/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.internal;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.javamodularity.moduleplugin.extensions.PatchModuleContainer;
import org.javamodularity.moduleplugin.internal.TaskOption;

public class PatchModuleMutator {
    private static final Logger LOGGER = Logging.getLogger(PatchModuleMutator.class);
    private final PatchModuleContainer patchModuleContainer;
    private final UnaryOperator<String> jarNameResolver;

    public PatchModuleMutator(PatchModuleContainer patchModuleContainer, FileCollection classpath) {
        this(patchModuleContainer, (UnaryOperator & Serializable)jarName -> classpath.filter((Spec & Serializable)jar -> jar.getName().endsWith((String)jarName)).getAsPath());
    }

    public PatchModuleMutator(PatchModuleContainer patchModuleContainer, UnaryOperator<String> jarNameResolver) {
        this.patchModuleContainer = patchModuleContainer;
        this.jarNameResolver = jarNameResolver;
    }

    public void mutateArgs(List<String> args) {
        this.taskOptionStream().forEach((Consumer<TaskOption> & Serializable)option -> option.mutateArgs(args));
    }

    public Stream<TaskOption> taskOptionStream() {
        return this.getPatchMap().entrySet().stream().map((Function<Map.Entry, TaskOption> & Serializable)entry -> this.buildTaskOption((String)entry.getKey(), (List)entry.getValue())).filter(Objects::nonNull);
    }

    private Map<String, List<String>> getPatchMap() {
        Map<String, List<String>> patchMap = this.patchModuleContainer.jarPatchedModulesStream().collect(Collectors.toMap((Function<Map.Entry, String> & Serializable)entry -> (String)entry.getKey(), (Function<Map.Entry, List> & Serializable)entry -> this.resolveJars((String)entry.getKey(), (List)entry.getValue())));
        this.patchModuleContainer.dirPatchedModulesStream().forEach((Consumer<Map.Entry<String, List<String>>>)(Consumer<Map.Entry> & Serializable)entry -> {
            List paths = (List)patchMap.computeIfAbsent((String)entry.getKey(), (Function<String, List> & Serializable)key -> new ArrayList());
            paths.addAll((Collection)entry.getValue());
        });
        return patchMap;
    }

    private TaskOption buildTaskOption(String moduleName, List<String> paths) {
        if (paths.isEmpty()) {
            return null;
        }
        return new TaskOption("--patch-module", moduleName + "=" + paths.stream().collect(Collectors.joining(File.pathSeparator)));
    }

    private List<String> resolveJars(String moduleName, List<String> jarNames) {
        return jarNames.stream().map((Function<String, String> & Serializable)jarName -> this.getJarPath(moduleName, (String)jarName)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private String getJarPath(String moduleName, String jarName) {
        String jarPath = (String)this.jarNameResolver.apply(jarName);
        if (jarPath.isEmpty()) {
            LOGGER.warn("Skipped patching {} into {}", (Object)jarName, (Object)moduleName);
            return null;
        }
        return jarPath;
    }
}

