// resource.cc for bbacpi - an tool to display the battery level in X11.
//
//  Copyright (c) 2004 by Max Lekeux, m_lekeux@hotmail.com
//
//  This program is heavily based on bbsload by John Kennis, jkennis@chello.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//


#include "resource.hh"
#include "blackboxstyle.hh"


Resource::Resource(ToolWindow *toolwindow):
                   BaseResource(toolwindow) {

  frame.font=0;
  label.font=0;
  menu.font=0;

  Load();
}


Resource::~Resource()
{
  Clean();
}


void Resource::Clean()
{
    if (label.font)
        XFreeFont(bbtool->getXDisplay(), label.font);
    if (frame.font)
        XFreeFont(bbtool->getXDisplay(), frame.font);
    if (menu.font)
      XFreeFont(bbtool->getXDisplay(), menu.font);

    frame.font = label.font = menu.font = 0;
}

void Resource::LoadBBToolResource(void)
{
    XrmValue value;
    char *value_type;

    if (XrmGetResource(resource_db, "bbacpi.autoConfig",
                           "Bbacpi.Autoconfig", &value_type, &value))
    {
        if (! strncasecmp("true", value.addr, value.size))
            style.auto_config = True;
        else
            style.auto_config = False;
    }
    else
        style.auto_config = False;

    SizeAndPosition();
    Frame();
    Menu();
    Show();

    if (show.label)
        Label();

    if (show.loadbar)
        LoadBar();

    CheckSettings();
    Reverse();
    Order();
}


void 	Resource::Frame() {
  XrmValue value;
  char *value_type;

  readTexture("bbacpi.frame","Bbacpi.Frame",BB_FRAME,"Toolbar",
              "slategrey","darkslategrey",
              "Raised Gradient Vertical Bevel1",&frame.texture);

  int default_bevel=4;
  if (bbtool->withdrawn) default_bevel=0;
  if (XrmGetResource(resource_db, "bbacpi.bevelWidth",
                     "bbacpi.BevelWidth", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &frame.bevelWidth) != 1)
      frame.bevelWidth = default_bevel;
    else if (frame.bevelWidth == 0)
      frame.bevelWidth = default_bevel;
  }
  else if (XrmGetResource(resource_db, BB_BEVELWIDTH,
                          "TitleFont", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &frame.bevelWidth) != 1)
      frame.bevelWidth = 4;
    else if (frame.bevelWidth == 0)
      frame.bevelWidth = 4;
  } 
  else
    frame.bevelWidth = 4;
}


void Resource::Menu()
{
  XrmValue value;
  char *value_type;
  
  
  readTexture("bbacpi.menu","Bbacpi.Menu",BB_MENU,"Menu.Frame",
	      "slategrey","darkslategrey",
	      "Raised Diagonal Gradient Bevel1",&menu.texture);
  
  readColor("bbacpi.menu.highlight.color",
	    "Bbacpi.Menu.Highlight.Color",
	    BB_MENU_HIGHLIGHT_COLOR,"Menu.highlightColor",
	    "rgb:c/9/6",&menu.highlightColor);
  
  readColor("bbacpi.menu.textColor","Bbacpi.Menu.TextColor",
	    BB_MENU_TEXTCOLOR,"Menu.Frame.TextColor",
	    "LightGrey",&menu.textColor);
  
  readColor("bbacpi.menu.highlight.textColor",
	    "Bbacpi.Menu.Highlight.TextColor",
	    BB_MENU_HITEXTCOLOR,"Menu.Frame.HiTextColor",
	    "white",&menu.hitextColor);
  
  if (XrmGetResource(resource_db,"bbacpi.menu.justify","Bbacpi.Menu.Justify",
		     &value_type, &value)) {
    if (! strncasecmp("leftjustify", value.addr, value.size))
      menu.justify = LeftJustify;
    else if (! strncasecmp("rightjustify", value.addr, value.size))
      menu.justify = RightJustify;
    else if (! strncasecmp("centerjustify", value.addr, value.size))
      menu.justify = CenterJustify;
    else
      menu.justify = LeftJustify;
  } else if (XrmGetResource(resource_db,BB_MENU_JUSTIFY,"Bbacpi.Menu.Justify",
			    &value_type, &value)) {
    if (! strncasecmp("leftjustify", value.addr, value.size))
      menu.justify = LeftJustify;
    else if (! strncasecmp("rightjustify", value.addr, value.size))
      menu.justify = RightJustify;
    else if (! strncasecmp("centerjustify", value.addr, value.size))
      menu.justify = CenterJustify;
    else
      menu.justify = LeftJustify;
  } else
    menu.justify = LeftJustify;
  
  if (XrmGetResource(resource_db, "bbacpi.menu.bulletStyle",
		     "Bbacpi.Menu.BulletStyle", &value_type, &value)) {
    if (! strncasecmp(value.addr, "empty", value.size))
      menu.bullet_style = Empty;
    else if (! strncasecmp(value.addr, "square", value.size))
      menu.bullet_style = Square;
    else if (! strncasecmp(value.addr, "triangle", value.size))
      menu.bullet_style = Triangle;
    else if (! strncasecmp(value.addr, "diamond", value.size))
      menu.bullet_style = Diamond;
    else
      menu.bullet_style = Round;
  } else {
    if (XrmGetResource(resource_db, BB_MENU_BULLETSTYLE,
		       "Menu.BulletStyle", &value_type, &value)) {
      if (! strncasecmp(value.addr, "empty", value.size))
	menu.bullet_style = Empty;
      else if (! strncasecmp(value.addr, "square", value.size))
	menu.bullet_style = Square;
      else if (! strncasecmp(value.addr, "triangle", value.size))
	menu.bullet_style = Triangle;
      else if (! strncasecmp(value.addr, "diamond", value.size))
	menu.bullet_style = Diamond;
      else
	menu.bullet_style = Round;
    } else
      menu.bullet_style = Round;
  }
  
  if (XrmGetResource(resource_db, "bbacpi.menu.bulletPosition",
		     "Bbacpi.Menu.BulletPosition", &value_type, &value)) {
    if (! strncasecmp(value.addr, "right", value.size))
      menu.bullet_pos = Right;
    else
      menu.bullet_pos = Left;
  } else {
    if (XrmGetResource(resource_db, BB_MENU_BULLETPOSITION,
		       "Menu.BulletPosition", &value_type, &value)) {
      if (! strncasecmp(value.addr, "right", value.size))
	menu.bullet_pos = Right;
      else
	menu.bullet_pos = Left;
    } else
      menu.bullet_pos = Left;
  }
  
  const char *defaultFont = "-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*";
  
  if (menu.font) {
    XFreeFont(bbtool->getXDisplay(), menu.font);
    menu.font = 0;
  }
  
  if (XrmGetResource(resource_db, "bbacpi.menu.font", "Bbacpi.Menu.Font",
		     &value_type, &value)) {
    if ((menu.font = XLoadQueryFont(bbtool->getXDisplay(), value.addr)) == NULL) {
      fprintf(stderr, " blackbox: couldn't load font '%s'\n"
	      " ...  reverting to default font.", value.addr);
      if ((menu.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) == NULL) {
	fprintf(stderr,
		"blackbox: couldn't load default font.  please check to\n"
		"make sure the necessary font is installed '%s'\n",
		defaultFont);
	exit(2);
      }
    }
  } else if  (XrmGetResource(resource_db, BB_MENU_FONT, "MenuFont", &value_type, &value)) {
    if ((menu.font = XLoadQueryFont(bbtool->getXDisplay(), value.addr)) == NULL) {
      fprintf(stderr, " blackbox: couldn't load font '%s'\n"
	      " ...  reverting to default font.", value.addr);
      if ((menu.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) == NULL) {
	fprintf(stderr,
		"blackbox: couldn't load default font.  please check to\n"
		"make sure the necessary font is installed '%s'\n",
		defaultFont);
	exit(2);
      }
    }
  } else {
    if ((menu.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) == NULL) {
      fprintf(stderr,"blackbox: couldn't load default font.  please check to\n"
	      "make sure the necessary font is installed '%s'\n", defaultFont);
      exit(2);
    }
  }
}


void	Resource::SizeAndPosition() {
  XrmValue value;
  char *value_type;
  unsigned int w,h;
  char positionstring[11];

  if (!(bbtool->withdrawn)) {
    if (XrmGetResource(resource_db, "bbacpi.withdrawn",
      		     "Bbacpi.Withdrawn", &value_type, &value)) {
      if (! strncasecmp("true", value.addr, value.size))
	  	  bbtool->withdrawn = True;
	    else
		  	bbtool->withdrawn = False;
    }	
	  else
		  bbtool->withdrawn = False;
  }

  if (!(bbtool->shape)) {
    if (XrmGetResource(resource_db, "bbacpi.shape",
    		       "Bbacpi.Shape", &value_type, &value)) {
  	  if (! strncasecmp("true", value.addr, value.size))
	  	  bbtool->shape = True;
	    else
		  	bbtool->shape = False;
  	}	
	  else
		  bbtool->shape = bbtool->withdrawn;
  }
    
  if (!(bbtool->position)) {
    if (!(XrmGetResource(resource_db, "bbacpi.position",
                                 "Bbacpi.Position", &value_type, &value)))
      strncpy(positionstring, "-0-0", 5);
    else
      strncpy(positionstring, value.addr, strlen(value.addr)+1);
  }
  else
    strncpy(positionstring, bbtool->position, strlen(bbtool->position)+1);

  position.mask=XParseGeometry(positionstring, &position.x, &position.y,
                                 &w, &h);

  if (!(position.mask & XValue))
    position.x=0;
  if (!(position.mask & YValue))
    position.y=0;

  /* need this to compute the height */
  const char *defaultFont = "-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*";

  if (frame.font) {
    XFreeFont(bbtool->getXDisplay(), frame.font);
    frame.font = 0;
  }

  if (XrmGetResource(resource_db, "bbacpi.heightBy.font",
                        "bbacpi.heightBy.Font", &value_type, &value)) {
    if ((frame.font = XLoadQueryFont(bbtool->getXDisplay(), value.addr)) == NULL) {
      fprintf(stderr, " blackbox: couldn't load font '%s'\n"
                      " ...  reverting to default font.", value.addr);
      if ((frame.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) == NULL) {
        fprintf(stderr,
                "blackbox: couldn't load default font.  please check to\n"
                "make sure the necessary font is installed '%s'\n",
                defaultFont);
         exit(2);
      }
    }
  }
  else if (XrmGetResource(resource_db, BB_FONT,"TitleFont",
                          &value_type,&value)) {
    if ((frame.font = XLoadQueryFont(bbtool->getXDisplay(), value.addr)) == NULL) {
      fprintf(stderr, " blackbox: couldn't load font '%s'\n"
                      " ...  reverting to default font.", value.addr);
      if ((frame.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) == NULL) {
        fprintf(stderr,
                "blackbox: couldn't load default font.  please check to\n"
                "make sure the necessary font is installed '%s'\n",
                 defaultFont);
         exit(2);
      }
    }
  }else {
    if ((frame.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) == NULL) {
      fprintf(stderr,
              "blackbox: couldn't load default font.  please check to\n"
              "make sure the necessary font is installed '%s'\n", defaultFont);
       exit(2);
    }
  }
}

void	Resource::CheckSettings() {
  XrmValue value;
  char *value_type;

  if (XrmGetResource(resource_db, "bbacpi.checkDelay",
                     "Bbacpi.CheckDelay", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &report.check_delay) != 1)
      report.check_delay = 10;
    else
      if (report.check_delay == 0)
        report.check_delay = 10;
  }
  else 
    report.check_delay = 10;

  if (XrmGetResource(resource_db, "bbacpi.xmessageDelay",
                     "Bbacpi.XmessageDelay", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &report.xmessage_delay) != 1)
      report.xmessage_delay = 60;
    else
      if (report.xmessage_delay == 0)
        report.xmessage_delay = 60;
  }
  else
    report.xmessage_delay = 60;

  if (XrmGetResource(resource_db, "bbacpi.minutesLimite",
                     "Bbacpi.minutesLimite", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &report.minlim) != 1)
      report.minlim = 15;
    else
      if (report.minlim == 0)
        report.minlim = 15;
  }
  else
    report.minlim = 15;

  if (XrmGetResource(resource_db, "bbacpi.raised",
                     "Bbacpi.Raised", &value_type, &value)) {
    if (! strncasecmp("true", value.addr, value.size))
      bbtool->raised = True;
    else
      bbtool->raised = False;
  }
  else
    bbtool->raised = True;

  if (XrmGetResource(resource_db,"bbacpi.label.temperature.degree",
                     "bbacpi.Label.Temperature.Degree",&value_type,&value)) {
    if (strncasecmp("Celcius", value.addr, value.size))
      show.label_temperature_celcius = False;
    else 
      show.label_temperature_celcius = True;
  }
  else
    show.label_temperature_celcius = True;  

  if (XrmGetResource(resource_db,"bbacpi.gauge.battery.special_charging",
                     "Bbacpi.Gauge.Battery.Special_charging",&value_type,&value)) {
    if (! strncasecmp("true", value.addr, value.size))
      show.gauge_battery_special_charging = True;
    else 
      show.gauge_battery_special_charging = False;
  }
  else
    show.gauge_battery_special_charging = False; 

  if (XrmGetResource(resource_db,"bbacpi.show.graphics.adapter",
                     "Bbacpi.Show.Graphics.Adapter",&value_type,&value)) {
    if (! strncasecmp("true", value.addr, value.size))
      show.gfx_adapter = True;
    else 
      show.gfx_adapter = False;
  }
  else
    show.gfx_adapter = False;
}


void 	Resource::Reverse() {
  XrmValue value;
  char *value_type; 

  
  if (XrmGetResource(resource_db, "bbacpi.gauge.battery.reverse",
                     "Bbacpi.Gauge.Battery.Reverse", &value_type, &value)) {
    if (! strncasecmp("true", value.addr, value.size))
      reverse.gauge_battery = True;
    else
      reverse.gauge_battery = False;
  }
  else 
    reverse.gauge_battery = True;
  

  if (XrmGetResource(resource_db, "bbacpi.gauge.temperature.reverse",
                     "Bbacpi.Gauge.Temperature.Reverse", &value_type, &value)) {
    if (! strncasecmp("true", value.addr, value.size))
      reverse.gauge_temperature = True;
    else
      reverse.gauge_temperature = False;
  }
  else
    reverse.gauge_temperature = False;
}

void 	Resource::Order() {
  XrmValue value;
  char *value_type;

  /* Battery gauge */
  if (XrmGetResource(resource_db, "bbacpi.gauge.order.battery",
                     "Bbacpi.Gauge.Order.Battery", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &order.gauge_battery) != 1)
      order.gauge_battery = 1;
    else
      if (order.gauge_battery == 0)
        order.gauge_battery = 1;
  }
  else 
    order.gauge_battery = 1;

  /* Temperature Gauge */
  if (XrmGetResource(resource_db, "bbacpi.gauge.order.temperature",
                     "Bbacpi.Gauge.Order.Temperature", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &order.gauge_temperature) != 1)
      order.gauge_temperature = 2;
    else
      if (order.gauge_temperature == 0)
        order.gauge_temperature = 2;
  }
  else
    order.gauge_temperature = 2;

  /* Battery label */
  if (XrmGetResource(resource_db, "bbacpi.label.order.battery",
                     "Bbacpi.Label.Order.Battery", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &order.label_battery) != 1)
      order.label_battery = 1;
    else
      if (order.label_battery == 0)
        order.label_battery = 1;
  }
  else
    order.label_battery = 1;

  /* Temperature label */
  if (XrmGetResource(resource_db, "bbacpi.label.order.temperature",
                     "Bbacpi.Label.Order.Temperature", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &order.label_temperature) != 1)
      order.label_temperature = 2;
    else
      if (order.label_temperature == 0)
        order.label_temperature = 2;
  }
  else
    order.label_temperature = 2;

  /* Time label */
  if (XrmGetResource(resource_db, "bbacpi.label.order.time",
                     "Bbacpi.Label.Order.Time", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &order.label_time) != 1)
      order.label_time = 3;
    else
      if (order.label_time == 0)
        order.label_time = 3;
  }
  else
    order.label_time = 3;

  /* Adapter label */
  if (XrmGetResource(resource_db, "bbacpi.label.order.adapter",
                     "Bbacpi.Label.Order.Adapter", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &order.label_adapter) != 1)
      order.label_adapter = 4;
    else
      if (order.label_adapter == 0)
        order.label_adapter = 4;
  }
  else
    order.label_adapter = 4;
}


void	Resource::Label(void) {
  XrmValue value;
  char *value_type;

  /* text-label resources */
  if (XrmGetResource(resource_db, "bbacpi.label.transparent",
                     "Bbacpi.label.Transparent", &value_type, &value)) {
    if (! strncasecmp("true", value.addr, value.size))
      label.transparent = True;
    else
      label.transparent = False;
  }
  else
    label.transparent = False;

  readTexture("bbacpi.label", "Bbacpi.Label",BB_LABEL,"Toolbar.Label",
              "slategrey","darkslategrey",
              "Sunken Gradient Vertical Bevel1",&label.texture);

  if (show.label_battery) {
    readColor("bbacpi.battery.label.textColor",
	      "Bbacpi.label_battery.Label.TextColor",
              BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
              "#cccccc",&label.battery_textColor);
  }
  if (show.label_time) {
    readColor("bbacpi.time.label.textColor",
	      "Bbacpi.label_time.Label.TextColor",
              BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
              "#cccccc",&label.time_textColor);
    readColor("bbacpi.time_short.label.textColor",
	      "Bbacpi.label_time_short.Label.TextColor",
              BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
              "#cccccc",&label.time_short_textColor);
  }
  if (show.label_temperature) {
    readColor("bbacpi.temperature.label.textColor",
	      "Bbacpi.label_temperature.Label.TextColor",
              BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
              "#cccccc",&label.temperature_textColor);
  }
  if (show.label_adapter) {
    readColor("bbacpi.adapter.label.textColor",
	      "Bbacpi.label_adapter.Label.TextColor",
              BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
              "#cccccc",&label.adapter_textColor);
  }


  readColor("bbacpi.separator.label.textColor",
	    "Bbacpi.Separator.Label.TextColor",
             BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
            "LightGrey",&label.separator_textColor);


  const char *defaultFont = "-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*";

  if (label.font) {
    XFreeFont(bbtool->getXDisplay(), label.font);
    label.font = 0;
  }

  if (XrmGetResource(resource_db, "bbacpi.label.font",
                     "Bbacpi.Label.Font", &value_type, &value)) {
    if ((label.font = XLoadQueryFont(bbtool->getXDisplay(), value.addr)) == NULL) {
      fprintf(stderr, " blackbox: couldn't load font '%s'\n"
                      " ...  reverting to default font.", value.addr);
      if ((label.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) == NULL) {
        fprintf(stderr,
                "blackbox: couldn't load default font.  please check to\n"
                "make sure the necessary font is installed '%s'\n",
                defaultFont);
        exit(2);
      }
    }
  }
  else if  (XrmGetResource(resource_db, BB_FONT,"TitleFont", 
                            &value_type, &value)) {
    if ((label.font = XLoadQueryFont(bbtool->getXDisplay(), value.addr)) == NULL) {
      fprintf(stderr, " blackbox: couldn't load font '%s'\n"
                      " ...  reverting to default font.", value.addr);
      if ((label.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) == NULL) {
        fprintf(stderr,
                "blackbox: couldn't load default font.  please check to\n"
                "make sure the necessary font is installed '%s'\n",
                 defaultFont);
         exit(2);
      }
    }
  } else {
    if ((label.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) == NULL) {
      fprintf(stderr,
              "blackbox: couldn't load default font.  please check to\n"
              "make sure the necessary font is installed '%s'\n", defaultFont);
      exit(2);
    }
  }
}


bool Resource::showLabel(char *dbname,char *dbclass,bool default_show)
{
  bool show_label;
  XrmValue value;
  char *value_type;

  
  if (XrmGetResource(resource_db,dbname,dbclass,&value_type, &value)) {
    if (! strncasecmp("true", value.addr, value.size))
      show_label = True;
    else
      show_label = False;
  }
  else 
    show_label = default_show;

  if (show_label)
    show.label = True;
  
  return show_label;
}

bool Resource::showGauge(char *dbname,char *dbclass, bool default_show)
{
  bool show_gauge;
  XrmValue value;
  char *value_type;

  
  if (XrmGetResource(resource_db,dbname,dbclass,&value_type, &value)) {
    if (! strncasecmp("true", value.addr, value.size))
      show_gauge = True;
    else
      show_gauge = False;
  }
  else 
    show_gauge = default_show;

  if (show_gauge) 
    show.loadbar=True;

  return show_gauge;
}

void	Resource::Show() {
  XrmValue value;
  char *value_type;
  show.label=False;
  show.loadbar=False;

  /* Show vertical */
  if (XrmGetResource(resource_db, "bbacpi.show.vertical",
                     "Bbacpi.Show.Show.Vertical", 
                      &value_type, &value)) {
    if (! strncasecmp("true", value.addr, value.size)) 
      show.vertical = True;
    else
      show.vertical = False;
  }
  else
    show.vertical = False;

  /* what to show.resources */
  show.gauge_battery = showGauge("bbacpi.show.battery.gauge",
				 "Bbacpi.Show.battery.Gauge",True);
  show.gauge_temperature = showGauge("bbacpi.show.temperature.gauge",
				     "Bbacpi.Show.temperature.Gauge",False);
  show.label_battery = showLabel("bbacpi.show.label_battery.label",
                                 "Bbacpi.Show.label_battery.Label",False);
  show.label_time = showLabel("bbacpi.show.label_time.label",
			      "Bbacpi.Show.label_time.Label",True);
  show.label_temperature = showLabel("bbacpi.show.label_temperature.label",
				     "Bbacpi.Show.label_temperature.Label",False);
  show.label_adapter = showLabel("bbacpi.show.label_adapter.label",
                                 "Bbacpi.Show.label_adapter.Label",False);
  show.xmessage = showLabel("bbacpi.show.xmessage.label",
			   "Bbacpi.Show.xmessage.Label",False);

  /* Number of batteries */
  if (XrmGetResource(resource_db, "bbacpi.battery_number",
                     "Bbacpi.Battery_number", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &show.battery_number) != 1)
      show.battery_number = 1;
    else
      if (show.battery_number == 0)
        show.battery_number = 1;
  }
  else
    show.battery_number = 1;
}


void	Resource::LoadBar() {
  XrmValue value;
  char *value_type;
  int i;

  readTexture("bbacpi.gauge.active","Bbacpi.Gauge.Active",
                      BB_BUTTON_PRESSED,"Toolbar.Button.Pressed",
                      "red1","green","Vertical Gradient Flat Bevel2",
                      &gauge.active_texture);

  readTexture("bbacpi.gauge.inactive","Bbacpi.Gauge.Inactive",
                          BB_BUTTON,"Toolbar.Button",
                          "black","black","Solid Flat Bevel2",
                          &gauge.inactive_texture);

  if (XrmGetResource(resource_db, "bbacpi.gauge.background",
		     "Bbacpi.Gauge.Background", &value_type, &value)) {
    readTexture("bbacpi.gauge.background",
                "Bbacpi.Gauge.Background","0","0","black","black",
                "Solid Flat Bevel2",&gauge.background_texture);
    gauge.background=True;
  }
  else
    gauge.background=False;
 
  if (XrmGetResource(resource_db, "bbacpi.gauge.width",
                     "Bbacpi.Gauge.Width", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &gauge.width) != 1)
      gauge.width = 20;
  }
  else
    gauge.width = 20;

  if (XrmGetResource(resource_db, "bbacpi.gauge.left.stepWidth",
                     "Bbacpi.Gauge.Left.StepWidth", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &gauge.left_step_width) != 1)
      gauge.left_step_width = 2;
  }
  else
    gauge.left_step_width = 2;

  if (XrmGetResource(resource_db, "bbacpi.gauge.right.stepWidth",
                     "Bbacpi.Gauge.Right.StepWidth", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &gauge.right_step_width) != 1)
      gauge.right_step_width = 0;
  }
  else
    gauge.right_step_width = 0;

  if (XrmGetResource(resource_db,"bbacpi.gauge.tickmarks",
                     "Bbacpi.Gauge.Tickmarks",&value_type,&value)) {
    if (! strncasecmp("false", value.addr, value.size)) {
      gauge.tickmarks = False;
      gauge.background = False;
    }
    else
      gauge.tickmarks = True;
  }
  else
    gauge.tickmarks=True;

  if (XrmGetResource(resource_db, "bbacpi.gauge.numberOf.bars",
                     "Bbacpi.Gauge.NumberOf.Bars", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &gauge.number_of_bars) != 1)
      gauge.number_of_bars = 6;
  }
  else
    gauge.number_of_bars = 6;

  if (XrmGetResource(resource_db, "bbacpi.gauge.maximum.load",
                     "Bbacpi.Gauge.Maximum.Load", &value_type, &value)) {
    if (sscanf(value.addr, "%f", &gauge.max_load) != 1)
      gauge.max_load = 1.0;
  }
  else
    gauge.max_load = 1.0;

  gauge.level = new float [gauge.number_of_bars];
  char *resource_name= new char [40];
  char *resource_class= new char [40];
  gauge.levels_defined=True;
   

  for (i=1;i<=gauge.number_of_bars;i++) {
    sprintf(resource_name,"bbacpi.gauge.segment.%d.scale",i);
    sprintf(resource_class,"Bbacpi.Gauge.Segment.%d.scale",i);
    if (XrmGetResource(resource_db, resource_name,resource_class
                       ,&value_type, &value)) {
      if (sscanf(value.addr, "%f", (float *) &gauge.level[i-1]) != 1) {
        gauge.levels_defined=False;
        break;
      }
    } else {
      gauge.levels_defined=False;
      break;
    }
  }
  
  if (XrmGetResource(resource_db,"bbacpi.gauge.multiColor",
                     "Bbacpi.Gauge.multiColor",&value_type,&value)) {
    if (! strncasecmp("true", value.addr, value.size)) 
      gauge.use_simple_color=True;
    else
      gauge.use_simple_color = False;
  }
  else
    gauge.use_simple_color= False;
    
  if (gauge.use_simple_color) {
    gauge.segment_texture = new BTexture [gauge.number_of_bars];
    for (i=1;i<=gauge.number_of_bars;i++) {
      sprintf(resource_name,"bbacpi.gauge.segment.%d",i);
      sprintf(resource_class,"Bbacpi.Gauge.Segment.%d",i);

      readTexture(resource_name,resource_class,
                  "0","0","green","green","Solid Flat Bevel1",
                   &gauge.segment_texture[i-1]);
    }
  }
  delete [] resource_class;
  delete [] resource_name;

}
