//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// Stand-in for the current user's ID; most often used in RecordZoneID->ownerName
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckcurrentuserdefaultname?language=objc)
    pub static CKCurrentUserDefaultName: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckownerdefaultname?language=objc)
    #[deprecated]
    pub static CKOwnerDefaultName: &'static NSString;
}

extern_class!(
    /// A CKContainer, and its CKDatabases, are the main entry points into the CloudKit framework.
    ///
    ///
    /// Several methods in CloudKit accept completion handlers to indicate when they're completed.
    /// All CKOperation subclasses include progress and completion blocks to report significant events in their lifecycles.
    /// Each of these handlers and blocks is invoked on a non-main serial queue.  The receiver is responsible for handling the message on a different queue or thread if it is required.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckcontainer?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKContainer;
);

unsafe impl Send for CKContainer {}

unsafe impl Sync for CKContainer {}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKContainer {}
);

impl CKContainer {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        /// Convenience method that uses the calling process' "iCloud.\(application-identifier)" as the container identifier
        ///
        ///
        /// application-identifier is the calling process'
        /// `application-identifier`entitlement on iOS / tvOS / watchOS.
        /// application-identifier is the calling process'
        /// `com.apple.application-identifier`entitlement on macOS.
        /// On all OSes, if an
        /// `com.apple.developer.associated-application-identifier`entitlement is present, its value will be preferred over the
        /// `application-identifier`variants.
        #[unsafe(method(defaultContainer))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultContainer() -> Retained<CKContainer>;

        /// Obtain a CKContainer for the given containerIdentifier
        ///
        ///
        /// If the application is in production mode (aka,
        /// `com.apple.developer.icloud-container-environment`is set to Production in your entitlements plist, and you have no override in
        /// `com.apple.developer.icloud-container-development-container-identifiers),`then the production environment is used.
        #[unsafe(method(containerWithIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn containerWithIdentifier(
            container_identifier: &NSString,
        ) -> Retained<CKContainer>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(containerIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn containerIdentifier(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "CKOperation")]
        #[unsafe(method(addOperation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addOperation(&self, operation: &CKOperation);
    );
}

/// Database.
///
/// Database properties:
/// Records in a public database
/// - By default are world readable, owner writable.
/// - Can be locked down by Roles, a process done in the Developer Portal, a web interface.  Roles are not present in the client API.
/// - Are visible to the application developer via the Developer Portal.
/// - Do not contribute to the owner's iCloud account storage quota.
/// Records in a private database
/// - By default are only owner readable and owner writable.
/// - Are not visible to the application developer via the Developer Portal.
/// - Are counted towards the owner's iCloud account storage quota.
/// Records in a shared database
/// - Are available to share participants based on the permissions of the enclosing CKShare
/// - Are not visible to the application developer via the Developer Portal.
/// - Are counted towards the originating owner's iCloud account storage quota.
impl CKContainer {
    extern_methods!(
        #[cfg(feature = "CKDatabase")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(privateCloudDatabase))]
        #[unsafe(method_family = none)]
        pub unsafe fn privateCloudDatabase(&self) -> Retained<CKDatabase>;

        #[cfg(feature = "CKDatabase")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(publicCloudDatabase))]
        #[unsafe(method_family = none)]
        pub unsafe fn publicCloudDatabase(&self) -> Retained<CKDatabase>;

        #[cfg(feature = "CKDatabase")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(sharedCloudDatabase))]
        #[unsafe(method_family = none)]
        pub unsafe fn sharedCloudDatabase(&self) -> Retained<CKDatabase>;

        #[cfg(feature = "CKDatabase")]
        /// Convenience methods
        ///
        ///
        /// Returns: a database that's pointer-equal to one of the above properties
        #[unsafe(method(databaseWithDatabaseScope:))]
        #[unsafe(method_family = none)]
        pub unsafe fn databaseWithDatabaseScope(
            &self,
            database_scope: CKDatabaseScope,
        ) -> Retained<CKDatabase>;
    );
}

/// credentials in Settings app.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckaccountstatus?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CKAccountStatus(pub NSInteger);
impl CKAccountStatus {
    #[doc(alias = "CKAccountStatusCouldNotDetermine")]
    pub const CouldNotDetermine: Self = Self(0);
    #[doc(alias = "CKAccountStatusAvailable")]
    pub const Available: Self = Self(1);
    #[doc(alias = "CKAccountStatusRestricted")]
    pub const Restricted: Self = Self(2);
    #[doc(alias = "CKAccountStatusNoAccount")]
    pub const NoAccount: Self = Self(3);
    #[doc(alias = "CKAccountStatusTemporarilyUnavailable")]
    pub const TemporarilyUnavailable: Self = Self(4);
}

unsafe impl Encode for CKAccountStatus {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for CKAccountStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// This local notification is posted when there has been any change to the logged in iCloud account.
    ///
    ///
    /// On receipt, an updated account status should be obtained by calling
    /// `accountStatusWithCompletionHandler:`
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckaccountchangednotification?language=objc)
    pub static CKAccountChangedNotification: &'static NSString;
}

/// AccountStatus.
impl CKContainer {
    extern_methods!(
        #[cfg(feature = "block2")]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(accountStatusWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn accountStatusWithCompletionHandler(
            &self,
            completion_handler: &block2::DynBlock<dyn Fn(CKAccountStatus, *mut NSError)>,
        );
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckapplicationpermissions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CKApplicationPermissions(pub NSUInteger);
bitflags::bitflags! {
    impl CKApplicationPermissions: NSUInteger {
/// Allows the user's record in CloudKit to be discoverable via the user's email address
        #[doc(alias = "CKApplicationPermissionUserDiscoverability")]
#[deprecated = "No longer supported. Please see Sharing CloudKit Data with Other iCloud Users."]
        const UserDiscoverability = 1<<0;
    }
}

unsafe impl Encode for CKApplicationPermissions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for CKApplicationPermissions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckapplicationpermissionstatus?language=objc)
// NS_ENUM
#[deprecated = "No longer supported. Please see Sharing CloudKit Data with Other iCloud Users."]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CKApplicationPermissionStatus(pub NSInteger);
impl CKApplicationPermissionStatus {
    #[doc(alias = "CKApplicationPermissionStatusInitialState")]
    #[deprecated = "No longer supported. Please see Sharing CloudKit Data with Other iCloud Users."]
    pub const InitialState: Self = Self(0);
    #[doc(alias = "CKApplicationPermissionStatusCouldNotComplete")]
    #[deprecated = "No longer supported. Please see Sharing CloudKit Data with Other iCloud Users."]
    pub const CouldNotComplete: Self = Self(1);
    #[doc(alias = "CKApplicationPermissionStatusDenied")]
    #[deprecated = "No longer supported. Please see Sharing CloudKit Data with Other iCloud Users."]
    pub const Denied: Self = Self(2);
    #[doc(alias = "CKApplicationPermissionStatusGranted")]
    #[deprecated = "No longer supported. Please see Sharing CloudKit Data with Other iCloud Users."]
    pub const Granted: Self = Self(3);
}

unsafe impl Encode for CKApplicationPermissionStatus {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for CKApplicationPermissionStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckapplicationpermissionblock?language=objc)
#[deprecated = "No longer supported. Please see Sharing CloudKit Data with Other iCloud Users."]
#[cfg(feature = "block2")]
pub type CKApplicationPermissionBlock =
    *mut block2::DynBlock<dyn Fn(CKApplicationPermissionStatus, *mut NSError)>;

/// ApplicationPermission.
impl CKContainer {
    extern_methods!(
        #[cfg(feature = "block2")]
        /// # Safety
        ///
        /// `completion_handler` must be a valid pointer.
        #[deprecated = "No longer supported. Please see Sharing CloudKit Data with Other iCloud Users."]
        #[unsafe(method(statusForApplicationPermission:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn statusForApplicationPermission_completionHandler(
            &self,
            application_permission: CKApplicationPermissions,
            completion_handler: CKApplicationPermissionBlock,
        );

        #[cfg(feature = "block2")]
        /// # Safety
        ///
        /// `completion_handler` must be a valid pointer.
        #[deprecated = "No longer supported. Please see Sharing CloudKit Data with Other iCloud Users."]
        #[unsafe(method(requestApplicationPermission:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn requestApplicationPermission_completionHandler(
            &self,
            application_permission: CKApplicationPermissions,
            completion_handler: CKApplicationPermissionBlock,
        );
    );
}

/// UserRecords.
impl CKContainer {
    extern_methods!(
        #[cfg(all(feature = "CKRecordID", feature = "block2"))]
        /// If there is no iCloud account configured, or if access is restricted, a
        /// `CKErrorNotAuthenticated`error will be returned.
        ///
        /// This work is treated as having
        /// `NSQualityOfServiceUserInitiated`quality of service.
        ///
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(fetchUserRecordIDWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchUserRecordIDWithCompletionHandler(
            &self,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKRecordID, *mut NSError)>,
        );

        #[cfg(all(feature = "CKUserIdentity", feature = "block2"))]
        /// Fetches all user identities that match an entry in the user's contacts database.
        ///
        ///
        /// `CKDiscoverAllUserIdentitiesOperation`is the more configurable,
        /// `CKOperation`-based alternative to this methods
        ///
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[deprecated = "No longer supported. Please see Sharing CloudKit Data with Other iCloud Users."]
        #[unsafe(method(discoverAllIdentitiesWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn discoverAllIdentitiesWithCompletionHandler(
            &self,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut NSArray<CKUserIdentity>, *mut NSError),
            >,
        );

        #[cfg(all(feature = "CKUserIdentity", feature = "block2"))]
        /// Fetches the user identity that corresponds to the given email address.
        ///
        ///
        /// Only users who have opted-in to user discoverability will have their identities returned by this method.  If a user with the inputted email exists in iCloud, but has not opted-in to user discoverability, this method completes with a nil
        /// `userInfo.``CKDiscoverUserIdentitiesOperation`is the more configurable,
        /// `CKOperation`-based alternative to this method
        ///
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[deprecated = "No longer supported. Please see Sharing CloudKit Data with Other iCloud Users."]
        #[unsafe(method(discoverUserIdentityWithEmailAddress:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn discoverUserIdentityWithEmailAddress_completionHandler(
            &self,
            email: &NSString,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKUserIdentity, *mut NSError)>,
        );

        #[cfg(all(feature = "CKUserIdentity", feature = "block2"))]
        /// Fetches the user identity that corresponds to the given phone number.
        ///
        ///
        /// Only users who have opted-in to user discoverability will have their identities returned by this method.  If a user with the inputted phone number exists in iCloud, but has not opted-in to user discoverability, this method completes with a nil
        /// `userInfo.``CKDiscoverUserIdentitiesOperation`is the more configurable,
        /// `CKOperation`-based alternative to this method
        ///
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[deprecated = "No longer supported. Please see Sharing CloudKit Data with Other iCloud Users."]
        #[unsafe(method(discoverUserIdentityWithPhoneNumber:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn discoverUserIdentityWithPhoneNumber_completionHandler(
            &self,
            phone_number: &NSString,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKUserIdentity, *mut NSError)>,
        );

        #[cfg(all(feature = "CKRecordID", feature = "CKUserIdentity", feature = "block2"))]
        /// Fetches the user identity that corresponds to the given user record id.
        ///
        ///
        /// Only users who have opted-in to user discoverability will have their identities returned by this method.  If a user has not opted-in to user discoverability, this method completes with a nil
        /// `userInfo.``CKDiscoverUserIdentitiesOperation`is the more configurable,
        /// `CKOperation`-based alternative to this method
        ///
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[deprecated = "No longer supported. Please see Sharing CloudKit Data with Other iCloud Users."]
        #[unsafe(method(discoverUserIdentityWithUserRecordID:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn discoverUserIdentityWithUserRecordID_completionHandler(
            &self,
            user_record_id: &CKRecordID,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKUserIdentity, *mut NSError)>,
        );
    );
}

/// Sharing.
impl CKContainer {
    extern_methods!(
        #[cfg(all(feature = "CKShareParticipant", feature = "block2"))]
        /// Fetches share participants matching the provided info.
        ///
        ///
        /// `CKFetchShareParticipantsOperation`is the more configurable,
        /// `CKOperation`-based alternative to these methods.
        ///
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(fetchShareParticipantWithEmailAddress:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchShareParticipantWithEmailAddress_completionHandler(
            &self,
            email_address: &NSString,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKShareParticipant, *mut NSError)>,
        );

        #[cfg(all(feature = "CKShareParticipant", feature = "block2"))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(fetchShareParticipantWithPhoneNumber:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchShareParticipantWithPhoneNumber_completionHandler(
            &self,
            phone_number: &NSString,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKShareParticipant, *mut NSError)>,
        );

        #[cfg(all(
            feature = "CKRecordID",
            feature = "CKShareParticipant",
            feature = "block2"
        ))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(fetchShareParticipantWithUserRecordID:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchShareParticipantWithUserRecordID_completionHandler(
            &self,
            user_record_id: &CKRecordID,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKShareParticipant, *mut NSError)>,
        );

        #[cfg(all(feature = "CKShareMetadata", feature = "block2"))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(fetchShareMetadataWithURL:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchShareMetadataWithURL_completionHandler(
            &self,
            url: &NSURL,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKShareMetadata, *mut NSError)>,
        );

        #[cfg(all(
            feature = "CKRecord",
            feature = "CKShare",
            feature = "CKShareMetadata",
            feature = "block2"
        ))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(acceptShareMetadata:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn acceptShareMetadata_completionHandler(
            &self,
            metadata: &CKShareMetadata,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKShare, *mut NSError)>,
        );
    );
}

/// CKLongLivedOperations.
impl CKContainer {
    extern_methods!(
        #[cfg(all(feature = "CKOperation", feature = "block2"))]
        /// Long lived CKOperations returned by this call must be started on an operation queue.
        /// Remember to set the callback blocks before starting the operation.
        /// If an operation has already completed against the server, and is subsequently resumed, that operation will replay all of its callbacks from the start of the operation, but the request will not be re-sent to the server.
        /// If a long lived operation is cancelled or finishes completely it is no longer returned by these calls.
        ///
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(fetchAllLongLivedOperationIDsWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchAllLongLivedOperationIDsWithCompletionHandler(
            &self,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut NSArray<CKOperationID>, *mut NSError),
            >,
        );

        #[cfg(all(feature = "CKOperation", feature = "block2"))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(fetchLongLivedOperationWithID:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchLongLivedOperationWithID_completionHandler(
            &self,
            operation_id: &CKOperationID,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKOperation, *mut NSError)>,
        );
    );
}
