// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HTTPClientOptions http client options
//
// swagger:model http_client_options
type HTTPClientOptions struct {
	// resolvers disabled
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	ResolversDisabled string `json:"resolvers_disabled,omitempty"`

	// resolvers id
	ResolversID string `json:"resolvers_id,omitempty"`

	// resolvers prefer
	// Enum: ["ipv4","ipv6"]
	// +kubebuilder:validation:Enum="ipv4","ipv6";
	ResolversPrefer string `json:"resolvers_prefer,omitempty"`

	// retries
	Retries int64 `json:"retries,omitempty"`

	// ssl ca file
	SslCaFile string `json:"ssl_ca_file,omitempty"`

	// ssl verify
	// Enum: ["","none","required"]
	// +kubebuilder:validation:Enum="","none","required";
	SslVerify *string `json:"ssl_verify,omitempty"`

	// timeout connect
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	TimeoutConnect *int64 `json:"timeout_connect,omitempty"`
}

// Validate validates this http client options
func (m *HTTPClientOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateResolversDisabled(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResolversPrefer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslVerify(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimeoutConnect(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var httpClientOptionsTypeResolversDisabledPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		httpClientOptionsTypeResolversDisabledPropEnum = append(httpClientOptionsTypeResolversDisabledPropEnum, v)
	}
}

const (

	// HTTPClientOptionsResolversDisabledEnabled captures enum value "enabled"
	HTTPClientOptionsResolversDisabledEnabled string = "enabled"

	// HTTPClientOptionsResolversDisabledDisabled captures enum value "disabled"
	HTTPClientOptionsResolversDisabledDisabled string = "disabled"
)

// prop value enum
func (m *HTTPClientOptions) validateResolversDisabledEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, httpClientOptionsTypeResolversDisabledPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HTTPClientOptions) validateResolversDisabled(formats strfmt.Registry) error {
	if swag.IsZero(m.ResolversDisabled) { // not required
		return nil
	}

	// value enum
	if err := m.validateResolversDisabledEnum("resolvers_disabled", "body", m.ResolversDisabled); err != nil {
		return err
	}

	return nil
}

var httpClientOptionsTypeResolversPreferPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ipv4","ipv6"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		httpClientOptionsTypeResolversPreferPropEnum = append(httpClientOptionsTypeResolversPreferPropEnum, v)
	}
}

const (

	// HTTPClientOptionsResolversPreferIPV4 captures enum value "ipv4"
	HTTPClientOptionsResolversPreferIPV4 string = "ipv4"

	// HTTPClientOptionsResolversPreferIPV6 captures enum value "ipv6"
	HTTPClientOptionsResolversPreferIPV6 string = "ipv6"
)

// prop value enum
func (m *HTTPClientOptions) validateResolversPreferEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, httpClientOptionsTypeResolversPreferPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HTTPClientOptions) validateResolversPrefer(formats strfmt.Registry) error {
	if swag.IsZero(m.ResolversPrefer) { // not required
		return nil
	}

	// value enum
	if err := m.validateResolversPreferEnum("resolvers_prefer", "body", m.ResolversPrefer); err != nil {
		return err
	}

	return nil
}

var httpClientOptionsTypeSslVerifyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["","none","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		httpClientOptionsTypeSslVerifyPropEnum = append(httpClientOptionsTypeSslVerifyPropEnum, v)
	}
}

const (

	// HTTPClientOptionsSslVerifyEmpty captures enum value ""
	HTTPClientOptionsSslVerifyEmpty string = ""

	// HTTPClientOptionsSslVerifyNone captures enum value "none"
	HTTPClientOptionsSslVerifyNone string = "none"

	// HTTPClientOptionsSslVerifyRequired captures enum value "required"
	HTTPClientOptionsSslVerifyRequired string = "required"
)

// prop value enum
func (m *HTTPClientOptions) validateSslVerifyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, httpClientOptionsTypeSslVerifyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HTTPClientOptions) validateSslVerify(formats strfmt.Registry) error {
	if swag.IsZero(m.SslVerify) { // not required
		return nil
	}

	// value enum
	if err := m.validateSslVerifyEnum("ssl_verify", "body", *m.SslVerify); err != nil {
		return err
	}

	return nil
}

func (m *HTTPClientOptions) validateTimeoutConnect(formats strfmt.Registry) error {
	if swag.IsZero(m.TimeoutConnect) { // not required
		return nil
	}

	if err := validate.MinimumInt("timeout_connect", "body", *m.TimeoutConnect, 0, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this http client options based on context it is used
func (m *HTTPClientOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HTTPClientOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HTTPClientOptions) UnmarshalBinary(b []byte) error {
	var res HTTPClientOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
