/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.compiler;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.CompilerDef;
import net.sf.antcontrib.cpptasks.OptimizationEnum;
import net.sf.antcontrib.cpptasks.ProcessorDef;
import net.sf.antcontrib.cpptasks.ProcessorParam;
import net.sf.antcontrib.cpptasks.TargetDef;
import net.sf.antcontrib.cpptasks.VersionInfo;
import net.sf.antcontrib.cpptasks.compiler.AbstractCompiler;
import net.sf.antcontrib.cpptasks.compiler.AbstractProcessor;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.CompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.ProgressMonitor;
import net.sf.antcontrib.cpptasks.types.CommandLineArgument;
import net.sf.antcontrib.cpptasks.types.UndefineArgument;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public abstract class CommandLineCompiler
extends AbstractCompiler {
    private String command;
    private final Environment env;
    private String identifier;
    private String identifierArg;
    private boolean libtool;
    private CommandLineCompiler libtoolCompiler;
    private final boolean newEnvironment;

    protected CommandLineCompiler(String command, String identifierArg, String[] sourceExtensions, String[] headerExtensions, String outputSuffix, boolean libtool, CommandLineCompiler libtoolCompiler, boolean newEnvironment, Environment env) {
        super(sourceExtensions, headerExtensions, outputSuffix);
        this.command = command;
        if (libtool && libtoolCompiler != null) {
            throw new IllegalArgumentException("libtoolCompiler should be null when libtool is true");
        }
        this.libtool = libtool;
        this.libtoolCompiler = libtoolCompiler;
        this.identifierArg = identifierArg;
        this.newEnvironment = newEnvironment;
        this.env = env;
    }

    protected abstract void addImpliedArgs(Vector var1, boolean var2, boolean var3, boolean var4, LinkType var5, Boolean var6, OptimizationEnum var7);

    protected void addIncludes(String baseDirPath, File[] includeDirs, Vector args, Vector relativeArgs, StringBuffer includePathId) {
        int i = 0;
        while (i < includeDirs.length) {
            args.addElement(this.getIncludeDirSwitch(includeDirs[i].getAbsolutePath()));
            if (relativeArgs != null) {
                String relative = CUtil.getRelativePath(baseDirPath, includeDirs[i]);
                relativeArgs.addElement(this.getIncludeDirSwitch(relative));
                if (includePathId != null) {
                    if (includePathId.length() == 0) {
                        includePathId.append("/I");
                    } else {
                        includePathId.append(" /I");
                    }
                    includePathId.append(relative);
                }
            }
            ++i;
        }
    }

    protected abstract void addWarningSwitch(Vector var1, int var2);

    protected void buildDefineArguments(CompilerDef[] defs, Vector args) {
        UndefineArgument[] merged = defs[0].getActiveDefines();
        int i = 1;
        while (i < defs.length) {
            merged = UndefineArgument.merge(defs[i].getActiveDefines(), merged);
            ++i;
        }
        StringBuffer buf = new StringBuffer(30);
        int i2 = 0;
        while (i2 < merged.length) {
            buf.setLength(0);
            UndefineArgument current = merged[i2];
            if (current.isDefine()) {
                this.getDefineSwitch(buf, current.getName(), current.getValue());
            } else {
                this.getUndefineSwitch(buf, current.getName());
            }
            args.addElement(buf.toString());
            ++i2;
        }
    }

    public void compile(CCTask task, File outputDir, String[] sourceFiles, String[] args, String[] endArgs, boolean relentless, CommandLineCompilerConfiguration config, ProgressMonitor monitor) throws BuildException {
        BuildException exc = null;
        String command = this.getCommand();
        int baseLength = command.length() + args.length + endArgs.length;
        if (this.libtool) {
            baseLength += 8;
        }
        int i = 0;
        while (i < args.length) {
            baseLength += args[i].length();
            ++i;
        }
        i = 0;
        while (i < endArgs.length) {
            baseLength += endArgs[i].length();
            ++i;
        }
        if (baseLength > this.getMaximumCommandLength()) {
            throw new BuildException("Command line is over maximum length without specifying source file");
        }
        int maxInputFilesPerCommand = this.getMaximumInputFilesPerCommand();
        int argumentCountPerInputFile = this.getArgumentCountPerInputFile();
        int sourceIndex = 0;
        while (sourceIndex < sourceFiles.length) {
            int cmdLength = baseLength;
            int firstFileNextExec = sourceIndex;
            while (firstFileNextExec < sourceFiles.length && firstFileNextExec - sourceIndex < maxInputFilesPerCommand) {
                if ((cmdLength += this.getTotalArgumentLengthForInputFile(outputDir, sourceFiles[firstFileNextExec])) >= this.getMaximumCommandLength()) break;
                ++firstFileNextExec;
            }
            if (firstFileNextExec == sourceIndex) {
                throw new BuildException("Extremely long file name, can't fit on command line");
            }
            int argCount = args.length + 1 + endArgs.length + (firstFileNextExec - sourceIndex) * argumentCountPerInputFile;
            if (this.libtool) {
                ++argCount;
            }
            String[] commandline = new String[argCount];
            int index = 0;
            if (this.libtool) {
                commandline[index++] = "libtool";
            }
            commandline[index++] = command;
            int j = 0;
            while (j < args.length) {
                commandline[index++] = args[j];
                ++j;
            }
            j = sourceIndex;
            while (j < firstFileNextExec) {
                int k = 0;
                while (k < argumentCountPerInputFile) {
                    commandline[index++] = this.getInputFileArgument(outputDir, sourceFiles[j], k);
                    ++k;
                }
                ++j;
            }
            j = 0;
            while (j < endArgs.length) {
                commandline[index++] = endArgs[j];
                ++j;
            }
            int retval = this.runCommand(task, outputDir, commandline);
            if (monitor != null) {
                String[] fileNames = new String[firstFileNextExec - sourceIndex];
                int j2 = 0;
                while (j2 < fileNames.length) {
                    fileNames[j2] = sourceFiles[sourceIndex + j2];
                    ++j2;
                }
                monitor.progress(fileNames);
            }
            if (retval != 0 && exc == null) {
                exc = new BuildException(String.valueOf(this.getCommand()) + " failed with return code " + retval, task.getLocation());
                if (!relentless) {
                    throw exc;
                }
            }
            sourceIndex = firstFileNextExec;
        }
        if (exc != null) {
            throw exc;
        }
    }

    protected CompilerConfiguration createConfiguration(CCTask task, LinkType linkType, ProcessorDef[] baseDefs, CompilerDef specificDef, TargetDef targetPlatform, VersionInfo versionInfo) {
        String baseDirPath;
        Vector<String> args = new Vector<String>();
        CompilerDef[] defaultProviders = new CompilerDef[baseDefs.length + 1];
        int i = 0;
        while (i < baseDefs.length) {
            defaultProviders[i + 1] = (CompilerDef)baseDefs[i];
            ++i;
        }
        defaultProviders[0] = specificDef;
        Vector<CommandLineArgument> cmdArgs = new Vector<CommandLineArgument>();
        int i2 = defaultProviders.length - 1;
        while (i2 >= 0) {
            CommandLineArgument[] commandArgs = defaultProviders[i2].getActiveProcessorArgs();
            int j = 0;
            while (j < commandArgs.length) {
                if (commandArgs[j].getLocation() == 0) {
                    args.addElement(commandArgs[j].getValue());
                } else {
                    cmdArgs.addElement(commandArgs[j]);
                }
                ++j;
            }
            --i2;
        }
        Vector<ProcessorParam> params = new Vector<ProcessorParam>();
        int i3 = defaultProviders.length - 1;
        while (i3 >= 0) {
            ProcessorParam[] paramArray = defaultProviders[i3].getActiveProcessorParams();
            int j = 0;
            while (j < paramArray.length) {
                params.add(paramArray[j]);
                ++j;
            }
            --i3;
        }
        ProcessorParam[] paramArray = params.toArray(new ProcessorParam[params.size()]);
        boolean multithreaded = specificDef.getMultithreaded(defaultProviders, 1);
        boolean debug = specificDef.getDebug(baseDefs, 0);
        boolean exceptions = specificDef.getExceptions(defaultProviders, 1);
        Boolean rtti = specificDef.getRtti(defaultProviders, 1);
        OptimizationEnum optimization = specificDef.getOptimization(defaultProviders, 1);
        this.addImpliedArgs(args, debug, multithreaded, exceptions, linkType, rtti, optimization);
        this.buildDefineArguments(defaultProviders, args);
        int warnings = specificDef.getWarnings(defaultProviders, 0);
        this.addWarningSwitch(args, warnings);
        Enumeration argEnum = cmdArgs.elements();
        int endCount = 0;
        while (argEnum.hasMoreElements()) {
            CommandLineArgument arg = (CommandLineArgument)argEnum.nextElement();
            switch (arg.getLocation()) {
                case 1: {
                    args.addElement(arg.getValue());
                    break;
                }
                case 2: {
                    ++endCount;
                }
            }
        }
        String[] endArgs = new String[endCount];
        argEnum = cmdArgs.elements();
        int index = 0;
        while (argEnum.hasMoreElements()) {
            CommandLineArgument arg = (CommandLineArgument)argEnum.nextElement();
            if (arg.getLocation() != 2) continue;
            endArgs[index++] = arg.getValue();
        }
        Vector relativeArgs = (Vector)args.clone();
        StringBuffer includePathIdentifier = new StringBuffer();
        File baseDir = specificDef.getProject().getBaseDir();
        try {
            baseDirPath = baseDir.getCanonicalPath();
        }
        catch (IOException ex) {
            baseDirPath = baseDir.toString();
        }
        Vector<String> includePath = new Vector<String>();
        Vector<String> sysIncludePath = new Vector<String>();
        int i4 = defaultProviders.length - 1;
        while (i4 >= 0) {
            String[] incPath = defaultProviders[i4].getActiveIncludePaths();
            int j = 0;
            while (j < incPath.length) {
                includePath.addElement(incPath[j]);
                ++j;
            }
            incPath = defaultProviders[i4].getActiveSysIncludePaths();
            j = 0;
            while (j < incPath.length) {
                sysIncludePath.addElement(incPath[j]);
                ++j;
            }
            --i4;
        }
        File[] incPath = new File[includePath.size()];
        int i5 = 0;
        while (i5 < includePath.size()) {
            incPath[i5] = new File((String)includePath.elementAt(i5));
            ++i5;
        }
        File[] sysIncPath = new File[sysIncludePath.size()];
        int i6 = 0;
        while (i6 < sysIncludePath.size()) {
            sysIncPath[i6] = new File((String)sysIncludePath.elementAt(i6));
            ++i6;
        }
        this.addIncludes(baseDirPath, incPath, args, relativeArgs, includePathIdentifier);
        this.addIncludes(baseDirPath, sysIncPath, args, null, null);
        StringBuffer buf = new StringBuffer(this.getIdentifier());
        int i7 = 0;
        while (i7 < relativeArgs.size()) {
            buf.append(' ');
            buf.append(relativeArgs.elementAt(i7));
            ++i7;
        }
        i7 = 0;
        while (i7 < endArgs.length) {
            buf.append(' ');
            buf.append(endArgs[i7]);
            ++i7;
        }
        String configId = buf.toString();
        Object[] argArray = new String[args.size()];
        args.copyInto(argArray);
        boolean rebuild = specificDef.getRebuild(baseDefs, 0);
        File[] envIncludePath = this.getEnvironmentIncludePath();
        return new CommandLineCompilerConfiguration(this, configId, incPath, sysIncPath, envIncludePath, includePathIdentifier.toString(), (String[])argArray, paramArray, rebuild, endArgs);
    }

    protected int getArgumentCountPerInputFile() {
        return 1;
    }

    protected final String getCommand() {
        return this.command;
    }

    protected abstract void getDefineSwitch(StringBuffer var1, String var2, String var3);

    protected abstract File[] getEnvironmentIncludePath();

    public String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.identifierArg == null ? AbstractProcessor.getIdentifier(new String[]{this.command}, this.command) : AbstractProcessor.getIdentifier(new String[]{this.command, this.identifierArg}, this.command);
        }
        return this.identifier;
    }

    protected abstract String getIncludeDirSwitch(String var1);

    protected String getInputFileArgument(File outputDir, String filename, int index) {
        if (filename.indexOf(32) >= 0) {
            StringBuffer buf = new StringBuffer("\"");
            buf.append(filename);
            buf.append("\"");
            return buf.toString();
        }
        return filename;
    }

    protected final boolean getLibtool() {
        return this.libtool;
    }

    public final CommandLineCompiler getLibtoolCompiler() {
        if (this.libtoolCompiler != null) {
            return this.libtoolCompiler;
        }
        return this;
    }

    public abstract int getMaximumCommandLength();

    protected int getMaximumInputFilesPerCommand() {
        return Integer.MAX_VALUE;
    }

    protected int getTotalArgumentLengthForInputFile(File outputDir, String inputFile) {
        return inputFile.length() + 1;
    }

    protected abstract void getUndefineSwitch(StringBuffer var1, String var2);

    protected int runCommand(CCTask task, File workingDir, String[] cmdline) throws BuildException {
        return CUtil.runCommand(task, workingDir, cmdline, this.newEnvironment, this.env);
    }

    protected final void setCommand(String command) {
        this.command = command;
    }
}

