/*
 *
 * Copyright 2019 gRPC authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package attributes_test

import (
	"fmt"
	"reflect"
	"testing"

	"google.golang.org/grpc/attributes"
)

func ExampleAttributes() {
	type keyOne struct{}
	type keyTwo struct{}
	a := attributes.New(keyOne{}, 1, keyTwo{}, "two")
	fmt.Println("Key one:", a.Value(keyOne{}))
	fmt.Println("Key two:", a.Value(keyTwo{}))
	// Output:
	// Key one: 1
	// Key two: two
}

func ExampleAttributes_WithValues() {
	type keyOne struct{}
	type keyTwo struct{}
	a := attributes.New(keyOne{}, 1)
	a = a.WithValues(keyTwo{}, "two")
	fmt.Println("Key one:", a.Value(keyOne{}))
	fmt.Println("Key two:", a.Value(keyTwo{}))
	// Output:
	// Key one: 1
	// Key two: two
}

// Test that two attributes with the same content are `reflect.DeepEqual`.
func TestDeepEqual(t *testing.T) {
	type keyOne struct{}
	a1 := attributes.New(keyOne{}, 1)
	a2 := attributes.New(keyOne{}, 1)
	if !reflect.DeepEqual(a1, a2) {
		t.Fatalf("reflect.DeepEqual(%+v, %+v), want true, got false", a1, a2)
	}
}
