"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Either_1 = require("./Either");
var eitherT = require("./EitherT");
var IO_1 = require("./IO");
var function_1 = require("./function");
exports.URI = 'IOEither';
var T = eitherT.getEitherT2v(IO_1.io);
var foldT = eitherT.fold(IO_1.io);
/**
 * @since 1.6.0
 */
var IOEither = /** @class */ (function () {
    function IOEither(value) {
        this.value = value;
    }
    /**
     * Runs the inner io
     */
    IOEither.prototype.run = function () {
        return this.value.run();
    };
    IOEither.prototype.map = function (f) {
        return new IOEither(T.map(this.value, f));
    };
    IOEither.prototype.ap = function (fab) {
        return new IOEither(T.ap(fab.value, this.value));
    };
    /**
     * Flipped version of `ap`
     */
    IOEither.prototype.ap_ = function (fb) {
        return fb.ap(this);
    };
    /**
     * Combine two effectful actions, keeping only the result of the first
     */
    IOEither.prototype.applyFirst = function (fb) {
        return fb.ap(this.map(function_1.constant));
    };
    /**
     * Combine two effectful actions, keeping only the result of the second
     */
    IOEither.prototype.applySecond = function (fb) {
        return fb.ap(this.map(function_1.constIdentity));
    };
    IOEither.prototype.chain = function (f) {
        return new IOEither(T.chain(this.value, function (a) { return f(a).value; }));
    };
    IOEither.prototype.fold = function (left, right) {
        return foldT(left, right, this.value);
    };
    IOEither.prototype.mapLeft = function (f) {
        return new IOEither(this.value.map(function (e) { return e.mapLeft(f); }));
    };
    IOEither.prototype.orElse = function (f) {
        return new IOEither(this.value.chain(function (e) { return e.fold(function (l) { return f(l).value; }, function (a) { return T.of(a); }); }));
    };
    IOEither.prototype.alt = function (fy) {
        return this.orElse(function () { return fy; });
    };
    IOEither.prototype.bimap = function (f, g) {
        return new IOEither(this.value.map(function (e) { return e.bimap(f, g); }));
    };
    return IOEither;
}());
exports.IOEither = IOEither;
var map = function (fa, f) {
    return fa.map(f);
};
var of = function (a) {
    return new IOEither(T.of(a));
};
var ap = function (fab, fa) {
    return fa.ap(fab);
};
var chain = function (fa, f) {
    return fa.chain(f);
};
var alt = function (fx, fy) {
    return fx.alt(fy);
};
var bimap = function (fa, f, g) {
    return fa.bimap(f, g);
};
/**
 * @since 1.6.0
 */
exports.right = function (fa) {
    return new IOEither(fa.map(function (a) { return Either_1.right(a); }));
};
/**
 * @since 1.6.0
 */
exports.left = function (fa) {
    return new IOEither(fa.map(function (a) { return Either_1.left(a); }));
};
/**
 * @since 1.6.0
 */
exports.fromEither = function (fa) {
    return new IOEither(IO_1.io.of(fa));
};
/**
 * @since 1.6.0
 */
exports.fromLeft = function (l) {
    return exports.fromEither(Either_1.left(l));
};
/**
 * Use `tryCatch2v` instead
 *
 * @since 1.6.0
 * @deprecated
 */
exports.tryCatch = function (f, onerror) {
    if (onerror === void 0) { onerror = Either_1.toError; }
    return exports.tryCatch2v(f, onerror);
};
/**
 * @since 1.11.0
 */
exports.tryCatch2v = function (f, onerror) {
    return new IOEither(new IO_1.IO(function () { return Either_1.tryCatch2v(f, onerror); }));
};
/**
 * @since 1.6.0
 */
exports.ioEither = {
    URI: exports.URI,
    bimap: bimap,
    map: map,
    of: of,
    ap: ap,
    chain: chain,
    alt: alt
};
