/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import java.util.ArrayList;
import java.util.List;

public abstract class NameAbbreviator {
    private static final NameAbbreviator DEFAULT = new NOPAbbreviator();

    public static NameAbbreviator getAbbreviator(String pattern) {
        if (pattern.length() > 0) {
            String trimmed = pattern.trim();
            if (trimmed.length() == 0) {
                return DEFAULT;
            }
            int i = 0;
            while (i < trimmed.length() && trimmed.charAt(i) >= '0' && trimmed.charAt(i) <= '9') {
                ++i;
            }
            if (i == trimmed.length()) {
                return new MaxElementAbbreviator(Integer.parseInt(trimmed));
            }
            ArrayList<PatternAbbreviatorFragment> fragments = new ArrayList<PatternAbbreviatorFragment>(5);
            int pos = 0;
            while (pos < trimmed.length() && pos >= 0) {
                int charCount;
                int ellipsisPos = pos;
                if (trimmed.charAt(pos) == '*') {
                    charCount = Integer.MAX_VALUE;
                    ++ellipsisPos;
                } else if (trimmed.charAt(pos) >= '0' && trimmed.charAt(pos) <= '9') {
                    charCount = trimmed.charAt(pos) - 48;
                    ++ellipsisPos;
                } else {
                    charCount = 0;
                }
                char ellipsis = '\u0000';
                if (ellipsisPos < trimmed.length() && (ellipsis = trimmed.charAt(ellipsisPos)) == '.') {
                    ellipsis = '\u0000';
                }
                fragments.add(new PatternAbbreviatorFragment(charCount, ellipsis));
                pos = trimmed.indexOf(".", pos);
                if (pos == -1) break;
                ++pos;
            }
            return new PatternAbbreviator(fragments);
        }
        return DEFAULT;
    }

    public static NameAbbreviator getDefaultAbbreviator() {
        return DEFAULT;
    }

    public abstract void abbreviate(int var1, StringBuffer var2);

    private static class PatternAbbreviator
    extends NameAbbreviator {
        private final PatternAbbreviatorFragment[] fragments;

        public PatternAbbreviator(List fragments) {
            if (fragments.size() == 0) {
                throw new IllegalArgumentException("fragments must have at least one element");
            }
            this.fragments = new PatternAbbreviatorFragment[fragments.size()];
            fragments.toArray(this.fragments);
        }

        public void abbreviate(int nameStart, StringBuffer buf) {
            int pos = nameStart;
            int i = 0;
            while (i < this.fragments.length - 1 && pos < buf.length()) {
                pos = this.fragments[i].abbreviate(buf, pos);
                ++i;
            }
            PatternAbbreviatorFragment terminalFragment = this.fragments[this.fragments.length - 1];
            while (pos < buf.length() && pos >= 0) {
                pos = terminalFragment.abbreviate(buf, pos);
            }
        }
    }

    private static class PatternAbbreviatorFragment {
        private final int charCount;
        private final char ellipsis;

        public PatternAbbreviatorFragment(int charCount, char ellipsis) {
            this.charCount = charCount;
            this.ellipsis = ellipsis;
        }

        public int abbreviate(StringBuffer buf, int startPos) {
            int nextDot = buf.toString().indexOf(".", startPos);
            if (nextDot != -1) {
                if (nextDot - startPos > this.charCount) {
                    buf.delete(startPos + this.charCount, nextDot);
                    nextDot = startPos + this.charCount;
                    if (this.ellipsis != '\u0000') {
                        buf.insert(nextDot, this.ellipsis);
                        ++nextDot;
                    }
                }
                ++nextDot;
            }
            return nextDot;
        }
    }

    private static class MaxElementAbbreviator
    extends NameAbbreviator {
        private final int count;

        public MaxElementAbbreviator(int count) {
            this.count = count;
        }

        public void abbreviate(int nameStart, StringBuffer buf) {
            int len = buf.length() - nameStart;
            int end = buf.length() - 1;
            String bufString = buf.toString();
            int i = this.count;
            while (i > 0) {
                if ((end = bufString.lastIndexOf(".", end - 1)) == -1 || end < nameStart) {
                    return;
                }
                --i;
            }
            buf.delete(nameStart, end + 1);
        }
    }

    private static class NOPAbbreviator
    extends NameAbbreviator {
        public void abbreviate(int nameStart, StringBuffer buf) {
        }
    }
}

