#ifndef MTALIB_H
#define MTALIB_H

typedef enum { MTA_SUCCESS, MTA_DEFER, MTA_FATAL } mta_ret_t;

typedef struct mta_t {
	/* priv */ mta_ret_t (*mta_open)P__((struct mta_t **, const char *path,const char *from, const char *to));
	/* pub  */ mta_ret_t (*mta_write)P__((struct mta_t *,const char *,size_t l));
	/* pub  */ mta_ret_t (*mta_abort)P__((struct mta_t *));
	/* pub  */ mta_ret_t (*mta_close)P__((struct mta_t *));
	/* priv */ void *priv;
} mta_t;

int mta_init P__((void));
mta_ret_t mta_get P__((mta_t **,const char *name,const char *path, const char *from, const char *to));
extern const char *mta_errtxt;
extern const char *mta_hcmssc;
void mta_set_err P__((const char *txt, const char *hcm, int err)); /* errno or 0 */

extern char *mta_hostname;
mta_ret_t mta_set_hostname P__((const char *)); /* NULL: use gethostname */


extern mta_t mta_qq;
extern mta_t mta_maildir;

#endif
