/*
    Copyright (C) 1995-1999 Uwe Ohse

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef FILELOCK_H
#define FILELOCK_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <sys/types.h>
#if defined(HAVE_FCNTL_H) || !defined(HAVE_SYS_FILE_H)
#include <fcntl.h>
#else
#include <sys/file.h>
#endif

#if defined(F_RDLCK) && defined(F_WRLCK) && defined(F_SETLK)
#define CAN_LOCK_FILES
/*
 * cmd: F_SETLK, F_GETLK, F_SETLKW
 * typ: F_RDLCK, F_WRLCK, F_UNLCK
 * offset: Start des Locks
 * len: Lnge des Locks (0: bis Ende der Datei)
 * whence: SEEK_SET, SEEK_END, SET_CUR
 */
int lock_region P__((int fd, int cmd, int typ, off_t offset, int whence, off_t len));
/* partial files: */
#define fd_read_lock(fd,offset,whence,len) \
	lock_region(fd,F_SETLK,F_RDLCK,offset,whence,len)
#define fd_readw_lock(fd,offset,whence,len) \
	lock_region(fd,F_SETLKW,F_RDLCK,offset,whence,len)
#define fd_write_lock(fd,offset,whence,len) \
	lock_region(fd,F_SETLK,F_WRLCK,offset,whence,len)
#define fd_writew_lock(fd,offset,whence,len) \
	lock_region(fd,F_SETLKW,F_WRLCK,offset,whence,len)
#define fd_un_lock(fd,offset,whence,len) \
	lock_region(fd,F_SETLK,F_UNLCK,offset,whence,len)
/* complete files: */
#define fd_read_lock0(fd) lock_region((fd),F_SETLK,F_RDLCK,0,SEEK_SET,0)
#define fd_readw_lock0(fd) lock_region((fd),F_SETLKW,F_RDLCK,0,SEEK_SET,0)
#define fd_write_lock0(fd) lock_region((fd),F_SETLK,F_WRLCK,0,SEEK_SET,0)
#define fd_writew_lock0(fd) lock_region((fd),F_SETLKW,F_WRLCK,0,SEEK_SET,0)
#define fd_un_lock0(fd) lock_region((fd),F_SETLK,F_UNLCK,0,SEEK_SET,0)
#endif

#endif
