/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.patch;

import java.util.ArrayList;
import org.eclipse.compare.internal.patch.HunkDiffNode;
import org.eclipse.compare.internal.patch.PatchDiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.mapping.SynchronizationResourceMappingContext;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchSubscriberMergeContext;
import org.eclipse.team.internal.ui.synchronize.patch.PatchModelProvider;
import org.eclipse.team.ui.mapping.SynchronizationContentProvider;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;

public class PatchSyncContentProvider
extends SynchronizationContentProvider {
    private BaseWorkbenchContentProvider delegate;

    @Override
    public void init(ICommonContentExtensionSite site) {
        super.init(site);
        this.delegate = new BaseWorkbenchContentProvider();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    @Override
    protected ITreeContentProvider getDelegateContentProvider() {
        return this.delegate;
    }

    @Override
    protected String getModelProviderId() {
        return "org.eclipse.team.ui.patchModelProvider";
    }

    @Override
    protected Object getModelRoot() {
        if (this.getContext() instanceof ApplyPatchSubscriberMergeContext) {
            ApplyPatchSubscriberMergeContext context = (ApplyPatchSubscriberMergeContext)this.getContext();
            return PatchModelProvider.getPatchWorkspace(context.getSubscriber());
        }
        return null;
    }

    @Override
    protected ResourceTraversal[] getTraversals(ISynchronizationContext context, Object object) {
        if (object instanceof IDiffElement) {
            ResourceMapping mapping = PatchModelProvider.getResourceMapping((IDiffElement)object);
            SynchronizationResourceMappingContext rmc = new SynchronizationResourceMappingContext(context);
            try {
                return mapping.getTraversals((ResourceMappingContext)rmc, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        return new ResourceTraversal[0];
    }

    @Override
    protected boolean isInScope(ISynchronizationScope scope, Object parent, Object element) {
        if (element instanceof PatchDiffNode) {
            IResource resource = PatchModelProvider.getResource((PatchDiffNode)element);
            if (resource == null) {
                return false;
            }
            if (scope.contains(resource)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof HunkDiffNode) {
            return false;
        }
        return super.hasChildren(element);
    }

    @Override
    public Object[] getChildren(Object parent) {
        Object[] children = super.getChildren(parent);
        ArrayList<PatchDiffNode> result = new ArrayList<PatchDiffNode>();
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            PatchDiffNode node;
            Object c = objectArray[n2];
            if (c instanceof PatchDiffNode && (node = (PatchDiffNode)c).isEnabled()) {
                result.add(node);
            }
            ++n2;
        }
        return result.toArray();
    }
}

