/*++

Copyright (C) 2019 PrimeDevelopers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated C application that demonstrates the
 usage of the C bindings of Prime Numbers Library

Interface version: 1.2.0

*/

#include <stdio.h>
#include "libprimes_dynamic.h"


void releaseWrapper(sLibPrimesDynamicWrapperTable* pWrapperTable) {
	LibPrimesResult eResult = ReleaseLibPrimesWrapperTable(pWrapperTable);
	printf_s("Failed releasing wrapper table\n");
}

int main()
{
	// TODO: put a path the LibPrimes-library file here.
	const char* libpath = "";
	sLibPrimesDynamicWrapperTable sWrapperTable;
	LibPrimesResult eResult = LIBPRIMES_SUCCESS;
	
	eResult = InitLibPrimesWrapperTable(&sWrapperTable);
	if (LIBPRIMES_SUCCESS != eResult) {
		printf_s("Failed initializing wrapper table\n");
		return eResult;
	}
	
	eResult = LoadLibPrimesWrapperTable(&sWrapperTable, libpath);
	if (LIBPRIMES_SUCCESS != eResult) {
		printf_s("Failed loading libprimes-binary\n");
		return eResult;
	}
	LibPrimes_uint32 nMajor, nMinor, nMicro;
	eResult = sWrapperTable.m_GetVersion(&nMajor, &nMinor, &nMicro);
	if (LIBPRIMES_SUCCESS != eResult) {
		printf_s("Failed to get version\n");
		releaseWrapper(&sWrapperTable);
		return eResult;
	}
	printf_s("LibPrimes.Version = %d.%d.%d", nMajor, nMinor, nMicro);
	
	printf_s("\n");
	
	eResult = ReleaseLibPrimesWrapperTable(&sWrapperTable);
	if (LIBPRIMES_SUCCESS != eResult) {
		printf_s("Failed releasing wrapper table\n");
		return eResult;
	}
	
	return 0;
}

