/*++

Copyright (C) 2019 PrimeDevelopers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated plain C Header file in order to allow an easy
 use of Prime Numbers Library

Interface version: 1.2.0

*/

#include "libprimes_types.h"
#include "libprimes_dynamic.h"
#ifdef _WIN32
#include <windows.h>
#else // _WIN32
#include <dlfcn.h>
#endif // _WIN32

LibPrimesResult InitLibPrimesWrapperTable(sLibPrimesDynamicWrapperTable * pWrapperTable)
{
	if (pWrapperTable == NULL)
		return LIBPRIMES_ERROR_INVALIDPARAM;
	
	pWrapperTable->m_LibraryHandle = NULL;
	pWrapperTable->m_Calculator_GetValue = NULL;
	pWrapperTable->m_Calculator_SetValue = NULL;
	pWrapperTable->m_Calculator_Calculate = NULL;
	pWrapperTable->m_Calculator_SetProgressCallback = NULL;
	pWrapperTable->m_FactorizationCalculator_GetPrimeFactors = NULL;
	pWrapperTable->m_SieveCalculator_GetPrimes = NULL;
	pWrapperTable->m_GetVersion = NULL;
	pWrapperTable->m_GetLastError = NULL;
	pWrapperTable->m_AcquireInstance = NULL;
	pWrapperTable->m_ReleaseInstance = NULL;
	pWrapperTable->m_CreateFactorizationCalculator = NULL;
	pWrapperTable->m_CreateSieveCalculator = NULL;
	pWrapperTable->m_SetJournal = NULL;
	
	return LIBPRIMES_SUCCESS;
}

LibPrimesResult ReleaseLibPrimesWrapperTable(sLibPrimesDynamicWrapperTable * pWrapperTable)
{
	if (pWrapperTable == NULL)
		return LIBPRIMES_ERROR_INVALIDPARAM;
	
	if (pWrapperTable->m_LibraryHandle != NULL) {
	#ifdef _WIN32
		HMODULE hModule = (HMODULE) pWrapperTable->m_LibraryHandle;
		FreeLibrary(hModule);
	#else // _WIN32
		dlclose(pWrapperTable->m_LibraryHandle);
	#endif // _WIN32
		return InitLibPrimesWrapperTable(pWrapperTable);
	}
	
	return LIBPRIMES_SUCCESS;
}

LibPrimesResult LoadLibPrimesWrapperTable(sLibPrimesDynamicWrapperTable * pWrapperTable, const char * pLibraryFileName)
{
	if (pWrapperTable == NULL)
		return LIBPRIMES_ERROR_INVALIDPARAM;
	if (pLibraryFileName == NULL)
		return LIBPRIMES_ERROR_INVALIDPARAM;
	
	#ifdef _WIN32
	// Convert filename to UTF16-string
	int nLength = (int)strlen(pLibraryFileName);
	int nBufferSize = nLength * 2 + 2;
	wchar_t* wsLibraryFileName = malloc(nBufferSize*sizeof(wchar_t));
	memset(wsLibraryFileName, 0, nBufferSize*sizeof(wchar_t));
	int nResult = MultiByteToWideChar(CP_UTF8, 0, pLibraryFileName, nLength, wsLibraryFileName, nBufferSize);
	if (nResult == 0) {
		free(wsLibraryFileName);
		return LIBPRIMES_ERROR_COULDNOTLOADLIBRARY;
	}
	
	HMODULE hLibrary = LoadLibraryW(wsLibraryFileName);
	free(wsLibraryFileName);
	if (hLibrary == 0) 
		return LIBPRIMES_ERROR_COULDNOTLOADLIBRARY;
	#else // _WIN32
	void* hLibrary = dlopen(pLibraryFileName, RTLD_LAZY);
	if (hLibrary == 0) 
		return LIBPRIMES_ERROR_COULDNOTLOADLIBRARY;
	dlerror();
	#endif // _WIN32
	
	#ifdef _WIN32
	pWrapperTable->m_Calculator_GetValue = (PLibPrimesCalculator_GetValuePtr) GetProcAddress(hLibrary, "libprimes_calculator_getvalue");
	#else // _WIN32
	pWrapperTable->m_Calculator_GetValue = (PLibPrimesCalculator_GetValuePtr) dlsym(hLibrary, "libprimes_calculator_getvalue");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Calculator_GetValue == NULL)
		return LIBPRIMES_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Calculator_SetValue = (PLibPrimesCalculator_SetValuePtr) GetProcAddress(hLibrary, "libprimes_calculator_setvalue");
	#else // _WIN32
	pWrapperTable->m_Calculator_SetValue = (PLibPrimesCalculator_SetValuePtr) dlsym(hLibrary, "libprimes_calculator_setvalue");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Calculator_SetValue == NULL)
		return LIBPRIMES_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Calculator_Calculate = (PLibPrimesCalculator_CalculatePtr) GetProcAddress(hLibrary, "libprimes_calculator_calculate");
	#else // _WIN32
	pWrapperTable->m_Calculator_Calculate = (PLibPrimesCalculator_CalculatePtr) dlsym(hLibrary, "libprimes_calculator_calculate");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Calculator_Calculate == NULL)
		return LIBPRIMES_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Calculator_SetProgressCallback = (PLibPrimesCalculator_SetProgressCallbackPtr) GetProcAddress(hLibrary, "libprimes_calculator_setprogresscallback");
	#else // _WIN32
	pWrapperTable->m_Calculator_SetProgressCallback = (PLibPrimesCalculator_SetProgressCallbackPtr) dlsym(hLibrary, "libprimes_calculator_setprogresscallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Calculator_SetProgressCallback == NULL)
		return LIBPRIMES_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FactorizationCalculator_GetPrimeFactors = (PLibPrimesFactorizationCalculator_GetPrimeFactorsPtr) GetProcAddress(hLibrary, "libprimes_factorizationcalculator_getprimefactors");
	#else // _WIN32
	pWrapperTable->m_FactorizationCalculator_GetPrimeFactors = (PLibPrimesFactorizationCalculator_GetPrimeFactorsPtr) dlsym(hLibrary, "libprimes_factorizationcalculator_getprimefactors");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FactorizationCalculator_GetPrimeFactors == NULL)
		return LIBPRIMES_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SieveCalculator_GetPrimes = (PLibPrimesSieveCalculator_GetPrimesPtr) GetProcAddress(hLibrary, "libprimes_sievecalculator_getprimes");
	#else // _WIN32
	pWrapperTable->m_SieveCalculator_GetPrimes = (PLibPrimesSieveCalculator_GetPrimesPtr) dlsym(hLibrary, "libprimes_sievecalculator_getprimes");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SieveCalculator_GetPrimes == NULL)
		return LIBPRIMES_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetVersion = (PLibPrimesGetVersionPtr) GetProcAddress(hLibrary, "libprimes_getversion");
	#else // _WIN32
	pWrapperTable->m_GetVersion = (PLibPrimesGetVersionPtr) dlsym(hLibrary, "libprimes_getversion");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetVersion == NULL)
		return LIBPRIMES_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetLastError = (PLibPrimesGetLastErrorPtr) GetProcAddress(hLibrary, "libprimes_getlasterror");
	#else // _WIN32
	pWrapperTable->m_GetLastError = (PLibPrimesGetLastErrorPtr) dlsym(hLibrary, "libprimes_getlasterror");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetLastError == NULL)
		return LIBPRIMES_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_AcquireInstance = (PLibPrimesAcquireInstancePtr) GetProcAddress(hLibrary, "libprimes_acquireinstance");
	#else // _WIN32
	pWrapperTable->m_AcquireInstance = (PLibPrimesAcquireInstancePtr) dlsym(hLibrary, "libprimes_acquireinstance");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_AcquireInstance == NULL)
		return LIBPRIMES_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ReleaseInstance = (PLibPrimesReleaseInstancePtr) GetProcAddress(hLibrary, "libprimes_releaseinstance");
	#else // _WIN32
	pWrapperTable->m_ReleaseInstance = (PLibPrimesReleaseInstancePtr) dlsym(hLibrary, "libprimes_releaseinstance");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ReleaseInstance == NULL)
		return LIBPRIMES_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CreateFactorizationCalculator = (PLibPrimesCreateFactorizationCalculatorPtr) GetProcAddress(hLibrary, "libprimes_createfactorizationcalculator");
	#else // _WIN32
	pWrapperTable->m_CreateFactorizationCalculator = (PLibPrimesCreateFactorizationCalculatorPtr) dlsym(hLibrary, "libprimes_createfactorizationcalculator");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CreateFactorizationCalculator == NULL)
		return LIBPRIMES_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CreateSieveCalculator = (PLibPrimesCreateSieveCalculatorPtr) GetProcAddress(hLibrary, "libprimes_createsievecalculator");
	#else // _WIN32
	pWrapperTable->m_CreateSieveCalculator = (PLibPrimesCreateSieveCalculatorPtr) dlsym(hLibrary, "libprimes_createsievecalculator");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CreateSieveCalculator == NULL)
		return LIBPRIMES_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SetJournal = (PLibPrimesSetJournalPtr) GetProcAddress(hLibrary, "libprimes_setjournal");
	#else // _WIN32
	pWrapperTable->m_SetJournal = (PLibPrimesSetJournalPtr) dlsym(hLibrary, "libprimes_setjournal");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SetJournal == NULL)
		return LIBPRIMES_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	pWrapperTable->m_LibraryHandle = hLibrary;
	return LIBPRIMES_SUCCESS;
}

