/*++

Copyright (C) 2019 ACT Developers


This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated C++ application that demonstrates the
 usage of the Dynamic C++ bindings of Optional Class Library

Interface version: 1.0.0

*/

#include <iostream>
#include "optclass_dynamic.hpp"


int main()
{
	try
	{
		std::string libpath = (""); // TODO: put the location of the OptClass-library file here.
		auto wrapper = OptClass::CWrapper::loadLibrary(libpath + "/optclass.dll"); // TODO: add correct suffix of the library
		OptClass_uint32 nMajor, nMinor, nMicro;
		wrapper->GetVersion(nMajor, nMinor, nMicro);
		std::cout << "OptClass.Version = " << nMajor << "." << nMinor << "." << nMicro;
		std::cout << std::endl;

		wrapper->CreateInstanceWithName("A");
		auto baseA = wrapper->FindInstanceA("A");
		if (baseA == nullptr) {
			std::cout << "Error: Expected to find Instance \"A\"." << std::endl;
			return 1;
		}

		OptClass::PBase baseB;
		wrapper->FindInstanceB("DoesNotExist", baseB);
		if (baseB != nullptr) {
			std::cout << "Error: Did not expect to find Instance \"DoesNotExist\"." << std::endl;
			return 1;
		}

 		if (!wrapper->UseInstanceMaybe(baseA.get())) {
			std::cout << "Error: Expected to use Instance \"A\"." << std::endl;
			return 1;
		}
		if (wrapper->UseInstanceMaybe(baseB.get())) {
			std::cout << "Error: Did not expect to use Instance \"DoesNotExist\"." << std::endl;
			return 1;
		}

		std::cout << "Passed." << std::endl;
	}
	catch (std::exception &e)
 	{
		std::cout << e.what() << std::endl;
 		return 1;
	}
	return 0;
}

