/*++

Copyright (C) 2019 Calculation developers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated C++ application that demonstrates the
 usage of the C++ bindings of Calculation library

Interface version: 1.0.0

*/

#include <iostream>
#include "calculation_implicit.hpp"


int main()
{
	try
	{
		auto wrapper = Calculation::CWrapper::loadLibrary();
		Calculation_uint32 nMajor, nMinor, nMicro;
		wrapper->GetVersion(nMajor, nMinor, nMicro);
		std::cout << "Calculation.Version = " << nMajor << "." << nMinor << "." << nMicro;
		std::cout << std::endl;
		
		std::string libpath = "";
		auto numbers = Numbers::CWrapper::loadLibrary(libpath + "/numbers.");
		numbers->GetVersion(nMajor, nMinor, nMicro);
		std::cout << "Numbers.Version = " << nMajor << "." << nMinor << "." << nMicro;
		std::cout << std::endl;

		wrapper->InjectComponent("Numbers", numbers->GetSymbolLookupMethod());

		auto calculator = wrapper->CreateCalculator();
		auto v1 = numbers->CreateVariable(10.0);
		calculator->EnlistVariable(v1.get());

		calculator->EnlistVariable(numbers->CreateVariable(5.0).get());

		Numbers::PVariable pSum = calculator->Add();
		std::cout << "   sum = " << pSum->GetValue() << std::endl;

		{
			auto v2New = calculator->GetEnlistedVariable(1);
			v2New->SetValue(15.0);
		} 

		std::cout << "newSum = " << calculator->Add()->GetValue() << std::endl;
	}
	catch (std::exception &e)
	{
		std::cout << e.what() << std::endl;
		return 1;
	}
	return 0;
}

