/*++

Copyright (C) 2019 Calculator developers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated C++ implementation file in order to allow easy
development of Calculator library. The functions in this file need to be implemented. It needs to be generated only once.

Interface version: 1.0.0

*/

#include "calculator_abi.hpp"
#include "calculator_interfaces.hpp"
#include "calculator_interfaceexception.hpp"

#include <map>

using namespace Calculator::Impl;

CalculatorResult handleCalculatorException(IBase * pIBaseClass, ECalculatorInterfaceException & Exception)
{
	CalculatorResult errorCode = Exception.getErrorCode();

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage(Exception.what());

	return errorCode;
}

CalculatorResult handleStdException(IBase * pIBaseClass, std::exception & Exception)
{
	CalculatorResult errorCode = CALCULATOR_ERROR_GENERICEXCEPTION;

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage(Exception.what());

	return errorCode;
}

CalculatorResult handleUnhandledException(IBase * pIBaseClass)
{
	CalculatorResult errorCode = CALCULATOR_ERROR_GENERICEXCEPTION;

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage("Unhandled Exception");

	return errorCode;
}



/*************************************************************************************************************************
 Class implementation for Base
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for Variable
**************************************************************************************************************************/
CalculatorResult calculator_variable_getvalue(Calculator_Variable pVariable, Calculator_double * pValue)
{
	IBase* pIBaseClass = (IBase *)pVariable;

	try {
		if (pValue == nullptr)
			throw ECalculatorInterfaceException (CALCULATOR_ERROR_INVALIDPARAM);
		IVariable* pIVariable = dynamic_cast<IVariable*>(pIBaseClass);
		if (!pIVariable)
			throw ECalculatorInterfaceException(CALCULATOR_ERROR_INVALIDCAST);
		
		*pValue = pIVariable->GetValue();

		return CALCULATOR_SUCCESS;
	}
	catch (ECalculatorInterfaceException & Exception) {
		return handleCalculatorException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculatorResult calculator_variable_setvalue(Calculator_Variable pVariable, Calculator_double dValue)
{
	IBase* pIBaseClass = (IBase *)pVariable;

	try {
		IVariable* pIVariable = dynamic_cast<IVariable*>(pIBaseClass);
		if (!pIVariable)
			throw ECalculatorInterfaceException(CALCULATOR_ERROR_INVALIDCAST);
		
		pIVariable->SetValue(dValue);

		return CALCULATOR_SUCCESS;
	}
	catch (ECalculatorInterfaceException & Exception) {
		return handleCalculatorException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}


/*************************************************************************************************************************
 Class implementation for Calculator
**************************************************************************************************************************/
CalculatorResult calculator_calculator_enlistvariable(Calculator_Calculator pCalculator, Calculator_Variable pVariable)
{
	IBase* pIBaseClass = (IBase *)pCalculator;

	try {
		IBase* pIBaseClassVariable = (IBase *)pVariable;
		IVariable* pIVariable = dynamic_cast<IVariable*>(pIBaseClassVariable);
		if (!pIVariable)
			throw ECalculatorInterfaceException (CALCULATOR_ERROR_INVALIDCAST);
		
		ICalculator* pICalculator = dynamic_cast<ICalculator*>(pIBaseClass);
		if (!pICalculator)
			throw ECalculatorInterfaceException(CALCULATOR_ERROR_INVALIDCAST);
		
		pICalculator->EnlistVariable(pIVariable);

		return CALCULATOR_SUCCESS;
	}
	catch (ECalculatorInterfaceException & Exception) {
		return handleCalculatorException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculatorResult calculator_calculator_getenlistedvariable(Calculator_Calculator pCalculator, Calculator_uint32 nIndex, Calculator_Variable * pVariable)
{
	IBase* pIBaseClass = (IBase *)pCalculator;

	try {
		if (pVariable == nullptr)
			throw ECalculatorInterfaceException (CALCULATOR_ERROR_INVALIDPARAM);
		IBase* pBaseVariable(nullptr);
		ICalculator* pICalculator = dynamic_cast<ICalculator*>(pIBaseClass);
		if (!pICalculator)
			throw ECalculatorInterfaceException(CALCULATOR_ERROR_INVALIDCAST);
		
		pBaseVariable = pICalculator->GetEnlistedVariable(nIndex);

		*pVariable = (IBase*)(pBaseVariable);
		return CALCULATOR_SUCCESS;
	}
	catch (ECalculatorInterfaceException & Exception) {
		return handleCalculatorException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculatorResult calculator_calculator_clearvariables(Calculator_Calculator pCalculator)
{
	IBase* pIBaseClass = (IBase *)pCalculator;

	try {
		ICalculator* pICalculator = dynamic_cast<ICalculator*>(pIBaseClass);
		if (!pICalculator)
			throw ECalculatorInterfaceException(CALCULATOR_ERROR_INVALIDCAST);
		
		pICalculator->ClearVariables();

		return CALCULATOR_SUCCESS;
	}
	catch (ECalculatorInterfaceException & Exception) {
		return handleCalculatorException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculatorResult calculator_calculator_multiply(Calculator_Calculator pCalculator, Calculator_Variable * pInstance)
{
	IBase* pIBaseClass = (IBase *)pCalculator;

	try {
		if (pInstance == nullptr)
			throw ECalculatorInterfaceException (CALCULATOR_ERROR_INVALIDPARAM);
		IBase* pBaseInstance(nullptr);
		ICalculator* pICalculator = dynamic_cast<ICalculator*>(pIBaseClass);
		if (!pICalculator)
			throw ECalculatorInterfaceException(CALCULATOR_ERROR_INVALIDCAST);
		
		pBaseInstance = pICalculator->Multiply();

		*pInstance = (IBase*)(pBaseInstance);
		return CALCULATOR_SUCCESS;
	}
	catch (ECalculatorInterfaceException & Exception) {
		return handleCalculatorException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculatorResult calculator_calculator_add(Calculator_Calculator pCalculator, Calculator_Variable * pInstance)
{
	IBase* pIBaseClass = (IBase *)pCalculator;

	try {
		if (pInstance == nullptr)
			throw ECalculatorInterfaceException (CALCULATOR_ERROR_INVALIDPARAM);
		IBase* pBaseInstance(nullptr);
		ICalculator* pICalculator = dynamic_cast<ICalculator*>(pIBaseClass);
		if (!pICalculator)
			throw ECalculatorInterfaceException(CALCULATOR_ERROR_INVALIDCAST);
		
		pBaseInstance = pICalculator->Add();

		*pInstance = (IBase*)(pBaseInstance);
		return CALCULATOR_SUCCESS;
	}
	catch (ECalculatorInterfaceException & Exception) {
		return handleCalculatorException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}



/*************************************************************************************************************************
 Function table lookup implementation
**************************************************************************************************************************/

CalculatorResult _calculator_getprocaddress_internal(const char * pProcName, void ** ppProcAddress)
{
	static bool sbProcAddressMapHasBeenInitialized = false;
	static std::map<std::string, void*> sProcAddressMap;
	if (!sbProcAddressMapHasBeenInitialized) {
		sProcAddressMap["calculator_variable_getvalue"] = (void*)&calculator_variable_getvalue;
		sProcAddressMap["calculator_variable_setvalue"] = (void*)&calculator_variable_setvalue;
		sProcAddressMap["calculator_calculator_enlistvariable"] = (void*)&calculator_calculator_enlistvariable;
		sProcAddressMap["calculator_calculator_getenlistedvariable"] = (void*)&calculator_calculator_getenlistedvariable;
		sProcAddressMap["calculator_calculator_clearvariables"] = (void*)&calculator_calculator_clearvariables;
		sProcAddressMap["calculator_calculator_multiply"] = (void*)&calculator_calculator_multiply;
		sProcAddressMap["calculator_calculator_add"] = (void*)&calculator_calculator_add;
		sProcAddressMap["calculator_getversion"] = (void*)&calculator_getversion;
		sProcAddressMap["calculator_getlasterror"] = (void*)&calculator_getlasterror;
		sProcAddressMap["calculator_releaseinstance"] = (void*)&calculator_releaseinstance;
		sProcAddressMap["calculator_acquireinstance"] = (void*)&calculator_acquireinstance;
		sProcAddressMap["calculator_createvariable"] = (void*)&calculator_createvariable;
		sProcAddressMap["calculator_createcalculator"] = (void*)&calculator_createcalculator;
		
		sbProcAddressMapHasBeenInitialized = true;
	}
	if (pProcName == nullptr)
		return CALCULATOR_ERROR_INVALIDPARAM;
	if (ppProcAddress == nullptr)
		return CALCULATOR_ERROR_INVALIDPARAM;
	*ppProcAddress = nullptr;
	std::string sProcName (pProcName);
	
	auto procPair = sProcAddressMap.find(sProcName);
	if (procPair == sProcAddressMap.end()) {
		return CALCULATOR_ERROR_COULDNOTFINDLIBRARYEXPORT;
	}
	else {
		*ppProcAddress = procPair->second;
		return CALCULATOR_SUCCESS;
	}
	
}

/*************************************************************************************************************************
 Global functions implementation
**************************************************************************************************************************/
CalculatorResult calculator_getversion(Calculator_uint32 * pMajor, Calculator_uint32 * pMinor, Calculator_uint32 * pMicro)
{
	IBase* pIBaseClass = nullptr;

	try {
		if (!pMajor)
			throw ECalculatorInterfaceException (CALCULATOR_ERROR_INVALIDPARAM);
		if (!pMinor)
			throw ECalculatorInterfaceException (CALCULATOR_ERROR_INVALIDPARAM);
		if (!pMicro)
			throw ECalculatorInterfaceException (CALCULATOR_ERROR_INVALIDPARAM);
		CWrapper::GetVersion(*pMajor, *pMinor, *pMicro);

		return CALCULATOR_SUCCESS;
	}
	catch (ECalculatorInterfaceException & Exception) {
		return handleCalculatorException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculatorResult calculator_getlasterror(Calculator_Base pInstance, const Calculator_uint32 nErrorMessageBufferSize, Calculator_uint32* pErrorMessageNeededChars, char * pErrorMessageBuffer, bool * pHasError)
{
	IBase* pIBaseClass = nullptr;

	try {
		if ( (!pErrorMessageBuffer) && !(pErrorMessageNeededChars) )
			throw ECalculatorInterfaceException (CALCULATOR_ERROR_INVALIDPARAM);
		if (pHasError == nullptr)
			throw ECalculatorInterfaceException (CALCULATOR_ERROR_INVALIDPARAM);
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw ECalculatorInterfaceException (CALCULATOR_ERROR_INVALIDCAST);
		
		std::string sErrorMessage("");
		*pHasError = CWrapper::GetLastError(pIInstance, sErrorMessage);

		if (pErrorMessageNeededChars)
			*pErrorMessageNeededChars = (Calculator_uint32) (sErrorMessage.size()+1);
		if (pErrorMessageBuffer) {
			if (sErrorMessage.size() >= nErrorMessageBufferSize)
				throw ECalculatorInterfaceException (CALCULATOR_ERROR_BUFFERTOOSMALL);
			for (size_t iErrorMessage = 0; iErrorMessage < sErrorMessage.size(); iErrorMessage++)
				pErrorMessageBuffer[iErrorMessage] = sErrorMessage[iErrorMessage];
			pErrorMessageBuffer[sErrorMessage.size()] = 0;
		}
		return CALCULATOR_SUCCESS;
	}
	catch (ECalculatorInterfaceException & Exception) {
		return handleCalculatorException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculatorResult calculator_releaseinstance(Calculator_Base pInstance)
{
	IBase* pIBaseClass = nullptr;

	try {
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw ECalculatorInterfaceException (CALCULATOR_ERROR_INVALIDCAST);
		
		CWrapper::ReleaseInstance(pIInstance);

		return CALCULATOR_SUCCESS;
	}
	catch (ECalculatorInterfaceException & Exception) {
		return handleCalculatorException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculatorResult calculator_acquireinstance(Calculator_Base pInstance)
{
	IBase* pIBaseClass = nullptr;

	try {
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw ECalculatorInterfaceException (CALCULATOR_ERROR_INVALIDCAST);
		
		CWrapper::AcquireInstance(pIInstance);

		return CALCULATOR_SUCCESS;
	}
	catch (ECalculatorInterfaceException & Exception) {
		return handleCalculatorException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculatorResult calculator_createvariable(Calculator_double dInitialValue, Calculator_Variable * pInstance)
{
	IBase* pIBaseClass = nullptr;

	try {
		if (pInstance == nullptr)
			throw ECalculatorInterfaceException (CALCULATOR_ERROR_INVALIDPARAM);
		IBase* pBaseInstance(nullptr);
		pBaseInstance = CWrapper::CreateVariable(dInitialValue);

		*pInstance = (IBase*)(pBaseInstance);
		return CALCULATOR_SUCCESS;
	}
	catch (ECalculatorInterfaceException & Exception) {
		return handleCalculatorException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculatorResult calculator_createcalculator(Calculator_Calculator * pInstance)
{
	IBase* pIBaseClass = nullptr;

	try {
		if (pInstance == nullptr)
			throw ECalculatorInterfaceException (CALCULATOR_ERROR_INVALIDPARAM);
		IBase* pBaseInstance(nullptr);
		pBaseInstance = CWrapper::CreateCalculator();

		*pInstance = (IBase*)(pBaseInstance);
		return CALCULATOR_SUCCESS;
	}
	catch (ECalculatorInterfaceException & Exception) {
		return handleCalculatorException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}


