/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.xml.sax.SAXException;

public final class SchemaCache {
    private Schema schema;
    private final URL source;

    public SchemaCache(URL source) {
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidatorHandler newValidator() {
        SchemaCache schemaCache = this;
        synchronized (schemaCache) {
            if (this.schema == null) {
                try {
                    this.schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(this.source);
                }
                catch (SAXException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        ValidatorHandler handler = this.schema.newValidatorHandler();
        this.fixValidatorBug6246922(handler);
        return handler;
    }

    private void fixValidatorBug6246922(ValidatorHandler handler) {
        try {
            Field f = handler.getClass().getDeclaredField("errorReporter");
            f.setAccessible(true);
            Object errorReporter = f.get(handler);
            Method get = errorReporter.getClass().getDeclaredMethod("getMessageFormatter", String.class);
            Object currentFormatter = get.invoke(errorReporter, "http://www.w3.org/TR/xml-schema-1");
            if (currentFormatter != null) {
                return;
            }
            Method put = null;
            for (Method m : errorReporter.getClass().getDeclaredMethods()) {
                if (!m.getName().equals("putMessageFormatter")) continue;
                put = m;
                break;
            }
            if (put == null) {
                return;
            }
            ClassLoader cl = errorReporter.getClass().getClassLoader();
            String className = "com.sun.org.apache.xerces.internal.impl.xs.XSMessageFormatter";
            Class<?> xsformatter = cl == null ? Class.forName(className) : cl.loadClass(className);
            put.invoke(errorReporter, "http://www.w3.org/TR/xml-schema-1", xsformatter.newInstance());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

