/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormSpec;
import java.awt.ComponentOrientation;
import java.awt.Insets;

public class FormLayoutUtil {
    private static ColumnSpec flipped(ColumnSpec spec) {
        FormSpec.DefaultAlignment alignment = spec.getDefaultAlignment();
        if (alignment == ColumnSpec.LEFT) {
            alignment = ColumnSpec.RIGHT;
        } else if (alignment == ColumnSpec.RIGHT) {
            alignment = ColumnSpec.LEFT;
        }
        return new ColumnSpec(alignment, spec.getSize(), spec.getResizeWeight());
    }

    private static ColumnSpec[] flipped(ColumnSpec[] original) {
        int length = original.length;
        ColumnSpec[] flipped = new ColumnSpec[length];
        for (int i = 0; i < length; ++i) {
            flipped[i] = FormLayoutUtil.flipped(original[length - 1 - i]);
        }
        return flipped;
    }

    private static ColumnSpec[] flipped(String encodedColumnSpecs) {
        return FormLayoutUtil.flipped(ColumnSpec.decodeSpecs(encodedColumnSpecs));
    }

    public static String flip(String encodedColumnSpecs) {
        ColumnSpec[] flippedSpecs;
        StringBuffer result = new StringBuffer();
        String separator = "";
        for (ColumnSpec spec : flippedSpecs = FormLayoutUtil.flipped(ColumnSpec.decodeSpecs(encodedColumnSpecs))) {
            result.append(separator);
            result.append(spec.encode());
            separator = ", ";
        }
        return result.toString();
    }

    private static CellConstraints flipHorizontally(CellConstraints cc) {
        CellConstraints.Alignment flippedHAlign = cc.hAlign;
        if (flippedHAlign == CellConstraints.LEFT) {
            flippedHAlign = CellConstraints.RIGHT;
        } else if (flippedHAlign == CellConstraints.RIGHT) {
            flippedHAlign = CellConstraints.LEFT;
        }
        CellConstraints flipped = new CellConstraints(cc.gridX, cc.gridY, cc.gridWidth, cc.gridHeight, flippedHAlign, cc.vAlign);
        if (cc.insets != null) {
            flipped.insets = new Insets(cc.insets.top, cc.insets.right, cc.insets.bottom, cc.insets.left);
        }
        return flipped;
    }

    private static CellConstraints flipHorizontally(CellConstraints cc, int columnCount) {
        CellConstraints flipped = FormLayoutUtil.flipHorizontally(cc);
        flipped.gridX = columnCount + 1 - cc.gridX - cc.gridWidth + 1;
        return flipped;
    }

    public static String getColSpec(String leftToRightColSpec, ComponentOrientation orientation) {
        if (orientation.isLeftToRight()) {
            return leftToRightColSpec;
        }
        return FormLayoutUtil.flip(leftToRightColSpec);
    }

    public static CellConstraints flip(CellConstraints cc, String colSpec, ComponentOrientation orientation) {
        if (orientation.isLeftToRight()) {
            return cc;
        }
        int columnCount = colSpec.split(",").length;
        return FormLayoutUtil.flipHorizontally(cc, columnCount);
    }
}

