/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import net.pms.io.BufferedOutputFile;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.WaitBufferedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnbufferedOutputFile
implements BufferedOutputFile {
    private static final Logger logger = LoggerFactory.getLogger(UnbufferedOutputFile.class);
    private PipedOutputStream pipedOutputStream = new PipedOutputStream();
    private PipedInputStream pipedInputStream;

    public UnbufferedOutputFile(OutputParams params) {
        try {
            this.pipedInputStream = new PipedInputStream(this.pipedOutputStream);
        }
        catch (IOException e) {
            logger.debug("Error creating piped input stream: " + e);
        }
    }

    @Override
    public void close() throws IOException {
        this.pipedInputStream.close();
        this.pipedOutputStream.close();
    }

    @Override
    public InputStream getInputStream(long newReadPosition) {
        return this.pipedInputStream;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.pipedOutputStream.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.pipedOutputStream.write(b);
    }

    @Override
    public void write(byte[] byteArray) throws IOException {
        this.pipedOutputStream.write(byteArray);
    }

    @Override
    @Deprecated
    public WaitBufferedInputStream getCurrentInputStream() {
        return null;
    }

    @Override
    @Deprecated
    public long getWriteCount() {
        return 0L;
    }

    @Override
    @Deprecated
    public int read(boolean firstRead, long readCount) {
        return 0;
    }

    @Override
    @Deprecated
    public int read(boolean firstRead, long readCount, byte[] b, int off, int len) {
        return 0;
    }

    @Override
    @Deprecated
    public void attachThread(ProcessWrapper thread) {
    }

    @Override
    @Deprecated
    public void reset() {
    }

    @Override
    @Deprecated
    public void removeInputStream(WaitBufferedInputStream waitBufferedInputStream) {
    }

    @Override
    @Deprecated
    public void detachInputStream() {
    }
}

