/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import com.sun.jna.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.pms.io.PipeProcess;
import net.pms.io.ProcessWrapper;
import net.pms.io.StreamModifier;
import net.pms.util.DTSAudioOutputStream;
import net.pms.util.H264AnnexBInputStream;
import net.pms.util.PCMAudioOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeIPCProcess
extends Thread
implements ProcessWrapper {
    private static final Logger logger = LoggerFactory.getLogger(PipeIPCProcess.class);
    private PipeProcess mkin;
    private PipeProcess mkout;
    private StreamModifier modifier;

    public StreamModifier getModifier() {
        return this.modifier;
    }

    public void setModifier(StreamModifier modifier) {
        this.modifier = modifier;
    }

    public PipeIPCProcess(String pipeName, String pipeNameOut, boolean forcereconnect1, boolean forcereconnect2) {
        this.mkin = new PipeProcess(pipeName, forcereconnect1 ? "reconnect" : "dummy");
        this.mkout = new PipeProcess(pipeNameOut, "out", forcereconnect2 ? "reconnect" : "dummy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] b = new byte[524288];
        int n = -1;
        InputStream in = null;
        OutputStream out = null;
        OutputStream debug = null;
        try {
            in = this.mkin.getInputStream();
            out = this.mkout.getOutputStream();
            if (this.modifier != null && this.modifier.isH264AnnexB()) {
                in = new H264AnnexBInputStream(in, this.modifier.getHeader());
            } else if (this.modifier != null && this.modifier.isDtsEmbed()) {
                out = new DTSAudioOutputStream(new PCMAudioOutputStream(out, this.modifier.getNbChannels(), this.modifier.getSampleFrequency(), this.modifier.getBitsPerSample()));
            } else if (this.modifier != null && this.modifier.isPcm()) {
                out = new PCMAudioOutputStream(out, this.modifier.getNbChannels(), this.modifier.getSampleFrequency(), this.modifier.getBitsPerSample());
            }
            if (this.modifier != null && this.modifier.getHeader() != null && !this.modifier.isH264AnnexB()) {
                out.write(this.modifier.getHeader());
            }
            while ((n = in.read(b)) > -1) {
                out.write(b, 0, n);
                if (debug == null) continue;
                debug.write(b, 0, n);
            }
        }
        catch (IOException e) {
            logger.debug("Error :" + e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                if (debug != null) {
                    debug.close();
                }
            }
            catch (IOException e) {
                logger.debug("Error :" + e.getMessage());
            }
        }
    }

    public String getInputPipe() {
        return this.mkin.getInputPipe();
    }

    public String getOutputPipe() {
        return this.mkout.getOutputPipe();
    }

    public ProcessWrapper getPipeProcess() {
        return this;
    }

    public void deleteLater() {
        this.mkin.deleteLater();
        this.mkout.deleteLater();
    }

    public InputStream getInputStream() throws IOException {
        return this.mkin.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.mkout.getOutputStream();
    }

    @Override
    public InputStream getInputStream(long seek) throws IOException {
        return null;
    }

    public ArrayList<String> getResults() {
        return null;
    }

    @Override
    public boolean isDestroyed() {
        return this.isAlive();
    }

    @Override
    public void runInNewThread() {
        if (!Platform.isWindows()) {
            this.mkin.getPipeProcess().runInNewThread();
            this.mkout.getPipeProcess().runInNewThread();
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.start();
    }

    @Override
    public boolean isReadyToStop() {
        return false;
    }

    @Override
    public void setReadyToStop(boolean nullable) {
    }

    @Override
    public void stopProcess() {
        this.interrupt();
        this.mkin.getPipeProcess().stopProcess();
        this.mkout.getPipeProcess().stopProcess();
    }
}

