/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna.virtual;

import java.io.File;
import java.util.ArrayList;
import net.pms.PMS;
import net.pms.dlna.DLNAMediaDatabase;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.DVDISOFile;
import net.pms.dlna.PlaylistFolder;
import net.pms.dlna.RealFile;
import net.pms.dlna.virtual.VirtualFolder;

public class MediaLibraryFolder
extends VirtualFolder {
    public static final int FILES = 0;
    public static final int TEXTS = 1;
    public static final int PLAYLISTS = 2;
    public static final int ISOS = 3;
    private String[] sqls;
    private int[] expectedOutputs;
    private DLNAMediaDatabase database;

    public MediaLibraryFolder(String name, String sql, int expectedOutput) {
        this(name, new String[]{sql}, new int[]{expectedOutput});
    }

    public MediaLibraryFolder(String name, String[] sql, int[] expectedOutput) {
        super(name, null);
        this.sqls = sql;
        this.expectedOutputs = expectedOutput;
        this.database = PMS.get().getDatabase();
        assert (this.database != null);
    }

    @Override
    public void discoverChildren() {
        block5: {
            ArrayList<String> list;
            int expectedOutput;
            String sql;
            block8: {
                block7: {
                    block6: {
                        if (this.sqls.length <= 0) break block5;
                        sql = this.sqls[0];
                        expectedOutput = this.expectedOutputs[0];
                        if (sql == null) break block5;
                        sql = this.transformSQL(sql);
                        if (expectedOutput != 0) break block6;
                        ArrayList<File> list2 = this.database.getFiles(sql);
                        if (list2 == null) break block5;
                        for (File f : list2) {
                            this.addChild(new RealFile(f));
                        }
                        break block5;
                    }
                    if (expectedOutput != 2) break block7;
                    ArrayList<File> list3 = this.database.getFiles(sql);
                    if (list3 == null) break block5;
                    for (File f : list3) {
                        this.addChild(new PlaylistFolder(f));
                    }
                    break block5;
                }
                if (expectedOutput != 3) break block8;
                ArrayList<File> list4 = this.database.getFiles(sql);
                if (list4 == null) break block5;
                for (File f : list4) {
                    this.addChild(new DVDISOFile(f));
                }
                break block5;
            }
            if (expectedOutput == 1 && (list = this.database.getStrings(sql)) != null) {
                for (String s : list) {
                    String[] sqls2 = new String[this.sqls.length - 1];
                    int[] expectedOutputs2 = new int[this.expectedOutputs.length - 1];
                    System.arraycopy(this.sqls, 1, sqls2, 0, sqls2.length);
                    System.arraycopy(this.expectedOutputs, 1, expectedOutputs2, 0, expectedOutputs2.length);
                    this.addChild(new MediaLibraryFolder(s, sqls2, expectedOutputs2));
                }
            }
        }
    }

    private String transformSQL(String sql) {
        sql = sql.replace("${0}", this.transformName(this.getName()));
        if (this.getParent() != null) {
            sql = sql.replace("${1}", this.transformName(this.getParent().getName()));
            if (this.getParent().getParent() != null) {
                sql = sql.replace("${2}", this.transformName(this.getParent().getParent().getName()));
                if (this.getParent().getParent().getParent() != null) {
                    sql = sql.replace("${3}", this.transformName(this.getParent().getParent().getParent().getName()));
                    if (this.getParent().getParent().getParent().getParent() != null) {
                        sql = sql.replace("${4}", this.transformName(this.getParent().getParent().getParent().getParent().getName()));
                    }
                }
            }
        }
        return sql;
    }

    private String transformName(String name) {
        if (name.equals("###")) {
            name = "";
        }
        name = name.replace("'", "''");
        return name;
    }

    @Override
    public boolean isRefreshNeeded() {
        return true;
    }

    @Override
    public void doRefreshChildren() {
        String name;
        boolean present;
        ArrayList<File> list = null;
        ArrayList<String> strings = null;
        int expectedOutput = 0;
        if (this.sqls.length > 0) {
            String sql = this.sqls[0];
            expectedOutput = this.expectedOutputs[0];
            if (sql != null) {
                sql = this.transformSQL(sql);
                if (expectedOutput == 0 || expectedOutput == 2 || expectedOutput == 3) {
                    list = this.database.getFiles(sql);
                } else if (expectedOutput == 1) {
                    strings = this.database.getStrings(sql);
                }
            }
        }
        ArrayList<File> addedFiles = new ArrayList<File>();
        ArrayList<String> addedString = new ArrayList<String>();
        ArrayList<DLNAResource> removedFiles = new ArrayList<DLNAResource>();
        ArrayList<DLNAResource> removedString = new ArrayList<DLNAResource>();
        int i = 0;
        if (list != null) {
            for (File file : list) {
                present = false;
                for (DLNAResource dlna : this.getChildren()) {
                    if (i == 0 && (!(dlna instanceof VirtualFolder) || dlna instanceof MediaLibraryFolder)) {
                        removedFiles.add(dlna);
                    }
                    name = dlna.getName();
                    long lm = dlna.getLastModified();
                    boolean videoTSHack = false;
                    if (dlna instanceof DVDISOFile) {
                        DVDISOFile dvdISOFile = (DVDISOFile)dlna;
                        videoTSHack = dvdISOFile.getFilename().equals(file.getName());
                    }
                    if (!file.getName().equals(name) && !videoTSHack || file.lastModified() != lm) continue;
                    removedFiles.remove(dlna);
                    present = true;
                }
                ++i;
                if (present) continue;
                addedFiles.add(file);
            }
        }
        i = 0;
        if (strings != null) {
            for (String string : strings) {
                present = false;
                for (DLNAResource d : this.getChildren()) {
                    if (i == 0 && (!(d instanceof VirtualFolder) || d instanceof MediaLibraryFolder)) {
                        removedString.add(d);
                    }
                    if (!string.equals(name = d.getName())) continue;
                    removedString.remove(d);
                    present = true;
                }
                ++i;
                if (present) continue;
                addedString.add(string);
            }
        }
        for (DLNAResource dLNAResource : removedFiles) {
            this.getChildren().remove(dLNAResource);
        }
        for (DLNAResource dLNAResource : removedString) {
            this.getChildren().remove(dLNAResource);
        }
        for (File file : addedFiles) {
            if (expectedOutput == 0) {
                this.addChild(new RealFile(file));
                continue;
            }
            if (expectedOutput == 2) {
                this.addChild(new PlaylistFolder(file));
                continue;
            }
            if (expectedOutput != 3) continue;
            this.addChild(new DVDISOFile(file));
        }
        for (String string : addedString) {
            if (expectedOutput != 1) continue;
            String[] sqls2 = new String[this.sqls.length - 1];
            int[] expectedOutputs2 = new int[this.expectedOutputs.length - 1];
            System.arraycopy(this.sqls, 1, sqls2, 0, sqls2.length);
            System.arraycopy(this.expectedOutputs, 1, expectedOutputs2, 0, expectedOutputs2.length);
            this.addChild(new MediaLibraryFolder(string, sqls2, expectedOutputs2));
        }
    }
}

