/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.pms.PMS;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.RealFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistFolder
extends DLNAResource {
    private static final Logger logger = LoggerFactory.getLogger(PlaylistFolder.class);
    private File playlistfile;
    private boolean valid = true;

    public File getPlaylistfile() {
        return this.playlistfile;
    }

    public PlaylistFolder(File f) {
        this.playlistfile = f;
        this.setLastModified(this.playlistfile.lastModified());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public String getName() {
        return this.playlistfile.getName();
    }

    @Override
    public String getSystemName() {
        return this.playlistfile.getName();
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    protected void resolveOnce() {
        if (this.playlistfile.length() < 10000000L) {
            String fileName;
            ArrayList<Entry> entries = new ArrayList<Entry>();
            boolean m3u = false;
            boolean pls = false;
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(this.playlistfile));
                while (!m3u && !pls && (line = br.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#EXTM3U")) {
                        m3u = true;
                        logger.debug("Reading m3u playlist: " + this.playlistfile.getName());
                        continue;
                    }
                    if (line.length() <= 0 || !line.equals("[playlist]")) continue;
                    pls = true;
                    logger.debug("Reading PLS playlist: " + this.playlistfile.getName());
                }
                fileName = null;
                String title = null;
                while ((line = br.readLine()) != null) {
                    line = line.trim();
                    if (pls) {
                        int eq;
                        if (line.length() <= 0 || line.startsWith("#") || (eq = line.indexOf("=")) == -1) continue;
                        String value = line.substring(eq + 1);
                        String var = line.substring(0, eq).toLowerCase();
                        fileName = null;
                        title = null;
                        int index = 0;
                        if (var.startsWith("file")) {
                            index = Integer.valueOf(var.substring(4));
                            fileName = value;
                        } else if (var.startsWith("title")) {
                            index = Integer.valueOf(var.substring(5));
                            title = value;
                        }
                        if (index <= 0) continue;
                        while (entries.size() < index) {
                            entries.add(null);
                        }
                        Entry entry = (Entry)entries.get(index - 1);
                        if (entry == null) {
                            entry = new Entry();
                            entries.set(index - 1, entry);
                        }
                        if (fileName != null) {
                            entry.fileName = fileName;
                        }
                        if (title == null) continue;
                        entry.title = title;
                        continue;
                    }
                    if (!m3u) continue;
                    if (line.startsWith("#EXTINF:")) {
                        if ((line = line.substring(8).trim()).matches("^-?\\d+,.+")) {
                            title = line.substring(line.indexOf(",") + 1).trim();
                            continue;
                        }
                        title = line;
                        continue;
                    }
                    if (line.startsWith("#") || line.matches("^\\s*$")) continue;
                    fileName = line;
                    Entry entry = new Entry();
                    entry.fileName = fileName;
                    entry.title = title;
                    entries.add(entry);
                    title = null;
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (NumberFormatException e) {
                logger.error(null, e);
            }
            catch (IOException e) {
                logger.error(null, e);
            }
            for (Entry entry : entries) {
                if (entry == null) continue;
                fileName = entry.fileName;
                logger.debug("Adding " + (pls ? "PLS " : (m3u ? "M3U " : "")) + "entry: " + entry);
                if (fileName.toLowerCase().startsWith("http://") || fileName.toLowerCase().startsWith("mms://")) continue;
                File en1 = new File(this.playlistfile.getParentFile(), fileName);
                File en2 = new File(fileName);
                if (en1.exists()) {
                    this.addChild(new RealFile(en1, entry.title));
                    this.valid = true;
                    continue;
                }
                if (!en2.exists()) continue;
                this.addChild(new RealFile(en2, entry.title));
                this.valid = true;
            }
            PMS.get().storeFileInCache(this.playlistfile, 16);
            for (DLNAResource r : this.getChildren()) {
                r.resolve();
            }
        }
    }

    private static class Entry {
        public String fileName;
        public String title;

        private Entry() {
        }

        public String toString() {
            return "[" + this.fileName + "," + this.title + "]";
        }
    }
}

