/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import java.io.File;
import java.io.IOException;
import net.pms.util.FileUtil;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TempFolder {
    private static final Logger logger = LoggerFactory.getLogger(TempFolder.class);
    private static final String DEFAULT_TEMP_FOLDER_NAME = "ps3mediaserver";
    private final String userSpecifiedFolder;
    private File tempFolder;

    public TempFolder(String userSpecifiedFolder) {
        this.userSpecifiedFolder = userSpecifiedFolder;
    }

    public synchronized File getTempFolder() throws IOException {
        if (this.tempFolder == null) {
            this.tempFolder = this.getTempFolder(this.userSpecifiedFolder);
        }
        return this.tempFolder;
    }

    private File getTempFolder(String userSpecifiedFolder) throws IOException {
        if (userSpecifiedFolder == null) {
            return TempFolder.getSystemTempFolder();
        }
        try {
            return this.getUserSpecifiedTempFolder(userSpecifiedFolder);
        }
        catch (IOException e) {
            logger.error("Problem with user specified temp directory - using system", e);
            return TempFolder.getSystemTempFolder();
        }
    }

    private File getUserSpecifiedTempFolder(String userSpecifiedFolder) throws IOException {
        if (userSpecifiedFolder != null && userSpecifiedFolder.length() == 0) {
            throw new IOException("Temporary directory path must not be empty if specified");
        }
        File folderFile = new File(userSpecifiedFolder);
        FileUtils.forceMkdir(folderFile);
        TempFolder.assertFolderIsValid(folderFile);
        return folderFile;
    }

    private static File getSystemTempFolder() throws IOException {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        File myTMP = new File(tmp, DEFAULT_TEMP_FOLDER_NAME);
        FileUtils.forceMkdir(myTMP);
        TempFolder.assertFolderIsValid(myTMP);
        return myTMP;
    }

    private static void assertFolderIsValid(File folder) throws IOException {
        if (!folder.isDirectory()) {
            throw new IOException("Temp directory must be a directory: " + folder);
        }
        if (!FileUtil.isDirectoryWritable(folder)) {
            throw new IOException("Temp directory is not writable: " + folder);
        }
    }
}

