/*
 * Decompiled with CFR 0.152.
 */
package jwbroek.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleOptionsToPropertiesParser {
    private static final Logger logger = Logger.getLogger(SimpleOptionsToPropertiesParser.class.getCanonicalName());
    Map<String, List<String>> argumentData = new HashMap<String, List<String>>();

    public SimpleOptionsToPropertiesParser() {
        logger.entering(SimpleOptionsToPropertiesParser.class.getCanonicalName(), "SimpleOptionsToPropertiesParser()");
        logger.exiting(SimpleOptionsToPropertiesParser.class.getCanonicalName(), "SimpleOptionsToPropertiesParser()");
    }

    public void registerOption(String string, String ... stringArray) {
        logger.entering(SimpleOptionsToPropertiesParser.class.getCanonicalName(), "registerOption(String,String[])", new Object[]{string, stringArray});
        this.argumentData.put(string, Arrays.asList(stringArray));
        logger.exiting(SimpleOptionsToPropertiesParser.class.getCanonicalName(), "registerOption(String,String[])");
    }

    public void registerOption(String string, List<String> list) {
        logger.entering(SimpleOptionsToPropertiesParser.class.getCanonicalName(), "registerOption(String,List<String>)", new Object[]{string, list});
        this.argumentData.put(string, list);
        logger.exiting(SimpleOptionsToPropertiesParser.class.getCanonicalName(), "registerOption(String,List<String>)");
    }

    public void registerOption(List<String> list, List<String> list2) {
        logger.entering(SimpleOptionsToPropertiesParser.class.getCanonicalName(), "registerOption(List<String>,List<String>)", new Object[]{list, list2});
        for (String string : list) {
            this.registerOption(string, list2);
        }
        logger.exiting(SimpleOptionsToPropertiesParser.class.getCanonicalName(), "registerOption(List<String>,List<String>)");
    }

    public void registerOption(String[] stringArray, String ... stringArray2) {
        logger.entering(SimpleOptionsToPropertiesParser.class.getCanonicalName(), "registerOption(String[],String [])", new Object[]{stringArray, stringArray2});
        for (String string : stringArray) {
            this.registerOption(string, stringArray2);
        }
        logger.exiting(SimpleOptionsToPropertiesParser.class.getCanonicalName(), "registerOption(String[],String [])");
    }

    public int parseOptions(String[] stringArray, Properties properties) {
        logger.entering(SimpleOptionsToPropertiesParser.class.getCanonicalName(), "registerOption(String[],Properties)", new Object[]{stringArray, properties});
        int n = this.parseOptions(stringArray, 0, stringArray.length, properties);
        logger.exiting(SimpleOptionsToPropertiesParser.class.getCanonicalName(), "registerOption(String[],Properties)", n);
        return n;
    }

    public int parseOptions(String[] stringArray, int n, int n2, Properties properties) {
        logger.entering(SimpleOptionsToPropertiesParser.class.getCanonicalName(), "parseOptions(String[],int,int,Properties)", new Object[]{stringArray, n, n2, properties});
        int n3 = n2;
        for (int i = n; i < n2; ++i) {
            List<String> list = this.argumentData.get(stringArray[i]);
            if (list == null) {
                n3 = i;
                break;
            }
            if (i + list.size() > n2) {
                n3 = -1;
                break;
            }
            if (list.get(0) != null) {
                properties.setProperty(list.get(0), stringArray[i]);
            }
            for (int j = 1; j < list.size(); ++j) {
                properties.setProperty(list.get(j), stringArray[++i]);
            }
        }
        logger.exiting(SimpleOptionsToPropertiesParser.class.getCanonicalName(), "parseOptions(String[],int,int,Properties)", n3);
        return n3;
    }
}

