/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.vfs2.provider.rar;

import com.github.junrar.io.IReadOnlyAccess;
import java.io.IOException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class RandomAccessContentAccess
implements IReadOnlyAccess {
    private final RandomAccessContent rac;

    public RandomAccessContentAccess(RandomAccessContent rac) {
        this.rac = rac;
    }

    public RandomAccessContentAccess(FileObject file) throws FileSystemException {
        this(file.getContent().getRandomAccessContent(RandomAccessMode.READ));
    }

    @Override
    public long getPosition() throws IOException {
        return this.rac.getFilePointer();
    }

    @Override
    public void setPosition(long pos) throws IOException {
        this.rac.seek(pos);
    }

    @Override
    public int read() throws IOException {
        return this.rac.readByte();
    }

    @Override
    public int read(byte[] buffer, int off, int count) throws IOException {
        return this.rac.getInputStream().read(buffer, off, count);
    }

    @Override
    public int readFully(byte[] buffer, int count) throws IOException {
        return this.rac.getInputStream().read(buffer, 0, count);
    }

    @Override
    public void close() throws IOException {
        this.rac.close();
    }
}

