#ifndef GLMOCK_H_
#define GLMOCK_H_

#if defined(_WIN32) || defined(__WIN32__)
   #define WIN32_LEAN_AND_MEAN
   #include <windows.h>
   #include <GL/glew.h>
   #include <GL/wglew.h>
   #include <GL/glu.h>
#elif defined(linux) || defined(__linux) || defined(__FreeBSD__) || defined(__FreeBSD_kernel__)
   #include <GL/glew.h>
   #include <GL/glxew.h>
   #include <GL/glu.h>
#elif defined(__APPLE__) || defined(MACOSX) || defined(macintosh) || defined(Macintosh)
   #include <OpenGL/glew.h>
   #include <OpenGL/glxew.h>
   #include <OpenGL/glu.h>
#endif

class CGLMock {
public:
    MOCK_METHOD2( Accum, void   (GLenum op, GLfloat value) );
    MOCK_METHOD2( AlphaFunc, void   (GLenum func, GLclampf ref) );
    MOCK_METHOD3( AreTexturesResident, GLboolean   (GLsizei n, const GLuint *textures, GLboolean *residences) );
    MOCK_METHOD1( ArrayElement, void   (GLint i) );
    MOCK_METHOD1( Begin, void   (GLenum mode) );
    MOCK_METHOD2( BindTexture, void   (GLenum target, GLuint texture) );
    MOCK_METHOD7( Bitmap, void   (GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap) );
    MOCK_METHOD2( BlendFunc, void   (GLenum sfactor, GLenum dfactor) );
    MOCK_METHOD1( CallList, void   (GLuint list) );
    MOCK_METHOD3( CallLists, void   (GLsizei n, GLenum type, const GLvoid *lists) );
    MOCK_METHOD1( Clear, void   (GLbitfield mask) );
    MOCK_METHOD4( ClearAccum, void   (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) );
    MOCK_METHOD4( ClearColor, void   (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) );
    MOCK_METHOD1( ClearDepth, void   (GLclampd depth) );
    MOCK_METHOD1( ClearIndex, void   (GLfloat c) );
    MOCK_METHOD1( ClearStencil, void   (GLint s) );
    MOCK_METHOD2( ClipPlane, void   (GLenum plane, const GLdouble *equation) );
    MOCK_METHOD3( Color3b, void   (GLbyte red, GLbyte green, GLbyte blue) );
    MOCK_METHOD1( Color3bv, void   (const GLbyte *v) );
    MOCK_METHOD3( Color3d, void   (GLdouble red, GLdouble green, GLdouble blue) );
    MOCK_METHOD1( Color3dv, void   (const GLdouble *v) );
    MOCK_METHOD3( Color3f, void   (GLfloat red, GLfloat green, GLfloat blue) );
    MOCK_METHOD1( Color3fv, void   (const GLfloat *v) );
    MOCK_METHOD3( Color3i, void   (GLint red, GLint green, GLint blue) );
    MOCK_METHOD1( Color3iv, void   (const GLint *v) );
    MOCK_METHOD3( Color3s, void   (GLshort red, GLshort green, GLshort blue) );
    MOCK_METHOD1( Color3sv, void   (const GLshort *v) );
    MOCK_METHOD3( Color3ub, void   (GLubyte red, GLubyte green, GLubyte blue) );
    MOCK_METHOD1( Color3ubv, void   (const GLubyte *v) );
    MOCK_METHOD3( Color3ui, void   (GLuint red, GLuint green, GLuint blue) );
    MOCK_METHOD1( Color3uiv, void   (const GLuint *v) );
    MOCK_METHOD3( Color3us, void   (GLushort red, GLushort green, GLushort blue) );
    MOCK_METHOD1( Color3usv, void   (const GLushort *v) );
    MOCK_METHOD4( Color4b, void   (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha) );
    MOCK_METHOD1( Color4bv, void   (const GLbyte *v) );
    MOCK_METHOD4( Color4d, void   (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha) );
    MOCK_METHOD1( Color4dv, void   (const GLdouble *v) );
    MOCK_METHOD4( Color4f, void   (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) );
    MOCK_METHOD1( Color4fv, void   (const GLfloat *v) );
    MOCK_METHOD4( Color4i, void   (GLint red, GLint green, GLint blue, GLint alpha) );
    MOCK_METHOD1( Color4iv, void   (const GLint *v) );
    MOCK_METHOD4( Color4s, void   (GLshort red, GLshort green, GLshort blue, GLshort alpha) );
    MOCK_METHOD1( Color4sv, void   (const GLshort *v) );
    MOCK_METHOD4( Color4ub, void   (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha) );
    MOCK_METHOD1( Color4ubv, void   (const GLubyte *v) );
    MOCK_METHOD4( Color4ui, void   (GLuint red, GLuint green, GLuint blue, GLuint alpha) );
    MOCK_METHOD1( Color4uiv, void   (const GLuint *v) );
    MOCK_METHOD4( Color4us, void   (GLushort red, GLushort green, GLushort blue, GLushort alpha) );
    MOCK_METHOD1( Color4usv, void   (const GLushort *v) );
    MOCK_METHOD4( ColorMask, void   (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha) );
    MOCK_METHOD2( ColorMaterial, void   (GLenum face, GLenum mode) );
    MOCK_METHOD4( ColorPointer, void   (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) );
    MOCK_METHOD5( CopyPixels, void   (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type) );
    MOCK_METHOD7( CopyTexImage1D, void   (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border) );
    MOCK_METHOD8( CopyTexImage2D, void   (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border) );
    MOCK_METHOD6( CopyTexSubImage1D, void   (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width) );
    MOCK_METHOD8( CopyTexSubImage2D, void   (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) );
    MOCK_METHOD1( CullFace, void   (GLenum mode) );
    MOCK_METHOD2( DeleteLists, void   (GLuint list, GLsizei range) );
    MOCK_METHOD2( DeleteTextures, void   (GLsizei n, const GLuint *textures) );
    MOCK_METHOD1( DepthFunc, void   (GLenum func) );
    MOCK_METHOD1( DepthMask, void   (GLboolean flag) );
    MOCK_METHOD2( DepthRange, void   (GLclampd zNear, GLclampd zFar) );
    MOCK_METHOD1( Disable, void   (GLenum cap) );
    MOCK_METHOD1( DisableClientState, void   (GLenum array) );
    MOCK_METHOD3( DrawArrays, void   (GLenum mode, GLint first, GLsizei count) );
    MOCK_METHOD1( DrawBuffer, void   (GLenum mode) );
    MOCK_METHOD4( DrawElements, void   (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices) );
    MOCK_METHOD5( DrawPixels, void   (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels) );
    MOCK_METHOD1( EdgeFlag, void   (GLboolean flag) );
    MOCK_METHOD2( EdgeFlagPointer, void   (GLsizei stride, const GLvoid *pointer) );
    MOCK_METHOD1( EdgeFlagv, void   (const GLboolean *flag) );
    MOCK_METHOD1( Enable, void   (GLenum cap) );
    MOCK_METHOD1( EnableClientState, void   (GLenum array) );
    MOCK_METHOD0( End, void   (void) );
    MOCK_METHOD0( EndList, void   (void) );
    MOCK_METHOD1( EvalCoord1d, void   (GLdouble u) );
    MOCK_METHOD1( EvalCoord1dv, void   (const GLdouble *u) );
    MOCK_METHOD1( EvalCoord1f, void   (GLfloat u) );
    MOCK_METHOD1( EvalCoord1fv, void   (const GLfloat *u) );
    MOCK_METHOD2( EvalCoord2d, void   (GLdouble u, GLdouble v) );
    MOCK_METHOD1( EvalCoord2dv, void   (const GLdouble *u) );
    MOCK_METHOD2( EvalCoord2f, void   (GLfloat u, GLfloat v) );
    MOCK_METHOD1( EvalCoord2fv, void   (const GLfloat *u) );
    MOCK_METHOD3( EvalMesh1, void   (GLenum mode, GLint i1, GLint i2) );
    MOCK_METHOD5( EvalMesh2, void   (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2) );
    MOCK_METHOD1( EvalPoint1, void   (GLint i) );
    MOCK_METHOD2( EvalPoint2, void   (GLint i, GLint j) );
    MOCK_METHOD3( FeedbackBuffer, void   (GLsizei size, GLenum type, GLfloat *buffer) );
    MOCK_METHOD0( Finish, void   (void) );
    MOCK_METHOD0( Flush, void   (void) );
    MOCK_METHOD2( Fogf, void   (GLenum pname, GLfloat param) );
    MOCK_METHOD2( Fogfv, void   (GLenum pname, const GLfloat *params) );
    MOCK_METHOD2( Fogi, void   (GLenum pname, GLint param) );
    MOCK_METHOD2( Fogiv, void   (GLenum pname, const GLint *params) );
    MOCK_METHOD1( FrontFace, void   (GLenum mode) );
    MOCK_METHOD6( Frustum, void   (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar) );
    MOCK_METHOD1( GenLists, GLuint   (GLsizei range) );
    MOCK_METHOD2( GenTextures, void   (GLsizei n, GLuint *textures) );
    MOCK_METHOD2( GetBooleanv, void   (GLenum pname, GLboolean *params) );
    MOCK_METHOD2( GetClipPlane, void   (GLenum plane, GLdouble *equation) );
    MOCK_METHOD2( GetDoublev, void   (GLenum pname, GLdouble *params) );
    MOCK_METHOD0( GetError, GLenum   (void) );
    MOCK_METHOD2( GetFloatv, void   (GLenum pname, GLfloat *params) );
    MOCK_METHOD2( GetIntegerv, void   (GLenum pname, GLint *params) );
    MOCK_METHOD3( GetLightfv, void   (GLenum light, GLenum pname, GLfloat *params) );
    MOCK_METHOD3( GetLightiv, void   (GLenum light, GLenum pname, GLint *params) );
    MOCK_METHOD3( GetMapdv, void   (GLenum target, GLenum query, GLdouble *v) );
    MOCK_METHOD3( GetMapfv, void   (GLenum target, GLenum query, GLfloat *v) );
    MOCK_METHOD3( GetMapiv, void   (GLenum target, GLenum query, GLint *v) );
    MOCK_METHOD3( GetMaterialfv, void   (GLenum face, GLenum pname, GLfloat *params) );
    MOCK_METHOD3( GetMaterialiv, void   (GLenum face, GLenum pname, GLint *params) );
    MOCK_METHOD2( GetPixelMapfv, void   (GLenum map, GLfloat *values) );
    MOCK_METHOD2( GetPixelMapuiv, void   (GLenum map, GLuint *values) );
    MOCK_METHOD2( GetPixelMapusv, void   (GLenum map, GLushort *values) );
    MOCK_METHOD2( GetPointerv, void   (GLenum pname, GLvoid* *params) );
    MOCK_METHOD1( GetPolygonStipple, void   (GLubyte *mask) );
    MOCK_METHOD1( GetString, const GLubyte *   (GLenum name) );
    MOCK_METHOD3( GetTexEnvfv, void   (GLenum target, GLenum pname, GLfloat *params) );
    MOCK_METHOD3( GetTexEnviv, void   (GLenum target, GLenum pname, GLint *params) );
    MOCK_METHOD3( GetTexGendv, void   (GLenum coord, GLenum pname, GLdouble *params) );
    MOCK_METHOD3( GetTexGenfv, void   (GLenum coord, GLenum pname, GLfloat *params) );
    MOCK_METHOD3( GetTexGeniv, void   (GLenum coord, GLenum pname, GLint *params) );
    MOCK_METHOD5( GetTexImage, void   (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels) );
    MOCK_METHOD4( GetTexLevelParameterfv, void   (GLenum target, GLint level, GLenum pname, GLfloat *params) );
    MOCK_METHOD4( GetTexLevelParameteriv, void   (GLenum target, GLint level, GLenum pname, GLint *params) );
    MOCK_METHOD3( GetTexParameterfv, void   (GLenum target, GLenum pname, GLfloat *params) );
    MOCK_METHOD3( GetTexParameteriv, void   (GLenum target, GLenum pname, GLint *params) );
    MOCK_METHOD2( Hint, void   (GLenum target, GLenum mode) );
    MOCK_METHOD1( IndexMask, void   (GLuint mask) );
    MOCK_METHOD3( IndexPointer, void   (GLenum type, GLsizei stride, const GLvoid *pointer) );
    MOCK_METHOD1( Indexd, void   (GLdouble c) );
    MOCK_METHOD1( Indexdv, void   (const GLdouble *c) );
    MOCK_METHOD1( Indexf, void   (GLfloat c) );
    MOCK_METHOD1( Indexfv, void   (const GLfloat *c) );
    MOCK_METHOD1( Indexi, void   (GLint c) );
    MOCK_METHOD1( Indexiv, void   (const GLint *c) );
    MOCK_METHOD1( Indexs, void   (GLshort c) );
    MOCK_METHOD1( Indexsv, void   (const GLshort *c) );
    MOCK_METHOD1( Indexub, void   (GLubyte c) );
    MOCK_METHOD1( Indexubv, void   (const GLubyte *c) );
    MOCK_METHOD0( InitNames, void   (void) );
    MOCK_METHOD3( InterleavedArrays, void   (GLenum format, GLsizei stride, const GLvoid *pointer) );
    MOCK_METHOD1( IsEnabled, GLboolean   (GLenum cap) );
    MOCK_METHOD1( IsList, GLboolean   (GLuint list) );
    MOCK_METHOD1( IsTexture, GLboolean   (GLuint texture) );
    MOCK_METHOD2( LightModelf, void   (GLenum pname, GLfloat param) );
    MOCK_METHOD2( LightModelfv, void   (GLenum pname, const GLfloat *params) );
    MOCK_METHOD2( LightModeli, void   (GLenum pname, GLint param) );
    MOCK_METHOD2( LightModeliv, void   (GLenum pname, const GLint *params) );
    MOCK_METHOD3( Lightf, void   (GLenum light, GLenum pname, GLfloat param) );
    MOCK_METHOD3( Lightfv, void   (GLenum light, GLenum pname, const GLfloat *params) );
    MOCK_METHOD3( Lighti, void   (GLenum light, GLenum pname, GLint param) );
    MOCK_METHOD3( Lightiv, void   (GLenum light, GLenum pname, const GLint *params) );
    MOCK_METHOD2( LineStipple, void   (GLint factor, GLushort pattern) );
    MOCK_METHOD1( LineWidth, void   (GLfloat width) );
    MOCK_METHOD1( ListBase, void   (GLuint base) );
    MOCK_METHOD0( LoadIdentity, void   (void) );
    MOCK_METHOD1( LoadMatrixd, void   (const GLdouble *m) );
    MOCK_METHOD1( LoadMatrixf, void   (const GLfloat *m) );
    MOCK_METHOD1( LoadName, void   (GLuint name) );
    MOCK_METHOD1( LogicOp, void   (GLenum opcode) );
    MOCK_METHOD6( Map1d, void   (GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points) );
    MOCK_METHOD6( Map1f, void   (GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points) );
    MOCK_METHOD10( Map2d, void   (GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points) );
    MOCK_METHOD10( Map2f, void   (GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points) );
    MOCK_METHOD3( MapGrid1d, void   (GLint un, GLdouble u1, GLdouble u2) );
    MOCK_METHOD3( MapGrid1f, void   (GLint un, GLfloat u1, GLfloat u2) );
    MOCK_METHOD6( MapGrid2d, void   (GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2) );
    MOCK_METHOD6( MapGrid2f, void   (GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2) );
    MOCK_METHOD3( Materialf, void   (GLenum face, GLenum pname, GLfloat param) );
    MOCK_METHOD3( Materialfv, void   (GLenum face, GLenum pname, const GLfloat *params) );
    MOCK_METHOD3( Materiali, void   (GLenum face, GLenum pname, GLint param) );
    MOCK_METHOD3( Materialiv, void   (GLenum face, GLenum pname, const GLint *params) );
    MOCK_METHOD1( MatrixMode, void   (GLenum mode) );
    MOCK_METHOD1( MultMatrixd, void   (const GLdouble *m) );
    MOCK_METHOD1( MultMatrixf, void   (const GLfloat *m) );
    MOCK_METHOD2( NewList, void   (GLuint list, GLenum mode) );
    MOCK_METHOD3( Normal3b, void   (GLbyte nx, GLbyte ny, GLbyte nz) );
    MOCK_METHOD1( Normal3bv, void   (const GLbyte *v) );
    MOCK_METHOD3( Normal3d, void   (GLdouble nx, GLdouble ny, GLdouble nz) );
    MOCK_METHOD1( Normal3dv, void   (const GLdouble *v) );
    MOCK_METHOD3( Normal3f, void   (GLfloat nx, GLfloat ny, GLfloat nz) );
    MOCK_METHOD1( Normal3fv, void   (const GLfloat *v) );
    MOCK_METHOD3( Normal3i, void   (GLint nx, GLint ny, GLint nz) );
    MOCK_METHOD1( Normal3iv, void   (const GLint *v) );
    MOCK_METHOD3( Normal3s, void   (GLshort nx, GLshort ny, GLshort nz) );
    MOCK_METHOD1( Normal3sv, void   (const GLshort *v) );
    MOCK_METHOD3( NormalPointer, void   (GLenum type, GLsizei stride, const GLvoid *pointer) );
    MOCK_METHOD6( Ortho, void   (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar) );
    MOCK_METHOD1( PassThrough, void   (GLfloat token) );
    MOCK_METHOD3( PixelMapfv, void   (GLenum map, GLsizei mapsize, const GLfloat *values) );
    MOCK_METHOD3( PixelMapuiv, void   (GLenum map, GLsizei mapsize, const GLuint *values) );
    MOCK_METHOD3( PixelMapusv, void   (GLenum map, GLsizei mapsize, const GLushort *values) );
    MOCK_METHOD2( PixelStoref, void   (GLenum pname, GLfloat param) );
    MOCK_METHOD2( PixelStorei, void   (GLenum pname, GLint param) );
    MOCK_METHOD2( PixelTransferf, void   (GLenum pname, GLfloat param) );
    MOCK_METHOD2( PixelTransferi, void   (GLenum pname, GLint param) );
    MOCK_METHOD2( PixelZoom, void   (GLfloat xfactor, GLfloat yfactor) );
    MOCK_METHOD1( PointSize, void   (GLfloat size) );
    MOCK_METHOD2( PolygonMode, void   (GLenum face, GLenum mode) );
    MOCK_METHOD2( PolygonOffset, void   (GLfloat factor, GLfloat units) );
    MOCK_METHOD1( PolygonStipple, void   (const GLubyte *mask) );
    MOCK_METHOD0( PopAttrib, void   (void) );
    MOCK_METHOD0( PopClientAttrib, void   (void) );
    MOCK_METHOD0( PopMatrix, void   (void) );
    MOCK_METHOD0( PopName, void   (void) );
    MOCK_METHOD3( PrioritizeTextures, void   (GLsizei n, const GLuint *textures, const GLclampf *priorities) );
    MOCK_METHOD1( PushAttrib, void   (GLbitfield mask) );
    MOCK_METHOD1( PushClientAttrib, void   (GLbitfield mask) );
    MOCK_METHOD0( PushMatrix, void   (void) );
    MOCK_METHOD1( PushName, void   (GLuint name) );
    MOCK_METHOD2( RasterPos2d, void   (GLdouble x, GLdouble y) );
    MOCK_METHOD1( RasterPos2dv, void   (const GLdouble *v) );
    MOCK_METHOD2( RasterPos2f, void   (GLfloat x, GLfloat y) );
    MOCK_METHOD1( RasterPos2fv, void   (const GLfloat *v) );
    MOCK_METHOD2( RasterPos2i, void   (GLint x, GLint y) );
    MOCK_METHOD1( RasterPos2iv, void   (const GLint *v) );
    MOCK_METHOD2( RasterPos2s, void   (GLshort x, GLshort y) );
    MOCK_METHOD1( RasterPos2sv, void   (const GLshort *v) );
    MOCK_METHOD3( RasterPos3d, void   (GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD1( RasterPos3dv, void   (const GLdouble *v) );
    MOCK_METHOD3( RasterPos3f, void   (GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD1( RasterPos3fv, void   (const GLfloat *v) );
    MOCK_METHOD3( RasterPos3i, void   (GLint x, GLint y, GLint z) );
    MOCK_METHOD1( RasterPos3iv, void   (const GLint *v) );
    MOCK_METHOD3( RasterPos3s, void   (GLshort x, GLshort y, GLshort z) );
    MOCK_METHOD1( RasterPos3sv, void   (const GLshort *v) );
    MOCK_METHOD4( RasterPos4d, void   (GLdouble x, GLdouble y, GLdouble z, GLdouble w) );
    MOCK_METHOD1( RasterPos4dv, void   (const GLdouble *v) );
    MOCK_METHOD4( RasterPos4f, void   (GLfloat x, GLfloat y, GLfloat z, GLfloat w) );
    MOCK_METHOD1( RasterPos4fv, void   (const GLfloat *v) );
    MOCK_METHOD4( RasterPos4i, void   (GLint x, GLint y, GLint z, GLint w) );
    MOCK_METHOD1( RasterPos4iv, void   (const GLint *v) );
    MOCK_METHOD4( RasterPos4s, void   (GLshort x, GLshort y, GLshort z, GLshort w) );
    MOCK_METHOD1( RasterPos4sv, void   (const GLshort *v) );
    MOCK_METHOD1( ReadBuffer, void   (GLenum mode) );
    MOCK_METHOD7( ReadPixels, void   (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels) );
    MOCK_METHOD4( Rectd, void   (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2) );
    MOCK_METHOD2( Rectdv, void   (const GLdouble *v1, const GLdouble *v2) );
    MOCK_METHOD4( Rectf, void   (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2) );
    MOCK_METHOD2( Rectfv, void   (const GLfloat *v1, const GLfloat *v2) );
    MOCK_METHOD4( Recti, void   (GLint x1, GLint y1, GLint x2, GLint y2) );
    MOCK_METHOD2( Rectiv, void   (const GLint *v1, const GLint *v2) );
    MOCK_METHOD4( Rects, void   (GLshort x1, GLshort y1, GLshort x2, GLshort y2) );
    MOCK_METHOD2( Rectsv, void   (const GLshort *v1, const GLshort *v2) );
    MOCK_METHOD1( RenderMode, GLint   (GLenum mode) );
    MOCK_METHOD4( Rotated, void   (GLdouble angle, GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD4( Rotatef, void   (GLfloat angle, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD3( Scaled, void   (GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD3( Scalef, void   (GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD4( Scissor, void   (GLint x, GLint y, GLsizei width, GLsizei height) );
    MOCK_METHOD2( SelectBuffer, void   (GLsizei size, GLuint *buffer) );
    MOCK_METHOD1( ShadeModel, void   (GLenum mode) );
    MOCK_METHOD3( StencilFunc, void   (GLenum func, GLint ref, GLuint mask) );
    MOCK_METHOD1( StencilMask, void   (GLuint mask) );
    MOCK_METHOD3( StencilOp, void   (GLenum fail, GLenum zfail, GLenum zpass) );
    MOCK_METHOD1( TexCoord1d, void   (GLdouble s) );
    MOCK_METHOD1( TexCoord1dv, void   (const GLdouble *v) );
    MOCK_METHOD1( TexCoord1f, void   (GLfloat s) );
    MOCK_METHOD1( TexCoord1fv, void   (const GLfloat *v) );
    MOCK_METHOD1( TexCoord1i, void   (GLint s) );
    MOCK_METHOD1( TexCoord1iv, void   (const GLint *v) );
    MOCK_METHOD1( TexCoord1s, void   (GLshort s) );
    MOCK_METHOD1( TexCoord1sv, void   (const GLshort *v) );
    MOCK_METHOD2( TexCoord2d, void   (GLdouble s, GLdouble t) );
    MOCK_METHOD1( TexCoord2dv, void   (const GLdouble *v) );
    MOCK_METHOD2( TexCoord2f, void   (GLfloat s, GLfloat t) );
    MOCK_METHOD1( TexCoord2fv, void   (const GLfloat *v) );
    MOCK_METHOD2( TexCoord2i, void   (GLint s, GLint t) );
    MOCK_METHOD1( TexCoord2iv, void   (const GLint *v) );
    MOCK_METHOD2( TexCoord2s, void   (GLshort s, GLshort t) );
    MOCK_METHOD1( TexCoord2sv, void   (const GLshort *v) );
    MOCK_METHOD3( TexCoord3d, void   (GLdouble s, GLdouble t, GLdouble r) );
    MOCK_METHOD1( TexCoord3dv, void   (const GLdouble *v) );
    MOCK_METHOD3( TexCoord3f, void   (GLfloat s, GLfloat t, GLfloat r) );
    MOCK_METHOD1( TexCoord3fv, void   (const GLfloat *v) );
    MOCK_METHOD3( TexCoord3i, void   (GLint s, GLint t, GLint r) );
    MOCK_METHOD1( TexCoord3iv, void   (const GLint *v) );
    MOCK_METHOD3( TexCoord3s, void   (GLshort s, GLshort t, GLshort r) );
    MOCK_METHOD1( TexCoord3sv, void   (const GLshort *v) );
    MOCK_METHOD4( TexCoord4d, void   (GLdouble s, GLdouble t, GLdouble r, GLdouble q) );
    MOCK_METHOD1( TexCoord4dv, void   (const GLdouble *v) );
    MOCK_METHOD4( TexCoord4f, void   (GLfloat s, GLfloat t, GLfloat r, GLfloat q) );
    MOCK_METHOD1( TexCoord4fv, void   (const GLfloat *v) );
    MOCK_METHOD4( TexCoord4i, void   (GLint s, GLint t, GLint r, GLint q) );
    MOCK_METHOD1( TexCoord4iv, void   (const GLint *v) );
    MOCK_METHOD4( TexCoord4s, void   (GLshort s, GLshort t, GLshort r, GLshort q) );
    MOCK_METHOD1( TexCoord4sv, void   (const GLshort *v) );
    MOCK_METHOD4( TexCoordPointer, void   (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) );
    MOCK_METHOD3( TexEnvf, void   (GLenum target, GLenum pname, GLfloat param) );
    MOCK_METHOD3( TexEnvfv, void   (GLenum target, GLenum pname, const GLfloat *params) );
    MOCK_METHOD3( TexEnvi, void   (GLenum target, GLenum pname, GLint param) );
    MOCK_METHOD3( TexEnviv, void   (GLenum target, GLenum pname, const GLint *params) );
    MOCK_METHOD3( TexGend, void   (GLenum coord, GLenum pname, GLdouble param) );
    MOCK_METHOD3( TexGendv, void   (GLenum coord, GLenum pname, const GLdouble *params) );
    MOCK_METHOD3( TexGenf, void   (GLenum coord, GLenum pname, GLfloat param) );
    MOCK_METHOD3( TexGenfv, void   (GLenum coord, GLenum pname, const GLfloat *params) );
    MOCK_METHOD3( TexGeni, void   (GLenum coord, GLenum pname, GLint param) );
    MOCK_METHOD3( TexGeniv, void   (GLenum coord, GLenum pname, const GLint *params) );
    MOCK_METHOD8( TexImage1D, void   (GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels) );
    MOCK_METHOD9( TexImage2D, void   (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels) );
    MOCK_METHOD3( TexParameterf, void   (GLenum target, GLenum pname, GLfloat param) );
    MOCK_METHOD3( TexParameterfv, void   (GLenum target, GLenum pname, const GLfloat *params) );
    MOCK_METHOD3( TexParameteri, void   (GLenum target, GLenum pname, GLint param) );
    MOCK_METHOD3( TexParameteriv, void   (GLenum target, GLenum pname, const GLint *params) );
    MOCK_METHOD7( TexSubImage1D, void   (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels) );
    MOCK_METHOD9( TexSubImage2D, void   (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels) );
    MOCK_METHOD3( Translated, void   (GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD3( Translatef, void   (GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD2( Vertex2d, void   (GLdouble x, GLdouble y) );
    MOCK_METHOD1( Vertex2dv, void   (const GLdouble *v) );
    MOCK_METHOD2( Vertex2f, void   (GLfloat x, GLfloat y) );
    MOCK_METHOD1( Vertex2fv, void   (const GLfloat *v) );
    MOCK_METHOD2( Vertex2i, void   (GLint x, GLint y) );
    MOCK_METHOD1( Vertex2iv, void   (const GLint *v) );
    MOCK_METHOD2( Vertex2s, void   (GLshort x, GLshort y) );
    MOCK_METHOD1( Vertex2sv, void   (const GLshort *v) );
    MOCK_METHOD3( Vertex3d, void   (GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD1( Vertex3dv, void   (const GLdouble *v) );
    MOCK_METHOD3( Vertex3f, void   (GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD1( Vertex3fv, void   (const GLfloat *v) );
    MOCK_METHOD3( Vertex3i, void   (GLint x, GLint y, GLint z) );
    MOCK_METHOD1( Vertex3iv, void   (const GLint *v) );
    MOCK_METHOD3( Vertex3s, void   (GLshort x, GLshort y, GLshort z) );
    MOCK_METHOD1( Vertex3sv, void   (const GLshort *v) );
    MOCK_METHOD4( Vertex4d, void   (GLdouble x, GLdouble y, GLdouble z, GLdouble w) );
    MOCK_METHOD1( Vertex4dv, void   (const GLdouble *v) );
    MOCK_METHOD4( Vertex4f, void   (GLfloat x, GLfloat y, GLfloat z, GLfloat w) );
    MOCK_METHOD1( Vertex4fv, void   (const GLfloat *v) );
    MOCK_METHOD4( Vertex4i, void   (GLint x, GLint y, GLint z, GLint w) );
    MOCK_METHOD1( Vertex4iv, void   (const GLint *v) );
    MOCK_METHOD4( Vertex4s, void   (GLshort x, GLshort y, GLshort z, GLshort w) );
    MOCK_METHOD1( Vertex4sv, void   (const GLshort *v) );
    MOCK_METHOD4( VertexPointer, void   (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) );
    MOCK_METHOD4( Viewport, void   (GLint x, GLint y, GLsizei width, GLsizei height) );
    MOCK_METHOD9( CopyTexSubImage3D, void  (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) );
    MOCK_METHOD6( DrawRangeElements, void  (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices) );
    MOCK_METHOD10( TexImage3D, void  (GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels) );
    MOCK_METHOD11( TexSubImage3D, void  (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels) );
    MOCK_METHOD1( ActiveTexture, void  (GLenum texture) );
    MOCK_METHOD1( ClientActiveTexture, void  (GLenum texture) );
    MOCK_METHOD7( CompressedTexImage1D, void  (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data) );
    MOCK_METHOD8( CompressedTexImage2D, void  (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data) );
    MOCK_METHOD9( CompressedTexImage3D, void  (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data) );
    MOCK_METHOD7( CompressedTexSubImage1D, void  (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data) );
    MOCK_METHOD9( CompressedTexSubImage2D, void  (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data) );
    MOCK_METHOD11( CompressedTexSubImage3D, void  (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data) );
    MOCK_METHOD3( GetCompressedTexImage, void  (GLenum target, GLint lod, GLvoid *img) );
    MOCK_METHOD1( LoadTransposeMatrixd, void  (const GLdouble m[16]) );
    MOCK_METHOD1( LoadTransposeMatrixf, void  (const GLfloat m[16]) );
    MOCK_METHOD1( MultTransposeMatrixd, void  (const GLdouble m[16]) );
    MOCK_METHOD1( MultTransposeMatrixf, void  (const GLfloat m[16]) );
    MOCK_METHOD2( MultiTexCoord1d, void  (GLenum target, GLdouble s) );
    MOCK_METHOD2( MultiTexCoord1dv, void  (GLenum target, const GLdouble *v) );
    MOCK_METHOD2( MultiTexCoord1f, void  (GLenum target, GLfloat s) );
    MOCK_METHOD2( MultiTexCoord1fv, void  (GLenum target, const GLfloat *v) );
    MOCK_METHOD2( MultiTexCoord1i, void  (GLenum target, GLint s) );
    MOCK_METHOD2( MultiTexCoord1iv, void  (GLenum target, const GLint *v) );
    MOCK_METHOD2( MultiTexCoord1s, void  (GLenum target, GLshort s) );
    MOCK_METHOD2( MultiTexCoord1sv, void  (GLenum target, const GLshort *v) );
    MOCK_METHOD3( MultiTexCoord2d, void  (GLenum target, GLdouble s, GLdouble t) );
    MOCK_METHOD2( MultiTexCoord2dv, void  (GLenum target, const GLdouble *v) );
    MOCK_METHOD3( MultiTexCoord2f, void  (GLenum target, GLfloat s, GLfloat t) );
    MOCK_METHOD2( MultiTexCoord2fv, void  (GLenum target, const GLfloat *v) );
    MOCK_METHOD3( MultiTexCoord2i, void  (GLenum target, GLint s, GLint t) );
    MOCK_METHOD2( MultiTexCoord2iv, void  (GLenum target, const GLint *v) );
    MOCK_METHOD3( MultiTexCoord2s, void  (GLenum target, GLshort s, GLshort t) );
    MOCK_METHOD2( MultiTexCoord2sv, void  (GLenum target, const GLshort *v) );
    MOCK_METHOD4( MultiTexCoord3d, void  (GLenum target, GLdouble s, GLdouble t, GLdouble r) );
    MOCK_METHOD2( MultiTexCoord3dv, void  (GLenum target, const GLdouble *v) );
    MOCK_METHOD4( MultiTexCoord3f, void  (GLenum target, GLfloat s, GLfloat t, GLfloat r) );
    MOCK_METHOD2( MultiTexCoord3fv, void  (GLenum target, const GLfloat *v) );
    MOCK_METHOD4( MultiTexCoord3i, void  (GLenum target, GLint s, GLint t, GLint r) );
    MOCK_METHOD2( MultiTexCoord3iv, void  (GLenum target, const GLint *v) );
    MOCK_METHOD4( MultiTexCoord3s, void  (GLenum target, GLshort s, GLshort t, GLshort r) );
    MOCK_METHOD2( MultiTexCoord3sv, void  (GLenum target, const GLshort *v) );
    MOCK_METHOD5( MultiTexCoord4d, void  (GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q) );
    MOCK_METHOD2( MultiTexCoord4dv, void  (GLenum target, const GLdouble *v) );
    MOCK_METHOD5( MultiTexCoord4f, void  (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q) );
    MOCK_METHOD2( MultiTexCoord4fv, void  (GLenum target, const GLfloat *v) );
    MOCK_METHOD5( MultiTexCoord4i, void  (GLenum target, GLint s, GLint t, GLint r, GLint q) );
    MOCK_METHOD2( MultiTexCoord4iv, void  (GLenum target, const GLint *v) );
    MOCK_METHOD5( MultiTexCoord4s, void  (GLenum target, GLshort s, GLshort t, GLshort r, GLshort q) );
    MOCK_METHOD2( MultiTexCoord4sv, void  (GLenum target, const GLshort *v) );
    MOCK_METHOD2( SampleCoverage, void  (GLclampf value, GLboolean invert) );
    MOCK_METHOD4( BlendColor, void  (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) );
    MOCK_METHOD1( BlendEquation, void  (GLenum mode) );
    MOCK_METHOD4( BlendFuncSeparate, void  (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha) );
    MOCK_METHOD3( FogCoordPointer, void  (GLenum type, GLsizei stride, const GLvoid *pointer) );
    MOCK_METHOD1( FogCoordd, void  (GLdouble coord) );
    MOCK_METHOD1( FogCoorddv, void  (const GLdouble *coord) );
    MOCK_METHOD1( FogCoordf, void  (GLfloat coord) );
    MOCK_METHOD1( FogCoordfv, void  (const GLfloat *coord) );
    MOCK_METHOD4( MultiDrawArrays, void  (GLenum mode, GLint *first, GLsizei *count, GLsizei primcount) );
    MOCK_METHOD5( MultiDrawElements, void  (GLenum mode, GLsizei *count, GLenum type, const GLvoid **indices, GLsizei primcount) );
    MOCK_METHOD2( PointParameterf, void  (GLenum pname, GLfloat param) );
    MOCK_METHOD2( PointParameterfv, void  (GLenum pname, const GLfloat *params) );
    MOCK_METHOD2( PointParameteri, void  (GLenum pname, GLint param) );
    MOCK_METHOD2( PointParameteriv, void  (GLenum pname, const GLint *params) );
    MOCK_METHOD3( SecondaryColor3b, void  (GLbyte red, GLbyte green, GLbyte blue) );
    MOCK_METHOD1( SecondaryColor3bv, void  (const GLbyte *v) );
    MOCK_METHOD3( SecondaryColor3d, void  (GLdouble red, GLdouble green, GLdouble blue) );
    MOCK_METHOD1( SecondaryColor3dv, void  (const GLdouble *v) );
    MOCK_METHOD3( SecondaryColor3f, void  (GLfloat red, GLfloat green, GLfloat blue) );
    MOCK_METHOD1( SecondaryColor3fv, void  (const GLfloat *v) );
    MOCK_METHOD3( SecondaryColor3i, void  (GLint red, GLint green, GLint blue) );
    MOCK_METHOD1( SecondaryColor3iv, void  (const GLint *v) );
    MOCK_METHOD3( SecondaryColor3s, void  (GLshort red, GLshort green, GLshort blue) );
    MOCK_METHOD1( SecondaryColor3sv, void  (const GLshort *v) );
    MOCK_METHOD3( SecondaryColor3ub, void  (GLubyte red, GLubyte green, GLubyte blue) );
    MOCK_METHOD1( SecondaryColor3ubv, void  (const GLubyte *v) );
    MOCK_METHOD3( SecondaryColor3ui, void  (GLuint red, GLuint green, GLuint blue) );
    MOCK_METHOD1( SecondaryColor3uiv, void  (const GLuint *v) );
    MOCK_METHOD3( SecondaryColor3us, void  (GLushort red, GLushort green, GLushort blue) );
    MOCK_METHOD1( SecondaryColor3usv, void  (const GLushort *v) );
    MOCK_METHOD4( SecondaryColorPointer, void  (GLint size, GLenum type, GLsizei stride, GLvoid *pointer) );
    MOCK_METHOD2( WindowPos2d, void  (GLdouble x, GLdouble y) );
    MOCK_METHOD1( WindowPos2dv, void  (const GLdouble *p) );
    MOCK_METHOD2( WindowPos2f, void  (GLfloat x, GLfloat y) );
    MOCK_METHOD1( WindowPos2fv, void  (const GLfloat *p) );
    MOCK_METHOD2( WindowPos2i, void  (GLint x, GLint y) );
    MOCK_METHOD1( WindowPos2iv, void  (const GLint *p) );
    MOCK_METHOD2( WindowPos2s, void  (GLshort x, GLshort y) );
    MOCK_METHOD1( WindowPos2sv, void  (const GLshort *p) );
    MOCK_METHOD3( WindowPos3d, void  (GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD1( WindowPos3dv, void  (const GLdouble *p) );
    MOCK_METHOD3( WindowPos3f, void  (GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD1( WindowPos3fv, void  (const GLfloat *p) );
    MOCK_METHOD3( WindowPos3i, void  (GLint x, GLint y, GLint z) );
    MOCK_METHOD1( WindowPos3iv, void  (const GLint *p) );
    MOCK_METHOD3( WindowPos3s, void  (GLshort x, GLshort y, GLshort z) );
    MOCK_METHOD1( WindowPos3sv, void  (const GLshort *p) );
    MOCK_METHOD2( BeginQuery, void  (GLenum target, GLuint id) );
    MOCK_METHOD2( BindBuffer, void  (GLenum target, GLuint buffer) );
    MOCK_METHOD4( BufferData, void  (GLenum target, GLsizeiptr size, const GLvoid* data, GLenum usage) );
    MOCK_METHOD4( BufferSubData, void  (GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid* data) );
    MOCK_METHOD2( DeleteBuffers, void  (GLsizei n, const GLuint* buffers) );
    MOCK_METHOD2( DeleteQueries, void  (GLsizei n, const GLuint* ids) );
    MOCK_METHOD1( EndQuery, void  (GLenum target) );
    MOCK_METHOD2( GenBuffers, void  (GLsizei n, GLuint* buffers) );
    MOCK_METHOD2( GenQueries, void  (GLsizei n, GLuint* ids) );
    MOCK_METHOD3( GetBufferParameteriv, void  (GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetBufferPointerv, void  (GLenum target, GLenum pname, GLvoid** params) );
    MOCK_METHOD4( GetBufferSubData, void  (GLenum target, GLintptr offset, GLsizeiptr size, GLvoid* data) );
    MOCK_METHOD3( GetQueryObjectiv, void  (GLuint id, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetQueryObjectuiv, void  (GLuint id, GLenum pname, GLuint* params) );
    MOCK_METHOD3( GetQueryiv, void  (GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD1( IsBuffer, GLboolean  (GLuint buffer) );
    MOCK_METHOD1( IsQuery, GLboolean  (GLuint id) );
    MOCK_METHOD2( MapBuffer, GLvoid*  (GLenum target, GLenum access) );
    MOCK_METHOD1( UnmapBuffer, GLboolean  (GLenum target) );
    MOCK_METHOD2( AttachShader, void  (GLuint program, GLuint shader) );
    MOCK_METHOD3( BindAttribLocation, void  (GLuint program, GLuint index, const GLchar* name) );
    MOCK_METHOD2( BlendEquationSeparate, void  (GLenum, GLenum) );
    MOCK_METHOD1( CompileShader, void  (GLuint shader) );
    MOCK_METHOD0( CreateProgram, GLuint  (void) );
    MOCK_METHOD1( CreateShader, GLuint  (GLenum type) );
    MOCK_METHOD1( DeleteProgram, void  (GLuint program) );
    MOCK_METHOD1( DeleteShader, void  (GLuint shader) );
    MOCK_METHOD2( DetachShader, void  (GLuint program, GLuint shader) );
    MOCK_METHOD1( DisableVertexAttribArray, void  (GLuint) );
    MOCK_METHOD2( DrawBuffers, void  (GLsizei n, const GLenum* bufs) );
    MOCK_METHOD1( EnableVertexAttribArray, void  (GLuint) );
    MOCK_METHOD7( GetActiveAttrib, void  (GLuint program, GLuint index, GLsizei maxLength, GLsizei* length, GLint* size, GLenum* type, GLchar* name) );
    MOCK_METHOD7( GetActiveUniform, void  (GLuint program, GLuint index, GLsizei maxLength, GLsizei* length, GLint* size, GLenum* type, GLchar* name) );
    MOCK_METHOD4( GetAttachedShaders, void  (GLuint program, GLsizei maxCount, GLsizei* count, GLuint* shaders) );
    MOCK_METHOD2( GetAttribLocation, GLint  (GLuint program, const GLchar* name) );
    MOCK_METHOD4( GetProgramInfoLog, void  (GLuint program, GLsizei bufSize, GLsizei* length, GLchar* infoLog) );
    MOCK_METHOD3( GetProgramiv, void  (GLuint program, GLenum pname, GLint* param) );
    MOCK_METHOD4( GetShaderInfoLog, void  (GLuint shader, GLsizei bufSize, GLsizei* length, GLchar* infoLog) );
    MOCK_METHOD4( GetShaderSource, void  (GLint obj, GLsizei maxLength, GLsizei* length, GLchar* source) );
    MOCK_METHOD3( GetShaderiv, void  (GLuint shader, GLenum pname, GLint* param) );
    MOCK_METHOD2( GetUniformLocation, GLint  (GLuint program, const GLchar* name) );
    MOCK_METHOD3( GetUniformfv, void  (GLuint program, GLint location, GLfloat* params) );
    MOCK_METHOD3( GetUniformiv, void  (GLuint program, GLint location, GLint* params) );
    MOCK_METHOD3( GetVertexAttribPointerv, void  (GLuint, GLenum, GLvoid*) );
    MOCK_METHOD3( GetVertexAttribdv, void  (GLuint, GLenum, GLdouble*) );
    MOCK_METHOD3( GetVertexAttribfv, void  (GLuint, GLenum, GLfloat*) );
    MOCK_METHOD3( GetVertexAttribiv, void  (GLuint, GLenum, GLint*) );
    MOCK_METHOD1( IsProgram, GLboolean  (GLuint program) );
    MOCK_METHOD1( IsShader, GLboolean  (GLuint shader) );
    MOCK_METHOD1( LinkProgram, void  (GLuint program) );
    MOCK_METHOD4( ShaderSource, void  (GLuint shader, GLsizei count, const GLchar** strings, const GLint* lengths) );
    MOCK_METHOD4( StencilFuncSeparate, void  (GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask) );
    MOCK_METHOD2( StencilMaskSeparate, void  (GLenum, GLuint) );
    MOCK_METHOD4( StencilOpSeparate, void  (GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass) );
    MOCK_METHOD2( Uniform1f, void  (GLint location, GLfloat v0) );
    MOCK_METHOD3( Uniform1fv, void  (GLint location, GLsizei count, const GLfloat* value) );
    MOCK_METHOD2( Uniform1i, void  (GLint location, GLint v0) );
    MOCK_METHOD3( Uniform1iv, void  (GLint location, GLsizei count, const GLint* value) );
    MOCK_METHOD3( Uniform2f, void  (GLint location, GLfloat v0, GLfloat v1) );
    MOCK_METHOD3( Uniform2fv, void  (GLint location, GLsizei count, const GLfloat* value) );
    MOCK_METHOD3( Uniform2i, void  (GLint location, GLint v0, GLint v1) );
    MOCK_METHOD3( Uniform2iv, void  (GLint location, GLsizei count, const GLint* value) );
    MOCK_METHOD4( Uniform3f, void  (GLint location, GLfloat v0, GLfloat v1, GLfloat v2) );
    MOCK_METHOD3( Uniform3fv, void  (GLint location, GLsizei count, const GLfloat* value) );
    MOCK_METHOD4( Uniform3i, void  (GLint location, GLint v0, GLint v1, GLint v2) );
    MOCK_METHOD3( Uniform3iv, void  (GLint location, GLsizei count, const GLint* value) );
    MOCK_METHOD5( Uniform4f, void  (GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3) );
    MOCK_METHOD3( Uniform4fv, void  (GLint location, GLsizei count, const GLfloat* value) );
    MOCK_METHOD5( Uniform4i, void  (GLint location, GLint v0, GLint v1, GLint v2, GLint v3) );
    MOCK_METHOD3( Uniform4iv, void  (GLint location, GLsizei count, const GLint* value) );
    MOCK_METHOD4( UniformMatrix2fv, void  (GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) );
    MOCK_METHOD4( UniformMatrix3fv, void  (GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) );
    MOCK_METHOD4( UniformMatrix4fv, void  (GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) );
    MOCK_METHOD1( UseProgram, void  (GLuint program) );
    MOCK_METHOD1( ValidateProgram, void  (GLuint program) );
    MOCK_METHOD2( VertexAttrib1d, void  (GLuint index, GLdouble x) );
    MOCK_METHOD2( VertexAttrib1dv, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD2( VertexAttrib1f, void  (GLuint index, GLfloat x) );
    MOCK_METHOD2( VertexAttrib1fv, void  (GLuint index, const GLfloat* v) );
    MOCK_METHOD2( VertexAttrib1s, void  (GLuint index, GLshort x) );
    MOCK_METHOD2( VertexAttrib1sv, void  (GLuint index, const GLshort* v) );
    MOCK_METHOD3( VertexAttrib2d, void  (GLuint index, GLdouble x, GLdouble y) );
    MOCK_METHOD2( VertexAttrib2dv, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD3( VertexAttrib2f, void  (GLuint index, GLfloat x, GLfloat y) );
    MOCK_METHOD2( VertexAttrib2fv, void  (GLuint index, const GLfloat* v) );
    MOCK_METHOD3( VertexAttrib2s, void  (GLuint index, GLshort x, GLshort y) );
    MOCK_METHOD2( VertexAttrib2sv, void  (GLuint index, const GLshort* v) );
    MOCK_METHOD4( VertexAttrib3d, void  (GLuint index, GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD2( VertexAttrib3dv, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD4( VertexAttrib3f, void  (GLuint index, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD2( VertexAttrib3fv, void  (GLuint index, const GLfloat* v) );
    MOCK_METHOD4( VertexAttrib3s, void  (GLuint index, GLshort x, GLshort y, GLshort z) );
    MOCK_METHOD2( VertexAttrib3sv, void  (GLuint index, const GLshort* v) );
    MOCK_METHOD2( VertexAttrib4Nbv, void  (GLuint index, const GLbyte* v) );
    MOCK_METHOD2( VertexAttrib4Niv, void  (GLuint index, const GLint* v) );
    MOCK_METHOD2( VertexAttrib4Nsv, void  (GLuint index, const GLshort* v) );
    MOCK_METHOD5( VertexAttrib4Nub, void  (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) );
    MOCK_METHOD2( VertexAttrib4Nubv, void  (GLuint index, const GLubyte* v) );
    MOCK_METHOD2( VertexAttrib4Nuiv, void  (GLuint index, const GLuint* v) );
    MOCK_METHOD2( VertexAttrib4Nusv, void  (GLuint index, const GLushort* v) );
    MOCK_METHOD2( VertexAttrib4bv, void  (GLuint index, const GLbyte* v) );
    MOCK_METHOD5( VertexAttrib4d, void  (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) );
    MOCK_METHOD2( VertexAttrib4dv, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD5( VertexAttrib4f, void  (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) );
    MOCK_METHOD2( VertexAttrib4fv, void  (GLuint index, const GLfloat* v) );
    MOCK_METHOD2( VertexAttrib4iv, void  (GLuint index, const GLint* v) );
    MOCK_METHOD5( VertexAttrib4s, void  (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w) );
    MOCK_METHOD2( VertexAttrib4sv, void  (GLuint index, const GLshort* v) );
    MOCK_METHOD2( VertexAttrib4ubv, void  (GLuint index, const GLubyte* v) );
    MOCK_METHOD2( VertexAttrib4uiv, void  (GLuint index, const GLuint* v) );
    MOCK_METHOD2( VertexAttrib4usv, void  (GLuint index, const GLushort* v) );
    MOCK_METHOD6( VertexAttribPointer, void  (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid* pointer) );
    MOCK_METHOD4( UniformMatrix2x3fv, void  (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) );
    MOCK_METHOD4( UniformMatrix2x4fv, void  (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) );
    MOCK_METHOD4( UniformMatrix3x2fv, void  (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) );
    MOCK_METHOD4( UniformMatrix3x4fv, void  (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) );
    MOCK_METHOD4( UniformMatrix4x2fv, void  (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) );
    MOCK_METHOD4( UniformMatrix4x3fv, void  (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) );
    MOCK_METHOD2( BeginConditionalRender, void  (GLuint, GLenum) );
    MOCK_METHOD1( BeginTransformFeedback, void  (GLenum) );
    MOCK_METHOD3( BindFragDataLocation, void  (GLuint, GLuint, const GLchar*) );
    MOCK_METHOD2( ClampColor, void  (GLenum, GLenum) );
    MOCK_METHOD4( ClearBufferfi, void  (GLenum, GLint, GLfloat, GLint) );
    MOCK_METHOD3( ClearBufferfv, void  (GLenum, GLint, const GLfloat*) );
    MOCK_METHOD3( ClearBufferiv, void  (GLenum, GLint, const GLint*) );
    MOCK_METHOD3( ClearBufferuiv, void  (GLenum, GLint, const GLuint*) );
    MOCK_METHOD5( ColorMaski, void  (GLuint, GLboolean, GLboolean, GLboolean, GLboolean) );
    MOCK_METHOD2( Disablei, void  (GLenum, GLuint) );
    MOCK_METHOD2( Enablei, void  (GLenum, GLuint) );
    MOCK_METHOD0( EndConditionalRender, void  (void) );
    MOCK_METHOD0( EndTransformFeedback, void  (void) );
    MOCK_METHOD3( GetBooleani_v, void  (GLenum, GLuint, GLboolean*) );
    MOCK_METHOD2( GetFragDataLocation, GLint  (GLuint, const GLchar*) );
    MOCK_METHOD2( GetStringi, const GLubyte*  (GLenum, GLuint) );
    MOCK_METHOD3( GetTexParameterIiv, void  (GLenum, GLenum, GLint*) );
    MOCK_METHOD3( GetTexParameterIuiv, void  (GLenum, GLenum, GLuint*) );
    MOCK_METHOD3( GetTransformFeedbackVarying, void  (GLuint, GLuint, GLint*) );
    MOCK_METHOD3( GetUniformuiv, void  (GLuint, GLint, GLuint*) );
    MOCK_METHOD3( GetVertexAttribIiv, void  (GLuint, GLenum, GLint*) );
    MOCK_METHOD3( GetVertexAttribIuiv, void  (GLuint, GLenum, GLuint*) );
    MOCK_METHOD2( IsEnabledi, GLboolean  (GLenum, GLuint) );
    MOCK_METHOD3( TexParameterIiv, void  (GLenum, GLenum, const GLint*) );
    MOCK_METHOD3( TexParameterIuiv, void  (GLenum, GLenum, const GLuint*) );
    MOCK_METHOD4( TransformFeedbackVaryings, void  (GLuint, GLsizei, const GLchar **, GLenum) );
    MOCK_METHOD2( Uniform1ui, void  (GLint, GLuint) );
    MOCK_METHOD3( Uniform1uiv, void  (GLint, GLsizei, const GLuint*) );
    MOCK_METHOD3( Uniform2ui, void  (GLint, GLuint, GLuint) );
    MOCK_METHOD3( Uniform2uiv, void  (GLint, GLsizei, const GLuint*) );
    MOCK_METHOD4( Uniform3ui, void  (GLint, GLuint, GLuint, GLuint) );
    MOCK_METHOD3( Uniform3uiv, void  (GLint, GLsizei, const GLuint*) );
    MOCK_METHOD5( Uniform4ui, void  (GLint, GLuint, GLuint, GLuint, GLuint) );
    MOCK_METHOD3( Uniform4uiv, void  (GLint, GLsizei, const GLuint*) );
    MOCK_METHOD2( VertexAttribI1i, void  (GLuint, GLint) );
    MOCK_METHOD2( VertexAttribI1iv, void  (GLuint, const GLint*) );
    MOCK_METHOD2( VertexAttribI1ui, void  (GLuint, GLuint) );
    MOCK_METHOD2( VertexAttribI1uiv, void  (GLuint, const GLuint*) );
    MOCK_METHOD3( VertexAttribI2i, void  (GLuint, GLint, GLint) );
    MOCK_METHOD2( VertexAttribI2iv, void  (GLuint, const GLint*) );
    MOCK_METHOD3( VertexAttribI2ui, void  (GLuint, GLuint, GLuint) );
    MOCK_METHOD2( VertexAttribI2uiv, void  (GLuint, const GLuint*) );
    MOCK_METHOD4( VertexAttribI3i, void  (GLuint, GLint, GLint, GLint) );
    MOCK_METHOD2( VertexAttribI3iv, void  (GLuint, const GLint*) );
    MOCK_METHOD4( VertexAttribI3ui, void  (GLuint, GLuint, GLuint, GLuint) );
    MOCK_METHOD2( VertexAttribI3uiv, void  (GLuint, const GLuint*) );
    MOCK_METHOD2( VertexAttribI4bv, void  (GLuint, const GLbyte*) );
    MOCK_METHOD5( VertexAttribI4i, void  (GLuint, GLint, GLint, GLint, GLint) );
    MOCK_METHOD2( VertexAttribI4iv, void  (GLuint, const GLint*) );
    MOCK_METHOD2( VertexAttribI4sv, void  (GLuint, const GLshort*) );
    MOCK_METHOD2( VertexAttribI4ubv, void  (GLuint, const GLubyte*) );
    MOCK_METHOD5( VertexAttribI4ui, void  (GLuint, GLuint, GLuint, GLuint, GLuint) );
    MOCK_METHOD2( VertexAttribI4uiv, void  (GLuint, const GLuint*) );
    MOCK_METHOD2( VertexAttribI4usv, void  (GLuint, const GLushort*) );
    MOCK_METHOD5( VertexAttribIPointer, void  (GLuint, GLint, GLenum, GLsizei, const GLvoid*) );
    MOCK_METHOD4( DrawArraysInstanced, void  (GLenum, GLint, GLsizei, GLsizei) );
    MOCK_METHOD5( DrawElementsInstanced, void  (GLenum, GLsizei, GLenum, const GLvoid*, GLsizei) );
    MOCK_METHOD1( PrimitiveRestartIndex, void  (GLuint) );
    MOCK_METHOD3( TexBuffer, void  (GLenum, GLenum, GLuint) );
    MOCK_METHOD4( FramebufferTexture, void  (GLenum, GLenum, GLuint, GLint) );
    MOCK_METHOD3( GetBufferParameteri64v, void  (GLenum, GLenum, GLint64 *) );
    MOCK_METHOD3( GetInteger64i_v, void  (GLenum, GLuint, GLint64 *) );
    MOCK_METHOD3( BlendEquationSeparatei, void  (GLuint buf, GLenum modeRGB, GLenum modeAlpha) );
    MOCK_METHOD2( BlendEquationi, void  (GLuint buf, GLenum mode) );
    MOCK_METHOD5( BlendFuncSeparatei, void  (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha) );
    MOCK_METHOD3( BlendFunci, void  (GLuint buf, GLenum src, GLenum dst) );
    MOCK_METHOD1( MinSampleShading, void  (GLclampf value) );
    MOCK_METHOD1( TbufferMask3DFX, void  (GLuint mask) );
    MOCK_METHOD2( BlendEquationIndexedAMD, void  (GLuint buf, GLenum mode) );
    MOCK_METHOD3( BlendEquationSeparateIndexedAMD, void  (GLuint buf, GLenum modeRGB, GLenum modeAlpha) );
    MOCK_METHOD3( BlendFuncIndexedAMD, void  (GLuint buf, GLenum src, GLenum dst) );
    MOCK_METHOD5( BlendFuncSeparateIndexedAMD, void  (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha) );
    MOCK_METHOD1( BeginPerfMonitorAMD, void  (GLuint monitor) );
    MOCK_METHOD2( DeletePerfMonitorsAMD, void  (GLsizei n, GLuint* monitors) );
    MOCK_METHOD1( EndPerfMonitorAMD, void  (GLuint monitor) );
    MOCK_METHOD2( GenPerfMonitorsAMD, void  (GLsizei n, GLuint* monitors) );
    MOCK_METHOD5( GetPerfMonitorCounterDataAMD, void  (GLuint monitor, GLenum pname, GLsizei dataSize, GLuint* data, GLint *bytesWritten) );
    MOCK_METHOD4( GetPerfMonitorCounterInfoAMD, void  (GLuint group, GLuint counter, GLenum pname, void* data) );
    MOCK_METHOD5( GetPerfMonitorCounterStringAMD, void  (GLuint group, GLuint counter, GLsizei bufSize, GLsizei* length, char *counterString) );
    MOCK_METHOD5( GetPerfMonitorCountersAMD, void  (GLuint group, GLint* numCounters, GLint *maxActiveCounters, GLsizei countersSize, GLuint *counters) );
    MOCK_METHOD4( GetPerfMonitorGroupStringAMD, void  (GLuint group, GLsizei bufSize, GLsizei* length, char *groupString) );
    MOCK_METHOD3( GetPerfMonitorGroupsAMD, void  (GLint* numGroups, GLsizei groupsSize, GLuint *groups) );
    MOCK_METHOD5( SelectPerfMonitorCountersAMD, void  (GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint* counterList) );
    MOCK_METHOD1( TessellationFactorAMD, void  (GLfloat factor) );
    MOCK_METHOD1( TessellationModeAMD, void  (GLenum mode) );
    MOCK_METHOD3( DrawElementArrayAPPLE, void  (GLenum mode, GLint first, GLsizei count) );
    MOCK_METHOD5( DrawRangeElementArrayAPPLE, void  (GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count) );
    MOCK_METHOD2( ElementPointerAPPLE, void  (GLenum type, const void* pointer) );
    MOCK_METHOD4( MultiDrawElementArrayAPPLE, void  (GLenum mode, const GLint* first, const GLsizei *count, GLsizei primcount) );
    MOCK_METHOD6( MultiDrawRangeElementArrayAPPLE, void  (GLenum mode, GLuint start, GLuint end, const GLint* first, const GLsizei *count, GLsizei primcount) );
    MOCK_METHOD2( DeleteFencesAPPLE, void  (GLsizei n, const GLuint* fences) );
    MOCK_METHOD1( FinishFenceAPPLE, void  (GLuint fence) );
    MOCK_METHOD2( FinishObjectAPPLE, void  (GLenum object, GLint name) );
    MOCK_METHOD2( GenFencesAPPLE, void  (GLsizei n, GLuint* fences) );
    MOCK_METHOD1( IsFenceAPPLE, GLboolean  (GLuint fence) );
    MOCK_METHOD1( SetFenceAPPLE, void  (GLuint fence) );
    MOCK_METHOD1( TestFenceAPPLE, GLboolean  (GLuint fence) );
    MOCK_METHOD2( TestObjectAPPLE, GLboolean  (GLenum object, GLuint name) );
    MOCK_METHOD3( BufferParameteriAPPLE, void  (GLenum target, GLenum pname, GLint param) );
    MOCK_METHOD3( FlushMappedBufferRangeAPPLE, void  (GLenum target, GLintptr offset, GLsizeiptr size) );
    MOCK_METHOD4( GetObjectParameterivAPPLE, void  (GLenum objectType, GLuint name, GLenum pname, GLint* params) );
    MOCK_METHOD3( ObjectPurgeableAPPLE, GLenum  (GLenum objectType, GLuint name, GLenum option) );
    MOCK_METHOD3( ObjectUnpurgeableAPPLE, GLenum  (GLenum objectType, GLuint name, GLenum option) );
    MOCK_METHOD3( GetTexParameterPointervAPPLE, void  (GLenum target, GLenum pname, GLvoid **params) );
    MOCK_METHOD3( TextureRangeAPPLE, void  (GLenum target, GLsizei length, GLvoid *pointer) );
    MOCK_METHOD1( BindVertexArrayAPPLE, void  (GLuint array) );
    MOCK_METHOD2( DeleteVertexArraysAPPLE, void  (GLsizei n, const GLuint* arrays) );
    MOCK_METHOD2( GenVertexArraysAPPLE, void  (GLsizei n, const GLuint* arrays) );
    MOCK_METHOD1( IsVertexArrayAPPLE, GLboolean  (GLuint array) );
    MOCK_METHOD2( FlushVertexArrayRangeAPPLE, void  (GLsizei length, void* pointer) );
    MOCK_METHOD2( VertexArrayParameteriAPPLE, void  (GLenum pname, GLint param) );
    MOCK_METHOD2( VertexArrayRangeAPPLE, void  (GLsizei length, void* pointer) );
    MOCK_METHOD2( DisableVertexAttribAPPLE, void  (GLuint index, GLenum pname) );
    MOCK_METHOD2( EnableVertexAttribAPPLE, void  (GLuint index, GLenum pname) );
    MOCK_METHOD2( IsVertexAttribEnabledAPPLE, GLboolean  (GLuint index, GLenum pname) );
    MOCK_METHOD7( MapVertexAttrib1dAPPLE, void  (GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble* points) );
    MOCK_METHOD7( MapVertexAttrib1fAPPLE, void  (GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat* points) );
    MOCK_METHOD11( MapVertexAttrib2dAPPLE, void  (GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble* points) );
    MOCK_METHOD11( MapVertexAttrib2fAPPLE, void  (GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat* points) );
    MOCK_METHOD4( BindFragDataLocationIndexed, void  (GLuint program, GLuint colorNumber, GLuint index, const char * name) );
    MOCK_METHOD2( GetFragDataIndex, GLint  (GLuint program, const char * name) );
    MOCK_METHOD2( ClampColorARB, void  (GLenum target, GLenum clamp) );
    MOCK_METHOD5( CopyBufferSubData, void  (GLenum readtarget, GLenum writetarget, GLintptr readoffset, GLintptr writeoffset, GLsizeiptr size) );
    MOCK_METHOD2( DrawBuffersARB, void  (GLsizei n, const GLenum* bufs) );
    MOCK_METHOD3( BlendEquationSeparateiARB, void  (GLuint buf, GLenum modeRGB, GLenum modeAlpha) );
    MOCK_METHOD2( BlendEquationiARB, void  (GLuint buf, GLenum mode) );
    MOCK_METHOD5( BlendFuncSeparateiARB, void  (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha) );
    MOCK_METHOD3( BlendFunciARB, void  (GLuint buf, GLenum src, GLenum dst) );
    MOCK_METHOD5( DrawElementsBaseVertex, void  (GLenum mode, GLsizei count, GLenum type, void* indices, GLint basevertex) );
    MOCK_METHOD6( DrawElementsInstancedBaseVertex, void  (GLenum mode, GLsizei count, GLenum type, const void* indices, GLsizei primcount, GLint basevertex) );
    MOCK_METHOD7( DrawRangeElementsBaseVertex, void  (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, void* indices, GLint basevertex) );
    MOCK_METHOD6( MultiDrawElementsBaseVertex, void  (GLenum mode, GLsizei* count, GLenum type, GLvoid**indices, GLsizei primcount, GLint *basevertex) );
    MOCK_METHOD2( DrawArraysIndirect, void  (GLenum mode, const void* indirect) );
    MOCK_METHOD3( DrawElementsIndirect, void  (GLenum mode, GLenum type, const void* indirect) );
    MOCK_METHOD4( DrawArraysInstancedARB, void  (GLenum mode, GLint first, GLsizei count, GLsizei primcount) );
    MOCK_METHOD5( DrawElementsInstancedARB, void  (GLenum mode, GLsizei count, GLenum type, const void* indices, GLsizei primcount) );
    MOCK_METHOD2( BindFramebuffer, void  (GLenum target, GLuint framebuffer) );
    MOCK_METHOD2( BindRenderbuffer, void  (GLenum target, GLuint renderbuffer) );
    MOCK_METHOD10( BlitFramebuffer, void  (GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) );
    MOCK_METHOD1( CheckFramebufferStatus, GLenum  (GLenum target) );
    MOCK_METHOD2( DeleteFramebuffers, void  (GLsizei n, const GLuint* framebuffers) );
    MOCK_METHOD2( DeleteRenderbuffers, void  (GLsizei n, const GLuint* renderbuffers) );
    MOCK_METHOD4( FramebufferRenderbuffer, void  (GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) );
    MOCK_METHOD5( FramebufferTexture1D, void  (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) );
    MOCK_METHOD5( FramebufferTexture2D, void  (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) );
    MOCK_METHOD6( FramebufferTexture3D, void  (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint layer) );
    MOCK_METHOD5( FramebufferTextureLayer, void  (GLenum target,GLenum attachment, GLuint texture,GLint level,GLint layer) );
    MOCK_METHOD2( GenFramebuffers, void  (GLsizei n, GLuint* framebuffers) );
    MOCK_METHOD2( GenRenderbuffers, void  (GLsizei n, GLuint* renderbuffers) );
    MOCK_METHOD1( GenerateMipmap, void  (GLenum target) );
    MOCK_METHOD4( GetFramebufferAttachmentParameteriv, void  (GLenum target, GLenum attachment, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetRenderbufferParameteriv, void  (GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD1( IsFramebuffer, GLboolean  (GLuint framebuffer) );
    MOCK_METHOD1( IsRenderbuffer, GLboolean  (GLuint renderbuffer) );
    MOCK_METHOD4( RenderbufferStorage, void  (GLenum target, GLenum internalformat, GLsizei width, GLsizei height) );
    MOCK_METHOD5( RenderbufferStorageMultisample, void  (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) );
    MOCK_METHOD4( FramebufferTextureARB, void  (GLenum target, GLenum attachment, GLuint texture, GLint level) );
    MOCK_METHOD5( FramebufferTextureFaceARB, void  (GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face) );
    MOCK_METHOD5( FramebufferTextureLayerARB, void  (GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer) );
    MOCK_METHOD3( ProgramParameteriARB, void  (GLuint program, GLenum pname, GLint value) );
    MOCK_METHOD6( ColorSubTable, void  (GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *data) );
    MOCK_METHOD6( ColorTable, void  (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table) );
    MOCK_METHOD3( ColorTableParameterfv, void  (GLenum target, GLenum pname, const GLfloat *params) );
    MOCK_METHOD3( ColorTableParameteriv, void  (GLenum target, GLenum pname, const GLint *params) );
    MOCK_METHOD6( ConvolutionFilter1D, void  (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image) );
    MOCK_METHOD7( ConvolutionFilter2D, void  (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image) );
    MOCK_METHOD3( ConvolutionParameterf, void  (GLenum target, GLenum pname, GLfloat params) );
    MOCK_METHOD3( ConvolutionParameterfv, void  (GLenum target, GLenum pname, const GLfloat *params) );
    MOCK_METHOD3( ConvolutionParameteri, void  (GLenum target, GLenum pname, GLint params) );
    MOCK_METHOD3( ConvolutionParameteriv, void  (GLenum target, GLenum pname, const GLint *params) );
    MOCK_METHOD5( CopyColorSubTable, void  (GLenum target, GLsizei start, GLint x, GLint y, GLsizei width) );
    MOCK_METHOD5( CopyColorTable, void  (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) );
    MOCK_METHOD5( CopyConvolutionFilter1D, void  (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) );
    MOCK_METHOD6( CopyConvolutionFilter2D, void  (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height) );
    MOCK_METHOD4( GetColorTable, void  (GLenum target, GLenum format, GLenum type, GLvoid *table) );
    MOCK_METHOD3( GetColorTableParameterfv, void  (GLenum target, GLenum pname, GLfloat *params) );
    MOCK_METHOD3( GetColorTableParameteriv, void  (GLenum target, GLenum pname, GLint *params) );
    MOCK_METHOD4( GetConvolutionFilter, void  (GLenum target, GLenum format, GLenum type, GLvoid *image) );
    MOCK_METHOD3( GetConvolutionParameterfv, void  (GLenum target, GLenum pname, GLfloat *params) );
    MOCK_METHOD3( GetConvolutionParameteriv, void  (GLenum target, GLenum pname, GLint *params) );
    MOCK_METHOD5( GetHistogram, void  (GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values) );
    MOCK_METHOD3( GetHistogramParameterfv, void  (GLenum target, GLenum pname, GLfloat *params) );
    MOCK_METHOD3( GetHistogramParameteriv, void  (GLenum target, GLenum pname, GLint *params) );
    MOCK_METHOD5( GetMinmax, void  (GLenum target, GLboolean reset, GLenum format, GLenum types, GLvoid *values) );
    MOCK_METHOD3( GetMinmaxParameterfv, void  (GLenum target, GLenum pname, GLfloat *params) );
    MOCK_METHOD3( GetMinmaxParameteriv, void  (GLenum target, GLenum pname, GLint *params) );
    MOCK_METHOD6( GetSeparableFilter, void  (GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span) );
    MOCK_METHOD4( Histogram, void  (GLenum target, GLsizei width, GLenum internalformat, GLboolean sink) );
    MOCK_METHOD3( Minmax, void  (GLenum target, GLenum internalformat, GLboolean sink) );
    MOCK_METHOD1( ResetHistogram, void  (GLenum target) );
    MOCK_METHOD1( ResetMinmax, void  (GLenum target) );
    MOCK_METHOD8( SeparableFilter2D, void  (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column) );
    MOCK_METHOD2( VertexAttribDivisorARB, void  (GLuint index, GLuint divisor) );
    MOCK_METHOD3( FlushMappedBufferRange, void  (GLenum target, GLintptr offset, GLsizeiptr length) );
    MOCK_METHOD4( MapBufferRange, GLvoid *  (GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access) );
    MOCK_METHOD1( CurrentPaletteMatrixARB, void  (GLint index) );
    MOCK_METHOD4( MatrixIndexPointerARB, void  (GLint size, GLenum type, GLsizei stride, GLvoid *pointer) );
    MOCK_METHOD2( MatrixIndexubvARB, void  (GLint size, GLubyte *indices) );
    MOCK_METHOD2( MatrixIndexuivARB, void  (GLint size, GLuint *indices) );
    MOCK_METHOD2( MatrixIndexusvARB, void  (GLint size, GLushort *indices) );
    MOCK_METHOD2( SampleCoverageARB, void  (GLclampf value, GLboolean invert) );
    MOCK_METHOD1( ActiveTextureARB, void  (GLenum texture) );
    MOCK_METHOD1( ClientActiveTextureARB, void  (GLenum texture) );
    MOCK_METHOD2( MultiTexCoord1dARB, void  (GLenum target, GLdouble s) );
    MOCK_METHOD2( MultiTexCoord1dvARB, void  (GLenum target, const GLdouble *v) );
    MOCK_METHOD2( MultiTexCoord1fARB, void  (GLenum target, GLfloat s) );
    MOCK_METHOD2( MultiTexCoord1fvARB, void  (GLenum target, const GLfloat *v) );
    MOCK_METHOD2( MultiTexCoord1iARB, void  (GLenum target, GLint s) );
    MOCK_METHOD2( MultiTexCoord1ivARB, void  (GLenum target, const GLint *v) );
    MOCK_METHOD2( MultiTexCoord1sARB, void  (GLenum target, GLshort s) );
    MOCK_METHOD2( MultiTexCoord1svARB, void  (GLenum target, const GLshort *v) );
    MOCK_METHOD3( MultiTexCoord2dARB, void  (GLenum target, GLdouble s, GLdouble t) );
    MOCK_METHOD2( MultiTexCoord2dvARB, void  (GLenum target, const GLdouble *v) );
    MOCK_METHOD3( MultiTexCoord2fARB, void  (GLenum target, GLfloat s, GLfloat t) );
    MOCK_METHOD2( MultiTexCoord2fvARB, void  (GLenum target, const GLfloat *v) );
    MOCK_METHOD3( MultiTexCoord2iARB, void  (GLenum target, GLint s, GLint t) );
    MOCK_METHOD2( MultiTexCoord2ivARB, void  (GLenum target, const GLint *v) );
    MOCK_METHOD3( MultiTexCoord2sARB, void  (GLenum target, GLshort s, GLshort t) );
    MOCK_METHOD2( MultiTexCoord2svARB, void  (GLenum target, const GLshort *v) );
    MOCK_METHOD4( MultiTexCoord3dARB, void  (GLenum target, GLdouble s, GLdouble t, GLdouble r) );
    MOCK_METHOD2( MultiTexCoord3dvARB, void  (GLenum target, const GLdouble *v) );
    MOCK_METHOD4( MultiTexCoord3fARB, void  (GLenum target, GLfloat s, GLfloat t, GLfloat r) );
    MOCK_METHOD2( MultiTexCoord3fvARB, void  (GLenum target, const GLfloat *v) );
    MOCK_METHOD4( MultiTexCoord3iARB, void  (GLenum target, GLint s, GLint t, GLint r) );
    MOCK_METHOD2( MultiTexCoord3ivARB, void  (GLenum target, const GLint *v) );
    MOCK_METHOD4( MultiTexCoord3sARB, void  (GLenum target, GLshort s, GLshort t, GLshort r) );
    MOCK_METHOD2( MultiTexCoord3svARB, void  (GLenum target, const GLshort *v) );
    MOCK_METHOD5( MultiTexCoord4dARB, void  (GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q) );
    MOCK_METHOD2( MultiTexCoord4dvARB, void  (GLenum target, const GLdouble *v) );
    MOCK_METHOD5( MultiTexCoord4fARB, void  (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q) );
    MOCK_METHOD2( MultiTexCoord4fvARB, void  (GLenum target, const GLfloat *v) );
    MOCK_METHOD5( MultiTexCoord4iARB, void  (GLenum target, GLint s, GLint t, GLint r, GLint q) );
    MOCK_METHOD2( MultiTexCoord4ivARB, void  (GLenum target, const GLint *v) );
    MOCK_METHOD5( MultiTexCoord4sARB, void  (GLenum target, GLshort s, GLshort t, GLshort r, GLshort q) );
    MOCK_METHOD2( MultiTexCoord4svARB, void  (GLenum target, const GLshort *v) );
    MOCK_METHOD2( BeginQueryARB, void  (GLenum target, GLuint id) );
    MOCK_METHOD2( DeleteQueriesARB, void  (GLsizei n, const GLuint* ids) );
    MOCK_METHOD1( EndQueryARB, void  (GLenum target) );
    MOCK_METHOD2( GenQueriesARB, void  (GLsizei n, GLuint* ids) );
    MOCK_METHOD3( GetQueryObjectivARB, void  (GLuint id, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetQueryObjectuivARB, void  (GLuint id, GLenum pname, GLuint* params) );
    MOCK_METHOD3( GetQueryivARB, void  (GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD1( IsQueryARB, GLboolean  (GLuint id) );
    MOCK_METHOD2( PointParameterfARB, void  (GLenum pname, GLfloat param) );
    MOCK_METHOD2( PointParameterfvARB, void  (GLenum pname, const GLfloat* params) );
    MOCK_METHOD1( ProvokingVertex, void  (GLenum mode) );
    MOCK_METHOD1( MinSampleShadingARB, void  (GLclampf value) );
    MOCK_METHOD2( BindSampler, void  (GLuint unit, GLuint sampler) );
    MOCK_METHOD2( DeleteSamplers, void  (GLsizei count, const GLuint * samplers) );
    MOCK_METHOD2( GenSamplers, void  (GLsizei count, GLuint* samplers) );
    MOCK_METHOD3( GetSamplerParameterIiv, void  (GLuint sampler, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetSamplerParameterIuiv, void  (GLuint sampler, GLenum pname, GLuint* params) );
    MOCK_METHOD3( GetSamplerParameterfv, void  (GLuint sampler, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetSamplerParameteriv, void  (GLuint sampler, GLenum pname, GLint* params) );
    MOCK_METHOD1( IsSampler, GLboolean  (GLuint sampler) );
    MOCK_METHOD3( SamplerParameterIiv, void  (GLuint sampler, GLenum pname, const GLint* params) );
    MOCK_METHOD3( SamplerParameterIuiv, void  (GLuint sampler, GLenum pname, const GLuint* params) );
    MOCK_METHOD3( SamplerParameterf, void  (GLuint sampler, GLenum pname, GLfloat param) );
    MOCK_METHOD3( SamplerParameterfv, void  (GLuint sampler, GLenum pname, const GLfloat* params) );
    MOCK_METHOD3( SamplerParameteri, void  (GLuint sampler, GLenum pname, GLint param) );
    MOCK_METHOD3( SamplerParameteriv, void  (GLuint sampler, GLenum pname, const GLint* params) );
    MOCK_METHOD2( AttachObjectARB, void  (GLhandleARB containerObj, GLhandleARB obj) );
    MOCK_METHOD1( CompileShaderARB, void  (GLhandleARB shaderObj) );
    MOCK_METHOD0( CreateProgramObjectARB, GLhandleARB  (void) );
    MOCK_METHOD1( CreateShaderObjectARB, GLhandleARB  (GLenum shaderType) );
    MOCK_METHOD1( DeleteObjectARB, void  (GLhandleARB obj) );
    MOCK_METHOD2( DetachObjectARB, void  (GLhandleARB containerObj, GLhandleARB attachedObj) );
    MOCK_METHOD7( GetActiveUniformARB, void  (GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei* length, GLint *size, GLenum *type, GLcharARB *name) );
    MOCK_METHOD4( GetAttachedObjectsARB, void  (GLhandleARB containerObj, GLsizei maxCount, GLsizei* count, GLhandleARB *obj) );
    MOCK_METHOD1( GetHandleARB, GLhandleARB  (GLenum pname) );
    MOCK_METHOD4( GetInfoLogARB, void  (GLhandleARB obj, GLsizei maxLength, GLsizei* length, GLcharARB *infoLog) );
    MOCK_METHOD3( GetObjectParameterfvARB, void  (GLhandleARB obj, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetObjectParameterivARB, void  (GLhandleARB obj, GLenum pname, GLint* params) );
    MOCK_METHOD4( GetShaderSourceARB, void  (GLhandleARB obj, GLsizei maxLength, GLsizei* length, GLcharARB *source) );
    MOCK_METHOD2( GetUniformLocationARB, GLint  (GLhandleARB programObj, const GLcharARB* name) );
    MOCK_METHOD3( GetUniformfvARB, void  (GLhandleARB programObj, GLint location, GLfloat* params) );
    MOCK_METHOD3( GetUniformivARB, void  (GLhandleARB programObj, GLint location, GLint* params) );
    MOCK_METHOD1( LinkProgramARB, void  (GLhandleARB programObj) );
    MOCK_METHOD4( ShaderSourceARB, void  (GLhandleARB shaderObj, GLsizei count, const GLcharARB ** string, const GLint *length) );
    MOCK_METHOD2( Uniform1fARB, void  (GLint location, GLfloat v0) );
    MOCK_METHOD3( Uniform1fvARB, void  (GLint location, GLsizei count, const GLfloat* value) );
    MOCK_METHOD2( Uniform1iARB, void  (GLint location, GLint v0) );
    MOCK_METHOD3( Uniform1ivARB, void  (GLint location, GLsizei count, const GLint* value) );
    MOCK_METHOD3( Uniform2fARB, void  (GLint location, GLfloat v0, GLfloat v1) );
    MOCK_METHOD3( Uniform2fvARB, void  (GLint location, GLsizei count, const GLfloat* value) );
    MOCK_METHOD3( Uniform2iARB, void  (GLint location, GLint v0, GLint v1) );
    MOCK_METHOD3( Uniform2ivARB, void  (GLint location, GLsizei count, const GLint* value) );
    MOCK_METHOD4( Uniform3fARB, void  (GLint location, GLfloat v0, GLfloat v1, GLfloat v2) );
    MOCK_METHOD3( Uniform3fvARB, void  (GLint location, GLsizei count, const GLfloat* value) );
    MOCK_METHOD4( Uniform3iARB, void  (GLint location, GLint v0, GLint v1, GLint v2) );
    MOCK_METHOD3( Uniform3ivARB, void  (GLint location, GLsizei count, const GLint* value) );
    MOCK_METHOD5( Uniform4fARB, void  (GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3) );
    MOCK_METHOD3( Uniform4fvARB, void  (GLint location, GLsizei count, const GLfloat* value) );
    MOCK_METHOD5( Uniform4iARB, void  (GLint location, GLint v0, GLint v1, GLint v2, GLint v3) );
    MOCK_METHOD3( Uniform4ivARB, void  (GLint location, GLsizei count, const GLint* value) );
    MOCK_METHOD4( UniformMatrix2fvARB, void  (GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) );
    MOCK_METHOD4( UniformMatrix3fvARB, void  (GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) );
    MOCK_METHOD4( UniformMatrix4fvARB, void  (GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) );
    MOCK_METHOD1( UseProgramObjectARB, void  (GLhandleARB programObj) );
    MOCK_METHOD1( ValidateProgramARB, void  (GLhandleARB programObj) );
    MOCK_METHOD6( GetActiveSubroutineName, void  (GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei* length, char *name) );
    MOCK_METHOD6( GetActiveSubroutineUniformName, void  (GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei* length, char *name) );
    MOCK_METHOD5( GetActiveSubroutineUniformiv, void  (GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint* values) );
    MOCK_METHOD4( GetProgramStageiv, void  (GLuint program, GLenum shadertype, GLenum pname, GLint* values) );
    MOCK_METHOD3( GetSubroutineIndex, GLuint  (GLuint program, GLenum shadertype, const char* name) );
    MOCK_METHOD3( GetSubroutineUniformLocation, GLint  (GLuint program, GLenum shadertype, const char* name) );
    MOCK_METHOD3( GetUniformSubroutineuiv, void  (GLenum shadertype, GLint location, GLuint* params) );
    MOCK_METHOD3( UniformSubroutinesuiv, void  (GLenum shadertype, GLsizei count, const GLuint* indices) );
    MOCK_METHOD4( CompileShaderIncludeARB, void  (GLuint shader, GLsizei count, const char ** path, const GLint *length) );
    MOCK_METHOD2( DeleteNamedStringARB, void  (GLint namelen, const char* name) );
    MOCK_METHOD5( GetNamedStringARB, void  (GLint namelen, const char* name, GLsizei bufSize, GLint *stringlen, char *string) );
    MOCK_METHOD4( GetNamedStringivARB, void  (GLint namelen, const char* name, GLenum pname, GLint *params) );
    MOCK_METHOD2( IsNamedStringARB, GLboolean  (GLint namelen, const char* name) );
    MOCK_METHOD5( NamedStringARB, void  (GLenum type, GLint namelen, const char* name, GLint stringlen, const char *string) );
    MOCK_METHOD3( ClientWaitSync, GLenum  (GLsync GLsync,GLbitfield flags,GLuint64 timeout) );
    MOCK_METHOD1( DeleteSync, void  (GLsync GLsync) );
    MOCK_METHOD2( FenceSync, GLsync  (GLenum condition,GLbitfield flags) );
    MOCK_METHOD2( GetInteger64v, void  (GLenum pname, GLint64* params) );
    MOCK_METHOD5( GetSynciv, void  (GLsync GLsync,GLenum pname,GLsizei bufSize,GLsizei* length, GLint *values) );
    MOCK_METHOD1( IsSync, GLboolean  (GLsync GLsync) );
    MOCK_METHOD3( WaitSync, void  (GLsync GLsync,GLbitfield flags,GLuint64 timeout) );
    MOCK_METHOD2( PatchParameterfv, void  (GLenum pname, const GLfloat* values) );
    MOCK_METHOD2( PatchParameteri, void  (GLenum pname, GLint value) );
    MOCK_METHOD3( TexBufferARB, void  (GLenum target, GLenum internalformat, GLuint buffer) );
    MOCK_METHOD7( CompressedTexImage1DARB, void  (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void* data) );
    MOCK_METHOD8( CompressedTexImage2DARB, void  (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void* data) );
    MOCK_METHOD9( CompressedTexImage3DARB, void  (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void* data) );
    MOCK_METHOD7( CompressedTexSubImage1DARB, void  (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void* data) );
    MOCK_METHOD9( CompressedTexSubImage2DARB, void  (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void* data) );
    MOCK_METHOD11( CompressedTexSubImage3DARB, void  (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void* data) );
    MOCK_METHOD3( GetCompressedTexImageARB, void  (GLenum target, GLint lod, void* img) );
    MOCK_METHOD3( GetMultisamplefv, void  (GLenum pname, GLuint index, GLfloat* val) );
    MOCK_METHOD2( SampleMaski, void  (GLuint index, GLbitfield mask) );
    MOCK_METHOD6( TexImage2DMultisample, void  (GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations) );
    MOCK_METHOD7( TexImage3DMultisample, void  (GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations) );
    MOCK_METHOD3( GetQueryObjecti64v, void  (GLuint id, GLenum pname, GLint64* params) );
    MOCK_METHOD3( GetQueryObjectui64v, void  (GLuint id, GLenum pname, GLuint64* params) );
    MOCK_METHOD2( QueryCounter, void  (GLuint id, GLenum target) );
    MOCK_METHOD2( BindTransformFeedback, void  (GLenum target, GLuint id) );
    MOCK_METHOD2( DeleteTransformFeedbacks, void  (GLsizei n, const GLuint* ids) );
    MOCK_METHOD2( DrawTransformFeedback, void  (GLenum mode, GLuint id) );
    MOCK_METHOD2( GenTransformFeedbacks, void  (GLsizei n, GLuint* ids) );
    MOCK_METHOD1( IsTransformFeedback, GLboolean  (GLuint id) );
    MOCK_METHOD0( PauseTransformFeedback, void  (void) );
    MOCK_METHOD0( ResumeTransformFeedback, void  (void) );
    MOCK_METHOD3( BeginQueryIndexed, void  (GLenum target, GLuint index, GLuint id) );
    MOCK_METHOD3( DrawTransformFeedbackStream, void  (GLenum mode, GLuint id, GLuint stream) );
    MOCK_METHOD2( EndQueryIndexed, void  (GLenum target, GLuint index) );
    MOCK_METHOD4( GetQueryIndexediv, void  (GLenum target, GLuint index, GLenum pname, GLint* params) );
    MOCK_METHOD1( LoadTransposeMatrixdARB, void  (GLdouble m[16]) );
    MOCK_METHOD1( LoadTransposeMatrixfARB, void  (GLfloat m[16]) );
    MOCK_METHOD1( MultTransposeMatrixdARB, void  (GLdouble m[16]) );
    MOCK_METHOD1( MultTransposeMatrixfARB, void  (GLfloat m[16]) );
    MOCK_METHOD3( BindBufferBase, void  (GLenum target, GLuint index, GLuint buffer) );
    MOCK_METHOD5( BindBufferRange, void  (GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size) );
    MOCK_METHOD5( GetActiveUniformBlockName, void  (GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei* length, char* uniformBlockName) );
    MOCK_METHOD4( GetActiveUniformBlockiv, void  (GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint* params) );
    MOCK_METHOD5( GetActiveUniformName, void  (GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei* length, char* uniformName) );
    MOCK_METHOD5( GetActiveUniformsiv, void  (GLuint program, GLsizei uniformCount, const GLuint* uniformIndices, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetIntegeri_v, void  (GLenum target, GLuint index, GLint* data) );
    MOCK_METHOD2( GetUniformBlockIndex, GLuint  (GLuint program, const char* uniformBlockName) );
    MOCK_METHOD4( GetUniformIndices, void  (GLuint program, GLsizei uniformCount, const char** uniformNames, GLuint* uniformIndices) );
    MOCK_METHOD3( UniformBlockBinding, void  (GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding) );
    MOCK_METHOD1( BindVertexArray, void  (GLuint array) );
    MOCK_METHOD2( DeleteVertexArrays, void  (GLsizei n, const GLuint* arrays) );
    MOCK_METHOD2( GenVertexArrays, void  (GLsizei n, GLuint* arrays) );
    MOCK_METHOD1( IsVertexArray, GLboolean  (GLuint array) );
    MOCK_METHOD1( VertexBlendARB, void  (GLint count) );
    MOCK_METHOD4( WeightPointerARB, void  (GLint size, GLenum type, GLsizei stride, GLvoid *pointer) );
    MOCK_METHOD2( WeightbvARB, void  (GLint size, GLbyte *weights) );
    MOCK_METHOD2( WeightdvARB, void  (GLint size, GLdouble *weights) );
    MOCK_METHOD2( WeightfvARB, void  (GLint size, GLfloat *weights) );
    MOCK_METHOD2( WeightivARB, void  (GLint size, GLint *weights) );
    MOCK_METHOD2( WeightsvARB, void  (GLint size, GLshort *weights) );
    MOCK_METHOD2( WeightubvARB, void  (GLint size, GLubyte *weights) );
    MOCK_METHOD2( WeightuivARB, void  (GLint size, GLuint *weights) );
    MOCK_METHOD2( WeightusvARB, void  (GLint size, GLushort *weights) );
    MOCK_METHOD2( BindBufferARB, void  (GLenum target, GLuint buffer) );
    MOCK_METHOD4( BufferDataARB, void  (GLenum target, GLsizeiptrARB size, const GLvoid* data, GLenum usage) );
    MOCK_METHOD4( BufferSubDataARB, void  (GLenum target, GLintptrARB offset, GLsizeiptrARB size, const GLvoid* data) );
    MOCK_METHOD2( DeleteBuffersARB, void  (GLsizei n, const GLuint* buffers) );
    MOCK_METHOD2( GenBuffersARB, void  (GLsizei n, GLuint* buffers) );
    MOCK_METHOD3( GetBufferParameterivARB, void  (GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetBufferPointervARB, void  (GLenum target, GLenum pname, GLvoid** params) );
    MOCK_METHOD4( GetBufferSubDataARB, void  (GLenum target, GLintptrARB offset, GLsizeiptrARB size, GLvoid* data) );
    MOCK_METHOD1( IsBufferARB, GLboolean  (GLuint buffer) );
    MOCK_METHOD2( MapBufferARB, GLvoid *  (GLenum target, GLenum access) );
    MOCK_METHOD1( UnmapBufferARB, GLboolean  (GLenum target) );
    MOCK_METHOD2( BindProgramARB, void  (GLenum target, GLuint program) );
    MOCK_METHOD2( DeleteProgramsARB, void  (GLsizei n, const GLuint* programs) );
    MOCK_METHOD1( DisableVertexAttribArrayARB, void  (GLuint index) );
    MOCK_METHOD1( EnableVertexAttribArrayARB, void  (GLuint index) );
    MOCK_METHOD2( GenProgramsARB, void  (GLsizei n, GLuint* programs) );
    MOCK_METHOD3( GetProgramEnvParameterdvARB, void  (GLenum target, GLuint index, GLdouble* params) );
    MOCK_METHOD3( GetProgramEnvParameterfvARB, void  (GLenum target, GLuint index, GLfloat* params) );
    MOCK_METHOD3( GetProgramLocalParameterdvARB, void  (GLenum target, GLuint index, GLdouble* params) );
    MOCK_METHOD3( GetProgramLocalParameterfvARB, void  (GLenum target, GLuint index, GLfloat* params) );
    MOCK_METHOD3( GetProgramStringARB, void  (GLenum target, GLenum pname, void* string) );
    MOCK_METHOD3( GetProgramivARB, void  (GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetVertexAttribPointervARB, void  (GLuint index, GLenum pname, GLvoid** pointer) );
    MOCK_METHOD3( GetVertexAttribdvARB, void  (GLuint index, GLenum pname, GLdouble* params) );
    MOCK_METHOD3( GetVertexAttribfvARB, void  (GLuint index, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetVertexAttribivARB, void  (GLuint index, GLenum pname, GLint* params) );
    MOCK_METHOD1( IsProgramARB, GLboolean  (GLuint program) );
    MOCK_METHOD6( ProgramEnvParameter4dARB, void  (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) );
    MOCK_METHOD3( ProgramEnvParameter4dvARB, void  (GLenum target, GLuint index, const GLdouble* params) );
    MOCK_METHOD6( ProgramEnvParameter4fARB, void  (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) );
    MOCK_METHOD3( ProgramEnvParameter4fvARB, void  (GLenum target, GLuint index, const GLfloat* params) );
    MOCK_METHOD6( ProgramLocalParameter4dARB, void  (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) );
    MOCK_METHOD3( ProgramLocalParameter4dvARB, void  (GLenum target, GLuint index, const GLdouble* params) );
    MOCK_METHOD6( ProgramLocalParameter4fARB, void  (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) );
    MOCK_METHOD3( ProgramLocalParameter4fvARB, void  (GLenum target, GLuint index, const GLfloat* params) );
    MOCK_METHOD4( ProgramStringARB, void  (GLenum target, GLenum format, GLsizei len, const void* string) );
    MOCK_METHOD2( VertexAttrib1dARB, void  (GLuint index, GLdouble x) );
    MOCK_METHOD2( VertexAttrib1dvARB, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD2( VertexAttrib1fARB, void  (GLuint index, GLfloat x) );
    MOCK_METHOD2( VertexAttrib1fvARB, void  (GLuint index, const GLfloat* v) );
    MOCK_METHOD2( VertexAttrib1sARB, void  (GLuint index, GLshort x) );
    MOCK_METHOD2( VertexAttrib1svARB, void  (GLuint index, const GLshort* v) );
    MOCK_METHOD3( VertexAttrib2dARB, void  (GLuint index, GLdouble x, GLdouble y) );
    MOCK_METHOD2( VertexAttrib2dvARB, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD3( VertexAttrib2fARB, void  (GLuint index, GLfloat x, GLfloat y) );
    MOCK_METHOD2( VertexAttrib2fvARB, void  (GLuint index, const GLfloat* v) );
    MOCK_METHOD3( VertexAttrib2sARB, void  (GLuint index, GLshort x, GLshort y) );
    MOCK_METHOD2( VertexAttrib2svARB, void  (GLuint index, const GLshort* v) );
    MOCK_METHOD4( VertexAttrib3dARB, void  (GLuint index, GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD2( VertexAttrib3dvARB, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD4( VertexAttrib3fARB, void  (GLuint index, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD2( VertexAttrib3fvARB, void  (GLuint index, const GLfloat* v) );
    MOCK_METHOD4( VertexAttrib3sARB, void  (GLuint index, GLshort x, GLshort y, GLshort z) );
    MOCK_METHOD2( VertexAttrib3svARB, void  (GLuint index, const GLshort* v) );
    MOCK_METHOD2( VertexAttrib4NbvARB, void  (GLuint index, const GLbyte* v) );
    MOCK_METHOD2( VertexAttrib4NivARB, void  (GLuint index, const GLint* v) );
    MOCK_METHOD2( VertexAttrib4NsvARB, void  (GLuint index, const GLshort* v) );
    MOCK_METHOD5( VertexAttrib4NubARB, void  (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) );
    MOCK_METHOD2( VertexAttrib4NubvARB, void  (GLuint index, const GLubyte* v) );
    MOCK_METHOD2( VertexAttrib4NuivARB, void  (GLuint index, const GLuint* v) );
    MOCK_METHOD2( VertexAttrib4NusvARB, void  (GLuint index, const GLushort* v) );
    MOCK_METHOD2( VertexAttrib4bvARB, void  (GLuint index, const GLbyte* v) );
    MOCK_METHOD5( VertexAttrib4dARB, void  (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) );
    MOCK_METHOD2( VertexAttrib4dvARB, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD5( VertexAttrib4fARB, void  (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) );
    MOCK_METHOD2( VertexAttrib4fvARB, void  (GLuint index, const GLfloat* v) );
    MOCK_METHOD2( VertexAttrib4ivARB, void  (GLuint index, const GLint* v) );
    MOCK_METHOD5( VertexAttrib4sARB, void  (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w) );
    MOCK_METHOD2( VertexAttrib4svARB, void  (GLuint index, const GLshort* v) );
    MOCK_METHOD2( VertexAttrib4ubvARB, void  (GLuint index, const GLubyte* v) );
    MOCK_METHOD2( VertexAttrib4uivARB, void  (GLuint index, const GLuint* v) );
    MOCK_METHOD2( VertexAttrib4usvARB, void  (GLuint index, const GLushort* v) );
    MOCK_METHOD6( VertexAttribPointerARB, void  (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void* pointer) );
    MOCK_METHOD3( BindAttribLocationARB, void  (GLhandleARB programObj, GLuint index, const GLcharARB* name) );
    MOCK_METHOD7( GetActiveAttribARB, void  (GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei* length, GLint *size, GLenum *type, GLcharARB *name) );
    MOCK_METHOD2( GetAttribLocationARB, GLint  (GLhandleARB programObj, const GLcharARB* name) );
    MOCK_METHOD2( ColorP3ui, void  (GLenum type, GLuint color) );
    MOCK_METHOD2( ColorP3uiv, void  (GLenum type, const GLuint* color) );
    MOCK_METHOD2( ColorP4ui, void  (GLenum type, GLuint color) );
    MOCK_METHOD2( ColorP4uiv, void  (GLenum type, const GLuint* color) );
    MOCK_METHOD3( MultiTexCoordP1ui, void  (GLenum texture, GLenum type, GLuint coords) );
    MOCK_METHOD3( MultiTexCoordP1uiv, void  (GLenum texture, GLenum type, const GLuint* coords) );
    MOCK_METHOD3( MultiTexCoordP2ui, void  (GLenum texture, GLenum type, GLuint coords) );
    MOCK_METHOD3( MultiTexCoordP2uiv, void  (GLenum texture, GLenum type, const GLuint* coords) );
    MOCK_METHOD3( MultiTexCoordP3ui, void  (GLenum texture, GLenum type, GLuint coords) );
    MOCK_METHOD3( MultiTexCoordP3uiv, void  (GLenum texture, GLenum type, const GLuint* coords) );
    MOCK_METHOD3( MultiTexCoordP4ui, void  (GLenum texture, GLenum type, GLuint coords) );
    MOCK_METHOD3( MultiTexCoordP4uiv, void  (GLenum texture, GLenum type, const GLuint* coords) );
    MOCK_METHOD2( NormalP3ui, void  (GLenum type, GLuint coords) );
    MOCK_METHOD2( NormalP3uiv, void  (GLenum type, const GLuint* coords) );
    MOCK_METHOD2( SecondaryColorP3ui, void  (GLenum type, GLuint color) );
    MOCK_METHOD2( SecondaryColorP3uiv, void  (GLenum type, const GLuint* color) );
    MOCK_METHOD2( TexCoordP1ui, void  (GLenum type, GLuint coords) );
    MOCK_METHOD2( TexCoordP1uiv, void  (GLenum type, const GLuint* coords) );
    MOCK_METHOD2( TexCoordP2ui, void  (GLenum type, GLuint coords) );
    MOCK_METHOD2( TexCoordP2uiv, void  (GLenum type, const GLuint* coords) );
    MOCK_METHOD2( TexCoordP3ui, void  (GLenum type, GLuint coords) );
    MOCK_METHOD2( TexCoordP3uiv, void  (GLenum type, const GLuint* coords) );
    MOCK_METHOD2( TexCoordP4ui, void  (GLenum type, GLuint coords) );
    MOCK_METHOD2( TexCoordP4uiv, void  (GLenum type, const GLuint* coords) );
    MOCK_METHOD4( VertexAttribP1ui, void  (GLuint index, GLenum type, GLboolean normalized, GLuint value) );
    MOCK_METHOD4( VertexAttribP1uiv, void  (GLuint index, GLenum type, GLboolean normalized, const GLuint* value) );
    MOCK_METHOD4( VertexAttribP2ui, void  (GLuint index, GLenum type, GLboolean normalized, GLuint value) );
    MOCK_METHOD4( VertexAttribP2uiv, void  (GLuint index, GLenum type, GLboolean normalized, const GLuint* value) );
    MOCK_METHOD4( VertexAttribP3ui, void  (GLuint index, GLenum type, GLboolean normalized, GLuint value) );
    MOCK_METHOD4( VertexAttribP3uiv, void  (GLuint index, GLenum type, GLboolean normalized, const GLuint* value) );
    MOCK_METHOD4( VertexAttribP4ui, void  (GLuint index, GLenum type, GLboolean normalized, GLuint value) );
    MOCK_METHOD4( VertexAttribP4uiv, void  (GLuint index, GLenum type, GLboolean normalized, const GLuint* value) );
    MOCK_METHOD2( VertexP2ui, void  (GLenum type, GLuint value) );
    MOCK_METHOD2( VertexP2uiv, void  (GLenum type, const GLuint* value) );
    MOCK_METHOD2( VertexP3ui, void  (GLenum type, GLuint value) );
    MOCK_METHOD2( VertexP3uiv, void  (GLenum type, const GLuint* value) );
    MOCK_METHOD2( VertexP4ui, void  (GLenum type, GLuint value) );
    MOCK_METHOD2( VertexP4uiv, void  (GLenum type, const GLuint* value) );
    MOCK_METHOD2( WindowPos2dARB, void  (GLdouble x, GLdouble y) );
    MOCK_METHOD1( WindowPos2dvARB, void  (const GLdouble* p) );
    MOCK_METHOD2( WindowPos2fARB, void  (GLfloat x, GLfloat y) );
    MOCK_METHOD1( WindowPos2fvARB, void  (const GLfloat* p) );
    MOCK_METHOD2( WindowPos2iARB, void  (GLint x, GLint y) );
    MOCK_METHOD1( WindowPos2ivARB, void  (const GLint* p) );
    MOCK_METHOD2( WindowPos2sARB, void  (GLshort x, GLshort y) );
    MOCK_METHOD1( WindowPos2svARB, void  (const GLshort* p) );
    MOCK_METHOD3( WindowPos3dARB, void  (GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD1( WindowPos3dvARB, void  (const GLdouble* p) );
    MOCK_METHOD3( WindowPos3fARB, void  (GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD1( WindowPos3fvARB, void  (const GLfloat* p) );
    MOCK_METHOD3( WindowPos3iARB, void  (GLint x, GLint y, GLint z) );
    MOCK_METHOD1( WindowPos3ivARB, void  (const GLint* p) );
    MOCK_METHOD3( WindowPos3sARB, void  (GLshort x, GLshort y, GLshort z) );
    MOCK_METHOD1( WindowPos3svARB, void  (const GLshort* p) );
    MOCK_METHOD2( DrawBuffersATI, void  (GLsizei n, const GLenum* bufs) );
    MOCK_METHOD2( DrawElementArrayATI, void  (GLenum mode, GLsizei count) );
    MOCK_METHOD4( DrawRangeElementArrayATI, void  (GLenum mode, GLuint start, GLuint end, GLsizei count) );
    MOCK_METHOD2( ElementPointerATI, void  (GLenum type, const void* pointer) );
    MOCK_METHOD2( GetTexBumpParameterfvATI, void  (GLenum pname, GLfloat *param) );
    MOCK_METHOD2( GetTexBumpParameterivATI, void  (GLenum pname, GLint *param) );
    MOCK_METHOD2( TexBumpParameterfvATI, void  (GLenum pname, GLfloat *param) );
    MOCK_METHOD2( TexBumpParameterivATI, void  (GLenum pname, GLint *param) );
    MOCK_METHOD6( AlphaFragmentOp1ATI, void  (GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod) );
    MOCK_METHOD9( AlphaFragmentOp2ATI, void  (GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod) );
    MOCK_METHOD12( AlphaFragmentOp3ATI, void  (GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod) );
    MOCK_METHOD0( BeginFragmentShaderATI, void  (void) );
    MOCK_METHOD1( BindFragmentShaderATI, void  (GLuint id) );
    MOCK_METHOD7( ColorFragmentOp1ATI, void  (GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod) );
    MOCK_METHOD10( ColorFragmentOp2ATI, void  (GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod) );
    MOCK_METHOD13( ColorFragmentOp3ATI, void  (GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod) );
    MOCK_METHOD1( DeleteFragmentShaderATI, void  (GLuint id) );
    MOCK_METHOD0( EndFragmentShaderATI, void  (void) );
    MOCK_METHOD1( GenFragmentShadersATI, GLuint  (GLuint range) );
    MOCK_METHOD3( PassTexCoordATI, void  (GLuint dst, GLuint coord, GLenum swizzle) );
    MOCK_METHOD3( SampleMapATI, void  (GLuint dst, GLuint interp, GLenum swizzle) );
    MOCK_METHOD2( SetFragmentShaderConstantATI, void  (GLuint dst, const GLfloat* value) );
    MOCK_METHOD1( MapObjectBufferATI, void*  (GLuint buffer) );
    MOCK_METHOD1( UnmapObjectBufferATI, void  (GLuint buffer) );
    MOCK_METHOD2( PNTrianglesfATI, void  (GLenum pname, GLfloat param) );
    MOCK_METHOD2( PNTrianglesiATI, void  (GLenum pname, GLint param) );
    MOCK_METHOD4( StencilFuncSeparateATI, void  (GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask) );
    MOCK_METHOD4( StencilOpSeparateATI, void  (GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass) );
    MOCK_METHOD6( ArrayObjectATI, void  (GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset) );
    MOCK_METHOD1( FreeObjectBufferATI, void  (GLuint buffer) );
    MOCK_METHOD3( GetArrayObjectfvATI, void  (GLenum array, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetArrayObjectivATI, void  (GLenum array, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetObjectBufferfvATI, void  (GLuint buffer, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetObjectBufferivATI, void  (GLuint buffer, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetVariantArrayObjectfvATI, void  (GLuint id, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetVariantArrayObjectivATI, void  (GLuint id, GLenum pname, GLint* params) );
    MOCK_METHOD1( IsObjectBufferATI, GLboolean  (GLuint buffer) );
    MOCK_METHOD3( NewObjectBufferATI, GLuint  (GLsizei size, const void* pointer, GLenum usage) );
    MOCK_METHOD5( UpdateObjectBufferATI, void  (GLuint buffer, GLuint offset, GLsizei size, const void* pointer, GLenum preserve) );
    MOCK_METHOD5( VariantArrayObjectATI, void  (GLuint id, GLenum type, GLsizei stride, GLuint buffer, GLuint offset) );
    MOCK_METHOD3( GetVertexAttribArrayObjectfvATI, void  (GLuint index, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetVertexAttribArrayObjectivATI, void  (GLuint index, GLenum pname, GLint* params) );
    MOCK_METHOD7( VertexAttribArrayObjectATI, void  (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLuint buffer, GLuint offset) );
    MOCK_METHOD1( ClientActiveVertexStreamATI, void  (GLenum stream) );
    MOCK_METHOD4( NormalStream3bATI, void  (GLenum stream, GLbyte x, GLbyte y, GLbyte z) );
    MOCK_METHOD2( NormalStream3bvATI, void  (GLenum stream, const GLbyte *v) );
    MOCK_METHOD4( NormalStream3dATI, void  (GLenum stream, GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD2( NormalStream3dvATI, void  (GLenum stream, const GLdouble *v) );
    MOCK_METHOD4( NormalStream3fATI, void  (GLenum stream, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD2( NormalStream3fvATI, void  (GLenum stream, const GLfloat *v) );
    MOCK_METHOD4( NormalStream3iATI, void  (GLenum stream, GLint x, GLint y, GLint z) );
    MOCK_METHOD2( NormalStream3ivATI, void  (GLenum stream, const GLint *v) );
    MOCK_METHOD4( NormalStream3sATI, void  (GLenum stream, GLshort x, GLshort y, GLshort z) );
    MOCK_METHOD2( NormalStream3svATI, void  (GLenum stream, const GLshort *v) );
    MOCK_METHOD2( VertexBlendEnvfATI, void  (GLenum pname, GLfloat param) );
    MOCK_METHOD2( VertexBlendEnviATI, void  (GLenum pname, GLint param) );
    MOCK_METHOD3( VertexStream2dATI, void  (GLenum stream, GLdouble x, GLdouble y) );
    MOCK_METHOD2( VertexStream2dvATI, void  (GLenum stream, const GLdouble *v) );
    MOCK_METHOD3( VertexStream2fATI, void  (GLenum stream, GLfloat x, GLfloat y) );
    MOCK_METHOD2( VertexStream2fvATI, void  (GLenum stream, const GLfloat *v) );
    MOCK_METHOD3( VertexStream2iATI, void  (GLenum stream, GLint x, GLint y) );
    MOCK_METHOD2( VertexStream2ivATI, void  (GLenum stream, const GLint *v) );
    MOCK_METHOD3( VertexStream2sATI, void  (GLenum stream, GLshort x, GLshort y) );
    MOCK_METHOD2( VertexStream2svATI, void  (GLenum stream, const GLshort *v) );
    MOCK_METHOD4( VertexStream3dATI, void  (GLenum stream, GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD2( VertexStream3dvATI, void  (GLenum stream, const GLdouble *v) );
    MOCK_METHOD4( VertexStream3fATI, void  (GLenum stream, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD2( VertexStream3fvATI, void  (GLenum stream, const GLfloat *v) );
    MOCK_METHOD4( VertexStream3iATI, void  (GLenum stream, GLint x, GLint y, GLint z) );
    MOCK_METHOD2( VertexStream3ivATI, void  (GLenum stream, const GLint *v) );
    MOCK_METHOD4( VertexStream3sATI, void  (GLenum stream, GLshort x, GLshort y, GLshort z) );
    MOCK_METHOD2( VertexStream3svATI, void  (GLenum stream, const GLshort *v) );
    MOCK_METHOD5( VertexStream4dATI, void  (GLenum stream, GLdouble x, GLdouble y, GLdouble z, GLdouble w) );
    MOCK_METHOD2( VertexStream4dvATI, void  (GLenum stream, const GLdouble *v) );
    MOCK_METHOD5( VertexStream4fATI, void  (GLenum stream, GLfloat x, GLfloat y, GLfloat z, GLfloat w) );
    MOCK_METHOD2( VertexStream4fvATI, void  (GLenum stream, const GLfloat *v) );
    MOCK_METHOD5( VertexStream4iATI, void  (GLenum stream, GLint x, GLint y, GLint z, GLint w) );
    MOCK_METHOD2( VertexStream4ivATI, void  (GLenum stream, const GLint *v) );
    MOCK_METHOD5( VertexStream4sATI, void  (GLenum stream, GLshort x, GLshort y, GLshort z, GLshort w) );
    MOCK_METHOD2( VertexStream4svATI, void  (GLenum stream, const GLshort *v) );
    MOCK_METHOD2( GetUniformBufferSizeEXT, GLint  (GLuint program, GLint location) );
    MOCK_METHOD2( GetUniformOffsetEXT, GLintptr  (GLuint program, GLint location) );
    MOCK_METHOD3( UniformBufferEXT, void  (GLuint program, GLint location, GLuint buffer) );
    MOCK_METHOD4( BlendColorEXT, void  (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) );
    MOCK_METHOD2( BlendEquationSeparateEXT, void  (GLenum modeRGB, GLenum modeAlpha) );
    MOCK_METHOD4( BlendFuncSeparateEXT, void  (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha) );
    MOCK_METHOD1( BlendEquationEXT, void  (GLenum mode) );
    MOCK_METHOD6( ColorSubTableEXT, void  (GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const void* data) );
    MOCK_METHOD5( CopyColorSubTableEXT, void  (GLenum target, GLsizei start, GLint x, GLint y, GLsizei width) );
    MOCK_METHOD2( LockArraysEXT, void  (GLint first, GLsizei count) );
    MOCK_METHOD0( UnlockArraysEXT, void  (void) );
    MOCK_METHOD6( ConvolutionFilter1DEXT, void  (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void* image) );
    MOCK_METHOD7( ConvolutionFilter2DEXT, void  (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void* image) );
    MOCK_METHOD3( ConvolutionParameterfEXT, void  (GLenum target, GLenum pname, GLfloat param) );
    MOCK_METHOD3( ConvolutionParameterfvEXT, void  (GLenum target, GLenum pname, const GLfloat* params) );
    MOCK_METHOD3( ConvolutionParameteriEXT, void  (GLenum target, GLenum pname, GLint param) );
    MOCK_METHOD3( ConvolutionParameterivEXT, void  (GLenum target, GLenum pname, const GLint* params) );
    MOCK_METHOD5( CopyConvolutionFilter1DEXT, void  (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) );
    MOCK_METHOD6( CopyConvolutionFilter2DEXT, void  (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height) );
    MOCK_METHOD4( GetConvolutionFilterEXT, void  (GLenum target, GLenum format, GLenum type, void* image) );
    MOCK_METHOD3( GetConvolutionParameterfvEXT, void  (GLenum target, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetConvolutionParameterivEXT, void  (GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD6( GetSeparableFilterEXT, void  (GLenum target, GLenum format, GLenum type, void* row, void* column, void* span) );
    MOCK_METHOD8( SeparableFilter2DEXT, void  (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void* row, const void* column) );
    MOCK_METHOD3( BinormalPointerEXT, void  (GLenum type, GLsizei stride, void* pointer) );
    MOCK_METHOD3( TangentPointerEXT, void  (GLenum type, GLsizei stride, void* pointer) );
    MOCK_METHOD7( CopyTexImage1DEXT, void  (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border) );
    MOCK_METHOD8( CopyTexImage2DEXT, void  (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border) );
    MOCK_METHOD6( CopyTexSubImage1DEXT, void  (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width) );
    MOCK_METHOD8( CopyTexSubImage2DEXT, void  (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) );
    MOCK_METHOD9( CopyTexSubImage3DEXT, void  (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) );
    MOCK_METHOD2( CullParameterdvEXT, void  (GLenum pname, GLdouble* params) );
    MOCK_METHOD2( CullParameterfvEXT, void  (GLenum pname, GLfloat* params) );
    MOCK_METHOD2( DepthBoundsEXT, void  (GLclampd zmin, GLclampd zmax) );
    MOCK_METHOD3( BindMultiTextureEXT, void  (GLenum texunit, GLenum target, GLuint texture) );
    MOCK_METHOD2( CheckNamedFramebufferStatusEXT, GLenum  (GLuint framebuffer, GLenum target) );
    MOCK_METHOD1( ClientAttribDefaultEXT, void  (GLbitfield mask) );
    MOCK_METHOD8( CompressedMultiTexImage1DEXT, void  (GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void* data) );
    MOCK_METHOD9( CompressedMultiTexImage2DEXT, void  (GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void* data) );
    MOCK_METHOD10( CompressedMultiTexImage3DEXT, void  (GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void* data) );
    MOCK_METHOD8( CompressedMultiTexSubImage1DEXT, void  (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void* data) );
    MOCK_METHOD10( CompressedMultiTexSubImage2DEXT, void  (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void* data) );
    MOCK_METHOD12( CompressedMultiTexSubImage3DEXT, void  (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void* data) );
    MOCK_METHOD8( CompressedTextureImage1DEXT, void  (GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void* data) );
    MOCK_METHOD9( CompressedTextureImage2DEXT, void  (GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void* data) );
    MOCK_METHOD10( CompressedTextureImage3DEXT, void  (GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void* data) );
    MOCK_METHOD8( CompressedTextureSubImage1DEXT, void  (GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void* data) );
    MOCK_METHOD10( CompressedTextureSubImage2DEXT, void  (GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void* data) );
    MOCK_METHOD12( CompressedTextureSubImage3DEXT, void  (GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void* data) );
    MOCK_METHOD8( CopyMultiTexImage1DEXT, void  (GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border) );
    MOCK_METHOD9( CopyMultiTexImage2DEXT, void  (GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border) );
    MOCK_METHOD7( CopyMultiTexSubImage1DEXT, void  (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width) );
    MOCK_METHOD9( CopyMultiTexSubImage2DEXT, void  (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) );
    MOCK_METHOD10( CopyMultiTexSubImage3DEXT, void  (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) );
    MOCK_METHOD8( CopyTextureImage1DEXT, void  (GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border) );
    MOCK_METHOD9( CopyTextureImage2DEXT, void  (GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border) );
    MOCK_METHOD7( CopyTextureSubImage1DEXT, void  (GLuint texture, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width) );
    MOCK_METHOD9( CopyTextureSubImage2DEXT, void  (GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) );
    MOCK_METHOD10( CopyTextureSubImage3DEXT, void  (GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) );
    MOCK_METHOD2( DisableClientStateIndexedEXT, void  (GLenum array, GLuint index) );
    MOCK_METHOD2( DisableClientStateiEXT, void  (GLenum array, GLuint index) );
    MOCK_METHOD2( DisableVertexArrayAttribEXT, void  (GLuint vaobj, GLuint index) );
    MOCK_METHOD2( DisableVertexArrayEXT, void  (GLuint vaobj, GLenum array) );
    MOCK_METHOD2( EnableClientStateIndexedEXT, void  (GLenum array, GLuint index) );
    MOCK_METHOD2( EnableClientStateiEXT, void  (GLenum array, GLuint index) );
    MOCK_METHOD2( EnableVertexArrayAttribEXT, void  (GLuint vaobj, GLuint index) );
    MOCK_METHOD2( EnableVertexArrayEXT, void  (GLuint vaobj, GLenum array) );
    MOCK_METHOD3( FlushMappedNamedBufferRangeEXT, void  (GLuint buffer, GLintptr offset, GLsizeiptr length) );
    MOCK_METHOD2( FramebufferDrawBufferEXT, void  (GLuint framebuffer, GLenum mode) );
    MOCK_METHOD3( FramebufferDrawBuffersEXT, void  (GLuint framebuffer, GLsizei n, const GLenum* bufs) );
    MOCK_METHOD2( FramebufferReadBufferEXT, void  (GLuint framebuffer, GLenum mode) );
    MOCK_METHOD2( GenerateMultiTexMipmapEXT, void  (GLenum texunit, GLenum target) );
    MOCK_METHOD2( GenerateTextureMipmapEXT, void  (GLuint texture, GLenum target) );
    MOCK_METHOD4( GetCompressedMultiTexImageEXT, void  (GLenum texunit, GLenum target, GLint level, void* img) );
    MOCK_METHOD4( GetCompressedTextureImageEXT, void  (GLuint texture, GLenum target, GLint level, void* img) );
    MOCK_METHOD3( GetDoubleIndexedvEXT, void  (GLenum target, GLuint index, GLdouble* params) );
    MOCK_METHOD3( GetDoublei_vEXT, void  (GLenum pname, GLuint index, GLdouble* params) );
    MOCK_METHOD3( GetFloatIndexedvEXT, void  (GLenum target, GLuint index, GLfloat* params) );
    MOCK_METHOD3( GetFloati_vEXT, void  (GLenum pname, GLuint index, GLfloat* params) );
    MOCK_METHOD3( GetFramebufferParameterivEXT, void  (GLuint framebuffer, GLenum pname, GLint* param) );
    MOCK_METHOD4( GetMultiTexEnvfvEXT, void  (GLenum texunit, GLenum target, GLenum pname, GLfloat* params) );
    MOCK_METHOD4( GetMultiTexEnvivEXT, void  (GLenum texunit, GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD4( GetMultiTexGendvEXT, void  (GLenum texunit, GLenum coord, GLenum pname, GLdouble* params) );
    MOCK_METHOD4( GetMultiTexGenfvEXT, void  (GLenum texunit, GLenum coord, GLenum pname, GLfloat* params) );
    MOCK_METHOD4( GetMultiTexGenivEXT, void  (GLenum texunit, GLenum coord, GLenum pname, GLint* params) );
    MOCK_METHOD6( GetMultiTexImageEXT, void  (GLenum texunit, GLenum target, GLint level, GLenum format, GLenum type, void* pixels) );
    MOCK_METHOD5( GetMultiTexLevelParameterfvEXT, void  (GLenum texunit, GLenum target, GLint level, GLenum pname, GLfloat* params) );
    MOCK_METHOD5( GetMultiTexLevelParameterivEXT, void  (GLenum texunit, GLenum target, GLint level, GLenum pname, GLint* params) );
    MOCK_METHOD4( GetMultiTexParameterIivEXT, void  (GLenum texunit, GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD4( GetMultiTexParameterIuivEXT, void  (GLenum texunit, GLenum target, GLenum pname, GLuint* params) );
    MOCK_METHOD4( GetMultiTexParameterfvEXT, void  (GLenum texunit, GLenum target, GLenum pname, GLfloat* params) );
    MOCK_METHOD4( GetMultiTexParameterivEXT, void  (GLenum texunit, GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetNamedBufferParameterivEXT, void  (GLuint buffer, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetNamedBufferPointervEXT, void  (GLuint buffer, GLenum pname, void** params) );
    MOCK_METHOD4( GetNamedBufferSubDataEXT, void  (GLuint buffer, GLintptr offset, GLsizeiptr size, void* data) );
    MOCK_METHOD4( GetNamedFramebufferAttachmentParameterivEXT, void  (GLuint framebuffer, GLenum attachment, GLenum pname, GLint* params) );
    MOCK_METHOD4( GetNamedProgramLocalParameterIivEXT, void  (GLuint program, GLenum target, GLuint index, GLint* params) );
    MOCK_METHOD4( GetNamedProgramLocalParameterIuivEXT, void  (GLuint program, GLenum target, GLuint index, GLuint* params) );
    MOCK_METHOD4( GetNamedProgramLocalParameterdvEXT, void  (GLuint program, GLenum target, GLuint index, GLdouble* params) );
    MOCK_METHOD4( GetNamedProgramLocalParameterfvEXT, void  (GLuint program, GLenum target, GLuint index, GLfloat* params) );
    MOCK_METHOD4( GetNamedProgramStringEXT, void  (GLuint program, GLenum target, GLenum pname, void* string) );
    MOCK_METHOD4( GetNamedProgramivEXT, void  (GLuint program, GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetNamedRenderbufferParameterivEXT, void  (GLuint renderbuffer, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetPointerIndexedvEXT, void  (GLenum target, GLuint index, GLvoid** params) );
    MOCK_METHOD3( GetPointeri_vEXT, void  (GLenum pname, GLuint index, GLvoid** params) );
    MOCK_METHOD6( GetTextureImageEXT, void  (GLuint texture, GLenum target, GLint level, GLenum format, GLenum type, void* pixels) );
    MOCK_METHOD5( GetTextureLevelParameterfvEXT, void  (GLuint texture, GLenum target, GLint level, GLenum pname, GLfloat* params) );
    MOCK_METHOD5( GetTextureLevelParameterivEXT, void  (GLuint texture, GLenum target, GLint level, GLenum pname, GLint* params) );
    MOCK_METHOD4( GetTextureParameterIivEXT, void  (GLuint texture, GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD4( GetTextureParameterIuivEXT, void  (GLuint texture, GLenum target, GLenum pname, GLuint* params) );
    MOCK_METHOD4( GetTextureParameterfvEXT, void  (GLuint texture, GLenum target, GLenum pname, GLfloat* params) );
    MOCK_METHOD4( GetTextureParameterivEXT, void  (GLuint texture, GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD4( GetVertexArrayIntegeri_vEXT, void  (GLuint vaobj, GLuint index, GLenum pname, GLint* param) );
    MOCK_METHOD3( GetVertexArrayIntegervEXT, void  (GLuint vaobj, GLenum pname, GLint* param) );
    MOCK_METHOD4( GetVertexArrayPointeri_vEXT, void  (GLuint vaobj, GLuint index, GLenum pname, GLvoid** param) );
    MOCK_METHOD3( GetVertexArrayPointervEXT, void  (GLuint vaobj, GLenum pname, GLvoid** param) );
    MOCK_METHOD2( MapNamedBufferEXT, GLvoid *  (GLuint buffer, GLenum access) );
    MOCK_METHOD4( MapNamedBufferRangeEXT, GLvoid *  (GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access) );
    MOCK_METHOD7( MatrixFrustumEXT, void  (GLenum matrixMode, GLdouble l, GLdouble r, GLdouble b, GLdouble t, GLdouble n, GLdouble f) );
    MOCK_METHOD1( MatrixLoadIdentityEXT, void  (GLenum matrixMode) );
    MOCK_METHOD2( MatrixLoadTransposedEXT, void  (GLenum matrixMode, const GLdouble* m) );
    MOCK_METHOD2( MatrixLoadTransposefEXT, void  (GLenum matrixMode, const GLfloat* m) );
    MOCK_METHOD2( MatrixLoaddEXT, void  (GLenum matrixMode, const GLdouble* m) );
    MOCK_METHOD2( MatrixLoadfEXT, void  (GLenum matrixMode, const GLfloat* m) );
    MOCK_METHOD2( MatrixMultTransposedEXT, void  (GLenum matrixMode, const GLdouble* m) );
    MOCK_METHOD2( MatrixMultTransposefEXT, void  (GLenum matrixMode, const GLfloat* m) );
    MOCK_METHOD2( MatrixMultdEXT, void  (GLenum matrixMode, const GLdouble* m) );
    MOCK_METHOD2( MatrixMultfEXT, void  (GLenum matrixMode, const GLfloat* m) );
    MOCK_METHOD7( MatrixOrthoEXT, void  (GLenum matrixMode, GLdouble l, GLdouble r, GLdouble b, GLdouble t, GLdouble n, GLdouble f) );
    MOCK_METHOD1( MatrixPopEXT, void  (GLenum matrixMode) );
    MOCK_METHOD1( MatrixPushEXT, void  (GLenum matrixMode) );
    MOCK_METHOD5( MatrixRotatedEXT, void  (GLenum matrixMode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD5( MatrixRotatefEXT, void  (GLenum matrixMode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD4( MatrixScaledEXT, void  (GLenum matrixMode, GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD4( MatrixScalefEXT, void  (GLenum matrixMode, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD4( MatrixTranslatedEXT, void  (GLenum matrixMode, GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD4( MatrixTranslatefEXT, void  (GLenum matrixMode, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD4( MultiTexBufferEXT, void  (GLenum texunit, GLenum target, GLenum internalformat, GLuint buffer) );
    MOCK_METHOD5( MultiTexCoordPointerEXT, void  (GLenum texunit, GLint size, GLenum type, GLsizei stride, const void* pointer) );
    MOCK_METHOD4( MultiTexEnvfEXT, void  (GLenum texunit, GLenum target, GLenum pname, GLfloat param) );
    MOCK_METHOD4( MultiTexEnvfvEXT, void  (GLenum texunit, GLenum target, GLenum pname, const GLfloat* params) );
    MOCK_METHOD4( MultiTexEnviEXT, void  (GLenum texunit, GLenum target, GLenum pname, GLint param) );
    MOCK_METHOD4( MultiTexEnvivEXT, void  (GLenum texunit, GLenum target, GLenum pname, const GLint* params) );
    MOCK_METHOD4( MultiTexGendEXT, void  (GLenum texunit, GLenum coord, GLenum pname, GLdouble param) );
    MOCK_METHOD4( MultiTexGendvEXT, void  (GLenum texunit, GLenum coord, GLenum pname, const GLdouble* params) );
    MOCK_METHOD4( MultiTexGenfEXT, void  (GLenum texunit, GLenum coord, GLenum pname, GLfloat param) );
    MOCK_METHOD4( MultiTexGenfvEXT, void  (GLenum texunit, GLenum coord, GLenum pname, const GLfloat* params) );
    MOCK_METHOD4( MultiTexGeniEXT, void  (GLenum texunit, GLenum coord, GLenum pname, GLint param) );
    MOCK_METHOD4( MultiTexGenivEXT, void  (GLenum texunit, GLenum coord, GLenum pname, const GLint* params) );
    MOCK_METHOD9( MultiTexImage1DEXT, void  (GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD10( MultiTexImage2DEXT, void  (GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD11( MultiTexImage3DEXT, void  (GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD4( MultiTexParameterIivEXT, void  (GLenum texunit, GLenum target, GLenum pname, const GLint* params) );
    MOCK_METHOD4( MultiTexParameterIuivEXT, void  (GLenum texunit, GLenum target, GLenum pname, const GLuint* params) );
    MOCK_METHOD4( MultiTexParameterfEXT, void  (GLenum texunit, GLenum target, GLenum pname, GLfloat param) );
    MOCK_METHOD4( MultiTexParameterfvEXT, void  (GLenum texunit, GLenum target, GLenum pname, const GLfloat* param) );
    MOCK_METHOD4( MultiTexParameteriEXT, void  (GLenum texunit, GLenum target, GLenum pname, GLint param) );
    MOCK_METHOD4( MultiTexParameterivEXT, void  (GLenum texunit, GLenum target, GLenum pname, const GLint* param) );
    MOCK_METHOD3( MultiTexRenderbufferEXT, void  (GLenum texunit, GLenum target, GLuint renderbuffer) );
    MOCK_METHOD8( MultiTexSubImage1DEXT, void  (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD10( MultiTexSubImage2DEXT, void  (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD12( MultiTexSubImage3DEXT, void  (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD4( NamedBufferDataEXT, void  (GLuint buffer, GLsizeiptr size, const void* data, GLenum usage) );
    MOCK_METHOD4( NamedBufferSubDataEXT, void  (GLuint buffer, GLintptr offset, GLsizeiptr size, const void* data) );
    MOCK_METHOD5( NamedCopyBufferSubDataEXT, void  (GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size) );
    MOCK_METHOD4( NamedFramebufferRenderbufferEXT, void  (GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) );
    MOCK_METHOD5( NamedFramebufferTexture1DEXT, void  (GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level) );
    MOCK_METHOD5( NamedFramebufferTexture2DEXT, void  (GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level) );
    MOCK_METHOD6( NamedFramebufferTexture3DEXT, void  (GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset) );
    MOCK_METHOD4( NamedFramebufferTextureEXT, void  (GLuint framebuffer, GLenum attachment, GLuint texture, GLint level) );
    MOCK_METHOD5( NamedFramebufferTextureFaceEXT, void  (GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLenum face) );
    MOCK_METHOD5( NamedFramebufferTextureLayerEXT, void  (GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer) );
    MOCK_METHOD7( NamedProgramLocalParameter4dEXT, void  (GLuint program, GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) );
    MOCK_METHOD4( NamedProgramLocalParameter4dvEXT, void  (GLuint program, GLenum target, GLuint index, const GLdouble* params) );
    MOCK_METHOD7( NamedProgramLocalParameter4fEXT, void  (GLuint program, GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) );
    MOCK_METHOD4( NamedProgramLocalParameter4fvEXT, void  (GLuint program, GLenum target, GLuint index, const GLfloat* params) );
    MOCK_METHOD7( NamedProgramLocalParameterI4iEXT, void  (GLuint program, GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w) );
    MOCK_METHOD4( NamedProgramLocalParameterI4ivEXT, void  (GLuint program, GLenum target, GLuint index, const GLint* params) );
    MOCK_METHOD7( NamedProgramLocalParameterI4uiEXT, void  (GLuint program, GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w) );
    MOCK_METHOD4( NamedProgramLocalParameterI4uivEXT, void  (GLuint program, GLenum target, GLuint index, const GLuint* params) );
    MOCK_METHOD5( NamedProgramLocalParameters4fvEXT, void  (GLuint program, GLenum target, GLuint index, GLsizei count, const GLfloat* params) );
    MOCK_METHOD5( NamedProgramLocalParametersI4ivEXT, void  (GLuint program, GLenum target, GLuint index, GLsizei count, const GLint* params) );
    MOCK_METHOD5( NamedProgramLocalParametersI4uivEXT, void  (GLuint program, GLenum target, GLuint index, GLsizei count, const GLuint* params) );
    MOCK_METHOD5( NamedProgramStringEXT, void  (GLuint program, GLenum target, GLenum format, GLsizei len, const void* string) );
    MOCK_METHOD4( NamedRenderbufferStorageEXT, void  (GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height) );
    MOCK_METHOD6( NamedRenderbufferStorageMultisampleCoverageEXT, void  (GLuint renderbuffer, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height) );
    MOCK_METHOD5( NamedRenderbufferStorageMultisampleEXT, void  (GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) );
    MOCK_METHOD3( ProgramUniform1fEXT, void  (GLuint program, GLint location, GLfloat v0) );
    MOCK_METHOD4( ProgramUniform1fvEXT, void  (GLuint program, GLint location, GLsizei count, const GLfloat* value) );
    MOCK_METHOD3( ProgramUniform1iEXT, void  (GLuint program, GLint location, GLint v0) );
    MOCK_METHOD4( ProgramUniform1ivEXT, void  (GLuint program, GLint location, GLsizei count, const GLint* value) );
    MOCK_METHOD3( ProgramUniform1uiEXT, void  (GLuint program, GLint location, GLuint v0) );
    MOCK_METHOD4( ProgramUniform1uivEXT, void  (GLuint program, GLint location, GLsizei count, const GLuint* value) );
    MOCK_METHOD4( ProgramUniform2fEXT, void  (GLuint program, GLint location, GLfloat v0, GLfloat v1) );
    MOCK_METHOD4( ProgramUniform2fvEXT, void  (GLuint program, GLint location, GLsizei count, const GLfloat* value) );
    MOCK_METHOD4( ProgramUniform2iEXT, void  (GLuint program, GLint location, GLint v0, GLint v1) );
    MOCK_METHOD4( ProgramUniform2ivEXT, void  (GLuint program, GLint location, GLsizei count, const GLint* value) );
    MOCK_METHOD4( ProgramUniform2uiEXT, void  (GLuint program, GLint location, GLuint v0, GLuint v1) );
    MOCK_METHOD4( ProgramUniform2uivEXT, void  (GLuint program, GLint location, GLsizei count, const GLuint* value) );
    MOCK_METHOD5( ProgramUniform3fEXT, void  (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2) );
    MOCK_METHOD4( ProgramUniform3fvEXT, void  (GLuint program, GLint location, GLsizei count, const GLfloat* value) );
    MOCK_METHOD5( ProgramUniform3iEXT, void  (GLuint program, GLint location, GLint v0, GLint v1, GLint v2) );
    MOCK_METHOD4( ProgramUniform3ivEXT, void  (GLuint program, GLint location, GLsizei count, const GLint* value) );
    MOCK_METHOD5( ProgramUniform3uiEXT, void  (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2) );
    MOCK_METHOD4( ProgramUniform3uivEXT, void  (GLuint program, GLint location, GLsizei count, const GLuint* value) );
    MOCK_METHOD6( ProgramUniform4fEXT, void  (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3) );
    MOCK_METHOD4( ProgramUniform4fvEXT, void  (GLuint program, GLint location, GLsizei count, const GLfloat* value) );
    MOCK_METHOD6( ProgramUniform4iEXT, void  (GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3) );
    MOCK_METHOD4( ProgramUniform4ivEXT, void  (GLuint program, GLint location, GLsizei count, const GLint* value) );
    MOCK_METHOD6( ProgramUniform4uiEXT, void  (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3) );
    MOCK_METHOD4( ProgramUniform4uivEXT, void  (GLuint program, GLint location, GLsizei count, const GLuint* value) );
    MOCK_METHOD5( ProgramUniformMatrix2fvEXT, void  (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) );
    MOCK_METHOD5( ProgramUniformMatrix2x3fvEXT, void  (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) );
    MOCK_METHOD5( ProgramUniformMatrix2x4fvEXT, void  (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) );
    MOCK_METHOD5( ProgramUniformMatrix3fvEXT, void  (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) );
    MOCK_METHOD5( ProgramUniformMatrix3x2fvEXT, void  (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) );
    MOCK_METHOD5( ProgramUniformMatrix3x4fvEXT, void  (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) );
    MOCK_METHOD5( ProgramUniformMatrix4fvEXT, void  (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) );
    MOCK_METHOD5( ProgramUniformMatrix4x2fvEXT, void  (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) );
    MOCK_METHOD5( ProgramUniformMatrix4x3fvEXT, void  (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) );
    MOCK_METHOD1( PushClientAttribDefaultEXT, void  (GLbitfield mask) );
    MOCK_METHOD4( TextureBufferEXT, void  (GLuint texture, GLenum target, GLenum internalformat, GLuint buffer) );
    MOCK_METHOD9( TextureImage1DEXT, void  (GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD10( TextureImage2DEXT, void  (GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD11( TextureImage3DEXT, void  (GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD4( TextureParameterIivEXT, void  (GLuint texture, GLenum target, GLenum pname, const GLint* params) );
    MOCK_METHOD4( TextureParameterIuivEXT, void  (GLuint texture, GLenum target, GLenum pname, const GLuint* params) );
    MOCK_METHOD4( TextureParameterfEXT, void  (GLuint texture, GLenum target, GLenum pname, GLfloat param) );
    MOCK_METHOD4( TextureParameterfvEXT, void  (GLuint texture, GLenum target, GLenum pname, const GLfloat* param) );
    MOCK_METHOD4( TextureParameteriEXT, void  (GLuint texture, GLenum target, GLenum pname, GLint param) );
    MOCK_METHOD4( TextureParameterivEXT, void  (GLuint texture, GLenum target, GLenum pname, const GLint* param) );
    MOCK_METHOD3( TextureRenderbufferEXT, void  (GLuint texture, GLenum target, GLuint renderbuffer) );
    MOCK_METHOD8( TextureSubImage1DEXT, void  (GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD10( TextureSubImage2DEXT, void  (GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD12( TextureSubImage3DEXT, void  (GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD1( UnmapNamedBufferEXT, GLboolean  (GLuint buffer) );
    MOCK_METHOD6( VertexArrayColorOffsetEXT, void  (GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset) );
    MOCK_METHOD4( VertexArrayEdgeFlagOffsetEXT, void  (GLuint vaobj, GLuint buffer, GLsizei stride, GLintptr offset) );
    MOCK_METHOD5( VertexArrayFogCoordOffsetEXT, void  (GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset) );
    MOCK_METHOD5( VertexArrayIndexOffsetEXT, void  (GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset) );
    MOCK_METHOD7( VertexArrayMultiTexCoordOffsetEXT, void  (GLuint vaobj, GLuint buffer, GLenum texunit, GLint size, GLenum type, GLsizei stride, GLintptr offset) );
    MOCK_METHOD5( VertexArrayNormalOffsetEXT, void  (GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset) );
    MOCK_METHOD6( VertexArraySecondaryColorOffsetEXT, void  (GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset) );
    MOCK_METHOD6( VertexArrayTexCoordOffsetEXT, void  (GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset) );
    MOCK_METHOD7( VertexArrayVertexAttribIOffsetEXT, void  (GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset) );
    MOCK_METHOD8( VertexArrayVertexAttribOffsetEXT, void  (GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLintptr offset) );
    MOCK_METHOD6( VertexArrayVertexOffsetEXT, void  (GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset) );
    MOCK_METHOD5( ColorMaskIndexedEXT, void  (GLuint buf, GLboolean r, GLboolean g, GLboolean b, GLboolean a) );
    MOCK_METHOD2( DisableIndexedEXT, void  (GLenum target, GLuint index) );
    MOCK_METHOD2( EnableIndexedEXT, void  (GLenum target, GLuint index) );
    MOCK_METHOD3( GetBooleanIndexedvEXT, void  (GLenum value, GLuint index, GLboolean* data) );
    MOCK_METHOD3( GetIntegerIndexedvEXT, void  (GLenum value, GLuint index, GLint* data) );
    MOCK_METHOD2( IsEnabledIndexedEXT, GLboolean  (GLenum target, GLuint index) );
    MOCK_METHOD4( DrawArraysInstancedEXT, void  (GLenum mode, GLint start, GLsizei count, GLsizei primcount) );
    MOCK_METHOD5( DrawElementsInstancedEXT, void  (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei primcount) );
    MOCK_METHOD6( DrawRangeElementsEXT, void  (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices) );
    MOCK_METHOD3( FogCoordPointerEXT, void  (GLenum type, GLsizei stride, const GLvoid *pointer) );
    MOCK_METHOD1( FogCoorddEXT, void  (GLdouble coord) );
    MOCK_METHOD1( FogCoorddvEXT, void  (const GLdouble *coord) );
    MOCK_METHOD1( FogCoordfEXT, void  (GLfloat coord) );
    MOCK_METHOD1( FogCoordfvEXT, void  (const GLfloat *coord) );
    MOCK_METHOD2( FragmentColorMaterialEXT, void  (GLenum face, GLenum mode) );
    MOCK_METHOD2( FragmentLightModelfEXT, void  (GLenum pname, GLfloat param) );
    MOCK_METHOD2( FragmentLightModelfvEXT, void  (GLenum pname, GLfloat* params) );
    MOCK_METHOD2( FragmentLightModeliEXT, void  (GLenum pname, GLint param) );
    MOCK_METHOD2( FragmentLightModelivEXT, void  (GLenum pname, GLint* params) );
    MOCK_METHOD3( FragmentLightfEXT, void  (GLenum light, GLenum pname, GLfloat param) );
    MOCK_METHOD3( FragmentLightfvEXT, void  (GLenum light, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( FragmentLightiEXT, void  (GLenum light, GLenum pname, GLint param) );
    MOCK_METHOD3( FragmentLightivEXT, void  (GLenum light, GLenum pname, GLint* params) );
    MOCK_METHOD3( FragmentMaterialfEXT, void  (GLenum face, GLenum pname, const GLfloat param) );
    MOCK_METHOD3( FragmentMaterialfvEXT, void  (GLenum face, GLenum pname, const GLfloat* params) );
    MOCK_METHOD3( FragmentMaterialiEXT, void  (GLenum face, GLenum pname, const GLint param) );
    MOCK_METHOD3( FragmentMaterialivEXT, void  (GLenum face, GLenum pname, const GLint* params) );
    MOCK_METHOD3( GetFragmentLightfvEXT, void  (GLenum light, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetFragmentLightivEXT, void  (GLenum light, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetFragmentMaterialfvEXT, void  (GLenum face, GLenum pname, const GLfloat* params) );
    MOCK_METHOD3( GetFragmentMaterialivEXT, void  (GLenum face, GLenum pname, const GLint* params) );
    MOCK_METHOD2( LightEnviEXT, void  (GLenum pname, GLint param) );
    MOCK_METHOD10( BlitFramebufferEXT, void  (GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) );
    MOCK_METHOD5( RenderbufferStorageMultisampleEXT, void  (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) );
    MOCK_METHOD2( BindFramebufferEXT, void  (GLenum target, GLuint framebuffer) );
    MOCK_METHOD2( BindRenderbufferEXT, void  (GLenum target, GLuint renderbuffer) );
    MOCK_METHOD1( CheckFramebufferStatusEXT, GLenum  (GLenum target) );
    MOCK_METHOD2( DeleteFramebuffersEXT, void  (GLsizei n, const GLuint* framebuffers) );
    MOCK_METHOD2( DeleteRenderbuffersEXT, void  (GLsizei n, const GLuint* renderbuffers) );
    MOCK_METHOD4( FramebufferRenderbufferEXT, void  (GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) );
    MOCK_METHOD5( FramebufferTexture1DEXT, void  (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) );
    MOCK_METHOD5( FramebufferTexture2DEXT, void  (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) );
    MOCK_METHOD6( FramebufferTexture3DEXT, void  (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset) );
    MOCK_METHOD2( GenFramebuffersEXT, void  (GLsizei n, GLuint* framebuffers) );
    MOCK_METHOD2( GenRenderbuffersEXT, void  (GLsizei n, GLuint* renderbuffers) );
    MOCK_METHOD1( GenerateMipmapEXT, void  (GLenum target) );
    MOCK_METHOD4( GetFramebufferAttachmentParameterivEXT, void  (GLenum target, GLenum attachment, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetRenderbufferParameterivEXT, void  (GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD1( IsFramebufferEXT, GLboolean  (GLuint framebuffer) );
    MOCK_METHOD1( IsRenderbufferEXT, GLboolean  (GLuint renderbuffer) );
    MOCK_METHOD4( RenderbufferStorageEXT, void  (GLenum target, GLenum internalformat, GLsizei width, GLsizei height) );
    MOCK_METHOD4( FramebufferTextureEXT, void  (GLenum target, GLenum attachment, GLuint texture, GLint level) );
    MOCK_METHOD5( FramebufferTextureFaceEXT, void  (GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face) );
    MOCK_METHOD5( FramebufferTextureLayerEXT, void  (GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer) );
    MOCK_METHOD3( ProgramParameteriEXT, void  (GLuint program, GLenum pname, GLint value) );
    MOCK_METHOD4( ProgramEnvParameters4fvEXT, void  (GLenum target, GLuint index, GLsizei count, const GLfloat* params) );
    MOCK_METHOD4( ProgramLocalParameters4fvEXT, void  (GLenum target, GLuint index, GLsizei count, const GLfloat* params) );
    MOCK_METHOD3( BindFragDataLocationEXT, void  (GLuint program, GLuint color, const GLchar *name) );
    MOCK_METHOD2( GetFragDataLocationEXT, GLint  (GLuint program, const GLchar *name) );
    MOCK_METHOD3( GetUniformuivEXT, void  (GLuint program, GLint location, GLuint *params) );
    MOCK_METHOD3( GetVertexAttribIivEXT, void  (GLuint index, GLenum pname, GLint *params) );
    MOCK_METHOD3( GetVertexAttribIuivEXT, void  (GLuint index, GLenum pname, GLuint *params) );
    MOCK_METHOD2( Uniform1uiEXT, void  (GLint location, GLuint v0) );
    MOCK_METHOD3( Uniform1uivEXT, void  (GLint location, GLsizei count, const GLuint *value) );
    MOCK_METHOD3( Uniform2uiEXT, void  (GLint location, GLuint v0, GLuint v1) );
    MOCK_METHOD3( Uniform2uivEXT, void  (GLint location, GLsizei count, const GLuint *value) );
    MOCK_METHOD4( Uniform3uiEXT, void  (GLint location, GLuint v0, GLuint v1, GLuint v2) );
    MOCK_METHOD3( Uniform3uivEXT, void  (GLint location, GLsizei count, const GLuint *value) );
    MOCK_METHOD5( Uniform4uiEXT, void  (GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3) );
    MOCK_METHOD3( Uniform4uivEXT, void  (GLint location, GLsizei count, const GLuint *value) );
    MOCK_METHOD2( VertexAttribI1iEXT, void  (GLuint index, GLint x) );
    MOCK_METHOD2( VertexAttribI1ivEXT, void  (GLuint index, const GLint *v) );
    MOCK_METHOD2( VertexAttribI1uiEXT, void  (GLuint index, GLuint x) );
    MOCK_METHOD2( VertexAttribI1uivEXT, void  (GLuint index, const GLuint *v) );
    MOCK_METHOD3( VertexAttribI2iEXT, void  (GLuint index, GLint x, GLint y) );
    MOCK_METHOD2( VertexAttribI2ivEXT, void  (GLuint index, const GLint *v) );
    MOCK_METHOD3( VertexAttribI2uiEXT, void  (GLuint index, GLuint x, GLuint y) );
    MOCK_METHOD2( VertexAttribI2uivEXT, void  (GLuint index, const GLuint *v) );
    MOCK_METHOD4( VertexAttribI3iEXT, void  (GLuint index, GLint x, GLint y, GLint z) );
    MOCK_METHOD2( VertexAttribI3ivEXT, void  (GLuint index, const GLint *v) );
    MOCK_METHOD4( VertexAttribI3uiEXT, void  (GLuint index, GLuint x, GLuint y, GLuint z) );
    MOCK_METHOD2( VertexAttribI3uivEXT, void  (GLuint index, const GLuint *v) );
    MOCK_METHOD2( VertexAttribI4bvEXT, void  (GLuint index, const GLbyte *v) );
    MOCK_METHOD5( VertexAttribI4iEXT, void  (GLuint index, GLint x, GLint y, GLint z, GLint w) );
    MOCK_METHOD2( VertexAttribI4ivEXT, void  (GLuint index, const GLint *v) );
    MOCK_METHOD2( VertexAttribI4svEXT, void  (GLuint index, const GLshort *v) );
    MOCK_METHOD2( VertexAttribI4ubvEXT, void  (GLuint index, const GLubyte *v) );
    MOCK_METHOD5( VertexAttribI4uiEXT, void  (GLuint index, GLuint x, GLuint y, GLuint z, GLuint w) );
    MOCK_METHOD2( VertexAttribI4uivEXT, void  (GLuint index, const GLuint *v) );
    MOCK_METHOD2( VertexAttribI4usvEXT, void  (GLuint index, const GLushort *v) );
    MOCK_METHOD5( VertexAttribIPointerEXT, void  (GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) );
    MOCK_METHOD5( GetHistogramEXT, void  (GLenum target, GLboolean reset, GLenum format, GLenum type, void* values) );
    MOCK_METHOD3( GetHistogramParameterfvEXT, void  (GLenum target, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetHistogramParameterivEXT, void  (GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD5( GetMinmaxEXT, void  (GLenum target, GLboolean reset, GLenum format, GLenum type, void* values) );
    MOCK_METHOD3( GetMinmaxParameterfvEXT, void  (GLenum target, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetMinmaxParameterivEXT, void  (GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD4( HistogramEXT, void  (GLenum target, GLsizei width, GLenum internalformat, GLboolean sink) );
    MOCK_METHOD3( MinmaxEXT, void  (GLenum target, GLenum internalformat, GLboolean sink) );
    MOCK_METHOD1( ResetHistogramEXT, void  (GLenum target) );
    MOCK_METHOD1( ResetMinmaxEXT, void  (GLenum target) );
    MOCK_METHOD2( IndexFuncEXT, void  (GLenum func, GLfloat ref) );
    MOCK_METHOD2( IndexMaterialEXT, void  (GLenum face, GLenum mode) );
    MOCK_METHOD1( ApplyTextureEXT, void  (GLenum mode) );
    MOCK_METHOD1( TextureLightEXT, void  (GLenum pname) );
    MOCK_METHOD2( TextureMaterialEXT, void  (GLenum face, GLenum mode) );
    MOCK_METHOD4( MultiDrawArraysEXT, void  (GLenum mode, GLint* first, GLsizei *count, GLsizei primcount) );
    MOCK_METHOD5( MultiDrawElementsEXT, void  (GLenum mode, GLsizei* count, GLenum type, const GLvoid **indices, GLsizei primcount) );
    MOCK_METHOD2( SampleMaskEXT, void  (GLclampf value, GLboolean invert) );
    MOCK_METHOD1( SamplePatternEXT, void  (GLenum pattern) );
    MOCK_METHOD6( ColorTableEXT, void  (GLenum target, GLenum internalFormat, GLsizei width, GLenum format, GLenum type, const void* data) );
    MOCK_METHOD4( GetColorTableEXT, void  (GLenum target, GLenum format, GLenum type, void* data) );
    MOCK_METHOD3( GetColorTableParameterfvEXT, void  (GLenum target, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetColorTableParameterivEXT, void  (GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetPixelTransformParameterfvEXT, void  (GLenum target, GLenum pname, const GLfloat* params) );
    MOCK_METHOD3( GetPixelTransformParameterivEXT, void  (GLenum target, GLenum pname, const GLint* params) );
    MOCK_METHOD3( PixelTransformParameterfEXT, void  (GLenum target, GLenum pname, const GLfloat param) );
    MOCK_METHOD3( PixelTransformParameterfvEXT, void  (GLenum target, GLenum pname, const GLfloat* params) );
    MOCK_METHOD3( PixelTransformParameteriEXT, void  (GLenum target, GLenum pname, const GLint param) );
    MOCK_METHOD3( PixelTransformParameterivEXT, void  (GLenum target, GLenum pname, const GLint* params) );
    MOCK_METHOD2( PointParameterfEXT, void  (GLenum pname, GLfloat param) );
    MOCK_METHOD2( PointParameterfvEXT, void  (GLenum pname, const GLfloat* params) );
    MOCK_METHOD2( PolygonOffsetEXT, void  (GLfloat factor, GLfloat bias) );
    MOCK_METHOD1( ProvokingVertexEXT, void  (GLenum mode) );
    MOCK_METHOD0( BeginSceneEXT, void  (void) );
    MOCK_METHOD0( EndSceneEXT, void  (void) );
    MOCK_METHOD3( SecondaryColor3bEXT, void  (GLbyte red, GLbyte green, GLbyte blue) );
    MOCK_METHOD1( SecondaryColor3bvEXT, void  (const GLbyte *v) );
    MOCK_METHOD3( SecondaryColor3dEXT, void  (GLdouble red, GLdouble green, GLdouble blue) );
    MOCK_METHOD1( SecondaryColor3dvEXT, void  (const GLdouble *v) );
    MOCK_METHOD3( SecondaryColor3fEXT, void  (GLfloat red, GLfloat green, GLfloat blue) );
    MOCK_METHOD1( SecondaryColor3fvEXT, void  (const GLfloat *v) );
    MOCK_METHOD3( SecondaryColor3iEXT, void  (GLint red, GLint green, GLint blue) );
    MOCK_METHOD1( SecondaryColor3ivEXT, void  (const GLint *v) );
    MOCK_METHOD3( SecondaryColor3sEXT, void  (GLshort red, GLshort green, GLshort blue) );
    MOCK_METHOD1( SecondaryColor3svEXT, void  (const GLshort *v) );
    MOCK_METHOD3( SecondaryColor3ubEXT, void  (GLubyte red, GLubyte green, GLubyte blue) );
    MOCK_METHOD1( SecondaryColor3ubvEXT, void  (const GLubyte *v) );
    MOCK_METHOD3( SecondaryColor3uiEXT, void  (GLuint red, GLuint green, GLuint blue) );
    MOCK_METHOD1( SecondaryColor3uivEXT, void  (const GLuint *v) );
    MOCK_METHOD3( SecondaryColor3usEXT, void  (GLushort red, GLushort green, GLushort blue) );
    MOCK_METHOD1( SecondaryColor3usvEXT, void  (const GLushort *v) );
    MOCK_METHOD4( SecondaryColorPointerEXT, void  (GLint size, GLenum type, GLsizei stride, GLvoid *pointer) );
    MOCK_METHOD1( ActiveProgramEXT, void  (GLuint program) );
    MOCK_METHOD2( CreateShaderProgramEXT, GLuint  (GLenum type, const char* string) );
    MOCK_METHOD2( UseShaderProgramEXT, void  (GLenum type, GLuint program) );
    MOCK_METHOD7( BindImageTextureEXT, void  (GLuint index, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLint format) );
    MOCK_METHOD1( MemoryBarrierEXT, void  (GLbitfield barriers) );
    MOCK_METHOD1( ActiveStencilFaceEXT, void  (GLenum face) );
    MOCK_METHOD7( TexSubImage1DEXT, void  (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD9( TexSubImage2DEXT, void  (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD11( TexSubImage3DEXT, void  (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD10( TexImage3DEXT, void  (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD3( TexBufferEXT, void  (GLenum target, GLenum internalformat, GLuint buffer) );
    MOCK_METHOD4( ClearColorIiEXT, void  (GLint red, GLint green, GLint blue, GLint alpha) );
    MOCK_METHOD4( ClearColorIuiEXT, void  (GLuint red, GLuint green, GLuint blue, GLuint alpha) );
    MOCK_METHOD3( GetTexParameterIivEXT, void  (GLenum target, GLenum pname, GLint *params) );
    MOCK_METHOD3( GetTexParameterIuivEXT, void  (GLenum target, GLenum pname, GLuint *params) );
    MOCK_METHOD3( TexParameterIivEXT, void  (GLenum target, GLenum pname, const GLint *params) );
    MOCK_METHOD3( TexParameterIuivEXT, void  (GLenum target, GLenum pname, const GLuint *params) );
    MOCK_METHOD3( AreTexturesResidentEXT, GLboolean  (GLsizei n, const GLuint* textures, GLboolean* residences) );
    MOCK_METHOD2( BindTextureEXT, void  (GLenum target, GLuint texture) );
    MOCK_METHOD2( DeleteTexturesEXT, void  (GLsizei n, const GLuint* textures) );
    MOCK_METHOD2( GenTexturesEXT, void  (GLsizei n, GLuint* textures) );
    MOCK_METHOD1( IsTextureEXT, GLboolean  (GLuint texture) );
    MOCK_METHOD3( PrioritizeTexturesEXT, void  (GLsizei n, const GLuint* textures, const GLclampf* priorities) );
    MOCK_METHOD1( TextureNormalEXT, void  (GLenum mode) );
    MOCK_METHOD3( GetQueryObjecti64vEXT, void  (GLuint id, GLenum pname, GLint64EXT *params) );
    MOCK_METHOD3( GetQueryObjectui64vEXT, void  (GLuint id, GLenum pname, GLuint64EXT *params) );
    MOCK_METHOD1( BeginTransformFeedbackEXT, void  (GLenum primitiveMode) );
    MOCK_METHOD3( BindBufferBaseEXT, void  (GLenum target, GLuint index, GLuint buffer) );
    MOCK_METHOD4( BindBufferOffsetEXT, void  (GLenum target, GLuint index, GLuint buffer, GLintptr offset) );
    MOCK_METHOD5( BindBufferRangeEXT, void  (GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size) );
    MOCK_METHOD0( EndTransformFeedbackEXT, void  (void) );
    MOCK_METHOD7( GetTransformFeedbackVaryingEXT, void  (GLuint program, GLuint index, GLsizei bufSize, GLsizei* length, GLsizei *size, GLenum *type, char *name) );
    MOCK_METHOD4( TransformFeedbackVaryingsEXT, void  (GLuint program, GLsizei count, const char ** varyings, GLenum bufferMode) );
    MOCK_METHOD1( ArrayElementEXT, void  (GLint i) );
    MOCK_METHOD5( ColorPointerEXT, void  (GLint size, GLenum type, GLsizei stride, GLsizei count, const void* pointer) );
    MOCK_METHOD3( DrawArraysEXT, void  (GLenum mode, GLint first, GLsizei count) );
    MOCK_METHOD3( EdgeFlagPointerEXT, void  (GLsizei stride, GLsizei count, const GLboolean* pointer) );
    MOCK_METHOD2( GetPointervEXT, void  (GLenum pname, void** params) );
    MOCK_METHOD4( IndexPointerEXT, void  (GLenum type, GLsizei stride, GLsizei count, const void* pointer) );
    MOCK_METHOD4( NormalPointerEXT, void  (GLenum type, GLsizei stride, GLsizei count, const void* pointer) );
    MOCK_METHOD5( TexCoordPointerEXT, void  (GLint size, GLenum type, GLsizei stride, GLsizei count, const void* pointer) );
    MOCK_METHOD5( VertexPointerEXT, void  (GLint size, GLenum type, GLsizei stride, GLsizei count, const void* pointer) );
    MOCK_METHOD3( GetVertexAttribLdvEXT, void  (GLuint index, GLenum pname, GLdouble* params) );
    MOCK_METHOD7( VertexArrayVertexAttribLOffsetEXT, void  (GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset) );
    MOCK_METHOD2( VertexAttribL1dEXT, void  (GLuint index, GLdouble x) );
    MOCK_METHOD2( VertexAttribL1dvEXT, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD3( VertexAttribL2dEXT, void  (GLuint index, GLdouble x, GLdouble y) );
    MOCK_METHOD2( VertexAttribL2dvEXT, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD4( VertexAttribL3dEXT, void  (GLuint index, GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD2( VertexAttribL3dvEXT, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD5( VertexAttribL4dEXT, void  (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) );
    MOCK_METHOD2( VertexAttribL4dvEXT, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD5( VertexAttribLPointerEXT, void  (GLuint index, GLint size, GLenum type, GLsizei stride, const void* pointer) );
    MOCK_METHOD0( BeginVertexShaderEXT, void  (void) );
    MOCK_METHOD2( BindLightParameterEXT, GLuint  (GLenum light, GLenum value) );
    MOCK_METHOD2( BindMaterialParameterEXT, GLuint  (GLenum face, GLenum value) );
    MOCK_METHOD1( BindParameterEXT, GLuint  (GLenum value) );
    MOCK_METHOD3( BindTexGenParameterEXT, GLuint  (GLenum unit, GLenum coord, GLenum value) );
    MOCK_METHOD2( BindTextureUnitParameterEXT, GLuint  (GLenum unit, GLenum value) );
    MOCK_METHOD1( BindVertexShaderEXT, void  (GLuint id) );
    MOCK_METHOD1( DeleteVertexShaderEXT, void  (GLuint id) );
    MOCK_METHOD1( DisableVariantClientStateEXT, void  (GLuint id) );
    MOCK_METHOD1( EnableVariantClientStateEXT, void  (GLuint id) );
    MOCK_METHOD0( EndVertexShaderEXT, void  (void) );
    MOCK_METHOD3( ExtractComponentEXT, void  (GLuint res, GLuint src, GLuint num) );
    MOCK_METHOD4( GenSymbolsEXT, GLuint  (GLenum dataType, GLenum storageType, GLenum range, GLuint components) );
    MOCK_METHOD1( GenVertexShadersEXT, GLuint  (GLuint range) );
    MOCK_METHOD3( GetInvariantBooleanvEXT, void  (GLuint id, GLenum value, GLboolean *data) );
    MOCK_METHOD3( GetInvariantFloatvEXT, void  (GLuint id, GLenum value, GLfloat *data) );
    MOCK_METHOD3( GetInvariantIntegervEXT, void  (GLuint id, GLenum value, GLint *data) );
    MOCK_METHOD3( GetLocalConstantBooleanvEXT, void  (GLuint id, GLenum value, GLboolean *data) );
    MOCK_METHOD3( GetLocalConstantFloatvEXT, void  (GLuint id, GLenum value, GLfloat *data) );
    MOCK_METHOD3( GetLocalConstantIntegervEXT, void  (GLuint id, GLenum value, GLint *data) );
    MOCK_METHOD3( GetVariantBooleanvEXT, void  (GLuint id, GLenum value, GLboolean *data) );
    MOCK_METHOD3( GetVariantFloatvEXT, void  (GLuint id, GLenum value, GLfloat *data) );
    MOCK_METHOD3( GetVariantIntegervEXT, void  (GLuint id, GLenum value, GLint *data) );
    MOCK_METHOD3( GetVariantPointervEXT, void  (GLuint id, GLenum value, GLvoid **data) );
    MOCK_METHOD3( InsertComponentEXT, void  (GLuint res, GLuint src, GLuint num) );
    MOCK_METHOD2( IsVariantEnabledEXT, GLboolean  (GLuint id, GLenum cap) );
    MOCK_METHOD3( SetInvariantEXT, void  (GLuint id, GLenum type, GLvoid *addr) );
    MOCK_METHOD3( SetLocalConstantEXT, void  (GLuint id, GLenum type, GLvoid *addr) );
    MOCK_METHOD3( ShaderOp1EXT, void  (GLenum op, GLuint res, GLuint arg1) );
    MOCK_METHOD4( ShaderOp2EXT, void  (GLenum op, GLuint res, GLuint arg1, GLuint arg2) );
    MOCK_METHOD5( ShaderOp3EXT, void  (GLenum op, GLuint res, GLuint arg1, GLuint arg2, GLuint arg3) );
    MOCK_METHOD6( SwizzleEXT, void  (GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW) );
    MOCK_METHOD4( VariantPointerEXT, void  (GLuint id, GLenum type, GLuint stride, GLvoid *addr) );
    MOCK_METHOD2( VariantbvEXT, void  (GLuint id, GLbyte *addr) );
    MOCK_METHOD2( VariantdvEXT, void  (GLuint id, GLdouble *addr) );
    MOCK_METHOD2( VariantfvEXT, void  (GLuint id, GLfloat *addr) );
    MOCK_METHOD2( VariantivEXT, void  (GLuint id, GLint *addr) );
    MOCK_METHOD2( VariantsvEXT, void  (GLuint id, GLshort *addr) );
    MOCK_METHOD2( VariantubvEXT, void  (GLuint id, GLubyte *addr) );
    MOCK_METHOD2( VariantuivEXT, void  (GLuint id, GLuint *addr) );
    MOCK_METHOD2( VariantusvEXT, void  (GLuint id, GLushort *addr) );
    MOCK_METHOD6( WriteMaskEXT, void  (GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW) );
    MOCK_METHOD4( VertexWeightPointerEXT, void  (GLint size, GLenum type, GLsizei stride, void* pointer) );
    MOCK_METHOD1( VertexWeightfEXT, void  (GLfloat weight) );
    MOCK_METHOD1( VertexWeightfvEXT, void  (GLfloat* weight) );
    MOCK_METHOD0( FrameTerminatorGREMEDY, void  (void) );
    MOCK_METHOD2( StringMarkerGREMEDY, void  (GLsizei len, const void* string) );
    MOCK_METHOD3( GetImageTransformParameterfvHP, void  (GLenum target, GLenum pname, const GLfloat* params) );
    MOCK_METHOD3( GetImageTransformParameterivHP, void  (GLenum target, GLenum pname, const GLint* params) );
    MOCK_METHOD3( ImageTransformParameterfHP, void  (GLenum target, GLenum pname, const GLfloat param) );
    MOCK_METHOD3( ImageTransformParameterfvHP, void  (GLenum target, GLenum pname, const GLfloat* params) );
    MOCK_METHOD3( ImageTransformParameteriHP, void  (GLenum target, GLenum pname, const GLint param) );
    MOCK_METHOD3( ImageTransformParameterivHP, void  (GLenum target, GLenum pname, const GLint* params) );
    MOCK_METHOD5( MultiModeDrawArraysIBM, void  (const GLenum* mode, const GLint *first, const GLsizei *count, GLsizei primcount, GLint modestride) );
    MOCK_METHOD6( MultiModeDrawElementsIBM, void  (const GLenum* mode, const GLsizei *count, GLenum type, const GLvoid * const *indices, GLsizei primcount, GLint modestride) );
    MOCK_METHOD5( ColorPointerListIBM, void  (GLint size, GLenum type, GLint stride, const GLvoid ** pointer, GLint ptrstride) );
    MOCK_METHOD3( EdgeFlagPointerListIBM, void  (GLint stride, const GLboolean ** pointer, GLint ptrstride) );
    MOCK_METHOD4( FogCoordPointerListIBM, void  (GLenum type, GLint stride, const GLvoid ** pointer, GLint ptrstride) );
    MOCK_METHOD4( IndexPointerListIBM, void  (GLenum type, GLint stride, const GLvoid ** pointer, GLint ptrstride) );
    MOCK_METHOD4( NormalPointerListIBM, void  (GLenum type, GLint stride, const GLvoid ** pointer, GLint ptrstride) );
    MOCK_METHOD5( SecondaryColorPointerListIBM, void  (GLint size, GLenum type, GLint stride, const GLvoid ** pointer, GLint ptrstride) );
    MOCK_METHOD5( TexCoordPointerListIBM, void  (GLint size, GLenum type, GLint stride, const GLvoid ** pointer, GLint ptrstride) );
    MOCK_METHOD5( VertexPointerListIBM, void  (GLint size, GLenum type, GLint stride, const GLvoid ** pointer, GLint ptrstride) );
    MOCK_METHOD3( ColorPointervINTEL, void  (GLint size, GLenum type, const void** pointer) );
    MOCK_METHOD2( NormalPointervINTEL, void  (GLenum type, const void** pointer) );
    MOCK_METHOD3( TexCoordPointervINTEL, void  (GLint size, GLenum type, const void** pointer) );
    MOCK_METHOD3( VertexPointervINTEL, void  (GLint size, GLenum type, const void** pointer) );
    MOCK_METHOD3( TexScissorFuncINTEL, void  (GLenum target, GLenum lfunc, GLenum hfunc) );
    MOCK_METHOD3( TexScissorINTEL, void  (GLenum target, GLclampf tlow, GLclampf thigh) );
    MOCK_METHOD0( BufferRegionEnabledEXT, GLuint  (void) );
    MOCK_METHOD1( DeleteBufferRegionEXT, void  (GLenum region) );
    MOCK_METHOD7( DrawBufferRegionEXT, void  (GLuint region, GLint x, GLint y, GLsizei width, GLsizei height, GLint xDest, GLint yDest) );
    MOCK_METHOD1( NewBufferRegionEXT, GLuint  (GLenum region) );
    MOCK_METHOD5( ReadBufferRegionEXT, void  (GLuint region, GLint x, GLint y, GLsizei width, GLsizei height) );
    MOCK_METHOD0( ResizeBuffersMESA, void  (void) );
    MOCK_METHOD2( WindowPos2dMESA, void  (GLdouble x, GLdouble y) );
    MOCK_METHOD1( WindowPos2dvMESA, void  (const GLdouble* p) );
    MOCK_METHOD2( WindowPos2fMESA, void  (GLfloat x, GLfloat y) );
    MOCK_METHOD1( WindowPos2fvMESA, void  (const GLfloat* p) );
    MOCK_METHOD2( WindowPos2iMESA, void  (GLint x, GLint y) );
    MOCK_METHOD1( WindowPos2ivMESA, void  (const GLint* p) );
    MOCK_METHOD2( WindowPos2sMESA, void  (GLshort x, GLshort y) );
    MOCK_METHOD1( WindowPos2svMESA, void  (const GLshort* p) );
    MOCK_METHOD3( WindowPos3dMESA, void  (GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD1( WindowPos3dvMESA, void  (const GLdouble* p) );
    MOCK_METHOD3( WindowPos3fMESA, void  (GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD1( WindowPos3fvMESA, void  (const GLfloat* p) );
    MOCK_METHOD3( WindowPos3iMESA, void  (GLint x, GLint y, GLint z) );
    MOCK_METHOD1( WindowPos3ivMESA, void  (const GLint* p) );
    MOCK_METHOD3( WindowPos3sMESA, void  (GLshort x, GLshort y, GLshort z) );
    MOCK_METHOD1( WindowPos3svMESA, void  (const GLshort* p) );
    MOCK_METHOD4( WindowPos4dMESA, void  (GLdouble x, GLdouble y, GLdouble z, GLdouble) );
    MOCK_METHOD1( WindowPos4dvMESA, void  (const GLdouble* p) );
    MOCK_METHOD4( WindowPos4fMESA, void  (GLfloat x, GLfloat y, GLfloat z, GLfloat w) );
    MOCK_METHOD1( WindowPos4fvMESA, void  (const GLfloat* p) );
    MOCK_METHOD4( WindowPos4iMESA, void  (GLint x, GLint y, GLint z, GLint w) );
    MOCK_METHOD1( WindowPos4ivMESA, void  (const GLint* p) );
    MOCK_METHOD4( WindowPos4sMESA, void  (GLshort x, GLshort y, GLshort z, GLshort w) );
    MOCK_METHOD1( WindowPos4svMESA, void  (const GLshort* p) );
    MOCK_METHOD2( BeginConditionalRenderNV, void  (GLuint id, GLenum mode) );
    MOCK_METHOD0( EndConditionalRenderNV, void  (void) );
    MOCK_METHOD15( CopyImageSubDataNV, void  (GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth) );
    MOCK_METHOD1( ClearDepthdNV, void  (GLdouble depth) );
    MOCK_METHOD2( DepthBoundsdNV, void  (GLdouble zmin, GLdouble zmax) );
    MOCK_METHOD2( DepthRangedNV, void  (GLdouble zNear, GLdouble zFar) );
    MOCK_METHOD2( EvalMapsNV, void  (GLenum target, GLenum mode) );
    MOCK_METHOD4( GetMapAttribParameterfvNV, void  (GLenum target, GLuint index, GLenum pname, GLfloat* params) );
    MOCK_METHOD4( GetMapAttribParameterivNV, void  (GLenum target, GLuint index, GLenum pname, GLint* params) );
    MOCK_METHOD7( GetMapControlPointsNV, void  (GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLboolean packed, void* points) );
    MOCK_METHOD3( GetMapParameterfvNV, void  (GLenum target, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetMapParameterivNV, void  (GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD9( MapControlPointsNV, void  (GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLint uorder, GLint vorder, GLboolean packed, const void* points) );
    MOCK_METHOD3( MapParameterfvNV, void  (GLenum target, GLenum pname, const GLfloat* params) );
    MOCK_METHOD3( MapParameterivNV, void  (GLenum target, GLenum pname, const GLint* params) );
    MOCK_METHOD3( GetMultisamplefvNV, void  (GLenum pname, GLuint index, GLfloat* val) );
    MOCK_METHOD2( SampleMaskIndexedNV, void  (GLuint index, GLbitfield mask) );
    MOCK_METHOD2( TexRenderbufferNV, void  (GLenum target, GLuint renderbuffer) );
    MOCK_METHOD2( DeleteFencesNV, void  (GLsizei n, const GLuint* fences) );
    MOCK_METHOD1( FinishFenceNV, void  (GLuint fence) );
    MOCK_METHOD2( GenFencesNV, void  (GLsizei n, GLuint* fences) );
    MOCK_METHOD3( GetFenceivNV, void  (GLuint fence, GLenum pname, GLint* params) );
    MOCK_METHOD1( IsFenceNV, GLboolean  (GLuint fence) );
    MOCK_METHOD2( SetFenceNV, void  (GLuint fence, GLenum condition) );
    MOCK_METHOD1( TestFenceNV, GLboolean  (GLuint fence) );
    MOCK_METHOD4( GetProgramNamedParameterdvNV, void  (GLuint id, GLsizei len, const GLubyte* name, GLdouble *params) );
    MOCK_METHOD4( GetProgramNamedParameterfvNV, void  (GLuint id, GLsizei len, const GLubyte* name, GLfloat *params) );
    MOCK_METHOD7( ProgramNamedParameter4dNV, void  (GLuint id, GLsizei len, const GLubyte* name, GLdouble x, GLdouble y, GLdouble z, GLdouble w) );
    MOCK_METHOD4( ProgramNamedParameter4dvNV, void  (GLuint id, GLsizei len, const GLubyte* name, const GLdouble *v) );
    MOCK_METHOD7( ProgramNamedParameter4fNV, void  (GLuint id, GLsizei len, const GLubyte* name, GLfloat x, GLfloat y, GLfloat z, GLfloat w) );
    MOCK_METHOD4( ProgramNamedParameter4fvNV, void  (GLuint id, GLsizei len, const GLubyte* name, const GLfloat *v) );
    MOCK_METHOD6( RenderbufferStorageMultisampleCoverageNV, void  (GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height) );
    MOCK_METHOD2( ProgramVertexLimitNV, void  (GLenum target, GLint limit) );
    MOCK_METHOD6( ProgramEnvParameterI4iNV, void  (GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w) );
    MOCK_METHOD3( ProgramEnvParameterI4ivNV, void  (GLenum target, GLuint index, const GLint *params) );
    MOCK_METHOD6( ProgramEnvParameterI4uiNV, void  (GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w) );
    MOCK_METHOD3( ProgramEnvParameterI4uivNV, void  (GLenum target, GLuint index, const GLuint *params) );
    MOCK_METHOD4( ProgramEnvParametersI4ivNV, void  (GLenum target, GLuint index, GLsizei count, const GLint *params) );
    MOCK_METHOD4( ProgramEnvParametersI4uivNV, void  (GLenum target, GLuint index, GLsizei count, const GLuint *params) );
    MOCK_METHOD6( ProgramLocalParameterI4iNV, void  (GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w) );
    MOCK_METHOD3( ProgramLocalParameterI4ivNV, void  (GLenum target, GLuint index, const GLint *params) );
    MOCK_METHOD6( ProgramLocalParameterI4uiNV, void  (GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w) );
    MOCK_METHOD3( ProgramLocalParameterI4uivNV, void  (GLenum target, GLuint index, const GLuint *params) );
    MOCK_METHOD4( ProgramLocalParametersI4ivNV, void  (GLenum target, GLuint index, GLsizei count, const GLint *params) );
    MOCK_METHOD4( ProgramLocalParametersI4uivNV, void  (GLenum target, GLuint index, GLsizei count, const GLuint *params) );
    MOCK_METHOD3( GetUniformi64vNV, void  (GLuint program, GLint location, GLint64EXT* params) );
    MOCK_METHOD3( GetUniformui64vNV, void  (GLuint program, GLint location, GLuint64EXT* params) );
    MOCK_METHOD3( ProgramUniform1i64NV, void  (GLuint program, GLint location, GLint64EXT x) );
    MOCK_METHOD4( ProgramUniform1i64vNV, void  (GLuint program, GLint location, GLsizei count, const GLint64EXT* value) );
    MOCK_METHOD3( ProgramUniform1ui64NV, void  (GLuint program, GLint location, GLuint64EXT x) );
    MOCK_METHOD4( ProgramUniform1ui64vNV, void  (GLuint program, GLint location, GLsizei count, const GLuint64EXT* value) );
    MOCK_METHOD4( ProgramUniform2i64NV, void  (GLuint program, GLint location, GLint64EXT x, GLint64EXT y) );
    MOCK_METHOD4( ProgramUniform2i64vNV, void  (GLuint program, GLint location, GLsizei count, const GLint64EXT* value) );
    MOCK_METHOD4( ProgramUniform2ui64NV, void  (GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y) );
    MOCK_METHOD4( ProgramUniform2ui64vNV, void  (GLuint program, GLint location, GLsizei count, const GLuint64EXT* value) );
    MOCK_METHOD5( ProgramUniform3i64NV, void  (GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z) );
    MOCK_METHOD4( ProgramUniform3i64vNV, void  (GLuint program, GLint location, GLsizei count, const GLint64EXT* value) );
    MOCK_METHOD5( ProgramUniform3ui64NV, void  (GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z) );
    MOCK_METHOD4( ProgramUniform3ui64vNV, void  (GLuint program, GLint location, GLsizei count, const GLuint64EXT* value) );
    MOCK_METHOD6( ProgramUniform4i64NV, void  (GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w) );
    MOCK_METHOD4( ProgramUniform4i64vNV, void  (GLuint program, GLint location, GLsizei count, const GLint64EXT* value) );
    MOCK_METHOD6( ProgramUniform4ui64NV, void  (GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w) );
    MOCK_METHOD4( ProgramUniform4ui64vNV, void  (GLuint program, GLint location, GLsizei count, const GLuint64EXT* value) );
    MOCK_METHOD2( Uniform1i64NV, void  (GLint location, GLint64EXT x) );
    MOCK_METHOD3( Uniform1i64vNV, void  (GLint location, GLsizei count, const GLint64EXT* value) );
    MOCK_METHOD2( Uniform1ui64NV, void  (GLint location, GLuint64EXT x) );
    MOCK_METHOD3( Uniform1ui64vNV, void  (GLint location, GLsizei count, const GLuint64EXT* value) );
    MOCK_METHOD3( Uniform2i64NV, void  (GLint location, GLint64EXT x, GLint64EXT y) );
    MOCK_METHOD3( Uniform2i64vNV, void  (GLint location, GLsizei count, const GLint64EXT* value) );
    MOCK_METHOD3( Uniform2ui64NV, void  (GLint location, GLuint64EXT x, GLuint64EXT y) );
    MOCK_METHOD3( Uniform2ui64vNV, void  (GLint location, GLsizei count, const GLuint64EXT* value) );
    MOCK_METHOD4( Uniform3i64NV, void  (GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z) );
    MOCK_METHOD3( Uniform3i64vNV, void  (GLint location, GLsizei count, const GLint64EXT* value) );
    MOCK_METHOD4( Uniform3ui64NV, void  (GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z) );
    MOCK_METHOD3( Uniform3ui64vNV, void  (GLint location, GLsizei count, const GLuint64EXT* value) );
    MOCK_METHOD5( Uniform4i64NV, void  (GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w) );
    MOCK_METHOD3( Uniform4i64vNV, void  (GLint location, GLsizei count, const GLint64EXT* value) );
    MOCK_METHOD5( Uniform4ui64NV, void  (GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w) );
    MOCK_METHOD3( Uniform4ui64vNV, void  (GLint location, GLsizei count, const GLuint64EXT* value) );
    MOCK_METHOD3( Color3hNV, void  (GLhalf red, GLhalf green, GLhalf blue) );
    MOCK_METHOD1( Color3hvNV, void  (const GLhalf* v) );
    MOCK_METHOD4( Color4hNV, void  (GLhalf red, GLhalf green, GLhalf blue, GLhalf alpha) );
    MOCK_METHOD1( Color4hvNV, void  (const GLhalf* v) );
    MOCK_METHOD1( FogCoordhNV, void  (GLhalf fog) );
    MOCK_METHOD1( FogCoordhvNV, void  (const GLhalf* fog) );
    MOCK_METHOD2( MultiTexCoord1hNV, void  (GLenum target, GLhalf s) );
    MOCK_METHOD2( MultiTexCoord1hvNV, void  (GLenum target, const GLhalf* v) );
    MOCK_METHOD3( MultiTexCoord2hNV, void  (GLenum target, GLhalf s, GLhalf t) );
    MOCK_METHOD2( MultiTexCoord2hvNV, void  (GLenum target, const GLhalf* v) );
    MOCK_METHOD4( MultiTexCoord3hNV, void  (GLenum target, GLhalf s, GLhalf t, GLhalf r) );
    MOCK_METHOD2( MultiTexCoord3hvNV, void  (GLenum target, const GLhalf* v) );
    MOCK_METHOD5( MultiTexCoord4hNV, void  (GLenum target, GLhalf s, GLhalf t, GLhalf r, GLhalf q) );
    MOCK_METHOD2( MultiTexCoord4hvNV, void  (GLenum target, const GLhalf* v) );
    MOCK_METHOD3( Normal3hNV, void  (GLhalf nx, GLhalf ny, GLhalf nz) );
    MOCK_METHOD1( Normal3hvNV, void  (const GLhalf* v) );
    MOCK_METHOD3( SecondaryColor3hNV, void  (GLhalf red, GLhalf green, GLhalf blue) );
    MOCK_METHOD1( SecondaryColor3hvNV, void  (const GLhalf* v) );
    MOCK_METHOD1( TexCoord1hNV, void  (GLhalf s) );
    MOCK_METHOD1( TexCoord1hvNV, void  (const GLhalf* v) );
    MOCK_METHOD2( TexCoord2hNV, void  (GLhalf s, GLhalf t) );
    MOCK_METHOD1( TexCoord2hvNV, void  (const GLhalf* v) );
    MOCK_METHOD3( TexCoord3hNV, void  (GLhalf s, GLhalf t, GLhalf r) );
    MOCK_METHOD1( TexCoord3hvNV, void  (const GLhalf* v) );
    MOCK_METHOD4( TexCoord4hNV, void  (GLhalf s, GLhalf t, GLhalf r, GLhalf q) );
    MOCK_METHOD1( TexCoord4hvNV, void  (const GLhalf* v) );
    MOCK_METHOD2( Vertex2hNV, void  (GLhalf x, GLhalf y) );
    MOCK_METHOD1( Vertex2hvNV, void  (const GLhalf* v) );
    MOCK_METHOD3( Vertex3hNV, void  (GLhalf x, GLhalf y, GLhalf z) );
    MOCK_METHOD1( Vertex3hvNV, void  (const GLhalf* v) );
    MOCK_METHOD4( Vertex4hNV, void  (GLhalf x, GLhalf y, GLhalf z, GLhalf w) );
    MOCK_METHOD1( Vertex4hvNV, void  (const GLhalf* v) );
    MOCK_METHOD2( VertexAttrib1hNV, void  (GLuint index, GLhalf x) );
    MOCK_METHOD2( VertexAttrib1hvNV, void  (GLuint index, const GLhalf* v) );
    MOCK_METHOD3( VertexAttrib2hNV, void  (GLuint index, GLhalf x, GLhalf y) );
    MOCK_METHOD2( VertexAttrib2hvNV, void  (GLuint index, const GLhalf* v) );
    MOCK_METHOD4( VertexAttrib3hNV, void  (GLuint index, GLhalf x, GLhalf y, GLhalf z) );
    MOCK_METHOD2( VertexAttrib3hvNV, void  (GLuint index, const GLhalf* v) );
    MOCK_METHOD5( VertexAttrib4hNV, void  (GLuint index, GLhalf x, GLhalf y, GLhalf z, GLhalf w) );
    MOCK_METHOD2( VertexAttrib4hvNV, void  (GLuint index, const GLhalf* v) );
    MOCK_METHOD3( VertexAttribs1hvNV, void  (GLuint index, GLsizei n, const GLhalf* v) );
    MOCK_METHOD3( VertexAttribs2hvNV, void  (GLuint index, GLsizei n, const GLhalf* v) );
    MOCK_METHOD3( VertexAttribs3hvNV, void  (GLuint index, GLsizei n, const GLhalf* v) );
    MOCK_METHOD3( VertexAttribs4hvNV, void  (GLuint index, GLsizei n, const GLhalf* v) );
    MOCK_METHOD1( VertexWeighthNV, void  (GLhalf weight) );
    MOCK_METHOD1( VertexWeighthvNV, void  (const GLhalf* weight) );
    MOCK_METHOD1( BeginOcclusionQueryNV, void  (GLuint id) );
    MOCK_METHOD2( DeleteOcclusionQueriesNV, void  (GLsizei n, const GLuint* ids) );
    MOCK_METHOD0( EndOcclusionQueryNV, void  (void) );
    MOCK_METHOD2( GenOcclusionQueriesNV, void  (GLsizei n, GLuint* ids) );
    MOCK_METHOD3( GetOcclusionQueryivNV, void  (GLuint id, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetOcclusionQueryuivNV, void  (GLuint id, GLenum pname, GLuint* params) );
    MOCK_METHOD1( IsOcclusionQueryNV, GLboolean  (GLuint id) );
    MOCK_METHOD5( ProgramBufferParametersIivNV, void  (GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLint *params) );
    MOCK_METHOD5( ProgramBufferParametersIuivNV, void  (GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLuint *params) );
    MOCK_METHOD5( ProgramBufferParametersfvNV, void  (GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLfloat *params) );
    MOCK_METHOD1( FlushPixelDataRangeNV, void  (GLenum target) );
    MOCK_METHOD3( PixelDataRangeNV, void  (GLenum target, GLsizei length, void* pointer) );
    MOCK_METHOD2( PointParameteriNV, void  (GLenum pname, GLint param) );
    MOCK_METHOD2( PointParameterivNV, void  (GLenum pname, const GLint* params) );
    MOCK_METHOD3( GetVideoi64vNV, void  (GLuint video_slot, GLenum pname, GLint64EXT* params) );
    MOCK_METHOD3( GetVideoivNV, void  (GLuint video_slot, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetVideoui64vNV, void  (GLuint video_slot, GLenum pname, GLuint64EXT* params) );
    MOCK_METHOD3( GetVideouivNV, void  (GLuint video_slot, GLenum pname, GLuint* params) );
    MOCK_METHOD13( PresentFrameDualFillNV, void  (GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLenum target1, GLuint fill1, GLenum target2, GLuint fill2, GLenum target3, GLuint fill3) );
    MOCK_METHOD11( PresentFrameKeyedNV, void  (GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLuint key0, GLenum target1, GLuint fill1, GLuint key1) );
    MOCK_METHOD1( PrimitiveRestartIndexNV, void  (GLuint index) );
    MOCK_METHOD0( PrimitiveRestartNV, void  (void) );
    MOCK_METHOD6( CombinerInputNV, void  (GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage) );
    MOCK_METHOD10( CombinerOutputNV, void  (GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean abDotProduct, GLboolean cdDotProduct, GLboolean muxSum) );
    MOCK_METHOD2( CombinerParameterfNV, void  (GLenum pname, GLfloat param) );
    MOCK_METHOD2( CombinerParameterfvNV, void  (GLenum pname, const GLfloat* params) );
    MOCK_METHOD2( CombinerParameteriNV, void  (GLenum pname, GLint param) );
    MOCK_METHOD2( CombinerParameterivNV, void  (GLenum pname, const GLint* params) );
    MOCK_METHOD4( FinalCombinerInputNV, void  (GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage) );
    MOCK_METHOD5( GetCombinerInputParameterfvNV, void  (GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat* params) );
    MOCK_METHOD5( GetCombinerInputParameterivNV, void  (GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint* params) );
    MOCK_METHOD4( GetCombinerOutputParameterfvNV, void  (GLenum stage, GLenum portion, GLenum pname, GLfloat* params) );
    MOCK_METHOD4( GetCombinerOutputParameterivNV, void  (GLenum stage, GLenum portion, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetFinalCombinerInputParameterfvNV, void  (GLenum variable, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetFinalCombinerInputParameterivNV, void  (GLenum variable, GLenum pname, GLint* params) );
    MOCK_METHOD3( CombinerStageParameterfvNV, void  (GLenum stage, GLenum pname, const GLfloat* params) );
    MOCK_METHOD3( GetCombinerStageParameterfvNV, void  (GLenum stage, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetBufferParameterui64vNV, void  (GLenum target, GLenum pname, GLuint64EXT* params) );
    MOCK_METHOD2( GetIntegerui64vNV, void  (GLenum value, GLuint64EXT* result) );
    MOCK_METHOD3( GetNamedBufferParameterui64vNV, void  (GLuint buffer, GLenum pname, GLuint64EXT* params) );
    MOCK_METHOD1( IsBufferResidentNV, GLboolean  (GLenum target) );
    MOCK_METHOD1( IsNamedBufferResidentNV, GLboolean  (GLuint buffer) );
    MOCK_METHOD1( MakeBufferNonResidentNV, void  (GLenum target) );
    MOCK_METHOD2( MakeBufferResidentNV, void  (GLenum target, GLenum access) );
    MOCK_METHOD1( MakeNamedBufferNonResidentNV, void  (GLuint buffer) );
    MOCK_METHOD2( MakeNamedBufferResidentNV, void  (GLuint buffer, GLenum access) );
    MOCK_METHOD3( ProgramUniformui64NV, void  (GLuint program, GLint location, GLuint64EXT value) );
    MOCK_METHOD4( ProgramUniformui64vNV, void  (GLuint program, GLint location, GLsizei count, const GLuint64EXT* value) );
    MOCK_METHOD2( Uniformui64NV, void  (GLint location, GLuint64EXT value) );
    MOCK_METHOD3( Uniformui64vNV, void  (GLint location, GLsizei count, const GLuint64EXT* value) );
    MOCK_METHOD0( TextureBarrierNV, void  (void) );
    MOCK_METHOD2( ActiveVaryingNV, void  (GLuint program, const GLchar *name) );
    MOCK_METHOD1( BeginTransformFeedbackNV, void  (GLenum primitiveMode) );
    MOCK_METHOD3( BindBufferBaseNV, void  (GLenum target, GLuint index, GLuint buffer) );
    MOCK_METHOD4( BindBufferOffsetNV, void  (GLenum target, GLuint index, GLuint buffer, GLintptr offset) );
    MOCK_METHOD5( BindBufferRangeNV, void  (GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size) );
    MOCK_METHOD0( EndTransformFeedbackNV, void  (void) );
    MOCK_METHOD7( GetActiveVaryingNV, void  (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name) );
    MOCK_METHOD3( GetTransformFeedbackVaryingNV, void  (GLuint program, GLuint index, GLint *location) );
    MOCK_METHOD2( GetVaryingLocationNV, GLint  (GLuint program, const GLchar *name) );
    MOCK_METHOD3( TransformFeedbackAttribsNV, void  (GLuint count, const GLint *attribs, GLenum bufferMode) );
    MOCK_METHOD4( TransformFeedbackVaryingsNV, void  (GLuint program, GLsizei count, const GLint *locations, GLenum bufferMode) );
    MOCK_METHOD2( BindTransformFeedbackNV, void  (GLenum target, GLuint id) );
    MOCK_METHOD2( DeleteTransformFeedbacksNV, void  (GLsizei n, const GLuint* ids) );
    MOCK_METHOD2( DrawTransformFeedbackNV, void  (GLenum mode, GLuint id) );
    MOCK_METHOD2( GenTransformFeedbacksNV, void  (GLsizei n, GLuint* ids) );
    MOCK_METHOD1( IsTransformFeedbackNV, GLboolean  (GLuint id) );
    MOCK_METHOD0( PauseTransformFeedbackNV, void  (void) );
    MOCK_METHOD0( ResumeTransformFeedbackNV, void  (void) );
    MOCK_METHOD0( FlushVertexArrayRangeNV, void  (void) );
    MOCK_METHOD2( VertexArrayRangeNV, void  (GLsizei length, void* pointer) );
    MOCK_METHOD3( GetVertexAttribLi64vNV, void  (GLuint index, GLenum pname, GLint64EXT* params) );
    MOCK_METHOD3( GetVertexAttribLui64vNV, void  (GLuint index, GLenum pname, GLuint64EXT* params) );
    MOCK_METHOD2( VertexAttribL1i64NV, void  (GLuint index, GLint64EXT x) );
    MOCK_METHOD2( VertexAttribL1i64vNV, void  (GLuint index, const GLint64EXT* v) );
    MOCK_METHOD2( VertexAttribL1ui64NV, void  (GLuint index, GLuint64EXT x) );
    MOCK_METHOD2( VertexAttribL1ui64vNV, void  (GLuint index, const GLuint64EXT* v) );
    MOCK_METHOD3( VertexAttribL2i64NV, void  (GLuint index, GLint64EXT x, GLint64EXT y) );
    MOCK_METHOD2( VertexAttribL2i64vNV, void  (GLuint index, const GLint64EXT* v) );
    MOCK_METHOD3( VertexAttribL2ui64NV, void  (GLuint index, GLuint64EXT x, GLuint64EXT y) );
    MOCK_METHOD2( VertexAttribL2ui64vNV, void  (GLuint index, const GLuint64EXT* v) );
    MOCK_METHOD4( VertexAttribL3i64NV, void  (GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z) );
    MOCK_METHOD2( VertexAttribL3i64vNV, void  (GLuint index, const GLint64EXT* v) );
    MOCK_METHOD4( VertexAttribL3ui64NV, void  (GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z) );
    MOCK_METHOD2( VertexAttribL3ui64vNV, void  (GLuint index, const GLuint64EXT* v) );
    MOCK_METHOD5( VertexAttribL4i64NV, void  (GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w) );
    MOCK_METHOD2( VertexAttribL4i64vNV, void  (GLuint index, const GLint64EXT* v) );
    MOCK_METHOD5( VertexAttribL4ui64NV, void  (GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w) );
    MOCK_METHOD2( VertexAttribL4ui64vNV, void  (GLuint index, const GLuint64EXT* v) );
    MOCK_METHOD4( VertexAttribLFormatNV, void  (GLuint index, GLint size, GLenum type, GLsizei stride) );
    MOCK_METHOD4( BufferAddressRangeNV, void  (GLenum pname, GLuint index, GLuint64EXT address, GLsizeiptr length) );
    MOCK_METHOD3( ColorFormatNV, void  (GLint size, GLenum type, GLsizei stride) );
    MOCK_METHOD1( EdgeFlagFormatNV, void  (GLsizei stride) );
    MOCK_METHOD2( FogCoordFormatNV, void  (GLenum type, GLsizei stride) );
    MOCK_METHOD3( GetIntegerui64i_vNV, void  (GLenum value, GLuint index, GLuint64EXT *result) );
    MOCK_METHOD2( IndexFormatNV, void  (GLenum type, GLsizei stride) );
    MOCK_METHOD2( NormalFormatNV, void  (GLenum type, GLsizei stride) );
    MOCK_METHOD3( SecondaryColorFormatNV, void  (GLint size, GLenum type, GLsizei stride) );
    MOCK_METHOD3( TexCoordFormatNV, void  (GLint size, GLenum type, GLsizei stride) );
    MOCK_METHOD5( VertexAttribFormatNV, void  (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride) );
    MOCK_METHOD4( VertexAttribIFormatNV, void  (GLuint index, GLint size, GLenum type, GLsizei stride) );
    MOCK_METHOD3( VertexFormatNV, void  (GLint size, GLenum type, GLsizei stride) );
    MOCK_METHOD3( AreProgramsResidentNV, GLboolean  (GLsizei n, const GLuint* ids, GLboolean *residences) );
    MOCK_METHOD2( BindProgramNV, void  (GLenum target, GLuint id) );
    MOCK_METHOD2( DeleteProgramsNV, void  (GLsizei n, const GLuint* ids) );
    MOCK_METHOD3( ExecuteProgramNV, void  (GLenum target, GLuint id, const GLfloat* params) );
    MOCK_METHOD2( GenProgramsNV, void  (GLsizei n, GLuint* ids) );
    MOCK_METHOD4( GetProgramParameterdvNV, void  (GLenum target, GLuint index, GLenum pname, GLdouble* params) );
    MOCK_METHOD4( GetProgramParameterfvNV, void  (GLenum target, GLuint index, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetProgramStringNV, void  (GLuint id, GLenum pname, GLubyte* program) );
    MOCK_METHOD3( GetProgramivNV, void  (GLuint id, GLenum pname, GLint* params) );
    MOCK_METHOD4( GetTrackMatrixivNV, void  (GLenum target, GLuint address, GLenum pname, GLint* params) );
    MOCK_METHOD3( GetVertexAttribPointervNV, void  (GLuint index, GLenum pname, GLvoid** pointer) );
    MOCK_METHOD3( GetVertexAttribdvNV, void  (GLuint index, GLenum pname, GLdouble* params) );
    MOCK_METHOD3( GetVertexAttribfvNV, void  (GLuint index, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetVertexAttribivNV, void  (GLuint index, GLenum pname, GLint* params) );
    MOCK_METHOD1( IsProgramNV, GLboolean  (GLuint id) );
    MOCK_METHOD4( LoadProgramNV, void  (GLenum target, GLuint id, GLsizei len, const GLubyte* program) );
    MOCK_METHOD6( ProgramParameter4dNV, void  (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) );
    MOCK_METHOD3( ProgramParameter4dvNV, void  (GLenum target, GLuint index, const GLdouble* params) );
    MOCK_METHOD6( ProgramParameter4fNV, void  (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) );
    MOCK_METHOD3( ProgramParameter4fvNV, void  (GLenum target, GLuint index, const GLfloat* params) );
    MOCK_METHOD4( ProgramParameters4dvNV, void  (GLenum target, GLuint index, GLuint num, const GLdouble* params) );
    MOCK_METHOD4( ProgramParameters4fvNV, void  (GLenum target, GLuint index, GLuint num, const GLfloat* params) );
    MOCK_METHOD2( RequestResidentProgramsNV, void  (GLsizei n, GLuint* ids) );
    MOCK_METHOD4( TrackMatrixNV, void  (GLenum target, GLuint address, GLenum matrix, GLenum transform) );
    MOCK_METHOD2( VertexAttrib1dNV, void  (GLuint index, GLdouble x) );
    MOCK_METHOD2( VertexAttrib1dvNV, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD2( VertexAttrib1fNV, void  (GLuint index, GLfloat x) );
    MOCK_METHOD2( VertexAttrib1fvNV, void  (GLuint index, const GLfloat* v) );
    MOCK_METHOD2( VertexAttrib1sNV, void  (GLuint index, GLshort x) );
    MOCK_METHOD2( VertexAttrib1svNV, void  (GLuint index, const GLshort* v) );
    MOCK_METHOD3( VertexAttrib2dNV, void  (GLuint index, GLdouble x, GLdouble y) );
    MOCK_METHOD2( VertexAttrib2dvNV, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD3( VertexAttrib2fNV, void  (GLuint index, GLfloat x, GLfloat y) );
    MOCK_METHOD2( VertexAttrib2fvNV, void  (GLuint index, const GLfloat* v) );
    MOCK_METHOD3( VertexAttrib2sNV, void  (GLuint index, GLshort x, GLshort y) );
    MOCK_METHOD2( VertexAttrib2svNV, void  (GLuint index, const GLshort* v) );
    MOCK_METHOD4( VertexAttrib3dNV, void  (GLuint index, GLdouble x, GLdouble y, GLdouble z) );
    MOCK_METHOD2( VertexAttrib3dvNV, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD4( VertexAttrib3fNV, void  (GLuint index, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD2( VertexAttrib3fvNV, void  (GLuint index, const GLfloat* v) );
    MOCK_METHOD4( VertexAttrib3sNV, void  (GLuint index, GLshort x, GLshort y, GLshort z) );
    MOCK_METHOD2( VertexAttrib3svNV, void  (GLuint index, const GLshort* v) );
    MOCK_METHOD5( VertexAttrib4dNV, void  (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) );
    MOCK_METHOD2( VertexAttrib4dvNV, void  (GLuint index, const GLdouble* v) );
    MOCK_METHOD5( VertexAttrib4fNV, void  (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) );
    MOCK_METHOD2( VertexAttrib4fvNV, void  (GLuint index, const GLfloat* v) );
    MOCK_METHOD5( VertexAttrib4sNV, void  (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w) );
    MOCK_METHOD2( VertexAttrib4svNV, void  (GLuint index, const GLshort* v) );
    MOCK_METHOD5( VertexAttrib4ubNV, void  (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) );
    MOCK_METHOD2( VertexAttrib4ubvNV, void  (GLuint index, const GLubyte* v) );
    MOCK_METHOD5( VertexAttribPointerNV, void  (GLuint index, GLint size, GLenum type, GLsizei stride, const void* pointer) );
    MOCK_METHOD3( VertexAttribs1dvNV, void  (GLuint index, GLsizei n, const GLdouble* v) );
    MOCK_METHOD3( VertexAttribs1fvNV, void  (GLuint index, GLsizei n, const GLfloat* v) );
    MOCK_METHOD3( VertexAttribs1svNV, void  (GLuint index, GLsizei n, const GLshort* v) );
    MOCK_METHOD3( VertexAttribs2dvNV, void  (GLuint index, GLsizei n, const GLdouble* v) );
    MOCK_METHOD3( VertexAttribs2fvNV, void  (GLuint index, GLsizei n, const GLfloat* v) );
    MOCK_METHOD3( VertexAttribs2svNV, void  (GLuint index, GLsizei n, const GLshort* v) );
    MOCK_METHOD3( VertexAttribs3dvNV, void  (GLuint index, GLsizei n, const GLdouble* v) );
    MOCK_METHOD3( VertexAttribs3fvNV, void  (GLuint index, GLsizei n, const GLfloat* v) );
    MOCK_METHOD3( VertexAttribs3svNV, void  (GLuint index, GLsizei n, const GLshort* v) );
    MOCK_METHOD3( VertexAttribs4dvNV, void  (GLuint index, GLsizei n, const GLdouble* v) );
    MOCK_METHOD3( VertexAttribs4fvNV, void  (GLuint index, GLsizei n, const GLfloat* v) );
    MOCK_METHOD3( VertexAttribs4svNV, void  (GLuint index, GLsizei n, const GLshort* v) );
    MOCK_METHOD3( VertexAttribs4ubvNV, void  (GLuint index, GLsizei n, const GLubyte* v) );
    MOCK_METHOD1( ClearDepthfOES, void  (GLclampd depth) );
    MOCK_METHOD2( ClipPlanefOES, void  (GLenum plane, const GLfloat* equation) );
    MOCK_METHOD2( DepthRangefOES, void  (GLclampf n, GLclampf f) );
    MOCK_METHOD6( FrustumfOES, void  (GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f) );
    MOCK_METHOD2( GetClipPlanefOES, void  (GLenum plane, GLfloat* equation) );
    MOCK_METHOD6( OrthofOES, void  (GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f) );
    MOCK_METHOD3( DetailTexFuncSGIS, void  (GLenum target, GLsizei n, const GLfloat* points) );
    MOCK_METHOD2( GetDetailTexFuncSGIS, void  (GLenum target, GLfloat* points) );
    MOCK_METHOD2( FogFuncSGIS, void  (GLsizei n, const GLfloat* points) );
    MOCK_METHOD1( GetFogFuncSGIS, void  (GLfloat* points) );
    MOCK_METHOD2( SampleMaskSGIS, void  (GLclampf value, GLboolean invert) );
    MOCK_METHOD1( SamplePatternSGIS, void  (GLenum pattern) );
    MOCK_METHOD2( GetSharpenTexFuncSGIS, void  (GLenum target, GLfloat* points) );
    MOCK_METHOD3( SharpenTexFuncSGIS, void  (GLenum target, GLsizei n, const GLfloat* points) );
    MOCK_METHOD11( TexImage4DSGIS, void  (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLsizei extent, GLint border, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD13( TexSubImage4DSGIS, void  (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint woffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei extent, GLenum format, GLenum type, const void* pixels) );
    MOCK_METHOD3( GetTexFilterFuncSGIS, void  (GLenum target, GLenum filter, GLfloat* weights) );
    MOCK_METHOD4( TexFilterFuncSGIS, void  (GLenum target, GLenum filter, GLsizei n, const GLfloat* weights) );
    MOCK_METHOD1( AsyncMarkerSGIX, void  (GLuint marker) );
    MOCK_METHOD2( DeleteAsyncMarkersSGIX, void  (GLuint marker, GLsizei range) );
    MOCK_METHOD1( FinishAsyncSGIX, GLint  (GLuint* markerp) );
    MOCK_METHOD1( GenAsyncMarkersSGIX, GLuint  (GLsizei range) );
    MOCK_METHOD1( IsAsyncMarkerSGIX, GLboolean  (GLuint marker) );
    MOCK_METHOD1( PollAsyncSGIX, GLint  (GLuint* markerp) );
    MOCK_METHOD0( FlushRasterSGIX, void  (void) );
    MOCK_METHOD1( TextureFogSGIX, void  (GLenum pname) );
    MOCK_METHOD2( FragmentColorMaterialSGIX, void  (GLenum face, GLenum mode) );
    MOCK_METHOD2( FragmentLightModelfSGIX, void  (GLenum pname, GLfloat param) );
    MOCK_METHOD2( FragmentLightModelfvSGIX, void  (GLenum pname, GLfloat* params) );
    MOCK_METHOD2( FragmentLightModeliSGIX, void  (GLenum pname, GLint param) );
    MOCK_METHOD2( FragmentLightModelivSGIX, void  (GLenum pname, GLint* params) );
    MOCK_METHOD3( FragmentLightfSGIX, void  (GLenum light, GLenum pname, GLfloat param) );
    MOCK_METHOD3( FragmentLightfvSGIX, void  (GLenum light, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( FragmentLightiSGIX, void  (GLenum light, GLenum pname, GLint param) );
    MOCK_METHOD3( FragmentLightivSGIX, void  (GLenum light, GLenum pname, GLint* params) );
    MOCK_METHOD3( FragmentMaterialfSGIX, void  (GLenum face, GLenum pname, const GLfloat param) );
    MOCK_METHOD3( FragmentMaterialfvSGIX, void  (GLenum face, GLenum pname, const GLfloat* params) );
    MOCK_METHOD3( FragmentMaterialiSGIX, void  (GLenum face, GLenum pname, const GLint param) );
    MOCK_METHOD3( FragmentMaterialivSGIX, void  (GLenum face, GLenum pname, const GLint* params) );
    MOCK_METHOD3( GetFragmentLightfvSGIX, void  (GLenum light, GLenum value, GLfloat* data) );
    MOCK_METHOD3( GetFragmentLightivSGIX, void  (GLenum light, GLenum value, GLint* data) );
    MOCK_METHOD3( GetFragmentMaterialfvSGIX, void  (GLenum face, GLenum pname, const GLfloat* data) );
    MOCK_METHOD3( GetFragmentMaterialivSGIX, void  (GLenum face, GLenum pname, const GLint* data) );
    MOCK_METHOD1( FrameZoomSGIX, void  (GLint factor) );
    MOCK_METHOD1( PixelTexGenSGIX, void  (GLenum mode) );
    MOCK_METHOD1( ReferencePlaneSGIX, void  (const GLdouble* equation) );
    MOCK_METHOD2( SpriteParameterfSGIX, void  (GLenum pname, GLfloat param) );
    MOCK_METHOD2( SpriteParameterfvSGIX, void  (GLenum pname, GLfloat* params) );
    MOCK_METHOD2( SpriteParameteriSGIX, void  (GLenum pname, GLint param) );
    MOCK_METHOD2( SpriteParameterivSGIX, void  (GLenum pname, GLint* params) );
    MOCK_METHOD0( TagSampleBufferSGIX, void  (void) );
    MOCK_METHOD3( ColorTableParameterfvSGI, void  (GLenum target, GLenum pname, const GLfloat* params) );
    MOCK_METHOD3( ColorTableParameterivSGI, void  (GLenum target, GLenum pname, const GLint* params) );
    MOCK_METHOD6( ColorTableSGI, void  (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void* table) );
    MOCK_METHOD5( CopyColorTableSGI, void  (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) );
    MOCK_METHOD3( GetColorTableParameterfvSGI, void  (GLenum target, GLenum pname, GLfloat* params) );
    MOCK_METHOD3( GetColorTableParameterivSGI, void  (GLenum target, GLenum pname, GLint* params) );
    MOCK_METHOD4( GetColorTableSGI, void  (GLenum target, GLenum format, GLenum type, void* table) );
    MOCK_METHOD0( FinishTextureSUNX, void  (void) );
    MOCK_METHOD1( GlobalAlphaFactorbSUN, void  (GLbyte factor) );
    MOCK_METHOD1( GlobalAlphaFactordSUN, void  (GLdouble factor) );
    MOCK_METHOD1( GlobalAlphaFactorfSUN, void  (GLfloat factor) );
    MOCK_METHOD1( GlobalAlphaFactoriSUN, void  (GLint factor) );
    MOCK_METHOD1( GlobalAlphaFactorsSUN, void  (GLshort factor) );
    MOCK_METHOD1( GlobalAlphaFactorubSUN, void  (GLubyte factor) );
    MOCK_METHOD1( GlobalAlphaFactoruiSUN, void  (GLuint factor) );
    MOCK_METHOD1( GlobalAlphaFactorusSUN, void  (GLushort factor) );
    MOCK_METHOD7( ReadVideoPixelsSUN, void  (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid* pixels) );
    MOCK_METHOD3( ReplacementCodePointerSUN, void  (GLenum type, GLsizei stride, const void* pointer) );
    MOCK_METHOD1( ReplacementCodeubSUN, void  (GLubyte code) );
    MOCK_METHOD1( ReplacementCodeubvSUN, void  (const GLubyte* code) );
    MOCK_METHOD1( ReplacementCodeuiSUN, void  (GLuint code) );
    MOCK_METHOD1( ReplacementCodeuivSUN, void  (const GLuint* code) );
    MOCK_METHOD1( ReplacementCodeusSUN, void  (GLushort code) );
    MOCK_METHOD1( ReplacementCodeusvSUN, void  (const GLushort* code) );
    MOCK_METHOD6( Color3fVertex3fSUN, void  (GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD2( Color3fVertex3fvSUN, void  (const GLfloat* c, const GLfloat *v) );
    MOCK_METHOD10( Color4fNormal3fVertex3fSUN, void  (GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD3( Color4fNormal3fVertex3fvSUN, void  (const GLfloat* c, const GLfloat *n, const GLfloat *v) );
    MOCK_METHOD6( Color4ubVertex2fSUN, void  (GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y) );
    MOCK_METHOD2( Color4ubVertex2fvSUN, void  (const GLubyte* c, const GLfloat *v) );
    MOCK_METHOD7( Color4ubVertex3fSUN, void  (GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD2( Color4ubVertex3fvSUN, void  (const GLubyte* c, const GLfloat *v) );
    MOCK_METHOD6( Normal3fVertex3fSUN, void  (GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD2( Normal3fVertex3fvSUN, void  (const GLfloat* n, const GLfloat *v) );
    MOCK_METHOD7( ReplacementCodeuiColor3fVertex3fSUN, void  (GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD3( ReplacementCodeuiColor3fVertex3fvSUN, void  (const GLuint* rc, const GLfloat *c, const GLfloat *v) );
    MOCK_METHOD11( ReplacementCodeuiColor4fNormal3fVertex3fSUN, void  (GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD4( ReplacementCodeuiColor4fNormal3fVertex3fvSUN, void  (const GLuint* rc, const GLfloat *c, const GLfloat *n, const GLfloat *v) );
    MOCK_METHOD8( ReplacementCodeuiColor4ubVertex3fSUN, void  (GLuint rc, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD3( ReplacementCodeuiColor4ubVertex3fvSUN, void  (const GLuint* rc, const GLubyte *c, const GLfloat *v) );
    MOCK_METHOD7( ReplacementCodeuiNormal3fVertex3fSUN, void  (GLuint rc, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD3( ReplacementCodeuiNormal3fVertex3fvSUN, void  (const GLuint* rc, const GLfloat *n, const GLfloat *v) );
    MOCK_METHOD13( ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN, void  (GLuint rc, GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD5( ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN, void  (const GLuint* rc, const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v) );
    MOCK_METHOD9( ReplacementCodeuiTexCoord2fNormal3fVertex3fSUN, void  (GLuint rc, GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD4( ReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN, void  (const GLuint* rc, const GLfloat *tc, const GLfloat *n, const GLfloat *v) );
    MOCK_METHOD6( ReplacementCodeuiTexCoord2fVertex3fSUN, void  (GLuint rc, GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD3( ReplacementCodeuiTexCoord2fVertex3fvSUN, void  (const GLuint* rc, const GLfloat *tc, const GLfloat *v) );
    MOCK_METHOD4( ReplacementCodeuiVertex3fSUN, void  (GLuint rc, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD2( ReplacementCodeuiVertex3fvSUN, void  (const GLuint* rc, const GLfloat *v) );
    MOCK_METHOD8( TexCoord2fColor3fVertex3fSUN, void  (GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD3( TexCoord2fColor3fVertex3fvSUN, void  (const GLfloat* tc, const GLfloat *c, const GLfloat *v) );
    MOCK_METHOD12( TexCoord2fColor4fNormal3fVertex3fSUN, void  (GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD4( TexCoord2fColor4fNormal3fVertex3fvSUN, void  (const GLfloat* tc, const GLfloat *c, const GLfloat *n, const GLfloat *v) );
    MOCK_METHOD9( TexCoord2fColor4ubVertex3fSUN, void  (GLfloat s, GLfloat t, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD3( TexCoord2fColor4ubVertex3fvSUN, void  (const GLfloat* tc, const GLubyte *c, const GLfloat *v) );
    MOCK_METHOD8( TexCoord2fNormal3fVertex3fSUN, void  (GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD3( TexCoord2fNormal3fVertex3fvSUN, void  (const GLfloat* tc, const GLfloat *n, const GLfloat *v) );
    MOCK_METHOD5( TexCoord2fVertex3fSUN, void  (GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z) );
    MOCK_METHOD2( TexCoord2fVertex3fvSUN, void  (const GLfloat* tc, const GLfloat *v) );
    MOCK_METHOD15( TexCoord4fColor4fNormal3fVertex4fSUN, void  (GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, GLfloat w) );
    MOCK_METHOD4( TexCoord4fColor4fNormal3fVertex4fvSUN, void  (const GLfloat* tc, const GLfloat *c, const GLfloat *n, const GLfloat *v) );
    MOCK_METHOD8( TexCoord4fVertex4fSUN, void  (GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat x, GLfloat y, GLfloat z, GLfloat w) );
    MOCK_METHOD2( TexCoord4fVertex4fvSUN, void  (const GLfloat* tc, const GLfloat *v) );
    MOCK_METHOD4( AddSwapHintRectWIN, void  (GLint x, GLint y, GLsizei width, GLsizei height) );
    MOCK_METHOD1( BeginCurve, void  (GLUnurbs* nurb) );
    MOCK_METHOD1( BeginPolygon, void  (GLUtesselator* tess) );
    MOCK_METHOD1( BeginSurface, void  (GLUnurbs* nurb) );
    MOCK_METHOD1( BeginTrim, void  (GLUnurbs* nurb) );
    MOCK_METHOD9( Build1DMipmapLevels, GLint  (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data) );
    MOCK_METHOD6( Build1DMipmaps, GLint  (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data) );
    MOCK_METHOD10( Build2DMipmapLevels, GLint  (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data) );
    MOCK_METHOD7( Build2DMipmaps, GLint  (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *data) );
    MOCK_METHOD11( Build3DMipmapLevels, GLint  (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data) );
    MOCK_METHOD8( Build3DMipmaps, GLint  (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *data) );
    MOCK_METHOD2( CheckExtension, GLboolean  (const GLubyte *extName, const GLubyte *extString) );
    MOCK_METHOD6( Cylinder, void  (GLUquadric* quad, GLdouble base, GLdouble top, GLdouble height, GLint slices, GLint stacks) );
    MOCK_METHOD1( DeleteNurbsRenderer, void  (GLUnurbs* nurb) );
    MOCK_METHOD1( DeleteQuadric, void  (GLUquadric* quad) );
    MOCK_METHOD1( DeleteTess, void  (GLUtesselator* tess) );
    MOCK_METHOD5( Disk, void  (GLUquadric* quad, GLdouble inner, GLdouble outer, GLint slices, GLint loops) );
    MOCK_METHOD1( EndCurve, void  (GLUnurbs* nurb) );
    MOCK_METHOD1( EndPolygon, void  (GLUtesselator* tess) );
    MOCK_METHOD1( EndSurface, void  (GLUnurbs* nurb) );
    MOCK_METHOD1( EndTrim, void  (GLUnurbs* nurb) );
    MOCK_METHOD1( ErrorString, const GLubyte *  (GLenum error) );
    MOCK_METHOD3( GetNurbsProperty, void  (GLUnurbs* nurb, GLenum property, GLfloat* data) );
    MOCK_METHOD1( GetString, const GLubyte *  (GLenum name) );
    MOCK_METHOD3( GetTessProperty, void  (GLUtesselator* tess, GLenum which, GLdouble* data) );
    MOCK_METHOD4( LoadSamplingMatrices, void  (GLUnurbs* nurb, const GLfloat *model, const GLfloat *perspective, const GLint *view) );
    MOCK_METHOD9( LookAt, void  (GLdouble eyeX, GLdouble eyeY, GLdouble eyeZ, GLdouble centerX, GLdouble centerY, GLdouble centerZ, GLdouble upX, GLdouble upY, GLdouble upZ) );
    MOCK_METHOD0( NewNurbsRenderer, GLUnurbs*  (void) );
    MOCK_METHOD0( NewQuadric, GLUquadric*  (void) );
    MOCK_METHOD0( NewTess, GLUtesselator*  (void) );
    MOCK_METHOD2( NextContour, void  (GLUtesselator* tess, GLenum type) );
    MOCK_METHOD3( NurbsCallback, void  (GLUnurbs* nurb, GLenum which, _GLUfuncptr CallBackFunc) );
    MOCK_METHOD2( NurbsCallbackData, void  (GLUnurbs* nurb, GLvoid* userData) );
    MOCK_METHOD2( NurbsCallbackDataEXT, void  (GLUnurbs* nurb, GLvoid* userData) );
    MOCK_METHOD7( NurbsCurve, void  (GLUnurbs* nurb, GLint knotCount, GLfloat *knots, GLint stride, GLfloat *control, GLint order, GLenum type) );
    MOCK_METHOD3( NurbsProperty, void  (GLUnurbs* nurb, GLenum property, GLfloat value) );
    MOCK_METHOD11( NurbsSurface, void  (GLUnurbs* nurb, GLint sKnotCount, GLfloat* sKnots, GLint tKnotCount, GLfloat* tKnots, GLint sStride, GLint tStride, GLfloat* control, GLint sOrder, GLint tOrder, GLenum type) );
    MOCK_METHOD4( Ortho2D, void  (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top) );
    MOCK_METHOD7( PartialDisk, void  (GLUquadric* quad, GLdouble inner, GLdouble outer, GLint slices, GLint loops, GLdouble start, GLdouble sweep) );
    MOCK_METHOD4( Perspective, void  (GLdouble fovy, GLdouble aspect, GLdouble zNear, GLdouble zFar) );
    MOCK_METHOD5( PickMatrix, void  (GLdouble x, GLdouble y, GLdouble delX, GLdouble delY, GLint *viewport) );
    MOCK_METHOD9( Project, GLint  (GLdouble objX, GLdouble objY, GLdouble objZ, const GLdouble *model, const GLdouble *proj, const GLint *view, GLdouble* winX, GLdouble* winY, GLdouble* winZ) );
    MOCK_METHOD5( PwlCurve, void  (GLUnurbs* nurb, GLint count, GLfloat* data, GLint stride, GLenum type) );
    MOCK_METHOD3( QuadricCallback, void  (GLUquadric* quad, GLenum which, _GLUfuncptr CallBackFunc) );
    MOCK_METHOD2( QuadricDrawStyle, void  (GLUquadric* quad, GLenum draw) );
    MOCK_METHOD2( QuadricNormals, void  (GLUquadric* quad, GLenum normal) );
    MOCK_METHOD2( QuadricOrientation, void  (GLUquadric* quad, GLenum orientation) );
    MOCK_METHOD2( QuadricTexture, void  (GLUquadric* quad, GLboolean texture) );
    MOCK_METHOD9( ScaleImage, GLint  (GLenum format, GLsizei wIn, GLsizei hIn, GLenum typeIn, const void *dataIn, GLsizei wOut, GLsizei hOut, GLenum typeOut, GLvoid* dataOut) );
    MOCK_METHOD4( Sphere, void  (GLUquadric* quad, GLdouble radius, GLint slices, GLint stacks) );
    MOCK_METHOD1( TessBeginContour, void  (GLUtesselator* tess) );
    MOCK_METHOD2( TessBeginPolygon, void  (GLUtesselator* tess, GLvoid* data) );
    MOCK_METHOD3( TessCallback, void  (GLUtesselator* tess, GLenum which, _GLUfuncptr CallBackFunc) );
    MOCK_METHOD1( TessEndContour, void  (GLUtesselator* tess) );
    MOCK_METHOD1( TessEndPolygon, void  (GLUtesselator* tess) );
    MOCK_METHOD4( TessNormal, void  (GLUtesselator* tess, GLdouble valueX, GLdouble valueY, GLdouble valueZ) );
    MOCK_METHOD3( TessProperty, void  (GLUtesselator* tess, GLenum which, GLdouble data) );
    MOCK_METHOD3( TessVertex, void  (GLUtesselator* tess, GLdouble *location, GLvoid* data) );
    MOCK_METHOD9( UnProject, GLint  (GLdouble winX, GLdouble winY, GLdouble winZ, const GLdouble *model, const GLdouble *proj, const GLint *view, GLdouble* objX, GLdouble* objY, GLdouble* objZ) );
    MOCK_METHOD13( UnProject4, GLint  (GLdouble winX, GLdouble winY, GLdouble winZ, GLdouble clipW, const GLdouble *model, const GLdouble *proj, const GLint *view, GLdouble near, GLdouble far, GLdouble* objX, GLdouble* objY, GLdouble* objZ, GLdouble* objW) );
};


#undef glAccum
#define glAccum GLMock.Accum
#undef glAlphaFunc
#define glAlphaFunc GLMock.AlphaFunc
#undef glAreTexturesResident
#define glAreTexturesResident GLMock.AreTexturesResident
#undef glArrayElement
#define glArrayElement GLMock.ArrayElement
#undef glBegin
#define glBegin GLMock.Begin
#undef glBindTexture
#define glBindTexture GLMock.BindTexture
#undef glBitmap
#define glBitmap GLMock.Bitmap
#undef glBlendFunc
#define glBlendFunc GLMock.BlendFunc
#undef glCallList
#define glCallList GLMock.CallList
#undef glCallLists
#define glCallLists GLMock.CallLists
#undef glClear
#define glClear GLMock.Clear
#undef glClearAccum
#define glClearAccum GLMock.ClearAccum
#undef glClearColor
#define glClearColor GLMock.ClearColor
#undef glClearDepth
#define glClearDepth GLMock.ClearDepth
#undef glClearIndex
#define glClearIndex GLMock.ClearIndex
#undef glClearStencil
#define glClearStencil GLMock.ClearStencil
#undef glClipPlane
#define glClipPlane GLMock.ClipPlane
#undef glColor3b
#define glColor3b GLMock.Color3b
#undef glColor3bv
#define glColor3bv GLMock.Color3bv
#undef glColor3d
#define glColor3d GLMock.Color3d
#undef glColor3dv
#define glColor3dv GLMock.Color3dv
#undef glColor3f
#define glColor3f GLMock.Color3f
#undef glColor3fv
#define glColor3fv GLMock.Color3fv
#undef glColor3i
#define glColor3i GLMock.Color3i
#undef glColor3iv
#define glColor3iv GLMock.Color3iv
#undef glColor3s
#define glColor3s GLMock.Color3s
#undef glColor3sv
#define glColor3sv GLMock.Color3sv
#undef glColor3ub
#define glColor3ub GLMock.Color3ub
#undef glColor3ubv
#define glColor3ubv GLMock.Color3ubv
#undef glColor3ui
#define glColor3ui GLMock.Color3ui
#undef glColor3uiv
#define glColor3uiv GLMock.Color3uiv
#undef glColor3us
#define glColor3us GLMock.Color3us
#undef glColor3usv
#define glColor3usv GLMock.Color3usv
#undef glColor4b
#define glColor4b GLMock.Color4b
#undef glColor4bv
#define glColor4bv GLMock.Color4bv
#undef glColor4d
#define glColor4d GLMock.Color4d
#undef glColor4dv
#define glColor4dv GLMock.Color4dv
#undef glColor4f
#define glColor4f GLMock.Color4f
#undef glColor4fv
#define glColor4fv GLMock.Color4fv
#undef glColor4i
#define glColor4i GLMock.Color4i
#undef glColor4iv
#define glColor4iv GLMock.Color4iv
#undef glColor4s
#define glColor4s GLMock.Color4s
#undef glColor4sv
#define glColor4sv GLMock.Color4sv
#undef glColor4ub
#define glColor4ub GLMock.Color4ub
#undef glColor4ubv
#define glColor4ubv GLMock.Color4ubv
#undef glColor4ui
#define glColor4ui GLMock.Color4ui
#undef glColor4uiv
#define glColor4uiv GLMock.Color4uiv
#undef glColor4us
#define glColor4us GLMock.Color4us
#undef glColor4usv
#define glColor4usv GLMock.Color4usv
#undef glColorMask
#define glColorMask GLMock.ColorMask
#undef glColorMaterial
#define glColorMaterial GLMock.ColorMaterial
#undef glColorPointer
#define glColorPointer GLMock.ColorPointer
#undef glCopyPixels
#define glCopyPixels GLMock.CopyPixels
#undef glCopyTexImage1D
#define glCopyTexImage1D GLMock.CopyTexImage1D
#undef glCopyTexImage2D
#define glCopyTexImage2D GLMock.CopyTexImage2D
#undef glCopyTexSubImage1D
#define glCopyTexSubImage1D GLMock.CopyTexSubImage1D
#undef glCopyTexSubImage2D
#define glCopyTexSubImage2D GLMock.CopyTexSubImage2D
#undef glCullFace
#define glCullFace GLMock.CullFace
#undef glDeleteLists
#define glDeleteLists GLMock.DeleteLists
#undef glDeleteTextures
#define glDeleteTextures GLMock.DeleteTextures
#undef glDepthFunc
#define glDepthFunc GLMock.DepthFunc
#undef glDepthMask
#define glDepthMask GLMock.DepthMask
#undef glDepthRange
#define glDepthRange GLMock.DepthRange
#undef glDisable
#define glDisable GLMock.Disable
#undef glDisableClientState
#define glDisableClientState GLMock.DisableClientState
#undef glDrawArrays
#define glDrawArrays GLMock.DrawArrays
#undef glDrawBuffer
#define glDrawBuffer GLMock.DrawBuffer
#undef glDrawElements
#define glDrawElements GLMock.DrawElements
#undef glDrawPixels
#define glDrawPixels GLMock.DrawPixels
#undef glEdgeFlag
#define glEdgeFlag GLMock.EdgeFlag
#undef glEdgeFlagPointer
#define glEdgeFlagPointer GLMock.EdgeFlagPointer
#undef glEdgeFlagv
#define glEdgeFlagv GLMock.EdgeFlagv
#undef glEnable
#define glEnable GLMock.Enable
#undef glEnableClientState
#define glEnableClientState GLMock.EnableClientState
#undef glEnd
#define glEnd GLMock.End
#undef glEndList
#define glEndList GLMock.EndList
#undef glEvalCoord1d
#define glEvalCoord1d GLMock.EvalCoord1d
#undef glEvalCoord1dv
#define glEvalCoord1dv GLMock.EvalCoord1dv
#undef glEvalCoord1f
#define glEvalCoord1f GLMock.EvalCoord1f
#undef glEvalCoord1fv
#define glEvalCoord1fv GLMock.EvalCoord1fv
#undef glEvalCoord2d
#define glEvalCoord2d GLMock.EvalCoord2d
#undef glEvalCoord2dv
#define glEvalCoord2dv GLMock.EvalCoord2dv
#undef glEvalCoord2f
#define glEvalCoord2f GLMock.EvalCoord2f
#undef glEvalCoord2fv
#define glEvalCoord2fv GLMock.EvalCoord2fv
#undef glEvalMesh1
#define glEvalMesh1 GLMock.EvalMesh1
#undef glEvalMesh2
#define glEvalMesh2 GLMock.EvalMesh2
#undef glEvalPoint1
#define glEvalPoint1 GLMock.EvalPoint1
#undef glEvalPoint2
#define glEvalPoint2 GLMock.EvalPoint2
#undef glFeedbackBuffer
#define glFeedbackBuffer GLMock.FeedbackBuffer
#undef glFinish
#define glFinish GLMock.Finish
#undef glFlush
#define glFlush GLMock.Flush
#undef glFogf
#define glFogf GLMock.Fogf
#undef glFogfv
#define glFogfv GLMock.Fogfv
#undef glFogi
#define glFogi GLMock.Fogi
#undef glFogiv
#define glFogiv GLMock.Fogiv
#undef glFrontFace
#define glFrontFace GLMock.FrontFace
#undef glFrustum
#define glFrustum GLMock.Frustum
#undef glGenLists
#define glGenLists GLMock.GenLists
#undef glGenTextures
#define glGenTextures GLMock.GenTextures
#undef glGetBooleanv
#define glGetBooleanv GLMock.GetBooleanv
#undef glGetClipPlane
#define glGetClipPlane GLMock.GetClipPlane
#undef glGetDoublev
#define glGetDoublev GLMock.GetDoublev
#undef glGetError
#define glGetError GLMock.GetError
#undef glGetFloatv
#define glGetFloatv GLMock.GetFloatv
#undef glGetIntegerv
#define glGetIntegerv GLMock.GetIntegerv
#undef glGetLightfv
#define glGetLightfv GLMock.GetLightfv
#undef glGetLightiv
#define glGetLightiv GLMock.GetLightiv
#undef glGetMapdv
#define glGetMapdv GLMock.GetMapdv
#undef glGetMapfv
#define glGetMapfv GLMock.GetMapfv
#undef glGetMapiv
#define glGetMapiv GLMock.GetMapiv
#undef glGetMaterialfv
#define glGetMaterialfv GLMock.GetMaterialfv
#undef glGetMaterialiv
#define glGetMaterialiv GLMock.GetMaterialiv
#undef glGetPixelMapfv
#define glGetPixelMapfv GLMock.GetPixelMapfv
#undef glGetPixelMapuiv
#define glGetPixelMapuiv GLMock.GetPixelMapuiv
#undef glGetPixelMapusv
#define glGetPixelMapusv GLMock.GetPixelMapusv
#undef glGetPointerv
#define glGetPointerv GLMock.GetPointerv
#undef glGetPolygonStipple
#define glGetPolygonStipple GLMock.GetPolygonStipple
#undef glGetString
#define glGetString GLMock.GetString
#undef glGetTexEnvfv
#define glGetTexEnvfv GLMock.GetTexEnvfv
#undef glGetTexEnviv
#define glGetTexEnviv GLMock.GetTexEnviv
#undef glGetTexGendv
#define glGetTexGendv GLMock.GetTexGendv
#undef glGetTexGenfv
#define glGetTexGenfv GLMock.GetTexGenfv
#undef glGetTexGeniv
#define glGetTexGeniv GLMock.GetTexGeniv
#undef glGetTexImage
#define glGetTexImage GLMock.GetTexImage
#undef glGetTexLevelParameterfv
#define glGetTexLevelParameterfv GLMock.GetTexLevelParameterfv
#undef glGetTexLevelParameteriv
#define glGetTexLevelParameteriv GLMock.GetTexLevelParameteriv
#undef glGetTexParameterfv
#define glGetTexParameterfv GLMock.GetTexParameterfv
#undef glGetTexParameteriv
#define glGetTexParameteriv GLMock.GetTexParameteriv
#undef glHint
#define glHint GLMock.Hint
#undef glIndexMask
#define glIndexMask GLMock.IndexMask
#undef glIndexPointer
#define glIndexPointer GLMock.IndexPointer
#undef glIndexd
#define glIndexd GLMock.Indexd
#undef glIndexdv
#define glIndexdv GLMock.Indexdv
#undef glIndexf
#define glIndexf GLMock.Indexf
#undef glIndexfv
#define glIndexfv GLMock.Indexfv
#undef glIndexi
#define glIndexi GLMock.Indexi
#undef glIndexiv
#define glIndexiv GLMock.Indexiv
#undef glIndexs
#define glIndexs GLMock.Indexs
#undef glIndexsv
#define glIndexsv GLMock.Indexsv
#undef glIndexub
#define glIndexub GLMock.Indexub
#undef glIndexubv
#define glIndexubv GLMock.Indexubv
#undef glInitNames
#define glInitNames GLMock.InitNames
#undef glInterleavedArrays
#define glInterleavedArrays GLMock.InterleavedArrays
#undef glIsEnabled
#define glIsEnabled GLMock.IsEnabled
#undef glIsList
#define glIsList GLMock.IsList
#undef glIsTexture
#define glIsTexture GLMock.IsTexture
#undef glLightModelf
#define glLightModelf GLMock.LightModelf
#undef glLightModelfv
#define glLightModelfv GLMock.LightModelfv
#undef glLightModeli
#define glLightModeli GLMock.LightModeli
#undef glLightModeliv
#define glLightModeliv GLMock.LightModeliv
#undef glLightf
#define glLightf GLMock.Lightf
#undef glLightfv
#define glLightfv GLMock.Lightfv
#undef glLighti
#define glLighti GLMock.Lighti
#undef glLightiv
#define glLightiv GLMock.Lightiv
#undef glLineStipple
#define glLineStipple GLMock.LineStipple
#undef glLineWidth
#define glLineWidth GLMock.LineWidth
#undef glListBase
#define glListBase GLMock.ListBase
#undef glLoadIdentity
#define glLoadIdentity GLMock.LoadIdentity
#undef glLoadMatrixd
#define glLoadMatrixd GLMock.LoadMatrixd
#undef glLoadMatrixf
#define glLoadMatrixf GLMock.LoadMatrixf
#undef glLoadName
#define glLoadName GLMock.LoadName
#undef glLogicOp
#define glLogicOp GLMock.LogicOp
#undef glMap1d
#define glMap1d GLMock.Map1d
#undef glMap1f
#define glMap1f GLMock.Map1f
#undef glMap2d
#define glMap2d GLMock.Map2d
#undef glMap2f
#define glMap2f GLMock.Map2f
#undef glMapGrid1d
#define glMapGrid1d GLMock.MapGrid1d
#undef glMapGrid1f
#define glMapGrid1f GLMock.MapGrid1f
#undef glMapGrid2d
#define glMapGrid2d GLMock.MapGrid2d
#undef glMapGrid2f
#define glMapGrid2f GLMock.MapGrid2f
#undef glMaterialf
#define glMaterialf GLMock.Materialf
#undef glMaterialfv
#define glMaterialfv GLMock.Materialfv
#undef glMateriali
#define glMateriali GLMock.Materiali
#undef glMaterialiv
#define glMaterialiv GLMock.Materialiv
#undef glMatrixMode
#define glMatrixMode GLMock.MatrixMode
#undef glMultMatrixd
#define glMultMatrixd GLMock.MultMatrixd
#undef glMultMatrixf
#define glMultMatrixf GLMock.MultMatrixf
#undef glNewList
#define glNewList GLMock.NewList
#undef glNormal3b
#define glNormal3b GLMock.Normal3b
#undef glNormal3bv
#define glNormal3bv GLMock.Normal3bv
#undef glNormal3d
#define glNormal3d GLMock.Normal3d
#undef glNormal3dv
#define glNormal3dv GLMock.Normal3dv
#undef glNormal3f
#define glNormal3f GLMock.Normal3f
#undef glNormal3fv
#define glNormal3fv GLMock.Normal3fv
#undef glNormal3i
#define glNormal3i GLMock.Normal3i
#undef glNormal3iv
#define glNormal3iv GLMock.Normal3iv
#undef glNormal3s
#define glNormal3s GLMock.Normal3s
#undef glNormal3sv
#define glNormal3sv GLMock.Normal3sv
#undef glNormalPointer
#define glNormalPointer GLMock.NormalPointer
#undef glOrtho
#define glOrtho GLMock.Ortho
#undef glPassThrough
#define glPassThrough GLMock.PassThrough
#undef glPixelMapfv
#define glPixelMapfv GLMock.PixelMapfv
#undef glPixelMapuiv
#define glPixelMapuiv GLMock.PixelMapuiv
#undef glPixelMapusv
#define glPixelMapusv GLMock.PixelMapusv
#undef glPixelStoref
#define glPixelStoref GLMock.PixelStoref
#undef glPixelStorei
#define glPixelStorei GLMock.PixelStorei
#undef glPixelTransferf
#define glPixelTransferf GLMock.PixelTransferf
#undef glPixelTransferi
#define glPixelTransferi GLMock.PixelTransferi
#undef glPixelZoom
#define glPixelZoom GLMock.PixelZoom
#undef glPointSize
#define glPointSize GLMock.PointSize
#undef glPolygonMode
#define glPolygonMode GLMock.PolygonMode
#undef glPolygonOffset
#define glPolygonOffset GLMock.PolygonOffset
#undef glPolygonStipple
#define glPolygonStipple GLMock.PolygonStipple
#undef glPopAttrib
#define glPopAttrib GLMock.PopAttrib
#undef glPopClientAttrib
#define glPopClientAttrib GLMock.PopClientAttrib
#undef glPopMatrix
#define glPopMatrix GLMock.PopMatrix
#undef glPopName
#define glPopName GLMock.PopName
#undef glPrioritizeTextures
#define glPrioritizeTextures GLMock.PrioritizeTextures
#undef glPushAttrib
#define glPushAttrib GLMock.PushAttrib
#undef glPushClientAttrib
#define glPushClientAttrib GLMock.PushClientAttrib
#undef glPushMatrix
#define glPushMatrix GLMock.PushMatrix
#undef glPushName
#define glPushName GLMock.PushName
#undef glRasterPos2d
#define glRasterPos2d GLMock.RasterPos2d
#undef glRasterPos2dv
#define glRasterPos2dv GLMock.RasterPos2dv
#undef glRasterPos2f
#define glRasterPos2f GLMock.RasterPos2f
#undef glRasterPos2fv
#define glRasterPos2fv GLMock.RasterPos2fv
#undef glRasterPos2i
#define glRasterPos2i GLMock.RasterPos2i
#undef glRasterPos2iv
#define glRasterPos2iv GLMock.RasterPos2iv
#undef glRasterPos2s
#define glRasterPos2s GLMock.RasterPos2s
#undef glRasterPos2sv
#define glRasterPos2sv GLMock.RasterPos2sv
#undef glRasterPos3d
#define glRasterPos3d GLMock.RasterPos3d
#undef glRasterPos3dv
#define glRasterPos3dv GLMock.RasterPos3dv
#undef glRasterPos3f
#define glRasterPos3f GLMock.RasterPos3f
#undef glRasterPos3fv
#define glRasterPos3fv GLMock.RasterPos3fv
#undef glRasterPos3i
#define glRasterPos3i GLMock.RasterPos3i
#undef glRasterPos3iv
#define glRasterPos3iv GLMock.RasterPos3iv
#undef glRasterPos3s
#define glRasterPos3s GLMock.RasterPos3s
#undef glRasterPos3sv
#define glRasterPos3sv GLMock.RasterPos3sv
#undef glRasterPos4d
#define glRasterPos4d GLMock.RasterPos4d
#undef glRasterPos4dv
#define glRasterPos4dv GLMock.RasterPos4dv
#undef glRasterPos4f
#define glRasterPos4f GLMock.RasterPos4f
#undef glRasterPos4fv
#define glRasterPos4fv GLMock.RasterPos4fv
#undef glRasterPos4i
#define glRasterPos4i GLMock.RasterPos4i
#undef glRasterPos4iv
#define glRasterPos4iv GLMock.RasterPos4iv
#undef glRasterPos4s
#define glRasterPos4s GLMock.RasterPos4s
#undef glRasterPos4sv
#define glRasterPos4sv GLMock.RasterPos4sv
#undef glReadBuffer
#define glReadBuffer GLMock.ReadBuffer
#undef glReadPixels
#define glReadPixels GLMock.ReadPixels
#undef glRectd
#define glRectd GLMock.Rectd
#undef glRectdv
#define glRectdv GLMock.Rectdv
#undef glRectf
#define glRectf GLMock.Rectf
#undef glRectfv
#define glRectfv GLMock.Rectfv
#undef glRecti
#define glRecti GLMock.Recti
#undef glRectiv
#define glRectiv GLMock.Rectiv
#undef glRects
#define glRects GLMock.Rects
#undef glRectsv
#define glRectsv GLMock.Rectsv
#undef glRenderMode
#define glRenderMode GLMock.RenderMode
#undef glRotated
#define glRotated GLMock.Rotated
#undef glRotatef
#define glRotatef GLMock.Rotatef
#undef glScaled
#define glScaled GLMock.Scaled
#undef glScalef
#define glScalef GLMock.Scalef
#undef glScissor
#define glScissor GLMock.Scissor
#undef glSelectBuffer
#define glSelectBuffer GLMock.SelectBuffer
#undef glShadeModel
#define glShadeModel GLMock.ShadeModel
#undef glStencilFunc
#define glStencilFunc GLMock.StencilFunc
#undef glStencilMask
#define glStencilMask GLMock.StencilMask
#undef glStencilOp
#define glStencilOp GLMock.StencilOp
#undef glTexCoord1d
#define glTexCoord1d GLMock.TexCoord1d
#undef glTexCoord1dv
#define glTexCoord1dv GLMock.TexCoord1dv
#undef glTexCoord1f
#define glTexCoord1f GLMock.TexCoord1f
#undef glTexCoord1fv
#define glTexCoord1fv GLMock.TexCoord1fv
#undef glTexCoord1i
#define glTexCoord1i GLMock.TexCoord1i
#undef glTexCoord1iv
#define glTexCoord1iv GLMock.TexCoord1iv
#undef glTexCoord1s
#define glTexCoord1s GLMock.TexCoord1s
#undef glTexCoord1sv
#define glTexCoord1sv GLMock.TexCoord1sv
#undef glTexCoord2d
#define glTexCoord2d GLMock.TexCoord2d
#undef glTexCoord2dv
#define glTexCoord2dv GLMock.TexCoord2dv
#undef glTexCoord2f
#define glTexCoord2f GLMock.TexCoord2f
#undef glTexCoord2fv
#define glTexCoord2fv GLMock.TexCoord2fv
#undef glTexCoord2i
#define glTexCoord2i GLMock.TexCoord2i
#undef glTexCoord2iv
#define glTexCoord2iv GLMock.TexCoord2iv
#undef glTexCoord2s
#define glTexCoord2s GLMock.TexCoord2s
#undef glTexCoord2sv
#define glTexCoord2sv GLMock.TexCoord2sv
#undef glTexCoord3d
#define glTexCoord3d GLMock.TexCoord3d
#undef glTexCoord3dv
#define glTexCoord3dv GLMock.TexCoord3dv
#undef glTexCoord3f
#define glTexCoord3f GLMock.TexCoord3f
#undef glTexCoord3fv
#define glTexCoord3fv GLMock.TexCoord3fv
#undef glTexCoord3i
#define glTexCoord3i GLMock.TexCoord3i
#undef glTexCoord3iv
#define glTexCoord3iv GLMock.TexCoord3iv
#undef glTexCoord3s
#define glTexCoord3s GLMock.TexCoord3s
#undef glTexCoord3sv
#define glTexCoord3sv GLMock.TexCoord3sv
#undef glTexCoord4d
#define glTexCoord4d GLMock.TexCoord4d
#undef glTexCoord4dv
#define glTexCoord4dv GLMock.TexCoord4dv
#undef glTexCoord4f
#define glTexCoord4f GLMock.TexCoord4f
#undef glTexCoord4fv
#define glTexCoord4fv GLMock.TexCoord4fv
#undef glTexCoord4i
#define glTexCoord4i GLMock.TexCoord4i
#undef glTexCoord4iv
#define glTexCoord4iv GLMock.TexCoord4iv
#undef glTexCoord4s
#define glTexCoord4s GLMock.TexCoord4s
#undef glTexCoord4sv
#define glTexCoord4sv GLMock.TexCoord4sv
#undef glTexCoordPointer
#define glTexCoordPointer GLMock.TexCoordPointer
#undef glTexEnvf
#define glTexEnvf GLMock.TexEnvf
#undef glTexEnvfv
#define glTexEnvfv GLMock.TexEnvfv
#undef glTexEnvi
#define glTexEnvi GLMock.TexEnvi
#undef glTexEnviv
#define glTexEnviv GLMock.TexEnviv
#undef glTexGend
#define glTexGend GLMock.TexGend
#undef glTexGendv
#define glTexGendv GLMock.TexGendv
#undef glTexGenf
#define glTexGenf GLMock.TexGenf
#undef glTexGenfv
#define glTexGenfv GLMock.TexGenfv
#undef glTexGeni
#define glTexGeni GLMock.TexGeni
#undef glTexGeniv
#define glTexGeniv GLMock.TexGeniv
#undef glTexImage1D
#define glTexImage1D GLMock.TexImage1D
#undef glTexImage2D
#define glTexImage2D GLMock.TexImage2D
#undef glTexParameterf
#define glTexParameterf GLMock.TexParameterf
#undef glTexParameterfv
#define glTexParameterfv GLMock.TexParameterfv
#undef glTexParameteri
#define glTexParameteri GLMock.TexParameteri
#undef glTexParameteriv
#define glTexParameteriv GLMock.TexParameteriv
#undef glTexSubImage1D
#define glTexSubImage1D GLMock.TexSubImage1D
#undef glTexSubImage2D
#define glTexSubImage2D GLMock.TexSubImage2D
#undef glTranslated
#define glTranslated GLMock.Translated
#undef glTranslatef
#define glTranslatef GLMock.Translatef
#undef glVertex2d
#define glVertex2d GLMock.Vertex2d
#undef glVertex2dv
#define glVertex2dv GLMock.Vertex2dv
#undef glVertex2f
#define glVertex2f GLMock.Vertex2f
#undef glVertex2fv
#define glVertex2fv GLMock.Vertex2fv
#undef glVertex2i
#define glVertex2i GLMock.Vertex2i
#undef glVertex2iv
#define glVertex2iv GLMock.Vertex2iv
#undef glVertex2s
#define glVertex2s GLMock.Vertex2s
#undef glVertex2sv
#define glVertex2sv GLMock.Vertex2sv
#undef glVertex3d
#define glVertex3d GLMock.Vertex3d
#undef glVertex3dv
#define glVertex3dv GLMock.Vertex3dv
#undef glVertex3f
#define glVertex3f GLMock.Vertex3f
#undef glVertex3fv
#define glVertex3fv GLMock.Vertex3fv
#undef glVertex3i
#define glVertex3i GLMock.Vertex3i
#undef glVertex3iv
#define glVertex3iv GLMock.Vertex3iv
#undef glVertex3s
#define glVertex3s GLMock.Vertex3s
#undef glVertex3sv
#define glVertex3sv GLMock.Vertex3sv
#undef glVertex4d
#define glVertex4d GLMock.Vertex4d
#undef glVertex4dv
#define glVertex4dv GLMock.Vertex4dv
#undef glVertex4f
#define glVertex4f GLMock.Vertex4f
#undef glVertex4fv
#define glVertex4fv GLMock.Vertex4fv
#undef glVertex4i
#define glVertex4i GLMock.Vertex4i
#undef glVertex4iv
#define glVertex4iv GLMock.Vertex4iv
#undef glVertex4s
#define glVertex4s GLMock.Vertex4s
#undef glVertex4sv
#define glVertex4sv GLMock.Vertex4sv
#undef glVertexPointer
#define glVertexPointer GLMock.VertexPointer
#undef glViewport
#define glViewport GLMock.Viewport
#undef glCopyTexSubImage3D
#define glCopyTexSubImage3D GLMock.CopyTexSubImage3D
#undef glDrawRangeElements
#define glDrawRangeElements GLMock.DrawRangeElements
#undef glTexImage3D
#define glTexImage3D GLMock.TexImage3D
#undef glTexSubImage3D
#define glTexSubImage3D GLMock.TexSubImage3D
#undef glActiveTexture
#define glActiveTexture GLMock.ActiveTexture
#undef glClientActiveTexture
#define glClientActiveTexture GLMock.ClientActiveTexture
#undef glCompressedTexImage1D
#define glCompressedTexImage1D GLMock.CompressedTexImage1D
#undef glCompressedTexImage2D
#define glCompressedTexImage2D GLMock.CompressedTexImage2D
#undef glCompressedTexImage3D
#define glCompressedTexImage3D GLMock.CompressedTexImage3D
#undef glCompressedTexSubImage1D
#define glCompressedTexSubImage1D GLMock.CompressedTexSubImage1D
#undef glCompressedTexSubImage2D
#define glCompressedTexSubImage2D GLMock.CompressedTexSubImage2D
#undef glCompressedTexSubImage3D
#define glCompressedTexSubImage3D GLMock.CompressedTexSubImage3D
#undef glGetCompressedTexImage
#define glGetCompressedTexImage GLMock.GetCompressedTexImage
#undef glLoadTransposeMatrixd
#define glLoadTransposeMatrixd GLMock.LoadTransposeMatrixd
#undef glLoadTransposeMatrixf
#define glLoadTransposeMatrixf GLMock.LoadTransposeMatrixf
#undef glMultTransposeMatrixd
#define glMultTransposeMatrixd GLMock.MultTransposeMatrixd
#undef glMultTransposeMatrixf
#define glMultTransposeMatrixf GLMock.MultTransposeMatrixf
#undef glMultiTexCoord1d
#define glMultiTexCoord1d GLMock.MultiTexCoord1d
#undef glMultiTexCoord1dv
#define glMultiTexCoord1dv GLMock.MultiTexCoord1dv
#undef glMultiTexCoord1f
#define glMultiTexCoord1f GLMock.MultiTexCoord1f
#undef glMultiTexCoord1fv
#define glMultiTexCoord1fv GLMock.MultiTexCoord1fv
#undef glMultiTexCoord1i
#define glMultiTexCoord1i GLMock.MultiTexCoord1i
#undef glMultiTexCoord1iv
#define glMultiTexCoord1iv GLMock.MultiTexCoord1iv
#undef glMultiTexCoord1s
#define glMultiTexCoord1s GLMock.MultiTexCoord1s
#undef glMultiTexCoord1sv
#define glMultiTexCoord1sv GLMock.MultiTexCoord1sv
#undef glMultiTexCoord2d
#define glMultiTexCoord2d GLMock.MultiTexCoord2d
#undef glMultiTexCoord2dv
#define glMultiTexCoord2dv GLMock.MultiTexCoord2dv
#undef glMultiTexCoord2f
#define glMultiTexCoord2f GLMock.MultiTexCoord2f
#undef glMultiTexCoord2fv
#define glMultiTexCoord2fv GLMock.MultiTexCoord2fv
#undef glMultiTexCoord2i
#define glMultiTexCoord2i GLMock.MultiTexCoord2i
#undef glMultiTexCoord2iv
#define glMultiTexCoord2iv GLMock.MultiTexCoord2iv
#undef glMultiTexCoord2s
#define glMultiTexCoord2s GLMock.MultiTexCoord2s
#undef glMultiTexCoord2sv
#define glMultiTexCoord2sv GLMock.MultiTexCoord2sv
#undef glMultiTexCoord3d
#define glMultiTexCoord3d GLMock.MultiTexCoord3d
#undef glMultiTexCoord3dv
#define glMultiTexCoord3dv GLMock.MultiTexCoord3dv
#undef glMultiTexCoord3f
#define glMultiTexCoord3f GLMock.MultiTexCoord3f
#undef glMultiTexCoord3fv
#define glMultiTexCoord3fv GLMock.MultiTexCoord3fv
#undef glMultiTexCoord3i
#define glMultiTexCoord3i GLMock.MultiTexCoord3i
#undef glMultiTexCoord3iv
#define glMultiTexCoord3iv GLMock.MultiTexCoord3iv
#undef glMultiTexCoord3s
#define glMultiTexCoord3s GLMock.MultiTexCoord3s
#undef glMultiTexCoord3sv
#define glMultiTexCoord3sv GLMock.MultiTexCoord3sv
#undef glMultiTexCoord4d
#define glMultiTexCoord4d GLMock.MultiTexCoord4d
#undef glMultiTexCoord4dv
#define glMultiTexCoord4dv GLMock.MultiTexCoord4dv
#undef glMultiTexCoord4f
#define glMultiTexCoord4f GLMock.MultiTexCoord4f
#undef glMultiTexCoord4fv
#define glMultiTexCoord4fv GLMock.MultiTexCoord4fv
#undef glMultiTexCoord4i
#define glMultiTexCoord4i GLMock.MultiTexCoord4i
#undef glMultiTexCoord4iv
#define glMultiTexCoord4iv GLMock.MultiTexCoord4iv
#undef glMultiTexCoord4s
#define glMultiTexCoord4s GLMock.MultiTexCoord4s
#undef glMultiTexCoord4sv
#define glMultiTexCoord4sv GLMock.MultiTexCoord4sv
#undef glSampleCoverage
#define glSampleCoverage GLMock.SampleCoverage
#undef glBlendColor
#define glBlendColor GLMock.BlendColor
#undef glBlendEquation
#define glBlendEquation GLMock.BlendEquation
#undef glBlendFuncSeparate
#define glBlendFuncSeparate GLMock.BlendFuncSeparate
#undef glFogCoordPointer
#define glFogCoordPointer GLMock.FogCoordPointer
#undef glFogCoordd
#define glFogCoordd GLMock.FogCoordd
#undef glFogCoorddv
#define glFogCoorddv GLMock.FogCoorddv
#undef glFogCoordf
#define glFogCoordf GLMock.FogCoordf
#undef glFogCoordfv
#define glFogCoordfv GLMock.FogCoordfv
#undef glMultiDrawArrays
#define glMultiDrawArrays GLMock.MultiDrawArrays
#undef glMultiDrawElements
#define glMultiDrawElements GLMock.MultiDrawElements
#undef glPointParameterf
#define glPointParameterf GLMock.PointParameterf
#undef glPointParameterfv
#define glPointParameterfv GLMock.PointParameterfv
#undef glPointParameteri
#define glPointParameteri GLMock.PointParameteri
#undef glPointParameteriv
#define glPointParameteriv GLMock.PointParameteriv
#undef glSecondaryColor3b
#define glSecondaryColor3b GLMock.SecondaryColor3b
#undef glSecondaryColor3bv
#define glSecondaryColor3bv GLMock.SecondaryColor3bv
#undef glSecondaryColor3d
#define glSecondaryColor3d GLMock.SecondaryColor3d
#undef glSecondaryColor3dv
#define glSecondaryColor3dv GLMock.SecondaryColor3dv
#undef glSecondaryColor3f
#define glSecondaryColor3f GLMock.SecondaryColor3f
#undef glSecondaryColor3fv
#define glSecondaryColor3fv GLMock.SecondaryColor3fv
#undef glSecondaryColor3i
#define glSecondaryColor3i GLMock.SecondaryColor3i
#undef glSecondaryColor3iv
#define glSecondaryColor3iv GLMock.SecondaryColor3iv
#undef glSecondaryColor3s
#define glSecondaryColor3s GLMock.SecondaryColor3s
#undef glSecondaryColor3sv
#define glSecondaryColor3sv GLMock.SecondaryColor3sv
#undef glSecondaryColor3ub
#define glSecondaryColor3ub GLMock.SecondaryColor3ub
#undef glSecondaryColor3ubv
#define glSecondaryColor3ubv GLMock.SecondaryColor3ubv
#undef glSecondaryColor3ui
#define glSecondaryColor3ui GLMock.SecondaryColor3ui
#undef glSecondaryColor3uiv
#define glSecondaryColor3uiv GLMock.SecondaryColor3uiv
#undef glSecondaryColor3us
#define glSecondaryColor3us GLMock.SecondaryColor3us
#undef glSecondaryColor3usv
#define glSecondaryColor3usv GLMock.SecondaryColor3usv
#undef glSecondaryColorPointer
#define glSecondaryColorPointer GLMock.SecondaryColorPointer
#undef glWindowPos2d
#define glWindowPos2d GLMock.WindowPos2d
#undef glWindowPos2dv
#define glWindowPos2dv GLMock.WindowPos2dv
#undef glWindowPos2f
#define glWindowPos2f GLMock.WindowPos2f
#undef glWindowPos2fv
#define glWindowPos2fv GLMock.WindowPos2fv
#undef glWindowPos2i
#define glWindowPos2i GLMock.WindowPos2i
#undef glWindowPos2iv
#define glWindowPos2iv GLMock.WindowPos2iv
#undef glWindowPos2s
#define glWindowPos2s GLMock.WindowPos2s
#undef glWindowPos2sv
#define glWindowPos2sv GLMock.WindowPos2sv
#undef glWindowPos3d
#define glWindowPos3d GLMock.WindowPos3d
#undef glWindowPos3dv
#define glWindowPos3dv GLMock.WindowPos3dv
#undef glWindowPos3f
#define glWindowPos3f GLMock.WindowPos3f
#undef glWindowPos3fv
#define glWindowPos3fv GLMock.WindowPos3fv
#undef glWindowPos3i
#define glWindowPos3i GLMock.WindowPos3i
#undef glWindowPos3iv
#define glWindowPos3iv GLMock.WindowPos3iv
#undef glWindowPos3s
#define glWindowPos3s GLMock.WindowPos3s
#undef glWindowPos3sv
#define glWindowPos3sv GLMock.WindowPos3sv
#undef glBeginQuery
#define glBeginQuery GLMock.BeginQuery
#undef glBindBuffer
#define glBindBuffer GLMock.BindBuffer
#undef glBufferData
#define glBufferData GLMock.BufferData
#undef glBufferSubData
#define glBufferSubData GLMock.BufferSubData
#undef glDeleteBuffers
#define glDeleteBuffers GLMock.DeleteBuffers
#undef glDeleteQueries
#define glDeleteQueries GLMock.DeleteQueries
#undef glEndQuery
#define glEndQuery GLMock.EndQuery
#undef glGenBuffers
#define glGenBuffers GLMock.GenBuffers
#undef glGenQueries
#define glGenQueries GLMock.GenQueries
#undef glGetBufferParameteriv
#define glGetBufferParameteriv GLMock.GetBufferParameteriv
#undef glGetBufferPointerv
#define glGetBufferPointerv GLMock.GetBufferPointerv
#undef glGetBufferSubData
#define glGetBufferSubData GLMock.GetBufferSubData
#undef glGetQueryObjectiv
#define glGetQueryObjectiv GLMock.GetQueryObjectiv
#undef glGetQueryObjectuiv
#define glGetQueryObjectuiv GLMock.GetQueryObjectuiv
#undef glGetQueryiv
#define glGetQueryiv GLMock.GetQueryiv
#undef glIsBuffer
#define glIsBuffer GLMock.IsBuffer
#undef glIsQuery
#define glIsQuery GLMock.IsQuery
#undef glMapBuffer
#define glMapBuffer GLMock.MapBuffer
#undef glUnmapBuffer
#define glUnmapBuffer GLMock.UnmapBuffer
#undef glAttachShader
#define glAttachShader GLMock.AttachShader
#undef glBindAttribLocation
#define glBindAttribLocation GLMock.BindAttribLocation
#undef glBlendEquationSeparate
#define glBlendEquationSeparate GLMock.BlendEquationSeparate
#undef glCompileShader
#define glCompileShader GLMock.CompileShader
#undef glCreateProgram
#define glCreateProgram GLMock.CreateProgram
#undef glCreateShader
#define glCreateShader GLMock.CreateShader
#undef glDeleteProgram
#define glDeleteProgram GLMock.DeleteProgram
#undef glDeleteShader
#define glDeleteShader GLMock.DeleteShader
#undef glDetachShader
#define glDetachShader GLMock.DetachShader
#undef glDisableVertexAttribArray
#define glDisableVertexAttribArray GLMock.DisableVertexAttribArray
#undef glDrawBuffers
#define glDrawBuffers GLMock.DrawBuffers
#undef glEnableVertexAttribArray
#define glEnableVertexAttribArray GLMock.EnableVertexAttribArray
#undef glGetActiveAttrib
#define glGetActiveAttrib GLMock.GetActiveAttrib
#undef glGetActiveUniform
#define glGetActiveUniform GLMock.GetActiveUniform
#undef glGetAttachedShaders
#define glGetAttachedShaders GLMock.GetAttachedShaders
#undef glGetAttribLocation
#define glGetAttribLocation GLMock.GetAttribLocation
#undef glGetProgramInfoLog
#define glGetProgramInfoLog GLMock.GetProgramInfoLog
#undef glGetProgramiv
#define glGetProgramiv GLMock.GetProgramiv
#undef glGetShaderInfoLog
#define glGetShaderInfoLog GLMock.GetShaderInfoLog
#undef glGetShaderSource
#define glGetShaderSource GLMock.GetShaderSource
#undef glGetShaderiv
#define glGetShaderiv GLMock.GetShaderiv
#undef glGetUniformLocation
#define glGetUniformLocation GLMock.GetUniformLocation
#undef glGetUniformfv
#define glGetUniformfv GLMock.GetUniformfv
#undef glGetUniformiv
#define glGetUniformiv GLMock.GetUniformiv
#undef glGetVertexAttribPointerv
#define glGetVertexAttribPointerv GLMock.GetVertexAttribPointerv
#undef glGetVertexAttribdv
#define glGetVertexAttribdv GLMock.GetVertexAttribdv
#undef glGetVertexAttribfv
#define glGetVertexAttribfv GLMock.GetVertexAttribfv
#undef glGetVertexAttribiv
#define glGetVertexAttribiv GLMock.GetVertexAttribiv
#undef glIsProgram
#define glIsProgram GLMock.IsProgram
#undef glIsShader
#define glIsShader GLMock.IsShader
#undef glLinkProgram
#define glLinkProgram GLMock.LinkProgram
#undef glShaderSource
#define glShaderSource GLMock.ShaderSource
#undef glStencilFuncSeparate
#define glStencilFuncSeparate GLMock.StencilFuncSeparate
#undef glStencilMaskSeparate
#define glStencilMaskSeparate GLMock.StencilMaskSeparate
#undef glStencilOpSeparate
#define glStencilOpSeparate GLMock.StencilOpSeparate
#undef glUniform1f
#define glUniform1f GLMock.Uniform1f
#undef glUniform1fv
#define glUniform1fv GLMock.Uniform1fv
#undef glUniform1i
#define glUniform1i GLMock.Uniform1i
#undef glUniform1iv
#define glUniform1iv GLMock.Uniform1iv
#undef glUniform2f
#define glUniform2f GLMock.Uniform2f
#undef glUniform2fv
#define glUniform2fv GLMock.Uniform2fv
#undef glUniform2i
#define glUniform2i GLMock.Uniform2i
#undef glUniform2iv
#define glUniform2iv GLMock.Uniform2iv
#undef glUniform3f
#define glUniform3f GLMock.Uniform3f
#undef glUniform3fv
#define glUniform3fv GLMock.Uniform3fv
#undef glUniform3i
#define glUniform3i GLMock.Uniform3i
#undef glUniform3iv
#define glUniform3iv GLMock.Uniform3iv
#undef glUniform4f
#define glUniform4f GLMock.Uniform4f
#undef glUniform4fv
#define glUniform4fv GLMock.Uniform4fv
#undef glUniform4i
#define glUniform4i GLMock.Uniform4i
#undef glUniform4iv
#define glUniform4iv GLMock.Uniform4iv
#undef glUniformMatrix2fv
#define glUniformMatrix2fv GLMock.UniformMatrix2fv
#undef glUniformMatrix3fv
#define glUniformMatrix3fv GLMock.UniformMatrix3fv
#undef glUniformMatrix4fv
#define glUniformMatrix4fv GLMock.UniformMatrix4fv
#undef glUseProgram
#define glUseProgram GLMock.UseProgram
#undef glValidateProgram
#define glValidateProgram GLMock.ValidateProgram
#undef glVertexAttrib1d
#define glVertexAttrib1d GLMock.VertexAttrib1d
#undef glVertexAttrib1dv
#define glVertexAttrib1dv GLMock.VertexAttrib1dv
#undef glVertexAttrib1f
#define glVertexAttrib1f GLMock.VertexAttrib1f
#undef glVertexAttrib1fv
#define glVertexAttrib1fv GLMock.VertexAttrib1fv
#undef glVertexAttrib1s
#define glVertexAttrib1s GLMock.VertexAttrib1s
#undef glVertexAttrib1sv
#define glVertexAttrib1sv GLMock.VertexAttrib1sv
#undef glVertexAttrib2d
#define glVertexAttrib2d GLMock.VertexAttrib2d
#undef glVertexAttrib2dv
#define glVertexAttrib2dv GLMock.VertexAttrib2dv
#undef glVertexAttrib2f
#define glVertexAttrib2f GLMock.VertexAttrib2f
#undef glVertexAttrib2fv
#define glVertexAttrib2fv GLMock.VertexAttrib2fv
#undef glVertexAttrib2s
#define glVertexAttrib2s GLMock.VertexAttrib2s
#undef glVertexAttrib2sv
#define glVertexAttrib2sv GLMock.VertexAttrib2sv
#undef glVertexAttrib3d
#define glVertexAttrib3d GLMock.VertexAttrib3d
#undef glVertexAttrib3dv
#define glVertexAttrib3dv GLMock.VertexAttrib3dv
#undef glVertexAttrib3f
#define glVertexAttrib3f GLMock.VertexAttrib3f
#undef glVertexAttrib3fv
#define glVertexAttrib3fv GLMock.VertexAttrib3fv
#undef glVertexAttrib3s
#define glVertexAttrib3s GLMock.VertexAttrib3s
#undef glVertexAttrib3sv
#define glVertexAttrib3sv GLMock.VertexAttrib3sv
#undef glVertexAttrib4Nbv
#define glVertexAttrib4Nbv GLMock.VertexAttrib4Nbv
#undef glVertexAttrib4Niv
#define glVertexAttrib4Niv GLMock.VertexAttrib4Niv
#undef glVertexAttrib4Nsv
#define glVertexAttrib4Nsv GLMock.VertexAttrib4Nsv
#undef glVertexAttrib4Nub
#define glVertexAttrib4Nub GLMock.VertexAttrib4Nub
#undef glVertexAttrib4Nubv
#define glVertexAttrib4Nubv GLMock.VertexAttrib4Nubv
#undef glVertexAttrib4Nuiv
#define glVertexAttrib4Nuiv GLMock.VertexAttrib4Nuiv
#undef glVertexAttrib4Nusv
#define glVertexAttrib4Nusv GLMock.VertexAttrib4Nusv
#undef glVertexAttrib4bv
#define glVertexAttrib4bv GLMock.VertexAttrib4bv
#undef glVertexAttrib4d
#define glVertexAttrib4d GLMock.VertexAttrib4d
#undef glVertexAttrib4dv
#define glVertexAttrib4dv GLMock.VertexAttrib4dv
#undef glVertexAttrib4f
#define glVertexAttrib4f GLMock.VertexAttrib4f
#undef glVertexAttrib4fv
#define glVertexAttrib4fv GLMock.VertexAttrib4fv
#undef glVertexAttrib4iv
#define glVertexAttrib4iv GLMock.VertexAttrib4iv
#undef glVertexAttrib4s
#define glVertexAttrib4s GLMock.VertexAttrib4s
#undef glVertexAttrib4sv
#define glVertexAttrib4sv GLMock.VertexAttrib4sv
#undef glVertexAttrib4ubv
#define glVertexAttrib4ubv GLMock.VertexAttrib4ubv
#undef glVertexAttrib4uiv
#define glVertexAttrib4uiv GLMock.VertexAttrib4uiv
#undef glVertexAttrib4usv
#define glVertexAttrib4usv GLMock.VertexAttrib4usv
#undef glVertexAttribPointer
#define glVertexAttribPointer GLMock.VertexAttribPointer
#undef glUniformMatrix2x3fv
#define glUniformMatrix2x3fv GLMock.UniformMatrix2x3fv
#undef glUniformMatrix2x4fv
#define glUniformMatrix2x4fv GLMock.UniformMatrix2x4fv
#undef glUniformMatrix3x2fv
#define glUniformMatrix3x2fv GLMock.UniformMatrix3x2fv
#undef glUniformMatrix3x4fv
#define glUniformMatrix3x4fv GLMock.UniformMatrix3x4fv
#undef glUniformMatrix4x2fv
#define glUniformMatrix4x2fv GLMock.UniformMatrix4x2fv
#undef glUniformMatrix4x3fv
#define glUniformMatrix4x3fv GLMock.UniformMatrix4x3fv
#undef glBeginConditionalRender
#define glBeginConditionalRender GLMock.BeginConditionalRender
#undef glBeginTransformFeedback
#define glBeginTransformFeedback GLMock.BeginTransformFeedback
#undef glBindFragDataLocation
#define glBindFragDataLocation GLMock.BindFragDataLocation
#undef glClampColor
#define glClampColor GLMock.ClampColor
#undef glClearBufferfi
#define glClearBufferfi GLMock.ClearBufferfi
#undef glClearBufferfv
#define glClearBufferfv GLMock.ClearBufferfv
#undef glClearBufferiv
#define glClearBufferiv GLMock.ClearBufferiv
#undef glClearBufferuiv
#define glClearBufferuiv GLMock.ClearBufferuiv
#undef glColorMaski
#define glColorMaski GLMock.ColorMaski
#undef glDisablei
#define glDisablei GLMock.Disablei
#undef glEnablei
#define glEnablei GLMock.Enablei
#undef glEndConditionalRender
#define glEndConditionalRender GLMock.EndConditionalRender
#undef glEndTransformFeedback
#define glEndTransformFeedback GLMock.EndTransformFeedback
#undef glGetBooleani_v
#define glGetBooleani_v GLMock.GetBooleani_v
#undef glGetFragDataLocation
#define glGetFragDataLocation GLMock.GetFragDataLocation
#undef glGetStringi
#define glGetStringi GLMock.GetStringi
#undef glGetTexParameterIiv
#define glGetTexParameterIiv GLMock.GetTexParameterIiv
#undef glGetTexParameterIuiv
#define glGetTexParameterIuiv GLMock.GetTexParameterIuiv
#undef glGetTransformFeedbackVarying
#define glGetTransformFeedbackVarying GLMock.GetTransformFeedbackVarying
#undef glGetUniformuiv
#define glGetUniformuiv GLMock.GetUniformuiv
#undef glGetVertexAttribIiv
#define glGetVertexAttribIiv GLMock.GetVertexAttribIiv
#undef glGetVertexAttribIuiv
#define glGetVertexAttribIuiv GLMock.GetVertexAttribIuiv
#undef glIsEnabledi
#define glIsEnabledi GLMock.IsEnabledi
#undef glTexParameterIiv
#define glTexParameterIiv GLMock.TexParameterIiv
#undef glTexParameterIuiv
#define glTexParameterIuiv GLMock.TexParameterIuiv
#undef glTransformFeedbackVaryings
#define glTransformFeedbackVaryings GLMock.TransformFeedbackVaryings
#undef glUniform1ui
#define glUniform1ui GLMock.Uniform1ui
#undef glUniform1uiv
#define glUniform1uiv GLMock.Uniform1uiv
#undef glUniform2ui
#define glUniform2ui GLMock.Uniform2ui
#undef glUniform2uiv
#define glUniform2uiv GLMock.Uniform2uiv
#undef glUniform3ui
#define glUniform3ui GLMock.Uniform3ui
#undef glUniform3uiv
#define glUniform3uiv GLMock.Uniform3uiv
#undef glUniform4ui
#define glUniform4ui GLMock.Uniform4ui
#undef glUniform4uiv
#define glUniform4uiv GLMock.Uniform4uiv
#undef glVertexAttribI1i
#define glVertexAttribI1i GLMock.VertexAttribI1i
#undef glVertexAttribI1iv
#define glVertexAttribI1iv GLMock.VertexAttribI1iv
#undef glVertexAttribI1ui
#define glVertexAttribI1ui GLMock.VertexAttribI1ui
#undef glVertexAttribI1uiv
#define glVertexAttribI1uiv GLMock.VertexAttribI1uiv
#undef glVertexAttribI2i
#define glVertexAttribI2i GLMock.VertexAttribI2i
#undef glVertexAttribI2iv
#define glVertexAttribI2iv GLMock.VertexAttribI2iv
#undef glVertexAttribI2ui
#define glVertexAttribI2ui GLMock.VertexAttribI2ui
#undef glVertexAttribI2uiv
#define glVertexAttribI2uiv GLMock.VertexAttribI2uiv
#undef glVertexAttribI3i
#define glVertexAttribI3i GLMock.VertexAttribI3i
#undef glVertexAttribI3iv
#define glVertexAttribI3iv GLMock.VertexAttribI3iv
#undef glVertexAttribI3ui
#define glVertexAttribI3ui GLMock.VertexAttribI3ui
#undef glVertexAttribI3uiv
#define glVertexAttribI3uiv GLMock.VertexAttribI3uiv
#undef glVertexAttribI4bv
#define glVertexAttribI4bv GLMock.VertexAttribI4bv
#undef glVertexAttribI4i
#define glVertexAttribI4i GLMock.VertexAttribI4i
#undef glVertexAttribI4iv
#define glVertexAttribI4iv GLMock.VertexAttribI4iv
#undef glVertexAttribI4sv
#define glVertexAttribI4sv GLMock.VertexAttribI4sv
#undef glVertexAttribI4ubv
#define glVertexAttribI4ubv GLMock.VertexAttribI4ubv
#undef glVertexAttribI4ui
#define glVertexAttribI4ui GLMock.VertexAttribI4ui
#undef glVertexAttribI4uiv
#define glVertexAttribI4uiv GLMock.VertexAttribI4uiv
#undef glVertexAttribI4usv
#define glVertexAttribI4usv GLMock.VertexAttribI4usv
#undef glVertexAttribIPointer
#define glVertexAttribIPointer GLMock.VertexAttribIPointer
#undef glDrawArraysInstanced
#define glDrawArraysInstanced GLMock.DrawArraysInstanced
#undef glDrawElementsInstanced
#define glDrawElementsInstanced GLMock.DrawElementsInstanced
#undef glPrimitiveRestartIndex
#define glPrimitiveRestartIndex GLMock.PrimitiveRestartIndex
#undef glTexBuffer
#define glTexBuffer GLMock.TexBuffer
#undef glFramebufferTexture
#define glFramebufferTexture GLMock.FramebufferTexture
#undef glGetBufferParameteri64v
#define glGetBufferParameteri64v GLMock.GetBufferParameteri64v
#undef glGetInteger64i_v
#define glGetInteger64i_v GLMock.GetInteger64i_v
#undef glBlendEquationSeparatei
#define glBlendEquationSeparatei GLMock.BlendEquationSeparatei
#undef glBlendEquationi
#define glBlendEquationi GLMock.BlendEquationi
#undef glBlendFuncSeparatei
#define glBlendFuncSeparatei GLMock.BlendFuncSeparatei
#undef glBlendFunci
#define glBlendFunci GLMock.BlendFunci
#undef glMinSampleShading
#define glMinSampleShading GLMock.MinSampleShading
#undef glTbufferMask3DFX
#define glTbufferMask3DFX GLMock.TbufferMask3DFX
#undef glBlendEquationIndexedAMD
#define glBlendEquationIndexedAMD GLMock.BlendEquationIndexedAMD
#undef glBlendEquationSeparateIndexedAMD
#define glBlendEquationSeparateIndexedAMD GLMock.BlendEquationSeparateIndexedAMD
#undef glBlendFuncIndexedAMD
#define glBlendFuncIndexedAMD GLMock.BlendFuncIndexedAMD
#undef glBlendFuncSeparateIndexedAMD
#define glBlendFuncSeparateIndexedAMD GLMock.BlendFuncSeparateIndexedAMD
#undef glBeginPerfMonitorAMD
#define glBeginPerfMonitorAMD GLMock.BeginPerfMonitorAMD
#undef glDeletePerfMonitorsAMD
#define glDeletePerfMonitorsAMD GLMock.DeletePerfMonitorsAMD
#undef glEndPerfMonitorAMD
#define glEndPerfMonitorAMD GLMock.EndPerfMonitorAMD
#undef glGenPerfMonitorsAMD
#define glGenPerfMonitorsAMD GLMock.GenPerfMonitorsAMD
#undef glGetPerfMonitorCounterDataAMD
#define glGetPerfMonitorCounterDataAMD GLMock.GetPerfMonitorCounterDataAMD
#undef glGetPerfMonitorCounterInfoAMD
#define glGetPerfMonitorCounterInfoAMD GLMock.GetPerfMonitorCounterInfoAMD
#undef glGetPerfMonitorCounterStringAMD
#define glGetPerfMonitorCounterStringAMD GLMock.GetPerfMonitorCounterStringAMD
#undef glGetPerfMonitorCountersAMD
#define glGetPerfMonitorCountersAMD GLMock.GetPerfMonitorCountersAMD
#undef glGetPerfMonitorGroupStringAMD
#define glGetPerfMonitorGroupStringAMD GLMock.GetPerfMonitorGroupStringAMD
#undef glGetPerfMonitorGroupsAMD
#define glGetPerfMonitorGroupsAMD GLMock.GetPerfMonitorGroupsAMD
#undef glSelectPerfMonitorCountersAMD
#define glSelectPerfMonitorCountersAMD GLMock.SelectPerfMonitorCountersAMD
#undef glTessellationFactorAMD
#define glTessellationFactorAMD GLMock.TessellationFactorAMD
#undef glTessellationModeAMD
#define glTessellationModeAMD GLMock.TessellationModeAMD
#undef glDrawElementArrayAPPLE
#define glDrawElementArrayAPPLE GLMock.DrawElementArrayAPPLE
#undef glDrawRangeElementArrayAPPLE
#define glDrawRangeElementArrayAPPLE GLMock.DrawRangeElementArrayAPPLE
#undef glElementPointerAPPLE
#define glElementPointerAPPLE GLMock.ElementPointerAPPLE
#undef glMultiDrawElementArrayAPPLE
#define glMultiDrawElementArrayAPPLE GLMock.MultiDrawElementArrayAPPLE
#undef glMultiDrawRangeElementArrayAPPLE
#define glMultiDrawRangeElementArrayAPPLE GLMock.MultiDrawRangeElementArrayAPPLE
#undef glDeleteFencesAPPLE
#define glDeleteFencesAPPLE GLMock.DeleteFencesAPPLE
#undef glFinishFenceAPPLE
#define glFinishFenceAPPLE GLMock.FinishFenceAPPLE
#undef glFinishObjectAPPLE
#define glFinishObjectAPPLE GLMock.FinishObjectAPPLE
#undef glGenFencesAPPLE
#define glGenFencesAPPLE GLMock.GenFencesAPPLE
#undef glIsFenceAPPLE
#define glIsFenceAPPLE GLMock.IsFenceAPPLE
#undef glSetFenceAPPLE
#define glSetFenceAPPLE GLMock.SetFenceAPPLE
#undef glTestFenceAPPLE
#define glTestFenceAPPLE GLMock.TestFenceAPPLE
#undef glTestObjectAPPLE
#define glTestObjectAPPLE GLMock.TestObjectAPPLE
#undef glBufferParameteriAPPLE
#define glBufferParameteriAPPLE GLMock.BufferParameteriAPPLE
#undef glFlushMappedBufferRangeAPPLE
#define glFlushMappedBufferRangeAPPLE GLMock.FlushMappedBufferRangeAPPLE
#undef glGetObjectParameterivAPPLE
#define glGetObjectParameterivAPPLE GLMock.GetObjectParameterivAPPLE
#undef glObjectPurgeableAPPLE
#define glObjectPurgeableAPPLE GLMock.ObjectPurgeableAPPLE
#undef glObjectUnpurgeableAPPLE
#define glObjectUnpurgeableAPPLE GLMock.ObjectUnpurgeableAPPLE
#undef glGetTexParameterPointervAPPLE
#define glGetTexParameterPointervAPPLE GLMock.GetTexParameterPointervAPPLE
#undef glTextureRangeAPPLE
#define glTextureRangeAPPLE GLMock.TextureRangeAPPLE
#undef glBindVertexArrayAPPLE
#define glBindVertexArrayAPPLE GLMock.BindVertexArrayAPPLE
#undef glDeleteVertexArraysAPPLE
#define glDeleteVertexArraysAPPLE GLMock.DeleteVertexArraysAPPLE
#undef glGenVertexArraysAPPLE
#define glGenVertexArraysAPPLE GLMock.GenVertexArraysAPPLE
#undef glIsVertexArrayAPPLE
#define glIsVertexArrayAPPLE GLMock.IsVertexArrayAPPLE
#undef glFlushVertexArrayRangeAPPLE
#define glFlushVertexArrayRangeAPPLE GLMock.FlushVertexArrayRangeAPPLE
#undef glVertexArrayParameteriAPPLE
#define glVertexArrayParameteriAPPLE GLMock.VertexArrayParameteriAPPLE
#undef glVertexArrayRangeAPPLE
#define glVertexArrayRangeAPPLE GLMock.VertexArrayRangeAPPLE
#undef glDisableVertexAttribAPPLE
#define glDisableVertexAttribAPPLE GLMock.DisableVertexAttribAPPLE
#undef glEnableVertexAttribAPPLE
#define glEnableVertexAttribAPPLE GLMock.EnableVertexAttribAPPLE
#undef glIsVertexAttribEnabledAPPLE
#define glIsVertexAttribEnabledAPPLE GLMock.IsVertexAttribEnabledAPPLE
#undef glMapVertexAttrib1dAPPLE
#define glMapVertexAttrib1dAPPLE GLMock.MapVertexAttrib1dAPPLE
#undef glMapVertexAttrib1fAPPLE
#define glMapVertexAttrib1fAPPLE GLMock.MapVertexAttrib1fAPPLE
#undef glMapVertexAttrib2dAPPLE
#define glMapVertexAttrib2dAPPLE GLMock.MapVertexAttrib2dAPPLE
#undef glMapVertexAttrib2fAPPLE
#define glMapVertexAttrib2fAPPLE GLMock.MapVertexAttrib2fAPPLE
#undef glBindFragDataLocationIndexed
#define glBindFragDataLocationIndexed GLMock.BindFragDataLocationIndexed
#undef glGetFragDataIndex
#define glGetFragDataIndex GLMock.GetFragDataIndex
#undef glClampColorARB
#define glClampColorARB GLMock.ClampColorARB
#undef glCopyBufferSubData
#define glCopyBufferSubData GLMock.CopyBufferSubData
#undef glDrawBuffersARB
#define glDrawBuffersARB GLMock.DrawBuffersARB
#undef glBlendEquationSeparateiARB
#define glBlendEquationSeparateiARB GLMock.BlendEquationSeparateiARB
#undef glBlendEquationiARB
#define glBlendEquationiARB GLMock.BlendEquationiARB
#undef glBlendFuncSeparateiARB
#define glBlendFuncSeparateiARB GLMock.BlendFuncSeparateiARB
#undef glBlendFunciARB
#define glBlendFunciARB GLMock.BlendFunciARB
#undef glDrawElementsBaseVertex
#define glDrawElementsBaseVertex GLMock.DrawElementsBaseVertex
#undef glDrawElementsInstancedBaseVertex
#define glDrawElementsInstancedBaseVertex GLMock.DrawElementsInstancedBaseVertex
#undef glDrawRangeElementsBaseVertex
#define glDrawRangeElementsBaseVertex GLMock.DrawRangeElementsBaseVertex
#undef glMultiDrawElementsBaseVertex
#define glMultiDrawElementsBaseVertex GLMock.MultiDrawElementsBaseVertex
#undef glDrawArraysIndirect
#define glDrawArraysIndirect GLMock.DrawArraysIndirect
#undef glDrawElementsIndirect
#define glDrawElementsIndirect GLMock.DrawElementsIndirect
#undef glDrawArraysInstancedARB
#define glDrawArraysInstancedARB GLMock.DrawArraysInstancedARB
#undef glDrawElementsInstancedARB
#define glDrawElementsInstancedARB GLMock.DrawElementsInstancedARB
#undef glBindFramebuffer
#define glBindFramebuffer GLMock.BindFramebuffer
#undef glBindRenderbuffer
#define glBindRenderbuffer GLMock.BindRenderbuffer
#undef glBlitFramebuffer
#define glBlitFramebuffer GLMock.BlitFramebuffer
#undef glCheckFramebufferStatus
#define glCheckFramebufferStatus GLMock.CheckFramebufferStatus
#undef glDeleteFramebuffers
#define glDeleteFramebuffers GLMock.DeleteFramebuffers
#undef glDeleteRenderbuffers
#define glDeleteRenderbuffers GLMock.DeleteRenderbuffers
#undef glFramebufferRenderbuffer
#define glFramebufferRenderbuffer GLMock.FramebufferRenderbuffer
#undef glFramebufferTexture1D
#define glFramebufferTexture1D GLMock.FramebufferTexture1D
#undef glFramebufferTexture2D
#define glFramebufferTexture2D GLMock.FramebufferTexture2D
#undef glFramebufferTexture3D
#define glFramebufferTexture3D GLMock.FramebufferTexture3D
#undef glFramebufferTextureLayer
#define glFramebufferTextureLayer GLMock.FramebufferTextureLayer
#undef glGenFramebuffers
#define glGenFramebuffers GLMock.GenFramebuffers
#undef glGenRenderbuffers
#define glGenRenderbuffers GLMock.GenRenderbuffers
#undef glGenerateMipmap
#define glGenerateMipmap GLMock.GenerateMipmap
#undef glGetFramebufferAttachmentParameteriv
#define glGetFramebufferAttachmentParameteriv GLMock.GetFramebufferAttachmentParameteriv
#undef glGetRenderbufferParameteriv
#define glGetRenderbufferParameteriv GLMock.GetRenderbufferParameteriv
#undef glIsFramebuffer
#define glIsFramebuffer GLMock.IsFramebuffer
#undef glIsRenderbuffer
#define glIsRenderbuffer GLMock.IsRenderbuffer
#undef glRenderbufferStorage
#define glRenderbufferStorage GLMock.RenderbufferStorage
#undef glRenderbufferStorageMultisample
#define glRenderbufferStorageMultisample GLMock.RenderbufferStorageMultisample
#undef glFramebufferTextureARB
#define glFramebufferTextureARB GLMock.FramebufferTextureARB
#undef glFramebufferTextureFaceARB
#define glFramebufferTextureFaceARB GLMock.FramebufferTextureFaceARB
#undef glFramebufferTextureLayerARB
#define glFramebufferTextureLayerARB GLMock.FramebufferTextureLayerARB
#undef glProgramParameteriARB
#define glProgramParameteriARB GLMock.ProgramParameteriARB
#undef glColorSubTable
#define glColorSubTable GLMock.ColorSubTable
#undef glColorTable
#define glColorTable GLMock.ColorTable
#undef glColorTableParameterfv
#define glColorTableParameterfv GLMock.ColorTableParameterfv
#undef glColorTableParameteriv
#define glColorTableParameteriv GLMock.ColorTableParameteriv
#undef glConvolutionFilter1D
#define glConvolutionFilter1D GLMock.ConvolutionFilter1D
#undef glConvolutionFilter2D
#define glConvolutionFilter2D GLMock.ConvolutionFilter2D
#undef glConvolutionParameterf
#define glConvolutionParameterf GLMock.ConvolutionParameterf
#undef glConvolutionParameterfv
#define glConvolutionParameterfv GLMock.ConvolutionParameterfv
#undef glConvolutionParameteri
#define glConvolutionParameteri GLMock.ConvolutionParameteri
#undef glConvolutionParameteriv
#define glConvolutionParameteriv GLMock.ConvolutionParameteriv
#undef glCopyColorSubTable
#define glCopyColorSubTable GLMock.CopyColorSubTable
#undef glCopyColorTable
#define glCopyColorTable GLMock.CopyColorTable
#undef glCopyConvolutionFilter1D
#define glCopyConvolutionFilter1D GLMock.CopyConvolutionFilter1D
#undef glCopyConvolutionFilter2D
#define glCopyConvolutionFilter2D GLMock.CopyConvolutionFilter2D
#undef glGetColorTable
#define glGetColorTable GLMock.GetColorTable
#undef glGetColorTableParameterfv
#define glGetColorTableParameterfv GLMock.GetColorTableParameterfv
#undef glGetColorTableParameteriv
#define glGetColorTableParameteriv GLMock.GetColorTableParameteriv
#undef glGetConvolutionFilter
#define glGetConvolutionFilter GLMock.GetConvolutionFilter
#undef glGetConvolutionParameterfv
#define glGetConvolutionParameterfv GLMock.GetConvolutionParameterfv
#undef glGetConvolutionParameteriv
#define glGetConvolutionParameteriv GLMock.GetConvolutionParameteriv
#undef glGetHistogram
#define glGetHistogram GLMock.GetHistogram
#undef glGetHistogramParameterfv
#define glGetHistogramParameterfv GLMock.GetHistogramParameterfv
#undef glGetHistogramParameteriv
#define glGetHistogramParameteriv GLMock.GetHistogramParameteriv
#undef glGetMinmax
#define glGetMinmax GLMock.GetMinmax
#undef glGetMinmaxParameterfv
#define glGetMinmaxParameterfv GLMock.GetMinmaxParameterfv
#undef glGetMinmaxParameteriv
#define glGetMinmaxParameteriv GLMock.GetMinmaxParameteriv
#undef glGetSeparableFilter
#define glGetSeparableFilter GLMock.GetSeparableFilter
#undef glHistogram
#define glHistogram GLMock.Histogram
#undef glMinmax
#define glMinmax GLMock.Minmax
#undef glResetHistogram
#define glResetHistogram GLMock.ResetHistogram
#undef glResetMinmax
#define glResetMinmax GLMock.ResetMinmax
#undef glSeparableFilter2D
#define glSeparableFilter2D GLMock.SeparableFilter2D
#undef glVertexAttribDivisorARB
#define glVertexAttribDivisorARB GLMock.VertexAttribDivisorARB
#undef glFlushMappedBufferRange
#define glFlushMappedBufferRange GLMock.FlushMappedBufferRange
#undef glMapBufferRange
#define glMapBufferRange GLMock.MapBufferRange
#undef glCurrentPaletteMatrixARB
#define glCurrentPaletteMatrixARB GLMock.CurrentPaletteMatrixARB
#undef glMatrixIndexPointerARB
#define glMatrixIndexPointerARB GLMock.MatrixIndexPointerARB
#undef glMatrixIndexubvARB
#define glMatrixIndexubvARB GLMock.MatrixIndexubvARB
#undef glMatrixIndexuivARB
#define glMatrixIndexuivARB GLMock.MatrixIndexuivARB
#undef glMatrixIndexusvARB
#define glMatrixIndexusvARB GLMock.MatrixIndexusvARB
#undef glSampleCoverageARB
#define glSampleCoverageARB GLMock.SampleCoverageARB
#undef glActiveTextureARB
#define glActiveTextureARB GLMock.ActiveTextureARB
#undef glClientActiveTextureARB
#define glClientActiveTextureARB GLMock.ClientActiveTextureARB
#undef glMultiTexCoord1dARB
#define glMultiTexCoord1dARB GLMock.MultiTexCoord1dARB
#undef glMultiTexCoord1dvARB
#define glMultiTexCoord1dvARB GLMock.MultiTexCoord1dvARB
#undef glMultiTexCoord1fARB
#define glMultiTexCoord1fARB GLMock.MultiTexCoord1fARB
#undef glMultiTexCoord1fvARB
#define glMultiTexCoord1fvARB GLMock.MultiTexCoord1fvARB
#undef glMultiTexCoord1iARB
#define glMultiTexCoord1iARB GLMock.MultiTexCoord1iARB
#undef glMultiTexCoord1ivARB
#define glMultiTexCoord1ivARB GLMock.MultiTexCoord1ivARB
#undef glMultiTexCoord1sARB
#define glMultiTexCoord1sARB GLMock.MultiTexCoord1sARB
#undef glMultiTexCoord1svARB
#define glMultiTexCoord1svARB GLMock.MultiTexCoord1svARB
#undef glMultiTexCoord2dARB
#define glMultiTexCoord2dARB GLMock.MultiTexCoord2dARB
#undef glMultiTexCoord2dvARB
#define glMultiTexCoord2dvARB GLMock.MultiTexCoord2dvARB
#undef glMultiTexCoord2fARB
#define glMultiTexCoord2fARB GLMock.MultiTexCoord2fARB
#undef glMultiTexCoord2fvARB
#define glMultiTexCoord2fvARB GLMock.MultiTexCoord2fvARB
#undef glMultiTexCoord2iARB
#define glMultiTexCoord2iARB GLMock.MultiTexCoord2iARB
#undef glMultiTexCoord2ivARB
#define glMultiTexCoord2ivARB GLMock.MultiTexCoord2ivARB
#undef glMultiTexCoord2sARB
#define glMultiTexCoord2sARB GLMock.MultiTexCoord2sARB
#undef glMultiTexCoord2svARB
#define glMultiTexCoord2svARB GLMock.MultiTexCoord2svARB
#undef glMultiTexCoord3dARB
#define glMultiTexCoord3dARB GLMock.MultiTexCoord3dARB
#undef glMultiTexCoord3dvARB
#define glMultiTexCoord3dvARB GLMock.MultiTexCoord3dvARB
#undef glMultiTexCoord3fARB
#define glMultiTexCoord3fARB GLMock.MultiTexCoord3fARB
#undef glMultiTexCoord3fvARB
#define glMultiTexCoord3fvARB GLMock.MultiTexCoord3fvARB
#undef glMultiTexCoord3iARB
#define glMultiTexCoord3iARB GLMock.MultiTexCoord3iARB
#undef glMultiTexCoord3ivARB
#define glMultiTexCoord3ivARB GLMock.MultiTexCoord3ivARB
#undef glMultiTexCoord3sARB
#define glMultiTexCoord3sARB GLMock.MultiTexCoord3sARB
#undef glMultiTexCoord3svARB
#define glMultiTexCoord3svARB GLMock.MultiTexCoord3svARB
#undef glMultiTexCoord4dARB
#define glMultiTexCoord4dARB GLMock.MultiTexCoord4dARB
#undef glMultiTexCoord4dvARB
#define glMultiTexCoord4dvARB GLMock.MultiTexCoord4dvARB
#undef glMultiTexCoord4fARB
#define glMultiTexCoord4fARB GLMock.MultiTexCoord4fARB
#undef glMultiTexCoord4fvARB
#define glMultiTexCoord4fvARB GLMock.MultiTexCoord4fvARB
#undef glMultiTexCoord4iARB
#define glMultiTexCoord4iARB GLMock.MultiTexCoord4iARB
#undef glMultiTexCoord4ivARB
#define glMultiTexCoord4ivARB GLMock.MultiTexCoord4ivARB
#undef glMultiTexCoord4sARB
#define glMultiTexCoord4sARB GLMock.MultiTexCoord4sARB
#undef glMultiTexCoord4svARB
#define glMultiTexCoord4svARB GLMock.MultiTexCoord4svARB
#undef glBeginQueryARB
#define glBeginQueryARB GLMock.BeginQueryARB
#undef glDeleteQueriesARB
#define glDeleteQueriesARB GLMock.DeleteQueriesARB
#undef glEndQueryARB
#define glEndQueryARB GLMock.EndQueryARB
#undef glGenQueriesARB
#define glGenQueriesARB GLMock.GenQueriesARB
#undef glGetQueryObjectivARB
#define glGetQueryObjectivARB GLMock.GetQueryObjectivARB
#undef glGetQueryObjectuivARB
#define glGetQueryObjectuivARB GLMock.GetQueryObjectuivARB
#undef glGetQueryivARB
#define glGetQueryivARB GLMock.GetQueryivARB
#undef glIsQueryARB
#define glIsQueryARB GLMock.IsQueryARB
#undef glPointParameterfARB
#define glPointParameterfARB GLMock.PointParameterfARB
#undef glPointParameterfvARB
#define glPointParameterfvARB GLMock.PointParameterfvARB
#undef glProvokingVertex
#define glProvokingVertex GLMock.ProvokingVertex
#undef glMinSampleShadingARB
#define glMinSampleShadingARB GLMock.MinSampleShadingARB
#undef glBindSampler
#define glBindSampler GLMock.BindSampler
#undef glDeleteSamplers
#define glDeleteSamplers GLMock.DeleteSamplers
#undef glGenSamplers
#define glGenSamplers GLMock.GenSamplers
#undef glGetSamplerParameterIiv
#define glGetSamplerParameterIiv GLMock.GetSamplerParameterIiv
#undef glGetSamplerParameterIuiv
#define glGetSamplerParameterIuiv GLMock.GetSamplerParameterIuiv
#undef glGetSamplerParameterfv
#define glGetSamplerParameterfv GLMock.GetSamplerParameterfv
#undef glGetSamplerParameteriv
#define glGetSamplerParameteriv GLMock.GetSamplerParameteriv
#undef glIsSampler
#define glIsSampler GLMock.IsSampler
#undef glSamplerParameterIiv
#define glSamplerParameterIiv GLMock.SamplerParameterIiv
#undef glSamplerParameterIuiv
#define glSamplerParameterIuiv GLMock.SamplerParameterIuiv
#undef glSamplerParameterf
#define glSamplerParameterf GLMock.SamplerParameterf
#undef glSamplerParameterfv
#define glSamplerParameterfv GLMock.SamplerParameterfv
#undef glSamplerParameteri
#define glSamplerParameteri GLMock.SamplerParameteri
#undef glSamplerParameteriv
#define glSamplerParameteriv GLMock.SamplerParameteriv
#undef glAttachObjectARB
#define glAttachObjectARB GLMock.AttachObjectARB
#undef glCompileShaderARB
#define glCompileShaderARB GLMock.CompileShaderARB
#undef glCreateProgramObjectARB
#define glCreateProgramObjectARB GLMock.CreateProgramObjectARB
#undef glCreateShaderObjectARB
#define glCreateShaderObjectARB GLMock.CreateShaderObjectARB
#undef glDeleteObjectARB
#define glDeleteObjectARB GLMock.DeleteObjectARB
#undef glDetachObjectARB
#define glDetachObjectARB GLMock.DetachObjectARB
#undef glGetActiveUniformARB
#define glGetActiveUniformARB GLMock.GetActiveUniformARB
#undef glGetAttachedObjectsARB
#define glGetAttachedObjectsARB GLMock.GetAttachedObjectsARB
#undef glGetHandleARB
#define glGetHandleARB GLMock.GetHandleARB
#undef glGetInfoLogARB
#define glGetInfoLogARB GLMock.GetInfoLogARB
#undef glGetObjectParameterfvARB
#define glGetObjectParameterfvARB GLMock.GetObjectParameterfvARB
#undef glGetObjectParameterivARB
#define glGetObjectParameterivARB GLMock.GetObjectParameterivARB
#undef glGetShaderSourceARB
#define glGetShaderSourceARB GLMock.GetShaderSourceARB
#undef glGetUniformLocationARB
#define glGetUniformLocationARB GLMock.GetUniformLocationARB
#undef glGetUniformfvARB
#define glGetUniformfvARB GLMock.GetUniformfvARB
#undef glGetUniformivARB
#define glGetUniformivARB GLMock.GetUniformivARB
#undef glLinkProgramARB
#define glLinkProgramARB GLMock.LinkProgramARB
#undef glShaderSourceARB
#define glShaderSourceARB GLMock.ShaderSourceARB
#undef glUniform1fARB
#define glUniform1fARB GLMock.Uniform1fARB
#undef glUniform1fvARB
#define glUniform1fvARB GLMock.Uniform1fvARB
#undef glUniform1iARB
#define glUniform1iARB GLMock.Uniform1iARB
#undef glUniform1ivARB
#define glUniform1ivARB GLMock.Uniform1ivARB
#undef glUniform2fARB
#define glUniform2fARB GLMock.Uniform2fARB
#undef glUniform2fvARB
#define glUniform2fvARB GLMock.Uniform2fvARB
#undef glUniform2iARB
#define glUniform2iARB GLMock.Uniform2iARB
#undef glUniform2ivARB
#define glUniform2ivARB GLMock.Uniform2ivARB
#undef glUniform3fARB
#define glUniform3fARB GLMock.Uniform3fARB
#undef glUniform3fvARB
#define glUniform3fvARB GLMock.Uniform3fvARB
#undef glUniform3iARB
#define glUniform3iARB GLMock.Uniform3iARB
#undef glUniform3ivARB
#define glUniform3ivARB GLMock.Uniform3ivARB
#undef glUniform4fARB
#define glUniform4fARB GLMock.Uniform4fARB
#undef glUniform4fvARB
#define glUniform4fvARB GLMock.Uniform4fvARB
#undef glUniform4iARB
#define glUniform4iARB GLMock.Uniform4iARB
#undef glUniform4ivARB
#define glUniform4ivARB GLMock.Uniform4ivARB
#undef glUniformMatrix2fvARB
#define glUniformMatrix2fvARB GLMock.UniformMatrix2fvARB
#undef glUniformMatrix3fvARB
#define glUniformMatrix3fvARB GLMock.UniformMatrix3fvARB
#undef glUniformMatrix4fvARB
#define glUniformMatrix4fvARB GLMock.UniformMatrix4fvARB
#undef glUseProgramObjectARB
#define glUseProgramObjectARB GLMock.UseProgramObjectARB
#undef glValidateProgramARB
#define glValidateProgramARB GLMock.ValidateProgramARB
#undef glGetActiveSubroutineName
#define glGetActiveSubroutineName GLMock.GetActiveSubroutineName
#undef glGetActiveSubroutineUniformName
#define glGetActiveSubroutineUniformName GLMock.GetActiveSubroutineUniformName
#undef glGetActiveSubroutineUniformiv
#define glGetActiveSubroutineUniformiv GLMock.GetActiveSubroutineUniformiv
#undef glGetProgramStageiv
#define glGetProgramStageiv GLMock.GetProgramStageiv
#undef glGetSubroutineIndex
#define glGetSubroutineIndex GLMock.GetSubroutineIndex
#undef glGetSubroutineUniformLocation
#define glGetSubroutineUniformLocation GLMock.GetSubroutineUniformLocation
#undef glGetUniformSubroutineuiv
#define glGetUniformSubroutineuiv GLMock.GetUniformSubroutineuiv
#undef glUniformSubroutinesuiv
#define glUniformSubroutinesuiv GLMock.UniformSubroutinesuiv
#undef glCompileShaderIncludeARB
#define glCompileShaderIncludeARB GLMock.CompileShaderIncludeARB
#undef glDeleteNamedStringARB
#define glDeleteNamedStringARB GLMock.DeleteNamedStringARB
#undef glGetNamedStringARB
#define glGetNamedStringARB GLMock.GetNamedStringARB
#undef glGetNamedStringivARB
#define glGetNamedStringivARB GLMock.GetNamedStringivARB
#undef glIsNamedStringARB
#define glIsNamedStringARB GLMock.IsNamedStringARB
#undef glNamedStringARB
#define glNamedStringARB GLMock.NamedStringARB
#undef glClientWaitSync
#define glClientWaitSync GLMock.ClientWaitSync
#undef glDeleteSync
#define glDeleteSync GLMock.DeleteSync
#undef glFenceSync
#define glFenceSync GLMock.FenceSync
#undef glGetInteger64v
#define glGetInteger64v GLMock.GetInteger64v
#undef glGetSynciv
#define glGetSynciv GLMock.GetSynciv
#undef glIsSync
#define glIsSync GLMock.IsSync
#undef glWaitSync
#define glWaitSync GLMock.WaitSync
#undef glPatchParameterfv
#define glPatchParameterfv GLMock.PatchParameterfv
#undef glPatchParameteri
#define glPatchParameteri GLMock.PatchParameteri
#undef glTexBufferARB
#define glTexBufferARB GLMock.TexBufferARB
#undef glCompressedTexImage1DARB
#define glCompressedTexImage1DARB GLMock.CompressedTexImage1DARB
#undef glCompressedTexImage2DARB
#define glCompressedTexImage2DARB GLMock.CompressedTexImage2DARB
#undef glCompressedTexImage3DARB
#define glCompressedTexImage3DARB GLMock.CompressedTexImage3DARB
#undef glCompressedTexSubImage1DARB
#define glCompressedTexSubImage1DARB GLMock.CompressedTexSubImage1DARB
#undef glCompressedTexSubImage2DARB
#define glCompressedTexSubImage2DARB GLMock.CompressedTexSubImage2DARB
#undef glCompressedTexSubImage3DARB
#define glCompressedTexSubImage3DARB GLMock.CompressedTexSubImage3DARB
#undef glGetCompressedTexImageARB
#define glGetCompressedTexImageARB GLMock.GetCompressedTexImageARB
#undef glGetMultisamplefv
#define glGetMultisamplefv GLMock.GetMultisamplefv
#undef glSampleMaski
#define glSampleMaski GLMock.SampleMaski
#undef glTexImage2DMultisample
#define glTexImage2DMultisample GLMock.TexImage2DMultisample
#undef glTexImage3DMultisample
#define glTexImage3DMultisample GLMock.TexImage3DMultisample
#undef glGetQueryObjecti64v
#define glGetQueryObjecti64v GLMock.GetQueryObjecti64v
#undef glGetQueryObjectui64v
#define glGetQueryObjectui64v GLMock.GetQueryObjectui64v
#undef glQueryCounter
#define glQueryCounter GLMock.QueryCounter
#undef glBindTransformFeedback
#define glBindTransformFeedback GLMock.BindTransformFeedback
#undef glDeleteTransformFeedbacks
#define glDeleteTransformFeedbacks GLMock.DeleteTransformFeedbacks
#undef glDrawTransformFeedback
#define glDrawTransformFeedback GLMock.DrawTransformFeedback
#undef glGenTransformFeedbacks
#define glGenTransformFeedbacks GLMock.GenTransformFeedbacks
#undef glIsTransformFeedback
#define glIsTransformFeedback GLMock.IsTransformFeedback
#undef glPauseTransformFeedback
#define glPauseTransformFeedback GLMock.PauseTransformFeedback
#undef glResumeTransformFeedback
#define glResumeTransformFeedback GLMock.ResumeTransformFeedback
#undef glBeginQueryIndexed
#define glBeginQueryIndexed GLMock.BeginQueryIndexed
#undef glDrawTransformFeedbackStream
#define glDrawTransformFeedbackStream GLMock.DrawTransformFeedbackStream
#undef glEndQueryIndexed
#define glEndQueryIndexed GLMock.EndQueryIndexed
#undef glGetQueryIndexediv
#define glGetQueryIndexediv GLMock.GetQueryIndexediv
#undef glLoadTransposeMatrixdARB
#define glLoadTransposeMatrixdARB GLMock.LoadTransposeMatrixdARB
#undef glLoadTransposeMatrixfARB
#define glLoadTransposeMatrixfARB GLMock.LoadTransposeMatrixfARB
#undef glMultTransposeMatrixdARB
#define glMultTransposeMatrixdARB GLMock.MultTransposeMatrixdARB
#undef glMultTransposeMatrixfARB
#define glMultTransposeMatrixfARB GLMock.MultTransposeMatrixfARB
#undef glBindBufferBase
#define glBindBufferBase GLMock.BindBufferBase
#undef glBindBufferRange
#define glBindBufferRange GLMock.BindBufferRange
#undef glGetActiveUniformBlockName
#define glGetActiveUniformBlockName GLMock.GetActiveUniformBlockName
#undef glGetActiveUniformBlockiv
#define glGetActiveUniformBlockiv GLMock.GetActiveUniformBlockiv
#undef glGetActiveUniformName
#define glGetActiveUniformName GLMock.GetActiveUniformName
#undef glGetActiveUniformsiv
#define glGetActiveUniformsiv GLMock.GetActiveUniformsiv
#undef glGetIntegeri_v
#define glGetIntegeri_v GLMock.GetIntegeri_v
#undef glGetUniformBlockIndex
#define glGetUniformBlockIndex GLMock.GetUniformBlockIndex
#undef glGetUniformIndices
#define glGetUniformIndices GLMock.GetUniformIndices
#undef glUniformBlockBinding
#define glUniformBlockBinding GLMock.UniformBlockBinding
#undef glBindVertexArray
#define glBindVertexArray GLMock.BindVertexArray
#undef glDeleteVertexArrays
#define glDeleteVertexArrays GLMock.DeleteVertexArrays
#undef glGenVertexArrays
#define glGenVertexArrays GLMock.GenVertexArrays
#undef glIsVertexArray
#define glIsVertexArray GLMock.IsVertexArray
#undef glVertexBlendARB
#define glVertexBlendARB GLMock.VertexBlendARB
#undef glWeightPointerARB
#define glWeightPointerARB GLMock.WeightPointerARB
#undef glWeightbvARB
#define glWeightbvARB GLMock.WeightbvARB
#undef glWeightdvARB
#define glWeightdvARB GLMock.WeightdvARB
#undef glWeightfvARB
#define glWeightfvARB GLMock.WeightfvARB
#undef glWeightivARB
#define glWeightivARB GLMock.WeightivARB
#undef glWeightsvARB
#define glWeightsvARB GLMock.WeightsvARB
#undef glWeightubvARB
#define glWeightubvARB GLMock.WeightubvARB
#undef glWeightuivARB
#define glWeightuivARB GLMock.WeightuivARB
#undef glWeightusvARB
#define glWeightusvARB GLMock.WeightusvARB
#undef glBindBufferARB
#define glBindBufferARB GLMock.BindBufferARB
#undef glBufferDataARB
#define glBufferDataARB GLMock.BufferDataARB
#undef glBufferSubDataARB
#define glBufferSubDataARB GLMock.BufferSubDataARB
#undef glDeleteBuffersARB
#define glDeleteBuffersARB GLMock.DeleteBuffersARB
#undef glGenBuffersARB
#define glGenBuffersARB GLMock.GenBuffersARB
#undef glGetBufferParameterivARB
#define glGetBufferParameterivARB GLMock.GetBufferParameterivARB
#undef glGetBufferPointervARB
#define glGetBufferPointervARB GLMock.GetBufferPointervARB
#undef glGetBufferSubDataARB
#define glGetBufferSubDataARB GLMock.GetBufferSubDataARB
#undef glIsBufferARB
#define glIsBufferARB GLMock.IsBufferARB
#undef glMapBufferARB
#define glMapBufferARB GLMock.MapBufferARB
#undef glUnmapBufferARB
#define glUnmapBufferARB GLMock.UnmapBufferARB
#undef glBindProgramARB
#define glBindProgramARB GLMock.BindProgramARB
#undef glDeleteProgramsARB
#define glDeleteProgramsARB GLMock.DeleteProgramsARB
#undef glDisableVertexAttribArrayARB
#define glDisableVertexAttribArrayARB GLMock.DisableVertexAttribArrayARB
#undef glEnableVertexAttribArrayARB
#define glEnableVertexAttribArrayARB GLMock.EnableVertexAttribArrayARB
#undef glGenProgramsARB
#define glGenProgramsARB GLMock.GenProgramsARB
#undef glGetProgramEnvParameterdvARB
#define glGetProgramEnvParameterdvARB GLMock.GetProgramEnvParameterdvARB
#undef glGetProgramEnvParameterfvARB
#define glGetProgramEnvParameterfvARB GLMock.GetProgramEnvParameterfvARB
#undef glGetProgramLocalParameterdvARB
#define glGetProgramLocalParameterdvARB GLMock.GetProgramLocalParameterdvARB
#undef glGetProgramLocalParameterfvARB
#define glGetProgramLocalParameterfvARB GLMock.GetProgramLocalParameterfvARB
#undef glGetProgramStringARB
#define glGetProgramStringARB GLMock.GetProgramStringARB
#undef glGetProgramivARB
#define glGetProgramivARB GLMock.GetProgramivARB
#undef glGetVertexAttribPointervARB
#define glGetVertexAttribPointervARB GLMock.GetVertexAttribPointervARB
#undef glGetVertexAttribdvARB
#define glGetVertexAttribdvARB GLMock.GetVertexAttribdvARB
#undef glGetVertexAttribfvARB
#define glGetVertexAttribfvARB GLMock.GetVertexAttribfvARB
#undef glGetVertexAttribivARB
#define glGetVertexAttribivARB GLMock.GetVertexAttribivARB
#undef glIsProgramARB
#define glIsProgramARB GLMock.IsProgramARB
#undef glProgramEnvParameter4dARB
#define glProgramEnvParameter4dARB GLMock.ProgramEnvParameter4dARB
#undef glProgramEnvParameter4dvARB
#define glProgramEnvParameter4dvARB GLMock.ProgramEnvParameter4dvARB
#undef glProgramEnvParameter4fARB
#define glProgramEnvParameter4fARB GLMock.ProgramEnvParameter4fARB
#undef glProgramEnvParameter4fvARB
#define glProgramEnvParameter4fvARB GLMock.ProgramEnvParameter4fvARB
#undef glProgramLocalParameter4dARB
#define glProgramLocalParameter4dARB GLMock.ProgramLocalParameter4dARB
#undef glProgramLocalParameter4dvARB
#define glProgramLocalParameter4dvARB GLMock.ProgramLocalParameter4dvARB
#undef glProgramLocalParameter4fARB
#define glProgramLocalParameter4fARB GLMock.ProgramLocalParameter4fARB
#undef glProgramLocalParameter4fvARB
#define glProgramLocalParameter4fvARB GLMock.ProgramLocalParameter4fvARB
#undef glProgramStringARB
#define glProgramStringARB GLMock.ProgramStringARB
#undef glVertexAttrib1dARB
#define glVertexAttrib1dARB GLMock.VertexAttrib1dARB
#undef glVertexAttrib1dvARB
#define glVertexAttrib1dvARB GLMock.VertexAttrib1dvARB
#undef glVertexAttrib1fARB
#define glVertexAttrib1fARB GLMock.VertexAttrib1fARB
#undef glVertexAttrib1fvARB
#define glVertexAttrib1fvARB GLMock.VertexAttrib1fvARB
#undef glVertexAttrib1sARB
#define glVertexAttrib1sARB GLMock.VertexAttrib1sARB
#undef glVertexAttrib1svARB
#define glVertexAttrib1svARB GLMock.VertexAttrib1svARB
#undef glVertexAttrib2dARB
#define glVertexAttrib2dARB GLMock.VertexAttrib2dARB
#undef glVertexAttrib2dvARB
#define glVertexAttrib2dvARB GLMock.VertexAttrib2dvARB
#undef glVertexAttrib2fARB
#define glVertexAttrib2fARB GLMock.VertexAttrib2fARB
#undef glVertexAttrib2fvARB
#define glVertexAttrib2fvARB GLMock.VertexAttrib2fvARB
#undef glVertexAttrib2sARB
#define glVertexAttrib2sARB GLMock.VertexAttrib2sARB
#undef glVertexAttrib2svARB
#define glVertexAttrib2svARB GLMock.VertexAttrib2svARB
#undef glVertexAttrib3dARB
#define glVertexAttrib3dARB GLMock.VertexAttrib3dARB
#undef glVertexAttrib3dvARB
#define glVertexAttrib3dvARB GLMock.VertexAttrib3dvARB
#undef glVertexAttrib3fARB
#define glVertexAttrib3fARB GLMock.VertexAttrib3fARB
#undef glVertexAttrib3fvARB
#define glVertexAttrib3fvARB GLMock.VertexAttrib3fvARB
#undef glVertexAttrib3sARB
#define glVertexAttrib3sARB GLMock.VertexAttrib3sARB
#undef glVertexAttrib3svARB
#define glVertexAttrib3svARB GLMock.VertexAttrib3svARB
#undef glVertexAttrib4NbvARB
#define glVertexAttrib4NbvARB GLMock.VertexAttrib4NbvARB
#undef glVertexAttrib4NivARB
#define glVertexAttrib4NivARB GLMock.VertexAttrib4NivARB
#undef glVertexAttrib4NsvARB
#define glVertexAttrib4NsvARB GLMock.VertexAttrib4NsvARB
#undef glVertexAttrib4NubARB
#define glVertexAttrib4NubARB GLMock.VertexAttrib4NubARB
#undef glVertexAttrib4NubvARB
#define glVertexAttrib4NubvARB GLMock.VertexAttrib4NubvARB
#undef glVertexAttrib4NuivARB
#define glVertexAttrib4NuivARB GLMock.VertexAttrib4NuivARB
#undef glVertexAttrib4NusvARB
#define glVertexAttrib4NusvARB GLMock.VertexAttrib4NusvARB
#undef glVertexAttrib4bvARB
#define glVertexAttrib4bvARB GLMock.VertexAttrib4bvARB
#undef glVertexAttrib4dARB
#define glVertexAttrib4dARB GLMock.VertexAttrib4dARB
#undef glVertexAttrib4dvARB
#define glVertexAttrib4dvARB GLMock.VertexAttrib4dvARB
#undef glVertexAttrib4fARB
#define glVertexAttrib4fARB GLMock.VertexAttrib4fARB
#undef glVertexAttrib4fvARB
#define glVertexAttrib4fvARB GLMock.VertexAttrib4fvARB
#undef glVertexAttrib4ivARB
#define glVertexAttrib4ivARB GLMock.VertexAttrib4ivARB
#undef glVertexAttrib4sARB
#define glVertexAttrib4sARB GLMock.VertexAttrib4sARB
#undef glVertexAttrib4svARB
#define glVertexAttrib4svARB GLMock.VertexAttrib4svARB
#undef glVertexAttrib4ubvARB
#define glVertexAttrib4ubvARB GLMock.VertexAttrib4ubvARB
#undef glVertexAttrib4uivARB
#define glVertexAttrib4uivARB GLMock.VertexAttrib4uivARB
#undef glVertexAttrib4usvARB
#define glVertexAttrib4usvARB GLMock.VertexAttrib4usvARB
#undef glVertexAttribPointerARB
#define glVertexAttribPointerARB GLMock.VertexAttribPointerARB
#undef glBindAttribLocationARB
#define glBindAttribLocationARB GLMock.BindAttribLocationARB
#undef glGetActiveAttribARB
#define glGetActiveAttribARB GLMock.GetActiveAttribARB
#undef glGetAttribLocationARB
#define glGetAttribLocationARB GLMock.GetAttribLocationARB
#undef glColorP3ui
#define glColorP3ui GLMock.ColorP3ui
#undef glColorP3uiv
#define glColorP3uiv GLMock.ColorP3uiv
#undef glColorP4ui
#define glColorP4ui GLMock.ColorP4ui
#undef glColorP4uiv
#define glColorP4uiv GLMock.ColorP4uiv
#undef glMultiTexCoordP1ui
#define glMultiTexCoordP1ui GLMock.MultiTexCoordP1ui
#undef glMultiTexCoordP1uiv
#define glMultiTexCoordP1uiv GLMock.MultiTexCoordP1uiv
#undef glMultiTexCoordP2ui
#define glMultiTexCoordP2ui GLMock.MultiTexCoordP2ui
#undef glMultiTexCoordP2uiv
#define glMultiTexCoordP2uiv GLMock.MultiTexCoordP2uiv
#undef glMultiTexCoordP3ui
#define glMultiTexCoordP3ui GLMock.MultiTexCoordP3ui
#undef glMultiTexCoordP3uiv
#define glMultiTexCoordP3uiv GLMock.MultiTexCoordP3uiv
#undef glMultiTexCoordP4ui
#define glMultiTexCoordP4ui GLMock.MultiTexCoordP4ui
#undef glMultiTexCoordP4uiv
#define glMultiTexCoordP4uiv GLMock.MultiTexCoordP4uiv
#undef glNormalP3ui
#define glNormalP3ui GLMock.NormalP3ui
#undef glNormalP3uiv
#define glNormalP3uiv GLMock.NormalP3uiv
#undef glSecondaryColorP3ui
#define glSecondaryColorP3ui GLMock.SecondaryColorP3ui
#undef glSecondaryColorP3uiv
#define glSecondaryColorP3uiv GLMock.SecondaryColorP3uiv
#undef glTexCoordP1ui
#define glTexCoordP1ui GLMock.TexCoordP1ui
#undef glTexCoordP1uiv
#define glTexCoordP1uiv GLMock.TexCoordP1uiv
#undef glTexCoordP2ui
#define glTexCoordP2ui GLMock.TexCoordP2ui
#undef glTexCoordP2uiv
#define glTexCoordP2uiv GLMock.TexCoordP2uiv
#undef glTexCoordP3ui
#define glTexCoordP3ui GLMock.TexCoordP3ui
#undef glTexCoordP3uiv
#define glTexCoordP3uiv GLMock.TexCoordP3uiv
#undef glTexCoordP4ui
#define glTexCoordP4ui GLMock.TexCoordP4ui
#undef glTexCoordP4uiv
#define glTexCoordP4uiv GLMock.TexCoordP4uiv
#undef glVertexAttribP1ui
#define glVertexAttribP1ui GLMock.VertexAttribP1ui
#undef glVertexAttribP1uiv
#define glVertexAttribP1uiv GLMock.VertexAttribP1uiv
#undef glVertexAttribP2ui
#define glVertexAttribP2ui GLMock.VertexAttribP2ui
#undef glVertexAttribP2uiv
#define glVertexAttribP2uiv GLMock.VertexAttribP2uiv
#undef glVertexAttribP3ui
#define glVertexAttribP3ui GLMock.VertexAttribP3ui
#undef glVertexAttribP3uiv
#define glVertexAttribP3uiv GLMock.VertexAttribP3uiv
#undef glVertexAttribP4ui
#define glVertexAttribP4ui GLMock.VertexAttribP4ui
#undef glVertexAttribP4uiv
#define glVertexAttribP4uiv GLMock.VertexAttribP4uiv
#undef glVertexP2ui
#define glVertexP2ui GLMock.VertexP2ui
#undef glVertexP2uiv
#define glVertexP2uiv GLMock.VertexP2uiv
#undef glVertexP3ui
#define glVertexP3ui GLMock.VertexP3ui
#undef glVertexP3uiv
#define glVertexP3uiv GLMock.VertexP3uiv
#undef glVertexP4ui
#define glVertexP4ui GLMock.VertexP4ui
#undef glVertexP4uiv
#define glVertexP4uiv GLMock.VertexP4uiv
#undef glWindowPos2dARB
#define glWindowPos2dARB GLMock.WindowPos2dARB
#undef glWindowPos2dvARB
#define glWindowPos2dvARB GLMock.WindowPos2dvARB
#undef glWindowPos2fARB
#define glWindowPos2fARB GLMock.WindowPos2fARB
#undef glWindowPos2fvARB
#define glWindowPos2fvARB GLMock.WindowPos2fvARB
#undef glWindowPos2iARB
#define glWindowPos2iARB GLMock.WindowPos2iARB
#undef glWindowPos2ivARB
#define glWindowPos2ivARB GLMock.WindowPos2ivARB
#undef glWindowPos2sARB
#define glWindowPos2sARB GLMock.WindowPos2sARB
#undef glWindowPos2svARB
#define glWindowPos2svARB GLMock.WindowPos2svARB
#undef glWindowPos3dARB
#define glWindowPos3dARB GLMock.WindowPos3dARB
#undef glWindowPos3dvARB
#define glWindowPos3dvARB GLMock.WindowPos3dvARB
#undef glWindowPos3fARB
#define glWindowPos3fARB GLMock.WindowPos3fARB
#undef glWindowPos3fvARB
#define glWindowPos3fvARB GLMock.WindowPos3fvARB
#undef glWindowPos3iARB
#define glWindowPos3iARB GLMock.WindowPos3iARB
#undef glWindowPos3ivARB
#define glWindowPos3ivARB GLMock.WindowPos3ivARB
#undef glWindowPos3sARB
#define glWindowPos3sARB GLMock.WindowPos3sARB
#undef glWindowPos3svARB
#define glWindowPos3svARB GLMock.WindowPos3svARB
#undef glDrawBuffersATI
#define glDrawBuffersATI GLMock.DrawBuffersATI
#undef glDrawElementArrayATI
#define glDrawElementArrayATI GLMock.DrawElementArrayATI
#undef glDrawRangeElementArrayATI
#define glDrawRangeElementArrayATI GLMock.DrawRangeElementArrayATI
#undef glElementPointerATI
#define glElementPointerATI GLMock.ElementPointerATI
#undef glGetTexBumpParameterfvATI
#define glGetTexBumpParameterfvATI GLMock.GetTexBumpParameterfvATI
#undef glGetTexBumpParameterivATI
#define glGetTexBumpParameterivATI GLMock.GetTexBumpParameterivATI
#undef glTexBumpParameterfvATI
#define glTexBumpParameterfvATI GLMock.TexBumpParameterfvATI
#undef glTexBumpParameterivATI
#define glTexBumpParameterivATI GLMock.TexBumpParameterivATI
#undef glAlphaFragmentOp1ATI
#define glAlphaFragmentOp1ATI GLMock.AlphaFragmentOp1ATI
#undef glAlphaFragmentOp2ATI
#define glAlphaFragmentOp2ATI GLMock.AlphaFragmentOp2ATI
#undef glAlphaFragmentOp3ATI
#define glAlphaFragmentOp3ATI GLMock.AlphaFragmentOp3ATI
#undef glBeginFragmentShaderATI
#define glBeginFragmentShaderATI GLMock.BeginFragmentShaderATI
#undef glBindFragmentShaderATI
#define glBindFragmentShaderATI GLMock.BindFragmentShaderATI
#undef glColorFragmentOp1ATI
#define glColorFragmentOp1ATI GLMock.ColorFragmentOp1ATI
#undef glColorFragmentOp2ATI
#define glColorFragmentOp2ATI GLMock.ColorFragmentOp2ATI
#undef glColorFragmentOp3ATI
#define glColorFragmentOp3ATI GLMock.ColorFragmentOp3ATI
#undef glDeleteFragmentShaderATI
#define glDeleteFragmentShaderATI GLMock.DeleteFragmentShaderATI
#undef glEndFragmentShaderATI
#define glEndFragmentShaderATI GLMock.EndFragmentShaderATI
#undef glGenFragmentShadersATI
#define glGenFragmentShadersATI GLMock.GenFragmentShadersATI
#undef glPassTexCoordATI
#define glPassTexCoordATI GLMock.PassTexCoordATI
#undef glSampleMapATI
#define glSampleMapATI GLMock.SampleMapATI
#undef glSetFragmentShaderConstantATI
#define glSetFragmentShaderConstantATI GLMock.SetFragmentShaderConstantATI
#undef glMapObjectBufferATI
#define glMapObjectBufferATI GLMock.MapObjectBufferATI
#undef glUnmapObjectBufferATI
#define glUnmapObjectBufferATI GLMock.UnmapObjectBufferATI
#undef glPNTrianglesfATI
#define glPNTrianglesfATI GLMock.PNTrianglesfATI
#undef glPNTrianglesiATI
#define glPNTrianglesiATI GLMock.PNTrianglesiATI
#undef glStencilFuncSeparateATI
#define glStencilFuncSeparateATI GLMock.StencilFuncSeparateATI
#undef glStencilOpSeparateATI
#define glStencilOpSeparateATI GLMock.StencilOpSeparateATI
#undef glArrayObjectATI
#define glArrayObjectATI GLMock.ArrayObjectATI
#undef glFreeObjectBufferATI
#define glFreeObjectBufferATI GLMock.FreeObjectBufferATI
#undef glGetArrayObjectfvATI
#define glGetArrayObjectfvATI GLMock.GetArrayObjectfvATI
#undef glGetArrayObjectivATI
#define glGetArrayObjectivATI GLMock.GetArrayObjectivATI
#undef glGetObjectBufferfvATI
#define glGetObjectBufferfvATI GLMock.GetObjectBufferfvATI
#undef glGetObjectBufferivATI
#define glGetObjectBufferivATI GLMock.GetObjectBufferivATI
#undef glGetVariantArrayObjectfvATI
#define glGetVariantArrayObjectfvATI GLMock.GetVariantArrayObjectfvATI
#undef glGetVariantArrayObjectivATI
#define glGetVariantArrayObjectivATI GLMock.GetVariantArrayObjectivATI
#undef glIsObjectBufferATI
#define glIsObjectBufferATI GLMock.IsObjectBufferATI
#undef glNewObjectBufferATI
#define glNewObjectBufferATI GLMock.NewObjectBufferATI
#undef glUpdateObjectBufferATI
#define glUpdateObjectBufferATI GLMock.UpdateObjectBufferATI
#undef glVariantArrayObjectATI
#define glVariantArrayObjectATI GLMock.VariantArrayObjectATI
#undef glGetVertexAttribArrayObjectfvATI
#define glGetVertexAttribArrayObjectfvATI GLMock.GetVertexAttribArrayObjectfvATI
#undef glGetVertexAttribArrayObjectivATI
#define glGetVertexAttribArrayObjectivATI GLMock.GetVertexAttribArrayObjectivATI
#undef glVertexAttribArrayObjectATI
#define glVertexAttribArrayObjectATI GLMock.VertexAttribArrayObjectATI
#undef glClientActiveVertexStreamATI
#define glClientActiveVertexStreamATI GLMock.ClientActiveVertexStreamATI
#undef glNormalStream3bATI
#define glNormalStream3bATI GLMock.NormalStream3bATI
#undef glNormalStream3bvATI
#define glNormalStream3bvATI GLMock.NormalStream3bvATI
#undef glNormalStream3dATI
#define glNormalStream3dATI GLMock.NormalStream3dATI
#undef glNormalStream3dvATI
#define glNormalStream3dvATI GLMock.NormalStream3dvATI
#undef glNormalStream3fATI
#define glNormalStream3fATI GLMock.NormalStream3fATI
#undef glNormalStream3fvATI
#define glNormalStream3fvATI GLMock.NormalStream3fvATI
#undef glNormalStream3iATI
#define glNormalStream3iATI GLMock.NormalStream3iATI
#undef glNormalStream3ivATI
#define glNormalStream3ivATI GLMock.NormalStream3ivATI
#undef glNormalStream3sATI
#define glNormalStream3sATI GLMock.NormalStream3sATI
#undef glNormalStream3svATI
#define glNormalStream3svATI GLMock.NormalStream3svATI
#undef glVertexBlendEnvfATI
#define glVertexBlendEnvfATI GLMock.VertexBlendEnvfATI
#undef glVertexBlendEnviATI
#define glVertexBlendEnviATI GLMock.VertexBlendEnviATI
#undef glVertexStream2dATI
#define glVertexStream2dATI GLMock.VertexStream2dATI
#undef glVertexStream2dvATI
#define glVertexStream2dvATI GLMock.VertexStream2dvATI
#undef glVertexStream2fATI
#define glVertexStream2fATI GLMock.VertexStream2fATI
#undef glVertexStream2fvATI
#define glVertexStream2fvATI GLMock.VertexStream2fvATI
#undef glVertexStream2iATI
#define glVertexStream2iATI GLMock.VertexStream2iATI
#undef glVertexStream2ivATI
#define glVertexStream2ivATI GLMock.VertexStream2ivATI
#undef glVertexStream2sATI
#define glVertexStream2sATI GLMock.VertexStream2sATI
#undef glVertexStream2svATI
#define glVertexStream2svATI GLMock.VertexStream2svATI
#undef glVertexStream3dATI
#define glVertexStream3dATI GLMock.VertexStream3dATI
#undef glVertexStream3dvATI
#define glVertexStream3dvATI GLMock.VertexStream3dvATI
#undef glVertexStream3fATI
#define glVertexStream3fATI GLMock.VertexStream3fATI
#undef glVertexStream3fvATI
#define glVertexStream3fvATI GLMock.VertexStream3fvATI
#undef glVertexStream3iATI
#define glVertexStream3iATI GLMock.VertexStream3iATI
#undef glVertexStream3ivATI
#define glVertexStream3ivATI GLMock.VertexStream3ivATI
#undef glVertexStream3sATI
#define glVertexStream3sATI GLMock.VertexStream3sATI
#undef glVertexStream3svATI
#define glVertexStream3svATI GLMock.VertexStream3svATI
#undef glVertexStream4dATI
#define glVertexStream4dATI GLMock.VertexStream4dATI
#undef glVertexStream4dvATI
#define glVertexStream4dvATI GLMock.VertexStream4dvATI
#undef glVertexStream4fATI
#define glVertexStream4fATI GLMock.VertexStream4fATI
#undef glVertexStream4fvATI
#define glVertexStream4fvATI GLMock.VertexStream4fvATI
#undef glVertexStream4iATI
#define glVertexStream4iATI GLMock.VertexStream4iATI
#undef glVertexStream4ivATI
#define glVertexStream4ivATI GLMock.VertexStream4ivATI
#undef glVertexStream4sATI
#define glVertexStream4sATI GLMock.VertexStream4sATI
#undef glVertexStream4svATI
#define glVertexStream4svATI GLMock.VertexStream4svATI
#undef glGetUniformBufferSizeEXT
#define glGetUniformBufferSizeEXT GLMock.GetUniformBufferSizeEXT
#undef glGetUniformOffsetEXT
#define glGetUniformOffsetEXT GLMock.GetUniformOffsetEXT
#undef glUniformBufferEXT
#define glUniformBufferEXT GLMock.UniformBufferEXT
#undef glBlendColorEXT
#define glBlendColorEXT GLMock.BlendColorEXT
#undef glBlendEquationSeparateEXT
#define glBlendEquationSeparateEXT GLMock.BlendEquationSeparateEXT
#undef glBlendFuncSeparateEXT
#define glBlendFuncSeparateEXT GLMock.BlendFuncSeparateEXT
#undef glBlendEquationEXT
#define glBlendEquationEXT GLMock.BlendEquationEXT
#undef glColorSubTableEXT
#define glColorSubTableEXT GLMock.ColorSubTableEXT
#undef glCopyColorSubTableEXT
#define glCopyColorSubTableEXT GLMock.CopyColorSubTableEXT
#undef glLockArraysEXT
#define glLockArraysEXT GLMock.LockArraysEXT
#undef glUnlockArraysEXT
#define glUnlockArraysEXT GLMock.UnlockArraysEXT
#undef glConvolutionFilter1DEXT
#define glConvolutionFilter1DEXT GLMock.ConvolutionFilter1DEXT
#undef glConvolutionFilter2DEXT
#define glConvolutionFilter2DEXT GLMock.ConvolutionFilter2DEXT
#undef glConvolutionParameterfEXT
#define glConvolutionParameterfEXT GLMock.ConvolutionParameterfEXT
#undef glConvolutionParameterfvEXT
#define glConvolutionParameterfvEXT GLMock.ConvolutionParameterfvEXT
#undef glConvolutionParameteriEXT
#define glConvolutionParameteriEXT GLMock.ConvolutionParameteriEXT
#undef glConvolutionParameterivEXT
#define glConvolutionParameterivEXT GLMock.ConvolutionParameterivEXT
#undef glCopyConvolutionFilter1DEXT
#define glCopyConvolutionFilter1DEXT GLMock.CopyConvolutionFilter1DEXT
#undef glCopyConvolutionFilter2DEXT
#define glCopyConvolutionFilter2DEXT GLMock.CopyConvolutionFilter2DEXT
#undef glGetConvolutionFilterEXT
#define glGetConvolutionFilterEXT GLMock.GetConvolutionFilterEXT
#undef glGetConvolutionParameterfvEXT
#define glGetConvolutionParameterfvEXT GLMock.GetConvolutionParameterfvEXT
#undef glGetConvolutionParameterivEXT
#define glGetConvolutionParameterivEXT GLMock.GetConvolutionParameterivEXT
#undef glGetSeparableFilterEXT
#define glGetSeparableFilterEXT GLMock.GetSeparableFilterEXT
#undef glSeparableFilter2DEXT
#define glSeparableFilter2DEXT GLMock.SeparableFilter2DEXT
#undef glBinormalPointerEXT
#define glBinormalPointerEXT GLMock.BinormalPointerEXT
#undef glTangentPointerEXT
#define glTangentPointerEXT GLMock.TangentPointerEXT
#undef glCopyTexImage1DEXT
#define glCopyTexImage1DEXT GLMock.CopyTexImage1DEXT
#undef glCopyTexImage2DEXT
#define glCopyTexImage2DEXT GLMock.CopyTexImage2DEXT
#undef glCopyTexSubImage1DEXT
#define glCopyTexSubImage1DEXT GLMock.CopyTexSubImage1DEXT
#undef glCopyTexSubImage2DEXT
#define glCopyTexSubImage2DEXT GLMock.CopyTexSubImage2DEXT
#undef glCopyTexSubImage3DEXT
#define glCopyTexSubImage3DEXT GLMock.CopyTexSubImage3DEXT
#undef glCullParameterdvEXT
#define glCullParameterdvEXT GLMock.CullParameterdvEXT
#undef glCullParameterfvEXT
#define glCullParameterfvEXT GLMock.CullParameterfvEXT
#undef glDepthBoundsEXT
#define glDepthBoundsEXT GLMock.DepthBoundsEXT
#undef glBindMultiTextureEXT
#define glBindMultiTextureEXT GLMock.BindMultiTextureEXT
#undef glCheckNamedFramebufferStatusEXT
#define glCheckNamedFramebufferStatusEXT GLMock.CheckNamedFramebufferStatusEXT
#undef glClientAttribDefaultEXT
#define glClientAttribDefaultEXT GLMock.ClientAttribDefaultEXT
#undef glCompressedMultiTexImage1DEXT
#define glCompressedMultiTexImage1DEXT GLMock.CompressedMultiTexImage1DEXT
#undef glCompressedMultiTexImage2DEXT
#define glCompressedMultiTexImage2DEXT GLMock.CompressedMultiTexImage2DEXT
#undef glCompressedMultiTexImage3DEXT
#define glCompressedMultiTexImage3DEXT GLMock.CompressedMultiTexImage3DEXT
#undef glCompressedMultiTexSubImage1DEXT
#define glCompressedMultiTexSubImage1DEXT GLMock.CompressedMultiTexSubImage1DEXT
#undef glCompressedMultiTexSubImage2DEXT
#define glCompressedMultiTexSubImage2DEXT GLMock.CompressedMultiTexSubImage2DEXT
#undef glCompressedMultiTexSubImage3DEXT
#define glCompressedMultiTexSubImage3DEXT GLMock.CompressedMultiTexSubImage3DEXT
#undef glCompressedTextureImage1DEXT
#define glCompressedTextureImage1DEXT GLMock.CompressedTextureImage1DEXT
#undef glCompressedTextureImage2DEXT
#define glCompressedTextureImage2DEXT GLMock.CompressedTextureImage2DEXT
#undef glCompressedTextureImage3DEXT
#define glCompressedTextureImage3DEXT GLMock.CompressedTextureImage3DEXT
#undef glCompressedTextureSubImage1DEXT
#define glCompressedTextureSubImage1DEXT GLMock.CompressedTextureSubImage1DEXT
#undef glCompressedTextureSubImage2DEXT
#define glCompressedTextureSubImage2DEXT GLMock.CompressedTextureSubImage2DEXT
#undef glCompressedTextureSubImage3DEXT
#define glCompressedTextureSubImage3DEXT GLMock.CompressedTextureSubImage3DEXT
#undef glCopyMultiTexImage1DEXT
#define glCopyMultiTexImage1DEXT GLMock.CopyMultiTexImage1DEXT
#undef glCopyMultiTexImage2DEXT
#define glCopyMultiTexImage2DEXT GLMock.CopyMultiTexImage2DEXT
#undef glCopyMultiTexSubImage1DEXT
#define glCopyMultiTexSubImage1DEXT GLMock.CopyMultiTexSubImage1DEXT
#undef glCopyMultiTexSubImage2DEXT
#define glCopyMultiTexSubImage2DEXT GLMock.CopyMultiTexSubImage2DEXT
#undef glCopyMultiTexSubImage3DEXT
#define glCopyMultiTexSubImage3DEXT GLMock.CopyMultiTexSubImage3DEXT
#undef glCopyTextureImage1DEXT
#define glCopyTextureImage1DEXT GLMock.CopyTextureImage1DEXT
#undef glCopyTextureImage2DEXT
#define glCopyTextureImage2DEXT GLMock.CopyTextureImage2DEXT
#undef glCopyTextureSubImage1DEXT
#define glCopyTextureSubImage1DEXT GLMock.CopyTextureSubImage1DEXT
#undef glCopyTextureSubImage2DEXT
#define glCopyTextureSubImage2DEXT GLMock.CopyTextureSubImage2DEXT
#undef glCopyTextureSubImage3DEXT
#define glCopyTextureSubImage3DEXT GLMock.CopyTextureSubImage3DEXT
#undef glDisableClientStateIndexedEXT
#define glDisableClientStateIndexedEXT GLMock.DisableClientStateIndexedEXT
#undef glDisableClientStateiEXT
#define glDisableClientStateiEXT GLMock.DisableClientStateiEXT
#undef glDisableVertexArrayAttribEXT
#define glDisableVertexArrayAttribEXT GLMock.DisableVertexArrayAttribEXT
#undef glDisableVertexArrayEXT
#define glDisableVertexArrayEXT GLMock.DisableVertexArrayEXT
#undef glEnableClientStateIndexedEXT
#define glEnableClientStateIndexedEXT GLMock.EnableClientStateIndexedEXT
#undef glEnableClientStateiEXT
#define glEnableClientStateiEXT GLMock.EnableClientStateiEXT
#undef glEnableVertexArrayAttribEXT
#define glEnableVertexArrayAttribEXT GLMock.EnableVertexArrayAttribEXT
#undef glEnableVertexArrayEXT
#define glEnableVertexArrayEXT GLMock.EnableVertexArrayEXT
#undef glFlushMappedNamedBufferRangeEXT
#define glFlushMappedNamedBufferRangeEXT GLMock.FlushMappedNamedBufferRangeEXT
#undef glFramebufferDrawBufferEXT
#define glFramebufferDrawBufferEXT GLMock.FramebufferDrawBufferEXT
#undef glFramebufferDrawBuffersEXT
#define glFramebufferDrawBuffersEXT GLMock.FramebufferDrawBuffersEXT
#undef glFramebufferReadBufferEXT
#define glFramebufferReadBufferEXT GLMock.FramebufferReadBufferEXT
#undef glGenerateMultiTexMipmapEXT
#define glGenerateMultiTexMipmapEXT GLMock.GenerateMultiTexMipmapEXT
#undef glGenerateTextureMipmapEXT
#define glGenerateTextureMipmapEXT GLMock.GenerateTextureMipmapEXT
#undef glGetCompressedMultiTexImageEXT
#define glGetCompressedMultiTexImageEXT GLMock.GetCompressedMultiTexImageEXT
#undef glGetCompressedTextureImageEXT
#define glGetCompressedTextureImageEXT GLMock.GetCompressedTextureImageEXT
#undef glGetDoubleIndexedvEXT
#define glGetDoubleIndexedvEXT GLMock.GetDoubleIndexedvEXT
#undef glGetDoublei_vEXT
#define glGetDoublei_vEXT GLMock.GetDoublei_vEXT
#undef glGetFloatIndexedvEXT
#define glGetFloatIndexedvEXT GLMock.GetFloatIndexedvEXT
#undef glGetFloati_vEXT
#define glGetFloati_vEXT GLMock.GetFloati_vEXT
#undef glGetFramebufferParameterivEXT
#define glGetFramebufferParameterivEXT GLMock.GetFramebufferParameterivEXT
#undef glGetMultiTexEnvfvEXT
#define glGetMultiTexEnvfvEXT GLMock.GetMultiTexEnvfvEXT
#undef glGetMultiTexEnvivEXT
#define glGetMultiTexEnvivEXT GLMock.GetMultiTexEnvivEXT
#undef glGetMultiTexGendvEXT
#define glGetMultiTexGendvEXT GLMock.GetMultiTexGendvEXT
#undef glGetMultiTexGenfvEXT
#define glGetMultiTexGenfvEXT GLMock.GetMultiTexGenfvEXT
#undef glGetMultiTexGenivEXT
#define glGetMultiTexGenivEXT GLMock.GetMultiTexGenivEXT
#undef glGetMultiTexImageEXT
#define glGetMultiTexImageEXT GLMock.GetMultiTexImageEXT
#undef glGetMultiTexLevelParameterfvEXT
#define glGetMultiTexLevelParameterfvEXT GLMock.GetMultiTexLevelParameterfvEXT
#undef glGetMultiTexLevelParameterivEXT
#define glGetMultiTexLevelParameterivEXT GLMock.GetMultiTexLevelParameterivEXT
#undef glGetMultiTexParameterIivEXT
#define glGetMultiTexParameterIivEXT GLMock.GetMultiTexParameterIivEXT
#undef glGetMultiTexParameterIuivEXT
#define glGetMultiTexParameterIuivEXT GLMock.GetMultiTexParameterIuivEXT
#undef glGetMultiTexParameterfvEXT
#define glGetMultiTexParameterfvEXT GLMock.GetMultiTexParameterfvEXT
#undef glGetMultiTexParameterivEXT
#define glGetMultiTexParameterivEXT GLMock.GetMultiTexParameterivEXT
#undef glGetNamedBufferParameterivEXT
#define glGetNamedBufferParameterivEXT GLMock.GetNamedBufferParameterivEXT
#undef glGetNamedBufferPointervEXT
#define glGetNamedBufferPointervEXT GLMock.GetNamedBufferPointervEXT
#undef glGetNamedBufferSubDataEXT
#define glGetNamedBufferSubDataEXT GLMock.GetNamedBufferSubDataEXT
#undef glGetNamedFramebufferAttachmentParameterivEXT
#define glGetNamedFramebufferAttachmentParameterivEXT GLMock.GetNamedFramebufferAttachmentParameterivEXT
#undef glGetNamedProgramLocalParameterIivEXT
#define glGetNamedProgramLocalParameterIivEXT GLMock.GetNamedProgramLocalParameterIivEXT
#undef glGetNamedProgramLocalParameterIuivEXT
#define glGetNamedProgramLocalParameterIuivEXT GLMock.GetNamedProgramLocalParameterIuivEXT
#undef glGetNamedProgramLocalParameterdvEXT
#define glGetNamedProgramLocalParameterdvEXT GLMock.GetNamedProgramLocalParameterdvEXT
#undef glGetNamedProgramLocalParameterfvEXT
#define glGetNamedProgramLocalParameterfvEXT GLMock.GetNamedProgramLocalParameterfvEXT
#undef glGetNamedProgramStringEXT
#define glGetNamedProgramStringEXT GLMock.GetNamedProgramStringEXT
#undef glGetNamedProgramivEXT
#define glGetNamedProgramivEXT GLMock.GetNamedProgramivEXT
#undef glGetNamedRenderbufferParameterivEXT
#define glGetNamedRenderbufferParameterivEXT GLMock.GetNamedRenderbufferParameterivEXT
#undef glGetPointerIndexedvEXT
#define glGetPointerIndexedvEXT GLMock.GetPointerIndexedvEXT
#undef glGetPointeri_vEXT
#define glGetPointeri_vEXT GLMock.GetPointeri_vEXT
#undef glGetTextureImageEXT
#define glGetTextureImageEXT GLMock.GetTextureImageEXT
#undef glGetTextureLevelParameterfvEXT
#define glGetTextureLevelParameterfvEXT GLMock.GetTextureLevelParameterfvEXT
#undef glGetTextureLevelParameterivEXT
#define glGetTextureLevelParameterivEXT GLMock.GetTextureLevelParameterivEXT
#undef glGetTextureParameterIivEXT
#define glGetTextureParameterIivEXT GLMock.GetTextureParameterIivEXT
#undef glGetTextureParameterIuivEXT
#define glGetTextureParameterIuivEXT GLMock.GetTextureParameterIuivEXT
#undef glGetTextureParameterfvEXT
#define glGetTextureParameterfvEXT GLMock.GetTextureParameterfvEXT
#undef glGetTextureParameterivEXT
#define glGetTextureParameterivEXT GLMock.GetTextureParameterivEXT
#undef glGetVertexArrayIntegeri_vEXT
#define glGetVertexArrayIntegeri_vEXT GLMock.GetVertexArrayIntegeri_vEXT
#undef glGetVertexArrayIntegervEXT
#define glGetVertexArrayIntegervEXT GLMock.GetVertexArrayIntegervEXT
#undef glGetVertexArrayPointeri_vEXT
#define glGetVertexArrayPointeri_vEXT GLMock.GetVertexArrayPointeri_vEXT
#undef glGetVertexArrayPointervEXT
#define glGetVertexArrayPointervEXT GLMock.GetVertexArrayPointervEXT
#undef glMapNamedBufferEXT
#define glMapNamedBufferEXT GLMock.MapNamedBufferEXT
#undef glMapNamedBufferRangeEXT
#define glMapNamedBufferRangeEXT GLMock.MapNamedBufferRangeEXT
#undef glMatrixFrustumEXT
#define glMatrixFrustumEXT GLMock.MatrixFrustumEXT
#undef glMatrixLoadIdentityEXT
#define glMatrixLoadIdentityEXT GLMock.MatrixLoadIdentityEXT
#undef glMatrixLoadTransposedEXT
#define glMatrixLoadTransposedEXT GLMock.MatrixLoadTransposedEXT
#undef glMatrixLoadTransposefEXT
#define glMatrixLoadTransposefEXT GLMock.MatrixLoadTransposefEXT
#undef glMatrixLoaddEXT
#define glMatrixLoaddEXT GLMock.MatrixLoaddEXT
#undef glMatrixLoadfEXT
#define glMatrixLoadfEXT GLMock.MatrixLoadfEXT
#undef glMatrixMultTransposedEXT
#define glMatrixMultTransposedEXT GLMock.MatrixMultTransposedEXT
#undef glMatrixMultTransposefEXT
#define glMatrixMultTransposefEXT GLMock.MatrixMultTransposefEXT
#undef glMatrixMultdEXT
#define glMatrixMultdEXT GLMock.MatrixMultdEXT
#undef glMatrixMultfEXT
#define glMatrixMultfEXT GLMock.MatrixMultfEXT
#undef glMatrixOrthoEXT
#define glMatrixOrthoEXT GLMock.MatrixOrthoEXT
#undef glMatrixPopEXT
#define glMatrixPopEXT GLMock.MatrixPopEXT
#undef glMatrixPushEXT
#define glMatrixPushEXT GLMock.MatrixPushEXT
#undef glMatrixRotatedEXT
#define glMatrixRotatedEXT GLMock.MatrixRotatedEXT
#undef glMatrixRotatefEXT
#define glMatrixRotatefEXT GLMock.MatrixRotatefEXT
#undef glMatrixScaledEXT
#define glMatrixScaledEXT GLMock.MatrixScaledEXT
#undef glMatrixScalefEXT
#define glMatrixScalefEXT GLMock.MatrixScalefEXT
#undef glMatrixTranslatedEXT
#define glMatrixTranslatedEXT GLMock.MatrixTranslatedEXT
#undef glMatrixTranslatefEXT
#define glMatrixTranslatefEXT GLMock.MatrixTranslatefEXT
#undef glMultiTexBufferEXT
#define glMultiTexBufferEXT GLMock.MultiTexBufferEXT
#undef glMultiTexCoordPointerEXT
#define glMultiTexCoordPointerEXT GLMock.MultiTexCoordPointerEXT
#undef glMultiTexEnvfEXT
#define glMultiTexEnvfEXT GLMock.MultiTexEnvfEXT
#undef glMultiTexEnvfvEXT
#define glMultiTexEnvfvEXT GLMock.MultiTexEnvfvEXT
#undef glMultiTexEnviEXT
#define glMultiTexEnviEXT GLMock.MultiTexEnviEXT
#undef glMultiTexEnvivEXT
#define glMultiTexEnvivEXT GLMock.MultiTexEnvivEXT
#undef glMultiTexGendEXT
#define glMultiTexGendEXT GLMock.MultiTexGendEXT
#undef glMultiTexGendvEXT
#define glMultiTexGendvEXT GLMock.MultiTexGendvEXT
#undef glMultiTexGenfEXT
#define glMultiTexGenfEXT GLMock.MultiTexGenfEXT
#undef glMultiTexGenfvEXT
#define glMultiTexGenfvEXT GLMock.MultiTexGenfvEXT
#undef glMultiTexGeniEXT
#define glMultiTexGeniEXT GLMock.MultiTexGeniEXT
#undef glMultiTexGenivEXT
#define glMultiTexGenivEXT GLMock.MultiTexGenivEXT
#undef glMultiTexImage1DEXT
#define glMultiTexImage1DEXT GLMock.MultiTexImage1DEXT
#undef glMultiTexImage2DEXT
#define glMultiTexImage2DEXT GLMock.MultiTexImage2DEXT
#undef glMultiTexImage3DEXT
#define glMultiTexImage3DEXT GLMock.MultiTexImage3DEXT
#undef glMultiTexParameterIivEXT
#define glMultiTexParameterIivEXT GLMock.MultiTexParameterIivEXT
#undef glMultiTexParameterIuivEXT
#define glMultiTexParameterIuivEXT GLMock.MultiTexParameterIuivEXT
#undef glMultiTexParameterfEXT
#define glMultiTexParameterfEXT GLMock.MultiTexParameterfEXT
#undef glMultiTexParameterfvEXT
#define glMultiTexParameterfvEXT GLMock.MultiTexParameterfvEXT
#undef glMultiTexParameteriEXT
#define glMultiTexParameteriEXT GLMock.MultiTexParameteriEXT
#undef glMultiTexParameterivEXT
#define glMultiTexParameterivEXT GLMock.MultiTexParameterivEXT
#undef glMultiTexRenderbufferEXT
#define glMultiTexRenderbufferEXT GLMock.MultiTexRenderbufferEXT
#undef glMultiTexSubImage1DEXT
#define glMultiTexSubImage1DEXT GLMock.MultiTexSubImage1DEXT
#undef glMultiTexSubImage2DEXT
#define glMultiTexSubImage2DEXT GLMock.MultiTexSubImage2DEXT
#undef glMultiTexSubImage3DEXT
#define glMultiTexSubImage3DEXT GLMock.MultiTexSubImage3DEXT
#undef glNamedBufferDataEXT
#define glNamedBufferDataEXT GLMock.NamedBufferDataEXT
#undef glNamedBufferSubDataEXT
#define glNamedBufferSubDataEXT GLMock.NamedBufferSubDataEXT
#undef glNamedCopyBufferSubDataEXT
#define glNamedCopyBufferSubDataEXT GLMock.NamedCopyBufferSubDataEXT
#undef glNamedFramebufferRenderbufferEXT
#define glNamedFramebufferRenderbufferEXT GLMock.NamedFramebufferRenderbufferEXT
#undef glNamedFramebufferTexture1DEXT
#define glNamedFramebufferTexture1DEXT GLMock.NamedFramebufferTexture1DEXT
#undef glNamedFramebufferTexture2DEXT
#define glNamedFramebufferTexture2DEXT GLMock.NamedFramebufferTexture2DEXT
#undef glNamedFramebufferTexture3DEXT
#define glNamedFramebufferTexture3DEXT GLMock.NamedFramebufferTexture3DEXT
#undef glNamedFramebufferTextureEXT
#define glNamedFramebufferTextureEXT GLMock.NamedFramebufferTextureEXT
#undef glNamedFramebufferTextureFaceEXT
#define glNamedFramebufferTextureFaceEXT GLMock.NamedFramebufferTextureFaceEXT
#undef glNamedFramebufferTextureLayerEXT
#define glNamedFramebufferTextureLayerEXT GLMock.NamedFramebufferTextureLayerEXT
#undef glNamedProgramLocalParameter4dEXT
#define glNamedProgramLocalParameter4dEXT GLMock.NamedProgramLocalParameter4dEXT
#undef glNamedProgramLocalParameter4dvEXT
#define glNamedProgramLocalParameter4dvEXT GLMock.NamedProgramLocalParameter4dvEXT
#undef glNamedProgramLocalParameter4fEXT
#define glNamedProgramLocalParameter4fEXT GLMock.NamedProgramLocalParameter4fEXT
#undef glNamedProgramLocalParameter4fvEXT
#define glNamedProgramLocalParameter4fvEXT GLMock.NamedProgramLocalParameter4fvEXT
#undef glNamedProgramLocalParameterI4iEXT
#define glNamedProgramLocalParameterI4iEXT GLMock.NamedProgramLocalParameterI4iEXT
#undef glNamedProgramLocalParameterI4ivEXT
#define glNamedProgramLocalParameterI4ivEXT GLMock.NamedProgramLocalParameterI4ivEXT
#undef glNamedProgramLocalParameterI4uiEXT
#define glNamedProgramLocalParameterI4uiEXT GLMock.NamedProgramLocalParameterI4uiEXT
#undef glNamedProgramLocalParameterI4uivEXT
#define glNamedProgramLocalParameterI4uivEXT GLMock.NamedProgramLocalParameterI4uivEXT
#undef glNamedProgramLocalParameters4fvEXT
#define glNamedProgramLocalParameters4fvEXT GLMock.NamedProgramLocalParameters4fvEXT
#undef glNamedProgramLocalParametersI4ivEXT
#define glNamedProgramLocalParametersI4ivEXT GLMock.NamedProgramLocalParametersI4ivEXT
#undef glNamedProgramLocalParametersI4uivEXT
#define glNamedProgramLocalParametersI4uivEXT GLMock.NamedProgramLocalParametersI4uivEXT
#undef glNamedProgramStringEXT
#define glNamedProgramStringEXT GLMock.NamedProgramStringEXT
#undef glNamedRenderbufferStorageEXT
#define glNamedRenderbufferStorageEXT GLMock.NamedRenderbufferStorageEXT
#undef glNamedRenderbufferStorageMultisampleCoverageEXT
#define glNamedRenderbufferStorageMultisampleCoverageEXT GLMock.NamedRenderbufferStorageMultisampleCoverageEXT
#undef glNamedRenderbufferStorageMultisampleEXT
#define glNamedRenderbufferStorageMultisampleEXT GLMock.NamedRenderbufferStorageMultisampleEXT
#undef glProgramUniform1fEXT
#define glProgramUniform1fEXT GLMock.ProgramUniform1fEXT
#undef glProgramUniform1fvEXT
#define glProgramUniform1fvEXT GLMock.ProgramUniform1fvEXT
#undef glProgramUniform1iEXT
#define glProgramUniform1iEXT GLMock.ProgramUniform1iEXT
#undef glProgramUniform1ivEXT
#define glProgramUniform1ivEXT GLMock.ProgramUniform1ivEXT
#undef glProgramUniform1uiEXT
#define glProgramUniform1uiEXT GLMock.ProgramUniform1uiEXT
#undef glProgramUniform1uivEXT
#define glProgramUniform1uivEXT GLMock.ProgramUniform1uivEXT
#undef glProgramUniform2fEXT
#define glProgramUniform2fEXT GLMock.ProgramUniform2fEXT
#undef glProgramUniform2fvEXT
#define glProgramUniform2fvEXT GLMock.ProgramUniform2fvEXT
#undef glProgramUniform2iEXT
#define glProgramUniform2iEXT GLMock.ProgramUniform2iEXT
#undef glProgramUniform2ivEXT
#define glProgramUniform2ivEXT GLMock.ProgramUniform2ivEXT
#undef glProgramUniform2uiEXT
#define glProgramUniform2uiEXT GLMock.ProgramUniform2uiEXT
#undef glProgramUniform2uivEXT
#define glProgramUniform2uivEXT GLMock.ProgramUniform2uivEXT
#undef glProgramUniform3fEXT
#define glProgramUniform3fEXT GLMock.ProgramUniform3fEXT
#undef glProgramUniform3fvEXT
#define glProgramUniform3fvEXT GLMock.ProgramUniform3fvEXT
#undef glProgramUniform3iEXT
#define glProgramUniform3iEXT GLMock.ProgramUniform3iEXT
#undef glProgramUniform3ivEXT
#define glProgramUniform3ivEXT GLMock.ProgramUniform3ivEXT
#undef glProgramUniform3uiEXT
#define glProgramUniform3uiEXT GLMock.ProgramUniform3uiEXT
#undef glProgramUniform3uivEXT
#define glProgramUniform3uivEXT GLMock.ProgramUniform3uivEXT
#undef glProgramUniform4fEXT
#define glProgramUniform4fEXT GLMock.ProgramUniform4fEXT
#undef glProgramUniform4fvEXT
#define glProgramUniform4fvEXT GLMock.ProgramUniform4fvEXT
#undef glProgramUniform4iEXT
#define glProgramUniform4iEXT GLMock.ProgramUniform4iEXT
#undef glProgramUniform4ivEXT
#define glProgramUniform4ivEXT GLMock.ProgramUniform4ivEXT
#undef glProgramUniform4uiEXT
#define glProgramUniform4uiEXT GLMock.ProgramUniform4uiEXT
#undef glProgramUniform4uivEXT
#define glProgramUniform4uivEXT GLMock.ProgramUniform4uivEXT
#undef glProgramUniformMatrix2fvEXT
#define glProgramUniformMatrix2fvEXT GLMock.ProgramUniformMatrix2fvEXT
#undef glProgramUniformMatrix2x3fvEXT
#define glProgramUniformMatrix2x3fvEXT GLMock.ProgramUniformMatrix2x3fvEXT
#undef glProgramUniformMatrix2x4fvEXT
#define glProgramUniformMatrix2x4fvEXT GLMock.ProgramUniformMatrix2x4fvEXT
#undef glProgramUniformMatrix3fvEXT
#define glProgramUniformMatrix3fvEXT GLMock.ProgramUniformMatrix3fvEXT
#undef glProgramUniformMatrix3x2fvEXT
#define glProgramUniformMatrix3x2fvEXT GLMock.ProgramUniformMatrix3x2fvEXT
#undef glProgramUniformMatrix3x4fvEXT
#define glProgramUniformMatrix3x4fvEXT GLMock.ProgramUniformMatrix3x4fvEXT
#undef glProgramUniformMatrix4fvEXT
#define glProgramUniformMatrix4fvEXT GLMock.ProgramUniformMatrix4fvEXT
#undef glProgramUniformMatrix4x2fvEXT
#define glProgramUniformMatrix4x2fvEXT GLMock.ProgramUniformMatrix4x2fvEXT
#undef glProgramUniformMatrix4x3fvEXT
#define glProgramUniformMatrix4x3fvEXT GLMock.ProgramUniformMatrix4x3fvEXT
#undef glPushClientAttribDefaultEXT
#define glPushClientAttribDefaultEXT GLMock.PushClientAttribDefaultEXT
#undef glTextureBufferEXT
#define glTextureBufferEXT GLMock.TextureBufferEXT
#undef glTextureImage1DEXT
#define glTextureImage1DEXT GLMock.TextureImage1DEXT
#undef glTextureImage2DEXT
#define glTextureImage2DEXT GLMock.TextureImage2DEXT
#undef glTextureImage3DEXT
#define glTextureImage3DEXT GLMock.TextureImage3DEXT
#undef glTextureParameterIivEXT
#define glTextureParameterIivEXT GLMock.TextureParameterIivEXT
#undef glTextureParameterIuivEXT
#define glTextureParameterIuivEXT GLMock.TextureParameterIuivEXT
#undef glTextureParameterfEXT
#define glTextureParameterfEXT GLMock.TextureParameterfEXT
#undef glTextureParameterfvEXT
#define glTextureParameterfvEXT GLMock.TextureParameterfvEXT
#undef glTextureParameteriEXT
#define glTextureParameteriEXT GLMock.TextureParameteriEXT
#undef glTextureParameterivEXT
#define glTextureParameterivEXT GLMock.TextureParameterivEXT
#undef glTextureRenderbufferEXT
#define glTextureRenderbufferEXT GLMock.TextureRenderbufferEXT
#undef glTextureSubImage1DEXT
#define glTextureSubImage1DEXT GLMock.TextureSubImage1DEXT
#undef glTextureSubImage2DEXT
#define glTextureSubImage2DEXT GLMock.TextureSubImage2DEXT
#undef glTextureSubImage3DEXT
#define glTextureSubImage3DEXT GLMock.TextureSubImage3DEXT
#undef glUnmapNamedBufferEXT
#define glUnmapNamedBufferEXT GLMock.UnmapNamedBufferEXT
#undef glVertexArrayColorOffsetEXT
#define glVertexArrayColorOffsetEXT GLMock.VertexArrayColorOffsetEXT
#undef glVertexArrayEdgeFlagOffsetEXT
#define glVertexArrayEdgeFlagOffsetEXT GLMock.VertexArrayEdgeFlagOffsetEXT
#undef glVertexArrayFogCoordOffsetEXT
#define glVertexArrayFogCoordOffsetEXT GLMock.VertexArrayFogCoordOffsetEXT
#undef glVertexArrayIndexOffsetEXT
#define glVertexArrayIndexOffsetEXT GLMock.VertexArrayIndexOffsetEXT
#undef glVertexArrayMultiTexCoordOffsetEXT
#define glVertexArrayMultiTexCoordOffsetEXT GLMock.VertexArrayMultiTexCoordOffsetEXT
#undef glVertexArrayNormalOffsetEXT
#define glVertexArrayNormalOffsetEXT GLMock.VertexArrayNormalOffsetEXT
#undef glVertexArraySecondaryColorOffsetEXT
#define glVertexArraySecondaryColorOffsetEXT GLMock.VertexArraySecondaryColorOffsetEXT
#undef glVertexArrayTexCoordOffsetEXT
#define glVertexArrayTexCoordOffsetEXT GLMock.VertexArrayTexCoordOffsetEXT
#undef glVertexArrayVertexAttribIOffsetEXT
#define glVertexArrayVertexAttribIOffsetEXT GLMock.VertexArrayVertexAttribIOffsetEXT
#undef glVertexArrayVertexAttribOffsetEXT
#define glVertexArrayVertexAttribOffsetEXT GLMock.VertexArrayVertexAttribOffsetEXT
#undef glVertexArrayVertexOffsetEXT
#define glVertexArrayVertexOffsetEXT GLMock.VertexArrayVertexOffsetEXT
#undef glColorMaskIndexedEXT
#define glColorMaskIndexedEXT GLMock.ColorMaskIndexedEXT
#undef glDisableIndexedEXT
#define glDisableIndexedEXT GLMock.DisableIndexedEXT
#undef glEnableIndexedEXT
#define glEnableIndexedEXT GLMock.EnableIndexedEXT
#undef glGetBooleanIndexedvEXT
#define glGetBooleanIndexedvEXT GLMock.GetBooleanIndexedvEXT
#undef glGetIntegerIndexedvEXT
#define glGetIntegerIndexedvEXT GLMock.GetIntegerIndexedvEXT
#undef glIsEnabledIndexedEXT
#define glIsEnabledIndexedEXT GLMock.IsEnabledIndexedEXT
#undef glDrawArraysInstancedEXT
#define glDrawArraysInstancedEXT GLMock.DrawArraysInstancedEXT
#undef glDrawElementsInstancedEXT
#define glDrawElementsInstancedEXT GLMock.DrawElementsInstancedEXT
#undef glDrawRangeElementsEXT
#define glDrawRangeElementsEXT GLMock.DrawRangeElementsEXT
#undef glFogCoordPointerEXT
#define glFogCoordPointerEXT GLMock.FogCoordPointerEXT
#undef glFogCoorddEXT
#define glFogCoorddEXT GLMock.FogCoorddEXT
#undef glFogCoorddvEXT
#define glFogCoorddvEXT GLMock.FogCoorddvEXT
#undef glFogCoordfEXT
#define glFogCoordfEXT GLMock.FogCoordfEXT
#undef glFogCoordfvEXT
#define glFogCoordfvEXT GLMock.FogCoordfvEXT
#undef glFragmentColorMaterialEXT
#define glFragmentColorMaterialEXT GLMock.FragmentColorMaterialEXT
#undef glFragmentLightModelfEXT
#define glFragmentLightModelfEXT GLMock.FragmentLightModelfEXT
#undef glFragmentLightModelfvEXT
#define glFragmentLightModelfvEXT GLMock.FragmentLightModelfvEXT
#undef glFragmentLightModeliEXT
#define glFragmentLightModeliEXT GLMock.FragmentLightModeliEXT
#undef glFragmentLightModelivEXT
#define glFragmentLightModelivEXT GLMock.FragmentLightModelivEXT
#undef glFragmentLightfEXT
#define glFragmentLightfEXT GLMock.FragmentLightfEXT
#undef glFragmentLightfvEXT
#define glFragmentLightfvEXT GLMock.FragmentLightfvEXT
#undef glFragmentLightiEXT
#define glFragmentLightiEXT GLMock.FragmentLightiEXT
#undef glFragmentLightivEXT
#define glFragmentLightivEXT GLMock.FragmentLightivEXT
#undef glFragmentMaterialfEXT
#define glFragmentMaterialfEXT GLMock.FragmentMaterialfEXT
#undef glFragmentMaterialfvEXT
#define glFragmentMaterialfvEXT GLMock.FragmentMaterialfvEXT
#undef glFragmentMaterialiEXT
#define glFragmentMaterialiEXT GLMock.FragmentMaterialiEXT
#undef glFragmentMaterialivEXT
#define glFragmentMaterialivEXT GLMock.FragmentMaterialivEXT
#undef glGetFragmentLightfvEXT
#define glGetFragmentLightfvEXT GLMock.GetFragmentLightfvEXT
#undef glGetFragmentLightivEXT
#define glGetFragmentLightivEXT GLMock.GetFragmentLightivEXT
#undef glGetFragmentMaterialfvEXT
#define glGetFragmentMaterialfvEXT GLMock.GetFragmentMaterialfvEXT
#undef glGetFragmentMaterialivEXT
#define glGetFragmentMaterialivEXT GLMock.GetFragmentMaterialivEXT
#undef glLightEnviEXT
#define glLightEnviEXT GLMock.LightEnviEXT
#undef glBlitFramebufferEXT
#define glBlitFramebufferEXT GLMock.BlitFramebufferEXT
#undef glRenderbufferStorageMultisampleEXT
#define glRenderbufferStorageMultisampleEXT GLMock.RenderbufferStorageMultisampleEXT
#undef glBindFramebufferEXT
#define glBindFramebufferEXT GLMock.BindFramebufferEXT
#undef glBindRenderbufferEXT
#define glBindRenderbufferEXT GLMock.BindRenderbufferEXT
#undef glCheckFramebufferStatusEXT
#define glCheckFramebufferStatusEXT GLMock.CheckFramebufferStatusEXT
#undef glDeleteFramebuffersEXT
#define glDeleteFramebuffersEXT GLMock.DeleteFramebuffersEXT
#undef glDeleteRenderbuffersEXT
#define glDeleteRenderbuffersEXT GLMock.DeleteRenderbuffersEXT
#undef glFramebufferRenderbufferEXT
#define glFramebufferRenderbufferEXT GLMock.FramebufferRenderbufferEXT
#undef glFramebufferTexture1DEXT
#define glFramebufferTexture1DEXT GLMock.FramebufferTexture1DEXT
#undef glFramebufferTexture2DEXT
#define glFramebufferTexture2DEXT GLMock.FramebufferTexture2DEXT
#undef glFramebufferTexture3DEXT
#define glFramebufferTexture3DEXT GLMock.FramebufferTexture3DEXT
#undef glGenFramebuffersEXT
#define glGenFramebuffersEXT GLMock.GenFramebuffersEXT
#undef glGenRenderbuffersEXT
#define glGenRenderbuffersEXT GLMock.GenRenderbuffersEXT
#undef glGenerateMipmapEXT
#define glGenerateMipmapEXT GLMock.GenerateMipmapEXT
#undef glGetFramebufferAttachmentParameterivEXT
#define glGetFramebufferAttachmentParameterivEXT GLMock.GetFramebufferAttachmentParameterivEXT
#undef glGetRenderbufferParameterivEXT
#define glGetRenderbufferParameterivEXT GLMock.GetRenderbufferParameterivEXT
#undef glIsFramebufferEXT
#define glIsFramebufferEXT GLMock.IsFramebufferEXT
#undef glIsRenderbufferEXT
#define glIsRenderbufferEXT GLMock.IsRenderbufferEXT
#undef glRenderbufferStorageEXT
#define glRenderbufferStorageEXT GLMock.RenderbufferStorageEXT
#undef glFramebufferTextureEXT
#define glFramebufferTextureEXT GLMock.FramebufferTextureEXT
#undef glFramebufferTextureFaceEXT
#define glFramebufferTextureFaceEXT GLMock.FramebufferTextureFaceEXT
#undef glFramebufferTextureLayerEXT
#define glFramebufferTextureLayerEXT GLMock.FramebufferTextureLayerEXT
#undef glProgramParameteriEXT
#define glProgramParameteriEXT GLMock.ProgramParameteriEXT
#undef glProgramEnvParameters4fvEXT
#define glProgramEnvParameters4fvEXT GLMock.ProgramEnvParameters4fvEXT
#undef glProgramLocalParameters4fvEXT
#define glProgramLocalParameters4fvEXT GLMock.ProgramLocalParameters4fvEXT
#undef glBindFragDataLocationEXT
#define glBindFragDataLocationEXT GLMock.BindFragDataLocationEXT
#undef glGetFragDataLocationEXT
#define glGetFragDataLocationEXT GLMock.GetFragDataLocationEXT
#undef glGetUniformuivEXT
#define glGetUniformuivEXT GLMock.GetUniformuivEXT
#undef glGetVertexAttribIivEXT
#define glGetVertexAttribIivEXT GLMock.GetVertexAttribIivEXT
#undef glGetVertexAttribIuivEXT
#define glGetVertexAttribIuivEXT GLMock.GetVertexAttribIuivEXT
#undef glUniform1uiEXT
#define glUniform1uiEXT GLMock.Uniform1uiEXT
#undef glUniform1uivEXT
#define glUniform1uivEXT GLMock.Uniform1uivEXT
#undef glUniform2uiEXT
#define glUniform2uiEXT GLMock.Uniform2uiEXT
#undef glUniform2uivEXT
#define glUniform2uivEXT GLMock.Uniform2uivEXT
#undef glUniform3uiEXT
#define glUniform3uiEXT GLMock.Uniform3uiEXT
#undef glUniform3uivEXT
#define glUniform3uivEXT GLMock.Uniform3uivEXT
#undef glUniform4uiEXT
#define glUniform4uiEXT GLMock.Uniform4uiEXT
#undef glUniform4uivEXT
#define glUniform4uivEXT GLMock.Uniform4uivEXT
#undef glVertexAttribI1iEXT
#define glVertexAttribI1iEXT GLMock.VertexAttribI1iEXT
#undef glVertexAttribI1ivEXT
#define glVertexAttribI1ivEXT GLMock.VertexAttribI1ivEXT
#undef glVertexAttribI1uiEXT
#define glVertexAttribI1uiEXT GLMock.VertexAttribI1uiEXT
#undef glVertexAttribI1uivEXT
#define glVertexAttribI1uivEXT GLMock.VertexAttribI1uivEXT
#undef glVertexAttribI2iEXT
#define glVertexAttribI2iEXT GLMock.VertexAttribI2iEXT
#undef glVertexAttribI2ivEXT
#define glVertexAttribI2ivEXT GLMock.VertexAttribI2ivEXT
#undef glVertexAttribI2uiEXT
#define glVertexAttribI2uiEXT GLMock.VertexAttribI2uiEXT
#undef glVertexAttribI2uivEXT
#define glVertexAttribI2uivEXT GLMock.VertexAttribI2uivEXT
#undef glVertexAttribI3iEXT
#define glVertexAttribI3iEXT GLMock.VertexAttribI3iEXT
#undef glVertexAttribI3ivEXT
#define glVertexAttribI3ivEXT GLMock.VertexAttribI3ivEXT
#undef glVertexAttribI3uiEXT
#define glVertexAttribI3uiEXT GLMock.VertexAttribI3uiEXT
#undef glVertexAttribI3uivEXT
#define glVertexAttribI3uivEXT GLMock.VertexAttribI3uivEXT
#undef glVertexAttribI4bvEXT
#define glVertexAttribI4bvEXT GLMock.VertexAttribI4bvEXT
#undef glVertexAttribI4iEXT
#define glVertexAttribI4iEXT GLMock.VertexAttribI4iEXT
#undef glVertexAttribI4ivEXT
#define glVertexAttribI4ivEXT GLMock.VertexAttribI4ivEXT
#undef glVertexAttribI4svEXT
#define glVertexAttribI4svEXT GLMock.VertexAttribI4svEXT
#undef glVertexAttribI4ubvEXT
#define glVertexAttribI4ubvEXT GLMock.VertexAttribI4ubvEXT
#undef glVertexAttribI4uiEXT
#define glVertexAttribI4uiEXT GLMock.VertexAttribI4uiEXT
#undef glVertexAttribI4uivEXT
#define glVertexAttribI4uivEXT GLMock.VertexAttribI4uivEXT
#undef glVertexAttribI4usvEXT
#define glVertexAttribI4usvEXT GLMock.VertexAttribI4usvEXT
#undef glVertexAttribIPointerEXT
#define glVertexAttribIPointerEXT GLMock.VertexAttribIPointerEXT
#undef glGetHistogramEXT
#define glGetHistogramEXT GLMock.GetHistogramEXT
#undef glGetHistogramParameterfvEXT
#define glGetHistogramParameterfvEXT GLMock.GetHistogramParameterfvEXT
#undef glGetHistogramParameterivEXT
#define glGetHistogramParameterivEXT GLMock.GetHistogramParameterivEXT
#undef glGetMinmaxEXT
#define glGetMinmaxEXT GLMock.GetMinmaxEXT
#undef glGetMinmaxParameterfvEXT
#define glGetMinmaxParameterfvEXT GLMock.GetMinmaxParameterfvEXT
#undef glGetMinmaxParameterivEXT
#define glGetMinmaxParameterivEXT GLMock.GetMinmaxParameterivEXT
#undef glHistogramEXT
#define glHistogramEXT GLMock.HistogramEXT
#undef glMinmaxEXT
#define glMinmaxEXT GLMock.MinmaxEXT
#undef glResetHistogramEXT
#define glResetHistogramEXT GLMock.ResetHistogramEXT
#undef glResetMinmaxEXT
#define glResetMinmaxEXT GLMock.ResetMinmaxEXT
#undef glIndexFuncEXT
#define glIndexFuncEXT GLMock.IndexFuncEXT
#undef glIndexMaterialEXT
#define glIndexMaterialEXT GLMock.IndexMaterialEXT
#undef glApplyTextureEXT
#define glApplyTextureEXT GLMock.ApplyTextureEXT
#undef glTextureLightEXT
#define glTextureLightEXT GLMock.TextureLightEXT
#undef glTextureMaterialEXT
#define glTextureMaterialEXT GLMock.TextureMaterialEXT
#undef glMultiDrawArraysEXT
#define glMultiDrawArraysEXT GLMock.MultiDrawArraysEXT
#undef glMultiDrawElementsEXT
#define glMultiDrawElementsEXT GLMock.MultiDrawElementsEXT
#undef glSampleMaskEXT
#define glSampleMaskEXT GLMock.SampleMaskEXT
#undef glSamplePatternEXT
#define glSamplePatternEXT GLMock.SamplePatternEXT
#undef glColorTableEXT
#define glColorTableEXT GLMock.ColorTableEXT
#undef glGetColorTableEXT
#define glGetColorTableEXT GLMock.GetColorTableEXT
#undef glGetColorTableParameterfvEXT
#define glGetColorTableParameterfvEXT GLMock.GetColorTableParameterfvEXT
#undef glGetColorTableParameterivEXT
#define glGetColorTableParameterivEXT GLMock.GetColorTableParameterivEXT
#undef glGetPixelTransformParameterfvEXT
#define glGetPixelTransformParameterfvEXT GLMock.GetPixelTransformParameterfvEXT
#undef glGetPixelTransformParameterivEXT
#define glGetPixelTransformParameterivEXT GLMock.GetPixelTransformParameterivEXT
#undef glPixelTransformParameterfEXT
#define glPixelTransformParameterfEXT GLMock.PixelTransformParameterfEXT
#undef glPixelTransformParameterfvEXT
#define glPixelTransformParameterfvEXT GLMock.PixelTransformParameterfvEXT
#undef glPixelTransformParameteriEXT
#define glPixelTransformParameteriEXT GLMock.PixelTransformParameteriEXT
#undef glPixelTransformParameterivEXT
#define glPixelTransformParameterivEXT GLMock.PixelTransformParameterivEXT
#undef glPointParameterfEXT
#define glPointParameterfEXT GLMock.PointParameterfEXT
#undef glPointParameterfvEXT
#define glPointParameterfvEXT GLMock.PointParameterfvEXT
#undef glPolygonOffsetEXT
#define glPolygonOffsetEXT GLMock.PolygonOffsetEXT
#undef glProvokingVertexEXT
#define glProvokingVertexEXT GLMock.ProvokingVertexEXT
#undef glBeginSceneEXT
#define glBeginSceneEXT GLMock.BeginSceneEXT
#undef glEndSceneEXT
#define glEndSceneEXT GLMock.EndSceneEXT
#undef glSecondaryColor3bEXT
#define glSecondaryColor3bEXT GLMock.SecondaryColor3bEXT
#undef glSecondaryColor3bvEXT
#define glSecondaryColor3bvEXT GLMock.SecondaryColor3bvEXT
#undef glSecondaryColor3dEXT
#define glSecondaryColor3dEXT GLMock.SecondaryColor3dEXT
#undef glSecondaryColor3dvEXT
#define glSecondaryColor3dvEXT GLMock.SecondaryColor3dvEXT
#undef glSecondaryColor3fEXT
#define glSecondaryColor3fEXT GLMock.SecondaryColor3fEXT
#undef glSecondaryColor3fvEXT
#define glSecondaryColor3fvEXT GLMock.SecondaryColor3fvEXT
#undef glSecondaryColor3iEXT
#define glSecondaryColor3iEXT GLMock.SecondaryColor3iEXT
#undef glSecondaryColor3ivEXT
#define glSecondaryColor3ivEXT GLMock.SecondaryColor3ivEXT
#undef glSecondaryColor3sEXT
#define glSecondaryColor3sEXT GLMock.SecondaryColor3sEXT
#undef glSecondaryColor3svEXT
#define glSecondaryColor3svEXT GLMock.SecondaryColor3svEXT
#undef glSecondaryColor3ubEXT
#define glSecondaryColor3ubEXT GLMock.SecondaryColor3ubEXT
#undef glSecondaryColor3ubvEXT
#define glSecondaryColor3ubvEXT GLMock.SecondaryColor3ubvEXT
#undef glSecondaryColor3uiEXT
#define glSecondaryColor3uiEXT GLMock.SecondaryColor3uiEXT
#undef glSecondaryColor3uivEXT
#define glSecondaryColor3uivEXT GLMock.SecondaryColor3uivEXT
#undef glSecondaryColor3usEXT
#define glSecondaryColor3usEXT GLMock.SecondaryColor3usEXT
#undef glSecondaryColor3usvEXT
#define glSecondaryColor3usvEXT GLMock.SecondaryColor3usvEXT
#undef glSecondaryColorPointerEXT
#define glSecondaryColorPointerEXT GLMock.SecondaryColorPointerEXT
#undef glActiveProgramEXT
#define glActiveProgramEXT GLMock.ActiveProgramEXT
#undef glCreateShaderProgramEXT
#define glCreateShaderProgramEXT GLMock.CreateShaderProgramEXT
#undef glUseShaderProgramEXT
#define glUseShaderProgramEXT GLMock.UseShaderProgramEXT
#undef glBindImageTextureEXT
#define glBindImageTextureEXT GLMock.BindImageTextureEXT
#undef glMemoryBarrierEXT
#define glMemoryBarrierEXT GLMock.MemoryBarrierEXT
#undef glActiveStencilFaceEXT
#define glActiveStencilFaceEXT GLMock.ActiveStencilFaceEXT
#undef glTexSubImage1DEXT
#define glTexSubImage1DEXT GLMock.TexSubImage1DEXT
#undef glTexSubImage2DEXT
#define glTexSubImage2DEXT GLMock.TexSubImage2DEXT
#undef glTexSubImage3DEXT
#define glTexSubImage3DEXT GLMock.TexSubImage3DEXT
#undef glTexImage3DEXT
#define glTexImage3DEXT GLMock.TexImage3DEXT
#undef glTexBufferEXT
#define glTexBufferEXT GLMock.TexBufferEXT
#undef glClearColorIiEXT
#define glClearColorIiEXT GLMock.ClearColorIiEXT
#undef glClearColorIuiEXT
#define glClearColorIuiEXT GLMock.ClearColorIuiEXT
#undef glGetTexParameterIivEXT
#define glGetTexParameterIivEXT GLMock.GetTexParameterIivEXT
#undef glGetTexParameterIuivEXT
#define glGetTexParameterIuivEXT GLMock.GetTexParameterIuivEXT
#undef glTexParameterIivEXT
#define glTexParameterIivEXT GLMock.TexParameterIivEXT
#undef glTexParameterIuivEXT
#define glTexParameterIuivEXT GLMock.TexParameterIuivEXT
#undef glAreTexturesResidentEXT
#define glAreTexturesResidentEXT GLMock.AreTexturesResidentEXT
#undef glBindTextureEXT
#define glBindTextureEXT GLMock.BindTextureEXT
#undef glDeleteTexturesEXT
#define glDeleteTexturesEXT GLMock.DeleteTexturesEXT
#undef glGenTexturesEXT
#define glGenTexturesEXT GLMock.GenTexturesEXT
#undef glIsTextureEXT
#define glIsTextureEXT GLMock.IsTextureEXT
#undef glPrioritizeTexturesEXT
#define glPrioritizeTexturesEXT GLMock.PrioritizeTexturesEXT
#undef glTextureNormalEXT
#define glTextureNormalEXT GLMock.TextureNormalEXT
#undef glGetQueryObjecti64vEXT
#define glGetQueryObjecti64vEXT GLMock.GetQueryObjecti64vEXT
#undef glGetQueryObjectui64vEXT
#define glGetQueryObjectui64vEXT GLMock.GetQueryObjectui64vEXT
#undef glBeginTransformFeedbackEXT
#define glBeginTransformFeedbackEXT GLMock.BeginTransformFeedbackEXT
#undef glBindBufferBaseEXT
#define glBindBufferBaseEXT GLMock.BindBufferBaseEXT
#undef glBindBufferOffsetEXT
#define glBindBufferOffsetEXT GLMock.BindBufferOffsetEXT
#undef glBindBufferRangeEXT
#define glBindBufferRangeEXT GLMock.BindBufferRangeEXT
#undef glEndTransformFeedbackEXT
#define glEndTransformFeedbackEXT GLMock.EndTransformFeedbackEXT
#undef glGetTransformFeedbackVaryingEXT
#define glGetTransformFeedbackVaryingEXT GLMock.GetTransformFeedbackVaryingEXT
#undef glTransformFeedbackVaryingsEXT
#define glTransformFeedbackVaryingsEXT GLMock.TransformFeedbackVaryingsEXT
#undef glArrayElementEXT
#define glArrayElementEXT GLMock.ArrayElementEXT
#undef glColorPointerEXT
#define glColorPointerEXT GLMock.ColorPointerEXT
#undef glDrawArraysEXT
#define glDrawArraysEXT GLMock.DrawArraysEXT
#undef glEdgeFlagPointerEXT
#define glEdgeFlagPointerEXT GLMock.EdgeFlagPointerEXT
#undef glGetPointervEXT
#define glGetPointervEXT GLMock.GetPointervEXT
#undef glIndexPointerEXT
#define glIndexPointerEXT GLMock.IndexPointerEXT
#undef glNormalPointerEXT
#define glNormalPointerEXT GLMock.NormalPointerEXT
#undef glTexCoordPointerEXT
#define glTexCoordPointerEXT GLMock.TexCoordPointerEXT
#undef glVertexPointerEXT
#define glVertexPointerEXT GLMock.VertexPointerEXT
#undef glGetVertexAttribLdvEXT
#define glGetVertexAttribLdvEXT GLMock.GetVertexAttribLdvEXT
#undef glVertexArrayVertexAttribLOffsetEXT
#define glVertexArrayVertexAttribLOffsetEXT GLMock.VertexArrayVertexAttribLOffsetEXT
#undef glVertexAttribL1dEXT
#define glVertexAttribL1dEXT GLMock.VertexAttribL1dEXT
#undef glVertexAttribL1dvEXT
#define glVertexAttribL1dvEXT GLMock.VertexAttribL1dvEXT
#undef glVertexAttribL2dEXT
#define glVertexAttribL2dEXT GLMock.VertexAttribL2dEXT
#undef glVertexAttribL2dvEXT
#define glVertexAttribL2dvEXT GLMock.VertexAttribL2dvEXT
#undef glVertexAttribL3dEXT
#define glVertexAttribL3dEXT GLMock.VertexAttribL3dEXT
#undef glVertexAttribL3dvEXT
#define glVertexAttribL3dvEXT GLMock.VertexAttribL3dvEXT
#undef glVertexAttribL4dEXT
#define glVertexAttribL4dEXT GLMock.VertexAttribL4dEXT
#undef glVertexAttribL4dvEXT
#define glVertexAttribL4dvEXT GLMock.VertexAttribL4dvEXT
#undef glVertexAttribLPointerEXT
#define glVertexAttribLPointerEXT GLMock.VertexAttribLPointerEXT
#undef glBeginVertexShaderEXT
#define glBeginVertexShaderEXT GLMock.BeginVertexShaderEXT
#undef glBindLightParameterEXT
#define glBindLightParameterEXT GLMock.BindLightParameterEXT
#undef glBindMaterialParameterEXT
#define glBindMaterialParameterEXT GLMock.BindMaterialParameterEXT
#undef glBindParameterEXT
#define glBindParameterEXT GLMock.BindParameterEXT
#undef glBindTexGenParameterEXT
#define glBindTexGenParameterEXT GLMock.BindTexGenParameterEXT
#undef glBindTextureUnitParameterEXT
#define glBindTextureUnitParameterEXT GLMock.BindTextureUnitParameterEXT
#undef glBindVertexShaderEXT
#define glBindVertexShaderEXT GLMock.BindVertexShaderEXT
#undef glDeleteVertexShaderEXT
#define glDeleteVertexShaderEXT GLMock.DeleteVertexShaderEXT
#undef glDisableVariantClientStateEXT
#define glDisableVariantClientStateEXT GLMock.DisableVariantClientStateEXT
#undef glEnableVariantClientStateEXT
#define glEnableVariantClientStateEXT GLMock.EnableVariantClientStateEXT
#undef glEndVertexShaderEXT
#define glEndVertexShaderEXT GLMock.EndVertexShaderEXT
#undef glExtractComponentEXT
#define glExtractComponentEXT GLMock.ExtractComponentEXT
#undef glGenSymbolsEXT
#define glGenSymbolsEXT GLMock.GenSymbolsEXT
#undef glGenVertexShadersEXT
#define glGenVertexShadersEXT GLMock.GenVertexShadersEXT
#undef glGetInvariantBooleanvEXT
#define glGetInvariantBooleanvEXT GLMock.GetInvariantBooleanvEXT
#undef glGetInvariantFloatvEXT
#define glGetInvariantFloatvEXT GLMock.GetInvariantFloatvEXT
#undef glGetInvariantIntegervEXT
#define glGetInvariantIntegervEXT GLMock.GetInvariantIntegervEXT
#undef glGetLocalConstantBooleanvEXT
#define glGetLocalConstantBooleanvEXT GLMock.GetLocalConstantBooleanvEXT
#undef glGetLocalConstantFloatvEXT
#define glGetLocalConstantFloatvEXT GLMock.GetLocalConstantFloatvEXT
#undef glGetLocalConstantIntegervEXT
#define glGetLocalConstantIntegervEXT GLMock.GetLocalConstantIntegervEXT
#undef glGetVariantBooleanvEXT
#define glGetVariantBooleanvEXT GLMock.GetVariantBooleanvEXT
#undef glGetVariantFloatvEXT
#define glGetVariantFloatvEXT GLMock.GetVariantFloatvEXT
#undef glGetVariantIntegervEXT
#define glGetVariantIntegervEXT GLMock.GetVariantIntegervEXT
#undef glGetVariantPointervEXT
#define glGetVariantPointervEXT GLMock.GetVariantPointervEXT
#undef glInsertComponentEXT
#define glInsertComponentEXT GLMock.InsertComponentEXT
#undef glIsVariantEnabledEXT
#define glIsVariantEnabledEXT GLMock.IsVariantEnabledEXT
#undef glSetInvariantEXT
#define glSetInvariantEXT GLMock.SetInvariantEXT
#undef glSetLocalConstantEXT
#define glSetLocalConstantEXT GLMock.SetLocalConstantEXT
#undef glShaderOp1EXT
#define glShaderOp1EXT GLMock.ShaderOp1EXT
#undef glShaderOp2EXT
#define glShaderOp2EXT GLMock.ShaderOp2EXT
#undef glShaderOp3EXT
#define glShaderOp3EXT GLMock.ShaderOp3EXT
#undef glSwizzleEXT
#define glSwizzleEXT GLMock.SwizzleEXT
#undef glVariantPointerEXT
#define glVariantPointerEXT GLMock.VariantPointerEXT
#undef glVariantbvEXT
#define glVariantbvEXT GLMock.VariantbvEXT
#undef glVariantdvEXT
#define glVariantdvEXT GLMock.VariantdvEXT
#undef glVariantfvEXT
#define glVariantfvEXT GLMock.VariantfvEXT
#undef glVariantivEXT
#define glVariantivEXT GLMock.VariantivEXT
#undef glVariantsvEXT
#define glVariantsvEXT GLMock.VariantsvEXT
#undef glVariantubvEXT
#define glVariantubvEXT GLMock.VariantubvEXT
#undef glVariantuivEXT
#define glVariantuivEXT GLMock.VariantuivEXT
#undef glVariantusvEXT
#define glVariantusvEXT GLMock.VariantusvEXT
#undef glWriteMaskEXT
#define glWriteMaskEXT GLMock.WriteMaskEXT
#undef glVertexWeightPointerEXT
#define glVertexWeightPointerEXT GLMock.VertexWeightPointerEXT
#undef glVertexWeightfEXT
#define glVertexWeightfEXT GLMock.VertexWeightfEXT
#undef glVertexWeightfvEXT
#define glVertexWeightfvEXT GLMock.VertexWeightfvEXT
#undef glFrameTerminatorGREMEDY
#define glFrameTerminatorGREMEDY GLMock.FrameTerminatorGREMEDY
#undef glStringMarkerGREMEDY
#define glStringMarkerGREMEDY GLMock.StringMarkerGREMEDY
#undef glGetImageTransformParameterfvHP
#define glGetImageTransformParameterfvHP GLMock.GetImageTransformParameterfvHP
#undef glGetImageTransformParameterivHP
#define glGetImageTransformParameterivHP GLMock.GetImageTransformParameterivHP
#undef glImageTransformParameterfHP
#define glImageTransformParameterfHP GLMock.ImageTransformParameterfHP
#undef glImageTransformParameterfvHP
#define glImageTransformParameterfvHP GLMock.ImageTransformParameterfvHP
#undef glImageTransformParameteriHP
#define glImageTransformParameteriHP GLMock.ImageTransformParameteriHP
#undef glImageTransformParameterivHP
#define glImageTransformParameterivHP GLMock.ImageTransformParameterivHP
#undef glMultiModeDrawArraysIBM
#define glMultiModeDrawArraysIBM GLMock.MultiModeDrawArraysIBM
#undef glMultiModeDrawElementsIBM
#define glMultiModeDrawElementsIBM GLMock.MultiModeDrawElementsIBM
#undef glColorPointerListIBM
#define glColorPointerListIBM GLMock.ColorPointerListIBM
#undef glEdgeFlagPointerListIBM
#define glEdgeFlagPointerListIBM GLMock.EdgeFlagPointerListIBM
#undef glFogCoordPointerListIBM
#define glFogCoordPointerListIBM GLMock.FogCoordPointerListIBM
#undef glIndexPointerListIBM
#define glIndexPointerListIBM GLMock.IndexPointerListIBM
#undef glNormalPointerListIBM
#define glNormalPointerListIBM GLMock.NormalPointerListIBM
#undef glSecondaryColorPointerListIBM
#define glSecondaryColorPointerListIBM GLMock.SecondaryColorPointerListIBM
#undef glTexCoordPointerListIBM
#define glTexCoordPointerListIBM GLMock.TexCoordPointerListIBM
#undef glVertexPointerListIBM
#define glVertexPointerListIBM GLMock.VertexPointerListIBM
#undef glColorPointervINTEL
#define glColorPointervINTEL GLMock.ColorPointervINTEL
#undef glNormalPointervINTEL
#define glNormalPointervINTEL GLMock.NormalPointervINTEL
#undef glTexCoordPointervINTEL
#define glTexCoordPointervINTEL GLMock.TexCoordPointervINTEL
#undef glVertexPointervINTEL
#define glVertexPointervINTEL GLMock.VertexPointervINTEL
#undef glTexScissorFuncINTEL
#define glTexScissorFuncINTEL GLMock.TexScissorFuncINTEL
#undef glTexScissorINTEL
#define glTexScissorINTEL GLMock.TexScissorINTEL
#undef glBufferRegionEnabledEXT
#define glBufferRegionEnabledEXT GLMock.BufferRegionEnabledEXT
#undef glDeleteBufferRegionEXT
#define glDeleteBufferRegionEXT GLMock.DeleteBufferRegionEXT
#undef glDrawBufferRegionEXT
#define glDrawBufferRegionEXT GLMock.DrawBufferRegionEXT
#undef glNewBufferRegionEXT
#define glNewBufferRegionEXT GLMock.NewBufferRegionEXT
#undef glReadBufferRegionEXT
#define glReadBufferRegionEXT GLMock.ReadBufferRegionEXT
#undef glResizeBuffersMESA
#define glResizeBuffersMESA GLMock.ResizeBuffersMESA
#undef glWindowPos2dMESA
#define glWindowPos2dMESA GLMock.WindowPos2dMESA
#undef glWindowPos2dvMESA
#define glWindowPos2dvMESA GLMock.WindowPos2dvMESA
#undef glWindowPos2fMESA
#define glWindowPos2fMESA GLMock.WindowPos2fMESA
#undef glWindowPos2fvMESA
#define glWindowPos2fvMESA GLMock.WindowPos2fvMESA
#undef glWindowPos2iMESA
#define glWindowPos2iMESA GLMock.WindowPos2iMESA
#undef glWindowPos2ivMESA
#define glWindowPos2ivMESA GLMock.WindowPos2ivMESA
#undef glWindowPos2sMESA
#define glWindowPos2sMESA GLMock.WindowPos2sMESA
#undef glWindowPos2svMESA
#define glWindowPos2svMESA GLMock.WindowPos2svMESA
#undef glWindowPos3dMESA
#define glWindowPos3dMESA GLMock.WindowPos3dMESA
#undef glWindowPos3dvMESA
#define glWindowPos3dvMESA GLMock.WindowPos3dvMESA
#undef glWindowPos3fMESA
#define glWindowPos3fMESA GLMock.WindowPos3fMESA
#undef glWindowPos3fvMESA
#define glWindowPos3fvMESA GLMock.WindowPos3fvMESA
#undef glWindowPos3iMESA
#define glWindowPos3iMESA GLMock.WindowPos3iMESA
#undef glWindowPos3ivMESA
#define glWindowPos3ivMESA GLMock.WindowPos3ivMESA
#undef glWindowPos3sMESA
#define glWindowPos3sMESA GLMock.WindowPos3sMESA
#undef glWindowPos3svMESA
#define glWindowPos3svMESA GLMock.WindowPos3svMESA
#undef glWindowPos4dMESA
#define glWindowPos4dMESA GLMock.WindowPos4dMESA
#undef glWindowPos4dvMESA
#define glWindowPos4dvMESA GLMock.WindowPos4dvMESA
#undef glWindowPos4fMESA
#define glWindowPos4fMESA GLMock.WindowPos4fMESA
#undef glWindowPos4fvMESA
#define glWindowPos4fvMESA GLMock.WindowPos4fvMESA
#undef glWindowPos4iMESA
#define glWindowPos4iMESA GLMock.WindowPos4iMESA
#undef glWindowPos4ivMESA
#define glWindowPos4ivMESA GLMock.WindowPos4ivMESA
#undef glWindowPos4sMESA
#define glWindowPos4sMESA GLMock.WindowPos4sMESA
#undef glWindowPos4svMESA
#define glWindowPos4svMESA GLMock.WindowPos4svMESA
#undef glBeginConditionalRenderNV
#define glBeginConditionalRenderNV GLMock.BeginConditionalRenderNV
#undef glEndConditionalRenderNV
#define glEndConditionalRenderNV GLMock.EndConditionalRenderNV
#undef glCopyImageSubDataNV
#define glCopyImageSubDataNV GLMock.CopyImageSubDataNV
#undef glClearDepthdNV
#define glClearDepthdNV GLMock.ClearDepthdNV
#undef glDepthBoundsdNV
#define glDepthBoundsdNV GLMock.DepthBoundsdNV
#undef glDepthRangedNV
#define glDepthRangedNV GLMock.DepthRangedNV
#undef glEvalMapsNV
#define glEvalMapsNV GLMock.EvalMapsNV
#undef glGetMapAttribParameterfvNV
#define glGetMapAttribParameterfvNV GLMock.GetMapAttribParameterfvNV
#undef glGetMapAttribParameterivNV
#define glGetMapAttribParameterivNV GLMock.GetMapAttribParameterivNV
#undef glGetMapControlPointsNV
#define glGetMapControlPointsNV GLMock.GetMapControlPointsNV
#undef glGetMapParameterfvNV
#define glGetMapParameterfvNV GLMock.GetMapParameterfvNV
#undef glGetMapParameterivNV
#define glGetMapParameterivNV GLMock.GetMapParameterivNV
#undef glMapControlPointsNV
#define glMapControlPointsNV GLMock.MapControlPointsNV
#undef glMapParameterfvNV
#define glMapParameterfvNV GLMock.MapParameterfvNV
#undef glMapParameterivNV
#define glMapParameterivNV GLMock.MapParameterivNV
#undef glGetMultisamplefvNV
#define glGetMultisamplefvNV GLMock.GetMultisamplefvNV
#undef glSampleMaskIndexedNV
#define glSampleMaskIndexedNV GLMock.SampleMaskIndexedNV
#undef glTexRenderbufferNV
#define glTexRenderbufferNV GLMock.TexRenderbufferNV
#undef glDeleteFencesNV
#define glDeleteFencesNV GLMock.DeleteFencesNV
#undef glFinishFenceNV
#define glFinishFenceNV GLMock.FinishFenceNV
#undef glGenFencesNV
#define glGenFencesNV GLMock.GenFencesNV
#undef glGetFenceivNV
#define glGetFenceivNV GLMock.GetFenceivNV
#undef glIsFenceNV
#define glIsFenceNV GLMock.IsFenceNV
#undef glSetFenceNV
#define glSetFenceNV GLMock.SetFenceNV
#undef glTestFenceNV
#define glTestFenceNV GLMock.TestFenceNV
#undef glGetProgramNamedParameterdvNV
#define glGetProgramNamedParameterdvNV GLMock.GetProgramNamedParameterdvNV
#undef glGetProgramNamedParameterfvNV
#define glGetProgramNamedParameterfvNV GLMock.GetProgramNamedParameterfvNV
#undef glProgramNamedParameter4dNV
#define glProgramNamedParameter4dNV GLMock.ProgramNamedParameter4dNV
#undef glProgramNamedParameter4dvNV
#define glProgramNamedParameter4dvNV GLMock.ProgramNamedParameter4dvNV
#undef glProgramNamedParameter4fNV
#define glProgramNamedParameter4fNV GLMock.ProgramNamedParameter4fNV
#undef glProgramNamedParameter4fvNV
#define glProgramNamedParameter4fvNV GLMock.ProgramNamedParameter4fvNV
#undef glRenderbufferStorageMultisampleCoverageNV
#define glRenderbufferStorageMultisampleCoverageNV GLMock.RenderbufferStorageMultisampleCoverageNV
#undef glProgramVertexLimitNV
#define glProgramVertexLimitNV GLMock.ProgramVertexLimitNV
#undef glProgramEnvParameterI4iNV
#define glProgramEnvParameterI4iNV GLMock.ProgramEnvParameterI4iNV
#undef glProgramEnvParameterI4ivNV
#define glProgramEnvParameterI4ivNV GLMock.ProgramEnvParameterI4ivNV
#undef glProgramEnvParameterI4uiNV
#define glProgramEnvParameterI4uiNV GLMock.ProgramEnvParameterI4uiNV
#undef glProgramEnvParameterI4uivNV
#define glProgramEnvParameterI4uivNV GLMock.ProgramEnvParameterI4uivNV
#undef glProgramEnvParametersI4ivNV
#define glProgramEnvParametersI4ivNV GLMock.ProgramEnvParametersI4ivNV
#undef glProgramEnvParametersI4uivNV
#define glProgramEnvParametersI4uivNV GLMock.ProgramEnvParametersI4uivNV
#undef glProgramLocalParameterI4iNV
#define glProgramLocalParameterI4iNV GLMock.ProgramLocalParameterI4iNV
#undef glProgramLocalParameterI4ivNV
#define glProgramLocalParameterI4ivNV GLMock.ProgramLocalParameterI4ivNV
#undef glProgramLocalParameterI4uiNV
#define glProgramLocalParameterI4uiNV GLMock.ProgramLocalParameterI4uiNV
#undef glProgramLocalParameterI4uivNV
#define glProgramLocalParameterI4uivNV GLMock.ProgramLocalParameterI4uivNV
#undef glProgramLocalParametersI4ivNV
#define glProgramLocalParametersI4ivNV GLMock.ProgramLocalParametersI4ivNV
#undef glProgramLocalParametersI4uivNV
#define glProgramLocalParametersI4uivNV GLMock.ProgramLocalParametersI4uivNV
#undef glGetUniformi64vNV
#define glGetUniformi64vNV GLMock.GetUniformi64vNV
#undef glGetUniformui64vNV
#define glGetUniformui64vNV GLMock.GetUniformui64vNV
#undef glProgramUniform1i64NV
#define glProgramUniform1i64NV GLMock.ProgramUniform1i64NV
#undef glProgramUniform1i64vNV
#define glProgramUniform1i64vNV GLMock.ProgramUniform1i64vNV
#undef glProgramUniform1ui64NV
#define glProgramUniform1ui64NV GLMock.ProgramUniform1ui64NV
#undef glProgramUniform1ui64vNV
#define glProgramUniform1ui64vNV GLMock.ProgramUniform1ui64vNV
#undef glProgramUniform2i64NV
#define glProgramUniform2i64NV GLMock.ProgramUniform2i64NV
#undef glProgramUniform2i64vNV
#define glProgramUniform2i64vNV GLMock.ProgramUniform2i64vNV
#undef glProgramUniform2ui64NV
#define glProgramUniform2ui64NV GLMock.ProgramUniform2ui64NV
#undef glProgramUniform2ui64vNV
#define glProgramUniform2ui64vNV GLMock.ProgramUniform2ui64vNV
#undef glProgramUniform3i64NV
#define glProgramUniform3i64NV GLMock.ProgramUniform3i64NV
#undef glProgramUniform3i64vNV
#define glProgramUniform3i64vNV GLMock.ProgramUniform3i64vNV
#undef glProgramUniform3ui64NV
#define glProgramUniform3ui64NV GLMock.ProgramUniform3ui64NV
#undef glProgramUniform3ui64vNV
#define glProgramUniform3ui64vNV GLMock.ProgramUniform3ui64vNV
#undef glProgramUniform4i64NV
#define glProgramUniform4i64NV GLMock.ProgramUniform4i64NV
#undef glProgramUniform4i64vNV
#define glProgramUniform4i64vNV GLMock.ProgramUniform4i64vNV
#undef glProgramUniform4ui64NV
#define glProgramUniform4ui64NV GLMock.ProgramUniform4ui64NV
#undef glProgramUniform4ui64vNV
#define glProgramUniform4ui64vNV GLMock.ProgramUniform4ui64vNV
#undef glUniform1i64NV
#define glUniform1i64NV GLMock.Uniform1i64NV
#undef glUniform1i64vNV
#define glUniform1i64vNV GLMock.Uniform1i64vNV
#undef glUniform1ui64NV
#define glUniform1ui64NV GLMock.Uniform1ui64NV
#undef glUniform1ui64vNV
#define glUniform1ui64vNV GLMock.Uniform1ui64vNV
#undef glUniform2i64NV
#define glUniform2i64NV GLMock.Uniform2i64NV
#undef glUniform2i64vNV
#define glUniform2i64vNV GLMock.Uniform2i64vNV
#undef glUniform2ui64NV
#define glUniform2ui64NV GLMock.Uniform2ui64NV
#undef glUniform2ui64vNV
#define glUniform2ui64vNV GLMock.Uniform2ui64vNV
#undef glUniform3i64NV
#define glUniform3i64NV GLMock.Uniform3i64NV
#undef glUniform3i64vNV
#define glUniform3i64vNV GLMock.Uniform3i64vNV
#undef glUniform3ui64NV
#define glUniform3ui64NV GLMock.Uniform3ui64NV
#undef glUniform3ui64vNV
#define glUniform3ui64vNV GLMock.Uniform3ui64vNV
#undef glUniform4i64NV
#define glUniform4i64NV GLMock.Uniform4i64NV
#undef glUniform4i64vNV
#define glUniform4i64vNV GLMock.Uniform4i64vNV
#undef glUniform4ui64NV
#define glUniform4ui64NV GLMock.Uniform4ui64NV
#undef glUniform4ui64vNV
#define glUniform4ui64vNV GLMock.Uniform4ui64vNV
#undef glColor3hNV
#define glColor3hNV GLMock.Color3hNV
#undef glColor3hvNV
#define glColor3hvNV GLMock.Color3hvNV
#undef glColor4hNV
#define glColor4hNV GLMock.Color4hNV
#undef glColor4hvNV
#define glColor4hvNV GLMock.Color4hvNV
#undef glFogCoordhNV
#define glFogCoordhNV GLMock.FogCoordhNV
#undef glFogCoordhvNV
#define glFogCoordhvNV GLMock.FogCoordhvNV
#undef glMultiTexCoord1hNV
#define glMultiTexCoord1hNV GLMock.MultiTexCoord1hNV
#undef glMultiTexCoord1hvNV
#define glMultiTexCoord1hvNV GLMock.MultiTexCoord1hvNV
#undef glMultiTexCoord2hNV
#define glMultiTexCoord2hNV GLMock.MultiTexCoord2hNV
#undef glMultiTexCoord2hvNV
#define glMultiTexCoord2hvNV GLMock.MultiTexCoord2hvNV
#undef glMultiTexCoord3hNV
#define glMultiTexCoord3hNV GLMock.MultiTexCoord3hNV
#undef glMultiTexCoord3hvNV
#define glMultiTexCoord3hvNV GLMock.MultiTexCoord3hvNV
#undef glMultiTexCoord4hNV
#define glMultiTexCoord4hNV GLMock.MultiTexCoord4hNV
#undef glMultiTexCoord4hvNV
#define glMultiTexCoord4hvNV GLMock.MultiTexCoord4hvNV
#undef glNormal3hNV
#define glNormal3hNV GLMock.Normal3hNV
#undef glNormal3hvNV
#define glNormal3hvNV GLMock.Normal3hvNV
#undef glSecondaryColor3hNV
#define glSecondaryColor3hNV GLMock.SecondaryColor3hNV
#undef glSecondaryColor3hvNV
#define glSecondaryColor3hvNV GLMock.SecondaryColor3hvNV
#undef glTexCoord1hNV
#define glTexCoord1hNV GLMock.TexCoord1hNV
#undef glTexCoord1hvNV
#define glTexCoord1hvNV GLMock.TexCoord1hvNV
#undef glTexCoord2hNV
#define glTexCoord2hNV GLMock.TexCoord2hNV
#undef glTexCoord2hvNV
#define glTexCoord2hvNV GLMock.TexCoord2hvNV
#undef glTexCoord3hNV
#define glTexCoord3hNV GLMock.TexCoord3hNV
#undef glTexCoord3hvNV
#define glTexCoord3hvNV GLMock.TexCoord3hvNV
#undef glTexCoord4hNV
#define glTexCoord4hNV GLMock.TexCoord4hNV
#undef glTexCoord4hvNV
#define glTexCoord4hvNV GLMock.TexCoord4hvNV
#undef glVertex2hNV
#define glVertex2hNV GLMock.Vertex2hNV
#undef glVertex2hvNV
#define glVertex2hvNV GLMock.Vertex2hvNV
#undef glVertex3hNV
#define glVertex3hNV GLMock.Vertex3hNV
#undef glVertex3hvNV
#define glVertex3hvNV GLMock.Vertex3hvNV
#undef glVertex4hNV
#define glVertex4hNV GLMock.Vertex4hNV
#undef glVertex4hvNV
#define glVertex4hvNV GLMock.Vertex4hvNV
#undef glVertexAttrib1hNV
#define glVertexAttrib1hNV GLMock.VertexAttrib1hNV
#undef glVertexAttrib1hvNV
#define glVertexAttrib1hvNV GLMock.VertexAttrib1hvNV
#undef glVertexAttrib2hNV
#define glVertexAttrib2hNV GLMock.VertexAttrib2hNV
#undef glVertexAttrib2hvNV
#define glVertexAttrib2hvNV GLMock.VertexAttrib2hvNV
#undef glVertexAttrib3hNV
#define glVertexAttrib3hNV GLMock.VertexAttrib3hNV
#undef glVertexAttrib3hvNV
#define glVertexAttrib3hvNV GLMock.VertexAttrib3hvNV
#undef glVertexAttrib4hNV
#define glVertexAttrib4hNV GLMock.VertexAttrib4hNV
#undef glVertexAttrib4hvNV
#define glVertexAttrib4hvNV GLMock.VertexAttrib4hvNV
#undef glVertexAttribs1hvNV
#define glVertexAttribs1hvNV GLMock.VertexAttribs1hvNV
#undef glVertexAttribs2hvNV
#define glVertexAttribs2hvNV GLMock.VertexAttribs2hvNV
#undef glVertexAttribs3hvNV
#define glVertexAttribs3hvNV GLMock.VertexAttribs3hvNV
#undef glVertexAttribs4hvNV
#define glVertexAttribs4hvNV GLMock.VertexAttribs4hvNV
#undef glVertexWeighthNV
#define glVertexWeighthNV GLMock.VertexWeighthNV
#undef glVertexWeighthvNV
#define glVertexWeighthvNV GLMock.VertexWeighthvNV
#undef glBeginOcclusionQueryNV
#define glBeginOcclusionQueryNV GLMock.BeginOcclusionQueryNV
#undef glDeleteOcclusionQueriesNV
#define glDeleteOcclusionQueriesNV GLMock.DeleteOcclusionQueriesNV
#undef glEndOcclusionQueryNV
#define glEndOcclusionQueryNV GLMock.EndOcclusionQueryNV
#undef glGenOcclusionQueriesNV
#define glGenOcclusionQueriesNV GLMock.GenOcclusionQueriesNV
#undef glGetOcclusionQueryivNV
#define glGetOcclusionQueryivNV GLMock.GetOcclusionQueryivNV
#undef glGetOcclusionQueryuivNV
#define glGetOcclusionQueryuivNV GLMock.GetOcclusionQueryuivNV
#undef glIsOcclusionQueryNV
#define glIsOcclusionQueryNV GLMock.IsOcclusionQueryNV
#undef glProgramBufferParametersIivNV
#define glProgramBufferParametersIivNV GLMock.ProgramBufferParametersIivNV
#undef glProgramBufferParametersIuivNV
#define glProgramBufferParametersIuivNV GLMock.ProgramBufferParametersIuivNV
#undef glProgramBufferParametersfvNV
#define glProgramBufferParametersfvNV GLMock.ProgramBufferParametersfvNV
#undef glFlushPixelDataRangeNV
#define glFlushPixelDataRangeNV GLMock.FlushPixelDataRangeNV
#undef glPixelDataRangeNV
#define glPixelDataRangeNV GLMock.PixelDataRangeNV
#undef glPointParameteriNV
#define glPointParameteriNV GLMock.PointParameteriNV
#undef glPointParameterivNV
#define glPointParameterivNV GLMock.PointParameterivNV
#undef glGetVideoi64vNV
#define glGetVideoi64vNV GLMock.GetVideoi64vNV
#undef glGetVideoivNV
#define glGetVideoivNV GLMock.GetVideoivNV
#undef glGetVideoui64vNV
#define glGetVideoui64vNV GLMock.GetVideoui64vNV
#undef glGetVideouivNV
#define glGetVideouivNV GLMock.GetVideouivNV
#undef glPresentFrameDualFillNV
#define glPresentFrameDualFillNV GLMock.PresentFrameDualFillNV
#undef glPresentFrameKeyedNV
#define glPresentFrameKeyedNV GLMock.PresentFrameKeyedNV
#undef glPrimitiveRestartIndexNV
#define glPrimitiveRestartIndexNV GLMock.PrimitiveRestartIndexNV
#undef glPrimitiveRestartNV
#define glPrimitiveRestartNV GLMock.PrimitiveRestartNV
#undef glCombinerInputNV
#define glCombinerInputNV GLMock.CombinerInputNV
#undef glCombinerOutputNV
#define glCombinerOutputNV GLMock.CombinerOutputNV
#undef glCombinerParameterfNV
#define glCombinerParameterfNV GLMock.CombinerParameterfNV
#undef glCombinerParameterfvNV
#define glCombinerParameterfvNV GLMock.CombinerParameterfvNV
#undef glCombinerParameteriNV
#define glCombinerParameteriNV GLMock.CombinerParameteriNV
#undef glCombinerParameterivNV
#define glCombinerParameterivNV GLMock.CombinerParameterivNV
#undef glFinalCombinerInputNV
#define glFinalCombinerInputNV GLMock.FinalCombinerInputNV
#undef glGetCombinerInputParameterfvNV
#define glGetCombinerInputParameterfvNV GLMock.GetCombinerInputParameterfvNV
#undef glGetCombinerInputParameterivNV
#define glGetCombinerInputParameterivNV GLMock.GetCombinerInputParameterivNV
#undef glGetCombinerOutputParameterfvNV
#define glGetCombinerOutputParameterfvNV GLMock.GetCombinerOutputParameterfvNV
#undef glGetCombinerOutputParameterivNV
#define glGetCombinerOutputParameterivNV GLMock.GetCombinerOutputParameterivNV
#undef glGetFinalCombinerInputParameterfvNV
#define glGetFinalCombinerInputParameterfvNV GLMock.GetFinalCombinerInputParameterfvNV
#undef glGetFinalCombinerInputParameterivNV
#define glGetFinalCombinerInputParameterivNV GLMock.GetFinalCombinerInputParameterivNV
#undef glCombinerStageParameterfvNV
#define glCombinerStageParameterfvNV GLMock.CombinerStageParameterfvNV
#undef glGetCombinerStageParameterfvNV
#define glGetCombinerStageParameterfvNV GLMock.GetCombinerStageParameterfvNV
#undef glGetBufferParameterui64vNV
#define glGetBufferParameterui64vNV GLMock.GetBufferParameterui64vNV
#undef glGetIntegerui64vNV
#define glGetIntegerui64vNV GLMock.GetIntegerui64vNV
#undef glGetNamedBufferParameterui64vNV
#define glGetNamedBufferParameterui64vNV GLMock.GetNamedBufferParameterui64vNV
#undef glIsBufferResidentNV
#define glIsBufferResidentNV GLMock.IsBufferResidentNV
#undef glIsNamedBufferResidentNV
#define glIsNamedBufferResidentNV GLMock.IsNamedBufferResidentNV
#undef glMakeBufferNonResidentNV
#define glMakeBufferNonResidentNV GLMock.MakeBufferNonResidentNV
#undef glMakeBufferResidentNV
#define glMakeBufferResidentNV GLMock.MakeBufferResidentNV
#undef glMakeNamedBufferNonResidentNV
#define glMakeNamedBufferNonResidentNV GLMock.MakeNamedBufferNonResidentNV
#undef glMakeNamedBufferResidentNV
#define glMakeNamedBufferResidentNV GLMock.MakeNamedBufferResidentNV
#undef glProgramUniformui64NV
#define glProgramUniformui64NV GLMock.ProgramUniformui64NV
#undef glProgramUniformui64vNV
#define glProgramUniformui64vNV GLMock.ProgramUniformui64vNV
#undef glUniformui64NV
#define glUniformui64NV GLMock.Uniformui64NV
#undef glUniformui64vNV
#define glUniformui64vNV GLMock.Uniformui64vNV
#undef glTextureBarrierNV
#define glTextureBarrierNV GLMock.TextureBarrierNV
#undef glActiveVaryingNV
#define glActiveVaryingNV GLMock.ActiveVaryingNV
#undef glBeginTransformFeedbackNV
#define glBeginTransformFeedbackNV GLMock.BeginTransformFeedbackNV
#undef glBindBufferBaseNV
#define glBindBufferBaseNV GLMock.BindBufferBaseNV
#undef glBindBufferOffsetNV
#define glBindBufferOffsetNV GLMock.BindBufferOffsetNV
#undef glBindBufferRangeNV
#define glBindBufferRangeNV GLMock.BindBufferRangeNV
#undef glEndTransformFeedbackNV
#define glEndTransformFeedbackNV GLMock.EndTransformFeedbackNV
#undef glGetActiveVaryingNV
#define glGetActiveVaryingNV GLMock.GetActiveVaryingNV
#undef glGetTransformFeedbackVaryingNV
#define glGetTransformFeedbackVaryingNV GLMock.GetTransformFeedbackVaryingNV
#undef glGetVaryingLocationNV
#define glGetVaryingLocationNV GLMock.GetVaryingLocationNV
#undef glTransformFeedbackAttribsNV
#define glTransformFeedbackAttribsNV GLMock.TransformFeedbackAttribsNV
#undef glTransformFeedbackVaryingsNV
#define glTransformFeedbackVaryingsNV GLMock.TransformFeedbackVaryingsNV
#undef glBindTransformFeedbackNV
#define glBindTransformFeedbackNV GLMock.BindTransformFeedbackNV
#undef glDeleteTransformFeedbacksNV
#define glDeleteTransformFeedbacksNV GLMock.DeleteTransformFeedbacksNV
#undef glDrawTransformFeedbackNV
#define glDrawTransformFeedbackNV GLMock.DrawTransformFeedbackNV
#undef glGenTransformFeedbacksNV
#define glGenTransformFeedbacksNV GLMock.GenTransformFeedbacksNV
#undef glIsTransformFeedbackNV
#define glIsTransformFeedbackNV GLMock.IsTransformFeedbackNV
#undef glPauseTransformFeedbackNV
#define glPauseTransformFeedbackNV GLMock.PauseTransformFeedbackNV
#undef glResumeTransformFeedbackNV
#define glResumeTransformFeedbackNV GLMock.ResumeTransformFeedbackNV
#undef glFlushVertexArrayRangeNV
#define glFlushVertexArrayRangeNV GLMock.FlushVertexArrayRangeNV
#undef glVertexArrayRangeNV
#define glVertexArrayRangeNV GLMock.VertexArrayRangeNV
#undef glGetVertexAttribLi64vNV
#define glGetVertexAttribLi64vNV GLMock.GetVertexAttribLi64vNV
#undef glGetVertexAttribLui64vNV
#define glGetVertexAttribLui64vNV GLMock.GetVertexAttribLui64vNV
#undef glVertexAttribL1i64NV
#define glVertexAttribL1i64NV GLMock.VertexAttribL1i64NV
#undef glVertexAttribL1i64vNV
#define glVertexAttribL1i64vNV GLMock.VertexAttribL1i64vNV
#undef glVertexAttribL1ui64NV
#define glVertexAttribL1ui64NV GLMock.VertexAttribL1ui64NV
#undef glVertexAttribL1ui64vNV
#define glVertexAttribL1ui64vNV GLMock.VertexAttribL1ui64vNV
#undef glVertexAttribL2i64NV
#define glVertexAttribL2i64NV GLMock.VertexAttribL2i64NV
#undef glVertexAttribL2i64vNV
#define glVertexAttribL2i64vNV GLMock.VertexAttribL2i64vNV
#undef glVertexAttribL2ui64NV
#define glVertexAttribL2ui64NV GLMock.VertexAttribL2ui64NV
#undef glVertexAttribL2ui64vNV
#define glVertexAttribL2ui64vNV GLMock.VertexAttribL2ui64vNV
#undef glVertexAttribL3i64NV
#define glVertexAttribL3i64NV GLMock.VertexAttribL3i64NV
#undef glVertexAttribL3i64vNV
#define glVertexAttribL3i64vNV GLMock.VertexAttribL3i64vNV
#undef glVertexAttribL3ui64NV
#define glVertexAttribL3ui64NV GLMock.VertexAttribL3ui64NV
#undef glVertexAttribL3ui64vNV
#define glVertexAttribL3ui64vNV GLMock.VertexAttribL3ui64vNV
#undef glVertexAttribL4i64NV
#define glVertexAttribL4i64NV GLMock.VertexAttribL4i64NV
#undef glVertexAttribL4i64vNV
#define glVertexAttribL4i64vNV GLMock.VertexAttribL4i64vNV
#undef glVertexAttribL4ui64NV
#define glVertexAttribL4ui64NV GLMock.VertexAttribL4ui64NV
#undef glVertexAttribL4ui64vNV
#define glVertexAttribL4ui64vNV GLMock.VertexAttribL4ui64vNV
#undef glVertexAttribLFormatNV
#define glVertexAttribLFormatNV GLMock.VertexAttribLFormatNV
#undef glBufferAddressRangeNV
#define glBufferAddressRangeNV GLMock.BufferAddressRangeNV
#undef glColorFormatNV
#define glColorFormatNV GLMock.ColorFormatNV
#undef glEdgeFlagFormatNV
#define glEdgeFlagFormatNV GLMock.EdgeFlagFormatNV
#undef glFogCoordFormatNV
#define glFogCoordFormatNV GLMock.FogCoordFormatNV
#undef glGetIntegerui64i_vNV
#define glGetIntegerui64i_vNV GLMock.GetIntegerui64i_vNV
#undef glIndexFormatNV
#define glIndexFormatNV GLMock.IndexFormatNV
#undef glNormalFormatNV
#define glNormalFormatNV GLMock.NormalFormatNV
#undef glSecondaryColorFormatNV
#define glSecondaryColorFormatNV GLMock.SecondaryColorFormatNV
#undef glTexCoordFormatNV
#define glTexCoordFormatNV GLMock.TexCoordFormatNV
#undef glVertexAttribFormatNV
#define glVertexAttribFormatNV GLMock.VertexAttribFormatNV
#undef glVertexAttribIFormatNV
#define glVertexAttribIFormatNV GLMock.VertexAttribIFormatNV
#undef glVertexFormatNV
#define glVertexFormatNV GLMock.VertexFormatNV
#undef glAreProgramsResidentNV
#define glAreProgramsResidentNV GLMock.AreProgramsResidentNV
#undef glBindProgramNV
#define glBindProgramNV GLMock.BindProgramNV
#undef glDeleteProgramsNV
#define glDeleteProgramsNV GLMock.DeleteProgramsNV
#undef glExecuteProgramNV
#define glExecuteProgramNV GLMock.ExecuteProgramNV
#undef glGenProgramsNV
#define glGenProgramsNV GLMock.GenProgramsNV
#undef glGetProgramParameterdvNV
#define glGetProgramParameterdvNV GLMock.GetProgramParameterdvNV
#undef glGetProgramParameterfvNV
#define glGetProgramParameterfvNV GLMock.GetProgramParameterfvNV
#undef glGetProgramStringNV
#define glGetProgramStringNV GLMock.GetProgramStringNV
#undef glGetProgramivNV
#define glGetProgramivNV GLMock.GetProgramivNV
#undef glGetTrackMatrixivNV
#define glGetTrackMatrixivNV GLMock.GetTrackMatrixivNV
#undef glGetVertexAttribPointervNV
#define glGetVertexAttribPointervNV GLMock.GetVertexAttribPointervNV
#undef glGetVertexAttribdvNV
#define glGetVertexAttribdvNV GLMock.GetVertexAttribdvNV
#undef glGetVertexAttribfvNV
#define glGetVertexAttribfvNV GLMock.GetVertexAttribfvNV
#undef glGetVertexAttribivNV
#define glGetVertexAttribivNV GLMock.GetVertexAttribivNV
#undef glIsProgramNV
#define glIsProgramNV GLMock.IsProgramNV
#undef glLoadProgramNV
#define glLoadProgramNV GLMock.LoadProgramNV
#undef glProgramParameter4dNV
#define glProgramParameter4dNV GLMock.ProgramParameter4dNV
#undef glProgramParameter4dvNV
#define glProgramParameter4dvNV GLMock.ProgramParameter4dvNV
#undef glProgramParameter4fNV
#define glProgramParameter4fNV GLMock.ProgramParameter4fNV
#undef glProgramParameter4fvNV
#define glProgramParameter4fvNV GLMock.ProgramParameter4fvNV
#undef glProgramParameters4dvNV
#define glProgramParameters4dvNV GLMock.ProgramParameters4dvNV
#undef glProgramParameters4fvNV
#define glProgramParameters4fvNV GLMock.ProgramParameters4fvNV
#undef glRequestResidentProgramsNV
#define glRequestResidentProgramsNV GLMock.RequestResidentProgramsNV
#undef glTrackMatrixNV
#define glTrackMatrixNV GLMock.TrackMatrixNV
#undef glVertexAttrib1dNV
#define glVertexAttrib1dNV GLMock.VertexAttrib1dNV
#undef glVertexAttrib1dvNV
#define glVertexAttrib1dvNV GLMock.VertexAttrib1dvNV
#undef glVertexAttrib1fNV
#define glVertexAttrib1fNV GLMock.VertexAttrib1fNV
#undef glVertexAttrib1fvNV
#define glVertexAttrib1fvNV GLMock.VertexAttrib1fvNV
#undef glVertexAttrib1sNV
#define glVertexAttrib1sNV GLMock.VertexAttrib1sNV
#undef glVertexAttrib1svNV
#define glVertexAttrib1svNV GLMock.VertexAttrib1svNV
#undef glVertexAttrib2dNV
#define glVertexAttrib2dNV GLMock.VertexAttrib2dNV
#undef glVertexAttrib2dvNV
#define glVertexAttrib2dvNV GLMock.VertexAttrib2dvNV
#undef glVertexAttrib2fNV
#define glVertexAttrib2fNV GLMock.VertexAttrib2fNV
#undef glVertexAttrib2fvNV
#define glVertexAttrib2fvNV GLMock.VertexAttrib2fvNV
#undef glVertexAttrib2sNV
#define glVertexAttrib2sNV GLMock.VertexAttrib2sNV
#undef glVertexAttrib2svNV
#define glVertexAttrib2svNV GLMock.VertexAttrib2svNV
#undef glVertexAttrib3dNV
#define glVertexAttrib3dNV GLMock.VertexAttrib3dNV
#undef glVertexAttrib3dvNV
#define glVertexAttrib3dvNV GLMock.VertexAttrib3dvNV
#undef glVertexAttrib3fNV
#define glVertexAttrib3fNV GLMock.VertexAttrib3fNV
#undef glVertexAttrib3fvNV
#define glVertexAttrib3fvNV GLMock.VertexAttrib3fvNV
#undef glVertexAttrib3sNV
#define glVertexAttrib3sNV GLMock.VertexAttrib3sNV
#undef glVertexAttrib3svNV
#define glVertexAttrib3svNV GLMock.VertexAttrib3svNV
#undef glVertexAttrib4dNV
#define glVertexAttrib4dNV GLMock.VertexAttrib4dNV
#undef glVertexAttrib4dvNV
#define glVertexAttrib4dvNV GLMock.VertexAttrib4dvNV
#undef glVertexAttrib4fNV
#define glVertexAttrib4fNV GLMock.VertexAttrib4fNV
#undef glVertexAttrib4fvNV
#define glVertexAttrib4fvNV GLMock.VertexAttrib4fvNV
#undef glVertexAttrib4sNV
#define glVertexAttrib4sNV GLMock.VertexAttrib4sNV
#undef glVertexAttrib4svNV
#define glVertexAttrib4svNV GLMock.VertexAttrib4svNV
#undef glVertexAttrib4ubNV
#define glVertexAttrib4ubNV GLMock.VertexAttrib4ubNV
#undef glVertexAttrib4ubvNV
#define glVertexAttrib4ubvNV GLMock.VertexAttrib4ubvNV
#undef glVertexAttribPointerNV
#define glVertexAttribPointerNV GLMock.VertexAttribPointerNV
#undef glVertexAttribs1dvNV
#define glVertexAttribs1dvNV GLMock.VertexAttribs1dvNV
#undef glVertexAttribs1fvNV
#define glVertexAttribs1fvNV GLMock.VertexAttribs1fvNV
#undef glVertexAttribs1svNV
#define glVertexAttribs1svNV GLMock.VertexAttribs1svNV
#undef glVertexAttribs2dvNV
#define glVertexAttribs2dvNV GLMock.VertexAttribs2dvNV
#undef glVertexAttribs2fvNV
#define glVertexAttribs2fvNV GLMock.VertexAttribs2fvNV
#undef glVertexAttribs2svNV
#define glVertexAttribs2svNV GLMock.VertexAttribs2svNV
#undef glVertexAttribs3dvNV
#define glVertexAttribs3dvNV GLMock.VertexAttribs3dvNV
#undef glVertexAttribs3fvNV
#define glVertexAttribs3fvNV GLMock.VertexAttribs3fvNV
#undef glVertexAttribs3svNV
#define glVertexAttribs3svNV GLMock.VertexAttribs3svNV
#undef glVertexAttribs4dvNV
#define glVertexAttribs4dvNV GLMock.VertexAttribs4dvNV
#undef glVertexAttribs4fvNV
#define glVertexAttribs4fvNV GLMock.VertexAttribs4fvNV
#undef glVertexAttribs4svNV
#define glVertexAttribs4svNV GLMock.VertexAttribs4svNV
#undef glVertexAttribs4ubvNV
#define glVertexAttribs4ubvNV GLMock.VertexAttribs4ubvNV
#undef glClearDepthfOES
#define glClearDepthfOES GLMock.ClearDepthfOES
#undef glClipPlanefOES
#define glClipPlanefOES GLMock.ClipPlanefOES
#undef glDepthRangefOES
#define glDepthRangefOES GLMock.DepthRangefOES
#undef glFrustumfOES
#define glFrustumfOES GLMock.FrustumfOES
#undef glGetClipPlanefOES
#define glGetClipPlanefOES GLMock.GetClipPlanefOES
#undef glOrthofOES
#define glOrthofOES GLMock.OrthofOES
#undef glDetailTexFuncSGIS
#define glDetailTexFuncSGIS GLMock.DetailTexFuncSGIS
#undef glGetDetailTexFuncSGIS
#define glGetDetailTexFuncSGIS GLMock.GetDetailTexFuncSGIS
#undef glFogFuncSGIS
#define glFogFuncSGIS GLMock.FogFuncSGIS
#undef glGetFogFuncSGIS
#define glGetFogFuncSGIS GLMock.GetFogFuncSGIS
#undef glSampleMaskSGIS
#define glSampleMaskSGIS GLMock.SampleMaskSGIS
#undef glSamplePatternSGIS
#define glSamplePatternSGIS GLMock.SamplePatternSGIS
#undef glGetSharpenTexFuncSGIS
#define glGetSharpenTexFuncSGIS GLMock.GetSharpenTexFuncSGIS
#undef glSharpenTexFuncSGIS
#define glSharpenTexFuncSGIS GLMock.SharpenTexFuncSGIS
#undef glTexImage4DSGIS
#define glTexImage4DSGIS GLMock.TexImage4DSGIS
#undef glTexSubImage4DSGIS
#define glTexSubImage4DSGIS GLMock.TexSubImage4DSGIS
#undef glGetTexFilterFuncSGIS
#define glGetTexFilterFuncSGIS GLMock.GetTexFilterFuncSGIS
#undef glTexFilterFuncSGIS
#define glTexFilterFuncSGIS GLMock.TexFilterFuncSGIS
#undef glAsyncMarkerSGIX
#define glAsyncMarkerSGIX GLMock.AsyncMarkerSGIX
#undef glDeleteAsyncMarkersSGIX
#define glDeleteAsyncMarkersSGIX GLMock.DeleteAsyncMarkersSGIX
#undef glFinishAsyncSGIX
#define glFinishAsyncSGIX GLMock.FinishAsyncSGIX
#undef glGenAsyncMarkersSGIX
#define glGenAsyncMarkersSGIX GLMock.GenAsyncMarkersSGIX
#undef glIsAsyncMarkerSGIX
#define glIsAsyncMarkerSGIX GLMock.IsAsyncMarkerSGIX
#undef glPollAsyncSGIX
#define glPollAsyncSGIX GLMock.PollAsyncSGIX
#undef glFlushRasterSGIX
#define glFlushRasterSGIX GLMock.FlushRasterSGIX
#undef glTextureFogSGIX
#define glTextureFogSGIX GLMock.TextureFogSGIX
#undef glFragmentColorMaterialSGIX
#define glFragmentColorMaterialSGIX GLMock.FragmentColorMaterialSGIX
#undef glFragmentLightModelfSGIX
#define glFragmentLightModelfSGIX GLMock.FragmentLightModelfSGIX
#undef glFragmentLightModelfvSGIX
#define glFragmentLightModelfvSGIX GLMock.FragmentLightModelfvSGIX
#undef glFragmentLightModeliSGIX
#define glFragmentLightModeliSGIX GLMock.FragmentLightModeliSGIX
#undef glFragmentLightModelivSGIX
#define glFragmentLightModelivSGIX GLMock.FragmentLightModelivSGIX
#undef glFragmentLightfSGIX
#define glFragmentLightfSGIX GLMock.FragmentLightfSGIX
#undef glFragmentLightfvSGIX
#define glFragmentLightfvSGIX GLMock.FragmentLightfvSGIX
#undef glFragmentLightiSGIX
#define glFragmentLightiSGIX GLMock.FragmentLightiSGIX
#undef glFragmentLightivSGIX
#define glFragmentLightivSGIX GLMock.FragmentLightivSGIX
#undef glFragmentMaterialfSGIX
#define glFragmentMaterialfSGIX GLMock.FragmentMaterialfSGIX
#undef glFragmentMaterialfvSGIX
#define glFragmentMaterialfvSGIX GLMock.FragmentMaterialfvSGIX
#undef glFragmentMaterialiSGIX
#define glFragmentMaterialiSGIX GLMock.FragmentMaterialiSGIX
#undef glFragmentMaterialivSGIX
#define glFragmentMaterialivSGIX GLMock.FragmentMaterialivSGIX
#undef glGetFragmentLightfvSGIX
#define glGetFragmentLightfvSGIX GLMock.GetFragmentLightfvSGIX
#undef glGetFragmentLightivSGIX
#define glGetFragmentLightivSGIX GLMock.GetFragmentLightivSGIX
#undef glGetFragmentMaterialfvSGIX
#define glGetFragmentMaterialfvSGIX GLMock.GetFragmentMaterialfvSGIX
#undef glGetFragmentMaterialivSGIX
#define glGetFragmentMaterialivSGIX GLMock.GetFragmentMaterialivSGIX
#undef glFrameZoomSGIX
#define glFrameZoomSGIX GLMock.FrameZoomSGIX
#undef glPixelTexGenSGIX
#define glPixelTexGenSGIX GLMock.PixelTexGenSGIX
#undef glReferencePlaneSGIX
#define glReferencePlaneSGIX GLMock.ReferencePlaneSGIX
#undef glSpriteParameterfSGIX
#define glSpriteParameterfSGIX GLMock.SpriteParameterfSGIX
#undef glSpriteParameterfvSGIX
#define glSpriteParameterfvSGIX GLMock.SpriteParameterfvSGIX
#undef glSpriteParameteriSGIX
#define glSpriteParameteriSGIX GLMock.SpriteParameteriSGIX
#undef glSpriteParameterivSGIX
#define glSpriteParameterivSGIX GLMock.SpriteParameterivSGIX
#undef glTagSampleBufferSGIX
#define glTagSampleBufferSGIX GLMock.TagSampleBufferSGIX
#undef glColorTableParameterfvSGI
#define glColorTableParameterfvSGI GLMock.ColorTableParameterfvSGI
#undef glColorTableParameterivSGI
#define glColorTableParameterivSGI GLMock.ColorTableParameterivSGI
#undef glColorTableSGI
#define glColorTableSGI GLMock.ColorTableSGI
#undef glCopyColorTableSGI
#define glCopyColorTableSGI GLMock.CopyColorTableSGI
#undef glGetColorTableParameterfvSGI
#define glGetColorTableParameterfvSGI GLMock.GetColorTableParameterfvSGI
#undef glGetColorTableParameterivSGI
#define glGetColorTableParameterivSGI GLMock.GetColorTableParameterivSGI
#undef glGetColorTableSGI
#define glGetColorTableSGI GLMock.GetColorTableSGI
#undef glFinishTextureSUNX
#define glFinishTextureSUNX GLMock.FinishTextureSUNX
#undef glGlobalAlphaFactorbSUN
#define glGlobalAlphaFactorbSUN GLMock.GlobalAlphaFactorbSUN
#undef glGlobalAlphaFactordSUN
#define glGlobalAlphaFactordSUN GLMock.GlobalAlphaFactordSUN
#undef glGlobalAlphaFactorfSUN
#define glGlobalAlphaFactorfSUN GLMock.GlobalAlphaFactorfSUN
#undef glGlobalAlphaFactoriSUN
#define glGlobalAlphaFactoriSUN GLMock.GlobalAlphaFactoriSUN
#undef glGlobalAlphaFactorsSUN
#define glGlobalAlphaFactorsSUN GLMock.GlobalAlphaFactorsSUN
#undef glGlobalAlphaFactorubSUN
#define glGlobalAlphaFactorubSUN GLMock.GlobalAlphaFactorubSUN
#undef glGlobalAlphaFactoruiSUN
#define glGlobalAlphaFactoruiSUN GLMock.GlobalAlphaFactoruiSUN
#undef glGlobalAlphaFactorusSUN
#define glGlobalAlphaFactorusSUN GLMock.GlobalAlphaFactorusSUN
#undef glReadVideoPixelsSUN
#define glReadVideoPixelsSUN GLMock.ReadVideoPixelsSUN
#undef glReplacementCodePointerSUN
#define glReplacementCodePointerSUN GLMock.ReplacementCodePointerSUN
#undef glReplacementCodeubSUN
#define glReplacementCodeubSUN GLMock.ReplacementCodeubSUN
#undef glReplacementCodeubvSUN
#define glReplacementCodeubvSUN GLMock.ReplacementCodeubvSUN
#undef glReplacementCodeuiSUN
#define glReplacementCodeuiSUN GLMock.ReplacementCodeuiSUN
#undef glReplacementCodeuivSUN
#define glReplacementCodeuivSUN GLMock.ReplacementCodeuivSUN
#undef glReplacementCodeusSUN
#define glReplacementCodeusSUN GLMock.ReplacementCodeusSUN
#undef glReplacementCodeusvSUN
#define glReplacementCodeusvSUN GLMock.ReplacementCodeusvSUN
#undef glColor3fVertex3fSUN
#define glColor3fVertex3fSUN GLMock.Color3fVertex3fSUN
#undef glColor3fVertex3fvSUN
#define glColor3fVertex3fvSUN GLMock.Color3fVertex3fvSUN
#undef glColor4fNormal3fVertex3fSUN
#define glColor4fNormal3fVertex3fSUN GLMock.Color4fNormal3fVertex3fSUN
#undef glColor4fNormal3fVertex3fvSUN
#define glColor4fNormal3fVertex3fvSUN GLMock.Color4fNormal3fVertex3fvSUN
#undef glColor4ubVertex2fSUN
#define glColor4ubVertex2fSUN GLMock.Color4ubVertex2fSUN
#undef glColor4ubVertex2fvSUN
#define glColor4ubVertex2fvSUN GLMock.Color4ubVertex2fvSUN
#undef glColor4ubVertex3fSUN
#define glColor4ubVertex3fSUN GLMock.Color4ubVertex3fSUN
#undef glColor4ubVertex3fvSUN
#define glColor4ubVertex3fvSUN GLMock.Color4ubVertex3fvSUN
#undef glNormal3fVertex3fSUN
#define glNormal3fVertex3fSUN GLMock.Normal3fVertex3fSUN
#undef glNormal3fVertex3fvSUN
#define glNormal3fVertex3fvSUN GLMock.Normal3fVertex3fvSUN
#undef glReplacementCodeuiColor3fVertex3fSUN
#define glReplacementCodeuiColor3fVertex3fSUN GLMock.ReplacementCodeuiColor3fVertex3fSUN
#undef glReplacementCodeuiColor3fVertex3fvSUN
#define glReplacementCodeuiColor3fVertex3fvSUN GLMock.ReplacementCodeuiColor3fVertex3fvSUN
#undef glReplacementCodeuiColor4fNormal3fVertex3fSUN
#define glReplacementCodeuiColor4fNormal3fVertex3fSUN GLMock.ReplacementCodeuiColor4fNormal3fVertex3fSUN
#undef glReplacementCodeuiColor4fNormal3fVertex3fvSUN
#define glReplacementCodeuiColor4fNormal3fVertex3fvSUN GLMock.ReplacementCodeuiColor4fNormal3fVertex3fvSUN
#undef glReplacementCodeuiColor4ubVertex3fSUN
#define glReplacementCodeuiColor4ubVertex3fSUN GLMock.ReplacementCodeuiColor4ubVertex3fSUN
#undef glReplacementCodeuiColor4ubVertex3fvSUN
#define glReplacementCodeuiColor4ubVertex3fvSUN GLMock.ReplacementCodeuiColor4ubVertex3fvSUN
#undef glReplacementCodeuiNormal3fVertex3fSUN
#define glReplacementCodeuiNormal3fVertex3fSUN GLMock.ReplacementCodeuiNormal3fVertex3fSUN
#undef glReplacementCodeuiNormal3fVertex3fvSUN
#define glReplacementCodeuiNormal3fVertex3fvSUN GLMock.ReplacementCodeuiNormal3fVertex3fvSUN
#undef glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN
#define glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN GLMock.ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN
#undef glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN
#define glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN GLMock.ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN
#undef glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN
#define glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN GLMock.ReplacementCodeuiTexCoord2fNormal3fVertex3fSUN
#undef glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN
#define glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN GLMock.ReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN
#undef glReplacementCodeuiTexCoord2fVertex3fSUN
#define glReplacementCodeuiTexCoord2fVertex3fSUN GLMock.ReplacementCodeuiTexCoord2fVertex3fSUN
#undef glReplacementCodeuiTexCoord2fVertex3fvSUN
#define glReplacementCodeuiTexCoord2fVertex3fvSUN GLMock.ReplacementCodeuiTexCoord2fVertex3fvSUN
#undef glReplacementCodeuiVertex3fSUN
#define glReplacementCodeuiVertex3fSUN GLMock.ReplacementCodeuiVertex3fSUN
#undef glReplacementCodeuiVertex3fvSUN
#define glReplacementCodeuiVertex3fvSUN GLMock.ReplacementCodeuiVertex3fvSUN
#undef glTexCoord2fColor3fVertex3fSUN
#define glTexCoord2fColor3fVertex3fSUN GLMock.TexCoord2fColor3fVertex3fSUN
#undef glTexCoord2fColor3fVertex3fvSUN
#define glTexCoord2fColor3fVertex3fvSUN GLMock.TexCoord2fColor3fVertex3fvSUN
#undef glTexCoord2fColor4fNormal3fVertex3fSUN
#define glTexCoord2fColor4fNormal3fVertex3fSUN GLMock.TexCoord2fColor4fNormal3fVertex3fSUN
#undef glTexCoord2fColor4fNormal3fVertex3fvSUN
#define glTexCoord2fColor4fNormal3fVertex3fvSUN GLMock.TexCoord2fColor4fNormal3fVertex3fvSUN
#undef glTexCoord2fColor4ubVertex3fSUN
#define glTexCoord2fColor4ubVertex3fSUN GLMock.TexCoord2fColor4ubVertex3fSUN
#undef glTexCoord2fColor4ubVertex3fvSUN
#define glTexCoord2fColor4ubVertex3fvSUN GLMock.TexCoord2fColor4ubVertex3fvSUN
#undef glTexCoord2fNormal3fVertex3fSUN
#define glTexCoord2fNormal3fVertex3fSUN GLMock.TexCoord2fNormal3fVertex3fSUN
#undef glTexCoord2fNormal3fVertex3fvSUN
#define glTexCoord2fNormal3fVertex3fvSUN GLMock.TexCoord2fNormal3fVertex3fvSUN
#undef glTexCoord2fVertex3fSUN
#define glTexCoord2fVertex3fSUN GLMock.TexCoord2fVertex3fSUN
#undef glTexCoord2fVertex3fvSUN
#define glTexCoord2fVertex3fvSUN GLMock.TexCoord2fVertex3fvSUN
#undef glTexCoord4fColor4fNormal3fVertex4fSUN
#define glTexCoord4fColor4fNormal3fVertex4fSUN GLMock.TexCoord4fColor4fNormal3fVertex4fSUN
#undef glTexCoord4fColor4fNormal3fVertex4fvSUN
#define glTexCoord4fColor4fNormal3fVertex4fvSUN GLMock.TexCoord4fColor4fNormal3fVertex4fvSUN
#undef glTexCoord4fVertex4fSUN
#define glTexCoord4fVertex4fSUN GLMock.TexCoord4fVertex4fSUN
#undef glTexCoord4fVertex4fvSUN
#define glTexCoord4fVertex4fvSUN GLMock.TexCoord4fVertex4fvSUN
#undef glAddSwapHintRectWIN
#define glAddSwapHintRectWIN GLMock.AddSwapHintRectWIN
#undef gluBeginCurve
#define gluBeginCurve GLMock.BeginCurve
#undef gluBeginPolygon
#define gluBeginPolygon GLMock.BeginPolygon
#undef gluBeginSurface
#define gluBeginSurface GLMock.BeginSurface
#undef gluBeginTrim
#define gluBeginTrim GLMock.BeginTrim
#undef gluBuild1DMipmapLevels
#define gluBuild1DMipmapLevels GLMock.Build1DMipmapLevels
#undef gluBuild1DMipmaps
#define gluBuild1DMipmaps GLMock.Build1DMipmaps
#undef gluBuild2DMipmapLevels
#define gluBuild2DMipmapLevels GLMock.Build2DMipmapLevels
#undef gluBuild2DMipmaps
#define gluBuild2DMipmaps GLMock.Build2DMipmaps
#undef gluBuild3DMipmapLevels
#define gluBuild3DMipmapLevels GLMock.Build3DMipmapLevels
#undef gluBuild3DMipmaps
#define gluBuild3DMipmaps GLMock.Build3DMipmaps
#undef gluCheckExtension
#define gluCheckExtension GLMock.CheckExtension
#undef gluCylinder
#define gluCylinder GLMock.Cylinder
#undef gluDeleteNurbsRenderer
#define gluDeleteNurbsRenderer GLMock.DeleteNurbsRenderer
#undef gluDeleteQuadric
#define gluDeleteQuadric GLMock.DeleteQuadric
#undef gluDeleteTess
#define gluDeleteTess GLMock.DeleteTess
#undef gluDisk
#define gluDisk GLMock.Disk
#undef gluEndCurve
#define gluEndCurve GLMock.EndCurve
#undef gluEndPolygon
#define gluEndPolygon GLMock.EndPolygon
#undef gluEndSurface
#define gluEndSurface GLMock.EndSurface
#undef gluEndTrim
#define gluEndTrim GLMock.EndTrim
#undef gluErrorString
#define gluErrorString GLMock.ErrorString
#undef gluGetNurbsProperty
#define gluGetNurbsProperty GLMock.GetNurbsProperty
#undef gluGetString
#define gluGetString GLMock.GetString
#undef gluGetTessProperty
#define gluGetTessProperty GLMock.GetTessProperty
#undef gluLoadSamplingMatrices
#define gluLoadSamplingMatrices GLMock.LoadSamplingMatrices
#undef gluLookAt
#define gluLookAt GLMock.LookAt
#undef gluNewNurbsRenderer
#define gluNewNurbsRenderer GLMock.NewNurbsRenderer
#undef gluNewQuadric
#define gluNewQuadric GLMock.NewQuadric
#undef gluNewTess
#define gluNewTess GLMock.NewTess
#undef gluNextContour
#define gluNextContour GLMock.NextContour
#undef gluNurbsCallback
#define gluNurbsCallback GLMock.NurbsCallback
#undef gluNurbsCallbackData
#define gluNurbsCallbackData GLMock.NurbsCallbackData
#undef gluNurbsCallbackDataEXT
#define gluNurbsCallbackDataEXT GLMock.NurbsCallbackDataEXT
#undef gluNurbsCurve
#define gluNurbsCurve GLMock.NurbsCurve
#undef gluNurbsProperty
#define gluNurbsProperty GLMock.NurbsProperty
#undef gluNurbsSurface
#define gluNurbsSurface GLMock.NurbsSurface
#undef gluOrtho2D
#define gluOrtho2D GLMock.Ortho2D
#undef gluPartialDisk
#define gluPartialDisk GLMock.PartialDisk
#undef gluPerspective
#define gluPerspective GLMock.Perspective
#undef gluPickMatrix
#define gluPickMatrix GLMock.PickMatrix
#undef gluProject
#define gluProject GLMock.Project
#undef gluPwlCurve
#define gluPwlCurve GLMock.PwlCurve
#undef gluQuadricCallback
#define gluQuadricCallback GLMock.QuadricCallback
#undef gluQuadricDrawStyle
#define gluQuadricDrawStyle GLMock.QuadricDrawStyle
#undef gluQuadricNormals
#define gluQuadricNormals GLMock.QuadricNormals
#undef gluQuadricOrientation
#define gluQuadricOrientation GLMock.QuadricOrientation
#undef gluQuadricTexture
#define gluQuadricTexture GLMock.QuadricTexture
#undef gluScaleImage
#define gluScaleImage GLMock.ScaleImage
#undef gluSphere
#define gluSphere GLMock.Sphere
#undef gluTessBeginContour
#define gluTessBeginContour GLMock.TessBeginContour
#undef gluTessBeginPolygon
#define gluTessBeginPolygon GLMock.TessBeginPolygon
#undef gluTessCallback
#define gluTessCallback GLMock.TessCallback
#undef gluTessEndContour
#define gluTessEndContour GLMock.TessEndContour
#undef gluTessEndPolygon
#define gluTessEndPolygon GLMock.TessEndPolygon
#undef gluTessNormal
#define gluTessNormal GLMock.TessNormal
#undef gluTessProperty
#define gluTessProperty GLMock.TessProperty
#undef gluTessVertex
#define gluTessVertex GLMock.TessVertex
#undef gluUnProject
#define gluUnProject GLMock.UnProject
#undef gluUnProject4
#define gluUnProject4 GLMock.UnProject4


#endif /* GLMOCK_H_ */

