// Copyright 2024 The Fuchsia Authors
//
// Licensed under a BSD-style license <LICENSE-BSD>, Apache License, Version 2.0
// <LICENSE-APACHE or https://www.apache.org/licenses/LICENSE-2.0>, or the MIT
// license <LICENSE-MIT or https://opensource.org/licenses/MIT>, at your option.
// This file may not be copied, modified, or distributed except according to
// those terms.

include!("../include.rs");

use util::AU16;
use zerocopy::try_transmute_ref;

// `try_transmute_ref!` does not support transmuting from a smaller type to a
// larger one.
fn main() {
    let _increase_size: Result<&AU16, _> = try_transmute_ref!(&[0u8; 2]);
}
