/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.time.packet;

import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IqBuilder;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smackx.time.packet.Time;
import org.jivesoftware.smackx.time.packet.TimeView;
import org.jxmpp.util.XmppDateTime;

public class TimeBuilder
extends IqBuilder<TimeBuilder, Time>
implements TimeView {
    private ZonedDateTime zonedDateTime;

    TimeBuilder(IqData iqCommon) {
        super(iqCommon);
    }

    TimeBuilder(XMPPConnection connection) {
        super(connection);
    }

    TimeBuilder(String stanzaId) {
        super(stanzaId);
    }

    @Override
    public ZonedDateTime getZonedDateTime() {
        return this.zonedDateTime;
    }

    public TimeBuilder set(ZonedDateTime zonedDateTime) {
        this.zonedDateTime = zonedDateTime;
        return this.getThis();
    }

    public TimeBuilder setUtcAndTzo(String utc, String tzo) throws ParseException {
        Instant instant = XmppDateTime.parseDate(utc).toInstant();
        ZoneId zoneId = ZoneId.of(tzo);
        this.zonedDateTime = instant.atZone(zoneId);
        return this.getThis();
    }

    public TimeBuilder setTime(Calendar calendar) {
        this.zonedDateTime = ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        return this.getThis();
    }

    @Override
    public Time build() {
        return new Time(this);
    }

    @Override
    public TimeBuilder getThis() {
        return this;
    }
}

