/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.search.ReportedData;
import org.jivesoftware.smackx.search.SimpleUserSearch;
import org.jivesoftware.smackx.search.UserSearch;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.form.Form;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.DomainBareJid;

public final class UserSearchManager
extends Manager {
    private static final Map<XMPPConnection, UserSearchManager> INSTANCES = new WeakHashMap<XMPPConnection, UserSearchManager>();

    public static synchronized UserSearchManager getInstanceFor(XMPPConnection connection) {
        UserSearchManager userSearchManager = INSTANCES.get(connection);
        if (userSearchManager == null) {
            userSearchManager = new UserSearchManager(connection);
            INSTANCES.put(connection, userSearchManager);
        }
        return userSearchManager;
    }

    private UserSearchManager(XMPPConnection connection) {
        super(connection);
    }

    public Form getSearchForm(DomainBareJid searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        UserSearch search = new UserSearch();
        search.setType(IQ.Type.get);
        search.setTo(searchService);
        Object response = this.connection().sendIqRequestAndWaitForResponse(search);
        DataForm dataForm = DataForm.from(response, "jabber:iq:search");
        return new Form(dataForm);
    }

    public ReportedData search(FillableForm filledForm, DomainBareJid searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        UserSearch search = new UserSearch();
        search.setType(IQ.Type.set);
        search.setTo(searchService);
        search.addExtension(filledForm.getDataFormToSubmit());
        Object response = this.connection().sendIqRequestAndWaitForResponse(search);
        return ReportedData.getReportedDataFrom(response);
    }

    public ReportedData sendSimpleSearchForm(DataForm searchForm, DomainBareJid searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        SimpleUserSearch search = new SimpleUserSearch();
        search.setForm(searchForm);
        search.setType(IQ.Type.set);
        search.setTo(searchService);
        SimpleUserSearch response = (SimpleUserSearch)this.connection().sendIqRequestAndWaitForResponse(search);
        return response.getReportedData();
    }

    public static List<DomainBareJid> getSearchServices(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ServiceDiscoveryManager discoManager = ServiceDiscoveryManager.getInstanceFor(connection);
        return discoManager.findServices("jabber:iq:search", false, true);
    }
}

