/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.dox.resolver.minidns;

import java.io.IOException;
import org.jivesoftware.smackx.dox.DnsOverXmppResolver;
import org.minidns.DnsClient;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.dnssec.DnssecClient;
import org.minidns.dnssec.DnssecQueryResult;

public final class DnsOverXmppMiniDnsResolver
implements DnsOverXmppResolver {
    public static final DnsOverXmppMiniDnsResolver INSTANCE = new DnsOverXmppMiniDnsResolver(new DnsClient(), new DnssecClient());
    private final DnsClient dnsClient;
    private final DnssecClient dnssecClient;

    DnsOverXmppMiniDnsResolver(DnsClient dnsClient, DnssecClient dnssecClient) {
        this.dnsClient = dnsClient;
        this.dnssecClient = dnssecClient;
    }

    @Override
    public DnsMessage resolve(DnsMessage query) throws IOException {
        DnsQueryResult dnsQueryResult;
        Question question = query.getQuestion();
        if (query.isDnssecOk()) {
            DnssecQueryResult dnssecQueryResult = this.dnssecClient.queryDnssec(question);
            dnsQueryResult = dnssecQueryResult.dnsQueryResult;
        } else {
            dnsQueryResult = this.dnsClient.query(question);
        }
        return dnsQueryResult.response;
    }
}

