/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.DefaultLocationInFileProvider;
import org.eclipse.xtext.resource.ILocationInFileProviderExtension;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.conversion.XbaseQualifiedNameInStaticImportValueConverter;
import org.eclipse.xtext.xbase.util.FeatureCallAsTypeLiteralHelper;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XtypePackage;

@Singleton
public class XbaseLocationInFileProvider
extends DefaultLocationInFileProvider {
    @Inject
    private FeatureCallAsTypeLiteralHelper typeLiteralHelper;
    @Inject
    private XbaseQualifiedNameInStaticImportValueConverter qualifiedNameInStaticImportValueConverter;

    public ITextRegion getSignificantTextRegion(EObject element) {
        XAbstractFeatureCall typeLiteral;
        if (element instanceof XAbstractFeatureCall && (typeLiteral = this.typeLiteralHelper.getRootTypeLiteral((XAbstractFeatureCall)element)) != null) {
            XAbstractFeatureCall target;
            if (typeLiteral instanceof XMemberFeatureCall && (target = (XAbstractFeatureCall)((XMemberFeatureCall)typeLiteral).getMemberCallTarget()).isTypeLiteral()) {
                return super.getSignificantTextRegion((EObject)typeLiteral);
            }
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)typeLiteral);
            if (node != null) {
                return this.toZeroBasedRegion(node.getTextRegionWithLineInformation());
            }
        }
        return super.getSignificantTextRegion(element);
    }

    protected ITextRegion getLocationOfCrossReference(EObject owner, EReference reference, int indexInList, boolean isSignificant) {
        List nodes;
        if (owner instanceof XMemberFeatureCall && reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE && ((XMemberFeatureCall)owner).isTypeLiteral()) {
            List featureNodes = NodeModelUtils.findNodesForFeature((EObject)owner, (EStructuralFeature)reference);
            ITextRegion result = ITextRegion.EMPTY_REGION;
            if (!featureNodes.isEmpty()) {
                INode featureNode = (INode)featureNodes.get(0);
                result = result.merge((ITextRegion)this.toZeroBasedRegion(featureNode.getTextRegionWithLineInformation()));
                List targetNodes = NodeModelUtils.findNodesForFeature((EObject)owner, (EStructuralFeature)XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET);
                if (!targetNodes.isEmpty()) {
                    INode targetNode = (INode)targetNodes.get(0);
                    result = result.merge((ITextRegion)this.toZeroBasedRegion(targetNode.getTextRegionWithLineInformation()));
                }
                return result;
            }
        }
        if (isSignificant && owner instanceof XImportDeclaration && reference == XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE && !(nodes = NodeModelUtils.findNodesForFeature((EObject)owner, (EStructuralFeature)reference)).isEmpty()) {
            INode qualifierNode = (INode)nodes.get(0);
            ITextRegion result = ITextRegion.EMPTY_REGION;
            INode pending = null;
            String delimiter = this.qualifiedNameInStaticImportValueConverter.getStringNamespaceDelimiter();
            for (INode node : qualifierNode.getLeafNodes()) {
                int length;
                if (this.isHidden(node) || (length = node.getLength()) == 0) continue;
                if (pending != null) {
                    result.merge((ITextRegion)this.toZeroBasedRegion(pending.getTextRegionWithLineInformation()));
                    pending = null;
                }
                if (delimiter.equals(node.getText())) {
                    pending = node;
                    continue;
                }
                result = result.merge((ITextRegion)this.toZeroBasedRegion(node.getTextRegionWithLineInformation()));
            }
            return result;
        }
        return super.getLocationOfCrossReference(owner, reference, indexInList, isSignificant);
    }

    protected ITextRegion getLocationOfContainmentReference(EObject owner, EReference reference, int indexInList, ILocationInFileProviderExtension.RegionDescription query) {
        XMemberFeatureCall casted;
        if (owner instanceof XMemberFeatureCall && reference == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET && ((casted = (XMemberFeatureCall)owner).isExplicitStatic() || casted.isStaticWithDeclaringType())) {
            XExpression target = ((XMemberFeatureCall)owner).getMemberCallTarget();
            return this.getTextRegion(target, query);
        }
        return super.getLocationOfContainmentReference(owner, reference, indexInList, query);
    }

    protected List<INode> getLocationNodes(EObject obj) {
        if (obj instanceof XMemberFeatureCall || obj instanceof XAssignment || obj instanceof XFeatureCall) {
            ArrayList resultNodes = Lists.newArrayList();
            ICompositeNode startNode = this.findNodeFor(obj);
            boolean crossRefConsumed = false;
            for (INode child : startNode.getChildren()) {
                if (crossRefConsumed) {
                    resultNodes.add(child);
                    continue;
                }
                EObject grammarElement = child.getGrammarElement();
                if (!(grammarElement instanceof CrossReference)) continue;
                Assignment assignment = GrammarUtil.containingAssignment((EObject)grammarElement);
                if (!XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE.getName().equals(assignment.getFeature())) continue;
                crossRefConsumed = true;
                resultNodes.add(child);
            }
            if (!resultNodes.isEmpty()) {
                return resultNodes;
            }
        }
        return super.getLocationNodes(obj);
    }

    protected boolean useKeyword(Keyword keyword, EObject context) {
        return false;
    }
}

