--

set_option tactic.hygienic false in
theorem ex1 {a p q r : Prop} : p → (p → q) → (q → r) → r := by
intro _ h1 h2;
apply h2;
apply h1;
exact a_1 -- Bad practice, using name generated by `intro`.

theorem ex2 {a p q r : Prop} : p → (p → q) → (q → r) → r := by
intro _ h1 h2;
apply h2;
apply h1;
exact a_1 -- error "unknown identifier"

theorem ex3 {a p q r : Prop} : p → (p → q) → (q → r) → r := by
intro _ h1 h2;
apply h2;
apply h1;
assumption

example {p q : Prop} (h₁ : p → q) (h₂ : p ∨ q) : q := by
  cases h₂;
  { apply h₁; exact h }; -- error "unknown identifier"
  exact h

set_option tactic.hygienic false in
example {p q : Prop} (h₁ : p → q) (h₂ : p ∨ q) : q := by
cases h₂;
{ apply h₁; exact h }; -- hygiene is disabled
exact h

-- Hygienic versions
example {p q : Prop} (h₁ : p → q) (h₂ : p ∨ q) : q := by
cases h₂ with
| inl h => apply h₁; exact h
| inr h => exact h

example {p q : Prop} (h₁ : p → q) (h₂ : p ∨ q) : q := by
cases h₂;
{ apply h₁; assumption };
assumption

example {p q : Prop} (h₁ : p → q) (h₂ : p ∨ q) : q := by
match h₂ with
| Or.inl _ => apply h₁; assumption
| Or.inr h => exact h

example {p q : Prop} (h₁ : p → q) (h₂ : p ∨ q) : q := by unhygienic
  cases h₂
  { apply h₁; exact h } -- hygiene is disabled
  exact h
