/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.type;

import com.google.common.io.Files;
import java.io.File;
import java.util.HashSet;
import java.util.function.Consumer;
import org.gradle.api.artifacts.type.ArtifactTypeContainer;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.artifacts.TransformRegistration;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.artifacts.type.DefaultArtifactTypeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.reflect.Instantiator;

public class DefaultArtifactTypeRegistry
implements ArtifactTypeRegistry {
    private final Instantiator instantiator;
    private final ImmutableAttributesFactory attributesFactory;
    private final CollectionCallbackActionDecorator callbackActionDecorator;
    private final VariantTransformRegistry transformRegistry;
    private final AttributeContainerInternal defaultArtifactAttributes;
    private ArtifactTypeContainer artifactTypeDefinitions;

    public DefaultArtifactTypeRegistry(Instantiator instantiator, ImmutableAttributesFactory attributesFactory, CollectionCallbackActionDecorator callbackActionDecorator, VariantTransformRegistry transformRegistry) {
        this.instantiator = instantiator;
        this.attributesFactory = attributesFactory;
        this.callbackActionDecorator = callbackActionDecorator;
        this.transformRegistry = transformRegistry;
        this.defaultArtifactAttributes = attributesFactory.mutable();
    }

    @Override
    public void visitArtifactTypes(Consumer<? super ImmutableAttributes> action) {
        Consumer<ImmutableAttributes> visitor = attributes -> {
            ImmutableAttributes attributesPlusDefaults = this.attributesFactory.concat(this.defaultArtifactAttributes.asImmutable(), attributes);
            action.accept(attributesPlusDefaults);
        };
        HashSet<String> seen = new HashSet<String>();
        if (this.artifactTypeDefinitions != null) {
            for (ArtifactTypeDefinition artifactTypeDefinition : this.artifactTypeDefinitions) {
                if (!seen.add(artifactTypeDefinition.getName())) continue;
                ImmutableAttributes attributes2 = ((AttributeContainerInternal)artifactTypeDefinition.getAttributes()).asImmutable();
                attributes2 = this.attributesFactory.concat(this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)artifactTypeDefinition.getName()), attributes2);
                visitor.accept(attributes2);
            }
        }
        for (TransformRegistration registration : this.transformRegistry.getRegistrations()) {
            ImmutableAttributes sourceAttributes = registration.getFrom();
            String format = (String)sourceAttributes.getAttribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE);
            if (format == null || !seen.add(format)) continue;
            ImmutableAttributes attributes3 = this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)format);
            visitor.accept(attributes3);
        }
        if (seen.add("directory")) {
            ImmutableAttributes directory = this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
            visitor.accept(directory);
        }
    }

    @Override
    public AttributeContainer getDefaultArtifactAttributes() {
        return this.defaultArtifactAttributes;
    }

    public ArtifactTypeContainer create() {
        if (this.artifactTypeDefinitions == null) {
            this.artifactTypeDefinitions = (ArtifactTypeContainer)this.instantiator.newInstance(DefaultArtifactTypeContainer.class, new Object[]{this.instantiator, this.attributesFactory, this.callbackActionDecorator});
        }
        return this.artifactTypeDefinitions;
    }

    @Override
    public ImmutableAttributes mapAttributesFor(File file) {
        ImmutableAttributes withoutDefaultAttributes = this.mapWithoutDefaultAttributesFor(file);
        return this.attributesFactory.concat(this.defaultArtifactAttributes.asImmutable(), withoutDefaultAttributes);
    }

    private ImmutableAttributes mapWithoutDefaultAttributesFor(File file) {
        if (file.isDirectory()) {
            return this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
        }
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        String extension = Files.getFileExtension((String)file.getName());
        if (this.artifactTypeDefinitions != null) {
            attributes = this.applyForExtension(attributes, extension);
        }
        return this.attributesFactory.concat(this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)extension), attributes);
    }

    @Override
    public ImmutableAttributes mapAttributesFor(ImmutableAttributes attributes, Iterable<? extends ComponentArtifactMetadata> artifacts) {
        ImmutableAttributes withoutDefaultAttributes = this.mapWithoutDefaultAttributesFor(attributes, artifacts);
        return this.attributesFactory.concat(this.defaultArtifactAttributes.asImmutable(), withoutDefaultAttributes);
    }

    private ImmutableAttributes mapWithoutDefaultAttributesFor(ImmutableAttributes attributes, Iterable<? extends ComponentArtifactMetadata> artifacts) {
        if (this.artifactTypeDefinitions != null) {
            String extension = null;
            for (ComponentArtifactMetadata componentArtifactMetadata : artifacts) {
                String candidateExtension = componentArtifactMetadata.getName().getExtension();
                if (extension == null) {
                    extension = candidateExtension;
                    continue;
                }
                if (extension.equals(candidateExtension)) continue;
                extension = null;
                break;
            }
            if (extension != null) {
                attributes = this.applyForExtension(attributes, extension);
            }
        }
        if (!attributes.contains(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE)) {
            String format = null;
            for (ComponentArtifactMetadata componentArtifactMetadata : artifacts) {
                String candidateFormat = componentArtifactMetadata.getName().getType();
                if (format == null) {
                    format = candidateFormat;
                    continue;
                }
                if (format.equals(candidateFormat)) continue;
                format = null;
                break;
            }
            if (format != null) {
                attributes = this.attributesFactory.concat(attributes.asImmutable(), ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, format);
            }
        }
        return attributes;
    }

    private ImmutableAttributes applyForExtension(ImmutableAttributes attributes, String extension) {
        ArtifactTypeDefinition definition = (ArtifactTypeDefinition)this.artifactTypeDefinitions.findByName(extension);
        if (definition != null) {
            attributes = this.attributesFactory.concat(((AttributeContainerInternal)definition.getAttributes()).asImmutable(), attributes);
        }
        return attributes;
    }
}

