/*******************************************************************************
 * Copyright (c) Contributors to the Eclipse Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0 
 *******************************************************************************/
package org.osgi.service.feature;

import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * An Artifact is an entity with an ID, for use in extensions.
 * 
 * @ThreadSafe
 */
@ProviderType
public interface FeatureArtifact {
    /**
     * Get the artifact's ID.
     * @return The ID of this artifact.
     */
    ID getID();

	/**
	 * Get the metadata for this artifact.
	 * 
	 * @return The metadata. The returned map is unmodifiable.
	 */
	Map<String,Object> getMetadata();
}
