#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "map.h"
#include "companies.h"
#include "vars.h"

extern tiles_t *tiles;
extern map_t *map;
extern game_t *game;
extern companies_t *companies;

extern int
vars_company_getvariable(char *name, void *rock)
{
    company_t *c = (company_t *)rock;

    if (strcasecmp(name, "workers") == 0) {
	return company_numemploy(c);

    } else if (strcasecmp(name, "maxworkers") == 0) {
	return tiles_getnumemploy(tiles, c->obj);

    } else if (strcasecmp(name, "hirecost") == 0) {
	return HIRECOST;	    

    } else {
	return -1;
    }
}

extern int
vars_population_getvariable(char *name, void *rock)
{
    if (strcasecmp(name, "numjobs") == 0) {
	return companies_total_positions(companies);
    } else if (strcasecmp(name, "avghappiness") == 0) {
	return (int)game->avghappy;
    } else if (strcasecmp(name, "population") == 0) {
	return game->totalpop;
    } else if (strcasecmp(name, "vacancies") == 0) {
	return game->vacancies;
    } else if (strcasecmp(name, "jobsavail") == 0) {
	return labor_count(&game->jobsavail);
    } else if (strcasecmp(name, "num_homeless") == 0) {
	return game->homeless;
    } else if (strcasecmp(name, "num_needhousing") == 0) {
	return game->homeless - game->vacancies;
    } else if (strcasecmp(name, "num_needjobs") == 0) {
	return labor_count(&game->needjobs);
    } else if (strcasecmp(name, "GDP") == 0) {
	return game->month_gdp;
    } else if (strcasecmp(name, "peopleleft") == 0) {
	return game->left_lastmonth;
    } else if (strcasecmp(name, "population_change") == 0) {
	return game->popchange_lastmonth;
    } else {
	return -1;
    }
}


extern int
vars_getvariable(char *name, void *rock)
{
    vars_t *vars = (vars_t *)rock;
    int r;

    r = vars_population_getvariable(name, NULL);
    if (r != -1) return r;

    if (vars->c) {
	r = vars_company_getvariable(name, vars->c);
	if (r != -1) return r;
    }
    
    if (vars->map) {
	return map_getvariable_cb(name, vars->map, vars->mapx, vars->mapy);
    }

    printf(_("variable not understood: %s\n"), name);
    return 0;
}
