#ifndef ATL_dtGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,176,327,364,402,440,478,516,554,592,630,667,705,743,781,819,857,895,933,1084,1236,1387,1539,1690,1842,2145,2448,3660,4872,6084,7296,8508,9720
 * N : 25,176,327,364,402,440,478,516,554,592,630,667,705,743,781,819,857,895,933,1084,1236,1387,1539,1690,1842,2145,2448,3660,4872,6084,7296,8508,9720
 * NB : 1,1,11,43,51,53,59,58,65,66,67,67,68,68,71,72,74,74,75,76,83,83,107,107,111,112,115,127,131,147,243,242,259
 */
#define ATL_dtGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 251) (nb_) = 1; \
   else if ((n_) < 345) (nb_) = 11; \
   else if ((n_) < 383) (nb_) = 43; \
   else if ((n_) < 421) (nb_) = 51; \
   else if ((n_) < 459) (nb_) = 53; \
   else if ((n_) < 497) (nb_) = 59; \
   else if ((n_) < 535) (nb_) = 58; \
   else if ((n_) < 573) (nb_) = 65; \
   else if ((n_) < 611) (nb_) = 66; \
   else if ((n_) < 686) (nb_) = 67; \
   else if ((n_) < 762) (nb_) = 68; \
   else if ((n_) < 800) (nb_) = 71; \
   else if ((n_) < 838) (nb_) = 72; \
   else if ((n_) < 914) (nb_) = 74; \
   else if ((n_) < 1008) (nb_) = 75; \
   else if ((n_) < 1160) (nb_) = 76; \
   else if ((n_) < 1463) (nb_) = 83; \
   else if ((n_) < 1766) (nb_) = 107; \
   else if ((n_) < 1993) (nb_) = 111; \
   else if ((n_) < 2296) (nb_) = 112; \
   else if ((n_) < 3054) (nb_) = 115; \
   else if ((n_) < 4266) (nb_) = 127; \
   else if ((n_) < 5478) (nb_) = 131; \
   else if ((n_) < 6690) (nb_) = 147; \
   else if ((n_) < 7902) (nb_) = 243; \
   else if ((n_) < 9114) (nb_) = 242; \
   else (nb_) = 259; \
}


#endif    /* end ifndef ATL_dtGetNB_geqrf */
