/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.commons.java.datastructure;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TrackedMap
extends HashMap {
    private Map _tracked;

    public TrackedMap() {
        this((Map)new HashMap());
    }

    public TrackedMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TrackedMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TrackedMap(Map map) {
        this._tracked = map;
    }

    public boolean hasChanges() {
        return this.getChangedKeySet().size() > 0;
    }

    public Set getChangedKeySet() {
        return super.keySet();
    }

    public Object get(Object key) {
        if (this.containsKey(key)) {
            return super.get(key);
        }
        return this._tracked.get(key);
    }

    public void makeUpToDate() {
        Iterator it = super.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object o = super.get(key);
            this._tracked.put(key, o);
        }
        super.clear();
    }

    public void clearChanges() {
        super.clear();
    }

    public void clear() {
        super.clear();
        this._tracked.clear();
    }

    public boolean containsKey(Object key) {
        return super.containsKey(key) || this._tracked.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return super.containsValue(value) || this._tracked.containsValue(value);
    }

    public Set entrySet() {
        HashSet s = new HashSet(this._tracked.entrySet());
        s.addAll(super.entrySet());
        return s;
    }

    public boolean isEmpty() {
        return super.isEmpty() && this._tracked.isEmpty();
    }

    public Set keySet() {
        HashSet s = new HashSet(this._tracked.keySet());
        s.addAll(super.keySet());
        return s;
    }

    public Object remove(Object key) {
        Object o = this.get(key);
        this.put(key, null);
        return o;
    }

    public int size() {
        return this.keySet().size();
    }

    public Collection values() {
        HashSet set = new HashSet(this._tracked.values());
        set.addAll(super.values());
        return set;
    }
}

