/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginElement;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.xml.IntegrityChecker;
import org.java.plugin.registry.xml.ModelExtension;
import org.java.plugin.registry.xml.ModelParameter;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginElementImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;

final class ExtensionImpl
extends PluginElementImpl
implements Extension {
    private final ModelExtension model;
    private List parameters;
    private Boolean isValid;

    ExtensionImpl(PluginDescriptorImpl pluginDescriptorImpl, PluginFragmentImpl pluginFragmentImpl, ModelExtension modelExtension) throws ManifestProcessingException {
        super(pluginDescriptorImpl, pluginFragmentImpl, modelExtension.getId(), modelExtension.getDocumentation());
        this.model = modelExtension;
        if (this.model.getPluginId() == null || this.model.getPluginId().trim().length() == 0) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "extensionIdIsBlank", pluginDescriptorImpl.getId());
        }
        if (this.model.getPointId() == null || this.model.getPointId().trim().length() == 0) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "extendedPointIdIsBlank", pluginDescriptorImpl.getId());
        }
        this.parameters = new ArrayList(this.model.getParams().size());
        Iterator iterator = this.model.getParams().iterator();
        while (iterator.hasNext()) {
            this.parameters.add(new ParameterImpl(null, (ModelParameter)iterator.next()));
        }
        this.parameters = Collections.unmodifiableList(this.parameters);
        this.log.debug("object instantiated: " + this);
    }

    public String getUniqueId() {
        return this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.getDeclaringPluginDescriptor().getId(), this.getId());
    }

    public Collection getParameters() {
        return this.parameters;
    }

    public Extension.Parameter getParameter(String string) {
        ParameterImpl parameterImpl = null;
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            ParameterImpl parameterImpl2 = (ParameterImpl)iterator.next();
            if (!parameterImpl2.getId().equals(string)) continue;
            if (parameterImpl == null) {
                parameterImpl = parameterImpl2;
                continue;
            }
            throw new IllegalArgumentException("more than one parameter with ID " + string + " defined in extension " + this.getUniqueId());
        }
        return parameterImpl;
    }

    public Collection getParameters(String string) {
        LinkedList<ParameterImpl> linkedList = new LinkedList<ParameterImpl>();
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            ParameterImpl parameterImpl = (ParameterImpl)iterator.next();
            if (!parameterImpl.getId().equals(string)) continue;
            linkedList.add(parameterImpl);
        }
        return Collections.unmodifiableList(linkedList);
    }

    public String getExtendedPluginId() {
        return this.model.getPluginId();
    }

    public String getExtendedPointId() {
        return this.model.getPointId();
    }

    public boolean isValid() {
        if (this.isValid == null) {
            this.validate();
        }
        return this.isValid;
    }

    Collection validate() {
        if (!this.getDeclaringPluginDescriptor().getRegistry().isExtensionPointAvailable(this.getExtendedPluginId(), this.getExtendedPointId())) {
            this.isValid = Boolean.FALSE;
            return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 6, "extPointNotAvailable", new Object[]{this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.getExtendedPluginId(), this.getExtendedPointId()), this.getUniqueId()}));
        }
        Collection collection = this.validateParameters(this.getDeclaringPluginDescriptor().getRegistry().getExtensionPoint(this.getExtendedPluginId(), this.getExtendedPointId()).getParameterDefinitions(), (Collection)this.parameters);
        this.isValid = collection.isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        return collection;
    }

    private Collection validateParameters(Collection collection, Collection collection2) {
        Object object;
        PluginElement pluginElement;
        LinkedList<IntegrityChecker.ReportItemImpl> linkedList = new LinkedList<IntegrityChecker.ReportItemImpl>();
        HashMap hashMap = new HashMap();
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            pluginElement = (Extension.Parameter)iterator.next();
            object = pluginElement.getDefinition();
            if (object == null) {
                linkedList.add(new IntegrityChecker.ReportItemImpl(1, this, 6, "cantDetectParameterDef", new Object[]{pluginElement.getId(), this.getUniqueId()}));
                continue;
            }
            if (hashMap.containsKey(pluginElement.getId())) {
                ((Collection)hashMap.get(pluginElement.getId())).add(pluginElement);
                continue;
            }
            LinkedList<PluginElement> linkedList2 = new LinkedList<PluginElement>();
            linkedList2.add(pluginElement);
            hashMap.put(pluginElement.getId(), linkedList2);
        }
        if (!linkedList.isEmpty()) {
            return linkedList;
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (Collection)hashMap.get((pluginElement = (ExtensionPoint.ParameterDefinition)iterator.next()).getId());
            linkedList.addAll(this.validateParameters((ExtensionPoint.ParameterDefinition)pluginElement, (Collection)(object != null ? object : Collections.EMPTY_LIST)));
        }
        return linkedList;
    }

    private Collection validateParameters(ExtensionPoint.ParameterDefinition parameterDefinition, Collection collection) {
        this.log.debug("validating parameters for definition " + parameterDefinition);
        if ("one".equals(parameterDefinition.getMultiplicity()) && collection.size() != 1) {
            return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 6, "tooManyOrFewParams", new Object[]{parameterDefinition.getId(), this.getUniqueId()}));
        }
        if ("none-or-one".equals(parameterDefinition.getMultiplicity()) && collection.size() > 1) {
            return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 6, "tooManyParams", new Object[]{parameterDefinition.getId(), this.getUniqueId()}));
        }
        if ("one-or-more".equals(parameterDefinition.getMultiplicity()) && collection.isEmpty()) {
            return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 6, "tooFewParams", new Object[]{parameterDefinition.getId(), this.getUniqueId()}));
        }
        if (collection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<IntegrityChecker.ReportItemImpl> linkedList = new LinkedList<IntegrityChecker.ReportItemImpl>();
        int n = 1;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ParameterImpl parameterImpl = (ParameterImpl)iterator.next();
            if (!parameterImpl.isValid()) {
                linkedList.add(new IntegrityChecker.ReportItemImpl(1, this, 6, "invalidParameterValue", new Object[]{parameterDefinition.getId(), new Integer(n), this.getUniqueId()}));
            }
            if (!"any".equals(parameterDefinition.getType()) && linkedList.isEmpty()) {
                linkedList.addAll(this.validateParameters(parameterImpl.getDefinition().getSubDefinitions(), parameterImpl.getSubParameters()));
            }
            ++n;
        }
        return linkedList;
    }

    public String toString() {
        return "{PluginExtension: uid=" + this.getUniqueId() + "}";
    }

    void registryChanged() {
        this.isValid = null;
    }

    private class ParameterImpl
    extends PluginElementImpl
    implements Extension.Parameter {
        private final ModelParameter modelParam;
        private Boolean isParamValid;
        private Object valueObj;
        private List subParameters;
        private ExtensionPoint.ParameterDefinition definition = null;
        private boolean definitionDetected = false;
        private final ParameterImpl superParameter;

        ParameterImpl(ParameterImpl parameterImpl, ModelParameter modelParameter) throws ManifestProcessingException {
            super(ExtensionImpl.this.getDeclaringPluginDescriptor(), ExtensionImpl.this.getDeclaringPluginFragment(), modelParameter.getId(), modelParameter.getDocumentation());
            this.superParameter = parameterImpl;
            this.modelParam = modelParameter;
            this.subParameters = new ArrayList(this.modelParam.getParams().size());
            Iterator iterator = this.modelParam.getParams().iterator();
            while (iterator.hasNext()) {
                this.subParameters.add(new ParameterImpl(this, (ModelParameter)iterator.next()));
            }
            this.subParameters = Collections.unmodifiableList(this.subParameters);
            this.log.debug("object instantiated: " + this);
        }

        public Extension getDeclaringExtension() {
            return ExtensionImpl.this;
        }

        public PluginDescriptor getDeclaringPluginDescriptor() {
            return ExtensionImpl.this.getDeclaringPluginDescriptor();
        }

        public PluginFragment getDeclaringPluginFragment() {
            return ExtensionImpl.this.getDeclaringPluginFragment();
        }

        public ExtensionPoint.ParameterDefinition getDefinition() {
            Collection collection;
            if (this.definitionDetected) {
                return this.definition;
            }
            this.definitionDetected = true;
            this.log.debug("detecting definition for parameter " + this);
            if (this.superParameter != null) {
                if (this.superParameter.getDefinition() == null) {
                    return null;
                }
                if ("any".equals(this.superParameter.getDefinition().getType())) {
                    this.definition = this.superParameter.getDefinition();
                    this.log.debug("definition detected - " + this.definition);
                    return this.definition;
                }
                collection = this.superParameter.getDefinition().getSubDefinitions();
            } else {
                collection = this.getDeclaringPluginDescriptor().getRegistry().getExtensionPoint(this.getDeclaringExtension().getExtendedPluginId(), this.getDeclaringExtension().getExtendedPointId()).getParameterDefinitions();
            }
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ExtensionPoint.ParameterDefinition parameterDefinition = (ExtensionPoint.ParameterDefinition)iterator.next();
                if (!parameterDefinition.getId().equals(this.getId())) continue;
                this.definition = parameterDefinition;
                break;
            }
            this.log.debug("definition detected - " + this.definition);
            return this.definition;
        }

        public Extension.Parameter getSuperParameter() {
            return this.superParameter;
        }

        public Collection getSubParameters() {
            return this.subParameters;
        }

        public Extension.Parameter getSubParameter(String string) {
            ParameterImpl parameterImpl = null;
            Iterator iterator = this.subParameters.iterator();
            while (iterator.hasNext()) {
                ParameterImpl parameterImpl2 = (ParameterImpl)iterator.next();
                if (!parameterImpl2.getId().equals(string)) continue;
                if (parameterImpl == null) {
                    parameterImpl = parameterImpl2;
                    continue;
                }
                throw new IllegalArgumentException("more than one parameter with ID " + string + " defined in extension " + ExtensionImpl.this.getUniqueId());
            }
            return parameterImpl;
        }

        public Collection getSubParameters(String string) {
            LinkedList<ParameterImpl> linkedList = new LinkedList<ParameterImpl>();
            Iterator iterator = this.subParameters.iterator();
            while (iterator.hasNext()) {
                ParameterImpl parameterImpl = (ParameterImpl)iterator.next();
                if (!parameterImpl.getId().equals(string)) continue;
                linkedList.add(parameterImpl);
            }
            return Collections.unmodifiableList(linkedList);
        }

        public String rawValue() {
            return this.modelParam.getValue() != null ? this.modelParam.getValue() : "";
        }

        boolean isValid() {
            if (this.isParamValid != null) {
                return this.isParamValid;
            }
            this.log.debug("validating parameter " + this);
            this.isParamValid = Boolean.FALSE;
            if (this.getDefinition() == null) {
                this.isParamValid = Boolean.FALSE;
                this.log.warn("can't detect definition for parameter " + this);
            } else {
                this.isParamValid = this.modelParam.getValue() != null ? this.parseValue() : Boolean.TRUE;
            }
            return this.isParamValid;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Boolean parseValue() {
            this.log.debug("parsing value for parameter " + this);
            if ("any".equals(this.definition.getType()) || "null".equals(this.definition.getType())) {
                return Boolean.TRUE;
            }
            if ("string".equals(this.definition.getType())) {
                this.valueObj = this.modelParam.getValue();
                return Boolean.TRUE;
            }
            String string = this.modelParam.getValue().trim();
            if (string.length() == 0) {
                return Boolean.TRUE;
            }
            if ("boolean".equals(this.definition.getType())) {
                if ("true".equals(string)) {
                    this.valueObj = Boolean.TRUE;
                    return Boolean.TRUE;
                }
                if ("false".equals(string)) {
                    this.valueObj = Boolean.FALSE;
                    return Boolean.TRUE;
                }
                this.log.error("can't parse value " + string + " of parameter " + this);
                return Boolean.FALSE;
            }
            if ("number".equals(this.definition.getType())) {
                try {
                    this.valueObj = NumberFormat.getInstance(Locale.ENGLISH).parse(string);
                    return Boolean.TRUE;
                }
                catch (ParseException parseException) {
                    this.log.error("can't parse value " + string + " of parameter " + this, parseException);
                    return Boolean.FALSE;
                }
            }
            if ("date".equals(this.definition.getType())) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
                try {
                    this.valueObj = simpleDateFormat.parse(string);
                    return Boolean.TRUE;
                }
                catch (ParseException parseException) {
                    this.log.error("can't parse value " + string + " of parameter " + this, parseException);
                    return Boolean.FALSE;
                }
            }
            if ("time".equals(this.definition.getType())) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.ENGLISH);
                try {
                    this.valueObj = simpleDateFormat.parse(string);
                    return Boolean.TRUE;
                }
                catch (ParseException parseException) {
                    this.log.error("can't parse value " + string + " of parameter " + this, parseException);
                    return Boolean.FALSE;
                }
            }
            if ("date-time".equals(this.definition.getType())) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
                try {
                    this.valueObj = simpleDateFormat.parse(string);
                    return Boolean.TRUE;
                }
                catch (ParseException parseException) {
                    this.log.error("can't parse value " + string + " of parameter " + this, parseException);
                    return Boolean.FALSE;
                }
            }
            if ("plugin-id".equals(this.definition.getType())) {
                try {
                    this.valueObj = this.getDeclaringPluginDescriptor().getRegistry().getPluginDescriptor(string);
                    return Boolean.TRUE;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.log.error("unknown plug-in ID " + string + " provided in parameter " + this, illegalArgumentException);
                    return Boolean.FALSE;
                }
            }
            if ("extension-point-id".equals(this.definition.getType())) {
                ExtensionPoint extensionPoint;
                try {
                    this.valueObj = this.getDeclaringPluginDescriptor().getRegistry().getExtensionPoint(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.log.error("unknown extension point UID " + string + " provided in parameter " + this, illegalArgumentException);
                    return Boolean.FALSE;
                }
                if (this.definition.getCustomData() == null || ((ExtensionPoint)this.valueObj).isSuccessorOf(extensionPoint = this.getDeclaringPluginDescriptor().getRegistry().getExtensionPoint(this.definition.getCustomData()))) return Boolean.TRUE;
                this.log.error("extension point with UID " + string + " provided in parameter " + this + " doesn't \"inherit\" point that is defined" + " according to custom data in parameter" + " definition - " + this.definition.getCustomData());
                return Boolean.FALSE;
            }
            if ("extension-id".equals(this.definition.getType())) {
                ExtensionPoint extensionPoint;
                Object object;
                String string2 = this.getDeclaringPluginDescriptor().getRegistry().extractId(string);
                Object object2 = this.getDeclaringPluginDescriptor().getRegistry().getPluginDescriptor(this.getDeclaringPluginDescriptor().getRegistry().extractPluginId(string)).getExtensions().iterator();
                while (object2.hasNext()) {
                    object = (Extension)object2.next();
                    if (!object.getId().equals(string2)) continue;
                    this.valueObj = object;
                    break;
                }
                if (this.valueObj == null) {
                    this.log.error("unknown extension UID " + string + " provided in parameter " + this);
                    return Boolean.FALSE;
                }
                if (this.definition.getCustomData() == null) return Boolean.TRUE;
                try {
                    object2 = this.getDeclaringPluginDescriptor().getRegistry().getExtensionPoint(this.definition.getCustomData());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.log.error("unknown extension point UID " + this.definition.getCustomData() + " provided as custom data in parameter " + this, illegalArgumentException);
                    return Boolean.FALSE;
                }
                object = this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(((Extension)this.valueObj).getExtendedPluginId(), ((Extension)this.valueObj).getExtendedPointId());
                try {
                    extensionPoint = this.getDeclaringPluginDescriptor().getRegistry().getExtensionPoint((String)object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.log.error("extension point " + (String)object + " is unknown for extension " + ((Extension)this.valueObj).getUniqueId() + ", provided in parameter " + this, illegalArgumentException);
                    return Boolean.FALSE;
                }
                if (extensionPoint.equals(object2) || extensionPoint.isSuccessorOf((ExtensionPoint)object2)) return Boolean.TRUE;
                this.log.error("extension with UID " + string + " provided in parameter " + this + " extends point that not allowed according" + " to custom data defined in parameter" + " definition - " + this.definition.getCustomData());
                return Boolean.FALSE;
            }
            if ("fixed".equals(this.definition.getType())) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.definition.getCustomData(), "|", false);
                while (stringTokenizer.hasMoreTokens()) {
                    if (!string.equals(stringTokenizer.nextToken().trim())) continue;
                    this.valueObj = string;
                    return Boolean.TRUE;
                }
                this.log.error("not allowed value " + string + " provided in parameter " + this);
                return Boolean.FALSE;
            }
            if (!"resource".equals(this.definition.getType())) return Boolean.TRUE;
            try {
                this.valueObj = new URL(string);
                return Boolean.TRUE;
            }
            catch (MalformedURLException malformedURLException) {
                this.log.error("can't parse value " + string + " of parameter " + this, malformedURLException);
                return Boolean.FALSE;
            }
        }

        public Boolean valueAsBoolean() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!"boolean".equals(this.definition.getType())) {
                throw new UnsupportedOperationException("parameter type is not boolean");
            }
            return (Boolean)this.valueObj;
        }

        public Date valueAsDate() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!("date".equals(this.definition.getType()) || "date-time".equals(this.definition.getType()) || "time".equals(this.definition.getType()))) {
                throw new UnsupportedOperationException("parameter type is not date nor date-time nortime");
            }
            return (Date)this.valueObj;
        }

        public Number valueAsNumber() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!"number".equals(this.definition.getType())) {
                throw new UnsupportedOperationException("parameter type is not number");
            }
            return (Number)this.valueObj;
        }

        public String valueAsString() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!"string".equals(this.definition.getType()) && !"fixed".equals(this.definition.getType())) {
                throw new UnsupportedOperationException("parameter type is not string");
            }
            return (String)this.valueObj;
        }

        public Extension valueAsExtension() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!"extension-id".equals(this.definition.getType())) {
                throw new UnsupportedOperationException("parameter type is not extension-id");
            }
            return (Extension)this.valueObj;
        }

        public ExtensionPoint valueAsExtensionPoint() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!"extension-point-id".equals(this.definition.getType())) {
                throw new UnsupportedOperationException("parameter type is not extension-point-id");
            }
            return (ExtensionPoint)this.valueObj;
        }

        public PluginDescriptor valueAsPluginDescriptor() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!"plugin-id".equals(this.definition.getType())) {
                throw new UnsupportedOperationException("parameter type is not plugin-id");
            }
            return (PluginDescriptor)this.valueObj;
        }

        public URL valueAsUrl() {
            return this.valueAsUrl(null);
        }

        public URL valueAsUrl(PathResolver pathResolver) {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!"resource".equals(this.definition.getType())) {
                throw new UnsupportedOperationException("parameter type is not resource");
            }
            URL uRL = (URL)this.valueObj;
            if (pathResolver == null || uRL.getProtocol() != null) {
                return uRL;
            }
            return pathResolver.resolvePath(this.getDeclaringPluginDescriptor(), uRL.getFile());
        }

        public String toString() {
            return "{PluginExtension.Parameter: extUid=" + this.getDeclaringExtension().getUniqueId() + "; id=" + this.getId() + "}";
        }

        protected boolean isEqualTo(Identity identity) {
            if (!super.isEqualTo(identity)) {
                return false;
            }
            ParameterImpl parameterImpl = (ParameterImpl)identity;
            if (this.getSuperParameter() == null && parameterImpl.getSuperParameter() == null) {
                return true;
            }
            if (this.getSuperParameter() == null || parameterImpl.getSuperParameter() == null) {
                return false;
            }
            return this.getSuperParameter().equals(parameterImpl.getSuperParameter());
        }
    }
}

