/* theme-2d-cairo.c generated by valac 0.46.3, the Vala compiler
 * generated from theme-2d-cairo.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2010  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <cairo.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

#define PASANG_TYPE_RGB (pasang_rgb_get_type ())
typedef struct _PasangRgb PasangRgb;

#define PASANG_TYPE_THEME (pasang_theme_get_type ())
#define PASANG_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME, PasangTheme))
#define PASANG_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME, PasangThemeClass))
#define PASANG_IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME))
#define PASANG_IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME))
#define PASANG_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME, PasangThemeClass))

typedef struct _PasangTheme PasangTheme;
typedef struct _PasangThemeClass PasangThemeClass;
typedef struct _PasangThemePrivate PasangThemePrivate;

#define PASANG_TYPE_GAME_VIEW (pasang_game_view_get_type ())
#define PASANG_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME_VIEW, PasangGameView))
#define PASANG_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME_VIEW, PasangGameViewClass))
#define PASANG_IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME_VIEW))
#define PASANG_IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME_VIEW))
#define PASANG_GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME_VIEW, PasangGameViewClass))

typedef struct _PasangGameView PasangGameView;
typedef struct _PasangGameViewClass PasangGameViewClass;
typedef enum  {
	PASANG_PIECE_NULL = -999,
	PASANG_PIECE_KAS_0 = 0,
	PASANG_PIECE_KAS_1 = 1,
	PASANG_PIECE_BLACK = 2,
	PASANG_PIECE_WHITE = 3,
	PASANG_PIECE_COUNT = 4,
	PASANG_PIECE_BOARD = 4,
	PASANG_PIECE_GUARD = 5,
	PASANG_PIECE_GUIDE = 6,
	PASANG_PIECE_EMPTY = 100
} PasangPiece;

#define PASANG_TYPE_PIECE (pasang_piece_get_type ())

#define PASANG_TYPE_POINT (pasang_point_get_type ())
typedef struct _PasangPoint PasangPoint;

#define PASANG_TYPE_GAME (pasang_game_get_type ())
#define PASANG_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME, PasangGame))
#define PASANG_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME, PasangGameClass))
#define PASANG_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME))
#define PASANG_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME))
#define PASANG_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME, PasangGameClass))

typedef struct _PasangGame PasangGame;
typedef struct _PasangGameClass PasangGameClass;

#define PASANG_TYPE_THEME_ITEM (pasang_theme_item_get_type ())
typedef struct _PasangThemeItem PasangThemeItem;

#define PASANG_TYPE_FILM (pasang_film_get_type ())
typedef struct _PasangFilm PasangFilm;

#define PASANG_TYPE_THEME2_D (pasang_theme2_d_get_type ())
#define PASANG_THEME2_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME2_D, PasangTheme2D))
#define PASANG_THEME2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME2_D, PasangTheme2DClass))
#define PASANG_IS_THEME2_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME2_D))
#define PASANG_IS_THEME2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME2_D))
#define PASANG_THEME2_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME2_D, PasangTheme2DClass))

typedef struct _PasangTheme2D PasangTheme2D;
typedef struct _PasangTheme2DClass PasangTheme2DClass;
typedef struct _PasangTheme2DPrivate PasangTheme2DPrivate;

#define PASANG_TYPE_LAYOUT2_D (pasang_layout2_d_get_type ())
typedef struct _PasangLayout2D PasangLayout2D;

#define PASANG_TYPE_THEME2_DCAIRO (pasang_theme2_dcairo_get_type ())
#define PASANG_THEME2_DCAIRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME2_DCAIRO, PasangTheme2DCairo))
#define PASANG_THEME2_DCAIRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME2_DCAIRO, PasangTheme2DCairoClass))
#define PASANG_IS_THEME2_DCAIRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME2_DCAIRO))
#define PASANG_IS_THEME2_DCAIRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME2_DCAIRO))
#define PASANG_THEME2_DCAIRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME2_DCAIRO, PasangTheme2DCairoClass))

typedef struct _PasangTheme2DCairo PasangTheme2DCairo;
typedef struct _PasangTheme2DCairoClass PasangTheme2DCairoClass;
typedef struct _PasangTheme2DCairoPrivate PasangTheme2DCairoPrivate;
typedef void (*PasangTheme2DCairoForgeTableFunction) (cairo_t* cr, gpointer user_data);
typedef void (*PasangTheme2DCairoForgePieceFunction) (cairo_t* cr, PasangPiece piece, gint size, gint f, gpointer user_data);
enum  {
	PASANG_THEME2_DCAIRO_0_PROPERTY,
	PASANG_THEME2_DCAIRO_NUM_PROPERTIES
};
static GParamSpec* pasang_theme2_dcairo_properties[PASANG_THEME2_DCAIRO_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _PasangTheme2DcairoResizeImagesAsyncData PasangTheme2DcairoResizeImagesAsyncData;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
enum  {
	PASANG_THEME2_DCAIRO_CHANGED_SIGNAL,
	PASANG_THEME2_DCAIRO_NUM_SIGNALS
};
static guint pasang_theme2_dcairo_signals[PASANG_THEME2_DCAIRO_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PasangRgb {
	gdouble red;
	gdouble green;
	gdouble blue;
	gdouble alpha;
};

struct _PasangPoint {
	gint x;
	gint y;
};

struct _PasangThemeItem {
	gchar* name;
	gchar* path;
	GdkPixbuf* pixbuf;
	gchar* license;
	gchar* artist;
	gchar* comment;
	PasangTheme* engine;
};

struct _PasangFilm {
	gint stop;
	gint length;
	gint viewed;
	gint n;
};

struct _PasangTheme {
	GObject parent_instance;
	PasangThemePrivate * priv;
	PasangThemeItem* items;
	gint items_length1;
	gint _items_size_;
	PasangFilm* films;
	gint films_length1;
	gint _films_size_;
	gint* cycles;
	gint cycles_length1;
	gint _cycles_size_;
};

struct _PasangThemeClass {
	GObjectClass parent_class;
	PasangTheme* (*select) (PasangTheme* self, const gchar* path, gint width, gint height);
	void (*resize) (PasangTheme* self, gint width, gint height);
	void (*free) (PasangTheme* self);
	void (*draw) (PasangTheme* self, PasangGameView* game_view, cairo_t* cr);
	void (*queue_draw_piece) (PasangTheme* self, GtkDrawingArea* view, PasangPiece piece, PasangPoint* p);
	gint (*count_frames) (PasangTheme* self, PasangPiece piece);
	void (*to_point) (PasangTheme* self, gint pos, gboolean rotated, PasangPoint* result);
	gint (*to_position) (PasangTheme* self, PasangGame* game, PasangPoint* p, gboolean rotated, gboolean precise);
	gint (*to_side) (PasangTheme* self, PasangPoint* p);
};

struct _PasangLayout2D {
	gint x;
	gint y;
	gint width;
	gint height;
	gint board_x;
	gint board_y;
	gint board_size;
	gint score_x[2];
	gint score_y[2];
	gint score_font_size;
	PasangRgb score_color[2];
	gint kas_x[2];
	gint kas_y[2];
	gint kas_frame[2];
	gint num_wins_x[2];
	gint num_wins_y[2];
	gint num_wins_font_size;
	PasangRgb num_wins_color;
	gint num_rounds_x;
	gint num_rounds_y;
	gint num_rounds_format;
	gint num_rounds_font_size;
	PasangRgb num_rounds_color;
	gint filler_left;
	gint filler_top;
	gint filler_right;
	gint filler_bottom;
	gint image_x;
	gint image_y;
	gint image_width;
	gint image_height;
};

struct _PasangTheme2D {
	PasangTheme parent_instance;
	PasangTheme2DPrivate * priv;
	PasangLayout2D default_layout;
	PasangLayout2D layout;
	PasangLayout2D table;
	gboolean layout_changed;
	cairo_surface_t** images;
	gint images_length1;
	gint _images_size_;
	gint* num_rows_in_image;
	gint num_rows_in_image_length1;
	gint _num_rows_in_image_size_;
};

struct _PasangTheme2DClass {
	PasangThemeClass parent_class;
	void (*resize_images) (PasangTheme2D* self);
};

struct _PasangTheme2DCairo {
	PasangTheme2D parent_instance;
	PasangTheme2DCairoPrivate * priv;
};

struct _PasangTheme2DCairoClass {
	PasangTheme2DClass parent_class;
};

struct _PasangTheme2DCairoPrivate {
	gchar* path;
	gint num_frames;
	PasangTheme2DCairoForgeTableFunction forge_table_function;
	gpointer forge_table_function_target;
	GDestroyNotify forge_table_function_target_destroy_notify;
	PasangTheme2DCairoForgePieceFunction forge_piece_function;
	gpointer forge_piece_function_target;
	GDestroyNotify forge_piece_function_target_destroy_notify;
	PasangRgb spin_color;
	PasangRgb dizzy_color;
	PasangRgb tv_color;
	PasangRgb shiny_color;
	PasangRgb flower_color;
	gint ticket;
	cairo_surface_t* flower_texture;
	gdouble* stars;
	gint stars_length1;
	gint stars_length2;
	cairo_surface_t** cluster_brush;
	gint cluster_brush_length1;
	gint _cluster_brush_size_;
};

struct _PasangTheme2DcairoResizeImagesAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PasangTheme2DCairo* self;
	gint my_ticket;
	cairo_surface_t** _tmp0_;
	gint _tmp0__length1;
	PasangLayout2D _tmp1_;
	PasangLayout2D _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_t* cr;
	cairo_surface_t** _tmp4_;
	gint _tmp4__length1;
	cairo_surface_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	PasangLayout2D _tmp8_;
	PasangLayout2D _tmp9_;
	PasangTheme2DCairoForgeTableFunction _tmp10_;
	gpointer _tmp10__target;
	cairo_t* _tmp11_;
	gint size;
	PasangLayout2D _tmp12_;
	gint i;
	gboolean _tmp13_;
	gint _tmp14_;
	cairo_surface_t** _tmp15_;
	gint _tmp15__length1;
	cairo_surface_t* _tmp16_;
	gint _vala1_i;
	gboolean _tmp17_;
	gint _tmp18_;
	PasangPiece piece;
	cairo_surface_t** _tmp19_;
	gint _tmp19__length1;
	cairo_surface_t* _tmp20_;
	cairo_t* _tmp21_;
	gint f;
	gboolean _tmp22_;
	gint _tmp23_;
	cairo_t* _tmp24_;
	cairo_t* _tmp25_;
	PasangTheme2DCairoForgePieceFunction _tmp26_;
	gpointer _tmp26__target;
	cairo_t* _tmp27_;
	PasangPiece _tmp28_;
	cairo_t* _tmp29_;
};

static gint PasangTheme2DCairo_private_offset;
static gpointer pasang_theme2_dcairo_parent_class = NULL;

GType pasang_rgb_get_type (void) G_GNUC_CONST;
PasangRgb* pasang_rgb_dup (const PasangRgb* self);
void pasang_rgb_free (PasangRgb* self);
void pasang_rgb_init (PasangRgb *self,
                      gdouble r,
                      gdouble g,
                      gdouble b,
                      gdouble a);
void pasang_rgb_set_source_for (PasangRgb *self,
                                cairo_t* cr);
void pasang_rgb_darken (PasangRgb *self,
                        gdouble factor,
                        PasangRgb* result);
void pasang_rgb_lighten (PasangRgb *self,
                         gdouble factor,
                         PasangRgb* result);
GType pasang_theme_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangTheme, g_object_unref)
GType pasang_game_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGameView, g_object_unref)
GType pasang_piece_get_type (void) G_GNUC_CONST;
GType pasang_point_get_type (void) G_GNUC_CONST;
PasangPoint* pasang_point_dup (const PasangPoint* self);
void pasang_point_free (PasangPoint* self);
GType pasang_game_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGame, g_object_unref)
GType pasang_theme_item_get_type (void) G_GNUC_CONST;
PasangThemeItem* pasang_theme_item_dup (const PasangThemeItem* self);
void pasang_theme_item_free (PasangThemeItem* self);
void pasang_theme_item_copy (const PasangThemeItem* self,
                             PasangThemeItem* dest);
void pasang_theme_item_destroy (PasangThemeItem* self);
GType pasang_film_get_type (void) G_GNUC_CONST;
PasangFilm* pasang_film_dup (const PasangFilm* self);
void pasang_film_free (PasangFilm* self);
GType pasang_theme2_d_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangTheme2D, g_object_unref)
GType pasang_layout2_d_get_type (void) G_GNUC_CONST;
PasangLayout2D* pasang_layout2_d_dup (const PasangLayout2D* self);
void pasang_layout2_d_free (PasangLayout2D* self);
GType pasang_theme2_dcairo_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangTheme2DCairo, g_object_unref)
PasangTheme2DCairo* pasang_theme2_dcairo_new (void);
PasangTheme2DCairo* pasang_theme2_dcairo_construct (GType object_type);
PasangTheme2D* pasang_theme2_d_construct (GType object_type);
static void pasang_theme2_dcairo_add (PasangTheme2DCairo* self,
                               const gchar* name,
                               const gchar* path);
void pasang_theme_item_init (PasangThemeItem *self);
PasangTheme* pasang_theme_select (PasangTheme* self,
                                  const gchar* path,
                                  gint width,
                                  gint height);
static void _vala_array_add31 (PasangThemeItem* * array,
                        int* length,
                        int* size,
                        const PasangThemeItem* value);
static PasangTheme* pasang_theme2_dcairo_real_select (PasangTheme* base,
                                               const gchar* path,
                                               gint width,
                                               gint height);
void pasang_theme_set_time_span (PasangTheme* self,
                                 gdouble value);
static void pasang_theme2_dcairo_forge_table_spin (PasangTheme2DCairo* self,
                                            cairo_t* cr);
static void _pasang_theme2_dcairo_forge_table_spin_pasang_theme2_dcairo_forge_table_function (cairo_t* cr,
                                                                                       gpointer self);
static void pasang_theme2_dcairo_forge_piece_spin (PasangTheme2DCairo* self,
                                            cairo_t* cr,
                                            PasangPiece piece,
                                            gint size,
                                            gint f);
static void _pasang_theme2_dcairo_forge_piece_spin_pasang_theme2_dcairo_forge_piece_function (cairo_t* cr,
                                                                                       PasangPiece piece,
                                                                                       gint size,
                                                                                       gint f,
                                                                                       gpointer self);
static void pasang_theme2_dcairo_forge_table_dizzy (PasangTheme2DCairo* self,
                                             cairo_t* cr);
static void _pasang_theme2_dcairo_forge_table_dizzy_pasang_theme2_dcairo_forge_table_function (cairo_t* cr,
                                                                                        gpointer self);
static void pasang_theme2_dcairo_forge_piece_dizzy (PasangTheme2DCairo* self,
                                             cairo_t* cr,
                                             PasangPiece piece,
                                             gint size,
                                             gint f);
static void _pasang_theme2_dcairo_forge_piece_dizzy_pasang_theme2_dcairo_forge_piece_function (cairo_t* cr,
                                                                                        PasangPiece piece,
                                                                                        gint size,
                                                                                        gint f,
                                                                                        gpointer self);
static void pasang_theme2_dcairo_forge_table_tv (PasangTheme2DCairo* self,
                                          cairo_t* cr);
static void _pasang_theme2_dcairo_forge_table_tv_pasang_theme2_dcairo_forge_table_function (cairo_t* cr,
                                                                                     gpointer self);
static void pasang_theme2_dcairo_forge_piece_tv (PasangTheme2DCairo* self,
                                          cairo_t* cr,
                                          PasangPiece piece,
                                          gint size,
                                          gint f);
static void _pasang_theme2_dcairo_forge_piece_tv_pasang_theme2_dcairo_forge_piece_function (cairo_t* cr,
                                                                                     PasangPiece piece,
                                                                                     gint size,
                                                                                     gint f,
                                                                                     gpointer self);
static void pasang_theme2_dcairo_forge_table_shiny (PasangTheme2DCairo* self,
                                             cairo_t* cr);
static void _pasang_theme2_dcairo_forge_table_shiny_pasang_theme2_dcairo_forge_table_function (cairo_t* cr,
                                                                                        gpointer self);
static void pasang_theme2_dcairo_forge_piece_shiny (PasangTheme2DCairo* self,
                                             cairo_t* cr,
                                             PasangPiece piece,
                                             gint size,
                                             gint f);
static void _pasang_theme2_dcairo_forge_piece_shiny_pasang_theme2_dcairo_forge_piece_function (cairo_t* cr,
                                                                                        PasangPiece piece,
                                                                                        gint size,
                                                                                        gint f,
                                                                                        gpointer self);
static void pasang_theme2_dcairo_forge_table_flower (PasangTheme2DCairo* self,
                                              cairo_t* cr);
static void _pasang_theme2_dcairo_forge_table_flower_pasang_theme2_dcairo_forge_table_function (cairo_t* cr,
                                                                                         gpointer self);
static void pasang_theme2_dcairo_forge_piece_flower (PasangTheme2DCairo* self,
                                              cairo_t* cr,
                                              PasangPiece piece,
                                              gint size,
                                              gint f);
static void _pasang_theme2_dcairo_forge_piece_flower_pasang_theme2_dcairo_forge_piece_function (cairo_t* cr,
                                                                                         PasangPiece piece,
                                                                                         gint size,
                                                                                         gint f,
                                                                                         gpointer self);
static void pasang_theme2_dcairo_forge_table_galaxy (PasangTheme2DCairo* self,
                                              cairo_t* cr);
static void _pasang_theme2_dcairo_forge_table_galaxy_pasang_theme2_dcairo_forge_table_function (cairo_t* cr,
                                                                                         gpointer self);
static void pasang_theme2_dcairo_forge_piece_galaxy (PasangTheme2DCairo* self,
                                              cairo_t* cr,
                                              PasangPiece piece,
                                              gint size,
                                              gint f);
static void _pasang_theme2_dcairo_forge_piece_galaxy_pasang_theme2_dcairo_forge_piece_function (cairo_t* cr,
                                                                                         PasangPiece piece,
                                                                                         gint size,
                                                                                         gint f,
                                                                                         gpointer self);
void pasang_theme_resize (PasangTheme* self,
                          gint width,
                          gint height);
static void pasang_theme2_dcairo_real_resize_images (PasangTheme2D* base);
static void pasang_theme2_dcairo_resize_images_async (PasangTheme2DCairo* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void pasang_theme2_dcairo_resize_images_finish (PasangTheme2DCairo* self,
                                                GAsyncResult* _res_);
static void pasang_theme2_dcairo_resize_images_async_data_free (gpointer _data);
static gboolean pasang_theme2_dcairo_resize_images_async_co (PasangTheme2DcairoResizeImagesAsyncData* _data_);
static gboolean _pasang_theme2_dcairo_resize_images_async_co_gsource_func (gpointer self);
static void pasang_theme2_dcairo_real_free (PasangTheme* base);
void pasang_theme_free (PasangTheme* self);
static void pasang_theme2_dcairo_draw_grids (PasangTheme2DCairo* self,
                                      cairo_t* cr,
                                      PasangRgb* line_color,
                                      gdouble line_width);
static void pasang_theme2_dcairo_paint_texture (PasangTheme2DCairo* self,
                                         cairo_t* cr,
                                         gint num_layers,
                                         gdouble* layer_spec,
                                         gint layer_spec_length1);
static void pasang_theme2_dcairo_tv_box (PasangTheme2DCairo* self,
                                  cairo_t* cr,
                                  PasangPiece piece,
                                  gint size,
                                  gint f);
static void pasang_theme2_dcairo_trace_flower (PasangTheme2DCairo* self,
                                        cairo_t* cr,
                                        gint num_petals,
                                        gdouble x,
                                        gdouble y,
                                        gdouble radius1,
                                        gdouble radius2,
                                        gdouble shift,
                                        gint num_removed);
gint pasang_theme2_d_cell_width (PasangTheme2D* self);
static cairo_surface_t** pasang_theme2_dcairo_create_spark_brush (PasangTheme2DCairo* self,
                                                           PasangRgb* core,
                                                           PasangRgb* crust,
                                                           PasangRgb* surface,
                                                           PasangRgb* ray1,
                                                           PasangRgb* ray2,
                                                           PasangRgb* ray3,
                                                           gint* result_length1);
static void pasang_theme2_dcairo_shine_light (PasangTheme2DCairo* self,
                                       cairo_t* cr,
                                       gdouble brightness,
                                       gdouble radius,
                                       gdouble tilt);
gboolean pasang_piece_is_kas (PasangPiece self);
static void pasang_theme2_dcairo_tv_control (PasangTheme2DCairo* self,
                                      cairo_t* cr,
                                      PasangPiece piece,
                                      gint size,
                                      gint f);
static void pasang_theme2_dcairo_trace_rounded_rectangle (PasangTheme2DCairo* self,
                                                   cairo_t* cr,
                                                   gdouble x,
                                                   gdouble y,
                                                   gdouble width,
                                                   gdouble height,
                                                   gdouble radius);
static void pasang_theme2_dcairo_fill_rectangle (PasangTheme2DCairo* self,
                                          cairo_t* cr,
                                          PasangRgb* color,
                                          gdouble x,
                                          gdouble y,
                                          gdouble w,
                                          gdouble h);
static void pasang_theme2_dcairo_fill_triangle (PasangTheme2DCairo* self,
                                         cairo_t* cr,
                                         PasangRgb* color,
                                         gdouble x1,
                                         gdouble y1,
                                         gdouble x2,
                                         gdouble y2,
                                         gdouble x3,
                                         gdouble y3);
void pasang_theme2_d_show_text (PasangTheme2D* self,
                                cairo_t* cr,
                                const gchar* text,
                                gint font_size,
                                gint cx,
                                gint cy,
                                gboolean boxed);
static cairo_surface_t* pasang_theme2_dcairo_create_texture (PasangTheme2DCairo* self,
                                                      gint num_layers,
                                                      gdouble* layer_spec,
                                                      gint layer_spec_length1);
static void pasang_theme2_dcairo_galaxy_black (PasangTheme2DCairo* self,
                                        cairo_t* cr,
                                        gint size,
                                        gint f);
static void pasang_theme2_dcairo_galaxy_white (PasangTheme2DCairo* self,
                                        cairo_t* cr,
                                        gint size,
                                        gint f);
static void pasang_theme2_dcairo_galaxy_kas (PasangTheme2DCairo* self,
                                      cairo_t* cr,
                                      PasangPiece piece,
                                      gint size,
                                      gint f);
static void pasang_theme2_dcairo_trace_triangle (PasangTheme2DCairo* self,
                                          cairo_t* cr,
                                          gdouble x1,
                                          gdouble y1,
                                          gdouble x2,
                                          gdouble y2,
                                          gdouble x3,
                                          gdouble y3);
static void pasang_theme2_dcairo_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

void
pasang_rgb_init (PasangRgb *self,
                 gdouble r,
                 gdouble g,
                 gdouble b,
                 gdouble a)
{
#line 26 "theme-2d-cairo.vala"
	memset (self, 0, sizeof (PasangRgb));
#line 27 "theme-2d-cairo.vala"
	(*self).red = r;
#line 28 "theme-2d-cairo.vala"
	(*self).green = g;
#line 29 "theme-2d-cairo.vala"
	(*self).blue = b;
#line 30 "theme-2d-cairo.vala"
	(*self).alpha = a;
#line 622 "theme-2d-cairo.c"
}

void
pasang_rgb_set_source_for (PasangRgb *self,
                           cairo_t* cr)
{
#line 33 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 34 "theme-2d-cairo.vala"
	cairo_set_source_rgba (cr, (*self).red, (*self).green, (*self).blue, (*self).alpha);
#line 633 "theme-2d-cairo.c"
}

void
pasang_rgb_darken (PasangRgb *self,
                   gdouble factor,
                   PasangRgb* result)
{
	PasangRgb _tmp0_ = {0};
#line 38 "theme-2d-cairo.vala"
	factor = 1 - factor;
#line 39 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp0_, (*self).red * factor, (*self).green * factor, (*self).blue * factor, (*self).alpha);
#line 39 "theme-2d-cairo.vala"
	*result = _tmp0_;
#line 39 "theme-2d-cairo.vala"
	return;
#line 650 "theme-2d-cairo.c"
}

void
pasang_rgb_lighten (PasangRgb *self,
                    gdouble factor,
                    PasangRgb* result)
{
	PasangRgb _tmp1_ = {0};
#line 43 "theme-2d-cairo.vala"
	if (factor < ((gdouble) 0)) {
#line 661 "theme-2d-cairo.c"
		PasangRgb _tmp0_ = {0};
#line 43 "theme-2d-cairo.vala"
		pasang_rgb_darken (&(*self), -factor, &_tmp0_);
#line 43 "theme-2d-cairo.vala"
		*result = _tmp0_;
#line 43 "theme-2d-cairo.vala"
		return;
#line 669 "theme-2d-cairo.c"
	}
#line 44 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp1_, (*self).red + ((1 - (*self).red) * factor), (*self).green + ((1 - (*self).green) * factor), (*self).blue + ((1 - (*self).blue) * factor), (*self).alpha);
#line 44 "theme-2d-cairo.vala"
	*result = _tmp1_;
#line 44 "theme-2d-cairo.vala"
	return;
#line 677 "theme-2d-cairo.c"
}

PasangRgb*
pasang_rgb_dup (const PasangRgb* self)
{
	PasangRgb* dup;
#line 21 "theme-2d-cairo.vala"
	dup = g_new0 (PasangRgb, 1);
#line 21 "theme-2d-cairo.vala"
	memcpy (dup, self, sizeof (PasangRgb));
#line 21 "theme-2d-cairo.vala"
	return dup;
#line 690 "theme-2d-cairo.c"
}

void
pasang_rgb_free (PasangRgb* self)
{
#line 21 "theme-2d-cairo.vala"
	g_free (self);
#line 698 "theme-2d-cairo.c"
}

GType
pasang_rgb_get_type (void)
{
	static volatile gsize pasang_rgb_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_rgb_type_id__volatile)) {
		GType pasang_rgb_type_id;
		pasang_rgb_type_id = g_boxed_type_register_static ("PasangRgb", (GBoxedCopyFunc) pasang_rgb_dup, (GBoxedFreeFunc) pasang_rgb_free);
		g_once_init_leave (&pasang_rgb_type_id__volatile, pasang_rgb_type_id);
	}
	return pasang_rgb_type_id__volatile;
}

static inline gpointer
pasang_theme2_dcairo_get_instance_private (PasangTheme2DCairo* self)
{
	return G_STRUCT_MEMBER_P (self, PasangTheme2DCairo_private_offset);
}

PasangTheme2DCairo*
pasang_theme2_dcairo_construct (GType object_type)
{
	PasangTheme2DCairo * self = NULL;
#line 80 "theme-2d-cairo.vala"
	self = (PasangTheme2DCairo*) pasang_theme2_d_construct (object_type);
#line 81 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_add (self, _ ("Spin"), "0");
#line 82 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_add (self, _ ("Dizzy"), "dizzy");
#line 83 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_add (self, _ ("Nothing Good On TV"), "tv");
#line 84 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_add (self, _ ("Smooth and Shiny"), "shiny");
#line 85 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_add (self, _ ("Enchanted Flowers"), "flower");
#line 86 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_add (self, _ ("Galaxy"), "galaxy");
#line 80 "theme-2d-cairo.vala"
	return self;
#line 739 "theme-2d-cairo.c"
}

PasangTheme2DCairo*
pasang_theme2_dcairo_new (void)
{
#line 80 "theme-2d-cairo.vala"
	return pasang_theme2_dcairo_construct (PASANG_TYPE_THEME2_DCAIRO);
#line 747 "theme-2d-cairo.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 90 "theme-2d-cairo.vala"
	return self ? g_object_ref (self) : NULL;
#line 755 "theme-2d-cairo.c"
}

static void
_vala_array_add31 (PasangThemeItem* * array,
                   int* length,
                   int* size,
                   const PasangThemeItem* value)
{
#line 101 "theme-2d-cairo.vala"
	if ((*length) == (*size)) {
#line 101 "theme-2d-cairo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 101 "theme-2d-cairo.vala"
		*array = g_renew (PasangThemeItem, *array, *size);
#line 770 "theme-2d-cairo.c"
	}
#line 101 "theme-2d-cairo.vala"
	(*array)[(*length)++] = *value;
#line 774 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_add (PasangTheme2DCairo* self,
                          const gchar* name,
                          const gchar* path)
{
	PasangThemeItem item = {0};
	gchar* _tmp0_;
	gchar* _tmp1_;
	PasangTheme* _tmp2_;
	PasangThemeItem _tmp3_ = {0};
	PasangTheme* _tmp4_;
	PasangTheme* _tmp5_;
	gint size = 0;
	PasangPiece p = 0;
	cairo_surface_t* image = NULL;
	cairo_surface_t* _tmp6_;
	cairo_t* cr = NULL;
	cairo_t* _tmp7_;
	PasangTheme2DCairoForgePieceFunction _tmp8_;
	gpointer _tmp8__target;
	PasangLayout2D _tmp9_;
	gint _tmp10_;
	GdkPixbuf* _tmp11_;
	PasangThemeItem* _tmp12_;
	gint _tmp12__length1;
	PasangThemeItem _tmp13_;
	PasangThemeItem _tmp14_;
	PasangThemeItem _tmp15_ = {0};
#line 89 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 89 "theme-2d-cairo.vala"
	g_return_if_fail (name != NULL);
#line 89 "theme-2d-cairo.vala"
	g_return_if_fail (path != NULL);
#line 90 "theme-2d-cairo.vala"
	_tmp0_ = g_strdup (name);
#line 90 "theme-2d-cairo.vala"
	_tmp1_ = g_strdup (path);
#line 90 "theme-2d-cairo.vala"
	_tmp2_ = _g_object_ref0 ((PasangTheme*) self);
#line 90 "theme-2d-cairo.vala"
	pasang_theme_item_init (&_tmp3_);
#line 90 "theme-2d-cairo.vala"
	_g_free0 (_tmp3_.name);
#line 90 "theme-2d-cairo.vala"
	_tmp3_.name = _tmp0_;
#line 90 "theme-2d-cairo.vala"
	_g_free0 (_tmp3_.path);
#line 90 "theme-2d-cairo.vala"
	_tmp3_.path = _tmp1_;
#line 90 "theme-2d-cairo.vala"
	_g_object_unref0 (_tmp3_.engine);
#line 90 "theme-2d-cairo.vala"
	_tmp3_.engine = _tmp2_;
#line 90 "theme-2d-cairo.vala"
	item = _tmp3_;
#line 91 "theme-2d-cairo.vala"
	_tmp4_ = pasang_theme_select ((PasangTheme*) self, path, 0, 0);
#line 91 "theme-2d-cairo.vala"
	_tmp5_ = _tmp4_;
#line 91 "theme-2d-cairo.vala"
	_g_object_unref0 (_tmp5_);
#line 94 "theme-2d-cairo.vala"
	size = 48;
#line 95 "theme-2d-cairo.vala"
	p = PASANG_PIECE_KAS_1;
#line 96 "theme-2d-cairo.vala"
	_tmp6_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, size, size);
#line 96 "theme-2d-cairo.vala"
	image = _tmp6_;
#line 97 "theme-2d-cairo.vala"
	_tmp7_ = cairo_create (image);
#line 97 "theme-2d-cairo.vala"
	cr = _tmp7_;
#line 98 "theme-2d-cairo.vala"
	cairo_translate (cr, (gdouble) (size / 2), (gdouble) (size / 2));
#line 99 "theme-2d-cairo.vala"
	_tmp8_ = self->priv->forge_piece_function;
#line 99 "theme-2d-cairo.vala"
	_tmp8__target = self->priv->forge_piece_function_target;
#line 99 "theme-2d-cairo.vala"
	_tmp9_ = ((PasangTheme2D*) self)->layout;
#line 99 "theme-2d-cairo.vala"
	_tmp10_ = _tmp9_.kas_frame[p];
#line 99 "theme-2d-cairo.vala"
	_tmp8_ (cr, p, size, _tmp10_, _tmp8__target);
#line 100 "theme-2d-cairo.vala"
	_tmp11_ = gdk_pixbuf_get_from_surface (image, 0, 0, size, size);
#line 100 "theme-2d-cairo.vala"
	_g_object_unref0 (item.pixbuf);
#line 100 "theme-2d-cairo.vala"
	item.pixbuf = _tmp11_;
#line 101 "theme-2d-cairo.vala"
	_tmp12_ = ((PasangTheme*) self)->items;
#line 101 "theme-2d-cairo.vala"
	_tmp12__length1 = ((PasangTheme*) self)->items_length1;
#line 101 "theme-2d-cairo.vala"
	_tmp13_ = item;
#line 101 "theme-2d-cairo.vala"
	_tmp14_ = _tmp13_;
#line 101 "theme-2d-cairo.vala"
	pasang_theme_item_copy (&_tmp14_, &_tmp15_);
#line 101 "theme-2d-cairo.vala"
	_vala_array_add31 (&((PasangTheme*) self)->items, &((PasangTheme*) self)->items_length1, &((PasangTheme*) self)->_items_size_, &_tmp15_);
#line 89 "theme-2d-cairo.vala"
	_cairo_destroy0 (cr);
#line 89 "theme-2d-cairo.vala"
	_cairo_surface_destroy0 (image);
#line 89 "theme-2d-cairo.vala"
	pasang_theme_item_destroy (&item);
#line 887 "theme-2d-cairo.c"
}

/**
     * If width == 0, then we are actually only peeking for the purpose
     * of populating the theme menu.
     */
static void
_pasang_theme2_dcairo_forge_table_spin_pasang_theme2_dcairo_forge_table_function (cairo_t* cr,
                                                                                  gpointer self)
{
#line 122 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_forge_table_spin ((PasangTheme2DCairo*) self, cr);
#line 900 "theme-2d-cairo.c"
}

static void
_pasang_theme2_dcairo_forge_piece_spin_pasang_theme2_dcairo_forge_piece_function (cairo_t* cr,
                                                                                  PasangPiece piece,
                                                                                  gint size,
                                                                                  gint f,
                                                                                  gpointer self)
{
#line 123 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_forge_piece_spin ((PasangTheme2DCairo*) self, cr, piece, size, f);
#line 912 "theme-2d-cairo.c"
}

static void
_pasang_theme2_dcairo_forge_table_dizzy_pasang_theme2_dcairo_forge_table_function (cairo_t* cr,
                                                                                   gpointer self)
{
#line 138 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_forge_table_dizzy ((PasangTheme2DCairo*) self, cr);
#line 921 "theme-2d-cairo.c"
}

static void
_pasang_theme2_dcairo_forge_piece_dizzy_pasang_theme2_dcairo_forge_piece_function (cairo_t* cr,
                                                                                   PasangPiece piece,
                                                                                   gint size,
                                                                                   gint f,
                                                                                   gpointer self)
{
#line 139 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_forge_piece_dizzy ((PasangTheme2DCairo*) self, cr, piece, size, f);
#line 933 "theme-2d-cairo.c"
}

static void
_pasang_theme2_dcairo_forge_table_tv_pasang_theme2_dcairo_forge_table_function (cairo_t* cr,
                                                                                gpointer self)
{
#line 154 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_forge_table_tv ((PasangTheme2DCairo*) self, cr);
#line 942 "theme-2d-cairo.c"
}

static void
_pasang_theme2_dcairo_forge_piece_tv_pasang_theme2_dcairo_forge_piece_function (cairo_t* cr,
                                                                                PasangPiece piece,
                                                                                gint size,
                                                                                gint f,
                                                                                gpointer self)
{
#line 155 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_forge_piece_tv ((PasangTheme2DCairo*) self, cr, piece, size, f);
#line 954 "theme-2d-cairo.c"
}

static void
_pasang_theme2_dcairo_forge_table_shiny_pasang_theme2_dcairo_forge_table_function (cairo_t* cr,
                                                                                   gpointer self)
{
#line 174 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_forge_table_shiny ((PasangTheme2DCairo*) self, cr);
#line 963 "theme-2d-cairo.c"
}

static void
_pasang_theme2_dcairo_forge_piece_shiny_pasang_theme2_dcairo_forge_piece_function (cairo_t* cr,
                                                                                   PasangPiece piece,
                                                                                   gint size,
                                                                                   gint f,
                                                                                   gpointer self)
{
#line 175 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_forge_piece_shiny ((PasangTheme2DCairo*) self, cr, piece, size, f);
#line 975 "theme-2d-cairo.c"
}

static void
_pasang_theme2_dcairo_forge_table_flower_pasang_theme2_dcairo_forge_table_function (cairo_t* cr,
                                                                                    gpointer self)
{
#line 191 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_forge_table_flower ((PasangTheme2DCairo*) self, cr);
#line 984 "theme-2d-cairo.c"
}

static void
_pasang_theme2_dcairo_forge_piece_flower_pasang_theme2_dcairo_forge_piece_function (cairo_t* cr,
                                                                                    PasangPiece piece,
                                                                                    gint size,
                                                                                    gint f,
                                                                                    gpointer self)
{
#line 192 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_forge_piece_flower ((PasangTheme2DCairo*) self, cr, piece, size, f);
#line 996 "theme-2d-cairo.c"
}

static void
_pasang_theme2_dcairo_forge_table_galaxy_pasang_theme2_dcairo_forge_table_function (cairo_t* cr,
                                                                                    gpointer self)
{
#line 213 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_forge_table_galaxy ((PasangTheme2DCairo*) self, cr);
#line 1005 "theme-2d-cairo.c"
}

static void
_pasang_theme2_dcairo_forge_piece_galaxy_pasang_theme2_dcairo_forge_piece_function (cairo_t* cr,
                                                                                    PasangPiece piece,
                                                                                    gint size,
                                                                                    gint f,
                                                                                    gpointer self)
{
#line 214 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_forge_piece_galaxy ((PasangTheme2DCairo*) self, cr, piece, size, f);
#line 1017 "theme-2d-cairo.c"
}

static PasangTheme*
pasang_theme2_dcairo_real_select (PasangTheme* base,
                                  const gchar* path,
                                  gint width,
                                  gint height)
{
	PasangTheme2DCairo * self;
	gint kas_cycle = 0;
	gint piece_cycle = 0;
	PasangLayout2D _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
#line 119 "theme-2d-cairo.vala"
	static GQuark _tmp2_label0 = 0;
#line 119 "theme-2d-cairo.vala"
	static GQuark _tmp2_label1 = 0;
#line 119 "theme-2d-cairo.vala"
	static GQuark _tmp2_label2 = 0;
#line 119 "theme-2d-cairo.vala"
	static GQuark _tmp2_label3 = 0;
#line 119 "theme-2d-cairo.vala"
	static GQuark _tmp2_label4 = 0;
#line 119 "theme-2d-cairo.vala"
	static GQuark _tmp2_label5 = 0;
#line 1044 "theme-2d-cairo.c"
	gchar* _tmp62_;
	PasangTheme* _tmp63_;
	PasangTheme* result = NULL;
#line 108 "theme-2d-cairo.vala"
	self = (PasangTheme2DCairo*) base;
#line 108 "theme-2d-cairo.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 109 "theme-2d-cairo.vala"
	pasang_theme_set_time_span ((PasangTheme*) self, 2.0);
#line 111 "theme-2d-cairo.vala"
	kas_cycle = self->priv->num_frames - 1;
#line 112 "theme-2d-cairo.vala"
	piece_cycle = (self->priv->num_frames / 2) - 1;
#line 113 "theme-2d-cairo.vala"
	_tmp0_ = ((PasangTheme2D*) self)->default_layout;
#line 113 "theme-2d-cairo.vala"
	((PasangTheme2D*) self)->layout = _tmp0_;
#line 114 "theme-2d-cairo.vala"
	((PasangTheme2D*) self)->layout.filler_left = 150;
#line 115 "theme-2d-cairo.vala"
	((PasangTheme2D*) self)->layout.filler_right = 150;
#line 116 "theme-2d-cairo.vala"
	((PasangTheme2D*) self)->layout.filler_top = 100;
#line 117 "theme-2d-cairo.vala"
	((PasangTheme2D*) self)->layout.filler_bottom = 100;
#line 119 "theme-2d-cairo.vala"
	_tmp1_ = path;
#line 119 "theme-2d-cairo.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 119 "theme-2d-cairo.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("0")))) {
#line 119 "theme-2d-cairo.vala"
		switch (0) {
#line 1078 "theme-2d-cairo.c"
			default:
			{
				gint* _tmp4_;
				gint _tmp5_[2] = {0};
				gint _tmp6_[2] = {0};
				gint _tmp7_[2] = {0};
				gint _tmp8_[2] = {0};
				PasangLayout2D _tmp9_;
				PasangRgb _tmp10_ = {0};
				PasangRgb _tmp11_ = {0};
				PasangRgb _tmp12_ = {0};
				PasangRgb _tmp13_[2] = {0};
				PasangRgb _tmp14_ = {0};
#line 121 "theme-2d-cairo.vala"
				_tmp4_ = g_new0 (gint, 4);
#line 121 "theme-2d-cairo.vala"
				_tmp4_[0] = kas_cycle;
#line 121 "theme-2d-cairo.vala"
				_tmp4_[1] = kas_cycle;
#line 121 "theme-2d-cairo.vala"
				_tmp4_[2] = piece_cycle;
#line 121 "theme-2d-cairo.vala"
				_tmp4_[3] = piece_cycle;
#line 121 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles = (g_free (((PasangTheme*) self)->cycles), NULL);
#line 121 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles = _tmp4_;
#line 121 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles_length1 = 4;
#line 121 "theme-2d-cairo.vala"
				((PasangTheme*) self)->_cycles_size_ = ((PasangTheme*) self)->cycles_length1;
#line 122 "theme-2d-cairo.vala"
				(self->priv->forge_table_function_target_destroy_notify == NULL) ? NULL : (self->priv->forge_table_function_target_destroy_notify (self->priv->forge_table_function_target), NULL);
#line 122 "theme-2d-cairo.vala"
				self->priv->forge_table_function = NULL;
#line 122 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target = NULL;
#line 122 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target_destroy_notify = NULL;
#line 122 "theme-2d-cairo.vala"
				self->priv->forge_table_function = _pasang_theme2_dcairo_forge_table_spin_pasang_theme2_dcairo_forge_table_function;
#line 122 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target = g_object_ref (self);
#line 122 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target_destroy_notify = g_object_unref;
#line 123 "theme-2d-cairo.vala"
				(self->priv->forge_piece_function_target_destroy_notify == NULL) ? NULL : (self->priv->forge_piece_function_target_destroy_notify (self->priv->forge_piece_function_target), NULL);
#line 123 "theme-2d-cairo.vala"
				self->priv->forge_piece_function = NULL;
#line 123 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target = NULL;
#line 123 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target_destroy_notify = NULL;
#line 123 "theme-2d-cairo.vala"
				self->priv->forge_piece_function = _pasang_theme2_dcairo_forge_piece_spin_pasang_theme2_dcairo_forge_piece_function;
#line 123 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target = g_object_ref (self);
#line 123 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target_destroy_notify = g_object_unref;
#line 124 "theme-2d-cairo.vala"
				_tmp5_[0] = 100;
#line 124 "theme-2d-cairo.vala"
				_tmp5_[1] = 900;
#line 124 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.num_wins_y, _tmp5_, 2 * sizeof (gint));
#line 125 "theme-2d-cairo.vala"
				_tmp6_[0] = 1150;
#line 125 "theme-2d-cairo.vala"
				_tmp6_[1] = 1050;
#line 125 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.kas_x, _tmp6_, 2 * sizeof (gint));
#line 126 "theme-2d-cairo.vala"
				_tmp7_[0] = 367;
#line 126 "theme-2d-cairo.vala"
				_tmp7_[1] = 500;
#line 126 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.kas_y, _tmp7_, 2 * sizeof (gint));
#line 127 "theme-2d-cairo.vala"
				_tmp8_[0] = 1050;
#line 127 "theme-2d-cairo.vala"
				_tmp8_[1] = 1150;
#line 127 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_x, _tmp8_, 2 * sizeof (gint));
#line 128 "theme-2d-cairo.vala"
				_tmp9_ = ((PasangTheme2D*) self)->layout;
#line 128 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_y, _tmp9_.kas_y, 2 * sizeof (gint));
#line 129 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.score_font_size = 30;
#line 130 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_y = 667;
#line 131 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_font_size = 25;
#line 132 "theme-2d-cairo.vala"
				pasang_rgb_darken (&self->priv->spin_color, 0.3, &_tmp10_);
#line 132 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_wins_color = _tmp10_;
#line 133 "theme-2d-cairo.vala"
				pasang_rgb_darken (&self->priv->spin_color, 0.5, &_tmp11_);
#line 133 "theme-2d-cairo.vala"
				pasang_rgb_darken (&self->priv->spin_color, 0.5, &_tmp12_);
#line 133 "theme-2d-cairo.vala"
				_tmp13_[0] = _tmp11_;
#line 133 "theme-2d-cairo.vala"
				_tmp13_[1] = _tmp12_;
#line 133 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_color, _tmp13_, 2 * sizeof (PasangRgb));
#line 134 "theme-2d-cairo.vala"
				pasang_rgb_darken (&self->priv->spin_color, 0.5, &_tmp14_);
#line 134 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_color = _tmp14_;
#line 135 "theme-2d-cairo.vala"
				break;
#line 1192 "theme-2d-cairo.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("dizzy")))) {
#line 119 "theme-2d-cairo.vala"
		switch (0) {
#line 1198 "theme-2d-cairo.c"
			default:
			{
				gint* _tmp15_;
				gint _tmp16_[2] = {0};
				gint _tmp17_[2] = {0};
				gint _tmp18_[2] = {0};
				gint _tmp19_[2] = {0};
				PasangRgb _tmp20_ = {0};
				PasangRgb _tmp21_;
				PasangRgb _tmp22_;
				PasangRgb _tmp23_[2] = {0};
				PasangRgb _tmp24_;
#line 137 "theme-2d-cairo.vala"
				_tmp15_ = g_new0 (gint, 4);
#line 137 "theme-2d-cairo.vala"
				_tmp15_[0] = kas_cycle;
#line 137 "theme-2d-cairo.vala"
				_tmp15_[1] = kas_cycle;
#line 137 "theme-2d-cairo.vala"
				_tmp15_[2] = piece_cycle;
#line 137 "theme-2d-cairo.vala"
				_tmp15_[3] = piece_cycle;
#line 137 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles = (g_free (((PasangTheme*) self)->cycles), NULL);
#line 137 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles = _tmp15_;
#line 137 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles_length1 = 4;
#line 137 "theme-2d-cairo.vala"
				((PasangTheme*) self)->_cycles_size_ = ((PasangTheme*) self)->cycles_length1;
#line 138 "theme-2d-cairo.vala"
				(self->priv->forge_table_function_target_destroy_notify == NULL) ? NULL : (self->priv->forge_table_function_target_destroy_notify (self->priv->forge_table_function_target), NULL);
#line 138 "theme-2d-cairo.vala"
				self->priv->forge_table_function = NULL;
#line 138 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target = NULL;
#line 138 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target_destroy_notify = NULL;
#line 138 "theme-2d-cairo.vala"
				self->priv->forge_table_function = _pasang_theme2_dcairo_forge_table_dizzy_pasang_theme2_dcairo_forge_table_function;
#line 138 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target = g_object_ref (self);
#line 138 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target_destroy_notify = g_object_unref;
#line 139 "theme-2d-cairo.vala"
				(self->priv->forge_piece_function_target_destroy_notify == NULL) ? NULL : (self->priv->forge_piece_function_target_destroy_notify (self->priv->forge_piece_function_target), NULL);
#line 139 "theme-2d-cairo.vala"
				self->priv->forge_piece_function = NULL;
#line 139 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target = NULL;
#line 139 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target_destroy_notify = NULL;
#line 139 "theme-2d-cairo.vala"
				self->priv->forge_piece_function = _pasang_theme2_dcairo_forge_piece_dizzy_pasang_theme2_dcairo_forge_piece_function;
#line 139 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target = g_object_ref (self);
#line 139 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target_destroy_notify = g_object_unref;
#line 140 "theme-2d-cairo.vala"
				_tmp16_[0] = 1120;
#line 140 "theme-2d-cairo.vala"
				_tmp16_[1] = 1120;
#line 140 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.num_wins_x, _tmp16_, 2 * sizeof (gint));
#line 141 "theme-2d-cairo.vala"
				_tmp17_[0] = 1120;
#line 141 "theme-2d-cairo.vala"
				_tmp17_[1] = 1120;
#line 141 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.kas_x, _tmp17_, 2 * sizeof (gint));
#line 142 "theme-2d-cairo.vala"
				_tmp18_[0] = 1120;
#line 142 "theme-2d-cairo.vala"
				_tmp18_[1] = 1120;
#line 142 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_x, _tmp18_, 2 * sizeof (gint));
#line 143 "theme-2d-cairo.vala"
				_tmp19_[0] = 300;
#line 143 "theme-2d-cairo.vala"
				_tmp19_[1] = 700;
#line 143 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_y, _tmp19_, 2 * sizeof (gint));
#line 144 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_x = 1120;
#line 145 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.board_x = -30;
#line 146 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.board_y = -30;
#line 147 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.board_size = 1060;
#line 148 "theme-2d-cairo.vala"
				pasang_rgb_darken (&self->priv->dizzy_color, 0.2, &_tmp20_);
#line 148 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_wins_color = _tmp20_;
#line 149 "theme-2d-cairo.vala"
				_tmp21_ = self->priv->dizzy_color;
#line 149 "theme-2d-cairo.vala"
				_tmp22_ = self->priv->dizzy_color;
#line 149 "theme-2d-cairo.vala"
				_tmp23_[0] = _tmp21_;
#line 149 "theme-2d-cairo.vala"
				_tmp23_[1] = _tmp22_;
#line 149 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_color, _tmp23_, 2 * sizeof (PasangRgb));
#line 150 "theme-2d-cairo.vala"
				_tmp24_ = self->priv->dizzy_color;
#line 150 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_color = _tmp24_;
#line 151 "theme-2d-cairo.vala"
				break;
#line 1309 "theme-2d-cairo.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("tv")))) {
#line 119 "theme-2d-cairo.vala"
		switch (0) {
#line 1315 "theme-2d-cairo.c"
			default:
			{
				gint* _tmp25_;
				gint _tmp26_[2] = {0};
				gint _tmp27_[2] = {0};
				gint _tmp28_[2] = {0};
				gint _tmp29_[2] = {0};
				gint _tmp30_[2] = {0};
				gint _tmp31_[2] = {0};
				PasangRgb _tmp32_ = {0};
				PasangRgb _tmp33_ = {0};
				PasangRgb _tmp34_[2] = {0};
#line 153 "theme-2d-cairo.vala"
				_tmp25_ = g_new0 (gint, 4);
#line 153 "theme-2d-cairo.vala"
				_tmp25_[0] = -kas_cycle;
#line 153 "theme-2d-cairo.vala"
				_tmp25_[1] = -kas_cycle;
#line 153 "theme-2d-cairo.vala"
				_tmp25_[2] = piece_cycle;
#line 153 "theme-2d-cairo.vala"
				_tmp25_[3] = piece_cycle;
#line 153 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles = (g_free (((PasangTheme*) self)->cycles), NULL);
#line 153 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles = _tmp25_;
#line 153 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles_length1 = 4;
#line 153 "theme-2d-cairo.vala"
				((PasangTheme*) self)->_cycles_size_ = ((PasangTheme*) self)->cycles_length1;
#line 154 "theme-2d-cairo.vala"
				(self->priv->forge_table_function_target_destroy_notify == NULL) ? NULL : (self->priv->forge_table_function_target_destroy_notify (self->priv->forge_table_function_target), NULL);
#line 154 "theme-2d-cairo.vala"
				self->priv->forge_table_function = NULL;
#line 154 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target = NULL;
#line 154 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target_destroy_notify = NULL;
#line 154 "theme-2d-cairo.vala"
				self->priv->forge_table_function = _pasang_theme2_dcairo_forge_table_tv_pasang_theme2_dcairo_forge_table_function;
#line 154 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target = g_object_ref (self);
#line 154 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target_destroy_notify = g_object_unref;
#line 155 "theme-2d-cairo.vala"
				(self->priv->forge_piece_function_target_destroy_notify == NULL) ? NULL : (self->priv->forge_piece_function_target_destroy_notify (self->priv->forge_piece_function_target), NULL);
#line 155 "theme-2d-cairo.vala"
				self->priv->forge_piece_function = NULL;
#line 155 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target = NULL;
#line 155 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target_destroy_notify = NULL;
#line 155 "theme-2d-cairo.vala"
				self->priv->forge_piece_function = _pasang_theme2_dcairo_forge_piece_tv_pasang_theme2_dcairo_forge_piece_function;
#line 155 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target = g_object_ref (self);
#line 155 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target_destroy_notify = g_object_unref;
#line 156 "theme-2d-cairo.vala"
				_tmp26_[0] = 1070;
#line 156 "theme-2d-cairo.vala"
				_tmp26_[1] = 1070;
#line 156 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.num_wins_x, _tmp26_, 2 * sizeof (gint));
#line 157 "theme-2d-cairo.vala"
				_tmp27_[0] = 100;
#line 157 "theme-2d-cairo.vala"
				_tmp27_[1] = 900;
#line 157 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.num_wins_y, _tmp27_, 2 * sizeof (gint));
#line 158 "theme-2d-cairo.vala"
				pasang_rgb_init (&((PasangTheme2D*) self)->layout.num_wins_color, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
#line 159 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_wins_font_size = 40;
#line 160 "theme-2d-cairo.vala"
				_tmp28_[0] = 1150;
#line 160 "theme-2d-cairo.vala"
				_tmp28_[1] = 1150;
#line 160 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.kas_x, _tmp28_, 2 * sizeof (gint));
#line 161 "theme-2d-cairo.vala"
				_tmp29_[0] = 500;
#line 161 "theme-2d-cairo.vala"
				_tmp29_[1] = 580;
#line 161 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.kas_y, _tmp29_, 2 * sizeof (gint));
#line 162 "theme-2d-cairo.vala"
				_tmp30_[0] = 1070;
#line 162 "theme-2d-cairo.vala"
				_tmp30_[1] = 1070;
#line 162 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_x, _tmp30_, 2 * sizeof (gint));
#line 163 "theme-2d-cairo.vala"
				_tmp31_[0] = 500;
#line 163 "theme-2d-cairo.vala"
				_tmp31_[1] = 580;
#line 163 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_y, _tmp31_, 2 * sizeof (gint));
#line 164 "theme-2d-cairo.vala"
				pasang_rgb_init (&_tmp32_, 1.0, 0.2, 0.3, (gdouble) 1);
#line 164 "theme-2d-cairo.vala"
				pasang_rgb_init (&_tmp33_, 0.3, 0.5, 1.0, (gdouble) 1);
#line 164 "theme-2d-cairo.vala"
				_tmp34_[0] = _tmp32_;
#line 164 "theme-2d-cairo.vala"
				_tmp34_[1] = _tmp33_;
#line 164 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_color, _tmp34_, 2 * sizeof (PasangRgb));
#line 165 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.score_font_size = 25;
#line 166 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_x = 1070;
#line 167 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_y = 420;
#line 168 "theme-2d-cairo.vala"
				pasang_rgb_init (&((PasangTheme2D*) self)->layout.num_rounds_color, 0.2, 0.8, 0.3, (gdouble) 1);
#line 169 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_font_size = 25;
#line 170 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_format = 2;
#line 171 "theme-2d-cairo.vala"
				break;
#line 1438 "theme-2d-cairo.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("shiny")))) {
#line 119 "theme-2d-cairo.vala"
		switch (0) {
#line 1444 "theme-2d-cairo.c"
			default:
			{
				gint* _tmp35_;
				gint _tmp36_[2] = {0};
				gint _tmp37_[2] = {0};
				gint _tmp38_[2] = {0};
				gint _tmp39_[2] = {0};
				PasangRgb _tmp40_ = {0};
				PasangRgb _tmp41_ = {0};
				PasangRgb _tmp42_ = {0};
				PasangRgb _tmp43_[2] = {0};
				PasangRgb _tmp44_ = {0};
#line 173 "theme-2d-cairo.vala"
				_tmp35_ = g_new0 (gint, 4);
#line 173 "theme-2d-cairo.vala"
				_tmp35_[0] = 0;
#line 173 "theme-2d-cairo.vala"
				_tmp35_[1] = 0;
#line 173 "theme-2d-cairo.vala"
				_tmp35_[2] = 0;
#line 173 "theme-2d-cairo.vala"
				_tmp35_[3] = 0;
#line 173 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles = (g_free (((PasangTheme*) self)->cycles), NULL);
#line 173 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles = _tmp35_;
#line 173 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles_length1 = 4;
#line 173 "theme-2d-cairo.vala"
				((PasangTheme*) self)->_cycles_size_ = ((PasangTheme*) self)->cycles_length1;
#line 174 "theme-2d-cairo.vala"
				(self->priv->forge_table_function_target_destroy_notify == NULL) ? NULL : (self->priv->forge_table_function_target_destroy_notify (self->priv->forge_table_function_target), NULL);
#line 174 "theme-2d-cairo.vala"
				self->priv->forge_table_function = NULL;
#line 174 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target = NULL;
#line 174 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target_destroy_notify = NULL;
#line 174 "theme-2d-cairo.vala"
				self->priv->forge_table_function = _pasang_theme2_dcairo_forge_table_shiny_pasang_theme2_dcairo_forge_table_function;
#line 174 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target = g_object_ref (self);
#line 174 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target_destroy_notify = g_object_unref;
#line 175 "theme-2d-cairo.vala"
				(self->priv->forge_piece_function_target_destroy_notify == NULL) ? NULL : (self->priv->forge_piece_function_target_destroy_notify (self->priv->forge_piece_function_target), NULL);
#line 175 "theme-2d-cairo.vala"
				self->priv->forge_piece_function = NULL;
#line 175 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target = NULL;
#line 175 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target_destroy_notify = NULL;
#line 175 "theme-2d-cairo.vala"
				self->priv->forge_piece_function = _pasang_theme2_dcairo_forge_piece_shiny_pasang_theme2_dcairo_forge_piece_function;
#line 175 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target = g_object_ref (self);
#line 175 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target_destroy_notify = g_object_unref;
#line 176 "theme-2d-cairo.vala"
				_tmp36_[0] = 1140;
#line 176 "theme-2d-cairo.vala"
				_tmp36_[1] = 1140;
#line 176 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.kas_x, _tmp36_, 2 * sizeof (gint));
#line 177 "theme-2d-cairo.vala"
				_tmp37_[0] = 460;
#line 177 "theme-2d-cairo.vala"
				_tmp37_[1] = 540;
#line 177 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.kas_y, _tmp37_, 2 * sizeof (gint));
#line 178 "theme-2d-cairo.vala"
				_tmp38_[0] = 1070;
#line 178 "theme-2d-cairo.vala"
				_tmp38_[1] = 1070;
#line 178 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_x, _tmp38_, 2 * sizeof (gint));
#line 179 "theme-2d-cairo.vala"
				_tmp39_[0] = 460;
#line 179 "theme-2d-cairo.vala"
				_tmp39_[1] = 540;
#line 179 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_y, _tmp39_, 2 * sizeof (gint));
#line 180 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.score_font_size = 35;
#line 181 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_x = 500;
#line 182 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_y = 970;
#line 183 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_font_size = 25;
#line 184 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_format = 1;
#line 185 "theme-2d-cairo.vala"
				pasang_rgb_lighten (&self->priv->shiny_color, -0.5, &_tmp40_);
#line 185 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_color = _tmp40_;
#line 186 "theme-2d-cairo.vala"
				pasang_rgb_lighten (&self->priv->shiny_color, -0.5, &_tmp41_);
#line 186 "theme-2d-cairo.vala"
				pasang_rgb_lighten (&self->priv->shiny_color, -0.5, &_tmp42_);
#line 186 "theme-2d-cairo.vala"
				_tmp43_[0] = _tmp41_;
#line 186 "theme-2d-cairo.vala"
				_tmp43_[1] = _tmp42_;
#line 186 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_color, _tmp43_, 2 * sizeof (PasangRgb));
#line 187 "theme-2d-cairo.vala"
				pasang_rgb_lighten (&self->priv->shiny_color, 0.5, &_tmp44_);
#line 187 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_wins_color = _tmp44_;
#line 188 "theme-2d-cairo.vala"
				break;
#line 1557 "theme-2d-cairo.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("flower")))) {
#line 119 "theme-2d-cairo.vala"
		switch (0) {
#line 1563 "theme-2d-cairo.c"
			default:
			{
				gint* _tmp45_;
				gint _tmp46_[2] = {0};
				gint _tmp47_[2] = {0};
				gint _tmp48_[2] = {0};
				PasangLayout2D _tmp49_;
				PasangLayout2D _tmp50_;
				gint _tmp51_[2] = {0};
				PasangRgb _tmp52_ = {0};
				PasangRgb _tmp53_ = {0};
				PasangRgb _tmp54_ = {0};
				PasangRgb _tmp55_[2] = {0};
				PasangRgb _tmp56_ = {0};
#line 190 "theme-2d-cairo.vala"
				_tmp45_ = g_new0 (gint, 4);
#line 190 "theme-2d-cairo.vala"
				_tmp45_[0] = piece_cycle;
#line 190 "theme-2d-cairo.vala"
				_tmp45_[1] = piece_cycle;
#line 190 "theme-2d-cairo.vala"
				_tmp45_[2] = 0;
#line 190 "theme-2d-cairo.vala"
				_tmp45_[3] = 0;
#line 190 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles = (g_free (((PasangTheme*) self)->cycles), NULL);
#line 190 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles = _tmp45_;
#line 190 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles_length1 = 4;
#line 190 "theme-2d-cairo.vala"
				((PasangTheme*) self)->_cycles_size_ = ((PasangTheme*) self)->cycles_length1;
#line 191 "theme-2d-cairo.vala"
				(self->priv->forge_table_function_target_destroy_notify == NULL) ? NULL : (self->priv->forge_table_function_target_destroy_notify (self->priv->forge_table_function_target), NULL);
#line 191 "theme-2d-cairo.vala"
				self->priv->forge_table_function = NULL;
#line 191 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target = NULL;
#line 191 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target_destroy_notify = NULL;
#line 191 "theme-2d-cairo.vala"
				self->priv->forge_table_function = _pasang_theme2_dcairo_forge_table_flower_pasang_theme2_dcairo_forge_table_function;
#line 191 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target = g_object_ref (self);
#line 191 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target_destroy_notify = g_object_unref;
#line 192 "theme-2d-cairo.vala"
				(self->priv->forge_piece_function_target_destroy_notify == NULL) ? NULL : (self->priv->forge_piece_function_target_destroy_notify (self->priv->forge_piece_function_target), NULL);
#line 192 "theme-2d-cairo.vala"
				self->priv->forge_piece_function = NULL;
#line 192 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target = NULL;
#line 192 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target_destroy_notify = NULL;
#line 192 "theme-2d-cairo.vala"
				self->priv->forge_piece_function = _pasang_theme2_dcairo_forge_piece_flower_pasang_theme2_dcairo_forge_piece_function;
#line 192 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target = g_object_ref (self);
#line 192 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target_destroy_notify = g_object_unref;
#line 193 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.board_x = 20;
#line 194 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.width = 1150;
#line 195 "theme-2d-cairo.vala"
				_tmp46_[0] = 1050;
#line 195 "theme-2d-cairo.vala"
				_tmp46_[1] = 1050;
#line 195 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.num_wins_x, _tmp46_, 2 * sizeof (gint));
#line 196 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_wins_font_size = 40;
#line 197 "theme-2d-cairo.vala"
				_tmp47_[0] = 1090;
#line 197 "theme-2d-cairo.vala"
				_tmp47_[1] = 1020;
#line 197 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_x, _tmp47_, 2 * sizeof (gint));
#line 198 "theme-2d-cairo.vala"
				_tmp48_[0] = 400;
#line 198 "theme-2d-cairo.vala"
				_tmp48_[1] = 650;
#line 198 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_y, _tmp48_, 2 * sizeof (gint));
#line 199 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.score_font_size = 25;
#line 200 "theme-2d-cairo.vala"
				_tmp49_ = ((PasangTheme2D*) self)->layout;
#line 200 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.kas_x, _tmp49_.score_x, 2 * sizeof (gint));
#line 201 "theme-2d-cairo.vala"
				_tmp50_ = ((PasangTheme2D*) self)->layout;
#line 201 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.kas_y, _tmp50_.score_y, 2 * sizeof (gint));
#line 202 "theme-2d-cairo.vala"
				_tmp51_[0] = self->priv->num_frames / 3;
#line 202 "theme-2d-cairo.vala"
				_tmp51_[1] = self->priv->num_frames / 3;
#line 202 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.kas_frame, _tmp51_, 2 * sizeof (gint));
#line 203 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_x = 200;
#line 204 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_y = 960;
#line 205 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_format = 1;
#line 206 "theme-2d-cairo.vala"
				pasang_rgb_lighten (&self->priv->flower_color, 0.7, &_tmp52_);
#line 206 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_wins_color = _tmp52_;
#line 207 "theme-2d-cairo.vala"
				pasang_rgb_darken (&self->priv->flower_color, 0.2, &_tmp53_);
#line 207 "theme-2d-cairo.vala"
				pasang_rgb_darken (&self->priv->flower_color, 0.2, &_tmp54_);
#line 207 "theme-2d-cairo.vala"
				_tmp55_[0] = _tmp53_;
#line 207 "theme-2d-cairo.vala"
				_tmp55_[1] = _tmp54_;
#line 207 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_color, _tmp55_, 2 * sizeof (PasangRgb));
#line 208 "theme-2d-cairo.vala"
				pasang_rgb_lighten (&self->priv->flower_color, 0.5, &_tmp56_);
#line 208 "theme-2d-cairo.vala"
				((PasangTheme2D*) self)->layout.num_rounds_color = _tmp56_;
#line 209 "theme-2d-cairo.vala"
				break;
#line 1690 "theme-2d-cairo.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("galaxy")))) {
#line 119 "theme-2d-cairo.vala"
		switch (0) {
#line 1696 "theme-2d-cairo.c"
			default:
			{
				gint* _tmp57_;
				gint _tmp58_[2] = {0};
				PasangRgb _tmp59_ = {0};
				PasangRgb _tmp60_ = {0};
				PasangRgb _tmp61_[2] = {0};
#line 211 "theme-2d-cairo.vala"
				kas_cycle = ((-self->priv->num_frames) * 3) / 4;
#line 212 "theme-2d-cairo.vala"
				_tmp57_ = g_new0 (gint, 4);
#line 212 "theme-2d-cairo.vala"
				_tmp57_[0] = kas_cycle;
#line 212 "theme-2d-cairo.vala"
				_tmp57_[1] = kas_cycle;
#line 212 "theme-2d-cairo.vala"
				_tmp57_[2] = piece_cycle;
#line 212 "theme-2d-cairo.vala"
				_tmp57_[3] = piece_cycle;
#line 212 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles = (g_free (((PasangTheme*) self)->cycles), NULL);
#line 212 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles = _tmp57_;
#line 212 "theme-2d-cairo.vala"
				((PasangTheme*) self)->cycles_length1 = 4;
#line 212 "theme-2d-cairo.vala"
				((PasangTheme*) self)->_cycles_size_ = ((PasangTheme*) self)->cycles_length1;
#line 213 "theme-2d-cairo.vala"
				(self->priv->forge_table_function_target_destroy_notify == NULL) ? NULL : (self->priv->forge_table_function_target_destroy_notify (self->priv->forge_table_function_target), NULL);
#line 213 "theme-2d-cairo.vala"
				self->priv->forge_table_function = NULL;
#line 213 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target = NULL;
#line 213 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target_destroy_notify = NULL;
#line 213 "theme-2d-cairo.vala"
				self->priv->forge_table_function = _pasang_theme2_dcairo_forge_table_galaxy_pasang_theme2_dcairo_forge_table_function;
#line 213 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target = g_object_ref (self);
#line 213 "theme-2d-cairo.vala"
				self->priv->forge_table_function_target_destroy_notify = g_object_unref;
#line 214 "theme-2d-cairo.vala"
				(self->priv->forge_piece_function_target_destroy_notify == NULL) ? NULL : (self->priv->forge_piece_function_target_destroy_notify (self->priv->forge_piece_function_target), NULL);
#line 214 "theme-2d-cairo.vala"
				self->priv->forge_piece_function = NULL;
#line 214 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target = NULL;
#line 214 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target_destroy_notify = NULL;
#line 214 "theme-2d-cairo.vala"
				self->priv->forge_piece_function = _pasang_theme2_dcairo_forge_piece_galaxy_pasang_theme2_dcairo_forge_piece_function;
#line 214 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target = g_object_ref (self);
#line 214 "theme-2d-cairo.vala"
				self->priv->forge_piece_function_target_destroy_notify = g_object_unref;
#line 215 "theme-2d-cairo.vala"
				_tmp58_[0] = self->priv->num_frames - 1;
#line 215 "theme-2d-cairo.vala"
				_tmp58_[1] = self->priv->num_frames - 1;
#line 215 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.kas_frame, _tmp58_, 2 * sizeof (gint));
#line 216 "theme-2d-cairo.vala"
				pasang_rgb_init (&((PasangTheme2D*) self)->layout.num_wins_color, 0.4, 0.4, 0.4, (gdouble) 1);
#line 217 "theme-2d-cairo.vala"
				pasang_rgb_init (&_tmp59_, 0.4, 0.1, 0.1, (gdouble) 1);
#line 217 "theme-2d-cairo.vala"
				pasang_rgb_init (&_tmp60_, 0.1, 0.1, 0.4, (gdouble) 1);
#line 217 "theme-2d-cairo.vala"
				_tmp61_[0] = _tmp59_;
#line 217 "theme-2d-cairo.vala"
				_tmp61_[1] = _tmp60_;
#line 217 "theme-2d-cairo.vala"
				memcpy (((PasangTheme2D*) self)->layout.score_color, _tmp61_, 2 * sizeof (PasangRgb));
#line 218 "theme-2d-cairo.vala"
				pasang_rgb_init (&((PasangTheme2D*) self)->layout.num_rounds_color, 0.1, 0.4, 0.1, (gdouble) 1);
#line 219 "theme-2d-cairo.vala"
				break;
#line 1774 "theme-2d-cairo.c"
			}
		}
	} else {
#line 119 "theme-2d-cairo.vala"
		switch (0) {
#line 1780 "theme-2d-cairo.c"
			default:
			{
#line 221 "theme-2d-cairo.vala"
				g_assert_not_reached ();
#line 1785 "theme-2d-cairo.c"
			}
		}
	}
#line 224 "theme-2d-cairo.vala"
	((PasangTheme2D*) self)->layout_changed = TRUE;
#line 225 "theme-2d-cairo.vala"
	_tmp62_ = g_strdup (path);
#line 225 "theme-2d-cairo.vala"
	_g_free0 (self->priv->path);
#line 225 "theme-2d-cairo.vala"
	self->priv->path = _tmp62_;
#line 226 "theme-2d-cairo.vala"
	if (width != 0) {
#line 227 "theme-2d-cairo.vala"
		pasang_theme_resize ((PasangTheme*) self, width, height);
#line 1801 "theme-2d-cairo.c"
	}
#line 229 "theme-2d-cairo.vala"
	_tmp63_ = _g_object_ref0 ((PasangTheme*) self);
#line 229 "theme-2d-cairo.vala"
	result = _tmp63_;
#line 229 "theme-2d-cairo.vala"
	return result;
#line 1809 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_real_resize_images (PasangTheme2D* base)
{
	PasangTheme2DCairo * self;
#line 232 "theme-2d-cairo.vala"
	self = (PasangTheme2DCairo*) base;
#line 233 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_resize_images_async (self, NULL, NULL);
#line 1820 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_resize_images_async_data_free (gpointer _data)
{
	PasangTheme2DcairoResizeImagesAsyncData* _data_;
	_data_ = _data;
#line 51 "theme-2d-cairo.vala"
	_g_object_unref0 (_data_->self);
#line 51 "theme-2d-cairo.vala"
	g_slice_free (PasangTheme2DcairoResizeImagesAsyncData, _data_);
#line 1832 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_resize_images_async (PasangTheme2DCairo* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	PasangTheme2DcairoResizeImagesAsyncData* _data_;
	PasangTheme2DCairo* _tmp0_;
#line 51 "theme-2d-cairo.vala"
	_data_ = g_slice_new0 (PasangTheme2DcairoResizeImagesAsyncData);
#line 51 "theme-2d-cairo.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 51 "theme-2d-cairo.vala"
	g_task_set_task_data (_data_->_async_result, _data_, pasang_theme2_dcairo_resize_images_async_data_free);
#line 51 "theme-2d-cairo.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 51 "theme-2d-cairo.vala"
	_data_->self = _tmp0_;
#line 51 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_resize_images_async_co (_data_);
#line 1854 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_resize_images_finish (PasangTheme2DCairo* self,
                                           GAsyncResult* _res_)
{
	PasangTheme2DcairoResizeImagesAsyncData* _data_;
#line 51 "theme-2d-cairo.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 1864 "theme-2d-cairo.c"
}

static gboolean
_pasang_theme2_dcairo_resize_images_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = pasang_theme2_dcairo_resize_images_async_co (self);
#line 254 "theme-2d-cairo.vala"
	return result;
#line 1874 "theme-2d-cairo.c"
}

static gboolean
pasang_theme2_dcairo_resize_images_async_co (PasangTheme2DcairoResizeImagesAsyncData* _data_)
{
#line 241 "theme-2d-cairo.vala"
	switch (_data_->_state_) {
#line 241 "theme-2d-cairo.vala"
		case 0:
#line 1884 "theme-2d-cairo.c"
		goto _state_0;
#line 241 "theme-2d-cairo.vala"
		case 1:
#line 1888 "theme-2d-cairo.c"
		goto _state_1;
#line 241 "theme-2d-cairo.vala"
		case 2:
#line 1892 "theme-2d-cairo.c"
		goto _state_2;
		default:
#line 241 "theme-2d-cairo.vala"
		g_assert_not_reached ();
#line 1897 "theme-2d-cairo.c"
	}
	_state_0:
#line 242 "theme-2d-cairo.vala"
	_data_->self->priv->ticket = _data_->self->priv->ticket + 1;
#line 242 "theme-2d-cairo.vala"
	_data_->my_ticket = _data_->self->priv->ticket;
#line 244 "theme-2d-cairo.vala"
	_data_->_tmp0_ = ((PasangTheme2D*) _data_->self)->images;
#line 244 "theme-2d-cairo.vala"
	_data_->_tmp0__length1 = ((PasangTheme2D*) _data_->self)->images_length1;
#line 244 "theme-2d-cairo.vala"
	_data_->_tmp1_ = ((PasangTheme2D*) _data_->self)->table;
#line 244 "theme-2d-cairo.vala"
	_data_->_tmp2_ = ((PasangTheme2D*) _data_->self)->table;
#line 244 "theme-2d-cairo.vala"
	_data_->_tmp3_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _data_->_tmp1_.image_width, _data_->_tmp2_.image_height);
#line 244 "theme-2d-cairo.vala"
	_cairo_surface_destroy0 (_data_->_tmp0_[PASANG_PIECE_BOARD]);
#line 244 "theme-2d-cairo.vala"
	_data_->_tmp0_[PASANG_PIECE_BOARD] = _data_->_tmp3_;
#line 245 "theme-2d-cairo.vala"
	_data_->_tmp4_ = ((PasangTheme2D*) _data_->self)->images;
#line 245 "theme-2d-cairo.vala"
	_data_->_tmp4__length1 = ((PasangTheme2D*) _data_->self)->images_length1;
#line 245 "theme-2d-cairo.vala"
	_data_->_tmp5_ = _data_->_tmp4_[PASANG_PIECE_BOARD];
#line 245 "theme-2d-cairo.vala"
	_data_->_tmp6_ = cairo_create (_data_->_tmp5_);
#line 245 "theme-2d-cairo.vala"
	_data_->cr = _data_->_tmp6_;
#line 246 "theme-2d-cairo.vala"
	_data_->_tmp7_ = _data_->cr;
#line 246 "theme-2d-cairo.vala"
	_data_->_tmp8_ = ((PasangTheme2D*) _data_->self)->table;
#line 246 "theme-2d-cairo.vala"
	_data_->_tmp9_ = ((PasangTheme2D*) _data_->self)->table;
#line 246 "theme-2d-cairo.vala"
	cairo_translate (_data_->_tmp7_, (gdouble) _data_->_tmp8_.filler_left, (gdouble) _data_->_tmp9_.filler_top);
#line 247 "theme-2d-cairo.vala"
	_data_->_tmp10_ = _data_->self->priv->forge_table_function;
#line 247 "theme-2d-cairo.vala"
	_data_->_tmp10__target = _data_->self->priv->forge_table_function_target;
#line 247 "theme-2d-cairo.vala"
	_data_->_tmp11_ = _data_->cr;
#line 247 "theme-2d-cairo.vala"
	_data_->_tmp10_ (_data_->_tmp11_, _data_->_tmp10__target);
#line 249 "theme-2d-cairo.vala"
	_data_->_tmp12_ = ((PasangTheme2D*) _data_->self)->table;
#line 249 "theme-2d-cairo.vala"
	_data_->size = (66 * _data_->_tmp12_.board_size) / 572;
#line 1948 "theme-2d-cairo.c"
	{
#line 250 "theme-2d-cairo.vala"
		_data_->i = 0;
#line 1952 "theme-2d-cairo.c"
		{
#line 250 "theme-2d-cairo.vala"
			_data_->_tmp13_ = TRUE;
#line 250 "theme-2d-cairo.vala"
			while (TRUE) {
#line 250 "theme-2d-cairo.vala"
				if (!_data_->_tmp13_) {
#line 250 "theme-2d-cairo.vala"
					_data_->_tmp14_ = _data_->i;
#line 250 "theme-2d-cairo.vala"
					_data_->i = _data_->_tmp14_ + 1;
#line 1964 "theme-2d-cairo.c"
				}
#line 250 "theme-2d-cairo.vala"
				_data_->_tmp13_ = FALSE;
#line 250 "theme-2d-cairo.vala"
				if (!(_data_->i < ((gint) PASANG_PIECE_COUNT))) {
#line 250 "theme-2d-cairo.vala"
					break;
#line 1972 "theme-2d-cairo.c"
				}
#line 251 "theme-2d-cairo.vala"
				_data_->_tmp15_ = ((PasangTheme2D*) _data_->self)->images;
#line 251 "theme-2d-cairo.vala"
				_data_->_tmp15__length1 = ((PasangTheme2D*) _data_->self)->images_length1;
#line 251 "theme-2d-cairo.vala"
				_data_->_tmp16_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _data_->size * _data_->self->priv->num_frames, _data_->size);
#line 251 "theme-2d-cairo.vala"
				_cairo_surface_destroy0 (_data_->_tmp15_[_data_->i]);
#line 251 "theme-2d-cairo.vala"
				_data_->_tmp15_[_data_->i] = _data_->_tmp16_;
#line 1984 "theme-2d-cairo.c"
			}
		}
	}
#line 254 "theme-2d-cairo.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _pasang_theme2_dcairo_resize_images_async_co_gsource_func, _data_, NULL);
#line 255 "theme-2d-cairo.vala"
	_data_->_state_ = 1;
#line 255 "theme-2d-cairo.vala"
	return FALSE;
#line 1994 "theme-2d-cairo.c"
	_state_1:
	;
#line 256 "theme-2d-cairo.vala"
	if (_data_->my_ticket != _data_->self->priv->ticket) {
#line 256 "theme-2d-cairo.vala"
		_cairo_destroy0 (_data_->cr);
#line 256 "theme-2d-cairo.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 256 "theme-2d-cairo.vala"
		if (_data_->_state_ != 0) {
#line 256 "theme-2d-cairo.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 256 "theme-2d-cairo.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2009 "theme-2d-cairo.c"
			}
		}
#line 256 "theme-2d-cairo.vala"
		g_object_unref (_data_->_async_result);
#line 256 "theme-2d-cairo.vala"
		return FALSE;
#line 2016 "theme-2d-cairo.c"
	}
#line 257 "theme-2d-cairo.vala"
	g_signal_emit (_data_->self, pasang_theme2_dcairo_signals[PASANG_THEME2_DCAIRO_CHANGED_SIGNAL], 0);
#line 2020 "theme-2d-cairo.c"
	{
#line 259 "theme-2d-cairo.vala"
		_data_->_vala1_i = 0;
#line 2024 "theme-2d-cairo.c"
		{
#line 259 "theme-2d-cairo.vala"
			_data_->_tmp17_ = TRUE;
#line 259 "theme-2d-cairo.vala"
			while (TRUE) {
#line 259 "theme-2d-cairo.vala"
				if (!_data_->_tmp17_) {
#line 259 "theme-2d-cairo.vala"
					_data_->_tmp18_ = _data_->_vala1_i;
#line 259 "theme-2d-cairo.vala"
					_data_->_vala1_i = _data_->_tmp18_ + 1;
#line 2036 "theme-2d-cairo.c"
				}
#line 259 "theme-2d-cairo.vala"
				_data_->_tmp17_ = FALSE;
#line 259 "theme-2d-cairo.vala"
				if (!(_data_->_vala1_i < ((gint) PASANG_PIECE_COUNT))) {
#line 259 "theme-2d-cairo.vala"
					break;
#line 2044 "theme-2d-cairo.c"
				}
#line 260 "theme-2d-cairo.vala"
				_data_->piece = (PasangPiece) _data_->_vala1_i;
#line 261 "theme-2d-cairo.vala"
				_data_->_tmp19_ = ((PasangTheme2D*) _data_->self)->images;
#line 261 "theme-2d-cairo.vala"
				_data_->_tmp19__length1 = ((PasangTheme2D*) _data_->self)->images_length1;
#line 261 "theme-2d-cairo.vala"
				_data_->_tmp20_ = _data_->_tmp19_[_data_->_vala1_i];
#line 261 "theme-2d-cairo.vala"
				_data_->_tmp21_ = cairo_create (_data_->_tmp20_);
#line 261 "theme-2d-cairo.vala"
				_cairo_destroy0 (_data_->cr);
#line 261 "theme-2d-cairo.vala"
				_data_->cr = _data_->_tmp21_;
#line 2060 "theme-2d-cairo.c"
				{
#line 262 "theme-2d-cairo.vala"
					_data_->f = 0;
#line 2064 "theme-2d-cairo.c"
					{
#line 262 "theme-2d-cairo.vala"
						_data_->_tmp22_ = TRUE;
#line 262 "theme-2d-cairo.vala"
						while (TRUE) {
#line 262 "theme-2d-cairo.vala"
							if (!_data_->_tmp22_) {
#line 262 "theme-2d-cairo.vala"
								_data_->_tmp23_ = _data_->f;
#line 262 "theme-2d-cairo.vala"
								_data_->f = _data_->_tmp23_ + 1;
#line 2076 "theme-2d-cairo.c"
							}
#line 262 "theme-2d-cairo.vala"
							_data_->_tmp22_ = FALSE;
#line 262 "theme-2d-cairo.vala"
							if (!(_data_->f < _data_->self->priv->num_frames)) {
#line 262 "theme-2d-cairo.vala"
								break;
#line 2084 "theme-2d-cairo.c"
							}
#line 263 "theme-2d-cairo.vala"
							_data_->_tmp24_ = _data_->cr;
#line 263 "theme-2d-cairo.vala"
							cairo_save (_data_->_tmp24_);
#line 264 "theme-2d-cairo.vala"
							_data_->_tmp25_ = _data_->cr;
#line 264 "theme-2d-cairo.vala"
							cairo_translate (_data_->_tmp25_, (gdouble) ((_data_->size * _data_->f) + (_data_->size / 2)), (gdouble) (_data_->size / 2));
#line 265 "theme-2d-cairo.vala"
							_data_->_tmp26_ = _data_->self->priv->forge_piece_function;
#line 265 "theme-2d-cairo.vala"
							_data_->_tmp26__target = _data_->self->priv->forge_piece_function_target;
#line 265 "theme-2d-cairo.vala"
							_data_->_tmp27_ = _data_->cr;
#line 265 "theme-2d-cairo.vala"
							_data_->_tmp28_ = _data_->piece;
#line 265 "theme-2d-cairo.vala"
							_data_->_tmp26_ (_data_->_tmp27_, _data_->_tmp28_, _data_->size, _data_->f, _data_->_tmp26__target);
#line 266 "theme-2d-cairo.vala"
							_data_->_tmp29_ = _data_->cr;
#line 266 "theme-2d-cairo.vala"
							cairo_restore (_data_->_tmp29_);
#line 268 "theme-2d-cairo.vala"
							g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _pasang_theme2_dcairo_resize_images_async_co_gsource_func, _data_, NULL);
#line 269 "theme-2d-cairo.vala"
							_data_->_state_ = 2;
#line 269 "theme-2d-cairo.vala"
							return FALSE;
#line 2114 "theme-2d-cairo.c"
							_state_2:
							;
#line 270 "theme-2d-cairo.vala"
							if (_data_->my_ticket != _data_->self->priv->ticket) {
#line 270 "theme-2d-cairo.vala"
								_cairo_destroy0 (_data_->cr);
#line 270 "theme-2d-cairo.vala"
								g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 270 "theme-2d-cairo.vala"
								if (_data_->_state_ != 0) {
#line 270 "theme-2d-cairo.vala"
									while (!g_task_get_completed (_data_->_async_result)) {
#line 270 "theme-2d-cairo.vala"
										g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2129 "theme-2d-cairo.c"
									}
								}
#line 270 "theme-2d-cairo.vala"
								g_object_unref (_data_->_async_result);
#line 270 "theme-2d-cairo.vala"
								return FALSE;
#line 2136 "theme-2d-cairo.c"
							}
						}
					}
				}
#line 273 "theme-2d-cairo.vala"
				g_signal_emit (_data_->self, pasang_theme2_dcairo_signals[PASANG_THEME2_DCAIRO_CHANGED_SIGNAL], 0);
#line 2143 "theme-2d-cairo.c"
			}
		}
	}
#line 241 "theme-2d-cairo.vala"
	_cairo_destroy0 (_data_->cr);
#line 241 "theme-2d-cairo.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 241 "theme-2d-cairo.vala"
	if (_data_->_state_ != 0) {
#line 241 "theme-2d-cairo.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 241 "theme-2d-cairo.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2157 "theme-2d-cairo.c"
		}
	}
#line 241 "theme-2d-cairo.vala"
	g_object_unref (_data_->_async_result);
#line 241 "theme-2d-cairo.vala"
	return FALSE;
#line 2164 "theme-2d-cairo.c"
}

/**
     * A call to free indicates that the theme has been changed. So invalidate
     * ticket so that any ongoing async theme construction is properly aborted.
     */
static void
pasang_theme2_dcairo_real_free (PasangTheme* base)
{
	PasangTheme2DCairo * self;
#line 281 "theme-2d-cairo.vala"
	self = (PasangTheme2DCairo*) base;
#line 282 "theme-2d-cairo.vala"
	self->priv->ticket = self->priv->ticket + 1;
#line 283 "theme-2d-cairo.vala"
	PASANG_THEME_CLASS (pasang_theme2_dcairo_parent_class)->free ((PasangTheme*) G_TYPE_CHECK_INSTANCE_CAST (self, PASANG_TYPE_THEME2_D, PasangTheme2D));
#line 2181 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_forge_table_spin (PasangTheme2DCairo* self,
                                       cairo_t* cr)
{
	gdouble x = 0.0;
	PasangLayout2D _tmp0_;
	gdouble width = 0.0;
	PasangLayout2D _tmp1_;
	PasangLayout2D _tmp5_;
	PasangLayout2D _tmp6_;
	PasangLayout2D _tmp7_;
	PasangLayout2D _tmp8_;
	PasangRgb _tmp9_ = {0};
	PasangRgb _tmp10_ = {0};
	gdouble* _tmp11_;
	gdouble* _tmp12_;
	gint _tmp12__length1;
#line 286 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 286 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 287 "theme-2d-cairo.vala"
	pasang_rgb_set_source_for (&self->priv->spin_color, cr);
#line 288 "theme-2d-cairo.vala"
	cairo_paint (cr);
#line 291 "theme-2d-cairo.vala"
	_tmp0_ = ((PasangTheme2D*) self)->table;
#line 291 "theme-2d-cairo.vala"
	x = (gdouble) _tmp0_.board_size;
#line 292 "theme-2d-cairo.vala"
	_tmp1_ = ((PasangTheme2D*) self)->table;
#line 292 "theme-2d-cairo.vala"
	width = _tmp1_.board_size / 15.0;
#line 293 "theme-2d-cairo.vala"
	cairo_move_to (cr, x, -2 * width);
#line 2219 "theme-2d-cairo.c"
	{
		gint i = 0;
#line 294 "theme-2d-cairo.vala"
		i = -2;
#line 2224 "theme-2d-cairo.c"
		{
			gboolean _tmp2_ = FALSE;
#line 294 "theme-2d-cairo.vala"
			_tmp2_ = TRUE;
#line 294 "theme-2d-cairo.vala"
			while (TRUE) {
#line 2231 "theme-2d-cairo.c"
				gdouble y = 0.0;
				gdouble _tmp4_ = 0.0;
				gdouble dx = 0.0;
#line 294 "theme-2d-cairo.vala"
				if (!_tmp2_) {
#line 2237 "theme-2d-cairo.c"
					gint _tmp3_;
#line 294 "theme-2d-cairo.vala"
					_tmp3_ = i;
#line 294 "theme-2d-cairo.vala"
					i = _tmp3_ + 1;
#line 2243 "theme-2d-cairo.c"
				}
#line 294 "theme-2d-cairo.vala"
				_tmp2_ = FALSE;
#line 294 "theme-2d-cairo.vala"
				if (!(i < 17)) {
#line 294 "theme-2d-cairo.vala"
					break;
#line 2251 "theme-2d-cairo.c"
				}
#line 295 "theme-2d-cairo.vala"
				y = i * width;
#line 297 "theme-2d-cairo.vala"
				if ((i % 2) == 0) {
#line 297 "theme-2d-cairo.vala"
					_tmp4_ = 0.4;
#line 2259 "theme-2d-cairo.c"
				} else {
#line 297 "theme-2d-cairo.vala"
					_tmp4_ = -0.4;
#line 2263 "theme-2d-cairo.c"
				}
#line 297 "theme-2d-cairo.vala"
				dx = _tmp4_ * width;
#line 298 "theme-2d-cairo.vala"
				cairo_curve_to (cr, x + dx, y + (0.3 * width), x + dx, y + (0.7 * width), x, y + width);
#line 2269 "theme-2d-cairo.c"
			}
		}
	}
#line 302 "theme-2d-cairo.vala"
	_tmp5_ = ((PasangTheme2D*) self)->table;
#line 302 "theme-2d-cairo.vala"
	_tmp6_ = ((PasangTheme2D*) self)->table;
#line 302 "theme-2d-cairo.vala"
	cairo_line_to (cr, (gdouble) _tmp5_.image_width, (gdouble) _tmp6_.image_height);
#line 303 "theme-2d-cairo.vala"
	_tmp7_ = ((PasangTheme2D*) self)->table;
#line 303 "theme-2d-cairo.vala"
	_tmp8_ = ((PasangTheme2D*) self)->table;
#line 303 "theme-2d-cairo.vala"
	cairo_line_to (cr, (gdouble) _tmp7_.image_width, (gdouble) (-_tmp8_.filler_top));
#line 304 "theme-2d-cairo.vala"
	pasang_rgb_lighten (&self->priv->spin_color, 0.2, &_tmp9_);
#line 304 "theme-2d-cairo.vala"
	pasang_rgb_set_source_for (&_tmp9_, cr);
#line 305 "theme-2d-cairo.vala"
	cairo_fill (cr);
#line 307 "theme-2d-cairo.vala"
	pasang_rgb_lighten (&self->priv->spin_color, 0.2, &_tmp10_);
#line 307 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_draw_grids (self, cr, &_tmp10_, 0.1);
#line 308 "theme-2d-cairo.vala"
	_tmp11_ = g_new0 (gdouble, 12);
#line 308 "theme-2d-cairo.vala"
	_tmp11_[0] = (gdouble) 2;
#line 308 "theme-2d-cairo.vala"
	_tmp11_[1] = 0.05;
#line 308 "theme-2d-cairo.vala"
	_tmp11_[2] = (gdouble) 0;
#line 308 "theme-2d-cairo.vala"
	_tmp11_[3] = (gdouble) 0;
#line 308 "theme-2d-cairo.vala"
	_tmp11_[4] = (gdouble) 1;
#line 308 "theme-2d-cairo.vala"
	_tmp11_[5] = (gdouble) 1;
#line 308 "theme-2d-cairo.vala"
	_tmp11_[6] = (gdouble) 2;
#line 308 "theme-2d-cairo.vala"
	_tmp11_[7] = 0.05;
#line 308 "theme-2d-cairo.vala"
	_tmp11_[8] = (gdouble) 0;
#line 308 "theme-2d-cairo.vala"
	_tmp11_[9] = (gdouble) 0;
#line 308 "theme-2d-cairo.vala"
	_tmp11_[10] = (gdouble) 1;
#line 308 "theme-2d-cairo.vala"
	_tmp11_[11] = (gdouble) 0;
#line 308 "theme-2d-cairo.vala"
	_tmp12_ = _tmp11_;
#line 308 "theme-2d-cairo.vala"
	_tmp12__length1 = 12;
#line 308 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_paint_texture (self, cr, 2, _tmp12_, (gint) 12);
#line 308 "theme-2d-cairo.vala"
	_tmp12_ = (g_free (_tmp12_), NULL);
#line 2329 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_forge_table_dizzy (PasangTheme2DCairo* self,
                                        cairo_t* cr)
{
	gdouble x = 0.0;
	PasangLayout2D _tmp0_;
	PasangLayout2D _tmp1_;
	PasangLayout2D _tmp2_;
	gdouble width = 0.0;
	PasangLayout2D _tmp3_;
	PasangLayout2D _tmp9_;
	PasangLayout2D _tmp10_;
	PasangLayout2D _tmp11_;
	PasangLayout2D _tmp12_;
	PasangRgb _tmp13_ = {0};
	gdouble* _tmp14_;
	gdouble* _tmp15_;
	gint _tmp15__length1;
	PasangRgb _tmp16_ = {0};
#line 311 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 311 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 312 "theme-2d-cairo.vala"
	pasang_rgb_set_source_for (&self->priv->dizzy_color, cr);
#line 313 "theme-2d-cairo.vala"
	cairo_paint (cr);
#line 316 "theme-2d-cairo.vala"
	_tmp0_ = ((PasangTheme2D*) self)->table;
#line 316 "theme-2d-cairo.vala"
	_tmp1_ = ((PasangTheme2D*) self)->table;
#line 316 "theme-2d-cairo.vala"
	_tmp2_ = ((PasangTheme2D*) self)->table;
#line 316 "theme-2d-cairo.vala"
	x = (gdouble) ((_tmp0_.board_x + _tmp1_.board_size) - _tmp2_.x);
#line 317 "theme-2d-cairo.vala"
	_tmp3_ = ((PasangTheme2D*) self)->table;
#line 317 "theme-2d-cairo.vala"
	width = _tmp3_.board_size / 31.0;
#line 2371 "theme-2d-cairo.c"
	{
		gint i = 0;
#line 318 "theme-2d-cairo.vala"
		i = -4;
#line 2376 "theme-2d-cairo.c"
		{
			gboolean _tmp4_ = FALSE;
#line 318 "theme-2d-cairo.vala"
			_tmp4_ = TRUE;
#line 318 "theme-2d-cairo.vala"
			while (TRUE) {
#line 2383 "theme-2d-cairo.c"
				gdouble y = 0.0;
				PasangLayout2D _tmp6_;
				PasangLayout2D _tmp7_;
				gdouble _tmp8_ = 0.0;
				gdouble dx = 0.0;
#line 318 "theme-2d-cairo.vala"
				if (!_tmp4_) {
#line 2391 "theme-2d-cairo.c"
					gint _tmp5_;
#line 318 "theme-2d-cairo.vala"
					_tmp5_ = i;
#line 318 "theme-2d-cairo.vala"
					i = _tmp5_ + 1;
#line 2397 "theme-2d-cairo.c"
				}
#line 318 "theme-2d-cairo.vala"
				_tmp4_ = FALSE;
#line 318 "theme-2d-cairo.vala"
				if (!(i < 35)) {
#line 318 "theme-2d-cairo.vala"
					break;
#line 2405 "theme-2d-cairo.c"
				}
#line 319 "theme-2d-cairo.vala"
				_tmp6_ = ((PasangTheme2D*) self)->table;
#line 319 "theme-2d-cairo.vala"
				_tmp7_ = ((PasangTheme2D*) self)->table;
#line 319 "theme-2d-cairo.vala"
				y = (_tmp6_.board_y + (i * width)) - _tmp7_.y;
#line 320 "theme-2d-cairo.vala"
				if ((i % 2) == 0) {
#line 320 "theme-2d-cairo.vala"
					_tmp8_ = 0.5;
#line 2417 "theme-2d-cairo.c"
				} else {
#line 320 "theme-2d-cairo.vala"
					_tmp8_ = -0.5;
#line 2421 "theme-2d-cairo.c"
				}
#line 320 "theme-2d-cairo.vala"
				dx = _tmp8_ * width;
#line 321 "theme-2d-cairo.vala"
				cairo_line_to (cr, x + dx, y);
#line 2427 "theme-2d-cairo.c"
			}
		}
	}
#line 323 "theme-2d-cairo.vala"
	_tmp9_ = ((PasangTheme2D*) self)->table;
#line 323 "theme-2d-cairo.vala"
	_tmp10_ = ((PasangTheme2D*) self)->table;
#line 323 "theme-2d-cairo.vala"
	cairo_line_to (cr, (gdouble) _tmp9_.image_width, (gdouble) _tmp10_.image_height);
#line 324 "theme-2d-cairo.vala"
	_tmp11_ = ((PasangTheme2D*) self)->table;
#line 324 "theme-2d-cairo.vala"
	_tmp12_ = ((PasangTheme2D*) self)->table;
#line 324 "theme-2d-cairo.vala"
	cairo_line_to (cr, (gdouble) _tmp11_.image_width, (gdouble) (-_tmp12_.filler_top));
#line 325 "theme-2d-cairo.vala"
	pasang_rgb_lighten (&self->priv->dizzy_color, 0.5, &_tmp13_);
#line 325 "theme-2d-cairo.vala"
	pasang_rgb_set_source_for (&_tmp13_, cr);
#line 326 "theme-2d-cairo.vala"
	cairo_fill (cr);
#line 328 "theme-2d-cairo.vala"
	_tmp14_ = g_new0 (gdouble, 18);
#line 328 "theme-2d-cairo.vala"
	_tmp14_[0] = 1.5;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[1] = 0.05;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[2] = (gdouble) 0;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[3] = (gdouble) 0;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[4] = (gdouble) 1;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[5] = (gdouble) 1;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[6] = 1.5;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[7] = 0.05;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[8] = (gdouble) 0;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[9] = (gdouble) 0;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[10] = (gdouble) 0;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[11] = (gdouble) 1;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[12] = 1.5;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[13] = 0.1;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[14] = (gdouble) 0;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[15] = (gdouble) 0;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[16] = (gdouble) 1;
#line 328 "theme-2d-cairo.vala"
	_tmp14_[17] = (gdouble) 0;
#line 328 "theme-2d-cairo.vala"
	_tmp15_ = _tmp14_;
#line 328 "theme-2d-cairo.vala"
	_tmp15__length1 = 18;
#line 328 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_paint_texture (self, cr, 3, _tmp15_, (gint) 18);
#line 328 "theme-2d-cairo.vala"
	_tmp15_ = (g_free (_tmp15_), NULL);
#line 331 "theme-2d-cairo.vala"
	pasang_rgb_lighten (&self->priv->dizzy_color, 0.5, &_tmp16_);
#line 331 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_draw_grids (self, cr, &_tmp16_, 0.08);
#line 2499 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_forge_table_tv (PasangTheme2DCairo* self,
                                     cairo_t* cr)
{
	gdouble* _tmp0_;
	gdouble* _tmp1_;
	gint _tmp1__length1;
	PasangRgb _tmp2_ = {0};
	PasangLayout2D _tmp3_;
	PasangLayout2D _tmp4_;
	PasangLayout2D _tmp19_;
	PasangLayout2D _tmp20_;
	PasangLayout2D _tmp21_;
#line 334 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 334 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 335 "theme-2d-cairo.vala"
	pasang_rgb_set_source_for (&self->priv->tv_color, cr);
#line 336 "theme-2d-cairo.vala"
	cairo_paint (cr);
#line 338 "theme-2d-cairo.vala"
	_tmp0_ = g_new0 (gdouble, 18);
#line 338 "theme-2d-cairo.vala"
	_tmp0_[0] = (gdouble) 2;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[1] = 0.05;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[2] = (gdouble) 0;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[3] = (gdouble) 0;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[4] = (gdouble) 1;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[5] = (gdouble) 1;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[6] = (gdouble) 2;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[7] = 0.05;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[8] = (gdouble) 0;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[9] = (gdouble) 0;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[10] = (gdouble) 0;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[11] = (gdouble) 1;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[12] = (gdouble) 2;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[13] = 0.1;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[14] = (gdouble) 0;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[15] = (gdouble) 0;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[16] = (gdouble) 1;
#line 338 "theme-2d-cairo.vala"
	_tmp0_[17] = (gdouble) 0;
#line 338 "theme-2d-cairo.vala"
	_tmp1_ = _tmp0_;
#line 338 "theme-2d-cairo.vala"
	_tmp1__length1 = 18;
#line 338 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_paint_texture (self, cr, 3, _tmp1_, (gint) 18);
#line 338 "theme-2d-cairo.vala"
	_tmp1_ = (g_free (_tmp1_), NULL);
#line 341 "theme-2d-cairo.vala"
	pasang_rgb_darken (&self->priv->tv_color, 0.2, &_tmp2_);
#line 341 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_draw_grids (self, cr, &_tmp2_, 0.1);
#line 343 "theme-2d-cairo.vala"
	_tmp3_ = ((PasangTheme2D*) self)->table;
#line 343 "theme-2d-cairo.vala"
	_tmp4_ = ((PasangTheme2D*) self)->table;
#line 343 "theme-2d-cairo.vala"
	cairo_translate (cr, (gdouble) (-_tmp3_.x), (gdouble) (-_tmp4_.y));
#line 2579 "theme-2d-cairo.c"
	{
		gint side = 0;
#line 344 "theme-2d-cairo.vala"
		side = 0;
#line 2584 "theme-2d-cairo.c"
		{
			gboolean _tmp5_ = FALSE;
#line 344 "theme-2d-cairo.vala"
			_tmp5_ = TRUE;
#line 344 "theme-2d-cairo.vala"
			while (TRUE) {
#line 2591 "theme-2d-cairo.c"
				PasangLayout2D _tmp7_;
				gint _tmp8_;
				PasangLayout2D _tmp9_;
				gint _tmp10_;
				PasangLayout2D _tmp11_;
#line 344 "theme-2d-cairo.vala"
				if (!_tmp5_) {
#line 2599 "theme-2d-cairo.c"
					gint _tmp6_;
#line 344 "theme-2d-cairo.vala"
					_tmp6_ = side;
#line 344 "theme-2d-cairo.vala"
					side = _tmp6_ + 1;
#line 2605 "theme-2d-cairo.c"
				}
#line 344 "theme-2d-cairo.vala"
				_tmp5_ = FALSE;
#line 344 "theme-2d-cairo.vala"
				if (!(side < 2)) {
#line 344 "theme-2d-cairo.vala"
					break;
#line 2613 "theme-2d-cairo.c"
				}
#line 345 "theme-2d-cairo.vala"
				cairo_save (cr);
#line 346 "theme-2d-cairo.vala"
				_tmp7_ = ((PasangTheme2D*) self)->table;
#line 346 "theme-2d-cairo.vala"
				_tmp8_ = _tmp7_.score_x[side];
#line 346 "theme-2d-cairo.vala"
				_tmp9_ = ((PasangTheme2D*) self)->table;
#line 346 "theme-2d-cairo.vala"
				_tmp10_ = _tmp9_.score_y[side];
#line 346 "theme-2d-cairo.vala"
				cairo_translate (cr, (gdouble) _tmp8_, (gdouble) _tmp10_);
#line 347 "theme-2d-cairo.vala"
				_tmp11_ = ((PasangTheme2D*) self)->table;
#line 347 "theme-2d-cairo.vala"
				pasang_theme2_dcairo_tv_box (self, cr, PASANG_PIECE_NULL, (gint) (0.15 * _tmp11_.width), 0);
#line 348 "theme-2d-cairo.vala"
				cairo_restore (cr);
#line 2633 "theme-2d-cairo.c"
			}
		}
	}
	{
		gint side = 0;
#line 350 "theme-2d-cairo.vala"
		side = 0;
#line 2641 "theme-2d-cairo.c"
		{
			gboolean _tmp12_ = FALSE;
#line 350 "theme-2d-cairo.vala"
			_tmp12_ = TRUE;
#line 350 "theme-2d-cairo.vala"
			while (TRUE) {
#line 2648 "theme-2d-cairo.c"
				PasangLayout2D _tmp14_;
				gint _tmp15_;
				PasangLayout2D _tmp16_;
				gint _tmp17_;
				PasangLayout2D _tmp18_;
#line 350 "theme-2d-cairo.vala"
				if (!_tmp12_) {
#line 2656 "theme-2d-cairo.c"
					gint _tmp13_;
#line 350 "theme-2d-cairo.vala"
					_tmp13_ = side;
#line 350 "theme-2d-cairo.vala"
					side = _tmp13_ + 1;
#line 2662 "theme-2d-cairo.c"
				}
#line 350 "theme-2d-cairo.vala"
				_tmp12_ = FALSE;
#line 350 "theme-2d-cairo.vala"
				if (!(side < 2)) {
#line 350 "theme-2d-cairo.vala"
					break;
#line 2670 "theme-2d-cairo.c"
				}
#line 351 "theme-2d-cairo.vala"
				cairo_save (cr);
#line 352 "theme-2d-cairo.vala"
				_tmp14_ = ((PasangTheme2D*) self)->table;
#line 352 "theme-2d-cairo.vala"
				_tmp15_ = _tmp14_.num_wins_x[side];
#line 352 "theme-2d-cairo.vala"
				_tmp16_ = ((PasangTheme2D*) self)->table;
#line 352 "theme-2d-cairo.vala"
				_tmp17_ = _tmp16_.num_wins_y[side];
#line 352 "theme-2d-cairo.vala"
				cairo_translate (cr, (gdouble) _tmp15_, (gdouble) _tmp17_);
#line 353 "theme-2d-cairo.vala"
				_tmp18_ = ((PasangTheme2D*) self)->table;
#line 353 "theme-2d-cairo.vala"
				pasang_theme2_dcairo_tv_box (self, cr, PASANG_PIECE_NULL, (gint) (0.20 * _tmp18_.width), 0);
#line 354 "theme-2d-cairo.vala"
				cairo_restore (cr);
#line 2690 "theme-2d-cairo.c"
			}
		}
	}
#line 356 "theme-2d-cairo.vala"
	_tmp19_ = ((PasangTheme2D*) self)->table;
#line 356 "theme-2d-cairo.vala"
	_tmp20_ = ((PasangTheme2D*) self)->table;
#line 356 "theme-2d-cairo.vala"
	cairo_translate (cr, (gdouble) _tmp19_.num_rounds_x, (gdouble) _tmp20_.num_rounds_y);
#line 357 "theme-2d-cairo.vala"
	_tmp21_ = ((PasangTheme2D*) self)->table;
#line 357 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_tv_box (self, cr, PASANG_PIECE_NULL, (gint) (0.15 * _tmp21_.width), 0);
#line 2704 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_forge_table_shiny (PasangTheme2DCairo* self,
                                        cairo_t* cr)
{
	PasangLayout2D _tmp0_;
	PasangLayout2D _tmp1_;
	PasangLayout2D _tmp2_;
	PasangLayout2D _tmp3_;
	PasangRgb _tmp4_ = {0};
	PasangRgb _tmp5_ = {0};
#line 360 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 360 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 361 "theme-2d-cairo.vala"
	pasang_rgb_set_source_for (&self->priv->shiny_color, cr);
#line 362 "theme-2d-cairo.vala"
	cairo_paint (cr);
#line 364 "theme-2d-cairo.vala"
	_tmp0_ = ((PasangTheme2D*) self)->table;
#line 364 "theme-2d-cairo.vala"
	_tmp1_ = ((PasangTheme2D*) self)->table;
#line 364 "theme-2d-cairo.vala"
	_tmp2_ = ((PasangTheme2D*) self)->table;
#line 364 "theme-2d-cairo.vala"
	_tmp3_ = ((PasangTheme2D*) self)->table;
#line 364 "theme-2d-cairo.vala"
	cairo_rectangle (cr, (gdouble) _tmp0_.board_size, (gdouble) (-_tmp1_.filler_top), (gdouble) _tmp2_.image_width, (gdouble) _tmp3_.image_height);
#line 365 "theme-2d-cairo.vala"
	pasang_rgb_darken (&self->priv->shiny_color, 0.1, &_tmp4_);
#line 365 "theme-2d-cairo.vala"
	pasang_rgb_set_source_for (&_tmp4_, cr);
#line 366 "theme-2d-cairo.vala"
	cairo_fill (cr);
#line 368 "theme-2d-cairo.vala"
	pasang_rgb_lighten (&self->priv->shiny_color, 0.5, &_tmp5_);
#line 368 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_draw_grids (self, cr, &_tmp5_, 0.05);
#line 2745 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_forge_table_flower (PasangTheme2DCairo* self,
                                         cairo_t* cr)
{
	PasangRgb _tmp0_ = {0};
	gdouble* _tmp1_;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gdouble* flower = NULL;
	gdouble* _tmp3_;
	gint flower_length1;
	gint _flower_size_;
	gint n = 0;
#line 371 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 371 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 372 "theme-2d-cairo.vala"
	pasang_rgb_set_source_for (&self->priv->flower_color, cr);
#line 373 "theme-2d-cairo.vala"
	cairo_paint (cr);
#line 374 "theme-2d-cairo.vala"
	pasang_rgb_lighten (&self->priv->flower_color, 0.5, &_tmp0_);
#line 374 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_draw_grids (self, cr, &_tmp0_, 0.1);
#line 375 "theme-2d-cairo.vala"
	_tmp1_ = g_new0 (gdouble, 12);
#line 375 "theme-2d-cairo.vala"
	_tmp1_[0] = (gdouble) 2;
#line 375 "theme-2d-cairo.vala"
	_tmp1_[1] = 0.05;
#line 375 "theme-2d-cairo.vala"
	_tmp1_[2] = (gdouble) 0;
#line 375 "theme-2d-cairo.vala"
	_tmp1_[3] = (gdouble) 0;
#line 375 "theme-2d-cairo.vala"
	_tmp1_[4] = (gdouble) 1;
#line 375 "theme-2d-cairo.vala"
	_tmp1_[5] = (gdouble) 1;
#line 375 "theme-2d-cairo.vala"
	_tmp1_[6] = (gdouble) 2;
#line 375 "theme-2d-cairo.vala"
	_tmp1_[7] = 0.05;
#line 375 "theme-2d-cairo.vala"
	_tmp1_[8] = (gdouble) 0;
#line 375 "theme-2d-cairo.vala"
	_tmp1_[9] = (gdouble) 0;
#line 375 "theme-2d-cairo.vala"
	_tmp1_[10] = (gdouble) 1;
#line 375 "theme-2d-cairo.vala"
	_tmp1_[11] = (gdouble) 0;
#line 375 "theme-2d-cairo.vala"
	_tmp2_ = _tmp1_;
#line 375 "theme-2d-cairo.vala"
	_tmp2__length1 = 12;
#line 375 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_paint_texture (self, cr, 2, _tmp2_, (gint) 12);
#line 375 "theme-2d-cairo.vala"
	_tmp2_ = (g_free (_tmp2_), NULL);
#line 378 "theme-2d-cairo.vala"
	_tmp3_ = g_new0 (gdouble, 56);
#line 378 "theme-2d-cairo.vala"
	_tmp3_[0] = (gdouble) 10;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[1] = 1.05;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[2] = 0.10;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[3] = 0.05;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[4] = 0.25;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[5] = 0.0;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[6] = 1.5;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[7] = (gdouble) 0;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[8] = (gdouble) 10;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[9] = 1.05;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[10] = 0.10;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[11] = 0.02;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[12] = 0.15;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[13] = 0.1;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[14] = 0.75;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[15] = 1.0 / 20;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[16] = (gdouble) 7;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[17] = 1.05;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[18] = 0.90;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[19] = 0.05;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[20] = 0.25;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[21] = 0.1;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[22] = 0.75;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[23] = (gdouble) 0;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[24] = (gdouble) 7;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[25] = 1.05;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[26] = 0.90;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[27] = 0.01;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[28] = 0.15;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[29] = 0.05;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[30] = 1.0;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[31] = 1.0 / 14;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[32] = (gdouble) 5;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[33] = 1.09;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[34] = 0.40;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[35] = 0.01;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[36] = 0.20;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[37] = -0.01;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[38] = 1.0;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[39] = (gdouble) 0;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[40] = (gdouble) 10;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[41] = 1.02;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[42] = 0.65;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[43] = 0.05;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[44] = 0.15;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[45] = -0.02;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[46] = 0.75;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[47] = (gdouble) 0;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[48] = (gdouble) 20;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[49] = 0.20;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[50] = 0.96;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[51] = 0.05;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[52] = 0.40;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[53] = 0.0;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[54] = 2.0;
#line 378 "theme-2d-cairo.vala"
	_tmp3_[55] = (gdouble) 0;
#line 378 "theme-2d-cairo.vala"
	flower = _tmp3_;
#line 378 "theme-2d-cairo.vala"
	flower_length1 = 56;
#line 378 "theme-2d-cairo.vala"
	_flower_size_ = flower_length1;
#line 385 "theme-2d-cairo.vala"
	n = 0;
#line 2929 "theme-2d-cairo.c"
	{
		gint i = 0;
#line 386 "theme-2d-cairo.vala"
		i = 0;
#line 2934 "theme-2d-cairo.c"
		{
			gboolean _tmp4_ = FALSE;
#line 386 "theme-2d-cairo.vala"
			_tmp4_ = TRUE;
#line 386 "theme-2d-cairo.vala"
			while (TRUE) {
#line 2941 "theme-2d-cairo.c"
				gdouble* _tmp6_;
				gint _tmp6__length1;
				gint num_petals = 0;
				gdouble* _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				gdouble _tmp9_;
				gdouble x = 0.0;
				gdouble* _tmp10_;
				gint _tmp10__length1;
				gint _tmp11_;
				gdouble _tmp12_;
				PasangLayout2D _tmp13_;
				gdouble y = 0.0;
				gdouble* _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				gdouble _tmp16_;
				PasangLayout2D _tmp17_;
				gdouble r1 = 0.0;
				gdouble* _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				gdouble _tmp20_;
				PasangLayout2D _tmp21_;
				gdouble r2 = 0.0;
				gdouble* _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				gdouble _tmp24_;
				PasangLayout2D _tmp25_;
				gdouble light = 0.0;
				gdouble* _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				gdouble _tmp28_;
				gdouble grain = 0.0;
				gdouble* _tmp29_;
				gint _tmp29__length1;
				gint _tmp30_;
				gdouble _tmp31_;
				gdouble shift = 0.0;
				gdouble* _tmp32_;
				gint _tmp32__length1;
				gint _tmp33_;
				gdouble _tmp34_;
				PasangRgb _tmp35_ = {0};
				PasangRgb _tmp36_ = {0};
				gdouble* _tmp37_;
				gdouble* _tmp38_;
				gint _tmp38__length1;
#line 386 "theme-2d-cairo.vala"
				if (!_tmp4_) {
#line 2995 "theme-2d-cairo.c"
					gint _tmp5_;
#line 386 "theme-2d-cairo.vala"
					_tmp5_ = i;
#line 386 "theme-2d-cairo.vala"
					i = _tmp5_ + 1;
#line 3001 "theme-2d-cairo.c"
				}
#line 386 "theme-2d-cairo.vala"
				_tmp4_ = FALSE;
#line 386 "theme-2d-cairo.vala"
				_tmp6_ = flower;
#line 386 "theme-2d-cairo.vala"
				_tmp6__length1 = flower_length1;
#line 386 "theme-2d-cairo.vala"
				if (!(i < (_tmp6__length1 / 8))) {
#line 386 "theme-2d-cairo.vala"
					break;
#line 3013 "theme-2d-cairo.c"
				}
#line 387 "theme-2d-cairo.vala"
				cairo_save (cr);
#line 388 "theme-2d-cairo.vala"
				_tmp7_ = flower;
#line 388 "theme-2d-cairo.vala"
				_tmp7__length1 = flower_length1;
#line 388 "theme-2d-cairo.vala"
				_tmp8_ = n;
#line 388 "theme-2d-cairo.vala"
				n = _tmp8_ + 1;
#line 388 "theme-2d-cairo.vala"
				_tmp9_ = _tmp7_[_tmp8_];
#line 388 "theme-2d-cairo.vala"
				num_petals = (gint) _tmp9_;
#line 389 "theme-2d-cairo.vala"
				_tmp10_ = flower;
#line 389 "theme-2d-cairo.vala"
				_tmp10__length1 = flower_length1;
#line 389 "theme-2d-cairo.vala"
				_tmp11_ = n;
#line 389 "theme-2d-cairo.vala"
				n = _tmp11_ + 1;
#line 389 "theme-2d-cairo.vala"
				_tmp12_ = _tmp10_[_tmp11_];
#line 389 "theme-2d-cairo.vala"
				_tmp13_ = ((PasangTheme2D*) self)->table;
#line 389 "theme-2d-cairo.vala"
				x = _tmp12_ * _tmp13_.height;
#line 390 "theme-2d-cairo.vala"
				_tmp14_ = flower;
#line 390 "theme-2d-cairo.vala"
				_tmp14__length1 = flower_length1;
#line 390 "theme-2d-cairo.vala"
				_tmp15_ = n;
#line 390 "theme-2d-cairo.vala"
				n = _tmp15_ + 1;
#line 390 "theme-2d-cairo.vala"
				_tmp16_ = _tmp14_[_tmp15_];
#line 390 "theme-2d-cairo.vala"
				_tmp17_ = ((PasangTheme2D*) self)->table;
#line 390 "theme-2d-cairo.vala"
				y = _tmp16_ * _tmp17_.height;
#line 391 "theme-2d-cairo.vala"
				_tmp18_ = flower;
#line 391 "theme-2d-cairo.vala"
				_tmp18__length1 = flower_length1;
#line 391 "theme-2d-cairo.vala"
				_tmp19_ = n;
#line 391 "theme-2d-cairo.vala"
				n = _tmp19_ + 1;
#line 391 "theme-2d-cairo.vala"
				_tmp20_ = _tmp18_[_tmp19_];
#line 391 "theme-2d-cairo.vala"
				_tmp21_ = ((PasangTheme2D*) self)->table;
#line 391 "theme-2d-cairo.vala"
				r1 = _tmp20_ * _tmp21_.height;
#line 392 "theme-2d-cairo.vala"
				_tmp22_ = flower;
#line 392 "theme-2d-cairo.vala"
				_tmp22__length1 = flower_length1;
#line 392 "theme-2d-cairo.vala"
				_tmp23_ = n;
#line 392 "theme-2d-cairo.vala"
				n = _tmp23_ + 1;
#line 392 "theme-2d-cairo.vala"
				_tmp24_ = _tmp22_[_tmp23_];
#line 392 "theme-2d-cairo.vala"
				_tmp25_ = ((PasangTheme2D*) self)->table;
#line 392 "theme-2d-cairo.vala"
				r2 = _tmp24_ * _tmp25_.height;
#line 393 "theme-2d-cairo.vala"
				_tmp26_ = flower;
#line 393 "theme-2d-cairo.vala"
				_tmp26__length1 = flower_length1;
#line 393 "theme-2d-cairo.vala"
				_tmp27_ = n;
#line 393 "theme-2d-cairo.vala"
				n = _tmp27_ + 1;
#line 393 "theme-2d-cairo.vala"
				_tmp28_ = _tmp26_[_tmp27_];
#line 393 "theme-2d-cairo.vala"
				light = _tmp28_;
#line 394 "theme-2d-cairo.vala"
				_tmp29_ = flower;
#line 394 "theme-2d-cairo.vala"
				_tmp29__length1 = flower_length1;
#line 394 "theme-2d-cairo.vala"
				_tmp30_ = n;
#line 394 "theme-2d-cairo.vala"
				n = _tmp30_ + 1;
#line 394 "theme-2d-cairo.vala"
				_tmp31_ = _tmp29_[_tmp30_];
#line 394 "theme-2d-cairo.vala"
				grain = _tmp31_;
#line 395 "theme-2d-cairo.vala"
				_tmp32_ = flower;
#line 395 "theme-2d-cairo.vala"
				_tmp32__length1 = flower_length1;
#line 395 "theme-2d-cairo.vala"
				_tmp33_ = n;
#line 395 "theme-2d-cairo.vala"
				n = _tmp33_ + 1;
#line 395 "theme-2d-cairo.vala"
				_tmp34_ = _tmp32_[_tmp33_];
#line 395 "theme-2d-cairo.vala"
				shift = (_tmp34_ * 2) * G_PI;
#line 396 "theme-2d-cairo.vala"
				pasang_theme2_dcairo_trace_flower (self, cr, num_petals, x, y, r1, r2, shift, 0);
#line 397 "theme-2d-cairo.vala"
				cairo_clip (cr);
#line 398 "theme-2d-cairo.vala"
				pasang_rgb_lighten (&self->priv->flower_color, light, &_tmp35_);
#line 398 "theme-2d-cairo.vala"
				pasang_rgb_set_source_for (&_tmp35_, cr);
#line 399 "theme-2d-cairo.vala"
				cairo_paint (cr);
#line 400 "theme-2d-cairo.vala"
				pasang_rgb_lighten (&self->priv->flower_color, 0.5, &_tmp36_);
#line 400 "theme-2d-cairo.vala"
				pasang_theme2_dcairo_draw_grids (self, cr, &_tmp36_, 0.1);
#line 401 "theme-2d-cairo.vala"
				_tmp37_ = g_new0 (gdouble, 12);
#line 401 "theme-2d-cairo.vala"
				_tmp37_[0] = grain;
#line 401 "theme-2d-cairo.vala"
				_tmp37_[1] = 0.1;
#line 401 "theme-2d-cairo.vala"
				_tmp37_[2] = (gdouble) 0;
#line 401 "theme-2d-cairo.vala"
				_tmp37_[3] = (gdouble) 0;
#line 401 "theme-2d-cairo.vala"
				_tmp37_[4] = (gdouble) 1;
#line 401 "theme-2d-cairo.vala"
				_tmp37_[5] = (gdouble) 1;
#line 401 "theme-2d-cairo.vala"
				_tmp37_[6] = grain;
#line 401 "theme-2d-cairo.vala"
				_tmp37_[7] = 0.1;
#line 401 "theme-2d-cairo.vala"
				_tmp37_[8] = (gdouble) 0;
#line 401 "theme-2d-cairo.vala"
				_tmp37_[9] = (gdouble) 0;
#line 401 "theme-2d-cairo.vala"
				_tmp37_[10] = (gdouble) 1;
#line 401 "theme-2d-cairo.vala"
				_tmp37_[11] = (gdouble) 0;
#line 401 "theme-2d-cairo.vala"
				_tmp38_ = _tmp37_;
#line 401 "theme-2d-cairo.vala"
				_tmp38__length1 = 12;
#line 401 "theme-2d-cairo.vala"
				pasang_theme2_dcairo_paint_texture (self, cr, 2, _tmp38_, (gint) 12);
#line 401 "theme-2d-cairo.vala"
				_tmp38_ = (g_free (_tmp38_), NULL);
#line 402 "theme-2d-cairo.vala"
				cairo_restore (cr);
#line 3171 "theme-2d-cairo.c"
			}
		}
	}
#line 371 "theme-2d-cairo.vala"
	flower = (g_free (flower), NULL);
#line 3177 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_forge_table_galaxy (PasangTheme2DCairo* self,
                                         cairo_t* cr)
{
	gint gap = 0;
	cairo_pattern_t* shade = NULL;
	PasangLayout2D _tmp0_;
	cairo_pattern_t* _tmp1_;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	cairo_pattern_t* _tmp4_;
	cairo_surface_t** brush = NULL;
	PasangRgb _tmp5_ = {0};
	PasangRgb _tmp6_ = {0};
	PasangRgb _tmp7_ = {0};
	PasangRgb _tmp8_ = {0};
	PasangRgb _tmp9_ = {0};
	PasangRgb _tmp10_ = {0};
	gint _tmp11_ = 0;
	cairo_surface_t** _tmp12_;
	gint brush_length1;
	gint _brush_size_;
	gdouble line_width = 0.0;
	gint brush_width = 0;
	cairo_surface_t** _tmp13_;
	gint _tmp13__length1;
	cairo_surface_t* _tmp14_;
#line 406 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 406 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 407 "theme-2d-cairo.vala"
	gap = pasang_theme2_d_cell_width ((PasangTheme2D*) self);
#line 408 "theme-2d-cairo.vala"
	_tmp0_ = ((PasangTheme2D*) self)->table;
#line 408 "theme-2d-cairo.vala"
	_tmp1_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) 0, (gdouble) _tmp0_.width, (gdouble) 0);
#line 408 "theme-2d-cairo.vala"
	shade = _tmp1_;
#line 409 "theme-2d-cairo.vala"
	_tmp2_ = shade;
#line 409 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgb (_tmp2_, 0.8, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 410 "theme-2d-cairo.vala"
	_tmp3_ = shade;
#line 410 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgb (_tmp3_, 0.9, 0.07, 0.01, 0.01);
#line 411 "theme-2d-cairo.vala"
	_tmp4_ = shade;
#line 411 "theme-2d-cairo.vala"
	cairo_set_source (cr, _tmp4_);
#line 412 "theme-2d-cairo.vala"
	cairo_paint (cr);
#line 414 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp5_, (gdouble) 1, 0.9, 0.64, (gdouble) 1);
#line 414 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp6_, 0.9, 0.95, 0.23, (gdouble) 1);
#line 414 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp7_, (gdouble) 1, 0.91, 0.5, (gdouble) 1);
#line 414 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp8_, 0.99, 0.79, (gdouble) 0, (gdouble) 1);
#line 414 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp9_, 0.99, 0.55, (gdouble) 0, (gdouble) 1);
#line 414 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp10_, 0.99, 0.19, (gdouble) 0, (gdouble) 1);
#line 414 "theme-2d-cairo.vala"
	_tmp12_ = pasang_theme2_dcairo_create_spark_brush (self, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
#line 414 "theme-2d-cairo.vala"
	brush = _tmp12_;
#line 414 "theme-2d-cairo.vala"
	brush_length1 = _tmp11_;
#line 414 "theme-2d-cairo.vala"
	_brush_size_ = brush_length1;
#line 418 "theme-2d-cairo.vala"
	line_width = 0.2 * gap;
#line 419 "theme-2d-cairo.vala"
	_tmp13_ = brush;
#line 419 "theme-2d-cairo.vala"
	_tmp13__length1 = brush_length1;
#line 419 "theme-2d-cairo.vala"
	_tmp14_ = _tmp13_[0];
#line 419 "theme-2d-cairo.vala"
	brush_width = cairo_image_surface_get_width (_tmp14_);
#line 3263 "theme-2d-cairo.c"
	{
		gdouble y = 0.0;
#line 420 "theme-2d-cairo.vala"
		y = 1.5 * gap;
#line 3268 "theme-2d-cairo.c"
		{
			gboolean _tmp15_ = FALSE;
#line 420 "theme-2d-cairo.vala"
			_tmp15_ = TRUE;
#line 420 "theme-2d-cairo.vala"
			while (TRUE) {
#line 420 "theme-2d-cairo.vala"
				if (!_tmp15_) {
#line 420 "theme-2d-cairo.vala"
					y += (gdouble) gap;
#line 3279 "theme-2d-cairo.c"
				}
#line 420 "theme-2d-cairo.vala"
				_tmp15_ = FALSE;
#line 420 "theme-2d-cairo.vala"
				if (!(y <= (11.5 * gap))) {
#line 420 "theme-2d-cairo.vala"
					break;
#line 3287 "theme-2d-cairo.c"
				}
				{
					gdouble x = 0.0;
#line 421 "theme-2d-cairo.vala"
					x = 1.5 * gap;
#line 3293 "theme-2d-cairo.c"
					{
						gboolean _tmp16_ = FALSE;
#line 421 "theme-2d-cairo.vala"
						_tmp16_ = TRUE;
#line 421 "theme-2d-cairo.vala"
						while (TRUE) {
#line 3300 "theme-2d-cairo.c"
							gboolean _tmp17_ = FALSE;
							gboolean _tmp18_ = FALSE;
							gboolean _tmp19_ = FALSE;
							cairo_surface_t** _tmp20_;
							gint _tmp20__length1;
							cairo_surface_t** _tmp21_;
							gint _tmp21__length1;
							cairo_surface_t* _tmp22_;
							cairo_surface_t** _tmp23_;
							gint _tmp23__length1;
							cairo_surface_t** _tmp24_;
							gint _tmp24__length1;
							cairo_surface_t* _tmp25_;
#line 421 "theme-2d-cairo.vala"
							if (!_tmp16_) {
#line 421 "theme-2d-cairo.vala"
								x += 0.05 * gap;
#line 3318 "theme-2d-cairo.c"
							}
#line 421 "theme-2d-cairo.vala"
							_tmp16_ = FALSE;
#line 421 "theme-2d-cairo.vala"
							if (!(x <= (11.5 * gap))) {
#line 421 "theme-2d-cairo.vala"
								break;
#line 3326 "theme-2d-cairo.c"
							}
#line 422 "theme-2d-cairo.vala"
							if (y > (5.5 * gap)) {
#line 422 "theme-2d-cairo.vala"
								_tmp19_ = y < (7.5 * gap);
#line 3332 "theme-2d-cairo.c"
							} else {
#line 422 "theme-2d-cairo.vala"
								_tmp19_ = FALSE;
#line 3336 "theme-2d-cairo.c"
							}
#line 422 "theme-2d-cairo.vala"
							if (_tmp19_) {
#line 422 "theme-2d-cairo.vala"
								_tmp18_ = x > (5.5 * gap);
#line 3342 "theme-2d-cairo.c"
							} else {
#line 422 "theme-2d-cairo.vala"
								_tmp18_ = FALSE;
#line 3346 "theme-2d-cairo.c"
							}
#line 422 "theme-2d-cairo.vala"
							if (_tmp18_) {
#line 422 "theme-2d-cairo.vala"
								_tmp17_ = x < (7.5 * gap);
#line 3352 "theme-2d-cairo.c"
							} else {
#line 422 "theme-2d-cairo.vala"
								_tmp17_ = FALSE;
#line 3356 "theme-2d-cairo.c"
							}
#line 422 "theme-2d-cairo.vala"
							if (_tmp17_) {
#line 422 "theme-2d-cairo.vala"
								continue;
#line 3362 "theme-2d-cairo.c"
							}
#line 423 "theme-2d-cairo.vala"
							cairo_save (cr);
#line 424 "theme-2d-cairo.vala"
							cairo_translate (cr, x - (line_width / 2), y - (line_width / 2));
#line 425 "theme-2d-cairo.vala"
							cairo_scale (cr, line_width / brush_width, line_width / brush_width);
#line 426 "theme-2d-cairo.vala"
							cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) brush_width, (gdouble) brush_width);
#line 427 "theme-2d-cairo.vala"
							_tmp20_ = brush;
#line 427 "theme-2d-cairo.vala"
							_tmp20__length1 = brush_length1;
#line 427 "theme-2d-cairo.vala"
							_tmp21_ = brush;
#line 427 "theme-2d-cairo.vala"
							_tmp21__length1 = brush_length1;
#line 427 "theme-2d-cairo.vala"
							_tmp22_ = _tmp20_[g_random_int_range ((gint32) 0, (gint32) _tmp21__length1)];
#line 427 "theme-2d-cairo.vala"
							cairo_set_source_surface (cr, _tmp22_, (gdouble) 0, (gdouble) 0);
#line 428 "theme-2d-cairo.vala"
							cairo_fill (cr);
#line 429 "theme-2d-cairo.vala"
							cairo_restore (cr);
#line 431 "theme-2d-cairo.vala"
							cairo_save (cr);
#line 432 "theme-2d-cairo.vala"
							cairo_translate (cr, y - (line_width / 2), x - (line_width / 2));
#line 433 "theme-2d-cairo.vala"
							cairo_scale (cr, line_width / brush_width, line_width / brush_width);
#line 434 "theme-2d-cairo.vala"
							cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) brush_width, (gdouble) brush_width);
#line 435 "theme-2d-cairo.vala"
							_tmp23_ = brush;
#line 435 "theme-2d-cairo.vala"
							_tmp23__length1 = brush_length1;
#line 435 "theme-2d-cairo.vala"
							_tmp24_ = brush;
#line 435 "theme-2d-cairo.vala"
							_tmp24__length1 = brush_length1;
#line 435 "theme-2d-cairo.vala"
							_tmp25_ = _tmp23_[g_random_int_range ((gint32) 0, (gint32) _tmp24__length1)];
#line 435 "theme-2d-cairo.vala"
							cairo_set_source_surface (cr, _tmp25_, (gdouble) 0, (gdouble) 0);
#line 436 "theme-2d-cairo.vala"
							cairo_fill (cr);
#line 437 "theme-2d-cairo.vala"
							cairo_restore (cr);
#line 3412 "theme-2d-cairo.c"
						}
					}
				}
			}
		}
	}
#line 406 "theme-2d-cairo.vala"
	brush = (_vala_array_free (brush, brush_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
#line 406 "theme-2d-cairo.vala"
	_cairo_pattern_destroy0 (shade);
#line 3423 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_shine_light (PasangTheme2DCairo* self,
                                  cairo_t* cr,
                                  gdouble brightness,
                                  gdouble radius,
                                  gdouble tilt)
{
	gdouble spot_angle = 0.0;
	gdouble spot_radius = 0.0;
	gdouble spot_x = 0.0;
	gdouble spot_y = 0.0;
	cairo_pattern_t* shade = NULL;
	cairo_pattern_t* _tmp0_;
#line 442 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 442 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 443 "theme-2d-cairo.vala"
	spot_angle = (0.25 * G_PI) - ((0.75 * G_PI) * tilt);
#line 444 "theme-2d-cairo.vala"
	spot_radius = radius * (0.5 + (0.3 * tilt));
#line 445 "theme-2d-cairo.vala"
	spot_x = spot_radius * cos (spot_angle);
#line 446 "theme-2d-cairo.vala"
	spot_y = spot_radius * sin (spot_angle);
#line 447 "theme-2d-cairo.vala"
	_tmp0_ = cairo_pattern_create_radial (-spot_x, -spot_y, (gdouble) 0, (gdouble) 0, (gdouble) 0, radius);
#line 447 "theme-2d-cairo.vala"
	shade = _tmp0_;
#line 448 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgba (shade, 0.0, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.95 * brightness);
#line 449 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgba (shade, 0.3, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.5 * brightness);
#line 450 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgba (shade, 1.0, 0.2, 0.2, 0.2, 0.2 * brightness);
#line 451 "theme-2d-cairo.vala"
	cairo_set_source (cr, shade);
#line 452 "theme-2d-cairo.vala"
	cairo_arc (cr, (gdouble) 0, (gdouble) 0, radius, (gdouble) 0, 2 * G_PI);
#line 453 "theme-2d-cairo.vala"
	cairo_fill (cr);
#line 442 "theme-2d-cairo.vala"
	_cairo_pattern_destroy0 (shade);
#line 3469 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_forge_piece_spin (PasangTheme2DCairo* self,
                                       cairo_t* cr,
                                       PasangPiece piece,
                                       gint size,
                                       gint f)
{
	gint _tmp0_ = 0;
	gint n_rotation = 0;
	PasangRgb* rgb1 = NULL;
	PasangRgb _tmp1_ = {0};
	PasangRgb _tmp2_ = {0};
	PasangRgb _tmp3_ = {0};
	PasangRgb _tmp4_ = {0};
	PasangRgb* _tmp5_;
	gint rgb1_length1;
	gint _rgb1_size_;
	PasangRgb* rgb2 = NULL;
	PasangRgb _tmp6_ = {0};
	PasangRgb _tmp7_ = {0};
	PasangRgb _tmp8_ = {0};
	PasangRgb _tmp9_ = {0};
	PasangRgb* _tmp10_;
	gint rgb2_length1;
	gint _rgb2_size_;
	PasangRgb dark = {0};
	PasangRgb* _tmp11_;
	gint _tmp11__length1;
	PasangRgb _tmp12_;
	PasangRgb light = {0};
	PasangRgb* _tmp13_;
	gint _tmp13__length1;
	PasangRgb _tmp14_;
	gdouble _tmp15_ = 0.0;
	gboolean _tmp16_ = FALSE;
	gdouble radius = 0.0;
	cairo_pattern_t* color1 = NULL;
	cairo_pattern_t* _tmp17_;
	PasangRgb _tmp18_;
	PasangRgb _tmp19_;
	PasangRgb _tmp20_;
	PasangRgb _tmp21_;
	PasangRgb _tmp22_;
	PasangRgb _tmp23_;
	PasangRgb _tmp24_;
	PasangRgb _tmp25_;
	PasangRgb _tmp26_;
	cairo_pattern_t* color2 = NULL;
	cairo_pattern_t* _tmp27_;
	PasangRgb _tmp28_;
	PasangRgb _tmp29_;
	PasangRgb _tmp30_;
	PasangRgb _tmp31_;
	PasangRgb _tmp32_;
	PasangRgb _tmp33_;
	PasangRgb _tmp34_;
	PasangRgb _tmp35_;
	PasangRgb _tmp36_;
#line 456 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 456 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 457 "theme-2d-cairo.vala"
	cairo_save (cr);
#line 458 "theme-2d-cairo.vala"
	if (pasang_piece_is_kas (piece)) {
#line 458 "theme-2d-cairo.vala"
		_tmp0_ = 1;
#line 3540 "theme-2d-cairo.c"
	} else {
#line 458 "theme-2d-cairo.vala"
		_tmp0_ = 2;
#line 3544 "theme-2d-cairo.c"
	}
#line 458 "theme-2d-cairo.vala"
	n_rotation = _tmp0_;
#line 459 "theme-2d-cairo.vala"
	cairo_rotate (cr, (((n_rotation * 2) * G_PI) * f) / (self->priv->num_frames - 1));
#line 460 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp1_, 1.0, 0.1, 0.3, (gdouble) 1);
#line 460 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp2_, 0.1, 0.3, 1.0, (gdouble) 1);
#line 460 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp3_, 0.0, 0.0, 0.0, (gdouble) 1);
#line 460 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp4_, 0.8, 0.8, 0.8, (gdouble) 1);
#line 460 "theme-2d-cairo.vala"
	_tmp5_ = g_new0 (PasangRgb, 4);
#line 460 "theme-2d-cairo.vala"
	_tmp5_[0] = _tmp1_;
#line 460 "theme-2d-cairo.vala"
	_tmp5_[1] = _tmp2_;
#line 460 "theme-2d-cairo.vala"
	_tmp5_[2] = _tmp3_;
#line 460 "theme-2d-cairo.vala"
	_tmp5_[3] = _tmp4_;
#line 460 "theme-2d-cairo.vala"
	rgb1 = _tmp5_;
#line 460 "theme-2d-cairo.vala"
	rgb1_length1 = 4;
#line 460 "theme-2d-cairo.vala"
	_rgb1_size_ = rgb1_length1;
#line 461 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp6_, 1.0, 0.4, 0.6, (gdouble) 1);
#line 461 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp7_, 0.4, 0.6, 1.0, (gdouble) 1);
#line 461 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp8_, 0.2, 0.2, 0.2, (gdouble) 1);
#line 461 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp9_, 0.9, 0.9, 0.9, (gdouble) 1);
#line 461 "theme-2d-cairo.vala"
	_tmp10_ = g_new0 (PasangRgb, 4);
#line 461 "theme-2d-cairo.vala"
	_tmp10_[0] = _tmp6_;
#line 461 "theme-2d-cairo.vala"
	_tmp10_[1] = _tmp7_;
#line 461 "theme-2d-cairo.vala"
	_tmp10_[2] = _tmp8_;
#line 461 "theme-2d-cairo.vala"
	_tmp10_[3] = _tmp9_;
#line 461 "theme-2d-cairo.vala"
	rgb2 = _tmp10_;
#line 461 "theme-2d-cairo.vala"
	rgb2_length1 = 4;
#line 461 "theme-2d-cairo.vala"
	_rgb2_size_ = rgb2_length1;
#line 462 "theme-2d-cairo.vala"
	_tmp11_ = rgb1;
#line 462 "theme-2d-cairo.vala"
	_tmp11__length1 = rgb1_length1;
#line 462 "theme-2d-cairo.vala"
	_tmp12_ = _tmp11_[piece];
#line 462 "theme-2d-cairo.vala"
	dark = _tmp12_;
#line 463 "theme-2d-cairo.vala"
	_tmp13_ = rgb2;
#line 463 "theme-2d-cairo.vala"
	_tmp13__length1 = rgb2_length1;
#line 463 "theme-2d-cairo.vala"
	_tmp14_ = _tmp13_[piece];
#line 463 "theme-2d-cairo.vala"
	light = _tmp14_;
#line 464 "theme-2d-cairo.vala"
	if (pasang_piece_is_kas (piece)) {
#line 464 "theme-2d-cairo.vala"
		_tmp16_ = TRUE;
#line 3618 "theme-2d-cairo.c"
	} else {
#line 464 "theme-2d-cairo.vala"
		_tmp16_ = f < (self->priv->num_frames / 2);
#line 3622 "theme-2d-cairo.c"
	}
#line 464 "theme-2d-cairo.vala"
	if (_tmp16_) {
#line 464 "theme-2d-cairo.vala"
		_tmp15_ = 0.3;
#line 3628 "theme-2d-cairo.c"
	} else {
#line 464 "theme-2d-cairo.vala"
		_tmp15_ = 0.6 - ((0.6 * f) / (self->priv->num_frames - 1));
#line 3632 "theme-2d-cairo.c"
	}
#line 464 "theme-2d-cairo.vala"
	radius = size * _tmp15_;
#line 465 "theme-2d-cairo.vala"
	_tmp17_ = cairo_pattern_create_radial ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, radius);
#line 465 "theme-2d-cairo.vala"
	color1 = _tmp17_;
#line 466 "theme-2d-cairo.vala"
	_tmp18_ = dark;
#line 466 "theme-2d-cairo.vala"
	_tmp19_ = dark;
#line 466 "theme-2d-cairo.vala"
	_tmp20_ = dark;
#line 466 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgba (color1, 0.0, _tmp18_.red, _tmp19_.green, _tmp20_.blue, 0.9);
#line 467 "theme-2d-cairo.vala"
	_tmp21_ = dark;
#line 467 "theme-2d-cairo.vala"
	_tmp22_ = dark;
#line 467 "theme-2d-cairo.vala"
	_tmp23_ = dark;
#line 467 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgba (color1, 0.8, _tmp21_.red, _tmp22_.green, _tmp23_.blue, 0.95);
#line 468 "theme-2d-cairo.vala"
	_tmp24_ = dark;
#line 468 "theme-2d-cairo.vala"
	_tmp25_ = dark;
#line 468 "theme-2d-cairo.vala"
	_tmp26_ = dark;
#line 468 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgba (color1, 1.0, _tmp24_.red, _tmp25_.green, _tmp26_.blue, 1.0);
#line 469 "theme-2d-cairo.vala"
	cairo_set_source (cr, color1);
#line 470 "theme-2d-cairo.vala"
	cairo_arc (cr, (gdouble) 0, (gdouble) 0, radius, (gdouble) 0, G_PI);
#line 471 "theme-2d-cairo.vala"
	cairo_arc (cr, (-radius) / 2, (gdouble) 0, radius / 2, G_PI, 2 * G_PI);
#line 472 "theme-2d-cairo.vala"
	cairo_arc_negative (cr, radius / 2, (gdouble) 0, (radius / 2) - 0.5, G_PI, (gdouble) 0);
#line 473 "theme-2d-cairo.vala"
	cairo_fill (cr);
#line 474 "theme-2d-cairo.vala"
	_tmp27_ = cairo_pattern_create_radial ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, radius);
#line 474 "theme-2d-cairo.vala"
	color2 = _tmp27_;
#line 475 "theme-2d-cairo.vala"
	_tmp28_ = light;
#line 475 "theme-2d-cairo.vala"
	_tmp29_ = light;
#line 475 "theme-2d-cairo.vala"
	_tmp30_ = light;
#line 475 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgba (color2, 0.0, _tmp28_.red, _tmp29_.green, _tmp30_.blue, 0.9);
#line 476 "theme-2d-cairo.vala"
	_tmp31_ = light;
#line 476 "theme-2d-cairo.vala"
	_tmp32_ = light;
#line 476 "theme-2d-cairo.vala"
	_tmp33_ = light;
#line 476 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgba (color2, 0.8, _tmp31_.red, _tmp32_.green, _tmp33_.blue, 0.95);
#line 477 "theme-2d-cairo.vala"
	_tmp34_ = light;
#line 477 "theme-2d-cairo.vala"
	_tmp35_ = light;
#line 477 "theme-2d-cairo.vala"
	_tmp36_ = light;
#line 477 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgba (color2, 1.0, _tmp34_.red, _tmp35_.green, _tmp36_.blue, 1.0);
#line 478 "theme-2d-cairo.vala"
	cairo_set_source (cr, color2);
#line 479 "theme-2d-cairo.vala"
	cairo_arc (cr, (gdouble) 0, (gdouble) 0, radius, G_PI, 2 * G_PI);
#line 480 "theme-2d-cairo.vala"
	cairo_arc (cr, radius / 2, (gdouble) 0, radius / 2, (gdouble) 0, G_PI);
#line 481 "theme-2d-cairo.vala"
	cairo_arc_negative (cr, (-radius) / 2, (gdouble) 0, (radius / 2) - 0.5, 2 * G_PI, G_PI);
#line 482 "theme-2d-cairo.vala"
	cairo_fill (cr);
#line 483 "theme-2d-cairo.vala"
	cairo_restore (cr);
#line 484 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_shine_light (self, cr, 1.0, radius, 0.0);
#line 456 "theme-2d-cairo.vala"
	_cairo_pattern_destroy0 (color2);
#line 456 "theme-2d-cairo.vala"
	_cairo_pattern_destroy0 (color1);
#line 456 "theme-2d-cairo.vala"
	rgb2 = (g_free (rgb2), NULL);
#line 456 "theme-2d-cairo.vala"
	rgb1 = (g_free (rgb1), NULL);
#line 3724 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_forge_piece_dizzy (PasangTheme2DCairo* self,
                                        cairo_t* cr,
                                        PasangPiece piece,
                                        gint size,
                                        gint f)
{
	PasangRgb* rgb = NULL;
	PasangRgb _tmp0_ = {0};
	PasangRgb _tmp1_ = {0};
	PasangRgb _tmp2_ = {0};
	PasangRgb _tmp3_ = {0};
	PasangRgb* _tmp4_;
	gint rgb_length1;
	gint _rgb_size_;
	PasangRgb paint = {0};
	PasangRgb* _tmp5_;
	gint _tmp5__length1;
	PasangRgb _tmp6_;
	gdouble phase = 0.0;
	gint num_rings = 0;
	gdouble band = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble radius = 0.0;
	gdouble alpha = 0.0;
	gboolean _tmp8_ = FALSE;
	gdouble delta = 0.0;
	cairo_pattern_t* color = NULL;
	cairo_pattern_t* _tmp11_;
	PasangRgb _tmp12_;
	PasangRgb _tmp13_;
	PasangRgb _tmp14_;
	PasangRgb _tmp15_;
	PasangRgb _tmp16_;
	PasangRgb _tmp17_;
	PasangRgb _tmp18_;
	PasangRgb _tmp19_;
	PasangRgb _tmp20_;
#line 487 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 487 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 488 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp0_, 1.0, 0.0, 0.0, (gdouble) 1);
#line 488 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp1_, 0.0, 0.0, 1.0, (gdouble) 1);
#line 488 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp2_, 0.0, 0.0, 0.0, (gdouble) 1);
#line 488 "theme-2d-cairo.vala"
	pasang_rgb_init (&_tmp3_, 1.0, 1.0, 1.0, (gdouble) 1);
#line 488 "theme-2d-cairo.vala"
	_tmp4_ = g_new0 (PasangRgb, 4);
#line 488 "theme-2d-cairo.vala"
	_tmp4_[0] = _tmp0_;
#line 488 "theme-2d-cairo.vala"
	_tmp4_[1] = _tmp1_;
#line 488 "theme-2d-cairo.vala"
	_tmp4_[2] = _tmp2_;
#line 488 "theme-2d-cairo.vala"
	_tmp4_[3] = _tmp3_;
#line 488 "theme-2d-cairo.vala"
	rgb = _tmp4_;
#line 488 "theme-2d-cairo.vala"
	rgb_length1 = 4;
#line 488 "theme-2d-cairo.vala"
	_rgb_size_ = rgb_length1;
#line 489 "theme-2d-cairo.vala"
	_tmp5_ = rgb;
#line 489 "theme-2d-cairo.vala"
	_tmp5__length1 = rgb_length1;
#line 489 "theme-2d-cairo.vala"
	_tmp6_ = _tmp5_[piece];
#line 489 "theme-2d-cairo.vala"
	paint = _tmp6_;
#line 490 "theme-2d-cairo.vala"
	phase = remainder (((4 * G_PI) * f) / (self->priv->num_frames - 1), 2 * G_PI);
#line 491 "theme-2d-cairo.vala"
	num_rings = 5;
#line 492 "theme-2d-cairo.vala"
	band = 0.25;
#line 493 "theme-2d-cairo.vala"
	if (pasang_piece_is_kas (piece)) {
#line 493 "theme-2d-cairo.vala"
		_tmp7_ = 0.3;
#line 3811 "theme-2d-cairo.c"
	} else {
#line 493 "theme-2d-cairo.vala"
		_tmp7_ = 0.3 - (0.05 * sin (phase));
#line 3815 "theme-2d-cairo.c"
	}
#line 493 "theme-2d-cairo.vala"
	radius = size * _tmp7_;
#line 494 "theme-2d-cairo.vala"
	alpha = 1.0;
#line 495 "theme-2d-cairo.vala"
	if (!pasang_piece_is_kas (piece)) {
#line 495 "theme-2d-cairo.vala"
		_tmp8_ = f > (self->priv->num_frames / 2);
#line 3825 "theme-2d-cairo.c"
	} else {
#line 495 "theme-2d-cairo.vala"
		_tmp8_ = FALSE;
#line 3829 "theme-2d-cairo.c"
	}
#line 495 "theme-2d-cairo.vala"
	if (_tmp8_) {
#line 3833 "theme-2d-cairo.c"
		gdouble fade = 0.0;
#line 497 "theme-2d-cairo.vala"
		fade = (cos ((G_PI * (f - (self->priv->num_frames / 2))) / (self->priv->num_frames / 2)) + 1) / 2;
#line 498 "theme-2d-cairo.vala"
		band += 0.9 * (1 - fade);
#line 499 "theme-2d-cairo.vala"
		alpha *= fade;
#line 500 "theme-2d-cairo.vala"
		radius *= 1 + ((1 - fade) / 2);
#line 3843 "theme-2d-cairo.c"
	}
#line 502 "theme-2d-cairo.vala"
	delta = phase / (2 * G_PI);
#line 503 "theme-2d-cairo.vala"
	cairo_arc (cr, (gdouble) 0, (gdouble) 0, radius, (gdouble) 0, 2 * G_PI);
#line 3849 "theme-2d-cairo.c"
	{
		gint ring = 0;
#line 504 "theme-2d-cairo.vala"
		ring = num_rings;
#line 3854 "theme-2d-cairo.c"
		{
			gboolean _tmp9_ = FALSE;
#line 504 "theme-2d-cairo.vala"
			_tmp9_ = TRUE;
#line 504 "theme-2d-cairo.vala"
			while (TRUE) {
#line 3861 "theme-2d-cairo.c"
				gdouble r = 0.0;
				gdouble r2 = 0.0;
#line 504 "theme-2d-cairo.vala"
				if (!_tmp9_) {
#line 3866 "theme-2d-cairo.c"
					gint _tmp10_;
#line 504 "theme-2d-cairo.vala"
					_tmp10_ = ring;
#line 504 "theme-2d-cairo.vala"
					ring = _tmp10_ - 1;
#line 3872 "theme-2d-cairo.c"
				}
#line 504 "theme-2d-cairo.vala"
				_tmp9_ = FALSE;
#line 504 "theme-2d-cairo.vala"
				if (!(ring >= 0)) {
#line 504 "theme-2d-cairo.vala"
					break;
#line 3880 "theme-2d-cairo.c"
				}
#line 505 "theme-2d-cairo.vala"
				r = ((delta + ring) * radius) / num_rings;
#line 506 "theme-2d-cairo.vala"
				r2 = (((delta + ring) - band) * radius) / num_rings;
#line 507 "theme-2d-cairo.vala"
				if (r > radius) {
#line 507 "theme-2d-cairo.vala"
					continue;
#line 3890 "theme-2d-cairo.c"
				}
#line 508 "theme-2d-cairo.vala"
				cairo_arc_negative (cr, (gdouble) 0, (gdouble) 0, r, 2 * G_PI, (gdouble) 0);
#line 509 "theme-2d-cairo.vala"
				cairo_arc (cr, (gdouble) 0, (gdouble) 0, r2, (gdouble) 0, 2 * G_PI);
#line 3896 "theme-2d-cairo.c"
			}
		}
	}
#line 511 "theme-2d-cairo.vala"
	_tmp11_ = cairo_pattern_create_radial ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, radius);
#line 511 "theme-2d-cairo.vala"
	color = _tmp11_;
#line 512 "theme-2d-cairo.vala"
	_tmp12_ = paint;
#line 512 "theme-2d-cairo.vala"
	_tmp13_ = paint;
#line 512 "theme-2d-cairo.vala"
	_tmp14_ = paint;
#line 512 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgba (color, 0.0, _tmp12_.red, _tmp13_.green, _tmp14_.blue, 1.0 * alpha);
#line 513 "theme-2d-cairo.vala"
	_tmp15_ = paint;
#line 513 "theme-2d-cairo.vala"
	_tmp16_ = paint;
#line 513 "theme-2d-cairo.vala"
	_tmp17_ = paint;
#line 513 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgba (color, 0.8, _tmp15_.red, _tmp16_.green, _tmp17_.blue, 0.8 * alpha);
#line 514 "theme-2d-cairo.vala"
	_tmp18_ = paint;
#line 514 "theme-2d-cairo.vala"
	_tmp19_ = paint;
#line 514 "theme-2d-cairo.vala"
	_tmp20_ = paint;
#line 514 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgba (color, 1.0, _tmp18_.red, _tmp19_.green, _tmp20_.blue, 0.0 * alpha);
#line 515 "theme-2d-cairo.vala"
	cairo_set_source (cr, color);
#line 516 "theme-2d-cairo.vala"
	cairo_fill (cr);
#line 517 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_shine_light (self, cr, alpha, radius, 0.0);
#line 487 "theme-2d-cairo.vala"
	_cairo_pattern_destroy0 (color);
#line 487 "theme-2d-cairo.vala"
	rgb = (g_free (rgb), NULL);
#line 3938 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_forge_piece_tv (PasangTheme2DCairo* self,
                                     cairo_t* cr,
                                     PasangPiece piece,
                                     gint size,
                                     gint f)
{
#line 520 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 520 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 521 "theme-2d-cairo.vala"
	if (pasang_piece_is_kas (piece)) {
#line 522 "theme-2d-cairo.vala"
		pasang_theme2_dcairo_tv_control (self, cr, piece, size, f);
#line 3956 "theme-2d-cairo.c"
	} else {
#line 524 "theme-2d-cairo.vala"
		pasang_theme2_dcairo_tv_box (self, cr, piece, size, f);
#line 3960 "theme-2d-cairo.c"
	}
}

static void
pasang_theme2_dcairo_tv_control (PasangTheme2DCairo* self,
                                 cairo_t* cr,
                                 PasangPiece piece,
                                 gint size,
                                 gint f)
{
	PasangRgb _tmp0_ = {0};
	PasangRgb paint = {0};
	gdouble width = 0.0;
	gdouble height = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble shadow_depth = 0.0;
	PasangRgb _tmp1_ = {0};
	gdouble proportion = 0.0;
	gdouble button_width = 0.0;
	gdouble shadow_width = 0.0;
	gint _tmp2_ = 0;
	gint pressed_button = 0;
#line 527 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 527 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 528 "theme-2d-cairo.vala"
	if (piece == PASANG_PIECE_KAS_0) {
#line 528 "theme-2d-cairo.vala"
		pasang_rgb_init (&_tmp0_, 1.0, 0.2, 0.3, (gdouble) 1);
#line 3992 "theme-2d-cairo.c"
	} else {
#line 528 "theme-2d-cairo.vala"
		pasang_rgb_init (&_tmp0_, 0.3, 0.5, 1.0, (gdouble) 1);
#line 3996 "theme-2d-cairo.c"
	}
#line 528 "theme-2d-cairo.vala"
	paint = _tmp0_;
#line 529 "theme-2d-cairo.vala"
	width = 0.3 * size;
#line 530 "theme-2d-cairo.vala"
	height = 0.5 * size;
#line 531 "theme-2d-cairo.vala"
	x = (-0.15) * size;
#line 532 "theme-2d-cairo.vala"
	y = (-0.25) * size;
#line 533 "theme-2d-cairo.vala"
	shadow_depth = 0.05 * width;
#line 534 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_trace_rounded_rectangle (self, cr, x + shadow_depth, y + shadow_depth, width, height, 0.15 * width);
#line 535 "theme-2d-cairo.vala"
	pasang_rgb_darken (&paint, 0.5, &_tmp1_);
#line 535 "theme-2d-cairo.vala"
	pasang_rgb_set_source_for (&_tmp1_, cr);
#line 536 "theme-2d-cairo.vala"
	cairo_fill (cr);
#line 537 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_trace_rounded_rectangle (self, cr, x, y, width, height, 0.15 * width);
#line 538 "theme-2d-cairo.vala"
	pasang_rgb_set_source_for (&paint, cr);
#line 539 "theme-2d-cairo.vala"
	cairo_fill (cr);
#line 543 "theme-2d-cairo.vala"
	proportion = 3.8;
#line 544 "theme-2d-cairo.vala"
	button_width = (0.9 * width) / proportion;
#line 545 "theme-2d-cairo.vala"
	shadow_width = (0.1 * width) / proportion;
#line 546 "theme-2d-cairo.vala"
	if ((f % 2) == 0) {
#line 546 "theme-2d-cairo.vala"
		_tmp2_ = -1;
#line 4034 "theme-2d-cairo.c"
	} else {
#line 546 "theme-2d-cairo.vala"
		_tmp2_ = (gint) g_random_int_range ((gint32) 0, (gint32) 15);
#line 4038 "theme-2d-cairo.c"
	}
#line 546 "theme-2d-cairo.vala"
	pressed_button = _tmp2_;
#line 4042 "theme-2d-cairo.c"
	{
		gint i = 0;
#line 547 "theme-2d-cairo.vala"
		i = 0;
#line 4047 "theme-2d-cairo.c"
		{
			gboolean _tmp3_ = FALSE;
#line 547 "theme-2d-cairo.vala"
			_tmp3_ = TRUE;
#line 547 "theme-2d-cairo.vala"
			while (TRUE) {
#line 4054 "theme-2d-cairo.c"
				gint col = 0;
				gint row = 0;
				gdouble x2 = 0.0;
				gdouble y2 = 0.0;
				PasangRgb _tmp5_ = {0};
				PasangRgb _tmp6_ = {0};
#line 547 "theme-2d-cairo.vala"
				if (!_tmp3_) {
#line 4063 "theme-2d-cairo.c"
					gint _tmp4_;
#line 547 "theme-2d-cairo.vala"
					_tmp4_ = i;
#line 547 "theme-2d-cairo.vala"
					i = _tmp4_ + 1;
#line 4069 "theme-2d-cairo.c"
				}
#line 547 "theme-2d-cairo.vala"
				_tmp3_ = FALSE;
#line 547 "theme-2d-cairo.vala"
				if (!(i < 15)) {
#line 547 "theme-2d-cairo.vala"
					break;
#line 4077 "theme-2d-cairo.c"
				}
#line 548 "theme-2d-cairo.vala"
				col = i % 3;
#line 549 "theme-2d-cairo.vala"
				row = i / 3;
#line 550 "theme-2d-cairo.vala"
				x2 = x + (((0.3 + (col * 1.1)) / proportion) * width);
#line 551 "theme-2d-cairo.vala"
				y2 = y + (((0.4 + (row * 1.1)) / proportion) * width);
#line 552 "theme-2d-cairo.vala"
				pasang_rgb_darken (&paint, 0.5, &_tmp5_);
#line 552 "theme-2d-cairo.vala"
				pasang_theme2_dcairo_fill_rectangle (self, cr, &_tmp5_, x2 + shadow_width, y2 + shadow_width, button_width, button_width);
#line 553 "theme-2d-cairo.vala"
				if (i == pressed_button) {
#line 554 "theme-2d-cairo.vala"
					x2 += shadow_width;
#line 555 "theme-2d-cairo.vala"
					y2 += shadow_width;
#line 4097 "theme-2d-cairo.c"
				}
#line 557 "theme-2d-cairo.vala"
				pasang_rgb_lighten (&paint, 0.5, &_tmp6_);
#line 557 "theme-2d-cairo.vala"
				pasang_theme2_dcairo_fill_rectangle (self, cr, &_tmp6_, x2, y2, button_width, button_width);
#line 4103 "theme-2d-cairo.c"
			}
		}
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
#line 1428 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1429 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1429 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1429 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1430 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1431 "glib-2.0.vapi"
		start = string_length + start;
#line 4133 "theme-2d-cairo.c"
	}
#line 1433 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1434 "glib-2.0.vapi"
		end = string_length + end;
#line 4139 "theme-2d-cairo.c"
	}
#line 1436 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1436 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 4145 "theme-2d-cairo.c"
	} else {
#line 1436 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 4149 "theme-2d-cairo.c"
	}
#line 1436 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1437 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1437 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 4157 "theme-2d-cairo.c"
	} else {
#line 1437 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 4161 "theme-2d-cairo.c"
	}
#line 1437 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1438 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1439 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1439 "glib-2.0.vapi"
	result = _tmp4_;
#line 1439 "glib-2.0.vapi"
	return result;
#line 4173 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_tv_box (PasangTheme2DCairo* self,
                             cairo_t* cr,
                             PasangPiece piece,
                             gint size,
                             gint f)
{
	PasangRgb _tmp0_ = {0};
	PasangRgb paint = {0};
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble width = 0.0;
	gdouble height = 0.0;
	cairo_pattern_t* color = NULL;
	cairo_pattern_t* _tmp3_;
	PasangRgb lighted = {0};
	PasangRgb _tmp4_ = {0};
	cairo_pattern_t* _tmp5_;
	PasangRgb _tmp6_;
	PasangRgb _tmp7_;
	PasangRgb _tmp8_;
	PasangRgb _tmp9_ = {0};
	cairo_pattern_t* _tmp10_;
	PasangRgb _tmp11_;
	PasangRgb _tmp12_;
	PasangRgb _tmp13_;
	cairo_pattern_t* _tmp14_;
	PasangRgb _tmp15_ = {0};
	PasangRgb _tmp16_ = {0};
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	cairo_pattern_t* _tmp17_;
	PasangRgb _tmp18_ = {0};
	cairo_pattern_t* _tmp19_;
	PasangRgb _tmp20_;
	PasangRgb _tmp21_;
	PasangRgb _tmp22_;
	PasangRgb _tmp23_ = {0};
	cairo_pattern_t* _tmp24_;
	PasangRgb _tmp25_;
	PasangRgb _tmp26_;
	PasangRgb _tmp27_;
	cairo_pattern_t* _tmp28_;
	PasangRgb _tmp29_ = {0};
	PasangRgb _tmp30_ = {0};
#line 561 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 561 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 562 "theme-2d-cairo.vala"
	if (piece == PASANG_PIECE_NULL) {
#line 4231 "theme-2d-cairo.c"
		PasangRgb _tmp1_ = {0};
#line 562 "theme-2d-cairo.vala"
		pasang_rgb_darken (&self->priv->tv_color, 0.5, &_tmp1_);
#line 562 "theme-2d-cairo.vala"
		_tmp0_ = _tmp1_;
#line 4237 "theme-2d-cairo.c"
	} else {
		PasangRgb _tmp2_ = {0};
#line 563 "theme-2d-cairo.vala"
		if (piece == PASANG_PIECE_BLACK) {
#line 563 "theme-2d-cairo.vala"
			pasang_rgb_init (&_tmp2_, 0.2, 0.2, 0.2, (gdouble) 1);
#line 4244 "theme-2d-cairo.c"
		} else {
#line 563 "theme-2d-cairo.vala"
			pasang_rgb_init (&_tmp2_, 0.8, 0.8, 0.8, (gdouble) 1);
#line 4248 "theme-2d-cairo.c"
		}
#line 563 "theme-2d-cairo.vala"
		_tmp0_ = _tmp2_;
#line 4252 "theme-2d-cairo.c"
	}
#line 562 "theme-2d-cairo.vala"
	paint = _tmp0_;
#line 566 "theme-2d-cairo.vala"
	x1 = (-0.3) * size;
#line 567 "theme-2d-cairo.vala"
	y1 = (-0.2) * size;
#line 568 "theme-2d-cairo.vala"
	x2 = -x1;
#line 569 "theme-2d-cairo.vala"
	y2 = -y1;
#line 570 "theme-2d-cairo.vala"
	width = 0.6 * size;
#line 571 "theme-2d-cairo.vala"
	height = 0.4 * size;
#line 572 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_trace_rounded_rectangle (self, cr, x1, y1, width, height, 0.1 * width);
#line 573 "theme-2d-cairo.vala"
	cairo_clip (cr);
#line 575 "theme-2d-cairo.vala"
	_tmp3_ = cairo_pattern_create_linear (x1, y1, x1, y2);
#line 575 "theme-2d-cairo.vala"
	color = _tmp3_;
#line 576 "theme-2d-cairo.vala"
	pasang_rgb_lighten (&paint, 0.5, &_tmp4_);
#line 576 "theme-2d-cairo.vala"
	lighted = _tmp4_;
#line 577 "theme-2d-cairo.vala"
	_tmp5_ = color;
#line 577 "theme-2d-cairo.vala"
	_tmp6_ = lighted;
#line 577 "theme-2d-cairo.vala"
	_tmp7_ = lighted;
#line 577 "theme-2d-cairo.vala"
	_tmp8_ = lighted;
#line 577 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgb (_tmp5_, 0.4, _tmp6_.red, _tmp7_.green, _tmp8_.blue);
#line 578 "theme-2d-cairo.vala"
	pasang_rgb_lighten (&paint, -0.5, &_tmp9_);
#line 578 "theme-2d-cairo.vala"
	lighted = _tmp9_;
#line 579 "theme-2d-cairo.vala"
	_tmp10_ = color;
#line 579 "theme-2d-cairo.vala"
	_tmp11_ = lighted;
#line 579 "theme-2d-cairo.vala"
	_tmp12_ = lighted;
#line 579 "theme-2d-cairo.vala"
	_tmp13_ = lighted;
#line 579 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgb (_tmp10_, 0.6, _tmp11_.red, _tmp12_.green, _tmp13_.blue);
#line 580 "theme-2d-cairo.vala"
	_tmp14_ = color;
#line 580 "theme-2d-cairo.vala"
	cairo_set_source (cr, _tmp14_);
#line 581 "theme-2d-cairo.vala"
	cairo_paint (cr);
#line 583 "theme-2d-cairo.vala"
	pasang_rgb_lighten (&paint, 0.3, &_tmp15_);
#line 583 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_fill_triangle (self, cr, &_tmp15_, x1, y1, x1, y2, x1 + (height / 2), (gdouble) 0);
#line 584 "theme-2d-cairo.vala"
	pasang_rgb_lighten (&paint, 0.0, &_tmp16_);
#line 584 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_fill_triangle (self, cr, &_tmp16_, x2, y1, x2, y2, x2 - (height / 2), (gdouble) 0);
#line 587 "theme-2d-cairo.vala"
	x = (-0.25) * size;
#line 588 "theme-2d-cairo.vala"
	y = (-0.15) * size;
#line 589 "theme-2d-cairo.vala"
	w = 0.5 * size;
#line 590 "theme-2d-cairo.vala"
	h = 0.3 * size;
#line 591 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_trace_rounded_rectangle (self, cr, x, y, w, h, 0.05 * w);
#line 592 "theme-2d-cairo.vala"
	cairo_clip (cr);
#line 594 "theme-2d-cairo.vala"
	_tmp17_ = cairo_pattern_create_linear (x, y, x, -y);
#line 594 "theme-2d-cairo.vala"
	_cairo_pattern_destroy0 (color);
#line 594 "theme-2d-cairo.vala"
	color = _tmp17_;
#line 595 "theme-2d-cairo.vala"
	pasang_rgb_lighten (&paint, -0.5, &_tmp18_);
#line 595 "theme-2d-cairo.vala"
	lighted = _tmp18_;
#line 596 "theme-2d-cairo.vala"
	_tmp19_ = color;
#line 596 "theme-2d-cairo.vala"
	_tmp20_ = lighted;
#line 596 "theme-2d-cairo.vala"
	_tmp21_ = lighted;
#line 596 "theme-2d-cairo.vala"
	_tmp22_ = lighted;
#line 596 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgb (_tmp19_, 0.4, _tmp20_.red, _tmp21_.green, _tmp22_.blue);
#line 597 "theme-2d-cairo.vala"
	pasang_rgb_lighten (&paint, 0.5, &_tmp23_);
#line 597 "theme-2d-cairo.vala"
	lighted = _tmp23_;
#line 598 "theme-2d-cairo.vala"
	_tmp24_ = color;
#line 598 "theme-2d-cairo.vala"
	_tmp25_ = lighted;
#line 598 "theme-2d-cairo.vala"
	_tmp26_ = lighted;
#line 598 "theme-2d-cairo.vala"
	_tmp27_ = lighted;
#line 598 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgb (_tmp24_, 0.6, _tmp25_.red, _tmp26_.green, _tmp27_.blue);
#line 599 "theme-2d-cairo.vala"
	_tmp28_ = color;
#line 599 "theme-2d-cairo.vala"
	cairo_set_source (cr, _tmp28_);
#line 600 "theme-2d-cairo.vala"
	cairo_paint (cr);
#line 602 "theme-2d-cairo.vala"
	pasang_rgb_lighten (&paint, 0.0, &_tmp29_);
#line 602 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_fill_triangle (self, cr, &_tmp29_, x1, y1, x1, y2, x1 + (height / 2), (gdouble) 0);
#line 603 "theme-2d-cairo.vala"
	pasang_rgb_lighten (&paint, 0.3, &_tmp30_);
#line 603 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_fill_triangle (self, cr, &_tmp30_, x2, y2, x2, y1, x2 - (height / 2), (gdouble) 0);
#line 606 "theme-2d-cairo.vala"
	x = (-0.22) * size;
#line 607 "theme-2d-cairo.vala"
	y = (-0.13) * size;
#line 608 "theme-2d-cairo.vala"
	w = 0.44 * size;
#line 609 "theme-2d-cairo.vala"
	h = 0.26 * size;
#line 610 "theme-2d-cairo.vala"
	cairo_rectangle (cr, x, y, w, h);
#line 611 "theme-2d-cairo.vala"
	cairo_clip (cr);
#line 614 "theme-2d-cairo.vala"
	if (f == 0) {
#line 4392 "theme-2d-cairo.c"
		gdouble _tmp31_ = 0.0;
		PasangRgb _tmp32_ = {0};
#line 615 "theme-2d-cairo.vala"
		if (piece == PASANG_PIECE_NULL) {
#line 615 "theme-2d-cairo.vala"
			_tmp31_ = 1.0;
#line 4399 "theme-2d-cairo.c"
		} else {
#line 615 "theme-2d-cairo.vala"
			_tmp31_ = 0.1;
#line 4403 "theme-2d-cairo.c"
		}
#line 615 "theme-2d-cairo.vala"
		pasang_rgb_darken (&paint, _tmp31_, &_tmp32_);
#line 615 "theme-2d-cairo.vala"
		pasang_rgb_set_source_for (&_tmp32_, cr);
#line 616 "theme-2d-cairo.vala"
		cairo_paint (cr);
#line 4411 "theme-2d-cairo.c"
	} else {
#line 618 "theme-2d-cairo.vala"
		if (f < 10) {
#line 619 "theme-2d-cairo.vala"
			cairo_set_source_rgb (cr, 0.2, (gdouble) 1, 0.2);
#line 620 "theme-2d-cairo.vala"
			cairo_paint (cr);
#line 621 "theme-2d-cairo.vala"
			pasang_theme2_dcairo_trace_flower (self, cr, 5, (gdouble) 0, (gdouble) 0, (gdouble) 0, (0.05 * (f % 10)) * size, (gdouble) 0, 0);
#line 622 "theme-2d-cairo.vala"
			cairo_set_source_rgb (cr, (gdouble) 1, 0.4, 0.8);
#line 623 "theme-2d-cairo.vala"
			cairo_fill (cr);
#line 4425 "theme-2d-cairo.c"
		} else {
#line 625 "theme-2d-cairo.vala"
			if (f < 20) {
#line 4429 "theme-2d-cairo.c"
				PasangRgb _tmp33_ = {0};
				PasangRgb _tmp34_ = {0};
#line 626 "theme-2d-cairo.vala"
				cairo_set_source_rgb (cr, (gdouble) 0, 0.7, 1.0);
#line 627 "theme-2d-cairo.vala"
				cairo_paint (cr);
#line 628 "theme-2d-cairo.vala"
				cairo_set_source_rgb (cr, 1.0, 0.2, (gdouble) 0);
#line 629 "theme-2d-cairo.vala"
				cairo_arc (cr, (gdouble) 0, ((-0.01) * (f % 10)) * size, 0.1 * size, (gdouble) 0, 2 * G_PI);
#line 630 "theme-2d-cairo.vala"
				cairo_fill (cr);
#line 631 "theme-2d-cairo.vala"
				pasang_rgb_init (&_tmp33_, 0.2, 0.6, 0.9, (gdouble) 1);
#line 631 "theme-2d-cairo.vala"
				pasang_theme2_dcairo_fill_triangle (self, cr, &_tmp33_, (-0.8) * size, y2, 0.5 * size, y2, (-0.15) * size, (gdouble) 0);
#line 632 "theme-2d-cairo.vala"
				pasang_rgb_init (&_tmp34_, 0.3, 0.4, 0.8, (gdouble) 1);
#line 632 "theme-2d-cairo.vala"
				pasang_theme2_dcairo_fill_triangle (self, cr, &_tmp34_, (-0.6) * size, y2, 0.5 * size, y2, 0.1 * size, 0.02 * size);
#line 4450 "theme-2d-cairo.c"
			} else {
				gchar* _tmp35_;
				gchar* _tmp36_;
#line 635 "theme-2d-cairo.vala"
				cairo_set_source_rgb (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 636 "theme-2d-cairo.vala"
				cairo_paint (cr);
#line 637 "theme-2d-cairo.vala"
				cairo_set_source_rgb (cr, (gdouble) 1, (gdouble) 1, (gdouble) 0);
#line 638 "theme-2d-cairo.vala"
				_tmp35_ = string_slice ("Pasang\nEmas", (glong) 0, (glong) (1 + (MIN (10, f - 20) % 11)));
#line 638 "theme-2d-cairo.vala"
				_tmp36_ = _tmp35_;
#line 638 "theme-2d-cairo.vala"
				pasang_theme2_d_show_text ((PasangTheme2D*) self, cr, _tmp36_, (gint) (0.06 * size), 0, 0, FALSE);
#line 638 "theme-2d-cairo.vala"
				_g_free0 (_tmp36_);
#line 4468 "theme-2d-cairo.c"
			}
		}
	}
#line 561 "theme-2d-cairo.vala"
	_cairo_pattern_destroy0 (color);
#line 4474 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_forge_piece_shiny (PasangTheme2DCairo* self,
                                        cairo_t* cr,
                                        PasangPiece piece,
                                        gint size,
                                        gint f)
{
	gdouble radius = 0.0;
	gint _tmp0_ = 0;
	gint n1 = 0;
	gint n2 = 0;
	gdouble* reds = NULL;
	gdouble* _tmp1_;
	gint reds_length1;
	gint _reds_size_;
	gdouble* greens = NULL;
	gdouble* _tmp2_;
	gint greens_length1;
	gint _greens_size_;
	gdouble* blues = NULL;
	gdouble* _tmp3_;
	gint blues_length1;
	gint _blues_size_;
	gdouble red = 0.0;
	gdouble _tmp4_;
	gdouble green = 0.0;
	gdouble _tmp5_;
	gdouble blue = 0.0;
	gdouble _tmp6_;
	cairo_pattern_t* color = NULL;
	cairo_pattern_t* _tmp7_;
#line 642 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 642 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 643 "theme-2d-cairo.vala"
	cairo_save (cr);
#line 644 "theme-2d-cairo.vala"
	radius = 0.30 * size;
#line 646 "theme-2d-cairo.vala"
	if (pasang_piece_is_kas (piece)) {
#line 646 "theme-2d-cairo.vala"
		_tmp0_ = f;
#line 4520 "theme-2d-cairo.c"
	} else {
#line 646 "theme-2d-cairo.vala"
		_tmp0_ = f * 2;
#line 4524 "theme-2d-cairo.c"
	}
#line 646 "theme-2d-cairo.vala"
	n1 = MIN (self->priv->num_frames - 2, _tmp0_);
#line 647 "theme-2d-cairo.vala"
	n2 = self->priv->num_frames;
#line 648 "theme-2d-cairo.vala"
	cairo_translate (cr, (gdouble) 0, (((-n1) * size) / 3.0) / n2);
#line 649 "theme-2d-cairo.vala"
	cairo_scale (cr, 1.0, ((gdouble) (n2 - (n1 / 2))) / n2);
#line 651 "theme-2d-cairo.vala"
	_tmp1_ = g_new0 (gdouble, 4);
#line 651 "theme-2d-cairo.vala"
	_tmp1_[0] = 1.0;
#line 651 "theme-2d-cairo.vala"
	_tmp1_[1] = 0.3;
#line 651 "theme-2d-cairo.vala"
	_tmp1_[2] = 0.2;
#line 651 "theme-2d-cairo.vala"
	_tmp1_[3] = 1.0;
#line 651 "theme-2d-cairo.vala"
	reds = _tmp1_;
#line 651 "theme-2d-cairo.vala"
	reds_length1 = 4;
#line 651 "theme-2d-cairo.vala"
	_reds_size_ = reds_length1;
#line 652 "theme-2d-cairo.vala"
	_tmp2_ = g_new0 (gdouble, 4);
#line 652 "theme-2d-cairo.vala"
	_tmp2_[0] = 0.2;
#line 652 "theme-2d-cairo.vala"
	_tmp2_[1] = 0.2;
#line 652 "theme-2d-cairo.vala"
	_tmp2_[2] = 0.2;
#line 652 "theme-2d-cairo.vala"
	_tmp2_[3] = 1.0;
#line 652 "theme-2d-cairo.vala"
	greens = _tmp2_;
#line 652 "theme-2d-cairo.vala"
	greens_length1 = 4;
#line 652 "theme-2d-cairo.vala"
	_greens_size_ = greens_length1;
#line 653 "theme-2d-cairo.vala"
	_tmp3_ = g_new0 (gdouble, 4);
#line 653 "theme-2d-cairo.vala"
	_tmp3_[0] = 0.3;
#line 653 "theme-2d-cairo.vala"
	_tmp3_[1] = 1.0;
#line 653 "theme-2d-cairo.vala"
	_tmp3_[2] = 0.2;
#line 653 "theme-2d-cairo.vala"
	_tmp3_[3] = 1.0;
#line 653 "theme-2d-cairo.vala"
	blues = _tmp3_;
#line 653 "theme-2d-cairo.vala"
	blues_length1 = 4;
#line 653 "theme-2d-cairo.vala"
	_blues_size_ = blues_length1;
#line 654 "theme-2d-cairo.vala"
	_tmp4_ = reds[piece];
#line 654 "theme-2d-cairo.vala"
	red = _tmp4_;
#line 655 "theme-2d-cairo.vala"
	_tmp5_ = greens[piece];
#line 655 "theme-2d-cairo.vala"
	green = _tmp5_;
#line 656 "theme-2d-cairo.vala"
	_tmp6_ = blues[piece];
#line 656 "theme-2d-cairo.vala"
	blue = _tmp6_;
#line 657 "theme-2d-cairo.vala"
	_tmp7_ = cairo_pattern_create_radial ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, radius);
#line 657 "theme-2d-cairo.vala"
	color = _tmp7_;
#line 658 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgba (color, (gdouble) 0, red, green, blue, 0.98);
#line 659 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgba (color, 0.8, red, green, blue, 1.0);
#line 660 "theme-2d-cairo.vala"
	cairo_set_source (cr, color);
#line 661 "theme-2d-cairo.vala"
	cairo_set_source_rgb (cr, red, green, blue);
#line 662 "theme-2d-cairo.vala"
	cairo_arc (cr, (gdouble) 0, (gdouble) 0, radius, (gdouble) 0, 2 * G_PI);
#line 663 "theme-2d-cairo.vala"
	cairo_fill (cr);
#line 664 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_shine_light (self, cr, 1.0, radius, (1.0 * n1) / n2);
#line 665 "theme-2d-cairo.vala"
	cairo_restore (cr);
#line 642 "theme-2d-cairo.vala"
	_cairo_pattern_destroy0 (color);
#line 642 "theme-2d-cairo.vala"
	blues = (g_free (blues), NULL);
#line 642 "theme-2d-cairo.vala"
	greens = (g_free (greens), NULL);
#line 642 "theme-2d-cairo.vala"
	reds = (g_free (reds), NULL);
#line 4622 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_forge_piece_flower (PasangTheme2DCairo* self,
                                         cairo_t* cr,
                                         PasangPiece piece,
                                         gint size,
                                         gint f)
{
	cairo_surface_t* _tmp0_;
	gdouble radius = 0.0;
	gdouble frac = 0.0;
	gdouble frac2 = 0.0;
	gdouble r_out = 0.0;
	gdouble r_in = 0.0;
	gint _tmp4_ = 0;
	gint num_petals = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gint num_removed = 0;
	gdouble _tmp7_ = 0.0;
	gboolean _tmp8_ = FALSE;
	gdouble shift = 0.0;
	gdouble* reds = NULL;
	gdouble* _tmp9_;
	gint reds_length1;
	gint _reds_size_;
	gdouble* greens = NULL;
	gdouble* _tmp10_;
	gint greens_length1;
	gint _greens_size_;
	gdouble* blues = NULL;
	gdouble* _tmp11_;
	gint blues_length1;
	gint _blues_size_;
	gdouble red = 0.0;
	gdouble _tmp12_;
	gdouble green = 0.0;
	gdouble _tmp13_;
	gdouble blue = 0.0;
	gdouble _tmp14_;
	cairo_pattern_t* color = NULL;
	cairo_pattern_t* _tmp15_;
	cairo_surface_t* _tmp16_;
	cairo_pattern_t* _tmp17_;
#line 673 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 673 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 674 "theme-2d-cairo.vala"
	_tmp0_ = self->priv->flower_texture;
#line 674 "theme-2d-cairo.vala"
	if (_tmp0_ == NULL) {
#line 4676 "theme-2d-cairo.c"
		gdouble* _tmp1_;
		gdouble* _tmp2_;
		gint _tmp2__length1;
		cairo_surface_t* _tmp3_;
#line 675 "theme-2d-cairo.vala"
		_tmp1_ = g_new0 (gdouble, 18);
#line 675 "theme-2d-cairo.vala"
		_tmp1_[0] = 1.5;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[1] = 0.05;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[2] = (gdouble) 0;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[3] = (gdouble) 0;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[4] = (gdouble) 1;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[5] = (gdouble) 1;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[6] = 1.5;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[7] = 0.05;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[8] = (gdouble) 0;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[9] = (gdouble) 0;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[10] = (gdouble) 1;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[11] = (gdouble) 0;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[12] = 1.5;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[13] = 0.05;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[14] = (gdouble) 0;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[15] = (gdouble) 0;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[16] = (gdouble) 0;
#line 675 "theme-2d-cairo.vala"
		_tmp1_[17] = (gdouble) 1;
#line 675 "theme-2d-cairo.vala"
		_tmp2_ = _tmp1_;
#line 675 "theme-2d-cairo.vala"
		_tmp2__length1 = 18;
#line 675 "theme-2d-cairo.vala"
		_tmp3_ = pasang_theme2_dcairo_create_texture (self, 3, _tmp2_, (gint) 18);
#line 675 "theme-2d-cairo.vala"
		_cairo_surface_destroy0 (self->priv->flower_texture);
#line 675 "theme-2d-cairo.vala"
		self->priv->flower_texture = _tmp3_;
#line 675 "theme-2d-cairo.vala"
		_tmp2_ = (g_free (_tmp2_), NULL);
#line 4731 "theme-2d-cairo.c"
	}
#line 679 "theme-2d-cairo.vala"
	cairo_save (cr);
#line 681 "theme-2d-cairo.vala"
	radius = 0.33 * size;
#line 682 "theme-2d-cairo.vala"
	frac = (1.0 * f) / (self->priv->num_frames / 2);
#line 683 "theme-2d-cairo.vala"
	frac2 = MIN (1.0, frac);
#line 684 "theme-2d-cairo.vala"
	r_out = (1.0 + frac2) * radius;
#line 685 "theme-2d-cairo.vala"
	r_in = (1.0 - frac2) * radius;
#line 686 "theme-2d-cairo.vala"
	if (pasang_piece_is_kas (piece)) {
#line 686 "theme-2d-cairo.vala"
		_tmp4_ = 16;
#line 4749 "theme-2d-cairo.c"
	} else {
#line 686 "theme-2d-cairo.vala"
		_tmp4_ = 8;
#line 4753 "theme-2d-cairo.c"
	}
#line 686 "theme-2d-cairo.vala"
	num_petals = _tmp4_;
#line 687 "theme-2d-cairo.vala"
	if (!pasang_piece_is_kas (piece)) {
#line 687 "theme-2d-cairo.vala"
		_tmp6_ = f > (self->priv->num_frames / 2);
#line 4761 "theme-2d-cairo.c"
	} else {
#line 687 "theme-2d-cairo.vala"
		_tmp6_ = FALSE;
#line 4765 "theme-2d-cairo.c"
	}
#line 687 "theme-2d-cairo.vala"
	if (_tmp6_) {
#line 688 "theme-2d-cairo.vala"
		_tmp5_ = ((gint) ((frac - 1) * (num_petals + 1))) + 1;
#line 4771 "theme-2d-cairo.c"
	} else {
#line 688 "theme-2d-cairo.vala"
		_tmp5_ = 0;
#line 4775 "theme-2d-cairo.c"
	}
#line 687 "theme-2d-cairo.vala"
	num_removed = _tmp5_;
#line 689 "theme-2d-cairo.vala"
	if (pasang_piece_is_kas (piece)) {
#line 689 "theme-2d-cairo.vala"
		_tmp8_ = f > (self->priv->num_frames / 2);
#line 4783 "theme-2d-cairo.c"
	} else {
#line 689 "theme-2d-cairo.vala"
		_tmp8_ = FALSE;
#line 4787 "theme-2d-cairo.c"
	}
#line 689 "theme-2d-cairo.vala"
	if (_tmp8_) {
#line 689 "theme-2d-cairo.vala"
		_tmp7_ = (((frac - 1) * 2) * G_PI) / num_petals;
#line 4793 "theme-2d-cairo.c"
	} else {
#line 689 "theme-2d-cairo.vala"
		_tmp7_ = 0.0;
#line 4797 "theme-2d-cairo.c"
	}
#line 689 "theme-2d-cairo.vala"
	shift = _tmp7_;
#line 690 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_trace_flower (self, cr, num_petals, (gdouble) 0, (gdouble) 0, r_in, r_out, shift, num_removed);
#line 691 "theme-2d-cairo.vala"
	cairo_clip (cr);
#line 693 "theme-2d-cairo.vala"
	_tmp9_ = g_new0 (gdouble, 4);
#line 693 "theme-2d-cairo.vala"
	_tmp9_[0] = 0.8;
#line 693 "theme-2d-cairo.vala"
	_tmp9_[1] = 0.3;
#line 693 "theme-2d-cairo.vala"
	_tmp9_[2] = 0.2;
#line 693 "theme-2d-cairo.vala"
	_tmp9_[3] = 1.0;
#line 693 "theme-2d-cairo.vala"
	reds = _tmp9_;
#line 693 "theme-2d-cairo.vala"
	reds_length1 = 4;
#line 693 "theme-2d-cairo.vala"
	_reds_size_ = reds_length1;
#line 694 "theme-2d-cairo.vala"
	_tmp10_ = g_new0 (gdouble, 4);
#line 694 "theme-2d-cairo.vala"
	_tmp10_[0] = 0.3;
#line 694 "theme-2d-cairo.vala"
	_tmp10_[1] = 0.5;
#line 694 "theme-2d-cairo.vala"
	_tmp10_[2] = 0.2;
#line 694 "theme-2d-cairo.vala"
	_tmp10_[3] = 1.0;
#line 694 "theme-2d-cairo.vala"
	greens = _tmp10_;
#line 694 "theme-2d-cairo.vala"
	greens_length1 = 4;
#line 694 "theme-2d-cairo.vala"
	_greens_size_ = greens_length1;
#line 695 "theme-2d-cairo.vala"
	_tmp11_ = g_new0 (gdouble, 4);
#line 695 "theme-2d-cairo.vala"
	_tmp11_[0] = 0.4;
#line 695 "theme-2d-cairo.vala"
	_tmp11_[1] = 0.8;
#line 695 "theme-2d-cairo.vala"
	_tmp11_[2] = 0.2;
#line 695 "theme-2d-cairo.vala"
	_tmp11_[3] = 1.0;
#line 695 "theme-2d-cairo.vala"
	blues = _tmp11_;
#line 695 "theme-2d-cairo.vala"
	blues_length1 = 4;
#line 695 "theme-2d-cairo.vala"
	_blues_size_ = blues_length1;
#line 696 "theme-2d-cairo.vala"
	_tmp12_ = reds[piece];
#line 696 "theme-2d-cairo.vala"
	red = _tmp12_;
#line 697 "theme-2d-cairo.vala"
	_tmp13_ = greens[piece];
#line 697 "theme-2d-cairo.vala"
	green = _tmp13_;
#line 698 "theme-2d-cairo.vala"
	_tmp14_ = blues[piece];
#line 698 "theme-2d-cairo.vala"
	blue = _tmp14_;
#line 699 "theme-2d-cairo.vala"
	_tmp15_ = cairo_pattern_create_radial ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (2.0 - frac2) * radius);
#line 699 "theme-2d-cairo.vala"
	color = _tmp15_;
#line 700 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgb (color, (gdouble) 0, red, green, blue);
#line 701 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgb (color, 0.5, red, green, blue);
#line 702 "theme-2d-cairo.vala"
	cairo_pattern_add_color_stop_rgb (color, 1.0, 1.0, 1.0, (gdouble) 0);
#line 703 "theme-2d-cairo.vala"
	cairo_set_source (cr, color);
#line 704 "theme-2d-cairo.vala"
	cairo_paint (cr);
#line 706 "theme-2d-cairo.vala"
	_tmp16_ = self->priv->flower_texture;
#line 706 "theme-2d-cairo.vala"
	cairo_set_source_surface (cr, _tmp16_, (gdouble) 0, (gdouble) 0);
#line 707 "theme-2d-cairo.vala"
	_tmp17_ = cairo_get_source (cr);
#line 707 "theme-2d-cairo.vala"
	cairo_pattern_set_extend (_tmp17_, CAIRO_EXTEND_REPEAT);
#line 708 "theme-2d-cairo.vala"
	cairo_paint (cr);
#line 709 "theme-2d-cairo.vala"
	cairo_restore (cr);
#line 673 "theme-2d-cairo.vala"
	_cairo_pattern_destroy0 (color);
#line 673 "theme-2d-cairo.vala"
	blues = (g_free (blues), NULL);
#line 673 "theme-2d-cairo.vala"
	greens = (g_free (greens), NULL);
#line 673 "theme-2d-cairo.vala"
	reds = (g_free (reds), NULL);
#line 4899 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_forge_piece_galaxy (PasangTheme2DCairo* self,
                                         cairo_t* cr,
                                         PasangPiece piece,
                                         gint size,
                                         gint f)
{
#line 715 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 715 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 716 "theme-2d-cairo.vala"
	cairo_save (cr);
#line 717 "theme-2d-cairo.vala"
	cairo_arc (cr, (gdouble) 0, (gdouble) 0, (gdouble) (size / 2), (gdouble) 0, 2 * G_PI);
#line 718 "theme-2d-cairo.vala"
	cairo_clip (cr);
#line 719 "theme-2d-cairo.vala"
	switch (piece) {
#line 719 "theme-2d-cairo.vala"
		case PASANG_PIECE_BLACK:
#line 4923 "theme-2d-cairo.c"
		{
#line 721 "theme-2d-cairo.vala"
			pasang_theme2_dcairo_galaxy_black (self, cr, size, f);
#line 722 "theme-2d-cairo.vala"
			break;
#line 4929 "theme-2d-cairo.c"
		}
#line 719 "theme-2d-cairo.vala"
		case PASANG_PIECE_WHITE:
#line 4933 "theme-2d-cairo.c"
		{
#line 724 "theme-2d-cairo.vala"
			pasang_theme2_dcairo_galaxy_white (self, cr, size, f);
#line 725 "theme-2d-cairo.vala"
			break;
#line 4939 "theme-2d-cairo.c"
		}
		default:
		{
#line 727 "theme-2d-cairo.vala"
			pasang_theme2_dcairo_galaxy_kas (self, cr, piece, size, f);
#line 728 "theme-2d-cairo.vala"
			break;
#line 4947 "theme-2d-cairo.c"
		}
	}
#line 730 "theme-2d-cairo.vala"
	cairo_restore (cr);
#line 4952 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_galaxy_kas (PasangTheme2DCairo* self,
                                 cairo_t* cr,
                                 PasangPiece piece,
                                 gint size,
                                 gint f)
{
	gint n_corners = 0;
	gboolean _tmp0_ = FALSE;
	gdouble phase = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble distort = 0.0;
	gdouble radius = 0.0;
	gdouble corona = 0.0;
#line 733 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 733 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 734 "theme-2d-cairo.vala"
	n_corners = 20;
#line 735 "theme-2d-cairo.vala"
	if (f == 0) {
#line 735 "theme-2d-cairo.vala"
		_tmp0_ = TRUE;
#line 4979 "theme-2d-cairo.c"
	} else {
		gdouble* _tmp1_;
		gint _tmp1__length1;
		gint _tmp1__length2;
#line 735 "theme-2d-cairo.vala"
		_tmp1_ = self->priv->stars;
#line 735 "theme-2d-cairo.vala"
		_tmp1__length1 = self->priv->stars_length1;
#line 735 "theme-2d-cairo.vala"
		_tmp1__length2 = self->priv->stars_length2;
#line 735 "theme-2d-cairo.vala"
		_tmp0_ = _tmp1_ == NULL;
#line 4992 "theme-2d-cairo.c"
	}
#line 735 "theme-2d-cairo.vala"
	if (_tmp0_) {
#line 4996 "theme-2d-cairo.c"
		gdouble* _tmp2_;
#line 736 "theme-2d-cairo.vala"
		_tmp2_ = g_new0 (gdouble, (n_corners * 2) * 2);
#line 736 "theme-2d-cairo.vala"
		self->priv->stars = (g_free (self->priv->stars), NULL);
#line 736 "theme-2d-cairo.vala"
		self->priv->stars = _tmp2_;
#line 736 "theme-2d-cairo.vala"
		self->priv->stars_length1 = n_corners * 2;
#line 736 "theme-2d-cairo.vala"
		self->priv->stars_length2 = 2;
#line 5008 "theme-2d-cairo.c"
		{
			gint i = 0;
#line 738 "theme-2d-cairo.vala"
			i = 0;
#line 5013 "theme-2d-cairo.c"
			{
				gboolean _tmp3_ = FALSE;
#line 738 "theme-2d-cairo.vala"
				_tmp3_ = TRUE;
#line 738 "theme-2d-cairo.vala"
				while (TRUE) {
#line 5020 "theme-2d-cairo.c"
					gdouble* _tmp5_;
					gint _tmp5__length1;
					gint _tmp5__length2;
					gdouble* _tmp6_;
					gint _tmp6__length1;
					gint _tmp6__length2;
#line 738 "theme-2d-cairo.vala"
					if (!_tmp3_) {
#line 5029 "theme-2d-cairo.c"
						gint _tmp4_;
#line 738 "theme-2d-cairo.vala"
						_tmp4_ = i;
#line 738 "theme-2d-cairo.vala"
						i = _tmp4_ + 1;
#line 5035 "theme-2d-cairo.c"
					}
#line 738 "theme-2d-cairo.vala"
					_tmp3_ = FALSE;
#line 738 "theme-2d-cairo.vala"
					if (!(i < (n_corners * 2))) {
#line 738 "theme-2d-cairo.vala"
						break;
#line 5043 "theme-2d-cairo.c"
					}
#line 739 "theme-2d-cairo.vala"
					_tmp5_ = self->priv->stars;
#line 739 "theme-2d-cairo.vala"
					_tmp5__length1 = self->priv->stars_length1;
#line 739 "theme-2d-cairo.vala"
					_tmp5__length2 = self->priv->stars_length2;
#line 739 "theme-2d-cairo.vala"
					_tmp5_[(i * _tmp5__length2) + 0] = (g_random_double () * 2) * G_PI;
#line 740 "theme-2d-cairo.vala"
					_tmp6_ = self->priv->stars;
#line 740 "theme-2d-cairo.vala"
					_tmp6__length1 = self->priv->stars_length1;
#line 740 "theme-2d-cairo.vala"
					_tmp6__length2 = self->priv->stars_length2;
#line 740 "theme-2d-cairo.vala"
					_tmp6_[(i * _tmp6__length2) + 1] = (g_random_double () * 2) * G_PI;
#line 5061 "theme-2d-cairo.c"
				}
			}
		}
	}
#line 743 "theme-2d-cairo.vala"
	phase = ((4 * G_PI) * f) / self->priv->num_frames;
#line 745 "theme-2d-cairo.vala"
	if (f > (self->priv->num_frames / 2)) {
#line 745 "theme-2d-cairo.vala"
		_tmp7_ = 1.0;
#line 5072 "theme-2d-cairo.c"
	} else {
#line 745 "theme-2d-cairo.vala"
		_tmp7_ = sin (((G_PI / 2) * f) / (self->priv->num_frames / 2));
#line 5076 "theme-2d-cairo.c"
	}
#line 745 "theme-2d-cairo.vala"
	distort = _tmp7_;
#line 746 "theme-2d-cairo.vala"
	radius = (0.2 + (0.3 * distort)) * size;
#line 747 "theme-2d-cairo.vala"
	corona = 0.7 * radius;
#line 5084 "theme-2d-cairo.c"
	{
		gint layer = 0;
#line 748 "theme-2d-cairo.vala"
		layer = 0;
#line 5089 "theme-2d-cairo.c"
		{
			gboolean _tmp8_ = FALSE;
#line 748 "theme-2d-cairo.vala"
			_tmp8_ = TRUE;
#line 748 "theme-2d-cairo.vala"
			while (TRUE) {
#line 5096 "theme-2d-cairo.c"
				gdouble* fx = NULL;
				gdouble* _tmp10_;
				gint fx_length1;
				gint _fx_size_;
				gdouble* fy = NULL;
				gdouble* _tmp11_;
				gint fy_length1;
				gint _fy_size_;
				gdouble* cx = NULL;
				gdouble* _tmp12_;
				gint cx_length1;
				gint _cx_size_;
				gdouble* cy = NULL;
				gdouble* _tmp13_;
				gint cy_length1;
				gint _cy_size_;
				gdouble* _tmp36_;
				gint _tmp36__length1;
				gdouble _tmp37_;
				gdouble* _tmp38_;
				gint _tmp38__length1;
				gdouble _tmp39_;
				gdouble alpha = 0.0;
#line 748 "theme-2d-cairo.vala"
				if (!_tmp8_) {
#line 5122 "theme-2d-cairo.c"
					gint _tmp9_;
#line 748 "theme-2d-cairo.vala"
					_tmp9_ = layer;
#line 748 "theme-2d-cairo.vala"
					layer = _tmp9_ + 1;
#line 5128 "theme-2d-cairo.c"
				}
#line 748 "theme-2d-cairo.vala"
				_tmp8_ = FALSE;
#line 748 "theme-2d-cairo.vala"
				if (!(((gdouble) layer) < corona)) {
#line 748 "theme-2d-cairo.vala"
					break;
#line 5136 "theme-2d-cairo.c"
				}
#line 749 "theme-2d-cairo.vala"
				radius -= 1.0;
#line 751 "theme-2d-cairo.vala"
				_tmp10_ = g_new0 (gdouble, n_corners);
#line 751 "theme-2d-cairo.vala"
				fx = _tmp10_;
#line 751 "theme-2d-cairo.vala"
				fx_length1 = n_corners;
#line 751 "theme-2d-cairo.vala"
				_fx_size_ = fx_length1;
#line 752 "theme-2d-cairo.vala"
				_tmp11_ = g_new0 (gdouble, n_corners);
#line 752 "theme-2d-cairo.vala"
				fy = _tmp11_;
#line 752 "theme-2d-cairo.vala"
				fy_length1 = n_corners;
#line 752 "theme-2d-cairo.vala"
				_fy_size_ = fy_length1;
#line 754 "theme-2d-cairo.vala"
				_tmp12_ = g_new0 (gdouble, 2 * n_corners);
#line 754 "theme-2d-cairo.vala"
				cx = _tmp12_;
#line 754 "theme-2d-cairo.vala"
				cx_length1 = 2 * n_corners;
#line 754 "theme-2d-cairo.vala"
				_cx_size_ = cx_length1;
#line 755 "theme-2d-cairo.vala"
				_tmp13_ = g_new0 (gdouble, 2 * n_corners);
#line 755 "theme-2d-cairo.vala"
				cy = _tmp13_;
#line 755 "theme-2d-cairo.vala"
				cy_length1 = 2 * n_corners;
#line 755 "theme-2d-cairo.vala"
				_cy_size_ = cy_length1;
#line 5172 "theme-2d-cairo.c"
				{
					gint i = 0;
#line 756 "theme-2d-cairo.vala"
					i = 0;
#line 5177 "theme-2d-cairo.c"
					{
						gboolean _tmp14_ = FALSE;
#line 756 "theme-2d-cairo.vala"
						_tmp14_ = TRUE;
#line 756 "theme-2d-cairo.vala"
						while (TRUE) {
#line 5184 "theme-2d-cairo.c"
							gdouble theta = 0.0;
							gdouble* _tmp16_;
							gint _tmp16__length1;
							gdouble* _tmp17_;
							gint _tmp17__length1;
							gdouble* _tmp18_;
							gint _tmp18__length1;
							gint _tmp18__length2;
							gdouble _tmp19_;
							gint n = 0;
							gdouble len = 0.0;
							gdouble* _tmp20_;
							gint _tmp20__length1;
							gint _tmp20__length2;
							gdouble _tmp21_;
							gdouble* _tmp22_;
							gint _tmp22__length1;
							gdouble* _tmp23_;
							gint _tmp23__length1;
							gdouble _tmp24_;
							gdouble* _tmp25_;
							gint _tmp25__length1;
							gdouble* _tmp26_;
							gint _tmp26__length1;
							gdouble _tmp27_;
							gdouble* _tmp28_;
							gint _tmp28__length1;
							gint _tmp28__length2;
							gdouble _tmp29_;
							gdouble* _tmp30_;
							gint _tmp30__length1;
							gdouble* _tmp31_;
							gint _tmp31__length1;
							gdouble _tmp32_;
							gdouble* _tmp33_;
							gint _tmp33__length1;
							gdouble* _tmp34_;
							gint _tmp34__length1;
							gdouble _tmp35_;
#line 756 "theme-2d-cairo.vala"
							if (!_tmp14_) {
#line 5226 "theme-2d-cairo.c"
								gint _tmp15_;
#line 756 "theme-2d-cairo.vala"
								_tmp15_ = i;
#line 756 "theme-2d-cairo.vala"
								i = _tmp15_ + 1;
#line 5232 "theme-2d-cairo.c"
							}
#line 756 "theme-2d-cairo.vala"
							_tmp14_ = FALSE;
#line 756 "theme-2d-cairo.vala"
							if (!(i < n_corners)) {
#line 756 "theme-2d-cairo.vala"
								break;
#line 5240 "theme-2d-cairo.c"
							}
#line 758 "theme-2d-cairo.vala"
							theta = ((2 * G_PI) * (i + 1)) / n_corners;
#line 761 "theme-2d-cairo.vala"
							_tmp16_ = fx;
#line 761 "theme-2d-cairo.vala"
							_tmp16__length1 = fx_length1;
#line 761 "theme-2d-cairo.vala"
							_tmp16_[i] = (-radius) * cos (theta);
#line 762 "theme-2d-cairo.vala"
							_tmp17_ = fy;
#line 762 "theme-2d-cairo.vala"
							_tmp17__length1 = fy_length1;
#line 762 "theme-2d-cairo.vala"
							_tmp17_[i] = (-radius) * sin (theta);
#line 764 "theme-2d-cairo.vala"
							theta += G_PI / 2;
#line 766 "theme-2d-cairo.vala"
							_tmp18_ = self->priv->stars;
#line 766 "theme-2d-cairo.vala"
							_tmp18__length1 = self->priv->stars_length1;
#line 766 "theme-2d-cairo.vala"
							_tmp18__length2 = self->priv->stars_length2;
#line 766 "theme-2d-cairo.vala"
							_tmp19_ = _tmp18_[(i * _tmp18__length2) + 0];
#line 766 "theme-2d-cairo.vala"
							theta += ((sin (phase + _tmp19_) * G_PI) / 3) * distort;
#line 767 "theme-2d-cairo.vala"
							n = i * 2;
#line 768 "theme-2d-cairo.vala"
							_tmp20_ = self->priv->stars;
#line 768 "theme-2d-cairo.vala"
							_tmp20__length1 = self->priv->stars_length1;
#line 768 "theme-2d-cairo.vala"
							_tmp20__length2 = self->priv->stars_length2;
#line 768 "theme-2d-cairo.vala"
							_tmp21_ = _tmp20_[(n * _tmp20__length2) + 1];
#line 768 "theme-2d-cairo.vala"
							len = (0.2 + (0.2 * sin ((distort * _tmp21_) + phase))) * radius;
#line 769 "theme-2d-cairo.vala"
							_tmp22_ = cx;
#line 769 "theme-2d-cairo.vala"
							_tmp22__length1 = cx_length1;
#line 769 "theme-2d-cairo.vala"
							_tmp23_ = fx;
#line 769 "theme-2d-cairo.vala"
							_tmp23__length1 = fx_length1;
#line 769 "theme-2d-cairo.vala"
							_tmp24_ = _tmp23_[i];
#line 769 "theme-2d-cairo.vala"
							_tmp22_[n] = _tmp24_ + (len * cos (theta));
#line 770 "theme-2d-cairo.vala"
							_tmp25_ = cy;
#line 770 "theme-2d-cairo.vala"
							_tmp25__length1 = cy_length1;
#line 770 "theme-2d-cairo.vala"
							_tmp26_ = fy;
#line 770 "theme-2d-cairo.vala"
							_tmp26__length1 = fy_length1;
#line 770 "theme-2d-cairo.vala"
							_tmp27_ = _tmp26_[i];
#line 770 "theme-2d-cairo.vala"
							_tmp25_[n] = _tmp27_ + (len * sin (theta));
#line 771 "theme-2d-cairo.vala"
							_tmp28_ = self->priv->stars;
#line 771 "theme-2d-cairo.vala"
							_tmp28__length1 = self->priv->stars_length1;
#line 771 "theme-2d-cairo.vala"
							_tmp28__length2 = self->priv->stars_length2;
#line 771 "theme-2d-cairo.vala"
							_tmp29_ = _tmp28_[((n + 1) * _tmp28__length2) + 1];
#line 771 "theme-2d-cairo.vala"
							len = (0.2 + (0.2 * sin ((distort * _tmp29_) + phase))) * radius;
#line 772 "theme-2d-cairo.vala"
							_tmp30_ = cx;
#line 772 "theme-2d-cairo.vala"
							_tmp30__length1 = cx_length1;
#line 772 "theme-2d-cairo.vala"
							_tmp31_ = fx;
#line 772 "theme-2d-cairo.vala"
							_tmp31__length1 = fx_length1;
#line 772 "theme-2d-cairo.vala"
							_tmp32_ = _tmp31_[i];
#line 772 "theme-2d-cairo.vala"
							_tmp30_[n + 1] = _tmp32_ - (len * cos (theta));
#line 773 "theme-2d-cairo.vala"
							_tmp33_ = cy;
#line 773 "theme-2d-cairo.vala"
							_tmp33__length1 = cy_length1;
#line 773 "theme-2d-cairo.vala"
							_tmp34_ = fy;
#line 773 "theme-2d-cairo.vala"
							_tmp34__length1 = fy_length1;
#line 773 "theme-2d-cairo.vala"
							_tmp35_ = _tmp34_[i];
#line 773 "theme-2d-cairo.vala"
							_tmp33_[n + 1] = _tmp35_ - (len * sin (theta));
#line 5338 "theme-2d-cairo.c"
						}
					}
				}
#line 775 "theme-2d-cairo.vala"
				_tmp36_ = fx;
#line 775 "theme-2d-cairo.vala"
				_tmp36__length1 = fx_length1;
#line 775 "theme-2d-cairo.vala"
				_tmp37_ = _tmp36_[0];
#line 775 "theme-2d-cairo.vala"
				_tmp38_ = fy;
#line 775 "theme-2d-cairo.vala"
				_tmp38__length1 = fy_length1;
#line 775 "theme-2d-cairo.vala"
				_tmp39_ = _tmp38_[0];
#line 775 "theme-2d-cairo.vala"
				cairo_move_to (cr, _tmp37_, _tmp39_);
#line 5356 "theme-2d-cairo.c"
				{
					gint i = 0;
#line 776 "theme-2d-cairo.vala"
					i = 0;
#line 5361 "theme-2d-cairo.c"
					{
						gboolean _tmp40_ = FALSE;
#line 776 "theme-2d-cairo.vala"
						_tmp40_ = TRUE;
#line 776 "theme-2d-cairo.vala"
						while (TRUE) {
#line 5368 "theme-2d-cairo.c"
							gint j = 0;
							gdouble* _tmp42_;
							gint _tmp42__length1;
							gdouble _tmp43_;
							gdouble* _tmp44_;
							gint _tmp44__length1;
							gdouble _tmp45_;
							gdouble* _tmp46_;
							gint _tmp46__length1;
							gdouble _tmp47_;
							gdouble* _tmp48_;
							gint _tmp48__length1;
							gdouble _tmp49_;
							gdouble* _tmp50_;
							gint _tmp50__length1;
							gdouble _tmp51_;
							gdouble* _tmp52_;
							gint _tmp52__length1;
							gdouble _tmp53_;
#line 776 "theme-2d-cairo.vala"
							if (!_tmp40_) {
#line 5390 "theme-2d-cairo.c"
								gint _tmp41_;
#line 776 "theme-2d-cairo.vala"
								_tmp41_ = i;
#line 776 "theme-2d-cairo.vala"
								i = _tmp41_ + 1;
#line 5396 "theme-2d-cairo.c"
							}
#line 776 "theme-2d-cairo.vala"
							_tmp40_ = FALSE;
#line 776 "theme-2d-cairo.vala"
							if (!(i < n_corners)) {
#line 776 "theme-2d-cairo.vala"
								break;
#line 5404 "theme-2d-cairo.c"
							}
#line 777 "theme-2d-cairo.vala"
							j = (i + 1) % n_corners;
#line 778 "theme-2d-cairo.vala"
							_tmp42_ = cx;
#line 778 "theme-2d-cairo.vala"
							_tmp42__length1 = cx_length1;
#line 778 "theme-2d-cairo.vala"
							_tmp43_ = _tmp42_[(2 * i) + 1];
#line 778 "theme-2d-cairo.vala"
							_tmp44_ = cy;
#line 778 "theme-2d-cairo.vala"
							_tmp44__length1 = cy_length1;
#line 778 "theme-2d-cairo.vala"
							_tmp45_ = _tmp44_[(2 * i) + 1];
#line 778 "theme-2d-cairo.vala"
							_tmp46_ = cx;
#line 778 "theme-2d-cairo.vala"
							_tmp46__length1 = cx_length1;
#line 778 "theme-2d-cairo.vala"
							_tmp47_ = _tmp46_[2 * j];
#line 778 "theme-2d-cairo.vala"
							_tmp48_ = cy;
#line 778 "theme-2d-cairo.vala"
							_tmp48__length1 = cy_length1;
#line 778 "theme-2d-cairo.vala"
							_tmp49_ = _tmp48_[2 * j];
#line 778 "theme-2d-cairo.vala"
							_tmp50_ = fx;
#line 778 "theme-2d-cairo.vala"
							_tmp50__length1 = fx_length1;
#line 778 "theme-2d-cairo.vala"
							_tmp51_ = _tmp50_[j];
#line 778 "theme-2d-cairo.vala"
							_tmp52_ = fy;
#line 778 "theme-2d-cairo.vala"
							_tmp52__length1 = fy_length1;
#line 778 "theme-2d-cairo.vala"
							_tmp53_ = _tmp52_[j];
#line 778 "theme-2d-cairo.vala"
							cairo_curve_to (cr, _tmp43_, _tmp45_, _tmp47_, _tmp49_, _tmp51_, _tmp53_);
#line 5446 "theme-2d-cairo.c"
						}
					}
				}
#line 780 "theme-2d-cairo.vala"
				alpha = pow (layer / corona, (gdouble) 3) * 0.6;
#line 781 "theme-2d-cairo.vala"
				if (piece == PASANG_PIECE_KAS_0) {
#line 5454 "theme-2d-cairo.c"
					cairo_pattern_t* _tmp54_;
					cairo_pattern_t* _tmp55_;
#line 782 "theme-2d-cairo.vala"
					_tmp54_ = cairo_pattern_create_rgba ((gdouble) 1, alpha, alpha, alpha);
#line 782 "theme-2d-cairo.vala"
					_tmp55_ = _tmp54_;
#line 782 "theme-2d-cairo.vala"
					cairo_set_source (cr, _tmp55_);
#line 782 "theme-2d-cairo.vala"
					_cairo_pattern_destroy0 (_tmp55_);
#line 5465 "theme-2d-cairo.c"
				} else {
					cairo_pattern_t* _tmp56_;
					cairo_pattern_t* _tmp57_;
#line 784 "theme-2d-cairo.vala"
					_tmp56_ = cairo_pattern_create_rgba (alpha, alpha, (gdouble) 1, alpha);
#line 784 "theme-2d-cairo.vala"
					_tmp57_ = _tmp56_;
#line 784 "theme-2d-cairo.vala"
					cairo_set_source (cr, _tmp57_);
#line 784 "theme-2d-cairo.vala"
					_cairo_pattern_destroy0 (_tmp57_);
#line 5477 "theme-2d-cairo.c"
				}
#line 785 "theme-2d-cairo.vala"
				cairo_fill (cr);
#line 748 "theme-2d-cairo.vala"
				cy = (g_free (cy), NULL);
#line 748 "theme-2d-cairo.vala"
				cx = (g_free (cx), NULL);
#line 748 "theme-2d-cairo.vala"
				fy = (g_free (fy), NULL);
#line 748 "theme-2d-cairo.vala"
				fx = (g_free (fx), NULL);
#line 5489 "theme-2d-cairo.c"
			}
		}
	}
}

static void
pasang_theme2_dcairo_galaxy_black (PasangTheme2DCairo* self,
                                   cairo_t* cr,
                                   gint size,
                                   gint f)
{
	gint num_stars = 0;
	gdouble _tmp10_ = 0.0;
	gdouble t = 0.0;
	gdouble expand = 0.0;
#line 789 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 789 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 790 "theme-2d-cairo.vala"
	if (f == (self->priv->num_frames - 1)) {
#line 790 "theme-2d-cairo.vala"
		return;
#line 5513 "theme-2d-cairo.c"
	}
#line 791 "theme-2d-cairo.vala"
	num_stars = 1000;
#line 792 "theme-2d-cairo.vala"
	if (f == 0) {
#line 5519 "theme-2d-cairo.c"
		gdouble* _tmp0_;
#line 793 "theme-2d-cairo.vala"
		_tmp0_ = g_new0 (gdouble, num_stars * 5);
#line 793 "theme-2d-cairo.vala"
		self->priv->stars = (g_free (self->priv->stars), NULL);
#line 793 "theme-2d-cairo.vala"
		self->priv->stars = _tmp0_;
#line 793 "theme-2d-cairo.vala"
		self->priv->stars_length1 = num_stars;
#line 793 "theme-2d-cairo.vala"
		self->priv->stars_length2 = 5;
#line 5531 "theme-2d-cairo.c"
		{
			gint i = 0;
#line 794 "theme-2d-cairo.vala"
			i = 0;
#line 5536 "theme-2d-cairo.c"
			{
				gboolean _tmp1_ = FALSE;
#line 794 "theme-2d-cairo.vala"
				_tmp1_ = TRUE;
#line 794 "theme-2d-cairo.vala"
				while (TRUE) {
#line 5543 "theme-2d-cairo.c"
					gdouble* _tmp3_;
					gint _tmp3__length1;
					gint _tmp3__length2;
					gdouble* _tmp4_;
					gint _tmp4__length1;
					gint _tmp4__length2;
					gdouble* _tmp5_;
					gint _tmp5__length1;
					gint _tmp5__length2;
					gdouble _tmp6_;
					gdouble* _tmp7_;
					gint _tmp7__length1;
					gint _tmp7__length2;
					gdouble* _tmp8_;
					gint _tmp8__length1;
					gint _tmp8__length2;
					gdouble* _tmp9_;
					gint _tmp9__length1;
					gint _tmp9__length2;
#line 794 "theme-2d-cairo.vala"
					if (!_tmp1_) {
#line 5565 "theme-2d-cairo.c"
						gint _tmp2_;
#line 794 "theme-2d-cairo.vala"
						_tmp2_ = i;
#line 794 "theme-2d-cairo.vala"
						i = _tmp2_ + 1;
#line 5571 "theme-2d-cairo.c"
					}
#line 794 "theme-2d-cairo.vala"
					_tmp1_ = FALSE;
#line 794 "theme-2d-cairo.vala"
					if (!(i < num_stars)) {
#line 794 "theme-2d-cairo.vala"
						break;
#line 5579 "theme-2d-cairo.c"
					}
#line 797 "theme-2d-cairo.vala"
					_tmp3_ = self->priv->stars;
#line 797 "theme-2d-cairo.vala"
					_tmp3__length1 = self->priv->stars_length1;
#line 797 "theme-2d-cairo.vala"
					_tmp3__length2 = self->priv->stars_length2;
#line 797 "theme-2d-cairo.vala"
					_tmp3_[(i * _tmp3__length2) + 0] = sqrt (-2 * log (g_random_double ()));
#line 799 "theme-2d-cairo.vala"
					_tmp4_ = self->priv->stars;
#line 799 "theme-2d-cairo.vala"
					_tmp4__length1 = self->priv->stars_length1;
#line 799 "theme-2d-cairo.vala"
					_tmp4__length2 = self->priv->stars_length2;
#line 799 "theme-2d-cairo.vala"
					_tmp5_ = self->priv->stars;
#line 799 "theme-2d-cairo.vala"
					_tmp5__length1 = self->priv->stars_length1;
#line 799 "theme-2d-cairo.vala"
					_tmp5__length2 = self->priv->stars_length2;
#line 799 "theme-2d-cairo.vala"
					_tmp6_ = _tmp5_[(i * _tmp5__length2) + 0];
#line 799 "theme-2d-cairo.vala"
					_tmp4_[(i * _tmp4__length2) + 1] = (((_tmp6_ * 2) * G_PI) - G_PI) + g_random_double_range ((gdouble) -1, (gdouble) 1);
#line 802 "theme-2d-cairo.vala"
					_tmp7_ = self->priv->stars;
#line 802 "theme-2d-cairo.vala"
					_tmp7__length1 = self->priv->stars_length1;
#line 802 "theme-2d-cairo.vala"
					_tmp7__length2 = self->priv->stars_length2;
#line 802 "theme-2d-cairo.vala"
					_tmp7_[(i * _tmp7__length2) + 2] = g_random_double_range (0.4, (gdouble) 1);
#line 803 "theme-2d-cairo.vala"
					_tmp8_ = self->priv->stars;
#line 803 "theme-2d-cairo.vala"
					_tmp8__length1 = self->priv->stars_length1;
#line 803 "theme-2d-cairo.vala"
					_tmp8__length2 = self->priv->stars_length2;
#line 803 "theme-2d-cairo.vala"
					_tmp8_[(i * _tmp8__length2) + 3] = g_random_double_range (0.1, 0.5);
#line 804 "theme-2d-cairo.vala"
					_tmp9_ = self->priv->stars;
#line 804 "theme-2d-cairo.vala"
					_tmp9__length1 = self->priv->stars_length1;
#line 804 "theme-2d-cairo.vala"
					_tmp9__length2 = self->priv->stars_length2;
#line 804 "theme-2d-cairo.vala"
					_tmp9_[(i * _tmp9__length2) + 4] = g_random_double_range (0.4, (gdouble) 1);
#line 5629 "theme-2d-cairo.c"
				}
			}
		}
	}
#line 808 "theme-2d-cairo.vala"
	if (f <= (self->priv->num_frames / 2)) {
#line 808 "theme-2d-cairo.vala"
		_tmp10_ = (gdouble) 0;
#line 5638 "theme-2d-cairo.c"
	} else {
#line 808 "theme-2d-cairo.vala"
		_tmp10_ = ((1.0 * f) - (self->priv->num_frames / 2)) / (self->priv->num_frames / 2);
#line 5642 "theme-2d-cairo.c"
	}
#line 808 "theme-2d-cairo.vala"
	t = _tmp10_;
#line 809 "theme-2d-cairo.vala"
	expand = (0.6 * t) * t;
#line 5648 "theme-2d-cairo.c"
	{
		gint i = 0;
#line 810 "theme-2d-cairo.vala"
		i = 0;
#line 5653 "theme-2d-cairo.c"
		{
			gboolean _tmp11_ = FALSE;
#line 810 "theme-2d-cairo.vala"
			_tmp11_ = TRUE;
#line 810 "theme-2d-cairo.vala"
			while (TRUE) {
#line 5660 "theme-2d-cairo.c"
				gdouble r = 0.0;
				gdouble* _tmp13_;
				gint _tmp13__length1;
				gint _tmp13__length2;
				gdouble _tmp14_;
				gdouble theta = 0.0;
				gdouble* _tmp15_;
				gint _tmp15__length1;
				gint _tmp15__length2;
				gdouble _tmp16_;
				gdouble x = 0.0;
				gdouble y = 0.0;
				gdouble cf = 0.0;
				gdouble light = 0.0;
				gdouble* _tmp17_;
				gint _tmp17__length1;
				gint _tmp17__length2;
				gdouble _tmp18_;
				gdouble* _tmp19_;
				gint _tmp19__length1;
				gint _tmp19__length2;
				gdouble _tmp20_;
				gdouble* _tmp21_;
				gint _tmp21__length1;
				gint _tmp21__length2;
				gdouble _tmp22_;
#line 810 "theme-2d-cairo.vala"
				if (!_tmp11_) {
#line 5689 "theme-2d-cairo.c"
					gint _tmp12_;
#line 810 "theme-2d-cairo.vala"
					_tmp12_ = i;
#line 810 "theme-2d-cairo.vala"
					i = _tmp12_ + 1;
#line 5695 "theme-2d-cairo.c"
				}
#line 810 "theme-2d-cairo.vala"
				_tmp11_ = FALSE;
#line 810 "theme-2d-cairo.vala"
				if (!(i < num_stars)) {
#line 810 "theme-2d-cairo.vala"
					break;
#line 5703 "theme-2d-cairo.c"
				}
#line 811 "theme-2d-cairo.vala"
				_tmp13_ = self->priv->stars;
#line 811 "theme-2d-cairo.vala"
				_tmp13__length1 = self->priv->stars_length1;
#line 811 "theme-2d-cairo.vala"
				_tmp13__length2 = self->priv->stars_length2;
#line 811 "theme-2d-cairo.vala"
				_tmp14_ = _tmp13_[(i * _tmp13__length2) + 0];
#line 811 "theme-2d-cairo.vala"
				r = _tmp14_ + expand;
#line 812 "theme-2d-cairo.vala"
				_tmp15_ = self->priv->stars;
#line 812 "theme-2d-cairo.vala"
				_tmp15__length1 = self->priv->stars_length1;
#line 812 "theme-2d-cairo.vala"
				_tmp15__length2 = self->priv->stars_length2;
#line 812 "theme-2d-cairo.vala"
				_tmp16_ = _tmp15_[(i * _tmp15__length2) + 1];
#line 812 "theme-2d-cairo.vala"
				theta = _tmp16_ - (((4 * G_PI) * f) / self->priv->num_frames);
#line 813 "theme-2d-cairo.vala"
				x = ((0.25 * size) * r) * sin (theta);
#line 814 "theme-2d-cairo.vala"
				y = ((0.25 * size) * r) * cos (theta);
#line 815 "theme-2d-cairo.vala"
				if (i >= (num_stars / 2)) {
#line 816 "theme-2d-cairo.vala"
					y = -y;
#line 816 "theme-2d-cairo.vala"
					x = -x;
#line 5735 "theme-2d-cairo.c"
				}
#line 819 "theme-2d-cairo.vala"
				cf = 1.5 - MIN (1.3, fabs (r));
#line 820 "theme-2d-cairo.vala"
				light = (cf * size) / 100;
#line 821 "theme-2d-cairo.vala"
				_tmp17_ = self->priv->stars;
#line 821 "theme-2d-cairo.vala"
				_tmp17__length1 = self->priv->stars_length1;
#line 821 "theme-2d-cairo.vala"
				_tmp17__length2 = self->priv->stars_length2;
#line 821 "theme-2d-cairo.vala"
				_tmp18_ = _tmp17_[(i * _tmp17__length2) + 2];
#line 821 "theme-2d-cairo.vala"
				_tmp19_ = self->priv->stars;
#line 821 "theme-2d-cairo.vala"
				_tmp19__length1 = self->priv->stars_length1;
#line 821 "theme-2d-cairo.vala"
				_tmp19__length2 = self->priv->stars_length2;
#line 821 "theme-2d-cairo.vala"
				_tmp20_ = _tmp19_[(i * _tmp19__length2) + 3];
#line 821 "theme-2d-cairo.vala"
				_tmp21_ = self->priv->stars;
#line 821 "theme-2d-cairo.vala"
				_tmp21__length1 = self->priv->stars_length1;
#line 821 "theme-2d-cairo.vala"
				_tmp21__length2 = self->priv->stars_length2;
#line 821 "theme-2d-cairo.vala"
				_tmp22_ = _tmp21_[(i * _tmp21__length2) + 4];
#line 821 "theme-2d-cairo.vala"
				cairo_set_source_rgb (cr, _tmp18_, _tmp20_, _tmp22_);
#line 822 "theme-2d-cairo.vala"
				cairo_arc (cr, x, y, light, (gdouble) 0, 2 * G_PI);
#line 823 "theme-2d-cairo.vala"
				cairo_fill (cr);
#line 5771 "theme-2d-cairo.c"
			}
		}
	}
}

static void
pasang_theme2_dcairo_galaxy_white (PasangTheme2DCairo* self,
                                   cairo_t* cr,
                                   gint size,
                                   gint f)
{
	gint num_clusters = 0;
	gint brush_width = 0;
	cairo_surface_t** _tmp17_;
	gint _tmp17__length1;
	cairo_surface_t* _tmp18_;
	gdouble cluster_width = 0.0;
	gdouble scale = 0.0;
#line 829 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 829 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 830 "theme-2d-cairo.vala"
	if (f == (self->priv->num_frames - 1)) {
#line 830 "theme-2d-cairo.vala"
		return;
#line 5798 "theme-2d-cairo.c"
	}
#line 831 "theme-2d-cairo.vala"
	num_clusters = 200;
#line 832 "theme-2d-cairo.vala"
	if (f == 0) {
#line 5804 "theme-2d-cairo.c"
		PasangRgb _tmp0_ = {0};
		PasangRgb _tmp1_ = {0};
		PasangRgb _tmp2_ = {0};
		PasangRgb _tmp3_ = {0};
		PasangRgb _tmp4_ = {0};
		PasangRgb _tmp5_ = {0};
		gint _tmp6_ = 0;
		cairo_surface_t** _tmp7_;
		gdouble* _tmp8_;
#line 833 "theme-2d-cairo.vala"
		pasang_rgb_init (&_tmp0_, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
#line 833 "theme-2d-cairo.vala"
		pasang_rgb_init (&_tmp1_, 0.9, 0.95, 0.95, (gdouble) 1);
#line 833 "theme-2d-cairo.vala"
		pasang_rgb_init (&_tmp2_, 0.9, 0.9, 0.8, (gdouble) 1);
#line 833 "theme-2d-cairo.vala"
		pasang_rgb_init (&_tmp3_, 0.9, 0.8, 0.8, (gdouble) 1);
#line 833 "theme-2d-cairo.vala"
		pasang_rgb_init (&_tmp4_, (gdouble) 1, (gdouble) 1, 0.9, (gdouble) 1);
#line 833 "theme-2d-cairo.vala"
		pasang_rgb_init (&_tmp5_, (gdouble) 1, (gdouble) 1, (gdouble) 0, (gdouble) 1);
#line 833 "theme-2d-cairo.vala"
		_tmp7_ = pasang_theme2_dcairo_create_spark_brush (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
#line 833 "theme-2d-cairo.vala"
		self->priv->cluster_brush = (_vala_array_free (self->priv->cluster_brush, self->priv->cluster_brush_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
#line 833 "theme-2d-cairo.vala"
		self->priv->cluster_brush = _tmp7_;
#line 833 "theme-2d-cairo.vala"
		self->priv->cluster_brush_length1 = _tmp6_;
#line 833 "theme-2d-cairo.vala"
		self->priv->_cluster_brush_size_ = self->priv->cluster_brush_length1;
#line 836 "theme-2d-cairo.vala"
		_tmp8_ = g_new0 (gdouble, num_clusters * 4);
#line 836 "theme-2d-cairo.vala"
		self->priv->stars = (g_free (self->priv->stars), NULL);
#line 836 "theme-2d-cairo.vala"
		self->priv->stars = _tmp8_;
#line 836 "theme-2d-cairo.vala"
		self->priv->stars_length1 = num_clusters;
#line 836 "theme-2d-cairo.vala"
		self->priv->stars_length2 = 4;
#line 5846 "theme-2d-cairo.c"
		{
			gint i = 0;
#line 837 "theme-2d-cairo.vala"
			i = 0;
#line 5851 "theme-2d-cairo.c"
			{
				gboolean _tmp9_ = FALSE;
#line 837 "theme-2d-cairo.vala"
				_tmp9_ = TRUE;
#line 837 "theme-2d-cairo.vala"
				while (TRUE) {
#line 5858 "theme-2d-cairo.c"
					gdouble r = 0.0;
					gdouble theta = 0.0;
					gdouble* _tmp12_;
					gint _tmp12__length1;
					gint _tmp12__length2;
					gdouble* _tmp13_;
					gint _tmp13__length1;
					gint _tmp13__length2;
					gdouble* _tmp14_;
					gint _tmp14__length1;
					gint _tmp14__length2;
					cairo_surface_t** _tmp15_;
					gint _tmp15__length1;
					gdouble* _tmp16_;
					gint _tmp16__length1;
					gint _tmp16__length2;
#line 837 "theme-2d-cairo.vala"
					if (!_tmp9_) {
#line 5877 "theme-2d-cairo.c"
						gint _tmp10_;
#line 837 "theme-2d-cairo.vala"
						_tmp10_ = i;
#line 837 "theme-2d-cairo.vala"
						i = _tmp10_ + 1;
#line 5883 "theme-2d-cairo.c"
					}
#line 837 "theme-2d-cairo.vala"
					_tmp9_ = FALSE;
#line 837 "theme-2d-cairo.vala"
					if (!(i < num_clusters)) {
#line 837 "theme-2d-cairo.vala"
						break;
#line 5891 "theme-2d-cairo.c"
					}
#line 838 "theme-2d-cairo.vala"
					r = (gdouble) 0;
#line 5895 "theme-2d-cairo.c"
					{
						gboolean _tmp11_ = FALSE;
#line 839 "theme-2d-cairo.vala"
						_tmp11_ = TRUE;
#line 839 "theme-2d-cairo.vala"
						while (TRUE) {
#line 839 "theme-2d-cairo.vala"
							if (!_tmp11_) {
#line 841 "theme-2d-cairo.vala"
								if (!(r > 1.0)) {
#line 841 "theme-2d-cairo.vala"
									break;
#line 5908 "theme-2d-cairo.c"
								}
							}
#line 839 "theme-2d-cairo.vala"
							_tmp11_ = FALSE;
#line 840 "theme-2d-cairo.vala"
							r = sqrt (-2 * log (g_random_double ()));
#line 5915 "theme-2d-cairo.c"
						}
					}
#line 842 "theme-2d-cairo.vala"
					theta = (2 * G_PI) * g_random_double ();
#line 843 "theme-2d-cairo.vala"
					_tmp12_ = self->priv->stars;
#line 843 "theme-2d-cairo.vala"
					_tmp12__length1 = self->priv->stars_length1;
#line 843 "theme-2d-cairo.vala"
					_tmp12__length2 = self->priv->stars_length2;
#line 843 "theme-2d-cairo.vala"
					_tmp12_[(i * _tmp12__length2) + 0] = ((0.2 * size) * r) * sin (theta);
#line 844 "theme-2d-cairo.vala"
					_tmp13_ = self->priv->stars;
#line 844 "theme-2d-cairo.vala"
					_tmp13__length1 = self->priv->stars_length1;
#line 844 "theme-2d-cairo.vala"
					_tmp13__length2 = self->priv->stars_length2;
#line 844 "theme-2d-cairo.vala"
					_tmp13_[(i * _tmp13__length2) + 1] = ((0.2 * size) * r) * cos (theta);
#line 845 "theme-2d-cairo.vala"
					_tmp14_ = self->priv->stars;
#line 845 "theme-2d-cairo.vala"
					_tmp14__length1 = self->priv->stars_length1;
#line 845 "theme-2d-cairo.vala"
					_tmp14__length2 = self->priv->stars_length2;
#line 845 "theme-2d-cairo.vala"
					_tmp15_ = self->priv->cluster_brush;
#line 845 "theme-2d-cairo.vala"
					_tmp15__length1 = self->priv->cluster_brush_length1;
#line 845 "theme-2d-cairo.vala"
					_tmp14_[(i * _tmp14__length2) + 2] = (gdouble) g_random_int_range ((gint32) 0, (gint32) _tmp15__length1);
#line 846 "theme-2d-cairo.vala"
					_tmp16_ = self->priv->stars;
#line 846 "theme-2d-cairo.vala"
					_tmp16__length1 = self->priv->stars_length1;
#line 846 "theme-2d-cairo.vala"
					_tmp16__length2 = self->priv->stars_length2;
#line 846 "theme-2d-cairo.vala"
					_tmp16_[(i * _tmp16__length2) + 3] = (2 * G_PI) * g_random_double ();
#line 5956 "theme-2d-cairo.c"
				}
			}
		}
	}
#line 850 "theme-2d-cairo.vala"
	_tmp17_ = self->priv->cluster_brush;
#line 850 "theme-2d-cairo.vala"
	_tmp17__length1 = self->priv->cluster_brush_length1;
#line 850 "theme-2d-cairo.vala"
	_tmp18_ = _tmp17_[0];
#line 850 "theme-2d-cairo.vala"
	brush_width = cairo_image_surface_get_width (_tmp18_);
#line 851 "theme-2d-cairo.vala"
	cluster_width = 0.2 * size;
#line 852 "theme-2d-cairo.vala"
	scale = cluster_width / brush_width;
#line 853 "theme-2d-cairo.vala"
	if (f >= (self->priv->num_frames / 2)) {
#line 856 "theme-2d-cairo.vala"
		scale *= 1.0 + (2.5 * sin ((3.55 * (f - (self->priv->num_frames / 2))) / (self->priv->num_frames / 2)));
#line 5977 "theme-2d-cairo.c"
	}
	{
		gint i = 0;
#line 858 "theme-2d-cairo.vala"
		i = 0;
#line 5983 "theme-2d-cairo.c"
		{
			gboolean _tmp19_ = FALSE;
#line 858 "theme-2d-cairo.vala"
			_tmp19_ = TRUE;
#line 858 "theme-2d-cairo.vala"
			while (TRUE) {
#line 5990 "theme-2d-cairo.c"
				gdouble* _tmp21_;
				gint _tmp21__length1;
				gint _tmp21__length2;
				gdouble _tmp22_;
				gdouble* _tmp23_;
				gint _tmp23__length1;
				gint _tmp23__length2;
				gdouble _tmp24_;
				gint _tmp25_ = 0;
				gdouble* _tmp26_;
				gint _tmp26__length1;
				gint _tmp26__length2;
				gdouble _tmp27_;
				cairo_surface_t** _tmp28_;
				gint _tmp28__length1;
				gdouble* _tmp29_;
				gint _tmp29__length1;
				gint _tmp29__length2;
				gdouble _tmp30_;
				cairo_surface_t* _tmp31_;
#line 858 "theme-2d-cairo.vala"
				if (!_tmp19_) {
#line 6013 "theme-2d-cairo.c"
					gint _tmp20_;
#line 858 "theme-2d-cairo.vala"
					_tmp20_ = i;
#line 858 "theme-2d-cairo.vala"
					i = _tmp20_ + 1;
#line 6019 "theme-2d-cairo.c"
				}
#line 858 "theme-2d-cairo.vala"
				_tmp19_ = FALSE;
#line 858 "theme-2d-cairo.vala"
				if (!(i < num_clusters)) {
#line 858 "theme-2d-cairo.vala"
					break;
#line 6027 "theme-2d-cairo.c"
				}
#line 859 "theme-2d-cairo.vala"
				cairo_save (cr);
#line 860 "theme-2d-cairo.vala"
				_tmp21_ = self->priv->stars;
#line 860 "theme-2d-cairo.vala"
				_tmp21__length1 = self->priv->stars_length1;
#line 860 "theme-2d-cairo.vala"
				_tmp21__length2 = self->priv->stars_length2;
#line 860 "theme-2d-cairo.vala"
				_tmp22_ = _tmp21_[(i * _tmp21__length2) + 0];
#line 860 "theme-2d-cairo.vala"
				_tmp23_ = self->priv->stars;
#line 860 "theme-2d-cairo.vala"
				_tmp23__length1 = self->priv->stars_length1;
#line 860 "theme-2d-cairo.vala"
				_tmp23__length2 = self->priv->stars_length2;
#line 860 "theme-2d-cairo.vala"
				_tmp24_ = _tmp23_[(i * _tmp23__length2) + 1];
#line 860 "theme-2d-cairo.vala"
				cairo_translate (cr, _tmp22_, _tmp24_);
#line 861 "theme-2d-cairo.vala"
				cairo_scale (cr, scale, scale);
#line 862 "theme-2d-cairo.vala"
				if ((i % 2) == 0) {
#line 862 "theme-2d-cairo.vala"
					_tmp25_ = -1;
#line 6055 "theme-2d-cairo.c"
				} else {
#line 862 "theme-2d-cairo.vala"
					_tmp25_ = 1;
#line 6059 "theme-2d-cairo.c"
				}
#line 862 "theme-2d-cairo.vala"
				_tmp26_ = self->priv->stars;
#line 862 "theme-2d-cairo.vala"
				_tmp26__length1 = self->priv->stars_length1;
#line 862 "theme-2d-cairo.vala"
				_tmp26__length2 = self->priv->stars_length2;
#line 862 "theme-2d-cairo.vala"
				_tmp27_ = _tmp26_[(i * _tmp26__length2) + 3];
#line 862 "theme-2d-cairo.vala"
				cairo_rotate (cr, _tmp27_ + ((((_tmp25_ * 4) * G_PI) * f) / self->priv->num_frames));
#line 863 "theme-2d-cairo.vala"
				cairo_translate (cr, (-0.5) * brush_width, (-0.5) * brush_width);
#line 864 "theme-2d-cairo.vala"
				cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) brush_width, (gdouble) brush_width);
#line 865 "theme-2d-cairo.vala"
				_tmp28_ = self->priv->cluster_brush;
#line 865 "theme-2d-cairo.vala"
				_tmp28__length1 = self->priv->cluster_brush_length1;
#line 865 "theme-2d-cairo.vala"
				_tmp29_ = self->priv->stars;
#line 865 "theme-2d-cairo.vala"
				_tmp29__length1 = self->priv->stars_length1;
#line 865 "theme-2d-cairo.vala"
				_tmp29__length2 = self->priv->stars_length2;
#line 865 "theme-2d-cairo.vala"
				_tmp30_ = _tmp29_[(i * _tmp29__length2) + 2];
#line 865 "theme-2d-cairo.vala"
				_tmp31_ = _tmp28_[(gint) _tmp30_];
#line 865 "theme-2d-cairo.vala"
				cairo_set_source_surface (cr, _tmp31_, (gdouble) 0, (gdouble) 0);
#line 866 "theme-2d-cairo.vala"
				cairo_fill (cr);
#line 867 "theme-2d-cairo.vala"
				cairo_restore (cr);
#line 6095 "theme-2d-cairo.c"
			}
		}
	}
}

/**
     * Emulate the Spark brush from Gimp (to create stars)
     */
static cairo_surface_t**
pasang_theme2_dcairo_create_spark_brush (PasangTheme2DCairo* self,
                                         PasangRgb* core,
                                         PasangRgb* crust,
                                         PasangRgb* surface,
                                         PasangRgb* ray1,
                                         PasangRgb* ray2,
                                         PasangRgb* ray3,
                                         gint* result_length1)
{
	gint* pt = NULL;
	gint* _tmp0_;
	gint pt_length1;
	gint _pt_size_;
	cairo_surface_t** brush = NULL;
	cairo_surface_t** _tmp1_;
	gint brush_length1;
	gint _brush_size_;
	cairo_surface_t** _tmp53_;
	gint _tmp53__length1;
	cairo_surface_t** result = NULL;
#line 874 "theme-2d-cairo.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 874 "theme-2d-cairo.vala"
	g_return_val_if_fail (core != NULL, NULL);
#line 874 "theme-2d-cairo.vala"
	g_return_val_if_fail (crust != NULL, NULL);
#line 874 "theme-2d-cairo.vala"
	g_return_val_if_fail (surface != NULL, NULL);
#line 874 "theme-2d-cairo.vala"
	g_return_val_if_fail (ray1 != NULL, NULL);
#line 874 "theme-2d-cairo.vala"
	g_return_val_if_fail (ray2 != NULL, NULL);
#line 874 "theme-2d-cairo.vala"
	g_return_val_if_fail (ray3 != NULL, NULL);
#line 877 "theme-2d-cairo.vala"
	_tmp0_ = g_new0 (gint, 56);
#line 877 "theme-2d-cairo.vala"
	_tmp0_[0] = 0;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[1] = 35;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[2] = 30;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[3] = 25;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[4] = 1;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[5] = 20;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[6] = 16;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[7] = 6;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[8] = 1;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[9] = 41;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[10] = 42;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[11] = 5;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[12] = 2;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[13] = 29;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[14] = 22;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[15] = 13;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[16] = 3;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[17] = 35;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[18] = 38;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[19] = 14;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[20] = 4;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[21] = 29;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[22] = 26;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[23] = 10;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[24] = 5;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[25] = 33;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[26] = 21;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[27] = 7;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[28] = 5;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[29] = 18;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[30] = 45;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[31] = 3;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[32] = 6;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[33] = 27;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[34] = 23;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[35] = 11;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[36] = 6;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[37] = 48;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[38] = 42;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[39] = 5;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[40] = 7;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[41] = 32;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[42] = 31;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[43] = 12;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[44] = 8;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[45] = 28;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[46] = 20;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[47] = 3;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[48] = 8;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[49] = 50;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[50] = 14;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[51] = 3;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[52] = 8;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[53] = 38;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[54] = 44;
#line 877 "theme-2d-cairo.vala"
	_tmp0_[55] = 3;
#line 877 "theme-2d-cairo.vala"
	pt = _tmp0_;
#line 877 "theme-2d-cairo.vala"
	pt_length1 = 56;
#line 877 "theme-2d-cairo.vala"
	_pt_size_ = pt_length1;
#line 886 "theme-2d-cairo.vala"
	_tmp1_ = g_new0 (cairo_surface_t*, 9 + 1);
#line 886 "theme-2d-cairo.vala"
	brush = _tmp1_;
#line 886 "theme-2d-cairo.vala"
	brush_length1 = 9;
#line 886 "theme-2d-cairo.vala"
	_brush_size_ = brush_length1;
#line 6267 "theme-2d-cairo.c"
	{
		gint i = 0;
#line 887 "theme-2d-cairo.vala"
		i = 0;
#line 6272 "theme-2d-cairo.c"
		{
			gboolean _tmp2_ = FALSE;
#line 887 "theme-2d-cairo.vala"
			_tmp2_ = TRUE;
#line 887 "theme-2d-cairo.vala"
			while (TRUE) {
#line 6279 "theme-2d-cairo.c"
				cairo_surface_t** _tmp4_;
				gint _tmp4__length1;
				cairo_surface_t** _tmp5_;
				gint _tmp5__length1;
				cairo_surface_t* _tmp6_;
#line 887 "theme-2d-cairo.vala"
				if (!_tmp2_) {
#line 6287 "theme-2d-cairo.c"
					gint _tmp3_;
#line 887 "theme-2d-cairo.vala"
					_tmp3_ = i;
#line 887 "theme-2d-cairo.vala"
					i = _tmp3_ + 1;
#line 6293 "theme-2d-cairo.c"
				}
#line 887 "theme-2d-cairo.vala"
				_tmp2_ = FALSE;
#line 887 "theme-2d-cairo.vala"
				_tmp4_ = brush;
#line 887 "theme-2d-cairo.vala"
				_tmp4__length1 = brush_length1;
#line 887 "theme-2d-cairo.vala"
				if (!(i < _tmp4__length1)) {
#line 887 "theme-2d-cairo.vala"
					break;
#line 6305 "theme-2d-cairo.c"
				}
#line 888 "theme-2d-cairo.vala"
				_tmp5_ = brush;
#line 888 "theme-2d-cairo.vala"
				_tmp5__length1 = brush_length1;
#line 888 "theme-2d-cairo.vala"
				_tmp6_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 60, 60);
#line 888 "theme-2d-cairo.vala"
				_cairo_surface_destroy0 (_tmp5_[i]);
#line 888 "theme-2d-cairo.vala"
				_tmp5_[i] = _tmp6_;
#line 6317 "theme-2d-cairo.c"
			}
		}
	}
	{
		gint i = 0;
#line 890 "theme-2d-cairo.vala"
		i = 0;
#line 6325 "theme-2d-cairo.c"
		{
			gboolean _tmp7_ = FALSE;
#line 890 "theme-2d-cairo.vala"
			_tmp7_ = TRUE;
#line 890 "theme-2d-cairo.vala"
			while (TRUE) {
#line 6332 "theme-2d-cairo.c"
				gint* _tmp8_;
				gint _tmp8__length1;
				gint n = 0;
				gint* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				gint _tmp11_;
				cairo_t* brush_cr = NULL;
				cairo_surface_t** _tmp12_;
				gint _tmp12__length1;
				cairo_surface_t* _tmp13_;
				cairo_t* _tmp14_;
				gint x = 0;
				gint* _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				gint _tmp17_;
				gint y = 0;
				gint* _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				gint _tmp20_;
				gint r = 0;
				gint* _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_;
				gint _tmp23_;
				cairo_pattern_t* pattern = NULL;
				cairo_pattern_t* _tmp24_;
				cairo_pattern_t* _tmp25_;
				PasangRgb _tmp26_;
				PasangRgb _tmp27_;
				PasangRgb _tmp28_;
				cairo_pattern_t* _tmp29_;
				PasangRgb _tmp30_;
				PasangRgb _tmp31_;
				PasangRgb _tmp32_;
				cairo_pattern_t* _tmp33_;
				PasangRgb _tmp34_;
				PasangRgb _tmp35_;
				PasangRgb _tmp36_;
				cairo_pattern_t* _tmp37_;
				PasangRgb _tmp38_;
				PasangRgb _tmp39_;
				PasangRgb _tmp40_;
				cairo_pattern_t* _tmp41_;
				PasangRgb _tmp42_;
				PasangRgb _tmp43_;
				PasangRgb _tmp44_;
				cairo_pattern_t* _tmp45_;
				PasangRgb _tmp46_;
				PasangRgb _tmp47_;
				PasangRgb _tmp48_;
				cairo_pattern_t* _tmp49_;
				cairo_t* _tmp50_;
				cairo_pattern_t* _tmp51_;
				cairo_t* _tmp52_;
#line 890 "theme-2d-cairo.vala"
				if (!_tmp7_) {
#line 6392 "theme-2d-cairo.c"
				}
#line 890 "theme-2d-cairo.vala"
				_tmp7_ = FALSE;
#line 890 "theme-2d-cairo.vala"
				_tmp8_ = pt;
#line 890 "theme-2d-cairo.vala"
				_tmp8__length1 = pt_length1;
#line 890 "theme-2d-cairo.vala"
				if (!(i < _tmp8__length1)) {
#line 890 "theme-2d-cairo.vala"
					break;
#line 6404 "theme-2d-cairo.c"
				}
#line 891 "theme-2d-cairo.vala"
				_tmp9_ = pt;
#line 891 "theme-2d-cairo.vala"
				_tmp9__length1 = pt_length1;
#line 891 "theme-2d-cairo.vala"
				_tmp10_ = i;
#line 891 "theme-2d-cairo.vala"
				i = _tmp10_ + 1;
#line 891 "theme-2d-cairo.vala"
				_tmp11_ = _tmp9_[_tmp10_];
#line 891 "theme-2d-cairo.vala"
				n = _tmp11_;
#line 892 "theme-2d-cairo.vala"
				_tmp12_ = brush;
#line 892 "theme-2d-cairo.vala"
				_tmp12__length1 = brush_length1;
#line 892 "theme-2d-cairo.vala"
				_tmp13_ = _tmp12_[n];
#line 892 "theme-2d-cairo.vala"
				_tmp14_ = cairo_create (_tmp13_);
#line 892 "theme-2d-cairo.vala"
				brush_cr = _tmp14_;
#line 893 "theme-2d-cairo.vala"
				_tmp15_ = pt;
#line 893 "theme-2d-cairo.vala"
				_tmp15__length1 = pt_length1;
#line 893 "theme-2d-cairo.vala"
				_tmp16_ = i;
#line 893 "theme-2d-cairo.vala"
				i = _tmp16_ + 1;
#line 893 "theme-2d-cairo.vala"
				_tmp17_ = _tmp15_[_tmp16_];
#line 893 "theme-2d-cairo.vala"
				x = _tmp17_;
#line 894 "theme-2d-cairo.vala"
				_tmp18_ = pt;
#line 894 "theme-2d-cairo.vala"
				_tmp18__length1 = pt_length1;
#line 894 "theme-2d-cairo.vala"
				_tmp19_ = i;
#line 894 "theme-2d-cairo.vala"
				i = _tmp19_ + 1;
#line 894 "theme-2d-cairo.vala"
				_tmp20_ = _tmp18_[_tmp19_];
#line 894 "theme-2d-cairo.vala"
				y = _tmp20_;
#line 895 "theme-2d-cairo.vala"
				_tmp21_ = pt;
#line 895 "theme-2d-cairo.vala"
				_tmp21__length1 = pt_length1;
#line 895 "theme-2d-cairo.vala"
				_tmp22_ = i;
#line 895 "theme-2d-cairo.vala"
				i = _tmp22_ + 1;
#line 895 "theme-2d-cairo.vala"
				_tmp23_ = _tmp21_[_tmp22_];
#line 895 "theme-2d-cairo.vala"
				r = _tmp23_;
#line 896 "theme-2d-cairo.vala"
				_tmp24_ = cairo_pattern_create_radial ((gdouble) x, (gdouble) y, (gdouble) 0, (gdouble) x, (gdouble) y, (gdouble) r);
#line 896 "theme-2d-cairo.vala"
				pattern = _tmp24_;
#line 897 "theme-2d-cairo.vala"
				_tmp25_ = pattern;
#line 897 "theme-2d-cairo.vala"
				_tmp26_ = *core;
#line 897 "theme-2d-cairo.vala"
				_tmp27_ = *core;
#line 897 "theme-2d-cairo.vala"
				_tmp28_ = *core;
#line 897 "theme-2d-cairo.vala"
				cairo_pattern_add_color_stop_rgba (_tmp25_, (gdouble) 0, _tmp26_.red, _tmp27_.green, _tmp28_.blue, (gdouble) 1);
#line 898 "theme-2d-cairo.vala"
				_tmp29_ = pattern;
#line 898 "theme-2d-cairo.vala"
				_tmp30_ = *crust;
#line 898 "theme-2d-cairo.vala"
				_tmp31_ = *crust;
#line 898 "theme-2d-cairo.vala"
				_tmp32_ = *crust;
#line 898 "theme-2d-cairo.vala"
				cairo_pattern_add_color_stop_rgba (_tmp29_, 12.0 / 60, _tmp30_.red, _tmp31_.green, _tmp32_.blue, 0.9);
#line 899 "theme-2d-cairo.vala"
				_tmp33_ = pattern;
#line 899 "theme-2d-cairo.vala"
				_tmp34_ = *surface;
#line 899 "theme-2d-cairo.vala"
				_tmp35_ = *surface;
#line 899 "theme-2d-cairo.vala"
				_tmp36_ = *surface;
#line 899 "theme-2d-cairo.vala"
				cairo_pattern_add_color_stop_rgba (_tmp33_, 15.0 / 60, _tmp34_.red, _tmp35_.green, _tmp36_.blue, 0.66);
#line 900 "theme-2d-cairo.vala"
				_tmp37_ = pattern;
#line 900 "theme-2d-cairo.vala"
				_tmp38_ = *ray1;
#line 900 "theme-2d-cairo.vala"
				_tmp39_ = *ray1;
#line 900 "theme-2d-cairo.vala"
				_tmp40_ = *ray1;
#line 900 "theme-2d-cairo.vala"
				cairo_pattern_add_color_stop_rgba (_tmp37_, 20.0 / 60, _tmp38_.red, _tmp39_.green, _tmp40_.blue, 0.49);
#line 901 "theme-2d-cairo.vala"
				_tmp41_ = pattern;
#line 901 "theme-2d-cairo.vala"
				_tmp42_ = *ray2;
#line 901 "theme-2d-cairo.vala"
				_tmp43_ = *ray2;
#line 901 "theme-2d-cairo.vala"
				_tmp44_ = *ray2;
#line 901 "theme-2d-cairo.vala"
				cairo_pattern_add_color_stop_rgba (_tmp41_, 30.0 / 60, _tmp42_.red, _tmp43_.green, _tmp44_.blue, 0.43);
#line 902 "theme-2d-cairo.vala"
				_tmp45_ = pattern;
#line 902 "theme-2d-cairo.vala"
				_tmp46_ = *ray3;
#line 902 "theme-2d-cairo.vala"
				_tmp47_ = *ray3;
#line 902 "theme-2d-cairo.vala"
				_tmp48_ = *ray3;
#line 902 "theme-2d-cairo.vala"
				cairo_pattern_add_color_stop_rgba (_tmp45_, 50.0 / 60, _tmp46_.red, _tmp47_.green, _tmp48_.blue, 0.10);
#line 903 "theme-2d-cairo.vala"
				_tmp49_ = pattern;
#line 903 "theme-2d-cairo.vala"
				cairo_pattern_add_color_stop_rgba (_tmp49_, (gdouble) 1, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 904 "theme-2d-cairo.vala"
				_tmp50_ = brush_cr;
#line 904 "theme-2d-cairo.vala"
				_tmp51_ = pattern;
#line 904 "theme-2d-cairo.vala"
				cairo_set_source (_tmp50_, _tmp51_);
#line 905 "theme-2d-cairo.vala"
				_tmp52_ = brush_cr;
#line 905 "theme-2d-cairo.vala"
				cairo_paint (_tmp52_);
#line 890 "theme-2d-cairo.vala"
				_cairo_pattern_destroy0 (pattern);
#line 890 "theme-2d-cairo.vala"
				_cairo_destroy0 (brush_cr);
#line 6546 "theme-2d-cairo.c"
			}
		}
	}
#line 907 "theme-2d-cairo.vala"
	_tmp53_ = brush;
#line 907 "theme-2d-cairo.vala"
	_tmp53__length1 = brush_length1;
#line 907 "theme-2d-cairo.vala"
	if (result_length1) {
#line 907 "theme-2d-cairo.vala"
		*result_length1 = _tmp53__length1;
#line 6558 "theme-2d-cairo.c"
	}
#line 907 "theme-2d-cairo.vala"
	result = _tmp53_;
#line 907 "theme-2d-cairo.vala"
	pt = (g_free (pt), NULL);
#line 907 "theme-2d-cairo.vala"
	return result;
#line 6566 "theme-2d-cairo.c"
}

/**
     * Trace a flower pattern. Don't draw, just trace.
     */
static void
pasang_theme2_dcairo_trace_flower (PasangTheme2DCairo* self,
                                   cairo_t* cr,
                                   gint num_petals,
                                   gdouble x,
                                   gdouble y,
                                   gdouble radius1,
                                   gdouble radius2,
                                   gdouble shift,
                                   gint num_removed)
{
#line 913 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 913 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 916 "theme-2d-cairo.vala"
	cairo_move_to (cr, x + radius1, y);
#line 6589 "theme-2d-cairo.c"
	{
		gint i = 0;
#line 917 "theme-2d-cairo.vala"
		i = num_removed;
#line 6594 "theme-2d-cairo.c"
		{
			gboolean _tmp0_ = FALSE;
#line 917 "theme-2d-cairo.vala"
			_tmp0_ = TRUE;
#line 917 "theme-2d-cairo.vala"
			while (TRUE) {
#line 6601 "theme-2d-cairo.c"
				gdouble angle = 0.0;
				gdouble x1 = 0.0;
				gdouble y1 = 0.0;
				gdouble x2 = 0.0;
				gdouble y2 = 0.0;
				gdouble x3 = 0.0;
				gdouble y3 = 0.0;
#line 917 "theme-2d-cairo.vala"
				if (!_tmp0_) {
#line 6611 "theme-2d-cairo.c"
					gint _tmp1_;
#line 917 "theme-2d-cairo.vala"
					_tmp1_ = i;
#line 917 "theme-2d-cairo.vala"
					i = _tmp1_ + 1;
#line 6617 "theme-2d-cairo.c"
				}
#line 917 "theme-2d-cairo.vala"
				_tmp0_ = FALSE;
#line 917 "theme-2d-cairo.vala"
				if (!(i <= num_petals)) {
#line 917 "theme-2d-cairo.vala"
					break;
#line 6625 "theme-2d-cairo.c"
				}
#line 918 "theme-2d-cairo.vala"
				angle = (((G_PI * 2) * i) / num_petals) + shift;
#line 919 "theme-2d-cairo.vala"
				x1 = x + (radius2 * cos (angle));
#line 920 "theme-2d-cairo.vala"
				y1 = y + (radius2 * sin (angle));
#line 921 "theme-2d-cairo.vala"
				angle = (((G_PI * 2) * (i + 1)) / num_petals) + shift;
#line 922 "theme-2d-cairo.vala"
				x2 = x + (radius2 * cos (angle));
#line 923 "theme-2d-cairo.vala"
				y2 = y + (radius2 * sin (angle));
#line 924 "theme-2d-cairo.vala"
				x3 = x + (radius1 * cos (angle));
#line 925 "theme-2d-cairo.vala"
				y3 = y + (radius1 * sin (angle));
#line 926 "theme-2d-cairo.vala"
				cairo_curve_to (cr, x1, y1, x2, y2, x3, y3);
#line 6645 "theme-2d-cairo.c"
			}
		}
	}
}

static void
pasang_theme2_dcairo_trace_rounded_rectangle (PasangTheme2DCairo* self,
                                              cairo_t* cr,
                                              gdouble x,
                                              gdouble y,
                                              gdouble width,
                                              gdouble height,
                                              gdouble radius)
{
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble r2 = 0.0;
#line 930 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 930 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 932 "theme-2d-cairo.vala"
	x2 = x + width;
#line 933 "theme-2d-cairo.vala"
	y2 = y + height;
#line 934 "theme-2d-cairo.vala"
	r2 = radius / 2;
#line 935 "theme-2d-cairo.vala"
	cairo_move_to (cr, x + radius, y);
#line 936 "theme-2d-cairo.vala"
	cairo_line_to (cr, x2 - radius, y);
#line 937 "theme-2d-cairo.vala"
	cairo_curve_to (cr, x2 - r2, y, x2, y + r2, x2, y + radius);
#line 938 "theme-2d-cairo.vala"
	cairo_line_to (cr, x2, y2 - radius);
#line 939 "theme-2d-cairo.vala"
	cairo_curve_to (cr, x2, y2 - r2, x2 - r2, y2, x2 - radius, y2);
#line 940 "theme-2d-cairo.vala"
	cairo_line_to (cr, x + radius, y2);
#line 941 "theme-2d-cairo.vala"
	cairo_curve_to (cr, x + r2, y2, x, y2 - r2, x, y2 - radius);
#line 942 "theme-2d-cairo.vala"
	cairo_line_to (cr, x, y + radius);
#line 943 "theme-2d-cairo.vala"
	cairo_curve_to (cr, x, y + r2, x + r2, y, x + radius, y);
#line 6691 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_fill_triangle (PasangTheme2DCairo* self,
                                    cairo_t* cr,
                                    PasangRgb* color,
                                    gdouble x1,
                                    gdouble y1,
                                    gdouble x2,
                                    gdouble y2,
                                    gdouble x3,
                                    gdouble y3)
{
#line 946 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 946 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 946 "theme-2d-cairo.vala"
	g_return_if_fail (color != NULL);
#line 948 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_trace_triangle (self, cr, x1, y1, x2, y2, x3, y3);
#line 949 "theme-2d-cairo.vala"
	pasang_rgb_set_source_for (color, cr);
#line 950 "theme-2d-cairo.vala"
	cairo_fill (cr);
#line 6717 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_trace_triangle (PasangTheme2DCairo* self,
                                     cairo_t* cr,
                                     gdouble x1,
                                     gdouble y1,
                                     gdouble x2,
                                     gdouble y2,
                                     gdouble x3,
                                     gdouble y3)
{
#line 953 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 953 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 955 "theme-2d-cairo.vala"
	cairo_move_to (cr, x1, y1);
#line 956 "theme-2d-cairo.vala"
	cairo_line_to (cr, x2, y2);
#line 957 "theme-2d-cairo.vala"
	cairo_line_to (cr, x3, y3);
#line 958 "theme-2d-cairo.vala"
	cairo_line_to (cr, x1, y1);
#line 6742 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_fill_rectangle (PasangTheme2DCairo* self,
                                     cairo_t* cr,
                                     PasangRgb* color,
                                     gdouble x,
                                     gdouble y,
                                     gdouble w,
                                     gdouble h)
{
#line 961 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 961 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 961 "theme-2d-cairo.vala"
	g_return_if_fail (color != NULL);
#line 962 "theme-2d-cairo.vala"
	cairo_rectangle (cr, x, y, w, h);
#line 963 "theme-2d-cairo.vala"
	pasang_rgb_set_source_for (color, cr);
#line 964 "theme-2d-cairo.vala"
	cairo_fill (cr);
#line 6766 "theme-2d-cairo.c"
}

/**
     * Paint horizontal and vertical lines, forming a grid.
     */
static void
pasang_theme2_dcairo_draw_grids (PasangTheme2DCairo* self,
                                 cairo_t* cr,
                                 PasangRgb* line_color,
                                 gdouble line_width)
{
	PasangLayout2D _tmp0_;
	PasangLayout2D _tmp1_;
	PasangLayout2D _tmp2_;
	PasangLayout2D _tmp3_;
	gint gap = 0;
#line 970 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 970 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 970 "theme-2d-cairo.vala"
	g_return_if_fail (line_color != NULL);
#line 971 "theme-2d-cairo.vala"
	cairo_save (cr);
#line 972 "theme-2d-cairo.vala"
	_tmp0_ = ((PasangTheme2D*) self)->table;
#line 972 "theme-2d-cairo.vala"
	_tmp1_ = ((PasangTheme2D*) self)->table;
#line 972 "theme-2d-cairo.vala"
	_tmp2_ = ((PasangTheme2D*) self)->table;
#line 972 "theme-2d-cairo.vala"
	_tmp3_ = ((PasangTheme2D*) self)->table;
#line 972 "theme-2d-cairo.vala"
	cairo_translate (cr, (gdouble) (_tmp0_.board_x - _tmp1_.x), (gdouble) (_tmp2_.board_y - _tmp3_.y));
#line 973 "theme-2d-cairo.vala"
	pasang_rgb_set_source_for (line_color, cr);
#line 974 "theme-2d-cairo.vala"
	gap = pasang_theme2_d_cell_width ((PasangTheme2D*) self);
#line 6805 "theme-2d-cairo.c"
	{
		gint i = 0;
#line 975 "theme-2d-cairo.vala"
		i = 0;
#line 6810 "theme-2d-cairo.c"
		{
			gboolean _tmp4_ = FALSE;
#line 975 "theme-2d-cairo.vala"
			_tmp4_ = TRUE;
#line 975 "theme-2d-cairo.vala"
			while (TRUE) {
#line 6817 "theme-2d-cairo.c"
				gdouble x = 0.0;
				gdouble y = 0.0;
				gdouble w = 0.0;
				gint h = 0;
#line 975 "theme-2d-cairo.vala"
				if (!_tmp4_) {
#line 6824 "theme-2d-cairo.c"
					gint _tmp5_;
#line 975 "theme-2d-cairo.vala"
					_tmp5_ = i;
#line 975 "theme-2d-cairo.vala"
					i = _tmp5_ + 1;
#line 6830 "theme-2d-cairo.c"
				}
#line 975 "theme-2d-cairo.vala"
				_tmp4_ = FALSE;
#line 975 "theme-2d-cairo.vala"
				if (!(i < 11)) {
#line 975 "theme-2d-cairo.vala"
					break;
#line 6838 "theme-2d-cairo.c"
				}
#line 976 "theme-2d-cairo.vala"
				x = ((gap * 1.5) + (gap * i)) - ((0.5 * line_width) * gap);
#line 977 "theme-2d-cairo.vala"
				y = (gap * 1.5) - ((0.5 * line_width) * gap);
#line 978 "theme-2d-cairo.vala"
				w = line_width * gap;
#line 979 "theme-2d-cairo.vala"
				h = 10 * gap;
#line 980 "theme-2d-cairo.vala"
				if (i != 5) {
#line 981 "theme-2d-cairo.vala"
					cairo_rectangle (cr, x, y, w, h + w);
#line 982 "theme-2d-cairo.vala"
					cairo_rectangle (cr, y, x, (gdouble) h, w);
#line 6854 "theme-2d-cairo.c"
				} else {
#line 985 "theme-2d-cairo.vala"
					cairo_rectangle (cr, x, y, w, (gdouble) (4 * gap));
#line 986 "theme-2d-cairo.vala"
					cairo_rectangle (cr, x, y + (6 * gap), w, (gdouble) (4 * gap));
#line 987 "theme-2d-cairo.vala"
					cairo_rectangle (cr, y, x, (gdouble) (4 * gap), w);
#line 988 "theme-2d-cairo.vala"
					cairo_rectangle (cr, y + (6 * gap), x, (gdouble) (4 * gap), w);
#line 6864 "theme-2d-cairo.c"
				}
			}
		}
	}
#line 991 "theme-2d-cairo.vala"
	cairo_fill (cr);
#line 992 "theme-2d-cairo.vala"
	cairo_restore (cr);
#line 6873 "theme-2d-cairo.c"
}

/**
     * Paint a texture using layers translucent black and white bands.
     * Each layer is specified using 5 numbers:
     *   grain size     : the spacing between the bands
     *   alpha          : 0 to 1
     *   x1, y1, x2, y2 : e.g., 0, 0, 1, 1 means the band goes this way ////
     *                          0, 0, 1, 0 means the band goes this way ||||
     */
static void
pasang_theme2_dcairo_paint_texture (PasangTheme2DCairo* self,
                                    cairo_t* cr,
                                    gint num_layers,
                                    gdouble* layer_spec,
                                    gint layer_spec_length1)
{
	cairo_surface_t* tile = NULL;
	cairo_surface_t* _tmp0_;
	cairo_pattern_t* _tmp1_;
#line 1003 "theme-2d-cairo.vala"
	g_return_if_fail (self != NULL);
#line 1003 "theme-2d-cairo.vala"
	g_return_if_fail (cr != NULL);
#line 1004 "theme-2d-cairo.vala"
	_vala_assert ((num_layers * 6) == layer_spec_length1, "num_layers * 6 == layer_spec.length");
#line 1007 "theme-2d-cairo.vala"
	_tmp0_ = pasang_theme2_dcairo_create_texture (self, num_layers, layer_spec, (gint) layer_spec_length1);
#line 1007 "theme-2d-cairo.vala"
	tile = _tmp0_;
#line 1008 "theme-2d-cairo.vala"
	cairo_set_source_surface (cr, tile, (gdouble) 0, (gdouble) 0);
#line 1009 "theme-2d-cairo.vala"
	_tmp1_ = cairo_get_source (cr);
#line 1009 "theme-2d-cairo.vala"
	cairo_pattern_set_extend (_tmp1_, CAIRO_EXTEND_REPEAT);
#line 1010 "theme-2d-cairo.vala"
	cairo_paint (cr);
#line 1003 "theme-2d-cairo.vala"
	_cairo_surface_destroy0 (tile);
#line 6914 "theme-2d-cairo.c"
}

/**
     * See paint_texture for arguments and usage
     */
static cairo_surface_t*
pasang_theme2_dcairo_create_texture (PasangTheme2DCairo* self,
                                     gint num_layers,
                                     gdouble* layer_spec,
                                     gint layer_spec_length1)
{
	gint tile_size = 0;
	gdouble _tmp0_;
	cairo_surface_t* tile = NULL;
	cairo_surface_t* _tmp1_;
	cairo_t* tile_cr = NULL;
	cairo_surface_t* _tmp2_;
	cairo_t* _tmp3_;
	gint n = 0;
	cairo_surface_t* result = NULL;
#line 1016 "theme-2d-cairo.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1017 "theme-2d-cairo.vala"
	_tmp0_ = layer_spec[0];
#line 1017 "theme-2d-cairo.vala"
	tile_size = (gint) (16 * _tmp0_);
#line 1018 "theme-2d-cairo.vala"
	_tmp1_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, tile_size, tile_size);
#line 1018 "theme-2d-cairo.vala"
	tile = _tmp1_;
#line 1019 "theme-2d-cairo.vala"
	_tmp2_ = tile;
#line 1019 "theme-2d-cairo.vala"
	_tmp3_ = cairo_create (_tmp2_);
#line 1019 "theme-2d-cairo.vala"
	tile_cr = _tmp3_;
#line 1021 "theme-2d-cairo.vala"
	n = 0;
#line 6953 "theme-2d-cairo.c"
	{
		gint layer = 0;
#line 1022 "theme-2d-cairo.vala"
		layer = 0;
#line 6958 "theme-2d-cairo.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1022 "theme-2d-cairo.vala"
			_tmp4_ = TRUE;
#line 1022 "theme-2d-cairo.vala"
			while (TRUE) {
#line 6965 "theme-2d-cairo.c"
				gint size = 0;
				gdouble grain_size = 0.0;
				gint _tmp6_;
				gdouble _tmp7_;
				gdouble alpha = 0.0;
				gint _tmp8_;
				gdouble _tmp9_;
				gdouble x1 = 0.0;
				gint _tmp10_;
				gdouble _tmp11_;
				gdouble y1 = 0.0;
				gint _tmp12_;
				gdouble _tmp13_;
				gdouble x2 = 0.0;
				gint _tmp14_;
				gdouble _tmp15_;
				gdouble y2 = 0.0;
				gint _tmp16_;
				gdouble _tmp17_;
				cairo_pattern_t* shade = NULL;
				cairo_pattern_t* _tmp18_;
				gint v = 0;
				cairo_t* _tmp22_;
				cairo_pattern_t* _tmp23_;
				cairo_t* _tmp24_;
#line 1022 "theme-2d-cairo.vala"
				if (!_tmp4_) {
#line 6993 "theme-2d-cairo.c"
					gint _tmp5_;
#line 1022 "theme-2d-cairo.vala"
					_tmp5_ = layer;
#line 1022 "theme-2d-cairo.vala"
					layer = _tmp5_ + 1;
#line 6999 "theme-2d-cairo.c"
				}
#line 1022 "theme-2d-cairo.vala"
				_tmp4_ = FALSE;
#line 1022 "theme-2d-cairo.vala"
				if (!(layer < num_layers)) {
#line 1022 "theme-2d-cairo.vala"
					break;
#line 7007 "theme-2d-cairo.c"
				}
#line 1023 "theme-2d-cairo.vala"
				size = 1024;
#line 1024 "theme-2d-cairo.vala"
				_tmp6_ = n;
#line 1024 "theme-2d-cairo.vala"
				n = _tmp6_ + 1;
#line 1024 "theme-2d-cairo.vala"
				_tmp7_ = layer_spec[_tmp6_];
#line 1024 "theme-2d-cairo.vala"
				grain_size = _tmp7_;
#line 1025 "theme-2d-cairo.vala"
				_tmp8_ = n;
#line 1025 "theme-2d-cairo.vala"
				n = _tmp8_ + 1;
#line 1025 "theme-2d-cairo.vala"
				_tmp9_ = layer_spec[_tmp8_];
#line 1025 "theme-2d-cairo.vala"
				alpha = _tmp9_;
#line 1026 "theme-2d-cairo.vala"
				_tmp10_ = n;
#line 1026 "theme-2d-cairo.vala"
				n = _tmp10_ + 1;
#line 1026 "theme-2d-cairo.vala"
				_tmp11_ = layer_spec[_tmp10_];
#line 1026 "theme-2d-cairo.vala"
				x1 = _tmp11_ * size;
#line 1027 "theme-2d-cairo.vala"
				_tmp12_ = n;
#line 1027 "theme-2d-cairo.vala"
				n = _tmp12_ + 1;
#line 1027 "theme-2d-cairo.vala"
				_tmp13_ = layer_spec[_tmp12_];
#line 1027 "theme-2d-cairo.vala"
				y1 = _tmp13_ * size;
#line 1028 "theme-2d-cairo.vala"
				_tmp14_ = n;
#line 1028 "theme-2d-cairo.vala"
				n = _tmp14_ + 1;
#line 1028 "theme-2d-cairo.vala"
				_tmp15_ = layer_spec[_tmp14_];
#line 1028 "theme-2d-cairo.vala"
				x2 = _tmp15_ * size;
#line 1029 "theme-2d-cairo.vala"
				_tmp16_ = n;
#line 1029 "theme-2d-cairo.vala"
				n = _tmp16_ + 1;
#line 1029 "theme-2d-cairo.vala"
				_tmp17_ = layer_spec[_tmp16_];
#line 1029 "theme-2d-cairo.vala"
				y2 = _tmp17_ * size;
#line 1030 "theme-2d-cairo.vala"
				_tmp18_ = cairo_pattern_create_linear (x1, y1, x2, y2);
#line 1030 "theme-2d-cairo.vala"
				shade = _tmp18_;
#line 1031 "theme-2d-cairo.vala"
				v = 0;
#line 7065 "theme-2d-cairo.c"
				{
					gdouble i = 0.0;
#line 1032 "theme-2d-cairo.vala"
					i = (gdouble) 0;
#line 7070 "theme-2d-cairo.c"
					{
						gboolean _tmp19_ = FALSE;
#line 1032 "theme-2d-cairo.vala"
						_tmp19_ = TRUE;
#line 1032 "theme-2d-cairo.vala"
						while (TRUE) {
#line 7077 "theme-2d-cairo.c"
							gint _tmp20_;
							gdouble val = 0.0;
							cairo_pattern_t* _tmp21_;
#line 1032 "theme-2d-cairo.vala"
							if (!_tmp19_) {
#line 1032 "theme-2d-cairo.vala"
								i += grain_size;
#line 7085 "theme-2d-cairo.c"
							}
#line 1032 "theme-2d-cairo.vala"
							_tmp19_ = FALSE;
#line 1032 "theme-2d-cairo.vala"
							if (!(i <= ((gdouble) (size * 2)))) {
#line 1032 "theme-2d-cairo.vala"
								break;
#line 7093 "theme-2d-cairo.c"
							}
#line 1033 "theme-2d-cairo.vala"
							_tmp20_ = v;
#line 1033 "theme-2d-cairo.vala"
							v = _tmp20_ + 1;
#line 1034 "theme-2d-cairo.vala"
							val = (gdouble) (v % 2);
#line 1035 "theme-2d-cairo.vala"
							_tmp21_ = shade;
#line 1035 "theme-2d-cairo.vala"
							cairo_pattern_add_color_stop_rgba (_tmp21_, ((gdouble) i) / size, val, val, val, alpha);
#line 7105 "theme-2d-cairo.c"
						}
					}
				}
#line 1037 "theme-2d-cairo.vala"
				_tmp22_ = tile_cr;
#line 1037 "theme-2d-cairo.vala"
				_tmp23_ = shade;
#line 1037 "theme-2d-cairo.vala"
				cairo_set_source (_tmp22_, _tmp23_);
#line 1038 "theme-2d-cairo.vala"
				_tmp24_ = tile_cr;
#line 1038 "theme-2d-cairo.vala"
				cairo_paint (_tmp24_);
#line 1022 "theme-2d-cairo.vala"
				_cairo_pattern_destroy0 (shade);
#line 7121 "theme-2d-cairo.c"
			}
		}
	}
#line 1040 "theme-2d-cairo.vala"
	result = tile;
#line 1040 "theme-2d-cairo.vala"
	_cairo_destroy0 (tile_cr);
#line 1040 "theme-2d-cairo.vala"
	return result;
#line 7131 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_class_init (PasangTheme2DCairoClass * klass,
                                 gpointer klass_data)
{
#line 51 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_parent_class = g_type_class_peek_parent (klass);
#line 51 "theme-2d-cairo.vala"
	g_type_class_adjust_private_offset (klass, &PasangTheme2DCairo_private_offset);
#line 51 "theme-2d-cairo.vala"
	((PasangThemeClass *) klass)->select = (PasangTheme* (*) (PasangTheme*, const gchar*, gint, gint)) pasang_theme2_dcairo_real_select;
#line 51 "theme-2d-cairo.vala"
	((PasangTheme2DClass *) klass)->resize_images = (void (*) (PasangTheme2D*)) pasang_theme2_dcairo_real_resize_images;
#line 51 "theme-2d-cairo.vala"
	((PasangThemeClass *) klass)->free = (void (*) (PasangTheme*)) pasang_theme2_dcairo_real_free;
#line 51 "theme-2d-cairo.vala"
	G_OBJECT_CLASS (klass)->finalize = pasang_theme2_dcairo_finalize;
#line 51 "theme-2d-cairo.vala"
	pasang_theme2_dcairo_signals[PASANG_THEME2_DCAIRO_CHANGED_SIGNAL] = g_signal_new ("changed", PASANG_TYPE_THEME2_DCAIRO, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 7152 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_instance_init (PasangTheme2DCairo * self,
                                    gpointer klass)
{
#line 51 "theme-2d-cairo.vala"
	self->priv = pasang_theme2_dcairo_get_instance_private (self);
#line 55 "theme-2d-cairo.vala"
	self->priv->path = NULL;
#line 56 "theme-2d-cairo.vala"
	self->priv->num_frames = 40;
#line 74 "theme-2d-cairo.vala"
	pasang_rgb_init (&self->priv->spin_color, 0.2, 0.5, 0.1, (gdouble) 1);
#line 75 "theme-2d-cairo.vala"
	pasang_rgb_init (&self->priv->dizzy_color, 0.2, 0.5, 0.7, (gdouble) 1);
#line 76 "theme-2d-cairo.vala"
	pasang_rgb_init (&self->priv->tv_color, 0.7, 0.5, 0.2, (gdouble) 1);
#line 77 "theme-2d-cairo.vala"
	pasang_rgb_init (&self->priv->shiny_color, 0.6, 0.4, 0.3, (gdouble) 1);
#line 78 "theme-2d-cairo.vala"
	pasang_rgb_init (&self->priv->flower_color, 0.35, 0.3, 0.2, (gdouble) 1);
#line 239 "theme-2d-cairo.vala"
	self->priv->ticket = 0;
#line 671 "theme-2d-cairo.vala"
	self->priv->flower_texture = NULL;
#line 713 "theme-2d-cairo.vala"
	self->priv->stars = NULL;
#line 713 "theme-2d-cairo.vala"
	self->priv->stars_length1 = 0;
#line 713 "theme-2d-cairo.vala"
	self->priv->stars_length2 = 0;
#line 7185 "theme-2d-cairo.c"
}

static void
pasang_theme2_dcairo_finalize (GObject * obj)
{
	PasangTheme2DCairo * self;
#line 51 "theme-2d-cairo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_THEME2_DCAIRO, PasangTheme2DCairo);
#line 55 "theme-2d-cairo.vala"
	_g_free0 (self->priv->path);
#line 63 "theme-2d-cairo.vala"
	(self->priv->forge_table_function_target_destroy_notify == NULL) ? NULL : (self->priv->forge_table_function_target_destroy_notify (self->priv->forge_table_function_target), NULL);
#line 63 "theme-2d-cairo.vala"
	self->priv->forge_table_function = NULL;
#line 63 "theme-2d-cairo.vala"
	self->priv->forge_table_function_target = NULL;
#line 63 "theme-2d-cairo.vala"
	self->priv->forge_table_function_target_destroy_notify = NULL;
#line 69 "theme-2d-cairo.vala"
	(self->priv->forge_piece_function_target_destroy_notify == NULL) ? NULL : (self->priv->forge_piece_function_target_destroy_notify (self->priv->forge_piece_function_target), NULL);
#line 69 "theme-2d-cairo.vala"
	self->priv->forge_piece_function = NULL;
#line 69 "theme-2d-cairo.vala"
	self->priv->forge_piece_function_target = NULL;
#line 69 "theme-2d-cairo.vala"
	self->priv->forge_piece_function_target_destroy_notify = NULL;
#line 671 "theme-2d-cairo.vala"
	_cairo_surface_destroy0 (self->priv->flower_texture);
#line 713 "theme-2d-cairo.vala"
	self->priv->stars = (g_free (self->priv->stars), NULL);
#line 827 "theme-2d-cairo.vala"
	self->priv->cluster_brush = (_vala_array_free (self->priv->cluster_brush, self->priv->cluster_brush_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
#line 51 "theme-2d-cairo.vala"
	G_OBJECT_CLASS (pasang_theme2_dcairo_parent_class)->finalize (obj);
#line 7220 "theme-2d-cairo.c"
}

GType
pasang_theme2_dcairo_get_type (void)
{
	static volatile gsize pasang_theme2_dcairo_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_theme2_dcairo_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangTheme2DCairoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_theme2_dcairo_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangTheme2DCairo), 0, (GInstanceInitFunc) pasang_theme2_dcairo_instance_init, NULL };
		GType pasang_theme2_dcairo_type_id;
		pasang_theme2_dcairo_type_id = g_type_register_static (PASANG_TYPE_THEME2_D, "PasangTheme2DCairo", &g_define_type_info, 0);
		PasangTheme2DCairo_private_offset = g_type_add_instance_private (pasang_theme2_dcairo_type_id, sizeof (PasangTheme2DCairoPrivate));
		g_once_init_leave (&pasang_theme2_dcairo_type_id__volatile, pasang_theme2_dcairo_type_id);
	}
	return pasang_theme2_dcairo_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

