/*
 *   mwmperc.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include "mwmparse.h"
#include "mwmparsi.h"
#include "mnpitcb.h"
#include <stddef.h>

static char szThisFile[] = "mwmperc.c";

USHORT mwmPercentMCommand( STATEINFO *psi );


USHORT mwmPercentCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmperc::mwmPercentCommand entry\n");
  /***************************************************************************/
  /* Look at this character in AT Command.                                   */
  /* Then advance index to point to next character.                          */
  /***************************************************************************/
  switch(psi->achCommandBuffer[psi->usNextATIndex++])
  {
    case 'A' :
      /***********************************************************************/
      /* This is a Percent A command.                                        */
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_PERCENT_A_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        /*********************************************************************/
        /* Get the parameter from the command string                         */
        /*********************************************************************/
        usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                            &psi->usNextATIndex);

        usParserStatus = mwmPercentACommand(psi, usParm);

      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;
    case 'C' :
      /***********************************************************************/
      /* This is a Percent C command.                                        */
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_PERCENT_C_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        /*********************************************************************/
        /* Get the parameter from the command string                         */
        /*********************************************************************/
        usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                            &psi->usNextATIndex);

        usParserStatus = mwmPercentCCommand(psi, usParm);

      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;
    case 'E' :
      /***********************************************************************/
      /* This is a Percent E command.                                        */
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_PERCENT_E_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        /*********************************************************************/
        /* Get the parameter from the command string                         */
        /*********************************************************************/
        usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                            &psi->usNextATIndex);

        usParserStatus = mwmPercentECommand(psi, usParm);

      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;
    case 'M' :
      /***********************************************************************/
      /* This is a Percent M command.                                        */
      /***********************************************************************/
      usParserStatus = mwmPercentMCommand( psi );
      break;
    case 'T' :
      if (psi->achCommandBuffer[psi->usNextATIndex] == 'T')
      {
        /*********************************************************************/
        /* This is a Percent TT command.                                     */
        /*********************************************************************/
        psi->usNextATIndex++;
        if (!(psi->usParserMode & MWM_MODE_CLASS2_FAX))
          usParserStatus = mwmPercentTTCommand( psi );
        else
          usParserStatus = MWM_ATCMD_ERROR;
      }
      else
        usParserStatus = MWM_ATCMD_ERROR;
      break;
    default:
      usParserStatus = MWM_ATCMD_ERROR;
  }


  if (usParserStatus & MWM_GET_MORE_BUFFERS)
    /*************************************************************************/
    /* Move the AT Command Index back to this command to be parsed           */
    /* on the next interrupt.                                                */
    /*************************************************************************/
    psi->usNextATIndex--;
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmperc::mwmPercentCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}



/*****************************************************************************/
USHORT mwmPercentACommand(STATEINFO *psi, USHORT usParm)
{
  USHORT usParserStatus = 0;
  REGISTERS Registers;
  ULONG  ulRC;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmperc::mwmPercentACommand entry\n");

  if (usParm<128)
  {
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x0e | psi->usParserMode);
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
    mwmParseQueryModemRegisters(&Registers);
    Registers.PercentA = usParm;
    mwmParseSetModemRegisters(&Registers);
    /*************************************************************************/
    /* Set MNPITCB.ARFC to the parameter.                                    */
    /*************************************************************************/
    ulRC = dspMemTransfer(psi->dsp.hDSP, (psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, ARFC),
                          &usParm, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                        MWM_DSP_ERROR, ulRC );
      return (USHORT)ulRC;
    }
  }
  else
    usParserStatus = MWM_ATCMD_ERROR;
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmperc::mwmPercentACommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}




USHORT mwmPercentCCommand(STATEINFO *psi, USHORT usParm)
{
  USHORT usParserStatus = 0;
  USHORT usRCLASSCAValue = 0;
  REGISTERS Registers;
  ULONG  ulRC;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmperc::mwmPercentCCommand entry\n");
  if (usParm == 0)
  {
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x23 | psi->usParserMode);
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
    usRCLASSCAValue = 0xFFAF;
  }
  else if ((usParm == 1) ||
           (usParm == 2) ||    // MTS 5099 Treat %c2 and %c3 like %c1
           (usParm == 3))
  {
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x23 | psi->usParserMode);
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 1;
    usRCLASSCAValue = 0xFFBF;
  }
  else
    usParserStatus = MWM_ATCMD_ERROR;

  if (!usParserStatus)
  {
    /*************************************************************************/
    /* Update Register                                                       */
    /*************************************************************************/
    mwmParseQueryModemRegisters(&Registers);
    Registers.PercentC = usParm;
    mwmParseSetModemRegisters(&Registers);

//  DPF("Writing 0x%x to MNPITCB.RCLASSCA (0x%04x)",usRCLASSCAValue,((psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RCLASSCA)));
    /*************************************************************************/
    /* Set MNPITCB.RCLASSCA to the parameter.                                   */
    /*************************************************************************/
    ulRC = dspMemTransfer(psi->dsp.hDSP, (psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RCLASSCA),
                          &usRCLASSCAValue, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                        MWM_DSP_ERROR, ulRC );
      return (USHORT)ulRC;
    }
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmperc::mwmPercentCCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}



USHORT mwmPercentECommand(STATEINFO *psi, USHORT usParm)
{
  USHORT usParserStatus = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmperc::mwmPercentECommand entry\n");
  if (usParm < 3)
  {
    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x29 | psi->usParserMode);
    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
  }
  else
    usParserStatus = MWM_ATCMD_ERROR;
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmperc::mwmPercentECommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}


USHORT mwmPercentMCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm;
  ULONG  ulRC = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmperc::mwmPercentMCommand entry\n");
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"WICL",strlen("WICL")))
  {
    psi->usNextATIndex += strlen("WICL");

   if (psi->achCommandBuffer[psi->usNextATIndex] == '=')
     psi->usNextATIndex++;

    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);

    if (usParm < 2)
    {
      if (psi->dsp.dspaddrIGNORES10)
      {
        ulRC = dspMemTransfer(psi->dsp.hDSP, psi->dsp.dspaddrIGNORES10,
                              &usParm, 1,
                              DSP_MEMXFER_DATA_WRITE);
        if (ulRC!=DSP_NOERROR)
        {
          mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                            MWM_DSP_ERROR, ulRC );
          return MWM_ATCMD_ERROR;
        }
      }
    }
  }
  else
    usParserStatus = MWM_ATCMD_ERROR;
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmperc::mwmPercentMCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}


USHORT mwmPercentTTCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  char   achParm[4];
  char   *pszParm;
  char   achString[AT_CMD_BUFFER_SIZE];
  USHORT usParm;
  USHORT usParmNumber = 0;
  USHORT usFCLASS;
  ULONG  ulRC;
  char   achValue[4];

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmperc::mwmPercentTTCommand entry\n");
  /***************************************************************************/
  /* If the PP results of this command will fit into the buffer.             */
  /***************************************************************************/
  if ( (psi->usNextPPIndex + PP_PERCENT_TT_CMD_SPACE) < PP_BUFFER_THRESHOLD)
  {
    /*************************************************************************/
    /* Check the next 2 characters to see if they are valid as parameters    */
    /* for the TT Command.                                                   */
    /* This command is special in that %TT without any parameters will be    */
    /* considered an error.                                                  */
    /*************************************************************************/
    strncpy(achParm,&psi->achCommandBuffer[psi->usNextATIndex],2);

    /* Get the value of the parameter */
    memset( achValue, '\0', sizeof(achValue));
    strncpy( achValue, achParm, 2 );
    sscanf( achParm, "%hx", &usParm );

    /* Determine the current FCLASS */
    ulRC = dspMemTransfer(psi->dsp.hDSP, psi->dsp.dspaddrFCLASS,
                          &usFCLASS, 1,
                          DSP_MEMXFER_DATA_READ);
    if (ulRC!=DSP_NOERROR) {
      mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                        MWM_DSP_ERROR, ulRC );
      return MWM_ATCMD_ERROR;
    } /* endif */

    /* Make sure we're in the correct FCLASS for the command */
    if (usParm >= 0x40 && usParm <= 0x4C) {
      if (usFCLASS != 1)
        return MWM_ATCMD_ERROR;
    } else {
      if (usFCLASS != 0)
        return MWM_ATCMD_ERROR;
    } /* endif */


    if (!strncmp(achParm,"00",2))
    {
      usParm = 0x00;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"01",2))
    {
      usParm = 0x01;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"02",2))
    {
      usParm = 0x02;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"03",2))
    {
      usParm = 0x03;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"04",2))
    {
      usParm = 0x04;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"05",2))
    {
      usParm = 0x05;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"06",2))
    {
      usParm = 0x06;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"07",2))
    {
      usParm = 0x07;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"08",2))
    {
      usParm = 0x08;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"09",2))
    {
      usParm = 0x09;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"0A",2))
    {
      usParm = 0x0A;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"0B",2))
    {
      /***********************************************************************/
      /* MTS 3550             Dial digit A                                   */
      /* Convert to TAIO's hex digit rather than passing parm directly.      */
      /***********************************************************************/
      usParm = 0x0C;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"0C",2))
    {
      /***********************************************************************/
      /* MTS 3550             Dial Digit B                                   */
      /* Convert to TAIO's hex digit rather than passing parm directly.      */
      /***********************************************************************/
      usParm = 0x0D;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"0D",2))
    {
      /***********************************************************************/
      /* MTS 3550             Dial Digit C                                   */
      /* Convert to TAIO's hex digit rather than passing parm directly.      */
      /***********************************************************************/
      usParm = 0x0E;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"0E",2))
    {
      /***********************************************************************/
      /* MTS 3550             Dial Digit #                                   */
      /* Convert to TAIO's hex digit rather than passing parm directly.      */
      /***********************************************************************/
      usParm = 0x0B;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"0F",2))
    {
      usParm = 0x0F;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"10",2))
    {
      usParm = 0x10;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"11",2))
    {
      usParm = 0x11;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"12",2))
    {
      usParm = 0x12;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"14",2))
    {
      usParm = 0x14;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"15",2))
    {
      usParm = 0x15;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"16",2))
    {
      usParm = 0x16;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"17",2))
    {
      usParm = 0x17;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"18",2))
    {
      usParm = 0x18;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"19",2))
    {
      usParm = 0x19;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"1A",2))
    {
      usParm = 0x1A;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"1B",2))
    {
      usParm = 0x1B;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"20",2))
    {
      usParm = 0x20;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"21",2))
    {
      usParm = 0x21;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"30",2))
    {
      usParm = 0x30;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"31",2))
    {
      usParm = 0x31;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"32",2))
    {
      usParm = 0x32;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"33",2))
    {
      usParm = 0x33;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"34",2))
    {
      usParm = 0x34;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if ( !strncmp(achParm,"40",2) ||
         !strncmp(achParm,"41",2) ||
         !strncmp(achParm,"42",2) ||
         !strncmp(achParm,"43",2) ||
         !strncmp(achParm,"44",2) ||
         !strncmp(achParm,"45",2) ||
         !strncmp(achParm,"46",2) ||
         !strncmp(achParm,"47",2) ||
         !strncmp(achParm,"48",2) ||
         !strncmp(achParm,"49",2) ||
         !strncmp(achParm,"4A",2) ||
         !strncmp(achParm,"4B",2) ||
         !strncmp(achParm,"4C",2) )
    {

      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      psi->usNextATIndex += 2;
    }
    else
    if (!strncmp(achParm,"6",1))
    {
      psi->usNextATIndex++;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2C | psi->usParserMode);
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x22;
      /*************************************************************************/
      /* Get the parameters between the comma's                                */
      /*************************************************************************/
      strcpy(achString,&psi->achCommandBuffer[psi->usNextATIndex]);
      pszParm = strtok(achString,",");
      do
      {
        psi->usNextATIndex += strlen(pszParm) + 1;

        if (strlen(pszParm))
        {
          sscanf(pszParm,"%x",(unsigned int *)&(psi->ausPPcmdBuffer[psi->usNextPPIndex++]));
        }
        /*********************************************************************/
        /* Increment to prepare for the next parameter.                      */
        /*********************************************************************/
        usParmNumber++;
      }
      while ( (pszParm = strtok(NULL,",")) && (usParmNumber < 5));

      psi->usNextATIndex--;
    }
    else
    {
      usParserStatus = MWM_ATCMD_ERROR;
    }

  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmperc::mwmPercentTTCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

