// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package accessanalyzer

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opApplyArchiveRule = "ApplyArchiveRule"

// ApplyArchiveRuleRequest generates a "aws/request.Request" representing the
// client's request for the ApplyArchiveRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ApplyArchiveRule for more information on using the ApplyArchiveRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ApplyArchiveRuleRequest method.
//    req, resp := client.ApplyArchiveRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ApplyArchiveRule
func (c *AccessAnalyzer) ApplyArchiveRuleRequest(input *ApplyArchiveRuleInput) (req *request.Request, output *ApplyArchiveRuleOutput) {
	op := &request.Operation{
		Name:       opApplyArchiveRule,
		HTTPMethod: "PUT",
		HTTPPath:   "/archive-rule",
	}

	if input == nil {
		input = &ApplyArchiveRuleInput{}
	}

	output = &ApplyArchiveRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ApplyArchiveRule API operation for Access Analyzer.
//
// Retroactively applies the archive rule to existing findings that meet the
// archive rule criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ApplyArchiveRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ApplyArchiveRule
func (c *AccessAnalyzer) ApplyArchiveRule(input *ApplyArchiveRuleInput) (*ApplyArchiveRuleOutput, error) {
	req, out := c.ApplyArchiveRuleRequest(input)
	return out, req.Send()
}

// ApplyArchiveRuleWithContext is the same as ApplyArchiveRule with the addition of
// the ability to pass a context and additional request options.
//
// See ApplyArchiveRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ApplyArchiveRuleWithContext(ctx aws.Context, input *ApplyArchiveRuleInput, opts ...request.Option) (*ApplyArchiveRuleOutput, error) {
	req, out := c.ApplyArchiveRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAnalyzer = "CreateAnalyzer"

// CreateAnalyzerRequest generates a "aws/request.Request" representing the
// client's request for the CreateAnalyzer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAnalyzer for more information on using the CreateAnalyzer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAnalyzerRequest method.
//    req, resp := client.CreateAnalyzerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateAnalyzer
func (c *AccessAnalyzer) CreateAnalyzerRequest(input *CreateAnalyzerInput) (req *request.Request, output *CreateAnalyzerOutput) {
	op := &request.Operation{
		Name:       opCreateAnalyzer,
		HTTPMethod: "PUT",
		HTTPPath:   "/analyzer",
	}

	if input == nil {
		input = &CreateAnalyzerInput{}
	}

	output = &CreateAnalyzerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAnalyzer API operation for Access Analyzer.
//
// Creates an analyzer for your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation CreateAnalyzer for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   A conflict exception error.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ServiceQuotaExceededException
//   Service quote met error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateAnalyzer
func (c *AccessAnalyzer) CreateAnalyzer(input *CreateAnalyzerInput) (*CreateAnalyzerOutput, error) {
	req, out := c.CreateAnalyzerRequest(input)
	return out, req.Send()
}

// CreateAnalyzerWithContext is the same as CreateAnalyzer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAnalyzer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) CreateAnalyzerWithContext(ctx aws.Context, input *CreateAnalyzerInput, opts ...request.Option) (*CreateAnalyzerOutput, error) {
	req, out := c.CreateAnalyzerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateArchiveRule = "CreateArchiveRule"

// CreateArchiveRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateArchiveRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateArchiveRule for more information on using the CreateArchiveRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateArchiveRuleRequest method.
//    req, resp := client.CreateArchiveRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateArchiveRule
func (c *AccessAnalyzer) CreateArchiveRuleRequest(input *CreateArchiveRuleInput) (req *request.Request, output *CreateArchiveRuleOutput) {
	op := &request.Operation{
		Name:       opCreateArchiveRule,
		HTTPMethod: "PUT",
		HTTPPath:   "/analyzer/{analyzerName}/archive-rule",
	}

	if input == nil {
		input = &CreateArchiveRuleInput{}
	}

	output = &CreateArchiveRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateArchiveRule API operation for Access Analyzer.
//
// Creates an archive rule for the specified analyzer. Archive rules automatically
// archive new findings that meet the criteria you define when you create the
// rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation CreateArchiveRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ConflictException
//   A conflict exception error.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ServiceQuotaExceededException
//   Service quote met error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateArchiveRule
func (c *AccessAnalyzer) CreateArchiveRule(input *CreateArchiveRuleInput) (*CreateArchiveRuleOutput, error) {
	req, out := c.CreateArchiveRuleRequest(input)
	return out, req.Send()
}

// CreateArchiveRuleWithContext is the same as CreateArchiveRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateArchiveRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) CreateArchiveRuleWithContext(ctx aws.Context, input *CreateArchiveRuleInput, opts ...request.Option) (*CreateArchiveRuleOutput, error) {
	req, out := c.CreateArchiveRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAnalyzer = "DeleteAnalyzer"

// DeleteAnalyzerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAnalyzer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAnalyzer for more information on using the DeleteAnalyzer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAnalyzerRequest method.
//    req, resp := client.DeleteAnalyzerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/DeleteAnalyzer
func (c *AccessAnalyzer) DeleteAnalyzerRequest(input *DeleteAnalyzerInput) (req *request.Request, output *DeleteAnalyzerOutput) {
	op := &request.Operation{
		Name:       opDeleteAnalyzer,
		HTTPMethod: "DELETE",
		HTTPPath:   "/analyzer/{analyzerName}",
	}

	if input == nil {
		input = &DeleteAnalyzerInput{}
	}

	output = &DeleteAnalyzerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAnalyzer API operation for Access Analyzer.
//
// Deletes the specified analyzer. When you delete an analyzer, Access Analyzer
// is disabled for the account in the current or specific Region. All findings
// that were generated by the analyzer are deleted. You cannot undo this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation DeleteAnalyzer for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/DeleteAnalyzer
func (c *AccessAnalyzer) DeleteAnalyzer(input *DeleteAnalyzerInput) (*DeleteAnalyzerOutput, error) {
	req, out := c.DeleteAnalyzerRequest(input)
	return out, req.Send()
}

// DeleteAnalyzerWithContext is the same as DeleteAnalyzer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAnalyzer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) DeleteAnalyzerWithContext(ctx aws.Context, input *DeleteAnalyzerInput, opts ...request.Option) (*DeleteAnalyzerOutput, error) {
	req, out := c.DeleteAnalyzerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteArchiveRule = "DeleteArchiveRule"

// DeleteArchiveRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteArchiveRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteArchiveRule for more information on using the DeleteArchiveRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteArchiveRuleRequest method.
//    req, resp := client.DeleteArchiveRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/DeleteArchiveRule
func (c *AccessAnalyzer) DeleteArchiveRuleRequest(input *DeleteArchiveRuleInput) (req *request.Request, output *DeleteArchiveRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteArchiveRule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/analyzer/{analyzerName}/archive-rule/{ruleName}",
	}

	if input == nil {
		input = &DeleteArchiveRuleInput{}
	}

	output = &DeleteArchiveRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteArchiveRule API operation for Access Analyzer.
//
// Deletes the specified archive rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation DeleteArchiveRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/DeleteArchiveRule
func (c *AccessAnalyzer) DeleteArchiveRule(input *DeleteArchiveRuleInput) (*DeleteArchiveRuleOutput, error) {
	req, out := c.DeleteArchiveRuleRequest(input)
	return out, req.Send()
}

// DeleteArchiveRuleWithContext is the same as DeleteArchiveRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteArchiveRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) DeleteArchiveRuleWithContext(ctx aws.Context, input *DeleteArchiveRuleInput, opts ...request.Option) (*DeleteArchiveRuleOutput, error) {
	req, out := c.DeleteArchiveRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnalyzedResource = "GetAnalyzedResource"

// GetAnalyzedResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetAnalyzedResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnalyzedResource for more information on using the GetAnalyzedResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAnalyzedResourceRequest method.
//    req, resp := client.GetAnalyzedResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAnalyzedResource
func (c *AccessAnalyzer) GetAnalyzedResourceRequest(input *GetAnalyzedResourceInput) (req *request.Request, output *GetAnalyzedResourceOutput) {
	op := &request.Operation{
		Name:       opGetAnalyzedResource,
		HTTPMethod: "GET",
		HTTPPath:   "/analyzed-resource",
	}

	if input == nil {
		input = &GetAnalyzedResourceInput{}
	}

	output = &GetAnalyzedResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAnalyzedResource API operation for Access Analyzer.
//
// Retrieves information about a resource that was analyzed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation GetAnalyzedResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAnalyzedResource
func (c *AccessAnalyzer) GetAnalyzedResource(input *GetAnalyzedResourceInput) (*GetAnalyzedResourceOutput, error) {
	req, out := c.GetAnalyzedResourceRequest(input)
	return out, req.Send()
}

// GetAnalyzedResourceWithContext is the same as GetAnalyzedResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnalyzedResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) GetAnalyzedResourceWithContext(ctx aws.Context, input *GetAnalyzedResourceInput, opts ...request.Option) (*GetAnalyzedResourceOutput, error) {
	req, out := c.GetAnalyzedResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAnalyzer = "GetAnalyzer"

// GetAnalyzerRequest generates a "aws/request.Request" representing the
// client's request for the GetAnalyzer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAnalyzer for more information on using the GetAnalyzer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAnalyzerRequest method.
//    req, resp := client.GetAnalyzerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAnalyzer
func (c *AccessAnalyzer) GetAnalyzerRequest(input *GetAnalyzerInput) (req *request.Request, output *GetAnalyzerOutput) {
	op := &request.Operation{
		Name:       opGetAnalyzer,
		HTTPMethod: "GET",
		HTTPPath:   "/analyzer/{analyzerName}",
	}

	if input == nil {
		input = &GetAnalyzerInput{}
	}

	output = &GetAnalyzerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAnalyzer API operation for Access Analyzer.
//
// Retrieves information about the specified analyzer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation GetAnalyzer for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAnalyzer
func (c *AccessAnalyzer) GetAnalyzer(input *GetAnalyzerInput) (*GetAnalyzerOutput, error) {
	req, out := c.GetAnalyzerRequest(input)
	return out, req.Send()
}

// GetAnalyzerWithContext is the same as GetAnalyzer with the addition of
// the ability to pass a context and additional request options.
//
// See GetAnalyzer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) GetAnalyzerWithContext(ctx aws.Context, input *GetAnalyzerInput, opts ...request.Option) (*GetAnalyzerOutput, error) {
	req, out := c.GetAnalyzerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetArchiveRule = "GetArchiveRule"

// GetArchiveRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetArchiveRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetArchiveRule for more information on using the GetArchiveRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetArchiveRuleRequest method.
//    req, resp := client.GetArchiveRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetArchiveRule
func (c *AccessAnalyzer) GetArchiveRuleRequest(input *GetArchiveRuleInput) (req *request.Request, output *GetArchiveRuleOutput) {
	op := &request.Operation{
		Name:       opGetArchiveRule,
		HTTPMethod: "GET",
		HTTPPath:   "/analyzer/{analyzerName}/archive-rule/{ruleName}",
	}

	if input == nil {
		input = &GetArchiveRuleInput{}
	}

	output = &GetArchiveRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetArchiveRule API operation for Access Analyzer.
//
// Retrieves information about an archive rule.
//
// To learn about filter keys that you can use to create an archive rule, see
// Access Analyzer filter keys (https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation GetArchiveRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetArchiveRule
func (c *AccessAnalyzer) GetArchiveRule(input *GetArchiveRuleInput) (*GetArchiveRuleOutput, error) {
	req, out := c.GetArchiveRuleRequest(input)
	return out, req.Send()
}

// GetArchiveRuleWithContext is the same as GetArchiveRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetArchiveRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) GetArchiveRuleWithContext(ctx aws.Context, input *GetArchiveRuleInput, opts ...request.Option) (*GetArchiveRuleOutput, error) {
	req, out := c.GetArchiveRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFinding = "GetFinding"

// GetFindingRequest generates a "aws/request.Request" representing the
// client's request for the GetFinding operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFinding for more information on using the GetFinding
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFindingRequest method.
//    req, resp := client.GetFindingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetFinding
func (c *AccessAnalyzer) GetFindingRequest(input *GetFindingInput) (req *request.Request, output *GetFindingOutput) {
	op := &request.Operation{
		Name:       opGetFinding,
		HTTPMethod: "GET",
		HTTPPath:   "/finding/{id}",
	}

	if input == nil {
		input = &GetFindingInput{}
	}

	output = &GetFindingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFinding API operation for Access Analyzer.
//
// Retrieves information about the specified finding.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation GetFinding for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetFinding
func (c *AccessAnalyzer) GetFinding(input *GetFindingInput) (*GetFindingOutput, error) {
	req, out := c.GetFindingRequest(input)
	return out, req.Send()
}

// GetFindingWithContext is the same as GetFinding with the addition of
// the ability to pass a context and additional request options.
//
// See GetFinding for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) GetFindingWithContext(ctx aws.Context, input *GetFindingInput, opts ...request.Option) (*GetFindingOutput, error) {
	req, out := c.GetFindingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAnalyzedResources = "ListAnalyzedResources"

// ListAnalyzedResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListAnalyzedResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnalyzedResources for more information on using the ListAnalyzedResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAnalyzedResourcesRequest method.
//    req, resp := client.ListAnalyzedResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzedResources
func (c *AccessAnalyzer) ListAnalyzedResourcesRequest(input *ListAnalyzedResourcesInput) (req *request.Request, output *ListAnalyzedResourcesOutput) {
	op := &request.Operation{
		Name:       opListAnalyzedResources,
		HTTPMethod: "POST",
		HTTPPath:   "/analyzed-resource",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnalyzedResourcesInput{}
	}

	output = &ListAnalyzedResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnalyzedResources API operation for Access Analyzer.
//
// Retrieves a list of resources of the specified type that have been analyzed
// by the specified analyzer..
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ListAnalyzedResources for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzedResources
func (c *AccessAnalyzer) ListAnalyzedResources(input *ListAnalyzedResourcesInput) (*ListAnalyzedResourcesOutput, error) {
	req, out := c.ListAnalyzedResourcesRequest(input)
	return out, req.Send()
}

// ListAnalyzedResourcesWithContext is the same as ListAnalyzedResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnalyzedResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListAnalyzedResourcesWithContext(ctx aws.Context, input *ListAnalyzedResourcesInput, opts ...request.Option) (*ListAnalyzedResourcesOutput, error) {
	req, out := c.ListAnalyzedResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnalyzedResourcesPages iterates over the pages of a ListAnalyzedResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnalyzedResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAnalyzedResources operation.
//    pageNum := 0
//    err := client.ListAnalyzedResourcesPages(params,
//        func(page *accessanalyzer.ListAnalyzedResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AccessAnalyzer) ListAnalyzedResourcesPages(input *ListAnalyzedResourcesInput, fn func(*ListAnalyzedResourcesOutput, bool) bool) error {
	return c.ListAnalyzedResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnalyzedResourcesPagesWithContext same as ListAnalyzedResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListAnalyzedResourcesPagesWithContext(ctx aws.Context, input *ListAnalyzedResourcesInput, fn func(*ListAnalyzedResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnalyzedResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnalyzedResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnalyzedResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAnalyzers = "ListAnalyzers"

// ListAnalyzersRequest generates a "aws/request.Request" representing the
// client's request for the ListAnalyzers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnalyzers for more information on using the ListAnalyzers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAnalyzersRequest method.
//    req, resp := client.ListAnalyzersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzers
func (c *AccessAnalyzer) ListAnalyzersRequest(input *ListAnalyzersInput) (req *request.Request, output *ListAnalyzersOutput) {
	op := &request.Operation{
		Name:       opListAnalyzers,
		HTTPMethod: "GET",
		HTTPPath:   "/analyzer",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnalyzersInput{}
	}

	output = &ListAnalyzersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnalyzers API operation for Access Analyzer.
//
// Retrieves a list of analyzers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ListAnalyzers for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzers
func (c *AccessAnalyzer) ListAnalyzers(input *ListAnalyzersInput) (*ListAnalyzersOutput, error) {
	req, out := c.ListAnalyzersRequest(input)
	return out, req.Send()
}

// ListAnalyzersWithContext is the same as ListAnalyzers with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnalyzers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListAnalyzersWithContext(ctx aws.Context, input *ListAnalyzersInput, opts ...request.Option) (*ListAnalyzersOutput, error) {
	req, out := c.ListAnalyzersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnalyzersPages iterates over the pages of a ListAnalyzers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnalyzers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAnalyzers operation.
//    pageNum := 0
//    err := client.ListAnalyzersPages(params,
//        func(page *accessanalyzer.ListAnalyzersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AccessAnalyzer) ListAnalyzersPages(input *ListAnalyzersInput, fn func(*ListAnalyzersOutput, bool) bool) error {
	return c.ListAnalyzersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnalyzersPagesWithContext same as ListAnalyzersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListAnalyzersPagesWithContext(ctx aws.Context, input *ListAnalyzersInput, fn func(*ListAnalyzersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnalyzersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnalyzersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnalyzersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListArchiveRules = "ListArchiveRules"

// ListArchiveRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListArchiveRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListArchiveRules for more information on using the ListArchiveRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListArchiveRulesRequest method.
//    req, resp := client.ListArchiveRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListArchiveRules
func (c *AccessAnalyzer) ListArchiveRulesRequest(input *ListArchiveRulesInput) (req *request.Request, output *ListArchiveRulesOutput) {
	op := &request.Operation{
		Name:       opListArchiveRules,
		HTTPMethod: "GET",
		HTTPPath:   "/analyzer/{analyzerName}/archive-rule",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListArchiveRulesInput{}
	}

	output = &ListArchiveRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListArchiveRules API operation for Access Analyzer.
//
// Retrieves a list of archive rules created for the specified analyzer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ListArchiveRules for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListArchiveRules
func (c *AccessAnalyzer) ListArchiveRules(input *ListArchiveRulesInput) (*ListArchiveRulesOutput, error) {
	req, out := c.ListArchiveRulesRequest(input)
	return out, req.Send()
}

// ListArchiveRulesWithContext is the same as ListArchiveRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListArchiveRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListArchiveRulesWithContext(ctx aws.Context, input *ListArchiveRulesInput, opts ...request.Option) (*ListArchiveRulesOutput, error) {
	req, out := c.ListArchiveRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListArchiveRulesPages iterates over the pages of a ListArchiveRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListArchiveRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListArchiveRules operation.
//    pageNum := 0
//    err := client.ListArchiveRulesPages(params,
//        func(page *accessanalyzer.ListArchiveRulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AccessAnalyzer) ListArchiveRulesPages(input *ListArchiveRulesInput, fn func(*ListArchiveRulesOutput, bool) bool) error {
	return c.ListArchiveRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListArchiveRulesPagesWithContext same as ListArchiveRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListArchiveRulesPagesWithContext(ctx aws.Context, input *ListArchiveRulesInput, fn func(*ListArchiveRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListArchiveRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListArchiveRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListArchiveRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFindings = "ListFindings"

// ListFindingsRequest generates a "aws/request.Request" representing the
// client's request for the ListFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFindings for more information on using the ListFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFindingsRequest method.
//    req, resp := client.ListFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListFindings
func (c *AccessAnalyzer) ListFindingsRequest(input *ListFindingsInput) (req *request.Request, output *ListFindingsOutput) {
	op := &request.Operation{
		Name:       opListFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/finding",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFindingsInput{}
	}

	output = &ListFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFindings API operation for Access Analyzer.
//
// Retrieves a list of findings generated by the specified analyzer.
//
// To learn about filter keys that you can use to create an archive rule, see
// Access Analyzer filter keys (https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ListFindings for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListFindings
func (c *AccessAnalyzer) ListFindings(input *ListFindingsInput) (*ListFindingsOutput, error) {
	req, out := c.ListFindingsRequest(input)
	return out, req.Send()
}

// ListFindingsWithContext is the same as ListFindings with the addition of
// the ability to pass a context and additional request options.
//
// See ListFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListFindingsWithContext(ctx aws.Context, input *ListFindingsInput, opts ...request.Option) (*ListFindingsOutput, error) {
	req, out := c.ListFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFindingsPages iterates over the pages of a ListFindings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFindings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFindings operation.
//    pageNum := 0
//    err := client.ListFindingsPages(params,
//        func(page *accessanalyzer.ListFindingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AccessAnalyzer) ListFindingsPages(input *ListFindingsInput, fn func(*ListFindingsOutput, bool) bool) error {
	return c.ListFindingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFindingsPagesWithContext same as ListFindingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListFindingsPagesWithContext(ctx aws.Context, input *ListFindingsInput, fn func(*ListFindingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFindingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListTagsForResource
func (c *AccessAnalyzer) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Access Analyzer.
//
// Retrieves a list of tags applied to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListTagsForResource
func (c *AccessAnalyzer) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartResourceScan = "StartResourceScan"

// StartResourceScanRequest generates a "aws/request.Request" representing the
// client's request for the StartResourceScan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartResourceScan for more information on using the StartResourceScan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartResourceScanRequest method.
//    req, resp := client.StartResourceScanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/StartResourceScan
func (c *AccessAnalyzer) StartResourceScanRequest(input *StartResourceScanInput) (req *request.Request, output *StartResourceScanOutput) {
	op := &request.Operation{
		Name:       opStartResourceScan,
		HTTPMethod: "POST",
		HTTPPath:   "/resource/scan",
	}

	if input == nil {
		input = &StartResourceScanInput{}
	}

	output = &StartResourceScanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartResourceScan API operation for Access Analyzer.
//
// Immediately starts a scan of the policies applied to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation StartResourceScan for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/StartResourceScan
func (c *AccessAnalyzer) StartResourceScan(input *StartResourceScanInput) (*StartResourceScanOutput, error) {
	req, out := c.StartResourceScanRequest(input)
	return out, req.Send()
}

// StartResourceScanWithContext is the same as StartResourceScan with the addition of
// the ability to pass a context and additional request options.
//
// See StartResourceScan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) StartResourceScanWithContext(ctx aws.Context, input *StartResourceScanInput, opts ...request.Option) (*StartResourceScanOutput, error) {
	req, out := c.StartResourceScanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/TagResource
func (c *AccessAnalyzer) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Access Analyzer.
//
// Adds a tag to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/TagResource
func (c *AccessAnalyzer) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UntagResource
func (c *AccessAnalyzer) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Access Analyzer.
//
// Removes a tag from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UntagResource
func (c *AccessAnalyzer) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateArchiveRule = "UpdateArchiveRule"

// UpdateArchiveRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateArchiveRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateArchiveRule for more information on using the UpdateArchiveRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateArchiveRuleRequest method.
//    req, resp := client.UpdateArchiveRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UpdateArchiveRule
func (c *AccessAnalyzer) UpdateArchiveRuleRequest(input *UpdateArchiveRuleInput) (req *request.Request, output *UpdateArchiveRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateArchiveRule,
		HTTPMethod: "PUT",
		HTTPPath:   "/analyzer/{analyzerName}/archive-rule/{ruleName}",
	}

	if input == nil {
		input = &UpdateArchiveRuleInput{}
	}

	output = &UpdateArchiveRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateArchiveRule API operation for Access Analyzer.
//
// Updates the criteria and values for the specified archive rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation UpdateArchiveRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UpdateArchiveRule
func (c *AccessAnalyzer) UpdateArchiveRule(input *UpdateArchiveRuleInput) (*UpdateArchiveRuleOutput, error) {
	req, out := c.UpdateArchiveRuleRequest(input)
	return out, req.Send()
}

// UpdateArchiveRuleWithContext is the same as UpdateArchiveRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateArchiveRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) UpdateArchiveRuleWithContext(ctx aws.Context, input *UpdateArchiveRuleInput, opts ...request.Option) (*UpdateArchiveRuleOutput, error) {
	req, out := c.UpdateArchiveRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFindings = "UpdateFindings"

// UpdateFindingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFindings for more information on using the UpdateFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFindingsRequest method.
//    req, resp := client.UpdateFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UpdateFindings
func (c *AccessAnalyzer) UpdateFindingsRequest(input *UpdateFindingsInput) (req *request.Request, output *UpdateFindingsOutput) {
	op := &request.Operation{
		Name:       opUpdateFindings,
		HTTPMethod: "PUT",
		HTTPPath:   "/finding",
	}

	if input == nil {
		input = &UpdateFindingsInput{}
	}

	output = &UpdateFindingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateFindings API operation for Access Analyzer.
//
// Updates the status for the specified findings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Access Analyzer's
// API operation UpdateFindings for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found.
//
//   * ValidationException
//   Validation exception error.
//
//   * InternalServerException
//   Internal server error.
//
//   * ThrottlingException
//   Throttling limit exceeded error.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UpdateFindings
func (c *AccessAnalyzer) UpdateFindings(input *UpdateFindingsInput) (*UpdateFindingsOutput, error) {
	req, out := c.UpdateFindingsRequest(input)
	return out, req.Send()
}

// UpdateFindingsWithContext is the same as UpdateFindings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AccessAnalyzer) UpdateFindingsWithContext(ctx aws.Context, input *UpdateFindingsInput, opts ...request.Option) (*UpdateFindingsOutput, error) {
	req, out := c.UpdateFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains details about the analyzed resource.
type AnalyzedResource struct {
	_ struct{} `type:"structure"`

	// The actions that an external principal is granted permission to use by the
	// policy that generated the finding.
	Actions []*string `locationName:"actions" type:"list"`

	// The time at which the resource was analyzed.
	//
	// AnalyzedAt is a required field
	AnalyzedAt *time.Time `locationName:"analyzedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The time at which the finding was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// An error message.
	Error *string `locationName:"error" type:"string"`

	// Indicates whether the policy that generated the finding grants public access
	// to the resource.
	//
	// IsPublic is a required field
	IsPublic *bool `locationName:"isPublic" type:"boolean" required:"true"`

	// The ARN of the resource that was analyzed.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The AWS account ID that owns the resource.
	//
	// ResourceOwnerAccount is a required field
	ResourceOwnerAccount *string `locationName:"resourceOwnerAccount" type:"string" required:"true"`

	// The type of the resource that was analyzed.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`

	// Indicates how the access that generated the finding is granted. This is populated
	// for Amazon S3 bucket findings.
	SharedVia []*string `locationName:"sharedVia" type:"list"`

	// The current status of the finding generated from the analyzed resource.
	Status *string `locationName:"status" type:"string" enum:"FindingStatus"`

	// The time at which the finding was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s AnalyzedResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyzedResource) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *AnalyzedResource) SetActions(v []*string) *AnalyzedResource {
	s.Actions = v
	return s
}

// SetAnalyzedAt sets the AnalyzedAt field's value.
func (s *AnalyzedResource) SetAnalyzedAt(v time.Time) *AnalyzedResource {
	s.AnalyzedAt = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AnalyzedResource) SetCreatedAt(v time.Time) *AnalyzedResource {
	s.CreatedAt = &v
	return s
}

// SetError sets the Error field's value.
func (s *AnalyzedResource) SetError(v string) *AnalyzedResource {
	s.Error = &v
	return s
}

// SetIsPublic sets the IsPublic field's value.
func (s *AnalyzedResource) SetIsPublic(v bool) *AnalyzedResource {
	s.IsPublic = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AnalyzedResource) SetResourceArn(v string) *AnalyzedResource {
	s.ResourceArn = &v
	return s
}

// SetResourceOwnerAccount sets the ResourceOwnerAccount field's value.
func (s *AnalyzedResource) SetResourceOwnerAccount(v string) *AnalyzedResource {
	s.ResourceOwnerAccount = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AnalyzedResource) SetResourceType(v string) *AnalyzedResource {
	s.ResourceType = &v
	return s
}

// SetSharedVia sets the SharedVia field's value.
func (s *AnalyzedResource) SetSharedVia(v []*string) *AnalyzedResource {
	s.SharedVia = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AnalyzedResource) SetStatus(v string) *AnalyzedResource {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AnalyzedResource) SetUpdatedAt(v time.Time) *AnalyzedResource {
	s.UpdatedAt = &v
	return s
}

// Contains the ARN of the analyzed resource.
type AnalyzedResourceSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzed resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The AWS account ID that owns the resource.
	//
	// ResourceOwnerAccount is a required field
	ResourceOwnerAccount *string `locationName:"resourceOwnerAccount" type:"string" required:"true"`

	// The type of resource that was analyzed.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation
func (s AnalyzedResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyzedResourceSummary) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AnalyzedResourceSummary) SetResourceArn(v string) *AnalyzedResourceSummary {
	s.ResourceArn = &v
	return s
}

// SetResourceOwnerAccount sets the ResourceOwnerAccount field's value.
func (s *AnalyzedResourceSummary) SetResourceOwnerAccount(v string) *AnalyzedResourceSummary {
	s.ResourceOwnerAccount = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AnalyzedResourceSummary) SetResourceType(v string) *AnalyzedResourceSummary {
	s.ResourceType = &v
	return s
}

// Contains information about the analyzer.
type AnalyzerSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// A timestamp for the time at which the analyzer was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The resource that was most recently analyzed by the analyzer.
	LastResourceAnalyzed *string `locationName:"lastResourceAnalyzed" type:"string"`

	// The time at which the most recently analyzed resource was analyzed.
	LastResourceAnalyzedAt *time.Time `locationName:"lastResourceAnalyzedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the analyzer.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of the analyzer. An Active analyzer successfully monitors supported
	// resources and generates new findings. The analyzer is Disabled when a user
	// action, such as removing trusted access for IAM Access Analyzer from AWS
	// Organizations, causes the analyzer to stop generating new findings. The status
	// is Creating when the analyzer creation is in progress and Failed when the
	// analyzer creation has failed.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AnalyzerStatus"`

	// The statusReason provides more details about the current status of the analyzer.
	// For example, if the creation for the analyzer fails, a Failed status is displayed.
	// For an analyzer with organization as the type, this failure can be due to
	// an issue with creating the service-linked roles required in the member accounts
	// of the AWS organization.
	StatusReason *StatusReason `locationName:"statusReason" type:"structure"`

	// The tags added to the analyzer.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of analyzer, which corresponds to the zone of trust chosen for the
	// analyzer.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"Type"`
}

// String returns the string representation
func (s AnalyzerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyzerSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AnalyzerSummary) SetArn(v string) *AnalyzerSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AnalyzerSummary) SetCreatedAt(v time.Time) *AnalyzerSummary {
	s.CreatedAt = &v
	return s
}

// SetLastResourceAnalyzed sets the LastResourceAnalyzed field's value.
func (s *AnalyzerSummary) SetLastResourceAnalyzed(v string) *AnalyzerSummary {
	s.LastResourceAnalyzed = &v
	return s
}

// SetLastResourceAnalyzedAt sets the LastResourceAnalyzedAt field's value.
func (s *AnalyzerSummary) SetLastResourceAnalyzedAt(v time.Time) *AnalyzerSummary {
	s.LastResourceAnalyzedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *AnalyzerSummary) SetName(v string) *AnalyzerSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AnalyzerSummary) SetStatus(v string) *AnalyzerSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *AnalyzerSummary) SetStatusReason(v *StatusReason) *AnalyzerSummary {
	s.StatusReason = v
	return s
}

// SetTags sets the Tags field's value.
func (s *AnalyzerSummary) SetTags(v map[string]*string) *AnalyzerSummary {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *AnalyzerSummary) SetType(v string) *AnalyzerSummary {
	s.Type = &v
	return s
}

// Retroactively applies an archive rule.
type ApplyArchiveRuleInput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) of the analyzer.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// A client token.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the rule to apply.
	//
	// RuleName is a required field
	RuleName *string `locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ApplyArchiveRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyArchiveRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplyArchiveRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplyArchiveRuleInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *ApplyArchiveRuleInput) SetAnalyzerArn(v string) *ApplyArchiveRuleInput {
	s.AnalyzerArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *ApplyArchiveRuleInput) SetClientToken(v string) *ApplyArchiveRuleInput {
	s.ClientToken = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *ApplyArchiveRuleInput) SetRuleName(v string) *ApplyArchiveRuleInput {
	s.RuleName = &v
	return s
}

type ApplyArchiveRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ApplyArchiveRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyArchiveRuleOutput) GoString() string {
	return s.String()
}

// Contains information about an archive rule.
type ArchiveRuleSummary struct {
	_ struct{} `type:"structure"`

	// The time at which the archive rule was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A filter used to define the archive rule.
	//
	// Filter is a required field
	Filter map[string]*Criterion `locationName:"filter" type:"map" required:"true"`

	// The name of the archive rule.
	//
	// RuleName is a required field
	RuleName *string `locationName:"ruleName" min:"1" type:"string" required:"true"`

	// The time at which the archive rule was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ArchiveRuleSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArchiveRuleSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ArchiveRuleSummary) SetCreatedAt(v time.Time) *ArchiveRuleSummary {
	s.CreatedAt = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ArchiveRuleSummary) SetFilter(v map[string]*Criterion) *ArchiveRuleSummary {
	s.Filter = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *ArchiveRuleSummary) SetRuleName(v string) *ArchiveRuleSummary {
	s.RuleName = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ArchiveRuleSummary) SetUpdatedAt(v time.Time) *ArchiveRuleSummary {
	s.UpdatedAt = &v
	return s
}

// A conflict exception error.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Creates an analyzer.
type CreateAnalyzerInput struct {
	_ struct{} `type:"structure"`

	// The name of the analyzer to create.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// Specifies the archive rules to add for the analyzer. Archive rules automatically
	// archive findings that meet the criteria you define for the rule.
	ArchiveRules []*InlineArchiveRule `locationName:"archiveRules" type:"list"`

	// A client token.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The tags to apply to the analyzer.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of analyzer to create. Only ACCOUNT analyzers are supported. You
	// can create only one analyzer per account per Region.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"Type"`
}

// String returns the string representation
func (s CreateAnalyzerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAnalyzerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAnalyzerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAnalyzerInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.ArchiveRules != nil {
		for i, v := range s.ArchiveRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ArchiveRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *CreateAnalyzerInput) SetAnalyzerName(v string) *CreateAnalyzerInput {
	s.AnalyzerName = &v
	return s
}

// SetArchiveRules sets the ArchiveRules field's value.
func (s *CreateAnalyzerInput) SetArchiveRules(v []*InlineArchiveRule) *CreateAnalyzerInput {
	s.ArchiveRules = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAnalyzerInput) SetClientToken(v string) *CreateAnalyzerInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAnalyzerInput) SetTags(v map[string]*string) *CreateAnalyzerInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateAnalyzerInput) SetType(v string) *CreateAnalyzerInput {
	s.Type = &v
	return s
}

// The response to the request to create an analyzer.
type CreateAnalyzerOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer that was created by the request.
	Arn *string `locationName:"arn" type:"string"`
}

// String returns the string representation
func (s CreateAnalyzerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAnalyzerOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateAnalyzerOutput) SetArn(v string) *CreateAnalyzerOutput {
	s.Arn = &v
	return s
}

// Creates an archive rule.
type CreateArchiveRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the created analyzer.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// A client token.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The criteria for the rule.
	//
	// Filter is a required field
	Filter map[string]*Criterion `locationName:"filter" type:"map" required:"true"`

	// The name of the rule to create.
	//
	// RuleName is a required field
	RuleName *string `locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateArchiveRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateArchiveRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateArchiveRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateArchiveRuleInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}
	if s.Filter != nil {
		for i, v := range s.Filter {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filter", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *CreateArchiveRuleInput) SetAnalyzerName(v string) *CreateArchiveRuleInput {
	s.AnalyzerName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateArchiveRuleInput) SetClientToken(v string) *CreateArchiveRuleInput {
	s.ClientToken = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *CreateArchiveRuleInput) SetFilter(v map[string]*Criterion) *CreateArchiveRuleInput {
	s.Filter = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *CreateArchiveRuleInput) SetRuleName(v string) *CreateArchiveRuleInput {
	s.RuleName = &v
	return s
}

type CreateArchiveRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateArchiveRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateArchiveRuleOutput) GoString() string {
	return s.String()
}

// The criteria to use in the filter that defines the archive rule.
type Criterion struct {
	_ struct{} `type:"structure"`

	// A "contains" operator to match for the filter used to create the rule.
	Contains []*string `locationName:"contains" min:"1" type:"list"`

	// An "equals" operator to match for the filter used to create the rule.
	Eq []*string `locationName:"eq" min:"1" type:"list"`

	// An "exists" operator to match for the filter used to create the rule.
	Exists *bool `locationName:"exists" type:"boolean"`

	// A "not equals" operator to match for the filter used to create the rule.
	Neq []*string `locationName:"neq" min:"1" type:"list"`
}

// String returns the string representation
func (s Criterion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Criterion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Criterion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Criterion"}
	if s.Contains != nil && len(s.Contains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Contains", 1))
	}
	if s.Eq != nil && len(s.Eq) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Eq", 1))
	}
	if s.Neq != nil && len(s.Neq) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Neq", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContains sets the Contains field's value.
func (s *Criterion) SetContains(v []*string) *Criterion {
	s.Contains = v
	return s
}

// SetEq sets the Eq field's value.
func (s *Criterion) SetEq(v []*string) *Criterion {
	s.Eq = v
	return s
}

// SetExists sets the Exists field's value.
func (s *Criterion) SetExists(v bool) *Criterion {
	s.Exists = &v
	return s
}

// SetNeq sets the Neq field's value.
func (s *Criterion) SetNeq(v []*string) *Criterion {
	s.Neq = v
	return s
}

// Deletes an analyzer.
type DeleteAnalyzerInput struct {
	_ struct{} `type:"structure"`

	// The name of the analyzer to delete.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// A client token.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s DeleteAnalyzerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAnalyzerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAnalyzerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAnalyzerInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *DeleteAnalyzerInput) SetAnalyzerName(v string) *DeleteAnalyzerInput {
	s.AnalyzerName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAnalyzerInput) SetClientToken(v string) *DeleteAnalyzerInput {
	s.ClientToken = &v
	return s
}

type DeleteAnalyzerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAnalyzerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAnalyzerOutput) GoString() string {
	return s.String()
}

// Deletes an archive rule.
type DeleteArchiveRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the analyzer that associated with the archive rule to delete.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// A client token.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the rule to delete.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteArchiveRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteArchiveRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteArchiveRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteArchiveRuleInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *DeleteArchiveRuleInput) SetAnalyzerName(v string) *DeleteArchiveRuleInput {
	s.AnalyzerName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteArchiveRuleInput) SetClientToken(v string) *DeleteArchiveRuleInput {
	s.ClientToken = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *DeleteArchiveRuleInput) SetRuleName(v string) *DeleteArchiveRuleInput {
	s.RuleName = &v
	return s
}

type DeleteArchiveRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteArchiveRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteArchiveRuleOutput) GoString() string {
	return s.String()
}

// Contains information about a finding.
type Finding struct {
	_ struct{} `type:"structure"`

	// The action in the analyzed policy statement that an external principal has
	// permission to use.
	Action []*string `locationName:"action" type:"list"`

	// The time at which the resource was analyzed.
	//
	// AnalyzedAt is a required field
	AnalyzedAt *time.Time `locationName:"analyzedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The condition in the analyzed policy statement that resulted in a finding.
	//
	// Condition is a required field
	Condition map[string]*string `locationName:"condition" type:"map" required:"true"`

	// The time at which the finding was generated.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// An error.
	Error *string `locationName:"error" type:"string"`

	// The ID of the finding.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Indicates whether the policy that generated the finding allows public access
	// to the resource.
	IsPublic *bool `locationName:"isPublic" type:"boolean"`

	// The external principal that access to a resource within the zone of trust.
	Principal map[string]*string `locationName:"principal" type:"map"`

	// The resource that an external principal has access to.
	Resource *string `locationName:"resource" type:"string"`

	// The AWS account ID that owns the resource.
	//
	// ResourceOwnerAccount is a required field
	ResourceOwnerAccount *string `locationName:"resourceOwnerAccount" type:"string" required:"true"`

	// The type of the resource reported in the finding.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`

	// The sources of the finding. This indicates how the access that generated
	// the finding is granted. It is populated for Amazon S3 bucket findings.
	Sources []*FindingSource `locationName:"sources" type:"list"`

	// The current status of the finding.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FindingStatus"`

	// The time at which the finding was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s Finding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Finding) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *Finding) SetAction(v []*string) *Finding {
	s.Action = v
	return s
}

// SetAnalyzedAt sets the AnalyzedAt field's value.
func (s *Finding) SetAnalyzedAt(v time.Time) *Finding {
	s.AnalyzedAt = &v
	return s
}

// SetCondition sets the Condition field's value.
func (s *Finding) SetCondition(v map[string]*string) *Finding {
	s.Condition = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Finding) SetCreatedAt(v time.Time) *Finding {
	s.CreatedAt = &v
	return s
}

// SetError sets the Error field's value.
func (s *Finding) SetError(v string) *Finding {
	s.Error = &v
	return s
}

// SetId sets the Id field's value.
func (s *Finding) SetId(v string) *Finding {
	s.Id = &v
	return s
}

// SetIsPublic sets the IsPublic field's value.
func (s *Finding) SetIsPublic(v bool) *Finding {
	s.IsPublic = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *Finding) SetPrincipal(v map[string]*string) *Finding {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *Finding) SetResource(v string) *Finding {
	s.Resource = &v
	return s
}

// SetResourceOwnerAccount sets the ResourceOwnerAccount field's value.
func (s *Finding) SetResourceOwnerAccount(v string) *Finding {
	s.ResourceOwnerAccount = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Finding) SetResourceType(v string) *Finding {
	s.ResourceType = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *Finding) SetSources(v []*FindingSource) *Finding {
	s.Sources = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Finding) SetStatus(v string) *Finding {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Finding) SetUpdatedAt(v time.Time) *Finding {
	s.UpdatedAt = &v
	return s
}

// The source of the finding. This indicates how the access that generated the
// finding is granted. It is populated for Amazon S3 bucket findings.
type FindingSource struct {
	_ struct{} `type:"structure"`

	// Includes details about how the access that generated the finding is granted.
	// This is populated for Amazon S3 bucket findings.
	Detail *FindingSourceDetail `locationName:"detail" type:"structure"`

	// Indicates the type of access that generated the finding.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FindingSourceType"`
}

// String returns the string representation
func (s FindingSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FindingSource) GoString() string {
	return s.String()
}

// SetDetail sets the Detail field's value.
func (s *FindingSource) SetDetail(v *FindingSourceDetail) *FindingSource {
	s.Detail = v
	return s
}

// SetType sets the Type field's value.
func (s *FindingSource) SetType(v string) *FindingSource {
	s.Type = &v
	return s
}

// Includes details about how the access that generated the finding is granted.
// This is populated for Amazon S3 bucket findings.
type FindingSourceDetail struct {
	_ struct{} `type:"structure"`

	// The ARN of the access point that generated the finding.
	AccessPointArn *string `locationName:"accessPointArn" type:"string"`
}

// String returns the string representation
func (s FindingSourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FindingSourceDetail) GoString() string {
	return s.String()
}

// SetAccessPointArn sets the AccessPointArn field's value.
func (s *FindingSourceDetail) SetAccessPointArn(v string) *FindingSourceDetail {
	s.AccessPointArn = &v
	return s
}

// Contains information about a finding.
type FindingSummary struct {
	_ struct{} `type:"structure"`

	// The action in the analyzed policy statement that an external principal has
	// permission to use.
	Action []*string `locationName:"action" type:"list"`

	// The time at which the resource-based policy that generated the finding was
	// analyzed.
	//
	// AnalyzedAt is a required field
	AnalyzedAt *time.Time `locationName:"analyzedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The condition in the analyzed policy statement that resulted in a finding.
	//
	// Condition is a required field
	Condition map[string]*string `locationName:"condition" type:"map" required:"true"`

	// The time at which the finding was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The error that resulted in an Error finding.
	Error *string `locationName:"error" type:"string"`

	// The ID of the finding.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Indicates whether the finding reports a resource that has a policy that allows
	// public access.
	IsPublic *bool `locationName:"isPublic" type:"boolean"`

	// The external principal that has access to a resource within the zone of trust.
	Principal map[string]*string `locationName:"principal" type:"map"`

	// The resource that the external principal has access to.
	Resource *string `locationName:"resource" type:"string"`

	// The AWS account ID that owns the resource.
	//
	// ResourceOwnerAccount is a required field
	ResourceOwnerAccount *string `locationName:"resourceOwnerAccount" type:"string" required:"true"`

	// The type of the resource that the external principal has access to.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`

	// The sources of the finding. This indicates how the access that generated
	// the finding is granted. It is populated for Amazon S3 bucket findings.
	Sources []*FindingSource `locationName:"sources" type:"list"`

	// The status of the finding.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FindingStatus"`

	// The time at which the finding was most recently updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s FindingSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FindingSummary) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *FindingSummary) SetAction(v []*string) *FindingSummary {
	s.Action = v
	return s
}

// SetAnalyzedAt sets the AnalyzedAt field's value.
func (s *FindingSummary) SetAnalyzedAt(v time.Time) *FindingSummary {
	s.AnalyzedAt = &v
	return s
}

// SetCondition sets the Condition field's value.
func (s *FindingSummary) SetCondition(v map[string]*string) *FindingSummary {
	s.Condition = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FindingSummary) SetCreatedAt(v time.Time) *FindingSummary {
	s.CreatedAt = &v
	return s
}

// SetError sets the Error field's value.
func (s *FindingSummary) SetError(v string) *FindingSummary {
	s.Error = &v
	return s
}

// SetId sets the Id field's value.
func (s *FindingSummary) SetId(v string) *FindingSummary {
	s.Id = &v
	return s
}

// SetIsPublic sets the IsPublic field's value.
func (s *FindingSummary) SetIsPublic(v bool) *FindingSummary {
	s.IsPublic = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *FindingSummary) SetPrincipal(v map[string]*string) *FindingSummary {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *FindingSummary) SetResource(v string) *FindingSummary {
	s.Resource = &v
	return s
}

// SetResourceOwnerAccount sets the ResourceOwnerAccount field's value.
func (s *FindingSummary) SetResourceOwnerAccount(v string) *FindingSummary {
	s.ResourceOwnerAccount = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *FindingSummary) SetResourceType(v string) *FindingSummary {
	s.ResourceType = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *FindingSummary) SetSources(v []*FindingSource) *FindingSummary {
	s.Sources = v
	return s
}

// SetStatus sets the Status field's value.
func (s *FindingSummary) SetStatus(v string) *FindingSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *FindingSummary) SetUpdatedAt(v time.Time) *FindingSummary {
	s.UpdatedAt = &v
	return s
}

// Retrieves an analyzed resource.
type GetAnalyzedResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer to retrieve information from.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `location:"querystring" locationName:"analyzerArn" type:"string" required:"true"`

	// The ARN of the resource to retrieve information about.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAnalyzedResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAnalyzedResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAnalyzedResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAnalyzedResourceInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *GetAnalyzedResourceInput) SetAnalyzerArn(v string) *GetAnalyzedResourceInput {
	s.AnalyzerArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetAnalyzedResourceInput) SetResourceArn(v string) *GetAnalyzedResourceInput {
	s.ResourceArn = &v
	return s
}

// The response to the request.
type GetAnalyzedResourceOutput struct {
	_ struct{} `type:"structure"`

	// An AnalyedResource object that contains information that Access Analyzer
	// found when it analyzed the resource.
	Resource *AnalyzedResource `locationName:"resource" type:"structure"`
}

// String returns the string representation
func (s GetAnalyzedResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAnalyzedResourceOutput) GoString() string {
	return s.String()
}

// SetResource sets the Resource field's value.
func (s *GetAnalyzedResourceOutput) SetResource(v *AnalyzedResource) *GetAnalyzedResourceOutput {
	s.Resource = v
	return s
}

// Retrieves an analyzer.
type GetAnalyzerInput struct {
	_ struct{} `type:"structure"`

	// The name of the analyzer retrieved.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAnalyzerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAnalyzerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAnalyzerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAnalyzerInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *GetAnalyzerInput) SetAnalyzerName(v string) *GetAnalyzerInput {
	s.AnalyzerName = &v
	return s
}

// The response to the request.
type GetAnalyzerOutput struct {
	_ struct{} `type:"structure"`

	// An AnalyzerSummary object that contains information about the analyzer.
	//
	// Analyzer is a required field
	Analyzer *AnalyzerSummary `locationName:"analyzer" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAnalyzerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAnalyzerOutput) GoString() string {
	return s.String()
}

// SetAnalyzer sets the Analyzer field's value.
func (s *GetAnalyzerOutput) SetAnalyzer(v *AnalyzerSummary) *GetAnalyzerOutput {
	s.Analyzer = v
	return s
}

// Retrieves an archive rule.
type GetArchiveRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the analyzer to retrieve rules from.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// The name of the rule to retrieve.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetArchiveRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetArchiveRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetArchiveRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetArchiveRuleInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *GetArchiveRuleInput) SetAnalyzerName(v string) *GetArchiveRuleInput {
	s.AnalyzerName = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *GetArchiveRuleInput) SetRuleName(v string) *GetArchiveRuleInput {
	s.RuleName = &v
	return s
}

// The response to the request.
type GetArchiveRuleOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an archive rule.
	//
	// ArchiveRule is a required field
	ArchiveRule *ArchiveRuleSummary `locationName:"archiveRule" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetArchiveRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetArchiveRuleOutput) GoString() string {
	return s.String()
}

// SetArchiveRule sets the ArchiveRule field's value.
func (s *GetArchiveRuleOutput) SetArchiveRule(v *ArchiveRuleSummary) *GetArchiveRuleOutput {
	s.ArchiveRule = v
	return s
}

// Retrieves a finding.
type GetFindingInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer that generated the finding.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `location:"querystring" locationName:"analyzerArn" type:"string" required:"true"`

	// The ID of the finding to retrieve.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFindingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFindingInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *GetFindingInput) SetAnalyzerArn(v string) *GetFindingInput {
	s.AnalyzerArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetFindingInput) SetId(v string) *GetFindingInput {
	s.Id = &v
	return s
}

// The response to the request.
type GetFindingOutput struct {
	_ struct{} `type:"structure"`

	// A finding object that contains finding details.
	Finding *Finding `locationName:"finding" type:"structure"`
}

// String returns the string representation
func (s GetFindingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingOutput) GoString() string {
	return s.String()
}

// SetFinding sets the Finding field's value.
func (s *GetFindingOutput) SetFinding(v *Finding) *GetFindingOutput {
	s.Finding = v
	return s
}

// An criterion statement in an archive rule. Each archive rule may have multiple
// criteria.
type InlineArchiveRule struct {
	_ struct{} `type:"structure"`

	// The condition and values for a criterion.
	//
	// Filter is a required field
	Filter map[string]*Criterion `locationName:"filter" type:"map" required:"true"`

	// The name of the rule.
	//
	// RuleName is a required field
	RuleName *string `locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InlineArchiveRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InlineArchiveRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InlineArchiveRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InlineArchiveRule"}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}
	if s.Filter != nil {
		for i, v := range s.Filter {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filter", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *InlineArchiveRule) SetFilter(v map[string]*Criterion) *InlineArchiveRule {
	s.Filter = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *InlineArchiveRule) SetRuleName(v string) *InlineArchiveRule {
	s.RuleName = &v
	return s
}

// Internal server error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The seconds to wait to retry.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Retrieves a list of resources that have been analyzed.
type ListAnalyzedResourcesInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer to retrieve a list of analyzed resources from.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The type of resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s ListAnalyzedResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAnalyzedResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnalyzedResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnalyzedResourcesInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *ListAnalyzedResourcesInput) SetAnalyzerArn(v string) *ListAnalyzedResourcesInput {
	s.AnalyzerArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnalyzedResourcesInput) SetMaxResults(v int64) *ListAnalyzedResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnalyzedResourcesInput) SetNextToken(v string) *ListAnalyzedResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListAnalyzedResourcesInput) SetResourceType(v string) *ListAnalyzedResourcesInput {
	s.ResourceType = &v
	return s
}

// The response to the request.
type ListAnalyzedResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of resources that were analyzed.
	//
	// AnalyzedResources is a required field
	AnalyzedResources []*AnalyzedResourceSummary `locationName:"analyzedResources" type:"list" required:"true"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListAnalyzedResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAnalyzedResourcesOutput) GoString() string {
	return s.String()
}

// SetAnalyzedResources sets the AnalyzedResources field's value.
func (s *ListAnalyzedResourcesOutput) SetAnalyzedResources(v []*AnalyzedResourceSummary) *ListAnalyzedResourcesOutput {
	s.AnalyzedResources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnalyzedResourcesOutput) SetNextToken(v string) *ListAnalyzedResourcesOutput {
	s.NextToken = &v
	return s
}

// Retrieves a list of analyzers.
type ListAnalyzersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token used for pagination of results returned.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The type of analyzer.
	Type *string `location:"querystring" locationName:"type" type:"string" enum:"Type"`
}

// String returns the string representation
func (s ListAnalyzersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAnalyzersInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnalyzersInput) SetMaxResults(v int64) *ListAnalyzersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnalyzersInput) SetNextToken(v string) *ListAnalyzersInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListAnalyzersInput) SetType(v string) *ListAnalyzersInput {
	s.Type = &v
	return s
}

// The response to the request.
type ListAnalyzersOutput struct {
	_ struct{} `type:"structure"`

	// The analyzers retrieved.
	//
	// Analyzers is a required field
	Analyzers []*AnalyzerSummary `locationName:"analyzers" type:"list" required:"true"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListAnalyzersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAnalyzersOutput) GoString() string {
	return s.String()
}

// SetAnalyzers sets the Analyzers field's value.
func (s *ListAnalyzersOutput) SetAnalyzers(v []*AnalyzerSummary) *ListAnalyzersOutput {
	s.Analyzers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnalyzersOutput) SetNextToken(v string) *ListAnalyzersOutput {
	s.NextToken = &v
	return s
}

// Retrieves a list of archive rules created for the specified analyzer.
type ListArchiveRulesInput struct {
	_ struct{} `type:"structure"`

	// The name of the analyzer to retrieve rules from.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in the request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token used for pagination of results returned.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListArchiveRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListArchiveRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListArchiveRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListArchiveRulesInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *ListArchiveRulesInput) SetAnalyzerName(v string) *ListArchiveRulesInput {
	s.AnalyzerName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListArchiveRulesInput) SetMaxResults(v int64) *ListArchiveRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListArchiveRulesInput) SetNextToken(v string) *ListArchiveRulesInput {
	s.NextToken = &v
	return s
}

// The response to the request.
type ListArchiveRulesOutput struct {
	_ struct{} `type:"structure"`

	// A list of archive rules created for the specified analyzer.
	//
	// ArchiveRules is a required field
	ArchiveRules []*ArchiveRuleSummary `locationName:"archiveRules" type:"list" required:"true"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListArchiveRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListArchiveRulesOutput) GoString() string {
	return s.String()
}

// SetArchiveRules sets the ArchiveRules field's value.
func (s *ListArchiveRulesOutput) SetArchiveRules(v []*ArchiveRuleSummary) *ListArchiveRulesOutput {
	s.ArchiveRules = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListArchiveRulesOutput) SetNextToken(v string) *ListArchiveRulesOutput {
	s.NextToken = &v
	return s
}

// Retrieves a list of findings generated by the specified analyzer.
type ListFindingsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer to retrieve findings from.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// A filter to match for the findings to return.
	Filter map[string]*Criterion `locationName:"filter" type:"map"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The sort order for the findings returned.
	Sort *SortCriteria `locationName:"sort" type:"structure"`
}

// String returns the string representation
func (s ListFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFindingsInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}
	if s.Filter != nil {
		for i, v := range s.Filter {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filter", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *ListFindingsInput) SetAnalyzerArn(v string) *ListFindingsInput {
	s.AnalyzerArn = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ListFindingsInput) SetFilter(v map[string]*Criterion) *ListFindingsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFindingsInput) SetMaxResults(v int64) *ListFindingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsInput) SetNextToken(v string) *ListFindingsInput {
	s.NextToken = &v
	return s
}

// SetSort sets the Sort field's value.
func (s *ListFindingsInput) SetSort(v *SortCriteria) *ListFindingsInput {
	s.Sort = v
	return s
}

// The response to the request.
type ListFindingsOutput struct {
	_ struct{} `type:"structure"`

	// A list of findings retrieved from the analyzer that match the filter criteria
	// specified, if any.
	//
	// Findings is a required field
	Findings []*FindingSummary `locationName:"findings" type:"list" required:"true"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFindingsOutput) GoString() string {
	return s.String()
}

// SetFindings sets the Findings field's value.
func (s *ListFindingsOutput) SetFindings(v []*FindingSummary) *ListFindingsOutput {
	s.Findings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsOutput) SetNextToken(v string) *ListFindingsOutput {
	s.NextToken = &v
	return s
}

// Retrieves a list of tags applied to the specified resource.
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to retrieve tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

// The response to the request.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags that are applied to the specified resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The specified resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Service quote met error.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The resource ID.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The criteria used to sort.
type SortCriteria struct {
	_ struct{} `type:"structure"`

	// The name of the attribute to sort on.
	AttributeName *string `locationName:"attributeName" type:"string"`

	// The sort order, ascending or descending.
	OrderBy *string `locationName:"orderBy" type:"string" enum:"OrderBy"`
}

// String returns the string representation
func (s SortCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SortCriteria) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *SortCriteria) SetAttributeName(v string) *SortCriteria {
	s.AttributeName = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *SortCriteria) SetOrderBy(v string) *SortCriteria {
	s.OrderBy = &v
	return s
}

// Starts a scan of the policies applied to the specified resource.
type StartResourceScanInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer to use to scan the policies applied to the specified
	// resource.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// The ARN of the resource to scan.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s StartResourceScanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartResourceScanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartResourceScanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartResourceScanInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *StartResourceScanInput) SetAnalyzerArn(v string) *StartResourceScanInput {
	s.AnalyzerArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *StartResourceScanInput) SetResourceArn(v string) *StartResourceScanInput {
	s.ResourceArn = &v
	return s
}

type StartResourceScanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartResourceScanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartResourceScanOutput) GoString() string {
	return s.String()
}

// Provides more details about the current status of the analyzer. For example,
// if the creation for the analyzer fails, a Failed status is displayed. For
// an analyzer with organization as the type, this failure can be due to an
// issue with creating the service-linked roles required in the member accounts
// of the AWS organization.
type StatusReason struct {
	_ struct{} `type:"structure"`

	// The reason code for the current status of the analyzer.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"ReasonCode"`
}

// String returns the string representation
func (s StatusReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *StatusReason) SetCode(v string) *StatusReason {
	s.Code = &v
	return s
}

// Adds a tag to the specified resource.
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to add the tag to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags to add to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

// The response to the request.
type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Throttling limit exceeded error.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The seconds to wait to retry.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Removes a tag from the specified resource.
type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to remove the tag from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The key for the tag to add.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

// The response to the request.
type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Updates the specified archive rule.
type UpdateArchiveRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the analyzer to update the archive rules for.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// A client token.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// A filter to match for the rules to update. Only rules that match the filter
	// are updated.
	//
	// Filter is a required field
	Filter map[string]*Criterion `locationName:"filter" type:"map" required:"true"`

	// The name of the rule to update.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateArchiveRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateArchiveRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateArchiveRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateArchiveRuleInput"}
	if s.AnalyzerName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalyzerName", 1))
	}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}
	if s.Filter != nil {
		for i, v := range s.Filter {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filter", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerName sets the AnalyzerName field's value.
func (s *UpdateArchiveRuleInput) SetAnalyzerName(v string) *UpdateArchiveRuleInput {
	s.AnalyzerName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateArchiveRuleInput) SetClientToken(v string) *UpdateArchiveRuleInput {
	s.ClientToken = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *UpdateArchiveRuleInput) SetFilter(v map[string]*Criterion) *UpdateArchiveRuleInput {
	s.Filter = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *UpdateArchiveRuleInput) SetRuleName(v string) *UpdateArchiveRuleInput {
	s.RuleName = &v
	return s
}

type UpdateArchiveRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateArchiveRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateArchiveRuleOutput) GoString() string {
	return s.String()
}

// Updates findings with the new values provided in the request.
type UpdateFindingsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer that generated the findings to update.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// A client token.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The IDs of the findings to update.
	Ids []*string `locationName:"ids" type:"list"`

	// The ARN of the resource identified in the finding.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// The state represents the action to take to update the finding Status. Use
	// ARCHIVE to change an Active finding to an Archived finding. Use ACTIVE to
	// change an Archived finding to an Active finding.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FindingStatusUpdate"`
}

// String returns the string representation
func (s UpdateFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFindingsInput"}
	if s.AnalyzerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyzerArn"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzerArn sets the AnalyzerArn field's value.
func (s *UpdateFindingsInput) SetAnalyzerArn(v string) *UpdateFindingsInput {
	s.AnalyzerArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateFindingsInput) SetClientToken(v string) *UpdateFindingsInput {
	s.ClientToken = &v
	return s
}

// SetIds sets the Ids field's value.
func (s *UpdateFindingsInput) SetIds(v []*string) *UpdateFindingsInput {
	s.Ids = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UpdateFindingsInput) SetResourceArn(v string) *UpdateFindingsInput {
	s.ResourceArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateFindingsInput) SetStatus(v string) *UpdateFindingsInput {
	s.Status = &v
	return s
}

type UpdateFindingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFindingsOutput) GoString() string {
	return s.String()
}

// Validation exception error.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A list of fields that didn't validate.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason for the exception.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about a validation exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// A message about the validation exception.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the validation exception.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AnalyzerStatusActive is a AnalyzerStatus enum value
	AnalyzerStatusActive = "ACTIVE"

	// AnalyzerStatusCreating is a AnalyzerStatus enum value
	AnalyzerStatusCreating = "CREATING"

	// AnalyzerStatusDisabled is a AnalyzerStatus enum value
	AnalyzerStatusDisabled = "DISABLED"

	// AnalyzerStatusFailed is a AnalyzerStatus enum value
	AnalyzerStatusFailed = "FAILED"
)

// AnalyzerStatus_Values returns all elements of the AnalyzerStatus enum
func AnalyzerStatus_Values() []string {
	return []string{
		AnalyzerStatusActive,
		AnalyzerStatusCreating,
		AnalyzerStatusDisabled,
		AnalyzerStatusFailed,
	}
}

const (
	// FindingSourceTypePolicy is a FindingSourceType enum value
	FindingSourceTypePolicy = "POLICY"

	// FindingSourceTypeBucketAcl is a FindingSourceType enum value
	FindingSourceTypeBucketAcl = "BUCKET_ACL"

	// FindingSourceTypeS3AccessPoint is a FindingSourceType enum value
	FindingSourceTypeS3AccessPoint = "S3_ACCESS_POINT"
)

// FindingSourceType_Values returns all elements of the FindingSourceType enum
func FindingSourceType_Values() []string {
	return []string{
		FindingSourceTypePolicy,
		FindingSourceTypeBucketAcl,
		FindingSourceTypeS3AccessPoint,
	}
}

const (
	// FindingStatusActive is a FindingStatus enum value
	FindingStatusActive = "ACTIVE"

	// FindingStatusArchived is a FindingStatus enum value
	FindingStatusArchived = "ARCHIVED"

	// FindingStatusResolved is a FindingStatus enum value
	FindingStatusResolved = "RESOLVED"
)

// FindingStatus_Values returns all elements of the FindingStatus enum
func FindingStatus_Values() []string {
	return []string{
		FindingStatusActive,
		FindingStatusArchived,
		FindingStatusResolved,
	}
}

const (
	// FindingStatusUpdateActive is a FindingStatusUpdate enum value
	FindingStatusUpdateActive = "ACTIVE"

	// FindingStatusUpdateArchived is a FindingStatusUpdate enum value
	FindingStatusUpdateArchived = "ARCHIVED"
)

// FindingStatusUpdate_Values returns all elements of the FindingStatusUpdate enum
func FindingStatusUpdate_Values() []string {
	return []string{
		FindingStatusUpdateActive,
		FindingStatusUpdateArchived,
	}
}

const (
	// OrderByAsc is a OrderBy enum value
	OrderByAsc = "ASC"

	// OrderByDesc is a OrderBy enum value
	OrderByDesc = "DESC"
)

// OrderBy_Values returns all elements of the OrderBy enum
func OrderBy_Values() []string {
	return []string{
		OrderByAsc,
		OrderByDesc,
	}
}

const (
	// ReasonCodeAwsServiceAccessDisabled is a ReasonCode enum value
	ReasonCodeAwsServiceAccessDisabled = "AWS_SERVICE_ACCESS_DISABLED"

	// ReasonCodeDelegatedAdministratorDeregistered is a ReasonCode enum value
	ReasonCodeDelegatedAdministratorDeregistered = "DELEGATED_ADMINISTRATOR_DEREGISTERED"

	// ReasonCodeOrganizationDeleted is a ReasonCode enum value
	ReasonCodeOrganizationDeleted = "ORGANIZATION_DELETED"

	// ReasonCodeServiceLinkedRoleCreationFailed is a ReasonCode enum value
	ReasonCodeServiceLinkedRoleCreationFailed = "SERVICE_LINKED_ROLE_CREATION_FAILED"
)

// ReasonCode_Values returns all elements of the ReasonCode enum
func ReasonCode_Values() []string {
	return []string{
		ReasonCodeAwsServiceAccessDisabled,
		ReasonCodeDelegatedAdministratorDeregistered,
		ReasonCodeOrganizationDeleted,
		ReasonCodeServiceLinkedRoleCreationFailed,
	}
}

const (
	// ResourceTypeAwsS3Bucket is a ResourceType enum value
	ResourceTypeAwsS3Bucket = "AWS::S3::Bucket"

	// ResourceTypeAwsIamRole is a ResourceType enum value
	ResourceTypeAwsIamRole = "AWS::IAM::Role"

	// ResourceTypeAwsSqsQueue is a ResourceType enum value
	ResourceTypeAwsSqsQueue = "AWS::SQS::Queue"

	// ResourceTypeAwsLambdaFunction is a ResourceType enum value
	ResourceTypeAwsLambdaFunction = "AWS::Lambda::Function"

	// ResourceTypeAwsLambdaLayerVersion is a ResourceType enum value
	ResourceTypeAwsLambdaLayerVersion = "AWS::Lambda::LayerVersion"

	// ResourceTypeAwsKmsKey is a ResourceType enum value
	ResourceTypeAwsKmsKey = "AWS::KMS::Key"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeAwsS3Bucket,
		ResourceTypeAwsIamRole,
		ResourceTypeAwsSqsQueue,
		ResourceTypeAwsLambdaFunction,
		ResourceTypeAwsLambdaLayerVersion,
		ResourceTypeAwsKmsKey,
	}
}

const (
	// TypeAccount is a Type enum value
	TypeAccount = "ACCOUNT"

	// TypeOrganization is a Type enum value
	TypeOrganization = "ORGANIZATION"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeAccount,
		TypeOrganization,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
