// Copyright 2023-2024 Gentoo Authors
// Distributed under the terms of the GNU General Public License v2

open System.Threading.Tasks

open System.CommandLine
open System.CommandLine.Invocation

open Gdmt.Shared.Ebuild

let CommandName = "gdmt-pn"
let CommandDescription = "show package name of current directory"

let CommandHandler (_context: InvocationContext) : Task =
    task {
        printfn "%s" (GetFullPackageName ".")

        ()
    }

[<EntryPoint>]
let main argv =
    let rootCommand = RootCommand(CommandName)

    rootCommand.Name <- CommandName
    rootCommand.Description <- CommandDescription

    rootCommand.SetHandler CommandHandler

    rootCommand.Invoke(argv)
