/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Type;
import java.net.URI;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.SparkOrcNewRecordReader;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.orc.OrcConf;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.SchemaMergeUtils$;
import org.apache.spark.sql.execution.datasources.orc.OrcFilters$;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.hive.HiveInspectors;
import org.apache.spark.sql.hive.orc.OrcFileFormat$;
import org.apache.spark.sql.hive.orc.OrcFileOperator$;
import org.apache.spark.sql.hive.orc.OrcOutputWriter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001B\u000b\u0017\u0001\rBQa\u000f\u0001\u0005\u0002qBQa\u0010\u0001\u0005B\u0001CQ\u0001\u0014\u0001\u0005B\u0001CQ!\u0014\u0001\u0005B9CQA\u001e\u0001\u0005B]Dq!a\u0004\u0001\t\u0003\n\t\u0002C\u0004\u0002(\u0001!\t%!\u000b\t\u000f\u0005M\u0004\u0001\"\u0011\u0002v!9\u0011\u0011\u0011\u0001\u0005\n\u0005\ru\u0001CAO-!\u0005a#a(\u0007\u000fU1\u0002\u0012\u0001\f\u0002\"\"11h\u0003C\u0001\u0003oC!\"!/\f\u0005\u0004%\tAFA^\u0011!\tYm\u0003Q\u0001\n\u0005u\u0006\"CAg\u0017\t\u0007I\u0011AAh\u0011!\tyn\u0003Q\u0001\n\u0005E\u0007bBAq\u0017\u0011\u0005\u00111\u001d\u0005\b\u0005#YA\u0011\u0001B\n\u0011\u001d\u0011\u0019c\u0003C\u0001\u0005KA\u0011B!\u0010\f\u0003\u0003%IAa\u0010\u0003\u001b=\u00138MR5mK\u001a{'/\\1u\u0015\t9\u0002$A\u0002pe\u000eT!!\u0007\u000e\u0002\t!Lg/\u001a\u0006\u00037q\t1a]9m\u0015\tib$A\u0003ta\u0006\u00148N\u0003\u0002 A\u00051\u0011\r]1dQ\u0016T\u0011!I\u0001\u0004_J<7\u0001A\n\u0006\u0001\u0011R#\u0007\u000f\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013a\u00033bi\u0006\u001cx.\u001e:dKNT!a\f\u000e\u0002\u0013\u0015DXmY;uS>t\u0017BA\u0019-\u0005)1\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003gYj\u0011\u0001\u000e\u0006\u0003ki\tqa]8ve\u000e,7/\u0003\u00028i\t\u0011B)\u0019;b'>,(oY3SK\u001eL7\u000f^3s!\t)\u0013(\u0003\u0002;M\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012!\u0010\t\u0003}\u0001i\u0011AF\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012!\u0011\t\u0003\u0005&s!aQ$\u0011\u0005\u00113S\"A#\u000b\u0005\u0019\u0013\u0013A\u0002\u001fs_>$h(\u0003\u0002IM\u00051\u0001K]3eK\u001aL!AS&\u0003\rM#(/\u001b8h\u0015\tAe%\u0001\u0005u_N#(/\u001b8h\u0003-IgNZ3s'\u000eDW-\\1\u0015\t=Cfl\u0019\t\u0004KA\u0013\u0016BA)'\u0005\u0019y\u0005\u000f^5p]B\u00111KV\u0007\u0002)*\u0011QKG\u0001\u0006if\u0004Xm]\u0005\u0003/R\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015IF\u00011\u0001[\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tYF,D\u0001\u001b\u0013\ti&D\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003`\t\u0001\u0007\u0001-A\u0004paRLwN\\:\u0011\t\t\u000b\u0017)Q\u0005\u0003E.\u00131!T1q\u0011\u0015!G\u00011\u0001f\u0003\u00151\u0017\u000e\\3t!\r17N\u001c\b\u0003O&t!\u0001\u00125\n\u0003\u001dJ!A\u001b\u0014\u0002\u000fA\f7m[1hK&\u0011A.\u001c\u0002\u0004'\u0016\f(B\u00016'!\tyG/D\u0001q\u0015\t\t(/\u0001\u0002gg*\u00111OH\u0001\u0007Q\u0006$wn\u001c9\n\u0005U\u0004(A\u0003$jY\u0016\u001cF/\u0019;vg\u0006a\u0001O]3qCJ,wK]5uKR9\u0001p\u001f?\u0002\n\u0005-\u0001CA\u0016z\u0013\tQHFA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010C\u0003Z\u000b\u0001\u0007!\fC\u0003~\u000b\u0001\u0007a0A\u0002k_\n\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004I\f\u0011\"\\1qe\u0016$WoY3\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u0004\u0015>\u0014\u0007\"B0\u0006\u0001\u0004\u0001\u0007BBA\u0007\u000b\u0001\u0007!+\u0001\u0006eCR\f7k\u00195f[\u0006\f1\"[:Ta2LG/\u00192mKRA\u00111CA\r\u00037\ti\u0002E\u0002&\u0003+I1!a\u0006'\u0005\u001d\u0011un\u001c7fC:DQ!\u0017\u0004A\u0002iCQa\u0018\u0004A\u0002\u0001Dq!a\b\u0007\u0001\u0004\t\t#\u0001\u0003qCRD\u0007cA8\u0002$%\u0019\u0011Q\u00059\u0003\tA\u000bG\u000f[\u0001\fEVLG\u000e\u001a*fC\u0012,'\u000f\u0006\t\u0002,\u0005%\u00131JA'\u0003#\n)&!\u0019\u0002dA9Q%!\f\u00022\u0005]\u0012bAA\u0018M\tIa)\u001e8di&|g.\r\t\u0004W\u0005M\u0012bAA\u001bY\ty\u0001+\u0019:uSRLwN\\3e\r&dW\rE\u0003g\u0003s\ti$C\u0002\u0002<5\u0014\u0001\"\u0013;fe\u0006$xN\u001d\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)\u0019\u00111\t\u000e\u0002\u0011\r\fG/\u00197zgRLA!a\u0012\u0002B\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0015Iv\u00011\u0001[\u0011\u0019\tia\u0002a\u0001%\"1\u0011qJ\u0004A\u0002I\u000bq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\u0007\u0003':\u0001\u0019\u0001*\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\"9\u0011qK\u0004A\u0002\u0005e\u0013a\u00024jYR,'o\u001d\t\u0005M.\fY\u0006E\u00024\u0003;J1!a\u00185\u0005\u00191\u0015\u000e\u001c;fe\")ql\u0002a\u0001A\"9\u0011QM\u0004A\u0002\u0005\u001d\u0014A\u00035bI>|\u0007oQ8oMB!\u0011\u0011NA8\u001b\t\tYGC\u0002\u0002nI\fAaY8oM&!\u0011\u0011OA6\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006y1/\u001e9q_J$H)\u0019;b)f\u0004X\r\u0006\u0003\u0002\u0014\u0005]\u0004bBA=\u0011\u0001\u0007\u00111P\u0001\tI\u0006$\u0018\rV=qKB\u00191+! \n\u0007\u0005}DK\u0001\u0005ECR\fG+\u001f9f\u0003\u0019!xn\u0013:z_R\u0019\u0011)!\"\t\u000f\u0005\u001d\u0015\u00021\u0001\u0002\n\u0006!1/\u0019:h!\u0011\tY)!'\u000e\u0005\u00055%\u0002BAD\u0003\u001fSA!!%\u0002\u0014\u0006\u0011\u0011n\u001c\u0006\u0005\u0003+\u000b9*\u0001\u0002rY*\u0011\u0011D]\u0005\u0005\u00037\u000biI\u0001\bTK\u0006\u00148\r[!sOVlWM\u001c;\u0002\u001b=\u00138MR5mK\u001a{'/\\1u!\tq4bE\u0004\fI\u0005\r\u00161\u0016\u001d\u0011\t\u0005\u0015\u0016qU\u0007\u00021%\u0019\u0011\u0011\u0016\r\u0003\u001d!Kg/Z%ogB,7\r^8sgB!\u0011QVAZ\u001b\t\tyKC\u0002\u00022r\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0003k\u000byKA\u0004M_\u001e<\u0017N\\4\u0015\u0005\u0005}\u0015!D*B%\u001e{\u0006+V*I\t>;f*\u0006\u0002\u0002>B!\u0011qXAe\u001b\t\t\tM\u0003\u0003\u0002D\u0006\u0015\u0017\u0001\u00027b]\u001eT!!a2\u0002\t)\fg/Y\u0005\u0004\u0015\u0006\u0005\u0017AD*B%\u001e{\u0006+V*I\t>;f\nI\u0001#Kb$XM\\:j_:\u001chi\u001c:D_6\u0004(/Z:tS>t7i\u001c3fG:\u000bW.Z:\u0016\u0005\u0005E\u0007\u0003CAj\u0003;\fi,!0\u000e\u0005\u0005U'\u0002BAl\u00033\f\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005mg%\u0001\u0006d_2dWm\u0019;j_:L1AYAk\u0003\r*\u0007\u0010^3og&|gn\u001d$pe\u000e{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cg*Y7fg\u0002\n\u0001#\u001e8xe\u0006\u0004xJ]2TiJ,8\r^:\u0015\u0019\u0005]\u0012Q]At\u0003S\fYO!\u0001\t\u000f\u00055\u0014\u00031\u0001\u0002h!1\u0011QB\tA\u0002ICa!a\u0015\u0012\u0001\u0004\u0011\u0006bBAw#\u0001\u0007\u0011q^\u0001\u000e[\u0006L(-Z*ueV\u001cGoT%\u0011\t\u0015\u0002\u0016\u0011\u001f\t\u0005\u0003g\fi0\u0004\u0002\u0002v*!\u0011q_A}\u0003=y'M[3di&t7\u000f]3di>\u0014(\u0002BA~\u0003/\u000baa]3sI\u0016\u0014\u0014\u0002BA\u0000\u0003k\u0014Qc\u0015;sk\u000e$xJ\u00196fGRLen\u001d9fGR|'\u000fC\u0004\u0003\u0004E\u0001\rA!\u0002\u0002\u0011%$XM]1u_J\u0004RAZA\u001d\u0005\u000f\u0001BA!\u0003\u0003\u000e5\u0011!1\u0002\u0006\u0004\u0003#\u0013\u0018\u0002\u0002B\b\u0005\u0017\u0011\u0001b\u0016:ji\u0006\u0014G.Z\u0001\u0013g\u0016$(+Z9vSJ,GmQ8mk6t7\u000f\u0006\u0005\u0003\u0016\tm!Q\u0004B\u0010!\r)#qC\u0005\u0004\u000531#\u0001B+oSRDq!!\u001c\u0013\u0001\u0004\t9\u0007\u0003\u0004\u0002\u000eI\u0001\rA\u0015\u0005\u0007\u0005C\u0011\u0002\u0019\u0001*\u0002\u001fI,\u0017/^3ti\u0016$7k\u00195f[\u0006\fq#\u00193e'B\f'o\u001b,feNLwN\\'fi\u0006$\u0017\r^1\u0015\t\tU!q\u0005\u0005\b\u0005S\u0019\u0002\u0019\u0001B\u0016\u00031\u0011XmY8sI^\u0013\u0018\u000e^3s!!\u0011iCa\r\u00038\t\u001dQB\u0001B\u0018\u0015\r\u0011\tD]\u0001\u0007[\u0006\u0004(/\u001a3\n\t\tU\"q\u0006\u0002\r%\u0016\u001cwN\u001d3Xe&$XM\u001d\t\u0005\u0005\u0013\u0011I$\u0003\u0003\u0003<\t-!\u0001\u0004(vY2<&/\u001b;bE2,\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0011\u0011\t\u0005}&1I\u0005\u0005\u0005\u000b\n\tM\u0001\u0004PE*,7\r\u001e")
public class OrcFileFormat
implements FileFormat,
DataSourceRegister,
scala.Serializable {
    public static void addSparkVersionMetadata(RecordWriter<NullWritable, Writable> recordWriter) {
        OrcFileFormat$.MODULE$.addSparkVersionMetadata(recordWriter);
    }

    public static void setRequiredColumns(Configuration configuration, StructType structType, StructType structType2) {
        OrcFileFormat$.MODULE$.setRequiredColumns(configuration, structType, structType2);
    }

    public static Iterator<InternalRow> unwrapOrcStructs(Configuration configuration, StructType structType, StructType structType2, Option<StructObjectInspector> option, Iterator<Writable> iterator) {
        return OrcFileFormat$.MODULE$.unwrapOrcStructs(configuration, structType, structType2, option, iterator);
    }

    public static Map<String, String> extensionsForCompressionCodecNames() {
        return OrcFileFormat$.MODULE$.extensionsForCompressionCodecNames();
    }

    public static HiveInspectors.typeInfoConversions typeInfoConversions(DataType dataType) {
        return OrcFileFormat$.MODULE$.typeInfoConversions(dataType);
    }

    public static DataType inspectorToDataType(ObjectInspector objectInspector) {
        return OrcFileFormat$.MODULE$.inspectorToDataType(objectInspector);
    }

    public static ObjectInspector toInspector(Expression expression) {
        return OrcFileFormat$.MODULE$.toInspector(expression);
    }

    public static ObjectInspector toInspector(DataType dataType) {
        return OrcFileFormat$.MODULE$.toInspector(dataType);
    }

    public static Object[] wrap(Seq<Object> seq, Function1<Object, Object>[] function1Array, Object[] objectArray, DataType[] dataTypeArray) {
        return OrcFileFormat$.MODULE$.wrap(seq, function1Array, objectArray, dataTypeArray);
    }

    public static Object[] wrap(InternalRow internalRow, Function1<Object, Object>[] function1Array, Object[] objectArray, DataType[] dataTypeArray) {
        return OrcFileFormat$.MODULE$.wrap(internalRow, function1Array, objectArray, dataTypeArray);
    }

    public static Object wrap(Object object, ObjectInspector objectInspector, DataType dataType) {
        return OrcFileFormat$.MODULE$.wrap(object, objectInspector, dataType);
    }

    public static Function3<Object, InternalRow, Object, BoxedUnit> unwrapperFor(StructField structField) {
        return OrcFileFormat$.MODULE$.unwrapperFor(structField);
    }

    public static Function1<Object, Object> unwrapperFor(ObjectInspector objectInspector) {
        return OrcFileFormat$.MODULE$.unwrapperFor(objectInspector);
    }

    public static DataType javaTypeToDataType(Type type) {
        return OrcFileFormat$.MODULE$.javaTypeToDataType(type);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.supportBatch$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReaderWithPartitionValues$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public String shortName() {
        return "orc";
    }

    public String toString() {
        return "ORC";
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        Option<StructType> option;
        OrcOptions orcOptions = new OrcOptions(options, sparkSession.sessionState().conf());
        if (orcOptions.mergeSchema()) {
            option = SchemaMergeUtils$.MODULE$.mergeSchemasInParallel(sparkSession, options, files, (Function3 & Serializable & scala.Serializable)(partFiles, conf, ignoreCorruptFiles) -> OrcFileOperator$.MODULE$.readOrcSchemasInParallel((Seq<FileStatus>)partFiles, conf, BoxesRunTime.unboxToBoolean((Object)ignoreCorruptFiles)));
        } else {
            boolean ignoreCorruptFiles2 = sparkSession.sessionState().conf().ignoreCorruptFiles();
            option = OrcFileOperator$.MODULE$.readSchema((Seq<String>)((Seq)files.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().toString(), Seq$.MODULE$.canBuildFrom())), (Option<Configuration>)new Some((Object)sparkSession.sessionState().newHadoopConfWithOptions(options)), ignoreCorruptFiles2);
        }
        return option;
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        OrcOptions orcOptions = new OrcOptions(options, sparkSession.sessionState().conf());
        Configuration configuration = job.getConfiguration();
        configuration.set(OrcConf.COMPRESS.getAttribute(), orcOptions.compressionCodec());
        Configuration configuration2 = configuration;
        if (configuration2 instanceof JobConf) {
            JobConf jobConf = (JobConf)configuration2;
            jobConf.setOutputFormat(OrcOutputFormat.class);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            configuration2.setClass("mapred.output.format.class", OrcOutputFormat.class, OutputFormat.class);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new OrcOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                String name = context.getConfiguration().get(OrcConf.COMPRESS.getAttribute());
                String compressionExtension = (String)OrcFileFormat$.MODULE$.extensionsForCompressionCodecNames().getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> "");
                return new StringBuilder(4).append(compressionExtension).append(".orc").toString();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getFileExtension$1()}, serializedLambda);
            }
        };
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        if (sparkSession.sessionState().conf().orcFilterPushDown()) {
            OrcFilters$.MODULE$.createFilter(requiredSchema, filters).foreach((Function1 & Serializable & scala.Serializable)f -> {
                OrcFileFormat.$anonfun$buildReader$1(this, hadoopConf, f);
                return BoxedUnit.UNIT;
            });
        }
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        boolean ignoreCorruptFiles = sparkSession.sessionState().conf().ignoreCorruptFiles();
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator<InternalRow> iterator;
            Configuration conf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            Path filePath = new Path(new URI(file.filePath()));
            boolean isEmptyFile = OrcFileOperator$.MODULE$.readSchema((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{filePath.toString()}))), (Option<Configuration>)new Some((Object)conf), ignoreCorruptFiles).isEmpty();
            if (isEmptyFile) {
                iterator = package$.MODULE$.Iterator().empty();
            } else {
                OrcFileFormat$.MODULE$.setRequiredColumns(conf, dataSchema, requiredSchema);
                Job job = Job.getInstance((Configuration)conf);
                FileInputFormat.setInputPaths((Job)job, (String)file.filePath());
                Reader orcReader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
                SparkOrcNewRecordReader orcRecordReader = new SparkOrcNewRecordReader(orcReader, conf, file.start(), file.length());
                RecordReaderIterator recordsIterator = new RecordReaderIterator((RecordReader)orcRecordReader);
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$3 -> {
                    recordsIterator.close();
                    return BoxedUnit.UNIT;
                }));
                iterator = OrcFileFormat$.MODULE$.unwrapOrcStructs(conf, dataSchema, requiredSchema, (Option<StructObjectInspector>)new Some((Object)((StructObjectInspector)orcRecordReader.getObjectInspector())), (Iterator<Writable>)recordsIterator);
            }
            return iterator;
        };
    }

    public boolean supportDataType(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType) && this.supportDataType(valueType);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType());
        } else {
            bl = false;
        }
        return bl;
    }

    private String toKryo(SearchArgument sarg) {
        Kryo kryo = new Kryo();
        Output out = new Output(4096, 0xA00000);
        kryo.writeObject(out, (Object)sarg);
        out.close();
        return Base64.encodeBase64String((byte[])out.toBytes());
    }

    public static final /* synthetic */ void $anonfun$buildReader$1(OrcFileFormat $this, Configuration hadoopConf$1, SearchArgument f) {
        hadoopConf$1.set(OrcFileFormat$.MODULE$.SARG_PUSHDOWN(), $this.toKryo(f));
        hadoopConf$1.setBoolean(HiveConf.ConfVars.HIVEOPTINDEXFILTER.varname, true);
    }

    public OrcFileFormat() {
        FileFormat.$init$((FileFormat)this);
    }
}

