/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RLike$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="str _FUNC_ regexp - Returns true if `str` matches `regexp`, or false otherwise.", arguments="\n    Arguments:\n      * str - a string expression\n      * regexp - a string expression. The regex string should be a Java regular expression.\n\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".\n\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n  ", examples="\n    Examples:\n      > SET spark.sql.parser.escapedStringLiterals=true;\n      spark.sql.parser.escapedStringLiterals\ttrue\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '%SystemDrive%\\\\Users.*';\n      true\n      > SET spark.sql.parser.escapedStringLiterals=false;\n      spark.sql.parser.escapedStringLiterals\tfalse\n      > SELECT '%SystemDrive%\\\\Users\\\\John' _FUNC_ '%SystemDrive%\\\\\\\\Users.*';\n      true\n  ", note="\n    Use LIKE to match with simple string pattern.\n  ", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001\u0002\u000e\u001c\u0001\"B\u0001B\u000e\u0001\u0003\u0016\u0004%\ta\u000e\u0005\tw\u0001\u0011\t\u0012)A\u0005q!AA\b\u0001BK\u0002\u0013\u0005q\u0007\u0003\u0005>\u0001\tE\t\u0015!\u00039\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u00151\u0007\u0001\"\u0015h\u0011\u001d)\b!!A\u0005\u0002YDq!\u001f\u0001\u0012\u0002\u0013\u0005!\u0010\u0003\u0005\u0002\f\u0001\t\n\u0011\"\u0001{\u0011%\ti\u0001AA\u0001\n\u0003\ny\u0001C\u0005\u0002\u001c\u0001\t\t\u0011\"\u0001\u0002\u001e!I\u0011Q\u0005\u0001\u0002\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003g\u0001\u0011\u0011!C!\u0003kA\u0011\"a\u0011\u0001\u0003\u0003%\t!!\u0012\t\u0013\u0005%\u0003!!A\u0005B\u0005-s!CA;7\u0005\u0005\t\u0012AA<\r!Q2$!A\t\u0002\u0005e\u0004B\u0002 \u0015\t\u0003\t9\t\u0003\u0005e)\u0005\u0005IQIAE\u0011%\tY\tFA\u0001\n\u0003\u000bi\tC\u0005\u0002\u0014R\t\t\u0011\"!\u0002\u0016\"I\u0011q\u0015\u000b\u0002\u0002\u0013%\u0011\u0011\u0016\u0002\u0006%2K7.\u001a\u0006\u00039u\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011adH\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001%I\u0001\u0004gFd'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001M!\u0001!K\u00174!\tQ3&D\u0001\u001c\u0013\ta3DA\u000bTiJLgn\u001a*fO\u0016DX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\u000fA\u0013x\u000eZ;diB\u0011a\u0006N\u0005\u0003k=\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001\\3giV\t\u0001\b\u0005\u0002+s%\u0011!h\u0007\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u0001\u0006\u0013\u0005C\u0001\u0016\u0001\u0011\u00151T\u00011\u00019\u0011\u0015aT\u00011\u00019\u0003\u0019)7oY1qKR\u0011Q\t\u0015\t\u0003\r6s!aR&\u0011\u0005!{S\"A%\u000b\u0005);\u0013A\u0002\u001fs_>$h(\u0003\u0002M_\u00051\u0001K]3eK\u001aL!AT(\u0003\rM#(/\u001b8h\u0015\tau\u0006C\u0003R\r\u0001\u0007Q)A\u0001w\u0003\u001di\u0017\r^2iKN$2\u0001V,c!\tqS+\u0003\u0002W_\t9!i\\8mK\u0006t\u0007\"\u0002-\b\u0001\u0004I\u0016!\u0002:fO\u0016D\bC\u0001.a\u001b\u0005Y&B\u0001-]\u0015\tif,\u0001\u0003vi&d'\"A0\u0002\t)\fg/Y\u0005\u0003Cn\u0013q\u0001U1ui\u0016\u0014h\u000eC\u0003d\u000f\u0001\u0007Q)A\u0002tiJ\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002\u000b\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0004Q:\u001c\bCA5m\u001b\u0005Q'BA6\u001c\u0003\u001d\u0019w\u000eZ3hK:L!!\u001c6\u0003\u0011\u0015C\bO]\"pI\u0016DQa\\\u0005A\u0002A\f1a\u0019;y!\tI\u0017/\u0003\u0002sU\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"\u0002;\n\u0001\u0004A\u0017AA3w\u0003\u0011\u0019w\u000e]=\u0015\u0007\u0001;\b\u0010C\u00047\u0015A\u0005\t\u0019\u0001\u001d\t\u000fqR\u0001\u0013!a\u0001q\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A>+\u0005ab8&A?\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0003_\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005%qPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/q\u0016\u0001\u00027b]\u001eL1ATA\u000b\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\u0002E\u0002/\u0003CI1!a\t0\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI#a\f\u0011\u00079\nY#C\u0002\u0002.=\u00121!\u00118z\u0011%\t\tdDA\u0001\u0002\u0004\ty\"A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003o\u0001b!!\u000f\u0002@\u0005%RBAA\u001e\u0015\r\tidL\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA!\u0003w\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019A+a\u0012\t\u0013\u0005E\u0012#!AA\u0002\u0005%\u0012AB3rk\u0006d7\u000fF\u0002U\u0003\u001bB\u0011\"!\r\u0013\u0003\u0003\u0005\r!!\u000b)/\u0001\t\t&a\u0016\u0002Z\u0005u\u0013qLA2\u0003K\nI'a\u001b\u0002p\u0005E\u0004c\u0001\u0016\u0002T%\u0019\u0011QK\u000e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111L\u0001PgR\u0014\be\u0018$V\u001d\u000e{\u0006E]3hKb\u0004\b%\f\u0011SKR,(O\\:!iJ,X\rI5gA\u0001\u001cHO\u001d1![\u0006$8\r[3tA\u0001\u0014XmZ3ya\u0002d\u0003e\u001c:!M\u0006d7/\u001a\u0011pi\",'o^5tK:\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005\u0005\u0014\u0001\"7\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aHO\u001d\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8\u000bA\u0001\u0002\u0003\u0005\t\u0011+AI,w-\u001a=qA5\u0002\u0013\rI:ue&tw\rI3yaJ,7o]5p]:\u0002C\u000b[3!e\u0016<W\r\u001f\u0011tiJLgn\u001a\u0011tQ>,H\u000e\u001a\u0011cK\u0002\n\u0007ES1wC\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/\u0015)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I*j]\u000e,\u0007e\u00159be.\u0004#G\f\u0019-AM$(/\u001b8hA1LG/\u001a:bYN\u0004\u0003&\u001b8dYV$\u0017N\\4!e\u0016<W\r\u001f\u0011qCR$XM\u001d8tS\u0001\n'/\u001a\u0011v]\u0016\u001c8-\u00199fI\u0002Jg\u000eI8ve\u0002\u001a\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0018M]:fe:\u0002ci\u001c:!Kb\fW\u000e\u001d7fY\u0001\"x\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014C\u0006I1!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|g\u000e\t4pe\u0002\u0002'/Z4fqB\u0004\u0007eY1oA\t,'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!EycF,\u00192dI\tr#B\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AQCWM]3!SN\u0004\u0013\rI*R\u0019\u0002\u001awN\u001c4jO\u0002:3\u000f]1sW:\u001a\u0018\u000f\u001c\u0018qCJ\u001cXM\u001d\u0018fg\u000e\f\u0007/\u001a3TiJLgn\u001a'ji\u0016\u0014\u0018\r\\:(AQD\u0017\r\u001e\u0011dC:\u0004#-\u001a\u0011vg\u0016$\u0007\u0005^8\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002c-\u00197mE\u0006\u001c7\u000e\t;pAQDW\rI*qCJ\\\u0007%\r\u00187A\t,\u0007.\u0019<j_J\u0004#/Z4be\u0012Lgn\u001a\u0011tiJLgn\u001a\u0011mSR,'/\u00197!a\u0006\u00148/\u001b8h]\u00012uN\u001d\u0011fq\u0006l\u0007\u000f\\3-\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001b4!i\",\u0007eY8oM&<\u0007%[:!K:\f'\r\\3eY\u0001\"\b.\u001a\u0011ae\u0016<W\r\u001f9aAQD\u0017\r\u001e\u0011dC:\u0004S.\u0019;dQ\u0002\u0012C,\u00192dE\u0001J7\u000f\t\u0012_9\u0006\u00147\r\n\u0012/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u001d\u0014aa\r\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E\u000bI:qCJ\\gf]9m]A\f'o]3s]\u0015\u001c8-\u00199fIN#(/\u001b8h\u0019&$XM]1mgv\"(/^3<\u0015\u0001\u0002\u0003\u0005\t\u0011!gB\f'o\u001b\u0018tc2t\u0003/\u0019:tKJtSm]2ba\u0016$7\u000b\u001e:j]\u001ed\u0015\u000e^3sC2\u001c\u0018\u0002\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003s%J*zgR,W\u000e\u0012:jm\u0016,C,V:feNd&j\u001c5oO\u0001zf)\u0016(D?\u0002:SeU=ti\u0016lGI]5wK\u0016bF,V:feNt#fJ\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F)\u0002\u001a\b/\u0019:l]M\fHN\f9beN,'OL3tG\u0006\u0004X\rZ*ue&tw\rT5uKJ\fGn]\u001fgC2\u001cXm\u000f\u0006!A\u0001\u0002\u0003\u0005I:qCJ\\gf]9m]A\f'o]3s]\u0015\u001c8-\u00199fIN#(/\u001b8h\u0019&$XM]1mg&1\u0017\r\\:f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002:SeU=ti\u0016lGI]5wK\u0016bF,V:feNdFLS8i]\u001e\u0002sLR+O\u0007~\u0003s%J*zgR,W\u000e\u0012:jm\u0016,C\f\u0018/]+N,'o\u001d\u0018+OmR\u0001\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\nAA\\8uK\u0006\u0012\u0011QN\u00016\u0015\u0001\u0002\u0003\u0005I+tK\u0002b\u0015jS#!i>\u0004S.\u0019;dQ\u0002:\u0018\u000e\u001e5!g&l\u0007\u000f\\3!gR\u0014\u0018N\\4!a\u0006$H/\u001a:o])\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002t\u0005)\u0011G\f\u0019/a\u0005)!\u000bT5lKB\u0011!\u0006F\n\u0005)\u0005m4\u0007E\u0004\u0002~\u0005\r\u0005\b\u000f!\u000e\u0005\u0005}$bAAA_\u00059!/\u001e8uS6,\u0017\u0002BAC\u0003\u007f\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\t9\b\u0006\u0002\u0002\u0012\u0005)\u0011\r\u001d9msR)\u0001)a$\u0002\u0012\")ag\u0006a\u0001q!)Ah\u0006a\u0001q\u00059QO\\1qa2LH\u0003BAL\u0003G\u0003RALAM\u0003;K1!a'0\u0005\u0019y\u0005\u000f^5p]B)a&a(9q%\u0019\u0011\u0011U\u0018\u0003\rQ+\b\u000f\\33\u0011!\t)\u000bGA\u0001\u0002\u0004\u0001\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\u000b\u0005\u0003\u0002\u0014\u00055\u0016\u0002BAX\u0003+\u0011aa\u00142kK\u000e$\b")
public class RLike
extends StringRegexExpression
implements scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(RLike rLike) {
        return RLike$.MODULE$.unapply(rLike);
    }

    public static Function1<Tuple2<Expression, Expression>, RLike> tupled() {
        return RLike$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, RLike>> curried() {
        return RLike$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String escape(String v) {
        return v;
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).find(0);
    }

    @Override
    public String toString() {
        return new StringBuilder(7).append(this.left()).append(" RLIKE ").append(this.right()).toString();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal != null) {
                String regexStr = StringEscapeUtils.escapeJava((String)((UTF8String)rVal).toString());
                String pattern = ctx.addMutableState(patternClass, "patternRLike", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(16).append((String)v).append(" = ").append(patternClass).append(".compile(\"").append(regexStr).append("\");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                ExprCode eval = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).find(0);\n          }\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), pattern, eval.value()})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2())})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String rightStr = ctx.freshName("rightStr");
            String pattern = ctx.freshName("pattern");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(112).append("\n          String ").append(rightStr).append(" = ").append((String)eval2).append(".toString();\n          ").append(patternClass).append(" ").append(pattern).append(" = ").append(patternClass).append(".compile(").append(rightStr).append(");\n          ").append(ev.value()).append(" = ").append(pattern).append(".matcher(").append((String)eval1).append(".toString()).find(0);\n        ").toString());
        }
        return exprCode;
    }

    public RLike copy(Expression left, Expression right) {
        return new RLike(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "RLike";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RLike;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RLike)) return false;
        boolean bl = true;
        if (!bl) return false;
        RLike rLike = (RLike)x$1;
        Expression expression = this.left();
        Expression expression2 = rLike.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = rLike.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!rLike.canEqual(this)) return false;
        return true;
    }

    public RLike(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

