#include "gimme_config_h.h"

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "make_pretty_string.h"

/* make names safe for filesystem */
void makePrettyString(char *incoming)
{
	unsigned int index;
	unsigned int place;

	if (strlen(incoming) == 0)
	{
		return;
	}
	for (index = 0; index < (unsigned int)strlen(incoming); ++index)
	{
		if (incoming[index] == ' ')
		{
			incoming[index] = '_';
		}
	}
	for (index = 0; index < (unsigned int)strlen(incoming); ++index)
	{

		/* this mess checks to see if the character is a-z or A-Z or 0-9
		 * for those of you not familiar, the |0x20 will convert a uppercase 
		 * letter to lowercase.  bit 5 gets set (look at an ascii chart) 
		 */
		if ((((incoming[index] | 0x20) < 'a') || ((incoming[index] | 0x20) > 'z')) && ((incoming[index] < '0') || (incoming[index] > '9'))
			&& incoming[index] != '_')
		{
			for (place = index; place <= (unsigned int)strlen(incoming); ++place)
			{
				incoming[place] = incoming[place + 1];
			}
			--index;
		}
	}
	return;
}
