//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `info!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn info() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::info!(name: "mog", target: "my::module", ident = 3); // DEBUG:info,nt,-,-,-,"ident","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = 3); // DEBUG:info,nt,-,p,-,"ident","3"
    tracing::info!(name: "mog", target: "my::module", ident = 3, qux = 3); // DEBUG:info,nt,-,f,-,"ident","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = 3, qux = 3); // DEBUG:info,nt,-,pf,-,"ident","3"
    tracing::info!(name: "mog", target: "my::module", ident = 3, "msg without args"); // DEBUG:info,nt,-,-,m,"ident","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = 3, "msg without args"); // DEBUG:info,nt,-,p,m,"ident","3"
    tracing::info!(name: "mog", target: "my::module", ident = 3, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"ident","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"ident","3"
    tracing::info!(name: "mog", target: "my::module", { ident = 3 }, "msg without args"); // DEBUG:info,nt,{},-,m,"ident","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = 3 }, "msg without args"); // DEBUG:info,nt,{},p,m,"ident","3"
    tracing::info!(name: "mog", target: "my::module", { ident = 3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"ident","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"ident","3"
    tracing::info!(name: "mog", target: "my::module", ident = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"ident","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"ident","3"
    tracing::info!(name: "mog", target: "my::module", ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"ident","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"ident","3"
    tracing::info!(name: "mog", target: "my::module", { ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"ident","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"ident","3"
    tracing::info!(name: "mog", target: "my::module", { ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"ident","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"ident","3"
    tracing::info!(name: "mog", target: "my::module", ident = false); // DEBUG:info,nt,-,-,-,"ident","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = false); // DEBUG:info,nt,-,p,-,"ident","false"
    tracing::info!(name: "mog", target: "my::module", ident = false, qux = 3); // DEBUG:info,nt,-,f,-,"ident","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = false, qux = 3); // DEBUG:info,nt,-,pf,-,"ident","false"
    tracing::info!(name: "mog", target: "my::module", ident = false, "msg without args"); // DEBUG:info,nt,-,-,m,"ident","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = false, "msg without args"); // DEBUG:info,nt,-,p,m,"ident","false"
    tracing::info!(name: "mog", target: "my::module", ident = false, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"ident","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"ident","false"
    tracing::info!(name: "mog", target: "my::module", { ident = false }, "msg without args"); // DEBUG:info,nt,{},-,m,"ident","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = false }, "msg without args"); // DEBUG:info,nt,{},p,m,"ident","false"
    tracing::info!(name: "mog", target: "my::module", { ident = false, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"ident","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"ident","false"
    tracing::info!(name: "mog", target: "my::module", ident = false, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"ident","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"ident","false"
    tracing::info!(name: "mog", target: "my::module", ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"ident","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"ident","false"
    tracing::info!(name: "mog", target: "my::module", { ident = false }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"ident","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"ident","false"
    tracing::info!(name: "mog", target: "my::module", { ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"ident","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"ident","false"
    tracing::info!(name: "mog", target: "my::module", ident = ?3); // DEBUG:info,nt,-,-,-,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?3); // DEBUG:info,nt,-,p,-,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", ident = ?3, qux = 3); // DEBUG:info,nt,-,f,-,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?3, qux = 3); // DEBUG:info,nt,-,pf,-,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", ident = ?3, "msg without args"); // DEBUG:info,nt,-,-,m,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?3, "msg without args"); // DEBUG:info,nt,-,p,m,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", ident = ?3, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", { ident = ?3 }, "msg without args"); // DEBUG:info,nt,{},-,m,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = ?3 }, "msg without args"); // DEBUG:info,nt,{},p,m,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", { ident = ?3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", ident = ?3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", { ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", { ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"ident","?3"
    tracing::info!(name: "mog", target: "my::module", ident = %3); // DEBUG:info,nt,-,-,-,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %3); // DEBUG:info,nt,-,p,-,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", ident = %3, qux = 3); // DEBUG:info,nt,-,f,-,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %3, qux = 3); // DEBUG:info,nt,-,pf,-,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", ident = %3, "msg without args"); // DEBUG:info,nt,-,-,m,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %3, "msg without args"); // DEBUG:info,nt,-,p,m,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", ident = %3, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", { ident = %3 }, "msg without args"); // DEBUG:info,nt,{},-,m,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = %3 }, "msg without args"); // DEBUG:info,nt,{},p,m,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", { ident = %3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", ident = %3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", { ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", { ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"ident","%3"
    tracing::info!(name: "mog", target: "my::module", ident = ?deb); // DEBUG:info,nt,-,-,-,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?deb); // DEBUG:info,nt,-,p,-,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", ident = ?deb, qux = 3); // DEBUG:info,nt,-,f,-,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?deb, qux = 3); // DEBUG:info,nt,-,pf,-,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", ident = ?deb, "msg without args"); // DEBUG:info,nt,-,-,m,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?deb, "msg without args"); // DEBUG:info,nt,-,p,m,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", ident = ?deb, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { ident = ?deb }, "msg without args"); // DEBUG:info,nt,{},-,m,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = ?deb }, "msg without args"); // DEBUG:info,nt,{},p,m,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"ident","?deb"
    tracing::info!(name: "mog", target: "my::module", ident = %disp); // DEBUG:info,nt,-,-,-,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %disp); // DEBUG:info,nt,-,p,-,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", ident = %disp, qux = 3); // DEBUG:info,nt,-,f,-,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %disp, qux = 3); // DEBUG:info,nt,-,pf,-,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", ident = %disp, "msg without args"); // DEBUG:info,nt,-,-,m,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %disp, "msg without args"); // DEBUG:info,nt,-,p,m,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", ident = %disp, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { ident = %disp }, "msg without args"); // DEBUG:info,nt,{},-,m,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = %disp }, "msg without args"); // DEBUG:info,nt,{},p,m,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { ident = %disp, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", ident = %disp, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"ident","%disp"
    tracing::info!(name: "mog", target: "my::module", ident = ?sub.field); // DEBUG:info,nt,-,-,-,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?sub.field); // DEBUG:info,nt,-,p,-,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", ident = ?sub.field, qux = 3); // DEBUG:info,nt,-,f,-,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?sub.field, qux = 3); // DEBUG:info,nt,-,pf,-,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", ident = ?sub.field, "msg without args"); // DEBUG:info,nt,-,-,m,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?sub.field, "msg without args"); // DEBUG:info,nt,-,p,m,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { ident = ?sub.field }, "msg without args"); // DEBUG:info,nt,{},-,m,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:info,nt,{},p,m,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", ident = %sub.field); // DEBUG:info,nt,-,-,-,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %sub.field); // DEBUG:info,nt,-,p,-,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", ident = %sub.field, qux = 3); // DEBUG:info,nt,-,f,-,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %sub.field, qux = 3); // DEBUG:info,nt,-,pf,-,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", ident = %sub.field, "msg without args"); // DEBUG:info,nt,-,-,m,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %sub.field, "msg without args"); // DEBUG:info,nt,-,p,m,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", ident = %sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { ident = %sub.field }, "msg without args"); // DEBUG:info,nt,{},-,m,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = %sub.field }, "msg without args"); // DEBUG:info,nt,{},p,m,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", ident = debug(&deb)); // DEBUG:info,nt,-,-,-,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = debug(&deb)); // DEBUG:info,nt,-,p,-,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", ident = debug(&deb), qux = 3); // DEBUG:info,nt,-,f,-,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = debug(&deb), qux = 3); // DEBUG:info,nt,-,pf,-,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", ident = debug(&deb), "msg without args"); // DEBUG:info,nt,-,-,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = debug(&deb), "msg without args"); // DEBUG:info,nt,-,p,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { ident = debug(&deb) }, "msg without args"); // DEBUG:info,nt,{},-,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:info,nt,{},p,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", ident = display(&disp)); // DEBUG:info,nt,-,-,-,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = display(&disp)); // DEBUG:info,nt,-,p,-,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", ident = display(&disp), qux = 3); // DEBUG:info,nt,-,f,-,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = display(&disp), qux = 3); // DEBUG:info,nt,-,pf,-,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", ident = display(&disp), "msg without args"); // DEBUG:info,nt,-,-,m,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = display(&disp), "msg without args"); // DEBUG:info,nt,-,p,m,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", ident = display(&disp), qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { ident = display(&disp) }, "msg without args"); // DEBUG:info,nt,{},-,m,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:info,nt,{},p,m,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", ident = tracing::field::Empty); // DEBUG:info,nt,-,-,-,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = tracing::field::Empty); // DEBUG:info,nt,-,p,-,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", ident = tracing::field::Empty, qux = 3); // DEBUG:info,nt,-,f,-,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:info,nt,-,pf,-,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", ident = tracing::field::Empty, "msg without args"); // DEBUG:info,nt,-,-,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:info,nt,-,p,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { ident = tracing::field::Empty }, "msg without args"); // DEBUG:info,nt,{},-,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:info,nt,{},p,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = 3); // DEBUG:info,nt,-,-,-,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = 3); // DEBUG:info,nt,-,p,-,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = 3, qux = 3); // DEBUG:info,nt,-,f,-,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = 3, qux = 3); // DEBUG:info,nt,-,pf,-,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = 3, "msg without args"); // DEBUG:info,nt,-,-,m,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = 3, "msg without args"); // DEBUG:info,nt,-,p,m,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = 3 }, "msg without args"); // DEBUG:info,nt,{},-,m,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:info,nt,{},p,m,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"dotted.ident","3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = false); // DEBUG:info,nt,-,-,-,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = false); // DEBUG:info,nt,-,p,-,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = false, qux = 3); // DEBUG:info,nt,-,f,-,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = false, qux = 3); // DEBUG:info,nt,-,pf,-,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = false, "msg without args"); // DEBUG:info,nt,-,-,m,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = false, "msg without args"); // DEBUG:info,nt,-,p,m,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = false, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = false }, "msg without args"); // DEBUG:info,nt,{},-,m,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = false }, "msg without args"); // DEBUG:info,nt,{},p,m,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"dotted.ident","false"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?3); // DEBUG:info,nt,-,-,-,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?3); // DEBUG:info,nt,-,p,-,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?3, qux = 3); // DEBUG:info,nt,-,f,-,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?3, qux = 3); // DEBUG:info,nt,-,pf,-,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?3, "msg without args"); // DEBUG:info,nt,-,-,m,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:info,nt,-,p,m,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = ?3 }, "msg without args"); // DEBUG:info,nt,{},-,m,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:info,nt,{},p,m,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %3); // DEBUG:info,nt,-,-,-,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %3); // DEBUG:info,nt,-,p,-,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %3, qux = 3); // DEBUG:info,nt,-,f,-,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %3, qux = 3); // DEBUG:info,nt,-,pf,-,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %3, "msg without args"); // DEBUG:info,nt,-,-,m,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %3, "msg without args"); // DEBUG:info,nt,-,p,m,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = %3 }, "msg without args"); // DEBUG:info,nt,{},-,m,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:info,nt,{},p,m,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?deb); // DEBUG:info,nt,-,-,-,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?deb); // DEBUG:info,nt,-,p,-,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?deb, qux = 3); // DEBUG:info,nt,-,f,-,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:info,nt,-,pf,-,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?deb, "msg without args"); // DEBUG:info,nt,-,-,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:info,nt,-,p,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = ?deb }, "msg without args"); // DEBUG:info,nt,{},-,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:info,nt,{},p,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %disp); // DEBUG:info,nt,-,-,-,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %disp); // DEBUG:info,nt,-,p,-,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %disp, qux = 3); // DEBUG:info,nt,-,f,-,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %disp, qux = 3); // DEBUG:info,nt,-,pf,-,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %disp, "msg without args"); // DEBUG:info,nt,-,-,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:info,nt,-,p,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = %disp }, "msg without args"); // DEBUG:info,nt,{},-,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:info,nt,{},p,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?sub.field); // DEBUG:info,nt,-,-,-,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?sub.field); // DEBUG:info,nt,-,p,-,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?sub.field, qux = 3); // DEBUG:info,nt,-,f,-,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:info,nt,-,pf,-,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?sub.field, "msg without args"); // DEBUG:info,nt,-,-,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:info,nt,-,p,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = ?sub.field }, "msg without args"); // DEBUG:info,nt,{},-,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:info,nt,{},p,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %sub.field); // DEBUG:info,nt,-,-,-,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %sub.field); // DEBUG:info,nt,-,p,-,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %sub.field, qux = 3); // DEBUG:info,nt,-,f,-,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:info,nt,-,pf,-,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %sub.field, "msg without args"); // DEBUG:info,nt,-,-,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:info,nt,-,p,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = %sub.field }, "msg without args"); // DEBUG:info,nt,{},-,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:info,nt,{},p,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = debug(&deb)); // DEBUG:info,nt,-,-,-,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = debug(&deb)); // DEBUG:info,nt,-,p,-,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = debug(&deb), qux = 3); // DEBUG:info,nt,-,f,-,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:info,nt,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = debug(&deb), "msg without args"); // DEBUG:info,nt,-,-,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:info,nt,-,p,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:info,nt,{},-,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:info,nt,{},p,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = display(&disp)); // DEBUG:info,nt,-,-,-,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = display(&disp)); // DEBUG:info,nt,-,p,-,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = display(&disp), qux = 3); // DEBUG:info,nt,-,f,-,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:info,nt,-,pf,-,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = display(&disp), "msg without args"); // DEBUG:info,nt,-,-,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:info,nt,-,p,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = display(&disp) }, "msg without args"); // DEBUG:info,nt,{},-,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:info,nt,{},p,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = tracing::field::Empty); // DEBUG:info,nt,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = tracing::field::Empty); // DEBUG:info,nt,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:info,nt,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:info,nt,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:info,nt,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:info,nt,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:info,nt,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:info,nt,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", "literal" = 3); // DEBUG:info,nt,-,-,-,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = 3); // DEBUG:info,nt,-,p,-,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", "literal" = 3, qux = 3); // DEBUG:info,nt,-,f,-,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = 3, qux = 3); // DEBUG:info,nt,-,pf,-,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", "literal" = 3, "msg without args"); // DEBUG:info,nt,-,-,m,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = 3, "msg without args"); // DEBUG:info,nt,-,p,m,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", "literal" = 3, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", { "literal" = 3 }, "msg without args"); // DEBUG:info,nt,{},-,m,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = 3 }, "msg without args"); // DEBUG:info,nt,{},p,m,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", { "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", { "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", { "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"\"literal\"","3"
    tracing::info!(name: "mog", target: "my::module", "literal" = false); // DEBUG:info,nt,-,-,-,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = false); // DEBUG:info,nt,-,p,-,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", "literal" = false, qux = 3); // DEBUG:info,nt,-,f,-,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = false, qux = 3); // DEBUG:info,nt,-,pf,-,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", "literal" = false, "msg without args"); // DEBUG:info,nt,-,-,m,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = false, "msg without args"); // DEBUG:info,nt,-,p,m,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", "literal" = false, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", { "literal" = false }, "msg without args"); // DEBUG:info,nt,{},-,m,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = false }, "msg without args"); // DEBUG:info,nt,{},p,m,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", { "literal" = false, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", "literal" = false, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", { "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", { "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"\"literal\"","false"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?3); // DEBUG:info,nt,-,-,-,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?3); // DEBUG:info,nt,-,p,-,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?3, qux = 3); // DEBUG:info,nt,-,f,-,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?3, qux = 3); // DEBUG:info,nt,-,pf,-,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?3, "msg without args"); // DEBUG:info,nt,-,-,m,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?3, "msg without args"); // DEBUG:info,nt,-,p,m,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?3, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", { "literal" = ?3 }, "msg without args"); // DEBUG:info,nt,{},-,m,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:info,nt,{},p,m,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", { "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", { "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", { "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", target: "my::module", "literal" = %3); // DEBUG:info,nt,-,-,-,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %3); // DEBUG:info,nt,-,p,-,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", "literal" = %3, qux = 3); // DEBUG:info,nt,-,f,-,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %3, qux = 3); // DEBUG:info,nt,-,pf,-,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", "literal" = %3, "msg without args"); // DEBUG:info,nt,-,-,m,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %3, "msg without args"); // DEBUG:info,nt,-,p,m,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", "literal" = %3, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", { "literal" = %3 }, "msg without args"); // DEBUG:info,nt,{},-,m,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = %3 }, "msg without args"); // DEBUG:info,nt,{},p,m,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", { "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", { "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", { "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?deb); // DEBUG:info,nt,-,-,-,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?deb); // DEBUG:info,nt,-,p,-,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?deb, qux = 3); // DEBUG:info,nt,-,f,-,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?deb, qux = 3); // DEBUG:info,nt,-,pf,-,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?deb, "msg without args"); // DEBUG:info,nt,-,-,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?deb, "msg without args"); // DEBUG:info,nt,-,p,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", { "literal" = ?deb }, "msg without args"); // DEBUG:info,nt,{},-,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:info,nt,{},p,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", { "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", { "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", { "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", target: "my::module", "literal" = %disp); // DEBUG:info,nt,-,-,-,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %disp); // DEBUG:info,nt,-,p,-,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", "literal" = %disp, qux = 3); // DEBUG:info,nt,-,f,-,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %disp, qux = 3); // DEBUG:info,nt,-,pf,-,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", "literal" = %disp, "msg without args"); // DEBUG:info,nt,-,-,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %disp, "msg without args"); // DEBUG:info,nt,-,p,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", "literal" = %disp, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", { "literal" = %disp }, "msg without args"); // DEBUG:info,nt,{},-,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = %disp }, "msg without args"); // DEBUG:info,nt,{},p,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", { "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", { "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", { "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?sub.field); // DEBUG:info,nt,-,-,-,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?sub.field); // DEBUG:info,nt,-,p,-,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?sub.field, qux = 3); // DEBUG:info,nt,-,f,-,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:info,nt,-,pf,-,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?sub.field, "msg without args"); // DEBUG:info,nt,-,-,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:info,nt,-,p,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { "literal" = ?sub.field }, "msg without args"); // DEBUG:info,nt,{},-,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:info,nt,{},p,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", target: "my::module", "literal" = %sub.field); // DEBUG:info,nt,-,-,-,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %sub.field); // DEBUG:info,nt,-,p,-,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", "literal" = %sub.field, qux = 3); // DEBUG:info,nt,-,f,-,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %sub.field, qux = 3); // DEBUG:info,nt,-,pf,-,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", "literal" = %sub.field, "msg without args"); // DEBUG:info,nt,-,-,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:info,nt,-,p,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { "literal" = %sub.field }, "msg without args"); // DEBUG:info,nt,{},-,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:info,nt,{},p,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", target: "my::module", "literal" = debug(&deb)); // DEBUG:info,nt,-,-,-,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = debug(&deb)); // DEBUG:info,nt,-,p,-,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", "literal" = debug(&deb), qux = 3); // DEBUG:info,nt,-,f,-,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:info,nt,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", "literal" = debug(&deb), "msg without args"); // DEBUG:info,nt,-,-,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:info,nt,-,p,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { "literal" = debug(&deb) }, "msg without args"); // DEBUG:info,nt,{},-,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:info,nt,{},p,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", "literal" = display(&disp)); // DEBUG:info,nt,-,-,-,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = display(&disp)); // DEBUG:info,nt,-,p,-,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", "literal" = display(&disp), qux = 3); // DEBUG:info,nt,-,f,-,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = display(&disp), qux = 3); // DEBUG:info,nt,-,pf,-,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", "literal" = display(&disp), "msg without args"); // DEBUG:info,nt,-,-,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:info,nt,-,p,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { "literal" = display(&disp) }, "msg without args"); // DEBUG:info,nt,{},-,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:info,nt,{},p,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", "literal" = tracing::field::Empty); // DEBUG:info,nt,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = tracing::field::Empty); // DEBUG:info,nt,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", "literal" = tracing::field::Empty, qux = 3); // DEBUG:info,nt,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:info,nt,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", "literal" = tracing::field::Empty, "msg without args"); // DEBUG:info,nt,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:info,nt,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:info,nt,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:info,nt,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = 3); // DEBUG:info,nt,-,-,-,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = 3); // DEBUG:info,nt,-,p,-,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = 3, qux = 3); // DEBUG:info,nt,-,f,-,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:info,nt,-,pf,-,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = 3, "msg without args"); // DEBUG:info,nt,-,-,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:info,nt,-,p,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = 3 }, "msg without args"); // DEBUG:info,nt,{},-,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:info,nt,{},p,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = false); // DEBUG:info,nt,-,-,-,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = false); // DEBUG:info,nt,-,p,-,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = false, qux = 3); // DEBUG:info,nt,-,f,-,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:info,nt,-,pf,-,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = false, "msg without args"); // DEBUG:info,nt,-,-,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:info,nt,-,p,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = false }, "msg without args"); // DEBUG:info,nt,{},-,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:info,nt,{},p,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?3); // DEBUG:info,nt,-,-,-,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?3); // DEBUG:info,nt,-,p,-,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?3, qux = 3); // DEBUG:info,nt,-,f,-,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:info,nt,-,pf,-,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?3, "msg without args"); // DEBUG:info,nt,-,-,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:info,nt,-,p,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:info,nt,{},-,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:info,nt,{},p,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %3); // DEBUG:info,nt,-,-,-,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %3); // DEBUG:info,nt,-,p,-,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %3, qux = 3); // DEBUG:info,nt,-,f,-,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:info,nt,-,pf,-,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %3, "msg without args"); // DEBUG:info,nt,-,-,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:info,nt,-,p,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = %3 }, "msg without args"); // DEBUG:info,nt,{},-,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:info,nt,{},p,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?deb); // DEBUG:info,nt,-,-,-,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?deb); // DEBUG:info,nt,-,p,-,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?deb, qux = 3); // DEBUG:info,nt,-,f,-,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:info,nt,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?deb, "msg without args"); // DEBUG:info,nt,-,-,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:info,nt,-,p,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:info,nt,{},-,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:info,nt,{},p,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %disp); // DEBUG:info,nt,-,-,-,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %disp); // DEBUG:info,nt,-,p,-,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %disp, qux = 3); // DEBUG:info,nt,-,f,-,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:info,nt,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %disp, "msg without args"); // DEBUG:info,nt,-,-,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:info,nt,-,p,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = %disp }, "msg without args"); // DEBUG:info,nt,{},-,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:info,nt,{},p,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?sub.field); // DEBUG:info,nt,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?sub.field); // DEBUG:info,nt,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:info,nt,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:info,nt,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:info,nt,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:info,nt,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:info,nt,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:info,nt,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %sub.field); // DEBUG:info,nt,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %sub.field); // DEBUG:info,nt,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %sub.field, qux = 3); // DEBUG:info,nt,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:info,nt,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:info,nt,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:info,nt,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:info,nt,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:info,nt,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = debug(&deb)); // DEBUG:info,nt,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:info,nt,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:info,nt,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:info,nt,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:info,nt,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:info,nt,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:info,nt,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:info,nt,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = display(&disp)); // DEBUG:info,nt,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = display(&disp)); // DEBUG:info,nt,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = display(&disp), qux = 3); // DEBUG:info,nt,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:info,nt,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:info,nt,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:info,nt,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:info,nt,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:info,nt,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = tracing::field::Empty); // DEBUG:info,nt,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:info,nt,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:info,nt,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:info,nt,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:info,nt,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:info,nt,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:info,nt,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:info,nt,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", r#type = 3); // DEBUG:info,nt,-,-,-,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = 3); // DEBUG:info,nt,-,p,-,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", r#type = 3, qux = 3); // DEBUG:info,nt,-,f,-,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = 3, qux = 3); // DEBUG:info,nt,-,pf,-,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", r#type = 3, "msg without args"); // DEBUG:info,nt,-,-,m,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = 3, "msg without args"); // DEBUG:info,nt,-,p,m,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", r#type = 3, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", { r#type = 3 }, "msg without args"); // DEBUG:info,nt,{},-,m,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = 3 }, "msg without args"); // DEBUG:info,nt,{},p,m,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", { r#type = 3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", r#type = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", { r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", { r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"r#type","3"
    tracing::info!(name: "mog", target: "my::module", r#type = false); // DEBUG:info,nt,-,-,-,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = false); // DEBUG:info,nt,-,p,-,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", r#type = false, qux = 3); // DEBUG:info,nt,-,f,-,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = false, qux = 3); // DEBUG:info,nt,-,pf,-,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", r#type = false, "msg without args"); // DEBUG:info,nt,-,-,m,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = false, "msg without args"); // DEBUG:info,nt,-,p,m,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", r#type = false, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", { r#type = false }, "msg without args"); // DEBUG:info,nt,{},-,m,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = false }, "msg without args"); // DEBUG:info,nt,{},p,m,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", { r#type = false, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", r#type = false, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", { r#type = false }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", { r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"r#type","false"
    tracing::info!(name: "mog", target: "my::module", r#type = ?3); // DEBUG:info,nt,-,-,-,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?3); // DEBUG:info,nt,-,p,-,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", r#type = ?3, qux = 3); // DEBUG:info,nt,-,f,-,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?3, qux = 3); // DEBUG:info,nt,-,pf,-,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", r#type = ?3, "msg without args"); // DEBUG:info,nt,-,-,m,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?3, "msg without args"); // DEBUG:info,nt,-,p,m,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", r#type = ?3, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", { r#type = ?3 }, "msg without args"); // DEBUG:info,nt,{},-,m,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = ?3 }, "msg without args"); // DEBUG:info,nt,{},p,m,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", { r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", { r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", { r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"r#type","?3"
    tracing::info!(name: "mog", target: "my::module", r#type = %3); // DEBUG:info,nt,-,-,-,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %3); // DEBUG:info,nt,-,p,-,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", r#type = %3, qux = 3); // DEBUG:info,nt,-,f,-,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %3, qux = 3); // DEBUG:info,nt,-,pf,-,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", r#type = %3, "msg without args"); // DEBUG:info,nt,-,-,m,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %3, "msg without args"); // DEBUG:info,nt,-,p,m,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", r#type = %3, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", { r#type = %3 }, "msg without args"); // DEBUG:info,nt,{},-,m,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = %3 }, "msg without args"); // DEBUG:info,nt,{},p,m,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", { r#type = %3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", r#type = %3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", { r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", { r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"r#type","%3"
    tracing::info!(name: "mog", target: "my::module", r#type = ?deb); // DEBUG:info,nt,-,-,-,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?deb); // DEBUG:info,nt,-,p,-,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", r#type = ?deb, qux = 3); // DEBUG:info,nt,-,f,-,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?deb, qux = 3); // DEBUG:info,nt,-,pf,-,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", r#type = ?deb, "msg without args"); // DEBUG:info,nt,-,-,m,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?deb, "msg without args"); // DEBUG:info,nt,-,p,m,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", r#type = ?deb, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", { r#type = ?deb }, "msg without args"); // DEBUG:info,nt,{},-,m,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = ?deb }, "msg without args"); // DEBUG:info,nt,{},p,m,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", { r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", { r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", { r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"r#type","?deb"
    tracing::info!(name: "mog", target: "my::module", r#type = %disp); // DEBUG:info,nt,-,-,-,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %disp); // DEBUG:info,nt,-,p,-,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", r#type = %disp, qux = 3); // DEBUG:info,nt,-,f,-,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %disp, qux = 3); // DEBUG:info,nt,-,pf,-,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", r#type = %disp, "msg without args"); // DEBUG:info,nt,-,-,m,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %disp, "msg without args"); // DEBUG:info,nt,-,p,m,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", r#type = %disp, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", { r#type = %disp }, "msg without args"); // DEBUG:info,nt,{},-,m,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = %disp }, "msg without args"); // DEBUG:info,nt,{},p,m,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", { r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", { r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", { r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"r#type","%disp"
    tracing::info!(name: "mog", target: "my::module", r#type = ?sub.field); // DEBUG:info,nt,-,-,-,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?sub.field); // DEBUG:info,nt,-,p,-,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", r#type = ?sub.field, qux = 3); // DEBUG:info,nt,-,f,-,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?sub.field, qux = 3); // DEBUG:info,nt,-,pf,-,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", r#type = ?sub.field, "msg without args"); // DEBUG:info,nt,-,-,m,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:info,nt,-,p,m,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { r#type = ?sub.field }, "msg without args"); // DEBUG:info,nt,{},-,m,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:info,nt,{},p,m,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", target: "my::module", r#type = %sub.field); // DEBUG:info,nt,-,-,-,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %sub.field); // DEBUG:info,nt,-,p,-,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", r#type = %sub.field, qux = 3); // DEBUG:info,nt,-,f,-,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %sub.field, qux = 3); // DEBUG:info,nt,-,pf,-,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", r#type = %sub.field, "msg without args"); // DEBUG:info,nt,-,-,m,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %sub.field, "msg without args"); // DEBUG:info,nt,-,p,m,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { r#type = %sub.field }, "msg without args"); // DEBUG:info,nt,{},-,m,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:info,nt,{},p,m,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", target: "my::module", r#type = debug(&deb)); // DEBUG:info,nt,-,-,-,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = debug(&deb)); // DEBUG:info,nt,-,p,-,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", r#type = debug(&deb), qux = 3); // DEBUG:info,nt,-,f,-,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = debug(&deb), qux = 3); // DEBUG:info,nt,-,pf,-,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", r#type = debug(&deb), "msg without args"); // DEBUG:info,nt,-,-,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:info,nt,-,p,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { r#type = debug(&deb) }, "msg without args"); // DEBUG:info,nt,{},-,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:info,nt,{},p,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", target: "my::module", r#type = display(&disp)); // DEBUG:info,nt,-,-,-,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = display(&disp)); // DEBUG:info,nt,-,p,-,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", r#type = display(&disp), qux = 3); // DEBUG:info,nt,-,f,-,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = display(&disp), qux = 3); // DEBUG:info,nt,-,pf,-,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", r#type = display(&disp), "msg without args"); // DEBUG:info,nt,-,-,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = display(&disp), "msg without args"); // DEBUG:info,nt,-,p,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { r#type = display(&disp) }, "msg without args"); // DEBUG:info,nt,{},-,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:info,nt,{},p,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", target: "my::module", r#type = tracing::field::Empty); // DEBUG:info,nt,-,-,-,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = tracing::field::Empty); // DEBUG:info,nt,-,p,-,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", r#type = tracing::field::Empty, qux = 3); // DEBUG:info,nt,-,f,-,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:info,nt,-,pf,-,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", r#type = tracing::field::Empty, "msg without args"); // DEBUG:info,nt,-,-,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:info,nt,-,p,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { r#type = tracing::field::Empty }, "msg without args"); // DEBUG:info,nt,{},-,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:info,nt,{},p,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", target: "my::module", var); // DEBUG:info,nt,-,-,-,-,"var"
    tracing::info!(name: "mog", target: "my::module", foo = true, var); // DEBUG:info,nt,-,p,-,-,"var"
    tracing::info!(name: "mog", target: "my::module", var, qux = 3); // DEBUG:info,nt,-,f,-,-,"var"
    tracing::info!(name: "mog", target: "my::module", foo = true, var, qux = 3); // DEBUG:info,nt,-,pf,-,-,"var"
    tracing::info!(name: "mog", target: "my::module", var, "msg without args"); // DEBUG:info,nt,-,-,m,-,"var"
    tracing::info!(name: "mog", target: "my::module", foo = true, var, "msg without args"); // DEBUG:info,nt,-,p,m,-,"var"
    tracing::info!(name: "mog", target: "my::module", var, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,-,"var"
    tracing::info!(name: "mog", target: "my::module", foo = true, var, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,-,"var"
    tracing::info!(name: "mog", target: "my::module", { var }, "msg without args"); // DEBUG:info,nt,{},-,m,-,"var"
    tracing::info!(name: "mog", target: "my::module", { foo = true, var }, "msg without args"); // DEBUG:info,nt,{},p,m,-,"var"
    tracing::info!(name: "mog", target: "my::module", { var, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,-,"var"
    tracing::info!(name: "mog", target: "my::module", { foo = true, var, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,-,"var"
    tracing::info!(name: "mog", target: "my::module", var, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,-,"var"
    tracing::info!(name: "mog", target: "my::module", foo = true, var, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,-,"var"
    tracing::info!(name: "mog", target: "my::module", var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,-,"var"
    tracing::info!(name: "mog", target: "my::module", foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,-,"var"
    tracing::info!(name: "mog", target: "my::module", { var }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,-,"var"
    tracing::info!(name: "mog", target: "my::module", { foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,-,"var"
    tracing::info!(name: "mog", target: "my::module", { var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,-,"var"
    tracing::info!(name: "mog", target: "my::module", { foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,-,"var"
    tracing::info!(name: "mog", target: "my::module", sub.field); // DEBUG:info,nt,-,-,-,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, sub.field); // DEBUG:info,nt,-,p,-,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", sub.field, qux = 3); // DEBUG:info,nt,-,f,-,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, sub.field, qux = 3); // DEBUG:info,nt,-,pf,-,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", sub.field, "msg without args"); // DEBUG:info,nt,-,-,m,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, sub.field, "msg without args"); // DEBUG:info,nt,-,p,m,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", { sub.field }, "msg without args"); // DEBUG:info,nt,{},-,m,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, sub.field }, "msg without args"); // DEBUG:info,nt,{},p,m,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", { sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", { sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", { sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,-,"sub.field"
    tracing::info!(name: "mog", target: "my::module", %disp); // DEBUG:info,nt,-,-,-,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, %disp); // DEBUG:info,nt,-,p,-,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", %disp, qux = 3); // DEBUG:info,nt,-,f,-,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, %disp, qux = 3); // DEBUG:info,nt,-,pf,-,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", %disp, "msg without args"); // DEBUG:info,nt,-,-,m,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, %disp, "msg without args"); // DEBUG:info,nt,-,p,m,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", %disp, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, %disp, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", { %disp }, "msg without args"); // DEBUG:info,nt,{},-,m,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, %disp }, "msg without args"); // DEBUG:info,nt,{},p,m,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", { %disp, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", %disp, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", { %disp }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", { %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", { foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,-,"%disp"
    tracing::info!(name: "mog", target: "my::module", ?deb); // DEBUG:info,nt,-,-,-,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, ?deb); // DEBUG:info,nt,-,p,-,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", ?deb, qux = 3); // DEBUG:info,nt,-,f,-,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, ?deb, qux = 3); // DEBUG:info,nt,-,pf,-,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", ?deb, "msg without args"); // DEBUG:info,nt,-,-,m,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, ?deb, "msg without args"); // DEBUG:info,nt,-,p,m,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", ?deb, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", { ?deb }, "msg without args"); // DEBUG:info,nt,{},-,m,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ?deb }, "msg without args"); // DEBUG:info,nt,{},p,m,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", { ?deb, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", ?deb, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", { ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", { ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,-,"?deb"
    tracing::info!(name: "mog", target: "my::module", %sub.field); // DEBUG:info,nt,-,-,-,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, %sub.field); // DEBUG:info,nt,-,p,-,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", %sub.field, qux = 3); // DEBUG:info,nt,-,f,-,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, %sub.field, qux = 3); // DEBUG:info,nt,-,pf,-,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", %sub.field, "msg without args"); // DEBUG:info,nt,-,-,m,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, %sub.field, "msg without args"); // DEBUG:info,nt,-,p,m,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", %sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", { %sub.field }, "msg without args"); // DEBUG:info,nt,{},-,m,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, %sub.field }, "msg without args"); // DEBUG:info,nt,{},p,m,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", { %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", { %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", { %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,-,"%sub.field"
    tracing::info!(name: "mog", target: "my::module", ?sub.field); // DEBUG:info,nt,-,-,-,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ?sub.field); // DEBUG:info,nt,-,p,-,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", ?sub.field, qux = 3); // DEBUG:info,nt,-,f,-,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ?sub.field, qux = 3); // DEBUG:info,nt,-,pf,-,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", ?sub.field, "msg without args"); // DEBUG:info,nt,-,-,m,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ?sub.field, "msg without args"); // DEBUG:info,nt,-,p,m,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", ?sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,f,m,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:info,nt,-,pf,m,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", { ?sub.field }, "msg without args"); // DEBUG:info,nt,{},-,m,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ?sub.field }, "msg without args"); // DEBUG:info,nt,{},p,m,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", { ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},f,m,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,nt,{},pf,m,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,-,ma,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,p,ma,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,f,ma,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,nt,-,pf,ma,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", { ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},-,ma,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},p,ma,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", { ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},f,ma,-,"?sub.field"
    tracing::info!(name: "mog", target: "my::module", { foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,nt,{},pf,ma,-,"?sub.field"
}
