/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.tools.build.bundletool.commands.AutoValue_BuildSdkAsarCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.commands.DaggerBuildSdkAsarManagerComponent;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.BundleParser;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.transparency.CodeTransparencyCryptoUtils;
import com.android.tools.build.bundletool.validation.SdkBundleValidator;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@AutoValue
public abstract class BuildSdkAsarCommand {
    public static final String COMMAND_NAME = "build-sdk-asar";
    private static final Flag<Path> SDK_BUNDLE_LOCATION_FLAG = Flag.path("sdk-bundle");
    private static final Flag<Path> APK_SIGNING_CERTIFICATE_LOCATION_FLAG = Flag.path("apk-signing-key-certificate");
    private static final Flag<Path> OUTPUT_FILE_FLAG = Flag.path("output");
    private static final Flag<Boolean> OVERWRITE_OUTPUT_FLAG = Flag.booleanFlag("overwrite");
    private static final int PLACEHOLDER_VERSION_CODE = 1;

    abstract Path getSdkBundlePath();

    abstract Optional<X509Certificate> getApkSigningCertificate();

    abstract Path getOutputFile();

    abstract boolean getOverwriteOutput();

    public static Builder builder() {
        return new AutoValue_BuildSdkAsarCommand.Builder().setOverwriteOutput(false);
    }

    public static BuildSdkAsarCommand fromFlags(ParsedFlags flags) {
        Builder sdkAsarCommandBuilder = BuildSdkAsarCommand.builder().setSdkBundlePath(SDK_BUNDLE_LOCATION_FLAG.getRequiredValue(flags)).setOutputFile(OUTPUT_FILE_FLAG.getRequiredValue(flags));
        OVERWRITE_OUTPUT_FLAG.getValue(flags).ifPresent(sdkAsarCommandBuilder::setOverwriteOutput);
        APK_SIGNING_CERTIFICATE_LOCATION_FLAG.getValue(flags).map(CodeTransparencyCryptoUtils::getX509Certificate).ifPresent(sdkAsarCommandBuilder::setApkSigningCertificate);
        flags.checkNoUnknownFlags();
        return sdkAsarCommandBuilder.build();
    }

    public Path execute() {
        this.validateInput();
        try (ZipFile bundleZip = new ZipFile(this.getSdkBundlePath().toFile());){
            TempDirectory tempDir = new TempDirectory(this.getClass().getSimpleName());
            SdkBundleValidator bundleValidator = SdkBundleValidator.create();
            bundleValidator.validateFile(bundleZip);
            Path modulesPath = tempDir.getPath().resolve("modules.resm");
            try (ZipFile modulesZip = BundleParser.getModulesZip(bundleZip, modulesPath);){
                bundleValidator.validateModulesFile(modulesZip);
                SdkBundle sdkBundle = SdkBundle.buildFromZip(bundleZip, modulesZip, 1);
                bundleValidator.validate(sdkBundle);
                DaggerBuildSdkAsarManagerComponent.builder().setBuildSdkAsarCommand(this).setSdkBundle(sdkBundle).build().create().execute(modulesPath);
            }
        }
        catch (ZipException e11) {
            throw InvalidBundleException.builder().withCause(e11).withUserMessage("The SDK Bundle is not a valid zip file.").build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException("An error occurred when validating the Sdk Bundle.", e12);
        }
        return this.getOutputFile();
    }

    private void validateInput() {
        FilePreconditions.checkFileExistsAndReadable(this.getSdkBundlePath());
        FilePreconditions.checkFileHasExtension("ASB file", this.getSdkBundlePath(), ".asb");
        if (!this.getOverwriteOutput()) {
            FilePreconditions.checkFileDoesNotExist(this.getOutputFile());
        }
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Generates an ASAR from an Android SDK Bundle.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(SDK_BUNDLE_LOCATION_FLAG.getName()).setExampleValue("path/to/SDKbundle.asb").setDescription("Path to SDK bundle. Must have the extension '.asb'.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(APK_SIGNING_CERTIFICATE_LOCATION_FLAG.getName()).setExampleValue("path/to/certificate.crt").setDescription("Path to SDK APK signing certificate.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_FILE_FLAG.getName()).setExampleValue("output.asar").setDescription("Path to where the ASAR should be created.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OVERWRITE_OUTPUT_FLAG.getName()).setOptional(true).setDescription("If set, any previous existing output will be overwritten.").build()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSdkBundlePath(Path var1);

        public abstract Builder setApkSigningCertificate(X509Certificate var1);

        public abstract Builder setOutputFile(Path var1);

        public abstract Builder setOverwriteOutput(boolean var1);

        public abstract BuildSdkAsarCommand build();
    }
}

