(function() {var type_impls = {
"core":[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-NonZeroU8\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#impl-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.new_unchecked\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0, const since 1.28.0\">1.28.0 (const: 1.28.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.new_unchecked\" class=\"fn\">new_unchecked</a>(n: <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Creates a non-zero without checking whether the value is non-zero.\nThis results in undefined behaviour if the value is zero.</p>\n<h5 id=\"safety\"><a href=\"#safety\">Safety</a></h5>\n<p>The value must not be zero.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.new\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0, const since 1.47.0\">1.28.0 (const: 1.47.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.new\" class=\"fn\">new</a>(n: <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;Self&gt;</h4></section></summary><div class=\"docblock\"><p>Creates a non-zero if the given value is not zero.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.get\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0, const since 1.34.0\">1.28.0 (const: 1.34.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.get\" class=\"fn\">get</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.u8.html\">u8</a></h4></section></summary><div class=\"docblock\"><p>Returns the value as a primitive type.</p>\n</div></details></div></details>",0,"core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-NonZeroU8\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#268-281\">source</a><a href=\"#impl-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.leading_zeros\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.53.0, const since 1.53.0\">1.53.0 (const: 1.53.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#268-281\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.leading_zeros\" class=\"fn\">leading_zeros</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.u32.html\">u32</a></h4></section></summary><div class=\"docblock\"><p>Returns the number of leading zeros in the binary representation of <code>self</code>.</p>\n<p>On many architectures, this function can perform better than <code>leading_zeros()</code> on the underlying integer type, as special handling of zero can be avoided.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<p>Basic usage:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>n = std::num::NonZeroU8::new(u8::MAX).unwrap();\n\n<span class=\"macro\">assert_eq!</span>(n.leading_zeros(), <span class=\"number\">0</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+n+=+std::num::NonZeroU8::new(u8::MAX).unwrap();%0A%0Aassert_eq!(n.leading_zeros(),+0);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.trailing_zeros\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.53.0, const since 1.53.0\">1.53.0 (const: 1.53.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#268-281\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.trailing_zeros\" class=\"fn\">trailing_zeros</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.u32.html\">u32</a></h4></section></summary><div class=\"docblock\"><p>Returns the number of trailing zeros in the binary representation\nof <code>self</code>.</p>\n<p>On many architectures, this function can perform better than <code>trailing_zeros()</code> on the underlying integer type, as special handling of zero can be avoided.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<p>Basic usage:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>n = std::num::NonZeroU8::new(<span class=\"number\">0b0101000</span>).unwrap();\n\n<span class=\"macro\">assert_eq!</span>(n.trailing_zeros(), <span class=\"number\">3</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+n+=+std::num::NonZeroU8::new(0b0101000).unwrap();%0A%0Aassert_eq!(n.trailing_zeros(),+3);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-NonZeroU8\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#562-569\">source</a><a href=\"#impl-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.checked_add\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#562-569\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.checked_add\" class=\"fn\">checked_add</a>(self, other: <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Adds an unsigned integer to a non-zero value.\nChecks for overflow and returns <a href=\"core/option/enum.Option.html#variant.None\" title=\"variant core::option::Option::None\"><code>None</code></a> on overflow.\nAs a consequence, the result cannot wrap to zero.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>one = NonZeroU8::new(<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>two = NonZeroU8::new(<span class=\"number\">2</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>max = NonZeroU8::new(u8::MAX)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Some</span>(two), one.checked_add(<span class=\"number\">1</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">None</span>, max.checked_add(<span class=\"number\">1</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroU8;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+one+=+NonZeroU8::new(1)?;%0Alet+two+=+NonZeroU8::new(2)?;%0Alet+max+=+NonZeroU8::new(u8::MAX)?;%0A%0Aassert_eq!(Some(two),+one.checked_add(1));%0Aassert_eq!(None,+max.checked_add(1));%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#562-569\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, other: <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h4></section></summary><div class=\"docblock\"><p>Adds an unsigned integer to a non-zero value.\nReturn <a href=\"core/num/struct.NonZeroU8.html#associatedconstant.MAX\" title=\"associated constant core::num::NonZeroU8::MAX\"><code>NonZeroU8::MAX</code></a> on overflow.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>one = NonZeroU8::new(<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>two = NonZeroU8::new(<span class=\"number\">2</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>max = NonZeroU8::new(u8::MAX)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(two, one.saturating_add(<span class=\"number\">1</span>));\n<span class=\"macro\">assert_eq!</span>(max, max.saturating_add(<span class=\"number\">1</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroU8;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+one+=+NonZeroU8::new(1)?;%0Alet+two+=+NonZeroU8::new(2)?;%0Alet+max+=+NonZeroU8::new(u8::MAX)?;%0A%0Aassert_eq!(two,+one.saturating_add(1));%0Aassert_eq!(max,+max.saturating_add(1));%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unchecked_add\" class=\"method\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#562-569\">source</a><h4 class=\"code-header\">pub const unsafe fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.unchecked_add\" class=\"fn\">unchecked_add</a>(self, other: <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>nonzero_ops</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84186\">#84186</a>)</span></div></span></summary><div class=\"docblock\"><p>Adds an unsigned integer to a non-zero value,\nassuming overflow cannot occur.\nOverflow is unchecked, and it is undefined behaviour to overflow\n<em>even if the result would wrap to a non-zero value</em>.\nThe behaviour is undefined as soon as\n<code>self + rhs &gt; u8::MAX</code>.</p>\n<h5 id=\"examples-2\"><a href=\"#examples-2\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(nonzero_ops)]\n\n</span><span class=\"kw\">let </span>one = NonZeroU8::new(<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>two = NonZeroU8::new(<span class=\"number\">2</span>)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(two, <span class=\"kw\">unsafe </span>{ one.unchecked_add(<span class=\"number\">1</span>) });</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(nonzero_ops)%5D%0A%0Ause+std::num::NonZeroU8;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+one+=+NonZeroU8::new(1)?;%0Alet+two+=+NonZeroU8::new(2)?;%0A%0Aassert_eq!(two,+unsafe+%7B+one.unchecked_add(1)+%7D);%0ASome(())%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.checked_next_power_of_two\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#562-569\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.checked_next_power_of_two\" class=\"fn\">checked_next_power_of_two</a>(self) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Returns the smallest power of two greater than or equal to n.\nChecks for overflow and returns <a href=\"core/option/enum.Option.html#variant.None\" title=\"variant core::option::Option::None\"><code>None</code></a>\nif the next power of two is greater than the type’s maximum value.\nAs a consequence, the result cannot wrap to zero.</p>\n<h5 id=\"examples-3\"><a href=\"#examples-3\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>two = NonZeroU8::new(<span class=\"number\">2</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>three = NonZeroU8::new(<span class=\"number\">3</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>four = NonZeroU8::new(<span class=\"number\">4</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>max = NonZeroU8::new(u8::MAX)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Some</span>(two), two.checked_next_power_of_two() );\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Some</span>(four), three.checked_next_power_of_two() );\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">None</span>, max.checked_next_power_of_two() );</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroU8;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+two+=+NonZeroU8::new(2)?;%0Alet+three+=+NonZeroU8::new(3)?;%0Alet+four+=+NonZeroU8::new(4)?;%0Alet+max+=+NonZeroU8::new(u8::MAX)?;%0A%0Aassert_eq!(Some(two),+two.checked_next_power_of_two()+);%0Aassert_eq!(Some(four),+three.checked_next_power_of_two()+);%0Aassert_eq!(None,+max.checked_next_power_of_two()+);%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ilog2\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.67.0, const since 1.67.0\">1.67.0 (const: 1.67.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#562-569\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.ilog2\" class=\"fn\">ilog2</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.u32.html\">u32</a></h4></section></summary><div class=\"docblock\"><p>Returns the base 2 logarithm of the number, rounded down.</p>\n<p>This is the same operation as\n<a href=\"core/primitive.u8.html#method.ilog2\" title=\"method u8::ilog2\"><code>u8::ilog2</code></a>,\nexcept that it has no failure cases to worry about\nsince this value can never be zero.</p>\n<h5 id=\"examples-4\"><a href=\"#examples-4\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"macro\">assert_eq!</span>(NonZeroU8::new(<span class=\"number\">7</span>).unwrap().ilog2(), <span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(NonZeroU8::new(<span class=\"number\">8</span>).unwrap().ilog2(), <span class=\"number\">3</span>);\n<span class=\"macro\">assert_eq!</span>(NonZeroU8::new(<span class=\"number\">9</span>).unwrap().ilog2(), <span class=\"number\">3</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::num::NonZeroU8;%0Aassert_eq!(NonZeroU8::new(7).unwrap().ilog2(),+2);%0Aassert_eq!(NonZeroU8::new(8).unwrap().ilog2(),+3);%0Aassert_eq!(NonZeroU8::new(9).unwrap().ilog2(),+3);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ilog10\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.67.0, const since 1.67.0\">1.67.0 (const: 1.67.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#562-569\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.ilog10\" class=\"fn\">ilog10</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.u32.html\">u32</a></h4></section></summary><div class=\"docblock\"><p>Returns the base 10 logarithm of the number, rounded down.</p>\n<p>This is the same operation as\n<a href=\"core/primitive.u8.html#method.ilog10\" title=\"method u8::ilog10\"><code>u8::ilog10</code></a>,\nexcept that it has no failure cases to worry about\nsince this value can never be zero.</p>\n<h5 id=\"examples-5\"><a href=\"#examples-5\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"macro\">assert_eq!</span>(NonZeroU8::new(<span class=\"number\">99</span>).unwrap().ilog10(), <span class=\"number\">1</span>);\n<span class=\"macro\">assert_eq!</span>(NonZeroU8::new(<span class=\"number\">100</span>).unwrap().ilog10(), <span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(NonZeroU8::new(<span class=\"number\">101</span>).unwrap().ilog10(), <span class=\"number\">2</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::num::NonZeroU8;%0Aassert_eq!(NonZeroU8::new(99).unwrap().ilog10(),+1);%0Aassert_eq!(NonZeroU8::new(100).unwrap().ilog10(),+2);%0Aassert_eq!(NonZeroU8::new(101).unwrap().ilog10(),+2);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.midpoint\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/110840\" title=\"Tracking issue for const_num_midpoint\">unstable</a></span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#562-569\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.midpoint\" class=\"fn\">midpoint</a>(self, rhs: Self) -&gt; Self</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>num_midpoint</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/110840\">#110840</a>)</span></div></span></summary><div class=\"docblock\"><p>Calculates the middle point of <code>self</code> and <code>rhs</code>.</p>\n<p><code>midpoint(a, b)</code> is <code>(a + b) &gt;&gt; 1</code> as if it were performed in a\nsufficiently-large signed integral type. This implies that the result is\nalways rounded towards negative infinity and that no overflow will ever occur.</p>\n<h5 id=\"examples-6\"><a href=\"#examples-6\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(num_midpoint)]\n\n</span><span class=\"kw\">let </span>one = NonZeroU8::new(<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>two = NonZeroU8::new(<span class=\"number\">2</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>four = NonZeroU8::new(<span class=\"number\">4</span>)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(one.midpoint(four), two);\n<span class=\"macro\">assert_eq!</span>(four.midpoint(one), two);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(num_midpoint)%5D%0Ause+std::num::NonZeroU8;%0A%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+one+=+NonZeroU8::new(1)?;%0Alet+two+=+NonZeroU8::new(2)?;%0Alet+four+=+NonZeroU8::new(4)?;%0A%0Aassert_eq!(one.midpoint(four),+two);%0Aassert_eq!(four.midpoint(one),+two);%0ASome(())%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-NonZeroU8\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#1201-1214\">source</a><a href=\"#impl-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.checked_mul\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#1201-1214\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.checked_mul\" class=\"fn\">checked_mul</a>(self, other: <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a>) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Multiplies two non-zero integers together.\nChecks for overflow and returns <a href=\"core/option/enum.Option.html#variant.None\" title=\"variant core::option::Option::None\"><code>None</code></a> on overflow.\nAs a consequence, the result cannot wrap to zero.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>two = NonZeroU8::new(<span class=\"number\">2</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>four = NonZeroU8::new(<span class=\"number\">4</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>max = NonZeroU8::new(u8::MAX)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Some</span>(four), two.checked_mul(two));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">None</span>, max.checked_mul(two));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroU8;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+two+=+NonZeroU8::new(2)?;%0Alet+four+=+NonZeroU8::new(4)?;%0Alet+max+=+NonZeroU8::new(u8::MAX)?;%0A%0Aassert_eq!(Some(four),+two.checked_mul(two));%0Aassert_eq!(None,+max.checked_mul(two));%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_mul\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#1201-1214\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.saturating_mul\" class=\"fn\">saturating_mul</a>(self, other: <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a>) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h4></section></summary><div class=\"docblock\"><p>Multiplies two non-zero integers together.\nReturn <a href=\"core/num/struct.NonZeroU8.html#associatedconstant.MAX\" title=\"associated constant core::num::NonZeroU8::MAX\"><code>NonZeroU8::MAX</code></a> on overflow.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>two = NonZeroU8::new(<span class=\"number\">2</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>four = NonZeroU8::new(<span class=\"number\">4</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>max = NonZeroU8::new(u8::MAX)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(four, two.saturating_mul(two));\n<span class=\"macro\">assert_eq!</span>(max, four.saturating_mul(max));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroU8;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+two+=+NonZeroU8::new(2)?;%0Alet+four+=+NonZeroU8::new(4)?;%0Alet+max+=+NonZeroU8::new(u8::MAX)?;%0A%0Aassert_eq!(four,+two.saturating_mul(two));%0Aassert_eq!(max,+four.saturating_mul(max));%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unchecked_mul\" class=\"method\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#1201-1214\">source</a><h4 class=\"code-header\">pub const unsafe fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.unchecked_mul\" class=\"fn\">unchecked_mul</a>(self, other: <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a>) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>nonzero_ops</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84186\">#84186</a>)</span></div></span></summary><div class=\"docblock\"><p>Multiplies two non-zero integers together,\nassuming overflow cannot occur.\nOverflow is unchecked, and it is undefined behaviour to overflow\n<em>even if the result would wrap to a non-zero value</em>.\nThe behaviour is undefined as soon as\n<code>self * rhs &gt; u8::MAX</code>.</p>\n<h5 id=\"examples-2\"><a href=\"#examples-2\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(nonzero_ops)]\n\n</span><span class=\"kw\">let </span>two = NonZeroU8::new(<span class=\"number\">2</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>four = NonZeroU8::new(<span class=\"number\">4</span>)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(four, <span class=\"kw\">unsafe </span>{ two.unchecked_mul(two) });</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(nonzero_ops)%5D%0A%0Ause+std::num::NonZeroU8;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+two+=+NonZeroU8::new(2)?;%0Alet+four+=+NonZeroU8::new(4)?;%0A%0Aassert_eq!(four,+unsafe+%7B+two.unchecked_mul(two)+%7D);%0ASome(())%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.checked_pow\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#1201-1214\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.checked_pow\" class=\"fn\">checked_pow</a>(self, other: <a class=\"primitive\" href=\"primitive.u32.html\">u32</a>) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Raises non-zero value to an integer power.\nChecks for overflow and returns <a href=\"core/option/enum.Option.html#variant.None\" title=\"variant core::option::Option::None\"><code>None</code></a> on overflow.\nAs a consequence, the result cannot wrap to zero.</p>\n<h5 id=\"examples-3\"><a href=\"#examples-3\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>three = NonZeroU8::new(<span class=\"number\">3</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>twenty_seven = NonZeroU8::new(<span class=\"number\">27</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>half_max = NonZeroU8::new(u8::MAX / <span class=\"number\">2</span>)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Some</span>(twenty_seven), three.checked_pow(<span class=\"number\">3</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">None</span>, half_max.checked_pow(<span class=\"number\">3</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroU8;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+three+=+NonZeroU8::new(3)?;%0Alet+twenty_seven+=+NonZeroU8::new(27)?;%0Alet+half_max+=+NonZeroU8::new(u8::MAX+/+2)?;%0A%0Aassert_eq!(Some(twenty_seven),+three.checked_pow(3));%0Aassert_eq!(None,+half_max.checked_pow(3));%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_pow\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#1201-1214\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.saturating_pow\" class=\"fn\">saturating_pow</a>(self, other: <a class=\"primitive\" href=\"primitive.u32.html\">u32</a>) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h4></section></summary><div class=\"docblock\"><p>Raise non-zero value to an integer power.\nReturn <a href=\"core/num/struct.NonZeroU8.html#associatedconstant.MAX\" title=\"associated constant core::num::NonZeroU8::MAX\"><code>NonZeroU8::MAX</code></a> on overflow.</p>\n<h5 id=\"examples-4\"><a href=\"#examples-4\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>three = NonZeroU8::new(<span class=\"number\">3</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>twenty_seven = NonZeroU8::new(<span class=\"number\">27</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>max = NonZeroU8::new(u8::MAX)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(twenty_seven, three.saturating_pow(<span class=\"number\">3</span>));\n<span class=\"macro\">assert_eq!</span>(max, max.saturating_pow(<span class=\"number\">3</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroU8;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+three+=+NonZeroU8::new(3)?;%0Alet+twenty_seven+=+NonZeroU8::new(27)?;%0Alet+max+=+NonZeroU8::new(u8::MAX)?;%0A%0Aassert_eq!(twenty_seven,+three.saturating_pow(3));%0Aassert_eq!(max,+max.saturating_pow(3));%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-NonZeroU8\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#1254\">source</a><a href=\"#impl-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_power_of_two\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.59.0, const since 1.59.0\">1.59.0 (const: 1.59.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#1254\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroU8.html#tymethod.is_power_of_two\" class=\"fn\">is_power_of_two</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if and only if <code>self == (1 &lt;&lt; k)</code> for some <code>k</code>.</p>\n<p>On many architectures, this function can perform better than <code>is_power_of_two()</code>\non the underlying integer type, as special handling of zero can be avoided.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<p>Basic usage:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>eight = std::num::NonZeroU8::new(<span class=\"number\">8</span>).unwrap();\n<span class=\"macro\">assert!</span>(eight.is_power_of_two());\n<span class=\"kw\">let </span>ten = std::num::NonZeroU8::new(<span class=\"number\">10</span>).unwrap();\n<span class=\"macro\">assert!</span>(!ten.is_power_of_two());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+eight+=+std::num::NonZeroU8::new(8).unwrap();%0Aassert!(eight.is_power_of_two());%0Alet+ten+=+std::num::NonZeroU8::new(10).unwrap();%0Aassert!(!ten.is_power_of_two());%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-NonZeroU8\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#1331-1338\">source</a><a href=\"#impl-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedconstant.MIN\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.70.0\">1.70.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#1331-1338\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/num/struct.NonZeroU8.html#associatedconstant.MIN\" class=\"constant\">MIN</a>: Self = _</h4></section></summary><div class=\"docblock\"><p>The smallest value that can be represented by this non-zero\ninteger type, 1.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"macro\">assert_eq!</span>(NonZeroU8::MIN.get(), <span class=\"number\">1u8</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::num::NonZeroU8;%0Aassert_eq!(NonZeroU8::MIN.get(),+1u8);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedconstant.MAX\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.70.0\">1.70.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#1331-1338\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/num/struct.NonZeroU8.html#associatedconstant.MAX\" class=\"constant\">MAX</a>: Self = _</h4></section></summary><div class=\"docblock\"><p>The largest value that can be represented by this non-zero\ninteger type,\nequal to <a href=\"core/primitive.u8.html#associatedconstant.MAX\" title=\"associated constant u8::MAX\"><code>u8::MAX</code></a>.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"macro\">assert_eq!</span>(NonZeroU8::MAX.get(), u8::MAX);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::num::NonZeroU8;%0Aassert_eq!(NonZeroU8::MAX.get(),+u8::MAX);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-NonZeroU8\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#1371-1384\">source</a><a href=\"#impl-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedconstant.BITS\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.67.0\">1.67.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#1371-1384\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/num/struct.NonZeroU8.html#associatedconstant.BITS\" class=\"constant\">BITS</a>: <a class=\"primitive\" href=\"primitive.u32.html\">u32</a> = 8u32</h4></section></summary><div class=\"docblock\"><p>The size of this non-zero integer type in bits.</p>\n<p>This value is equal to <a href=\"core/primitive.u8.html#associatedconstant.BITS\" title=\"associated constant u8::BITS\"><code>u8::BITS</code></a>.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code>\n<span class=\"macro\">assert_eq!</span>(NonZeroU8::BITS, u8::BITS);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::num::NonZeroU8;%0A%0Aassert_eq!(NonZeroU8::BITS,+u8::BITS);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroI64%3E-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#567\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroI64%3E-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroI64.html\" title=\"struct core::num::NonZeroI64\">NonZeroI64</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#567\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroI64.html\" title=\"struct core::num::NonZeroI64\">NonZeroI64</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroI64</code> to <code>NonZeroU8</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroI64>","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Binary-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0\">1.28.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Binary-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.Binary.html\" title=\"trait core::fmt::Binary\">Binary</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.Binary.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter.</div></details></div></details>","Binary","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Debug-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0\">1.28.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Debug-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.Debug.html\" title=\"trait core::fmt::Debug\">Debug</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.Debug.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"core/fmt/trait.Debug.html#tymethod.fmt\">Read more</a></div></details></div></details>","Debug","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-FromStr-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.35.0\">1.35.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#209-210\">source</a></span><a href=\"#impl-FromStr-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/str/trait.FromStr.html\" title=\"trait core::str::FromStr\">FromStr</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Err\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Err\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/str/trait.FromStr.html#associatedtype.Err\" class=\"associatedtype\">Err</a> = <a class=\"struct\" href=\"core/num/struct.ParseIntError.html\" title=\"struct core::num::ParseIntError\">ParseIntError</a></h4></section></summary><div class='docblock'>The associated error which can be returned from parsing.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_str\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#209-210\">source</a><a href=\"#method.from_str\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/str/trait.FromStr.html#tymethod.from_str\" class=\"fn\">from_str</a>(src: &amp;<a class=\"primitive\" href=\"primitive.str.html\">str</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/str/trait.FromStr.html#associatedtype.Err\" title=\"type core::str::FromStr::Err\">Err</a>&gt;</h4></section></summary><div class='docblock'>Parses a string <code>s</code> to return a value of this type. <a href=\"core/str/trait.FromStr.html#tymethod.from_str\">Read more</a></div></details></div></details>","FromStr","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroU64%3E-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#567\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroU64%3E-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroU64.html\" title=\"struct core::num::NonZeroU64\">NonZeroU64</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#567\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroU64.html\" title=\"struct core::num::NonZeroU64\">NonZeroU64</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroU64</code> to <code>NonZeroU8</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroU64>","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-UpperHex-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0\">1.28.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-UpperHex-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.UpperHex.html\" title=\"trait core::fmt::UpperHex\">UpperHex</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.UpperHex.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter.</div></details></div></details>","UpperHex","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Display-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0\">1.28.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Display-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.Display.html\" title=\"trait core::fmt::Display\">Display</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.Display.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"core/fmt/trait.Display.html#tymethod.fmt\">Read more</a></div></details></div></details>","Display","core::ffi::NonZero_c_uchar"],["<section id=\"impl-StructuralEq-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0\">1.28.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-StructuralEq-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/marker/trait.StructuralEq.html\" title=\"trait core::marker::StructuralEq\">StructuralEq</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section>","StructuralEq","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroU128%3E-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#567\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroU128%3E-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroU128.html\" title=\"struct core::num::NonZeroU128\">NonZeroU128</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#567\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroU128.html\" title=\"struct core::num::NonZeroU128\">NonZeroU128</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroU128</code> to <code>NonZeroU8</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroU128>","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroI32%3E-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#567\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroI32%3E-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroI32.html\" title=\"struct core::num::NonZeroI32\">NonZeroI32</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#567\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroI32.html\" title=\"struct core::num::NonZeroI32\">NonZeroI32</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroI32</code> to <code>NonZeroU8</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroI32>","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0\">1.28.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-PartialEq-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>self</code> and <code>other</code> values to be equal, and is used\nby <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#242-244\">source</a></span><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>!=</code>. The default implementation is almost always\nsufficient, and should not be overridden without very good reason.</div></details></div></details>","PartialEq","core::ffi::NonZero_c_uchar"],["<section id=\"impl-Eq-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0\">1.28.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Eq-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/cmp/trait.Eq.html\" title=\"trait core::cmp::Eq\">Eq</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section>","Eq","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Ord-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0\">1.28.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Ord-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/cmp/trait.Ord.html\" title=\"trait core::cmp::Ord\">Ord</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#tymethod.cmp\" class=\"fn\">cmp</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a>) -&gt; <a class=\"enum\" href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\">Ordering</a></h4></section></summary><div class='docblock'>This method returns an <a href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\"><code>Ordering</code></a> between <code>self</code> and <code>other</code>. <a href=\"core/cmp/trait.Ord.html#tymethod.cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.max\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#829-834\">source</a></span><a href=\"#method.max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#method.max\" class=\"fn\">max</a>(self, other: Self) -&gt; Self<div class=\"where\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class='docblock'>Compares and returns the maximum of two values. <a href=\"core/cmp/trait.Ord.html#method.max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.min\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#849-854\">source</a></span><a href=\"#method.min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#method.min\" class=\"fn\">min</a>(self, other: Self) -&gt; Self<div class=\"where\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class='docblock'>Compares and returns the minimum of two values. <a href=\"core/cmp/trait.Ord.html#method.min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clamp\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.50.0\">1.50.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#874-887\">source</a></span><a href=\"#method.clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#method.clamp\" class=\"fn\">clamp</a>(self, min: Self, max: Self) -&gt; Self<div class=\"where\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"core/cmp/trait.PartialOrd.html\" title=\"trait core::cmp::PartialOrd\">PartialOrd</a>,</div></h4></section></summary><div class='docblock'>Restrict a value to a certain interval. <a href=\"core/cmp/trait.Ord.html#method.clamp\">Read more</a></div></details></div></details>","Ord","core::ffi::NonZero_c_uchar"],["<section id=\"impl-StructuralPartialEq-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0\">1.28.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-StructuralPartialEq-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/marker/trait.StructuralPartialEq.html\" title=\"trait core::marker::StructuralPartialEq\">StructuralPartialEq</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section>","StructuralPartialEq","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOrAssign-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.45.0\">1.45.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-BitOrAssign-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.BitOrAssign.html\" title=\"trait core::ops::BitOrAssign\">BitOrAssign</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.bitor_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.BitOrAssign.html#tymethod.bitor_assign\" class=\"fn\">bitor_assign</a>(&amp;mut self, rhs: Self)</h4></section></summary><div class='docblock'>Performs the <code>|=</code> operation. <a href=\"core/ops/trait.BitOrAssign.html#tymethod.bitor_assign\">Read more</a></div></details></div></details>","BitOrAssign","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Octal-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0\">1.28.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Octal-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.Octal.html\" title=\"trait core::fmt::Octal\">Octal</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.Octal.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter.</div></details></div></details>","Octal","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialOrd-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0\">1.28.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-PartialOrd-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/cmp/trait.PartialOrd.html\" title=\"trait core::cmp::PartialOrd\">PartialOrd</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.partial_cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.partial_cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#tymethod.partial_cmp\" class=\"fn\">partial_cmp</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a>) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"enum\" href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\">Ordering</a>&gt;</h4></section></summary><div class='docblock'>This method returns an ordering between <code>self</code> and <code>other</code> values if one exists. <a href=\"core/cmp/trait.PartialOrd.html#tymethod.partial_cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.lt\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1125-1127\">source</a></span><a href=\"#method.lt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.lt\" class=\"fn\">lt</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;</code> operator. <a href=\"core/cmp/trait.PartialOrd.html#method.lt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.le\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1142-1144\">source</a></span><a href=\"#method.le\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.le\" class=\"fn\">le</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;=</code>\noperator. <a href=\"core/cmp/trait.PartialOrd.html#method.le\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gt\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1158-1160\">source</a></span><a href=\"#method.gt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.gt\" class=\"fn\">gt</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;</code> operator. <a href=\"core/cmp/trait.PartialOrd.html#method.gt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ge\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1175-1177\">source</a></span><a href=\"#method.ge\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.ge\" class=\"fn\">ge</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;=</code>\noperator. <a href=\"core/cmp/trait.PartialOrd.html#method.ge\">Read more</a></div></details></div></details>","PartialOrd","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Clone-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0\">1.28.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Clone-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/clone/trait.Clone.html\" title=\"trait core::clone::Clone\">Clone</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.clone\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/clone/trait.Clone.html#tymethod.clone\" class=\"fn\">clone</a>(&amp;self) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h4></section></summary><div class='docblock'>Returns a copy of the value. <a href=\"core/clone/trait.Clone.html#tymethod.clone\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone_from\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/clone.rs.html#169-171\">source</a></span><a href=\"#method.clone_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/clone/trait.Clone.html#method.clone_from\" class=\"fn\">clone_from</a>(&amp;mut self, source: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Self</a>)</h4></section></summary><div class='docblock'>Performs copy-assignment from <code>source</code>. <a href=\"core/clone/trait.Clone.html#method.clone_from\">Read more</a></div></details></div></details>","Clone","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Hash-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0\">1.28.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Hash-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/hash/trait.Hash.html\" title=\"trait core::hash::Hash\">Hash</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.hash\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/hash/trait.Hash.html#tymethod.hash\" class=\"fn\">hash</a>&lt;__H: <a class=\"trait\" href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\">Hasher</a>&gt;(&amp;self, state: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut __H</a>)</h4></section></summary><div class='docblock'>Feeds this value into the given <a href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\"><code>Hasher</code></a>. <a href=\"core/hash/trait.Hash.html#tymethod.hash\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash_slice\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.3.0\">1.3.0</span> · <a class=\"src\" href=\"src/core/hash/mod.rs.html#238-245\">source</a></span><a href=\"#method.hash_slice\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/hash/trait.Hash.html#method.hash_slice\" class=\"fn\">hash_slice</a>&lt;H: <a class=\"trait\" href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\">Hasher</a>&gt;(data: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[Self]</a>, state: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut H</a>)<div class=\"where\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</div></h4></section></summary><div class='docblock'>Feeds a slice of this type into the given <a href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\"><code>Hasher</code></a>. <a href=\"core/hash/trait.Hash.html#method.hash_slice\">Read more</a></div></details></div></details>","Hash","core::ffi::NonZero_c_uchar"],["<section id=\"impl-Copy-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0\">1.28.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Copy-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/marker/trait.Copy.html\" title=\"trait core::marker::Copy\">Copy</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section>","Copy","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3Cu8%3E-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.46.0\">1.46.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#521\">source</a></span><a href=\"#impl-TryFrom%3Cu8%3E-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#521\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>u8</code> to <code>NonZeroU8</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<u8>","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOrAssign%3Cu8%3E-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.45.0\">1.45.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-BitOrAssign%3Cu8%3E-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.BitOrAssign.html\" title=\"trait core::ops::BitOrAssign\">BitOrAssign</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.bitor_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.BitOrAssign.html#tymethod.bitor_assign\" class=\"fn\">bitor_assign</a>(&amp;mut self, rhs: <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>)</h4></section></summary><div class='docblock'>Performs the <code>|=</code> operation. <a href=\"core/ops/trait.BitOrAssign.html#tymethod.bitor_assign\">Read more</a></div></details></div></details>","BitOrAssign<u8>","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroI128%3E-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#567\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroI128%3E-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroI128.html\" title=\"struct core::num::NonZeroI128\">NonZeroI128</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#567\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroI128.html\" title=\"struct core::num::NonZeroI128\">NonZeroI128</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroI128</code> to <code>NonZeroU8</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroI128>","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOr%3Cu8%3E-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.45.0\">1.45.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-BitOr%3Cu8%3E-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.BitOr.html\" title=\"trait core::ops::BitOr\">BitOr</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.BitOr.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>|</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.bitor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.BitOr.html#tymethod.bitor\" class=\"fn\">bitor</a>(self, rhs: <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>) -&gt; Self::<a class=\"associatedtype\" href=\"core/ops/trait.BitOr.html#associatedtype.Output\" title=\"type core::ops::BitOr::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>|</code> operation. <a href=\"core/ops/trait.BitOr.html#tymethod.bitor\">Read more</a></div></details></div></details>","BitOr<u8>","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroU32%3E-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#567\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroU32%3E-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroU32.html\" title=\"struct core::num::NonZeroU32\">NonZeroU32</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#567\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroU32.html\" title=\"struct core::num::NonZeroU32\">NonZeroU32</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroU32</code> to <code>NonZeroU8</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroU32>","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroUsize%3E-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#567\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroUsize%3E-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroUsize.html\" title=\"struct core::num::NonZeroUsize\">NonZeroUsize</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#567\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroUsize.html\" title=\"struct core::num::NonZeroUsize\">NonZeroUsize</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroUsize</code> to <code>NonZeroU8</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroUsize>","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroI16%3E-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#567\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroI16%3E-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#567\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroI16</code> to <code>NonZeroU8</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroI16>","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOr-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.45.0\">1.45.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-BitOr-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.BitOr.html\" title=\"trait core::ops::BitOr\">BitOr</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.BitOr.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>|</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.bitor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.BitOr.html#tymethod.bitor\" class=\"fn\">bitor</a>(self, rhs: Self) -&gt; Self::<a class=\"associatedtype\" href=\"core/ops/trait.BitOr.html#associatedtype.Output\" title=\"type core::ops::BitOr::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>|</code> operation. <a href=\"core/ops/trait.BitOr.html#tymethod.bitor\">Read more</a></div></details></div></details>","BitOr","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroU16%3E-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#567\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroU16%3E-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroU16.html\" title=\"struct core::num::NonZeroU16\">NonZeroU16</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#567\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroU16.html\" title=\"struct core::num::NonZeroU16\">NonZeroU16</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroU16</code> to <code>NonZeroU8</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroU16>","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroIsize%3E-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#567\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroIsize%3E-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroIsize.html\" title=\"struct core::num::NonZeroIsize\">NonZeroIsize</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#567\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroIsize.html\" title=\"struct core::num::NonZeroIsize\">NonZeroIsize</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroIsize</code> to <code>NonZeroU8</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroIsize>","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-LowerHex-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.28.0\">1.28.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-LowerHex-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.LowerHex.html\" title=\"trait core::fmt::LowerHex\">LowerHex</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.LowerHex.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter.</div></details></div></details>","LowerHex","core::ffi::NonZero_c_uchar"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroI8%3E-for-NonZeroU8\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#567\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroI8%3E-for-NonZeroU8\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroI8.html\" title=\"struct core::num::NonZeroI8\">NonZeroI8</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#567\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroI8.html\" title=\"struct core::num::NonZeroI8\">NonZeroI8</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroI8</code> to <code>NonZeroU8</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroI8>","core::ffi::NonZero_c_uchar"]]
};if (window.register_type_impls) {window.register_type_impls(type_impls);} else {window.pending_type_impls = type_impls;}})()