use crate::{mod_prelude_sys::*, core};

mod alphamat_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_alphamat_infoFlow_const__InputArrayR_const__InputArrayR_const__OutputArrayR(image: *const c_void, tmap: *const c_void, result: *const c_void, ocvrs_return: *mut Result<()>);
	}
}
pub use alphamat_sys::*;

mod aruco_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_aruco_calibrateCameraAruco_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_PtrLBoardGR_Size_const__InputOutputArrayR_const__InputOutputArrayR(corners: *const c_void, ids: *const c_void, counter: *const c_void, board: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_aruco_calibrateCameraAruco_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_PtrLBoardGR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(corners: *const c_void, ids: *const c_void, counter: *const c_void, board: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, std_deviations_intrinsics: *const c_void, std_deviations_extrinsics: *const c_void, per_view_errors: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_aruco_calibrateCameraAruco_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_PtrLBoardGR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_const_TermCriteriaR(corners: *const c_void, ids: *const c_void, counter: *const c_void, board: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, std_deviations_intrinsics: *const c_void, std_deviations_extrinsics: *const c_void, per_view_errors: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_aruco_calibrateCameraAruco_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_PtrLBoardGR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int_const_TermCriteriaR(corners: *const c_void, ids: *const c_void, counter: *const c_void, board: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_aruco_calibrateCameraCharuco_const__InputArrayR_const__InputArrayR_const_PtrLCharucoBoardGR_Size_const__InputOutputArrayR_const__InputOutputArrayR(charuco_corners: *const c_void, charuco_ids: *const c_void, board: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_aruco_calibrateCameraCharuco_const__InputArrayR_const__InputArrayR_const_PtrLCharucoBoardGR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(charuco_corners: *const c_void, charuco_ids: *const c_void, board: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, std_deviations_intrinsics: *const c_void, std_deviations_extrinsics: *const c_void, per_view_errors: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_aruco_calibrateCameraCharuco_const__InputArrayR_const__InputArrayR_const_PtrLCharucoBoardGR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_const_TermCriteriaR(charuco_corners: *const c_void, charuco_ids: *const c_void, board: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, std_deviations_intrinsics: *const c_void, std_deviations_extrinsics: *const c_void, per_view_errors: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_aruco_calibrateCameraCharuco_const__InputArrayR_const__InputArrayR_const_PtrLCharucoBoardGR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int_const_TermCriteriaR(charuco_corners: *const c_void, charuco_ids: *const c_void, board: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_aruco_detectCharucoDiamond_const__InputArrayR_const__InputArrayR_const__InputArrayR_float_const__OutputArrayR_const__OutputArrayR(image: *const c_void, marker_corners: *const c_void, marker_ids: *const c_void, square_marker_length_rate: f32, diamond_corners: *const c_void, diamond_ids: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_aruco_detectCharucoDiamond_const__InputArrayR_const__InputArrayR_const__InputArrayR_float_const__OutputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_PtrLDictionaryG(image: *const c_void, marker_corners: *const c_void, marker_ids: *const c_void, square_marker_length_rate: f32, diamond_corners: *const c_void, diamond_ids: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, dictionary: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_aruco_detectMarkers_const__InputArrayR_const_PtrLDictionaryGR_const__OutputArrayR_const__OutputArrayR(image: *const c_void, dictionary: *const c_void, corners: *const c_void, ids: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_aruco_detectMarkers_const__InputArrayR_const_PtrLDictionaryGR_const__OutputArrayR_const__OutputArrayR_const_PtrLDetectorParametersGR_const__OutputArrayR(image: *const c_void, dictionary: *const c_void, corners: *const c_void, ids: *const c_void, parameters: *const c_void, rejected_img_points: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_aruco_drawCharucoDiamond_const_PtrLDictionaryGR_Vec4i_int_int_const__OutputArrayR(dictionary: *const c_void, ids: *const core::Vec4i, square_length: i32, marker_length: i32, img: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_aruco_drawCharucoDiamond_const_PtrLDictionaryGR_Vec4i_int_int_const__OutputArrayR_int_int(dictionary: *const c_void, ids: *const core::Vec4i, square_length: i32, marker_length: i32, img: *const c_void, margin_size: i32, border_bits: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_aruco_drawPlanarBoard_const_PtrLBoardGR_Size_const__OutputArrayR_int_int(board: *const c_void, out_size: *const core::Size, img: *const c_void, margin_size: i32, border_bits: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_aruco_estimatePoseBoard_const__InputArrayR_const__InputArrayR_const_PtrLBoardGR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR(corners: *const c_void, ids: *const c_void, board: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_aruco_estimatePoseBoard_const__InputArrayR_const__InputArrayR_const_PtrLBoardGR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_bool(corners: *const c_void, ids: *const c_void, board: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, ocvrs_return: *mut Result<i32>);
		pub fn cv_aruco_estimatePoseCharucoBoard_const__InputArrayR_const__InputArrayR_const_PtrLCharucoBoardGR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR(charuco_corners: *const c_void, charuco_ids: *const c_void, board: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_aruco_estimatePoseCharucoBoard_const__InputArrayR_const__InputArrayR_const_PtrLCharucoBoardGR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_bool(charuco_corners: *const c_void, charuco_ids: *const c_void, board: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, ocvrs_return: *mut Result<bool>);
		pub fn cv_aruco_estimatePoseSingleMarkers_const__InputArrayR_float_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(corners: *const c_void, marker_length: f32, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_aruco_estimatePoseSingleMarkers_const__InputArrayR_float_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const_PtrLEstimateParametersGR(corners: *const c_void, marker_length: f32, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, obj_points: *const c_void, estimate_parameters: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_aruco_getBoardObjectAndImagePoints_const_PtrLBoardGR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(board: *const c_void, detected_corners: *const c_void, detected_ids: *const c_void, obj_points: *const c_void, img_points: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_aruco_interpolateCornersCharuco_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_PtrLCharucoBoardGR_const__OutputArrayR_const__OutputArrayR(marker_corners: *const c_void, marker_ids: *const c_void, image: *const c_void, board: *const c_void, charuco_corners: *const c_void, charuco_ids: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_aruco_interpolateCornersCharuco_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_PtrLCharucoBoardGR_const__OutputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_int(marker_corners: *const c_void, marker_ids: *const c_void, image: *const c_void, board: *const c_void, charuco_corners: *const c_void, charuco_ids: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, min_markers: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_aruco_refineDetectedMarkers_const__InputArrayR_const_PtrLBoardGR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR(image: *const c_void, board: *const c_void, detected_corners: *const c_void, detected_ids: *const c_void, rejected_corners: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_aruco_refineDetectedMarkers_const__InputArrayR_const_PtrLBoardGR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_float_float_bool_const__OutputArrayR_const_PtrLDetectorParametersGR(image: *const c_void, board: *const c_void, detected_corners: *const c_void, detected_ids: *const c_void, rejected_corners: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, min_rep_distance: f32, error_correction_rate: f32, check_all_orders: bool, recovered_idxs: *const c_void, parameters: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_aruco_testCharucoCornersCollinear_const_PtrLCharucoBoardGR_const__InputArrayR(board: *const c_void, charuco_ids: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_aruco_EstimateParameters_EstimateParameters(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_aruco_EstimateParameters_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_aruco_EstimateParameters_propPattern_const(instance: *const c_void, ocvrs_return: *mut crate::aruco::PatternPositionType);
		pub fn cv_aruco_EstimateParameters_propPattern_const_PatternPositionType(instance: *mut c_void, val: crate::aruco::PatternPositionType);
		pub fn cv_aruco_EstimateParameters_propUseExtrinsicGuess_const(instance: *const c_void) -> bool;
		pub fn cv_aruco_EstimateParameters_propUseExtrinsicGuess_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_aruco_EstimateParameters_propSolvePnPMethod_const(instance: *const c_void) -> i32;
		pub fn cv_aruco_EstimateParameters_propSolvePnPMethod_const_int(instance: *mut c_void, val: i32);
		pub fn cv_aruco_EstimateParameters_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_aruco_EstimateParametersG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_aruco_EstimateParametersG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_aruco_EstimateParametersG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_aruco_EstimateParametersG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_aruco_EstimateParametersG_new_const_EstimateParameters(val: *mut c_void) -> *mut c_void;
	}
}
pub use aruco_sys::*;

mod bgsegm_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_bgsegm_createBackgroundSubtractorCNT(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bgsegm_createBackgroundSubtractorCNT_int_bool_int_bool(min_pixel_stability: i32, use_history: bool, max_pixel_stability: i32, is_parallel: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bgsegm_createBackgroundSubtractorGMG(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bgsegm_createBackgroundSubtractorGMG_int_double(initialization_frames: i32, decision_threshold: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bgsegm_createBackgroundSubtractorGSOC(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bgsegm_createBackgroundSubtractorGSOC_int_int_float_float_int_float_float_float_float_float_float(mc: i32, n_samples: i32, replace_rate: f32, propagation_rate: f32, hits_threshold: i32, alpha: f32, beta: f32, blinking_supression_decay: f32, blinking_supression_multiplier: f32, noise_removal_threshold_fac_bg: f32, noise_removal_threshold_fac_fg: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bgsegm_createBackgroundSubtractorLSBP(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bgsegm_createBackgroundSubtractorLSBP_int_int_int_float_float_float_float_float_float_float_float_int_int(mc: i32, n_samples: i32, lsbp_radius: i32, tlower: f32, tupper: f32, tinc: f32, tdec: f32, rscale: f32, rincdec: f32, noise_removal_threshold_fac_bg: f32, noise_removal_threshold_fac_fg: f32, lsb_pthreshold: i32, min_count: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bgsegm_createBackgroundSubtractorMOG(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bgsegm_createBackgroundSubtractorMOG_int_int_double_double(history: i32, nmixtures: i32, background_ratio: f64, noise_sigma: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bgsegm_createSyntheticSequenceGenerator_const__InputArrayR_const__InputArrayR(background: *const c_void, object: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bgsegm_createSyntheticSequenceGenerator_const__InputArrayR_const__InputArrayR_double_double_double_double(background: *const c_void, object: *const c_void, amplitude: f64, wavelength: f64, wavespeed: f64, objspeed: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bgsegm_BackgroundSubtractorCNT_apply_const__InputArrayR_const__OutputArrayR_double(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, learning_rate: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorCNT_apply_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorCNT_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double(instance: *mut c_void, image: *const c_void, known_foreground_mask: *const c_void, fgmask: *const c_void, learning_rate: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorCNT_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, known_foreground_mask: *const c_void, fgmask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorCNT_getBackgroundImage_const_const__OutputArrayR(instance: *const c_void, background_image: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorCNT_getMinPixelStability_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_bgsegm_BackgroundSubtractorCNT_setMinPixelStability_int(instance: *mut c_void, value: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorCNT_getMaxPixelStability_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_bgsegm_BackgroundSubtractorCNT_setMaxPixelStability_int(instance: *mut c_void, value: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorCNT_getUseHistory_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_bgsegm_BackgroundSubtractorCNT_setUseHistory_bool(instance: *mut c_void, value: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorCNT_getIsParallel_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_bgsegm_BackgroundSubtractorCNT_setIsParallel_bool(instance: *mut c_void, value: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorCNT_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_bgsegm_BackgroundSubtractorCNT_to_BackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_bgsegm_BackgroundSubtractorCNT_delete(instance: *mut c_void);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_apply_const__InputArrayR_const__OutputArrayR_double(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, learning_rate: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_apply_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double(instance: *mut c_void, image: *const c_void, known_foreground_mask: *const c_void, fgmask: *const c_void, learning_rate: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, known_foreground_mask: *const c_void, fgmask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getBackgroundImage_const_const__OutputArrayR(instance: *const c_void, background_image: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getMaxFeatures_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setMaxFeatures_int(instance: *mut c_void, max_features: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getDefaultLearningRate_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setDefaultLearningRate_double(instance: *mut c_void, lr: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getNumFrames_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setNumFrames_int(instance: *mut c_void, nframes: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getQuantizationLevels_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setQuantizationLevels_int(instance: *mut c_void, nlevels: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getBackgroundPrior_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setBackgroundPrior_double(instance: *mut c_void, bgprior: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getSmoothingRadius_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setSmoothingRadius_int(instance: *mut c_void, radius: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getDecisionThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setDecisionThreshold_double(instance: *mut c_void, thresh: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getUpdateBackgroundModel_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setUpdateBackgroundModel_bool(instance: *mut c_void, update: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getMinVal_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setMinVal_double(instance: *mut c_void, val: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_getMaxVal_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_setMaxVal_double(instance: *mut c_void, val: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGMG_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_to_BackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_bgsegm_BackgroundSubtractorGMG_delete(instance: *mut c_void);
		pub fn cv_bgsegm_BackgroundSubtractorGSOC_apply_const__InputArrayR_const__OutputArrayR_double(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, learning_rate: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGSOC_apply_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGSOC_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double(instance: *mut c_void, image: *const c_void, known_foreground_mask: *const c_void, fgmask: *const c_void, learning_rate: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGSOC_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, known_foreground_mask: *const c_void, fgmask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGSOC_getBackgroundImage_const_const__OutputArrayR(instance: *const c_void, background_image: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorGSOC_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_bgsegm_BackgroundSubtractorGSOC_to_BackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_bgsegm_BackgroundSubtractorGSOC_delete(instance: *mut c_void);
		pub fn cv_bgsegm_BackgroundSubtractorLSBP_apply_const__InputArrayR_const__OutputArrayR_double(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, learning_rate: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorLSBP_apply_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorLSBP_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double(instance: *mut c_void, image: *const c_void, known_foreground_mask: *const c_void, fgmask: *const c_void, learning_rate: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorLSBP_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, known_foreground_mask: *const c_void, fgmask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorLSBP_getBackgroundImage_const_const__OutputArrayR(instance: *const c_void, background_image: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorLSBP_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_bgsegm_BackgroundSubtractorLSBP_to_BackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_bgsegm_BackgroundSubtractorLSBP_delete(instance: *mut c_void);
		pub fn cv_bgsegm_BackgroundSubtractorLSBPDesc_calcLocalSVDValues_const__OutputArrayR_const_MatR(local_svd_values: *const c_void, frame: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorLSBPDesc_computeFromLocalSVDValues_const__OutputArrayR_const_MatR_const_Point2iX(desc: *const c_void, local_svd_values: *const c_void, lsbp_sample_points: *const core::Point2i, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorLSBPDesc_compute_const__OutputArrayR_const_MatR_const_Point2iX(desc: *const c_void, frame: *const c_void, lsbp_sample_points: *const core::Point2i, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorLSBPDesc_defaultNew_const() -> *mut c_void;
		pub fn cv_bgsegm_BackgroundSubtractorLSBPDesc_delete(instance: *mut c_void);
		pub fn cv_bgsegm_BackgroundSubtractorMOG_apply_const__InputArrayR_const__OutputArrayR_double(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, learning_rate: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorMOG_apply_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorMOG_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double(instance: *mut c_void, image: *const c_void, known_foreground_mask: *const c_void, fgmask: *const c_void, learning_rate: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorMOG_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, known_foreground_mask: *const c_void, fgmask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorMOG_getHistory_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_bgsegm_BackgroundSubtractorMOG_setHistory_int(instance: *mut c_void, nframes: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorMOG_getNMixtures_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_bgsegm_BackgroundSubtractorMOG_setNMixtures_int(instance: *mut c_void, nmix: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorMOG_getBackgroundRatio_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_bgsegm_BackgroundSubtractorMOG_setBackgroundRatio_double(instance: *mut c_void, background_ratio: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorMOG_getNoiseSigma_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_bgsegm_BackgroundSubtractorMOG_setNoiseSigma_double(instance: *mut c_void, noise_sigma: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_BackgroundSubtractorMOG_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_bgsegm_BackgroundSubtractorMOG_to_BackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_bgsegm_BackgroundSubtractorMOG_delete(instance: *mut c_void);
		pub fn cv_bgsegm_SyntheticSequenceGenerator_SyntheticSequenceGenerator_const__InputArrayR_const__InputArrayR_double_double_double_double(background: *const c_void, object: *const c_void, amplitude: f64, wavelength: f64, wavespeed: f64, objspeed: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bgsegm_SyntheticSequenceGenerator_getNextFrame_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, frame: *const c_void, gt_mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bgsegm_SyntheticSequenceGenerator_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_bgsegm_SyntheticSequenceGenerator_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorCNTG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorCNTG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorCNTG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorCNTG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorCNTG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorCNTG_to_PtrOfBackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorGMGG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorGMGG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorGMGG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorGMGG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorGMGG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorGMGG_to_PtrOfBackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorGSOCG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorGSOCG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorGSOCG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorGSOCG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorGSOCG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorGSOCG_to_PtrOfBackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorLSBPG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorLSBPG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorLSBPG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorLSBPG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorLSBPG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorLSBPG_to_PtrOfBackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorMOGG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorMOGG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorMOGG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorMOGG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorMOGG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_BackgroundSubtractorMOGG_to_PtrOfBackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_SyntheticSequenceGeneratorG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_SyntheticSequenceGeneratorG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_SyntheticSequenceGeneratorG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_SyntheticSequenceGeneratorG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_bgsegm_SyntheticSequenceGeneratorG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bgsegm_SyntheticSequenceGeneratorG_new_const_SyntheticSequenceGenerator(val: *mut c_void) -> *mut c_void;
	}
}
pub use bgsegm_sys::*;

mod bioinspired_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_bioinspired_Retina_getInputSize(instance: *mut c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_bioinspired_Retina_getOutputSize(instance: *mut c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_bioinspired_Retina_setup_String_const_bool(instance: *mut c_void, retina_parameter_file: *const c_char, apply_default_setup_on_failure: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_setup(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_setup_FileStorageR_const_bool(instance: *mut c_void, fs: *mut c_void, apply_default_setup_on_failure: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_setup_FileStorageR(instance: *mut c_void, fs: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_setup_RetinaParameters(instance: *mut c_void, new_parameters: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_getParameters(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bioinspired_Retina_printSetup(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bioinspired_Retina_write_const_String(instance: *const c_void, fs: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_setupOPLandIPLParvoChannel_const_bool_const_bool_const_float_const_float_const_float_const_float_const_float_const_float_const_float(instance: *mut c_void, color_mode: bool, normalise_output: bool, photoreceptors_local_adaptation_sensitivity: f32, photoreceptors_temporal_constant: f32, photoreceptors_spatial_constant: f32, horizontal_cells_gain: f32, hcells_temporal_constant: f32, hcells_spatial_constant: f32, ganglion_cells_sensitivity: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_setupOPLandIPLParvoChannel(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_setupIPLMagnoChannel_const_bool_const_float_const_float_const_float_const_float_const_float_const_float_const_float(instance: *mut c_void, normalise_output: bool, parasol_cells_beta: f32, parasol_cells_tau: f32, parasol_cells_k: f32, amacrin_cells_temporal_cut_frequency: f32, v0_compression_parameter: f32, local_adaptintegration_tau: f32, local_adaptintegration_k: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_setupIPLMagnoChannel(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_run_const__InputArrayR(instance: *mut c_void, input_image: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_applyFastToneMapping_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, input_image: *const c_void, output_tone_mapped_image: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_getParvo_const__OutputArrayR(instance: *mut c_void, retina_output_parvo: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_getParvoRAW_const__OutputArrayR(instance: *mut c_void, retina_output_parvo: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_getMagno_const__OutputArrayR(instance: *mut c_void, retina_output_magno: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_getMagnoRAW_const__OutputArrayR(instance: *mut c_void, retina_output_magno: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_getMagnoRAW_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bioinspired_Retina_getParvoRAW_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bioinspired_Retina_setColorSaturation_const_bool_const_float(instance: *mut c_void, saturate_colors: bool, color_saturation_value: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_setColorSaturation(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_clearBuffers(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_activateMovingContoursProcessing_const_bool(instance: *mut c_void, activate: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_activateContoursProcessing_const_bool(instance: *mut c_void, activate: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_Retina_create_Size(input_size: *const core::Size, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bioinspired_Retina_create_Size_const_bool_int_const_bool_const_float_const_float(input_size: *const core::Size, color_mode: bool, color_sampling_method: i32, use_retina_log_sampling: bool, reduction_factor: f32, sampling_strength: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bioinspired_Retina_create_Size_const_bool(input_size: *const core::Size, color_mode: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bioinspired_Retina_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_bioinspired_Retina_delete(instance: *mut c_void);
		pub fn cv_bioinspired_RetinaFastToneMapping_applyFastToneMapping_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, input_image: *const c_void, output_tone_mapped_image: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_RetinaFastToneMapping_setup_const_float_const_float_const_float(instance: *mut c_void, photoreceptors_neighborhood_radius: f32, ganglioncells_neighborhood_radius: f32, mean_luminance_modulator_k: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_RetinaFastToneMapping_setup(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_RetinaFastToneMapping_create_Size(input_size: *const core::Size, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bioinspired_RetinaFastToneMapping_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_bioinspired_RetinaFastToneMapping_delete(instance: *mut c_void);
		pub fn cv_bioinspired_RetinaParameters_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_bioinspired_RetinaParameters_defaultNew_const() -> *mut c_void;
		pub fn cv_bioinspired_RetinaParameters_propOPLandIplParvo_const(instance: *const c_void, ocvrs_return: *mut crate::bioinspired::RetinaParameters_OPLandIplParvoParameters);
		pub fn cv_bioinspired_RetinaParameters_propOPLandIplParvo_const_OPLandIplParvoParameters(instance: *mut c_void, val: *const crate::bioinspired::RetinaParameters_OPLandIplParvoParameters);
		pub fn cv_bioinspired_RetinaParameters_propIplMagno_const(instance: *const c_void, ocvrs_return: *mut crate::bioinspired::RetinaParameters_IplMagnoParameters);
		pub fn cv_bioinspired_RetinaParameters_propIplMagno_const_IplMagnoParameters(instance: *mut c_void, val: *const crate::bioinspired::RetinaParameters_IplMagnoParameters);
		pub fn cv_bioinspired_RetinaParameters_delete(instance: *mut c_void);
		pub fn cv_bioinspired_RetinaParameters_IplMagnoParameters_IplMagnoParameters(ocvrs_return: *mut Result<crate::bioinspired::RetinaParameters_IplMagnoParameters>);
		pub fn cv_bioinspired_RetinaParameters_OPLandIplParvoParameters_OPLandIplParvoParameters(ocvrs_return: *mut Result<crate::bioinspired::RetinaParameters_OPLandIplParvoParameters>);
		pub fn cv_bioinspired_SegmentationParameters_SegmentationParameters(ocvrs_return: *mut Result<crate::bioinspired::SegmentationParameters>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_getSize(instance: *mut c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_setup_String_const_bool(instance: *mut c_void, segmentation_parameter_file: *const c_char, apply_default_setup_on_failure: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_setup(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_setup_FileStorageR_const_bool(instance: *mut c_void, fs: *mut c_void, apply_default_setup_on_failure: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_setup_FileStorageR(instance: *mut c_void, fs: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_setup_SegmentationParameters(instance: *mut c_void, new_parameters: *const crate::bioinspired::SegmentationParameters, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_getParameters(instance: *mut c_void, ocvrs_return: *mut Result<crate::bioinspired::SegmentationParameters>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_printSetup(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_write_const_String(instance: *const c_void, fs: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_run_const__InputArrayR_const_int(instance: *mut c_void, input_to_segment: *const c_void, channel_index: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_run_const__InputArrayR(instance: *mut c_void, input_to_segment: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_getSegmentationPicture_const__OutputArrayR(instance: *mut c_void, transient_areas: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_clearAllBuffers(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_create_Size(input_size: *const core::Size, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_bioinspired_TransientAreasSegmentationModule_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_bioinspired_TransientAreasSegmentationModule_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_bioinspired_RetinaG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bioinspired_RetinaG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bioinspired_RetinaG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_bioinspired_RetinaG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_bioinspired_RetinaG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bioinspired_RetinaFastToneMappingG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bioinspired_RetinaFastToneMappingG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bioinspired_RetinaFastToneMappingG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_bioinspired_RetinaFastToneMappingG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_bioinspired_RetinaFastToneMappingG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bioinspired_TransientAreasSegmentationModuleG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bioinspired_TransientAreasSegmentationModuleG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_bioinspired_TransientAreasSegmentationModuleG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_bioinspired_TransientAreasSegmentationModuleG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_bioinspired_TransientAreasSegmentationModuleG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
	}
}
pub use bioinspired_sys::*;

mod calib3d_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_RQDecomp3x3_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, mtx_r: *const c_void, mtx_q: *const c_void, ocvrs_return: *mut Result<core::Vec3d>);
		pub fn cv_RQDecomp3x3_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, mtx_r: *const c_void, mtx_q: *const c_void, qx: *const c_void, qy: *const c_void, qz: *const c_void, ocvrs_return: *mut Result<core::Vec3d>);
		pub fn cv_Rodrigues_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Rodrigues_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, jacobian: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_calibrateCameraRO_const__InputArrayR_const__InputArrayR_Size_int_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, i_fixed_point: i32, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, new_obj_points: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_calibrateCameraRO_const__InputArrayR_const__InputArrayR_Size_int_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, i_fixed_point: i32, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, new_obj_points: *const c_void, std_deviations_intrinsics: *const c_void, std_deviations_extrinsics: *const c_void, std_deviations_obj_points: *const c_void, per_view_errors: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_calibrateCameraRO_const__InputArrayR_const__InputArrayR_Size_int_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, i_fixed_point: i32, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, new_obj_points: *const c_void, std_deviations_intrinsics: *const c_void, std_deviations_extrinsics: *const c_void, std_deviations_obj_points: *const c_void, per_view_errors: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_calibrateCameraRO_const__InputArrayR_const__InputArrayR_Size_int_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, i_fixed_point: i32, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, new_obj_points: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_calibrateCamera_const__InputArrayR_const__InputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_calibrateCamera_const__InputArrayR_const__InputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, std_deviations_intrinsics: *const c_void, std_deviations_extrinsics: *const c_void, per_view_errors: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_calibrateCamera_const__InputArrayR_const__InputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, std_deviations_intrinsics: *const c_void, std_deviations_extrinsics: *const c_void, per_view_errors: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_calibrateCamera_const__InputArrayR_const__InputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_calibrateHandEye_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(r_gripper2base: *const c_void, t_gripper2base: *const c_void, r_target2cam: *const c_void, t_target2cam: *const c_void, r_cam2gripper: *const c_void, t_cam2gripper: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_calibrateHandEye_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_HandEyeCalibrationMethod(r_gripper2base: *const c_void, t_gripper2base: *const c_void, r_target2cam: *const c_void, t_target2cam: *const c_void, r_cam2gripper: *const c_void, t_cam2gripper: *const c_void, method: crate::calib3d::HandEyeCalibrationMethod, ocvrs_return: *mut Result<()>);
		pub fn cv_calibrateRobotWorldHandEye_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(r_world2cam: *const c_void, t_world2cam: *const c_void, r_base2gripper: *const c_void, t_base2gripper: *const c_void, r_base2world: *const c_void, t_base2world: *const c_void, r_gripper2cam: *const c_void, t_gripper2cam: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_calibrateRobotWorldHandEye_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_RobotWorldHandEyeCalibrationMethod(r_world2cam: *const c_void, t_world2cam: *const c_void, r_base2gripper: *const c_void, t_base2gripper: *const c_void, r_base2world: *const c_void, t_base2world: *const c_void, r_gripper2cam: *const c_void, t_gripper2cam: *const c_void, method: crate::calib3d::RobotWorldHandEyeCalibrationMethod, ocvrs_return: *mut Result<()>);
		pub fn cv_calibrationMatrixValues_const__InputArrayR_Size_double_double_doubleR_doubleR_doubleR_Point2dR_doubleR(camera_matrix: *const c_void, image_size: *const core::Size, aperture_width: f64, aperture_height: f64, fovx: *mut f64, fovy: *mut f64, focal_length: *mut f64, principal_point: *mut core::Point2d, aspect_ratio: *mut f64, ocvrs_return: *mut Result<()>);
		pub fn cv_checkChessboard_const__InputArrayR_Size(img: *const c_void, size: *const core::Size, ocvrs_return: *mut Result<bool>);
		pub fn cv_composeRT_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(rvec1: *const c_void, tvec1: *const c_void, rvec2: *const c_void, tvec2: *const c_void, rvec3: *const c_void, tvec3: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_composeRT_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(rvec1: *const c_void, tvec1: *const c_void, rvec2: *const c_void, tvec2: *const c_void, rvec3: *const c_void, tvec3: *const c_void, dr3dr1: *const c_void, dr3dt1: *const c_void, dr3dr2: *const c_void, dr3dt2: *const c_void, dt3dr1: *const c_void, dt3dt1: *const c_void, dt3dr2: *const c_void, dt3dt2: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_computeCorrespondEpilines_const__InputArrayR_int_const__InputArrayR_const__OutputArrayR(points: *const c_void, which_image: i32, f: *const c_void, lines: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_convertPointsFromHomogeneous_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_convertPointsHomogeneous_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_convertPointsToHomogeneous_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_correctMatches_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(f: *const c_void, points1: *const c_void, points2: *const c_void, new_points1: *const c_void, new_points2: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_decomposeEssentialMat_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(e: *const c_void, r1: *const c_void, r2: *const c_void, t: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_decomposeHomographyMat_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(h: *const c_void, k: *const c_void, rotations: *const c_void, translations: *const c_void, normals: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_decomposeProjectionMatrix_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(proj_matrix: *const c_void, camera_matrix: *const c_void, rot_matrix: *const c_void, trans_vect: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_decomposeProjectionMatrix_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(proj_matrix: *const c_void, camera_matrix: *const c_void, rot_matrix: *const c_void, trans_vect: *const c_void, rot_matrix_x: *const c_void, rot_matrix_y: *const c_void, rot_matrix_z: *const c_void, euler_angles: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_drawChessboardCorners_const__InputOutputArrayR_Size_const__InputArrayR_bool(image: *const c_void, pattern_size: *const core::Size, corners: *const c_void, pattern_was_found: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_drawFrameAxes_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_float(image: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, length: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_drawFrameAxes_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_float_int(image: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, length: f32, thickness: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_estimateAffine2D_const__InputArrayR_const__InputArrayR(from: *const c_void, to: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_estimateAffine2D_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const_UsacParamsR(pts1: *const c_void, pts2: *const c_void, inliers: *const c_void, params: *const crate::calib3d::UsacParams, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_estimateAffine2D_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_double_size_t_double_size_t(from: *const c_void, to: *const c_void, inliers: *const c_void, method: i32, ransac_reproj_threshold: f64, max_iters: size_t, confidence: f64, refine_iters: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_estimateAffine3D_const__InputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_estimateAffine3D_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, out: *const c_void, inliers: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_estimateAffine3D_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double_double(src: *const c_void, dst: *const c_void, out: *const c_void, inliers: *const c_void, ransac_threshold: f64, confidence: f64, ocvrs_return: *mut Result<i32>);
		pub fn cv_estimateAffine3D_const__InputArrayR_const__InputArrayR_doubleX_bool(src: *const c_void, dst: *const c_void, scale: *mut f64, force_rotation: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_estimateAffinePartial2D_const__InputArrayR_const__InputArrayR(from: *const c_void, to: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_estimateAffinePartial2D_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_double_size_t_double_size_t(from: *const c_void, to: *const c_void, inliers: *const c_void, method: i32, ransac_reproj_threshold: f64, max_iters: size_t, confidence: f64, refine_iters: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_estimateChessboardSharpness_const__InputArrayR_Size_const__InputArrayR(image: *const c_void, pattern_size: *const core::Size, corners: *const c_void, ocvrs_return: *mut Result<core::Scalar>);
		pub fn cv_estimateChessboardSharpness_const__InputArrayR_Size_const__InputArrayR_float_bool_const__OutputArrayR(image: *const c_void, pattern_size: *const core::Size, corners: *const c_void, rise_distance: f32, vertical: bool, sharpness: *const c_void, ocvrs_return: *mut Result<core::Scalar>);
		pub fn cv_estimateTranslation2D_const__InputArrayR_const__InputArrayR(from: *const c_void, to: *const c_void, ocvrs_return: *mut Result<core::Vec2d>);
		pub fn cv_estimateTranslation2D_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_double_size_t_double_size_t(from: *const c_void, to: *const c_void, inliers: *const c_void, method: i32, ransac_reproj_threshold: f64, max_iters: size_t, confidence: f64, refine_iters: size_t, ocvrs_return: *mut Result<core::Vec2d>);
		pub fn cv_estimateTranslation3D_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, out: *const c_void, inliers: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_estimateTranslation3D_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double_double(src: *const c_void, dst: *const c_void, out: *const c_void, inliers: *const c_void, ransac_threshold: f64, confidence: f64, ocvrs_return: *mut Result<i32>);
		pub fn cv_filterHomographyDecompByVisibleRefpoints_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(rotations: *const c_void, normals: *const c_void, before_points: *const c_void, after_points: *const c_void, possible_solutions: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_filterHomographyDecompByVisibleRefpoints_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(rotations: *const c_void, normals: *const c_void, before_points: *const c_void, after_points: *const c_void, possible_solutions: *const c_void, points_mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_filterSpeckles_const__InputOutputArrayR_double_int_double(img: *const c_void, new_val: f64, max_speckle_size: i32, max_diff: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_filterSpeckles_const__InputOutputArrayR_double_int_double_const__InputOutputArrayR(img: *const c_void, new_val: f64, max_speckle_size: i32, max_diff: f64, buf: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_find4QuadCornerSubpix_const__InputArrayR_const__InputOutputArrayR_Size(img: *const c_void, corners: *const c_void, region_size: *const core::Size, ocvrs_return: *mut Result<bool>);
		pub fn cv_findChessboardCornersSB_const__InputArrayR_Size_const__OutputArrayR(image: *const c_void, pattern_size: *const core::Size, corners: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_findChessboardCornersSB_const__InputArrayR_Size_const__OutputArrayR_int(image: *const c_void, pattern_size: *const core::Size, corners: *const c_void, flags: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_findChessboardCornersSB_const__InputArrayR_Size_const__OutputArrayR_int_const__OutputArrayR(image: *const c_void, pattern_size: *const core::Size, corners: *const c_void, flags: i32, meta: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_findChessboardCorners_const__InputArrayR_Size_const__OutputArrayR(image: *const c_void, pattern_size: *const core::Size, corners: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_findChessboardCorners_const__InputArrayR_Size_const__OutputArrayR_int(image: *const c_void, pattern_size: *const core::Size, corners: *const c_void, flags: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_findCirclesGrid_const__InputArrayR_Size_const__OutputArrayR(image: *const c_void, pattern_size: *const core::Size, centers: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_findCirclesGrid_const__InputArrayR_Size_const__OutputArrayR_int_const_PtrLFeature2DGR(image: *const c_void, pattern_size: *const core::Size, centers: *const c_void, flags: i32, blob_detector: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_findCirclesGrid_const__InputArrayR_Size_const__OutputArrayR_int_const_PtrLFeature2DGR_const_CirclesGridFinderParametersR(image: *const c_void, pattern_size: *const core::Size, centers: *const c_void, flags: i32, blob_detector: *const c_void, parameters: *const crate::calib3d::CirclesGridFinderParameters, ocvrs_return: *mut Result<bool>);
		pub fn cv_findEssentialMat_const__InputArrayR_const__InputArrayR(points1: *const c_void, points2: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findEssentialMat_const__InputArrayR_const__InputArrayR_const__InputArrayR(points1: *const c_void, points2: *const c_void, camera_matrix: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findEssentialMat_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(points1: *const c_void, points2: *const c_void, camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findEssentialMat_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const_UsacParamsR(points1: *const c_void, points2: *const c_void, camera_matrix1: *const c_void, camera_matrix2: *const c_void, dist_coeff1: *const c_void, dist_coeff2: *const c_void, mask: *const c_void, params: *const crate::calib3d::UsacParams, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findEssentialMat_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_double_double_const__OutputArrayR(points1: *const c_void, points2: *const c_void, camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, method: i32, prob: f64, threshold: f64, mask: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findEssentialMat_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_double_double_const__OutputArrayR(points1: *const c_void, points2: *const c_void, camera_matrix: *const c_void, method: i32, prob: f64, threshold: f64, mask: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findEssentialMat_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_double_double_int_const__OutputArrayR(points1: *const c_void, points2: *const c_void, camera_matrix: *const c_void, method: i32, prob: f64, threshold: f64, max_iters: i32, mask: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findEssentialMat_const__InputArrayR_const__InputArrayR_double_Point2d_int_double_double_const__OutputArrayR(points1: *const c_void, points2: *const c_void, focal: f64, pp: *const core::Point2d, method: i32, prob: f64, threshold: f64, mask: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findEssentialMat_const__InputArrayR_const__InputArrayR_double_Point2d_int_double_double_int_const__OutputArrayR(points1: *const c_void, points2: *const c_void, focal: f64, pp: *const core::Point2d, method: i32, prob: f64, threshold: f64, max_iters: i32, mask: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findFundamentalMat_const__InputArrayR_const__InputArrayR(points1: *const c_void, points2: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findFundamentalMat_const__InputArrayR_const__InputArrayR_const__OutputArrayR(points1: *const c_void, points2: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findFundamentalMat_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const_UsacParamsR(points1: *const c_void, points2: *const c_void, mask: *const c_void, params: *const crate::calib3d::UsacParams, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findFundamentalMat_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_double_double(points1: *const c_void, points2: *const c_void, mask: *const c_void, method: i32, ransac_reproj_threshold: f64, confidence: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findFundamentalMat_const__InputArrayR_const__InputArrayR_int_double_double_const__OutputArrayR(points1: *const c_void, points2: *const c_void, method: i32, ransac_reproj_threshold: f64, confidence: f64, mask: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findFundamentalMat_const__InputArrayR_const__InputArrayR_int_double_double_int(points1: *const c_void, points2: *const c_void, method: i32, ransac_reproj_threshold: f64, confidence: f64, max_iters: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findFundamentalMat_const__InputArrayR_const__InputArrayR_int_double_double_int_const__OutputArrayR(points1: *const c_void, points2: *const c_void, method: i32, ransac_reproj_threshold: f64, confidence: f64, max_iters: i32, mask: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findHomography_const__InputArrayR_const__InputArrayR(src_points: *const c_void, dst_points: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findHomography_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src_points: *const c_void, dst_points: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findHomography_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const_UsacParamsR(src_points: *const c_void, dst_points: *const c_void, mask: *const c_void, params: *const crate::calib3d::UsacParams, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findHomography_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_double(src_points: *const c_void, dst_points: *const c_void, mask: *const c_void, method: i32, ransac_reproj_threshold: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_findHomography_const__InputArrayR_const__InputArrayR_int_double_const__OutputArrayR_const_int_const_double(src_points: *const c_void, dst_points: *const c_void, method: i32, ransac_reproj_threshold: f64, mask: *const c_void, max_iters: i32, confidence: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_fisheye_calibrate_const__InputArrayR_const__InputArrayR_const_SizeR_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, k: *const c_void, d: *const c_void, rvecs: *const c_void, tvecs: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_fisheye_calibrate_const__InputArrayR_const__InputArrayR_const_SizeR_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, k: *const c_void, d: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_fisheye_distortPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR(undistorted: *const c_void, distorted: *const c_void, k: *const c_void, d: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_distortPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(undistorted: *const c_void, distorted: *const c_void, kundistorted: *const c_void, k: *const c_void, d: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_distortPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_double(undistorted: *const c_void, distorted: *const c_void, kundistorted: *const c_void, k: *const c_void, d: *const c_void, alpha: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_distortPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_double(undistorted: *const c_void, distorted: *const c_void, k: *const c_void, d: *const c_void, alpha: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_estimateNewCameraMatrixForUndistortRectify_const__InputArrayR_const__InputArrayR_const_SizeR_const__InputArrayR_const__OutputArrayR(k: *const c_void, d: *const c_void, image_size: *const core::Size, r: *const c_void, p: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_estimateNewCameraMatrixForUndistortRectify_const__InputArrayR_const__InputArrayR_const_SizeR_const__InputArrayR_const__OutputArrayR_double_const_SizeR_double(k: *const c_void, d: *const c_void, image_size: *const core::Size, r: *const c_void, p: *const c_void, balance: f64, new_size: *const core::Size, fov_scale: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_initUndistortRectifyMap_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_SizeR_int_const__OutputArrayR_const__OutputArrayR(k: *const c_void, d: *const c_void, r: *const c_void, p: *const c_void, size: *const core::Size, m1type: i32, map1: *const c_void, map2: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_projectPoints_const__InputArrayR_const__OutputArrayR_const_Affine3dR_const__InputArrayR_const__InputArrayR(object_points: *const c_void, image_points: *const c_void, affine: *const core::Affine3d, k: *const c_void, d: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_projectPoints_const__InputArrayR_const__OutputArrayR_const_Affine3dR_const__InputArrayR_const__InputArrayR_double_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, affine: *const core::Affine3d, k: *const c_void, d: *const c_void, alpha: f64, jacobian: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_projectPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(object_points: *const c_void, image_points: *const c_void, rvec: *const c_void, tvec: *const c_void, k: *const c_void, d: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_projectPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_double_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, rvec: *const c_void, tvec: *const c_void, k: *const c_void, d: *const c_void, alpha: f64, jacobian: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_solvePnPRansac_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_fisheye_solvePnPRansac_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_int_float_double_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, iterations_count: i32, reprojection_error: f32, confidence: f64, inliers: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<bool>);
		pub fn cv_fisheye_solvePnP_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_fisheye_solvePnP_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_int_TermCriteria(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<bool>);
		pub fn cv_fisheye_stereoCalibrate_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_Size_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, k1: *const c_void, d1: *const c_void, k2: *const c_void, d2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_fisheye_stereoCalibrate_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_Size_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, k1: *const c_void, d1: *const c_void, k2: *const c_void, d2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, rvecs: *const c_void, tvecs: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_fisheye_stereoCalibrate_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_Size_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, k1: *const c_void, d1: *const c_void, k2: *const c_void, d2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_fisheye_stereoCalibrate_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_Size_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, k1: *const c_void, d1: *const c_void, k2: *const c_void, d2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_fisheye_stereoRectify_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_SizeR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int(k1: *const c_void, d1: *const c_void, k2: *const c_void, d2: *const c_void, image_size: *const core::Size, r: *const c_void, tvec: *const c_void, r1: *const c_void, r2: *const c_void, p1: *const c_void, p2: *const c_void, q: *const c_void, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_stereoRectify_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_SizeR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_const_SizeR_double_double(k1: *const c_void, d1: *const c_void, k2: *const c_void, d2: *const c_void, image_size: *const core::Size, r: *const c_void, tvec: *const c_void, r1: *const c_void, r2: *const c_void, p1: *const c_void, p2: *const c_void, q: *const c_void, flags: i32, new_image_size: *const core::Size, balance: f64, fov_scale: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_undistortImage_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR(distorted: *const c_void, undistorted: *const c_void, k: *const c_void, d: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_undistortImage_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_SizeR(distorted: *const c_void, undistorted: *const c_void, k: *const c_void, d: *const c_void, knew: *const c_void, new_size: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_undistortPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR(distorted: *const c_void, undistorted: *const c_void, k: *const c_void, d: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_fisheye_undistortPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_TermCriteria(distorted: *const c_void, undistorted: *const c_void, k: *const c_void, d: *const c_void, r: *const c_void, p: *const c_void, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<()>);
		pub fn cv_getDefaultNewCameraMatrix_const__InputArrayR(camera_matrix: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_getDefaultNewCameraMatrix_const__InputArrayR_Size_bool(camera_matrix: *const c_void, imgsize: *const core::Size, center_principal_point: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_getOptimalNewCameraMatrix_const__InputArrayR_const__InputArrayR_Size_double(camera_matrix: *const c_void, dist_coeffs: *const c_void, image_size: *const core::Size, alpha: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_getOptimalNewCameraMatrix_const__InputArrayR_const__InputArrayR_Size_double_Size_RectX_bool(camera_matrix: *const c_void, dist_coeffs: *const c_void, image_size: *const core::Size, alpha: f64, new_img_size: *const core::Size, valid_pix_roi: *mut core::Rect, center_principal_point: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_getValidDisparityROI_Rect_Rect_int_int_int(roi1: *const core::Rect, roi2: *const core::Rect, min_disparity: i32, number_of_disparities: i32, block_size: i32, ocvrs_return: *mut Result<core::Rect>);
		pub fn cv_initCameraMatrix2D_const__InputArrayR_const__InputArrayR_Size(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_initCameraMatrix2D_const__InputArrayR_const__InputArrayR_Size_double(object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, aspect_ratio: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_initInverseRectificationMap_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_SizeR_int_const__OutputArrayR_const__OutputArrayR(camera_matrix: *const c_void, dist_coeffs: *const c_void, r: *const c_void, new_camera_matrix: *const c_void, size: *const core::Size, m1type: i32, map1: *const c_void, map2: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_initUndistortRectifyMap_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_Size_int_const__OutputArrayR_const__OutputArrayR(camera_matrix: *const c_void, dist_coeffs: *const c_void, r: *const c_void, new_camera_matrix: *const c_void, size: *const core::Size, m1type: i32, map1: *const c_void, map2: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_initWideAngleProjMap_const__InputArrayR_const__InputArrayR_Size_int_int_const__OutputArrayR_const__OutputArrayR(camera_matrix: *const c_void, dist_coeffs: *const c_void, image_size: *const core::Size, dest_image_width: i32, m1type: i32, map1: *const c_void, map2: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_initWideAngleProjMap_const__InputArrayR_const__InputArrayR_Size_int_int_const__OutputArrayR_const__OutputArrayR_UndistortTypes_double(camera_matrix: *const c_void, dist_coeffs: *const c_void, image_size: *const core::Size, dest_image_width: i32, m1type: i32, map1: *const c_void, map2: *const c_void, proj_type: crate::calib3d::UndistortTypes, alpha: f64, ocvrs_return: *mut Result<f32>);
		pub fn cv_matMulDeriv_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(a: *const c_void, b: *const c_void, d_a_bd_a: *const c_void, d_a_bd_b: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_projectPoints_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(object_points: *const c_void, rvec: *const c_void, tvec: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, image_points: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_projectPoints_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double(object_points: *const c_void, rvec: *const c_void, tvec: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, image_points: *const c_void, jacobian: *const c_void, aspect_ratio: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_recoverPose_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(points1: *const c_void, points2: *const c_void, camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, e: *const c_void, r: *const c_void, t: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_recoverPose_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_double_double_const__InputOutputArrayR(points1: *const c_void, points2: *const c_void, camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, e: *const c_void, r: *const c_void, t: *const c_void, method: i32, prob: f64, threshold: f64, mask: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_recoverPose_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(e: *const c_void, points1: *const c_void, points2: *const c_void, camera_matrix: *const c_void, r: *const c_void, t: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_recoverPose_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__InputOutputArrayR(e: *const c_void, points1: *const c_void, points2: *const c_void, camera_matrix: *const c_void, r: *const c_void, t: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_recoverPose_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double(e: *const c_void, points1: *const c_void, points2: *const c_void, camera_matrix: *const c_void, r: *const c_void, t: *const c_void, distance_thresh: f64, ocvrs_return: *mut Result<i32>);
		pub fn cv_recoverPose_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double_const__InputOutputArrayR_const__OutputArrayR(e: *const c_void, points1: *const c_void, points2: *const c_void, camera_matrix: *const c_void, r: *const c_void, t: *const c_void, distance_thresh: f64, mask: *const c_void, triangulated_points: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_recoverPose_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(e: *const c_void, points1: *const c_void, points2: *const c_void, r: *const c_void, t: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_recoverPose_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double_Point2d_const__InputOutputArrayR(e: *const c_void, points1: *const c_void, points2: *const c_void, r: *const c_void, t: *const c_void, focal: f64, pp: *const core::Point2d, mask: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_rectify3Collinear_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_Size_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_double_Size_RectX_RectX_int(camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, camera_matrix3: *const c_void, dist_coeffs3: *const c_void, imgpt1: *const c_void, imgpt3: *const c_void, image_size: *const core::Size, r12: *const c_void, t12: *const c_void, r13: *const c_void, t13: *const c_void, r1: *const c_void, r2: *const c_void, r3: *const c_void, p1: *const c_void, p2: *const c_void, p3: *const c_void, q: *const c_void, alpha: f64, new_img_size: *const core::Size, roi1: *mut core::Rect, roi2: *mut core::Rect, flags: i32, ocvrs_return: *mut Result<f32>);
		pub fn cv_reprojectImageTo3D_const__InputArrayR_const__OutputArrayR_const__InputArrayR(disparity: *const c_void, _3d_image: *const c_void, q: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_reprojectImageTo3D_const__InputArrayR_const__OutputArrayR_const__InputArrayR_bool_int(disparity: *const c_void, _3d_image: *const c_void, q: *const c_void, handle_missing_values: bool, ddepth: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_sampsonDistance_const__InputArrayR_const__InputArrayR_const__InputArrayR(pt1: *const c_void, pt2: *const c_void, f: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_solveP3P_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_solvePnPGeneric_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_solvePnPGeneric_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_SolvePnPMethod_const__InputArrayR_const__InputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, use_extrinsic_guess: bool, flags: crate::calib3d::SolvePnPMethod, rvec: *const c_void, tvec: *const c_void, reprojection_error: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_solvePnPRansac_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_solvePnPRansac_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_int_float_double_const__OutputArrayR_int(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, iterations_count: i32, reprojection_error: f32, confidence: f64, inliers: *const c_void, flags: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_solvePnPRansac_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, inliers: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_solvePnPRansac_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const_UsacParamsR(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, inliers: *const c_void, params: *const crate::calib3d::UsacParams, ocvrs_return: *mut Result<bool>);
		pub fn cv_solvePnPRefineLM_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_solvePnPRefineLM_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_TermCriteria(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<()>);
		pub fn cv_solvePnPRefineVVS_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_solvePnPRefineVVS_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_TermCriteria_double(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, criteria: *const core::TermCriteria, vv_slambda: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_solvePnP_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_solvePnP_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_int(object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, flags: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_stereoCalibrate_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, e: *const c_void, f: *const c_void, per_view_errors: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_stereoCalibrate_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, e: *const c_void, f: *const c_void, rvecs: *const c_void, tvecs: *const c_void, per_view_errors: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_stereoCalibrate_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, e: *const c_void, f: *const c_void, rvecs: *const c_void, tvecs: *const c_void, per_view_errors: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_stereoCalibrate_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, e: *const c_void, f: *const c_void, per_view_errors: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_stereoCalibrate_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_Size_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, e: *const c_void, f: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_stereoCalibrate_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_Size_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, e: *const c_void, f: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_stereoRectifyUncalibrated_const__InputArrayR_const__InputArrayR_const__InputArrayR_Size_const__OutputArrayR_const__OutputArrayR(points1: *const c_void, points2: *const c_void, f: *const c_void, img_size: *const core::Size, h1: *const c_void, h2: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_stereoRectifyUncalibrated_const__InputArrayR_const__InputArrayR_const__InputArrayR_Size_const__OutputArrayR_const__OutputArrayR_double(points1: *const c_void, points2: *const c_void, f: *const c_void, img_size: *const core::Size, h1: *const c_void, h2: *const c_void, threshold: f64, ocvrs_return: *mut Result<bool>);
		pub fn cv_stereoRectify_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, r1: *const c_void, r2: *const c_void, p1: *const c_void, p2: *const c_void, q: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_stereoRectify_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_Size_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_double_Size_RectX_RectX(camera_matrix1: *const c_void, dist_coeffs1: *const c_void, camera_matrix2: *const c_void, dist_coeffs2: *const c_void, image_size: *const core::Size, r: *const c_void, t: *const c_void, r1: *const c_void, r2: *const c_void, p1: *const c_void, p2: *const c_void, q: *const c_void, flags: i32, alpha: f64, new_image_size: *const core::Size, valid_pix_roi1: *mut core::Rect, valid_pix_roi2: *mut core::Rect, ocvrs_return: *mut Result<()>);
		pub fn cv_triangulatePoints_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(proj_matr1: *const c_void, proj_matr2: *const c_void, proj_points1: *const c_void, proj_points2: *const c_void, points4_d: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_undistortImagePoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_undistortImagePoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_TermCriteria(src: *const c_void, dst: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, unnamed: *const core::TermCriteria, ocvrs_return: *mut Result<()>);
		pub fn cv_undistortPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_undistortPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, r: *const c_void, p: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_undistortPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_TermCriteria(src: *const c_void, dst: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, r: *const c_void, p: *const c_void, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<()>);
		pub fn cv_undistort_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_undistort_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, new_camera_matrix: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_validateDisparity_const__InputOutputArrayR_const__InputArrayR_int_int(disparity: *const c_void, cost: *const c_void, min_disparity: i32, number_of_disparities: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_validateDisparity_const__InputOutputArrayR_const__InputArrayR_int_int_int(disparity: *const c_void, cost: *const c_void, min_disparity: i32, number_of_disparities: i32, disp12_max_disp: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_CirclesGridFinderParameters_CirclesGridFinderParameters(ocvrs_return: *mut Result<crate::calib3d::CirclesGridFinderParameters>);
		pub fn cv_LMSolver_run_const_const__InputOutputArrayR(instance: *const c_void, param: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_LMSolver_setMaxIters_int(instance: *mut c_void, max_iters: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_LMSolver_getMaxIters_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_LMSolver_create_const_PtrLCallbackGR_int(cb: *const c_void, max_iters: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_LMSolver_create_const_PtrLCallbackGR_int_double(cb: *const c_void, max_iters: i32, eps: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_LMSolver_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_LMSolver_delete(instance: *mut c_void);
		pub fn cv_LMSolver_Callback_compute_const_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *const c_void, param: *const c_void, err: *const c_void, j: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_LMSolver_Callback_delete(instance: *mut c_void);
		pub fn cv_StereoBM_getPreFilterType_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoBM_setPreFilterType_int(instance: *mut c_void, pre_filter_type: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoBM_getPreFilterSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoBM_setPreFilterSize_int(instance: *mut c_void, pre_filter_size: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoBM_getPreFilterCap_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoBM_setPreFilterCap_int(instance: *mut c_void, pre_filter_cap: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoBM_getTextureThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoBM_setTextureThreshold_int(instance: *mut c_void, texture_threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoBM_getUniquenessRatio_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoBM_setUniquenessRatio_int(instance: *mut c_void, uniqueness_ratio: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoBM_getSmallerBlockSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoBM_setSmallerBlockSize_int(instance: *mut c_void, block_size: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoBM_getROI1_const(instance: *const c_void, ocvrs_return: *mut Result<core::Rect>);
		pub fn cv_StereoBM_setROI1_Rect(instance: *mut c_void, roi1: *const core::Rect, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoBM_getROI2_const(instance: *const c_void, ocvrs_return: *mut Result<core::Rect>);
		pub fn cv_StereoBM_setROI2_Rect(instance: *mut c_void, roi2: *const core::Rect, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoBM_create_int_int(num_disparities: i32, block_size: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_StereoBM_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_StereoBM_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_StereoBM_to_StereoMatcher(instance: *mut c_void) -> *mut c_void;
		pub fn cv_StereoBM_delete(instance: *mut c_void);
		pub fn cv_StereoMatcher_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, left: *const c_void, right: *const c_void, disparity: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoMatcher_getMinDisparity_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoMatcher_setMinDisparity_int(instance: *mut c_void, min_disparity: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoMatcher_getNumDisparities_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoMatcher_setNumDisparities_int(instance: *mut c_void, num_disparities: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoMatcher_getBlockSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoMatcher_setBlockSize_int(instance: *mut c_void, block_size: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoMatcher_getSpeckleWindowSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoMatcher_setSpeckleWindowSize_int(instance: *mut c_void, speckle_window_size: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoMatcher_getSpeckleRange_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoMatcher_setSpeckleRange_int(instance: *mut c_void, speckle_range: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoMatcher_getDisp12MaxDiff_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoMatcher_setDisp12MaxDiff_int(instance: *mut c_void, disp12_max_diff: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoMatcher_to_StereoBM(instance: *mut c_void) -> *mut c_void;
		pub fn cv_StereoMatcher_to_StereoSGBM(instance: *mut c_void) -> *mut c_void;
		pub fn cv_StereoMatcher_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_StereoMatcher_delete(instance: *mut c_void);
		pub fn cv_StereoSGBM_getPreFilterCap_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoSGBM_setPreFilterCap_int(instance: *mut c_void, pre_filter_cap: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoSGBM_getUniquenessRatio_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoSGBM_setUniquenessRatio_int(instance: *mut c_void, uniqueness_ratio: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoSGBM_getP1_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoSGBM_setP1_int(instance: *mut c_void, p1: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoSGBM_getP2_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoSGBM_setP2_int(instance: *mut c_void, p2: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoSGBM_getMode_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_StereoSGBM_setMode_int(instance: *mut c_void, mode: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_StereoSGBM_create_int_int_int_int_int_int_int_int_int_int_int(min_disparity: i32, num_disparities: i32, block_size: i32, p1: i32, p2: i32, disp12_max_diff: i32, pre_filter_cap: i32, uniqueness_ratio: i32, speckle_window_size: i32, speckle_range: i32, mode: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_StereoSGBM_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_StereoSGBM_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_StereoSGBM_to_StereoMatcher(instance: *mut c_void) -> *mut c_void;
		pub fn cv_StereoSGBM_delete(instance: *mut c_void);
		pub fn cv_UsacParams_UsacParams(ocvrs_return: *mut Result<crate::calib3d::UsacParams>);
		pub fn cv_PtrLcv_LMSolverG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_LMSolverG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_LMSolverG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_LMSolverG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_LMSolverG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_LMSolver_CallbackG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_LMSolver_CallbackG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_LMSolver_CallbackG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_LMSolver_CallbackG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_StereoBMG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_StereoBMG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_StereoBMG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_StereoBMG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_StereoBMG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_StereoBMG_to_PtrOfStereoMatcher(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_StereoMatcherG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_StereoMatcherG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_StereoMatcherG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_StereoMatcherG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_StereoMatcherG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_StereoSGBMG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_StereoSGBMG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_StereoSGBMG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_StereoSGBMG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_StereoSGBMG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_StereoSGBMG_to_PtrOfStereoMatcher(instance: *mut c_void) -> *mut c_void;
	}
}
pub use calib3d_sys::*;

mod ccalib_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_omnidir_calibrate_const__InputArrayR_const__InputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points: *const c_void, size: *const core::Size, k: *const c_void, xi: *const c_void, d: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_omnidir_calibrate_const__InputArrayR_const__InputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, size: *const core::Size, k: *const c_void, xi: *const c_void, d: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32, criteria: *const core::TermCriteria, idx: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_omnidir_initUndistortRectifyMap_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_SizeR_int_const__OutputArrayR_const__OutputArrayR_int(k: *const c_void, d: *const c_void, xi: *const c_void, r: *const c_void, p: *const c_void, size: *const core::Size, m1type: i32, map1: *const c_void, map2: *const c_void, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_omnidir_projectPoints_const__InputArrayR_const__OutputArrayR_const_Affine3dR_const__InputArrayR_double_const__InputArrayR(object_points: *const c_void, image_points: *const c_void, affine: *const core::Affine3d, k: *const c_void, xi: f64, d: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_omnidir_projectPoints_const__InputArrayR_const__OutputArrayR_const_Affine3dR_const__InputArrayR_double_const__InputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, affine: *const core::Affine3d, k: *const c_void, xi: f64, d: *const c_void, jacobian: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_omnidir_projectPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_double_const__InputArrayR(object_points: *const c_void, image_points: *const c_void, rvec: *const c_void, tvec: *const c_void, k: *const c_void, xi: f64, d: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_omnidir_projectPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_double_const__InputArrayR_const__OutputArrayR(object_points: *const c_void, image_points: *const c_void, rvec: *const c_void, tvec: *const c_void, k: *const c_void, xi: f64, d: *const c_void, jacobian: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_omnidir_stereoCalibrate_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const_SizeR_const_SizeR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, image_size1: *const core::Size, image_size2: *const core::Size, k1: *const c_void, xi1: *const c_void, d1: *const c_void, k2: *const c_void, xi2: *const c_void, d2: *const c_void, rvec: *const c_void, tvec: *const c_void, rvecs_l: *const c_void, tvecs_l: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_omnidir_stereoCalibrate_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const_SizeR_const_SizeR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria_const__OutputArrayR(object_points: *const c_void, image_points1: *const c_void, image_points2: *const c_void, image_size1: *const core::Size, image_size2: *const core::Size, k1: *const c_void, xi1: *const c_void, d1: *const c_void, k2: *const c_void, xi2: *const c_void, d2: *const c_void, rvec: *const c_void, tvec: *const c_void, rvecs_l: *const c_void, tvecs_l: *const c_void, flags: i32, criteria: *const core::TermCriteria, idx: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_omnidir_stereoReconstruct_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_int_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(image1: *const c_void, image2: *const c_void, k1: *const c_void, d1: *const c_void, xi1: *const c_void, k2: *const c_void, d2: *const c_void, xi2: *const c_void, r: *const c_void, t: *const c_void, flag: i32, num_disparities: i32, sad_window_size: i32, disparity: *const c_void, image1_rec: *const c_void, image2_rec: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_omnidir_stereoReconstruct_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_int_int_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const_SizeR_const__InputArrayR_const__OutputArrayR_int(image1: *const c_void, image2: *const c_void, k1: *const c_void, d1: *const c_void, xi1: *const c_void, k2: *const c_void, d2: *const c_void, xi2: *const c_void, r: *const c_void, t: *const c_void, flag: i32, num_disparities: i32, sad_window_size: i32, disparity: *const c_void, image1_rec: *const c_void, image2_rec: *const c_void, new_size: *const core::Size, knew: *const c_void, point_cloud: *const c_void, point_type: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_omnidir_stereoRectify_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(r: *const c_void, t: *const c_void, r1: *const c_void, r2: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_omnidir_undistortImage_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_int(distorted: *const c_void, undistorted: *const c_void, k: *const c_void, d: *const c_void, xi: *const c_void, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_omnidir_undistortImage_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_int_const__InputArrayR_const_SizeR_const__InputArrayR(distorted: *const c_void, undistorted: *const c_void, k: *const c_void, d: *const c_void, xi: *const c_void, flags: i32, knew: *const c_void, new_size: *const core::Size, r: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_omnidir_undistortPoints_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(distorted: *const c_void, undistorted: *const c_void, k: *const c_void, d: *const c_void, xi: *const c_void, r: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ccalib_CustomPattern_CustomPattern(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ccalib_CustomPattern_create_const__InputArrayR_const_Size2f_const__OutputArrayR(instance: *mut c_void, pattern: *const c_void, board_size: *const core::Size2f, output: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_create_const__InputArrayR_const_Size2f(instance: *mut c_void, pattern: *const c_void, board_size: *const core::Size2f, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_findPattern_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const_double_const_double_const_bool_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, matched_features: *const c_void, pattern_points: *const c_void, ratio: f64, proj_error: f64, refine_position: bool, out: *const c_void, h: *const c_void, pattern_corners: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_findPattern_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, matched_features: *const c_void, pattern_points: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_isInitialized(instance: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_getPatternPoints_vectorLKeyPointGR(instance: *mut c_void, original_points: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ccalib_CustomPattern_getPixelSize(instance: *mut c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_ccalib_CustomPattern_setFeatureDetector_PtrLFeature2DG(instance: *mut c_void, feature_detector: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_setDescriptorExtractor_PtrLFeature2DG(instance: *mut c_void, extractor: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_setDescriptorMatcher_PtrLDescriptorMatcherG(instance: *mut c_void, matcher: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_getFeatureDetector(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ccalib_CustomPattern_getDescriptorExtractor(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ccalib_CustomPattern_getDescriptorMatcher(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ccalib_CustomPattern_calibrate_const__InputArrayR_const__InputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(instance: *mut c_void, object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, flags: i32, criteria: *const core::TermCriteria, ocvrs_return: *mut Result<f64>);
		pub fn cv_ccalib_CustomPattern_calibrate_const__InputArrayR_const__InputArrayR_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, object_points: *const c_void, image_points: *const c_void, image_size: *const core::Size, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvecs: *const c_void, tvecs: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_ccalib_CustomPattern_findRt_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_bool_int(instance: *mut c_void, object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, flags: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_findRt_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR(instance: *mut c_void, object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_findRt_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_bool_int(instance: *mut c_void, image: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, flags: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_findRt_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR(instance: *mut c_void, image: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_findRtRANSAC_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_bool_int_float_int_const__OutputArrayR_int(instance: *mut c_void, object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, iterations_count: i32, reprojection_error: f32, min_inliers_count: i32, inliers: *const c_void, flags: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_findRtRANSAC_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR(instance: *mut c_void, object_points: *const c_void, image_points: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_findRtRANSAC_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_bool_int_float_int_const__OutputArrayR_int(instance: *mut c_void, image: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, use_extrinsic_guess: bool, iterations_count: i32, reprojection_error: f32, min_inliers_count: i32, inliers: *const c_void, flags: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_findRtRANSAC_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR(instance: *mut c_void, image: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, rvec: *const c_void, tvec: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ccalib_CustomPattern_drawOrientation_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_double_int(instance: *mut c_void, image: *const c_void, tvec: *const c_void, rvec: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, axis_length: f64, axis_width: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_ccalib_CustomPattern_drawOrientation_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(instance: *mut c_void, image: *const c_void, tvec: *const c_void, rvec: *const c_void, camera_matrix: *const c_void, dist_coeffs: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ccalib_CustomPattern_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_ccalib_CustomPattern_delete(instance: *mut c_void);
		pub fn cv_multicalib_MultiCameraCalibration_MultiCameraCalibration_int_int_const_stringR_float_float_int_int_int_int_TermCriteria_PtrLFeature2DG_PtrLFeature2DG_PtrLDescriptorMatcherG(camera_type: i32, n_cameras: i32, file_name: *const c_char, pattern_width: f32, pattern_height: f32, verbose: i32, show_extration: i32, n_mini_matches: i32, flags: i32, criteria: *const core::TermCriteria, detector: *mut c_void, descriptor: *mut c_void, matcher: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_multicalib_MultiCameraCalibration_MultiCameraCalibration_int_int_const_stringR_float_float(camera_type: i32, n_cameras: i32, file_name: *const c_char, pattern_width: f32, pattern_height: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_multicalib_MultiCameraCalibration_loadImages(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_multicalib_MultiCameraCalibration_initialize(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_multicalib_MultiCameraCalibration_optimizeExtrinsics(instance: *mut c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_multicalib_MultiCameraCalibration_run(instance: *mut c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_multicalib_MultiCameraCalibration_writeParameters_const_stringR(instance: *mut c_void, filename: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_multicalib_MultiCameraCalibration_delete(instance: *mut c_void);
		pub fn cv_multicalib_MultiCameraCalibration_edge_edge_int_int_int_Mat(cv: i32, pv: i32, pi: i32, trans: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_multicalib_MultiCameraCalibration_edge_propCameraVertex_const(instance: *const c_void) -> i32;
		pub fn cv_multicalib_MultiCameraCalibration_edge_propCameraVertex_const_int(instance: *mut c_void, val: i32);
		pub fn cv_multicalib_MultiCameraCalibration_edge_propPhotoVertex_const(instance: *const c_void) -> i32;
		pub fn cv_multicalib_MultiCameraCalibration_edge_propPhotoVertex_const_int(instance: *mut c_void, val: i32);
		pub fn cv_multicalib_MultiCameraCalibration_edge_propPhotoIndex_const(instance: *const c_void) -> i32;
		pub fn cv_multicalib_MultiCameraCalibration_edge_propPhotoIndex_const_int(instance: *mut c_void, val: i32);
		pub fn cv_multicalib_MultiCameraCalibration_edge_propTransform_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_multicalib_MultiCameraCalibration_edge_propTransform_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_multicalib_MultiCameraCalibration_edge_delete(instance: *mut c_void);
		pub fn cv_multicalib_MultiCameraCalibration_vertex_vertex_Mat_int(po: *mut c_void, ts: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_multicalib_MultiCameraCalibration_vertex_vertex(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_multicalib_MultiCameraCalibration_vertex_propPose_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_multicalib_MultiCameraCalibration_vertex_propPose_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_multicalib_MultiCameraCalibration_vertex_propTimestamp_const(instance: *const c_void) -> i32;
		pub fn cv_multicalib_MultiCameraCalibration_vertex_propTimestamp_const_int(instance: *mut c_void, val: i32);
		pub fn cv_multicalib_MultiCameraCalibration_vertex_delete(instance: *mut c_void);
		pub fn cv_randpattern_RandomPatternCornerFinder_RandomPatternCornerFinder_float_float_int_int_int_int_PtrLFeature2DG_PtrLFeature2DG_PtrLDescriptorMatcherG(pattern_width: f32, pattern_height: f32, nmini_match: i32, depth: i32, verbose: i32, show_extraction: i32, detector: *mut c_void, descriptor: *mut c_void, matcher: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_randpattern_RandomPatternCornerFinder_RandomPatternCornerFinder_float_float(pattern_width: f32, pattern_height: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_randpattern_RandomPatternCornerFinder_loadPattern_const_MatR(instance: *mut c_void, pattern_image: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_randpattern_RandomPatternCornerFinder_loadPattern_const_MatR_const_vectorLKeyPointGR_const_MatR(instance: *mut c_void, pattern_image: *const c_void, pattern_key_points: *const c_void, pattern_descriptors: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_randpattern_RandomPatternCornerFinder_computeObjectImagePoints_vectorLMatG(instance: *mut c_void, input_images: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_randpattern_RandomPatternCornerFinder_computeObjectImagePointsForSingle_Mat(instance: *mut c_void, input_image: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_randpattern_RandomPatternCornerFinder_getObjectPoints(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_randpattern_RandomPatternCornerFinder_getImagePoints(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_randpattern_RandomPatternCornerFinder_delete(instance: *mut c_void);
		pub fn cv_randpattern_RandomPatternGenerator_RandomPatternGenerator_int_int(image_width: i32, image_height: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_randpattern_RandomPatternGenerator_generatePattern(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_randpattern_RandomPatternGenerator_getPattern(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_randpattern_RandomPatternGenerator_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_ccalib_CustomPatternG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_ccalib_CustomPatternG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_ccalib_CustomPatternG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_ccalib_CustomPatternG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_ccalib_CustomPatternG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_ccalib_CustomPatternG_new_const_CustomPattern(val: *mut c_void) -> *mut c_void;
	}
}
pub use ccalib_sys::*;

mod core_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_Cholesky_doubleX_size_t_int_doubleX_size_t_int(a: *mut f64, astep: size_t, m: i32, b: *mut f64, bstep: size_t, n: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_Cholesky_floatX_size_t_int_floatX_size_t_int(a: *mut f32, astep: size_t, m: i32, b: *mut f32, bstep: size_t, n: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_LUT_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src: *const c_void, lut: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_LU_doubleX_size_t_int_doubleX_size_t_int(a: *mut f64, astep: size_t, m: i32, b: *mut f64, bstep: size_t, n: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_LU_floatX_size_t_int_floatX_size_t_int(a: *mut f32, astep: size_t, m: i32, b: *mut f32, bstep: size_t, n: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_Mahalanobis_const__InputArrayR_const__InputArrayR_const__InputArrayR(v1: *const c_void, v2: *const c_void, icovar: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_PCABackProject_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(data: *const c_void, mean: *const c_void, eigenvectors: *const c_void, result: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_PCACompute_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR(data: *const c_void, mean: *const c_void, eigenvectors: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_PCACompute_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR(data: *const c_void, mean: *const c_void, eigenvectors: *const c_void, eigenvalues: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_PCACompute_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_double(data: *const c_void, mean: *const c_void, eigenvectors: *const c_void, eigenvalues: *const c_void, retained_variance: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_PCACompute_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int(data: *const c_void, mean: *const c_void, eigenvectors: *const c_void, eigenvalues: *const c_void, max_components: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_PCACompute_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_double(data: *const c_void, mean: *const c_void, eigenvectors: *const c_void, retained_variance: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_PCACompute_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_int(data: *const c_void, mean: *const c_void, eigenvectors: *const c_void, max_components: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_PCAProject_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(data: *const c_void, mean: *const c_void, eigenvectors: *const c_void, result: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_PSNR_const__InputArrayR_const__InputArrayR(src1: *const c_void, src2: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_PSNR_const__InputArrayR_const__InputArrayR_double(src1: *const c_void, src2: *const c_void, r: f64, ocvrs_return: *mut Result<f64>);
		pub fn cv_SVBackSubst_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(w: *const c_void, u: *const c_void, vt: *const c_void, rhs: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SVDecomp_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, w: *const c_void, u: *const c_void, vt: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SVDecomp_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int(src: *const c_void, w: *const c_void, u: *const c_void, vt: *const c_void, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_abs_const_MatExprR(e: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_abs_const_MatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_absdiff_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_addWeighted_const__InputArrayR_double_const__InputArrayR_double_double_const__OutputArrayR(src1: *const c_void, alpha: f64, src2: *const c_void, beta: f64, gamma: f64, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_addWeighted_const__InputArrayR_double_const__InputArrayR_double_double_const__OutputArrayR_int(src1: *const c_void, alpha: f64, src2: *const c_void, beta: f64, gamma: f64, dst: *const c_void, dtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_add_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_add_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_int(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, dtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_batchDistance_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dist: *const c_void, dtype: i32, nidx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_batchDistance_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_const__OutputArrayR_int_int_const__InputArrayR_int_bool(src1: *const c_void, src2: *const c_void, dist: *const c_void, dtype: i32, nidx: *const c_void, norm_type: i32, k: i32, mask: *const c_void, update: i32, crosscheck: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_bitwise_and_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bitwise_and_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bitwise_not_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bitwise_not_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bitwise_or_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bitwise_or_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bitwise_xor_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_bitwise_xor_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_borderInterpolate_int_int_int(p: i32, len: i32, border_type: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_broadcast_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src: *const c_void, shape: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_calcCovarMatrix_const__InputArrayR_const__OutputArrayR_const__InputOutputArrayR_int(samples: *const c_void, covar: *const c_void, mean: *const c_void, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_calcCovarMatrix_const__InputArrayR_const__OutputArrayR_const__InputOutputArrayR_int_int(samples: *const c_void, covar: *const c_void, mean: *const c_void, flags: i32, ctype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cartToPolar_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(x: *const c_void, y: *const c_void, magnitude: *const c_void, angle: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cartToPolar_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool(x: *const c_void, y: *const c_void, magnitude: *const c_void, angle: *const c_void, angle_in_degrees: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_checkHardwareSupport_int(feature: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_checkRange_const__InputArrayR(a: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_checkRange_const__InputArrayR_bool_PointX_double_double(a: *const c_void, quiet: bool, pos: *mut core::Point, min_val: f64, max_val: f64, ocvrs_return: *mut Result<bool>);
		pub fn cv_compare_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int(src1: *const c_void, src2: *const c_void, dst: *const c_void, cmpop: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_completeSymm_const__InputOutputArrayR(m: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_completeSymm_const__InputOutputArrayR_bool(m: *const c_void, lower_to_upper: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_convertFp16_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_convertScaleAbs_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_convertScaleAbs_const__InputArrayR_const__OutputArrayR_double_double(src: *const c_void, dst: *const c_void, alpha: f64, beta: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_copyMakeBorder_const__InputArrayR_const__OutputArrayR_int_int_int_int_int(src: *const c_void, dst: *const c_void, top: i32, bottom: i32, left: i32, right: i32, border_type: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_copyMakeBorder_const__InputArrayR_const__OutputArrayR_int_int_int_int_int_const_ScalarR(src: *const c_void, dst: *const c_void, top: i32, bottom: i32, left: i32, right: i32, border_type: i32, value: *const core::Scalar, ocvrs_return: *mut Result<()>);
		pub fn cv_copyTo_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_countNonZero_const__InputArrayR(src: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cubeRoot_float(val: f32, ocvrs_return: *mut Result<f32>);
		pub fn cv_cuda_createContinuous_int_int_int_const__OutputArrayR(rows: i32, cols: i32, typ: i32, arr: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_createGpuMatFromCudaMemory_Size_int_size_t(size: *const core::Size, typ: i32, cuda_memory_address: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createGpuMatFromCudaMemory_Size_int_size_t_size_t(size: *const core::Size, typ: i32, cuda_memory_address: size_t, step: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createGpuMatFromCudaMemory_int_int_int_size_t(rows: i32, cols: i32, typ: i32, cuda_memory_address: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createGpuMatFromCudaMemory_int_int_int_size_t_size_t(rows: i32, cols: i32, typ: i32, cuda_memory_address: size_t, step: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_deviceSupports_FeatureSet(feature_set: core::FeatureSet, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_ensureSizeIsEnough_int_int_int_const__OutputArrayR(rows: i32, cols: i32, typ: i32, arr: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_getCudaEnabledDeviceCount(ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_getDevice(ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_printCudaDeviceInfo_int(device: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_printShortCudaDeviceInfo_int(device: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_registerPageLocked_MatR(m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_resetDevice(ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_setBufferPoolConfig_int_size_t_int(device_id: i32, stack_size: size_t, stack_count: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_setBufferPoolUsage_bool(on: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_setDevice_int(device: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_setGlDevice(ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_setGlDevice_int(device: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_unregisterPageLocked_MatR(m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_wrapStream_size_t(cuda_stream_memory_address: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dct_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dct_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_depthToString_int(depth: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_detail_check_failed_MatChannels_const_int_const_CheckContextR(v: i32, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_MatChannels_const_int_const_int_const_CheckContextR(v1: i32, v2: i32, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_MatDepth_const_int_const_CheckContextR(v: i32, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_MatDepth_const_int_const_int_const_CheckContextR(v1: i32, v2: i32, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_MatType_const_int_const_CheckContextR(v: i32, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_MatType_const_int_const_int_const_CheckContextR(v1: i32, v2: i32, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_auto_const_Size_LintG_const_CheckContextR(v: *const core::Size_<i32>, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_auto_const_Size_LintG_const_Size_LintG_const_CheckContextR(v1: *const core::Size_<i32>, v2: *const core::Size_<i32>, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_auto_const_bool_const_bool_const_CheckContextR(v1: bool, v2: bool, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_auto_const_double_const_CheckContextR(v: f64, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_auto_const_double_const_double_const_CheckContextR(v1: f64, v2: f64, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_auto_const_float_const_CheckContextR(v: f32, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_auto_const_float_const_float_const_CheckContextR(v1: f32, v2: f32, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_auto_const_int_const_CheckContextR(v: i32, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_auto_const_int_const_int_const_CheckContextR(v1: i32, v2: i32, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_auto_const_size_t_const_CheckContextR(v: size_t, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_auto_const_size_t_const_size_t_const_CheckContextR(v1: size_t, v2: size_t, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_auto_const_stringR_const_CheckContextR(v1: *const c_char, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_false_const_bool_const_CheckContextR(v: bool, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_detail_check_failed_true_const_bool_const_CheckContextR(v: bool, ctx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_determinant_const__InputArrayR(mtx: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_dft_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dft_const__InputArrayR_const__OutputArrayR_int_int(src: *const c_void, dst: *const c_void, flags: i32, nonzero_rows: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_directx_convertFromD3D10Texture2D_ID3D10Texture2DX_const__OutputArrayR(p_d3d10_texture_2d: *mut c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_directx_convertFromD3D11Texture2D_ID3D11Texture2DX_const__OutputArrayR(p_d3d11_texture_2d: *mut c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_directx_convertFromDirect3DSurface9_IDirect3DSurface9X_const__OutputArrayR(p_direct_3d_surface9: *mut c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_directx_convertFromDirect3DSurface9_IDirect3DSurface9X_const__OutputArrayR_voidX(p_direct_3d_surface9: *mut c_void, dst: *const c_void, surface_shared_handle: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_directx_convertToD3D10Texture2D_const__InputArrayR_ID3D10Texture2DX(src: *const c_void, p_d3d10_texture_2d: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_directx_convertToD3D11Texture2D_const__InputArrayR_ID3D11Texture2DX(src: *const c_void, p_d3d11_texture_2d: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_directx_convertToDirect3DSurface9_const__InputArrayR_IDirect3DSurface9X(src: *const c_void, p_direct_3d_surface9: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_directx_convertToDirect3DSurface9_const__InputArrayR_IDirect3DSurface9X_voidX(src: *const c_void, p_direct_3d_surface9: *mut c_void, surface_shared_handle: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_directx_getTypeFromD3DFORMAT_const_int(id_3d_format: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_directx_getTypeFromDXGI_FORMAT_const_int(i_dxgi_format: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_directx_ocl_initializeContextFromD3D10Device_ID3D10DeviceX(p_d3d10_device: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_directx_ocl_initializeContextFromD3D11Device_ID3D11DeviceX(p_d3d11_device: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_directx_ocl_initializeContextFromDirect3DDevice9Ex_IDirect3DDevice9ExX(p_direct_3d_device9_ex: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_directx_ocl_initializeContextFromDirect3DDevice9_IDirect3DDevice9X(p_direct_3d_device9: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_divide_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_divide_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_int(src1: *const c_void, src2: *const c_void, dst: *const c_void, scale: f64, dtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_divide_double_const__InputArrayR_const__OutputArrayR(scale: f64, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_divide_double_const__InputArrayR_const__OutputArrayR_int(scale: f64, src2: *const c_void, dst: *const c_void, dtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_eigenNonSymmetric_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, eigenvalues: *const c_void, eigenvectors: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_eigen_const__InputArrayR_const__OutputArrayR(src: *const c_void, eigenvalues: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_eigen_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, eigenvalues: *const c_void, eigenvectors: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_error_const_ExceptionR(exc: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_error_int_const_StringR_const_charX_const_charX_int(code: i32, err: *const c_char, func: *const c_char, file: *const c_char, line: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_exp_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_extractChannel_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, coi: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_fastAtan2_float_float(y: f32, x: f32, ocvrs_return: *mut Result<f32>);
		pub fn cv_findNonZero_const__InputArrayR_const__OutputArrayR(src: *const c_void, idx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_flipND_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, axis: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_flip_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, flip_code: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_gemm_const__InputArrayR_const__InputArrayR_double_const__InputArrayR_double_const__OutputArrayR(src1: *const c_void, src2: *const c_void, alpha: f64, src3: *const c_void, beta: f64, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_gemm_const__InputArrayR_const__InputArrayR_double_const__InputArrayR_double_const__OutputArrayR_int(src1: *const c_void, src2: *const c_void, alpha: f64, src3: *const c_void, beta: f64, dst: *const c_void, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_getBuildInformation(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_getCPUFeaturesLine(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_getCPUTickCount(ocvrs_return: *mut Result<i64>);
		pub fn cv_getDefaultAlgorithmHint(ocvrs_return: *mut Result<core::AlgorithmHint>);
		pub fn cv_getElemSize_int(typ: i32, ocvrs_return: *mut Result<size_t>);
		pub fn cv_getHardwareFeatureName_int(feature: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_getNumThreads(ocvrs_return: *mut Result<i32>);
		pub fn cv_getNumberOfCPUs(ocvrs_return: *mut Result<i32>);
		pub fn cv_getOptimalDFTSize_int(vecsize: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_getThreadNum(ocvrs_return: *mut Result<i32>);
		pub fn cv_getTickCount(ocvrs_return: *mut Result<i64>);
		pub fn cv_getTickFrequency(ocvrs_return: *mut Result<f64>);
		pub fn cv_getVersionMajor() -> i32;
		pub fn cv_getVersionMinor() -> i32;
		pub fn cv_getVersionRevision() -> i32;
		pub fn cv_getVersionString(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_glob_String_vectorLStringGR(pattern: *const c_char, result: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_glob_String_vectorLStringGR_bool(pattern: *const c_char, result: *mut c_void, recursive: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_hasNonZero_const__InputArrayR(src: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_haveOpenVX(ocvrs_return: *mut Result<bool>);
		pub fn cv_hconcat_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_hconcat_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_idct_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_idct_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_idft_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_idft_const__InputArrayR_const__OutputArrayR_int_int(src: *const c_void, dst: *const c_void, flags: i32, nonzero_rows: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_inRange_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src: *const c_void, lowerb: *const c_void, upperb: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_insertChannel_const__InputArrayR_const__InputOutputArrayR_int(src: *const c_void, dst: *const c_void, coi: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_instr_getFlags(ocvrs_return: *mut Result<core::FLAGS>);
		pub fn cv_instr_resetTrace(ocvrs_return: *mut Result<()>);
		pub fn cv_instr_setFlags_FLAGS(mode_flags: core::FLAGS, ocvrs_return: *mut Result<()>);
		pub fn cv_instr_setUseInstrumentation_bool(flag: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_instr_useInstrumentation(ocvrs_return: *mut Result<bool>);
		pub fn cv_invert_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_invert_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, flags: i32, ocvrs_return: *mut Result<f64>);
		pub fn cv_ipp_getIppErrorLocation(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ipp_getIppFeatures(ocvrs_return: *mut Result<u64>);
		pub fn cv_ipp_getIppStatus(ocvrs_return: *mut Result<i32>);
		pub fn cv_ipp_getIppVersion(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ipp_setIppStatus_int(status: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_ipp_setIppStatus_int_const_charX_const_charX_int(status: i32, funcname: *const c_char, filename: *const c_char, line: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_ipp_setUseIPP_NotExact_bool(flag: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ipp_setUseIPP_bool(flag: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ipp_useIPP(ocvrs_return: *mut Result<bool>);
		pub fn cv_ipp_useIPP_NotExact(ocvrs_return: *mut Result<bool>);
		pub fn cv_kmeans_const__InputArrayR_int_const__InputOutputArrayR_TermCriteria_int_int(data: *const c_void, k: i32, best_labels: *const c_void, criteria: *const core::TermCriteria, attempts: i32, flags: i32, ocvrs_return: *mut Result<f64>);
		pub fn cv_kmeans_const__InputArrayR_int_const__InputOutputArrayR_TermCriteria_int_int_const__OutputArrayR(data: *const c_void, k: i32, best_labels: *const c_void, criteria: *const core::TermCriteria, attempts: i32, flags: i32, centers: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_log_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_magnitude_const__InputArrayR_const__InputArrayR_const__OutputArrayR(x: *const c_void, y: *const c_void, magnitude: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_max_const_MatR_const_MatR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_max_const_MatR_const_MatR_MatR(src1: *const c_void, src2: *const c_void, dst: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_max_const_MatR_double(a: *const c_void, s: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_max_const_UMatR_const_UMatR_UMatR(src1: *const c_void, src2: *const c_void, dst: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_max_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_max_double_const_MatR(s: f64, a: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_meanStdDev_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, mean: *const c_void, stddev: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_meanStdDev_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__InputArrayR(src: *const c_void, mean: *const c_void, stddev: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_mean_const__InputArrayR(src: *const c_void, ocvrs_return: *mut Result<core::Scalar>);
		pub fn cv_mean_const__InputArrayR_const__InputArrayR(src: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<core::Scalar>);
		pub fn cv_merge_const__InputArrayR_const__OutputArrayR(mv: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_minMaxIdx_const__InputArrayR_doubleX(src: *const c_void, min_val: *mut f64, ocvrs_return: *mut Result<()>);
		pub fn cv_minMaxIdx_const__InputArrayR_doubleX_doubleX_intX_intX_const__InputArrayR(src: *const c_void, min_val: *mut f64, max_val: *mut f64, min_idx: *mut i32, max_idx: *mut i32, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_minMaxLoc_const_SparseMatR_doubleX_doubleX(a: *const c_void, min_val: *mut f64, max_val: *mut f64, ocvrs_return: *mut Result<()>);
		pub fn cv_minMaxLoc_const_SparseMatR_doubleX_doubleX_intX_intX(a: *const c_void, min_val: *mut f64, max_val: *mut f64, min_idx: *mut i32, max_idx: *mut i32, ocvrs_return: *mut Result<()>);
		pub fn cv_minMaxLoc_const__InputArrayR_doubleX(src: *const c_void, min_val: *mut f64, ocvrs_return: *mut Result<()>);
		pub fn cv_minMaxLoc_const__InputArrayR_doubleX_doubleX_PointX_PointX_const__InputArrayR(src: *const c_void, min_val: *mut f64, max_val: *mut f64, min_loc: *mut core::Point, max_loc: *mut core::Point, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_min_const_MatR_const_MatR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_min_const_MatR_const_MatR_MatR(src1: *const c_void, src2: *const c_void, dst: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_min_const_MatR_double(a: *const c_void, s: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_min_const_UMatR_const_UMatR_UMatR(src1: *const c_void, src2: *const c_void, dst: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_min_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_min_double_const_MatR(s: f64, a: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_mixChannels_const__InputArrayR_const__InputOutputArrayR_const_intX_size_t(src: *const c_void, dst: *const c_void, from_to: *const i32, npairs: size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_mixChannels_const__InputArrayR_const__InputOutputArrayR_const_vectorLintGR(src: *const c_void, dst: *const c_void, from_to: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_mulSpectrums_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int(a: *const c_void, b: *const c_void, c: *const c_void, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_mulSpectrums_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_bool(a: *const c_void, b: *const c_void, c: *const c_void, flags: i32, conj_b: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_mulTransposed_const__InputArrayR_const__OutputArrayR_bool(src: *const c_void, dst: *const c_void, a_ta: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_mulTransposed_const__InputArrayR_const__OutputArrayR_bool_const__InputArrayR_double_int(src: *const c_void, dst: *const c_void, a_ta: bool, delta: *const c_void, scale: f64, dtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_multiply_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_multiply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_int(src1: *const c_void, src2: *const c_void, dst: *const c_void, scale: f64, dtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_noArray() -> *mut c_void;
		pub fn cv_norm_const_SparseMatR_int(src: *const c_void, norm_type: i32, ocvrs_return: *mut Result<f64>);
		pub fn cv_norm_const__InputArrayR(src1: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_norm_const__InputArrayR_const__InputArrayR(src1: *const c_void, src2: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_norm_const__InputArrayR_const__InputArrayR_int_const__InputArrayR(src1: *const c_void, src2: *const c_void, norm_type: i32, mask: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_norm_const__InputArrayR_int_const__InputArrayR(src1: *const c_void, norm_type: i32, mask: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_normalize_const_SparseMatR_SparseMatR_double_int(src: *const c_void, dst: *mut c_void, alpha: f64, norm_type: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_normalize_const__InputArrayR_const__InputOutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_normalize_const__InputArrayR_const__InputOutputArrayR_double_double_int_int_const__InputArrayR(src: *const c_void, dst: *const c_void, alpha: f64, beta: f64, norm_type: i32, dtype: i32, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_attachContext_const_StringR_voidX_voidX_voidX(platform_name: *const c_char, platform_id: *mut c_void, context: *mut c_void, device_id: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_buildOptionsAddMatrixDescription_StringR_const_StringR_const__InputArrayR(build_options: *mut *mut c_void, name: *const c_char, _m: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_checkOptimalVectorWidth_const_intX_const__InputArrayR(vector_widths: *const i32, src1: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_checkOptimalVectorWidth_const_intX_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_OclVectorStrategy(vector_widths: *const i32, src1: *const c_void, src2: *const c_void, src3: *const c_void, src4: *const c_void, src5: *const c_void, src6: *const c_void, src7: *const c_void, src8: *const c_void, src9: *const c_void, strat: core::OclVectorStrategy, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_convertFromBuffer_voidX_size_t_int_int_int_UMatR(cl_mem_buffer: *mut c_void, step: size_t, rows: i32, cols: i32, typ: i32, dst: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_convertFromImage_voidX_UMatR(cl_mem_image: *mut c_void, dst: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_convertTypeStr_int_int_int_charX(sdepth: i32, ddepth: i32, cn: i32, buf: *mut *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_convertTypeStr_int_int_int_charX_size_t(sdepth: i32, ddepth: i32, cn: i32, buf: *mut *mut c_void, buf_size: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_finish(ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_getOpenCLErrorString_int(error_code: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_getPlatfomsInfo_vectorLPlatformInfoGR(platform_info: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_haveAmdBlas(ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_haveAmdFft(ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_haveOpenCL(ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_haveSVM(ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_kernelToStr_const__InputArrayR(_kernel: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_kernelToStr_const__InputArrayR_int_const_charX(_kernel: *const c_void, ddepth: i32, name: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_memopTypeToStr_int(t: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_predictOptimalVectorWidthMax_const__InputArrayR(src1: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_predictOptimalVectorWidthMax_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(src1: *const c_void, src2: *const c_void, src3: *const c_void, src4: *const c_void, src5: *const c_void, src6: *const c_void, src7: *const c_void, src8: *const c_void, src9: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_predictOptimalVectorWidth_const__InputArrayR(src1: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_predictOptimalVectorWidth_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_OclVectorStrategy(src1: *const c_void, src2: *const c_void, src3: *const c_void, src4: *const c_void, src5: *const c_void, src6: *const c_void, src7: *const c_void, src8: *const c_void, src9: *const c_void, strat: core::OclVectorStrategy, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_setUseOpenCL_bool(flag: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_typeToStr_int(t: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_useOpenCL(ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_vecopTypeToStr_int(t: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_convertFromGLTexture2D_const_Texture2DR_const__OutputArrayR(texture: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_convertToGLTexture2D_const__InputArrayR_Texture2DR(src: *const c_void, texture: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_mapGLBuffer_const_BufferR(buffer: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_mapGLBuffer_const_BufferR_AccessFlag(buffer: *const c_void, access_flags: core::AccessFlag, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_ocl_initializeContextFromGL(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_render_const_ArraysR(arr: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_render_const_ArraysR_const__InputArrayR(arr: *const c_void, indices: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_render_const_ArraysR_const__InputArrayR_int_Scalar(arr: *const c_void, indices: *const c_void, mode: i32, color: *const core::Scalar, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_render_const_ArraysR_int_Scalar(arr: *const c_void, mode: i32, color: *const core::Scalar, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_render_const_Texture2DR(tex: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_render_const_Texture2DR_Rect_LdoubleG_Rect_LdoubleG(tex: *const c_void, wnd_rect: *const core::Rect_<f64>, tex_rect: *const core::Rect_<f64>, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_unmapGLBuffer_UMatR(u: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_operatorA_const_MatExprR_const_MatExprR(e1: *const c_void, e2: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorA_const_MatExprR_const_MatR(e: *const c_void, m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorA_const_MatExprR_const_ScalarR(e: *const c_void, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorA_const_MatR_const_MatExprR(m: *const c_void, e: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorA_const_MatR_const_MatR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorA_const_MatR_const_ScalarR(a: *const c_void, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorA_const_ScalarR_const_MatExprR(s: *const core::Scalar, e: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorA_const_ScalarR_const_MatR(s: *const core::Scalar, a: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorD_const_MatExprR_const_MatExprR(e1: *const c_void, e2: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorD_const_MatExprR_const_MatR(e: *const c_void, m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorD_const_MatExprR_double(e: *const c_void, s: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorD_const_MatR_const_MatExprR(m: *const c_void, e: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorD_const_MatR_const_MatR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorD_const_MatR_double(a: *const c_void, s: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorD_double_const_MatExprR(s: f64, e: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorD_double_const_MatR(s: f64, a: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorEQ_const_FileNodeIteratorR_const_FileNodeIteratorR(it1: *const c_void, it2: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_operatorEQ_const_MatR_const_MatR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorEQ_const_MatR_double(a: *const c_void, s: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorEQ_double_const_MatR(s: f64, a: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorGE_const_MatR_const_MatR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorGE_const_MatR_double(a: *const c_void, s: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorGE_double_const_MatR(s: f64, a: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorG_const_MatR_const_MatR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorG_const_MatR_double(a: *const c_void, s: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorG_double_const_MatR(s: f64, a: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorLE_const_MatR_const_MatR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorLE_const_MatR_double(a: *const c_void, s: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorLE_double_const_MatR(s: f64, a: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorL_const_MatR_const_MatR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorL_const_MatR_double(a: *const c_void, s: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorL_double_const_MatR(s: f64, a: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorNE_const_FileNodeIteratorR_const_FileNodeIteratorR(it1: *const c_void, it2: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_operatorNE_const_MatR_const_MatR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorNE_const_MatR_double(a: *const c_void, s: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorNE_double_const_MatR(s: f64, a: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorNOTB_const_MatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorOR_const_MatR_const_MatR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorOR_const_MatR_const_ScalarR(a: *const c_void, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorOR_const_ScalarR_const_MatR(s: *const core::Scalar, a: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorR_const_MatR_const_MatR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorR_const_MatR_const_ScalarR(a: *const c_void, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorR_const_ScalarR_const_MatR(s: *const core::Scalar, a: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorS_const_MatExprR(e: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorS_const_MatExprR_const_MatExprR(e1: *const c_void, e2: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorS_const_MatExprR_const_MatR(e: *const c_void, m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorS_const_MatExprR_const_ScalarR(e: *const c_void, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorS_const_MatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorS_const_MatR_const_MatExprR(m: *const c_void, e: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorS_const_MatR_const_MatR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorS_const_MatR_const_ScalarR(a: *const c_void, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorS_const_ScalarR_const_MatExprR(s: *const core::Scalar, e: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorS_const_ScalarR_const_MatR(s: *const core::Scalar, a: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorXOR_const_MatR_const_MatR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorXOR_const_MatR_const_ScalarR(a: *const c_void, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorXOR_const_ScalarR_const_MatR(s: *const core::Scalar, a: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorX_const_MatExprR_const_MatExprR(e1: *const c_void, e2: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorX_const_MatExprR_const_MatR(e: *const c_void, m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorX_const_MatExprR_double(e: *const c_void, s: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorX_const_MatR_const_MatExprR(m: *const c_void, e: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorX_const_MatR_const_MatR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorX_const_MatR_double(a: *const c_void, s: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorX_double_const_MatExprR(s: f64, e: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_operatorX_double_const_MatR(s: f64, a: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_parallel_for__const_RangeR_const_ParallelLoopBodyR(range: *const c_void, body: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_parallel_for__const_RangeR_const_ParallelLoopBodyR_double(range: *const c_void, body: *const c_void, nstripes: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_patchNaNs_const__InputOutputArrayR(a: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_patchNaNs_const__InputOutputArrayR_double(a: *const c_void, val: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_perspectiveTransform_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, m: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_phase_const__InputArrayR_const__InputArrayR_const__OutputArrayR(x: *const c_void, y: *const c_void, angle: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_phase_const__InputArrayR_const__InputArrayR_const__OutputArrayR_bool(x: *const c_void, y: *const c_void, angle: *const c_void, angle_in_degrees: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_polarToCart_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(magnitude: *const c_void, angle: *const c_void, x: *const c_void, y: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_polarToCart_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool(magnitude: *const c_void, angle: *const c_void, x: *const c_void, y: *const c_void, angle_in_degrees: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_pow_const__InputArrayR_double_const__OutputArrayR(src: *const c_void, power: f64, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_randShuffle_const__InputOutputArrayR(dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_randShuffle_const__InputOutputArrayR_double_RNGX(dst: *const c_void, iter_factor: f64, rng: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_randn_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR(dst: *const c_void, mean: *const c_void, stddev: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_randu_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR(dst: *const c_void, low: *const c_void, high: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_read_const_FileNodeR_DMatchR_const_DMatchR(node: *const c_void, value: *mut core::DMatch, default_value: *const core::DMatch, ocvrs_return: *mut Result<()>);
		pub fn cv_read_const_FileNodeR_KeyPointR_const_KeyPointR(node: *const c_void, value: *mut c_void, default_value: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_read_const_FileNodeR_MatR(node: *const c_void, mat: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_read_const_FileNodeR_MatR_const_MatR(node: *const c_void, mat: *mut c_void, default_mat: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_read_const_FileNodeR_SparseMatR(node: *const c_void, mat: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_read_const_FileNodeR_SparseMatR_const_SparseMatR(node: *const c_void, mat: *mut c_void, default_mat: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_read_const_FileNodeR_doubleR_double(node: *const c_void, value: *mut f64, default_value: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_read_const_FileNodeR_floatR_float(node: *const c_void, value: *mut f32, default_value: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_read_const_FileNodeR_int64_tR_int64_t(node: *const c_void, value: *mut i64, default_value: i64, ocvrs_return: *mut Result<()>);
		pub fn cv_read_const_FileNodeR_intR_int(node: *const c_void, value: *mut i32, default_value: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_read_const_FileNodeR_stringR_const_stringR(node: *const c_void, value: *mut *mut c_void, default_value: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_read_const_FileNodeR_vectorLDMatchGR(node: *const c_void, matches: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_read_const_FileNodeR_vectorLKeyPointGR(node: *const c_void, keypoints: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_rectangleIntersectionArea_const_Rect2dR_const_Rect2dR(a: *const core::Rect2d, b: *const core::Rect2d, ocvrs_return: *mut Result<f64>);
		pub fn cv_reduceArgMax_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, axis: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_reduceArgMax_const__InputArrayR_const__OutputArrayR_int_bool(src: *const c_void, dst: *const c_void, axis: i32, last_index: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_reduceArgMin_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, axis: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_reduceArgMin_const__InputArrayR_const__OutputArrayR_int_bool(src: *const c_void, dst: *const c_void, axis: i32, last_index: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_reduce_const__InputArrayR_const__OutputArrayR_int_int(src: *const c_void, dst: *const c_void, dim: i32, rtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_reduce_const__InputArrayR_const__OutputArrayR_int_int_int(src: *const c_void, dst: *const c_void, dim: i32, rtype: i32, dtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_repeat_const_MatR_int_int(src: *const c_void, ny: i32, nx: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_repeat_const__InputArrayR_int_int_const__OutputArrayR(src: *const c_void, ny: i32, nx: i32, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_rotate_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, rotate_code: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_samples_addSamplesDataSearchPath_const_StringR(path: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_samples_addSamplesDataSearchSubDirectory_const_StringR(subdir: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_samples_findFileOrKeep_const_StringR(relative_path: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_samples_findFileOrKeep_const_StringR_bool(relative_path: *const c_char, silent_mode: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_samples_findFile_const_StringR(relative_path: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_samples_findFile_const_StringR_bool_bool(relative_path: *const c_char, required: bool, silent_mode: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_scaleAdd_const__InputArrayR_double_const__InputArrayR_const__OutputArrayR(src1: *const c_void, alpha: f64, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_setBreakOnError_bool(flag: bool, ocvrs_return: *mut Result<bool>);
		pub fn cv_setIdentity_const__InputOutputArrayR(mtx: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_setIdentity_const__InputOutputArrayR_const_ScalarR(mtx: *const c_void, s: *const core::Scalar, ocvrs_return: *mut Result<()>);
		pub fn cv_setNumThreads_int(nthreads: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_setRNGSeed_int(seed: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_setUseOpenVX_bool(flag: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_setUseOptimized_bool(onoff: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_solveCubic_const__InputArrayR_const__OutputArrayR(coeffs: *const c_void, roots: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_solveLP_const__InputArrayR_const__InputArrayR_const__OutputArrayR(func: *const c_void, constr: *const c_void, z: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_solveLP_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double(func: *const c_void, constr: *const c_void, z: *const c_void, constr_eps: f64, ocvrs_return: *mut Result<i32>);
		pub fn cv_solvePoly_const__InputArrayR_const__OutputArrayR(coeffs: *const c_void, roots: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_solvePoly_const__InputArrayR_const__OutputArrayR_int(coeffs: *const c_void, roots: *const c_void, max_iters: i32, ocvrs_return: *mut Result<f64>);
		pub fn cv_solve_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_solve_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int(src1: *const c_void, src2: *const c_void, dst: *const c_void, flags: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_sortIdx_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_sort_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_split_const_MatR_MatX(src: *const c_void, mvbegin: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_split_const__InputArrayR_const__OutputArrayR(m: *const c_void, mv: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_sqrt_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_subtract_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_subtract_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_int(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, dtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_sum_const__InputArrayR(src: *const c_void, ocvrs_return: *mut Result<core::Scalar>);
		pub fn cv_swap_MatR_MatR(a: *mut c_void, b: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_swap_UMatR_UMatR(a: *mut c_void, b: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_tempfile(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_tempfile_const_charX(suffix: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_terminate_int_const_StringR_const_charX_const_charX_int(code: i32, err: *const c_char, func: *const c_char, file: *const c_char, line: i32);
		pub fn cv_theRNG(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_trace_const__InputArrayR(mtx: *const c_void, ocvrs_return: *mut Result<core::Scalar>);
		pub fn cv_transform_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, m: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_transposeND_const__InputArrayR_const_vectorLintGR_const__OutputArrayR(src: *const c_void, order: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_transpose_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_typeToString_int(typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_useOpenVX(ocvrs_return: *mut Result<bool>);
		pub fn cv_useOptimized(ocvrs_return: *mut Result<bool>);
		pub fn cv_utils_copyMatAndDumpNamedArguments_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_copyMatAndDumpNamedArguments_const__InputArrayR_const__OutputArrayR_const_FunctionParamsR(src: *const c_void, dst: *const c_void, params: *const core::FunctionParams, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpBool_bool(argument: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpCString_const_charX(argument: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpDouble_double(argument: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpFloat_float(argument: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpInputArrayOfArrays_const__InputArrayR(argument: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpInputArray_const__InputArrayR(argument: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpInputOutputArrayOfArrays_const__InputOutputArrayR(argument: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpInputOutputArray_const__InputOutputArrayR(argument: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpInt64_int64_t(argument: i64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpInt_int(argument: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpRange_const_RangeR(argument: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpRect_const_RectR(argument: *const core::Rect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpRotatedRect_const_RotatedRectR(argument: *const core::RotatedRect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpSizeT_size_t(argument: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpString_const_StringR(argument: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpTermCriteria_const_TermCriteriaR(argument: *const core::TermCriteria, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpVec2i(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpVec2i_const_Vec2i(value: *const core::Vec2i, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpVectorOfDouble_const_vectorLdoubleGR(vec: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpVectorOfInt_const_vectorLintGR(vec: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_dumpVectorOfRect_const_vectorLRectGR(vec: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_fs_getCacheDirectoryForDownloads(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_generateVectorOfInt_size_t_vectorLintGR(len: size_t, vec: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_utils_generateVectorOfMat_size_t_int_int_int_vectorLMatGR(len: size_t, rows: i32, cols: i32, dtype: i32, vec: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_utils_generateVectorOfRect_size_t_vectorLRectGR(len: size_t, vec: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_utils_getThreadID(ocvrs_return: *mut Result<i32>);
		pub fn cv_utils_logging_getLogLevel(ocvrs_return: *mut Result<core::LogLevel>);
		pub fn cv_utils_logging_getLogTagLevel_const_charX(tag: *const c_char, ocvrs_return: *mut Result<core::LogLevel>);
		pub fn cv_utils_logging_internal_getGlobalLogTag(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_logging_internal_replaceWriteLogMessageEx_WriteLogMessageExFuncType(f: Option<unsafe extern "C" fn(core::LogLevel, *const c_char, *const c_char, i32, *const c_char, *const c_char) -> ()>, ocvrs_return: *mut Result<()>);
		pub fn cv_utils_logging_internal_replaceWriteLogMessage_WriteLogMessageFuncType(f: Option<unsafe extern "C" fn(core::LogLevel, *const c_char) -> ()>, ocvrs_return: *mut Result<()>);
		pub fn cv_utils_logging_internal_writeLogMessageEx_LogLevel_const_charX_const_charX_int_const_charX_const_charX(log_level: core::LogLevel, tag: *const c_char, file: *const c_char, line: i32, func: *const c_char, message: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_utils_logging_internal_writeLogMessage_LogLevel_const_charX(log_level: core::LogLevel, message: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_utils_logging_registerLogTag_LogTagX(plogtag: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_utils_logging_setLogLevel_LogLevel(log_level: core::LogLevel, ocvrs_return: *mut Result<core::LogLevel>);
		pub fn cv_utils_logging_setLogTagLevel_const_charX_LogLevel(tag: *const c_char, level: core::LogLevel, ocvrs_return: *mut Result<()>);
		pub fn cv_utils_nested_testEchoBooleanFunction_bool(flag: bool, ocvrs_return: *mut Result<bool>);
		pub fn cv_utils_testAsyncArray_const__InputArrayR(argument: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_testAsyncException(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_testOverloadResolution_const_RectR(rect: *const core::Rect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_testOverloadResolution_int(value: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_testOverloadResolution_int_const_PointR(value: i32, point: *const core::Point, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_testOverwriteNativeMethod_int(argument: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_utils_testRaiseGeneralException(ocvrs_return: *mut Result<()>);
		pub fn cv_utils_testReservedKeywordConversion_int(positional_argument: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_testReservedKeywordConversion_int_int_int(positional_argument: i32, lambda: i32, from: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_testRotatedRectVector_float_float_float_float_float(x: f32, y: f32, w: f32, h: f32, angle: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_testRotatedRect_float_float_float_float_float(x: f32, y: f32, w: f32, h: f32, angle: f32, ocvrs_return: *mut Result<core::RotatedRect>);
		pub fn cv_va_intel_convertFromVASurface_VADisplay_VASurfaceID_Size_const__OutputArrayR(display: core::VADisplay, surface: core::VASurfaceID, size: *const core::Size, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_va_intel_convertToVASurface_VADisplay_const__InputArrayR_VASurfaceID_Size(display: core::VADisplay, src: *const c_void, surface: core::VASurfaceID, size: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_va_intel_ocl_initializeContextFromVA_VADisplay(display: core::VADisplay, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_va_intel_ocl_initializeContextFromVA_VADisplay_bool(display: core::VADisplay, try_interop: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_vconcat_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_vconcat_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_writeScalar_FileStorageR_const_StringR(fs: *mut c_void, value: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_writeScalar_FileStorageR_double(fs: *mut c_void, value: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_writeScalar_FileStorageR_float(fs: *mut c_void, value: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_writeScalar_FileStorageR_int(fs: *mut c_void, value: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_writeScalar_FileStorageR_int64_t(fs: *mut c_void, value: i64, ocvrs_return: *mut Result<()>);
		pub fn cv_write_FileStorageR_const_StringR_const_MatR(fs: *mut c_void, name: *const c_char, value: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_write_FileStorageR_const_StringR_const_SparseMatR(fs: *mut c_void, name: *const c_char, value: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_write_FileStorageR_const_StringR_const_StringR(fs: *mut c_void, name: *const c_char, value: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_write_FileStorageR_const_StringR_const_vectorLDMatchGR(fs: *mut c_void, name: *const c_char, value: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_write_FileStorageR_const_StringR_const_vectorLKeyPointGR(fs: *mut c_void, name: *const c_char, value: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_write_FileStorageR_const_StringR_double(fs: *mut c_void, name: *const c_char, value: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_write_FileStorageR_const_StringR_float(fs: *mut c_void, name: *const c_char, value: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_write_FileStorageR_const_StringR_int(fs: *mut c_void, name: *const c_char, value: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_write_FileStorageR_const_StringR_int64_t(fs: *mut c_void, name: *const c_char, value: i64, ocvrs_return: *mut Result<()>);
		pub fn cv_Algorithm_Algorithm(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Algorithm_clear(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Algorithm_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Algorithm_write_const_FileStorageR_const_StringR(instance: *const c_void, fs: *mut c_void, name: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_Algorithm_write_const_const_PtrLFileStorageGR_const_StringR(instance: *const c_void, fs: *const c_void, name: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_Algorithm_write_const_const_PtrLFileStorageGR(instance: *const c_void, fs: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Algorithm_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Algorithm_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_Algorithm_save_const_const_StringR(instance: *const c_void, filename: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_Algorithm_getDefaultName_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Algorithm_to_ConjGradSolver(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Algorithm_to_DownhillSolver(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Algorithm_to_MinProblemSolver(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Algorithm_delete(instance: *mut c_void);
		pub fn cv_AsyncArray_AsyncArray() -> *mut c_void;
		pub fn cv_AsyncArray_AsyncArray_const_AsyncArrayR(o: *const c_void) -> *mut c_void;
		pub fn cv_AsyncArray_operatorST_const_AsyncArrayR(instance: *mut c_void, o: *const c_void);
		pub fn cv_AsyncArray_release(instance: *mut c_void);
		pub fn cv_AsyncArray_get_const_const__OutputArrayR(instance: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_AsyncArray_get_const_const__OutputArrayR_int64_t(instance: *const c_void, dst: *const c_void, timeout_ns: i64, ocvrs_return: *mut Result<bool>);
		pub fn cv_AsyncArray_get_const_const__OutputArrayR_double(instance: *const c_void, dst: *const c_void, timeout_ns: f64, ocvrs_return: *mut Result<bool>);
		pub fn cv_AsyncArray_wait_for_const_int64_t(instance: *const c_void, timeout_ns: i64, ocvrs_return: *mut Result<bool>);
		pub fn cv_AsyncArray_wait_for_const_double(instance: *const c_void, timeout_ns: f64, ocvrs_return: *mut Result<bool>);
		pub fn cv_AsyncArray_valid_const(instance: *const c_void) -> bool;
		pub fn cv_AsyncArray_AsyncArray_AsyncArrayRR(o: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_AsyncArray_operatorST_AsyncArrayRR(instance: *mut c_void, o: *mut c_void);
		pub fn cv_AsyncArray_delete(instance: *mut c_void);
		pub fn cv_AsyncPromise_AsyncPromise() -> *mut c_void;
		pub fn cv_AsyncPromise_AsyncPromise_const_AsyncPromiseR(o: *const c_void) -> *mut c_void;
		pub fn cv_AsyncPromise_operatorST_const_AsyncPromiseR(instance: *mut c_void, o: *const c_void);
		pub fn cv_AsyncPromise_release(instance: *mut c_void);
		pub fn cv_AsyncPromise_getArrayResult(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_AsyncPromise_setValue_const__InputArrayR(instance: *mut c_void, value: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_AsyncPromise_setException_const_ExceptionR(instance: *mut c_void, exception: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_AsyncPromise_AsyncPromise_AsyncPromiseRR(o: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_AsyncPromise_operatorST_AsyncPromiseRR(instance: *mut c_void, o: *mut c_void);
		pub fn cv_AsyncPromise__getImpl_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_AsyncPromise_delete(instance: *mut c_void);
		pub fn cv_CommandLineParser_CommandLineParser_int_const_charXX_const_StringR(argc: i32, argv: *const *const c_char, keys: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_CommandLineParser_CommandLineParser_const_CommandLineParserR(parser: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_CommandLineParser_operatorST_const_CommandLineParserR(instance: *mut c_void, parser: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_CommandLineParser_getPathToApplication_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_CommandLineParser_get_bool_const_const_StringR_bool(instance: *const c_void, name: *const c_char, space_delete: bool, ocvrs_return: *mut Result<bool>);
		pub fn cv_CommandLineParser_get_bool_const_const_StringR(instance: *const c_void, name: *const c_char, ocvrs_return: *mut Result<bool>);
		pub fn cv_CommandLineParser_get_int_const_const_StringR_bool(instance: *const c_void, name: *const c_char, space_delete: bool, ocvrs_return: *mut Result<i32>);
		pub fn cv_CommandLineParser_get_int_const_const_StringR(instance: *const c_void, name: *const c_char, ocvrs_return: *mut Result<i32>);
		pub fn cv_CommandLineParser_get_double_const_const_StringR_bool(instance: *const c_void, name: *const c_char, space_delete: bool, ocvrs_return: *mut Result<f64>);
		pub fn cv_CommandLineParser_get_double_const_const_StringR(instance: *const c_void, name: *const c_char, ocvrs_return: *mut Result<f64>);
		pub fn cv_CommandLineParser_get_cv_String_const_const_StringR_bool(instance: *const c_void, name: *const c_char, space_delete: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_CommandLineParser_get_cv_String_const_const_StringR(instance: *const c_void, name: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_CommandLineParser_get_uint64_t_const_const_StringR_bool(instance: *const c_void, name: *const c_char, space_delete: bool, ocvrs_return: *mut Result<u64>);
		pub fn cv_CommandLineParser_get_uint64_t_const_const_StringR(instance: *const c_void, name: *const c_char, ocvrs_return: *mut Result<u64>);
		pub fn cv_CommandLineParser_get_bool_const_int_bool(instance: *const c_void, index: i32, space_delete: bool, ocvrs_return: *mut Result<bool>);
		pub fn cv_CommandLineParser_get_bool_const_int(instance: *const c_void, index: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_CommandLineParser_get_int_const_int_bool(instance: *const c_void, index: i32, space_delete: bool, ocvrs_return: *mut Result<i32>);
		pub fn cv_CommandLineParser_get_int_const_int(instance: *const c_void, index: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_CommandLineParser_get_double_const_int_bool(instance: *const c_void, index: i32, space_delete: bool, ocvrs_return: *mut Result<f64>);
		pub fn cv_CommandLineParser_get_double_const_int(instance: *const c_void, index: i32, ocvrs_return: *mut Result<f64>);
		pub fn cv_CommandLineParser_get_cv_String_const_int_bool(instance: *const c_void, index: i32, space_delete: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_CommandLineParser_get_cv_String_const_int(instance: *const c_void, index: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_CommandLineParser_get_uint64_t_const_int_bool(instance: *const c_void, index: i32, space_delete: bool, ocvrs_return: *mut Result<u64>);
		pub fn cv_CommandLineParser_get_uint64_t_const_int(instance: *const c_void, index: i32, ocvrs_return: *mut Result<u64>);
		pub fn cv_CommandLineParser_has_const_const_StringR(instance: *const c_void, name: *const c_char, ocvrs_return: *mut Result<bool>);
		pub fn cv_CommandLineParser_check_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_CommandLineParser_about_const_StringR(instance: *mut c_void, message: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_CommandLineParser_printMessage_const(instance: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_CommandLineParser_printErrors_const(instance: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_CommandLineParser_delete(instance: *mut c_void);
		pub fn cv_ConjGradSolver_create_const_PtrLFunctionGR_TermCriteria(f: *const c_void, termcrit: *const core::TermCriteria, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ConjGradSolver_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ConjGradSolver_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_ConjGradSolver_to_MinProblemSolver(instance: *mut c_void) -> *mut c_void;
		pub fn cv_ConjGradSolver_delete(instance: *mut c_void);
		pub fn cv_DMatch_DMatch(ocvrs_return: *mut Result<core::DMatch>);
		pub fn cv_DMatch_DMatch_int_int_float(_query_idx: i32, _train_idx: i32, _distance: f32, ocvrs_return: *mut Result<core::DMatch>);
		pub fn cv_DMatch_DMatch_int_int_int_float(_query_idx: i32, _train_idx: i32, _img_idx: i32, _distance: f32, ocvrs_return: *mut Result<core::DMatch>);
		pub fn cv_DMatch_operatorL_const_const_DMatchR(instance: *const core::DMatch, m: *const core::DMatch, ocvrs_return: *mut Result<bool>);
		pub fn cv_DownhillSolver_getInitStep_const_const__OutputArrayR(instance: *const c_void, step: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_DownhillSolver_setInitStep_const__InputArrayR(instance: *mut c_void, step: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_DownhillSolver_create_const_PtrLFunctionGR_const__InputArrayR_TermCriteria(f: *const c_void, init_step: *const c_void, termcrit: *const core::TermCriteria, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_DownhillSolver_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_DownhillSolver_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_DownhillSolver_to_MinProblemSolver(instance: *mut c_void) -> *mut c_void;
		pub fn cv_DownhillSolver_delete(instance: *mut c_void);
		pub fn cv_Exception_Exception(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Exception_Exception_int_const_StringR_const_StringR_const_StringR_int(_code: i32, _err: *const c_char, _func: *const c_char, _file: *const c_char, _line: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Exception_what_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_Exception_formatMessage(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Exception_propMsg_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_Exception_propMsg_const_String(instance: *mut c_void, val: *const c_char);
		pub fn cv_Exception_propCode_const(instance: *const c_void) -> i32;
		pub fn cv_Exception_propCode_const_int(instance: *mut c_void, val: i32);
		pub fn cv_Exception_propErr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_Exception_propErr_const_String(instance: *mut c_void, val: *const c_char);
		pub fn cv_Exception_propFunc_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_Exception_propFunc_const_String(instance: *mut c_void, val: *const c_char);
		pub fn cv_Exception_propFile_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_Exception_propFile_const_String(instance: *mut c_void, val: *const c_char);
		pub fn cv_Exception_propLine_const(instance: *const c_void) -> i32;
		pub fn cv_Exception_propLine_const_int(instance: *mut c_void, val: i32);
		pub fn cv_Exception_delete(instance: *mut c_void);
		pub fn cv_FileNode_FileNode(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNode_FileNode_const_FileStorageX_size_t_size_t(fs: *const c_void, block_idx: size_t, ofs: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNode_FileNode_const_FileNodeR(node: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNode_operatorST_const_FileNodeR(instance: *mut c_void, node: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_FileNode_operator___const_const_StringR(instance: *const c_void, nodename: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNode_operator___const_const_charX(instance: *const c_void, nodename: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNode_operator___const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNode_keys_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNode_type_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_FileNode_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileNode_isNone_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileNode_isSeq_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileNode_isMap_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileNode_isInt_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileNode_isReal_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileNode_isString_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileNode_isNamed_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileNode_name_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNode_size_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_FileNode_rawSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_FileNode_operator_int_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_FileNode_operator_int64_t_const(instance: *const c_void, ocvrs_return: *mut Result<i64>);
		pub fn cv_FileNode_operator_float_const(instance: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_FileNode_operator_double_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_FileNode_operator_std_string_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNode_isMap_int(flags: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileNode_isSeq_int(flags: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileNode_isCollection_int(flags: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileNode_isEmptyCollection_int(flags: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileNode_isFlow_int(flags: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileNode_ptr(instance: *mut c_void, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_FileNode_ptr_const(instance: *const c_void, ocvrs_return: *mut Result<*const u8>);
		pub fn cv_FileNode_begin_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNode_end_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNode_readRaw_const_const_StringR_voidX_size_t(instance: *const c_void, fmt: *const c_char, vec: *mut c_void, len: size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_FileNode_setValue_int_const_voidX_int(instance: *mut c_void, typ: i32, value: *const c_void, len: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_FileNode_real_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_FileNode_string_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNode_mat_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNode_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_FileNode_propBlockIdx_const(instance: *const c_void) -> size_t;
		pub fn cv_FileNode_propBlockIdx_const_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_FileNode_propOfs_const(instance: *const c_void) -> size_t;
		pub fn cv_FileNode_propOfs_const_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_FileNode_delete(instance: *mut c_void);
		pub fn cv_FileNodeIterator_FileNodeIterator(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNodeIterator_FileNodeIterator_const_FileNodeR_bool(node: *const c_void, seek_end: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNodeIterator_FileNodeIterator_const_FileNodeIteratorR(it: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNodeIterator_operatorST_const_FileNodeIteratorR(instance: *mut c_void, it: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_FileNodeIterator_operatorX_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNodeIterator_operatorAA(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNodeIterator_readRaw_const_StringR_voidX_size_t(instance: *mut c_void, fmt: *const c_char, vec: *mut c_void, len: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileNodeIterator_remaining_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_FileNodeIterator_equalTo_const_const_FileNodeIteratorR(instance: *const c_void, it: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileNodeIterator_delete(instance: *mut c_void);
		pub fn cv_FileStorage_FileStorage(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileStorage_FileStorage_const_StringR_int_const_StringR(filename: *const c_char, flags: i32, encoding: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileStorage_FileStorage_const_StringR_int(filename: *const c_char, flags: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileStorage_open_const_StringR_int_const_StringR(instance: *mut c_void, filename: *const c_char, flags: i32, encoding: *const c_char, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileStorage_open_const_StringR_int(instance: *mut c_void, filename: *const c_char, flags: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileStorage_isOpened_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_FileStorage_release(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_FileStorage_releaseAndGetString(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileStorage_getFirstTopLevelNode_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileStorage_root_const_int(instance: *const c_void, streamidx: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileStorage_root_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileStorage_operator___const_const_StringR(instance: *const c_void, nodename: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileStorage_operator___const_const_charX(instance: *const c_void, nodename: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileStorage_write_const_StringR_int(instance: *mut c_void, name: *const c_char, val: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_FileStorage_write_const_StringR_int64_t(instance: *mut c_void, name: *const c_char, val: i64, ocvrs_return: *mut Result<()>);
		pub fn cv_FileStorage_write_const_StringR_double(instance: *mut c_void, name: *const c_char, val: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_FileStorage_write_const_StringR_const_StringR(instance: *mut c_void, name: *const c_char, val: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_FileStorage_write_const_StringR_const_MatR(instance: *mut c_void, name: *const c_char, val: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_FileStorage_write_const_StringR_const_vectorLStringGR(instance: *mut c_void, name: *const c_char, val: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_FileStorage_writeRaw_const_StringR_const_voidX_size_t(instance: *mut c_void, fmt: *const c_char, vec: *const c_void, len: size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_FileStorage_writeComment_const_StringR_bool(instance: *mut c_void, comment: *const c_char, append: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_FileStorage_writeComment_const_StringR(instance: *mut c_void, comment: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_FileStorage_startWriteStruct_const_StringR_int_const_StringR(instance: *mut c_void, name: *const c_char, flags: i32, type_name: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_FileStorage_startWriteStruct_const_StringR_int(instance: *mut c_void, name: *const c_char, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_FileStorage_endWriteStruct(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_FileStorage_getDefaultObjectName_const_StringR(filename: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FileStorage_getFormat_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_FileStorage_propState_const(instance: *const c_void) -> i32;
		pub fn cv_FileStorage_propState_const_int(instance: *mut c_void, val: i32);
		pub fn cv_FileStorage_propElname_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_FileStorage_propElname_const_string(instance: *mut c_void, val: *const c_char);
		pub fn cv_FileStorage_delete(instance: *mut c_void);
		pub fn cv_Formatted_next(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Formatted_reset(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Formatted_delete(instance: *mut c_void);
		pub fn cv_Formatter_format_const_const_MatR(instance: *const c_void, mtx: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Formatter_set16fPrecision_int(instance: *mut c_void, p: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_Formatter_set16fPrecision(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Formatter_set32fPrecision_int(instance: *mut c_void, p: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_Formatter_set32fPrecision(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Formatter_set64fPrecision_int(instance: *mut c_void, p: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_Formatter_set64fPrecision(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Formatter_setMultiline_bool(instance: *mut c_void, ml: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_Formatter_setMultiline(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Formatter_get_FormatType(fmt: core::Formatter_FormatType, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Formatter_get(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Formatter_delete(instance: *mut c_void);
		pub fn cv_Hamming_operator___const_const_unsigned_charX_const_unsigned_charX_int(instance: *const c_void, a: *const u8, b: *const u8, size: i32, ocvrs_return: *mut Result<core::Hamming_ResultType>);
		pub fn cv_Hamming_defaultNew_const() -> *mut c_void;
		pub fn cv_Hamming_delete(instance: *mut c_void);
		pub fn cv_KeyPoint_KeyPoint(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_KeyPoint_KeyPoint_Point2f_float_float_float_int_int(pt: *const core::Point2f, size: f32, angle: f32, response: f32, octave: i32, class_id: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_KeyPoint_KeyPoint_Point2f_float(pt: *const core::Point2f, size: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_KeyPoint_KeyPoint_float_float_float_float_float_int_int(x: f32, y: f32, size: f32, angle: f32, response: f32, octave: i32, class_id: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_KeyPoint_KeyPoint_float_float_float(x: f32, y: f32, size: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_KeyPoint_hash_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_KeyPoint_convert_const_vectorLKeyPointGR_vectorLPoint2fGR_const_vectorLintGR(keypoints: *const c_void, points2f: *mut c_void, keypoint_indexes: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_KeyPoint_convert_const_vectorLKeyPointGR_vectorLPoint2fGR(keypoints: *const c_void, points2f: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_KeyPoint_convert_const_vectorLPoint2fGR_vectorLKeyPointGR_float_float_int_int(points2f: *const c_void, keypoints: *mut c_void, size: f32, response: f32, octave: i32, class_id: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_KeyPoint_convert_const_vectorLPoint2fGR_vectorLKeyPointGR(points2f: *const c_void, keypoints: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_KeyPoint_overlap_const_KeyPointR_const_KeyPointR(kp1: *const c_void, kp2: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_KeyPoint_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_KeyPoint_propPt_const(instance: *const c_void, ocvrs_return: *mut core::Point2f);
		pub fn cv_KeyPoint_propPt_const_Point2f(instance: *mut c_void, val: *const core::Point2f);
		pub fn cv_KeyPoint_propSize_const(instance: *const c_void) -> f32;
		pub fn cv_KeyPoint_propSize_const_float(instance: *mut c_void, val: f32);
		pub fn cv_KeyPoint_propAngle_const(instance: *const c_void) -> f32;
		pub fn cv_KeyPoint_propAngle_const_float(instance: *mut c_void, val: f32);
		pub fn cv_KeyPoint_propResponse_const(instance: *const c_void) -> f32;
		pub fn cv_KeyPoint_propResponse_const_float(instance: *mut c_void, val: f32);
		pub fn cv_KeyPoint_propOctave_const(instance: *const c_void) -> i32;
		pub fn cv_KeyPoint_propOctave_const_int(instance: *mut c_void, val: i32);
		pub fn cv_KeyPoint_propClass_id_const(instance: *const c_void) -> i32;
		pub fn cv_KeyPoint_propClass_id_const_int(instance: *mut c_void, val: i32);
		pub fn cv_KeyPoint_delete(instance: *mut c_void);
		pub fn cv_LDA_LDA_int(num_components: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_LDA_LDA(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_LDA_LDA_const__InputArrayR_const__InputArrayR_int(src: *const c_void, labels: *const c_void, num_components: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_LDA_LDA_const__InputArrayR_const__InputArrayR(src: *const c_void, labels: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_LDA_save_const_const_StringR(instance: *const c_void, filename: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_LDA_load_const_StringR(instance: *mut c_void, filename: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_LDA_save_const_FileStorageR(instance: *const c_void, fs: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_LDA_load_const_FileStorageR(instance: *mut c_void, node: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_LDA_compute_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, labels: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_LDA_project_const__InputArrayR(instance: *mut c_void, src: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_LDA_reconstruct_const__InputArrayR(instance: *mut c_void, src: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_LDA_eigenvectors_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_LDA_eigenvalues_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_LDA_subspaceProject_const__InputArrayR_const__InputArrayR_const__InputArrayR(w: *const c_void, mean: *const c_void, src: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_LDA_subspaceReconstruct_const__InputArrayR_const__InputArrayR_const__InputArrayR(w: *const c_void, mean: *const c_void, src: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_LDA_delete(instance: *mut c_void);
		pub fn cv_Mat_Mat() -> *mut c_void;
		pub fn cv_Mat_Mat_int_int_int(rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_Size_int(size: *const core::Size, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_int_int_int_const_ScalarR(rows: i32, cols: i32, typ: i32, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_Size_int_const_ScalarR(size: *const core::Size, typ: i32, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_int_const_intX_int(ndims: i32, sizes: *const i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_const_vectorLintGR_int(sizes: *const c_void, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_int_const_intX_int_const_ScalarR(ndims: i32, sizes: *const i32, typ: i32, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_const_vectorLintGR_int_const_ScalarR(sizes: *const c_void, typ: i32, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_const_MatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_MatR(m: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_int_int_int_voidX_size_t(rows: i32, cols: i32, typ: i32, data: *mut c_void, step: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_int_int_int_voidX(rows: i32, cols: i32, typ: i32, data: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_Size_int_voidX_size_t(size: *const core::Size, typ: i32, data: *mut c_void, step: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_Size_int_voidX(size: *const core::Size, typ: i32, data: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_int_const_intX_int_voidX_const_size_tX(ndims: i32, sizes: *const i32, typ: i32, data: *mut c_void, steps: *const size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_int_const_intX_int_voidX(ndims: i32, sizes: *const i32, typ: i32, data: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_const_vectorLintGR_int_voidX_const_size_tX(sizes: *const c_void, typ: i32, data: *mut c_void, steps: *const size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_const_vectorLintGR_int_voidX(sizes: *const c_void, typ: i32, data: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_const_MatR_const_RangeR_const_RangeR(m: *const c_void, row_range: *const c_void, col_range: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_MatR_const_RangeR(m: *mut c_void, row_range: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_const_MatR_const_RangeR(m: *const c_void, row_range: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_MatR_const_RangeR_const_RangeR(m: *mut c_void, row_range: *const c_void, col_range: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_const_MatR_const_RectR(m: *const c_void, roi: *const core::Rect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_MatR_const_RectR(m: *mut c_void, roi: *const core::Rect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_const_MatR_const_vectorLRangeGR(m: *const c_void, ranges: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_MatR_const_vectorLRangeGR(m: *mut c_void, ranges: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_Mat_const_GpuMatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_operatorST_const_MatExprR(instance: *mut c_void, expr: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_getUMat_const_AccessFlag_UMatUsageFlags(instance: *const c_void, access_flags: core::AccessFlag, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_getUMat_const_AccessFlag(instance: *const c_void, access_flags: core::AccessFlag, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_row_const_int(instance: *const c_void, y: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_row_int(instance: *mut c_void, y: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_col_const_int(instance: *const c_void, x: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_col_int(instance: *mut c_void, x: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_rowRange_const_int_int(instance: *const c_void, startrow: i32, endrow: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_rowRange_int_int(instance: *mut c_void, startrow: i32, endrow: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_rowRange_const_const_RangeR(instance: *const c_void, r: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_rowRange_const_RangeR(instance: *mut c_void, r: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_colRange_const_int_int(instance: *const c_void, startcol: i32, endcol: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_colRange_int_int(instance: *mut c_void, startcol: i32, endcol: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_colRange_const_const_RangeR(instance: *const c_void, r: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_colRange_const_RangeR(instance: *mut c_void, r: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_diag_const_int(instance: *const c_void, d: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_diag(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_diag_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_diag_int(instance: *mut c_void, d: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_diag_const_MatR(d: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_clone_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_copyTo_const_const__OutputArrayR(instance: *const c_void, m: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_copyTo_const_const__OutputArrayR_const__InputArrayR(instance: *const c_void, m: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_copyAt_const_const__OutputArrayR(instance: *const c_void, m: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_copyAt_const_const__OutputArrayR_const__InputArrayR(instance: *const c_void, m: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_convertTo_const_const__OutputArrayR_int_double_double(instance: *const c_void, m: *const c_void, rtype: i32, alpha: f64, beta: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_convertTo_const_const__OutputArrayR_int(instance: *const c_void, m: *const c_void, rtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_assignTo_const_MatR_int(instance: *const c_void, m: *mut c_void, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_assignTo_const_MatR(instance: *const c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_operatorST_const_ScalarR(instance: *mut c_void, s: *const core::Scalar, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_setTo_const__InputArrayR_const__InputArrayR(instance: *mut c_void, value: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_setTo_const__InputArrayR(instance: *mut c_void, value: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_reshape_const_int_int(instance: *const c_void, cn: i32, rows: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_reshape_int(instance: *mut c_void, cn: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_reshape_const_int(instance: *const c_void, cn: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_reshape_int_int(instance: *mut c_void, cn: i32, rows: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_reshape_const_int_int_const_intX(instance: *const c_void, cn: i32, newndims: i32, newsz: *const i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_reshape_int_int_const_intX(instance: *mut c_void, cn: i32, newndims: i32, newsz: *const i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_reshape_const_int_const_vectorLintGR(instance: *const c_void, cn: i32, newshape: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_reshape_int_const_vectorLintGR(instance: *mut c_void, cn: i32, newshape: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_reinterpret_const_int(instance: *const c_void, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_t_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_inv_const_int(instance: *const c_void, method: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_inv_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_mul_const_const__InputArrayR_double(instance: *const c_void, m: *const c_void, scale: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_mul_const_const__InputArrayR(instance: *const c_void, m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_cross_const_const__InputArrayR(instance: *const c_void, m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_dot_const_const__InputArrayR(instance: *const c_void, m: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_Mat_zeros_int_int_int(rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_zeros_Size_int(size: *const core::Size, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_zeros_int_const_intX_int(ndims: i32, sz: *const i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_ones_int_int_int(rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_ones_Size_int(size: *const core::Size, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_ones_int_const_intX_int(ndims: i32, sz: *const i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_eye_int_int_int(rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_eye_Size_int(size: *const core::Size, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_create_int_int_int(instance: *mut c_void, rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_create_Size_int(instance: *mut c_void, size: *const core::Size, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_create_int_const_intX_int(instance: *mut c_void, ndims: i32, sizes: *const i32, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_create_const_vectorLintGR_int(instance: *mut c_void, sizes: *const c_void, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_addref(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_release(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_deallocate(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_reserve_size_t(instance: *mut c_void, sz: size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_reserveBuffer_size_t(instance: *mut c_void, sz: size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_resize_size_t(instance: *mut c_void, sz: size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_resize_size_t_const_ScalarR(instance: *mut c_void, sz: size_t, s: *const core::Scalar, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_push_back_const_MatR(instance: *mut c_void, m: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_pop_back_size_t(instance: *mut c_void, nelems: size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_pop_back(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_locateROI_const_SizeR_PointR(instance: *const c_void, whole_size: *mut core::Size, ofs: *mut core::Point, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_adjustROI_int_int_int_int(instance: *mut c_void, dtop: i32, dbottom: i32, dleft: i32, dright: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_operator___const_Range_Range(instance: *const c_void, row_range: *mut c_void, col_range: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_operator___Range_Range(instance: *mut c_void, row_range: *mut c_void, col_range: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_operator___const_const_RectR(instance: *const c_void, roi: *const core::Rect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_operator___const_RectR(instance: *mut c_void, roi: *const core::Rect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_operator___const_const_vectorLRangeGR(instance: *const c_void, ranges: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_operator___const_vectorLRangeGR(instance: *mut c_void, ranges: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_isContinuous_const(instance: *const c_void) -> bool;
		pub fn cv_Mat_isSubmatrix_const(instance: *const c_void) -> bool;
		pub fn cv_Mat_elemSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_Mat_elemSize1_const(instance: *const c_void) -> size_t;
		pub fn cv_Mat_type_const(instance: *const c_void) -> i32;
		pub fn cv_Mat_depth_const(instance: *const c_void) -> i32;
		pub fn cv_Mat_channels_const(instance: *const c_void) -> i32;
		pub fn cv_Mat_step1_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<size_t>);
		pub fn cv_Mat_step1_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_Mat_empty_const(instance: *const c_void) -> bool;
		pub fn cv_Mat_total_const(instance: *const c_void) -> size_t;
		pub fn cv_Mat_total_const_int_int(instance: *const c_void, start_dim: i32, end_dim: i32, ocvrs_return: *mut Result<size_t>);
		pub fn cv_Mat_total_const_int(instance: *const c_void, start_dim: i32, ocvrs_return: *mut Result<size_t>);
		pub fn cv_Mat_checkVector_const_int_int_bool(instance: *const c_void, elem_channels: i32, depth: i32, require_continuous: bool, ocvrs_return: *mut Result<i32>);
		pub fn cv_Mat_checkVector_const_int(instance: *const c_void, elem_channels: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_Mat_ptr_int(instance: *mut c_void, i0: i32, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_Mat_ptr(instance: *mut c_void, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_Mat_ptr_const_int(instance: *const c_void, i0: i32, ocvrs_return: *mut Result<*const u8>);
		pub fn cv_Mat_ptr_const(instance: *const c_void, ocvrs_return: *mut Result<*const u8>);
		pub fn cv_Mat_ptr_int_int(instance: *mut c_void, row: i32, col: i32, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_Mat_ptr_const_int_int(instance: *const c_void, row: i32, col: i32, ocvrs_return: *mut Result<*const u8>);
		pub fn cv_Mat_ptr_int_int_int(instance: *mut c_void, i0: i32, i1: i32, i2: i32, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_Mat_ptr_const_int_int_int(instance: *const c_void, i0: i32, i1: i32, i2: i32, ocvrs_return: *mut Result<*const u8>);
		pub fn cv_Mat_ptr_const_intX(instance: *mut c_void, idx: *const i32, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_Mat_ptr_const_const_intX(instance: *const c_void, idx: *const i32, ocvrs_return: *mut Result<*const u8>);
		pub fn cv_Mat_operatorST_MatRR(instance: *mut c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_updateContinuityFlag(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Mat_size_const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_Mat_getDataDump_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Mat_propFlags_const(instance: *const c_void) -> i32;
		pub fn cv_Mat_propFlags_const_int(instance: *mut c_void, val: i32);
		pub fn cv_Mat_propDims_const(instance: *const c_void) -> i32;
		pub fn cv_Mat_propDims_const_int(instance: *mut c_void, val: i32);
		pub fn cv_Mat_propRows_const(instance: *const c_void) -> i32;
		pub fn cv_Mat_propRows_const_int(instance: *mut c_void, val: i32);
		pub fn cv_Mat_propCols_const(instance: *const c_void) -> i32;
		pub fn cv_Mat_propCols_const_int(instance: *mut c_void, val: i32);
		pub fn cv_Mat_propData_const(instance: *const c_void) -> *const u8;
		pub fn cv_Mat_propData(instance: *mut c_void) -> *mut u8;
		pub fn cv_Mat_propData_unsigned_charX(instance: *mut c_void, val: *const u8);
		pub fn cv_Mat_propDatastart_const(instance: *const c_void) -> *const u8;
		pub fn cv_Mat_propDataend_const(instance: *const c_void) -> *const u8;
		pub fn cv_Mat_propDatalimit_const(instance: *const c_void) -> *const u8;
		pub fn cv_Mat_propU(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Mat_propU_UMatDataX(instance: *mut c_void, val: *const c_void);
		pub fn cv_Mat_propSize_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_Mat_propSize_const_MatSize(instance: *mut c_void, val: *const c_void);
		pub fn cv_Mat_propStep_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_Mat_delete(instance: *mut c_void);
		pub fn cv_MatConstIterator_MatConstIterator(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatConstIterator_MatConstIterator_const_MatX(_m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatConstIterator_MatConstIterator_const_MatX_int_int(_m: *const c_void, _row: i32, _col: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatConstIterator_MatConstIterator_const_MatX_int(_m: *const c_void, _row: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatConstIterator_MatConstIterator_const_MatX_Point(_m: *const c_void, _pt: *const core::Point, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatConstIterator_MatConstIterator_const_MatConstIteratorR(it: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatConstIterator_operatorST_const_MatConstIteratorR(instance: *mut c_void, it: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatConstIterator_operatorX_const(instance: *const c_void, ocvrs_return: *mut Result<*const u8>);
		pub fn cv_MatConstIterator_operator___const_ptrdiff_t(instance: *const c_void, i: ptrdiff_t, ocvrs_return: *mut Result<*const u8>);
		pub fn cv_MatConstIterator_operatorSS(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatConstIterator_operatorAA(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatConstIterator_pos_const(instance: *const c_void, ocvrs_return: *mut Result<core::Point>);
		pub fn cv_MatConstIterator_pos_const_intX(instance: *const c_void, _idx: *mut i32, ocvrs_return: *mut Result<()>);
		pub fn cv_MatConstIterator_lpos_const(instance: *const c_void, ocvrs_return: *mut Result<ptrdiff_t>);
		pub fn cv_MatConstIterator_seek_ptrdiff_t_bool(instance: *mut c_void, ofs: ptrdiff_t, relative: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_MatConstIterator_seek_ptrdiff_t(instance: *mut c_void, ofs: ptrdiff_t, ocvrs_return: *mut Result<()>);
		pub fn cv_MatConstIterator_seek_const_intX_bool(instance: *mut c_void, _idx: *const i32, relative: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_MatConstIterator_seek_const_intX(instance: *mut c_void, _idx: *const i32, ocvrs_return: *mut Result<()>);
		pub fn cv_MatConstIterator_type_const(instance: *const c_void) -> i32;
		pub fn cv_MatConstIterator_propM_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_MatConstIterator_propElemSize_const(instance: *const c_void) -> size_t;
		pub fn cv_MatConstIterator_propElemSize_const_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_MatConstIterator_propPtr_const(instance: *const c_void) -> *const u8;
		pub fn cv_MatConstIterator_propSliceStart_const(instance: *const c_void) -> *const u8;
		pub fn cv_MatConstIterator_propSliceEnd_const(instance: *const c_void) -> *const u8;
		pub fn cv_MatConstIterator_delete(instance: *mut c_void);
		pub fn cv_MatExpr_MatExpr(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_MatExpr_const_MatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_MatExpr_const_MatOpX_int_const_MatR_const_MatR_const_MatR_double_double_const_ScalarR(_op: *const c_void, _flags: i32, _a: *const c_void, _b: *const c_void, _c: *const c_void, _alpha: f64, _beta: f64, _s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_MatExpr_const_MatOpX_int(_op: *const c_void, _flags: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_operator_cv_Mat_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_size_const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_MatExpr_type_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_MatExpr_row_const_int(instance: *const c_void, y: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_col_const_int(instance: *const c_void, x: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_diag_const_int(instance: *const c_void, d: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_diag_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_operator___const_const_RangeR_const_RangeR(instance: *const c_void, row_range: *const c_void, col_range: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_operator___const_const_RectR(instance: *const c_void, roi: *const core::Rect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_t_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_inv_const_int(instance: *const c_void, method: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_inv_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_mul_const_const_MatExprR_double(instance: *const c_void, e: *const c_void, scale: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_mul_const_const_MatExprR(instance: *const c_void, e: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_mul_const_const_MatR_double(instance: *const c_void, m: *const c_void, scale: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_mul_const_const_MatR(instance: *const c_void, m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_cross_const_const_MatR(instance: *const c_void, m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MatExpr_dot_const_const_MatR(instance: *const c_void, m: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_MatExpr_swap_MatExprR(instance: *mut c_void, b: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatExpr_propFlags_const(instance: *const c_void) -> i32;
		pub fn cv_MatExpr_propFlags_const_int(instance: *mut c_void, val: i32);
		pub fn cv_MatExpr_propA_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_MatExpr_propA_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_MatExpr_propB_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_MatExpr_propB_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_MatExpr_propC_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_MatExpr_propC_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_MatExpr_propAlpha_const(instance: *const c_void) -> f64;
		pub fn cv_MatExpr_propAlpha_const_double(instance: *mut c_void, val: f64);
		pub fn cv_MatExpr_propBeta_const(instance: *const c_void) -> f64;
		pub fn cv_MatExpr_propBeta_const_double(instance: *mut c_void, val: f64);
		pub fn cv_MatExpr_propS_const(instance: *const c_void, ocvrs_return: *mut core::Scalar);
		pub fn cv_MatExpr_propS_const_Scalar(instance: *mut c_void, val: *const core::Scalar);
		pub fn cv_MatExpr_delete(instance: *mut c_void);
		pub fn cv_MatOp_elementWise_const_const_MatExprR(instance: *const c_void, expr: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_MatOp_assign_const_const_MatExprR_MatR_int(instance: *const c_void, expr: *const c_void, m: *mut c_void, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_assign_const_const_MatExprR_MatR(instance: *const c_void, expr: *const c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_roi_const_const_MatExprR_const_RangeR_const_RangeR_MatExprR(instance: *const c_void, expr: *const c_void, row_range: *const c_void, col_range: *const c_void, res: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_diag_const_const_MatExprR_int_MatExprR(instance: *const c_void, expr: *const c_void, d: i32, res: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_augAssignAdd_const_const_MatExprR_MatR(instance: *const c_void, expr: *const c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_augAssignSubtract_const_const_MatExprR_MatR(instance: *const c_void, expr: *const c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_augAssignMultiply_const_const_MatExprR_MatR(instance: *const c_void, expr: *const c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_augAssignDivide_const_const_MatExprR_MatR(instance: *const c_void, expr: *const c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_augAssignAnd_const_const_MatExprR_MatR(instance: *const c_void, expr: *const c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_augAssignOr_const_const_MatExprR_MatR(instance: *const c_void, expr: *const c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_augAssignXor_const_const_MatExprR_MatR(instance: *const c_void, expr: *const c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_add_const_const_MatExprR_const_MatExprR_MatExprR(instance: *const c_void, expr1: *const c_void, expr2: *const c_void, res: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_add_const_const_MatExprR_const_ScalarR_MatExprR(instance: *const c_void, expr1: *const c_void, s: *const core::Scalar, res: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_subtract_const_const_MatExprR_const_MatExprR_MatExprR(instance: *const c_void, expr1: *const c_void, expr2: *const c_void, res: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_subtract_const_const_ScalarR_const_MatExprR_MatExprR(instance: *const c_void, s: *const core::Scalar, expr: *const c_void, res: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_multiply_const_const_MatExprR_const_MatExprR_MatExprR_double(instance: *const c_void, expr1: *const c_void, expr2: *const c_void, res: *mut c_void, scale: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_multiply_const_const_MatExprR_const_MatExprR_MatExprR(instance: *const c_void, expr1: *const c_void, expr2: *const c_void, res: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_multiply_const_const_MatExprR_double_MatExprR(instance: *const c_void, expr1: *const c_void, s: f64, res: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_divide_const_const_MatExprR_const_MatExprR_MatExprR_double(instance: *const c_void, expr1: *const c_void, expr2: *const c_void, res: *mut c_void, scale: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_divide_const_const_MatExprR_const_MatExprR_MatExprR(instance: *const c_void, expr1: *const c_void, expr2: *const c_void, res: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_divide_const_double_const_MatExprR_MatExprR(instance: *const c_void, s: f64, expr: *const c_void, res: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_abs_const_const_MatExprR_MatExprR(instance: *const c_void, expr: *const c_void, res: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_transpose_const_const_MatExprR_MatExprR(instance: *const c_void, expr: *const c_void, res: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_matmul_const_const_MatExprR_const_MatExprR_MatExprR(instance: *const c_void, expr1: *const c_void, expr2: *const c_void, res: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_invert_const_const_MatExprR_int_MatExprR(instance: *const c_void, expr: *const c_void, method: i32, res: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MatOp_size_const_const_MatExprR(instance: *const c_void, expr: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_MatOp_type_const_const_MatExprR(instance: *const c_void, expr: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_MatOp_delete(instance: *mut c_void);
		pub fn cv_MatSize_MatSize_intX(_p: *mut i32) -> *mut c_void;
		pub fn cv_MatSize_dims_const(instance: *const c_void) -> i32;
		pub fn cv_MatSize_operator___const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_MatSize_operator___const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_MatSize_operator___int(instance: *mut c_void, i: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_MatSize_operator_const_intX_const(instance: *const c_void) -> *const i32;
		pub fn cv_MatSize_operatorEQ_const_const_MatSizeR(instance: *const c_void, sz: *const c_void) -> bool;
		pub fn cv_MatSize_operatorNE_const_const_MatSizeR(instance: *const c_void, sz: *const c_void) -> bool;
		pub fn cv_MatSize_propP_const(instance: *const c_void) -> *const i32;
		pub fn cv_MatSize_propP(instance: *mut c_void) -> *mut i32;
		pub fn cv_MatSize_propP_intX(instance: *mut c_void, val: *const i32);
		pub fn cv_MatSize_delete(instance: *mut c_void);
		pub fn cv_MatStep_MatStep() -> *mut c_void;
		pub fn cv_MatStep_MatStep_size_t(s: size_t) -> *mut c_void;
		pub fn cv_MatStep_operator___const_int(instance: *const c_void, i: i32) -> size_t;
		pub fn cv_MatStep_operator___int(instance: *mut c_void, i: i32) -> size_t;
		pub fn cv_MatStep_operator_size_t_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_MatStep_operatorST_size_t(instance: *mut c_void, s: size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_MatStep_propP_const(instance: *const c_void) -> *const size_t;
		pub fn cv_MatStep_propP(instance: *mut c_void) -> *mut size_t;
		pub fn cv_MatStep_propP_size_tX(instance: *mut c_void, val: *const size_t);
		pub fn cv_MatStep_propBuf_const(instance: *const c_void) -> *const [size_t; 2];
		pub fn cv_MatStep_propBuf(instance: *mut c_void) -> *mut [size_t; 2];
		pub fn cv_MatStep_delete(instance: *mut c_void);
		pub fn cv_Matx_AddOp_Matx_AddOp(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Matx_AddOp_Matx_AddOp_const_Matx_AddOpR(unnamed: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Matx_AddOp_delete(instance: *mut c_void);
		pub fn cv_Matx_DivOp_Matx_DivOp(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Matx_DivOp_Matx_DivOp_const_Matx_DivOpR(unnamed: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Matx_DivOp_delete(instance: *mut c_void);
		pub fn cv_Matx_MatMulOp_Matx_MatMulOp(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Matx_MatMulOp_Matx_MatMulOp_const_Matx_MatMulOpR(unnamed: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Matx_MatMulOp_delete(instance: *mut c_void);
		pub fn cv_Matx_MulOp_Matx_MulOp(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Matx_MulOp_Matx_MulOp_const_Matx_MulOpR(unnamed: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Matx_MulOp_delete(instance: *mut c_void);
		pub fn cv_Matx_ScaleOp_Matx_ScaleOp(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Matx_ScaleOp_Matx_ScaleOp_const_Matx_ScaleOpR(unnamed: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Matx_ScaleOp_delete(instance: *mut c_void);
		pub fn cv_Matx_SubOp_Matx_SubOp(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Matx_SubOp_Matx_SubOp_const_Matx_SubOpR(unnamed: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Matx_SubOp_delete(instance: *mut c_void);
		pub fn cv_Matx_TOp_Matx_TOp(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Matx_TOp_Matx_TOp_const_Matx_TOpR(unnamed: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Matx_TOp_delete(instance: *mut c_void);
		pub fn cv_MinProblemSolver_getFunction_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MinProblemSolver_setFunction_const_PtrLFunctionGR(instance: *mut c_void, f: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MinProblemSolver_getTermCriteria_const(instance: *const c_void, ocvrs_return: *mut Result<core::TermCriteria>);
		pub fn cv_MinProblemSolver_setTermCriteria_const_TermCriteriaR(instance: *mut c_void, termcrit: *const core::TermCriteria, ocvrs_return: *mut Result<()>);
		pub fn cv_MinProblemSolver_minimize_const__InputOutputArrayR(instance: *mut c_void, x: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_MinProblemSolver_to_ConjGradSolver(instance: *mut c_void) -> *mut c_void;
		pub fn cv_MinProblemSolver_to_DownhillSolver(instance: *mut c_void) -> *mut c_void;
		pub fn cv_MinProblemSolver_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_MinProblemSolver_delete(instance: *mut c_void);
		pub fn cv_MinProblemSolver_Function_getDims_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_MinProblemSolver_Function_getGradientEps_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_MinProblemSolver_Function_calc_const_const_doubleX(instance: *const c_void, x: *const f64, ocvrs_return: *mut Result<f64>);
		pub fn cv_MinProblemSolver_Function_getGradient_const_doubleX_doubleX(instance: *mut c_void, x: *const f64, grad: *mut f64, ocvrs_return: *mut Result<()>);
		pub fn cv_MinProblemSolver_Function_delete(instance: *mut c_void);
		pub fn cv_Moments_Moments(ocvrs_return: *mut Result<core::Moments>);
		pub fn cv_Moments_Moments_double_double_double_double_double_double_double_double_double_double(m00: f64, m10: f64, m01: f64, m20: f64, m11: f64, m02: f64, m30: f64, m21: f64, m12: f64, m03: f64, ocvrs_return: *mut Result<core::Moments>);
		pub fn cv_PCA_PCA(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_PCA_PCA_const__InputArrayR_const__InputArrayR_int_int(data: *const c_void, mean: *const c_void, flags: i32, max_components: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_PCA_PCA_const__InputArrayR_const__InputArrayR_int(data: *const c_void, mean: *const c_void, flags: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_PCA_PCA_const__InputArrayR_const__InputArrayR_int_double(data: *const c_void, mean: *const c_void, flags: i32, retained_variance: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_PCA_operator___const__InputArrayR_const__InputArrayR_int_int(instance: *mut c_void, data: *const c_void, mean: *const c_void, flags: i32, max_components: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_PCA_operator___const__InputArrayR_const__InputArrayR_int(instance: *mut c_void, data: *const c_void, mean: *const c_void, flags: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_PCA_operator___const__InputArrayR_const__InputArrayR_int_double(instance: *mut c_void, data: *const c_void, mean: *const c_void, flags: i32, retained_variance: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_PCA_project_const_const__InputArrayR(instance: *const c_void, vec: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_PCA_project_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, vec: *const c_void, result: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_PCA_backProject_const_const__InputArrayR(instance: *const c_void, vec: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_PCA_backProject_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, vec: *const c_void, result: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_PCA_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_PCA_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_PCA_propEigenvectors_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PCA_propEigenvectors_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_PCA_propEigenvalues_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PCA_propEigenvalues_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_PCA_propMean_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PCA_propMean_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_PCA_delete(instance: *mut c_void);
		pub fn cv_ParallelLoopBody_operator___const_const_RangeR(instance: *const c_void, range: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ParallelLoopBody_delete(instance: *mut c_void);
		pub fn cv_RNG_RNG(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_RNG_RNG_uint64_t(state: u64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_RNG_next(instance: *mut c_void, ocvrs_return: *mut Result<u32>);
		pub fn cv_RNG_operator_unsigned_char(instance: *mut c_void, ocvrs_return: *mut Result<u8>);
		pub fn cv_RNG_operator_signed_char(instance: *mut c_void, ocvrs_return: *mut Result<i8>);
		pub fn cv_RNG_operator_unsigned_short(instance: *mut c_void, ocvrs_return: *mut Result<u16>);
		pub fn cv_RNG_operator_short(instance: *mut c_void, ocvrs_return: *mut Result<i16>);
		pub fn cv_RNG_operator_unsigned_int(instance: *mut c_void, ocvrs_return: *mut Result<u32>);
		pub fn cv_RNG_operator_int(instance: *mut c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_RNG_operator_float(instance: *mut c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_RNG_operator_double(instance: *mut c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_RNG_operator__(instance: *mut c_void, ocvrs_return: *mut Result<u32>);
		pub fn cv_RNG_operator___unsigned_int(instance: *mut c_void, n: u32, ocvrs_return: *mut Result<u32>);
		pub fn cv_RNG_uniform_int_int(instance: *mut c_void, a: i32, b: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_RNG_uniform_float_float(instance: *mut c_void, a: f32, b: f32, ocvrs_return: *mut Result<f32>);
		pub fn cv_RNG_uniform_double_double(instance: *mut c_void, a: f64, b: f64, ocvrs_return: *mut Result<f64>);
		pub fn cv_RNG_fill_const__InputOutputArrayR_int_const__InputArrayR_const__InputArrayR_bool(instance: *mut c_void, mat: *const c_void, dist_type: i32, a: *const c_void, b: *const c_void, saturate_range: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_RNG_fill_const__InputOutputArrayR_int_const__InputArrayR_const__InputArrayR(instance: *mut c_void, mat: *const c_void, dist_type: i32, a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_RNG_gaussian_double(instance: *mut c_void, sigma: f64, ocvrs_return: *mut Result<f64>);
		pub fn cv_RNG_operatorEQ_const_const_RNGR(instance: *const c_void, other: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_RNG_propState_const(instance: *const c_void) -> u64;
		pub fn cv_RNG_propState_const_uint64_t(instance: *mut c_void, val: u64);
		pub fn cv_RNG_delete(instance: *mut c_void);
		pub fn cv_RNG_MT19937_RNG_MT19937(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_RNG_MT19937_RNG_MT19937_unsigned_int(s: u32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_RNG_MT19937_seed_unsigned_int(instance: *mut c_void, s: u32, ocvrs_return: *mut Result<()>);
		pub fn cv_RNG_MT19937_next(instance: *mut c_void, ocvrs_return: *mut Result<u32>);
		pub fn cv_RNG_MT19937_operator_int(instance: *mut c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_RNG_MT19937_operator_unsigned_int(instance: *mut c_void, ocvrs_return: *mut Result<u32>);
		pub fn cv_RNG_MT19937_operator_float(instance: *mut c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_RNG_MT19937_operator_double(instance: *mut c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_RNG_MT19937_operator___unsigned_int(instance: *mut c_void, n: u32, ocvrs_return: *mut Result<u32>);
		pub fn cv_RNG_MT19937_uniform_int_int(instance: *mut c_void, a: i32, b: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_RNG_MT19937_uniform_float_float(instance: *mut c_void, a: f32, b: f32, ocvrs_return: *mut Result<f32>);
		pub fn cv_RNG_MT19937_uniform_double_double(instance: *mut c_void, a: f64, b: f64, ocvrs_return: *mut Result<f64>);
		pub fn cv_RNG_MT19937_delete(instance: *mut c_void);
		pub fn cv_Range_Range(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Range_Range_int_int(_start: i32, _end: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Range_size_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_Range_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_Range_all(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Range_propStart_const(instance: *const c_void) -> i32;
		pub fn cv_Range_propStart_const_int(instance: *mut c_void, val: i32);
		pub fn cv_Range_propEnd_const(instance: *const c_void) -> i32;
		pub fn cv_Range_propEnd_const_int(instance: *mut c_void, val: i32);
		pub fn cv_Range_delete(instance: *mut c_void);
		pub fn cv_RotatedRect_RotatedRect(ocvrs_return: *mut Result<core::RotatedRect>);
		pub fn cv_RotatedRect_RotatedRect_const_Point2fR_const_Size2fR_float(center: *const core::Point2f, size: *const core::Size2f, angle: f32, ocvrs_return: *mut Result<core::RotatedRect>);
		pub fn cv_RotatedRect_RotatedRect_const_Point2fR_const_Point2fR_const_Point2fR(point1: *const core::Point2f, point2: *const core::Point2f, point3: *const core::Point2f, ocvrs_return: *mut Result<core::RotatedRect>);
		pub fn cv_RotatedRect_points_const_Point2fXX(instance: *const core::RotatedRect, pts: *mut [core::Point2f; 4], ocvrs_return: *mut Result<()>);
		pub fn cv_RotatedRect_points_const_vectorLPoint2fGR(instance: *const core::RotatedRect, pts: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_RotatedRect_boundingRect_const(instance: *const core::RotatedRect, ocvrs_return: *mut Result<core::Rect>);
		pub fn cv_RotatedRect_boundingRect2f_const(instance: *const core::RotatedRect, ocvrs_return: *mut Result<core::Rect2f>);
		pub fn cv_SVD_SVD(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SVD_SVD_const__InputArrayR_int(src: *const c_void, flags: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SVD_SVD_const__InputArrayR(src: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SVD_operator___const__InputArrayR_int(instance: *mut c_void, src: *const c_void, flags: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SVD_operator___const__InputArrayR(instance: *mut c_void, src: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SVD_compute_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int(src: *const c_void, w: *const c_void, u: *const c_void, vt: *const c_void, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_SVD_compute_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, w: *const c_void, u: *const c_void, vt: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SVD_compute_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, w: *const c_void, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_SVD_compute_const__InputArrayR_const__OutputArrayR(src: *const c_void, w: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SVD_backSubst_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(w: *const c_void, u: *const c_void, vt: *const c_void, rhs: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SVD_solveZ_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SVD_backSubst_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, rhs: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SVD_propU_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_SVD_propU_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_SVD_propW_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_SVD_propW_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_SVD_propVt_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_SVD_propVt_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_SVD_delete(instance: *mut c_void);
		pub fn cv_SparseMat_SparseMat(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMat_SparseMat_int_const_intX_int(dims: i32, _sizes: *const i32, _type: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMat_SparseMat_const_SparseMatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMat_SparseMat_const_MatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMat_operatorST_const_SparseMatR(instance: *mut c_void, m: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_operatorST_const_MatR(instance: *mut c_void, m: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_clone_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMat_copyTo_const_SparseMatR(instance: *const c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_copyTo_const_MatR(instance: *const c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_convertTo_const_SparseMatR_int_double(instance: *const c_void, m: *mut c_void, rtype: i32, alpha: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_convertTo_const_SparseMatR_int(instance: *const c_void, m: *mut c_void, rtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_convertTo_const_MatR_int_double_double(instance: *const c_void, m: *mut c_void, rtype: i32, alpha: f64, beta: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_convertTo_const_MatR_int(instance: *const c_void, m: *mut c_void, rtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_assignTo_const_SparseMatR_int(instance: *const c_void, m: *mut c_void, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_assignTo_const_SparseMatR(instance: *const c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_create_int_const_intX_int(instance: *mut c_void, dims: i32, _sizes: *const i32, _type: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_clear(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_addref(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_release(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_elemSize_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMat_elemSize1_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMat_type_const(instance: *const c_void) -> i32;
		pub fn cv_SparseMat_depth_const(instance: *const c_void) -> i32;
		pub fn cv_SparseMat_channels_const(instance: *const c_void) -> i32;
		pub fn cv_SparseMat_size_const(instance: *const c_void, ocvrs_return: *mut Result<*const i32>);
		pub fn cv_SparseMat_size_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_SparseMat_dims_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_SparseMat_nzcount_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_SparseMat_hash_const_int(instance: *const c_void, i0: i32, ocvrs_return: *mut Result<size_t>);
		pub fn cv_SparseMat_hash_const_int_int(instance: *const c_void, i0: i32, i1: i32, ocvrs_return: *mut Result<size_t>);
		pub fn cv_SparseMat_hash_const_int_int_int(instance: *const c_void, i0: i32, i1: i32, i2: i32, ocvrs_return: *mut Result<size_t>);
		pub fn cv_SparseMat_hash_const_const_intX(instance: *const c_void, idx: *const i32, ocvrs_return: *mut Result<size_t>);
		pub fn cv_SparseMat_ptr_int_bool_size_tX(instance: *mut c_void, i0: i32, create_missing: bool, hashval: *mut size_t, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_SparseMat_ptr_int_bool(instance: *mut c_void, i0: i32, create_missing: bool, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_SparseMat_ptr_int_int_bool_size_tX(instance: *mut c_void, i0: i32, i1: i32, create_missing: bool, hashval: *mut size_t, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_SparseMat_ptr_int_int_bool(instance: *mut c_void, i0: i32, i1: i32, create_missing: bool, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_SparseMat_ptr_int_int_int_bool_size_tX(instance: *mut c_void, i0: i32, i1: i32, i2: i32, create_missing: bool, hashval: *mut size_t, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_SparseMat_ptr_int_int_int_bool(instance: *mut c_void, i0: i32, i1: i32, i2: i32, create_missing: bool, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_SparseMat_ptr_const_intX_bool_size_tX(instance: *mut c_void, idx: *const i32, create_missing: bool, hashval: *mut size_t, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_SparseMat_ptr_const_intX_bool(instance: *mut c_void, idx: *const i32, create_missing: bool, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_SparseMat_erase_int_int_size_tX(instance: *mut c_void, i0: i32, i1: i32, hashval: *mut size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_erase_int_int(instance: *mut c_void, i0: i32, i1: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_erase_int_int_int_size_tX(instance: *mut c_void, i0: i32, i1: i32, i2: i32, hashval: *mut size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_erase_int_int_int(instance: *mut c_void, i0: i32, i1: i32, i2: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_erase_const_intX_size_tX(instance: *mut c_void, idx: *const i32, hashval: *mut size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_erase_const_intX(instance: *mut c_void, idx: *const i32, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_begin(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMat_begin_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMat_end(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMat_end_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMat_node_size_t(instance: *mut c_void, nidx: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMat_node_const_size_t(instance: *const c_void, nidx: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMat_newNode_const_intX_size_t(instance: *mut c_void, idx: *const i32, hashval: size_t, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_SparseMat_removeNode_size_t_size_t_size_t(instance: *mut c_void, hidx: size_t, nidx: size_t, previdx: size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_resizeHashTab_size_t(instance: *mut c_void, newsize: size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_propFlags_const(instance: *const c_void) -> i32;
		pub fn cv_SparseMat_propFlags_const_int(instance: *mut c_void, val: i32);
		pub fn cv_SparseMat_propHdr(instance: *mut c_void) -> *mut c_void;
		pub fn cv_SparseMat_propHdr_HdrX(instance: *mut c_void, val: *const c_void);
		pub fn cv_SparseMat_delete(instance: *mut c_void);
		pub fn cv_SparseMat_Hdr_Hdr_int_const_intX_int(_dims: i32, _sizes: *const i32, _type: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMat_Hdr_clear(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMat_Hdr_propRefcount_const(instance: *const c_void) -> i32;
		pub fn cv_SparseMat_Hdr_propRefcount_const_int(instance: *mut c_void, val: i32);
		pub fn cv_SparseMat_Hdr_propDims_const(instance: *const c_void) -> i32;
		pub fn cv_SparseMat_Hdr_propDims_const_int(instance: *mut c_void, val: i32);
		pub fn cv_SparseMat_Hdr_propValueOffset_const(instance: *const c_void) -> i32;
		pub fn cv_SparseMat_Hdr_propValueOffset_const_int(instance: *mut c_void, val: i32);
		pub fn cv_SparseMat_Hdr_propNodeSize_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMat_Hdr_propNodeSize_const_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_SparseMat_Hdr_propNodeCount_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMat_Hdr_propNodeCount_const_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_SparseMat_Hdr_propFreeList_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMat_Hdr_propFreeList_const_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_SparseMat_Hdr_propPool_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_SparseMat_Hdr_propPool_const_vectorLunsigned_charG(instance: *mut c_void, val: *const c_void);
		pub fn cv_SparseMat_Hdr_propHashtab_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_SparseMat_Hdr_propHashtab_const_vectorLsize_tG(instance: *mut c_void, val: *const c_void);
		pub fn cv_SparseMat_Hdr_propSize_const(instance: *const c_void) -> *const [i32; 32];
		pub fn cv_SparseMat_Hdr_propSize(instance: *mut c_void) -> *mut [i32; 32];
		pub fn cv_SparseMat_Hdr_delete(instance: *mut c_void);
		pub fn cv_SparseMat_Node_defaultNew_const() -> *mut c_void;
		pub fn cv_SparseMat_Node_propHashval_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMat_Node_propHashval_const_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_SparseMat_Node_propNext_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMat_Node_propNext_const_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_SparseMat_Node_propIdx_const(instance: *const c_void) -> *const [i32; 32];
		pub fn cv_SparseMat_Node_propIdx(instance: *mut c_void) -> *mut [i32; 32];
		pub fn cv_SparseMat_Node_delete(instance: *mut c_void);
		pub fn cv_SparseMatConstIterator_SparseMatConstIterator(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMatConstIterator_SparseMatConstIterator_const_SparseMatX(_m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMatConstIterator_SparseMatConstIterator_const_SparseMatConstIteratorR(it: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMatConstIterator_operatorST_const_SparseMatConstIteratorR(instance: *mut c_void, it: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMatConstIterator_node_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMatConstIterator_operatorAA(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMatConstIterator_seekEnd(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMatConstIterator_propM_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_SparseMatConstIterator_propHashidx_const(instance: *const c_void) -> size_t;
		pub fn cv_SparseMatConstIterator_propHashidx_const_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_SparseMatConstIterator_propPtr_const(instance: *const c_void) -> *const u8;
		pub fn cv_SparseMatConstIterator_propPtr(instance: *mut c_void) -> *mut u8;
		pub fn cv_SparseMatConstIterator_propPtr_unsigned_charX(instance: *mut c_void, val: *const u8);
		pub fn cv_SparseMatConstIterator_delete(instance: *mut c_void);
		pub fn cv_SparseMatIterator_SparseMatIterator(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMatIterator_SparseMatIterator_SparseMatX(_m: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMatIterator_SparseMatIterator_const_SparseMatIteratorR(it: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMatIterator_operatorST_const_SparseMatIteratorR(instance: *mut c_void, it: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_SparseMatIterator_node_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMatIterator_operatorAA(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SparseMatIterator_to_SparseMatConstIterator(instance: *mut c_void) -> *mut c_void;
		pub fn cv_SparseMatIterator_delete(instance: *mut c_void);
		pub fn cv_TermCriteria_TermCriteria(ocvrs_return: *mut Result<core::TermCriteria>);
		pub fn cv_TermCriteria_TermCriteria_int_int_double(typ: i32, max_count: i32, epsilon: f64, ocvrs_return: *mut Result<core::TermCriteria>);
		pub fn cv_TermCriteria_isValid_const(instance: *const core::TermCriteria, ocvrs_return: *mut Result<bool>);
		pub fn cv_TickMeter_TickMeter(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_TickMeter_start(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_TickMeter_stop(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_TickMeter_getTimeTicks_const(instance: *const c_void, ocvrs_return: *mut Result<i64>);
		pub fn cv_TickMeter_getTimeMicro_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_TickMeter_getTimeMilli_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_TickMeter_getTimeSec_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_TickMeter_getLastTimeTicks_const(instance: *const c_void, ocvrs_return: *mut Result<i64>);
		pub fn cv_TickMeter_getLastTimeMicro_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_TickMeter_getLastTimeMilli_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_TickMeter_getLastTimeSec_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_TickMeter_getCounter_const(instance: *const c_void, ocvrs_return: *mut Result<i64>);
		pub fn cv_TickMeter_getFPS_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_TickMeter_getAvgTimeSec_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_TickMeter_getAvgTimeMilli_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_TickMeter_reset(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_TickMeter_delete(instance: *mut c_void);
		pub fn cv_UMat_UMat_UMatUsageFlags(usage_flags: core::UMatUsageFlags) -> *mut c_void;
		pub fn cv_UMat_UMat() -> *mut c_void;
		pub fn cv_UMat_UMat_int_int_int_UMatUsageFlags(rows: i32, cols: i32, typ: i32, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_int_int_int(rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_Size_int_UMatUsageFlags(size: *const core::Size, typ: i32, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_Size_int(size: *const core::Size, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_int_int_int_const_ScalarR_UMatUsageFlags(rows: i32, cols: i32, typ: i32, s: *const core::Scalar, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_int_int_int_const_ScalarR(rows: i32, cols: i32, typ: i32, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_Size_int_const_ScalarR_UMatUsageFlags(size: *const core::Size, typ: i32, s: *const core::Scalar, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_Size_int_const_ScalarR(size: *const core::Size, typ: i32, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_int_const_intX_int_UMatUsageFlags(ndims: i32, sizes: *const i32, typ: i32, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_int_const_intX_int(ndims: i32, sizes: *const i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_int_const_intX_int_const_ScalarR_UMatUsageFlags(ndims: i32, sizes: *const i32, typ: i32, s: *const core::Scalar, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_int_const_intX_int_const_ScalarR(ndims: i32, sizes: *const i32, typ: i32, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_const_UMatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_const_UMatR_const_RangeR_const_RangeR(m: *const c_void, row_range: *const c_void, col_range: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_UMatR_const_RangeR(m: *mut c_void, row_range: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_const_UMatR_const_RangeR(m: *const c_void, row_range: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_UMatR_const_RangeR_const_RangeR(m: *mut c_void, row_range: *const c_void, col_range: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_const_UMatR_const_RectR(m: *const c_void, roi: *const core::Rect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_UMatR_const_RectR(m: *mut c_void, roi: *const core::Rect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_const_UMatR_const_vectorLRangeGR(m: *const c_void, ranges: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_UMat_UMatR_const_vectorLRangeGR(m: *mut c_void, ranges: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_operatorST_const_UMatR(instance: *mut c_void, m: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_getMat_const_AccessFlag(instance: *const c_void, flags: core::AccessFlag, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_row_const_int(instance: *const c_void, y: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_row_int(instance: *mut c_void, y: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_col_const_int(instance: *const c_void, x: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_col_int(instance: *mut c_void, x: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_rowRange_const_int_int(instance: *const c_void, startrow: i32, endrow: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_rowRange_int_int(instance: *mut c_void, startrow: i32, endrow: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_rowRange_const_const_RangeR(instance: *const c_void, r: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_rowRange_const_RangeR(instance: *mut c_void, r: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_colRange_const_int_int(instance: *const c_void, startcol: i32, endcol: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_colRange_int_int(instance: *mut c_void, startcol: i32, endcol: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_colRange_const_const_RangeR(instance: *const c_void, r: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_colRange_const_RangeR(instance: *mut c_void, r: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_diag_const_int(instance: *const c_void, d: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_diag(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_diag_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_diag_int(instance: *mut c_void, d: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_diag_const_UMatR_UMatUsageFlags(d: *const c_void, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_diag_const_UMatR(d: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_clone_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_copyTo_const_const__OutputArrayR(instance: *const c_void, m: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_copyTo_const_const__OutputArrayR_const__InputArrayR(instance: *const c_void, m: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_convertTo_const_const__OutputArrayR_int_double_double(instance: *const c_void, m: *const c_void, rtype: i32, alpha: f64, beta: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_convertTo_const_const__OutputArrayR_int(instance: *const c_void, m: *const c_void, rtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_assignTo_const_UMatR_int(instance: *const c_void, m: *mut c_void, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_assignTo_const_UMatR(instance: *const c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_operatorST_const_ScalarR(instance: *mut c_void, s: *const core::Scalar, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_setTo_const__InputArrayR_const__InputArrayR(instance: *mut c_void, value: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_setTo_const__InputArrayR(instance: *mut c_void, value: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_reshape_const_int_int(instance: *const c_void, cn: i32, rows: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_reshape_int(instance: *mut c_void, cn: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_reshape_const_int(instance: *const c_void, cn: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_reshape_int_int(instance: *mut c_void, cn: i32, rows: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_reshape_const_int_int_const_intX(instance: *const c_void, cn: i32, newndims: i32, newsz: *const i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_reshape_int_int_const_intX(instance: *mut c_void, cn: i32, newndims: i32, newsz: *const i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_t_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_inv_const_int(instance: *const c_void, method: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_inv_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_mul_const_const__InputArrayR_double(instance: *const c_void, m: *const c_void, scale: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_mul_const_const__InputArrayR(instance: *const c_void, m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_dot_const_const__InputArrayR(instance: *const c_void, m: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_UMat_zeros_int_int_int_UMatUsageFlags(rows: i32, cols: i32, typ: i32, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_zeros_Size_int_UMatUsageFlags(size: *const core::Size, typ: i32, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_zeros_int_const_intX_int_UMatUsageFlags(ndims: i32, sz: *const i32, typ: i32, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_zeros_int_int_int(rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_zeros_Size_int(size: *const core::Size, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_zeros_int_const_intX_int(ndims: i32, sz: *const i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_ones_int_int_int_UMatUsageFlags(rows: i32, cols: i32, typ: i32, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_ones_Size_int_UMatUsageFlags(size: *const core::Size, typ: i32, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_ones_int_const_intX_int_UMatUsageFlags(ndims: i32, sz: *const i32, typ: i32, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_ones_int_int_int(rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_ones_Size_int(size: *const core::Size, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_ones_int_const_intX_int(ndims: i32, sz: *const i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_eye_int_int_int_UMatUsageFlags(rows: i32, cols: i32, typ: i32, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_eye_Size_int_UMatUsageFlags(size: *const core::Size, typ: i32, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_eye_int_int_int(rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_eye_Size_int(size: *const core::Size, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_create_int_int_int_UMatUsageFlags(instance: *mut c_void, rows: i32, cols: i32, typ: i32, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_create_int_int_int(instance: *mut c_void, rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_create_Size_int_UMatUsageFlags(instance: *mut c_void, size: *const core::Size, typ: i32, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_create_Size_int(instance: *mut c_void, size: *const core::Size, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_create_int_const_intX_int_UMatUsageFlags(instance: *mut c_void, ndims: i32, sizes: *const i32, typ: i32, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_create_int_const_intX_int(instance: *mut c_void, ndims: i32, sizes: *const i32, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_create_const_vectorLintGR_int_UMatUsageFlags(instance: *mut c_void, sizes: *const c_void, typ: i32, usage_flags: core::UMatUsageFlags, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_create_const_vectorLintGR_int(instance: *mut c_void, sizes: *const c_void, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_addref(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_release(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_deallocate(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_locateROI_const_SizeR_PointR(instance: *const c_void, whole_size: *mut core::Size, ofs: *mut core::Point, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_adjustROI_int_int_int_int(instance: *mut c_void, dtop: i32, dbottom: i32, dleft: i32, dright: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_operator___const_Range_Range(instance: *const c_void, row_range: *mut c_void, col_range: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_operator___Range_Range(instance: *mut c_void, row_range: *mut c_void, col_range: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_operator___const_const_RectR(instance: *const c_void, roi: *const core::Rect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_operator___const_RectR(instance: *mut c_void, roi: *const core::Rect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_operator___const_const_vectorLRangeGR(instance: *const c_void, ranges: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_operator___const_vectorLRangeGR(instance: *mut c_void, ranges: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_isContinuous_const(instance: *const c_void) -> bool;
		pub fn cv_UMat_isSubmatrix_const(instance: *const c_void) -> bool;
		pub fn cv_UMat_elemSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_UMat_elemSize1_const(instance: *const c_void) -> size_t;
		pub fn cv_UMat_type_const(instance: *const c_void) -> i32;
		pub fn cv_UMat_depth_const(instance: *const c_void) -> i32;
		pub fn cv_UMat_channels_const(instance: *const c_void) -> i32;
		pub fn cv_UMat_step1_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<size_t>);
		pub fn cv_UMat_step1_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_UMat_empty_const(instance: *const c_void) -> bool;
		pub fn cv_UMat_total_const(instance: *const c_void) -> size_t;
		pub fn cv_UMat_checkVector_const_int_int_bool(instance: *const c_void, elem_channels: i32, depth: i32, require_continuous: bool, ocvrs_return: *mut Result<i32>);
		pub fn cv_UMat_checkVector_const_int(instance: *const c_void, elem_channels: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_UMat_UMat_UMatRR(m: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_operatorST_UMatRR(instance: *mut c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_handle_const_AccessFlag(instance: *const c_void, access_flags: core::AccessFlag, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_UMat_ndoffset_const_size_tX(instance: *const c_void, ofs: *mut size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_updateContinuityFlag(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_UMat_size_const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_UMat_propFlags_const(instance: *const c_void) -> i32;
		pub fn cv_UMat_propFlags_const_int(instance: *mut c_void, val: i32);
		pub fn cv_UMat_propDims_const(instance: *const c_void) -> i32;
		pub fn cv_UMat_propDims_const_int(instance: *mut c_void, val: i32);
		pub fn cv_UMat_propRows_const(instance: *const c_void) -> i32;
		pub fn cv_UMat_propRows_const_int(instance: *mut c_void, val: i32);
		pub fn cv_UMat_propCols_const(instance: *const c_void) -> i32;
		pub fn cv_UMat_propCols_const_int(instance: *mut c_void, val: i32);
		pub fn cv_UMat_propUsageFlags_const(instance: *const c_void, ocvrs_return: *mut core::UMatUsageFlags);
		pub fn cv_UMat_propUsageFlags_const_UMatUsageFlags(instance: *mut c_void, val: core::UMatUsageFlags);
		pub fn cv_UMat_propU(instance: *mut c_void) -> *mut c_void;
		pub fn cv_UMat_propU_UMatDataX(instance: *mut c_void, val: *const c_void);
		pub fn cv_UMat_propOffset_const(instance: *const c_void) -> size_t;
		pub fn cv_UMat_propOffset_const_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_UMat_propSize_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_UMat_propSize_const_MatSize(instance: *mut c_void, val: *const c_void);
		pub fn cv_UMat_propStep_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_UMat_delete(instance: *mut c_void);
		pub fn cv_UMatData_lock(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_UMatData_unlock(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_UMatData_hostCopyObsolete_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_UMatData_deviceCopyObsolete_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_UMatData_deviceMemMapped_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_UMatData_copyOnMap_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_UMatData_tempUMat_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_UMatData_tempCopiedUMat_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_UMatData_markHostCopyObsolete_bool(instance: *mut c_void, flag: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_UMatData_markDeviceCopyObsolete_bool(instance: *mut c_void, flag: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_UMatData_markDeviceMemMapped_bool(instance: *mut c_void, flag: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_UMatData_propUrefcount_const(instance: *const c_void) -> i32;
		pub fn cv_UMatData_propUrefcount_const_int(instance: *mut c_void, val: i32);
		pub fn cv_UMatData_propRefcount_const(instance: *const c_void) -> i32;
		pub fn cv_UMatData_propRefcount_const_int(instance: *mut c_void, val: i32);
		pub fn cv_UMatData_propData_const(instance: *const c_void) -> *const u8;
		pub fn cv_UMatData_propData(instance: *mut c_void) -> *mut u8;
		pub fn cv_UMatData_propData_unsigned_charX(instance: *mut c_void, val: *const u8);
		pub fn cv_UMatData_propOrigdata_const(instance: *const c_void) -> *const u8;
		pub fn cv_UMatData_propOrigdata(instance: *mut c_void) -> *mut u8;
		pub fn cv_UMatData_propOrigdata_unsigned_charX(instance: *mut c_void, val: *const u8);
		pub fn cv_UMatData_propSize_const(instance: *const c_void) -> size_t;
		pub fn cv_UMatData_propSize_const_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_UMatData_propFlags_const(instance: *const c_void, ocvrs_return: *mut core::UMatData_MemoryFlag);
		pub fn cv_UMatData_propFlags_const_MemoryFlag(instance: *mut c_void, val: core::UMatData_MemoryFlag);
		pub fn cv_UMatData_propHandle(instance: *mut c_void) -> *mut c_void;
		pub fn cv_UMatData_propHandle_voidX(instance: *mut c_void, val: *const c_void);
		pub fn cv_UMatData_propUserdata(instance: *mut c_void) -> *mut c_void;
		pub fn cv_UMatData_propUserdata_voidX(instance: *mut c_void, val: *const c_void);
		pub fn cv_UMatData_propAllocatorFlags__const(instance: *const c_void) -> i32;
		pub fn cv_UMatData_propAllocatorFlags__const_int(instance: *mut c_void, val: i32);
		pub fn cv_UMatData_propMapcount_const(instance: *const c_void) -> i32;
		pub fn cv_UMatData_propMapcount_const_int(instance: *mut c_void, val: i32);
		pub fn cv_UMatData_propOriginalUMatData(instance: *mut c_void) -> *mut c_void;
		pub fn cv_UMatData_propOriginalUMatData_UMatDataX(instance: *mut c_void, val: *const c_void);
		pub fn cv_UMatData_delete(instance: *mut c_void);
		pub fn cv__InputArray__InputArray(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray__InputArray_int_voidX(_flags: i32, _obj: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray__InputArray_const_MatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray__InputArray_const_MatExprR(expr: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray__InputArray_const_vectorLMatGR(vec: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray__InputArray_const_vectorLboolGR(vec: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray__InputArray_const_doubleR(val: *const f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray__InputArray_const_GpuMatR(d_mat: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray__InputArray_const_vectorLGpuMatGR(d_mat_array: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray__InputArray_const_GpuMatNDR(d_mat: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray__InputArray_const_BufferR(buf: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray__InputArray_const_HostMemR(cuda_mem: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray__InputArray_const_UMatR(um: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray__InputArray_const_vectorLUMatGR(umv: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray_getMat_const_int(instance: *const c_void, idx: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray_getMat_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray_getMat__const_int(instance: *const c_void, idx: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray_getMat__const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray_getUMat_const_int(instance: *const c_void, idx: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray_getUMat_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray_getMatVector_const_vectorLMatGR(instance: *const c_void, mv: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv__InputArray_getUMatVector_const_vectorLUMatGR(instance: *const c_void, umv: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv__InputArray_getGpuMatVector_const_vectorLGpuMatGR(instance: *const c_void, gpumv: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv__InputArray_getGpuMat_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray_getGpuMatND_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray_getOGlBuffer_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray_getFlags_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv__InputArray_getObj_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray_getSz_const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv__InputArray_kind_const(instance: *const c_void, ocvrs_return: *mut Result<core::_InputArray_KindFlag>);
		pub fn cv__InputArray_dims_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv__InputArray_dims_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv__InputArray_cols_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv__InputArray_cols_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv__InputArray_rows_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv__InputArray_rows_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv__InputArray_size_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<core::Size>);
		pub fn cv__InputArray_size_const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv__InputArray_sizend_const_intX_int(instance: *const c_void, sz: *mut i32, i: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv__InputArray_sizend_const_intX(instance: *const c_void, sz: *mut i32, ocvrs_return: *mut Result<i32>);
		pub fn cv__InputArray_sameSize_const_const__InputArrayR(instance: *const c_void, arr: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray_total_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<size_t>);
		pub fn cv__InputArray_total_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv__InputArray_type_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv__InputArray_type_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv__InputArray_depth_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv__InputArray_depth_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv__InputArray_channels_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv__InputArray_channels_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv__InputArray_isContinuous_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray_isContinuous_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray_isSubmatrix_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray_isSubmatrix_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray_empty_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray_copyTo_const_const__OutputArrayR(instance: *const c_void, arr: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv__InputArray_copyTo_const_const__OutputArrayR_const__InputArrayR(instance: *const c_void, arr: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv__InputArray_offset_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<size_t>);
		pub fn cv__InputArray_offset_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv__InputArray_step_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<size_t>);
		pub fn cv__InputArray_step_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv__InputArray_isMat_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray_isUMat_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray_isMatVector_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray_isUMatVector_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray_isMatx_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray_isVector_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray_isGpuMat_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray_isGpuMatVector_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray_isGpuMatND_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__InputArray__InputArray_const_unsigned_charX_int(vec: *const u8, n: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputArray_delete(instance: *mut c_void);
		pub fn cv__InputOutputArray__InputOutputArray(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_int_voidX(_flags: i32, _obj: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_MatR(m: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_vectorLMatGR(vec: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_GpuMatR(d_mat: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_GpuMatNDR(d_mat: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_BufferR(buf: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_HostMemR(cuda_mem: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_UMatR(m: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_vectorLUMatGR(vec: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_const_MatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_const_vectorLMatGR(vec: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_const_GpuMatR(d_mat: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_const_vectorLGpuMatGR(d_mat: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_const_GpuMatNDR(d_mat: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_const_BufferR(buf: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_const_HostMemR(cuda_mem: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_const_UMatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray__InputOutputArray_const_vectorLUMatGR(vec: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__InputOutputArray_to__InputArray(instance: *mut c_void) -> *mut c_void;
		pub fn cv__InputOutputArray_to__OutputArray(instance: *mut c_void) -> *mut c_void;
		pub fn cv__InputOutputArray_delete(instance: *mut c_void);
		pub fn cv__OutputArray__OutputArray(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_int_voidX(_flags: i32, _obj: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_MatR(m: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_vectorLMatGR(vec: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_GpuMatR(d_mat: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_vectorLGpuMatGR(d_mat: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_GpuMatNDR(d_mat: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_BufferR(buf: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_HostMemR(cuda_mem: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_UMatR(m: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_vectorLUMatGR(vec: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_const_MatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_const_vectorLMatGR(vec: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_const_GpuMatR(d_mat: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_const_GpuMatNDR(d_mat: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_const_BufferR(buf: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_const_HostMemR(cuda_mem: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_const_UMatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray__OutputArray_const_vectorLUMatGR(vec: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray_fixedSize_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__OutputArray_fixedType_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__OutputArray_needed_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv__OutputArray_getMatRef_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray_getMatRef_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray_getUMatRef_const_int(instance: *const c_void, i: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray_getUMatRef_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray_getGpuMatRef_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray_getGpuMatVecRef_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray_getGpuMatNDRef_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray_getOGlBufferRef_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray_getHostMemRef_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray_create_const_Size_int_int_bool_DepthMask(instance: *const c_void, sz: *const core::Size, typ: i32, i: i32, allow_transposed: bool, fixed_depth_mask: core::_OutputArray_DepthMask, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_create_const_Size_int(instance: *const c_void, sz: *const core::Size, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_create_const_int_int_int_int_bool_DepthMask(instance: *const c_void, rows: i32, cols: i32, typ: i32, i: i32, allow_transposed: bool, fixed_depth_mask: core::_OutputArray_DepthMask, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_create_const_int_int_int(instance: *const c_void, rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_create_const_int_const_intX_int_int_bool_DepthMask(instance: *const c_void, dims: i32, size: *const i32, typ: i32, i: i32, allow_transposed: bool, fixed_depth_mask: core::_OutputArray_DepthMask, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_create_const_int_const_intX_int(instance: *const c_void, dims: i32, size: *const i32, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_createSameSize_const_const__InputArrayR_int(instance: *const c_void, arr: *const c_void, mtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_release_const(instance: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_clear_const(instance: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_setTo_const_const__InputArrayR_const__InputArrayR(instance: *const c_void, value: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_setTo_const_const__InputArrayR(instance: *const c_void, value: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_reinterpret_const_int(instance: *const c_void, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv__OutputArray_assign_const_const_UMatR(instance: *const c_void, u: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_assign_const_const_MatR(instance: *const c_void, m: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_assign_const_const_vectorLUMatGR(instance: *const c_void, v: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_assign_const_const_vectorLMatGR(instance: *const c_void, v: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_move_const_UMatR(instance: *const c_void, u: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_move_const_MatR(instance: *const c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv__OutputArray_to__InputArray(instance: *mut c_void) -> *mut c_void;
		pub fn cv__OutputArray_delete(instance: *mut c_void);
		pub fn cv_cuda_BufferPool_BufferPool_StreamR(stream: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_BufferPool_getBuffer_int_int_int(instance: *mut c_void, rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_BufferPool_getBuffer_Size_int(instance: *mut c_void, size: *const core::Size, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_BufferPool_getAllocator_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_BufferPool_delete(instance: *mut c_void);
		pub fn cv_cuda_DeviceInfo_DeviceInfo(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_DeviceInfo_DeviceInfo_int(device_id: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_DeviceInfo_deviceID_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_name_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_DeviceInfo_totalGlobalMem_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_DeviceInfo_sharedMemPerBlock_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_DeviceInfo_regsPerBlock_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_warpSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_memPitch_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_DeviceInfo_maxThreadsPerBlock_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_maxThreadsDim_const(instance: *const c_void, ocvrs_return: *mut Result<core::Vec3i>);
		pub fn cv_cuda_DeviceInfo_maxGridSize_const(instance: *const c_void, ocvrs_return: *mut Result<core::Vec3i>);
		pub fn cv_cuda_DeviceInfo_clockRate_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_totalConstMem_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_DeviceInfo_majorVersion_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_minorVersion_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_textureAlignment_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_DeviceInfo_texturePitchAlignment_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_DeviceInfo_multiProcessorCount_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_kernelExecTimeoutEnabled_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_DeviceInfo_integrated_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_DeviceInfo_canMapHostMemory_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_DeviceInfo_computeMode_const(instance: *const c_void, ocvrs_return: *mut Result<core::DeviceInfo_ComputeMode>);
		pub fn cv_cuda_DeviceInfo_maxTexture1D_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_maxTexture1DMipmap_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_maxTexture1DLinear_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_maxTexture2D_const(instance: *const c_void, ocvrs_return: *mut Result<core::Vec2i>);
		pub fn cv_cuda_DeviceInfo_maxTexture2DMipmap_const(instance: *const c_void, ocvrs_return: *mut Result<core::Vec2i>);
		pub fn cv_cuda_DeviceInfo_maxTexture2DLinear_const(instance: *const c_void, ocvrs_return: *mut Result<core::Vec3i>);
		pub fn cv_cuda_DeviceInfo_maxTexture2DGather_const(instance: *const c_void, ocvrs_return: *mut Result<core::Vec2i>);
		pub fn cv_cuda_DeviceInfo_maxTexture3D_const(instance: *const c_void, ocvrs_return: *mut Result<core::Vec3i>);
		pub fn cv_cuda_DeviceInfo_maxTextureCubemap_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_maxTexture1DLayered_const(instance: *const c_void, ocvrs_return: *mut Result<core::Vec2i>);
		pub fn cv_cuda_DeviceInfo_maxTexture2DLayered_const(instance: *const c_void, ocvrs_return: *mut Result<core::Vec3i>);
		pub fn cv_cuda_DeviceInfo_maxTextureCubemapLayered_const(instance: *const c_void, ocvrs_return: *mut Result<core::Vec2i>);
		pub fn cv_cuda_DeviceInfo_maxSurface1D_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_maxSurface2D_const(instance: *const c_void, ocvrs_return: *mut Result<core::Vec2i>);
		pub fn cv_cuda_DeviceInfo_maxSurface3D_const(instance: *const c_void, ocvrs_return: *mut Result<core::Vec3i>);
		pub fn cv_cuda_DeviceInfo_maxSurface1DLayered_const(instance: *const c_void, ocvrs_return: *mut Result<core::Vec2i>);
		pub fn cv_cuda_DeviceInfo_maxSurface2DLayered_const(instance: *const c_void, ocvrs_return: *mut Result<core::Vec3i>);
		pub fn cv_cuda_DeviceInfo_maxSurfaceCubemap_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_maxSurfaceCubemapLayered_const(instance: *const c_void, ocvrs_return: *mut Result<core::Vec2i>);
		pub fn cv_cuda_DeviceInfo_surfaceAlignment_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_DeviceInfo_concurrentKernels_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_DeviceInfo_ECCEnabled_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_DeviceInfo_pciBusID_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_pciDeviceID_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_pciDomainID_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_tccDriver_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_DeviceInfo_asyncEngineCount_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_unifiedAddressing_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_DeviceInfo_memoryClockRate_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_memoryBusWidth_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_l2CacheSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_maxThreadsPerMultiProcessor_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DeviceInfo_queryMemory_const_size_tR_size_tR(instance: *const c_void, total_memory: *mut size_t, free_memory: *mut size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DeviceInfo_freeMemory_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_DeviceInfo_totalMemory_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_DeviceInfo_supports_const_FeatureSet(instance: *const c_void, feature_set: core::FeatureSet, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_DeviceInfo_isCompatible_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_DeviceInfo_delete(instance: *mut c_void);
		pub fn cv_cuda_Event_Event_const_CreateFlags(flags: core::Event_CreateFlags, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_Event_Event(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_Event_record_StreamR(instance: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Event_record(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Event_queryIfComplete_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_Event_waitForCompletion(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Event_elapsedTime_const_EventR_const_EventR(start: *const c_void, end: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_cuda_Event_delete(instance: *mut c_void);
		pub fn cv_cuda_GpuData_GpuData_size_t(_size: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuData_propData_const(instance: *const c_void) -> *const u8;
		pub fn cv_cuda_GpuData_propData(instance: *mut c_void) -> *mut u8;
		pub fn cv_cuda_GpuData_propData_unsigned_charX(instance: *mut c_void, val: *const u8);
		pub fn cv_cuda_GpuData_propSize_const(instance: *const c_void) -> size_t;
		pub fn cv_cuda_GpuData_propSize_const_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_cuda_GpuData_delete(instance: *mut c_void);
		pub fn cv_cuda_GpuMat_defaultAllocator(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_setDefaultAllocator_AllocatorX(allocator: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_getStdAllocator(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_AllocatorX(allocator: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_int_int_int_AllocatorX(rows: i32, cols: i32, typ: i32, allocator: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_int_int_int(rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_Size_int_AllocatorX(size: *const core::Size, typ: i32, allocator: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_Size_int(size: *const core::Size, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_int_int_int_Scalar_AllocatorX(rows: i32, cols: i32, typ: i32, s: *const core::Scalar, allocator: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_int_int_int_Scalar(rows: i32, cols: i32, typ: i32, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_Size_int_Scalar_AllocatorX(size: *const core::Size, typ: i32, s: *const core::Scalar, allocator: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_Size_int_Scalar(size: *const core::Size, typ: i32, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_const_GpuMatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_int_int_int_voidX_size_t(rows: i32, cols: i32, typ: i32, data: *mut c_void, step: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_int_int_int_voidX(rows: i32, cols: i32, typ: i32, data: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_Size_int_voidX_size_t(size: *const core::Size, typ: i32, data: *mut c_void, step: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_Size_int_voidX(size: *const core::Size, typ: i32, data: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_const_GpuMatR_Range_Range(m: *const c_void, row_range: *mut c_void, col_range: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_GpuMatR_Range_Range(m: *mut c_void, row_range: *mut c_void, col_range: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_const_GpuMatR_Rect(m: *const c_void, roi: *const core::Rect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_GpuMatR_Rect(m: *mut c_void, roi: *const core::Rect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_const__InputArrayR_AllocatorX(arr: *const c_void, allocator: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_GpuMat_const__InputArrayR(arr: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_operatorST_const_GpuMatR(instance: *mut c_void, m: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_create_int_int_int(instance: *mut c_void, rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_create_Size_int(instance: *mut c_void, size: *const core::Size, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_release(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_swap_GpuMatR(instance: *mut c_void, mat: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_upload_const__InputArrayR(instance: *mut c_void, arr: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_upload_const__InputArrayR_StreamR(instance: *mut c_void, arr: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_download_const_const__OutputArrayR(instance: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_download_const_const__OutputArrayR_StreamR(instance: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_clone_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_copyTo_const_const__OutputArrayR(instance: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_copyTo_const_GpuMatR(instance: *const c_void, dst: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_copyTo_const_const__OutputArrayR_StreamR(instance: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_copyTo_const_GpuMatR_StreamR(instance: *const c_void, dst: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_copyTo_const_const__OutputArrayR_const__InputArrayR(instance: *const c_void, dst: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_copyTo_const_GpuMatR_GpuMatR(instance: *const c_void, dst: *mut c_void, mask: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_copyTo_const_const__OutputArrayR_const__InputArrayR_StreamR(instance: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_copyTo_const_GpuMatR_GpuMatR_StreamR(instance: *const c_void, dst: *mut c_void, mask: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_setTo_Scalar(instance: *mut c_void, s: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_setTo_Scalar_StreamR(instance: *mut c_void, s: *const core::Scalar, stream: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_setTo_Scalar_const__InputArrayR(instance: *mut c_void, s: *const core::Scalar, mask: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_setTo_Scalar_const__InputArrayR_StreamR(instance: *mut c_void, s: *const core::Scalar, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int(instance: *const c_void, dst: *const c_void, rtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_convertTo_const_GpuMatR_int(instance: *const c_void, dst: *mut c_void, rtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int_StreamR(instance: *const c_void, dst: *const c_void, rtype: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_convertTo_const_GpuMatR_int_StreamR(instance: *const c_void, dst: *mut c_void, rtype: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int_double_double(instance: *const c_void, dst: *const c_void, rtype: i32, alpha: f64, beta: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int_double(instance: *const c_void, dst: *const c_void, rtype: i32, alpha: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int_double_StreamR(instance: *const c_void, dst: *const c_void, rtype: i32, alpha: f64, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int_double_double_StreamR(instance: *const c_void, dst: *const c_void, rtype: i32, alpha: f64, beta: f64, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_convertTo_const_GpuMatR_int_double_double_StreamR(instance: *const c_void, dst: *mut c_void, rtype: i32, alpha: f64, beta: f64, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_assignTo_const_GpuMatR_int(instance: *const c_void, m: *mut c_void, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_assignTo_const_GpuMatR(instance: *const c_void, m: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_ptr_int(instance: *mut c_void, y: i32, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_cuda_GpuMat_ptr(instance: *mut c_void, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_cuda_GpuMat_ptr_const_int(instance: *const c_void, y: i32, ocvrs_return: *mut Result<*const u8>);
		pub fn cv_cuda_GpuMat_ptr_const(instance: *const c_void, ocvrs_return: *mut Result<*const u8>);
		pub fn cv_cuda_GpuMat_row_const_int(instance: *const c_void, y: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_row_int(instance: *mut c_void, y: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_col_const_int(instance: *const c_void, x: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_col_int(instance: *mut c_void, x: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_rowRange_const_int_int(instance: *const c_void, startrow: i32, endrow: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_rowRange_int_int(instance: *mut c_void, startrow: i32, endrow: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_rowRange_const_Range(instance: *const c_void, r: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_rowRange_Range(instance: *mut c_void, r: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_colRange_const_int_int(instance: *const c_void, startcol: i32, endcol: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_colRange_int_int(instance: *mut c_void, startcol: i32, endcol: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_colRange_const_Range(instance: *const c_void, r: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_colRange_Range(instance: *mut c_void, r: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_operator___const_Range_Range(instance: *const c_void, row_range: *mut c_void, col_range: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_operator___Range_Range(instance: *mut c_void, row_range: *mut c_void, col_range: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_operator___const_Rect(instance: *const c_void, roi: *const core::Rect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_operator___Rect(instance: *mut c_void, roi: *const core::Rect, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_reshape_const_int_int(instance: *const c_void, cn: i32, rows: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_reshape_int(instance: *mut c_void, cn: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_reshape_const_int(instance: *const c_void, cn: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_reshape_int_int(instance: *mut c_void, cn: i32, rows: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_locateROI_const_SizeR_PointR(instance: *const c_void, whole_size: *mut core::Size, ofs: *mut core::Point, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_adjustROI_int_int_int_int(instance: *mut c_void, dtop: i32, dbottom: i32, dleft: i32, dright: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_isContinuous_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_GpuMat_elemSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_GpuMat_elemSize1_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_GpuMat_type_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_GpuMat_depth_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_GpuMat_channels_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_GpuMat_step1_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_GpuMat_size_const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_cuda_GpuMat_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_GpuMat_cudaPtr_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMat_updateContinuityFlag(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_propFlags_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_GpuMat_propFlags_const_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_GpuMat_propRows_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_GpuMat_propRows_const_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_GpuMat_propCols_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_GpuMat_propCols_const_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_GpuMat_propStep_const(instance: *const c_void) -> size_t;
		pub fn cv_cuda_GpuMat_propStep_const_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_cuda_GpuMat_propData_const(instance: *const c_void) -> *const u8;
		pub fn cv_cuda_GpuMat_propData(instance: *mut c_void) -> *mut u8;
		pub fn cv_cuda_GpuMat_propData_unsigned_charX(instance: *mut c_void, val: *const u8);
		pub fn cv_cuda_GpuMat_propRefcount_const(instance: *const c_void) -> *const i32;
		pub fn cv_cuda_GpuMat_propRefcount(instance: *mut c_void) -> *mut i32;
		pub fn cv_cuda_GpuMat_propRefcount_intX(instance: *mut c_void, val: *const i32);
		pub fn cv_cuda_GpuMat_propDatastart_const(instance: *const c_void) -> *const u8;
		pub fn cv_cuda_GpuMat_propDatastart(instance: *mut c_void) -> *mut u8;
		pub fn cv_cuda_GpuMat_propDatastart_unsigned_charX(instance: *mut c_void, val: *const u8);
		pub fn cv_cuda_GpuMat_propDataend_const(instance: *const c_void) -> *const u8;
		pub fn cv_cuda_GpuMat_propAllocator(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_GpuMat_propAllocator_AllocatorX(instance: *mut c_void, val: *const c_void);
		pub fn cv_cuda_GpuMat_delete(instance: *mut c_void);
		pub fn cv_cuda_GpuMat_Allocator_allocate_GpuMatX_int_int_size_t(instance: *mut c_void, mat: *mut c_void, rows: i32, cols: i32, elem_size: size_t, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_GpuMat_Allocator_free_GpuMatX(instance: *mut c_void, mat: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMat_Allocator_delete(instance: *mut c_void);
		pub fn cv_cuda_GpuMatND_GpuMatND(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMatND_GpuMatND_SizeArray_int(size: *mut c_void, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMatND_GpuMatND_SizeArray_int_voidX_StepArray(size: *mut c_void, typ: i32, data: *mut c_void, step: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMatND_GpuMatND_SizeArray_int_voidX(size: *mut c_void, typ: i32, data: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMatND_create_SizeArray_int(instance: *mut c_void, size: *mut c_void, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMatND_release(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMatND_swap_GpuMatNDR(instance: *mut c_void, m: *mut c_void);
		pub fn cv_cuda_GpuMatND_clone_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMatND_clone_const_StreamR(instance: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMatND_operator___const_const_vectorLRangeGR(instance: *const c_void, ranges: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMatND_operator___const_vectorLRangeGR(instance: *mut c_void, ranges: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMatND_createGpuMatHeader_const_IndexArray_Range_Range(instance: *const c_void, idx: *mut c_void, row_range: *mut c_void, col_range: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMatND_createGpuMatHeader_IndexArray_Range_Range(instance: *mut c_void, idx: *mut c_void, row_range: *mut c_void, col_range: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMatND_createGpuMatHeader_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMatND_createGpuMatHeader(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMatND_operator___const_IndexArray_Range_Range(instance: *const c_void, idx: *mut c_void, row_range: *mut c_void, col_range: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMatND_operator___IndexArray_Range_Range(instance: *mut c_void, idx: *mut c_void, row_range: *mut c_void, col_range: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMatND_operator_cv_cuda_GpuMat_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_GpuMatND_GpuMatND_const_GpuMatNDR(unnamed: *const c_void) -> *mut c_void;
		pub fn cv_cuda_GpuMatND_operatorST_const_GpuMatNDR(instance: *mut c_void, unnamed: *const c_void);
		pub fn cv_cuda_GpuMatND_GpuMatND_GpuMatNDRR(unnamed: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_GpuMatND_operatorST_GpuMatNDRR(instance: *mut c_void, unnamed: *mut c_void);
		pub fn cv_cuda_GpuMatND_upload_const__InputArrayR(instance: *mut c_void, src: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMatND_upload_const__InputArrayR_StreamR(instance: *mut c_void, src: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMatND_download_const_const__OutputArrayR(instance: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMatND_download_const_const__OutputArrayR_StreamR(instance: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_GpuMatND_isContinuous_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_GpuMatND_isSubmatrix_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_GpuMatND_elemSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_GpuMatND_elemSize1_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_GpuMatND_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_GpuMatND_external_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_GpuMatND_getDevicePtr_const(instance: *const c_void, ocvrs_return: *mut Result<*mut u8>);
		pub fn cv_cuda_GpuMatND_total_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_GpuMatND_totalMemSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_GpuMatND_type_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_GpuMatND_propFlags_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_GpuMatND_propFlags_const_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_GpuMatND_propDims_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_GpuMatND_propDims_const_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_GpuMatND_propSize_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_cuda_GpuMatND_propSize_const_SizeArray(instance: *mut c_void, val: *const c_void);
		pub fn cv_cuda_GpuMatND_propStep_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_cuda_GpuMatND_propStep_const_StepArray(instance: *mut c_void, val: *const c_void);
		pub fn cv_cuda_GpuMatND_delete(instance: *mut c_void);
		pub fn cv_cuda_HostMem_HostMem_AllocType(alloc_type: core::HostMem_AllocType, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HostMem_HostMem(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HostMem_HostMem_const_HostMemR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HostMem_HostMem_int_int_int_AllocType(rows: i32, cols: i32, typ: i32, alloc_type: core::HostMem_AllocType, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HostMem_HostMem_int_int_int(rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HostMem_HostMem_Size_int_AllocType(size: *const core::Size, typ: i32, alloc_type: core::HostMem_AllocType, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HostMem_HostMem_Size_int(size: *const core::Size, typ: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HostMem_HostMem_const__InputArrayR_AllocType(arr: *const c_void, alloc_type: core::HostMem_AllocType, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HostMem_HostMem_const__InputArrayR(arr: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HostMem_operatorST_const_HostMemR(instance: *mut c_void, m: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HostMem_swap_HostMemR(instance: *mut c_void, b: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HostMem_clone_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HostMem_create_int_int_int(instance: *mut c_void, rows: i32, cols: i32, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HostMem_create_Size_int(instance: *mut c_void, size: *const core::Size, typ: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HostMem_reshape_const_int_int(instance: *const c_void, cn: i32, rows: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HostMem_reshape_const_int(instance: *const c_void, cn: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HostMem_release(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HostMem_createMatHeader_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HostMem_createGpuMatHeader_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HostMem_isContinuous_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_HostMem_elemSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_HostMem_elemSize1_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_HostMem_type_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HostMem_depth_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HostMem_channels_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HostMem_step1_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_HostMem_size_const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_cuda_HostMem_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_HostMem_propFlags_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_HostMem_propFlags_const_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_HostMem_propRows_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_HostMem_propRows_const_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_HostMem_propCols_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_HostMem_propCols_const_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_HostMem_propStep_const(instance: *const c_void) -> size_t;
		pub fn cv_cuda_HostMem_propStep_const_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_cuda_HostMem_propData_const(instance: *const c_void) -> *const u8;
		pub fn cv_cuda_HostMem_propData(instance: *mut c_void) -> *mut u8;
		pub fn cv_cuda_HostMem_propData_unsigned_charX(instance: *mut c_void, val: *const u8);
		pub fn cv_cuda_HostMem_propRefcount_const(instance: *const c_void) -> *const i32;
		pub fn cv_cuda_HostMem_propRefcount(instance: *mut c_void) -> *mut i32;
		pub fn cv_cuda_HostMem_propRefcount_intX(instance: *mut c_void, val: *const i32);
		pub fn cv_cuda_HostMem_propDatastart_const(instance: *const c_void) -> *const u8;
		pub fn cv_cuda_HostMem_propDatastart(instance: *mut c_void) -> *mut u8;
		pub fn cv_cuda_HostMem_propDatastart_unsigned_charX(instance: *mut c_void, val: *const u8);
		pub fn cv_cuda_HostMem_propDataend_const(instance: *const c_void) -> *const u8;
		pub fn cv_cuda_HostMem_propAlloc_type_const(instance: *const c_void, ocvrs_return: *mut core::HostMem_AllocType);
		pub fn cv_cuda_HostMem_propAlloc_type_const_AllocType(instance: *mut c_void, val: core::HostMem_AllocType);
		pub fn cv_cuda_HostMem_delete(instance: *mut c_void);
		pub fn cv_cuda_Stream_Stream(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_Stream_Stream_const_PtrLAllocatorGR(allocator: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_Stream_Stream_const_size_t(cuda_flags: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_Stream_queryIfComplete_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_Stream_waitForCompletion(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Stream_waitEvent_const_EventR(instance: *mut c_void, event: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Stream_enqueueHostCallback_StreamCallback_voidX(instance: *mut c_void, callback: Option<unsafe extern "C" fn(i32, *mut c_void) -> ()>, user_data: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Stream_Null(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_Stream_cudaPtr_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_Stream_delete(instance: *mut c_void);
		pub fn cv_cuda_TargetArchs_builtWith_FeatureSet(feature_set: core::FeatureSet, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_TargetArchs_has_int_int(major: i32, minor: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_TargetArchs_hasPtx_int_int(major: i32, minor: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_TargetArchs_hasBin_int_int(major: i32, minor: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_TargetArchs_hasEqualOrLessPtx_int_int(major: i32, minor: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_TargetArchs_hasEqualOrGreater_int_int(major: i32, minor: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_TargetArchs_hasEqualOrGreaterPtx_int_int(major: i32, minor: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_TargetArchs_hasEqualOrGreaterBin_int_int(major: i32, minor: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_TargetArchs_defaultNew_const() -> *mut c_void;
		pub fn cv_cuda_TargetArchs_delete(instance: *mut c_void);
		pub fn cv_detail_CheckContext_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_CheckContext_defaultNew_const() -> *mut c_void;
		pub fn cv_detail_CheckContext_propFunc_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_CheckContext_propFile_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_CheckContext_propLine_const(instance: *const c_void) -> i32;
		pub fn cv_detail_CheckContext_propLine_const_int(instance: *mut c_void, val: i32);
		pub fn cv_detail_CheckContext_propTestOp_const(instance: *const c_void, ocvrs_return: *mut core::Detail_TestOp);
		pub fn cv_detail_CheckContext_propTestOp_const_TestOp(instance: *mut c_void, val: core::Detail_TestOp);
		pub fn cv_detail_CheckContext_propMessage_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_CheckContext_propP1_str_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_CheckContext_propP2_str_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_detail_CheckContext_delete(instance: *mut c_void);
		pub fn cv_hfloat_hfloat(ocvrs_return: *mut Result<core::hfloat>);
		pub fn cv_hfloat_hfloat_float(x: f32, ocvrs_return: *mut Result<core::hfloat>);
		pub fn cv_hfloat_operator_float_const(instance: *const core::hfloat, ocvrs_return: *mut Result<f32>);
		pub fn cv_instr_NodeData_NodeData_const_charX_const_charX_int_voidX_bool_TYPE_IMPL(fun_name: *const c_char, file_name: *const c_char, line_num: i32, ret_address: *mut c_void, always_expand: bool, instr_type: core::TYPE, impl_type: core::IMPL, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_instr_NodeData_NodeData(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_instr_NodeData_NodeData_NodeDataR(ref_: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_instr_NodeData_operatorST_const_NodeDataR(instance: *mut c_void, unnamed: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_instr_NodeData_getTotalMs_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_instr_NodeData_getMeanMs_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_instr_NodeData_propM_funName_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_instr_NodeData_propM_funName_const_String(instance: *mut c_void, val: *const c_char);
		pub fn cv_instr_NodeData_propM_instrType_const(instance: *const c_void, ocvrs_return: *mut core::TYPE);
		pub fn cv_instr_NodeData_propM_instrType_const_TYPE(instance: *mut c_void, val: core::TYPE);
		pub fn cv_instr_NodeData_propM_implType_const(instance: *const c_void, ocvrs_return: *mut core::IMPL);
		pub fn cv_instr_NodeData_propM_implType_const_IMPL(instance: *mut c_void, val: core::IMPL);
		pub fn cv_instr_NodeData_propM_fileName_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_instr_NodeData_propM_lineNum_const(instance: *const c_void) -> i32;
		pub fn cv_instr_NodeData_propM_lineNum_const_int(instance: *mut c_void, val: i32);
		pub fn cv_instr_NodeData_propM_retAddress(instance: *mut c_void) -> *mut c_void;
		pub fn cv_instr_NodeData_propM_retAddress_voidX(instance: *mut c_void, val: *const c_void);
		pub fn cv_instr_NodeData_propM_alwaysExpand_const(instance: *const c_void) -> bool;
		pub fn cv_instr_NodeData_propM_alwaysExpand_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_instr_NodeData_propM_funError_const(instance: *const c_void) -> bool;
		pub fn cv_instr_NodeData_propM_funError_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_instr_NodeData_propM_counter_const(instance: *const c_void) -> i32;
		pub fn cv_instr_NodeData_propM_counter_const_int(instance: *mut c_void, val: i32);
		pub fn cv_instr_NodeData_propM_ticksTotal_const(instance: *const c_void) -> u64;
		pub fn cv_instr_NodeData_propM_ticksTotal_const_uint64_t(instance: *mut c_void, val: u64);
		pub fn cv_instr_NodeData_propM_threads_const(instance: *const c_void) -> i32;
		pub fn cv_instr_NodeData_propM_threads_const_int(instance: *mut c_void, val: i32);
		pub fn cv_instr_NodeData_delete(instance: *mut c_void);
		pub fn cv_internal_WriteStructContext_WriteStructContext_FileStorageR_const_StringR_int_const_StringR(_fs: *mut c_void, name: *const c_char, flags: i32, type_name: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_internal_WriteStructContext_WriteStructContext_FileStorageR_const_StringR_int(_fs: *mut c_void, name: *const c_char, flags: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_internal_WriteStructContext_delete(instance: *mut c_void);
		pub fn cv_ocl_Context_Context() -> *mut c_void;
		pub fn cv_ocl_Context_Context_int(dtype: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Context_Context_const_ContextR(c: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Context_operatorST_const_ContextR(instance: *mut c_void, c: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Context_Context_ContextRR(c: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_Context_operatorST_ContextRR(instance: *mut c_void, c: *mut c_void);
		pub fn cv_ocl_Context_create(instance: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Context_create_int(instance: *mut c_void, dtype: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Context_ndevices_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Context_device_const_size_t(instance: *const c_void, idx: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Context_getProg_const_ProgramSourceR_const_StringR_StringR(instance: *mut c_void, prog: *const c_void, buildopt: *const c_char, errmsg: *mut *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Context_unloadProg_ProgramR(instance: *mut c_void, prog: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Context_getDefault_bool(initialize: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Context_getDefault(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Context_ptr_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Context_getOpenCLContextProperty_const_int(instance: *const c_void, property_id: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Context_useSVM_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Context_setUseSVM_bool(instance: *mut c_void, enabled: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Context_fromHandle_voidX(context: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Context_fromDevice_const_DeviceR(device: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Context_create_const_stringR(configuration: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Context_release(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Context_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Context_delete(instance: *mut c_void);
		pub fn cv_ocl_Context_UserContext_defaultNew_const() -> *mut c_void;
		pub fn cv_ocl_Context_UserContext_delete(instance: *mut c_void);
		pub fn cv_ocl_Device_Device() -> *mut c_void;
		pub fn cv_ocl_Device_Device_voidX(d: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Device_Device_const_DeviceR(d: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Device_operatorST_const_DeviceR(instance: *mut c_void, d: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Device_Device_DeviceRR(d: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_Device_operatorST_DeviceRR(instance: *mut c_void, d: *mut c_void);
		pub fn cv_ocl_Device_set_voidX(instance: *mut c_void, d: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Device_name_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Device_extensions_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Device_isExtensionSupported_const_const_StringR(instance: *const c_void, extension_name: *const c_char, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_version_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Device_vendorName_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Device_OpenCL_C_Version_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Device_OpenCLVersion_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Device_deviceVersionMajor_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_deviceVersionMinor_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_driverVersion_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Device_ptr_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Device_type_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_addressBits_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_available_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_compilerAvailable_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_linkerAvailable_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_doubleFPConfig_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_singleFPConfig_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_halfFPConfig_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_hasFP64_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_hasFP16_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_endianLittle_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_errorCorrectionSupport_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_executionCapabilities_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_globalMemCacheSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_globalMemCacheType_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_globalMemCacheLineSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_globalMemSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_localMemSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_localMemType_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_hostUnifiedMemory_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_imageSupport_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_imageFromBufferSupport_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_imagePitchAlignment_const(instance: *const c_void, ocvrs_return: *mut Result<u32>);
		pub fn cv_ocl_Device_imageBaseAddressAlignment_const(instance: *const c_void, ocvrs_return: *mut Result<u32>);
		pub fn cv_ocl_Device_intelSubgroupsSupport_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_image2DMaxWidth_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_image2DMaxHeight_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_image3DMaxWidth_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_image3DMaxHeight_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_image3DMaxDepth_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_imageMaxBufferSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_imageMaxArraySize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_vendorID_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_isAMD_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_isIntel_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_isNVidia_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_maxClockFrequency_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_maxComputeUnits_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_maxConstantArgs_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_maxConstantBufferSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_maxMemAllocSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_maxParameterSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_maxReadImageArgs_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_maxWriteImageArgs_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_maxSamplers_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_maxWorkGroupSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_maxWorkItemDims_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_maxWorkItemSizes_const_size_tX(instance: *const c_void, unnamed: *mut size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Device_memBaseAddrAlign_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_nativeVectorWidthChar_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_nativeVectorWidthShort_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_nativeVectorWidthInt_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_nativeVectorWidthLong_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_nativeVectorWidthFloat_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_nativeVectorWidthDouble_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_nativeVectorWidthHalf_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_preferredVectorWidthChar_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_preferredVectorWidthShort_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_preferredVectorWidthInt_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_preferredVectorWidthLong_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_preferredVectorWidthFloat_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_preferredVectorWidthDouble_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_preferredVectorWidthHalf_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Device_printfBufferSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_profilingTimerResolution_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Device_getDefault(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Device_fromHandle_voidX(d: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Device_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Device_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_ocl_Device_delete(instance: *mut c_void);
		pub fn cv_ocl_Image2D_Image2D() -> *mut c_void;
		pub fn cv_ocl_Image2D_Image2D_const_UMatR_bool_bool(src: *const c_void, norm: bool, alias: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Image2D_Image2D_const_UMatR(src: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Image2D_Image2D_const_Image2DR(i: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Image2D_operatorST_const_Image2DR(instance: *mut c_void, i: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Image2D_Image2D_Image2DRR(unnamed: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_Image2D_operatorST_Image2DRR(instance: *mut c_void, unnamed: *mut c_void);
		pub fn cv_ocl_Image2D_canCreateAlias_const_UMatR(u: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Image2D_isFormatSupported_int_int_bool(depth: i32, cn: i32, norm: bool, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Image2D_ptr_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Image2D_delete(instance: *mut c_void);
		pub fn cv_ocl_Kernel_Kernel() -> *mut c_void;
		pub fn cv_ocl_Kernel_Kernel_const_charX_const_ProgramR(kname: *const c_char, prog: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Kernel_Kernel_const_charX_const_ProgramSourceR_const_StringR_StringX(kname: *const c_char, prog: *const c_void, buildopts: *const c_char, errmsg: *mut *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Kernel_Kernel_const_charX_const_ProgramSourceR(kname: *const c_char, prog: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Kernel_Kernel_const_KernelR(k: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Kernel_operatorST_const_KernelR(instance: *mut c_void, k: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Kernel_Kernel_KernelRR(k: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_Kernel_operatorST_KernelRR(instance: *mut c_void, k: *mut c_void);
		pub fn cv_ocl_Kernel_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Kernel_create_const_charX_const_ProgramR(instance: *mut c_void, kname: *const c_char, prog: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Kernel_create_const_charX_const_ProgramSourceR_const_StringR_StringX(instance: *mut c_void, kname: *const c_char, prog: *const c_void, buildopts: *const c_char, errmsg: *mut *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Kernel_create_const_charX_const_ProgramSourceR_const_StringR(instance: *mut c_void, kname: *const c_char, prog: *const c_void, buildopts: *const c_char, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Kernel_set_int_const_voidX_size_t(instance: *mut c_void, i: i32, value: *const c_void, sz: size_t, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Kernel_set_int_const_Image2DR(instance: *mut c_void, i: i32, image_2d: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Kernel_set_int_const_UMatR(instance: *mut c_void, i: i32, m: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Kernel_set_int_const_KernelArgR(instance: *mut c_void, i: i32, arg: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_Kernel_run_int_size_tX_size_tX_bool_const_QueueR(instance: *mut c_void, dims: i32, globalsize: *mut size_t, localsize: *mut size_t, sync: bool, q: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Kernel_run_int_size_tX_size_tX_bool(instance: *mut c_void, dims: i32, globalsize: *mut size_t, localsize: *mut size_t, sync: bool, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Kernel_run__int_size_tX_size_tX_bool_const_QueueR(instance: *mut c_void, dims: i32, globalsize: *mut size_t, localsize: *mut size_t, sync: bool, q: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Kernel_run__int_size_tX_size_tX_bool(instance: *mut c_void, dims: i32, globalsize: *mut size_t, localsize: *mut size_t, sync: bool, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Kernel_runTask_bool_const_QueueR(instance: *mut c_void, sync: bool, q: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Kernel_runTask_bool(instance: *mut c_void, sync: bool, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Kernel_runProfiling_int_size_tX_size_tX_const_QueueR(instance: *mut c_void, dims: i32, globalsize: *mut size_t, localsize: *mut size_t, q: *const c_void, ocvrs_return: *mut Result<i64>);
		pub fn cv_ocl_Kernel_runProfiling_int_size_tX_size_tX(instance: *mut c_void, dims: i32, globalsize: *mut size_t, localsize: *mut size_t, ocvrs_return: *mut Result<i64>);
		pub fn cv_ocl_Kernel_workGroupSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Kernel_preferedWorkGroupSizeMultiple_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Kernel_compileWorkGroupSize_const_size_tX(instance: *const c_void, wsz: *mut size_t, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Kernel_localMemSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_ocl_Kernel_ptr_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Kernel_delete(instance: *mut c_void);
		pub fn cv_ocl_KernelArg_KernelArg_int_UMatX_int_int_const_voidX_size_t(_flags: i32, _m: *mut c_void, wscale: i32, iwscale: i32, _obj: *const c_void, _sz: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_KernelArg_int_UMatX(_flags: i32, _m: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_KernelArg() -> *mut c_void;
		pub fn cv_ocl_KernelArg_Local_size_t(local_mem_size: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_PtrWriteOnly_const_UMatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_PtrReadOnly_const_UMatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_PtrReadWrite_const_UMatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_ReadWrite_const_UMatR_int_int(m: *const c_void, wscale: i32, iwscale: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_ReadWrite_const_UMatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_ReadWriteNoSize_const_UMatR_int_int(m: *const c_void, wscale: i32, iwscale: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_ReadWriteNoSize_const_UMatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_ReadOnly_const_UMatR_int_int(m: *const c_void, wscale: i32, iwscale: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_ReadOnly_const_UMatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_WriteOnly_const_UMatR_int_int(m: *const c_void, wscale: i32, iwscale: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_WriteOnly_const_UMatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_ReadOnlyNoSize_const_UMatR_int_int(m: *const c_void, wscale: i32, iwscale: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_ReadOnlyNoSize_const_UMatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_WriteOnlyNoSize_const_UMatR_int_int(m: *const c_void, wscale: i32, iwscale: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_WriteOnlyNoSize_const_UMatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_Constant_const_MatR(m: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_KernelArg_propFlags_const(instance: *const c_void) -> i32;
		pub fn cv_ocl_KernelArg_propFlags_const_int(instance: *mut c_void, val: i32);
		pub fn cv_ocl_KernelArg_propM(instance: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_KernelArg_propM_UMatX(instance: *mut c_void, val: *const c_void);
		pub fn cv_ocl_KernelArg_propObj_const(instance: *const c_void) -> *const c_void;
		pub fn cv_ocl_KernelArg_propSz_const(instance: *const c_void) -> size_t;
		pub fn cv_ocl_KernelArg_propSz_const_size_t(instance: *mut c_void, val: size_t);
		pub fn cv_ocl_KernelArg_propWscale_const(instance: *const c_void) -> i32;
		pub fn cv_ocl_KernelArg_propWscale_const_int(instance: *mut c_void, val: i32);
		pub fn cv_ocl_KernelArg_propIwscale_const(instance: *const c_void) -> i32;
		pub fn cv_ocl_KernelArg_propIwscale_const_int(instance: *mut c_void, val: i32);
		pub fn cv_ocl_KernelArg_delete(instance: *mut c_void);
		pub fn cv_ocl_OpenCLExecutionContext_OpenCLExecutionContext() -> *mut c_void;
		pub fn cv_ocl_OpenCLExecutionContext_OpenCLExecutionContext_const_OpenCLExecutionContextR(unnamed: *const c_void) -> *mut c_void;
		pub fn cv_ocl_OpenCLExecutionContext_OpenCLExecutionContext_OpenCLExecutionContextRR(unnamed: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_OpenCLExecutionContext_operatorST_const_OpenCLExecutionContextR(instance: *mut c_void, unnamed: *const c_void);
		pub fn cv_ocl_OpenCLExecutionContext_operatorST_OpenCLExecutionContextRR(instance: *mut c_void, unnamed: *mut c_void);
		pub fn cv_ocl_OpenCLExecutionContext_getContext_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_OpenCLExecutionContext_getDevice_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_OpenCLExecutionContext_getQueue_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_OpenCLExecutionContext_useOpenCL_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_OpenCLExecutionContext_setUseOpenCL_bool(instance: *mut c_void, flag: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_OpenCLExecutionContext_getCurrent(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_OpenCLExecutionContext_getCurrentRef(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_OpenCLExecutionContext_bind_const(instance: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_OpenCLExecutionContext_cloneWithNewQueue_const_const_QueueR(instance: *const c_void, q: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_OpenCLExecutionContext_cloneWithNewQueue_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_OpenCLExecutionContext_create_const_stringR_voidX_voidX_voidX(platform_name: *const c_char, platform_id: *mut c_void, context: *mut c_void, device_id: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_OpenCLExecutionContext_create_const_ContextR_const_DeviceR_const_QueueR(context: *const c_void, device: *const c_void, queue: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_OpenCLExecutionContext_create_const_ContextR_const_DeviceR(context: *const c_void, device: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_OpenCLExecutionContext_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_OpenCLExecutionContext_release(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_OpenCLExecutionContext_delete(instance: *mut c_void);
		pub fn cv_ocl_Platform_Platform() -> *mut c_void;
		pub fn cv_ocl_Platform_Platform_const_PlatformR(p: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Platform_operatorST_const_PlatformR(instance: *mut c_void, p: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Platform_Platform_PlatformRR(p: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_Platform_operatorST_PlatformRR(instance: *mut c_void, p: *mut c_void);
		pub fn cv_ocl_Platform_ptr_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Platform_getDefault(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Platform_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Platform_delete(instance: *mut c_void);
		pub fn cv_ocl_PlatformInfo_PlatformInfo() -> *mut c_void;
		pub fn cv_ocl_PlatformInfo_PlatformInfo_voidX(id: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_PlatformInfo_PlatformInfo_const_PlatformInfoR(i: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_PlatformInfo_operatorST_const_PlatformInfoR(instance: *mut c_void, i: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_PlatformInfo_PlatformInfo_PlatformInfoRR(i: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_PlatformInfo_operatorST_PlatformInfoRR(instance: *mut c_void, i: *mut c_void);
		pub fn cv_ocl_PlatformInfo_name_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_PlatformInfo_vendor_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_PlatformInfo_version_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_PlatformInfo_versionMajor_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_PlatformInfo_versionMinor_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_PlatformInfo_deviceNumber_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ocl_PlatformInfo_getDevice_const_DeviceR_int(instance: *const c_void, device: *mut c_void, d: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_PlatformInfo_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_PlatformInfo_delete(instance: *mut c_void);
		pub fn cv_ocl_Program_Program() -> *mut c_void;
		pub fn cv_ocl_Program_Program_const_ProgramSourceR_const_StringR_StringR(src: *const c_void, buildflags: *const c_char, errmsg: *mut *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Program_Program_const_ProgramR(prog: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Program_operatorST_const_ProgramR(instance: *mut c_void, prog: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Program_Program_ProgramRR(prog: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_Program_operatorST_ProgramRR(instance: *mut c_void, prog: *mut c_void);
		pub fn cv_ocl_Program_create_const_ProgramSourceR_const_StringR_StringR(instance: *mut c_void, src: *const c_void, buildflags: *const c_char, errmsg: *mut *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Program_ptr_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Program_getBinary_const_vectorLcharGR(instance: *const c_void, binary: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Program_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Program_read_const_StringR_const_StringR(instance: *mut c_void, buf: *const c_char, buildflags: *const c_char, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Program_write_const_StringR(instance: *const c_void, buf: *mut *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Program_source_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Program_getPrefix_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Program_getPrefix_const_StringR(buildflags: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Program_delete(instance: *mut c_void);
		pub fn cv_ocl_ProgramSource_ProgramSource() -> *mut c_void;
		pub fn cv_ocl_ProgramSource_ProgramSource_const_StringR_const_StringR_const_StringR_const_StringR(module: *const c_char, name: *const c_char, code_str: *const c_char, code_hash: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_ProgramSource_ProgramSource_const_StringR(prog: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_ProgramSource_ProgramSource_const_ProgramSourceR(prog: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_ProgramSource_operatorST_const_ProgramSourceR(instance: *mut c_void, prog: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_ProgramSource_ProgramSource_ProgramSourceRR(prog: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_ProgramSource_operatorST_ProgramSourceRR(instance: *mut c_void, prog: *mut c_void);
		pub fn cv_ocl_ProgramSource_source_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_ProgramSource_hash_const(instance: *const c_void, ocvrs_return: *mut Result<core::ProgramSource_hash_t>);
		pub fn cv_ocl_ProgramSource_fromBinary_const_StringR_const_StringR_const_unsigned_charX_const_size_t_const_StringR(module: *const c_char, name: *const c_char, binary: *const u8, size: size_t, build_options: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_ProgramSource_fromBinary_const_StringR_const_StringR_const_unsigned_charX_const_size_t(module: *const c_char, name: *const c_char, binary: *const u8, size: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_ProgramSource_fromSPIR_const_StringR_const_StringR_const_unsigned_charX_const_size_t_const_StringR(module: *const c_char, name: *const c_char, binary: *const u8, size: size_t, build_options: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_ProgramSource_fromSPIR_const_StringR_const_StringR_const_unsigned_charX_const_size_t(module: *const c_char, name: *const c_char, binary: *const u8, size: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_ProgramSource_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_ProgramSource_delete(instance: *mut c_void);
		pub fn cv_ocl_Queue_Queue() -> *mut c_void;
		pub fn cv_ocl_Queue_Queue_const_ContextR_const_DeviceR(c: *const c_void, d: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Queue_Queue_const_ContextR(c: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Queue_Queue_const_QueueR(q: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Queue_operatorST_const_QueueR(instance: *mut c_void, q: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Queue_Queue_QueueRR(q: *mut c_void) -> *mut c_void;
		pub fn cv_ocl_Queue_operatorST_QueueRR(instance: *mut c_void, q: *mut c_void);
		pub fn cv_ocl_Queue_create_const_ContextR_const_DeviceR(instance: *mut c_void, c: *const c_void, d: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Queue_create(instance: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Queue_finish(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Queue_ptr_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Queue_getDefault(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Queue_getProfilingQueue_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Queue_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ocl_Queue_delete(instance: *mut c_void);
		pub fn cv_ocl_Timer_Timer_const_QueueR(q: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ocl_Timer_start(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Timer_stop(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ocl_Timer_durationNS_const(instance: *const c_void, ocvrs_return: *mut Result<u64>);
		pub fn cv_ocl_Timer_delete(instance: *mut c_void);
		pub fn cv_ogl_Arrays_Arrays(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Arrays_setVertexArray_const__InputArrayR(instance: *mut c_void, vertex: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Arrays_resetVertexArray(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Arrays_setColorArray_const__InputArrayR(instance: *mut c_void, color: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Arrays_resetColorArray(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Arrays_setNormalArray_const__InputArrayR(instance: *mut c_void, normal: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Arrays_resetNormalArray(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Arrays_setTexCoordArray_const__InputArrayR(instance: *mut c_void, tex_coord: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Arrays_resetTexCoordArray(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Arrays_release(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Arrays_setAutoRelease_bool(instance: *mut c_void, flag: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Arrays_bind_const(instance: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Arrays_size_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ogl_Arrays_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ogl_Arrays_delete(instance: *mut c_void);
		pub fn cv_ogl_Buffer_Buffer(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_Buffer_int_int_int_unsigned_int_bool(arows: i32, acols: i32, atype: i32, abuf_id: u32, auto_release: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_Buffer_int_int_int_unsigned_int(arows: i32, acols: i32, atype: i32, abuf_id: u32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_Buffer_Size_int_unsigned_int_bool(asize: *const core::Size, atype: i32, abuf_id: u32, auto_release: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_Buffer_Size_int_unsigned_int(asize: *const core::Size, atype: i32, abuf_id: u32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_Buffer_int_int_int_Target_bool(arows: i32, acols: i32, atype: i32, target: core::Buffer_Target, auto_release: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_Buffer_int_int_int(arows: i32, acols: i32, atype: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_Buffer_Size_int_Target_bool(asize: *const core::Size, atype: i32, target: core::Buffer_Target, auto_release: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_Buffer_Size_int(asize: *const core::Size, atype: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_Buffer_const__InputArrayR_Target_bool(arr: *const c_void, target: core::Buffer_Target, auto_release: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_Buffer_const__InputArrayR(arr: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_create_int_int_int_Target_bool(instance: *mut c_void, arows: i32, acols: i32, atype: i32, target: core::Buffer_Target, auto_release: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_create_int_int_int(instance: *mut c_void, arows: i32, acols: i32, atype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_create_Size_int_Target_bool(instance: *mut c_void, asize: *const core::Size, atype: i32, target: core::Buffer_Target, auto_release: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_create_Size_int(instance: *mut c_void, asize: *const core::Size, atype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_release(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_setAutoRelease_bool(instance: *mut c_void, flag: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_copyFrom_const__InputArrayR_Target_bool(instance: *mut c_void, arr: *const c_void, target: core::Buffer_Target, auto_release: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_copyFrom_const__InputArrayR(instance: *mut c_void, arr: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_copyFrom_const__InputArrayR_StreamR_Target_bool(instance: *mut c_void, arr: *const c_void, stream: *mut c_void, target: core::Buffer_Target, auto_release: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_copyFrom_const__InputArrayR_StreamR(instance: *mut c_void, arr: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_copyTo_const_const__OutputArrayR(instance: *const c_void, arr: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_copyTo_const_const__OutputArrayR_StreamR(instance: *const c_void, arr: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_clone_const_Target_bool(instance: *const c_void, target: core::Buffer_Target, auto_release: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_clone_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_bind_const_Target(instance: *const c_void, target: core::Buffer_Target, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_unbind_Target(target: core::Buffer_Target, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_mapHost_Access(instance: *mut c_void, access: core::Buffer_Access, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_unmapHost(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_mapDevice(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_unmapDevice(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_mapDevice_StreamR(instance: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Buffer_unmapDevice_StreamR(instance: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Buffer_rows_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ogl_Buffer_cols_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ogl_Buffer_size_const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_ogl_Buffer_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ogl_Buffer_type_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ogl_Buffer_depth_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ogl_Buffer_channels_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ogl_Buffer_elemSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ogl_Buffer_elemSize1_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ogl_Buffer_bufId_const(instance: *const c_void, ocvrs_return: *mut Result<u32>);
		pub fn cv_ogl_Buffer_delete(instance: *mut c_void);
		pub fn cv_ogl_Texture2D_Texture2D(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Texture2D_Texture2D_int_int_Format_unsigned_int_bool(arows: i32, acols: i32, aformat: core::Texture2D_Format, atex_id: u32, auto_release: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Texture2D_Texture2D_int_int_Format_unsigned_int(arows: i32, acols: i32, aformat: core::Texture2D_Format, atex_id: u32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Texture2D_Texture2D_Size_Format_unsigned_int_bool(asize: *const core::Size, aformat: core::Texture2D_Format, atex_id: u32, auto_release: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Texture2D_Texture2D_Size_Format_unsigned_int(asize: *const core::Size, aformat: core::Texture2D_Format, atex_id: u32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Texture2D_Texture2D_int_int_Format_bool(arows: i32, acols: i32, aformat: core::Texture2D_Format, auto_release: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Texture2D_Texture2D_int_int_Format(arows: i32, acols: i32, aformat: core::Texture2D_Format, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Texture2D_Texture2D_Size_Format_bool(asize: *const core::Size, aformat: core::Texture2D_Format, auto_release: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Texture2D_Texture2D_Size_Format(asize: *const core::Size, aformat: core::Texture2D_Format, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Texture2D_Texture2D_const__InputArrayR_bool(arr: *const c_void, auto_release: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Texture2D_Texture2D_const__InputArrayR(arr: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ogl_Texture2D_create_int_int_Format_bool(instance: *mut c_void, arows: i32, acols: i32, aformat: core::Texture2D_Format, auto_release: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Texture2D_create_int_int_Format(instance: *mut c_void, arows: i32, acols: i32, aformat: core::Texture2D_Format, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Texture2D_create_Size_Format_bool(instance: *mut c_void, asize: *const core::Size, aformat: core::Texture2D_Format, auto_release: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Texture2D_create_Size_Format(instance: *mut c_void, asize: *const core::Size, aformat: core::Texture2D_Format, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Texture2D_release(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Texture2D_setAutoRelease_bool(instance: *mut c_void, flag: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Texture2D_copyFrom_const__InputArrayR_bool(instance: *mut c_void, arr: *const c_void, auto_release: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Texture2D_copyFrom_const__InputArrayR(instance: *mut c_void, arr: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Texture2D_copyTo_const_const__OutputArrayR_int_bool(instance: *const c_void, arr: *const c_void, ddepth: i32, auto_release: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Texture2D_copyTo_const_const__OutputArrayR(instance: *const c_void, arr: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Texture2D_bind_const(instance: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_ogl_Texture2D_rows_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ogl_Texture2D_cols_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ogl_Texture2D_size_const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_ogl_Texture2D_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_ogl_Texture2D_format_const(instance: *const c_void, ocvrs_return: *mut Result<core::Texture2D_Format>);
		pub fn cv_ogl_Texture2D_texId_const(instance: *const c_void, ocvrs_return: *mut Result<u32>);
		pub fn cv_ogl_Texture2D_delete(instance: *mut c_void);
		pub fn cv_utils_ClassWithKeywordProperties_ClassWithKeywordProperties_int_int(lambda_arg: i32, except_arg: i32, ocvrs_return: *mut Result<core::ClassWithKeywordProperties>);
		pub fn cv_utils_ClassWithKeywordProperties_ClassWithKeywordProperties(ocvrs_return: *mut Result<core::ClassWithKeywordProperties>);
		pub fn cv_utils_FunctionParams_setLambda_int(instance: *const core::FunctionParams, value: i32, ocvrs_return: *mut core::FunctionParams);
		pub fn cv_utils_FunctionParams_setSigma_float(instance: *const core::FunctionParams, value: f32, ocvrs_return: *mut core::FunctionParams);
		pub fn cv_utils_logging_LogTag_LogTag_const_charX_LogLevel(_name: *const c_char, _level: core::LogLevel, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_logging_LogTag_propName_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_utils_logging_LogTag_propLevel_const(instance: *const c_void, ocvrs_return: *mut core::LogLevel);
		pub fn cv_utils_logging_LogTag_propLevel_const_LogLevel(instance: *mut c_void, val: core::LogLevel);
		pub fn cv_utils_logging_LogTag_delete(instance: *mut c_void);
		pub fn cv_utils_nested_OriginalClassName_OriginalClassName_const_ParamsR(params: *const core::OriginalClassName_Params, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_nested_OriginalClassName_OriginalClassName(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_nested_OriginalClassName_getIntParam_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_utils_nested_OriginalClassName_getFloatParam_const(instance: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_utils_nested_OriginalClassName_originalName(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_nested_OriginalClassName_create_const_ParamsR(params: *const core::OriginalClassName_Params, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_nested_OriginalClassName_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_utils_nested_OriginalClassName_delete(instance: *mut c_void);
		pub fn cv_utils_nested_OriginalClassName_Params_Params_int_float(int_param: i32, float_param: f32, ocvrs_return: *mut Result<core::OriginalClassName_Params>);
		pub fn cv_utils_nested_OriginalClassName_Params_Params(ocvrs_return: *mut Result<core::OriginalClassName_Params>);
		pub fn cv_PtrLcv_AlgorithmG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_AlgorithmG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_AlgorithmG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_AlgorithmG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_AlgorithmG_new_const_Algorithm(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_ConjGradSolverG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_ConjGradSolverG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_ConjGradSolverG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_ConjGradSolverG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_ConjGradSolverG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_ConjGradSolverG_to_PtrOfMinProblemSolver(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_DownhillSolverG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_DownhillSolverG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_DownhillSolverG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_DownhillSolverG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_DownhillSolverG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_DownhillSolverG_to_PtrOfMinProblemSolver(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_FileStorageG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_FileStorageG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_FileStorageG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_FileStorageG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_FileStorageG_new_const_FileStorage(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_FormattedG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_FormattedG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_FormattedG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_FormattedG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_FormatterG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_FormatterG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_FormatterG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_FormatterG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_GpuMat_AllocatorG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_GpuMat_AllocatorG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_GpuMat_AllocatorG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_GpuMat_AllocatorG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_KeyPointG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_KeyPointG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_KeyPointG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_KeyPointG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_KeyPointG_new_const_KeyPoint(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_MinProblemSolverG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_MinProblemSolverG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_MinProblemSolverG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_MinProblemSolverG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_MinProblemSolverG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_MinProblemSolver_FunctionG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_MinProblemSolver_FunctionG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_MinProblemSolver_FunctionG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_MinProblemSolver_FunctionG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_utils_nested_OriginalClassNameG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_utils_nested_OriginalClassNameG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_utils_nested_OriginalClassNameG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_utils_nested_OriginalClassNameG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_utils_nested_OriginalClassNameG_new_const_OriginalClassName(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLfloatG_getInnerPtr_const(instance: *const c_void) -> *const f32;
		pub fn cv_PtrLfloatG_getInnerPtrMut(instance: *mut c_void) -> *mut f32;
		pub fn cv_PtrLfloatG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLfloatG_delete(instance: *mut c_void);
		pub fn cv_PtrLfloatG_new_const_float(val: f32) -> *mut c_void;
		pub fn std_pairLcv_Point2i__cv_Point2iG_new_const_Point2i_Point2i(arg: *const core::Point2i, arg_1: *const core::Point2i) -> *mut c_void;
		pub fn std_pairLcv_Point2i__cv_Point2iG_get_0_const(instance: *const c_void, ocvrs_return: *mut core::Point2i);
		pub fn std_pairLcv_Point2i__cv_Point2iG_get_1_const(instance: *const c_void, ocvrs_return: *mut core::Point2i);
		pub fn std_pairLcv_Point2i__cv_Point2iG_delete(instance: *mut c_void);
		pub fn std_pairLcv_Rect__intG_new_const_Rect_int(arg: *const core::Rect, arg_1: i32) -> *mut c_void;
		pub fn std_pairLcv_Rect__intG_get_0_const(instance: *const c_void, ocvrs_return: *mut core::Rect);
		pub fn std_pairLcv_Rect__intG_get_1_const(instance: *const c_void, ocvrs_return: *mut i32);
		pub fn std_pairLcv_Rect__intG_delete(instance: *mut c_void);
		pub fn std_pairLcv_UMat__unsigned_charG_new_const_UMat_unsigned_char(arg: *mut c_void, arg_1: u8) -> *mut c_void;
		pub fn std_pairLcv_UMat__unsigned_charG_get_0_const(instance: *const c_void, ocvrs_return: *mut *mut c_void);
		pub fn std_pairLcv_UMat__unsigned_charG_get_1_const(instance: *const c_void, ocvrs_return: *mut u8);
		pub fn std_pairLcv_UMat__unsigned_charG_delete(instance: *mut c_void);
		pub fn std_pairLint__floatG_new_const_int_float(arg: i32, arg_1: f32) -> *mut c_void;
		pub fn std_pairLint__floatG_get_0_const(instance: *const c_void, ocvrs_return: *mut i32);
		pub fn std_pairLint__floatG_get_1_const(instance: *const c_void, ocvrs_return: *mut f32);
		pub fn std_pairLint__floatG_delete(instance: *mut c_void);
		pub fn std_pairLint__doubleG_new_const_int_double(arg: i32, arg_1: f64) -> *mut c_void;
		pub fn std_pairLint__doubleG_get_0_const(instance: *const c_void, ocvrs_return: *mut i32);
		pub fn std_pairLint__doubleG_get_1_const(instance: *const c_void, ocvrs_return: *mut f64);
		pub fn std_pairLint__doubleG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_DMatchG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_DMatchG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_DMatchG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_DMatchG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_DMatchG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_DMatchG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_DMatchG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_DMatchG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_DMatchG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_DMatchG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_DMatchG_push_const_DMatch(instance: *mut c_void, val: *const core::DMatch);
		pub fn std_vectorLcv_DMatchG_insert_size_t_const_DMatch(instance: *mut c_void, index: size_t, val: *const core::DMatch);
		pub fn std_vectorLcv_DMatchG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::DMatch);
		pub fn std_vectorLcv_DMatchG_set_size_t_const_DMatch(instance: *mut c_void, index: size_t, val: *const core::DMatch);
		pub fn std_vectorLcv_DMatchG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_DMatchG_data_const(instance: *const c_void) -> *const core::DMatch;
		pub fn std_vectorLcv_DMatchG_dataMut(instance: *mut c_void) -> *mut core::DMatch;
		pub fn cv_fromSlice_const_const_DMatchX_size_t(data: *const core::DMatch, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_cuda_GpuMatG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_cuda_GpuMatG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_cuda_GpuMatG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_cuda_GpuMatG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_cuda_GpuMatG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_cuda_GpuMatG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_cuda_GpuMatG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_cuda_GpuMatG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_cuda_GpuMatG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_cuda_GpuMatG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_cuda_GpuMatG_push_const_GpuMat(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLcv_cuda_GpuMatG_insert_size_t_const_GpuMat(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_cuda_GpuMatG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLcv_cuda_GpuMatG_set_size_t_const_GpuMat(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_KeyPointG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_KeyPointG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_KeyPointG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_KeyPointG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_KeyPointG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_KeyPointG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_KeyPointG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_KeyPointG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_KeyPointG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_KeyPointG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_KeyPointG_push_const_KeyPoint(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLcv_KeyPointG_insert_size_t_const_KeyPoint(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_KeyPointG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLcv_KeyPointG_set_size_t_const_KeyPoint(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_MatG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_MatG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_MatG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_MatG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_MatG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_MatG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_MatG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_MatG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_MatG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_MatG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_MatG_push_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLcv_MatG_insert_size_t_const_Mat(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_MatG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLcv_MatG_set_size_t_const_Mat(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_ocl_PlatformInfoG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_ocl_PlatformInfoG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_ocl_PlatformInfoG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_ocl_PlatformInfoG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_ocl_PlatformInfoG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_ocl_PlatformInfoG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_ocl_PlatformInfoG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_ocl_PlatformInfoG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_ocl_PlatformInfoG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_ocl_PlatformInfoG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_ocl_PlatformInfoG_push_const_PlatformInfo(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLcv_ocl_PlatformInfoG_insert_size_t_const_PlatformInfo(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_ocl_PlatformInfoG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLcv_ocl_PlatformInfoG_set_size_t_const_PlatformInfo(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_PointG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_PointG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_PointG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_PointG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_PointG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_PointG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_PointG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_PointG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_PointG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_PointG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_PointG_push_const_Point(instance: *mut c_void, val: *const core::Point);
		pub fn std_vectorLcv_PointG_insert_size_t_const_Point(instance: *mut c_void, index: size_t, val: *const core::Point);
		pub fn std_vectorLcv_PointG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Point);
		pub fn std_vectorLcv_PointG_set_size_t_const_Point(instance: *mut c_void, index: size_t, val: *const core::Point);
		pub fn std_vectorLcv_PointG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_PointG_data_const(instance: *const c_void) -> *const core::Point;
		pub fn std_vectorLcv_PointG_dataMut(instance: *mut c_void) -> *mut core::Point;
		pub fn cv_fromSlice_const_const_PointX_size_t(data: *const core::Point, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_PointG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_PointG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_PointG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Point2dG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_Point2dG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_Point2dG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Point2dG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_Point2dG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Point2dG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_Point2dG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_Point2dG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_Point2dG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_Point2dG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_Point2dG_push_const_Point2d(instance: *mut c_void, val: *const core::Point2d);
		pub fn std_vectorLcv_Point2dG_insert_size_t_const_Point2d(instance: *mut c_void, index: size_t, val: *const core::Point2d);
		pub fn std_vectorLcv_Point2dG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Point2d);
		pub fn std_vectorLcv_Point2dG_set_size_t_const_Point2d(instance: *mut c_void, index: size_t, val: *const core::Point2d);
		pub fn std_vectorLcv_Point2dG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_Point2dG_data_const(instance: *const c_void) -> *const core::Point2d;
		pub fn std_vectorLcv_Point2dG_dataMut(instance: *mut c_void) -> *mut core::Point2d;
		pub fn cv_fromSlice_const_const_Point2dX_size_t(data: *const core::Point2d, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_Point2dG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Point2dG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Point2dG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Point2fG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_Point2fG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_Point2fG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Point2fG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_Point2fG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Point2fG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_Point2fG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_Point2fG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_Point2fG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_Point2fG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_Point2fG_push_const_Point2f(instance: *mut c_void, val: *const core::Point2f);
		pub fn std_vectorLcv_Point2fG_insert_size_t_const_Point2f(instance: *mut c_void, index: size_t, val: *const core::Point2f);
		pub fn std_vectorLcv_Point2fG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Point2f);
		pub fn std_vectorLcv_Point2fG_set_size_t_const_Point2f(instance: *mut c_void, index: size_t, val: *const core::Point2f);
		pub fn std_vectorLcv_Point2fG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_Point2fG_data_const(instance: *const c_void) -> *const core::Point2f;
		pub fn std_vectorLcv_Point2fG_dataMut(instance: *mut c_void) -> *mut core::Point2f;
		pub fn cv_fromSlice_const_const_Point2fX_size_t(data: *const core::Point2f, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_Point2fG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Point2fG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Point2fG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Point3dG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_Point3dG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_Point3dG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Point3dG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_Point3dG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Point3dG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_Point3dG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_Point3dG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_Point3dG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_Point3dG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_Point3dG_push_const_Point3d(instance: *mut c_void, val: *const core::Point3d);
		pub fn std_vectorLcv_Point3dG_insert_size_t_const_Point3d(instance: *mut c_void, index: size_t, val: *const core::Point3d);
		pub fn std_vectorLcv_Point3dG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Point3d);
		pub fn std_vectorLcv_Point3dG_set_size_t_const_Point3d(instance: *mut c_void, index: size_t, val: *const core::Point3d);
		pub fn std_vectorLcv_Point3dG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_Point3dG_data_const(instance: *const c_void) -> *const core::Point3d;
		pub fn std_vectorLcv_Point3dG_dataMut(instance: *mut c_void) -> *mut core::Point3d;
		pub fn cv_fromSlice_const_const_Point3dX_size_t(data: *const core::Point3d, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_Point3dG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Point3dG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Point3dG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Point3fG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_Point3fG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_Point3fG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Point3fG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_Point3fG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Point3fG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_Point3fG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_Point3fG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_Point3fG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_Point3fG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_Point3fG_push_const_Point3f(instance: *mut c_void, val: *const core::Point3f);
		pub fn std_vectorLcv_Point3fG_insert_size_t_const_Point3f(instance: *mut c_void, index: size_t, val: *const core::Point3f);
		pub fn std_vectorLcv_Point3fG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Point3f);
		pub fn std_vectorLcv_Point3fG_set_size_t_const_Point3f(instance: *mut c_void, index: size_t, val: *const core::Point3f);
		pub fn std_vectorLcv_Point3fG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_Point3fG_data_const(instance: *const c_void) -> *const core::Point3f;
		pub fn std_vectorLcv_Point3fG_dataMut(instance: *mut c_void) -> *mut core::Point3f;
		pub fn cv_fromSlice_const_const_Point3fX_size_t(data: *const core::Point3f, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_Point3fG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Point3fG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Point3fG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Point3iG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_Point3iG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_Point3iG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Point3iG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_Point3iG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Point3iG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_Point3iG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_Point3iG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_Point3iG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_Point3iG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_Point3iG_push_const_Point3i(instance: *mut c_void, val: *const core::Point3i);
		pub fn std_vectorLcv_Point3iG_insert_size_t_const_Point3i(instance: *mut c_void, index: size_t, val: *const core::Point3i);
		pub fn std_vectorLcv_Point3iG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Point3i);
		pub fn std_vectorLcv_Point3iG_set_size_t_const_Point3i(instance: *mut c_void, index: size_t, val: *const core::Point3i);
		pub fn std_vectorLcv_Point3iG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_Point3iG_data_const(instance: *const c_void) -> *const core::Point3i;
		pub fn std_vectorLcv_Point3iG_dataMut(instance: *mut c_void) -> *mut core::Point3i;
		pub fn cv_fromSlice_const_const_Point3iX_size_t(data: *const core::Point3i, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_Point3iG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Point3iG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Point3iG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_RangeG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_RangeG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_RangeG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_RangeG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_RangeG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_RangeG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_RangeG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_RangeG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_RangeG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_RangeG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_RangeG_push_const_Range(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLcv_RangeG_insert_size_t_const_Range(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_RangeG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLcv_RangeG_set_size_t_const_Range(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_RectG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_RectG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_RectG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_RectG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_RectG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_RectG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_RectG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_RectG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_RectG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_RectG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_RectG_push_const_Rect(instance: *mut c_void, val: *const core::Rect);
		pub fn std_vectorLcv_RectG_insert_size_t_const_Rect(instance: *mut c_void, index: size_t, val: *const core::Rect);
		pub fn std_vectorLcv_RectG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Rect);
		pub fn std_vectorLcv_RectG_set_size_t_const_Rect(instance: *mut c_void, index: size_t, val: *const core::Rect);
		pub fn std_vectorLcv_RectG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_RectG_data_const(instance: *const c_void) -> *const core::Rect;
		pub fn std_vectorLcv_RectG_dataMut(instance: *mut c_void) -> *mut core::Rect;
		pub fn cv_fromSlice_const_const_RectX_size_t(data: *const core::Rect, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_RectG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_RectG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_RectG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Rect2dG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_Rect2dG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_Rect2dG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Rect2dG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_Rect2dG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Rect2dG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_Rect2dG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_Rect2dG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_Rect2dG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_Rect2dG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_Rect2dG_push_const_Rect2d(instance: *mut c_void, val: *const core::Rect2d);
		pub fn std_vectorLcv_Rect2dG_insert_size_t_const_Rect2d(instance: *mut c_void, index: size_t, val: *const core::Rect2d);
		pub fn std_vectorLcv_Rect2dG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Rect2d);
		pub fn std_vectorLcv_Rect2dG_set_size_t_const_Rect2d(instance: *mut c_void, index: size_t, val: *const core::Rect2d);
		pub fn std_vectorLcv_Rect2dG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_Rect2dG_data_const(instance: *const c_void) -> *const core::Rect2d;
		pub fn std_vectorLcv_Rect2dG_dataMut(instance: *mut c_void) -> *mut core::Rect2d;
		pub fn cv_fromSlice_const_const_Rect2dX_size_t(data: *const core::Rect2d, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_Rect2dG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Rect2dG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Rect2dG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_RotatedRectG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_RotatedRectG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_RotatedRectG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_RotatedRectG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_RotatedRectG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_RotatedRectG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_RotatedRectG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_RotatedRectG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_RotatedRectG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_RotatedRectG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_RotatedRectG_push_const_RotatedRect(instance: *mut c_void, val: *const core::RotatedRect);
		pub fn std_vectorLcv_RotatedRectG_insert_size_t_const_RotatedRect(instance: *mut c_void, index: size_t, val: *const core::RotatedRect);
		pub fn std_vectorLcv_RotatedRectG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::RotatedRect);
		pub fn std_vectorLcv_RotatedRectG_set_size_t_const_RotatedRect(instance: *mut c_void, index: size_t, val: *const core::RotatedRect);
		pub fn std_vectorLcv_RotatedRectG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_RotatedRectG_data_const(instance: *const c_void) -> *const core::RotatedRect;
		pub fn std_vectorLcv_RotatedRectG_dataMut(instance: *mut c_void) -> *mut core::RotatedRect;
		pub fn cv_fromSlice_const_const_RotatedRectX_size_t(data: *const core::RotatedRect, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_ScalarG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_ScalarG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_ScalarG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_ScalarG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_ScalarG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_ScalarG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_ScalarG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_ScalarG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_ScalarG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_ScalarG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_ScalarG_push_const_Scalar(instance: *mut c_void, val: *const core::Scalar);
		pub fn std_vectorLcv_ScalarG_insert_size_t_const_Scalar(instance: *mut c_void, index: size_t, val: *const core::Scalar);
		pub fn std_vectorLcv_ScalarG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Scalar);
		pub fn std_vectorLcv_ScalarG_set_size_t_const_Scalar(instance: *mut c_void, index: size_t, val: *const core::Scalar);
		pub fn std_vectorLcv_ScalarG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_ScalarG_data_const(instance: *const c_void) -> *const core::Scalar;
		pub fn std_vectorLcv_ScalarG_dataMut(instance: *mut c_void) -> *mut core::Scalar;
		pub fn cv_fromSlice_const_const_ScalarX_size_t(data: *const core::Scalar, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_ScalarG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_ScalarG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_ScalarG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_SizeG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_SizeG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_SizeG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_SizeG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_SizeG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_SizeG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_SizeG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_SizeG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_SizeG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_SizeG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_SizeG_push_const_Size(instance: *mut c_void, val: *const core::Size);
		pub fn std_vectorLcv_SizeG_insert_size_t_const_Size(instance: *mut c_void, index: size_t, val: *const core::Size);
		pub fn std_vectorLcv_SizeG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Size);
		pub fn std_vectorLcv_SizeG_set_size_t_const_Size(instance: *mut c_void, index: size_t, val: *const core::Size);
		pub fn std_vectorLcv_SizeG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_SizeG_data_const(instance: *const c_void) -> *const core::Size;
		pub fn std_vectorLcv_SizeG_dataMut(instance: *mut c_void) -> *mut core::Size;
		pub fn cv_fromSlice_const_const_SizeX_size_t(data: *const core::Size, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_SizeG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_SizeG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_SizeG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_StringG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_StringG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_StringG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_StringG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_StringG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_StringG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_StringG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_StringG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_StringG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_StringG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_StringG_push_const_String(instance: *mut c_void, val: *const c_char);
		pub fn std_vectorLcv_StringG_insert_size_t_const_String(instance: *mut c_void, index: size_t, val: *const c_char);
		pub fn std_vectorLcv_StringG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLcv_StringG_set_size_t_const_String(instance: *mut c_void, index: size_t, val: *const c_char);
		pub fn std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_push_const_pairLcv_Point2i__cv_Point2iG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_insert_size_t_const_pairLcv_Point2i__cv_Point2iG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_pairLcv_Point2i__cv_Point2iGG_set_size_t_const_pairLcv_Point2i__cv_Point2iG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_pairLcv_UMat__unsigned_charGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_pairLcv_UMat__unsigned_charGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_pairLcv_UMat__unsigned_charGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_pairLcv_UMat__unsigned_charGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_pairLcv_UMat__unsigned_charGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_pairLcv_UMat__unsigned_charGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_pairLcv_UMat__unsigned_charGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_pairLcv_UMat__unsigned_charGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_pairLcv_UMat__unsigned_charGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_pairLcv_UMat__unsigned_charGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_pairLcv_UMat__unsigned_charGG_push_const_pairLcv_UMat__unsigned_charG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_pairLcv_UMat__unsigned_charGG_insert_size_t_const_pairLcv_UMat__unsigned_charG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_pairLcv_UMat__unsigned_charGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_pairLcv_UMat__unsigned_charGG_set_size_t_const_pairLcv_UMat__unsigned_charG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_pairLint__doubleGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_pairLint__doubleGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_pairLint__doubleGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_pairLint__doubleGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_pairLint__doubleGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_pairLint__doubleGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_pairLint__doubleGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_pairLint__doubleGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_pairLint__doubleGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_pairLint__doubleGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_pairLint__doubleGG_push_const_pairLint__doubleG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_pairLint__doubleGG_insert_size_t_const_pairLint__doubleG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_pairLint__doubleGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_pairLint__doubleGG_set_size_t_const_pairLint__doubleG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_UMatG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_UMatG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_UMatG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_UMatG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_UMatG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_UMatG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_UMatG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_UMatG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_UMatG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_UMatG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_UMatG_push_const_UMat(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLcv_UMatG_insert_size_t_const_UMat(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_UMatG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLcv_UMatG_set_size_t_const_UMat(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_Vec2dG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_Vec2dG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_Vec2dG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec2dG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_Vec2dG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec2dG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_Vec2dG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_Vec2dG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_Vec2dG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_Vec2dG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_Vec2dG_push_const_Vec2d(instance: *mut c_void, val: *const core::Vec2d);
		pub fn std_vectorLcv_Vec2dG_insert_size_t_const_Vec2d(instance: *mut c_void, index: size_t, val: *const core::Vec2d);
		pub fn std_vectorLcv_Vec2dG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Vec2d);
		pub fn std_vectorLcv_Vec2dG_set_size_t_const_Vec2d(instance: *mut c_void, index: size_t, val: *const core::Vec2d);
		pub fn std_vectorLcv_Vec2dG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_Vec2dG_data_const(instance: *const c_void) -> *const core::Vec2d;
		pub fn std_vectorLcv_Vec2dG_dataMut(instance: *mut c_void) -> *mut core::Vec2d;
		pub fn cv_fromSlice_const_const_Vec2dX_size_t(data: *const core::Vec2d, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_Vec2dG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec2dG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec2dG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec2fG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_Vec2fG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_Vec2fG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec2fG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_Vec2fG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec2fG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_Vec2fG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_Vec2fG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_Vec2fG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_Vec2fG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_Vec2fG_push_const_Vec2f(instance: *mut c_void, val: *const core::Vec2f);
		pub fn std_vectorLcv_Vec2fG_insert_size_t_const_Vec2f(instance: *mut c_void, index: size_t, val: *const core::Vec2f);
		pub fn std_vectorLcv_Vec2fG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Vec2f);
		pub fn std_vectorLcv_Vec2fG_set_size_t_const_Vec2f(instance: *mut c_void, index: size_t, val: *const core::Vec2f);
		pub fn std_vectorLcv_Vec2fG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_Vec2fG_data_const(instance: *const c_void) -> *const core::Vec2f;
		pub fn std_vectorLcv_Vec2fG_dataMut(instance: *mut c_void) -> *mut core::Vec2f;
		pub fn cv_fromSlice_const_const_Vec2fX_size_t(data: *const core::Vec2f, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_Vec2fG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec2fG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec2fG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec2iG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_Vec2iG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_Vec2iG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec2iG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_Vec2iG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec2iG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_Vec2iG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_Vec2iG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_Vec2iG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_Vec2iG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_Vec2iG_push_const_Vec2i(instance: *mut c_void, val: *const core::Vec2i);
		pub fn std_vectorLcv_Vec2iG_insert_size_t_const_Vec2i(instance: *mut c_void, index: size_t, val: *const core::Vec2i);
		pub fn std_vectorLcv_Vec2iG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Vec2i);
		pub fn std_vectorLcv_Vec2iG_set_size_t_const_Vec2i(instance: *mut c_void, index: size_t, val: *const core::Vec2i);
		pub fn std_vectorLcv_Vec2iG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_Vec2iG_data_const(instance: *const c_void) -> *const core::Vec2i;
		pub fn std_vectorLcv_Vec2iG_dataMut(instance: *mut c_void) -> *mut core::Vec2i;
		pub fn cv_fromSlice_const_const_Vec2iX_size_t(data: *const core::Vec2i, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_Vec2iG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec2iG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec2iG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec3dG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_Vec3dG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_Vec3dG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec3dG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_Vec3dG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec3dG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_Vec3dG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_Vec3dG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_Vec3dG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_Vec3dG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_Vec3dG_push_const_Vec3d(instance: *mut c_void, val: *const core::Vec3d);
		pub fn std_vectorLcv_Vec3dG_insert_size_t_const_Vec3d(instance: *mut c_void, index: size_t, val: *const core::Vec3d);
		pub fn std_vectorLcv_Vec3dG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Vec3d);
		pub fn std_vectorLcv_Vec3dG_set_size_t_const_Vec3d(instance: *mut c_void, index: size_t, val: *const core::Vec3d);
		pub fn std_vectorLcv_Vec3dG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_Vec3dG_data_const(instance: *const c_void) -> *const core::Vec3d;
		pub fn std_vectorLcv_Vec3dG_dataMut(instance: *mut c_void) -> *mut core::Vec3d;
		pub fn cv_fromSlice_const_const_Vec3dX_size_t(data: *const core::Vec3d, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_Vec3dG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec3dG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec3dG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec3fG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_Vec3fG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_Vec3fG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec3fG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_Vec3fG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec3fG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_Vec3fG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_Vec3fG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_Vec3fG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_Vec3fG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_Vec3fG_push_const_Vec3f(instance: *mut c_void, val: *const core::Vec3f);
		pub fn std_vectorLcv_Vec3fG_insert_size_t_const_Vec3f(instance: *mut c_void, index: size_t, val: *const core::Vec3f);
		pub fn std_vectorLcv_Vec3fG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Vec3f);
		pub fn std_vectorLcv_Vec3fG_set_size_t_const_Vec3f(instance: *mut c_void, index: size_t, val: *const core::Vec3f);
		pub fn std_vectorLcv_Vec3fG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_Vec3fG_data_const(instance: *const c_void) -> *const core::Vec3f;
		pub fn std_vectorLcv_Vec3fG_dataMut(instance: *mut c_void) -> *mut core::Vec3f;
		pub fn cv_fromSlice_const_const_Vec3fX_size_t(data: *const core::Vec3f, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_Vec3fG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec3fG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec3fG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec3iG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_Vec3iG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_Vec3iG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec3iG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_Vec3iG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec3iG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_Vec3iG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_Vec3iG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_Vec3iG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_Vec3iG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_Vec3iG_push_const_Vec3i(instance: *mut c_void, val: *const core::Vec3i);
		pub fn std_vectorLcv_Vec3iG_insert_size_t_const_Vec3i(instance: *mut c_void, index: size_t, val: *const core::Vec3i);
		pub fn std_vectorLcv_Vec3iG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Vec3i);
		pub fn std_vectorLcv_Vec3iG_set_size_t_const_Vec3i(instance: *mut c_void, index: size_t, val: *const core::Vec3i);
		pub fn std_vectorLcv_Vec3iG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_Vec3iG_data_const(instance: *const c_void) -> *const core::Vec3i;
		pub fn std_vectorLcv_Vec3iG_dataMut(instance: *mut c_void) -> *mut core::Vec3i;
		pub fn cv_fromSlice_const_const_Vec3iX_size_t(data: *const core::Vec3i, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_Vec3iG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec3iG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec3iG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec4fG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_Vec4fG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_Vec4fG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec4fG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_Vec4fG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec4fG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_Vec4fG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_Vec4fG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_Vec4fG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_Vec4fG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_Vec4fG_push_const_Vec4f(instance: *mut c_void, val: *const core::Vec4f);
		pub fn std_vectorLcv_Vec4fG_insert_size_t_const_Vec4f(instance: *mut c_void, index: size_t, val: *const core::Vec4f);
		pub fn std_vectorLcv_Vec4fG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Vec4f);
		pub fn std_vectorLcv_Vec4fG_set_size_t_const_Vec4f(instance: *mut c_void, index: size_t, val: *const core::Vec4f);
		pub fn std_vectorLcv_Vec4fG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_Vec4fG_data_const(instance: *const c_void) -> *const core::Vec4f;
		pub fn std_vectorLcv_Vec4fG_dataMut(instance: *mut c_void) -> *mut core::Vec4f;
		pub fn cv_fromSlice_const_const_Vec4fX_size_t(data: *const core::Vec4f, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_Vec4fG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec4fG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec4fG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec4iG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_Vec4iG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_Vec4iG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec4iG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_Vec4iG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec4iG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_Vec4iG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_Vec4iG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_Vec4iG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_Vec4iG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_Vec4iG_push_const_Vec4i(instance: *mut c_void, val: *const core::Vec4i);
		pub fn std_vectorLcv_Vec4iG_insert_size_t_const_Vec4i(instance: *mut c_void, index: size_t, val: *const core::Vec4i);
		pub fn std_vectorLcv_Vec4iG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Vec4i);
		pub fn std_vectorLcv_Vec4iG_set_size_t_const_Vec4i(instance: *mut c_void, index: size_t, val: *const core::Vec4i);
		pub fn std_vectorLcv_Vec4iG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_Vec4iG_data_const(instance: *const c_void) -> *const core::Vec4i;
		pub fn std_vectorLcv_Vec4iG_dataMut(instance: *mut c_void) -> *mut core::Vec4i;
		pub fn cv_fromSlice_const_const_Vec4iX_size_t(data: *const core::Vec4i, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_Vec4iG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec4iG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec4iG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec6fG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_Vec6fG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_Vec6fG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec6fG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_Vec6fG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_Vec6fG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_Vec6fG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_Vec6fG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_Vec6fG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_Vec6fG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_Vec6fG_push_const_Vec6f(instance: *mut c_void, val: *const core::Vec6f);
		pub fn std_vectorLcv_Vec6fG_insert_size_t_const_Vec6f(instance: *mut c_void, index: size_t, val: *const core::Vec6f);
		pub fn std_vectorLcv_Vec6fG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut core::Vec6f);
		pub fn std_vectorLcv_Vec6fG_set_size_t_const_Vec6f(instance: *mut c_void, index: size_t, val: *const core::Vec6f);
		pub fn std_vectorLcv_Vec6fG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_Vec6fG_data_const(instance: *const c_void) -> *const core::Vec6f;
		pub fn std_vectorLcv_Vec6fG_dataMut(instance: *mut c_void) -> *mut core::Vec6f;
		pub fn cv_fromSlice_const_const_Vec6fX_size_t(data: *const core::Vec6f, len: size_t) -> *mut c_void;
		pub fn std_vectorLcv_Vec6fG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec6fG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_Vec6fG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_DMatchGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_DMatchGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_DMatchGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_DMatchGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_DMatchGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_DMatchGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_DMatchGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_DMatchGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_DMatchGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_DMatchGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_DMatchGG_push_const_vectorLDMatchG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_DMatchGG_insert_size_t_const_vectorLDMatchG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_DMatchGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_DMatchGG_set_size_t_const_vectorLDMatchG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_KeyPointGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_KeyPointGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_KeyPointGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_KeyPointGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_KeyPointGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_KeyPointGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_KeyPointGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_KeyPointGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_KeyPointGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_KeyPointGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_KeyPointGG_push_const_vectorLKeyPointG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_KeyPointGG_insert_size_t_const_vectorLKeyPointG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_KeyPointGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_KeyPointGG_set_size_t_const_vectorLKeyPointG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_MatGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_MatGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_MatGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_MatGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_MatGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_MatGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_MatGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_MatGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_MatGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_MatGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_MatGG_push_const_vectorLMatG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_MatGG_insert_size_t_const_vectorLMatG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_MatGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_MatGG_set_size_t_const_vectorLMatG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_PointGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_PointGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_PointGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_PointGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_PointGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_PointGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_PointGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_PointGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_PointGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_PointGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_PointGG_push_const_vectorLPointG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_PointGG_insert_size_t_const_vectorLPointG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_PointGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_PointGG_set_size_t_const_vectorLPointG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_PointGG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_PointGG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_PointGG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Point2dGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_Point2dGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point2dGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Point2dGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_Point2dGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Point2dGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point2dGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_Point2dGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_Point2dGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_Point2dGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point2dGG_push_const_vectorLPoint2dG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Point2dGG_insert_size_t_const_vectorLPoint2dG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Point2dGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point2dGG_set_size_t_const_vectorLPoint2dG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Point2dGG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Point2dGG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Point2dGG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Point2fGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_Point2fGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point2fGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Point2fGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_Point2fGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Point2fGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point2fGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_Point2fGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_Point2fGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_Point2fGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point2fGG_push_const_vectorLPoint2fG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Point2fGG_insert_size_t_const_vectorLPoint2fG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Point2fGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point2fGG_set_size_t_const_vectorLPoint2fG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Point2fGG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Point2fGG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Point2fGG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Point3dGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_Point3dGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point3dGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Point3dGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_Point3dGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Point3dGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point3dGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_Point3dGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_Point3dGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_Point3dGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point3dGG_push_const_vectorLPoint3dG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Point3dGG_insert_size_t_const_vectorLPoint3dG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Point3dGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point3dGG_set_size_t_const_vectorLPoint3dG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Point3dGG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Point3dGG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Point3dGG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Point3fGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_Point3fGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point3fGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Point3fGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_Point3fGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Point3fGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point3fGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_Point3fGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_Point3fGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_Point3fGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point3fGG_push_const_vectorLPoint3fG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Point3fGG_insert_size_t_const_vectorLPoint3fG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Point3fGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point3fGG_set_size_t_const_vectorLPoint3fG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Point3fGG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Point3fGG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Point3fGG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Point3iGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_Point3iGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point3iGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Point3iGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_Point3iGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Point3iGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point3iGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_Point3iGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_Point3iGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_Point3iGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point3iGG_push_const_vectorLPoint3iG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Point3iGG_insert_size_t_const_vectorLPoint3iG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Point3iGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Point3iGG_set_size_t_const_vectorLPoint3iG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Point3iGG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Point3iGG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Point3iGG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_RangeGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_RangeGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_RangeGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_RangeGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_RangeGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_RangeGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_RangeGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_RangeGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_RangeGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_RangeGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_RangeGG_push_const_vectorLRangeG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_RangeGG_insert_size_t_const_vectorLRangeG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_RangeGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_RangeGG_set_size_t_const_vectorLRangeG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_push_const_vectorLVec2dG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_insert_size_t_const_vectorLVec2dG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_set_size_t_const_vectorLVec2dG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Vec2dGG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_push_const_vectorLVec2fG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_insert_size_t_const_vectorLVec2fG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_set_size_t_const_vectorLVec2fG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Vec2fGG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_push_const_vectorLVec2iG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_insert_size_t_const_vectorLVec2iG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_set_size_t_const_vectorLVec2iG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Vec2iGG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_push_const_vectorLVec3dG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_insert_size_t_const_vectorLVec3dG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_set_size_t_const_vectorLVec3dG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Vec3dGG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_push_const_vectorLVec3fG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_insert_size_t_const_vectorLVec3fG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_set_size_t_const_vectorLVec3fG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLcv_Vec3fGG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLfloatGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLfloatGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLfloatGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLfloatGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLfloatGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLfloatGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLfloatGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLfloatGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLfloatGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLfloatGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLfloatGG_push_const_vectorLfloatG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLfloatGG_insert_size_t_const_vectorLfloatG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLfloatGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLfloatGG_set_size_t_const_vectorLfloatG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLfloatGG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLfloatGG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLfloatGG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLdoubleGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLdoubleGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLdoubleGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLdoubleGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLdoubleGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLdoubleGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLdoubleGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLdoubleGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLdoubleGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLdoubleGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLdoubleGG_push_const_vectorLdoubleG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLdoubleGG_insert_size_t_const_vectorLdoubleG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLdoubleGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLdoubleGG_set_size_t_const_vectorLdoubleG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLdoubleGG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLdoubleGG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLdoubleGG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLintGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLintGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLintGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLintGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLintGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLintGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLintGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLintGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLintGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLintGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLintGG_push_const_vectorLintG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLintGG_insert_size_t_const_vectorLintG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLintGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLintGG_set_size_t_const_vectorLintG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLintGG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLintGG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLintGG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLsigned_charGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLsigned_charGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLsigned_charGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLsigned_charGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLsigned_charGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLsigned_charGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLsigned_charGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLsigned_charGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLsigned_charGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLsigned_charGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLsigned_charGG_push_const_vectorLsigned_charG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLsigned_charGG_insert_size_t_const_vectorLsigned_charG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLsigned_charGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLsigned_charGG_set_size_t_const_vectorLsigned_charG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLuint8_tGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLuint8_tGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLuint8_tGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLuint8_tGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLuint8_tGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLuint8_tGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLuint8_tGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLuint8_tGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLuint8_tGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLuint8_tGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLuint8_tGG_push_const_vectorLuint8_tG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLuint8_tGG_insert_size_t_const_vectorLuint8_tG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLuint8_tGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLuint8_tGG_set_size_t_const_vectorLuint8_tG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLuint8_tGG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLuint8_tGG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLstd_vectorLuint8_tGG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLboolG_new_const() -> *mut c_void;
		pub fn std_vectorLboolG_delete(instance: *mut c_void);
		pub fn std_vectorLboolG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLboolG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLboolG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLboolG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLboolG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLboolG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLboolG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLboolG_clear(instance: *mut c_void);
		pub fn std_vectorLboolG_push_const_bool(instance: *mut c_void, val: bool);
		pub fn std_vectorLboolG_insert_size_t_const_bool(instance: *mut c_void, index: size_t, val: bool);
		pub fn std_vectorLboolG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut bool);
		pub fn std_vectorLboolG_set_size_t_const_bool(instance: *mut c_void, index: size_t, val: bool);
		pub fn std_vectorLboolG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLfloatG_new_const() -> *mut c_void;
		pub fn std_vectorLfloatG_delete(instance: *mut c_void);
		pub fn std_vectorLfloatG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLfloatG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLfloatG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLfloatG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLfloatG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLfloatG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLfloatG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLfloatG_clear(instance: *mut c_void);
		pub fn std_vectorLfloatG_push_const_float(instance: *mut c_void, val: f32);
		pub fn std_vectorLfloatG_insert_size_t_const_float(instance: *mut c_void, index: size_t, val: f32);
		pub fn std_vectorLfloatG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut f32);
		pub fn std_vectorLfloatG_set_size_t_const_float(instance: *mut c_void, index: size_t, val: f32);
		pub fn std_vectorLfloatG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLfloatG_data_const(instance: *const c_void) -> *const f32;
		pub fn std_vectorLfloatG_dataMut(instance: *mut c_void) -> *mut f32;
		pub fn cv_fromSlice_const_const_floatX_size_t(data: *const f32, len: size_t) -> *mut c_void;
		pub fn std_vectorLfloatG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLfloatG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLfloatG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLdoubleG_new_const() -> *mut c_void;
		pub fn std_vectorLdoubleG_delete(instance: *mut c_void);
		pub fn std_vectorLdoubleG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLdoubleG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLdoubleG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLdoubleG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLdoubleG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLdoubleG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLdoubleG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLdoubleG_clear(instance: *mut c_void);
		pub fn std_vectorLdoubleG_push_const_double(instance: *mut c_void, val: f64);
		pub fn std_vectorLdoubleG_insert_size_t_const_double(instance: *mut c_void, index: size_t, val: f64);
		pub fn std_vectorLdoubleG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut f64);
		pub fn std_vectorLdoubleG_set_size_t_const_double(instance: *mut c_void, index: size_t, val: f64);
		pub fn std_vectorLdoubleG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLdoubleG_data_const(instance: *const c_void) -> *const f64;
		pub fn std_vectorLdoubleG_dataMut(instance: *mut c_void) -> *mut f64;
		pub fn cv_fromSlice_const_const_doubleX_size_t(data: *const f64, len: size_t) -> *mut c_void;
		pub fn std_vectorLdoubleG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLdoubleG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLdoubleG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLintG_new_const() -> *mut c_void;
		pub fn std_vectorLintG_delete(instance: *mut c_void);
		pub fn std_vectorLintG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLintG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLintG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLintG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLintG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLintG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLintG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLintG_clear(instance: *mut c_void);
		pub fn std_vectorLintG_push_const_int(instance: *mut c_void, val: i32);
		pub fn std_vectorLintG_insert_size_t_const_int(instance: *mut c_void, index: size_t, val: i32);
		pub fn std_vectorLintG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut i32);
		pub fn std_vectorLintG_set_size_t_const_int(instance: *mut c_void, index: size_t, val: i32);
		pub fn std_vectorLintG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLintG_data_const(instance: *const c_void) -> *const i32;
		pub fn std_vectorLintG_dataMut(instance: *mut c_void) -> *mut i32;
		pub fn cv_fromSlice_const_const_intX_size_t(data: *const i32, len: size_t) -> *mut c_void;
		pub fn std_vectorLintG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLintG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLintG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLsigned_charG_new_const() -> *mut c_void;
		pub fn std_vectorLsigned_charG_delete(instance: *mut c_void);
		pub fn std_vectorLsigned_charG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLsigned_charG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLsigned_charG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLsigned_charG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLsigned_charG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLsigned_charG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLsigned_charG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLsigned_charG_clear(instance: *mut c_void);
		pub fn std_vectorLsigned_charG_push_const_signed_char(instance: *mut c_void, val: i8);
		pub fn std_vectorLsigned_charG_insert_size_t_const_signed_char(instance: *mut c_void, index: size_t, val: i8);
		pub fn std_vectorLsigned_charG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut i8);
		pub fn std_vectorLsigned_charG_set_size_t_const_signed_char(instance: *mut c_void, index: size_t, val: i8);
		pub fn std_vectorLsigned_charG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLsigned_charG_data_const(instance: *const c_void) -> *const i8;
		pub fn std_vectorLsigned_charG_dataMut(instance: *mut c_void) -> *mut i8;
		pub fn cv_fromSlice_const_const_signed_charX_size_t(data: *const i8, len: size_t) -> *mut c_void;
		pub fn std_vectorLsize_tG_new_const() -> *mut c_void;
		pub fn std_vectorLsize_tG_delete(instance: *mut c_void);
		pub fn std_vectorLsize_tG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLsize_tG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLsize_tG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLsize_tG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLsize_tG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLsize_tG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLsize_tG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLsize_tG_clear(instance: *mut c_void);
		pub fn std_vectorLsize_tG_push_const_size_t(instance: *mut c_void, val: size_t);
		pub fn std_vectorLsize_tG_insert_size_t_const_size_t(instance: *mut c_void, index: size_t, val: size_t);
		pub fn std_vectorLsize_tG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut size_t);
		pub fn std_vectorLsize_tG_set_size_t_const_size_t(instance: *mut c_void, index: size_t, val: size_t);
		pub fn std_vectorLsize_tG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLsize_tG_data_const(instance: *const c_void) -> *const size_t;
		pub fn std_vectorLsize_tG_dataMut(instance: *mut c_void) -> *mut size_t;
		pub fn cv_fromSlice_const_const_size_tX_size_t(data: *const size_t, len: size_t) -> *mut c_void;
		pub fn std_vectorLuint64_tG_new_const() -> *mut c_void;
		pub fn std_vectorLuint64_tG_delete(instance: *mut c_void);
		pub fn std_vectorLuint64_tG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLuint64_tG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLuint64_tG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLuint64_tG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLuint64_tG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLuint64_tG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLuint64_tG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLuint64_tG_clear(instance: *mut c_void);
		pub fn std_vectorLuint64_tG_push_const_uint64_t(instance: *mut c_void, val: u64);
		pub fn std_vectorLuint64_tG_insert_size_t_const_uint64_t(instance: *mut c_void, index: size_t, val: u64);
		pub fn std_vectorLuint64_tG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut u64);
		pub fn std_vectorLuint64_tG_set_size_t_const_uint64_t(instance: *mut c_void, index: size_t, val: u64);
		pub fn std_vectorLuint64_tG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLuint64_tG_data_const(instance: *const c_void) -> *const u64;
		pub fn std_vectorLuint64_tG_dataMut(instance: *mut c_void) -> *mut u64;
		pub fn cv_fromSlice_const_const_uint64_tX_size_t(data: *const u64, len: size_t) -> *mut c_void;
		#[cfg(ocvrs_opencv_branch_5)]
		pub fn std_vectorLuint64_tG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		#[cfg(ocvrs_opencv_branch_5)]
		pub fn std_vectorLuint64_tG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		#[cfg(ocvrs_opencv_branch_5)]
		pub fn std_vectorLuint64_tG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLuint8_tG_new_const() -> *mut c_void;
		pub fn std_vectorLuint8_tG_delete(instance: *mut c_void);
		pub fn std_vectorLuint8_tG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLuint8_tG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLuint8_tG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLuint8_tG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLuint8_tG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLuint8_tG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLuint8_tG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLuint8_tG_clear(instance: *mut c_void);
		pub fn std_vectorLuint8_tG_push_const_uint8_t(instance: *mut c_void, val: u8);
		pub fn std_vectorLuint8_tG_insert_size_t_const_uint8_t(instance: *mut c_void, index: size_t, val: u8);
		pub fn std_vectorLuint8_tG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut u8);
		pub fn std_vectorLuint8_tG_set_size_t_const_uint8_t(instance: *mut c_void, index: size_t, val: u8);
		pub fn std_vectorLuint8_tG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLuint8_tG_data_const(instance: *const c_void) -> *const u8;
		pub fn std_vectorLuint8_tG_dataMut(instance: *mut c_void) -> *mut u8;
		pub fn cv_fromSlice_const_const_uint8_tX_size_t(data: *const u8, len: size_t) -> *mut c_void;
		pub fn std_vectorLuint8_tG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLuint8_tG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLuint8_tG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
	}
}
pub use core_sys::*;

mod cudaarithm_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_cuda_absSum_const__InputArrayR(src: *const c_void, ocvrs_return: *mut Result<core::Scalar>);
		pub fn cv_cuda_absSum_const__InputArrayR_const__InputArrayR(src: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<core::Scalar>);
		pub fn cv_cuda_abs_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_abs_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_absdiffWithScalar_const__InputArrayR_Scalar_const__OutputArrayR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_absdiffWithScalar_const__InputArrayR_Scalar_const__OutputArrayR_StreamR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_absdiff_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_absdiff_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_addWeighted_const__InputArrayR_double_const__InputArrayR_double_double_const__OutputArrayR(src1: *const c_void, alpha: f64, src2: *const c_void, beta: f64, gamma: f64, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_addWeighted_const__InputArrayR_double_const__InputArrayR_double_double_const__OutputArrayR_int_StreamR(src1: *const c_void, alpha: f64, src2: *const c_void, beta: f64, gamma: f64, dst: *const c_void, dtype: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_addWithScalar_const__InputArrayR_Scalar_const__OutputArrayR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_addWithScalar_const__InputArrayR_Scalar_const__OutputArrayR_const__InputArrayR_int_StreamR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, mask: *const c_void, dtype: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_add_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_add_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_int_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, dtype: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bitwise_and_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bitwise_and_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bitwise_and_with_scalar_const__InputArrayR_Scalar_const__OutputArrayR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bitwise_and_with_scalar_const__InputArrayR_Scalar_const__OutputArrayR_const__InputArrayR_StreamR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bitwise_not_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bitwise_not_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bitwise_or_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bitwise_or_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bitwise_or_with_scalar_const__InputArrayR_Scalar_const__OutputArrayR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bitwise_or_with_scalar_const__InputArrayR_Scalar_const__OutputArrayR_const__InputArrayR_StreamR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bitwise_xor_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bitwise_xor_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bitwise_xor_with_scalar_const__InputArrayR_Scalar_const__OutputArrayR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bitwise_xor_with_scalar_const__InputArrayR_Scalar_const__OutputArrayR_const__InputArrayR_StreamR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_calcAbsSum_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_calcAbsSum_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_calcNormDiff_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_calcNormDiff_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, norm_type: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_calcNorm_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, norm_type: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_calcNorm_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR_StreamR(src: *const c_void, dst: *const c_void, norm_type: i32, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_calcSqrSum_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_calcSqrSum_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_calcSum_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_calcSum_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_cartToPolar_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(x: *const c_void, y: *const c_void, magnitude: *const c_void, angle: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_cartToPolar_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_StreamR(x: *const c_void, y: *const c_void, magnitude: *const c_void, angle: *const c_void, angle_in_degrees: bool, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_cartToPolar_const__InputArrayR_const__OutputArrayR(xy: *const c_void, magnitude_angle: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_cartToPolar_const__InputArrayR_const__OutputArrayR_bool_StreamR(xy: *const c_void, magnitude_angle: *const c_void, angle_in_degrees: bool, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_cartToPolar_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(xy: *const c_void, magnitude: *const c_void, angle: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_cartToPolar_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_StreamR(xy: *const c_void, magnitude: *const c_void, angle: *const c_void, angle_in_degrees: bool, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_compareWithScalar_const__InputArrayR_Scalar_const__OutputArrayR_int(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, cmpop: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_compareWithScalar_const__InputArrayR_Scalar_const__OutputArrayR_int_StreamR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, cmpop: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_compare_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int(src1: *const c_void, src2: *const c_void, dst: *const c_void, cmpop: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_compare_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, cmpop: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_copyMakeBorder_const__InputArrayR_const__OutputArrayR_int_int_int_int_int(src: *const c_void, dst: *const c_void, top: i32, bottom: i32, left: i32, right: i32, border_type: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_copyMakeBorder_const__InputArrayR_const__OutputArrayR_int_int_int_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, top: i32, bottom: i32, left: i32, right: i32, border_type: i32, value: *const core::Scalar, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_countNonZero_const__InputArrayR(src: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_countNonZero_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_countNonZero_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_createConvolution(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createConvolution_Size(user_block_size: *const core::Size, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createDFT_Size_int(dft_size: *const core::Size, flags: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createLookUpTable_const__InputArrayR(lut: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_dft_const__InputArrayR_const__OutputArrayR_Size(src: *const c_void, dst: *const c_void, dft_size: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_dft_const__InputArrayR_const__OutputArrayR_Size_int_StreamR(src: *const c_void, dst: *const c_void, dft_size: *const core::Size, flags: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_divideWithScalar_const__InputArrayR_Scalar_const__OutputArrayR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_divideWithScalar_const__InputArrayR_Scalar_const__OutputArrayR_double_int_StreamR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, scale: f64, dtype: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_divide_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_divide_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_int_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, scale: f64, dtype: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_exp_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_exp_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_findMinMaxLoc_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(src: *const c_void, min_max_vals: *const c_void, loc: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_findMinMaxLoc_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src: *const c_void, min_max_vals: *const c_void, loc: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_findMinMax_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_findMinMax_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_flip_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, flip_code: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_flip_const__InputArrayR_const__OutputArrayR_int_StreamR(src: *const c_void, dst: *const c_void, flip_code: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_gemm_const__InputArrayR_const__InputArrayR_double_const__InputArrayR_double_const__OutputArrayR(src1: *const c_void, src2: *const c_void, alpha: f64, src3: *const c_void, beta: f64, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_gemm_const__InputArrayR_const__InputArrayR_double_const__InputArrayR_double_const__OutputArrayR_int_StreamR(src1: *const c_void, src2: *const c_void, alpha: f64, src3: *const c_void, beta: f64, dst: *const c_void, flags: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_inRange_const__InputArrayR_const_ScalarR_const_ScalarR_const__OutputArrayR(src: *const c_void, lowerb: *const core::Scalar, upperb: *const core::Scalar, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_inRange_const__InputArrayR_const_ScalarR_const_ScalarR_const__OutputArrayR_StreamR(src: *const c_void, lowerb: *const core::Scalar, upperb: *const core::Scalar, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_integral_const__InputArrayR_const__OutputArrayR(src: *const c_void, sum: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_integral_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, sum: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_log_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_log_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_lshift_const__InputArrayR_Scalar_LintG_const__OutputArrayR(src: *const c_void, val: *const core::Scalar_<i32>, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_lshift_const__InputArrayR_Scalar_LintG_const__OutputArrayR_StreamR(src: *const c_void, val: *const core::Scalar_<i32>, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_lshift_const__InputArrayR_Scalar_const__OutputArrayR(src: *const c_void, val: *const core::Scalar, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_lshift_const__InputArrayR_Scalar_const__OutputArrayR_StreamR(src: *const c_void, val: *const core::Scalar, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_magnitudeSqr_const__InputArrayR_const__InputArrayR_const__OutputArrayR(x: *const c_void, y: *const c_void, magnitude: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_magnitudeSqr_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(x: *const c_void, y: *const c_void, magnitude: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_magnitudeSqr_const__InputArrayR_const__OutputArrayR(xy: *const c_void, magnitude: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_magnitudeSqr_const__InputArrayR_const__OutputArrayR_StreamR(xy: *const c_void, magnitude: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_magnitude_const__InputArrayR_const__InputArrayR_const__OutputArrayR(x: *const c_void, y: *const c_void, magnitude: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_magnitude_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(x: *const c_void, y: *const c_void, magnitude: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_magnitude_const__InputArrayR_const__OutputArrayR(xy: *const c_void, magnitude: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_magnitude_const__InputArrayR_const__OutputArrayR_StreamR(xy: *const c_void, magnitude: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_maxWithScalar_const__InputArrayR_Scalar_const__OutputArrayR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_maxWithScalar_const__InputArrayR_Scalar_const__OutputArrayR_StreamR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_max_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_max_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_meanStdDev_const__InputArrayR_ScalarR_ScalarR(mtx: *const c_void, mean: *mut core::Scalar, stddev: *mut core::Scalar, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_meanStdDev_const__InputArrayR_ScalarR_ScalarR_const__InputArrayR(src: *const c_void, mean: *mut core::Scalar, stddev: *mut core::Scalar, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_meanStdDev_const__InputArrayR_const__OutputArrayR(mtx: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_meanStdDev_const__InputArrayR_const__OutputArrayR_StreamR(mtx: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_meanStdDev_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src: *const c_void, dst: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_meanStdDev_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src: *const c_void, dst: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_merge_const_GpuMatX_size_t_const__OutputArrayR(src: *const c_void, n: size_t, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_merge_const_GpuMatX_size_t_const__OutputArrayR_StreamR(src: *const c_void, n: size_t, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_merge_const_vectorLGpuMatGR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_merge_const_vectorLGpuMatGR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_minMaxLoc_const__InputArrayR_doubleX_doubleX_PointX_PointX(src: *const c_void, min_val: *mut f64, max_val: *mut f64, min_loc: *mut core::Point, max_loc: *mut core::Point, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_minMaxLoc_const__InputArrayR_doubleX_doubleX_PointX_PointX_const__InputArrayR(src: *const c_void, min_val: *mut f64, max_val: *mut f64, min_loc: *mut core::Point, max_loc: *mut core::Point, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_minMax_const__InputArrayR_doubleX_doubleX(src: *const c_void, min_val: *mut f64, max_val: *mut f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_minMax_const__InputArrayR_doubleX_doubleX_const__InputArrayR(src: *const c_void, min_val: *mut f64, max_val: *mut f64, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_minWithScalar_const__InputArrayR_Scalar_const__OutputArrayR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_minWithScalar_const__InputArrayR_Scalar_const__OutputArrayR_StreamR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_min_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_min_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_mulAndScaleSpectrums_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_float(src1: *const c_void, src2: *const c_void, dst: *const c_void, flags: i32, scale: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_mulAndScaleSpectrums_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_float_bool_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, flags: i32, scale: f32, conj_b: bool, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_mulSpectrums_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int(src1: *const c_void, src2: *const c_void, dst: *const c_void, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_mulSpectrums_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_bool_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, flags: i32, conj_b: bool, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_multiplyWithScalar_const__InputArrayR_Scalar_const__OutputArrayR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_multiplyWithScalar_const__InputArrayR_Scalar_const__OutputArrayR_double_int_StreamR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, scale: f64, dtype: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_multiply_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_multiply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_int_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, scale: f64, dtype: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_norm_const__InputArrayR_const__InputArrayR(src1: *const c_void, src2: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_norm_const__InputArrayR_const__InputArrayR_int(src1: *const c_void, src2: *const c_void, norm_type: i32, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_norm_const__InputArrayR_int(src1: *const c_void, norm_type: i32, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_norm_const__InputArrayR_int_const__InputArrayR(src1: *const c_void, norm_type: i32, mask: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_normalize_const__InputArrayR_const__OutputArrayR_double_double_int_int(src: *const c_void, dst: *const c_void, alpha: f64, beta: f64, norm_type: i32, dtype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_normalize_const__InputArrayR_const__OutputArrayR_double_double_int_int_const__InputArrayR_StreamR(src: *const c_void, dst: *const c_void, alpha: f64, beta: f64, norm_type: i32, dtype: i32, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_phase_const__InputArrayR_const__InputArrayR_const__OutputArrayR(x: *const c_void, y: *const c_void, angle: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_phase_const__InputArrayR_const__InputArrayR_const__OutputArrayR_bool_StreamR(x: *const c_void, y: *const c_void, angle: *const c_void, angle_in_degrees: bool, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_phase_const__InputArrayR_const__OutputArrayR(xy: *const c_void, angle: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_phase_const__InputArrayR_const__OutputArrayR_bool_StreamR(xy: *const c_void, angle: *const c_void, angle_in_degrees: bool, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_polarToCart_const__InputArrayR_const__InputArrayR_const__OutputArrayR(magnitude: *const c_void, angle: *const c_void, xy: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_polarToCart_const__InputArrayR_const__InputArrayR_const__OutputArrayR_bool_StreamR(magnitude: *const c_void, angle: *const c_void, xy: *const c_void, angle_in_degrees: bool, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_polarToCart_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(magnitude: *const c_void, angle: *const c_void, x: *const c_void, y: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_polarToCart_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_StreamR(magnitude: *const c_void, angle: *const c_void, x: *const c_void, y: *const c_void, angle_in_degrees: bool, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_polarToCart_const__InputArrayR_const__OutputArrayR(magnitude_angle: *const c_void, xy: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_polarToCart_const__InputArrayR_const__OutputArrayR_bool_StreamR(magnitude_angle: *const c_void, xy: *const c_void, angle_in_degrees: bool, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_pow_const__InputArrayR_double_const__OutputArrayR(src: *const c_void, power: f64, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_pow_const__InputArrayR_double_const__OutputArrayR_StreamR(src: *const c_void, power: f64, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_rectStdDev_const__InputArrayR_const__InputArrayR_const__OutputArrayR_Rect(src: *const c_void, sqr: *const c_void, dst: *const c_void, rect: *const core::Rect, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_rectStdDev_const__InputArrayR_const__InputArrayR_const__OutputArrayR_Rect_StreamR(src: *const c_void, sqr: *const c_void, dst: *const c_void, rect: *const core::Rect, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_reduce_const__InputArrayR_const__OutputArrayR_int_int(mtx: *const c_void, vec: *const c_void, dim: i32, reduce_op: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_reduce_const__InputArrayR_const__OutputArrayR_int_int_int_StreamR(mtx: *const c_void, vec: *const c_void, dim: i32, reduce_op: i32, dtype: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_rshift_const__InputArrayR_Scalar_LintG_const__OutputArrayR(src: *const c_void, val: *const core::Scalar_<i32>, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_rshift_const__InputArrayR_Scalar_LintG_const__OutputArrayR_StreamR(src: *const c_void, val: *const core::Scalar_<i32>, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_rshift_const__InputArrayR_Scalar_const__OutputArrayR(src: *const c_void, val: *const core::Scalar, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_rshift_const__InputArrayR_Scalar_const__OutputArrayR_StreamR(src: *const c_void, val: *const core::Scalar, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_split_const__InputArrayR_GpuMatX(src: *const c_void, dst: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_split_const__InputArrayR_GpuMatX_StreamR(src: *const c_void, dst: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_split_const__InputArrayR_vectorLGpuMatGR(src: *const c_void, dst: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_split_const__InputArrayR_vectorLGpuMatGR_StreamR(src: *const c_void, dst: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_sqrIntegral_const__InputArrayR_const__OutputArrayR(src: *const c_void, sqsum: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_sqrIntegral_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, sqsum: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_sqrSum_const__InputArrayR(src: *const c_void, ocvrs_return: *mut Result<core::Scalar>);
		pub fn cv_cuda_sqrSum_const__InputArrayR_const__InputArrayR(src: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<core::Scalar>);
		pub fn cv_cuda_sqr_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_sqr_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_sqrt_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_sqrt_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_subtractWithScalar_const__InputArrayR_Scalar_const__OutputArrayR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_subtractWithScalar_const__InputArrayR_Scalar_const__OutputArrayR_const__InputArrayR_int_StreamR(src1: *const c_void, src2: *const core::Scalar, dst: *const c_void, mask: *const c_void, dtype: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_subtract_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src1: *const c_void, src2: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_subtract_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_int_StreamR(src1: *const c_void, src2: *const c_void, dst: *const c_void, mask: *const c_void, dtype: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_sum_const__InputArrayR(src: *const c_void, ocvrs_return: *mut Result<core::Scalar>);
		pub fn cv_cuda_sum_const__InputArrayR_const__InputArrayR(src: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<core::Scalar>);
		pub fn cv_cuda_threshold_const__InputArrayR_const__OutputArrayR_double_double_int(src: *const c_void, dst: *const c_void, thresh: f64, maxval: f64, typ: i32, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_threshold_const__InputArrayR_const__OutputArrayR_double_double_int_StreamR(src: *const c_void, dst: *const c_void, thresh: f64, maxval: f64, typ: i32, stream: *mut c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_transpose_const__InputArrayR_const__OutputArrayR(src1: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_transpose_const__InputArrayR_const__OutputArrayR_StreamR(src1: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Convolution_convolve_const__InputArrayR_const__InputArrayR_const__OutputArrayR_bool_StreamR(instance: *mut c_void, image: *const c_void, templ: *const c_void, result: *const c_void, ccorr: bool, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Convolution_convolve_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, templ: *const c_void, result: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Convolution_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_Convolution_delete(instance: *mut c_void);
		pub fn cv_cuda_DFT_compute_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, image: *const c_void, result: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DFT_compute_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, result: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DFT_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_DFT_delete(instance: *mut c_void);
		pub fn cv_cuda_LookUpTable_transform_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, src: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_LookUpTable_transform_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_LookUpTable_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_LookUpTable_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_ConvolutionG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_ConvolutionG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_ConvolutionG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_ConvolutionG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_ConvolutionG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DFTG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DFTG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DFTG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DFTG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_DFTG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_LookUpTableG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_LookUpTableG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_LookUpTableG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_LookUpTableG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_LookUpTableG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
	}
}
pub use cudaarithm_sys::*;

mod cudabgsegm_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_cuda_createBackgroundSubtractorMOG(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createBackgroundSubtractorMOG2(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createBackgroundSubtractorMOG2_int_double_bool(history: i32, var_threshold: f64, detect_shadows: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createBackgroundSubtractorMOG_int_int_double_double(history: i32, nmixtures: i32, background_ratio: f64, noise_sigma: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_BackgroundSubtractorMOG_apply_const__InputArrayR_const__OutputArrayR_double_StreamR(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, learning_rate: f64, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorMOG_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_StreamR(instance: *mut c_void, image: *const c_void, known_foreground_mask: *const c_void, fgmask: *const c_void, learning_rate: f64, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorMOG_getBackgroundImage_const_const__OutputArrayR_StreamR(instance: *const c_void, background_image: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorMOG_getBackgroundImage_GpuMatR_StreamR(instance: *mut c_void, background_image: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorMOG_getHistory_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_BackgroundSubtractorMOG_setHistory_int(instance: *mut c_void, nframes: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorMOG_getNMixtures_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_BackgroundSubtractorMOG_setNMixtures_int(instance: *mut c_void, nmix: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorMOG_getBackgroundRatio_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_BackgroundSubtractorMOG_setBackgroundRatio_double(instance: *mut c_void, background_ratio: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorMOG_getNoiseSigma_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_BackgroundSubtractorMOG_setNoiseSigma_double(instance: *mut c_void, noise_sigma: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorMOG_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_BackgroundSubtractorMOG_to_BackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_BackgroundSubtractorMOG_delete(instance: *mut c_void);
		pub fn cv_cuda_BackgroundSubtractorMOG2_apply_const__InputArrayR_const__OutputArrayR_double_StreamR(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, learning_rate: f64, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorMOG2_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_StreamR(instance: *mut c_void, image: *const c_void, known_foreground_mask: *const c_void, fgmask: *const c_void, learning_rate: f64, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorMOG2_getBackgroundImage_const_const__OutputArrayR_StreamR(instance: *const c_void, background_image: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorMOG2_getBackgroundImage_GpuMatR_StreamR(instance: *mut c_void, background_image: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorMOG2_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_BackgroundSubtractorMOG2_to_BackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_BackgroundSubtractorMOG2_to_BackgroundSubtractorMOG2(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_BackgroundSubtractorMOG2_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorMOGG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorMOGG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorMOGG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorMOGG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorMOGG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorMOGG_to_PtrOfBackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorMOG2G_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorMOG2G_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorMOG2G_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorMOG2G_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorMOG2G_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorMOG2G_to_PtrOfBackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorMOG2G_to_PtrOfBackgroundSubtractorMOG2(instance: *mut c_void) -> *mut c_void;
	}
}
pub use cudabgsegm_sys::*;

mod cudacodec_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_cudacodec_MapHist_const_GpuMatR_MatR(hist: *const c_void, hist_full: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cudacodec_createNVSurfaceToColorConverter_const_ColorSpaceStandard(color_space: crate::cudacodec::CUDA_ColorSpaceStandard, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cudacodec_createNVSurfaceToColorConverter_const_ColorSpaceStandard_const_bool(color_space: crate::cudacodec::CUDA_ColorSpaceStandard, video_full_range_flag: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cudacodec_createVideoReader_const_PtrLRawVideoSourceGR(source: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cudacodec_createVideoReader_const_PtrLRawVideoSourceGR_const_VideoReaderInitParams(source: *const c_void, params: *const crate::cudacodec::CUDA_VideoReaderInitParams, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cudacodec_createVideoReader_const_StringR(filename: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cudacodec_createVideoReader_const_StringR_const_vectorLintGR_const_VideoReaderInitParams(filename: *const c_char, source_params: *const c_void, params: *const crate::cudacodec::CUDA_VideoReaderInitParams, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cudacodec_createVideoWriter_const_StringR_const_Size(file_name: *const c_char, frame_size: *const core::Size, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cudacodec_createVideoWriter_const_StringR_const_Size_const_Codec_const_double_const_ColorFormat_PtrLEncoderCallbackG_const_StreamR(file_name: *const c_char, frame_size: *const core::Size, codec: crate::cudacodec::CUDA_Codec, fps: f64, color_format: crate::cudacodec::CUDA_ColorFormat, encoder_callback: *mut c_void, stream: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cudacodec_createVideoWriter_const_StringR_const_Size_const_Codec_const_double_const_ColorFormat_const_EncoderParamsR(file_name: *const c_char, frame_size: *const core::Size, codec: crate::cudacodec::CUDA_Codec, fps: f64, color_format: crate::cudacodec::CUDA_ColorFormat, params: *const crate::cudacodec::CUDA_EncoderParams, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cudacodec_createVideoWriter_const_StringR_const_Size_const_Codec_const_double_const_ColorFormat_const_EncoderParamsR_PtrLEncoderCallbackG_const_StreamR(file_name: *const c_char, frame_size: *const core::Size, codec: crate::cudacodec::CUDA_Codec, fps: f64, color_format: crate::cudacodec::CUDA_ColorFormat, params: *const crate::cudacodec::CUDA_EncoderParams, encoder_callback: *mut c_void, stream: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cudacodec_operatorEQ_const_EncoderParamsR_const_EncoderParamsR(lhs: *const crate::cudacodec::CUDA_EncoderParams, rhs: *const crate::cudacodec::CUDA_EncoderParams, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_EncoderCallback_onEncoded_const_vectorLvectorLuint8_tGGR_const_vectorLuint64_tGR(instance: *mut c_void, v_packet: *const c_void, pts: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cudacodec_EncoderCallback_setFrameIntervalP_const_int(instance: *mut c_void, frame_interval_p: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_EncoderCallback_onEncodingFinished(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cudacodec_EncoderCallback_delete(instance: *mut c_void);
		pub fn cv_cudacodec_EncoderParams_EncoderParams(ocvrs_return: *mut Result<crate::cudacodec::CUDA_EncoderParams>);
		pub fn cv_cudacodec_FormatInfo_FormatInfo(ocvrs_return: *mut Result<crate::cudacodec::CUDA_FormatInfo>);
		pub fn cv_cudacodec_NVSurfaceToColorConverter_convert_const__InputArrayR_const__OutputArrayR_const_SurfaceFormat_const_ColorFormat_const_BitDepth_const_bool_StreamR(instance: *mut c_void, yuv: *const c_void, color: *const c_void, surface_format: crate::cudacodec::CUDA_SurfaceFormat, output_format: crate::cudacodec::CUDA_ColorFormat, bit_depth: crate::cudacodec::CUDA_BitDepth, planar: bool, stream: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_NVSurfaceToColorConverter_convert_const__InputArrayR_const__OutputArrayR_const_SurfaceFormat_const_ColorFormat(instance: *mut c_void, yuv: *const c_void, color: *const c_void, surface_format: crate::cudacodec::CUDA_SurfaceFormat, output_format: crate::cudacodec::CUDA_ColorFormat, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_NVSurfaceToColorConverter_delete(instance: *mut c_void);
		pub fn cv_cudacodec_RawVideoSource_getNextPacket_unsigned_charXX_size_tX(instance: *mut c_void, data: *mut *mut u8, size: *mut size_t, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_RawVideoSource_lastPacketContainsKeyFrame_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_RawVideoSource_format_const(instance: *const c_void, ocvrs_return: *mut Result<crate::cudacodec::CUDA_FormatInfo>);
		pub fn cv_cudacodec_RawVideoSource_updateFormat_const_FormatInfoR(instance: *mut c_void, video_format: *const crate::cudacodec::CUDA_FormatInfo, ocvrs_return: *mut Result<()>);
		pub fn cv_cudacodec_RawVideoSource_getExtraData_const_MatR(instance: *const c_void, extra_data: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cudacodec_RawVideoSource_get_const_const_int_doubleR(instance: *const c_void, property_id: i32, property_val: *mut f64, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_RawVideoSource_getFirstFrameIdx_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cudacodec_RawVideoSource_delete(instance: *mut c_void);
		pub fn cv_cudacodec_VideoReader_nextFrame_GpuMatR_StreamR(instance: *mut c_void, frame: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_nextFrame_GpuMatR(instance: *mut c_void, frame: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_nextFrame_GpuMatR_GpuMatR_StreamR(instance: *mut c_void, frame: *mut c_void, histogram: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_nextFrame_GpuMatR_GpuMatR(instance: *mut c_void, frame: *mut c_void, histogram: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_format_const(instance: *const c_void, ocvrs_return: *mut Result<crate::cudacodec::CUDA_FormatInfo>);
		pub fn cv_cudacodec_VideoReader_grab_StreamR(instance: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_grab(instance: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_retrieve_const_const__OutputArrayR_const_size_t(instance: *const c_void, frame: *const c_void, idx: size_t, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_retrieve_const_const__OutputArrayR(instance: *const c_void, frame: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_retrieve_const_MatR_const_size_t(instance: *const c_void, frame: *mut c_void, idx: size_t, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_retrieve_const_GpuMatR(instance: *const c_void, frame: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_set_const_VideoReaderProps_const_double(instance: *mut c_void, property_id: crate::cudacodec::CUDA_VideoReaderProps, property_val: f64, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_setVideoReaderProps_const_VideoReaderProps_double(instance: *mut c_void, property_id: crate::cudacodec::CUDA_VideoReaderProps, property_val: f64, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_set_const_ColorFormat_const_BitDepth_const_bool(instance: *mut c_void, color_format: crate::cudacodec::CUDA_ColorFormat, bit_depth: crate::cudacodec::CUDA_BitDepth, planar: bool, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_set_const_ColorFormat(instance: *mut c_void, color_format: crate::cudacodec::CUDA_ColorFormat, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_get_const_const_VideoReaderProps_doubleR(instance: *const c_void, property_id: crate::cudacodec::CUDA_VideoReaderProps, property_val: *mut f64, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_getVideoReaderProps_const_const_VideoReaderProps_doubleR_double(instance: *const c_void, property_id: crate::cudacodec::CUDA_VideoReaderProps, property_val_out: *mut f64, property_val_in: f64, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_getVideoReaderProps_const_const_VideoReaderProps_doubleR(instance: *const c_void, property_id: crate::cudacodec::CUDA_VideoReaderProps, property_val_out: *mut f64, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_get_const_const_int_doubleR(instance: *const c_void, property_id: i32, property_val: *mut f64, ocvrs_return: *mut Result<bool>);
		pub fn cv_cudacodec_VideoReader_delete(instance: *mut c_void);
		pub fn cv_cudacodec_VideoReaderInitParams_VideoReaderInitParams(ocvrs_return: *mut Result<crate::cudacodec::CUDA_VideoReaderInitParams>);
		pub fn cv_cudacodec_VideoWriter_write_const__InputArrayR(instance: *mut c_void, frame: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cudacodec_VideoWriter_getEncoderParams_const(instance: *const c_void, ocvrs_return: *mut Result<crate::cudacodec::CUDA_EncoderParams>);
		pub fn cv_cudacodec_VideoWriter_release(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cudacodec_VideoWriter_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cudacodec_EncoderCallbackG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cudacodec_EncoderCallbackG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cudacodec_EncoderCallbackG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cudacodec_EncoderCallbackG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cudacodec_NVSurfaceToColorConverterG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cudacodec_NVSurfaceToColorConverterG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cudacodec_NVSurfaceToColorConverterG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cudacodec_NVSurfaceToColorConverterG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cudacodec_RawVideoSourceG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cudacodec_RawVideoSourceG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cudacodec_RawVideoSourceG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cudacodec_RawVideoSourceG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cudacodec_VideoReaderG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cudacodec_VideoReaderG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cudacodec_VideoReaderG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cudacodec_VideoReaderG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cudacodec_VideoWriterG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cudacodec_VideoWriterG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cudacodec_VideoWriterG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cudacodec_VideoWriterG_delete(instance: *mut c_void);
	}
}
pub use cudacodec_sys::*;

mod cudafeatures2d_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_cuda_DescriptorMatcher_createBFMatcher_int(norm_type: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_DescriptorMatcher_createBFMatcher(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_DescriptorMatcher_isMaskSupported_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_DescriptorMatcher_add_const_vectorLGpuMatGR(instance: *mut c_void, descriptors: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_getTrainDescriptors_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_DescriptorMatcher_clear(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_DescriptorMatcher_train(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_match_const__InputArrayR_const__InputArrayR_vectorLDMatchGR_const__InputArrayR(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_match_const__InputArrayR_const__InputArrayR_vectorLDMatchGR(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_match_const__InputArrayR_vectorLDMatchGR_const_vectorLGpuMatGR(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, masks: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_match_const__InputArrayR_vectorLDMatchGR(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_matchAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_matchAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_matchAsync_const__InputArrayR_const__OutputArrayR_const_vectorLGpuMatGR_StreamR(instance: *mut c_void, query_descriptors: *const c_void, matches: *const c_void, masks: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_matchAsync_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, query_descriptors: *const c_void, matches: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_matchConvert_const__InputArrayR_vectorLDMatchGR(instance: *mut c_void, gpu_matches: *const c_void, matches: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_knnMatch_const__InputArrayR_const__InputArrayR_vectorLvectorLDMatchGGR_int_const__InputArrayR_bool(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, k: i32, mask: *const c_void, compact_result: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_knnMatch_const__InputArrayR_const__InputArrayR_vectorLvectorLDMatchGGR_int(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, k: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_knnMatch_const__InputArrayR_vectorLvectorLDMatchGGR_int_const_vectorLGpuMatGR_bool(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, k: i32, masks: *const c_void, compact_result: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_knnMatch_const__InputArrayR_vectorLvectorLDMatchGGR_int(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, k: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_knnMatchAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR_StreamR(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *const c_void, k: i32, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_knnMatchAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *const c_void, k: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_knnMatchAsync_const__InputArrayR_const__OutputArrayR_int_const_vectorLGpuMatGR_StreamR(instance: *mut c_void, query_descriptors: *const c_void, matches: *const c_void, k: i32, masks: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_knnMatchAsync_const__InputArrayR_const__OutputArrayR_int(instance: *mut c_void, query_descriptors: *const c_void, matches: *const c_void, k: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_knnMatchConvert_const__InputArrayR_vectorLvectorLDMatchGGR_bool(instance: *mut c_void, gpu_matches: *const c_void, matches: *mut c_void, compact_result: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_knnMatchConvert_const__InputArrayR_vectorLvectorLDMatchGGR(instance: *mut c_void, gpu_matches: *const c_void, matches: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_radiusMatch_const__InputArrayR_const__InputArrayR_vectorLvectorLDMatchGGR_float_const__InputArrayR_bool(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, max_distance: f32, mask: *const c_void, compact_result: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_radiusMatch_const__InputArrayR_const__InputArrayR_vectorLvectorLDMatchGGR_float(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, max_distance: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_radiusMatch_const__InputArrayR_vectorLvectorLDMatchGGR_float_const_vectorLGpuMatGR_bool(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, max_distance: f32, masks: *const c_void, compact_result: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_radiusMatch_const__InputArrayR_vectorLvectorLDMatchGGR_float(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, max_distance: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_radiusMatchAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR_float_const__InputArrayR_StreamR(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *const c_void, max_distance: f32, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_radiusMatchAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR_float(instance: *mut c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *const c_void, max_distance: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_radiusMatchAsync_const__InputArrayR_const__OutputArrayR_float_const_vectorLGpuMatGR_StreamR(instance: *mut c_void, query_descriptors: *const c_void, matches: *const c_void, max_distance: f32, masks: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_radiusMatchAsync_const__InputArrayR_const__OutputArrayR_float(instance: *mut c_void, query_descriptors: *const c_void, matches: *const c_void, max_distance: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_radiusMatchConvert_const__InputArrayR_vectorLvectorLDMatchGGR_bool(instance: *mut c_void, gpu_matches: *const c_void, matches: *mut c_void, compact_result: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_radiusMatchConvert_const__InputArrayR_vectorLvectorLDMatchGGR(instance: *mut c_void, gpu_matches: *const c_void, matches: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DescriptorMatcher_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_DescriptorMatcher_delete(instance: *mut c_void);
		pub fn cv_cuda_FastFeatureDetector_create_int_bool_int_int(threshold: i32, nonmax_suppression: bool, typ: i32, max_npoints: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_FastFeatureDetector_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_FastFeatureDetector_setThreshold_int(instance: *mut c_void, threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_FastFeatureDetector_setMaxNumPoints_int(instance: *mut c_void, max_npoints: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_FastFeatureDetector_getMaxNumPoints_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_FastFeatureDetector_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_FastFeatureDetector_to_Feature2D(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_FastFeatureDetector_to_CUDA_Feature2DAsync(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_FastFeatureDetector_delete(instance: *mut c_void);
		pub fn cv_cuda_Feature2DAsync_detectAsync_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(instance: *mut c_void, image: *const c_void, keypoints: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Feature2DAsync_detectAsync_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, keypoints: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Feature2DAsync_computeAsync_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, image: *const c_void, keypoints: *const c_void, descriptors: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Feature2DAsync_computeAsync_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, keypoints: *const c_void, descriptors: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Feature2DAsync_detectAndComputeAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_StreamR(instance: *mut c_void, image: *const c_void, mask: *const c_void, keypoints: *const c_void, descriptors: *const c_void, use_provided_keypoints: bool, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Feature2DAsync_detectAndComputeAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, mask: *const c_void, keypoints: *const c_void, descriptors: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Feature2DAsync_convert_const__InputArrayR_vectorLKeyPointGR(instance: *mut c_void, gpu_keypoints: *const c_void, keypoints: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Feature2DAsync_to_CUDA_FastFeatureDetector(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_Feature2DAsync_to_CUDA_ORB(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_Feature2DAsync_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_Feature2DAsync_to_Feature2D(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_Feature2DAsync_delete(instance: *mut c_void);
		pub fn cv_cuda_ORB_create_int_float_int_int_int_int_int_int_int_bool(nfeatures: i32, scale_factor: f32, nlevels: i32, edge_threshold: i32, first_level: i32, wta_k: i32, score_type: i32, patch_size: i32, fast_threshold: i32, blur_for_descriptor: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_ORB_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_ORB_setMaxFeatures_int(instance: *mut c_void, max_features: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_ORB_getMaxFeatures_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_ORB_setScaleFactor_double(instance: *mut c_void, scale_factor: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_ORB_getScaleFactor_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_ORB_setNLevels_int(instance: *mut c_void, nlevels: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_ORB_getNLevels_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_ORB_setEdgeThreshold_int(instance: *mut c_void, edge_threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_ORB_getEdgeThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_ORB_setFirstLevel_int(instance: *mut c_void, first_level: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_ORB_getFirstLevel_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_ORB_setWTA_K_int(instance: *mut c_void, wta_k: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_ORB_getWTA_K_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_ORB_setScoreType_int(instance: *mut c_void, score_type: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_ORB_getScoreType_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_ORB_setPatchSize_int(instance: *mut c_void, patch_size: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_ORB_getPatchSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_ORB_setFastThreshold_int(instance: *mut c_void, fast_threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_ORB_getFastThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_ORB_setBlurForDescriptor_bool(instance: *mut c_void, blur_for_descriptor: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_ORB_getBlurForDescriptor_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_ORB_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_ORB_to_Feature2D(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_ORB_to_CUDA_Feature2DAsync(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_ORB_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_DescriptorMatcherG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DescriptorMatcherG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DescriptorMatcherG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DescriptorMatcherG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_DescriptorMatcherG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_FastFeatureDetectorG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_FastFeatureDetectorG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_FastFeatureDetectorG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_FastFeatureDetectorG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_FastFeatureDetectorG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_FastFeatureDetectorG_to_PtrOfFeature2D(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_FastFeatureDetectorG_to_PtrOfCUDA_Feature2DAsync(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_Feature2DAsyncG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_Feature2DAsyncG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_Feature2DAsyncG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_Feature2DAsyncG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_Feature2DAsyncG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_Feature2DAsyncG_to_PtrOfFeature2D(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_ORBG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_ORBG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_ORBG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_ORBG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_ORBG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_ORBG_to_PtrOfFeature2D(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_ORBG_to_PtrOfCUDA_Feature2DAsync(instance: *mut c_void) -> *mut c_void;
	}
}
pub use cudafeatures2d_sys::*;

mod cudafilters_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_cuda_createBoxFilter_int_int_Size(src_type: i32, dst_type: i32, ksize: *const core::Size, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createBoxFilter_int_int_Size_Point_int_Scalar(src_type: i32, dst_type: i32, ksize: *const core::Size, anchor: *const core::Point, border_mode: i32, border_val: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createBoxMaxFilter_int_Size(src_type: i32, ksize: *const core::Size, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createBoxMaxFilter_int_Size_Point_int_Scalar(src_type: i32, ksize: *const core::Size, anchor: *const core::Point, border_mode: i32, border_val: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createBoxMinFilter_int_Size(src_type: i32, ksize: *const core::Size, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createBoxMinFilter_int_Size_Point_int_Scalar(src_type: i32, ksize: *const core::Size, anchor: *const core::Point, border_mode: i32, border_val: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createColumnSumFilter_int_int_int(src_type: i32, dst_type: i32, ksize: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createColumnSumFilter_int_int_int_int_int_Scalar(src_type: i32, dst_type: i32, ksize: i32, anchor: i32, border_mode: i32, border_val: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createDerivFilter_int_int_int_int_int(src_type: i32, dst_type: i32, dx: i32, dy: i32, ksize: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createDerivFilter_int_int_int_int_int_bool_double_int_int(src_type: i32, dst_type: i32, dx: i32, dy: i32, ksize: i32, normalize: bool, scale: f64, row_border_mode: i32, column_border_mode: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createGaussianFilter_int_int_Size_double(src_type: i32, dst_type: i32, ksize: *const core::Size, sigma1: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createGaussianFilter_int_int_Size_double_double_int_int(src_type: i32, dst_type: i32, ksize: *const core::Size, sigma1: f64, sigma2: f64, row_border_mode: i32, column_border_mode: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createLaplacianFilter_int_int(src_type: i32, dst_type: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createLaplacianFilter_int_int_int_double_int_Scalar(src_type: i32, dst_type: i32, ksize: i32, scale: f64, border_mode: i32, border_val: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createLinearFilter_int_int_const__InputArrayR(src_type: i32, dst_type: i32, kernel: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createLinearFilter_int_int_const__InputArrayR_Point_int_Scalar(src_type: i32, dst_type: i32, kernel: *const c_void, anchor: *const core::Point, border_mode: i32, border_val: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createMedianFilter_int_int(src_type: i32, window_size: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createMedianFilter_int_int_int(src_type: i32, window_size: i32, partition: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createMorphologyFilter_int_int_const__InputArrayR(op: i32, src_type: i32, kernel: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createMorphologyFilter_int_int_const__InputArrayR_Point_int(op: i32, src_type: i32, kernel: *const c_void, anchor: *const core::Point, iterations: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createRowSumFilter_int_int_int(src_type: i32, dst_type: i32, ksize: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createRowSumFilter_int_int_int_int_int_Scalar(src_type: i32, dst_type: i32, ksize: i32, anchor: i32, border_mode: i32, border_val: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createScharrFilter_int_int_int_int(src_type: i32, dst_type: i32, dx: i32, dy: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createScharrFilter_int_int_int_int_double_int_int(src_type: i32, dst_type: i32, dx: i32, dy: i32, scale: f64, row_border_mode: i32, column_border_mode: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createSeparableLinearFilter_int_int_const__InputArrayR_const__InputArrayR(src_type: i32, dst_type: i32, row_kernel: *const c_void, column_kernel: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createSeparableLinearFilter_int_int_const__InputArrayR_const__InputArrayR_Point_int_int(src_type: i32, dst_type: i32, row_kernel: *const c_void, column_kernel: *const c_void, anchor: *const core::Point, row_border_mode: i32, column_border_mode: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createSobelFilter_int_int_int_int(src_type: i32, dst_type: i32, dx: i32, dy: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createSobelFilter_int_int_int_int_int_double_int_int(src_type: i32, dst_type: i32, dx: i32, dy: i32, ksize: i32, scale: f64, row_border_mode: i32, column_border_mode: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_Filter_apply_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, src: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Filter_apply_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_Filter_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_Filter_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_FilterG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_FilterG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_FilterG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_FilterG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_FilterG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
	}
}
pub use cudafilters_sys::*;

mod cudaimgproc_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_cuda_alphaComp_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int(img1: *const c_void, img2: *const c_void, dst: *const c_void, alpha_op: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_alphaComp_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_StreamR(img1: *const c_void, img2: *const c_void, dst: *const c_void, alpha_op: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bilateralFilter_const__InputArrayR_const__OutputArrayR_int_float_float(src: *const c_void, dst: *const c_void, kernel_size: i32, sigma_color: f32, sigma_spatial: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_bilateralFilter_const__InputArrayR_const__OutputArrayR_int_float_float_int_StreamR(src: *const c_void, dst: *const c_void, kernel_size: i32, sigma_color: f32, sigma_spatial: f32, border_mode: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_blendLinear_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(img1: *const c_void, img2: *const c_void, weights1: *const c_void, weights2: *const c_void, result: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_blendLinear_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(img1: *const c_void, img2: *const c_void, weights1: *const c_void, weights2: *const c_void, result: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_calcHist_const__InputArrayR_const__InputArrayR_const__OutputArrayR(src: *const c_void, mask: *const c_void, hist: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_calcHist_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, mask: *const c_void, hist: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_calcHist_const__InputArrayR_const__OutputArrayR(src: *const c_void, hist: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_calcHist_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, hist: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_connectedComponents_const__InputArrayR_const__OutputArrayR(image: *const c_void, labels: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_connectedComponents_const__InputArrayR_const__OutputArrayR_int_int(image: *const c_void, labels: *const c_void, connectivity: i32, ltype: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_connectedComponents_const__InputArrayR_const__OutputArrayR_int_int_ConnectedComponentsAlgorithmsTypes(image: *const c_void, labels: *const c_void, connectivity: i32, ltype: i32, ccltype: crate::cudaimgproc::CUDA_ConnectedComponentsAlgorithmsTypes, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_convertSpatialMoments_Mat_const_MomentsOrder_const_int(spatial_moments: *mut c_void, order: crate::cudaimgproc::CUDA_MomentsOrder, moments_type: i32, ocvrs_return: *mut Result<core::Moments>);
		pub fn cv_cuda_createCLAHE(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createCLAHE_double_Size(clip_limit: f64, tile_grid_size: *const core::Size, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createCannyEdgeDetector_double_double(low_thresh: f64, high_thresh: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createCannyEdgeDetector_double_double_int_bool(low_thresh: f64, high_thresh: f64, apperture_size: i32, l2gradient: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createGeneralizedHoughBallard(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createGeneralizedHoughGuil(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createGoodFeaturesToTrackDetector_int(src_type: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createGoodFeaturesToTrackDetector_int_int_double_double_int_bool_double(src_type: i32, max_corners: i32, quality_level: f64, min_distance: f64, block_size: i32, use_harris_detector: bool, harris_k: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createHarrisCorner_int_int_int_double(src_type: i32, block_size: i32, ksize: i32, k: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createHarrisCorner_int_int_int_double_int(src_type: i32, block_size: i32, ksize: i32, k: f64, border_type: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createHoughCirclesDetector_float_float_int_int_int_int(dp: f32, min_dist: f32, canny_threshold: i32, votes_threshold: i32, min_radius: i32, max_radius: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createHoughCirclesDetector_float_float_int_int_int_int_int(dp: f32, min_dist: f32, canny_threshold: i32, votes_threshold: i32, min_radius: i32, max_radius: i32, max_circles: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createHoughLinesDetector_float_float_int(rho: f32, theta: f32, threshold: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createHoughLinesDetector_float_float_int_bool_int(rho: f32, theta: f32, threshold: i32, do_sort: bool, max_lines: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createHoughSegmentDetector_float_float_int_int(rho: f32, theta: f32, min_line_length: i32, max_line_gap: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createHoughSegmentDetector_float_float_int_int_int_int(rho: f32, theta: f32, min_line_length: i32, max_line_gap: i32, max_lines: i32, threshold: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createMinEigenValCorner_int_int_int(src_type: i32, block_size: i32, ksize: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createMinEigenValCorner_int_int_int_int(src_type: i32, block_size: i32, ksize: i32, border_type: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createTemplateMatching_int_int(src_type: i32, method: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createTemplateMatching_int_int_Size(src_type: i32, method: i32, user_block_size: *const core::Size, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_cvtColor_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, code: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_cvtColor_const__InputArrayR_const__OutputArrayR_int_int_StreamR(src: *const c_void, dst: *const c_void, code: i32, dcn: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_demosaicing_const__InputArrayR_const__OutputArrayR_int(src: *const c_void, dst: *const c_void, code: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_demosaicing_const__InputArrayR_const__OutputArrayR_int_int_StreamR(src: *const c_void, dst: *const c_void, code: i32, dcn: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_equalizeHist_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_equalizeHist_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_evenLevels_const__OutputArrayR_int_int_int(levels: *const c_void, n_levels: i32, lower_level: i32, upper_level: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_evenLevels_const__OutputArrayR_int_int_int_StreamR(levels: *const c_void, n_levels: i32, lower_level: i32, upper_level: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_gammaCorrection_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_gammaCorrection_const__InputArrayR_const__OutputArrayR_bool_StreamR(src: *const c_void, dst: *const c_void, forward: bool, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_histEven_const__InputArrayR_const__OutputArrayR_int_int_int(src: *const c_void, hist: *const c_void, hist_size: i32, lower_level: i32, upper_level: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_histEven_const__InputArrayR_const__OutputArrayR_int_int_int_StreamR(src: *const c_void, hist: *const c_void, hist_size: i32, lower_level: i32, upper_level: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_histRange_const__InputArrayR_const__OutputArrayR_const__InputArrayR(src: *const c_void, hist: *const c_void, levels: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_histRange_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(src: *const c_void, hist: *const c_void, levels: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_meanShiftFiltering_const__InputArrayR_const__OutputArrayR_int_int(src: *const c_void, dst: *const c_void, sp: i32, sr: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_meanShiftFiltering_const__InputArrayR_const__OutputArrayR_int_int_TermCriteria_StreamR(src: *const c_void, dst: *const c_void, sp: i32, sr: i32, criteria: *const core::TermCriteria, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_meanShiftProc_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int_int(src: *const c_void, dstr: *const c_void, dstsp: *const c_void, sp: i32, sr: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_meanShiftProc_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int_int_TermCriteria_StreamR(src: *const c_void, dstr: *const c_void, dstsp: *const c_void, sp: i32, sr: i32, criteria: *const core::TermCriteria, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_meanShiftSegmentation_const__InputArrayR_const__OutputArrayR_int_int_int(src: *const c_void, dst: *const c_void, sp: i32, sr: i32, minsize: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_meanShiftSegmentation_const__InputArrayR_const__OutputArrayR_int_int_int_TermCriteria_StreamR(src: *const c_void, dst: *const c_void, sp: i32, sr: i32, minsize: i32, criteria: *const core::TermCriteria, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_moments_const__InputArrayR(src: *const c_void, ocvrs_return: *mut Result<core::Moments>);
		pub fn cv_cuda_moments_const__InputArrayR_const_bool_const_MomentsOrder_const_int(src: *const c_void, binary_image: bool, order: crate::cudaimgproc::CUDA_MomentsOrder, moments_type: i32, ocvrs_return: *mut Result<core::Moments>);
		pub fn cv_cuda_numMoments_const_MomentsOrder(order: crate::cudaimgproc::CUDA_MomentsOrder, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_spatialMoments_const__InputArrayR_const__OutputArrayR(src: *const c_void, moments: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_spatialMoments_const__InputArrayR_const__OutputArrayR_const_bool_const_MomentsOrder_const_int_StreamR(src: *const c_void, moments: *const c_void, binary_image: bool, order: crate::cudaimgproc::CUDA_MomentsOrder, moments_type: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_swapChannels_const__InputOutputArrayR_const_intXX(image: *const c_void, dst_order: *const [i32; 4], ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_swapChannels_const__InputOutputArrayR_const_intXX_StreamR(image: *const c_void, dst_order: *const [i32; 4], stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CLAHE_apply_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, src: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CLAHE_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_CLAHE_to_CLAHE(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_CLAHE_delete(instance: *mut c_void);
		pub fn cv_cuda_CannyEdgeDetector_detect_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, image: *const c_void, edges: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CannyEdgeDetector_detect_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, edges: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CannyEdgeDetector_detect_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, dx: *const c_void, dy: *const c_void, edges: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CannyEdgeDetector_detect_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, dx: *const c_void, dy: *const c_void, edges: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CannyEdgeDetector_setLowThreshold_double(instance: *mut c_void, low_thresh: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CannyEdgeDetector_getLowThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_CannyEdgeDetector_setHighThreshold_double(instance: *mut c_void, high_thresh: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CannyEdgeDetector_getHighThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_CannyEdgeDetector_setAppertureSize_int(instance: *mut c_void, apperture_size: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CannyEdgeDetector_getAppertureSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_CannyEdgeDetector_setL2Gradient_bool(instance: *mut c_void, l2gradient: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CannyEdgeDetector_getL2Gradient_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_CannyEdgeDetector_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_CannyEdgeDetector_delete(instance: *mut c_void);
		pub fn cv_cuda_CornernessCriteria_compute_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, src: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CornernessCriteria_compute_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CornernessCriteria_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_CornernessCriteria_delete(instance: *mut c_void);
		pub fn cv_cuda_CornersDetector_detect_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(instance: *mut c_void, image: *const c_void, corners: *const c_void, mask: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CornersDetector_detect_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, corners: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CornersDetector_setMaxCorners_int(instance: *mut c_void, max_corners: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CornersDetector_setMinDistance_double(instance: *mut c_void, min_distance: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CornersDetector_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_CornersDetector_delete(instance: *mut c_void);
		pub fn cv_cuda_HoughCirclesDetector_detect_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, src: *const c_void, circles: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughCirclesDetector_detect_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, src: *const c_void, circles: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughCirclesDetector_setDp_float(instance: *mut c_void, dp: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughCirclesDetector_getDp_const(instance: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_cuda_HoughCirclesDetector_setMinDist_float(instance: *mut c_void, min_dist: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughCirclesDetector_getMinDist_const(instance: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_cuda_HoughCirclesDetector_setCannyThreshold_int(instance: *mut c_void, canny_threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughCirclesDetector_getCannyThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HoughCirclesDetector_setVotesThreshold_int(instance: *mut c_void, votes_threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughCirclesDetector_getVotesThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HoughCirclesDetector_setMinRadius_int(instance: *mut c_void, min_radius: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughCirclesDetector_getMinRadius_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HoughCirclesDetector_setMaxRadius_int(instance: *mut c_void, max_radius: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughCirclesDetector_getMaxRadius_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HoughCirclesDetector_setMaxCircles_int(instance: *mut c_void, max_circles: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughCirclesDetector_getMaxCircles_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HoughCirclesDetector_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_HoughCirclesDetector_delete(instance: *mut c_void);
		pub fn cv_cuda_HoughLinesDetector_detect_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, src: *const c_void, lines: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughLinesDetector_detect_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, src: *const c_void, lines: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughLinesDetector_downloadResults_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, d_lines: *const c_void, h_lines: *const c_void, h_votes: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughLinesDetector_downloadResults_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, d_lines: *const c_void, h_lines: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughLinesDetector_setRho_float(instance: *mut c_void, rho: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughLinesDetector_getRho_const(instance: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_cuda_HoughLinesDetector_setTheta_float(instance: *mut c_void, theta: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughLinesDetector_getTheta_const(instance: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_cuda_HoughLinesDetector_setThreshold_int(instance: *mut c_void, threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughLinesDetector_getThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HoughLinesDetector_setDoSort_bool(instance: *mut c_void, do_sort: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughLinesDetector_getDoSort_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_HoughLinesDetector_setMaxLines_int(instance: *mut c_void, max_lines: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughLinesDetector_getMaxLines_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HoughLinesDetector_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_HoughLinesDetector_delete(instance: *mut c_void);
		pub fn cv_cuda_HoughSegmentDetector_detect_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, src: *const c_void, lines: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughSegmentDetector_detect_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, src: *const c_void, lines: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughSegmentDetector_setRho_float(instance: *mut c_void, rho: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughSegmentDetector_getRho_const(instance: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_cuda_HoughSegmentDetector_setTheta_float(instance: *mut c_void, theta: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughSegmentDetector_getTheta_const(instance: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_cuda_HoughSegmentDetector_setMinLineLength_int(instance: *mut c_void, min_line_length: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughSegmentDetector_getMinLineLength_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HoughSegmentDetector_setMaxLineGap_int(instance: *mut c_void, max_line_gap: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughSegmentDetector_getMaxLineGap_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HoughSegmentDetector_setMaxLines_int(instance: *mut c_void, max_lines: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughSegmentDetector_getMaxLines_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HoughSegmentDetector_setThreshold_int(instance: *mut c_void, threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HoughSegmentDetector_getThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HoughSegmentDetector_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_HoughSegmentDetector_delete(instance: *mut c_void);
		pub fn cv_cuda_TemplateMatching_match_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, image: *const c_void, templ: *const c_void, result: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_TemplateMatching_match_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, templ: *const c_void, result: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_TemplateMatching_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_TemplateMatching_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_CLAHEG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CLAHEG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CLAHEG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CLAHEG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_CLAHEG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CLAHEG_to_PtrOfCLAHE(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CannyEdgeDetectorG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CannyEdgeDetectorG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CannyEdgeDetectorG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CannyEdgeDetectorG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_CannyEdgeDetectorG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CornernessCriteriaG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CornernessCriteriaG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CornernessCriteriaG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CornernessCriteriaG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_CornernessCriteriaG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CornersDetectorG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CornersDetectorG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CornersDetectorG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CornersDetectorG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_CornersDetectorG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HoughCirclesDetectorG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HoughCirclesDetectorG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HoughCirclesDetectorG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HoughCirclesDetectorG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_HoughCirclesDetectorG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HoughLinesDetectorG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HoughLinesDetectorG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HoughLinesDetectorG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HoughLinesDetectorG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_HoughLinesDetectorG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HoughSegmentDetectorG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HoughSegmentDetectorG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HoughSegmentDetectorG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HoughSegmentDetectorG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_HoughSegmentDetectorG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_TemplateMatchingG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_TemplateMatchingG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_TemplateMatchingG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_TemplateMatchingG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_TemplateMatchingG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
	}
}
pub use cudaimgproc_sys::*;

mod cudalegacy_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_cuda_calcOpticalFlowBM_const_GpuMatR_const_GpuMatR_Size_Size_Size_bool_GpuMatR_GpuMatR_GpuMatR(prev: *const c_void, curr: *const c_void, block_size: *const core::Size, shift_size: *const core::Size, max_range: *const core::Size, use_previous: bool, velx: *mut c_void, vely: *mut c_void, buf: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_calcOpticalFlowBM_const_GpuMatR_const_GpuMatR_Size_Size_Size_bool_GpuMatR_GpuMatR_GpuMatR_StreamR(prev: *const c_void, curr: *const c_void, block_size: *const core::Size, shift_size: *const core::Size, max_range: *const core::Size, use_previous: bool, velx: *mut c_void, vely: *mut c_void, buf: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_connectivityMask_const_GpuMatR_GpuMatR_const_ScalarR_const_ScalarR(image: *const c_void, mask: *mut c_void, lo: *const core::Scalar, hi: *const core::Scalar, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_connectivityMask_const_GpuMatR_GpuMatR_const_ScalarR_const_ScalarR_StreamR(image: *const c_void, mask: *mut c_void, lo: *const core::Scalar, hi: *const core::Scalar, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_createBackgroundSubtractorFGD(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createBackgroundSubtractorFGD_const_FGDParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createBackgroundSubtractorGMG(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createBackgroundSubtractorGMG_int_double(initialization_frames: i32, decision_threshold: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createImagePyramid_const__InputArrayR(img: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createImagePyramid_const__InputArrayR_int_StreamR(img: *const c_void, n_layers: i32, stream: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createOpticalFlowNeedleMap_const_GpuMatR_const_GpuMatR_GpuMatR_GpuMatR(u: *const c_void, v: *const c_void, vertex: *mut c_void, colors: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_graphcut_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR(terminals: *mut c_void, left_transp: *mut c_void, right_transp: *mut c_void, top: *mut c_void, bottom: *mut c_void, labels: *mut c_void, buf: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_graphcut_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR(terminals: *mut c_void, left_transp: *mut c_void, right_transp: *mut c_void, top: *mut c_void, top_left: *mut c_void, top_right: *mut c_void, bottom: *mut c_void, bottom_left: *mut c_void, bottom_right: *mut c_void, labels: *mut c_void, buf: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_graphcut_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_StreamR(terminals: *mut c_void, left_transp: *mut c_void, right_transp: *mut c_void, top: *mut c_void, top_left: *mut c_void, top_right: *mut c_void, bottom: *mut c_void, bottom_left: *mut c_void, bottom_right: *mut c_void, labels: *mut c_void, buf: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_graphcut_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_GpuMatR_StreamR(terminals: *mut c_void, left_transp: *mut c_void, right_transp: *mut c_void, top: *mut c_void, bottom: *mut c_void, labels: *mut c_void, buf: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_interpolateFrames_const_GpuMatR_const_GpuMatR_const_GpuMatR_const_GpuMatR_const_GpuMatR_const_GpuMatR_float_GpuMatR_GpuMatR(frame0: *const c_void, frame1: *const c_void, fu: *const c_void, fv: *const c_void, bu: *const c_void, bv: *const c_void, pos: f32, new_frame: *mut c_void, buf: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_interpolateFrames_const_GpuMatR_const_GpuMatR_const_GpuMatR_const_GpuMatR_const_GpuMatR_const_GpuMatR_float_GpuMatR_GpuMatR_StreamR(frame0: *const c_void, frame1: *const c_void, fu: *const c_void, fv: *const c_void, bu: *const c_void, bv: *const c_void, pos: f32, new_frame: *mut c_void, buf: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_labelComponents_const_GpuMatR_GpuMatR(mask: *const c_void, components: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_labelComponents_const_GpuMatR_GpuMatR_int_StreamR(mask: *const c_void, components: *mut c_void, flags: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_projectPoints_const_GpuMatR_const_MatR_const_MatR_const_MatR_const_MatR_GpuMatR(src: *const c_void, rvec: *const c_void, tvec: *const c_void, camera_mat: *const c_void, dist_coef: *const c_void, dst: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_projectPoints_const_GpuMatR_const_MatR_const_MatR_const_MatR_const_MatR_GpuMatR_StreamR(src: *const c_void, rvec: *const c_void, tvec: *const c_void, camera_mat: *const c_void, dist_coef: *const c_void, dst: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_solvePnPRansac_const_MatR_const_MatR_const_MatR_const_MatR_MatR_MatR(object: *const c_void, image: *const c_void, camera_mat: *const c_void, dist_coef: *const c_void, rvec: *mut c_void, tvec: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_solvePnPRansac_const_MatR_const_MatR_const_MatR_const_MatR_MatR_MatR_bool_int_float_int_vectorLintGX(object: *const c_void, image: *const c_void, camera_mat: *const c_void, dist_coef: *const c_void, rvec: *mut c_void, tvec: *mut c_void, use_extrinsic_guess: bool, num_iters: i32, max_dist: f32, min_inlier_count: i32, inliers: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_transformPoints_const_GpuMatR_const_MatR_const_MatR_GpuMatR(src: *const c_void, rvec: *const c_void, tvec: *const c_void, dst: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_transformPoints_const_GpuMatR_const_MatR_const_MatR_GpuMatR_StreamR(src: *const c_void, rvec: *const c_void, tvec: *const c_void, dst: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorFGD_getForegroundRegions_const__OutputArrayR(instance: *mut c_void, foreground_regions: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorFGD_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_BackgroundSubtractorFGD_to_BackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_BackgroundSubtractorFGD_delete(instance: *mut c_void);
		pub fn cv_cuda_BackgroundSubtractorGMG_apply_const__InputArrayR_const__OutputArrayR_double_StreamR(instance: *mut c_void, image: *const c_void, fgmask: *const c_void, learning_rate: f64, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorGMG_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_StreamR(instance: *mut c_void, image: *const c_void, known_foreground_mask: *const c_void, fgmask: *const c_void, learning_rate: f64, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorGMG_getMaxFeatures_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_BackgroundSubtractorGMG_setMaxFeatures_int(instance: *mut c_void, max_features: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorGMG_getDefaultLearningRate_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_BackgroundSubtractorGMG_setDefaultLearningRate_double(instance: *mut c_void, lr: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorGMG_getNumFrames_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_BackgroundSubtractorGMG_setNumFrames_int(instance: *mut c_void, nframes: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorGMG_getQuantizationLevels_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_BackgroundSubtractorGMG_setQuantizationLevels_int(instance: *mut c_void, nlevels: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorGMG_getBackgroundPrior_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_BackgroundSubtractorGMG_setBackgroundPrior_double(instance: *mut c_void, bgprior: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorGMG_getSmoothingRadius_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_BackgroundSubtractorGMG_setSmoothingRadius_int(instance: *mut c_void, radius: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorGMG_getDecisionThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_BackgroundSubtractorGMG_setDecisionThreshold_double(instance: *mut c_void, thresh: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorGMG_getUpdateBackgroundModel_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_BackgroundSubtractorGMG_setUpdateBackgroundModel_bool(instance: *mut c_void, update: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorGMG_getMinVal_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_BackgroundSubtractorGMG_setMinVal_double(instance: *mut c_void, val: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorGMG_getMaxVal_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_BackgroundSubtractorGMG_setMaxVal_double(instance: *mut c_void, val: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BackgroundSubtractorGMG_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_BackgroundSubtractorGMG_to_BackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_BackgroundSubtractorGMG_delete(instance: *mut c_void);
		pub fn cv_cuda_FGDParams_FGDParams(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_FGDParams_propLc_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_FGDParams_propLc_const_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_FGDParams_propN1c_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_FGDParams_propN1c_const_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_FGDParams_propN2c_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_FGDParams_propN2c_const_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_FGDParams_propLcc_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_FGDParams_propLcc_const_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_FGDParams_propN1cc_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_FGDParams_propN1cc_const_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_FGDParams_propN2cc_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_FGDParams_propN2cc_const_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_FGDParams_propIs_obj_without_holes_const(instance: *const c_void) -> bool;
		pub fn cv_cuda_FGDParams_propIs_obj_without_holes_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_cuda_FGDParams_propPerform_morphing_const(instance: *const c_void) -> i32;
		pub fn cv_cuda_FGDParams_propPerform_morphing_const_int(instance: *mut c_void, val: i32);
		pub fn cv_cuda_FGDParams_propAlpha1_const(instance: *const c_void) -> f32;
		pub fn cv_cuda_FGDParams_propAlpha1_const_float(instance: *mut c_void, val: f32);
		pub fn cv_cuda_FGDParams_propAlpha2_const(instance: *const c_void) -> f32;
		pub fn cv_cuda_FGDParams_propAlpha2_const_float(instance: *mut c_void, val: f32);
		pub fn cv_cuda_FGDParams_propAlpha3_const(instance: *const c_void) -> f32;
		pub fn cv_cuda_FGDParams_propAlpha3_const_float(instance: *mut c_void, val: f32);
		pub fn cv_cuda_FGDParams_propDelta_const(instance: *const c_void) -> f32;
		pub fn cv_cuda_FGDParams_propDelta_const_float(instance: *mut c_void, val: f32);
		pub fn cv_cuda_FGDParams_propT_const(instance: *const c_void) -> f32;
		pub fn cv_cuda_FGDParams_propT_const_float(instance: *mut c_void, val: f32);
		pub fn cv_cuda_FGDParams_propMinArea_const(instance: *const c_void) -> f32;
		pub fn cv_cuda_FGDParams_propMinArea_const_float(instance: *mut c_void, val: f32);
		pub fn cv_cuda_FGDParams_delete(instance: *mut c_void);
		pub fn cv_cuda_FastOpticalFlowBM_operator___const_GpuMatR_const_GpuMatR_GpuMatR_GpuMatR_int_int_StreamR(instance: *mut c_void, i0: *const c_void, i1: *const c_void, flowx: *mut c_void, flowy: *mut c_void, search_window: i32, block_window: i32, s: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_FastOpticalFlowBM_operator___const_GpuMatR_const_GpuMatR_GpuMatR_GpuMatR(instance: *mut c_void, i0: *const c_void, i1: *const c_void, flowx: *mut c_void, flowy: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_FastOpticalFlowBM_defaultNew_const() -> *mut c_void;
		pub fn cv_cuda_FastOpticalFlowBM_delete(instance: *mut c_void);
		pub fn cv_cuda_ImagePyramid_getLayer_const_const__OutputArrayR_Size_StreamR(instance: *const c_void, out_img: *const c_void, out_roi: *const core::Size, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_ImagePyramid_getLayer_const_const__OutputArrayR_Size(instance: *const c_void, out_img: *const c_void, out_roi: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_ImagePyramid_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_ImagePyramid_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorFGDG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorFGDG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorFGDG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorFGDG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorFGDG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorFGDG_to_PtrOfBackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorGMGG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorGMGG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorGMGG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorGMGG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorGMGG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BackgroundSubtractorGMGG_to_PtrOfBackgroundSubtractor(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_ImagePyramidG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_ImagePyramidG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_ImagePyramidG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_ImagePyramidG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_ImagePyramidG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
	}
}
pub use cudalegacy_sys::*;

mod cudaobjdetect_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_cuda_CascadeClassifier_create_const_StringR(filename: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_CascadeClassifier_create_const_FileStorageR(file: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_CascadeClassifier_setMaxObjectSize_Size(instance: *mut c_void, max_object_size: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CascadeClassifier_getMaxObjectSize_const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_cuda_CascadeClassifier_setMinObjectSize_Size(instance: *mut c_void, min_size: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CascadeClassifier_getMinObjectSize_const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_cuda_CascadeClassifier_setScaleFactor_double(instance: *mut c_void, scale_factor: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CascadeClassifier_getScaleFactor_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_CascadeClassifier_setMinNeighbors_int(instance: *mut c_void, min_neighbors: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CascadeClassifier_getMinNeighbors_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_CascadeClassifier_setFindLargestObject_bool(instance: *mut c_void, find_largest_object: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CascadeClassifier_getFindLargestObject(instance: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_CascadeClassifier_setMaxNumObjects_int(instance: *mut c_void, max_num_objects: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CascadeClassifier_getMaxNumObjects_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_CascadeClassifier_getClassifierSize_const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_cuda_CascadeClassifier_detectMultiScale_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, image: *const c_void, objects: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CascadeClassifier_detectMultiScale_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, objects: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CascadeClassifier_convert_const__OutputArrayR_vectorLRectGR(instance: *mut c_void, gpu_objects: *const c_void, objects: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_CascadeClassifier_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_CascadeClassifier_delete(instance: *mut c_void);
		pub fn cv_cuda_HOG_create_Size_Size_Size_Size_int(win_size: *const core::Size, block_size: *const core::Size, block_stride: *const core::Size, cell_size: *const core::Size, nbins: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HOG_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HOG_setWinSigma_double(instance: *mut c_void, win_sigma: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_getWinSigma_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_HOG_setL2HysThreshold_double(instance: *mut c_void, threshold_l2hys: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_getL2HysThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_HOG_setGammaCorrection_bool(instance: *mut c_void, gamma_correction: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_getGammaCorrection_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_HOG_setNumLevels_int(instance: *mut c_void, nlevels: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_getNumLevels_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HOG_setHitThreshold_double(instance: *mut c_void, hit_threshold: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_getHitThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_HOG_setWinStride_Size(instance: *mut c_void, win_stride: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_getWinStride_const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_cuda_HOG_setScaleFactor_double(instance: *mut c_void, scale0: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_getScaleFactor_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_HOG_setGroupThreshold_int(instance: *mut c_void, group_threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_getGroupThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_HOG_setDescriptorFormat_DescriptorStorageFormat(instance: *mut c_void, descr_format: crate::objdetect::HOGDescriptor_DescriptorStorageFormat, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_getDescriptorFormat_const(instance: *const c_void, ocvrs_return: *mut Result<crate::objdetect::HOGDescriptor_DescriptorStorageFormat>);
		pub fn cv_cuda_HOG_getDescriptorSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_HOG_getBlockHistogramSize_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_cuda_HOG_setSVMDetector_const__InputArrayR(instance: *mut c_void, detector: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_getDefaultPeopleDetector_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_HOG_detect_const__InputArrayR_vectorLPointGR_vectorLdoubleGX(instance: *mut c_void, img: *const c_void, found_locations: *mut c_void, confidences: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_detect_const__InputArrayR_vectorLPointGR(instance: *mut c_void, img: *const c_void, found_locations: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_detect_const__InputArrayR_vectorLPointGR_vectorLdoubleGR(instance: *mut c_void, img: *const c_void, found_locations: *mut c_void, confidences: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_detectWithoutConf_const__InputArrayR_vectorLPointGR(instance: *mut c_void, img: *const c_void, found_locations: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_detectMultiScale_const__InputArrayR_vectorLRectGR_vectorLdoubleGX(instance: *mut c_void, img: *const c_void, found_locations: *mut c_void, confidences: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_detectMultiScale_const__InputArrayR_vectorLRectGR(instance: *mut c_void, img: *const c_void, found_locations: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_detectMultiScale_const__InputArrayR_vectorLRectGR_vectorLdoubleGR(instance: *mut c_void, img: *const c_void, found_locations: *mut c_void, confidences: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_detectMultiScaleWithoutConf_const__InputArrayR_vectorLRectGR(instance: *mut c_void, img: *const c_void, found_locations: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_compute_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, img: *const c_void, descriptors: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_compute_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, img: *const c_void, descriptors: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_HOG_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_HOG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_CascadeClassifierG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CascadeClassifierG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CascadeClassifierG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_CascadeClassifierG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_CascadeClassifierG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HOGG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HOGG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HOGG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_HOGG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_HOGG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
	}
}
pub use cudaobjdetect_sys::*;

mod cudaoptflow_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_cuda_BroxOpticalFlow_getFlowSmoothness_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_BroxOpticalFlow_setFlowSmoothness_double(instance: *mut c_void, alpha: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BroxOpticalFlow_getGradientConstancyImportance_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_BroxOpticalFlow_setGradientConstancyImportance_double(instance: *mut c_void, gamma: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BroxOpticalFlow_getPyramidScaleFactor_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_BroxOpticalFlow_setPyramidScaleFactor_double(instance: *mut c_void, scale_factor: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BroxOpticalFlow_getInnerIterations_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_BroxOpticalFlow_setInnerIterations_int(instance: *mut c_void, inner_iterations: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BroxOpticalFlow_getOuterIterations_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_BroxOpticalFlow_setOuterIterations_int(instance: *mut c_void, outer_iterations: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BroxOpticalFlow_getSolverIterations_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_BroxOpticalFlow_setSolverIterations_int(instance: *mut c_void, solver_iterations: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_BroxOpticalFlow_create_double_double_double_int_int_int(alpha: f64, gamma: f64, scale_factor: f64, inner_iterations: i32, outer_iterations: i32, solver_iterations: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_BroxOpticalFlow_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_BroxOpticalFlow_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_BroxOpticalFlow_to_CUDA_DenseOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_BroxOpticalFlow_delete(instance: *mut c_void);
		pub fn cv_cuda_DenseOpticalFlow_calc_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_StreamR(instance: *mut c_void, i0: *const c_void, i1: *const c_void, flow: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DenseOpticalFlow_calc_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR(instance: *mut c_void, i0: *const c_void, i1: *const c_void, flow: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DenseOpticalFlow_to_CUDA_BroxOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_DenseOpticalFlow_to_CUDA_DensePyrLKOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_DenseOpticalFlow_to_CUDA_FarnebackOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_DenseOpticalFlow_to_CUDA_OpticalFlowDual_TVL1(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_DenseOpticalFlow_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_DenseOpticalFlow_delete(instance: *mut c_void);
		pub fn cv_cuda_DensePyrLKOpticalFlow_getWinSize_const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_cuda_DensePyrLKOpticalFlow_setWinSize_Size(instance: *mut c_void, win_size: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DensePyrLKOpticalFlow_getMaxLevel_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DensePyrLKOpticalFlow_setMaxLevel_int(instance: *mut c_void, max_level: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DensePyrLKOpticalFlow_getNumIters_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DensePyrLKOpticalFlow_setNumIters_int(instance: *mut c_void, iters: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DensePyrLKOpticalFlow_getUseInitialFlow_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_DensePyrLKOpticalFlow_setUseInitialFlow_bool(instance: *mut c_void, use_initial_flow: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DensePyrLKOpticalFlow_create_Size_int_int_bool(win_size: *const core::Size, max_level: i32, iters: i32, use_initial_flow: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_DensePyrLKOpticalFlow_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_DensePyrLKOpticalFlow_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_DensePyrLKOpticalFlow_to_CUDA_DenseOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_DensePyrLKOpticalFlow_delete(instance: *mut c_void);
		pub fn cv_cuda_FarnebackOpticalFlow_getNumLevels_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_FarnebackOpticalFlow_setNumLevels_int(instance: *mut c_void, num_levels: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_FarnebackOpticalFlow_getPyrScale_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_FarnebackOpticalFlow_setPyrScale_double(instance: *mut c_void, pyr_scale: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_FarnebackOpticalFlow_getFastPyramids_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_FarnebackOpticalFlow_setFastPyramids_bool(instance: *mut c_void, fast_pyramids: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_FarnebackOpticalFlow_getWinSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_FarnebackOpticalFlow_setWinSize_int(instance: *mut c_void, win_size: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_FarnebackOpticalFlow_getNumIters_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_FarnebackOpticalFlow_setNumIters_int(instance: *mut c_void, num_iters: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_FarnebackOpticalFlow_getPolyN_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_FarnebackOpticalFlow_setPolyN_int(instance: *mut c_void, poly_n: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_FarnebackOpticalFlow_getPolySigma_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_FarnebackOpticalFlow_setPolySigma_double(instance: *mut c_void, poly_sigma: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_FarnebackOpticalFlow_getFlags_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_FarnebackOpticalFlow_setFlags_int(instance: *mut c_void, flags: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_FarnebackOpticalFlow_create_int_double_bool_int_int_int_double_int(num_levels: i32, pyr_scale: f64, fast_pyramids: bool, win_size: i32, num_iters: i32, poly_n: i32, poly_sigma: f64, flags: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_FarnebackOpticalFlow_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_FarnebackOpticalFlow_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_FarnebackOpticalFlow_to_CUDA_DenseOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_FarnebackOpticalFlow_delete(instance: *mut c_void);
		pub fn cv_cuda_NvidiaHWOpticalFlow_calc_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_StreamR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, input_image: *const c_void, reference_image: *const c_void, flow: *const c_void, stream: *mut c_void, hint: *const c_void, cost: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_NvidiaHWOpticalFlow_calc_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR(instance: *mut c_void, input_image: *const c_void, reference_image: *const c_void, flow: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_NvidiaHWOpticalFlow_collectGarbage(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_NvidiaHWOpticalFlow_getGridSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_NvidiaHWOpticalFlow_to_CUDA_NvidiaOpticalFlow_1_0(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_NvidiaHWOpticalFlow_to_CUDA_NvidiaOpticalFlow_2_0(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_NvidiaHWOpticalFlow_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_NvidiaHWOpticalFlow_delete(instance: *mut c_void);
		pub fn cv_cuda_NvidiaOpticalFlow_1_0_upSampler_const__InputArrayR_Size_int_const__InputOutputArrayR(instance: *mut c_void, flow: *const c_void, image_size: *const core::Size, grid_size: i32, upsampled_flow: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_NvidiaOpticalFlow_1_0_create_Size_NVIDIA_OF_PERF_LEVEL_bool_bool_bool_int_StreamR_StreamR(image_size: *const core::Size, perf_preset: crate::cudaoptflow::CUDA_NvidiaOpticalFlow_1_0_NVIDIA_OF_PERF_LEVEL, enable_temporal_hints: bool, enable_external_hints: bool, enable_cost_buffer: bool, gpu_id: i32, input_stream: *mut c_void, output_stream: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_NvidiaOpticalFlow_1_0_create_Size(image_size: *const core::Size, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_NvidiaOpticalFlow_1_0_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_NvidiaOpticalFlow_1_0_to_CUDA_NvidiaHWOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_NvidiaOpticalFlow_1_0_delete(instance: *mut c_void);
		pub fn cv_cuda_NvidiaOpticalFlow_2_0_convertToFloat_const__InputArrayR_const__InputOutputArrayR(instance: *mut c_void, flow: *const c_void, float_flow: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_NvidiaOpticalFlow_2_0_create_Size_NVIDIA_OF_PERF_LEVEL_NVIDIA_OF_OUTPUT_VECTOR_GRID_SIZE_NVIDIA_OF_HINT_VECTOR_GRID_SIZE_bool_bool_bool_int_StreamR_StreamR(image_size: *const core::Size, perf_preset: crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0_NVIDIA_OF_PERF_LEVEL, output_grid_size: crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0_NVIDIA_OF_OUTPUT_VECTOR_GRID_SIZE, hint_grid_size: crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0_NVIDIA_OF_HINT_VECTOR_GRID_SIZE, enable_temporal_hints: bool, enable_external_hints: bool, enable_cost_buffer: bool, gpu_id: i32, input_stream: *mut c_void, output_stream: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_NvidiaOpticalFlow_2_0_create_Size(image_size: *const core::Size, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_NvidiaOpticalFlow_2_0_create_Size_vectorLRectG_NVIDIA_OF_PERF_LEVEL_NVIDIA_OF_OUTPUT_VECTOR_GRID_SIZE_NVIDIA_OF_HINT_VECTOR_GRID_SIZE_bool_bool_bool_int_StreamR_StreamR(image_size: *const core::Size, roi_data: *mut c_void, perf_preset: crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0_NVIDIA_OF_PERF_LEVEL, output_grid_size: crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0_NVIDIA_OF_OUTPUT_VECTOR_GRID_SIZE, hint_grid_size: crate::cudaoptflow::CUDA_NvidiaOpticalFlow_2_0_NVIDIA_OF_HINT_VECTOR_GRID_SIZE, enable_temporal_hints: bool, enable_external_hints: bool, enable_cost_buffer: bool, gpu_id: i32, input_stream: *mut c_void, output_stream: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_NvidiaOpticalFlow_2_0_create_Size_vectorLRectG(image_size: *const core::Size, roi_data: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_NvidiaOpticalFlow_2_0_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_NvidiaOpticalFlow_2_0_to_CUDA_NvidiaHWOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_NvidiaOpticalFlow_2_0_delete(instance: *mut c_void);
		pub fn cv_cuda_OpticalFlowDual_TVL1_getTau_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_setTau_double(instance: *mut c_void, tau: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_getLambda_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_setLambda_double(instance: *mut c_void, lambda: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_getGamma_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_setGamma_double(instance: *mut c_void, gamma: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_getTheta_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_setTheta_double(instance: *mut c_void, theta: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_getNumScales_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_setNumScales_int(instance: *mut c_void, nscales: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_getNumWarps_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_setNumWarps_int(instance: *mut c_void, warps: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_getEpsilon_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_setEpsilon_double(instance: *mut c_void, epsilon: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_getNumIterations_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_setNumIterations_int(instance: *mut c_void, iterations: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_getScaleStep_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_setScaleStep_double(instance: *mut c_void, scale_step: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_getUseInitialFlow_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_setUseInitialFlow_bool(instance: *mut c_void, use_initial_flow: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_create_double_double_double_int_int_double_int_double_double_bool(tau: f64, lambda: f64, theta: f64, nscales: i32, warps: i32, epsilon: f64, iterations: i32, scale_step: f64, gamma: f64, use_initial_flow: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_OpticalFlowDual_TVL1_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_OpticalFlowDual_TVL1_to_CUDA_DenseOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_OpticalFlowDual_TVL1_delete(instance: *mut c_void);
		pub fn cv_cuda_SparseOpticalFlow_calc_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, prev_img: *const c_void, next_img: *const c_void, prev_pts: *const c_void, next_pts: *const c_void, status: *const c_void, err: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_SparseOpticalFlow_calc_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR(instance: *mut c_void, prev_img: *const c_void, next_img: *const c_void, prev_pts: *const c_void, next_pts: *const c_void, status: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_SparseOpticalFlow_to_CUDA_SparsePyrLKOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_SparseOpticalFlow_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_SparseOpticalFlow_delete(instance: *mut c_void);
		pub fn cv_cuda_SparsePyrLKOpticalFlow_getWinSize_const(instance: *const c_void, ocvrs_return: *mut Result<core::Size>);
		pub fn cv_cuda_SparsePyrLKOpticalFlow_setWinSize_Size(instance: *mut c_void, win_size: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_SparsePyrLKOpticalFlow_getMaxLevel_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_SparsePyrLKOpticalFlow_setMaxLevel_int(instance: *mut c_void, max_level: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_SparsePyrLKOpticalFlow_getNumIters_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_SparsePyrLKOpticalFlow_setNumIters_int(instance: *mut c_void, iters: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_SparsePyrLKOpticalFlow_getUseInitialFlow_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_SparsePyrLKOpticalFlow_setUseInitialFlow_bool(instance: *mut c_void, use_initial_flow: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_SparsePyrLKOpticalFlow_create_Size_int_int_bool(win_size: *const core::Size, max_level: i32, iters: i32, use_initial_flow: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_SparsePyrLKOpticalFlow_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_SparsePyrLKOpticalFlow_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_SparsePyrLKOpticalFlow_to_CUDA_SparseOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_SparsePyrLKOpticalFlow_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_BroxOpticalFlowG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BroxOpticalFlowG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BroxOpticalFlowG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BroxOpticalFlowG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_BroxOpticalFlowG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_BroxOpticalFlowG_to_PtrOfCUDA_DenseOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DenseOpticalFlowG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DenseOpticalFlowG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DenseOpticalFlowG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DenseOpticalFlowG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_DenseOpticalFlowG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DensePyrLKOpticalFlowG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DensePyrLKOpticalFlowG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DensePyrLKOpticalFlowG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DensePyrLKOpticalFlowG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_DensePyrLKOpticalFlowG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DensePyrLKOpticalFlowG_to_PtrOfCUDA_DenseOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_FarnebackOpticalFlowG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_FarnebackOpticalFlowG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_FarnebackOpticalFlowG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_FarnebackOpticalFlowG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_FarnebackOpticalFlowG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_FarnebackOpticalFlowG_to_PtrOfCUDA_DenseOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_NvidiaHWOpticalFlowG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_NvidiaHWOpticalFlowG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_NvidiaHWOpticalFlowG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_NvidiaHWOpticalFlowG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_NvidiaHWOpticalFlowG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_NvidiaOpticalFlow_1_0G_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_NvidiaOpticalFlow_1_0G_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_NvidiaOpticalFlow_1_0G_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_NvidiaOpticalFlow_1_0G_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_NvidiaOpticalFlow_1_0G_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_NvidiaOpticalFlow_1_0G_to_PtrOfCUDA_NvidiaHWOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_NvidiaOpticalFlow_2_0G_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_NvidiaOpticalFlow_2_0G_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_NvidiaOpticalFlow_2_0G_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_NvidiaOpticalFlow_2_0G_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_NvidiaOpticalFlow_2_0G_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_NvidiaOpticalFlow_2_0G_to_PtrOfCUDA_NvidiaHWOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_OpticalFlowDual_TVL1G_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_OpticalFlowDual_TVL1G_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_OpticalFlowDual_TVL1G_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_OpticalFlowDual_TVL1G_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_OpticalFlowDual_TVL1G_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_OpticalFlowDual_TVL1G_to_PtrOfCUDA_DenseOpticalFlow(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_SparseOpticalFlowG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_SparseOpticalFlowG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_SparseOpticalFlowG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_SparseOpticalFlowG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_SparseOpticalFlowG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_SparsePyrLKOpticalFlowG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_SparsePyrLKOpticalFlowG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_SparsePyrLKOpticalFlowG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_SparsePyrLKOpticalFlowG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_SparsePyrLKOpticalFlowG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_SparsePyrLKOpticalFlowG_to_PtrOfCUDA_SparseOpticalFlow(instance: *mut c_void) -> *mut c_void;
	}
}
pub use cudaoptflow_sys::*;

mod cudastereo_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_cuda_createDisparityBilateralFilter(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createDisparityBilateralFilter_int_int_int(ndisp: i32, radius: i32, iters: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createStereoBM(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createStereoBM_int_int(num_disparities: i32, block_size: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createStereoBeliefPropagation(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createStereoBeliefPropagation_int_int_int_int(ndisp: i32, iters: i32, levels: i32, msg_type: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createStereoConstantSpaceBP(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createStereoConstantSpaceBP_int_int_int_int_int(ndisp: i32, iters: i32, levels: i32, nr_plane: i32, msg_type: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createStereoSGM(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_createStereoSGM_int_int_int_int_int_int(min_disparity: i32, num_disparities: i32, p1: i32, p2: i32, uniqueness_ratio: i32, mode: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_cuda_drawColorDisp_const__InputArrayR_const__OutputArrayR_int(src_disp: *const c_void, dst_disp: *const c_void, ndisp: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_drawColorDisp_const__InputArrayR_const__OutputArrayR_int_StreamR(src_disp: *const c_void, dst_disp: *const c_void, ndisp: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_reprojectImageTo3D_GpuMat_GpuMatR_Mat(disp: *mut c_void, xyzw: *mut c_void, q: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_reprojectImageTo3D_GpuMat_GpuMatR_Mat_int_StreamR(disp: *mut c_void, xyzw: *mut c_void, q: *mut c_void, dst_cn: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_reprojectImageTo3D_const__InputArrayR_const__OutputArrayR_const__InputArrayR(disp: *const c_void, xyzw: *const c_void, q: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_reprojectImageTo3D_const__InputArrayR_const__OutputArrayR_const__InputArrayR_int_StreamR(disp: *const c_void, xyzw: *const c_void, q: *const c_void, dst_cn: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DisparityBilateralFilter_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, disparity: *const c_void, image: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DisparityBilateralFilter_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, disparity: *const c_void, image: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DisparityBilateralFilter_getNumDisparities_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DisparityBilateralFilter_setNumDisparities_int(instance: *mut c_void, num_disparities: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DisparityBilateralFilter_getRadius_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DisparityBilateralFilter_setRadius_int(instance: *mut c_void, radius: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DisparityBilateralFilter_getNumIters_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_DisparityBilateralFilter_setNumIters_int(instance: *mut c_void, iters: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DisparityBilateralFilter_getEdgeThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_DisparityBilateralFilter_setEdgeThreshold_double(instance: *mut c_void, edge_threshold: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DisparityBilateralFilter_getMaxDiscThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_DisparityBilateralFilter_setMaxDiscThreshold_double(instance: *mut c_void, max_disc_threshold: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DisparityBilateralFilter_getSigmaRange_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_DisparityBilateralFilter_setSigmaRange_double(instance: *mut c_void, sigma_range: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_DisparityBilateralFilter_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_DisparityBilateralFilter_delete(instance: *mut c_void);
		pub fn cv_cuda_StereoBM_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, left: *const c_void, right: *const c_void, disparity: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoBM_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_StereoBM_to_StereoBM(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_StereoBM_to_StereoMatcher(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_StereoBM_delete(instance: *mut c_void);
		pub fn cv_cuda_StereoBeliefPropagation_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, left: *const c_void, right: *const c_void, disparity: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoBeliefPropagation_compute_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, data: *const c_void, disparity: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoBeliefPropagation_compute_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, data: *const c_void, disparity: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoBeliefPropagation_getNumIters_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_StereoBeliefPropagation_setNumIters_int(instance: *mut c_void, iters: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoBeliefPropagation_getNumLevels_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_StereoBeliefPropagation_setNumLevels_int(instance: *mut c_void, levels: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoBeliefPropagation_getMaxDataTerm_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_StereoBeliefPropagation_setMaxDataTerm_double(instance: *mut c_void, max_data_term: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoBeliefPropagation_getDataWeight_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_StereoBeliefPropagation_setDataWeight_double(instance: *mut c_void, data_weight: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoBeliefPropagation_getMaxDiscTerm_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_StereoBeliefPropagation_setMaxDiscTerm_double(instance: *mut c_void, max_disc_term: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoBeliefPropagation_getDiscSingleJump_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_cuda_StereoBeliefPropagation_setDiscSingleJump_double(instance: *mut c_void, disc_single_jump: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoBeliefPropagation_getMsgType_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_StereoBeliefPropagation_setMsgType_int(instance: *mut c_void, msg_type: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoBeliefPropagation_estimateRecommendedParams_int_int_intR_intR_intR(width: i32, height: i32, ndisp: *mut i32, iters: *mut i32, levels: *mut i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoBeliefPropagation_to_CUDA_StereoConstantSpaceBP(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_StereoBeliefPropagation_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_StereoBeliefPropagation_to_StereoMatcher(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_StereoBeliefPropagation_delete(instance: *mut c_void);
		pub fn cv_cuda_StereoConstantSpaceBP_getNrPlane_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_cuda_StereoConstantSpaceBP_setNrPlane_int(instance: *mut c_void, nr_plane: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoConstantSpaceBP_getUseLocalInitDataCost_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_cuda_StereoConstantSpaceBP_setUseLocalInitDataCost_bool(instance: *mut c_void, use_local_init_data_cost: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoConstantSpaceBP_estimateRecommendedParams_int_int_intR_intR_intR_intR(width: i32, height: i32, ndisp: *mut i32, iters: *mut i32, levels: *mut i32, nr_plane: *mut i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoConstantSpaceBP_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_StereoConstantSpaceBP_to_CUDA_StereoBeliefPropagation(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_StereoConstantSpaceBP_to_StereoMatcher(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_StereoConstantSpaceBP_delete(instance: *mut c_void);
		pub fn cv_cuda_StereoSGM_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, left: *const c_void, right: *const c_void, disparity: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoSGM_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(instance: *mut c_void, left: *const c_void, right: *const c_void, disparity: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_StereoSGM_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_StereoSGM_to_StereoMatcher(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_StereoSGM_to_StereoSGBM(instance: *mut c_void) -> *mut c_void;
		pub fn cv_cuda_StereoSGM_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_DisparityBilateralFilterG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DisparityBilateralFilterG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DisparityBilateralFilterG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_DisparityBilateralFilterG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_DisparityBilateralFilterG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoBMG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoBMG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoBMG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoBMG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_StereoBMG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoBMG_to_PtrOfStereoBM(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoBMG_to_PtrOfStereoMatcher(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoBeliefPropagationG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoBeliefPropagationG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoBeliefPropagationG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoBeliefPropagationG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_StereoBeliefPropagationG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoBeliefPropagationG_to_PtrOfStereoMatcher(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoConstantSpaceBPG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoConstantSpaceBPG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoConstantSpaceBPG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoConstantSpaceBPG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_StereoConstantSpaceBPG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoConstantSpaceBPG_to_PtrOfStereoMatcher(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoConstantSpaceBPG_to_PtrOfCUDA_StereoBeliefPropagation(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoSGMG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoSGMG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoSGMG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoSGMG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_cuda_StereoSGMG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoSGMG_to_PtrOfStereoMatcher(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_cuda_StereoSGMG_to_PtrOfStereoSGBM(instance: *mut c_void) -> *mut c_void;
	}
}
pub use cudastereo_sys::*;

mod cudawarping_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_cuda_buildWarpAffineMaps_Mat_bool_Size_GpuMatR_GpuMatR(m: *mut c_void, inverse: bool, dsize: *const core::Size, xmap: *mut c_void, ymap: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_buildWarpAffineMaps_Mat_bool_Size_GpuMatR_GpuMatR_StreamR(m: *mut c_void, inverse: bool, dsize: *const core::Size, xmap: *mut c_void, ymap: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_buildWarpAffineMaps_UMat_bool_Size_GpuMatR_GpuMatR(m: *mut c_void, inverse: bool, dsize: *const core::Size, xmap: *mut c_void, ymap: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_buildWarpAffineMaps_UMat_bool_Size_GpuMatR_GpuMatR_StreamR(m: *mut c_void, inverse: bool, dsize: *const core::Size, xmap: *mut c_void, ymap: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_buildWarpAffineMaps_const__InputArrayR_bool_Size_const__OutputArrayR_const__OutputArrayR(m: *const c_void, inverse: bool, dsize: *const core::Size, xmap: *const c_void, ymap: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_buildWarpAffineMaps_const__InputArrayR_bool_Size_const__OutputArrayR_const__OutputArrayR_StreamR(m: *const c_void, inverse: bool, dsize: *const core::Size, xmap: *const c_void, ymap: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_buildWarpPerspectiveMaps_Mat_bool_Size_GpuMatR_GpuMatR(m: *mut c_void, inverse: bool, dsize: *const core::Size, xmap: *mut c_void, ymap: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_buildWarpPerspectiveMaps_Mat_bool_Size_GpuMatR_GpuMatR_StreamR(m: *mut c_void, inverse: bool, dsize: *const core::Size, xmap: *mut c_void, ymap: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_buildWarpPerspectiveMaps_UMat_bool_Size_GpuMatR_GpuMatR(m: *mut c_void, inverse: bool, dsize: *const core::Size, xmap: *mut c_void, ymap: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_buildWarpPerspectiveMaps_UMat_bool_Size_GpuMatR_GpuMatR_StreamR(m: *mut c_void, inverse: bool, dsize: *const core::Size, xmap: *mut c_void, ymap: *mut c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_buildWarpPerspectiveMaps_const__InputArrayR_bool_Size_const__OutputArrayR_const__OutputArrayR(m: *const c_void, inverse: bool, dsize: *const core::Size, xmap: *const c_void, ymap: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_buildWarpPerspectiveMaps_const__InputArrayR_bool_Size_const__OutputArrayR_const__OutputArrayR_StreamR(m: *const c_void, inverse: bool, dsize: *const core::Size, xmap: *const c_void, ymap: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_pyrDown_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_pyrDown_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_pyrUp_const__InputArrayR_const__OutputArrayR(src: *const c_void, dst: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_pyrUp_const__InputArrayR_const__OutputArrayR_StreamR(src: *const c_void, dst: *const c_void, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_remap_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_int(src: *const c_void, dst: *const c_void, xmap: *const c_void, ymap: *const c_void, interpolation: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_remap_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, xmap: *const c_void, ymap: *const c_void, interpolation: i32, border_mode: i32, border_value: *const core::Scalar, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_resize_const__InputArrayR_const__OutputArrayR_Size(src: *const c_void, dst: *const c_void, dsize: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_resize_const__InputArrayR_const__OutputArrayR_Size_double_double_int_StreamR(src: *const c_void, dst: *const c_void, dsize: *const core::Size, fx: f64, fy: f64, interpolation: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_rotate_const__InputArrayR_const__OutputArrayR_Size_double(src: *const c_void, dst: *const c_void, dsize: *const core::Size, angle: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_rotate_const__InputArrayR_const__OutputArrayR_Size_double_double_double_int_StreamR(src: *const c_void, dst: *const c_void, dsize: *const core::Size, angle: f64, x_shift: f64, y_shift: f64, interpolation: i32, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_warpAffine_const__InputArrayR_const__OutputArrayR_Mat_Size(src: *const c_void, dst: *const c_void, m: *mut c_void, dsize: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_warpAffine_const__InputArrayR_const__OutputArrayR_Mat_Size_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, m: *mut c_void, dsize: *const core::Size, flags: i32, border_mode: i32, border_value: *const core::Scalar, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_warpAffine_const__InputArrayR_const__OutputArrayR_UMat_Size(src: *const c_void, dst: *const c_void, m: *mut c_void, dsize: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_warpAffine_const__InputArrayR_const__OutputArrayR_UMat_Size_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, m: *mut c_void, dsize: *const core::Size, flags: i32, border_mode: i32, border_value: *const core::Scalar, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_warpAffine_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Size(src: *const c_void, dst: *const c_void, m: *const c_void, dsize: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_warpAffine_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Size_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, m: *const c_void, dsize: *const core::Size, flags: i32, border_mode: i32, border_value: *const core::Scalar, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_warpPerspective_const__InputArrayR_const__OutputArrayR_Mat_Size(src: *const c_void, dst: *const c_void, m: *mut c_void, dsize: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_warpPerspective_const__InputArrayR_const__OutputArrayR_Mat_Size_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, m: *mut c_void, dsize: *const core::Size, flags: i32, border_mode: i32, border_value: *const core::Scalar, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_warpPerspective_const__InputArrayR_const__OutputArrayR_UMat_Size(src: *const c_void, dst: *const c_void, m: *mut c_void, dsize: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_warpPerspective_const__InputArrayR_const__OutputArrayR_UMat_Size_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, m: *mut c_void, dsize: *const core::Size, flags: i32, border_mode: i32, border_value: *const core::Scalar, stream: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_warpPerspective_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Size(src: *const c_void, dst: *const c_void, m: *const c_void, dsize: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_cuda_warpPerspective_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Size_int_int_Scalar_StreamR(src: *const c_void, dst: *const c_void, m: *const c_void, dsize: *const core::Size, flags: i32, border_mode: i32, border_value: *const core::Scalar, stream: *mut c_void, ocvrs_return: *mut Result<()>);
	}
}
pub use cudawarping_sys::*;

mod cvv_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cvv_impl_debugDMatch_const__InputArrayR_vectorLKeyPointG_const__InputArrayR_vectorLKeyPointG_vectorLDMatchG_const_CallMetaDataR_const_charX_const_charX_bool(img1: *const c_void, keypoints1: *mut c_void, img2: *const c_void, keypoints2: *mut c_void, matches: *mut c_void, data: *const c_void, description: *const c_char, view: *const c_char, use_train_descriptor: bool, ocvrs_return: *mut Result<()>);
		pub fn cvv_impl_debugFilter_const__InputArrayR_const__InputArrayR_const_CallMetaDataR_const_charX_const_charX(original: *const c_void, result: *const c_void, data: *const c_void, description: *const c_char, view: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cvv_impl_finalShow(ocvrs_return: *mut Result<()>);
		pub fn cvv_impl_showImage_const__InputArrayR_const_CallMetaDataR_const_charX_const_charX(img: *const c_void, data: *const c_void, description: *const c_char, view: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cvv_impl_CallMetaData_CallMetaData(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cvv_impl_CallMetaData_CallMetaData_const_charX_size_t_const_charX(file: *const c_char, line: size_t, function: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cvv_impl_CallMetaData_operator_bool(instance: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cvv_impl_CallMetaData_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cvv_impl_CallMetaData_propFile_const(instance: *const c_void) -> *mut c_void;
		pub fn cvv_impl_CallMetaData_propLine_const(instance: *const c_void) -> size_t;
		pub fn cvv_impl_CallMetaData_propFunction_const(instance: *const c_void) -> *mut c_void;
		pub fn cvv_impl_CallMetaData_propIsKnown_const(instance: *const c_void) -> bool;
		pub fn cvv_impl_CallMetaData_delete(instance: *mut c_void);
	}
}
pub use cvv_sys::*;

mod dnn_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_dnn_NMSBoxesBatched_const_vectorLRect2dGR_const_vectorLfloatGR_const_vectorLintGR_const_float_const_float_vectorLintGR(bboxes: *const c_void, scores: *const c_void, class_ids: *const c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_NMSBoxesBatched_const_vectorLRect2dGR_const_vectorLfloatGR_const_vectorLintGR_const_float_const_float_vectorLintGR_const_float_const_int(bboxes: *const c_void, scores: *const c_void, class_ids: *const c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, eta: f32, top_k: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_NMSBoxesBatched_const_vectorLRectGR_const_vectorLfloatGR_const_vectorLintGR_const_float_const_float_vectorLintGR(bboxes: *const c_void, scores: *const c_void, class_ids: *const c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_NMSBoxesBatched_const_vectorLRectGR_const_vectorLfloatGR_const_vectorLintGR_const_float_const_float_vectorLintGR_const_float_const_int(bboxes: *const c_void, scores: *const c_void, class_ids: *const c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, eta: f32, top_k: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_NMSBoxes_const_vectorLRect2dGR_const_vectorLfloatGR_const_float_const_float_vectorLintGR(bboxes: *const c_void, scores: *const c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_NMSBoxes_const_vectorLRect2dGR_const_vectorLfloatGR_const_float_const_float_vectorLintGR_const_float_const_int(bboxes: *const c_void, scores: *const c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, eta: f32, top_k: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_NMSBoxes_const_vectorLRectGR_const_vectorLfloatGR_const_float_const_float_vectorLintGR(bboxes: *const c_void, scores: *const c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_NMSBoxes_const_vectorLRectGR_const_vectorLfloatGR_const_float_const_float_vectorLintGR_const_float_const_int(bboxes: *const c_void, scores: *const c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, eta: f32, top_k: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_NMSBoxes_const_vectorLRotatedRectGR_const_vectorLfloatGR_const_float_const_float_vectorLintGR(bboxes: *const c_void, scores: *const c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_NMSBoxes_const_vectorLRotatedRectGR_const_vectorLfloatGR_const_float_const_float_vectorLintGR_const_float_const_int(bboxes: *const c_void, scores: *const c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, eta: f32, top_k: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_blobFromImageWithParams_const__InputArrayR(image: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_blobFromImageWithParams_const__InputArrayR_const_Image2BlobParamsR(image: *const c_void, param: *const crate::dnn::Image2BlobParams, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_blobFromImageWithParams_const__InputArrayR_const__OutputArrayR(image: *const c_void, blob: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_blobFromImageWithParams_const__InputArrayR_const__OutputArrayR_const_Image2BlobParamsR(image: *const c_void, blob: *const c_void, param: *const crate::dnn::Image2BlobParams, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_blobFromImage_const__InputArrayR(image: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_blobFromImage_const__InputArrayR_const__OutputArrayR(image: *const c_void, blob: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_blobFromImage_const__InputArrayR_const__OutputArrayR_double_const_SizeR_const_ScalarR_bool_bool_int(image: *const c_void, blob: *const c_void, scalefactor: f64, size: *const core::Size, mean: *const core::Scalar, swap_rb: bool, crop: bool, ddepth: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_blobFromImage_const__InputArrayR_double_const_SizeR_const_ScalarR_bool_bool_int(image: *const c_void, scalefactor: f64, size: *const core::Size, mean: *const core::Scalar, swap_rb: bool, crop: bool, ddepth: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_blobFromImagesWithParams_const__InputArrayR(images: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_blobFromImagesWithParams_const__InputArrayR_const_Image2BlobParamsR(images: *const c_void, param: *const crate::dnn::Image2BlobParams, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_blobFromImagesWithParams_const__InputArrayR_const__OutputArrayR(images: *const c_void, blob: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_blobFromImagesWithParams_const__InputArrayR_const__OutputArrayR_const_Image2BlobParamsR(images: *const c_void, blob: *const c_void, param: *const crate::dnn::Image2BlobParams, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_blobFromImages_const__InputArrayR(images: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_blobFromImages_const__InputArrayR_const__OutputArrayR(images: *const c_void, blob: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_blobFromImages_const__InputArrayR_const__OutputArrayR_double_Size_const_ScalarR_bool_bool_int(images: *const c_void, blob: *const c_void, scalefactor: f64, size: *const core::Size, mean: *const core::Scalar, swap_rb: bool, crop: bool, ddepth: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_blobFromImages_const__InputArrayR_double_Size_const_ScalarR_bool_bool_int(images: *const c_void, scalefactor: f64, size: *const core::Size, mean: *const core::Scalar, swap_rb: bool, crop: bool, ddepth: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_concat_const_MatShapeR_const_MatShapeR(a: *const c_void, b: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_enableModelDiagnostics_bool(is_diagnostics_mode: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_getAvailableBackends(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_getAvailableTargets_Backend(be: crate::dnn::Backend, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_getInferenceEngineBackendType(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_getInferenceEngineCPUType(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_getInferenceEngineVPUType(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_getPlane_const_MatR_int_int(m: *const c_void, n: i32, cn: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_imagesFromBlob_const_MatR_const__OutputArrayR(blob_: *const c_void, images_: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_readNetFromCaffe_const_StringR(prototxt: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromCaffe_const_StringR_const_StringR(prototxt: *const c_char, caffe_model: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromCaffe_const_charX_size_t(buffer_proto: *const c_char, len_proto: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromCaffe_const_charX_size_t_const_charX_size_t(buffer_proto: *const c_char, len_proto: size_t, buffer_model: *const c_char, len_model: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromCaffe_const_vectorLunsigned_charGR(buffer_proto: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromCaffe_const_vectorLunsigned_charGR_const_vectorLunsigned_charGR(buffer_proto: *const c_void, buffer_model: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromDarknet_const_StringR(cfg_file: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromDarknet_const_StringR_const_StringR(cfg_file: *const c_char, darknet_model: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromDarknet_const_charX_size_t(buffer_cfg: *const c_char, len_cfg: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromDarknet_const_charX_size_t_const_charX_size_t(buffer_cfg: *const c_char, len_cfg: size_t, buffer_model: *const c_char, len_model: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromDarknet_const_vectorLunsigned_charGR(buffer_cfg: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromDarknet_const_vectorLunsigned_charGR_const_vectorLunsigned_charGR(buffer_cfg: *const c_void, buffer_model: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromModelOptimizer_const_StringR(xml: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromModelOptimizer_const_StringR_const_StringR(xml: *const c_char, bin: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromModelOptimizer_const_unsigned_charX_size_t_const_unsigned_charX_size_t(buffer_model_config_ptr: *const u8, buffer_model_config_size: size_t, buffer_weights_ptr: *const u8, buffer_weights_size: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromModelOptimizer_const_vectorLunsigned_charGR_const_vectorLunsigned_charGR(buffer_model_config: *const c_void, buffer_weights: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromONNX_const_StringR(onnx_file: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromONNX_const_charX_size_t(buffer: *const c_char, size_buffer: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromONNX_const_vectorLunsigned_charGR(buffer: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromTFLite_const_StringR(model: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromTFLite_const_charX_size_t(buffer_model: *const c_char, len_model: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromTFLite_const_vectorLunsigned_charGR(buffer_model: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromTensorflow_const_StringR(model: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromTensorflow_const_StringR_const_StringR(model: *const c_char, config: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromTensorflow_const_charX_size_t(buffer_model: *const c_char, len_model: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromTensorflow_const_charX_size_t_const_charX_size_t(buffer_model: *const c_char, len_model: size_t, buffer_config: *const c_char, len_config: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromTensorflow_const_vectorLunsigned_charGR(buffer_model: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromTensorflow_const_vectorLunsigned_charGR_const_vectorLunsigned_charGR(buffer_model: *const c_void, buffer_config: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromTorch_const_StringR(model: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNetFromTorch_const_StringR_bool_bool(model: *const c_char, is_binary: bool, evaluate: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNet_const_StringR(model: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNet_const_StringR_const_StringR_const_StringR(model: *const c_char, config: *const c_char, framework: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNet_const_StringR_const_vectorLunsigned_charGR(framework: *const c_char, buffer_model: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readNet_const_StringR_const_vectorLunsigned_charGR_const_vectorLunsigned_charGR(framework: *const c_char, buffer_model: *const c_void, buffer_config: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readTensorFromONNX_const_StringR(path: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readTorchBlob_const_StringR(filename: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_readTorchBlob_const_StringR_bool(filename: *const c_char, is_binary: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_releaseHDDLPlugin(ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_resetMyriadDevice(ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_setInferenceEngineBackendType_const_StringR(new_backend_type: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_shape_const_MatR(mat: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_shape_const_MatSizeR(sz: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_shape_const_UMatR(mat: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_shape_const_intX_const_int(dims: *const i32, n: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_shape_int(a0: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_shape_int_int_int_int(a0: i32, a1: i32, a2: i32, a3: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_shrinkCaffeModel_const_StringR_const_StringR(src: *const c_char, dst: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_shrinkCaffeModel_const_StringR_const_StringR_const_vectorLStringGR(src: *const c_char, dst: *const c_char, layers_types: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_slice_const_MatR_const__RangeR(m: *const c_void, r0: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_slice_const_MatR_const__RangeR_const__RangeR(m: *const c_void, r0: *const c_void, r1: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_slice_const_MatR_const__RangeR_const__RangeR_const__RangeR(m: *const c_void, r0: *const c_void, r1: *const c_void, r2: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_slice_const_MatR_const__RangeR_const__RangeR_const__RangeR_const__RangeR(m: *const c_void, r0: *const c_void, r1: *const c_void, r2: *const c_void, r3: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_softNMSBoxes_const_vectorLRectGR_const_vectorLfloatGR_vectorLfloatGR_const_float_const_float_vectorLintGR(bboxes: *const c_void, scores: *const c_void, updated_scores: *mut c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_softNMSBoxes_const_vectorLRectGR_const_vectorLfloatGR_vectorLfloatGR_const_float_const_float_vectorLintGR_size_t_const_float_SoftNMSMethod(bboxes: *const c_void, scores: *const c_void, updated_scores: *mut c_void, score_threshold: f32, nms_threshold: f32, indices: *mut c_void, top_k: size_t, sigma: f32, method: crate::dnn::SoftNMSMethod, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_total_const_MatR(mat: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_total_const_MatR_int_int(mat: *const c_void, start: i32, end: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_total_const_MatShapeR(shape: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_total_const_MatShapeR_int_int(shape: *const c_void, start: i32, end: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_writeTextGraph_const_StringR_const_StringR(model: *const c_char, output: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_AbsLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_AbsLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_AbsLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AbsLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AbsLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AbsLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_AccumLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_AccumLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_AccumLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AccumLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AccumLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_AcosLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_AcosLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_AcosLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AcosLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AcosLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AcosLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_AcoshLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_AcoshLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_AcoshLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AcoshLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AcoshLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AcoshLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ActivationLayer_forwardSlice_const_const_floatX_floatX_int_size_t_int_int(instance: *const c_void, src: *const f32, dst: *mut f32, len: i32, out_plane_size: size_t, cn0: i32, cn1: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_ActivationLayer_forwardSlice_const_const_intX_const_intX_intX_int_size_t_int_int(instance: *const c_void, src: *const i32, lut: *const i32, dst: *mut i32, len: i32, out_plane_size: size_t, cn0: i32, cn1: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_ActivationLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_AbsLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_AcosLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_AcoshLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_ActivationLayerInt8(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_AsinLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_AsinhLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_AtanLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_AtanhLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_BNLLLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_BatchNormLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_BatchNormLayerInt8(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_CeilLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_CeluLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_ChannelsPReLULayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_CosLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_CoshLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_ELULayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_ErfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_ExpLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_FloorLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_GeluApproximationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_GeluLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_HardSigmoidLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_HardSwishLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_LogLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_MishLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_NotLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_PowerLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_ReLU6Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_ReLULayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_ReciprocalLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_RoundLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_SeluLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_ShrinkLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_SigmoidLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_SignLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_SinLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_SinhLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_SoftplusLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_SoftsignLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_SqrtLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_SwishLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_TanHLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_TanLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_ThresholdedReluLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ActivationLayerInt8_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ActivationLayerInt8_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ActivationLayerInt8_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayerInt8_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayerInt8_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ActivationLayerInt8_delete(instance: *mut c_void);
		pub fn cv_dnn_ArgLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ArgLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ArgLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ArgLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ArgLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_AsinLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_AsinLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_AsinLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AsinLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AsinLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AsinLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_AsinhLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_AsinhLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_AsinhLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AsinhLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AsinhLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AsinhLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_AtanLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_AtanLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_AtanLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AtanLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AtanLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AtanLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_AtanhLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_AtanhLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_AtanhLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AtanhLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AtanhLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AtanhLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_AttentionLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_AttentionLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_AttentionLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AttentionLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_AttentionLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_BNLLLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_BNLLLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_BNLLLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_BNLLLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_BNLLLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_BNLLLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_BackendNode_propBackendId_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_BackendNode_propBackendId_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_BackendNode_delete(instance: *mut c_void);
		pub fn cv_dnn_BackendWrapper_copyToHost(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_BackendWrapper_setHostDirty(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_BackendWrapper_propBackendId_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_BackendWrapper_propBackendId_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_BackendWrapper_propTargetId_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_BackendWrapper_propTargetId_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_BackendWrapper_delete(instance: *mut c_void);
		pub fn cv_dnn_BaseConvolutionLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_propKernel_const(instance: *const c_void, ocvrs_return: *mut core::Size);
		pub fn cv_dnn_BaseConvolutionLayer_propKernel_const_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_BaseConvolutionLayer_propStride_const(instance: *const c_void, ocvrs_return: *mut core::Size);
		pub fn cv_dnn_BaseConvolutionLayer_propStride_const_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_BaseConvolutionLayer_propPad_const(instance: *const c_void, ocvrs_return: *mut core::Size);
		pub fn cv_dnn_BaseConvolutionLayer_propPad_const_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_BaseConvolutionLayer_propDilation_const(instance: *const c_void, ocvrs_return: *mut core::Size);
		pub fn cv_dnn_BaseConvolutionLayer_propDilation_const_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_BaseConvolutionLayer_propAdjustPad_const(instance: *const c_void, ocvrs_return: *mut core::Size);
		pub fn cv_dnn_BaseConvolutionLayer_propAdjustPad_const_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_BaseConvolutionLayer_propAdjust_pads_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_propAdjust_pads_const_vectorLsize_tG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_BaseConvolutionLayer_propKernel_size_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_propKernel_size_const_vectorLsize_tG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_BaseConvolutionLayer_propStrides_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_propStrides_const_vectorLsize_tG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_BaseConvolutionLayer_propDilations_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_propDilations_const_vectorLsize_tG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_BaseConvolutionLayer_propPads_begin_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_propPads_begin_const_vectorLsize_tG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_BaseConvolutionLayer_propPads_end_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_propPads_end_const_vectorLsize_tG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_BaseConvolutionLayer_propPadMode_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_propPadMode_const_String(instance: *mut c_void, val: *const c_char);
		pub fn cv_dnn_BaseConvolutionLayer_propNumOutput_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_BaseConvolutionLayer_propNumOutput_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_BaseConvolutionLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_BaseConvolutionLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_BatchNormLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_BatchNormLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_BatchNormLayer_propHasWeights_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_BatchNormLayer_propHasWeights_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_BatchNormLayer_propHasBias_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_BatchNormLayer_propHasBias_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_BatchNormLayer_propEpsilon_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_BatchNormLayer_propEpsilon_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_BatchNormLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_BatchNormLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_BatchNormLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_BatchNormLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_BatchNormLayerInt8_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_BatchNormLayerInt8_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_BatchNormLayerInt8_propInput_sc_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_BatchNormLayerInt8_propInput_sc_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_BatchNormLayerInt8_propOutput_sc_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_BatchNormLayerInt8_propOutput_sc_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_BatchNormLayerInt8_propInput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_BatchNormLayerInt8_propInput_zp_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_BatchNormLayerInt8_propOutput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_BatchNormLayerInt8_propOutput_zp_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_BatchNormLayerInt8_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_BatchNormLayerInt8_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_BatchNormLayerInt8_to_BatchNormLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_BatchNormLayerInt8_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_BatchNormLayerInt8_delete(instance: *mut c_void);
		pub fn cv_dnn_BlankLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_BlankLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_BlankLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_BlankLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_BlankLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_CeilLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_CeilLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_CeilLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CeilLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CeilLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CeilLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_CeluLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_CeluLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_CeluLayer_propAlpha_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_CeluLayer_propAlpha_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_CeluLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CeluLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CeluLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CeluLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ChannelsPReLULayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ChannelsPReLULayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ChannelsPReLULayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ChannelsPReLULayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ChannelsPReLULayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ChannelsPReLULayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ClassificationModel_ClassificationModel(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ClassificationModel_ClassificationModel_const_StringR_const_StringR(model: *const c_char, config: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ClassificationModel_ClassificationModel_const_StringR(model: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ClassificationModel_ClassificationModel_const_NetR(network: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ClassificationModel_setEnableSoftmaxPostProcessing_bool(instance: *mut c_void, enable: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ClassificationModel_getEnableSoftmaxPostProcessing_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_dnn_ClassificationModel_classify_const__InputArrayR(instance: *mut c_void, frame: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ClassificationModel_classify_const__InputArrayR_intR_floatR(instance: *mut c_void, frame: *const c_void, class_id: *mut i32, conf: *mut f32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_ClassificationModel_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_ClassificationModel_to_Model(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ClassificationModel_delete(instance: *mut c_void);
		pub fn cv_dnn_CompareLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_CompareLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_CompareLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CompareLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CompareLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ConcatLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ConcatLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ConcatLayer_propAxis_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_ConcatLayer_propAxis_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_ConcatLayer_propPadding_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_ConcatLayer_propPadding_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_ConcatLayer_propPaddingValue_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_ConcatLayer_propPaddingValue_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_ConcatLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ConcatLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ConcatLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ConstLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ConstLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ConstLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ConstLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ConstLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ConvolutionLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ConvolutionLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ConvolutionLayer_propFusedActivation_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_ConvolutionLayer_propFusedActivation_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_ConvolutionLayer_propFusedAdd_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_ConvolutionLayer_propFusedAdd_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_ConvolutionLayer_propUseWinograd_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_ConvolutionLayer_propUseWinograd_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_ConvolutionLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ConvolutionLayer_to_BaseConvolutionLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ConvolutionLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ConvolutionLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ConvolutionLayerInt8_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ConvolutionLayerInt8_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ConvolutionLayerInt8_propInput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_ConvolutionLayerInt8_propInput_zp_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_ConvolutionLayerInt8_propOutput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_ConvolutionLayerInt8_propOutput_zp_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_ConvolutionLayerInt8_propInput_sc_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ConvolutionLayerInt8_propInput_sc_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ConvolutionLayerInt8_propOutput_sc_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ConvolutionLayerInt8_propOutput_sc_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ConvolutionLayerInt8_propPer_channel_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_ConvolutionLayerInt8_propPer_channel_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_ConvolutionLayerInt8_propUseWinograd_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_ConvolutionLayerInt8_propUseWinograd_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_ConvolutionLayerInt8_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ConvolutionLayerInt8_to_BaseConvolutionLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ConvolutionLayerInt8_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ConvolutionLayerInt8_delete(instance: *mut c_void);
		pub fn cv_dnn_CorrelationLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_CorrelationLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_CorrelationLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CorrelationLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CorrelationLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_CosLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_CosLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_CosLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CosLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CosLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CosLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_CoshLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_CoshLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_CoshLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CoshLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CoshLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CoshLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_CropAndResizeLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_CropAndResizeLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_CropAndResizeLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CropAndResizeLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CropAndResizeLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_CropLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_CropLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_CropLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CropLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CropLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_CumSumLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_CumSumLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_CumSumLayer_propExclusive_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_CumSumLayer_propExclusive_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_CumSumLayer_propReverse_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_CumSumLayer_propReverse_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_CumSumLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CumSumLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_CumSumLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_DataAugmentationLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DataAugmentationLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_DataAugmentationLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_DataAugmentationLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_DataAugmentationLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_DeconvolutionLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DeconvolutionLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_DeconvolutionLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_DeconvolutionLayer_to_BaseConvolutionLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_DeconvolutionLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_DeconvolutionLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_DepthToSpaceLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DepthToSpaceLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_DepthToSpaceLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_DepthToSpaceLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_DepthToSpaceLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_DequantizeLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DequantizeLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_DequantizeLayer_propScales_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_DequantizeLayer_propScales_const_vectorLfloatG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_DequantizeLayer_propZeropoints_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_DequantizeLayer_propZeropoints_const_vectorLintG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_DequantizeLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_DequantizeLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_DequantizeLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_DetectionModel_DetectionModel_const_StringR_const_StringR(model: *const c_char, config: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DetectionModel_DetectionModel_const_StringR(model: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DetectionModel_DetectionModel_const_NetR(network: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DetectionModel_DetectionModel(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DetectionModel_setNmsAcrossClasses_bool(instance: *mut c_void, value: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DetectionModel_getNmsAcrossClasses(instance: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_dnn_DetectionModel_detect_const__InputArrayR_vectorLintGR_vectorLfloatGR_vectorLRectGR_float_float(instance: *mut c_void, frame: *const c_void, class_ids: *mut c_void, confidences: *mut c_void, boxes: *mut c_void, conf_threshold: f32, nms_threshold: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_DetectionModel_detect_const__InputArrayR_vectorLintGR_vectorLfloatGR_vectorLRectGR(instance: *mut c_void, frame: *const c_void, class_ids: *mut c_void, confidences: *mut c_void, boxes: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_DetectionModel_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_DetectionModel_to_Model(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_DetectionModel_delete(instance: *mut c_void);
		pub fn cv_dnn_DetectionOutputLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DetectionOutputLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_DetectionOutputLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_DetectionOutputLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_DetectionOutputLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_Dict_has_const_const_StringR(instance: *const c_void, key: *const c_char, ocvrs_return: *mut Result<bool>);
		pub fn cv_dnn_Dict_ptr_const_StringR(instance: *mut c_void, key: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Dict_ptr_const_const_StringR(instance: *const c_void, key: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Dict_get_const_const_StringR(instance: *const c_void, key: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Dict_set_const_cv_String_const_StringR_const_StringR(instance: *mut c_void, key: *const c_char, value: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Dict_set_const_cv_dnn_DictValue_const_StringR_const_DictValueR(instance: *mut c_void, key: *const c_char, value: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Dict_set_const_double_const_StringR_const_doubleR(instance: *mut c_void, key: *const c_char, value: *const f64, ocvrs_return: *mut Result<f64>);
		pub fn cv_dnn_Dict_set_const_int64_t_const_StringR_const_int64_tR(instance: *mut c_void, key: *const c_char, value: *const i64, ocvrs_return: *mut Result<i64>);
		pub fn cv_dnn_Dict_erase_const_StringR(instance: *mut c_void, key: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Dict_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_Dict_delete(instance: *mut c_void);
		pub fn cv_dnn_DictValue_DictValue_const_DictValueR(r: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DictValue_DictValue_bool(i: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DictValue_DictValue_int64_t(i: i64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DictValue_DictValue(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DictValue_DictValue_int(i: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DictValue_DictValue_unsigned_int(p: u32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DictValue_DictValue_double(p: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DictValue_DictValue_const_charX(s: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DictValue_get_cv_String_const_int(instance: *const c_void, idx: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DictValue_get_cv_String_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DictValue_get_double_const_int(instance: *const c_void, idx: i32, ocvrs_return: *mut Result<f64>);
		pub fn cv_dnn_DictValue_get_double_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_dnn_DictValue_get_int_const_int(instance: *const c_void, idx: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_DictValue_get_int_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_DictValue_get_int64_t_const_int(instance: *const c_void, idx: i32, ocvrs_return: *mut Result<i64>);
		pub fn cv_dnn_DictValue_get_int64_t_const(instance: *const c_void, ocvrs_return: *mut Result<i64>);
		pub fn cv_dnn_DictValue_size_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_DictValue_isInt_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_dnn_DictValue_isString_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_dnn_DictValue_isReal_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_dnn_DictValue_getIntValue_const_int(instance: *const c_void, idx: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_DictValue_getIntValue_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_DictValue_getRealValue_const_int(instance: *const c_void, idx: i32, ocvrs_return: *mut Result<f64>);
		pub fn cv_dnn_DictValue_getRealValue_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_dnn_DictValue_getStringValue_const_int(instance: *const c_void, idx: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DictValue_getStringValue_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_DictValue_operatorST_const_DictValueR(instance: *mut c_void, r: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_DictValue_delete(instance: *mut c_void);
		pub fn cv_dnn_ELULayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ELULayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ELULayer_propAlpha_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ELULayer_propAlpha_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ELULayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ELULayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ELULayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ELULayer_delete(instance: *mut c_void);
		pub fn cv_dnn_EinsumLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_EinsumLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_EinsumLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_EinsumLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_EinsumLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_EltwiseLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_EltwiseLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_EltwiseLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_EltwiseLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_EltwiseLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_EltwiseLayerInt8_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_EltwiseLayerInt8_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_EltwiseLayerInt8_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_EltwiseLayerInt8_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_EltwiseLayerInt8_delete(instance: *mut c_void);
		pub fn cv_dnn_ErfLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ErfLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ErfLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ErfLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ErfLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ErfLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ExpLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ExpLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ExpLayer_propBase_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ExpLayer_propBase_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ExpLayer_propScale_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ExpLayer_propScale_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ExpLayer_propShift_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ExpLayer_propShift_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ExpLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ExpLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ExpLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ExpLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ExpandLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ExpandLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ExpandLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ExpandLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ExpandLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_FlattenLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_FlattenLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_FlattenLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_FlattenLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_FlattenLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_FloorLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_FloorLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_FloorLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_FloorLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_FloorLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_FloorLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_FlowWarpLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_FlowWarpLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_FlowWarpLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_FlowWarpLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_FlowWarpLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_GRULayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_GRULayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_GRULayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GRULayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GRULayer_delete(instance: *mut c_void);
		pub fn cv_dnn_GatherElementsLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_GatherElementsLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_GatherElementsLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GatherElementsLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GatherElementsLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_GatherLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_GatherLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_GatherLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GatherLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GatherLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_GeluApproximationLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_GeluApproximationLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_GeluApproximationLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GeluApproximationLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GeluApproximationLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GeluApproximationLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_GeluLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_GeluLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_GeluLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GeluLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GeluLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GeluLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_GemmLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_GemmLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_GemmLayer_propTrans_a_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_GemmLayer_propTrans_a_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_GemmLayer_propTrans_b_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_GemmLayer_propTrans_b_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_GemmLayer_propAlpha_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_GemmLayer_propAlpha_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_GemmLayer_propBeta_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_GemmLayer_propBeta_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_GemmLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GemmLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GemmLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_GroupNormLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_GroupNormLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_GroupNormLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GroupNormLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_GroupNormLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_HardSigmoidLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_HardSigmoidLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_HardSigmoidLayer_propAlpha_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_HardSigmoidLayer_propAlpha_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_HardSigmoidLayer_propBeta_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_HardSigmoidLayer_propBeta_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_HardSigmoidLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_HardSigmoidLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_HardSigmoidLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_HardSigmoidLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_HardSwishLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_HardSwishLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_HardSwishLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_HardSwishLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_HardSwishLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_HardSwishLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_Image2BlobParams_Image2BlobParams(ocvrs_return: *mut Result<crate::dnn::Image2BlobParams>);
		pub fn cv_dnn_Image2BlobParams_Image2BlobParams_const_ScalarR_const_SizeR_const_ScalarR_bool_int_DataLayout_ImagePaddingMode_Scalar(scalefactor: *const core::Scalar, size: *const core::Size, mean: *const core::Scalar, swap_rb: bool, ddepth: i32, datalayout: crate::dnn::DataLayout, mode: crate::dnn::ImagePaddingMode, border_value: *const core::Scalar, ocvrs_return: *mut Result<crate::dnn::Image2BlobParams>);
		pub fn cv_dnn_Image2BlobParams_Image2BlobParams_const_ScalarR(scalefactor: *const core::Scalar, ocvrs_return: *mut Result<crate::dnn::Image2BlobParams>);
		pub fn cv_dnn_Image2BlobParams_blobRectToImageRect_const_RectR_const_SizeR(instance: *const crate::dnn::Image2BlobParams, r_blob: *const core::Rect, size: *const core::Size, ocvrs_return: *mut Result<core::Rect>);
		pub fn cv_dnn_Image2BlobParams_blobRectsToImageRects_const_vectorLRectGR_vectorLRectGR_const_SizeR(instance: *const crate::dnn::Image2BlobParams, r_blob: *const c_void, r_img: *mut c_void, size: *const core::Size, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_InnerProductLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_InnerProductLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_InnerProductLayer_propAxis_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_InnerProductLayer_propAxis_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_InnerProductLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_InnerProductLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_InnerProductLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_InnerProductLayerInt8_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_InnerProductLayerInt8_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_InnerProductLayerInt8_propInput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_InnerProductLayerInt8_propInput_zp_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_InnerProductLayerInt8_propOutput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_InnerProductLayerInt8_propOutput_zp_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_InnerProductLayerInt8_propInput_sc_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_InnerProductLayerInt8_propInput_sc_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_InnerProductLayerInt8_propOutput_sc_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_InnerProductLayerInt8_propOutput_sc_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_InnerProductLayerInt8_propPer_channel_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_InnerProductLayerInt8_propPer_channel_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_InnerProductLayerInt8_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_InnerProductLayerInt8_to_InnerProductLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_InnerProductLayerInt8_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_InnerProductLayerInt8_delete(instance: *mut c_void);
		pub fn cv_dnn_InstanceNormLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_InstanceNormLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_InstanceNormLayer_propEpsilon_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_InstanceNormLayer_propEpsilon_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_InstanceNormLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_InstanceNormLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_InstanceNormLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_InterpLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_InterpLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_InterpLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_InterpLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_InterpLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_KeypointsModel_KeypointsModel_const_StringR_const_StringR(model: *const c_char, config: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_KeypointsModel_KeypointsModel_const_StringR(model: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_KeypointsModel_KeypointsModel_const_NetR(network: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_KeypointsModel_estimate_const__InputArrayR_float(instance: *mut c_void, frame: *const c_void, thresh: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_KeypointsModel_estimate_const__InputArrayR(instance: *mut c_void, frame: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_KeypointsModel_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_KeypointsModel_to_Model(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_KeypointsModel_delete(instance: *mut c_void);
		pub fn cv_dnn_LRNLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_LRNLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_LRNLayer_propType_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_LRNLayer_propType_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_LRNLayer_propSize_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_LRNLayer_propSize_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_LRNLayer_propAlpha_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_LRNLayer_propAlpha_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_LRNLayer_propBeta_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_LRNLayer_propBeta_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_LRNLayer_propBias_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_LRNLayer_propBias_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_LRNLayer_propNormBySize_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_LRNLayer_propNormBySize_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_LRNLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_LRNLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_LRNLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_LSTMLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_LSTMLayer_setWeights_const_MatR_const_MatR_const_MatR(instance: *mut c_void, wh: *const c_void, wx: *const c_void, b: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_LSTMLayer_setOutShape_const_MatShapeR(instance: *mut c_void, out_tail_shape: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_LSTMLayer_setOutShape(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_LSTMLayer_setUseTimstampsDim_bool(instance: *mut c_void, use_: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_LSTMLayer_setUseTimstampsDim(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_LSTMLayer_setProduceCellOutput_bool(instance: *mut c_void, produce: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_LSTMLayer_setProduceCellOutput(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_LSTMLayer_inputNameToIndex_String(instance: *mut c_void, input_name: *const c_char, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_LSTMLayer_outputNameToIndex_const_StringR(instance: *mut c_void, output_name: *const c_char, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_LSTMLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_LSTMLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_LSTMLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_Layer_finalize_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, inputs: *const c_void, outputs: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Layer_forward_vectorLMatXGR_vectorLMatGR_vectorLMatGR(instance: *mut c_void, input: *mut c_void, output: *mut c_void, internals: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Layer_forward_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, inputs: *const c_void, outputs: *const c_void, internals: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Layer_tryQuantize_const_vectorLvectorLfloatGGR_const_vectorLvectorLintGGR_LayerParamsR(instance: *mut c_void, scales: *const c_void, zeropoints: *const c_void, params: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_dnn_Layer_forward_fallback_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(instance: *mut c_void, inputs: *const c_void, outputs: *const c_void, internals: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Layer_finalize_const_vectorLMatGR_vectorLMatGR(instance: *mut c_void, inputs: *const c_void, outputs: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Layer_finalize_const_vectorLMatGR(instance: *mut c_void, inputs: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Layer_run_const_vectorLMatGR_vectorLMatGR_vectorLMatGR(instance: *mut c_void, inputs: *const c_void, outputs: *mut c_void, internals: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Layer_inputNameToIndex_String(instance: *mut c_void, input_name: *const c_char, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_Layer_outputNameToIndex_const_StringR(instance: *mut c_void, output_name: *const c_char, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_Layer_supportBackend_int(instance: *mut c_void, backend_id: i32, ocvrs_return: *mut Result<bool>);
		pub fn cv_dnn_Layer_initHalide_const_vectorLPtrLBackendWrapperGGR(instance: *mut c_void, inputs: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Layer_initNgraph_const_vectorLPtrLBackendWrapperGGR_const_vectorLPtrLBackendNodeGGR(instance: *mut c_void, inputs: *const c_void, nodes: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Layer_initVkCom_const_vectorLPtrLBackendWrapperGGR_vectorLPtrLBackendWrapperGGR(instance: *mut c_void, inputs: *const c_void, outputs: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Layer_initWebnn_const_vectorLPtrLBackendWrapperGGR_const_vectorLPtrLBackendNodeGGR(instance: *mut c_void, inputs: *const c_void, nodes: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Layer_initCUDA_voidX_const_vectorLPtrLBackendWrapperGGR_const_vectorLPtrLBackendWrapperGGR(instance: *mut c_void, context: *mut c_void, inputs: *const c_void, outputs: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Layer_initTimVX_voidX_const_vectorLPtrLBackendWrapperGGR_const_vectorLPtrLBackendWrapperGGR_bool(instance: *mut c_void, tim_vx_info: *mut c_void, inputs_wrapper: *const c_void, outputs_wrapper: *const c_void, is_last: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Layer_initCann_const_vectorLPtrLBackendWrapperGGR_const_vectorLPtrLBackendWrapperGGR_const_vectorLPtrLBackendNodeGGR(instance: *mut c_void, inputs: *const c_void, outputs: *const c_void, nodes: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Layer_applyHalideScheduler_const_PtrLBackendNodeGR_const_vectorLMatXGR_const_vectorLMatGR_int(instance: *const c_void, node: *mut c_void, inputs: *const c_void, outputs: *const c_void, target_id: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Layer_tryAttach_const_PtrLBackendNodeGR(instance: *mut c_void, node: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Layer_setActivation_const_PtrLActivationLayerGR(instance: *mut c_void, layer: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_dnn_Layer_tryFuse_PtrLLayerGR(instance: *mut c_void, top: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_dnn_Layer_getScaleShift_const_MatR_MatR(instance: *const c_void, scale: *mut c_void, shift: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Layer_getScaleZeropoint_const_floatR_intR(instance: *const c_void, scale: *mut f32, zeropoint: *mut i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Layer_unsetAttached(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Layer_getMemoryShapes_const_const_vectorLMatShapeGR_const_int_vectorLMatShapeGR_vectorLMatShapeGR(instance: *const c_void, inputs: *const c_void, required_outputs: i32, outputs: *mut c_void, internals: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_dnn_Layer_getFLOPS_const_const_vectorLMatShapeGR_const_vectorLMatShapeGR(instance: *const c_void, inputs: *const c_void, outputs: *const c_void, ocvrs_return: *mut Result<i64>);
		pub fn cv_dnn_Layer_updateMemoryShapes_const_vectorLMatShapeGR(instance: *mut c_void, inputs: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_dnn_Layer_Layer(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Layer_Layer_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Layer_setParamsFrom_const_LayerParamsR(instance: *mut c_void, params: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Layer_propBlobs_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_propBlobs_const_vectorLMatG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_Layer_propName_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_propName_const_String(instance: *mut c_void, val: *const c_char);
		pub fn cv_dnn_Layer_propType_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_propType_const_String(instance: *mut c_void, val: *const c_char);
		pub fn cv_dnn_Layer_propPreferableTarget_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_Layer_propPreferableTarget_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_Layer_to_AbsLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_AccumLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_AcosLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_AcoshLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ActivationLayerInt8(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ArgLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_AsinLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_AsinhLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_AtanLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_AtanhLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_AttentionLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_BNLLLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_BaseConvolutionLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_BatchNormLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_BatchNormLayerInt8(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_BlankLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_CeilLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_CeluLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ChannelsPReLULayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_CompareLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ConcatLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ConstLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ConvolutionLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ConvolutionLayerInt8(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_CorrelationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_CosLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_CoshLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_CropAndResizeLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_CropLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_CumSumLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_DataAugmentationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_DeconvolutionLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_DepthToSpaceLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_DequantizeLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_DetectionOutputLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ELULayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_EinsumLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_EltwiseLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_EltwiseLayerInt8(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ErfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ExpLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ExpandLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_FlattenLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_FloorLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_FlowWarpLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_GRULayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_GatherElementsLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_GatherLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_GeluApproximationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_GeluLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_GemmLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_GroupNormLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_HardSigmoidLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_HardSwishLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_InnerProductLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_InnerProductLayerInt8(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_InstanceNormLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_InterpLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_LRNLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_LSTMLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_LayerNormLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_LogLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_MVNLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_MatMulLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_MaxUnpoolLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_MishLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_NaryEltwiseLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_NormalizeBBoxLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_NotLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_PaddingLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_PermuteLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_PoolingLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_PoolingLayerInt8(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_PowerLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_PriorBoxLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ProposalLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_QuantizeLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_RNNLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ReLU6Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ReLULayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ReciprocalLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ReduceLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_RegionLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ReorgLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_RequantizeLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ReshapeLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ResizeLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_RoundLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ScaleLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ScaleLayerInt8(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ScatterLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ScatterNDLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_SeluLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ShiftLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ShiftLayerInt8(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ShrinkLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ShuffleChannelLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_SigmoidLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_SignLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_SinLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_SinhLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_SliceLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_SoftmaxLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_SoftmaxLayerInt8(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_SoftplusLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_SoftsignLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_SpaceToDepthLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_SplitLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_SqrtLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_SwishLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_TanHLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_TanLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_ThresholdedReluLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_TileLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_TopKLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Layer_delete(instance: *mut c_void);
		pub fn cv_dnn_LayerFactory_registerLayer_const_StringR_Constructor(typ: *const c_char, constructor: Option<unsafe extern "C" fn(*mut c_void) -> *mut c_void>, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_LayerFactory_unregisterLayer_const_StringR(typ: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_LayerFactory_isLayerRegistered_const_stringR(typ: *const c_char, ocvrs_return: *mut Result<bool>);
		pub fn cv_dnn_LayerFactory_createLayerInstance_const_StringR_LayerParamsR(typ: *const c_char, params: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_LayerFactory_delete(instance: *mut c_void);
		pub fn cv_dnn_LayerNormLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_LayerNormLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_LayerNormLayer_propHasBias_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_LayerNormLayer_propHasBias_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_LayerNormLayer_propAxis_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_LayerNormLayer_propAxis_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_LayerNormLayer_propEpsilon_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_LayerNormLayer_propEpsilon_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_LayerNormLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_LayerNormLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_LayerNormLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_LayerParams_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_LayerParams_propBlobs_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_LayerParams_propBlobs_const_vectorLMatG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_LayerParams_propName_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_LayerParams_propName_const_String(instance: *mut c_void, val: *const c_char);
		pub fn cv_dnn_LayerParams_propType_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_LayerParams_propType_const_String(instance: *mut c_void, val: *const c_char);
		pub fn cv_dnn_LayerParams_to_Dict(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_LayerParams_delete(instance: *mut c_void);
		pub fn cv_dnn_LogLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_LogLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_LogLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_LogLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_LogLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_LogLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_MVNLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_MVNLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_MVNLayer_propEps_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_MVNLayer_propEps_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_MVNLayer_propNormVariance_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_MVNLayer_propNormVariance_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_MVNLayer_propAcrossChannels_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_MVNLayer_propAcrossChannels_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_MVNLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_MVNLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_MVNLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_MatMulLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_MatMulLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_MatMulLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_MatMulLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_MatMulLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_MaxUnpoolLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_MaxUnpoolLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_MaxUnpoolLayer_propPoolKernel_const(instance: *const c_void, ocvrs_return: *mut core::Size);
		pub fn cv_dnn_MaxUnpoolLayer_propPoolKernel_const_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_MaxUnpoolLayer_propPoolPad_const(instance: *const c_void, ocvrs_return: *mut core::Size);
		pub fn cv_dnn_MaxUnpoolLayer_propPoolPad_const_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_MaxUnpoolLayer_propPoolStride_const(instance: *const c_void, ocvrs_return: *mut core::Size);
		pub fn cv_dnn_MaxUnpoolLayer_propPoolStride_const_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_MaxUnpoolLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_MaxUnpoolLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_MaxUnpoolLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_MishLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_MishLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_MishLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_MishLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_MishLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_MishLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_Model_Model(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_Model_const_ModelR(unnamed: *const c_void) -> *mut c_void;
		pub fn cv_dnn_Model_Model_ModelRR(unnamed: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_Model_operatorST_const_ModelR(instance: *mut c_void, unnamed: *const c_void);
		pub fn cv_dnn_Model_operatorST_ModelRR(instance: *mut c_void, unnamed: *mut c_void);
		pub fn cv_dnn_Model_Model_const_StringR_const_StringR(model: *const c_char, config: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_Model_const_StringR(model: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_Model_const_NetR(network: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_setInputSize_const_SizeR(instance: *mut c_void, size: *const core::Size, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_setInputSize_int_int(instance: *mut c_void, width: i32, height: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_setInputMean_const_ScalarR(instance: *mut c_void, mean: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_setInputScale_const_ScalarR(instance: *mut c_void, scale: *const core::Scalar, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_setInputCrop_bool(instance: *mut c_void, crop: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_setInputSwapRB_bool(instance: *mut c_void, swap_rb: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_setOutputNames_const_vectorLStringGR(instance: *mut c_void, out_names: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_setInputParams_double_const_SizeR_const_ScalarR_bool_bool(instance: *mut c_void, scale: f64, size: *const core::Size, mean: *const core::Scalar, swap_rb: bool, crop: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Model_setInputParams(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Model_predict_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, frame: *const c_void, outs: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Model_setPreferableBackend_Backend(instance: *mut c_void, backend_id: crate::dnn::Backend, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_setPreferableTarget_Target(instance: *mut c_void, target_id: crate::dnn::Target, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_enableWinograd_bool(instance: *mut c_void, use_winograd: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_getNetwork__const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_getNetwork_(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Model_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_Model_delete(instance: *mut c_void);
		pub fn cv_dnn_NaryEltwiseLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_NaryEltwiseLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_NaryEltwiseLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_NaryEltwiseLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_NaryEltwiseLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_Net_Net(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_readFromModelOptimizer_const_StringR_const_StringR(xml: *const c_char, bin: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_readFromModelOptimizer_const_vectorLunsigned_charGR_const_vectorLunsigned_charGR(buffer_model_config: *const c_void, buffer_weights: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_readFromModelOptimizer_const_unsigned_charX_size_t_const_unsigned_charX_size_t(buffer_model_config_ptr: *const u8, buffer_model_config_size: size_t, buffer_weights_ptr: *const u8, buffer_weights_size: size_t, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_dnn_Net_dump(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_dumpToFile_const_StringR(instance: *mut c_void, path: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_dumpToPbtxt_const_StringR(instance: *mut c_void, path: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_addLayer_const_StringR_const_StringR_const_intR_LayerParamsR(instance: *mut c_void, name: *const c_char, typ: *const c_char, dtype: *const i32, params: *mut c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_Net_addLayer_const_StringR_const_StringR_LayerParamsR(instance: *mut c_void, name: *const c_char, typ: *const c_char, params: *mut c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_Net_addLayerToPrev_const_StringR_const_StringR_const_intR_LayerParamsR(instance: *mut c_void, name: *const c_char, typ: *const c_char, dtype: *const i32, params: *mut c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_Net_addLayerToPrev_const_StringR_const_StringR_LayerParamsR(instance: *mut c_void, name: *const c_char, typ: *const c_char, params: *mut c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_Net_getLayerId_const_const_StringR(instance: *const c_void, layer: *const c_char, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_Net_getLayerNames_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_getLayer_const_int(instance: *const c_void, layer_id: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_getLayer_const_const_StringR(instance: *const c_void, layer_name: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_getLayer_const_const_LayerIdR(instance: *const c_void, layer_id: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_getLayerInputs_const_int(instance: *const c_void, layer_id: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_connect_String_String(instance: *mut c_void, out_pin: *const c_char, inp_pin: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_connect_int_int_int_int(instance: *mut c_void, out_layer_id: i32, out_num: i32, inp_layer_id: i32, inp_num: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_registerOutput_const_stringR_int_int(instance: *mut c_void, output_name: *const c_char, layer_id: i32, output_port: i32, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_Net_setInputsNames_const_vectorLStringGR(instance: *mut c_void, input_blob_names: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_setInputShape_const_StringR_const_MatShapeR(instance: *mut c_void, input_name: *const c_char, shape: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_forward_const_StringR(instance: *mut c_void, output_name: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_forward(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_forwardAsync_const_StringR(instance: *mut c_void, output_name: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_forwardAsync(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_forward_const__OutputArrayR_const_StringR(instance: *mut c_void, output_blobs: *const c_void, output_name: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_forward_const__OutputArrayR(instance: *mut c_void, output_blobs: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_forward_const__OutputArrayR_const_vectorLStringGR(instance: *mut c_void, output_blobs: *const c_void, out_blob_names: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_forward_vectorLvectorLMatGGR_const_vectorLStringGR(instance: *mut c_void, output_blobs: *mut c_void, out_blob_names: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_quantize_const__InputArrayR_int_int_bool(instance: *mut c_void, calib_data: *const c_void, inputs_dtype: i32, outputs_dtype: i32, per_channel: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_quantize_const__InputArrayR_int_int(instance: *mut c_void, calib_data: *const c_void, inputs_dtype: i32, outputs_dtype: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_getInputDetails_const_vectorLfloatGR_vectorLintGR(instance: *const c_void, scales: *mut c_void, zeropoints: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_getOutputDetails_const_vectorLfloatGR_vectorLintGR(instance: *const c_void, scales: *mut c_void, zeropoints: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_setHalideScheduler_const_StringR(instance: *mut c_void, scheduler: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_setPreferableBackend_int(instance: *mut c_void, backend_id: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_setPreferableTarget_int(instance: *mut c_void, target_id: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_setInput_const__InputArrayR_const_StringR_double_const_ScalarR(instance: *mut c_void, blob: *const c_void, name: *const c_char, scalefactor: f64, mean: *const core::Scalar, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_setInput_const__InputArrayR(instance: *mut c_void, blob: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_setParam_int_int_const_MatR(instance: *mut c_void, layer: i32, num_param: i32, blob: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_setParam_const_StringR_int_const_MatR(instance: *mut c_void, layer_name: *const c_char, num_param: i32, blob: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_getParam_const_int_int(instance: *const c_void, layer: i32, num_param: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_getParam_const_int(instance: *const c_void, layer: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_getParam_const_const_StringR_int(instance: *const c_void, layer_name: *const c_char, num_param: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_getParam_const_const_StringR(instance: *const c_void, layer_name: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_getUnconnectedOutLayers_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_getUnconnectedOutLayersNames_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_Net_getLayersShapes_const_const_vectorLMatShapeGR_vectorLintGR_vectorLvectorLMatShapeGGR_vectorLvectorLMatShapeGGR(instance: *const c_void, net_input_shapes: *const c_void, layers_ids: *mut c_void, in_layers_shapes: *mut c_void, out_layers_shapes: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_getLayersShapes_const_const_MatShapeR_vectorLintGR_vectorLvectorLMatShapeGGR_vectorLvectorLMatShapeGGR(instance: *const c_void, net_input_shape: *const c_void, layers_ids: *mut c_void, in_layers_shapes: *mut c_void, out_layers_shapes: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_getLayerShapes_const_const_MatShapeR_const_int_vectorLMatShapeGR_vectorLMatShapeGR(instance: *const c_void, net_input_shape: *const c_void, layer_id: i32, in_layer_shapes: *mut c_void, out_layer_shapes: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_getLayerShapes_const_const_vectorLMatShapeGR_const_int_vectorLMatShapeGR_vectorLMatShapeGR(instance: *const c_void, net_input_shapes: *const c_void, layer_id: i32, in_layer_shapes: *mut c_void, out_layer_shapes: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_getFLOPS_const_const_vectorLMatShapeGR(instance: *const c_void, net_input_shapes: *const c_void, ocvrs_return: *mut Result<i64>);
		pub fn cv_dnn_Net_getFLOPS_const_const_MatShapeR(instance: *const c_void, net_input_shape: *const c_void, ocvrs_return: *mut Result<i64>);
		pub fn cv_dnn_Net_getFLOPS_const_const_int_const_vectorLMatShapeGR(instance: *const c_void, layer_id: i32, net_input_shapes: *const c_void, ocvrs_return: *mut Result<i64>);
		pub fn cv_dnn_Net_getFLOPS_const_const_int_const_MatShapeR(instance: *const c_void, layer_id: i32, net_input_shape: *const c_void, ocvrs_return: *mut Result<i64>);
		pub fn cv_dnn_Net_getLayerTypes_const_vectorLStringGR(instance: *const c_void, layers_types: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_getLayersCount_const_const_StringR(instance: *const c_void, layer_type: *const c_char, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_Net_getMemoryConsumption_const_const_vectorLMatShapeGR_size_tR_size_tR(instance: *const c_void, net_input_shapes: *const c_void, weights: *mut size_t, blobs: *mut size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_getMemoryConsumption_const_const_MatShapeR_size_tR_size_tR(instance: *const c_void, net_input_shape: *const c_void, weights: *mut size_t, blobs: *mut size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_getMemoryConsumption_const_const_int_const_vectorLMatShapeGR_size_tR_size_tR(instance: *const c_void, layer_id: i32, net_input_shapes: *const c_void, weights: *mut size_t, blobs: *mut size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_getMemoryConsumption_const_const_int_const_MatShapeR_size_tR_size_tR(instance: *const c_void, layer_id: i32, net_input_shape: *const c_void, weights: *mut size_t, blobs: *mut size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_getMemoryConsumption_const_const_vectorLMatShapeGR_vectorLintGR_vectorLsize_tGR_vectorLsize_tGR(instance: *const c_void, net_input_shapes: *const c_void, layer_ids: *mut c_void, weights: *mut c_void, blobs: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_getMemoryConsumption_const_const_MatShapeR_vectorLintGR_vectorLsize_tGR_vectorLsize_tGR(instance: *const c_void, net_input_shape: *const c_void, layer_ids: *mut c_void, weights: *mut c_void, blobs: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_enableFusion_bool(instance: *mut c_void, fusion: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_enableWinograd_bool(instance: *mut c_void, use_winograd: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_Net_getPerfProfile_vectorLdoubleGR(instance: *mut c_void, timings: *mut c_void, ocvrs_return: *mut Result<i64>);
		pub fn cv_dnn_Net_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_Net_delete(instance: *mut c_void);
		pub fn cv_dnn_NormalizeBBoxLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_NormalizeBBoxLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_NormalizeBBoxLayer_propPnorm_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_NormalizeBBoxLayer_propPnorm_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_NormalizeBBoxLayer_propEpsilon_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_NormalizeBBoxLayer_propEpsilon_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_NormalizeBBoxLayer_propAcrossSpatial_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_NormalizeBBoxLayer_propAcrossSpatial_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_NormalizeBBoxLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_NormalizeBBoxLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_NormalizeBBoxLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_NotLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_NotLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_NotLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_NotLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_NotLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_NotLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_PaddingLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_PaddingLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_PaddingLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_PaddingLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_PaddingLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_PermuteLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_PermuteLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_PermuteLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_PermuteLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_PermuteLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_PoolingLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_PoolingLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_PoolingLayer_propType_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_PoolingLayer_propType_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_PoolingLayer_propKernel_size_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayer_propKernel_size_const_vectorLsize_tG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_PoolingLayer_propStrides_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayer_propStrides_const_vectorLsize_tG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_PoolingLayer_propPads_begin_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayer_propPads_begin_const_vectorLsize_tG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_PoolingLayer_propPads_end_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayer_propPads_end_const_vectorLsize_tG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_PoolingLayer_propGlobalPooling_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_PoolingLayer_propGlobalPooling_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_PoolingLayer_propIsGlobalPooling_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayer_propIsGlobalPooling_const_vectorLboolG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_PoolingLayer_propComputeMaxIdx_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_PoolingLayer_propComputeMaxIdx_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_PoolingLayer_propPadMode_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayer_propPadMode_const_String(instance: *mut c_void, val: *const c_char);
		pub fn cv_dnn_PoolingLayer_propCeilMode_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_PoolingLayer_propCeilMode_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_PoolingLayer_propAvePoolPaddedArea_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_PoolingLayer_propAvePoolPaddedArea_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_PoolingLayer_propPooledSize_const(instance: *const c_void, ocvrs_return: *mut core::Size);
		pub fn cv_dnn_PoolingLayer_propPooledSize_const_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_dnn_PoolingLayer_propSpatialScale_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_PoolingLayer_propSpatialScale_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_PoolingLayer_propPsRoiOutChannels_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_PoolingLayer_propPsRoiOutChannels_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_PoolingLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_PoolingLayerInt8_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_PoolingLayerInt8_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_PoolingLayerInt8_propInput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_PoolingLayerInt8_propInput_zp_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_PoolingLayerInt8_propOutput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_PoolingLayerInt8_propOutput_zp_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_PoolingLayerInt8_propInput_sc_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_PoolingLayerInt8_propInput_sc_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_PoolingLayerInt8_propOutput_sc_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_PoolingLayerInt8_propOutput_sc_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_PoolingLayerInt8_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayerInt8_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayerInt8_to_PoolingLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_PoolingLayerInt8_delete(instance: *mut c_void);
		pub fn cv_dnn_PowerLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_PowerLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_PowerLayer_propPower_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_PowerLayer_propPower_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_PowerLayer_propScale_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_PowerLayer_propScale_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_PowerLayer_propShift_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_PowerLayer_propShift_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_PowerLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_PowerLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_PowerLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_PowerLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_PriorBoxLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_PriorBoxLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_PriorBoxLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_PriorBoxLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_PriorBoxLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ProposalLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ProposalLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ProposalLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ProposalLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ProposalLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_QuantizeLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_QuantizeLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_QuantizeLayer_propScales_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_QuantizeLayer_propScales_const_vectorLfloatG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_QuantizeLayer_propZeropoints_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_QuantizeLayer_propZeropoints_const_vectorLintG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_QuantizeLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_QuantizeLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_QuantizeLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_RNNLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_RNNLayer_setWeights_const_MatR_const_MatR_const_MatR_const_MatR_const_MatR(instance: *mut c_void, wxh: *const c_void, bh: *const c_void, whh: *const c_void, who: *const c_void, bo: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_RNNLayer_setProduceHiddenOutput_bool(instance: *mut c_void, produce: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_RNNLayer_setProduceHiddenOutput(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_RNNLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_RNNLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_RNNLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ReLU6Layer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ReLU6Layer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ReLU6Layer_propMinValue_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ReLU6Layer_propMinValue_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ReLU6Layer_propMaxValue_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ReLU6Layer_propMaxValue_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ReLU6Layer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ReLU6Layer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ReLU6Layer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ReLU6Layer_delete(instance: *mut c_void);
		pub fn cv_dnn_ReLULayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ReLULayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ReLULayer_propNegativeSlope_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ReLULayer_propNegativeSlope_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ReLULayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ReLULayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ReLULayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ReLULayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ReciprocalLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ReciprocalLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ReciprocalLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ReciprocalLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ReciprocalLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ReciprocalLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ReduceLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ReduceLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ReduceLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ReduceLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ReduceLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_RegionLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_RegionLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_RegionLayer_propNmsThreshold_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_RegionLayer_propNmsThreshold_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_RegionLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_RegionLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_RegionLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ReorgLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ReorgLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ReorgLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ReorgLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ReorgLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_RequantizeLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_RequantizeLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_RequantizeLayer_propScale_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_RequantizeLayer_propScale_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_RequantizeLayer_propShift_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_RequantizeLayer_propShift_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_RequantizeLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_RequantizeLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_RequantizeLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ReshapeLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ReshapeLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ReshapeLayer_propNewShapeDesc_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_ReshapeLayer_propNewShapeDesc_const_MatShape(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_ReshapeLayer_propNewShapeRange_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_ReshapeLayer_propNewShapeRange_const_Range(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_ReshapeLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ReshapeLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ReshapeLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ResizeLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ResizeLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ResizeLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ResizeLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ResizeLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_RoundLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_RoundLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_RoundLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_RoundLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_RoundLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_RoundLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ScaleLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ScaleLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ScaleLayer_propHasBias_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_ScaleLayer_propHasBias_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_ScaleLayer_propAxis_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_ScaleLayer_propAxis_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_ScaleLayer_propMode_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_ScaleLayer_propMode_const_String(instance: *mut c_void, val: *const c_char);
		pub fn cv_dnn_ScaleLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ScaleLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ScaleLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ScaleLayerInt8_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ScaleLayerInt8_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ScaleLayerInt8_propOutput_sc_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ScaleLayerInt8_propOutput_sc_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ScaleLayerInt8_propOutput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_ScaleLayerInt8_propOutput_zp_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_ScaleLayerInt8_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ScaleLayerInt8_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ScaleLayerInt8_to_ScaleLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ScaleLayerInt8_delete(instance: *mut c_void);
		pub fn cv_dnn_ScatterLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ScatterLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ScatterLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ScatterLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ScatterLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ScatterNDLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ScatterNDLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ScatterNDLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ScatterNDLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ScatterNDLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_SegmentationModel_SegmentationModel_const_StringR_const_StringR(model: *const c_char, config: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SegmentationModel_SegmentationModel_const_StringR(model: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SegmentationModel_SegmentationModel_const_NetR(network: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SegmentationModel_segment_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, frame: *const c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_SegmentationModel_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_SegmentationModel_to_Model(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SegmentationModel_delete(instance: *mut c_void);
		pub fn cv_dnn_SeluLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SeluLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_SeluLayer_propAlpha_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_SeluLayer_propAlpha_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_SeluLayer_propGamma_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_SeluLayer_propGamma_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_SeluLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SeluLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SeluLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SeluLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ShiftLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ShiftLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ShiftLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ShiftLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ShiftLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ShiftLayerInt8_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ShiftLayerInt8_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ShiftLayerInt8_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ShiftLayerInt8_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ShiftLayerInt8_delete(instance: *mut c_void);
		pub fn cv_dnn_ShrinkLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ShrinkLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ShrinkLayer_propBias_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ShrinkLayer_propBias_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ShrinkLayer_propLambd_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ShrinkLayer_propLambd_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ShrinkLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ShrinkLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ShrinkLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ShrinkLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_ShuffleChannelLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ShuffleChannelLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ShuffleChannelLayer_propGroup_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_ShuffleChannelLayer_propGroup_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_ShuffleChannelLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ShuffleChannelLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ShuffleChannelLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_SigmoidLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SigmoidLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_SigmoidLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SigmoidLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SigmoidLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SigmoidLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_SignLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SignLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_SignLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SignLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SignLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SignLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_SinLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SinLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_SinLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SinLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SinLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SinLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_SinhLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SinhLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_SinhLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SinhLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SinhLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SinhLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_SliceLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SliceLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_SliceLayer_propSliceRanges_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_SliceLayer_propSliceRanges_const_vectorLvectorLRangeGG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_SliceLayer_propSliceSteps_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_SliceLayer_propSliceSteps_const_vectorLvectorLintGG(instance: *mut c_void, val: *const c_void);
		pub fn cv_dnn_SliceLayer_propAxis_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_SliceLayer_propAxis_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_SliceLayer_propNum_split_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_SliceLayer_propNum_split_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_SliceLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SliceLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SliceLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_SoftmaxLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SoftmaxLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_SoftmaxLayer_propLogSoftMax_const(instance: *const c_void) -> bool;
		pub fn cv_dnn_SoftmaxLayer_propLogSoftMax_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_dnn_SoftmaxLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SoftmaxLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SoftmaxLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_SoftmaxLayerInt8_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SoftmaxLayerInt8_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_SoftmaxLayerInt8_propOutput_sc_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_SoftmaxLayerInt8_propOutput_sc_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_SoftmaxLayerInt8_propOutput_zp_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_SoftmaxLayerInt8_propOutput_zp_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_SoftmaxLayerInt8_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SoftmaxLayerInt8_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SoftmaxLayerInt8_to_SoftmaxLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SoftmaxLayerInt8_delete(instance: *mut c_void);
		pub fn cv_dnn_SoftplusLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SoftplusLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_SoftplusLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SoftplusLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SoftplusLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SoftplusLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_SoftsignLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SoftsignLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_SoftsignLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SoftsignLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SoftsignLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SoftsignLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_SpaceToDepthLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SpaceToDepthLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_SpaceToDepthLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SpaceToDepthLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SpaceToDepthLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_SplitLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SplitLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_SplitLayer_propOutputsCount_const(instance: *const c_void) -> i32;
		pub fn cv_dnn_SplitLayer_propOutputsCount_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dnn_SplitLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SplitLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SplitLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_SqrtLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SqrtLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_SqrtLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SqrtLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SqrtLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SqrtLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_SwishLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_SwishLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_SwishLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SwishLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SwishLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_SwishLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_TanHLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TanHLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_TanHLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TanHLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TanHLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TanHLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_TanLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TanLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_TanLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TanLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TanLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TanLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_TextDetectionModel_detect_const_const__InputArrayR_vectorLvectorLPointGGR_vectorLfloatGR(instance: *const c_void, frame: *const c_void, detections: *mut c_void, confidences: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_TextDetectionModel_detect_const_const__InputArrayR_vectorLvectorLPointGGR(instance: *const c_void, frame: *const c_void, detections: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_TextDetectionModel_detectTextRectangles_const_const__InputArrayR_vectorLRotatedRectGR_vectorLfloatGR(instance: *const c_void, frame: *const c_void, detections: *mut c_void, confidences: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_TextDetectionModel_detectTextRectangles_const_const__InputArrayR_vectorLRotatedRectGR(instance: *const c_void, frame: *const c_void, detections: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_TextDetectionModel_to_Model(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TextDetectionModel_delete(instance: *mut c_void);
		pub fn cv_dnn_TextDetectionModel_DB_TextDetectionModel_DB(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextDetectionModel_DB_TextDetectionModel_DB_const_NetR(network: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextDetectionModel_DB_TextDetectionModel_DB_const_stringR_const_stringR(model: *const c_char, config: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextDetectionModel_DB_TextDetectionModel_DB_const_stringR(model: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextDetectionModel_DB_setBinaryThreshold_float(instance: *mut c_void, binary_threshold: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextDetectionModel_DB_getBinaryThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_dnn_TextDetectionModel_DB_setPolygonThreshold_float(instance: *mut c_void, polygon_threshold: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextDetectionModel_DB_getPolygonThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_dnn_TextDetectionModel_DB_setUnclipRatio_double(instance: *mut c_void, unclip_ratio: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextDetectionModel_DB_getUnclipRatio_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_dnn_TextDetectionModel_DB_setMaxCandidates_int(instance: *mut c_void, max_candidates: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextDetectionModel_DB_getMaxCandidates_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_TextDetectionModel_DB_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_TextDetectionModel_DB_to_Model(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TextDetectionModel_DB_to_TextDetectionModel(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TextDetectionModel_DB_delete(instance: *mut c_void);
		pub fn cv_dnn_TextDetectionModel_EAST_TextDetectionModel_EAST(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextDetectionModel_EAST_TextDetectionModel_EAST_const_NetR(network: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextDetectionModel_EAST_TextDetectionModel_EAST_const_stringR_const_stringR(model: *const c_char, config: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextDetectionModel_EAST_TextDetectionModel_EAST_const_stringR(model: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextDetectionModel_EAST_setConfidenceThreshold_float(instance: *mut c_void, conf_threshold: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextDetectionModel_EAST_getConfidenceThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_dnn_TextDetectionModel_EAST_setNMSThreshold_float(instance: *mut c_void, nms_threshold: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextDetectionModel_EAST_getNMSThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_dnn_TextDetectionModel_EAST_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_TextDetectionModel_EAST_to_Model(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TextDetectionModel_EAST_to_TextDetectionModel(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TextDetectionModel_EAST_delete(instance: *mut c_void);
		pub fn cv_dnn_TextRecognitionModel_TextRecognitionModel(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextRecognitionModel_TextRecognitionModel_const_NetR(network: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextRecognitionModel_TextRecognitionModel_const_stringR_const_stringR(model: *const c_char, config: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextRecognitionModel_TextRecognitionModel_const_stringR(model: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextRecognitionModel_setDecodeType_const_stringR(instance: *mut c_void, decode_type: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextRecognitionModel_getDecodeType_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextRecognitionModel_setDecodeOptsCTCPrefixBeamSearch_int_int(instance: *mut c_void, beam_size: i32, voc_prune_size: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextRecognitionModel_setDecodeOptsCTCPrefixBeamSearch_int(instance: *mut c_void, beam_size: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextRecognitionModel_setVocabulary_const_vectorLstringGR(instance: *mut c_void, vocabulary: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextRecognitionModel_getVocabulary_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextRecognitionModel_recognize_const_const__InputArrayR(instance: *const c_void, frame: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TextRecognitionModel_recognize_const_const__InputArrayR_const__InputArrayR_vectorLstringGR(instance: *const c_void, frame: *const c_void, roi_rects: *const c_void, results: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_TextRecognitionModel_implicitClone_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_dnn_TextRecognitionModel_to_Model(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TextRecognitionModel_delete(instance: *mut c_void);
		pub fn cv_dnn_ThresholdedReluLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_ThresholdedReluLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_ThresholdedReluLayer_propAlpha_const(instance: *const c_void) -> f32;
		pub fn cv_dnn_ThresholdedReluLayer_propAlpha_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dnn_ThresholdedReluLayer_to_ActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ThresholdedReluLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ThresholdedReluLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_ThresholdedReluLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_TileLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TileLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_TileLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TileLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TileLayer_delete(instance: *mut c_void);
		pub fn cv_dnn_TopKLayer_create_const_LayerParamsR(params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_TopKLayer_defaultNew_const() -> *mut c_void;
		pub fn cv_dnn_TopKLayer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TopKLayer_to_Layer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn_TopKLayer_delete(instance: *mut c_void);
		pub fn cv_dnn__Range__Range_const_RangeR(r: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn__Range__Range_int_int(start_: i32, size_: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn__Range__Range_int(start_: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn__Range_to_Range(instance: *mut c_void) -> *mut c_void;
		pub fn cv_dnn__Range_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_AbsLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AbsLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AbsLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AbsLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_AbsLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AbsLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AbsLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AbsLayerG_new_const_AbsLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AccumLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AccumLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AccumLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AccumLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_AccumLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AccumLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AccumLayerG_new_const_AccumLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AcosLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AcosLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AcosLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AcosLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_AcosLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AcosLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AcosLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AcosLayerG_new_const_AcosLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AcoshLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AcoshLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AcoshLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AcoshLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_AcoshLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AcoshLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AcoshLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AcoshLayerG_new_const_AcoshLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ActivationLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ActivationLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ActivationLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ActivationLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ActivationLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ActivationLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ActivationLayerG_new_const_ActivationLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ActivationLayerInt8G_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ActivationLayerInt8G_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ActivationLayerInt8G_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ActivationLayerInt8G_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ActivationLayerInt8G_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ActivationLayerInt8G_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ActivationLayerInt8G_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ActivationLayerInt8G_new_const_ActivationLayerInt8(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ArgLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ArgLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ArgLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ArgLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ArgLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ArgLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ArgLayerG_new_const_ArgLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AsinLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AsinLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AsinLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AsinLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_AsinLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AsinLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AsinLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AsinLayerG_new_const_AsinLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AsinhLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AsinhLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AsinhLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AsinhLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_AsinhLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AsinhLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AsinhLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AsinhLayerG_new_const_AsinhLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AtanLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AtanLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AtanLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AtanLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_AtanLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AtanLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AtanLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AtanLayerG_new_const_AtanLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AtanhLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AtanhLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AtanhLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AtanhLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_AtanhLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AtanhLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AtanhLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AtanhLayerG_new_const_AtanhLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AttentionLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AttentionLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AttentionLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AttentionLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_AttentionLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AttentionLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_AttentionLayerG_new_const_AttentionLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BNLLLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BNLLLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BNLLLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BNLLLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_BNLLLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BNLLLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BNLLLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BNLLLayerG_new_const_BNLLLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BackendNodeG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BackendNodeG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BackendNodeG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BackendNodeG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_BackendNodeG_new_const_BackendNode(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BackendWrapperG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BackendWrapperG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BackendWrapperG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BackendWrapperG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_BaseConvolutionLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BaseConvolutionLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BaseConvolutionLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BaseConvolutionLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_BaseConvolutionLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BaseConvolutionLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BaseConvolutionLayerG_new_const_BaseConvolutionLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BatchNormLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BatchNormLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BatchNormLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BatchNormLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_BatchNormLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BatchNormLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BatchNormLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BatchNormLayerG_new_const_BatchNormLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BatchNormLayerInt8G_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BatchNormLayerInt8G_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BatchNormLayerInt8G_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BatchNormLayerInt8G_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_BatchNormLayerInt8G_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BatchNormLayerInt8G_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BatchNormLayerInt8G_to_PtrOfBatchNormLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BatchNormLayerInt8G_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BatchNormLayerInt8G_new_const_BatchNormLayerInt8(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BlankLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BlankLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BlankLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BlankLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_BlankLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BlankLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_BlankLayerG_new_const_BlankLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CeilLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CeilLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CeilLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CeilLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_CeilLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CeilLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CeilLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CeilLayerG_new_const_CeilLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CeluLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CeluLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CeluLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CeluLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_CeluLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CeluLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CeluLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CeluLayerG_new_const_CeluLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ChannelsPReLULayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ChannelsPReLULayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ChannelsPReLULayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ChannelsPReLULayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ChannelsPReLULayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ChannelsPReLULayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ChannelsPReLULayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ChannelsPReLULayerG_new_const_ChannelsPReLULayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CompareLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CompareLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CompareLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CompareLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_CompareLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CompareLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CompareLayerG_new_const_CompareLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConcatLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConcatLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConcatLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConcatLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ConcatLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConcatLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConcatLayerG_new_const_ConcatLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConstLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConstLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConstLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConstLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ConstLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConstLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConstLayerG_new_const_ConstLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConvolutionLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConvolutionLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConvolutionLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConvolutionLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ConvolutionLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConvolutionLayerG_to_PtrOfBaseConvolutionLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConvolutionLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConvolutionLayerG_new_const_ConvolutionLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConvolutionLayerInt8G_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConvolutionLayerInt8G_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConvolutionLayerInt8G_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConvolutionLayerInt8G_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ConvolutionLayerInt8G_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConvolutionLayerInt8G_to_PtrOfBaseConvolutionLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConvolutionLayerInt8G_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ConvolutionLayerInt8G_new_const_ConvolutionLayerInt8(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CorrelationLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CorrelationLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CorrelationLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CorrelationLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_CorrelationLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CorrelationLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CorrelationLayerG_new_const_CorrelationLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CosLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CosLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CosLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CosLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_CosLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CosLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CosLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CosLayerG_new_const_CosLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CoshLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CoshLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CoshLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CoshLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_CoshLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CoshLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CoshLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CoshLayerG_new_const_CoshLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CropAndResizeLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CropAndResizeLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CropAndResizeLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CropAndResizeLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_CropAndResizeLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CropAndResizeLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CropAndResizeLayerG_new_const_CropAndResizeLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CropLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CropLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CropLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CropLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_CropLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CropLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CropLayerG_new_const_CropLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CumSumLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CumSumLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CumSumLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CumSumLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_CumSumLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CumSumLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_CumSumLayerG_new_const_CumSumLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DataAugmentationLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DataAugmentationLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DataAugmentationLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DataAugmentationLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_DataAugmentationLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DataAugmentationLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DataAugmentationLayerG_new_const_DataAugmentationLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DeconvolutionLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DeconvolutionLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DeconvolutionLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DeconvolutionLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_DeconvolutionLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DeconvolutionLayerG_to_PtrOfBaseConvolutionLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DeconvolutionLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DeconvolutionLayerG_new_const_DeconvolutionLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DepthToSpaceLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DepthToSpaceLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DepthToSpaceLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DepthToSpaceLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_DepthToSpaceLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DepthToSpaceLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DepthToSpaceLayerG_new_const_DepthToSpaceLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DequantizeLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DequantizeLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DequantizeLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DequantizeLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_DequantizeLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DequantizeLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DequantizeLayerG_new_const_DequantizeLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DetectionOutputLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DetectionOutputLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DetectionOutputLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DetectionOutputLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_DetectionOutputLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DetectionOutputLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_DetectionOutputLayerG_new_const_DetectionOutputLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ELULayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ELULayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ELULayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ELULayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ELULayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ELULayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ELULayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ELULayerG_new_const_ELULayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EinsumLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EinsumLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EinsumLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EinsumLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_EinsumLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EinsumLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EinsumLayerG_new_const_EinsumLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EltwiseLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EltwiseLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EltwiseLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EltwiseLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_EltwiseLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EltwiseLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EltwiseLayerG_new_const_EltwiseLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EltwiseLayerInt8G_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EltwiseLayerInt8G_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EltwiseLayerInt8G_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EltwiseLayerInt8G_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_EltwiseLayerInt8G_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EltwiseLayerInt8G_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_EltwiseLayerInt8G_new_const_EltwiseLayerInt8(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ErfLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ErfLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ErfLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ErfLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ErfLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ErfLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ErfLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ErfLayerG_new_const_ErfLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ExpLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ExpLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ExpLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ExpLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ExpLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ExpLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ExpLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ExpLayerG_new_const_ExpLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ExpandLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ExpandLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ExpandLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ExpandLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ExpandLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ExpandLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ExpandLayerG_new_const_ExpandLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FlattenLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FlattenLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FlattenLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FlattenLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_FlattenLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FlattenLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FlattenLayerG_new_const_FlattenLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FloorLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FloorLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FloorLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FloorLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_FloorLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FloorLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FloorLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FloorLayerG_new_const_FloorLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FlowWarpLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FlowWarpLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FlowWarpLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FlowWarpLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_FlowWarpLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FlowWarpLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_FlowWarpLayerG_new_const_FlowWarpLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GRULayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GRULayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GRULayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GRULayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_GRULayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GRULayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GRULayerG_new_const_GRULayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GatherElementsLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GatherElementsLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GatherElementsLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GatherElementsLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_GatherElementsLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GatherElementsLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GatherElementsLayerG_new_const_GatherElementsLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GatherLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GatherLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GatherLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GatherLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_GatherLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GatherLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GatherLayerG_new_const_GatherLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GeluApproximationLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GeluApproximationLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GeluApproximationLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GeluApproximationLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_GeluApproximationLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GeluApproximationLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GeluApproximationLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GeluApproximationLayerG_new_const_GeluApproximationLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GeluLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GeluLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GeluLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GeluLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_GeluLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GeluLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GeluLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GeluLayerG_new_const_GeluLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GemmLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GemmLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GemmLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GemmLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_GemmLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GemmLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GemmLayerG_new_const_GemmLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GroupNormLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GroupNormLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GroupNormLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GroupNormLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_GroupNormLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GroupNormLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_GroupNormLayerG_new_const_GroupNormLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_HardSigmoidLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_HardSigmoidLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_HardSigmoidLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_HardSigmoidLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_HardSigmoidLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_HardSigmoidLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_HardSigmoidLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_HardSigmoidLayerG_new_const_HardSigmoidLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_HardSwishLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_HardSwishLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_HardSwishLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_HardSwishLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_HardSwishLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_HardSwishLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_HardSwishLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_HardSwishLayerG_new_const_HardSwishLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InnerProductLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InnerProductLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InnerProductLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InnerProductLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_InnerProductLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InnerProductLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InnerProductLayerG_new_const_InnerProductLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InnerProductLayerInt8G_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InnerProductLayerInt8G_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InnerProductLayerInt8G_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InnerProductLayerInt8G_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_InnerProductLayerInt8G_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InnerProductLayerInt8G_to_PtrOfInnerProductLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InnerProductLayerInt8G_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InnerProductLayerInt8G_new_const_InnerProductLayerInt8(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InstanceNormLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InstanceNormLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InstanceNormLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InstanceNormLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_InstanceNormLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InstanceNormLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InstanceNormLayerG_new_const_InstanceNormLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InterpLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InterpLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InterpLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InterpLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_InterpLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InterpLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_InterpLayerG_new_const_InterpLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LRNLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LRNLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LRNLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LRNLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_LRNLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LRNLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LRNLayerG_new_const_LRNLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LSTMLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LSTMLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LSTMLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LSTMLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_LSTMLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LSTMLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_LayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LayerG_new_const_Layer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LayerNormLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LayerNormLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LayerNormLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LayerNormLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_LayerNormLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LayerNormLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LayerNormLayerG_new_const_LayerNormLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LogLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LogLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LogLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LogLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_LogLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LogLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LogLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_LogLayerG_new_const_LogLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MVNLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MVNLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MVNLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MVNLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_MVNLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MVNLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MVNLayerG_new_const_MVNLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MatMulLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MatMulLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MatMulLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MatMulLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_MatMulLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MatMulLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MatMulLayerG_new_const_MatMulLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MaxUnpoolLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MaxUnpoolLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MaxUnpoolLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MaxUnpoolLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_MaxUnpoolLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MaxUnpoolLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MaxUnpoolLayerG_new_const_MaxUnpoolLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MishLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MishLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MishLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MishLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_MishLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MishLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MishLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_MishLayerG_new_const_MishLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NaryEltwiseLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NaryEltwiseLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NaryEltwiseLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NaryEltwiseLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_NaryEltwiseLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NaryEltwiseLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NaryEltwiseLayerG_new_const_NaryEltwiseLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NormalizeBBoxLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NormalizeBBoxLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NormalizeBBoxLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NormalizeBBoxLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_NormalizeBBoxLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NormalizeBBoxLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NormalizeBBoxLayerG_new_const_NormalizeBBoxLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NotLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NotLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NotLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NotLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_NotLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NotLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NotLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_NotLayerG_new_const_NotLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PaddingLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PaddingLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PaddingLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PaddingLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_PaddingLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PaddingLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PaddingLayerG_new_const_PaddingLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PermuteLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PermuteLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PermuteLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PermuteLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_PermuteLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PermuteLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PermuteLayerG_new_const_PermuteLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PoolingLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PoolingLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PoolingLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PoolingLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_PoolingLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PoolingLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PoolingLayerG_new_const_PoolingLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PoolingLayerInt8G_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PoolingLayerInt8G_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PoolingLayerInt8G_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PoolingLayerInt8G_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_PoolingLayerInt8G_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PoolingLayerInt8G_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PoolingLayerInt8G_to_PtrOfPoolingLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PoolingLayerInt8G_new_const_PoolingLayerInt8(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PowerLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PowerLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PowerLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PowerLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_PowerLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PowerLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PowerLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PowerLayerG_new_const_PowerLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PriorBoxLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PriorBoxLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PriorBoxLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PriorBoxLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_PriorBoxLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PriorBoxLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_PriorBoxLayerG_new_const_PriorBoxLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ProposalLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ProposalLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ProposalLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ProposalLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ProposalLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ProposalLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ProposalLayerG_new_const_ProposalLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_QuantizeLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_QuantizeLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_QuantizeLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_QuantizeLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_QuantizeLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_QuantizeLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_QuantizeLayerG_new_const_QuantizeLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RNNLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RNNLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RNNLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RNNLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_RNNLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RNNLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReLU6LayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReLU6LayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReLU6LayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReLU6LayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ReLU6LayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReLU6LayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReLU6LayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReLU6LayerG_new_const_ReLU6Layer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReLULayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReLULayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReLULayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReLULayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ReLULayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReLULayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReLULayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReLULayerG_new_const_ReLULayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReciprocalLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReciprocalLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReciprocalLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReciprocalLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ReciprocalLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReciprocalLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReciprocalLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReciprocalLayerG_new_const_ReciprocalLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReduceLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReduceLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReduceLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReduceLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ReduceLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReduceLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReduceLayerG_new_const_ReduceLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RegionLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RegionLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RegionLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RegionLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_RegionLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RegionLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RegionLayerG_new_const_RegionLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReorgLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReorgLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReorgLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReorgLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ReorgLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReorgLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReorgLayerG_new_const_ReorgLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RequantizeLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RequantizeLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RequantizeLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RequantizeLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_RequantizeLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RequantizeLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RequantizeLayerG_new_const_RequantizeLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReshapeLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReshapeLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReshapeLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReshapeLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ReshapeLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReshapeLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ReshapeLayerG_new_const_ReshapeLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ResizeLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ResizeLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ResizeLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ResizeLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ResizeLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ResizeLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ResizeLayerG_new_const_ResizeLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RoundLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RoundLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RoundLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RoundLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_RoundLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RoundLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RoundLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_RoundLayerG_new_const_RoundLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScaleLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScaleLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScaleLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScaleLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ScaleLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScaleLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScaleLayerG_new_const_ScaleLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScaleLayerInt8G_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScaleLayerInt8G_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScaleLayerInt8G_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScaleLayerInt8G_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ScaleLayerInt8G_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScaleLayerInt8G_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScaleLayerInt8G_to_PtrOfScaleLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScaleLayerInt8G_new_const_ScaleLayerInt8(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScatterLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScatterLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScatterLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScatterLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ScatterLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScatterLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScatterLayerG_new_const_ScatterLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScatterNDLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScatterNDLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScatterNDLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScatterNDLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ScatterNDLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScatterNDLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ScatterNDLayerG_new_const_ScatterNDLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SeluLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SeluLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SeluLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SeluLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_SeluLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SeluLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SeluLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SeluLayerG_new_const_SeluLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShiftLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShiftLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShiftLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShiftLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ShiftLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShiftLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShiftLayerG_new_const_ShiftLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShiftLayerInt8G_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShiftLayerInt8G_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShiftLayerInt8G_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShiftLayerInt8G_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ShiftLayerInt8G_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShiftLayerInt8G_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShiftLayerInt8G_new_const_ShiftLayerInt8(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShrinkLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShrinkLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShrinkLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShrinkLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ShrinkLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShrinkLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShrinkLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShrinkLayerG_new_const_ShrinkLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShuffleChannelLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShuffleChannelLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShuffleChannelLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShuffleChannelLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ShuffleChannelLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShuffleChannelLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ShuffleChannelLayerG_new_const_ShuffleChannelLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SigmoidLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SigmoidLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SigmoidLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SigmoidLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_SigmoidLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SigmoidLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SigmoidLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SigmoidLayerG_new_const_SigmoidLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SignLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SignLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SignLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SignLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_SignLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SignLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SignLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SignLayerG_new_const_SignLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SinLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SinLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SinLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SinLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_SinLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SinLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SinLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SinLayerG_new_const_SinLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SinhLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SinhLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SinhLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SinhLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_SinhLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SinhLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SinhLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SinhLayerG_new_const_SinhLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SliceLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SliceLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SliceLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SliceLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_SliceLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SliceLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SliceLayerG_new_const_SliceLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftmaxLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftmaxLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftmaxLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftmaxLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_SoftmaxLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftmaxLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftmaxLayerG_new_const_SoftmaxLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftmaxLayerInt8G_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftmaxLayerInt8G_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftmaxLayerInt8G_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftmaxLayerInt8G_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_SoftmaxLayerInt8G_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftmaxLayerInt8G_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftmaxLayerInt8G_to_PtrOfSoftmaxLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftmaxLayerInt8G_new_const_SoftmaxLayerInt8(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftplusLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftplusLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftplusLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftplusLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_SoftplusLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftplusLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftplusLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftplusLayerG_new_const_SoftplusLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftsignLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftsignLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftsignLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftsignLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_SoftsignLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftsignLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftsignLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SoftsignLayerG_new_const_SoftsignLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SpaceToDepthLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SpaceToDepthLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SpaceToDepthLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SpaceToDepthLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_SpaceToDepthLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SpaceToDepthLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SpaceToDepthLayerG_new_const_SpaceToDepthLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SplitLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SplitLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SplitLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SplitLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_SplitLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SplitLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SplitLayerG_new_const_SplitLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SqrtLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SqrtLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SqrtLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SqrtLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_SqrtLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SqrtLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SqrtLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SqrtLayerG_new_const_SqrtLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SwishLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SwishLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SwishLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SwishLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_SwishLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SwishLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SwishLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_SwishLayerG_new_const_SwishLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TanHLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TanHLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TanHLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TanHLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_TanHLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TanHLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TanHLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TanHLayerG_new_const_TanHLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TanLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TanLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TanLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TanLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_TanLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TanLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TanLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TanLayerG_new_const_TanLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ThresholdedReluLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ThresholdedReluLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ThresholdedReluLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ThresholdedReluLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_ThresholdedReluLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ThresholdedReluLayerG_to_PtrOfActivationLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ThresholdedReluLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_ThresholdedReluLayerG_new_const_ThresholdedReluLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TileLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TileLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TileLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TileLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_TileLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TileLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TileLayerG_new_const_TileLayer(val: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TopKLayerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TopKLayerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TopKLayerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TopKLayerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_TopKLayerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TopKLayerG_to_PtrOfLayer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_TopKLayerG_new_const_TopKLayer(val: *mut c_void) -> *mut c_void;
		pub fn std_pairLcv_dnn_Backend__cv_dnn_TargetG_new_const_Backend_Target(arg: crate::dnn::Backend, arg_1: crate::dnn::Target) -> *mut c_void;
		pub fn std_pairLcv_dnn_Backend__cv_dnn_TargetG_get_0_const(instance: *const c_void, ocvrs_return: *mut crate::dnn::Backend);
		pub fn std_pairLcv_dnn_Backend__cv_dnn_TargetG_get_1_const(instance: *const c_void, ocvrs_return: *mut crate::dnn::Target);
		pub fn std_pairLcv_dnn_Backend__cv_dnn_TargetG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_dnn_MatShapeG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_dnn_MatShapeG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_dnn_MatShapeG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_dnn_MatShapeG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_dnn_MatShapeG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_dnn_MatShapeG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_dnn_MatShapeG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_dnn_MatShapeG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_dnn_MatShapeG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_dnn_MatShapeG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_dnn_MatShapeG_push_const_MatShape(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLcv_dnn_MatShapeG_insert_size_t_const_MatShape(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_dnn_MatShapeG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLcv_dnn_MatShapeG_set_size_t_const_MatShape(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_dnn_MatShapeG_inputArray_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_dnn_MatShapeG_outputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_dnn_MatShapeG_inputOutputArray(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendNodeGG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_PtrLcv_dnn_BackendNodeGG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendNodeGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_PtrLcv_dnn_BackendNodeGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_PtrLcv_dnn_BackendNodeGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_PtrLcv_dnn_BackendNodeGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendNodeGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendNodeGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendNodeGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendNodeGG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendNodeGG_push_const_PtrLBackendNodeG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendNodeGG_insert_size_t_const_PtrLBackendNodeG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendNodeGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendNodeGG_set_size_t_const_PtrLBackendNodeG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_push_const_PtrLBackendWrapperG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_insert_size_t_const_PtrLBackendWrapperG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_BackendWrapperGG_set_size_t_const_PtrLBackendWrapperG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_LayerGG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_PtrLcv_dnn_LayerGG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_LayerGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_PtrLcv_dnn_LayerGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_PtrLcv_dnn_LayerGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_PtrLcv_dnn_LayerGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_LayerGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_PtrLcv_dnn_LayerGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_PtrLcv_dnn_LayerGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_PtrLcv_dnn_LayerGG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_LayerGG_push_const_PtrLLayerG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_LayerGG_insert_size_t_const_PtrLLayerG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_LayerGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLcv_PtrLcv_dnn_LayerGG_set_size_t_const_PtrLLayerG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_dnn_TargetG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_dnn_TargetG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_dnn_TargetG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_dnn_TargetG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_dnn_TargetG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_dnn_TargetG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_dnn_TargetG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_dnn_TargetG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_dnn_TargetG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_dnn_TargetG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_dnn_TargetG_push_const_Target(instance: *mut c_void, val: crate::dnn::Target);
		pub fn std_vectorLcv_dnn_TargetG_insert_size_t_const_Target(instance: *mut c_void, index: size_t, val: crate::dnn::Target);
		pub fn std_vectorLcv_dnn_TargetG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut crate::dnn::Target);
		pub fn std_vectorLcv_dnn_TargetG_set_size_t_const_Target(instance: *mut c_void, index: size_t, val: crate::dnn::Target);
		pub fn std_vectorLcv_dnn_TargetG_clone_const(instance: *const c_void) -> *mut c_void;
		pub fn std_vectorLcv_dnn_TargetG_data_const(instance: *const c_void) -> *const crate::dnn::Target;
		pub fn std_vectorLcv_dnn_TargetG_dataMut(instance: *mut c_void) -> *mut crate::dnn::Target;
		pub fn cv_fromSlice_const_const_TargetX_size_t(data: *const crate::dnn::Target, len: size_t) -> *mut c_void;
		pub fn std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_push_const_pairLcv_dnn_Backend__cv_dnn_TargetG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_insert_size_t_const_pairLcv_dnn_Backend__cv_dnn_TargetG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_pairLcv_dnn_Backend__cv_dnn_TargetGG_set_size_t_const_pairLcv_dnn_Backend__cv_dnn_TargetG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_dnn_MatShapeGG_new_const() -> *mut c_void;
		pub fn std_vectorLstd_vectorLcv_dnn_MatShapeGG_delete(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_dnn_MatShapeGG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_dnn_MatShapeGG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLstd_vectorLcv_dnn_MatShapeGG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLstd_vectorLcv_dnn_MatShapeGG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_dnn_MatShapeGG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLstd_vectorLcv_dnn_MatShapeGG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLstd_vectorLcv_dnn_MatShapeGG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLstd_vectorLcv_dnn_MatShapeGG_clear(instance: *mut c_void);
		pub fn std_vectorLstd_vectorLcv_dnn_MatShapeGG_push_const_vectorLMatShapeG(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_dnn_MatShapeGG_insert_size_t_const_vectorLMatShapeG(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLstd_vectorLcv_dnn_MatShapeGG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLstd_vectorLcv_dnn_MatShapeGG_set_size_t_const_vectorLMatShapeG(instance: *mut c_void, index: size_t, val: *const c_void);
	}
}
pub use dnn_sys::*;

mod dnn_superres_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_dnn_superres_DnnSuperResImpl_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_superres_DnnSuperResImpl_DnnSuperResImpl(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_superres_DnnSuperResImpl_DnnSuperResImpl_const_StringR_int(algo: *const c_char, scale: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_superres_DnnSuperResImpl_readModel_const_StringR(instance: *mut c_void, path: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_superres_DnnSuperResImpl_readModel_const_StringR_const_StringR(instance: *mut c_void, weights: *const c_char, definition: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_superres_DnnSuperResImpl_setModel_const_StringR_int(instance: *mut c_void, algo: *const c_char, scale: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_superres_DnnSuperResImpl_setPreferableBackend_int(instance: *mut c_void, backend_id: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_superres_DnnSuperResImpl_setPreferableTarget_int(instance: *mut c_void, target_id: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_superres_DnnSuperResImpl_upsample_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, img: *const c_void, result: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_superres_DnnSuperResImpl_upsampleMultioutput_const__InputArrayR_vectorLMatGR_const_vectorLintGR_const_vectorLStringGR(instance: *mut c_void, img: *const c_void, imgs_new: *mut c_void, scale_factors: *const c_void, node_names: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dnn_superres_DnnSuperResImpl_getScale(instance: *mut c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_dnn_superres_DnnSuperResImpl_getAlgorithm(instance: *mut c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dnn_superres_DnnSuperResImpl_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_superres_DnnSuperResImplG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_superres_DnnSuperResImplG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dnn_superres_DnnSuperResImplG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dnn_superres_DnnSuperResImplG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dnn_superres_DnnSuperResImplG_new_const_DnnSuperResImpl(val: *mut c_void) -> *mut c_void;
	}
}
pub use dnn_superres_sys::*;

mod dpm_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_dpm_DPMDetector_isEmpty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_dpm_DPMDetector_detect_MatR_vectorLObjectDetectionGR(instance: *mut c_void, image: *mut c_void, objects: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_dpm_DPMDetector_getClassNames_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dpm_DPMDetector_getClassCount_const(instance: *const c_void, ocvrs_return: *mut Result<size_t>);
		pub fn cv_dpm_DPMDetector_create_const_vectorLstringGR_const_vectorLstringGR(filenames: *const c_void, class_names: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dpm_DPMDetector_create_const_vectorLstringGR(filenames: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dpm_DPMDetector_delete(instance: *mut c_void);
		pub fn cv_dpm_DPMDetector_ObjectDetection_ObjectDetection(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dpm_DPMDetector_ObjectDetection_ObjectDetection_const_RectR_float_int(rect: *const core::Rect, score: f32, class_id: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dpm_DPMDetector_ObjectDetection_ObjectDetection_const_RectR_float(rect: *const core::Rect, score: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_dpm_DPMDetector_ObjectDetection_propRect_const(instance: *const c_void, ocvrs_return: *mut core::Rect);
		pub fn cv_dpm_DPMDetector_ObjectDetection_propRect_const_Rect(instance: *mut c_void, val: *const core::Rect);
		pub fn cv_dpm_DPMDetector_ObjectDetection_propScore_const(instance: *const c_void) -> f32;
		pub fn cv_dpm_DPMDetector_ObjectDetection_propScore_const_float(instance: *mut c_void, val: f32);
		pub fn cv_dpm_DPMDetector_ObjectDetection_propClassID_const(instance: *const c_void) -> i32;
		pub fn cv_dpm_DPMDetector_ObjectDetection_propClassID_const_int(instance: *mut c_void, val: i32);
		pub fn cv_dpm_DPMDetector_ObjectDetection_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_dpm_DPMDetectorG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dpm_DPMDetectorG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_dpm_DPMDetectorG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_dpm_DPMDetectorG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_push_const_ObjectDetection(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_insert_size_t_const_ObjectDetection(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLcv_dpm_DPMDetector_ObjectDetectionG_set_size_t_const_ObjectDetection(instance: *mut c_void, index: size_t, val: *const c_void);
	}
}
pub use dpm_sys::*;

mod face_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_face_createFacemarkAAM(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_createFacemarkKazemi(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_createFacemarkLBF(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_drawFacemarks_const__InputOutputArrayR_const__InputArrayR(image: *const c_void, points: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_drawFacemarks_const__InputOutputArrayR_const__InputArrayR_Scalar(image: *const c_void, points: *const c_void, color: *const core::Scalar, ocvrs_return: *mut Result<()>);
		pub fn cv_face_getFacesHAAR_const__InputArrayR_const__OutputArrayR_const_StringR(image: *const c_void, faces: *const c_void, face_cascade_name: *const c_char, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_getFaces_const__InputArrayR_const__OutputArrayR_CParamsX(image: *const c_void, faces: *const c_void, params: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_loadDatasetList_String_String_vectorLStringGR_vectorLStringGR(image_list: *const c_char, annotation_list: *const c_char, images: *mut c_void, annotations: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_loadFacePoints_String_const__OutputArrayR(filename: *const c_char, points: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_loadFacePoints_String_const__OutputArrayR_float(filename: *const c_char, points: *const c_void, offset: f32, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_loadTrainingData_String_String_vectorLStringGR_const__OutputArrayR(image_list: *const c_char, ground_truth: *const c_char, images: *mut c_void, face_points: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_loadTrainingData_String_String_vectorLStringGR_const__OutputArrayR_float(image_list: *const c_char, ground_truth: *const c_char, images: *mut c_void, face_points: *const c_void, offset: f32, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_loadTrainingData_String_vectorLStringGR_const__OutputArrayR(filename: *const c_char, images: *mut c_void, face_points: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_loadTrainingData_String_vectorLStringGR_const__OutputArrayR_char_float(filename: *const c_char, images: *mut c_void, face_points: *const c_void, delim: c_char, offset: f32, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_loadTrainingData_vectorLStringG_vectorLvectorLPoint2fGGR_vectorLStringGR(filename: *mut c_void, trainlandmarks: *mut c_void, trainimages: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_BIF_getNumBands_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_face_BIF_getNumRotations_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_face_BIF_compute_const_const__InputArrayR_const__OutputArrayR(instance: *const c_void, image: *const c_void, features: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_BIF_create_int_int(num_bands: i32, num_rotations: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_BIF_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_BIF_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_BIF_delete(instance: *mut c_void);
		pub fn cv_face_BasicFaceRecognizer_getNumComponents_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_face_BasicFaceRecognizer_setNumComponents_int(instance: *mut c_void, val: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_face_BasicFaceRecognizer_getThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_face_BasicFaceRecognizer_setThreshold_double(instance: *mut c_void, val: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_face_BasicFaceRecognizer_getProjections_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_BasicFaceRecognizer_getLabels_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_BasicFaceRecognizer_getEigenValues_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_BasicFaceRecognizer_getEigenVectors_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_BasicFaceRecognizer_getMean_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_BasicFaceRecognizer_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_BasicFaceRecognizer_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_BasicFaceRecognizer_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_BasicFaceRecognizer_to_EigenFaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_BasicFaceRecognizer_to_FisherFaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_BasicFaceRecognizer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_BasicFaceRecognizer_to_FaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_BasicFaceRecognizer_delete(instance: *mut c_void);
		pub fn cv_face_CParams_CParams_String_double_int_Size_Size(cascade_model: *const c_char, sf: f64, min_n: i32, min_sz: *const core::Size, max_sz: *const core::Size, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_CParams_CParams_String(cascade_model: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_CParams_propCascade_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_CParams_propCascade_const_String(instance: *mut c_void, val: *const c_char);
		pub fn cv_face_CParams_propScaleFactor_const(instance: *const c_void) -> f64;
		pub fn cv_face_CParams_propScaleFactor_const_double(instance: *mut c_void, val: f64);
		pub fn cv_face_CParams_propMinNeighbors_const(instance: *const c_void) -> i32;
		pub fn cv_face_CParams_propMinNeighbors_const_int(instance: *mut c_void, val: i32);
		pub fn cv_face_CParams_propMinSize_const(instance: *const c_void, ocvrs_return: *mut core::Size);
		pub fn cv_face_CParams_propMinSize_const_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_face_CParams_propMaxSize_const(instance: *const c_void, ocvrs_return: *mut core::Size);
		pub fn cv_face_CParams_propMaxSize_const_Size(instance: *mut c_void, val: *const core::Size);
		pub fn cv_face_CParams_propFace_cascade_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_CParams_propFace_cascade_const_CascadeClassifier(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_CParams_delete(instance: *mut c_void);
		pub fn cv_face_EigenFaceRecognizer_create_int_double(num_components: i32, threshold: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_EigenFaceRecognizer_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_EigenFaceRecognizer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_EigenFaceRecognizer_to_BasicFaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_EigenFaceRecognizer_to_FaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_EigenFaceRecognizer_delete(instance: *mut c_void);
		pub fn cv_face_FaceRecognizer_train_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, labels: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FaceRecognizer_update_const__InputArrayR_const__InputArrayR(instance: *mut c_void, src: *const c_void, labels: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FaceRecognizer_predict_const_const__InputArrayR(instance: *const c_void, src: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_face_FaceRecognizer_predict_const_const__InputArrayR_intR_doubleR(instance: *const c_void, src: *const c_void, label: *mut i32, confidence: *mut f64, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FaceRecognizer_predict_const_const__InputArrayR_PtrLPredictCollectorG(instance: *const c_void, src: *const c_void, collector: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FaceRecognizer_write_const_const_StringR(instance: *const c_void, filename: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FaceRecognizer_read_const_StringR(instance: *mut c_void, filename: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FaceRecognizer_write_const_FileStorageR(instance: *const c_void, fs: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FaceRecognizer_read_const_FileNodeR(instance: *mut c_void, fn_: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FaceRecognizer_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_FaceRecognizer_setLabelInfo_int_const_StringR(instance: *mut c_void, label: i32, str_info: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FaceRecognizer_getLabelInfo_const_int(instance: *const c_void, label: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_FaceRecognizer_getLabelsByString_const_const_StringR(instance: *const c_void, str: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_FaceRecognizer_getThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_face_FaceRecognizer_setThreshold_double(instance: *mut c_void, val: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FaceRecognizer_to_BasicFaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FaceRecognizer_to_EigenFaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FaceRecognizer_to_FisherFaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FaceRecognizer_to_LBPHFaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FaceRecognizer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FaceRecognizer_delete(instance: *mut c_void);
		pub fn cv_face_Facemark_loadModel_String(instance: *mut c_void, model: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_face_Facemark_fit_const__InputArrayR_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, faces: *const c_void, landmarks: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_Facemark_to_FacemarkAAM(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_Facemark_to_FacemarkKazemi(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_Facemark_to_FacemarkLBF(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_Facemark_to_FacemarkTrain(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_Facemark_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_Facemark_delete(instance: *mut c_void);
		pub fn cv_face_FacemarkAAM_fitConfig_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const_vectorLConfigGR(instance: *mut c_void, image: *const c_void, roi: *const c_void, _landmarks: *const c_void, runtime_params: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_FacemarkAAM_create_const_ParamsR(parameters: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_FacemarkAAM_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_FacemarkAAM_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_to_Facemark(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_to_FacemarkTrain(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_delete(instance: *mut c_void);
		pub fn cv_face_FacemarkAAM_Config_Config_Mat_Point2f_float_int(rot: *mut c_void, trans: *const core::Point2f, scaling: f32, scale_id: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_FacemarkAAM_Config_Config(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_FacemarkAAM_Config_propR_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Config_propR_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Config_propT_const(instance: *const c_void, ocvrs_return: *mut core::Point2f);
		pub fn cv_face_FacemarkAAM_Config_propT_const_Point2f(instance: *mut c_void, val: *const core::Point2f);
		pub fn cv_face_FacemarkAAM_Config_propScale_const(instance: *const c_void) -> f32;
		pub fn cv_face_FacemarkAAM_Config_propScale_const_float(instance: *mut c_void, val: f32);
		pub fn cv_face_FacemarkAAM_Config_propModel_scale_idx_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Config_propModel_scale_idx_const_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Config_delete(instance: *mut c_void);
		pub fn cv_face_FacemarkAAM_Data_defaultNew_const() -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Data_propS0_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Data_propS0_const_vectorLPoint2fG(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Data_delete(instance: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_defaultNew_const() -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_propScales_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_propScales_const_vectorLfloatG(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Model_propTriangles_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_propTriangles_const_vectorLVec3iG(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Model_propTextures_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_propTextures_const_vectorLTextureG(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Model_propS0_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_propS0_const_vectorLPoint2fG(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Model_propS_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_propS_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Model_propQ_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_propQ_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Model_delete(instance: *mut c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_defaultNew_const() -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_propMax_m_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Model_Texture_propMax_m_const_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Model_Texture_propResolution_const(instance: *const c_void, ocvrs_return: *mut core::Rect);
		pub fn cv_face_FacemarkAAM_Model_Texture_propResolution_const_Rect(instance: *mut c_void, val: *const core::Rect);
		pub fn cv_face_FacemarkAAM_Model_Texture_propA_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_propA_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_propA0_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_propA0_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_propAA_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_propAA_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_propAA0_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_propAA0_const_Mat(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_propTextureIdx_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_propTextureIdx_const_vectorLvectorLPointGG(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_propBase_shape_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_propBase_shape_const_vectorLPoint2fG(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_propInd1_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_propInd1_const_vectorLintG(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_propInd2_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Model_Texture_propInd2_const_vectorLintG(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Model_Texture_delete(instance: *mut c_void);
		pub fn cv_face_FacemarkAAM_Params_Params(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_FacemarkAAM_Params_read_const_FileNodeR(instance: *mut c_void, unnamed: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FacemarkAAM_Params_write_const_FileStorageR(instance: *const c_void, unnamed: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FacemarkAAM_Params_propModel_filename_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Params_propModel_filename_const_string(instance: *mut c_void, val: *const c_char);
		pub fn cv_face_FacemarkAAM_Params_propM_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Params_propM_const_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Params_propN_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Params_propN_const_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Params_propN_iter_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Params_propN_iter_const_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Params_propVerbose_const(instance: *const c_void) -> bool;
		pub fn cv_face_FacemarkAAM_Params_propVerbose_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_face_FacemarkAAM_Params_propSave_model_const(instance: *const c_void) -> bool;
		pub fn cv_face_FacemarkAAM_Params_propSave_model_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_face_FacemarkAAM_Params_propMax_m_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Params_propMax_m_const_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Params_propMax_n_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Params_propMax_n_const_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Params_propTexture_max_m_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkAAM_Params_propTexture_max_m_const_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkAAM_Params_propScales_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkAAM_Params_propScales_const_vectorLfloatG(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkAAM_Params_delete(instance: *mut c_void);
		pub fn cv_face_FacemarkKazemi_create_const_ParamsR(parameters: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_FacemarkKazemi_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_FacemarkKazemi_training_vectorLMatGR_vectorLvectorLPoint2fGGR_string_Size_string(instance: *mut c_void, images: *mut c_void, landmarks: *mut c_void, configfile: *const c_char, scale: *const core::Size, model_filename: *const c_char, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_FacemarkKazemi_training_vectorLMatGR_vectorLvectorLPoint2fGGR_string_Size(instance: *mut c_void, images: *mut c_void, landmarks: *mut c_void, configfile: *const c_char, scale: *const core::Size, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_FacemarkKazemi_setFaceDetector_bool__X__const_cv__InputArrayR__const_cv__OutputArrayR__voidX__voidX(instance: *mut c_void, f: Option<unsafe extern "C" fn(*const c_void, *const c_void, *mut c_void) -> bool>, user_data: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_FacemarkKazemi_getFaces_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, faces: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_FacemarkKazemi_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FacemarkKazemi_to_Facemark(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FacemarkKazemi_delete(instance: *mut c_void);
		pub fn cv_face_FacemarkKazemi_Params_Params(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_FacemarkKazemi_Params_propCascade_depth_const(instance: *const c_void) -> u32;
		pub fn cv_face_FacemarkKazemi_Params_propCascade_depth_const_unsigned_long(instance: *mut c_void, val: u32);
		pub fn cv_face_FacemarkKazemi_Params_propTree_depth_const(instance: *const c_void) -> u32;
		pub fn cv_face_FacemarkKazemi_Params_propTree_depth_const_unsigned_long(instance: *mut c_void, val: u32);
		pub fn cv_face_FacemarkKazemi_Params_propNum_trees_per_cascade_level_const(instance: *const c_void) -> u32;
		pub fn cv_face_FacemarkKazemi_Params_propNum_trees_per_cascade_level_const_unsigned_long(instance: *mut c_void, val: u32);
		pub fn cv_face_FacemarkKazemi_Params_propLearning_rate_const(instance: *const c_void) -> f32;
		pub fn cv_face_FacemarkKazemi_Params_propLearning_rate_const_float(instance: *mut c_void, val: f32);
		pub fn cv_face_FacemarkKazemi_Params_propOversampling_amount_const(instance: *const c_void) -> u32;
		pub fn cv_face_FacemarkKazemi_Params_propOversampling_amount_const_unsigned_long(instance: *mut c_void, val: u32);
		pub fn cv_face_FacemarkKazemi_Params_propNum_test_coordinates_const(instance: *const c_void) -> u32;
		pub fn cv_face_FacemarkKazemi_Params_propNum_test_coordinates_const_unsigned_long(instance: *mut c_void, val: u32);
		pub fn cv_face_FacemarkKazemi_Params_propLambda_const(instance: *const c_void) -> f32;
		pub fn cv_face_FacemarkKazemi_Params_propLambda_const_float(instance: *mut c_void, val: f32);
		pub fn cv_face_FacemarkKazemi_Params_propNum_test_splits_const(instance: *const c_void) -> u32;
		pub fn cv_face_FacemarkKazemi_Params_propNum_test_splits_const_unsigned_long(instance: *mut c_void, val: u32);
		pub fn cv_face_FacemarkKazemi_Params_propConfigfile_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkKazemi_Params_propConfigfile_const_String(instance: *mut c_void, val: *const c_char);
		pub fn cv_face_FacemarkKazemi_Params_delete(instance: *mut c_void);
		pub fn cv_face_FacemarkLBF_create_const_ParamsR(parameters: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_FacemarkLBF_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_FacemarkLBF_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FacemarkLBF_to_Facemark(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FacemarkLBF_to_FacemarkTrain(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FacemarkLBF_delete(instance: *mut c_void);
		pub fn cv_face_FacemarkLBF_Params_Params(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_FacemarkLBF_Params_read_const_FileNodeR(instance: *mut c_void, unnamed: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FacemarkLBF_Params_write_const_FileStorageR(instance: *const c_void, unnamed: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FacemarkLBF_Params_propShape_offset_const(instance: *const c_void) -> f64;
		pub fn cv_face_FacemarkLBF_Params_propShape_offset_const_double(instance: *mut c_void, val: f64);
		pub fn cv_face_FacemarkLBF_Params_propCascade_face_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkLBF_Params_propCascade_face_const_String(instance: *mut c_void, val: *const c_char);
		pub fn cv_face_FacemarkLBF_Params_propVerbose_const(instance: *const c_void) -> bool;
		pub fn cv_face_FacemarkLBF_Params_propVerbose_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_face_FacemarkLBF_Params_propN_landmarks_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkLBF_Params_propN_landmarks_const_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkLBF_Params_propInitShape_n_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkLBF_Params_propInitShape_n_const_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkLBF_Params_propStages_n_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkLBF_Params_propStages_n_const_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkLBF_Params_propTree_n_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkLBF_Params_propTree_n_const_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkLBF_Params_propTree_depth_const(instance: *const c_void) -> i32;
		pub fn cv_face_FacemarkLBF_Params_propTree_depth_const_int(instance: *mut c_void, val: i32);
		pub fn cv_face_FacemarkLBF_Params_propBagging_overlap_const(instance: *const c_void) -> f64;
		pub fn cv_face_FacemarkLBF_Params_propBagging_overlap_const_double(instance: *mut c_void, val: f64);
		pub fn cv_face_FacemarkLBF_Params_propModel_filename_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkLBF_Params_propModel_filename_const_string(instance: *mut c_void, val: *const c_char);
		pub fn cv_face_FacemarkLBF_Params_propSave_model_const(instance: *const c_void) -> bool;
		pub fn cv_face_FacemarkLBF_Params_propSave_model_const_bool(instance: *mut c_void, val: bool);
		pub fn cv_face_FacemarkLBF_Params_propSeed_const(instance: *const c_void) -> u32;
		pub fn cv_face_FacemarkLBF_Params_propSeed_const_unsigned_int(instance: *mut c_void, val: u32);
		pub fn cv_face_FacemarkLBF_Params_propFeats_m_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkLBF_Params_propFeats_m_const_vectorLintG(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkLBF_Params_propRadius_m_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_face_FacemarkLBF_Params_propRadius_m_const_vectorLdoubleG(instance: *mut c_void, val: *const c_void);
		pub fn cv_face_FacemarkLBF_Params_propDetectROI_const(instance: *const c_void, ocvrs_return: *mut core::Rect);
		pub fn cv_face_FacemarkLBF_Params_propDetectROI_const_Rect(instance: *mut c_void, val: *const core::Rect);
		pub fn cv_face_FacemarkLBF_Params_delete(instance: *mut c_void);
		pub fn cv_face_FacemarkTrain_addTrainingSample_const__InputArrayR_const__InputArrayR(instance: *mut c_void, image: *const c_void, landmarks: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_FacemarkTrain_training_voidX(instance: *mut c_void, parameters: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FacemarkTrain_training(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_FacemarkTrain_setFaceDetector_FN_FaceDetector_voidX(instance: *mut c_void, detector: Option<unsafe extern "C" fn(*const c_void, *const c_void, *mut c_void) -> bool>, user_data: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_FacemarkTrain_getFaces_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, faces: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_FacemarkTrain_getData_voidX(instance: *mut c_void, items: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_FacemarkTrain_getData(instance: *mut c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_FacemarkTrain_to_FacemarkAAM(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FacemarkTrain_to_FacemarkLBF(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FacemarkTrain_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FacemarkTrain_to_Facemark(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FacemarkTrain_delete(instance: *mut c_void);
		pub fn cv_face_FisherFaceRecognizer_create_int_double(num_components: i32, threshold: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_FisherFaceRecognizer_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_FisherFaceRecognizer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FisherFaceRecognizer_to_BasicFaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FisherFaceRecognizer_to_FaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_FisherFaceRecognizer_delete(instance: *mut c_void);
		pub fn cv_face_LBPHFaceRecognizer_getGridX_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_face_LBPHFaceRecognizer_setGridX_int(instance: *mut c_void, val: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_face_LBPHFaceRecognizer_getGridY_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_face_LBPHFaceRecognizer_setGridY_int(instance: *mut c_void, val: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_face_LBPHFaceRecognizer_getRadius_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_face_LBPHFaceRecognizer_setRadius_int(instance: *mut c_void, val: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_face_LBPHFaceRecognizer_getNeighbors_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_face_LBPHFaceRecognizer_setNeighbors_int(instance: *mut c_void, val: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_face_LBPHFaceRecognizer_getThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_face_LBPHFaceRecognizer_setThreshold_double(instance: *mut c_void, val: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_face_LBPHFaceRecognizer_getHistograms_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_LBPHFaceRecognizer_getLabels_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_LBPHFaceRecognizer_create_int_int_int_int_double(radius: i32, neighbors: i32, grid_x: i32, grid_y: i32, threshold: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_LBPHFaceRecognizer_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_LBPHFaceRecognizer_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_LBPHFaceRecognizer_to_FaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_LBPHFaceRecognizer_delete(instance: *mut c_void);
		pub fn cv_face_MACE_salt_const_StringR(instance: *mut c_void, passphrase: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_face_MACE_train_const__InputArrayR(instance: *mut c_void, images: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_face_MACE_same_const_const__InputArrayR(instance: *const c_void, query: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_MACE_load_const_StringR_const_StringR(filename: *const c_char, objname: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_MACE_load_const_StringR(filename: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_MACE_create_int(imgsize: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_MACE_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_MACE_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_MACE_delete(instance: *mut c_void);
		pub fn cv_face_PredictCollector_init_size_t(instance: *mut c_void, size: size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_face_PredictCollector_collect_int_double(instance: *mut c_void, label: i32, dist: f64, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_PredictCollector_to_StandardCollector(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_PredictCollector_delete(instance: *mut c_void);
		pub fn cv_face_StandardCollector_StandardCollector_double(threshold_: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_StandardCollector_StandardCollector(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_StandardCollector_init_size_t(instance: *mut c_void, size: size_t, ocvrs_return: *mut Result<()>);
		pub fn cv_face_StandardCollector_collect_int_double(instance: *mut c_void, label: i32, dist: f64, ocvrs_return: *mut Result<bool>);
		pub fn cv_face_StandardCollector_getMinLabel_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_face_StandardCollector_getMinDist_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_face_StandardCollector_getResults_const_bool(instance: *const c_void, sorted: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_StandardCollector_getResults_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_StandardCollector_create_double(threshold: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_StandardCollector_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_face_StandardCollector_to_PredictCollector(instance: *mut c_void) -> *mut c_void;
		pub fn cv_face_StandardCollector_delete(instance: *mut c_void);
		pub fn cv_face_StandardCollector_PredictResult_PredictResult_int_double(label_: i32, distance_: f64, ocvrs_return: *mut Result<crate::face::StandardCollector_PredictResult>);
		pub fn cv_face_StandardCollector_PredictResult_PredictResult(ocvrs_return: *mut Result<crate::face::StandardCollector_PredictResult>);
		pub fn cv_PtrLcv_face_BIFG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_BIFG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_BIFG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_face_BIFG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_face_BIFG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_BasicFaceRecognizerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_BasicFaceRecognizerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_BasicFaceRecognizerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_face_BasicFaceRecognizerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_face_BasicFaceRecognizerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_BasicFaceRecognizerG_to_PtrOfFaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_EigenFaceRecognizerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_EigenFaceRecognizerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_EigenFaceRecognizerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_face_EigenFaceRecognizerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_face_EigenFaceRecognizerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_EigenFaceRecognizerG_to_PtrOfBasicFaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_EigenFaceRecognizerG_to_PtrOfFaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FaceRecognizerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FaceRecognizerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FaceRecognizerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_face_FaceRecognizerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_face_FaceRecognizerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_face_FacemarkG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkAAMG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkAAMG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkAAMG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkAAMG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_face_FacemarkAAMG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkAAMG_to_PtrOfFacemark(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkAAMG_to_PtrOfFacemarkTrain(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkKazemiG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkKazemiG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkKazemiG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkKazemiG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_face_FacemarkKazemiG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkKazemiG_to_PtrOfFacemark(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkLBFG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkLBFG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkLBFG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkLBFG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_face_FacemarkLBFG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkLBFG_to_PtrOfFacemark(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkLBFG_to_PtrOfFacemarkTrain(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkTrainG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkTrainG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkTrainG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkTrainG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_face_FacemarkTrainG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FacemarkTrainG_to_PtrOfFacemark(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FisherFaceRecognizerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FisherFaceRecognizerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FisherFaceRecognizerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_face_FisherFaceRecognizerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_face_FisherFaceRecognizerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FisherFaceRecognizerG_to_PtrOfBasicFaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_FisherFaceRecognizerG_to_PtrOfFaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_LBPHFaceRecognizerG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_LBPHFaceRecognizerG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_LBPHFaceRecognizerG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_face_LBPHFaceRecognizerG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_face_LBPHFaceRecognizerG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_LBPHFaceRecognizerG_to_PtrOfFaceRecognizer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_MACEG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_MACEG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_MACEG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_face_MACEG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_face_MACEG_to_PtrOfAlgorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_PredictCollectorG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_PredictCollectorG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_PredictCollectorG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_face_PredictCollectorG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_face_StandardCollectorG_getInnerPtr_const(instance: *const c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_StandardCollectorG_getInnerPtrMut(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_StandardCollectorG_new_null_const() -> *mut c_void;
		pub fn cv_PtrLcv_face_StandardCollectorG_delete(instance: *mut c_void);
		pub fn cv_PtrLcv_face_StandardCollectorG_to_PtrOfPredictCollector(instance: *mut c_void) -> *mut c_void;
		pub fn cv_PtrLcv_face_StandardCollectorG_new_const_StandardCollector(val: *mut c_void) -> *mut c_void;
		pub fn std_vectorLcv_face_FacemarkAAM_ConfigG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_face_FacemarkAAM_ConfigG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_face_FacemarkAAM_ConfigG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_face_FacemarkAAM_ConfigG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_face_FacemarkAAM_ConfigG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_face_FacemarkAAM_ConfigG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_face_FacemarkAAM_ConfigG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_face_FacemarkAAM_ConfigG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_face_FacemarkAAM_ConfigG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_face_FacemarkAAM_ConfigG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_face_FacemarkAAM_ConfigG_push_const_Config(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLcv_face_FacemarkAAM_ConfigG_insert_size_t_const_Config(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_face_FacemarkAAM_ConfigG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLcv_face_FacemarkAAM_ConfigG_set_size_t_const_Config(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_face_FacemarkAAM_Model_TextureG_new_const() -> *mut c_void;
		pub fn std_vectorLcv_face_FacemarkAAM_Model_TextureG_delete(instance: *mut c_void);
		pub fn std_vectorLcv_face_FacemarkAAM_Model_TextureG_len_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_face_FacemarkAAM_Model_TextureG_isEmpty_const(instance: *const c_void) -> bool;
		pub fn std_vectorLcv_face_FacemarkAAM_Model_TextureG_capacity_const(instance: *const c_void) -> size_t;
		pub fn std_vectorLcv_face_FacemarkAAM_Model_TextureG_shrinkToFit(instance: *mut c_void);
		pub fn std_vectorLcv_face_FacemarkAAM_Model_TextureG_reserve_size_t(instance: *mut c_void, additional: size_t);
		pub fn std_vectorLcv_face_FacemarkAAM_Model_TextureG_remove_size_t(instance: *mut c_void, index: size_t);
		pub fn std_vectorLcv_face_FacemarkAAM_Model_TextureG_swap_size_t_size_t(instance: *mut c_void, index1: size_t, index2: size_t);
		pub fn std_vectorLcv_face_FacemarkAAM_Model_TextureG_clear(instance: *mut c_void);
		pub fn std_vectorLcv_face_FacemarkAAM_Model_TextureG_push_const_Texture(instance: *mut c_void, val: *const c_void);
		pub fn std_vectorLcv_face_FacemarkAAM_Model_TextureG_insert_size_t_const_Texture(instance: *mut c_void, index: size_t, val: *const c_void);
		pub fn std_vectorLcv_face_FacemarkAAM_Model_TextureG_get_const_size_t(instance: *const c_void, index: size_t, ocvrs_return: *mut *mut c_void);
		pub fn std_vectorLcv_face_FacemarkAAM_Model_TextureG_set_size_t_const_Texture(instance: *mut c_void, index: size_t, val: *const c_void);
	}
}
pub use face_sys::*;

mod features2d_sys {
	use super::*;

	unsafe extern "C" {
		pub fn cv_AGAST_const__InputArrayR_vectorLKeyPointGR_int(image: *const c_void, keypoints: *mut c_void, threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_AGAST_const__InputArrayR_vectorLKeyPointGR_int_bool(image: *const c_void, keypoints: *mut c_void, threshold: i32, nonmax_suppression: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_AGAST_const__InputArrayR_vectorLKeyPointGR_int_bool_DetectorType(image: *const c_void, keypoints: *mut c_void, threshold: i32, nonmax_suppression: bool, typ: crate::features2d::AgastFeatureDetector_DetectorType, ocvrs_return: *mut Result<()>);
		pub fn cv_FAST_const__InputArrayR_vectorLKeyPointGR_int(image: *const c_void, keypoints: *mut c_void, threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_FAST_const__InputArrayR_vectorLKeyPointGR_int_bool(image: *const c_void, keypoints: *mut c_void, threshold: i32, nonmax_suppression: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_FAST_const__InputArrayR_vectorLKeyPointGR_int_bool_DetectorType(image: *const c_void, keypoints: *mut c_void, threshold: i32, nonmax_suppression: bool, typ: crate::features2d::FastFeatureDetector_DetectorType, ocvrs_return: *mut Result<()>);
		pub fn cv_computeRecallPrecisionCurve_const_vectorLvectorLDMatchGGR_const_vectorLvectorLunsigned_charGGR_vectorLPoint2fGR(matches1to2: *const c_void, correct_matches1to2_mask: *const c_void, recall_precision_curve: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_drawKeypoints_const__InputArrayR_const_vectorLKeyPointGR_const__InputOutputArrayR(image: *const c_void, keypoints: *const c_void, out_image: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_drawKeypoints_const__InputArrayR_const_vectorLKeyPointGR_const__InputOutputArrayR_const_ScalarR_DrawMatchesFlags(image: *const c_void, keypoints: *const c_void, out_image: *const c_void, color: *const core::Scalar, flags: crate::features2d::DrawMatchesFlags, ocvrs_return: *mut Result<()>);
		pub fn cv_drawMatches_const__InputArrayR_const_vectorLKeyPointGR_const__InputArrayR_const_vectorLKeyPointGR_const_vectorLDMatchGR_const__InputOutputArrayR(img1: *const c_void, keypoints1: *const c_void, img2: *const c_void, keypoints2: *const c_void, matches1to2: *const c_void, out_img: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_drawMatches_const__InputArrayR_const_vectorLKeyPointGR_const__InputArrayR_const_vectorLKeyPointGR_const_vectorLDMatchGR_const__InputOutputArrayR_const_ScalarR_const_ScalarR_const_vectorLcharGR_DrawMatchesFlags(img1: *const c_void, keypoints1: *const c_void, img2: *const c_void, keypoints2: *const c_void, matches1to2: *const c_void, out_img: *const c_void, match_color: *const core::Scalar, single_point_color: *const core::Scalar, matches_mask: *const c_void, flags: crate::features2d::DrawMatchesFlags, ocvrs_return: *mut Result<()>);
		pub fn cv_drawMatches_const__InputArrayR_const_vectorLKeyPointGR_const__InputArrayR_const_vectorLKeyPointGR_const_vectorLDMatchGR_const__InputOutputArrayR_const_int(img1: *const c_void, keypoints1: *const c_void, img2: *const c_void, keypoints2: *const c_void, matches1to2: *const c_void, out_img: *const c_void, matches_thickness: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_drawMatches_const__InputArrayR_const_vectorLKeyPointGR_const__InputArrayR_const_vectorLKeyPointGR_const_vectorLDMatchGR_const__InputOutputArrayR_const_int_const_ScalarR_const_ScalarR_const_vectorLcharGR_DrawMatchesFlags(img1: *const c_void, keypoints1: *const c_void, img2: *const c_void, keypoints2: *const c_void, matches1to2: *const c_void, out_img: *const c_void, matches_thickness: i32, match_color: *const core::Scalar, single_point_color: *const core::Scalar, matches_mask: *const c_void, flags: crate::features2d::DrawMatchesFlags, ocvrs_return: *mut Result<()>);
		pub fn cv_drawMatches_const__InputArrayR_const_vectorLKeyPointGR_const__InputArrayR_const_vectorLKeyPointGR_const_vectorLvectorLDMatchGGR_const__InputOutputArrayR(img1: *const c_void, keypoints1: *const c_void, img2: *const c_void, keypoints2: *const c_void, matches1to2: *const c_void, out_img: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_drawMatches_const__InputArrayR_const_vectorLKeyPointGR_const__InputArrayR_const_vectorLKeyPointGR_const_vectorLvectorLDMatchGGR_const__InputOutputArrayR_const_ScalarR_const_ScalarR_const_vectorLvectorLcharGGR_DrawMatchesFlags(img1: *const c_void, keypoints1: *const c_void, img2: *const c_void, keypoints2: *const c_void, matches1to2: *const c_void, out_img: *const c_void, match_color: *const core::Scalar, single_point_color: *const core::Scalar, matches_mask: *const c_void, flags: crate::features2d::DrawMatchesFlags, ocvrs_return: *mut Result<()>);
		pub fn cv_evaluateFeatureDetector_const_MatR_const_MatR_const_MatR_vectorLKeyPointGX_vectorLKeyPointGX_floatR_intR(img1: *const c_void, img2: *const c_void, h1to2: *const c_void, keypoints1: *mut c_void, keypoints2: *mut c_void, repeatability: *mut f32, corresp_count: *mut i32, ocvrs_return: *mut Result<()>);
		pub fn cv_evaluateFeatureDetector_const_MatR_const_MatR_const_MatR_vectorLKeyPointGX_vectorLKeyPointGX_floatR_intR_const_PtrLFeature2DGR(img1: *const c_void, img2: *const c_void, h1to2: *const c_void, keypoints1: *mut c_void, keypoints2: *mut c_void, repeatability: *mut f32, corresp_count: *mut i32, fdetector: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_getNearestPoint_const_vectorLPoint2fGR_float(recall_precision_curve: *const c_void, l_precision: f32, ocvrs_return: *mut Result<i32>);
		pub fn cv_getRecall_const_vectorLPoint2fGR_float(recall_precision_curve: *const c_void, l_precision: f32, ocvrs_return: *mut Result<f32>);
		pub fn cv_AKAZE_create_DescriptorType_int_int_float_int_int_DiffusivityType_int(descriptor_type: crate::features2d::AKAZE_DescriptorType, descriptor_size: i32, descriptor_channels: i32, threshold: f32, n_octaves: i32, n_octave_layers: i32, diffusivity: crate::features2d::KAZE_DiffusivityType, max_points: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_AKAZE_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_AKAZE_setDescriptorType_DescriptorType(instance: *mut c_void, dtype: crate::features2d::AKAZE_DescriptorType, ocvrs_return: *mut Result<()>);
		pub fn cv_AKAZE_getDescriptorType_const(instance: *const c_void, ocvrs_return: *mut Result<crate::features2d::AKAZE_DescriptorType>);
		pub fn cv_AKAZE_setDescriptorSize_int(instance: *mut c_void, dsize: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_AKAZE_getDescriptorSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_AKAZE_setDescriptorChannels_int(instance: *mut c_void, dch: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_AKAZE_getDescriptorChannels_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_AKAZE_setThreshold_double(instance: *mut c_void, threshold: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_AKAZE_getThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_AKAZE_setNOctaves_int(instance: *mut c_void, octaves: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_AKAZE_getNOctaves_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_AKAZE_setNOctaveLayers_int(instance: *mut c_void, octave_layers: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_AKAZE_getNOctaveLayers_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_AKAZE_setDiffusivity_DiffusivityType(instance: *mut c_void, diff: crate::features2d::KAZE_DiffusivityType, ocvrs_return: *mut Result<()>);
		pub fn cv_AKAZE_getDiffusivity_const(instance: *const c_void, ocvrs_return: *mut Result<crate::features2d::KAZE_DiffusivityType>);
		pub fn cv_AKAZE_getDefaultName_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_AKAZE_setMaxPoints_int(instance: *mut c_void, max_points: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_AKAZE_getMaxPoints_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_AKAZE_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_AKAZE_to_Feature2D(instance: *mut c_void) -> *mut c_void;
		pub fn cv_AKAZE_delete(instance: *mut c_void);
		pub fn cv_AffineFeature_create_const_PtrLFeature2DGR_int_int_float_float(backend: *const c_void, max_tilt: i32, min_tilt: i32, tilt_step: f32, rotate_step_base: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_AffineFeature_create_const_PtrLFeature2DGR(backend: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_AffineFeature_setViewParams_const_vectorLfloatGR_const_vectorLfloatGR(instance: *mut c_void, tilts: *const c_void, rolls: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_AffineFeature_getViewParams_const_vectorLfloatGR_vectorLfloatGR(instance: *const c_void, tilts: *mut c_void, rolls: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_AffineFeature_getDefaultName_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_AffineFeature_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_AffineFeature_to_Feature2D(instance: *mut c_void) -> *mut c_void;
		pub fn cv_AffineFeature_delete(instance: *mut c_void);
		pub fn cv_AgastFeatureDetector_create_int_bool_DetectorType(threshold: i32, nonmax_suppression: bool, typ: crate::features2d::AgastFeatureDetector_DetectorType, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_AgastFeatureDetector_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_AgastFeatureDetector_setThreshold_int(instance: *mut c_void, threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_AgastFeatureDetector_getThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_AgastFeatureDetector_setNonmaxSuppression_bool(instance: *mut c_void, f: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_AgastFeatureDetector_getNonmaxSuppression_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_AgastFeatureDetector_setType_DetectorType(instance: *mut c_void, typ: crate::features2d::AgastFeatureDetector_DetectorType, ocvrs_return: *mut Result<()>);
		pub fn cv_AgastFeatureDetector_getType_const(instance: *const c_void, ocvrs_return: *mut Result<crate::features2d::AgastFeatureDetector_DetectorType>);
		pub fn cv_AgastFeatureDetector_getDefaultName_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_AgastFeatureDetector_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_AgastFeatureDetector_to_Feature2D(instance: *mut c_void) -> *mut c_void;
		pub fn cv_AgastFeatureDetector_delete(instance: *mut c_void);
		pub fn cv_BFMatcher_BFMatcher_int_bool(norm_type: i32, cross_check: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BFMatcher_BFMatcher(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BFMatcher_isMaskSupported_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_BFMatcher_create_int_bool(norm_type: i32, cross_check: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BFMatcher_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BFMatcher_clone_const_bool(instance: *const c_void, empty_train_data: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BFMatcher_clone_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BFMatcher_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_BFMatcher_to_DescriptorMatcher(instance: *mut c_void) -> *mut c_void;
		pub fn cv_BFMatcher_delete(instance: *mut c_void);
		pub fn cv_BOWImgDescriptorExtractor_BOWImgDescriptorExtractor_const_PtrLFeature2DGR_const_PtrLDescriptorMatcherGR(dextractor: *const c_void, dmatcher: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BOWImgDescriptorExtractor_BOWImgDescriptorExtractor_const_PtrLDescriptorMatcherGR(dmatcher: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BOWImgDescriptorExtractor_setVocabulary_const_MatR(instance: *mut c_void, vocabulary: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_BOWImgDescriptorExtractor_getVocabulary_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BOWImgDescriptorExtractor_compute_const__InputArrayR_vectorLKeyPointGR_const__OutputArrayR_vectorLvectorLintGGX_MatX(instance: *mut c_void, image: *const c_void, keypoints: *mut c_void, img_descriptor: *const c_void, point_idxs_of_clusters: *mut c_void, descriptors: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_BOWImgDescriptorExtractor_compute_const__InputArrayR_vectorLKeyPointGR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, keypoints: *mut c_void, img_descriptor: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_BOWImgDescriptorExtractor_compute_const__InputArrayR_const__OutputArrayR_vectorLvectorLintGGX(instance: *mut c_void, keypoint_descriptors: *const c_void, img_descriptor: *const c_void, point_idxs_of_clusters: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_BOWImgDescriptorExtractor_compute_const__InputArrayR_const__OutputArrayR(instance: *mut c_void, keypoint_descriptors: *const c_void, img_descriptor: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_BOWImgDescriptorExtractor_compute2_const_MatR_vectorLKeyPointGR_MatR(instance: *mut c_void, image: *const c_void, keypoints: *mut c_void, img_descriptor: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_BOWImgDescriptorExtractor_descriptorSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_BOWImgDescriptorExtractor_descriptorType_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_BOWImgDescriptorExtractor_delete(instance: *mut c_void);
		pub fn cv_BOWKMeansTrainer_BOWKMeansTrainer_int_const_TermCriteriaR_int_int(cluster_count: i32, termcrit: *const core::TermCriteria, attempts: i32, flags: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BOWKMeansTrainer_BOWKMeansTrainer_int(cluster_count: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BOWKMeansTrainer_cluster_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BOWKMeansTrainer_cluster_const_const_MatR(instance: *const c_void, descriptors: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BOWKMeansTrainer_to_BOWTrainer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_BOWKMeansTrainer_delete(instance: *mut c_void);
		pub fn cv_BOWTrainer_add_const_MatR(instance: *mut c_void, descriptors: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_BOWTrainer_getDescriptors_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BOWTrainer_descriptorsCount_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_BOWTrainer_clear(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_BOWTrainer_cluster_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BOWTrainer_cluster_const_const_MatR(instance: *const c_void, descriptors: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BOWTrainer_to_BOWKMeansTrainer(instance: *mut c_void) -> *mut c_void;
		pub fn cv_BOWTrainer_delete(instance: *mut c_void);
		pub fn cv_BRISK_create_int_int_float(thresh: i32, octaves: i32, pattern_scale: f32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BRISK_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BRISK_create_const_vectorLfloatGR_const_vectorLintGR_float_float_const_vectorLintGR(radius_list: *const c_void, number_list: *const c_void, d_max: f32, d_min: f32, index_change: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BRISK_create_const_vectorLfloatGR_const_vectorLintGR(radius_list: *const c_void, number_list: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BRISK_create_int_int_const_vectorLfloatGR_const_vectorLintGR_float_float_const_vectorLintGR(thresh: i32, octaves: i32, radius_list: *const c_void, number_list: *const c_void, d_max: f32, d_min: f32, index_change: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BRISK_create_int_int_const_vectorLfloatGR_const_vectorLintGR(thresh: i32, octaves: i32, radius_list: *const c_void, number_list: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BRISK_getDefaultName_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_BRISK_setThreshold_int(instance: *mut c_void, threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_BRISK_getThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_BRISK_setOctaves_int(instance: *mut c_void, octaves: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_BRISK_getOctaves_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_BRISK_setPatternScale_float(instance: *mut c_void, pattern_scale: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_BRISK_getPatternScale_const(instance: *const c_void, ocvrs_return: *mut Result<f32>);
		pub fn cv_BRISK_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_BRISK_to_Feature2D(instance: *mut c_void) -> *mut c_void;
		pub fn cv_BRISK_delete(instance: *mut c_void);
		pub fn cv_DescriptorMatcher_add_const__InputArrayR(instance: *mut c_void, descriptors: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_getTrainDescriptors_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_DescriptorMatcher_clear(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_DescriptorMatcher_isMaskSupported_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_DescriptorMatcher_train(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_match_const_const__InputArrayR_const__InputArrayR_vectorLDMatchGR_const__InputArrayR(instance: *const c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_match_const_const__InputArrayR_const__InputArrayR_vectorLDMatchGR(instance: *const c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_knnMatch_const_const__InputArrayR_const__InputArrayR_vectorLvectorLDMatchGGR_int_const__InputArrayR_bool(instance: *const c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, k: i32, mask: *const c_void, compact_result: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_knnMatch_const_const__InputArrayR_const__InputArrayR_vectorLvectorLDMatchGGR_int(instance: *const c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, k: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_radiusMatch_const_const__InputArrayR_const__InputArrayR_vectorLvectorLDMatchGGR_float_const__InputArrayR_bool(instance: *const c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, max_distance: f32, mask: *const c_void, compact_result: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_radiusMatch_const_const__InputArrayR_const__InputArrayR_vectorLvectorLDMatchGGR_float(instance: *const c_void, query_descriptors: *const c_void, train_descriptors: *const c_void, matches: *mut c_void, max_distance: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_match_const__InputArrayR_vectorLDMatchGR_const__InputArrayR(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, masks: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_match_const__InputArrayR_vectorLDMatchGR(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_knnMatch_const__InputArrayR_vectorLvectorLDMatchGGR_int_const__InputArrayR_bool(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, k: i32, masks: *const c_void, compact_result: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_knnMatch_const__InputArrayR_vectorLvectorLDMatchGGR_int(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, k: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_radiusMatch_const__InputArrayR_vectorLvectorLDMatchGGR_float_const__InputArrayR_bool(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, max_distance: f32, masks: *const c_void, compact_result: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_radiusMatch_const__InputArrayR_vectorLvectorLDMatchGGR_float(instance: *mut c_void, query_descriptors: *const c_void, matches: *mut c_void, max_distance: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_write_const_const_StringR(instance: *const c_void, file_name: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_read_const_StringR(instance: *mut c_void, file_name: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_read_const_FileNodeR(instance: *mut c_void, unnamed: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_write_const_FileStorageR(instance: *const c_void, unnamed: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_clone_const_bool(instance: *const c_void, empty_train_data: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_DescriptorMatcher_clone_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_DescriptorMatcher_create_const_StringR(descriptor_matcher_type: *const c_char, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_DescriptorMatcher_create_const_MatcherTypeR(matcher_type: crate::features2d::DescriptorMatcher_MatcherType, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_DescriptorMatcher_write_const_FileStorageR_const_StringR(instance: *const c_void, fs: *mut c_void, name: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_write_const_const_PtrLFileStorageGR_const_StringR(instance: *const c_void, fs: *const c_void, name: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_DescriptorMatcher_to_BFMatcher(instance: *mut c_void) -> *mut c_void;
		pub fn cv_DescriptorMatcher_to_FlannBasedMatcher(instance: *mut c_void) -> *mut c_void;
		pub fn cv_DescriptorMatcher_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_DescriptorMatcher_delete(instance: *mut c_void);
		pub fn cv_FastFeatureDetector_create_int_bool_DetectorType(threshold: i32, nonmax_suppression: bool, typ: crate::features2d::FastFeatureDetector_DetectorType, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FastFeatureDetector_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FastFeatureDetector_setThreshold_int(instance: *mut c_void, threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_FastFeatureDetector_getThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_FastFeatureDetector_setNonmaxSuppression_bool(instance: *mut c_void, f: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_FastFeatureDetector_getNonmaxSuppression_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_FastFeatureDetector_setType_DetectorType(instance: *mut c_void, typ: crate::features2d::FastFeatureDetector_DetectorType, ocvrs_return: *mut Result<()>);
		pub fn cv_FastFeatureDetector_getType_const(instance: *const c_void, ocvrs_return: *mut Result<crate::features2d::FastFeatureDetector_DetectorType>);
		pub fn cv_FastFeatureDetector_getDefaultName_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FastFeatureDetector_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_FastFeatureDetector_to_Feature2D(instance: *mut c_void) -> *mut c_void;
		pub fn cv_FastFeatureDetector_delete(instance: *mut c_void);
		pub fn cv_Feature2D_detect_const__InputArrayR_vectorLKeyPointGR_const__InputArrayR(instance: *mut c_void, image: *const c_void, keypoints: *mut c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Feature2D_detect_const__InputArrayR_vectorLKeyPointGR(instance: *mut c_void, image: *const c_void, keypoints: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Feature2D_detect_const__InputArrayR_vectorLvectorLKeyPointGGR_const__InputArrayR(instance: *mut c_void, images: *const c_void, keypoints: *mut c_void, masks: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Feature2D_detect_const__InputArrayR_vectorLvectorLKeyPointGGR(instance: *mut c_void, images: *const c_void, keypoints: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Feature2D_compute_const__InputArrayR_vectorLKeyPointGR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, keypoints: *mut c_void, descriptors: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Feature2D_compute_const__InputArrayR_vectorLvectorLKeyPointGGR_const__OutputArrayR(instance: *mut c_void, images: *const c_void, keypoints: *mut c_void, descriptors: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Feature2D_detectAndCompute_const__InputArrayR_const__InputArrayR_vectorLKeyPointGR_const__OutputArrayR_bool(instance: *mut c_void, image: *const c_void, mask: *const c_void, keypoints: *mut c_void, descriptors: *const c_void, use_provided_keypoints: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_Feature2D_detectAndCompute_const__InputArrayR_const__InputArrayR_vectorLKeyPointGR_const__OutputArrayR(instance: *mut c_void, image: *const c_void, mask: *const c_void, keypoints: *mut c_void, descriptors: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Feature2D_descriptorSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_Feature2D_descriptorType_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_Feature2D_defaultNorm_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_Feature2D_write_const_const_StringR(instance: *const c_void, file_name: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_Feature2D_read_const_StringR(instance: *mut c_void, file_name: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_Feature2D_write_const_FileStorageR(instance: *const c_void, unnamed: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Feature2D_read_const_FileNodeR(instance: *mut c_void, unnamed: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_Feature2D_empty_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_Feature2D_getDefaultName_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_Feature2D_write_const_FileStorageR_const_StringR(instance: *const c_void, fs: *mut c_void, name: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_Feature2D_write_const_const_PtrLFileStorageGR_const_StringR(instance: *const c_void, fs: *const c_void, name: *const c_char, ocvrs_return: *mut Result<()>);
		pub fn cv_Feature2D_defaultNew_const() -> *mut c_void;
		pub fn cv_Feature2D_to_AKAZE(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Feature2D_to_AffineFeature(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Feature2D_to_AgastFeatureDetector(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Feature2D_to_BRISK(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Feature2D_to_FastFeatureDetector(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Feature2D_to_GFTTDetector(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Feature2D_to_KAZE(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Feature2D_to_MSER(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Feature2D_to_ORB(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Feature2D_to_SIFT(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Feature2D_to_SimpleBlobDetector(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Feature2D_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_Feature2D_delete(instance: *mut c_void);
		pub fn cv_FlannBasedMatcher_FlannBasedMatcher_const_PtrLIndexParamsGR_const_PtrLSearchParamsGR(index_params: *const c_void, search_params: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FlannBasedMatcher_FlannBasedMatcher(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FlannBasedMatcher_add_const__InputArrayR(instance: *mut c_void, descriptors: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_FlannBasedMatcher_clear(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_FlannBasedMatcher_read_const_FileNodeR(instance: *mut c_void, unnamed: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_FlannBasedMatcher_write_const_FileStorageR(instance: *const c_void, unnamed: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_FlannBasedMatcher_train(instance: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_FlannBasedMatcher_isMaskSupported_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_FlannBasedMatcher_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FlannBasedMatcher_clone_const_bool(instance: *const c_void, empty_train_data: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FlannBasedMatcher_clone_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_FlannBasedMatcher_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_FlannBasedMatcher_to_DescriptorMatcher(instance: *mut c_void) -> *mut c_void;
		pub fn cv_FlannBasedMatcher_delete(instance: *mut c_void);
		pub fn cv_GFTTDetector_create_int_double_double_int_bool_double(max_corners: i32, quality_level: f64, min_distance: f64, block_size: i32, use_harris_detector: bool, k: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_GFTTDetector_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_GFTTDetector_create_int_double_double_int_int_bool_double(max_corners: i32, quality_level: f64, min_distance: f64, block_size: i32, gradient_size: i32, use_harris_detector: bool, k: f64, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_GFTTDetector_create_int_double_double_int_int(max_corners: i32, quality_level: f64, min_distance: f64, block_size: i32, gradient_size: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_GFTTDetector_setMaxFeatures_int(instance: *mut c_void, max_features: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_GFTTDetector_getMaxFeatures_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_GFTTDetector_setQualityLevel_double(instance: *mut c_void, qlevel: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_GFTTDetector_getQualityLevel_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_GFTTDetector_setMinDistance_double(instance: *mut c_void, min_distance: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_GFTTDetector_getMinDistance_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_GFTTDetector_setBlockSize_int(instance: *mut c_void, block_size: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_GFTTDetector_getBlockSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_GFTTDetector_setGradientSize_int(instance: *mut c_void, gradient_size_: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_GFTTDetector_getGradientSize(instance: *mut c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_GFTTDetector_setHarrisDetector_bool(instance: *mut c_void, val: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_GFTTDetector_getHarrisDetector_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_GFTTDetector_setK_double(instance: *mut c_void, k: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_GFTTDetector_getK_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_GFTTDetector_getDefaultName_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_GFTTDetector_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_GFTTDetector_to_Feature2D(instance: *mut c_void) -> *mut c_void;
		pub fn cv_GFTTDetector_delete(instance: *mut c_void);
		pub fn cv_KAZE_create_bool_bool_float_int_int_DiffusivityType(extended: bool, upright: bool, threshold: f32, n_octaves: i32, n_octave_layers: i32, diffusivity: crate::features2d::KAZE_DiffusivityType, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_KAZE_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_KAZE_setExtended_bool(instance: *mut c_void, extended: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_KAZE_getExtended_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_KAZE_setUpright_bool(instance: *mut c_void, upright: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_KAZE_getUpright_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_KAZE_setThreshold_double(instance: *mut c_void, threshold: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_KAZE_getThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_KAZE_setNOctaves_int(instance: *mut c_void, octaves: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_KAZE_getNOctaves_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_KAZE_setNOctaveLayers_int(instance: *mut c_void, octave_layers: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_KAZE_getNOctaveLayers_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_KAZE_setDiffusivity_DiffusivityType(instance: *mut c_void, diff: crate::features2d::KAZE_DiffusivityType, ocvrs_return: *mut Result<()>);
		pub fn cv_KAZE_getDiffusivity_const(instance: *const c_void, ocvrs_return: *mut Result<crate::features2d::KAZE_DiffusivityType>);
		pub fn cv_KAZE_getDefaultName_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_KAZE_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_KAZE_to_Feature2D(instance: *mut c_void) -> *mut c_void;
		pub fn cv_KAZE_delete(instance: *mut c_void);
		pub fn cv_KeyPointsFilter_KeyPointsFilter(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_KeyPointsFilter_runByImageBorder_vectorLKeyPointGR_Size_int(keypoints: *mut c_void, image_size: *const core::Size, border_size: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_KeyPointsFilter_runByKeypointSize_vectorLKeyPointGR_float_float(keypoints: *mut c_void, min_size: f32, max_size: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_KeyPointsFilter_runByKeypointSize_vectorLKeyPointGR_float(keypoints: *mut c_void, min_size: f32, ocvrs_return: *mut Result<()>);
		pub fn cv_KeyPointsFilter_runByPixelsMask_vectorLKeyPointGR_const_MatR(keypoints: *mut c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_KeyPointsFilter_runByPixelsMask2VectorPoint_vectorLKeyPointGR_vectorLvectorLPointGGR_const_MatR(keypoints: *mut c_void, remove_from: *mut c_void, mask: *const c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_KeyPointsFilter_removeDuplicated_vectorLKeyPointGR(keypoints: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_KeyPointsFilter_removeDuplicatedSorted_vectorLKeyPointGR(keypoints: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_KeyPointsFilter_retainBest_vectorLKeyPointGR_int(keypoints: *mut c_void, npoints: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_KeyPointsFilter_delete(instance: *mut c_void);
		pub fn cv_MSER_create_int_int_int_double_double_int_double_double_int(delta: i32, min_area: i32, max_area: i32, max_variation: f64, min_diversity: f64, max_evolution: i32, area_threshold: f64, min_margin: f64, edge_blur_size: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MSER_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MSER_detectRegions_const__InputArrayR_vectorLvectorLPointGGR_vectorLRectGR(instance: *mut c_void, image: *const c_void, msers: *mut c_void, bboxes: *mut c_void, ocvrs_return: *mut Result<()>);
		pub fn cv_MSER_setDelta_int(instance: *mut c_void, delta: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_MSER_getDelta_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_MSER_setMinArea_int(instance: *mut c_void, min_area: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_MSER_getMinArea_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_MSER_setMaxArea_int(instance: *mut c_void, max_area: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_MSER_getMaxArea_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_MSER_setMaxVariation_double(instance: *mut c_void, max_variation: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_MSER_getMaxVariation_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_MSER_setMinDiversity_double(instance: *mut c_void, min_diversity: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_MSER_getMinDiversity_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_MSER_setMaxEvolution_int(instance: *mut c_void, max_evolution: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_MSER_getMaxEvolution_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_MSER_setAreaThreshold_double(instance: *mut c_void, area_threshold: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_MSER_getAreaThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_MSER_setMinMargin_double(instance: *mut c_void, min_margin: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_MSER_getMinMargin_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_MSER_setEdgeBlurSize_int(instance: *mut c_void, edge_blur_size: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_MSER_getEdgeBlurSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_MSER_setPass2Only_bool(instance: *mut c_void, f: bool, ocvrs_return: *mut Result<()>);
		pub fn cv_MSER_getPass2Only_const(instance: *const c_void, ocvrs_return: *mut Result<bool>);
		pub fn cv_MSER_getDefaultName_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_MSER_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_MSER_to_Feature2D(instance: *mut c_void) -> *mut c_void;
		pub fn cv_MSER_delete(instance: *mut c_void);
		pub fn cv_ORB_create_int_float_int_int_int_int_ScoreType_int_int(nfeatures: i32, scale_factor: f32, nlevels: i32, edge_threshold: i32, first_level: i32, wta_k: i32, score_type: crate::features2d::ORB_ScoreType, patch_size: i32, fast_threshold: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ORB_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ORB_setMaxFeatures_int(instance: *mut c_void, max_features: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_ORB_getMaxFeatures_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ORB_setScaleFactor_double(instance: *mut c_void, scale_factor: f64, ocvrs_return: *mut Result<()>);
		pub fn cv_ORB_getScaleFactor_const(instance: *const c_void, ocvrs_return: *mut Result<f64>);
		pub fn cv_ORB_setNLevels_int(instance: *mut c_void, nlevels: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_ORB_getNLevels_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ORB_setEdgeThreshold_int(instance: *mut c_void, edge_threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_ORB_getEdgeThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ORB_setFirstLevel_int(instance: *mut c_void, first_level: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_ORB_getFirstLevel_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ORB_setWTA_K_int(instance: *mut c_void, wta_k: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_ORB_getWTA_K_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ORB_setScoreType_ScoreType(instance: *mut c_void, score_type: crate::features2d::ORB_ScoreType, ocvrs_return: *mut Result<()>);
		pub fn cv_ORB_getScoreType_const(instance: *const c_void, ocvrs_return: *mut Result<crate::features2d::ORB_ScoreType>);
		pub fn cv_ORB_setPatchSize_int(instance: *mut c_void, patch_size: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_ORB_getPatchSize_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ORB_setFastThreshold_int(instance: *mut c_void, fast_threshold: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_ORB_getFastThreshold_const(instance: *const c_void, ocvrs_return: *mut Result<i32>);
		pub fn cv_ORB_getDefaultName_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_ORB_to_Algorithm(instance: *mut c_void) -> *mut c_void;
		pub fn cv_ORB_to_Feature2D(instance: *mut c_void) -> *mut c_void;
		pub fn cv_ORB_delete(instance: *mut c_void);
		pub fn cv_SIFT_create_int_int_double_double_double_bool(nfeatures: i32, n_octave_layers: i32, contrast_threshold: f64, edge_threshold: f64, sigma: f64, enable_precise_upscale: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SIFT_create(ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SIFT_create_int_int_double_double_double_int_bool(nfeatures: i32, n_octave_layers: i32, contrast_threshold: f64, edge_threshold: f64, sigma: f64, descriptor_type: i32, enable_precise_upscale: bool, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SIFT_create_int_int_double_double_double_int(nfeatures: i32, n_octave_layers: i32, contrast_threshold: f64, edge_threshold: f64, sigma: f64, descriptor_type: i32, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SIFT_getDefaultName_const(instance: *const c_void, ocvrs_return: *mut Result<*mut c_void>);
		pub fn cv_SIFT_setNFeatures_int(instance: *mut c_void, max_features: i32, ocvrs_return: *mut Result<()>);
		pub fn cv_SIFT_getNFeatures_const(instance: *const c_void, ocvrs_ret