#include <stdio.h>
#include <string.h>
#include "vars.h"

#define MAX 1024

/***********************************************
 ******* SIMPLE COMPARE URLS FOR SORT **********/
int cmp_urls(const void *arg1, const void *arg2)
{
  char *s1,*s2;
  s1=*(char **)arg1;
  s2=*(char **)arg2;

  while (1)
  {

   if (*s1==0 && *s2==0)
      {
       #ifdef DEBUG_URLS_CMP
       fprintf (stderr,"cmp: %s == %s \n",*(char **)arg1,*(char **)arg2);
       #endif
       return (0);
      }
   if (*s1==*s2) {s1++;s2++;continue;}
   if (*s1<*s2)
     {
      #ifdef DEBUG_URLS_CMP
      fprintf (stderr,"cmp: %s < %s \n",*(char **)arg1,*(char **)arg2);
      #endif
      return(-1);
     }
   else
     {
      #ifdef DEBUG_URLS_CMP
      fprintf (stderr,"cmp: %s > %s \n",*(char **)arg1,*(char **)arg2);
      #endif
      return (1);
     }
  }
}


/********************************************
 ******* COMPARE FINISHED IN  0x1 ***********/

int cmp_urls_bs(const void *arg1, const void *arg2)
{
  char *s1,*s2;
  s1=(char *)arg1;
  s2=*(char **)arg2;


//  printf ("cmp: %s ? %s \n",(char *)arg1,*(char**)arg2); 
  
  while (1)
  {

   if (*s1==0 && (*s2==0 || *s2==1))
      {
       #ifdef DEBUG_URLS_CMP 
       fprintf (stderr,"cmp: %s == %s \n",(char *)arg1,*(char **)arg2); 
       #endif
       return (0);
      }
   if (*s1==*s2) {s1++;s2++;continue;}
   if (*s1<*s2) 
     {
      #ifdef DEBUG_URLS_CMP 
      fprintf (stderr,"cmp: %s < %s \n",(char *)arg1,*(char **)arg2);
      #endif
      return(-1);
     }
   else 
     {
      #ifdef DEBUG_URLS_CMP 
      fprintf (stderr,"cmp: %s > %s \n",(char *)arg1,*(char **)arg2);
      #endif
      return (1);
     }
  }
}

/********************************
 ******* COMPARE PORT ***********/

int cmp_urls_port(const void *arg1, const void *arg2)
{
  char *s1,*s2;
  s1=(char *)arg1;
  s2=(char *)arg2;

//  printf ("cmp port: %s ? %s \n",(char *)arg1,(char*)arg2); 
  
  while (1)
  {

   if (*s1==0 && (*s2==0 || *s2==1))
      {
       #ifdef DEBUG_URLS_CMP 
       fprintf (stderr,"cmp: %s == %s \n",(char *)arg1,(char *)arg2); 
       #endif
       return (0);
      }
   if (*s1==*s2) {s1++;s2++;continue;}
   if (*s1<*s2) 
     {
      #ifdef DEBUG_URLS_CMP 
      fprintf (stderr,"cmp: %s < %s \n",(char *)arg1,(char *)arg2);
      #endif
      return(-1);
     }
   else 
     {
      #ifdef DEBUG_URLS_CMP 
      fprintf (stderr,"cmp: %s > %s \n",(char *)arg1,(char *)arg2);
      #endif
      return (1);
     }
  }
}

/********************************************
 *********** COMPARE SUBDOMEN ***************/
int cmp_urls_sub(const void *arg1, const void *arg2)
{
  char *s1,*s2,*e1,*e2;
  s1=(char *)arg1;
  s2=(char *)arg2;
  e1=strchr(s1,0)-1;
  e2=strchr(s2,1)-1;

//  printf ("cmp: %s ? %s\n", (char *)arg1, (char *)arg2); 

  while (1)
  {
//  printf("%c ? %c\n",*e1,*e2);

   if ((e1==s1-1 || *e1=='.') && (e2==s2-1))
      {
       #ifdef DEBUG_URLS_CMP 
       fprintf (stderr,"cmp: %s == %s \n",(char *)arg1,(char *)arg2); 
       #endif
       return (0);
      }

   if (e1==s1-1 && e2!=s2-1)
     {
      #ifdef DEBUG_URLS_CMP 
      fprintf (stderr,"cmp: %s < %s (first string ended)\n",(char *)arg1,(char *)arg2);
      #endif
      return(-1);
     }

   if (e1!=s1-1 && e2==s2-1)
     {
      #ifdef DEBUG_URLS_CMP 
      fprintf (stderr,"cmp: %s > %s (second string ended)\n",(char *)arg1,(char *)arg2);
      #endif
      return(1);
     }

   if (*e1==*e2) {e1--;e2--;continue;}
   if (*e1<*e2) 
     {
      #ifdef DEBUG_URLS_CMP 
      fprintf (stderr,"cmp: %s < %s \n",(char *)arg1,(char *)arg2);
      #endif
      return(-1);
     }
   else 
     {
      #ifdef DEBUG_URLS_CMP 
      fprintf (stderr,"cmp: %s > %s \n",(char *)arg1,(char *)arg2);
      #endif
      return (1);
     }
  return(0);
  }
}

/********************************************
 ************* COMPARE DIRS *****************/
       
int cmp_urls_dirs(const void *arg1, const void *arg2)
{
  char *s1,*s2;
  s1=(char *)arg1;
  s2=(char *)arg2;

//  printf ("cmp dirs: %s ? %s \n",(char *)arg1,(char *)arg2); 
  
  while (1)
  {

   if ((*s1==0 || *s1=='/' || *s1=='?') && (*s2==0 || *s2==1))
      {
       #ifdef DEBUG_URLS_CMP 
       fprintf (stderr,"cmp: %s == %s \n",(char *)arg1,(char *)arg2); 
       #endif
       return (0);
      }
   if (*s1==*s2) {s1++;s2++;continue;}
   if (*s1<*s2) 
     {
      #ifdef DEBUG_URLS_CMP 
      fprintf (stderr,"cmp: %s < %s \n",(char *)arg1,(char *)arg2);
      #endif
      return(-1);
     }
   else 
     {
      #ifdef DEBUG_URLS_CMP 
      fprintf (stderr,"cmp: %s > %s \n",(char *)arg1,(char *)arg2);
      #endif
      return (1);
     }
  }
}
